(window.webpackJsonp=window.webpackJsonp||[]).push([[165],{1290:function(e,n){e.exports={attributes:{title:"Transformers",description:"The ArgillaTransformersTrainer leverages the features of transformers to train programmatically with Argilla.",links:[{linkText:"Argilla docs",linkLink:"https://docs.argilla.io/en/latest/guides/train_a_model.html"},{linkText:"Transformers docs",linkLink:"https://huggingface.co/docs/transformers/training"}]},html:'<p><em>code snippet</em></p>\n<pre><code class="language-python">from argilla.training import ArgillaTrainer\n\ntrainer = ArgillaTrainer(\n    name=&quot;&lt;my_dataset_name&gt;&quot;,\n    workspace=&quot;&lt;my_workspace_name&gt;&quot;,\n    framework=&quot;transformers&quot;,\n    train_size=0.8\n)\ntrainer.update_config(num_train_epochs=10)\ntrainer.train(output_dir=&quot;text-classification&quot;)\nrecords = trainer.predict(&quot;The ArgillaTrainer is great!&quot;, as_argilla_records=True)\n</code></pre>\n<p><em>update training config</em></p>\n<pre><code class="language-python"># `transformers.AutoModelForTextClassification`\ntrainer.update_config(\n    pretrained_model_name_or_path = &quot;distilbert-base-uncased&quot;\n    force_download = False\n    resume_download = False\n    proxies = None\n    token = None\n    cache_dir = None\n    local_files_only = False\n)\n# `transformers.TrainingArguments`\ntrainer.update_config(\n    per_device_train_batch_size = 8,\n    per_device_eval_batch_size = 8,\n    gradient_accumulation_steps = 1,\n    learning_rate = 5e-5,\n    weight_decay = 0,\n    adam_beta1 = 0.9,\n    adam_beta2 = 0.9,\n    adam_epsilon = 1e-8,\n    max_grad_norm = 1,\n    learning_rate = 5e-5,\n    num_train_epochs = 3,\n    max_steps = 0,\n    log_level = &quot;passive&quot;,\n    logging_strategy = &quot;steps&quot;,\n    save_strategy = &quot;steps&quot;,\n    save_steps = 500,\n    seed = 42,\n    push_to_hub = False,\n    hub_model_id = &quot;user_name/output_dir_name&quot;,\n    hub_strategy = &quot;every_save&quot;,\n    hub_token = &quot;1234&quot;,\n    hub_private_repo = False\n)\n</code></pre>\n'}}}]);