from ..core.tools import format_color
import seaborn as sns

# TODO: Add formulas to compute palettes
# TODO: Add a grey scale palette

_colors_categories_10 = {
    1: [(0.2980392156862745, 0.4470588235294118, 0.6901960784313725)],
    2: [(0.2980392156862745, 0.4470588235294118, 0.6901960784313725), (0.8666666666666667, 0.5176470588235295, 0.3215686274509804)],
    3: [(0.2980392156862745, 0.4470588235294118, 0.6901960784313725), (0.8666666666666667, 0.5176470588235295, 0.3215686274509804), (0.3333333333333333, 0.6588235294117647, 0.40784313725490196)],
    4: [(0.2980392156862745, 0.4470588235294118, 0.6901960784313725), (0.8666666666666667, 0.5176470588235295, 0.3215686274509804), (0.3333333333333333, 0.6588235294117647, 0.40784313725490196), (0.7686274509803922, 0.3058823529411765, 0.3215686274509804)],
    5: [(0.2980392156862745, 0.4470588235294118, 0.6901960784313725), (0.8666666666666667, 0.5176470588235295, 0.3215686274509804), (0.3333333333333333, 0.6588235294117647, 0.40784313725490196), (0.7686274509803922, 0.3058823529411765, 0.3215686274509804), (0.5058823529411764, 0.4470588235294118, 0.7019607843137254)],
    6: [(0.2980392156862745, 0.4470588235294118, 0.6901960784313725), (0.8666666666666667, 0.5176470588235295, 0.3215686274509804), (0.3333333333333333, 0.6588235294117647, 0.40784313725490196), (0.7686274509803922, 0.3058823529411765, 0.3215686274509804), (0.5058823529411764, 0.4470588235294118, 0.7019607843137254), (0.5764705882352941, 0.47058823529411764, 0.3764705882352941)],
    7: [(0.2980392156862745, 0.4470588235294118, 0.6901960784313725), (0.8666666666666667, 0.5176470588235295, 0.3215686274509804), (0.3333333333333333, 0.6588235294117647, 0.40784313725490196), (0.7686274509803922, 0.3058823529411765, 0.3215686274509804), (0.5058823529411764, 0.4470588235294118, 0.7019607843137254), (0.5764705882352941, 0.47058823529411764, 0.3764705882352941), (0.8549019607843137, 0.5450980392156862, 0.7647058823529411)],
    8: [(0.2980392156862745, 0.4470588235294118, 0.6901960784313725), (0.8666666666666667, 0.5176470588235295, 0.3215686274509804), (0.3333333333333333, 0.6588235294117647, 0.40784313725490196), (0.7686274509803922, 0.3058823529411765, 0.3215686274509804), (0.5058823529411764, 0.4470588235294118, 0.7019607843137254), (0.5764705882352941, 0.47058823529411764, 0.3764705882352941), (0.8549019607843137, 0.5450980392156862, 0.7647058823529411), (0.5490196078431373, 0.5490196078431373, 0.5490196078431373)],
    9: [(0.2980392156862745, 0.4470588235294118, 0.6901960784313725), (0.8666666666666667, 0.5176470588235295, 0.3215686274509804), (0.3333333333333333, 0.6588235294117647, 0.40784313725490196), (0.7686274509803922, 0.3058823529411765, 0.3215686274509804), (0.5058823529411764, 0.4470588235294118, 0.7019607843137254), (0.5764705882352941, 0.47058823529411764, 0.3764705882352941), (0.8549019607843137, 0.5450980392156862, 0.7647058823529411), (0.5490196078431373, 0.5490196078431373, 0.5490196078431373), (0.8, 0.7254901960784313, 0.4549019607843137)],
    10: [(0.2980392156862745, 0.4470588235294118, 0.6901960784313725), (0.8666666666666667, 0.5176470588235295, 0.3215686274509804), (0.3333333333333333, 0.6588235294117647, 0.40784313725490196), (0.7686274509803922, 0.3058823529411765, 0.3215686274509804), (0.5058823529411764, 0.4470588235294118, 0.7019607843137254), (0.5764705882352941, 0.47058823529411764, 0.3764705882352941), (0.8549019607843137, 0.5450980392156862, 0.7647058823529411), (0.5490196078431373, 0.5490196078431373, 0.5490196078431373), (0.8, 0.7254901960784313, 0.4549019607843137), (0.39215686274509803, 0.7098039215686275, 0.803921568627451)]
}

_color_categories_256 = {
    1: [(0.8, 0.3999999999999999, 0.3999999999999999)],
    2: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.3999999999999999, 0.8, 0.8)],
    3: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.4000000000000002, 0.8)],
    4: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8)],
    5: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.5599999999999996, 0.8), (0.72, 0.3999999999999999, 0.8)],
    6: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8)],
    7: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.6285714285714286, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7428571428571424)],
    8: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.6999999999999997)],
    9: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.6666666666666665)],
    10: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.4800000000000002, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.6399999999999999)],
    11: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.6181818181818177)],
    12: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.5999999999999996), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.6000000000000001, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.6000000000000001)],
    13: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.7076923076923081), (0.3999999999999999, 0.7076923076923074, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.46153846153846123, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.5846153846153842)],
    14: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.685714285714286, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.6857142857142853, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.5714285714285716)],
    15: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.7200000000000002, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.5599999999999996)],
    16: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.5499999999999999, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.7500000000000001, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.45, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.65), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.6499999999999999, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.44999999999999973, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.7499999999999998, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.5499999999999997)],
    17: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.5411764705882353, 0.3999999999999999), (0.8, 0.6823529411764706, 0.3999999999999999), (0.7764705882352942, 0.8, 0.3999999999999999), (0.6352941176470588, 0.8, 0.3999999999999999), (0.4941176470588234, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.44705882352941195), (0.3999999999999999, 0.8, 0.5882352941176467), (0.3999999999999999, 0.8, 0.7294117647058826), (0.3999999999999999, 0.7294117647058825, 0.8), (0.3999999999999999, 0.5882352941176466, 0.8), (0.3999999999999999, 0.4470588235294118, 0.8), (0.49411764705882316, 0.3999999999999999, 0.8), (0.6352941176470586, 0.3999999999999999, 0.8), (0.7764705882352938, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.6823529411764704), (0.8, 0.3999999999999999, 0.541176470588235)],
    18: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.5333333333333333, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.5333333333333337, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.5333333333333332), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.5333333333333331, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.5333333333333333, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.5333333333333331)],
    19: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.5263157894736841, 0.3999999999999999), (0.8, 0.6526315789473681, 0.3999999999999999), (0.8, 0.7789473684210528, 0.3999999999999999), (0.6947368421052633, 0.8, 0.3999999999999999), (0.5684210526315792, 0.8, 0.3999999999999999), (0.4421052631578945, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.48421052631578954), (0.3999999999999999, 0.8, 0.6105263157894737), (0.3999999999999999, 0.8, 0.7368421052631577), (0.3999999999999999, 0.7368421052631582, 0.8), (0.3999999999999999, 0.6105263157894735, 0.8), (0.3999999999999999, 0.4842105263157894, 0.8), (0.4421052631578943, 0.3999999999999999, 0.8), (0.5684210526315789, 0.3999999999999999, 0.8), (0.6947368421052631, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7789473684210526), (0.8, 0.3999999999999999, 0.6526315789473685), (0.8, 0.3999999999999999, 0.5263157894736843)],
    20: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.52, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.7599999999999998, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.44000000000000017), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.6799999999999999), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.6799999999999998, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.44000000000000006, 0.8), (0.4800000000000002, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7599999999999996), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.5199999999999992)],
    21: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.5142857142857143, 0.3999999999999999), (0.8, 0.6285714285714288, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.742857142857143, 0.8, 0.3999999999999999), (0.6285714285714286, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.5142857142857142), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.7428571428571431), (0.3999999999999999, 0.742857142857143, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.5142857142857141, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.6285714285714283, 0.3999999999999999, 0.8), (0.7428571428571427, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.6285714285714286), (0.8, 0.3999999999999999, 0.5142857142857141)],
    22: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.5090909090909089, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.7272727272727271, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.6545454545454545, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.4363636363636365, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.581818181818182), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.5818181818181819, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.43636363636363623, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.6545454545454543, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7272727272727267), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.5090909090909087)],
    23: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.5043478260869564, 0.3999999999999999), (0.8, 0.6086956521739129, 0.3999999999999999), (0.8, 0.7130434782608694, 0.3999999999999999), (0.7826086956521743, 0.8, 0.3999999999999999), (0.6782608695652173, 0.8, 0.3999999999999999), (0.5739130434782608, 0.8, 0.3999999999999999), (0.4695652173913043, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4347826086956521), (0.3999999999999999, 0.8, 0.5391304347826086), (0.3999999999999999, 0.8, 0.643478260869565), (0.3999999999999999, 0.8, 0.7478260869565216), (0.3999999999999999, 0.7478260869565214, 0.8), (0.3999999999999999, 0.6434782608695655, 0.8), (0.3999999999999999, 0.5391304347826085, 0.8), (0.3999999999999999, 0.434782608695652, 0.8), (0.4695652173913041, 0.3999999999999999, 0.8), (0.5739130434782606, 0.3999999999999999, 0.8), (0.678260869565217, 0.3999999999999999, 0.8), (0.7826086956521741, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7130434782608697), (0.8, 0.3999999999999999, 0.6086956521739126), (0.8, 0.3999999999999999, 0.5043478260869562)],
    24: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.5000000000000001, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7000000000000003, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5000000000000004, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5999999999999996), (0.3999999999999999, 0.8, 0.7), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7000000000000003, 0.8), (0.3999999999999999, 0.6000000000000001, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4999999999999996, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6999999999999995, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.49999999999999983)],
    25: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.49600000000000005, 0.3999999999999999), (0.8, 0.5920000000000002, 0.3999999999999999), (0.8, 0.6880000000000003, 0.3999999999999999), (0.8, 0.7839999999999998, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6240000000000001, 0.8, 0.3999999999999999), (0.528, 0.8, 0.3999999999999999), (0.4319999999999999, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4639999999999997), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.6559999999999999), (0.3999999999999999, 0.8, 0.752), (0.3999999999999999, 0.7519999999999999, 0.8), (0.3999999999999999, 0.6559999999999998, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.4639999999999995, 0.8), (0.4320000000000001, 0.3999999999999999, 0.8), (0.5279999999999997, 0.3999999999999999, 0.8), (0.6239999999999999, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.784), (0.8, 0.3999999999999999, 0.688), (0.8, 0.3999999999999999, 0.5919999999999999), (0.8, 0.3999999999999999, 0.4959999999999998)],
    26: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.49230769230769245, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.676923076923077, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.7384615384615386, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.5538461538461541, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.43076923076923096), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.6153846153846155), (0.3999999999999999, 0.8, 0.7076923076923081), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7076923076923074, 0.8), (0.3999999999999999, 0.6153846153846149, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.43076923076923085, 0.8), (0.46153846153846123, 0.3999999999999999, 0.8), (0.5538461538461538, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.7384615384615383, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.6769230769230767), (0.8, 0.3999999999999999, 0.5846153846153842), (0.8, 0.3999999999999999, 0.49230769230769167)],
    27: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4888888888888887, 0.3999999999999999), (0.8, 0.5777777777777775, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.7555555555555555, 0.3999999999999999), (0.7555555555555558, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.5777777777777777, 0.8, 0.3999999999999999), (0.48888888888888893, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.48888888888888854), (0.3999999999999999, 0.8, 0.5777777777777778), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.7555555555555554), (0.3999999999999999, 0.7555555555555553, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.5777777777777777, 0.8), (0.3999999999999999, 0.48888888888888893, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4888888888888887, 0.3999999999999999, 0.8), (0.5777777777777775, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.7555555555555555, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7555555555555553), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.5777777777777777), (0.8, 0.3999999999999999, 0.48888888888888893)],
    28: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4857142857142859, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.6571428571428573, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.7714285714285715, 0.8, 0.3999999999999999), (0.685714285714286, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.42857142857142866, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.5428571428571427), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.7142857142857142), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7142857142857145, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.5428571428571426, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.4285714285714278, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6857142857142853, 0.3999999999999999, 0.8), (0.7714285714285712, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.657142857142857), (0.8, 0.3999999999999999, 0.5714285714285716), (0.8, 0.3999999999999999, 0.4857142857142856)],
    29: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.48275862068965525, 0.3999999999999999), (0.8, 0.5655172413793101, 0.3999999999999999), (0.8, 0.6482758620689655, 0.3999999999999999), (0.8, 0.7310344827586208, 0.3999999999999999), (0.7862068965517239, 0.8, 0.3999999999999999), (0.7034482758620692, 0.8, 0.3999999999999999), (0.6206896551724138, 0.8, 0.3999999999999999), (0.5379310344827584, 0.8, 0.3999999999999999), (0.4551724137931036, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42758620689655175), (0.3999999999999999, 0.8, 0.5103448275862071), (0.3999999999999999, 0.8, 0.5931034482758619), (0.3999999999999999, 0.8, 0.6758620689655173), (0.3999999999999999, 0.8, 0.7586206896551726), (0.3999999999999999, 0.7586206896551726, 0.8), (0.3999999999999999, 0.6758620689655173, 0.8), (0.3999999999999999, 0.5931034482758618, 0.8), (0.3999999999999999, 0.510344827586207, 0.8), (0.3999999999999999, 0.4275862068965516, 0.8), (0.4551724137931033, 0.3999999999999999, 0.8), (0.5379310344827581, 0.3999999999999999, 0.8), (0.6206896551724135, 0.3999999999999999, 0.8), (0.7034482758620688, 0.3999999999999999, 0.8), (0.7862068965517237, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7310344827586206), (0.8, 0.3999999999999999, 0.6482758620689653), (0.8, 0.3999999999999999, 0.5655172413793104), (0.8, 0.3999999999999999, 0.482758620689655)],
    30: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4800000000000002, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6399999999999999, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.48000000000000004), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.6400000000000001), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7200000000000002, 0.8), (0.3999999999999999, 0.6399999999999999, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.4799999999999999, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.47999999999999965, 0.3999999999999999, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.6399999999999997, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.5599999999999996), (0.8, 0.3999999999999999, 0.47999999999999937)],
    31: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.47741935483870956, 0.3999999999999999), (0.8, 0.5548387096774192, 0.3999999999999999), (0.8, 0.6322580645161289, 0.3999999999999999), (0.8, 0.7096774193548385, 0.3999999999999999), (0.8, 0.7870967741935486, 0.3999999999999999), (0.7354838709677419, 0.8, 0.3999999999999999), (0.6580645161290323, 0.8, 0.3999999999999999), (0.5806451612903226, 0.8, 0.3999999999999999), (0.5032258064516131, 0.8, 0.3999999999999999), (0.42580645161290337, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4516129032258067), (0.3999999999999999, 0.8, 0.5290322580645164), (0.3999999999999999, 0.8, 0.606451612903226), (0.3999999999999999, 0.8, 0.6838709677419357), (0.3999999999999999, 0.8, 0.7612903225806453), (0.3999999999999999, 0.7612903225806451, 0.8), (0.3999999999999999, 0.6838709677419355, 0.8), (0.3999999999999999, 0.6064516129032259, 0.8), (0.3999999999999999, 0.5290322580645163, 0.8), (0.3999999999999999, 0.4516129032258066, 0.8), (0.4258064516129026, 0.3999999999999999, 0.8), (0.5032258064516127, 0.3999999999999999, 0.8), (0.5806451612903224, 0.3999999999999999, 0.8), (0.658064516129032, 0.3999999999999999, 0.8), (0.7354838709677416, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7870967741935484), (0.8, 0.3999999999999999, 0.7096774193548382), (0.8, 0.3999999999999999, 0.6322580645161285), (0.8, 0.3999999999999999, 0.5548387096774189), (0.8, 0.3999999999999999, 0.4774193548387093)],
    32: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4749999999999999, 0.3999999999999999), (0.8, 0.5499999999999999, 0.3999999999999999), (0.8, 0.625, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7750000000000001, 0.3999999999999999), (0.7500000000000001, 0.8, 0.3999999999999999), (0.675, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.525, 0.8, 0.3999999999999999), (0.45, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42499999999999993), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.575), (0.3999999999999999, 0.8, 0.65), (0.3999999999999999, 0.8, 0.7250000000000001), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7249999999999999, 0.8), (0.3999999999999999, 0.6499999999999999, 0.8), (0.3999999999999999, 0.5749999999999998, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4249999999999998, 0.8), (0.44999999999999973, 0.3999999999999999, 0.8), (0.5249999999999998, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6749999999999998, 0.3999999999999999, 0.8), (0.7499999999999998, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7749999999999998), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6249999999999998), (0.8, 0.3999999999999999, 0.5499999999999997), (0.8, 0.3999999999999999, 0.47499999999999964)],
    33: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4727272727272726, 0.3999999999999999), (0.8, 0.5454545454545453, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6909090909090907, 0.3999999999999999), (0.8, 0.7636363636363639, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.6909090909090909, 0.8, 0.3999999999999999), (0.6181818181818183, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.4727272727272729, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.5454545454545456), (0.3999999999999999, 0.8, 0.6181818181818184), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7636363636363638), (0.3999999999999999, 0.7636363636363637, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6181818181818183, 0.8), (0.3999999999999999, 0.5454545454545455, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.4727272727272726, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.6181818181818179, 0.3999999999999999, 0.8), (0.6909090909090907, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7636363636363631), (0.8, 0.3999999999999999, 0.6909090909090905), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.545454545454545), (0.8, 0.3999999999999999, 0.47272727272727233)],
    34: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4705882352941173, 0.3999999999999999), (0.8, 0.5411764705882353, 0.3999999999999999), (0.8, 0.6117647058823527, 0.3999999999999999), (0.8, 0.6823529411764706, 0.3999999999999999), (0.8, 0.752941176470588, 0.3999999999999999), (0.7764705882352942, 0.8, 0.3999999999999999), (0.7058823529411767, 0.8, 0.3999999999999999), (0.6352941176470588, 0.8, 0.3999999999999999), (0.5647058823529414, 0.8, 0.3999999999999999), (0.4941176470588234, 0.8, 0.3999999999999999), (0.423529411764706, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.44705882352941195), (0.3999999999999999, 0.8, 0.5176470588235293), (0.3999999999999999, 0.8, 0.5882352941176467), (0.3999999999999999, 0.8, 0.6588235294117647), (0.3999999999999999, 0.8, 0.7294117647058826), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7294117647058825, 0.8), (0.3999999999999999, 0.6588235294117646, 0.8), (0.3999999999999999, 0.5882352941176466, 0.8), (0.3999999999999999, 0.5176470588235292, 0.8), (0.3999999999999999, 0.4470588235294118, 0.8), (0.4235294117647057, 0.3999999999999999, 0.8), (0.49411764705882316, 0.3999999999999999, 0.8), (0.5647058823529411, 0.3999999999999999, 0.8), (0.6352941176470586, 0.3999999999999999, 0.8), (0.705882352941176, 0.3999999999999999, 0.8), (0.7764705882352938, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7529411764705878), (0.8, 0.3999999999999999, 0.6823529411764704), (0.8, 0.3999999999999999, 0.611764705882353), (0.8, 0.3999999999999999, 0.541176470588235), (0.8, 0.3999999999999999, 0.4705882352941171)],
    35: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.46857142857142825, 0.3999999999999999), (0.8, 0.5371428571428571, 0.3999999999999999), (0.8, 0.6057142857142855, 0.3999999999999999), (0.8, 0.6742857142857144, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.7885714285714285, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6514285714285714, 0.8, 0.3999999999999999), (0.582857142857143, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.44571428571428573, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4228571428571431), (0.3999999999999999, 0.8, 0.49142857142857144), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6971428571428571), (0.3999999999999999, 0.8, 0.7657142857142859), (0.3999999999999999, 0.7657142857142858, 0.8), (0.3999999999999999, 0.6971428571428575, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.4914285714285713, 0.8), (0.3999999999999999, 0.42285714285714293, 0.8), (0.4457142857142855, 0.3999999999999999, 0.8), (0.5142857142857143, 0.3999999999999999, 0.8), (0.5828571428571427, 0.3999999999999999, 0.8), (0.651428571428571, 0.3999999999999999, 0.8), (0.7199999999999994, 0.3999999999999999, 0.8), (0.7885714285714283, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.6742857142857142), (0.8, 0.3999999999999999, 0.6057142857142858), (0.8, 0.3999999999999999, 0.5371428571428569), (0.8, 0.3999999999999999, 0.468571428571428)],
    36: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.46666666666666634, 0.3999999999999999), (0.8, 0.5333333333333333, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.7333333333333332, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7333333333333335, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5333333333333337, 0.8, 0.3999999999999999), (0.4666666666666666, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4666666666666668), (0.3999999999999999, 0.8, 0.5333333333333332), (0.3999999999999999, 0.8, 0.5999999999999996), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.7333333333333336), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7333333333333335, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6000000000000001, 0.8), (0.3999999999999999, 0.5333333333333331, 0.8), (0.3999999999999999, 0.4666666666666666, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.46666666666666634, 0.3999999999999999, 0.8), (0.5333333333333333, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.7333333333333327, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.733333333333333), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5333333333333331), (0.8, 0.3999999999999999, 0.4666666666666661)],
    37: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.46486486486486467, 0.3999999999999999), (0.8, 0.5297297297297294, 0.3999999999999999), (0.8, 0.5945945945945947, 0.3999999999999999), (0.8, 0.6594594594594595, 0.3999999999999999), (0.8, 0.7243243243243243, 0.3999999999999999), (0.8, 0.7891891891891896, 0.3999999999999999), (0.7459459459459459, 0.8, 0.3999999999999999), (0.6810810810810812, 0.8, 0.3999999999999999), (0.6162162162162164, 0.8, 0.3999999999999999), (0.5513513513513516, 0.8, 0.3999999999999999), (0.48648648648648635, 0.8, 0.3999999999999999), (0.4216216216216216, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.44324324324324316), (0.3999999999999999, 0.8, 0.5081081081081085), (0.3999999999999999, 0.8, 0.5729729729729731), (0.3999999999999999, 0.8, 0.637837837837838), (0.3999999999999999, 0.8, 0.7027027027027026), (0.3999999999999999, 0.8, 0.7675675675675675), (0.3999999999999999, 0.7675675675675673, 0.8), (0.3999999999999999, 0.7027027027027026, 0.8), (0.3999999999999999, 0.6378378378378378, 0.8), (0.3999999999999999, 0.5729729729729724, 0.8), (0.3999999999999999, 0.5081081081081078, 0.8), (0.3999999999999999, 0.443243243243243, 0.8), (0.4216216216216213, 0.3999999999999999, 0.8), (0.48648648648648607, 0.3999999999999999, 0.8), (0.5513513513513514, 0.3999999999999999, 0.8), (0.6162162162162161, 0.3999999999999999, 0.8), (0.6810810810810809, 0.3999999999999999, 0.8), (0.7459459459459461, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7891891891891887), (0.8, 0.3999999999999999, 0.724324324324324), (0.8, 0.3999999999999999, 0.6594594594594592), (0.8, 0.3999999999999999, 0.5945945945945944), (0.8, 0.3999999999999999, 0.5297297297297292), (0.8, 0.3999999999999999, 0.4648648648648644)],
    38: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4631578947368422, 0.3999999999999999), (0.8, 0.5263157894736841, 0.3999999999999999), (0.8, 0.5894736842105264, 0.3999999999999999), (0.8, 0.6526315789473681, 0.3999999999999999), (0.8, 0.7157894736842105, 0.3999999999999999), (0.8, 0.7789473684210528, 0.3999999999999999), (0.7578947368421056, 0.8, 0.3999999999999999), (0.6947368421052633, 0.8, 0.3999999999999999), (0.631578947368421, 0.8, 0.3999999999999999), (0.5684210526315792, 0.8, 0.3999999999999999), (0.5052631578947369, 0.8, 0.3999999999999999), (0.4421052631578945, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42105263157894723), (0.3999999999999999, 0.8, 0.48421052631578954), (0.3999999999999999, 0.8, 0.5473684210526318), (0.3999999999999999, 0.8, 0.6105263157894737), (0.3999999999999999, 0.8, 0.6736842105263154), (0.3999999999999999, 0.8, 0.7368421052631577), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7368421052631582, 0.8), (0.3999999999999999, 0.6736842105263159, 0.8), (0.3999999999999999, 0.6105263157894735, 0.8), (0.3999999999999999, 0.5473684210526317, 0.8), (0.3999999999999999, 0.4842105263157894, 0.8), (0.3999999999999999, 0.42105263157894707, 0.8), (0.4421052631578943, 0.3999999999999999, 0.8), (0.5052631578947366, 0.3999999999999999, 0.8), (0.5684210526315789, 0.3999999999999999, 0.8), (0.6315789473684207, 0.3999999999999999, 0.8), (0.6947368421052631, 0.3999999999999999, 0.8), (0.7578947368421054, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7789473684210526), (0.8, 0.3999999999999999, 0.7157894736842108), (0.8, 0.3999999999999999, 0.6526315789473685), (0.8, 0.3999999999999999, 0.589473684210526), (0.8, 0.3999999999999999, 0.5263157894736843), (0.8, 0.3999999999999999, 0.463157894736842)],
    39: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.46153846153846123, 0.3999999999999999), (0.8, 0.5230769230769231, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.6461538461538463, 0.3999999999999999), (0.8, 0.7076923076923076, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.7692307692307693, 0.8, 0.3999999999999999), (0.707692307692308, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.5846153846153848, 0.8, 0.3999999999999999), (0.5230769230769234, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4615384615384617), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.5846153846153843), (0.3999999999999999, 0.8, 0.6461538461538462), (0.3999999999999999, 0.8, 0.7076923076923076), (0.3999999999999999, 0.8, 0.7692307692307694), (0.3999999999999999, 0.7692307692307693, 0.8), (0.3999999999999999, 0.707692307692308, 0.8), (0.3999999999999999, 0.6461538461538461, 0.8), (0.3999999999999999, 0.5846153846153842, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.4615384615384615, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.46153846153846123, 0.3999999999999999, 0.8), (0.5230769230769231, 0.3999999999999999, 0.8), (0.5846153846153845, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.7076923076923072, 0.3999999999999999, 0.8), (0.769230769230769, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7076923076923074), (0.8, 0.3999999999999999, 0.6461538461538461), (0.8, 0.3999999999999999, 0.5846153846153848), (0.8, 0.3999999999999999, 0.5230769230769229), (0.8, 0.3999999999999999, 0.461538461538461)],
    40: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.45999999999999974, 0.3999999999999999), (0.8, 0.52, 0.3999999999999999), (0.8, 0.5799999999999998, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7599999999999998, 0.3999999999999999), (0.78, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6599999999999999, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5400000000000003, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.4200000000000001, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.44000000000000017), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.6200000000000001), (0.3999999999999999, 0.8, 0.6799999999999999), (0.3999999999999999, 0.8, 0.7400000000000002), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7400000000000002, 0.8), (0.3999999999999999, 0.6799999999999998, 0.8), (0.3999999999999999, 0.6199999999999994, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.44000000000000006, 0.8), (0.4199999999999998, 0.3999999999999999, 0.8), (0.4800000000000002, 0.3999999999999999, 0.8), (0.54, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6599999999999996, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7800000000000002, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7599999999999996), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.5799999999999996), (0.8, 0.3999999999999999, 0.5199999999999992), (0.8, 0.3999999999999999, 0.45999999999999946)],
    41: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4585365853658536, 0.3999999999999999), (0.8, 0.5170731707317073, 0.3999999999999999), (0.8, 0.575609756097561, 0.3999999999999999), (0.8, 0.6341463414634149, 0.3999999999999999), (0.8, 0.6926829268292686, 0.3999999999999999), (0.8, 0.7512195121951223, 0.3999999999999999), (0.7902439024390246, 0.8, 0.3999999999999999), (0.7317073170731709, 0.8, 0.3999999999999999), (0.6731707317073172, 0.8, 0.3999999999999999), (0.6146341463414635, 0.8, 0.3999999999999999), (0.5560975609756098, 0.8, 0.3999999999999999), (0.49756097560975604, 0.8, 0.3999999999999999), (0.43902439024390233, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41951219512195137), (0.3999999999999999, 0.8, 0.4780487804878046), (0.3999999999999999, 0.8, 0.5365853658536583), (0.3999999999999999, 0.8, 0.5951219512195121), (0.3999999999999999, 0.8, 0.6536585365853658), (0.3999999999999999, 0.8, 0.7121951219512195), (0.3999999999999999, 0.8, 0.7707317073170732), (0.3999999999999999, 0.7707317073170731, 0.8), (0.3999999999999999, 0.7121951219512194, 0.8), (0.3999999999999999, 0.6536585365853657, 0.8), (0.3999999999999999, 0.595121951219512, 0.8), (0.3999999999999999, 0.5365853658536581, 0.8), (0.3999999999999999, 0.4780487804878044, 0.8), (0.3999999999999999, 0.4195121951219507, 0.8), (0.43902439024390255, 0.3999999999999999, 0.8), (0.4975609756097563, 0.3999999999999999, 0.8), (0.5560975609756095, 0.3999999999999999, 0.8), (0.6146341463414633, 0.3999999999999999, 0.8), (0.673170731707317, 0.3999999999999999, 0.8), (0.7317073170731707, 0.3999999999999999, 0.8), (0.7902439024390244, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.751219512195122), (0.8, 0.3999999999999999, 0.6926829268292682), (0.8, 0.3999999999999999, 0.6341463414634145), (0.8, 0.3999999999999999, 0.5756097560975608), (0.8, 0.3999999999999999, 0.5170731707317071), (0.8, 0.3999999999999999, 0.4585365853658534)],
    42: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.45714285714285685, 0.3999999999999999), (0.8, 0.5142857142857143, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.6285714285714288, 0.3999999999999999), (0.8, 0.6857142857142857, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.742857142857143, 0.8, 0.3999999999999999), (0.685714285714286, 0.8, 0.3999999999999999), (0.6285714285714286, 0.8, 0.3999999999999999), (0.5714285714285716, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.45714285714285713, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.5142857142857142), (0.3999999999999999, 0.8, 0.5714285714285712), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6857142857142857), (0.3999999999999999, 0.8, 0.7428571428571431), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.742857142857143, 0.8), (0.3999999999999999, 0.685714285714286, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.5714285714285711, 0.8), (0.3999999999999999, 0.5142857142857141, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.45714285714285685, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5714285714285713, 0.3999999999999999, 0.8), (0.6285714285714283, 0.3999999999999999, 0.8), (0.6857142857142853, 0.3999999999999999, 0.8), (0.7428571428571427, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.6857142857142855), (0.8, 0.3999999999999999, 0.6285714285714286), (0.8, 0.3999999999999999, 0.5714285714285716), (0.8, 0.3999999999999999, 0.5142857142857141), (0.8, 0.3999999999999999, 0.45714285714285663)],
    43: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4558139534883721, 0.3999999999999999), (0.8, 0.5116279069767443, 0.3999999999999999), (0.8, 0.567441860465116, 0.3999999999999999), (0.8, 0.6232558139534883, 0.3999999999999999), (0.8, 0.6790697674418604, 0.3999999999999999), (0.8, 0.7348837209302326, 0.3999999999999999), (0.8, 0.790697674418605, 0.3999999999999999), (0.7534883720930237, 0.8, 0.3999999999999999), (0.6976744186046515, 0.8, 0.3999999999999999), (0.6418604651162793, 0.8, 0.3999999999999999), (0.586046511627907, 0.8, 0.3999999999999999), (0.5302325581395348, 0.8, 0.3999999999999999), (0.4744186046511626, 0.8, 0.3999999999999999), (0.4186046511627904, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.43720930232558125), (0.3999999999999999, 0.8, 0.49302325581395345), (0.3999999999999999, 0.8, 0.5488372093023257), (0.3999999999999999, 0.8, 0.6046511627906973), (0.3999999999999999, 0.8, 0.6604651162790696), (0.3999999999999999, 0.8, 0.7162790697674417), (0.3999999999999999, 0.8, 0.772093023255814), (0.3999999999999999, 0.7720930232558139, 0.8), (0.3999999999999999, 0.7162790697674417, 0.8), (0.3999999999999999, 0.6604651162790695, 0.8), (0.3999999999999999, 0.6046511627906972, 0.8), (0.3999999999999999, 0.5488372093023255, 0.8), (0.3999999999999999, 0.49302325581395334, 0.8), (0.3999999999999999, 0.43720930232558114, 0.8), (0.4186046511627901, 0.3999999999999999, 0.8), (0.4744186046511623, 0.3999999999999999, 0.8), (0.5302325581395345, 0.3999999999999999, 0.8), (0.5860465116279068, 0.3999999999999999, 0.8), (0.6418604651162789, 0.3999999999999999, 0.8), (0.6976744186046512, 0.3999999999999999, 0.8), (0.7534883720930234, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7906976744186045), (0.8, 0.3999999999999999, 0.7348837209302324), (0.8, 0.3999999999999999, 0.6790697674418602), (0.8, 0.3999999999999999, 0.6232558139534885), (0.8, 0.3999999999999999, 0.5674418604651162), (0.8, 0.3999999999999999, 0.5116279069767441), (0.8, 0.3999999999999999, 0.45581395348837184)],
    44: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4545454545454544, 0.3999999999999999), (0.8, 0.5090909090909089, 0.3999999999999999), (0.8, 0.5636363636363635, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6727272727272731, 0.3999999999999999), (0.8, 0.7272727272727271, 0.3999999999999999), (0.8, 0.781818181818182, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7090909090909091, 0.8, 0.3999999999999999), (0.6545454545454545, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.4909090909090911, 0.8, 0.3999999999999999), (0.4363636363636365, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41818181818181793), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.527272727272727), (0.3999999999999999, 0.8, 0.581818181818182), (0.3999999999999999, 0.8, 0.6363636363636366), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7454545454545456), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7454545454545454, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6363636363636359, 0.8), (0.3999999999999999, 0.5818181818181819, 0.8), (0.3999999999999999, 0.5272727272727269, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.4181818181818178, 0.8), (0.43636363636363623, 0.3999999999999999, 0.8), (0.49090909090909074, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6545454545454543, 0.3999999999999999, 0.8), (0.7090909090909088, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7818181818181817), (0.8, 0.3999999999999999, 0.7272727272727267), (0.8, 0.3999999999999999, 0.6727272727272728), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.5636363636363632), (0.8, 0.3999999999999999, 0.5090909090909087), (0.8, 0.3999999999999999, 0.45454545454545414)],
    45: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4533333333333331, 0.3999999999999999), (0.8, 0.5066666666666668, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.6133333333333331, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.8, 0.7733333333333331, 0.3999999999999999), (0.7733333333333334, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6133333333333334, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.5066666666666665, 0.8, 0.3999999999999999), (0.45333333333333337, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.4533333333333335), (0.3999999999999999, 0.8, 0.5066666666666666), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.6133333333333335), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.8, 0.7733333333333335), (0.3999999999999999, 0.7733333333333334, 0.8), (0.3999999999999999, 0.7200000000000002, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6133333333333328, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5066666666666665, 0.8), (0.3999999999999999, 0.45333333333333337, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.4533333333333331, 0.3999999999999999, 0.8), (0.5066666666666668, 0.3999999999999999, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.6133333333333331, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7733333333333337, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7733333333333329), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6133333333333334), (0.8, 0.3999999999999999, 0.5599999999999996), (0.8, 0.3999999999999999, 0.5066666666666659), (0.8, 0.3999999999999999, 0.4533333333333328)],
    46: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4521739130434784, 0.3999999999999999), (0.8, 0.5043478260869564, 0.3999999999999999), (0.8, 0.5565217391304349, 0.3999999999999999), (0.8, 0.6086956521739129, 0.3999999999999999), (0.8, 0.6608695652173914, 0.3999999999999999), (0.8, 0.7130434782608694, 0.3999999999999999), (0.8, 0.7652173913043478, 0.3999999999999999), (0.7826086956521743, 0.8, 0.3999999999999999), (0.7304347826086959, 0.8, 0.3999999999999999), (0.6782608695652173, 0.8, 0.3999999999999999), (0.6260869565217393, 0.8, 0.3999999999999999), (0.5739130434782608, 0.8, 0.3999999999999999), (0.5217391304347828, 0.8, 0.3999999999999999), (0.4695652173913043, 0.8, 0.3999999999999999), (0.4173913043478258, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4347826086956521), (0.3999999999999999, 0.8, 0.48695652173913007), (0.3999999999999999, 0.8, 0.5391304347826086), (0.3999999999999999, 0.8, 0.5913043478260871), (0.3999999999999999, 0.8, 0.643478260869565), (0.3999999999999999, 0.8, 0.6956521739130437), (0.3999999999999999, 0.8, 0.7478260869565216), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7478260869565214, 0.8), (0.3999999999999999, 0.6956521739130435, 0.8), (0.3999999999999999, 0.6434782608695655, 0.8), (0.3999999999999999, 0.591304347826087, 0.8), (0.3999999999999999, 0.5391304347826085, 0.8), (0.3999999999999999, 0.48695652173912995, 0.8), (0.3999999999999999, 0.434782608695652, 0.8), (0.41739130434782556, 0.3999999999999999, 0.8), (0.4695652173913041, 0.3999999999999999, 0.8), (0.5217391304347826, 0.3999999999999999, 0.8), (0.5739130434782606, 0.3999999999999999, 0.8), (0.6260869565217385, 0.3999999999999999, 0.8), (0.678260869565217, 0.3999999999999999, 0.8), (0.7304347826086955, 0.3999999999999999, 0.8), (0.7826086956521741, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7652173913043476), (0.8, 0.3999999999999999, 0.7130434782608697), (0.8, 0.3999999999999999, 0.6608695652173912), (0.8, 0.3999999999999999, 0.6086956521739126), (0.8, 0.3999999999999999, 0.5565217391304347), (0.8, 0.3999999999999999, 0.5043478260869562), (0.8, 0.3999999999999999, 0.45217391304347815)],
    47: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4510638297872338, 0.3999999999999999), (0.8, 0.5021276595744681, 0.3999999999999999), (0.8, 0.553191489361702, 0.3999999999999999), (0.8, 0.6042553191489359, 0.3999999999999999), (0.8, 0.6553191489361703, 0.3999999999999999), (0.8, 0.7063829787234042, 0.3999999999999999), (0.8, 0.7574468085106385, 0.3999999999999999), (0.7914893617021277, 0.8, 0.3999999999999999), (0.7404255319148938, 0.8, 0.3999999999999999), (0.6893617021276595, 0.8, 0.3999999999999999), (0.6382978723404256, 0.8, 0.3999999999999999), (0.5872340425531917, 0.8, 0.3999999999999999), (0.5361702127659573, 0.8, 0.3999999999999999), (0.48510638297872344, 0.8, 0.3999999999999999), (0.4340425531914896, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4170212765957447), (0.3999999999999999, 0.8, 0.4680851063829786), (0.3999999999999999, 0.8, 0.5191489361702125), (0.3999999999999999, 0.8, 0.5702127659574469), (0.3999999999999999, 0.8, 0.6212765957446807), (0.3999999999999999, 0.8, 0.6723404255319146), (0.3999999999999999, 0.8, 0.7234042553191491), (0.3999999999999999, 0.8, 0.7744680851063829), (0.3999999999999999, 0.7744680851063833, 0.8), (0.3999999999999999, 0.7234042553191489, 0.8), (0.3999999999999999, 0.6723404255319145, 0.8), (0.3999999999999999, 0.6212765957446812, 0.8), (0.3999999999999999, 0.5702127659574467, 0.8), (0.3999999999999999, 0.5191489361702124, 0.8), (0.3999999999999999, 0.4680851063829785, 0.8), (0.3999999999999999, 0.4170212765957446, 0.8), (0.4340425531914893, 0.3999999999999999, 0.8), (0.4851063829787232, 0.3999999999999999, 0.8), (0.5361702127659571, 0.3999999999999999, 0.8), (0.5872340425531914, 0.3999999999999999, 0.8), (0.6382978723404253, 0.3999999999999999, 0.8), (0.6893617021276592, 0.3999999999999999, 0.8), (0.7404255319148936, 0.3999999999999999, 0.8), (0.7914893617021275, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7574468085106383), (0.8, 0.3999999999999999, 0.7063829787234039), (0.8, 0.3999999999999999, 0.65531914893617), (0.8, 0.3999999999999999, 0.6042553191489362), (0.8, 0.3999999999999999, 0.5531914893617018), (0.8, 0.3999999999999999, 0.5021276595744679), (0.8, 0.3999999999999999, 0.451063829787234)],
    48: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.44999999999999973, 0.3999999999999999), (0.8, 0.5000000000000001, 0.3999999999999999), (0.8, 0.5499999999999999, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6500000000000001, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7499999999999998, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7500000000000001, 0.8, 0.3999999999999999), (0.7000000000000003, 0.8, 0.3999999999999999), (0.6499999999999999, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5500000000000003, 0.8, 0.3999999999999999), (0.5000000000000004, 0.8, 0.3999999999999999), (0.45, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4499999999999996), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5499999999999998), (0.3999999999999999, 0.8, 0.5999999999999996), (0.3999999999999999, 0.8, 0.65), (0.3999999999999999, 0.8, 0.7), (0.3999999999999999, 0.8, 0.7499999999999998), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7500000000000001, 0.8), (0.3999999999999999, 0.7000000000000003, 0.8), (0.3999999999999999, 0.6499999999999999, 0.8), (0.3999999999999999, 0.6000000000000001, 0.8), (0.3999999999999999, 0.5500000000000003, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.45, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.44999999999999973, 0.3999999999999999, 0.8), (0.4999999999999996, 0.3999999999999999, 0.8), (0.5499999999999994, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6499999999999997, 0.3999999999999999, 0.8), (0.6999999999999995, 0.3999999999999999, 0.8), (0.7499999999999998, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7500000000000001), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6499999999999999), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5499999999999997), (0.8, 0.3999999999999999, 0.49999999999999983), (0.8, 0.3999999999999999, 0.45)],
    49: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4489795918367347, 0.3999999999999999), (0.8, 0.4979591836734694, 0.3999999999999999), (0.8, 0.5469387755102042, 0.3999999999999999), (0.8, 0.5959183673469389, 0.3999999999999999), (0.8, 0.6448979591836732, 0.3999999999999999), (0.8, 0.693877551020408, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7918367346938775, 0.3999999999999999), (0.759183673469388, 0.8, 0.3999999999999999), (0.7102040816326531, 0.8, 0.3999999999999999), (0.6612244897959184, 0.8, 0.3999999999999999), (0.6122448979591836, 0.8, 0.3999999999999999), (0.5632653061224488, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.46530612244897984, 0.8, 0.3999999999999999), (0.4163265306122451, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4326530612244896), (0.3999999999999999, 0.8, 0.4816326530612244), (0.3999999999999999, 0.8, 0.5306122448979591), (0.3999999999999999, 0.8, 0.5795918367346939), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6775510204081634), (0.3999999999999999, 0.8, 0.7265306122448977), (0.3999999999999999, 0.8, 0.7755102040816331), (0.3999999999999999, 0.7755102040816328, 0.8), (0.3999999999999999, 0.726530612244898, 0.8), (0.3999999999999999, 0.6775510204081634, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.5795918367346937, 0.8), (0.3999999999999999, 0.5306122448979596, 0.8), (0.3999999999999999, 0.48163265306122427, 0.8), (0.3999999999999999, 0.43265306122449004, 0.8), (0.41632653061224484, 0.3999999999999999, 0.8), (0.46530612244897906, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5632653061224486, 0.3999999999999999, 0.8), (0.6122448979591834, 0.3999999999999999, 0.8), (0.6612244897959181, 0.3999999999999999, 0.8), (0.7102040816326524, 0.3999999999999999, 0.8), (0.7591836734693876, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7918367346938777), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.6938775510204083), (0.8, 0.3999999999999999, 0.6448979591836734), (0.8, 0.3999999999999999, 0.5959183673469387), (0.8, 0.3999999999999999, 0.546938775510204), (0.8, 0.3999999999999999, 0.4979591836734692), (0.8, 0.3999999999999999, 0.4489795918367344)],
    50: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.44799999999999995, 0.3999999999999999), (0.8, 0.49600000000000005, 0.3999999999999999), (0.8, 0.544, 0.3999999999999999), (0.8, 0.5920000000000002, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6880000000000003, 0.3999999999999999), (0.8, 0.7360000000000003, 0.3999999999999999), (0.8, 0.7839999999999998, 0.3999999999999999), (0.7680000000000002, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6720000000000002, 0.8, 0.3999999999999999), (0.6240000000000001, 0.8, 0.3999999999999999), (0.5760000000000001, 0.8, 0.3999999999999999), (0.528, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.4319999999999999, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41600000000000015), (0.3999999999999999, 0.8, 0.4639999999999997), (0.3999999999999999, 0.8, 0.5119999999999998), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.6079999999999999), (0.3999999999999999, 0.8, 0.6559999999999999), (0.3999999999999999, 0.8, 0.704), (0.3999999999999999, 0.8, 0.752), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7519999999999999, 0.8), (0.3999999999999999, 0.7039999999999998, 0.8), (0.3999999999999999, 0.6559999999999998, 0.8), (0.3999999999999999, 0.6079999999999998, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5119999999999996, 0.8), (0.3999999999999999, 0.4639999999999995, 0.8), (0.3999999999999999, 0.4159999999999995, 0.8), (0.4320000000000001, 0.3999999999999999, 0.8), (0.4800000000000002, 0.3999999999999999, 0.8), (0.5279999999999997, 0.3999999999999999, 0.8), (0.5759999999999997, 0.3999999999999999, 0.8), (0.6239999999999999, 0.3999999999999999, 0.8), (0.6719999999999999, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.768, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.784), (0.8, 0.3999999999999999, 0.736), (0.8, 0.3999999999999999, 0.688), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.5919999999999999), (0.8, 0.3999999999999999, 0.5439999999999998), (0.8, 0.3999999999999999, 0.4959999999999998), (0.8, 0.3999999999999999, 0.44799999999999973)],
    51: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4470588235294115, 0.3999999999999999), (0.8, 0.49411764705882366, 0.3999999999999999), (0.8, 0.5411764705882353, 0.3999999999999999), (0.8, 0.5882352941176469, 0.3999999999999999), (0.8, 0.635294117647059, 0.3999999999999999), (0.8, 0.6823529411764706, 0.3999999999999999), (0.8, 0.7294117647058822, 0.3999999999999999), (0.8, 0.7764705882352938, 0.3999999999999999), (0.7764705882352942, 0.8, 0.3999999999999999), (0.7294117647058825, 0.8, 0.3999999999999999), (0.6823529411764704, 0.8, 0.3999999999999999), (0.6352941176470588, 0.8, 0.3999999999999999), (0.5882352941176472, 0.8, 0.3999999999999999), (0.5411764705882356, 0.8, 0.3999999999999999), (0.4941176470588234, 0.8, 0.3999999999999999), (0.4470588235294118, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.44705882352941195), (0.3999999999999999, 0.8, 0.49411764705882355), (0.3999999999999999, 0.8, 0.5411764705882351), (0.3999999999999999, 0.8, 0.5882352941176467), (0.3999999999999999, 0.8, 0.6352941176470589), (0.3999999999999999, 0.8, 0.6823529411764706), (0.3999999999999999, 0.8, 0.7294117647058826), (0.3999999999999999, 0.8, 0.7764705882352942), (0.3999999999999999, 0.7764705882352942, 0.8), (0.3999999999999999, 0.7294117647058825, 0.8), (0.3999999999999999, 0.6823529411764704, 0.8), (0.3999999999999999, 0.6352941176470588, 0.8), (0.3999999999999999, 0.5882352941176466, 0.8), (0.3999999999999999, 0.541176470588235, 0.8), (0.3999999999999999, 0.4941176470588234, 0.8), (0.3999999999999999, 0.4470588235294118, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4470588235294115, 0.3999999999999999, 0.8), (0.49411764705882316, 0.3999999999999999, 0.8), (0.5411764705882353, 0.3999999999999999, 0.8), (0.5882352941176469, 0.3999999999999999, 0.8), (0.6352941176470586, 0.3999999999999999, 0.8), (0.6823529411764702, 0.3999999999999999, 0.8), (0.7294117647058822, 0.3999999999999999, 0.8), (0.7764705882352938, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7764705882352936), (0.8, 0.3999999999999999, 0.729411764705882), (0.8, 0.3999999999999999, 0.6823529411764704), (0.8, 0.3999999999999999, 0.6352941176470588), (0.8, 0.3999999999999999, 0.5882352941176472), (0.8, 0.3999999999999999, 0.541176470588235), (0.8, 0.3999999999999999, 0.4941176470588229), (0.8, 0.3999999999999999, 0.4470588235294113)],
    52: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4461538461538459, 0.3999999999999999), (0.8, 0.49230769230769245, 0.3999999999999999), (0.8, 0.5384615384615384, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.630769230769231, 0.3999999999999999), (0.8, 0.676923076923077, 0.3999999999999999), (0.8, 0.723076923076923, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.7846153846153847, 0.8, 0.3999999999999999), (0.7384615384615386, 0.8, 0.3999999999999999), (0.6923076923076921, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5538461538461541, 0.8, 0.3999999999999999), (0.5076923076923076, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.4153846153846155, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.43076923076923096), (0.3999999999999999, 0.8, 0.476923076923077), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.569230769230769), (0.3999999999999999, 0.8, 0.6153846153846155), (0.3999999999999999, 0.8, 0.6615384615384615), (0.3999999999999999, 0.8, 0.7076923076923081), (0.3999999999999999, 0.8, 0.753846153846154), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7538461538461539, 0.8), (0.3999999999999999, 0.7076923076923074, 0.8), (0.3999999999999999, 0.6615384615384614, 0.8), (0.3999999999999999, 0.6153846153846149, 0.8), (0.3999999999999999, 0.5692307692307689, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.47692307692307684, 0.8), (0.3999999999999999, 0.43076923076923085, 0.8), (0.41538461538461524, 0.3999999999999999, 0.8), (0.46153846153846123, 0.3999999999999999, 0.8), (0.5076923076923078, 0.3999999999999999, 0.8), (0.5538461538461538, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.6923076923076923, 0.3999999999999999, 0.8), (0.7384615384615383, 0.3999999999999999, 0.8), (0.7846153846153849, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7230769230769227), (0.8, 0.3999999999999999, 0.6769230769230767), (0.8, 0.3999999999999999, 0.6307692307692307), (0.8, 0.3999999999999999, 0.5846153846153842), (0.8, 0.3999999999999999, 0.5384615384615377), (0.8, 0.3999999999999999, 0.49230769230769167), (0.8, 0.3999999999999999, 0.4461538461538457)],
    53: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.44528301886792443, 0.3999999999999999), (0.8, 0.49056603773584895, 0.3999999999999999), (0.8, 0.5358490566037735, 0.3999999999999999), (0.8, 0.581132075471698, 0.3999999999999999), (0.8, 0.6264150943396226, 0.3999999999999999), (0.8, 0.6716981132075471, 0.3999999999999999), (0.8, 0.7169811320754716, 0.3999999999999999), (0.8, 0.7622641509433962, 0.3999999999999999), (0.7924528301886795, 0.8, 0.3999999999999999), (0.747169811320755, 0.8, 0.3999999999999999), (0.7018867924528305, 0.8, 0.3999999999999999), (0.6566037735849058, 0.8, 0.3999999999999999), (0.6113207547169813, 0.8, 0.3999999999999999), (0.5660377358490568, 0.8, 0.3999999999999999), (0.5207547169811323, 0.8, 0.3999999999999999), (0.4754716981132077, 0.8, 0.3999999999999999), (0.4301886792452832, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4150943396226413), (0.3999999999999999, 0.8, 0.4603773584905658), (0.3999999999999999, 0.8, 0.5056603773584903), (0.3999999999999999, 0.8, 0.5509433962264149), (0.3999999999999999, 0.8, 0.5962264150943394), (0.3999999999999999, 0.8, 0.641509433962264), (0.3999999999999999, 0.8, 0.6867924528301885), (0.3999999999999999, 0.8, 0.7320754716981135), (0.3999999999999999, 0.8, 0.7773584905660376), (0.3999999999999999, 0.7773584905660373, 0.8), (0.3999999999999999, 0.7320754716981135, 0.8), (0.3999999999999999, 0.6867924528301883, 0.8), (0.3999999999999999, 0.6415094339622643, 0.8), (0.3999999999999999, 0.5962264150943393, 0.8), (0.3999999999999999, 0.5509433962264153, 0.8), (0.3999999999999999, 0.5056603773584902, 0.8), (0.3999999999999999, 0.4603773584905662, 0.8), (0.3999999999999999, 0.41509433962264114, 0.8), (0.4301886792452824, 0.3999999999999999, 0.8), (0.47547169811320744, 0.3999999999999999, 0.8), (0.5207547169811315, 0.3999999999999999, 0.8), (0.5660377358490565, 0.3999999999999999, 0.8), (0.6113207547169806, 0.3999999999999999, 0.8), (0.6566037735849056, 0.3999999999999999, 0.8), (0.7018867924528296, 0.3999999999999999, 0.8), (0.7471698113207547, 0.3999999999999999, 0.8), (0.7924528301886786, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7622641509433958), (0.8, 0.3999999999999999, 0.716981132075472), (0.8, 0.3999999999999999, 0.6716981132075468), (0.8, 0.3999999999999999, 0.6264150943396223), (0.8, 0.3999999999999999, 0.5811320754716978), (0.8, 0.3999999999999999, 0.5358490566037732), (0.8, 0.3999999999999999, 0.4905660377358487), (0.8, 0.3999999999999999, 0.4452830188679242)],
    54: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4444444444444446, 0.3999999999999999), (0.8, 0.4888888888888887, 0.3999999999999999), (0.8, 0.5333333333333333, 0.3999999999999999), (0.8, 0.5777777777777775, 0.3999999999999999), (0.8, 0.6222222222222221, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.7111111111111109, 0.3999999999999999), (0.8, 0.7555555555555555, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7555555555555558, 0.8, 0.3999999999999999), (0.7111111111111112, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6222222222222225, 0.8, 0.3999999999999999), (0.5777777777777777, 0.8, 0.3999999999999999), (0.5333333333333337, 0.8, 0.3999999999999999), (0.48888888888888893, 0.8, 0.3999999999999999), (0.4444444444444443, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4444444444444444), (0.3999999999999999, 0.8, 0.48888888888888854), (0.3999999999999999, 0.8, 0.5333333333333332), (0.3999999999999999, 0.8, 0.5777777777777778), (0.3999999999999999, 0.8, 0.6222222222222226), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.7111111111111108), (0.3999999999999999, 0.8, 0.7555555555555554), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7555555555555553, 0.8), (0.3999999999999999, 0.7111111111111112, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6222222222222225, 0.8), (0.3999999999999999, 0.5777777777777777, 0.8), (0.3999999999999999, 0.5333333333333331, 0.8), (0.3999999999999999, 0.48888888888888893, 0.8), (0.3999999999999999, 0.4444444444444443, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.44444444444444403, 0.3999999999999999, 0.8), (0.4888888888888887, 0.3999999999999999, 0.8), (0.5333333333333333, 0.3999999999999999, 0.8), (0.5777777777777775, 0.3999999999999999, 0.8), (0.6222222222222216, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.7111111111111109, 0.3999999999999999, 0.8), (0.7555555555555555, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7555555555555553), (0.8, 0.3999999999999999, 0.7111111111111112), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6222222222222219), (0.8, 0.3999999999999999, 0.5777777777777777), (0.8, 0.3999999999999999, 0.5333333333333331), (0.8, 0.3999999999999999, 0.48888888888888893), (0.8, 0.3999999999999999, 0.4444444444444443)],
    55: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.44363636363636333, 0.3999999999999999), (0.8, 0.48727272727272725, 0.3999999999999999), (0.8, 0.5309090909090907, 0.3999999999999999), (0.8, 0.5745454545454546, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6618181818181819, 0.3999999999999999), (0.8, 0.7054545454545453, 0.3999999999999999), (0.8, 0.7490909090909093, 0.3999999999999999), (0.8, 0.7927272727272727, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6763636363636363, 0.8, 0.3999999999999999), (0.6327272727272729, 0.8, 0.3999999999999999), (0.5890909090909094, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5018181818181816, 0.8, 0.3999999999999999), (0.45818181818181825, 0.8, 0.3999999999999999), (0.41454545454545483, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4290909090909091), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.5163636363636364), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.6036363636363637), (0.3999999999999999, 0.8, 0.6472727272727271), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7345454545454544), (0.3999999999999999, 0.8, 0.7781818181818183), (0.3999999999999999, 0.7781818181818183, 0.8), (0.3999999999999999, 0.7345454545454544, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6472727272727276, 0.8), (0.3999999999999999, 0.6036363636363636, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5163636363636362, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.4290909090909089, 0.8), (0.41454545454545455, 0.3999999999999999, 0.8), (0.45818181818181797, 0.3999999999999999, 0.8), (0.5018181818181814, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5890909090909087, 0.3999999999999999, 0.8), (0.6327272727272726, 0.3999999999999999, 0.8), (0.6763636363636361, 0.3999999999999999, 0.8), (0.7199999999999994, 0.3999999999999999, 0.8), (0.7636363636363633, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7927272727272723), (0.8, 0.3999999999999999, 0.749090909090909), (0.8, 0.3999999999999999, 0.7054545454545456), (0.8, 0.3999999999999999, 0.6618181818181816), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.5745454545454542), (0.8, 0.3999999999999999, 0.5309090909090909), (0.8, 0.3999999999999999, 0.48727272727272697), (0.8, 0.3999999999999999, 0.44363636363636305)],
    56: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4428571428571426, 0.3999999999999999), (0.8, 0.4857142857142859, 0.3999999999999999), (0.8, 0.5285714285714286, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.6142857142857141, 0.3999999999999999), (0.8, 0.6571428571428573, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7857142857142854, 0.3999999999999999), (0.7714285714285715, 0.8, 0.3999999999999999), (0.7285714285714288, 0.8, 0.3999999999999999), (0.685714285714286, 0.8, 0.3999999999999999), (0.6428571428571428, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5571428571428574, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.47142857142857136, 0.8, 0.3999999999999999), (0.42857142857142866, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41428571428571404), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5428571428571427), (0.3999999999999999, 0.8, 0.5857142857142854), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6714285714285715), (0.3999999999999999, 0.8, 0.7142857142857142), (0.3999999999999999, 0.8, 0.7571428571428573), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7571428571428572, 0.8), (0.3999999999999999, 0.7142857142857145, 0.8), (0.3999999999999999, 0.6714285714285718, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.5857142857142853, 0.8), (0.3999999999999999, 0.5428571428571426, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.3999999999999999, 0.4142857142857144, 0.8), (0.4285714285714278, 0.3999999999999999, 0.8), (0.4714285714285711, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.557142857142857, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6428571428571426, 0.3999999999999999, 0.8), (0.6857142857142853, 0.3999999999999999, 0.8), (0.728571428571428, 0.3999999999999999, 0.8), (0.7714285714285712, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7857142857142858), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.657142857142857), (0.8, 0.3999999999999999, 0.6142857142857143), (0.8, 0.3999999999999999, 0.5714285714285716), (0.8, 0.3999999999999999, 0.5285714285714284), (0.8, 0.3999999999999999, 0.4857142857142856), (0.8, 0.3999999999999999, 0.4428571428571424)],
    57: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4421052631578948, 0.3999999999999999), (0.8, 0.48421052631578965, 0.3999999999999999), (0.8, 0.5263157894736841, 0.3999999999999999), (0.8, 0.5684210526315789, 0.3999999999999999), (0.8, 0.6105263157894738, 0.3999999999999999), (0.8, 0.6526315789473681, 0.3999999999999999), (0.8, 0.6947368421052631, 0.3999999999999999), (0.8, 0.736842105263158, 0.3999999999999999), (0.8, 0.7789473684210528, 0.3999999999999999), (0.7789473684210526, 0.8, 0.3999999999999999), (0.7368421052631582, 0.8, 0.3999999999999999), (0.6947368421052633, 0.8, 0.3999999999999999), (0.6526315789473685, 0.8, 0.3999999999999999), (0.610526315789474, 0.8, 0.3999999999999999), (0.5684210526315792, 0.8, 0.3999999999999999), (0.5263157894736843, 0.8, 0.3999999999999999), (0.4842105263157894, 0.8, 0.3999999999999999), (0.4421052631578945, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.44210526315789467), (0.3999999999999999, 0.8, 0.48421052631578954), (0.3999999999999999, 0.8, 0.5263157894736838), (0.3999999999999999, 0.8, 0.5684210526315787), (0.3999999999999999, 0.8, 0.6105263157894737), (0.3999999999999999, 0.8, 0.6526315789473686), (0.3999999999999999, 0.8, 0.6947368421052634), (0.3999999999999999, 0.8, 0.7368421052631577), (0.3999999999999999, 0.8, 0.7789473684210526), (0.3999999999999999, 0.7789473684210526, 0.8), (0.3999999999999999, 0.7368421052631582, 0.8), (0.3999999999999999, 0.6947368421052633, 0.8), (0.3999999999999999, 0.6526315789473685, 0.8), (0.3999999999999999, 0.6105263157894735, 0.8), (0.3999999999999999, 0.5684210526315786, 0.8), (0.3999999999999999, 0.5263157894736843, 0.8), (0.3999999999999999, 0.4842105263157894, 0.8), (0.3999999999999999, 0.4421052631578945, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4421052631578943, 0.3999999999999999, 0.8), (0.48421052631578915, 0.3999999999999999, 0.8), (0.5263157894736841, 0.3999999999999999, 0.8), (0.5684210526315789, 0.3999999999999999, 0.8), (0.6105263157894733, 0.3999999999999999, 0.8), (0.6526315789473681, 0.3999999999999999, 0.8), (0.6947368421052631, 0.3999999999999999, 0.8), (0.7368421052631573, 0.3999999999999999, 0.8), (0.7789473684210522, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7789473684210526), (0.8, 0.3999999999999999, 0.7368421052631576), (0.8, 0.3999999999999999, 0.6947368421052628), (0.8, 0.3999999999999999, 0.6526315789473685), (0.8, 0.3999999999999999, 0.6105263157894735), (0.8, 0.3999999999999999, 0.5684210526315786), (0.8, 0.3999999999999999, 0.5263157894736843), (0.8, 0.3999999999999999, 0.4842105263157894), (0.8, 0.3999999999999999, 0.4421052631578945)],
    58: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4413793103448273, 0.3999999999999999), (0.8, 0.48275862068965525, 0.3999999999999999), (0.8, 0.5241379310344827, 0.3999999999999999), (0.8, 0.5655172413793101, 0.3999999999999999), (0.8, 0.606896551724138, 0.3999999999999999), (0.8, 0.6482758620689655, 0.3999999999999999), (0.8, 0.6896551724137929, 0.3999999999999999), (0.8, 0.7310344827586208, 0.3999999999999999), (0.8, 0.7724137931034483, 0.3999999999999999), (0.7862068965517239, 0.8, 0.3999999999999999), (0.7448275862068965, 0.8, 0.3999999999999999), (0.7034482758620692, 0.8, 0.3999999999999999), (0.6620689655172417, 0.8, 0.3999999999999999), (0.6206896551724138, 0.8, 0.3999999999999999), (0.5793103448275864, 0.8, 0.3999999999999999), (0.5379310344827584, 0.8, 0.3999999999999999), (0.49655172413793097, 0.8, 0.3999999999999999), (0.4551724137931036, 0.8, 0.3999999999999999), (0.41379310344827613, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42758620689655175), (0.3999999999999999, 0.8, 0.46896551724137914), (0.3999999999999999, 0.8, 0.5103448275862071), (0.3999999999999999, 0.8, 0.5517241379310345), (0.3999999999999999, 0.8, 0.5931034482758619), (0.3999999999999999, 0.8, 0.6344827586206894), (0.3999999999999999, 0.8, 0.6758620689655173), (0.3999999999999999, 0.8, 0.7172413793103447), (0.3999999999999999, 0.8, 0.7586206896551726), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7586206896551726, 0.8), (0.3999999999999999, 0.7172413793103452, 0.8), (0.3999999999999999, 0.6758620689655173, 0.8), (0.3999999999999999, 0.6344827586206893, 0.8), (0.3999999999999999, 0.5931034482758618, 0.8), (0.3999999999999999, 0.5517241379310344, 0.8), (0.3999999999999999, 0.510344827586207, 0.8), (0.3999999999999999, 0.4689655172413796, 0.8), (0.3999999999999999, 0.4275862068965516, 0.8), (0.4137931034482759, 0.3999999999999999, 0.8), (0.4551724137931033, 0.3999999999999999, 0.8), (0.49655172413793075, 0.3999999999999999, 0.8), (0.5379310344827581, 0.3999999999999999, 0.8), (0.579310344827586, 0.3999999999999999, 0.8), (0.6206896551724135, 0.3999999999999999, 0.8), (0.6620689655172415, 0.3999999999999999, 0.8), (0.7034482758620688, 0.3999999999999999, 0.8), (0.7448275862068963, 0.3999999999999999, 0.8), (0.7862068965517237, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.772413793103448), (0.8, 0.3999999999999999, 0.7310344827586206), (0.8, 0.3999999999999999, 0.6896551724137927), (0.8, 0.3999999999999999, 0.6482758620689653), (0.8, 0.3999999999999999, 0.6068965517241378), (0.8, 0.3999999999999999, 0.5655172413793104), (0.8, 0.3999999999999999, 0.5241379310344825), (0.8, 0.3999999999999999, 0.482758620689655), (0.8, 0.3999999999999999, 0.4413793103448271)],
    59: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.44067796610169474, 0.3999999999999999), (0.8, 0.48135593220338957, 0.3999999999999999), (0.8, 0.522033898305085, 0.3999999999999999), (0.8, 0.5627118644067797, 0.3999999999999999), (0.8, 0.6033898305084745, 0.3999999999999999), (0.8, 0.6440677966101693, 0.3999999999999999), (0.8, 0.6847457627118643, 0.3999999999999999), (0.8, 0.7254237288135595, 0.3999999999999999), (0.8, 0.7661016949152544, 0.3999999999999999), (0.793220338983051, 0.8, 0.3999999999999999), (0.7525423728813562, 0.8, 0.3999999999999999), (0.7118644067796613, 0.8, 0.3999999999999999), (0.671186440677966, 0.8, 0.3999999999999999), (0.6305084745762712, 0.8, 0.3999999999999999), (0.5898305084745764, 0.8, 0.3999999999999999), (0.5491525423728816, 0.8, 0.3999999999999999), (0.5084745762711862, 0.8, 0.3999999999999999), (0.46779661016949137, 0.8, 0.3999999999999999), (0.42711864406779654, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4135593220338982), (0.3999999999999999, 0.8, 0.45423728813559305), (0.3999999999999999, 0.8, 0.4949152542372879), (0.3999999999999999, 0.8, 0.5355932203389833), (0.3999999999999999, 0.8, 0.576271186440678), (0.3999999999999999, 0.8, 0.6169491525423729), (0.3999999999999999, 0.8, 0.6576271186440676), (0.3999999999999999, 0.8, 0.698305084745763), (0.3999999999999999, 0.8, 0.7389830508474579), (0.3999999999999999, 0.8, 0.7796610169491527), (0.3999999999999999, 0.7796610169491525, 0.8), (0.3999999999999999, 0.7389830508474577, 0.8), (0.3999999999999999, 0.6983050847457629, 0.8), (0.3999999999999999, 0.6576271186440681, 0.8), (0.3999999999999999, 0.6169491525423727, 0.8), (0.3999999999999999, 0.5762711864406779, 0.8), (0.3999999999999999, 0.5355932203389826, 0.8), (0.3999999999999999, 0.4949152542372877, 0.8), (0.3999999999999999, 0.45423728813559294, 0.8), (0.3999999999999999, 0.4135593220338981, 0.8), (0.42711864406779626, 0.3999999999999999, 0.8), (0.4677966101694911, 0.3999999999999999, 0.8), (0.508474576271186, 0.3999999999999999, 0.8), (0.5491525423728807, 0.3999999999999999, 0.8), (0.5898305084745761, 0.3999999999999999, 0.8), (0.6305084745762709, 0.3999999999999999, 0.8), (0.6711864406779663, 0.3999999999999999, 0.8), (0.7118644067796611, 0.3999999999999999, 0.8), (0.7525423728813558, 0.3999999999999999, 0.8), (0.7932203389830508, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7661016949152541), (0.8, 0.3999999999999999, 0.7254237288135592), (0.8, 0.3999999999999999, 0.6847457627118645), (0.8, 0.3999999999999999, 0.6440677966101691), (0.8, 0.3999999999999999, 0.6033898305084743), (0.8, 0.3999999999999999, 0.5627118644067794), (0.8, 0.3999999999999999, 0.5220338983050841), (0.8, 0.3999999999999999, 0.4813559322033893), (0.8, 0.3999999999999999, 0.44067796610169446)],
    60: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4399999999999998, 0.3999999999999999), (0.8, 0.4800000000000002, 0.3999999999999999), (0.8, 0.52, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6800000000000002, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.8, 0.7599999999999998, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.76, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6799999999999998, 0.8, 0.3999999999999999), (0.6399999999999999, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.5200000000000004, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.44000000000000006, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.44000000000000017), (0.3999999999999999, 0.8, 0.48000000000000004), (0.3999999999999999, 0.8, 0.5199999999999999), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.6000000000000002), (0.3999999999999999, 0.8, 0.6400000000000001), (0.3999999999999999, 0.8, 0.6799999999999999), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.8, 0.7600000000000002), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.76, 0.8), (0.3999999999999999, 0.7200000000000002, 0.8), (0.3999999999999999, 0.6799999999999998, 0.8), (0.3999999999999999, 0.6399999999999999, 0.8), (0.3999999999999999, 0.5999999999999995, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5199999999999998, 0.8), (0.3999999999999999, 0.4799999999999999, 0.8), (0.3999999999999999, 0.44000000000000006, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4399999999999998, 0.3999999999999999, 0.8), (0.47999999999999965, 0.3999999999999999, 0.8), (0.52, 0.3999999999999999, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6399999999999997, 0.3999999999999999, 0.8), (0.6799999999999995, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7599999999999998, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7599999999999996), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.6799999999999998), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5599999999999996), (0.8, 0.3999999999999999, 0.5199999999999998), (0.8, 0.3999999999999999, 0.47999999999999937), (0.8, 0.3999999999999999, 0.4399999999999995)],
    61: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.43934426229508194, 0.3999999999999999), (0.8, 0.478688524590164, 0.3999999999999999), (0.8, 0.518032786885246, 0.3999999999999999), (0.8, 0.557377049180328, 0.3999999999999999), (0.8, 0.5967213114754101, 0.3999999999999999), (0.8, 0.6360655737704921, 0.3999999999999999), (0.8, 0.6754098360655736, 0.3999999999999999), (0.8, 0.7147540983606555, 0.3999999999999999), (0.8, 0.7540983606557377, 0.3999999999999999), (0.8, 0.7934426229508196, 0.3999999999999999), (0.7672131147540986, 0.8, 0.3999999999999999), (0.7278688524590164, 0.8, 0.3999999999999999), (0.6885245901639345, 0.8, 0.3999999999999999), (0.6491803278688525, 0.8, 0.3999999999999999), (0.6098360655737705, 0.8, 0.3999999999999999), (0.5704918032786884, 0.8, 0.3999999999999999), (0.5311475409836064, 0.8, 0.3999999999999999), (0.4918032786885249, 0.8, 0.3999999999999999), (0.4524590163934423, 0.8, 0.3999999999999999), (0.41311475409836085, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4262295081967211), (0.3999999999999999, 0.8, 0.46557377049180315), (0.3999999999999999, 0.8, 0.5049180327868852), (0.3999999999999999, 0.8, 0.5442622950819672), (0.3999999999999999, 0.8, 0.5836065573770493), (0.3999999999999999, 0.8, 0.6229508196721313), (0.3999999999999999, 0.8, 0.6622950819672133), (0.3999999999999999, 0.8, 0.7016393442622952), (0.3999999999999999, 0.8, 0.7409836065573774), (0.3999999999999999, 0.8, 0.7803278688524593), (0.3999999999999999, 0.7803278688524593, 0.8), (0.3999999999999999, 0.7409836065573767, 0.8), (0.3999999999999999, 0.7016393442622952, 0.8), (0.3999999999999999, 0.6622950819672127, 0.8), (0.3999999999999999, 0.6229508196721312, 0.8), (0.3999999999999999, 0.583606557377049, 0.8), (0.3999999999999999, 0.5442622950819671, 0.8), (0.3999999999999999, 0.5049180327868851, 0.8), (0.3999999999999999, 0.46557377049180304, 0.8), (0.3999999999999999, 0.426229508196721, 0.8), (0.41311475409836057, 0.3999999999999999, 0.8), (0.4524590163934421, 0.3999999999999999, 0.8), (0.49180327868852464, 0.3999999999999999, 0.8), (0.5311475409836062, 0.3999999999999999, 0.8), (0.5704918032786886, 0.3999999999999999, 0.8), (0.6098360655737701, 0.3999999999999999, 0.8), (0.6491803278688527, 0.3999999999999999, 0.8), (0.6885245901639343, 0.3999999999999999, 0.8), (0.7278688524590162, 0.3999999999999999, 0.8), (0.7672131147540983, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7934426229508194), (0.8, 0.3999999999999999, 0.7540983606557373), (0.8, 0.3999999999999999, 0.7147540983606553), (0.8, 0.3999999999999999, 0.6754098360655734), (0.8, 0.3999999999999999, 0.6360655737704918), (0.8, 0.3999999999999999, 0.5967213114754092), (0.8, 0.3999999999999999, 0.5573770491803277), (0.8, 0.3999999999999999, 0.5180327868852452), (0.8, 0.3999999999999999, 0.4786885245901637), (0.8, 0.3999999999999999, 0.4393442622950811)],
    62: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.43870967741935474, 0.3999999999999999), (0.8, 0.47741935483870956, 0.3999999999999999), (0.8, 0.5161290322580644, 0.3999999999999999), (0.8, 0.5548387096774192, 0.3999999999999999), (0.8, 0.593548387096774, 0.3999999999999999), (0.8, 0.6322580645161289, 0.3999999999999999), (0.8, 0.6709677419354836, 0.3999999999999999), (0.8, 0.7096774193548385, 0.3999999999999999), (0.8, 0.7483870967741932, 0.3999999999999999), (0.8, 0.7870967741935486, 0.3999999999999999), (0.7741935483870968, 0.8, 0.3999999999999999), (0.7354838709677419, 0.8, 0.3999999999999999), (0.6967741935483871, 0.8, 0.3999999999999999), (0.6580645161290323, 0.8, 0.3999999999999999), (0.6193548387096774, 0.8, 0.3999999999999999), (0.5806451612903226, 0.8, 0.3999999999999999), (0.5419354838709678, 0.8, 0.3999999999999999), (0.5032258064516131, 0.8, 0.3999999999999999), (0.4645161290322582, 0.8, 0.3999999999999999), (0.42580645161290337, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4129032258064514), (0.3999999999999999, 0.8, 0.4516129032258067), (0.3999999999999999, 0.8, 0.49032258064516154), (0.3999999999999999, 0.8, 0.5290322580645164), (0.3999999999999999, 0.8, 0.5677419354838712), (0.3999999999999999, 0.8, 0.606451612903226), (0.3999999999999999, 0.8, 0.6451612903225808), (0.3999999999999999, 0.8, 0.6838709677419357), (0.3999999999999999, 0.8, 0.7225806451612904), (0.3999999999999999, 0.8, 0.7612903225806453), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7612903225806451, 0.8), (0.3999999999999999, 0.7225806451612904, 0.8), (0.3999999999999999, 0.6838709677419355, 0.8), (0.3999999999999999, 0.6451612903225807, 0.8), (0.3999999999999999, 0.6064516129032259, 0.8), (0.3999999999999999, 0.5677419354838711, 0.8), (0.3999999999999999, 0.5290322580645163, 0.8), (0.3999999999999999, 0.49032258064516143, 0.8), (0.3999999999999999, 0.4516129032258066, 0.8), (0.3999999999999999, 0.4129032258064518, 0.8), (0.4258064516129026, 0.3999999999999999, 0.8), (0.4645161290322574, 0.3999999999999999, 0.8), (0.5032258064516127, 0.3999999999999999, 0.8), (0.5419354838709676, 0.3999999999999999, 0.8), (0.5806451612903224, 0.3999999999999999, 0.8), (0.6193548387096772, 0.3999999999999999, 0.8), (0.658064516129032, 0.3999999999999999, 0.8), (0.6967741935483869, 0.3999999999999999, 0.8), (0.7354838709677416, 0.3999999999999999, 0.8), (0.7741935483870965, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7870967741935484), (0.8, 0.3999999999999999, 0.748387096774193), (0.8, 0.3999999999999999, 0.7096774193548382), (0.8, 0.3999999999999999, 0.6709677419354834), (0.8, 0.3999999999999999, 0.6322580645161285), (0.8, 0.3999999999999999, 0.5935483870967737), (0.8, 0.3999999999999999, 0.5548387096774189), (0.8, 0.3999999999999999, 0.5161290322580641), (0.8, 0.3999999999999999, 0.4774193548387093), (0.8, 0.3999999999999999, 0.43870967741935446)],
    63: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.43809523809523787, 0.3999999999999999), (0.8, 0.47619047619047583, 0.3999999999999999), (0.8, 0.5142857142857143, 0.3999999999999999), (0.8, 0.5523809523809523, 0.3999999999999999), (0.8, 0.5904761904761903, 0.3999999999999999), (0.8, 0.6285714285714288, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.7047619047619047, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7809523809523806, 0.3999999999999999), (0.7809523809523811, 0.8, 0.3999999999999999), (0.742857142857143, 0.8, 0.3999999999999999), (0.704761904761905, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6285714285714286, 0.8, 0.3999999999999999), (0.5904761904761906, 0.8, 0.3999999999999999), (0.5523809523809526, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.4761904761904761, 0.8, 0.3999999999999999), (0.43809523809523815, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.43809523809523826), (0.3999999999999999, 0.8, 0.4761904761904763), (0.3999999999999999, 0.8, 0.5142857142857142), (0.3999999999999999, 0.8, 0.5523809523809522), (0.3999999999999999, 0.8, 0.5904761904761902), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.7047619047619047), (0.3999999999999999, 0.8, 0.7428571428571431), (0.3999999999999999, 0.8, 0.7809523809523811), (0.3999999999999999, 0.7809523809523811, 0.8), (0.3999999999999999, 0.742857142857143, 0.8), (0.3999999999999999, 0.704761904761905, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.5904761904761906, 0.8), (0.3999999999999999, 0.5523809523809521, 0.8), (0.3999999999999999, 0.5142857142857141, 0.8), (0.3999999999999999, 0.4761904761904761, 0.8), (0.3999999999999999, 0.43809523809523815, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.43809523809523787, 0.3999999999999999, 0.8), (0.47619047619047583, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5523809523809523, 0.3999999999999999, 0.8), (0.5904761904761903, 0.3999999999999999, 0.8), (0.6285714285714283, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.7047619047619043, 0.3999999999999999, 0.8), (0.7428571428571427, 0.3999999999999999, 0.8), (0.7809523809523806, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7809523809523811), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7047619047619045), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6285714285714286), (0.8, 0.3999999999999999, 0.5904761904761906), (0.8, 0.3999999999999999, 0.5523809523809521), (0.8, 0.3999999999999999, 0.5142857142857141), (0.8, 0.3999999999999999, 0.4761904761904761), (0.8, 0.3999999999999999, 0.4380952380952376)],
    64: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.43749999999999994, 0.3999999999999999), (0.8, 0.4749999999999999, 0.3999999999999999), (0.8, 0.5125, 0.3999999999999999), (0.8, 0.5499999999999999, 0.3999999999999999), (0.8, 0.5875, 0.3999999999999999), (0.8, 0.625, 0.3999999999999999), (0.8, 0.6625, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7375, 0.3999999999999999), (0.8, 0.7750000000000001, 0.3999999999999999), (0.7875000000000001, 0.8, 0.3999999999999999), (0.7500000000000001, 0.8, 0.3999999999999999), (0.7125000000000001, 0.8, 0.3999999999999999), (0.675, 0.8, 0.3999999999999999), (0.6375000000000001, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5625, 0.8, 0.3999999999999999), (0.525, 0.8, 0.3999999999999999), (0.48750000000000004, 0.8, 0.3999999999999999), (0.45, 0.8, 0.3999999999999999), (0.4125, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42499999999999993), (0.3999999999999999, 0.8, 0.46249999999999997), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5375), (0.3999999999999999, 0.8, 0.575), (0.3999999999999999, 0.8, 0.6125), (0.3999999999999999, 0.8, 0.65), (0.3999999999999999, 0.8, 0.6875), (0.3999999999999999, 0.8, 0.7250000000000001), (0.3999999999999999, 0.8, 0.7625000000000001), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7625, 0.8), (0.3999999999999999, 0.7249999999999999, 0.8), (0.3999999999999999, 0.6875, 0.8), (0.3999999999999999, 0.6499999999999999, 0.8), (0.3999999999999999, 0.6124999999999999, 0.8), (0.3999999999999999, 0.5749999999999998, 0.8), (0.3999999999999999, 0.5374999999999999, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.46249999999999986, 0.8), (0.3999999999999999, 0.4249999999999998, 0.8), (0.41249999999999976, 0.3999999999999999, 0.8), (0.44999999999999973, 0.3999999999999999, 0.8), (0.48749999999999977, 0.3999999999999999, 0.8), (0.5249999999999998, 0.3999999999999999, 0.8), (0.5624999999999998, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6374999999999998, 0.3999999999999999, 0.8), (0.6749999999999998, 0.3999999999999999, 0.8), (0.7124999999999999, 0.3999999999999999, 0.8), (0.7499999999999998, 0.3999999999999999, 0.8), (0.7874999999999999, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7749999999999998), (0.8, 0.3999999999999999, 0.7374999999999998), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6624999999999998), (0.8, 0.3999999999999999, 0.6249999999999998), (0.8, 0.3999999999999999, 0.5874999999999997), (0.8, 0.3999999999999999, 0.5499999999999997), (0.8, 0.3999999999999999, 0.5124999999999997), (0.8, 0.3999999999999999, 0.47499999999999964), (0.8, 0.3999999999999999, 0.43749999999999967)],
    65: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4369230769230767, 0.3999999999999999), (0.8, 0.47384615384615353, 0.3999999999999999), (0.8, 0.5107692307692309, 0.3999999999999999), (0.8, 0.5476923076923077, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.6215384615384618, 0.3999999999999999), (0.8, 0.6584615384615387, 0.3999999999999999), (0.8, 0.6953846153846155, 0.3999999999999999), (0.8, 0.7323076923076922, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.7938461538461539, 0.8, 0.3999999999999999), (0.756923076923077, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6830769230769229, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.6092307692307692, 0.8, 0.3999999999999999), (0.5723076923076924, 0.8, 0.3999999999999999), (0.5353846153846157, 0.8, 0.3999999999999999), (0.49846153846153834, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.42461538461538473, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4123076923076926), (0.3999999999999999, 0.8, 0.4492307692307694), (0.3999999999999999, 0.8, 0.48615384615384616), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5969230769230771), (0.3999999999999999, 0.8, 0.633846153846154), (0.3999999999999999, 0.8, 0.6707692307692308), (0.3999999999999999, 0.8, 0.7076923076923081), (0.3999999999999999, 0.8, 0.7446153846153849), (0.3999999999999999, 0.8, 0.7815384615384617), (0.3999999999999999, 0.7815384615384615, 0.8), (0.3999999999999999, 0.7446153846153847, 0.8), (0.3999999999999999, 0.7076923076923074, 0.8), (0.3999999999999999, 0.6707692307692306, 0.8), (0.3999999999999999, 0.6338461538461538, 0.8), (0.3999999999999999, 0.5969230769230764, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.48615384615384605, 0.8), (0.3999999999999999, 0.44923076923076927, 0.8), (0.3999999999999999, 0.41230769230769193, 0.8), (0.42461538461538445, 0.3999999999999999, 0.8), (0.46153846153846123, 0.3999999999999999, 0.8), (0.49846153846153857, 0.3999999999999999, 0.8), (0.5353846153846153, 0.3999999999999999, 0.8), (0.5723076923076922, 0.3999999999999999, 0.8), (0.609230769230769, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.6830769230769231, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7569230769230768, 0.3999999999999999, 0.8), (0.7938461538461541, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7323076923076919), (0.8, 0.3999999999999999, 0.6953846153846152), (0.8, 0.3999999999999999, 0.6584615384615383), (0.8, 0.3999999999999999, 0.621538461538461), (0.8, 0.3999999999999999, 0.5846153846153842), (0.8, 0.3999999999999999, 0.5476923076923074), (0.8, 0.3999999999999999, 0.5107692307692301), (0.8, 0.3999999999999999, 0.47384615384615325), (0.8, 0.3999999999999999, 0.43692307692307647)],
    66: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.43636363636363623, 0.3999999999999999), (0.8, 0.4727272727272726, 0.3999999999999999), (0.8, 0.5090909090909089, 0.3999999999999999), (0.8, 0.5454545454545453, 0.3999999999999999), (0.8, 0.5818181818181816, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6545454545454543, 0.3999999999999999), (0.8, 0.6909090909090907, 0.3999999999999999), (0.8, 0.7272727272727271, 0.3999999999999999), (0.8, 0.7636363636363639, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7272727272727273, 0.8, 0.3999999999999999), (0.6909090909090909, 0.8, 0.3999999999999999), (0.6545454545454545, 0.8, 0.3999999999999999), (0.6181818181818183, 0.8, 0.3999999999999999), (0.5818181818181819, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5090909090909093, 0.8, 0.3999999999999999), (0.4727272727272729, 0.8, 0.3999999999999999), (0.4363636363636365, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.4363636363636367), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.5090909090909094), (0.3999999999999999, 0.8, 0.5454545454545456), (0.3999999999999999, 0.8, 0.581818181818182), (0.3999999999999999, 0.8, 0.6181818181818184), (0.3999999999999999, 0.8, 0.6545454545454548), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7272727272727274), (0.3999999999999999, 0.8, 0.7636363636363638), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7636363636363637, 0.8), (0.3999999999999999, 0.7272727272727273, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6545454545454545, 0.8), (0.3999999999999999, 0.6181818181818183, 0.8), (0.3999999999999999, 0.5818181818181819, 0.8), (0.3999999999999999, 0.5454545454545455, 0.8), (0.3999999999999999, 0.5090909090909093, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.4363636363636365, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.43636363636363623, 0.3999999999999999, 0.8), (0.4727272727272726, 0.3999999999999999, 0.8), (0.5090909090909089, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5818181818181816, 0.3999999999999999, 0.8), (0.6181818181818179, 0.3999999999999999, 0.8), (0.6545454545454543, 0.3999999999999999, 0.8), (0.6909090909090907, 0.3999999999999999, 0.8), (0.7272727272727275, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7636363636363631), (0.8, 0.3999999999999999, 0.7272727272727267), (0.8, 0.3999999999999999, 0.6909090909090905), (0.8, 0.3999999999999999, 0.6545454545454541), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.5818181818181813), (0.8, 0.3999999999999999, 0.545454545454545), (0.8, 0.3999999999999999, 0.5090909090909087), (0.8, 0.3999999999999999, 0.47272727272727233), (0.8, 0.3999999999999999, 0.436363636363636)],
    67: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.43582089552238806, 0.3999999999999999), (0.8, 0.47164179104477627, 0.3999999999999999), (0.8, 0.5074626865671639, 0.3999999999999999), (0.8, 0.5432835820895521, 0.3999999999999999), (0.8, 0.5791044776119403, 0.3999999999999999), (0.8, 0.6149253731343285, 0.3999999999999999), (0.8, 0.6507462686567166, 0.3999999999999999), (0.8, 0.6865671641791042, 0.3999999999999999), (0.8, 0.7223880597014924, 0.3999999999999999), (0.8, 0.7582089552238807, 0.3999999999999999), (0.8, 0.7940298507462689, 0.3999999999999999), (0.7701492537313432, 0.8, 0.3999999999999999), (0.7343283582089556, 0.8, 0.3999999999999999), (0.6985074626865675, 0.8, 0.3999999999999999), (0.6626865671641793, 0.8, 0.3999999999999999), (0.6268656716417911, 0.8, 0.3999999999999999), (0.5910447761194029, 0.8, 0.3999999999999999), (0.5552238805970152, 0.8, 0.3999999999999999), (0.5194029850746271, 0.8, 0.3999999999999999), (0.4835820895522389, 0.8, 0.3999999999999999), (0.4477611940298507, 0.8, 0.3999999999999999), (0.41194029850746255, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42388059701492503), (0.3999999999999999, 0.8, 0.45970149253731324), (0.3999999999999999, 0.8, 0.4955223880597014), (0.3999999999999999, 0.8, 0.5313432835820896), (0.3999999999999999, 0.8, 0.5671641791044777), (0.3999999999999999, 0.8, 0.6029850746268653), (0.3999999999999999, 0.8, 0.6388059701492536), (0.3999999999999999, 0.8, 0.6746268656716418), (0.3999999999999999, 0.8, 0.7104477611940299), (0.3999999999999999, 0.8, 0.7462686567164181), (0.3999999999999999, 0.8, 0.7820895522388058), (0.3999999999999999, 0.7820895522388056, 0.8), (0.3999999999999999, 0.746268656716418, 0.8), (0.3999999999999999, 0.7104477611940299, 0.8), (0.3999999999999999, 0.6746268656716417, 0.8), (0.3999999999999999, 0.638805970149254, 0.8), (0.3999999999999999, 0.6029850746268652, 0.8), (0.3999999999999999, 0.5671641791044776, 0.8), (0.3999999999999999, 0.5313432835820895, 0.8), (0.3999999999999999, 0.4955223880597013, 0.8), (0.3999999999999999, 0.4597014925373136, 0.8), (0.3999999999999999, 0.4238805970149249, 0.8), (0.4119402985074623, 0.3999999999999999, 0.8), (0.4477611940298505, 0.3999999999999999, 0.8), (0.48358208955223864, 0.3999999999999999, 0.8), (0.5194029850746262, 0.3999999999999999, 0.8), (0.555223880597015, 0.3999999999999999, 0.8), (0.5910447761194026, 0.3999999999999999, 0.8), (0.6268656716417909, 0.3999999999999999, 0.8), (0.6626865671641791, 0.3999999999999999, 0.8), (0.6985074626865666, 0.3999999999999999, 0.8), (0.7343283582089553, 0.3999999999999999, 0.8), (0.770149253731343, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7940298507462684), (0.8, 0.3999999999999999, 0.7582089552238803), (0.8, 0.3999999999999999, 0.7223880597014927), (0.8, 0.3999999999999999, 0.686567164179104), (0.8, 0.3999999999999999, 0.6507462686567164), (0.8, 0.3999999999999999, 0.6149253731343282), (0.8, 0.3999999999999999, 0.57910447761194), (0.8, 0.3999999999999999, 0.5432835820895523), (0.8, 0.3999999999999999, 0.5074626865671636), (0.8, 0.3999999999999999, 0.471641791044776), (0.8, 0.3999999999999999, 0.43582089552238784)],
    68: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4352941176470586, 0.3999999999999999), (0.8, 0.4705882352941173, 0.3999999999999999), (0.8, 0.5058823529411766, 0.3999999999999999), (0.8, 0.5411764705882353, 0.3999999999999999), (0.8, 0.576470588235294, 0.3999999999999999), (0.8, 0.6117647058823527, 0.3999999999999999), (0.8, 0.6470588235294119, 0.3999999999999999), (0.8, 0.6823529411764706, 0.3999999999999999), (0.8, 0.7176470588235293, 0.3999999999999999), (0.8, 0.752941176470588, 0.3999999999999999), (0.8, 0.7882352941176474, 0.3999999999999999), (0.7764705882352942, 0.8, 0.3999999999999999), (0.7411764705882354, 0.8, 0.3999999999999999), (0.7058823529411767, 0.8, 0.3999999999999999), (0.6705882352941175, 0.8, 0.3999999999999999), (0.6352941176470588, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5647058823529414, 0.8, 0.3999999999999999), (0.5294117647058827, 0.8, 0.3999999999999999), (0.4941176470588234, 0.8, 0.3999999999999999), (0.4588235294117647, 0.8, 0.3999999999999999), (0.423529411764706, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4117647058823532), (0.3999999999999999, 0.8, 0.44705882352941195), (0.3999999999999999, 0.8, 0.48235294117647065), (0.3999999999999999, 0.8, 0.5176470588235293), (0.3999999999999999, 0.8, 0.552941176470588), (0.3999999999999999, 0.8, 0.5882352941176467), (0.3999999999999999, 0.8, 0.623529411764706), (0.3999999999999999, 0.8, 0.6588235294117647), (0.3999999999999999, 0.8, 0.6941176470588235), (0.3999999999999999, 0.8, 0.7294117647058826), (0.3999999999999999, 0.8, 0.7647058823529413), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7647058823529412, 0.8), (0.3999999999999999, 0.7294117647058825, 0.8), (0.3999999999999999, 0.6941176470588238, 0.8), (0.3999999999999999, 0.6588235294117646, 0.8), (0.3999999999999999, 0.6235294117647059, 0.8), (0.3999999999999999, 0.5882352941176466, 0.8), (0.3999999999999999, 0.5529411764705879, 0.8), (0.3999999999999999, 0.5176470588235292, 0.8), (0.3999999999999999, 0.4823529411764705, 0.8), (0.3999999999999999, 0.4470588235294118, 0.8), (0.3999999999999999, 0.4117647058823531, 0.8), (0.4235294117647057, 0.3999999999999999, 0.8), (0.4588235294117644, 0.3999999999999999, 0.8), (0.49411764705882316, 0.3999999999999999, 0.8), (0.5294117647058824, 0.3999999999999999, 0.8), (0.5647058823529411, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6352941176470586, 0.3999999999999999, 0.8), (0.6705882352941173, 0.3999999999999999, 0.8), (0.705882352941176, 0.3999999999999999, 0.8), (0.7411764705882351, 0.3999999999999999, 0.8), (0.7764705882352938, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7882352941176465), (0.8, 0.3999999999999999, 0.7529411764705878), (0.8, 0.3999999999999999, 0.7176470588235291), (0.8, 0.3999999999999999, 0.6823529411764704), (0.8, 0.3999999999999999, 0.6470588235294117), (0.8, 0.3999999999999999, 0.611764705882353), (0.8, 0.3999999999999999, 0.5764705882352937), (0.8, 0.3999999999999999, 0.541176470588235), (0.8, 0.3999999999999999, 0.5058823529411763), (0.8, 0.3999999999999999, 0.4705882352941171), (0.8, 0.3999999999999999, 0.43529411764705833)],
    69: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4347826086956523, 0.3999999999999999), (0.8, 0.4695652173913041, 0.3999999999999999), (0.8, 0.5043478260869564, 0.3999999999999999), (0.8, 0.5391304347826087, 0.3999999999999999), (0.8, 0.5739130434782611, 0.3999999999999999), (0.8, 0.6086956521739129, 0.3999999999999999), (0.8, 0.6434782608695653, 0.3999999999999999), (0.8, 0.6782608695652176, 0.3999999999999999), (0.8, 0.7130434782608694, 0.3999999999999999), (0.8, 0.7478260869565216, 0.3999999999999999), (0.8, 0.7826086956521741, 0.3999999999999999), (0.7826086956521743, 0.8, 0.3999999999999999), (0.747826086956522, 0.8, 0.3999999999999999), (0.7130434782608697, 0.8, 0.3999999999999999), (0.6782608695652173, 0.8, 0.3999999999999999), (0.6434782608695655, 0.8, 0.3999999999999999), (0.6086956521739132, 0.8, 0.3999999999999999), (0.5739130434782608, 0.8, 0.3999999999999999), (0.539130434782609, 0.8, 0.3999999999999999), (0.5043478260869567, 0.8, 0.3999999999999999), (0.4695652173913043, 0.8, 0.3999999999999999), (0.434782608695652, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4347826086956521), (0.3999999999999999, 0.8, 0.46956521739130447), (0.3999999999999999, 0.8, 0.5043478260869563), (0.3999999999999999, 0.8, 0.5391304347826086), (0.3999999999999999, 0.8, 0.5739130434782609), (0.3999999999999999, 0.8, 0.6086956521739133), (0.3999999999999999, 0.8, 0.643478260869565), (0.3999999999999999, 0.8, 0.6782608695652175), (0.3999999999999999, 0.8, 0.7130434782608698), (0.3999999999999999, 0.8, 0.7478260869565216), (0.3999999999999999, 0.8, 0.7826086956521738), (0.3999999999999999, 0.7826086956521738, 0.8), (0.3999999999999999, 0.7478260869565214, 0.8), (0.3999999999999999, 0.7130434782608691, 0.8), (0.3999999999999999, 0.6782608695652173, 0.8), (0.3999999999999999, 0.6434782608695655, 0.8), (0.3999999999999999, 0.6086956521739132, 0.8), (0.3999999999999999, 0.5739130434782608, 0.8), (0.3999999999999999, 0.5391304347826085, 0.8), (0.3999999999999999, 0.5043478260869562, 0.8), (0.3999999999999999, 0.4695652173913038, 0.8), (0.3999999999999999, 0.434782608695652, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4347826086956517, 0.3999999999999999, 0.8), (0.4695652173913041, 0.3999999999999999, 0.8), (0.5043478260869564, 0.3999999999999999, 0.8), (0.5391304347826087, 0.3999999999999999, 0.8), (0.5739130434782611, 0.3999999999999999, 0.8), (0.6086956521739129, 0.3999999999999999, 0.8), (0.6434782608695647, 0.3999999999999999, 0.8), (0.678260869565217, 0.3999999999999999, 0.8), (0.7130434782608694, 0.3999999999999999, 0.8), (0.7478260869565216, 0.3999999999999999, 0.8), (0.7826086956521741, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7826086956521738), (0.8, 0.3999999999999999, 0.7478260869565214), (0.8, 0.3999999999999999, 0.7130434782608697), (0.8, 0.3999999999999999, 0.6782608695652173), (0.8, 0.3999999999999999, 0.6434782608695649), (0.8, 0.3999999999999999, 0.6086956521739126), (0.8, 0.3999999999999999, 0.5739130434782602), (0.8, 0.3999999999999999, 0.5391304347826085), (0.8, 0.3999999999999999, 0.5043478260869562), (0.8, 0.3999999999999999, 0.4695652173913043), (0.8, 0.3999999999999999, 0.434782608695652)],
    70: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4342857142857141, 0.3999999999999999), (0.8, 0.46857142857142825, 0.3999999999999999), (0.8, 0.502857142857143, 0.3999999999999999), (0.8, 0.5371428571428571, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.6057142857142855, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6742857142857144, 0.3999999999999999), (0.8, 0.7085714285714286, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7771428571428569, 0.3999999999999999), (0.7885714285714285, 0.8, 0.3999999999999999), (0.7542857142857144, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.685714285714286, 0.8, 0.3999999999999999), (0.6514285714285714, 0.8, 0.3999999999999999), (0.6171428571428572, 0.8, 0.3999999999999999), (0.582857142857143, 0.8, 0.3999999999999999), (0.5485714285714288, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.44571428571428573, 0.8, 0.3999999999999999), (0.4114285714285716, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4228571428571431), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.49142857142857144), (0.3999999999999999, 0.8, 0.5257142857142856), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.594285714285714), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6628571428571428), (0.3999999999999999, 0.8, 0.6971428571428571), (0.3999999999999999, 0.8, 0.7314285714285718), (0.3999999999999999, 0.8, 0.7657142857142859), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7657142857142858, 0.8), (0.3999999999999999, 0.7314285714285715, 0.8), (0.3999999999999999, 0.6971428571428575, 0.8), (0.3999999999999999, 0.6628571428571428, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.5942857142857139, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5257142857142855, 0.8), (0.3999999999999999, 0.4914285714285713, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.3999999999999999, 0.42285714285714293, 0.8), (0.41142857142857076, 0.3999999999999999, 0.8), (0.4457142857142855, 0.3999999999999999, 0.8), (0.47999999999999965, 0.3999999999999999, 0.8), (0.5142857142857143, 0.3999999999999999, 0.8), (0.5485714285714285, 0.3999999999999999, 0.8), (0.5828571428571427, 0.3999999999999999, 0.8), (0.6171428571428569, 0.3999999999999999, 0.8), (0.651428571428571, 0.3999999999999999, 0.8), (0.6857142857142853, 0.3999999999999999, 0.8), (0.7199999999999994, 0.3999999999999999, 0.8), (0.7542857142857141, 0.3999999999999999, 0.8), (0.7885714285714283, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7771428571428567), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7085714285714283), (0.8, 0.3999999999999999, 0.6742857142857142), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6057142857142858), (0.8, 0.3999999999999999, 0.5714285714285716), (0.8, 0.3999999999999999, 0.5371428571428569), (0.8, 0.3999999999999999, 0.5028571428571427), (0.8, 0.3999999999999999, 0.468571428571428), (0.8, 0.3999999999999999, 0.43428571428571383)],
    71: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4338028169014083, 0.3999999999999999), (0.8, 0.4676056338028167, 0.3999999999999999), (0.8, 0.5014084507042251, 0.3999999999999999), (0.8, 0.5352112676056335, 0.3999999999999999), (0.8, 0.5690140845070419, 0.3999999999999999), (0.8, 0.6028169014084505, 0.3999999999999999), (0.8, 0.6366197183098594, 0.3999999999999999), (0.8, 0.6704225352112678, 0.3999999999999999), (0.8, 0.7042253521126762, 0.3999999999999999), (0.8, 0.7380281690140846, 0.3999999999999999), (0.8, 0.771830985915493, 0.3999999999999999), (0.7943661971830986, 0.8, 0.3999999999999999), (0.7605633802816902, 0.8, 0.3999999999999999), (0.7267605633802818, 0.8, 0.3999999999999999), (0.6929577464788734, 0.8, 0.3999999999999999), (0.659154929577465, 0.8, 0.3999999999999999), (0.6253521126760562, 0.8, 0.3999999999999999), (0.5915492957746477, 0.8, 0.3999999999999999), (0.5577464788732392, 0.8, 0.3999999999999999), (0.5239436619718308, 0.8, 0.3999999999999999), (0.49014084507042244, 0.8, 0.3999999999999999), (0.45633802816901403, 0.8, 0.3999999999999999), (0.4225352112676056, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41126760563380277), (0.3999999999999999, 0.8, 0.4450704225352112), (0.3999999999999999, 0.8, 0.4788732394366196), (0.3999999999999999, 0.8, 0.512676056338028), (0.3999999999999999, 0.8, 0.5464788732394364), (0.3999999999999999, 0.8, 0.5802816901408449), (0.3999999999999999, 0.8, 0.6140845070422533), (0.3999999999999999, 0.8, 0.6478873239436622), (0.3999999999999999, 0.8, 0.6816901408450706), (0.3999999999999999, 0.8, 0.715492957746479), (0.3999999999999999, 0.8, 0.7492957746478874), (0.3999999999999999, 0.8, 0.7830985915492958), (0.3999999999999999, 0.7830985915492958, 0.8), (0.3999999999999999, 0.7492957746478873, 0.8), (0.3999999999999999, 0.7154929577464784, 0.8), (0.3999999999999999, 0.68169014084507, 0.8), (0.3999999999999999, 0.6478873239436616, 0.8), (0.3999999999999999, 0.6140845070422531, 0.8), (0.3999999999999999, 0.5802816901408447, 0.8), (0.3999999999999999, 0.5464788732394363, 0.8), (0.3999999999999999, 0.5126760563380279, 0.8), (0.3999999999999999, 0.47887323943661947, 0.8), (0.3999999999999999, 0.44507042253521106, 0.8), (0.3999999999999999, 0.4112676056338026, 0.8), (0.42253521126760535, 0.3999999999999999, 0.8), (0.45633802816901375, 0.3999999999999999, 0.8), (0.49014084507042216, 0.3999999999999999, 0.8), (0.5239436619718306, 0.3999999999999999, 0.8), (0.557746478873239, 0.3999999999999999, 0.8), (0.5915492957746474, 0.3999999999999999, 0.8), (0.6253521126760558, 0.3999999999999999, 0.8), (0.6591549295774642, 0.3999999999999999, 0.8), (0.6929577464788732, 0.3999999999999999, 0.8), (0.7267605633802816, 0.3999999999999999, 0.8), (0.76056338028169, 0.3999999999999999, 0.8), (0.7943661971830984, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7718309859154928), (0.8, 0.3999999999999999, 0.7380281690140844), (0.8, 0.3999999999999999, 0.7042253521126753), (0.8, 0.3999999999999999, 0.6704225352112669), (0.8, 0.3999999999999999, 0.6366197183098585), (0.8, 0.3999999999999999, 0.6028169014084501), (0.8, 0.3999999999999999, 0.5690140845070417), (0.8, 0.3999999999999999, 0.5352112676056333), (0.8, 0.3999999999999999, 0.5014084507042249), (0.8, 0.3999999999999999, 0.4676056338028165), (0.8, 0.3999999999999999, 0.43380281690140804)],
    72: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4333333333333331, 0.3999999999999999), (0.8, 0.46666666666666634, 0.3999999999999999), (0.8, 0.5000000000000001, 0.3999999999999999), (0.8, 0.5333333333333333, 0.3999999999999999), (0.8, 0.5666666666666665, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6333333333333335, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7333333333333332, 0.3999999999999999), (0.8, 0.7666666666666665, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7666666666666667, 0.8, 0.3999999999999999), (0.7333333333333335, 0.8, 0.3999999999999999), (0.7000000000000003, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6333333333333333, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5666666666666669, 0.8, 0.3999999999999999), (0.5333333333333337, 0.8, 0.3999999999999999), (0.5000000000000004, 0.8, 0.3999999999999999), (0.4666666666666666, 0.8, 0.3999999999999999), (0.4333333333333334, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4333333333333335), (0.3999999999999999, 0.8, 0.4666666666666668), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5333333333333332), (0.3999999999999999, 0.8, 0.5666666666666664), (0.3999999999999999, 0.8, 0.5999999999999996), (0.3999999999999999, 0.8, 0.6333333333333334), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.7), (0.3999999999999999, 0.8, 0.7333333333333336), (0.3999999999999999, 0.8, 0.7666666666666668), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7666666666666667, 0.8), (0.3999999999999999, 0.7333333333333335, 0.8), (0.3999999999999999, 0.7000000000000003, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6333333333333333, 0.8), (0.3999999999999999, 0.6000000000000001, 0.8), (0.3999999999999999, 0.5666666666666663, 0.8), (0.3999999999999999, 0.5333333333333331, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4666666666666666, 0.8), (0.3999999999999999, 0.4333333333333334, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4333333333333326, 0.3999999999999999, 0.8), (0.46666666666666634, 0.3999999999999999, 0.8), (0.4999999999999996, 0.3999999999999999, 0.8), (0.5333333333333333, 0.3999999999999999, 0.8), (0.5666666666666665, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6333333333333331, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6999999999999995, 0.3999999999999999, 0.8), (0.7333333333333327, 0.3999999999999999, 0.8), (0.7666666666666665, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7666666666666662), (0.8, 0.3999999999999999, 0.733333333333333), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6333333333333333), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5666666666666669), (0.8, 0.3999999999999999, 0.5333333333333331), (0.8, 0.3999999999999999, 0.49999999999999983), (0.8, 0.3999999999999999, 0.4666666666666661), (0.8, 0.3999999999999999, 0.43333333333333285)],
    73: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4328767123287672, 0.3999999999999999), (0.8, 0.46575342465753444, 0.3999999999999999), (0.8, 0.49863013698630115, 0.3999999999999999), (0.8, 0.5315068493150684, 0.3999999999999999), (0.8, 0.5643835616438357, 0.3999999999999999), (0.8, 0.5972602739726024, 0.3999999999999999), (0.8, 0.6301369863013697, 0.3999999999999999), (0.8, 0.6630136986301369, 0.3999999999999999), (0.8, 0.6958904109589042, 0.3999999999999999), (0.8, 0.7287671232876716, 0.3999999999999999), (0.8, 0.7616438356164382, 0.3999999999999999), (0.8, 0.7945205479452055, 0.3999999999999999), (0.7726027397260274, 0.8, 0.3999999999999999), (0.7397260273972607, 0.8, 0.3999999999999999), (0.7068493150684934, 0.8, 0.3999999999999999), (0.6739726027397261, 0.8, 0.3999999999999999), (0.6410958904109589, 0.8, 0.3999999999999999), (0.6082191780821916, 0.8, 0.3999999999999999), (0.5753424657534248, 0.8, 0.3999999999999999), (0.5424657534246576, 0.8, 0.3999999999999999), (0.5095890410958903, 0.8, 0.3999999999999999), (0.4767123287671236, 0.8, 0.3999999999999999), (0.44383561643835634, 0.8, 0.3999999999999999), (0.4109589041095891, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4219178082191781), (0.3999999999999999, 0.8, 0.4547945205479454), (0.3999999999999999, 0.8, 0.4876712328767121), (0.3999999999999999, 0.8, 0.5205479452054794), (0.3999999999999999, 0.8, 0.5534246575342466), (0.3999999999999999, 0.8, 0.5863013698630134), (0.3999999999999999, 0.8, 0.6191780821917807), (0.3999999999999999, 0.8, 0.6520547945205479), (0.3999999999999999, 0.8, 0.6849315068493151), (0.3999999999999999, 0.8, 0.7178082191780825), (0.3999999999999999, 0.8, 0.7506849315068491), (0.3999999999999999, 0.8, 0.7835616438356166), (0.3999999999999999, 0.7835616438356163, 0.8), (0.3999999999999999, 0.7506849315068496, 0.8), (0.3999999999999999, 0.7178082191780824, 0.8), (0.3999999999999999, 0.6849315068493151, 0.8), (0.3999999999999999, 0.6520547945205478, 0.8), (0.3999999999999999, 0.6191780821917805, 0.8), (0.3999999999999999, 0.5863013698630137, 0.8), (0.3999999999999999, 0.5534246575342465, 0.8), (0.3999999999999999, 0.5205479452054793, 0.8), (0.3999999999999999, 0.48767123287671255, 0.8), (0.3999999999999999, 0.4547945205479453, 0.8), (0.3999999999999999, 0.421917808219178, 0.8), (0.4109589041095888, 0.3999999999999999, 0.8), (0.4438356164383561, 0.3999999999999999, 0.8), (0.47671232876712283, 0.3999999999999999, 0.8), (0.5095890410958901, 0.3999999999999999, 0.8), (0.5424657534246573, 0.3999999999999999, 0.8), (0.5753424657534241, 0.3999999999999999, 0.8), (0.6082191780821914, 0.3999999999999999, 0.8), (0.6410958904109586, 0.3999999999999999, 0.8), (0.6739726027397259, 0.3999999999999999, 0.8), (0.7068493150684931, 0.3999999999999999, 0.8), (0.7397260273972599, 0.3999999999999999, 0.8), (0.7726027397260271, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7945205479452053), (0.8, 0.3999999999999999, 0.7616438356164386), (0.8, 0.3999999999999999, 0.7287671232876712), (0.8, 0.3999999999999999, 0.6958904109589039), (0.8, 0.3999999999999999, 0.6630136986301367), (0.8, 0.3999999999999999, 0.6301369863013695), (0.8, 0.3999999999999999, 0.5972602739726027), (0.8, 0.3999999999999999, 0.5643835616438354), (0.8, 0.3999999999999999, 0.5315068493150682), (0.8, 0.3999999999999999, 0.49863013698630143), (0.8, 0.3999999999999999, 0.46575342465753417), (0.8, 0.3999999999999999, 0.4328767123287669)],
    74: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.43243243243243257, 0.3999999999999999), (0.8, 0.46486486486486467, 0.3999999999999999), (0.8, 0.4972972972972973, 0.3999999999999999), (0.8, 0.5297297297297294, 0.3999999999999999), (0.8, 0.5621621621621621, 0.3999999999999999), (0.8, 0.5945945945945947, 0.3999999999999999), (0.8, 0.6270270270270268, 0.3999999999999999), (0.8, 0.6594594594594595, 0.3999999999999999), (0.8, 0.6918918918918922, 0.3999999999999999), (0.8, 0.7243243243243243, 0.3999999999999999), (0.8, 0.7567567567567568, 0.3999999999999999), (0.8, 0.7891891891891896, 0.3999999999999999), (0.7783783783783786, 0.8, 0.3999999999999999), (0.7459459459459459, 0.8, 0.3999999999999999), (0.7135135135135138, 0.8, 0.3999999999999999), (0.6810810810810812, 0.8, 0.3999999999999999), (0.6486486486486485, 0.8, 0.3999999999999999), (0.6162162162162164, 0.8, 0.3999999999999999), (0.5837837837837838, 0.8, 0.3999999999999999), (0.5513513513513516, 0.8, 0.3999999999999999), (0.518918918918919, 0.8, 0.3999999999999999), (0.48648648648648635, 0.8, 0.3999999999999999), (0.4540540540540537, 0.8, 0.3999999999999999), (0.4216216216216216, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4108108108108105), (0.3999999999999999, 0.8, 0.44324324324324316), (0.3999999999999999, 0.8, 0.47567567567567576), (0.3999999999999999, 0.8, 0.5081081081081085), (0.3999999999999999, 0.8, 0.5405405405405406), (0.3999999999999999, 0.8, 0.5729729729729731), (0.3999999999999999, 0.8, 0.6054054054054053), (0.3999999999999999, 0.8, 0.637837837837838), (0.3999999999999999, 0.8, 0.6702702702702705), (0.3999999999999999, 0.8, 0.7027027027027026), (0.3999999999999999, 0.8, 0.7351351351351354), (0.3999999999999999, 0.8, 0.7675675675675675), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7675675675675673, 0.8), (0.3999999999999999, 0.7351351351351347, 0.8), (0.3999999999999999, 0.7027027027027026, 0.8), (0.3999999999999999, 0.6702702702702705, 0.8), (0.3999999999999999, 0.6378378378378378, 0.8), (0.3999999999999999, 0.6054054054054051, 0.8), (0.3999999999999999, 0.5729729729729724, 0.8), (0.3999999999999999, 0.5405405405405403, 0.8), (0.3999999999999999, 0.5081081081081078, 0.8), (0.3999999999999999, 0.47567567567567565, 0.8), (0.3999999999999999, 0.443243243243243, 0.8), (0.3999999999999999, 0.41081081081081033, 0.8), (0.4216216216216213, 0.3999999999999999, 0.8), (0.45405405405405397, 0.3999999999999999, 0.8), (0.48648648648648607, 0.3999999999999999, 0.8), (0.5189189189189187, 0.3999999999999999, 0.8), (0.5513513513513514, 0.3999999999999999, 0.8), (0.583783783783784, 0.3999999999999999, 0.8), (0.6162162162162161, 0.3999999999999999, 0.8), (0.6486486486486482, 0.3999999999999999, 0.8), (0.6810810810810809, 0.3999999999999999, 0.8), (0.7135135135135136, 0.3999999999999999, 0.8), (0.7459459459459461, 0.3999999999999999, 0.8), (0.7783783783783782, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7891891891891887), (0.8, 0.3999999999999999, 0.7567567567567566), (0.8, 0.3999999999999999, 0.724324324324324), (0.8, 0.3999999999999999, 0.6918918918918913), (0.8, 0.3999999999999999, 0.6594594594594592), (0.8, 0.3999999999999999, 0.6270270270270266), (0.8, 0.3999999999999999, 0.5945945945945944), (0.8, 0.3999999999999999, 0.5621621621621617), (0.8, 0.3999999999999999, 0.5297297297297292), (0.8, 0.3999999999999999, 0.4972972972972965), (0.8, 0.3999999999999999, 0.4648648648648644), (0.8, 0.3999999999999999, 0.4324324324324323)],
    75: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4320000000000001, 0.3999999999999999), (0.8, 0.4639999999999998, 0.3999999999999999), (0.8, 0.49600000000000005, 0.3999999999999999), (0.8, 0.5279999999999997, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.5920000000000002, 0.3999999999999999), (0.8, 0.6239999999999999, 0.3999999999999999), (0.8, 0.656, 0.3999999999999999), (0.8, 0.6880000000000003, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.8, 0.7520000000000002, 0.3999999999999999), (0.8, 0.7839999999999998, 0.3999999999999999), (0.784, 0.8, 0.3999999999999999), (0.7519999999999999, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.688, 0.8, 0.3999999999999999), (0.6560000000000004, 0.8, 0.3999999999999999), (0.6240000000000001, 0.8, 0.3999999999999999), (0.5919999999999999, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.528, 0.8, 0.3999999999999999), (0.4959999999999998, 0.8, 0.3999999999999999), (0.4640000000000001, 0.8, 0.3999999999999999), (0.4319999999999999, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.432), (0.3999999999999999, 0.8, 0.4640000000000002), (0.3999999999999999, 0.8, 0.4959999999999999), (0.3999999999999999, 0.8, 0.5280000000000001), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.592), (0.3999999999999999, 0.8, 0.6240000000000002), (0.3999999999999999, 0.8, 0.6559999999999999), (0.3999999999999999, 0.8, 0.6880000000000002), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.8, 0.752), (0.3999999999999999, 0.8, 0.7840000000000003), (0.3999999999999999, 0.7839999999999996, 0.8), (0.3999999999999999, 0.7519999999999999, 0.8), (0.3999999999999999, 0.7200000000000002, 0.8), (0.3999999999999999, 0.6879999999999995, 0.8), (0.3999999999999999, 0.6559999999999998, 0.8), (0.3999999999999999, 0.6240000000000001, 0.8), (0.3999999999999999, 0.5919999999999999, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.528, 0.8), (0.3999999999999999, 0.4959999999999998, 0.8), (0.3999999999999999, 0.4639999999999995, 0.8), (0.3999999999999999, 0.4319999999999999, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.4320000000000001, 0.3999999999999999, 0.8), (0.4639999999999998, 0.3999999999999999, 0.8), (0.4959999999999995, 0.3999999999999999, 0.8), (0.5280000000000002, 0.3999999999999999, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.5919999999999996, 0.3999999999999999, 0.8), (0.6239999999999999, 0.3999999999999999, 0.8), (0.656, 0.3999999999999999, 0.8), (0.6879999999999997, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7520000000000002, 0.3999999999999999, 0.8), (0.7839999999999998, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7839999999999996), (0.8, 0.3999999999999999, 0.7519999999999993), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.688), (0.8, 0.3999999999999999, 0.6559999999999993), (0.8, 0.3999999999999999, 0.6239999999999996), (0.8, 0.3999999999999999, 0.5919999999999999), (0.8, 0.3999999999999999, 0.5599999999999996), (0.8, 0.3999999999999999, 0.5279999999999995), (0.8, 0.3999999999999999, 0.4959999999999998), (0.8, 0.3999999999999999, 0.4639999999999995), (0.8, 0.3999999999999999, 0.43199999999999933)],
    76: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4315789473684208, 0.3999999999999999), (0.8, 0.4631578947368422, 0.3999999999999999), (0.8, 0.49473684210526314, 0.3999999999999999), (0.8, 0.5263157894736841, 0.3999999999999999), (0.8, 0.5578947368421054, 0.3999999999999999), (0.8, 0.5894736842105264, 0.3999999999999999), (0.8, 0.6210526315789473, 0.3999999999999999), (0.8, 0.6526315789473681, 0.3999999999999999), (0.8, 0.6842105263157896, 0.3999999999999999), (0.8, 0.7157894736842105, 0.3999999999999999), (0.8, 0.7473684210526319, 0.3999999999999999), (0.8, 0.7789473684210528, 0.3999999999999999), (0.7894736842105265, 0.8, 0.3999999999999999), (0.7578947368421056, 0.8, 0.3999999999999999), (0.7263157894736842, 0.8, 0.3999999999999999), (0.6947368421052633, 0.8, 0.3999999999999999), (0.6631578947368424, 0.8, 0.3999999999999999), (0.631578947368421, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5684210526315792, 0.8, 0.3999999999999999), (0.5368421052631582, 0.8, 0.3999999999999999), (0.5052631578947369, 0.8, 0.3999999999999999), (0.47368421052631593, 0.8, 0.3999999999999999), (0.4421052631578945, 0.8, 0.3999999999999999), (0.41052631578947363, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42105263157894723), (0.3999999999999999, 0.8, 0.4526315789473681), (0.3999999999999999, 0.8, 0.48421052631578954), (0.3999999999999999, 0.8, 0.5157894736842105), (0.3999999999999999, 0.8, 0.5473684210526318), (0.3999999999999999, 0.8, 0.5789473684210528), (0.3999999999999999, 0.8, 0.6105263157894737), (0.3999999999999999, 0.8, 0.6421052631578945), (0.3999999999999999, 0.8, 0.6736842105263154), (0.3999999999999999, 0.8, 0.7052631578947368), (0.3999999999999999, 0.8, 0.7368421052631577), (0.3999999999999999, 0.8, 0.7684210526315792), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7684210526315791, 0.8), (0.3999999999999999, 0.7368421052631582, 0.8), (0.3999999999999999, 0.7052631578947368, 0.8), (0.3999999999999999, 0.6736842105263159, 0.8), (0.3999999999999999, 0.6421052631578944, 0.8), (0.3999999999999999, 0.6105263157894735, 0.8), (0.3999999999999999, 0.5789473684210527, 0.8), (0.3999999999999999, 0.5473684210526317, 0.8), (0.3999999999999999, 0.5157894736842108, 0.8), (0.3999999999999999, 0.4842105263157894, 0.8), (0.3999999999999999, 0.452631578947368, 0.8), (0.3999999999999999, 0.42105263157894707, 0.8), (0.41052631578947335, 0.3999999999999999, 0.8), (0.4421052631578943, 0.3999999999999999, 0.8), (0.47368421052631515, 0.3999999999999999, 0.8), (0.5052631578947366, 0.3999999999999999, 0.8), (0.5368421052631575, 0.3999999999999999, 0.8), (0.5684210526315789, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6315789473684207, 0.3999999999999999, 0.8), (0.6631578947368416, 0.3999999999999999, 0.8), (0.6947368421052631, 0.3999999999999999, 0.8), (0.7263157894736839, 0.3999999999999999, 0.8), (0.7578947368421054, 0.3999999999999999, 0.8), (0.7894736842105263, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7789473684210526), (0.8, 0.3999999999999999, 0.7473684210526317), (0.8, 0.3999999999999999, 0.7157894736842108), (0.8, 0.3999999999999999, 0.6842105263157894), (0.8, 0.3999999999999999, 0.6526315789473685), (0.8, 0.3999999999999999, 0.621052631578947), (0.8, 0.3999999999999999, 0.589473684210526), (0.8, 0.3999999999999999, 0.5578947368421052), (0.8, 0.3999999999999999, 0.5263157894736843), (0.8, 0.3999999999999999, 0.49473684210526286), (0.8, 0.3999999999999999, 0.463157894736842), (0.8, 0.3999999999999999, 0.43157894736842056)],
    77: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4311688311688308, 0.3999999999999999), (0.8, 0.46233766233766227, 0.3999999999999999), (0.8, 0.4935064935064932, 0.3999999999999999), (0.8, 0.5246753246753246, 0.3999999999999999), (0.8, 0.5558441558441556, 0.3999999999999999), (0.8, 0.587012987012987, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6493506493506495, 0.3999999999999999), (0.8, 0.6805194805194803, 0.3999999999999999), (0.8, 0.7116883116883118, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7740259740259742, 0.3999999999999999), (0.7948051948051951, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7324675324675327, 0.8, 0.3999999999999999), (0.7012987012987013, 0.8, 0.3999999999999999), (0.6701298701298704, 0.8, 0.3999999999999999), (0.6389610389610388, 0.8, 0.3999999999999999), (0.6077922077922079, 0.8, 0.3999999999999999), (0.5766233766233765, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5142857142857141, 0.8, 0.3999999999999999), (0.48311688311688317, 0.8, 0.3999999999999999), (0.4519480519480517, 0.8, 0.3999999999999999), (0.4207792207792208, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4103896103896101), (0.3999999999999999, 0.8, 0.44155844155844154), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.503896103896104), (0.3999999999999999, 0.8, 0.5350649350649348), (0.3999999999999999, 0.8, 0.5662337662337663), (0.3999999999999999, 0.8, 0.5974025974025977), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6597402597402596), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7220779220779225), (0.3999999999999999, 0.8, 0.7532467532467535), (0.3999999999999999, 0.8, 0.7844155844155845), (0.3999999999999999, 0.7844155844155842, 0.8), (0.3999999999999999, 0.7532467532467528, 0.8), (0.3999999999999999, 0.7220779220779219, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6597402597402595, 0.8), (0.3999999999999999, 0.628571428571428, 0.8), (0.3999999999999999, 0.597402597402597, 0.8), (0.3999999999999999, 0.5662337662337662, 0.8), (0.3999999999999999, 0.5350649350649347, 0.8), (0.3999999999999999, 0.5038961038961038, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.44155844155844143, 0.8), (0.3999999999999999, 0.41038961038960997, 0.8), (0.42077922077922053, 0.3999999999999999, 0.8), (0.45194805194805143, 0.3999999999999999, 0.8), (0.4831168831168829, 0.3999999999999999, 0.8), (0.5142857142857143, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5766233766233761, 0.3999999999999999, 0.8), (0.6077922077922077, 0.3999999999999999, 0.8), (0.6389610389610392, 0.3999999999999999, 0.8), (0.6701298701298701, 0.3999999999999999, 0.8), (0.701298701298701, 0.3999999999999999, 0.8), (0.7324675324675325, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.7948051948051948, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.774025974025974), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.711688311688311), (0.8, 0.3999999999999999, 0.6805194805194801), (0.8, 0.3999999999999999, 0.6493506493506491), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.5870129870129863), (0.8, 0.3999999999999999, 0.5558441558441554), (0.8, 0.3999999999999999, 0.5246753246753244), (0.8, 0.3999999999999999, 0.49350649350649295), (0.8, 0.3999999999999999, 0.4623376623376615), (0.8, 0.3999999999999999, 0.4311688311688306)],
    78: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.43076923076923057, 0.3999999999999999), (0.8, 0.46153846153846123, 0.3999999999999999), (0.8, 0.49230769230769245, 0.3999999999999999), (0.8, 0.5230769230769231, 0.3999999999999999), (0.8, 0.5538461538461538, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.6153846153846152, 0.3999999999999999), (0.8, 0.6461538461538463, 0.3999999999999999), (0.8, 0.676923076923077, 0.3999999999999999), (0.8, 0.7076923076923076, 0.3999999999999999), (0.8, 0.7384615384615383, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7692307692307693, 0.8, 0.3999999999999999), (0.7384615384615386, 0.8, 0.3999999999999999), (0.707692307692308, 0.8, 0.3999999999999999), (0.6769230769230767, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.6153846153846154, 0.8, 0.3999999999999999), (0.5846153846153848, 0.8, 0.3999999999999999), (0.5538461538461541, 0.8, 0.3999999999999999), (0.5230769230769234, 0.8, 0.3999999999999999), (0.4923076923076922, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.43076923076923085, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.43076923076923096), (0.3999999999999999, 0.8, 0.4615384615384617), (0.3999999999999999, 0.8, 0.49230769230769234), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.5538461538461537), (0.3999999999999999, 0.8, 0.5846153846153843), (0.3999999999999999, 0.8, 0.6153846153846155), (0.3999999999999999, 0.8, 0.6461538461538462), (0.3999999999999999, 0.8, 0.676923076923077), (0.3999999999999999, 0.8, 0.7076923076923076), (0.3999999999999999, 0.8, 0.7384615384615387), (0.3999999999999999, 0.8, 0.7692307692307694), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7692307692307693, 0.8), (0.3999999999999999, 0.7384615384615386, 0.8), (0.3999999999999999, 0.707692307692308, 0.8), (0.3999999999999999, 0.6769230769230773, 0.8), (0.3999999999999999, 0.6461538461538461, 0.8), (0.3999999999999999, 0.6153846153846154, 0.8), (0.3999999999999999, 0.5846153846153842, 0.8), (0.3999999999999999, 0.5538461538461535, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.4923076923076922, 0.8), (0.3999999999999999, 0.4615384615384615, 0.8), (0.3999999999999999, 0.43076923076923085, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.43076923076923057, 0.3999999999999999, 0.8), (0.46153846153846123, 0.3999999999999999, 0.8), (0.4923076923076919, 0.3999999999999999, 0.8), (0.5230769230769231, 0.3999999999999999, 0.8), (0.5538461538461538, 0.3999999999999999, 0.8), (0.5846153846153845, 0.3999999999999999, 0.8), (0.6153846153846152, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.6769230769230765, 0.3999999999999999, 0.8), (0.7076923076923072, 0.3999999999999999, 0.8), (0.7384615384615383, 0.3999999999999999, 0.8), (0.769230769230769, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7384615384615381), (0.8, 0.3999999999999999, 0.7076923076923074), (0.8, 0.3999999999999999, 0.6769230769230767), (0.8, 0.3999999999999999, 0.6461538461538461), (0.8, 0.3999999999999999, 0.6153846153846154), (0.8, 0.3999999999999999, 0.5846153846153848), (0.8, 0.3999999999999999, 0.5538461538461535), (0.8, 0.3999999999999999, 0.5230769230769229), (0.8, 0.3999999999999999, 0.4923076923076922), (0.8, 0.3999999999999999, 0.461538461538461), (0.8, 0.3999999999999999, 0.4307692307692303)],
    79: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4303797468354431, 0.3999999999999999), (0.8, 0.4607594936708858, 0.3999999999999999), (0.8, 0.491139240506329, 0.3999999999999999), (0.8, 0.5215189873417723, 0.3999999999999999), (0.8, 0.5518987341772149, 0.3999999999999999), (0.8, 0.5822784810126581, 0.3999999999999999), (0.8, 0.6126582278481013, 0.3999999999999999), (0.8, 0.6430379746835445, 0.3999999999999999), (0.8, 0.6734177215189872, 0.3999999999999999), (0.8, 0.7037974683544304, 0.3999999999999999), (0.8, 0.7341772151898736, 0.3999999999999999), (0.8, 0.7645569620253163, 0.3999999999999999), (0.8, 0.7949367088607595, 0.3999999999999999), (0.7746835443037975, 0.8, 0.3999999999999999), (0.7443037974683548, 0.8, 0.3999999999999999), (0.7139240506329116, 0.8, 0.3999999999999999), (0.6835443037974684, 0.8, 0.3999999999999999), (0.6531645569620257, 0.8, 0.3999999999999999), (0.6227848101265825, 0.8, 0.3999999999999999), (0.5924050632911393, 0.8, 0.3999999999999999), (0.5620253164556961, 0.8, 0.3999999999999999), (0.5316455696202533, 0.8, 0.3999999999999999), (0.5012658227848101, 0.8, 0.3999999999999999), (0.47088607594936693, 0.8, 0.3999999999999999), (0.4405063291139243, 0.8, 0.3999999999999999), (0.4101265822784811, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4202531645569621), (0.3999999999999999, 0.8, 0.4506329113924053), (0.3999999999999999, 0.8, 0.481012658227848), (0.3999999999999999, 0.8, 0.5113924050632912), (0.3999999999999999, 0.8, 0.5417721518987338), (0.3999999999999999, 0.8, 0.572151898734177), (0.3999999999999999, 0.8, 0.6025316455696202), (0.3999999999999999, 0.8, 0.6329113924050636), (0.3999999999999999, 0.8, 0.6632911392405062), (0.3999999999999999, 0.8, 0.6936708860759494), (0.3999999999999999, 0.8, 0.7240506329113926), (0.3999999999999999, 0.8, 0.7544303797468352), (0.3999999999999999, 0.8, 0.7848101265822784), (0.3999999999999999, 0.7848101265822784, 0.8), (0.3999999999999999, 0.7544303797468351, 0.8), (0.3999999999999999, 0.7240506329113925, 0.8), (0.3999999999999999, 0.6936708860759493, 0.8), (0.3999999999999999, 0.6632911392405065, 0.8), (0.3999999999999999, 0.6329113924050633, 0.8), (0.3999999999999999, 0.6025316455696201, 0.8), (0.3999999999999999, 0.5721518987341769, 0.8), (0.3999999999999999, 0.5417721518987337, 0.8), (0.3999999999999999, 0.5113924050632911, 0.8), (0.3999999999999999, 0.48101265822784783, 0.8), (0.3999999999999999, 0.4506329113924052, 0.8), (0.3999999999999999, 0.42025316455696193, 0.8), (0.4101265822784808, 0.3999999999999999, 0.8), (0.440506329113924, 0.3999999999999999, 0.8), (0.4708860759493667, 0.3999999999999999, 0.8), (0.5012658227848099, 0.3999999999999999, 0.8), (0.5316455696202526, 0.3999999999999999, 0.8), (0.5620253164556958, 0.3999999999999999, 0.8), (0.592405063291139, 0.3999999999999999, 0.8), (0.6227848101265823, 0.3999999999999999, 0.8), (0.6531645569620255, 0.3999999999999999, 0.8), (0.6835443037974681, 0.3999999999999999, 0.8), (0.7139240506329113, 0.3999999999999999, 0.8), (0.744303797468354, 0.3999999999999999, 0.8), (0.7746835443037972, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7949367088607593), (0.8, 0.3999999999999999, 0.7645569620253161), (0.8, 0.3999999999999999, 0.7341772151898729), (0.8, 0.3999999999999999, 0.7037974683544301), (0.8, 0.3999999999999999, 0.6734177215189875), (0.8, 0.3999999999999999, 0.6430379746835443), (0.8, 0.3999999999999999, 0.6126582278481011), (0.8, 0.3999999999999999, 0.5822784810126578), (0.8, 0.3999999999999999, 0.5518987341772146), (0.8, 0.3999999999999999, 0.5215189873417719), (0.8, 0.3999999999999999, 0.49113924050632873), (0.8, 0.3999999999999999, 0.4607594936708861), (0.8, 0.3999999999999999, 0.43037974683544283)],
    80: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4299999999999998, 0.3999999999999999), (0.8, 0.45999999999999974, 0.3999999999999999), (0.8, 0.49000000000000016, 0.3999999999999999), (0.8, 0.52, 0.3999999999999999), (0.8, 0.5499999999999999, 0.3999999999999999), (0.8, 0.5799999999999998, 0.3999999999999999), (0.8, 0.6099999999999998, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6700000000000002, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.73, 0.3999999999999999), (0.8, 0.7599999999999998, 0.3999999999999999), (0.8, 0.7900000000000003, 0.3999999999999999), (0.78, 0.8, 0.3999999999999999), (0.7500000000000001, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6900000000000004, 0.8, 0.3999999999999999), (0.6599999999999999, 0.8, 0.3999999999999999), (0.63, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5700000000000002, 0.8, 0.3999999999999999), (0.5400000000000003, 0.8, 0.3999999999999999), (0.5099999999999998, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.45, 0.8, 0.3999999999999999), (0.4200000000000001, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40999999999999975), (0.3999999999999999, 0.8, 0.44000000000000017), (0.3999999999999999, 0.8, 0.4700000000000001), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5299999999999999), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5900000000000002), (0.3999999999999999, 0.8, 0.6200000000000001), (0.3999999999999999, 0.8, 0.65), (0.3999999999999999, 0.8, 0.6799999999999999), (0.3999999999999999, 0.8, 0.7099999999999999), (0.3999999999999999, 0.8, 0.7400000000000002), (0.3999999999999999, 0.8, 0.7700000000000002), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7699999999999996, 0.8), (0.3999999999999999, 0.7400000000000002, 0.8), (0.3999999999999999, 0.7099999999999997, 0.8), (0.3999999999999999, 0.6799999999999998, 0.8), (0.3999999999999999, 0.6499999999999999, 0.8), (0.3999999999999999, 0.6199999999999994, 0.8), (0.3999999999999999, 0.5900000000000001, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5299999999999998, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4699999999999994, 0.8), (0.3999999999999999, 0.44000000000000006, 0.8), (0.3999999999999999, 0.4099999999999996, 0.8), (0.4199999999999998, 0.3999999999999999, 0.8), (0.44999999999999973, 0.3999999999999999, 0.8), (0.4800000000000002, 0.3999999999999999, 0.8), (0.5099999999999996, 0.3999999999999999, 0.8), (0.54, 0.3999999999999999, 0.8), (0.5699999999999998, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6300000000000002, 0.3999999999999999, 0.8), (0.6599999999999996, 0.3999999999999999, 0.8), (0.6900000000000001, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7499999999999998, 0.3999999999999999, 0.8), (0.7800000000000002, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.79), (0.8, 0.3999999999999999, 0.7599999999999996), (0.8, 0.3999999999999999, 0.7299999999999996), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6699999999999993), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6099999999999995), (0.8, 0.3999999999999999, 0.5799999999999996), (0.8, 0.3999999999999999, 0.5499999999999997), (0.8, 0.3999999999999999, 0.5199999999999992), (0.8, 0.3999999999999999, 0.4899999999999999), (0.8, 0.3999999999999999, 0.45999999999999946), (0.8, 0.3999999999999999, 0.42999999999999955)],
    81: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4296296296296297, 0.3999999999999999), (0.8, 0.4592592592592595, 0.3999999999999999), (0.8, 0.4888888888888887, 0.3999999999999999), (0.8, 0.5185185185185185, 0.3999999999999999), (0.8, 0.5481481481481483, 0.3999999999999999), (0.8, 0.5777777777777775, 0.3999999999999999), (0.8, 0.6074074074074073, 0.3999999999999999), (0.8, 0.6370370370370371, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6962962962962966, 0.3999999999999999), (0.8, 0.7259259259259259, 0.3999999999999999), (0.8, 0.7555555555555555, 0.3999999999999999), (0.8, 0.7851851851851854, 0.3999999999999999), (0.7851851851851857, 0.8, 0.3999999999999999), (0.7555555555555558, 0.8, 0.3999999999999999), (0.7259259259259261, 0.8, 0.3999999999999999), (0.6962962962962963, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6370370370370373, 0.8, 0.3999999999999999), (0.6074074074074075, 0.8, 0.3999999999999999), (0.5777777777777777, 0.8, 0.3999999999999999), (0.5481481481481485, 0.8, 0.3999999999999999), (0.5185185185185187, 0.8, 0.3999999999999999), (0.48888888888888893, 0.8, 0.3999999999999999), (0.4592592592592592, 0.8, 0.3999999999999999), (0.4296296296296294, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42962962962962953), (0.3999999999999999, 0.8, 0.4592592592592593), (0.3999999999999999, 0.8, 0.48888888888888854), (0.3999999999999999, 0.8, 0.5185185185185184), (0.3999999999999999, 0.8, 0.548148148148148), (0.3999999999999999, 0.8, 0.5777777777777778), (0.3999999999999999, 0.8, 0.6074074074074076), (0.3999999999999999, 0.8, 0.6370370370370368), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6962962962962964), (0.3999999999999999, 0.8, 0.7259259259259256), (0.3999999999999999, 0.8, 0.7555555555555554), (0.3999999999999999, 0.8, 0.7851851851851852), (0.3999999999999999, 0.785185185185185, 0.8), (0.3999999999999999, 0.7555555555555553, 0.8), (0.3999999999999999, 0.7259259259259261, 0.8), (0.3999999999999999, 0.6962962962962963, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6370370370370373, 0.8), (0.3999999999999999, 0.6074074074074075, 0.8), (0.3999999999999999, 0.5777777777777777, 0.8), (0.3999999999999999, 0.5481481481481479, 0.8), (0.3999999999999999, 0.5185185185185182, 0.8), (0.3999999999999999, 0.48888888888888893, 0.8), (0.3999999999999999, 0.4592592592592592, 0.8), (0.3999999999999999, 0.4296296296296294, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.42962962962962914, 0.3999999999999999, 0.8), (0.4592592592592589, 0.3999999999999999, 0.8), (0.4888888888888887, 0.3999999999999999, 0.8), (0.5185185185185185, 0.3999999999999999, 0.8), (0.5481481481481477, 0.3999999999999999, 0.8), (0.5777777777777775, 0.3999999999999999, 0.8), (0.6074074074074073, 0.3999999999999999, 0.8), (0.6370370370370365, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.696296296296296, 0.3999999999999999, 0.8), (0.7259259259259259, 0.3999999999999999, 0.8), (0.7555555555555555, 0.3999999999999999, 0.8), (0.7851851851851848, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.785185185185185), (0.8, 0.3999999999999999, 0.7555555555555553), (0.8, 0.3999999999999999, 0.7259259259259261), (0.8, 0.3999999999999999, 0.6962962962962963), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6370370370370367), (0.8, 0.3999999999999999, 0.607407407407407), (0.8, 0.3999999999999999, 0.5777777777777777), (0.8, 0.3999999999999999, 0.5481481481481479), (0.8, 0.3999999999999999, 0.5185185185185182), (0.8, 0.3999999999999999, 0.48888888888888893), (0.8, 0.3999999999999999, 0.4592592592592592), (0.8, 0.3999999999999999, 0.4296296296296294)],
    82: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42926829268292677, 0.3999999999999999), (0.8, 0.4585365853658536, 0.3999999999999999), (0.8, 0.4878048780487805, 0.3999999999999999), (0.8, 0.5170731707317073, 0.3999999999999999), (0.8, 0.5463414634146342, 0.3999999999999999), (0.8, 0.575609756097561, 0.3999999999999999), (0.8, 0.604878048780488, 0.3999999999999999), (0.8, 0.6341463414634149, 0.3999999999999999), (0.8, 0.6634146341463417, 0.3999999999999999), (0.8, 0.6926829268292686, 0.3999999999999999), (0.8, 0.7219512195121954, 0.3999999999999999), (0.8, 0.7512195121951223, 0.3999999999999999), (0.8, 0.7804878048780486, 0.3999999999999999), (0.7902439024390246, 0.8, 0.3999999999999999), (0.7609756097560978, 0.8, 0.3999999999999999), (0.7317073170731709, 0.8, 0.3999999999999999), (0.7024390243902441, 0.8, 0.3999999999999999), (0.6731707317073172, 0.8, 0.3999999999999999), (0.6439024390243904, 0.8, 0.3999999999999999), (0.6146341463414635, 0.8, 0.3999999999999999), (0.5853658536585367, 0.8, 0.3999999999999999), (0.5560975609756098, 0.8, 0.3999999999999999), (0.526829268292683, 0.8, 0.3999999999999999), (0.49756097560975604, 0.8, 0.3999999999999999), (0.4682926829268292, 0.8, 0.3999999999999999), (0.43902439024390233, 0.8, 0.3999999999999999), (0.4097560975609754, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41951219512195137), (0.3999999999999999, 0.8, 0.4487804878048782), (0.3999999999999999, 0.8, 0.4780487804878046), (0.3999999999999999, 0.8, 0.5073170731707315), (0.3999999999999999, 0.8, 0.5365853658536583), (0.3999999999999999, 0.8, 0.5658536585365852), (0.3999999999999999, 0.8, 0.5951219512195121), (0.3999999999999999, 0.8, 0.6243902439024389), (0.3999999999999999, 0.8, 0.6536585365853658), (0.3999999999999999, 0.8, 0.6829268292682926), (0.3999999999999999, 0.8, 0.7121951219512195), (0.3999999999999999, 0.8, 0.7414634146341463), (0.3999999999999999, 0.8, 0.7707317073170732), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7707317073170731, 0.8), (0.3999999999999999, 0.7414634146341462, 0.8), (0.3999999999999999, 0.7121951219512194, 0.8), (0.3999999999999999, 0.6829268292682925, 0.8), (0.3999999999999999, 0.6536585365853657, 0.8), (0.3999999999999999, 0.6243902439024388, 0.8), (0.3999999999999999, 0.595121951219512, 0.8), (0.3999999999999999, 0.565853658536585, 0.8), (0.3999999999999999, 0.5365853658536581, 0.8), (0.3999999999999999, 0.5073170731707313, 0.8), (0.3999999999999999, 0.4780487804878044, 0.8), (0.3999999999999999, 0.44878048780487756, 0.8), (0.3999999999999999, 0.4195121951219507, 0.8), (0.4097560975609757, 0.3999999999999999, 0.8), (0.43902439024390255, 0.3999999999999999, 0.8), (0.46829268292682946, 0.3999999999999999, 0.8), (0.4975609756097563, 0.3999999999999999, 0.8), (0.5268292682926826, 0.3999999999999999, 0.8), (0.5560975609756095, 0.3999999999999999, 0.8), (0.5853658536585364, 0.3999999999999999, 0.8), (0.6146341463414633, 0.3999999999999999, 0.8), (0.6439024390243901, 0.3999999999999999, 0.8), (0.673170731707317, 0.3999999999999999, 0.8), (0.7024390243902439, 0.3999999999999999, 0.8), (0.7317073170731707, 0.3999999999999999, 0.8), (0.7609756097560976, 0.3999999999999999, 0.8), (0.7902439024390244, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7804878048780484), (0.8, 0.3999999999999999, 0.751219512195122), (0.8, 0.3999999999999999, 0.7219512195121951), (0.8, 0.3999999999999999, 0.6926829268292682), (0.8, 0.3999999999999999, 0.6634146341463414), (0.8, 0.3999999999999999, 0.6341463414634145), (0.8, 0.3999999999999999, 0.6048780487804877), (0.8, 0.3999999999999999, 0.5756097560975608), (0.8, 0.3999999999999999, 0.546341463414634), (0.8, 0.3999999999999999, 0.5170731707317071), (0.8, 0.3999999999999999, 0.48780487804878025), (0.8, 0.3999999999999999, 0.4585365853658534), (0.8, 0.3999999999999999, 0.4292682926829265)],
    83: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42891566265060216, 0.3999999999999999), (0.8, 0.45783132530120496, 0.3999999999999999), (0.8, 0.48674698795180715, 0.3999999999999999), (0.8, 0.5156626506024095, 0.3999999999999999), (0.8, 0.5445783132530122, 0.3999999999999999), (0.8, 0.5734939759036144, 0.3999999999999999), (0.8, 0.6024096385542167, 0.3999999999999999), (0.8, 0.6313253012048194, 0.3999999999999999), (0.8, 0.6602409638554217, 0.3999999999999999), (0.8, 0.689156626506024, 0.3999999999999999), (0.8, 0.7180722891566267, 0.3999999999999999), (0.8, 0.746987951807229, 0.3999999999999999), (0.8, 0.7759036144578313, 0.3999999999999999), (0.7951807228915662, 0.8, 0.3999999999999999), (0.766265060240964, 0.8, 0.3999999999999999), (0.7373493975903617, 0.8, 0.3999999999999999), (0.7084337349397589, 0.8, 0.3999999999999999), (0.6795180722891567, 0.8, 0.3999999999999999), (0.6506024096385544, 0.8, 0.3999999999999999), (0.6216867469879521, 0.8, 0.3999999999999999), (0.5927710843373494, 0.8, 0.3999999999999999), (0.5638554216867471, 0.8, 0.3999999999999999), (0.5349397590361449, 0.8, 0.3999999999999999), (0.5060240963855421, 0.8, 0.3999999999999999), (0.47710843373493983, 0.8, 0.3999999999999999), (0.44819277108433764, 0.8, 0.3999999999999999), (0.41927710843373484, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40963855421686735), (0.3999999999999999, 0.8, 0.4385542168674696), (0.3999999999999999, 0.8, 0.4674698795180724), (0.3999999999999999, 0.8, 0.49638554216867464), (0.3999999999999999, 0.8, 0.5253012048192769), (0.3999999999999999, 0.8, 0.5542168674698796), (0.3999999999999999, 0.8, 0.5831325301204819), (0.3999999999999999, 0.8, 0.6120481927710841), (0.3999999999999999, 0.8, 0.640963855421687), (0.3999999999999999, 0.8, 0.6698795180722892), (0.3999999999999999, 0.8, 0.6987951807228914), (0.3999999999999999, 0.8, 0.7277108433734942), (0.3999999999999999, 0.8, 0.7566265060240964), (0.3999999999999999, 0.8, 0.7855421686746986), (0.3999999999999999, 0.7855421686746986, 0.8), (0.3999999999999999, 0.7566265060240963, 0.8), (0.3999999999999999, 0.727710843373494, 0.8), (0.3999999999999999, 0.6987951807228914, 0.8), (0.3999999999999999, 0.6698795180722891, 0.8), (0.3999999999999999, 0.6409638554216868, 0.8), (0.3999999999999999, 0.612048192771084, 0.8), (0.3999999999999999, 0.5831325301204817, 0.8), (0.3999999999999999, 0.5542168674698795, 0.8), (0.3999999999999999, 0.5253012048192768, 0.8), (0.3999999999999999, 0.49638554216867453, 0.8), (0.3999999999999999, 0.4674698795180723, 0.8), (0.3999999999999999, 0.4385542168674695, 0.8), (0.3999999999999999, 0.40963855421686723, 0.8), (0.41927710843373456, 0.3999999999999999, 0.8), (0.44819277108433736, 0.3999999999999999, 0.8), (0.4771084337349396, 0.3999999999999999, 0.8), (0.5060240963855418, 0.3999999999999999, 0.8), (0.5349397590361447, 0.3999999999999999, 0.8), (0.5638554216867468, 0.3999999999999999, 0.8), (0.5927710843373492, 0.3999999999999999, 0.8), (0.6216867469879519, 0.3999999999999999, 0.8), (0.6506024096385541, 0.3999999999999999, 0.8), (0.6795180722891564, 0.3999999999999999, 0.8), (0.7084337349397591, 0.3999999999999999, 0.8), (0.7373493975903613, 0.3999999999999999, 0.8), (0.7662650602409636, 0.3999999999999999, 0.8), (0.7951807228915664, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7759036144578311), (0.8, 0.3999999999999999, 0.7469879518072287), (0.8, 0.3999999999999999, 0.718072289156626), (0.8, 0.3999999999999999, 0.6891566265060237), (0.8, 0.3999999999999999, 0.6602409638554214), (0.8, 0.3999999999999999, 0.6313253012048187), (0.8, 0.3999999999999999, 0.6024096385542165), (0.8, 0.3999999999999999, 0.5734939759036142), (0.8, 0.3999999999999999, 0.5445783132530114), (0.8, 0.3999999999999999, 0.5156626506024091), (0.8, 0.3999999999999999, 0.48674698795180693), (0.8, 0.3999999999999999, 0.45783132530120413), (0.8, 0.3999999999999999, 0.4289156626506019)],
    84: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4285714285714284, 0.3999999999999999), (0.8, 0.45714285714285685, 0.3999999999999999), (0.8, 0.4857142857142859, 0.3999999999999999), (0.8, 0.5142857142857143, 0.3999999999999999), (0.8, 0.5428571428571428, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6285714285714288, 0.3999999999999999), (0.8, 0.6571428571428573, 0.3999999999999999), (0.8, 0.6857142857142857, 0.3999999999999999), (0.8, 0.7142857142857142, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7714285714285712, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7714285714285715, 0.8, 0.3999999999999999), (0.742857142857143, 0.8, 0.3999999999999999), (0.7142857142857145, 0.8, 0.3999999999999999), (0.685714285714286, 0.8, 0.3999999999999999), (0.657142857142857, 0.8, 0.3999999999999999), (0.6285714285714286, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5714285714285716, 0.8, 0.3999999999999999), (0.5428571428571431, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.4857142857142856, 0.8, 0.3999999999999999), (0.45714285714285713, 0.8, 0.3999999999999999), (0.42857142857142866, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42857142857142877), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.48571428571428577), (0.3999999999999999, 0.8, 0.5142857142857142), (0.3999999999999999, 0.8, 0.5428571428571427), (0.3999999999999999, 0.8, 0.5714285714285712), (0.3999999999999999, 0.8, 0.5999999999999996), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6571428571428571), (0.3999999999999999, 0.8, 0.6857142857142857), (0.3999999999999999, 0.8, 0.7142857142857142), (0.3999999999999999, 0.8, 0.7428571428571431), (0.3999999999999999, 0.8, 0.7714285714285716), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7714285714285715, 0.8), (0.3999999999999999, 0.742857142857143, 0.8), (0.3999999999999999, 0.7142857142857145, 0.8), (0.3999999999999999, 0.685714285714286, 0.8), (0.3999999999999999, 0.657142857142857, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6000000000000001, 0.8), (0.3999999999999999, 0.5714285714285711, 0.8), (0.3999999999999999, 0.5428571428571426, 0.8), (0.3999999999999999, 0.5142857142857141, 0.8), (0.3999999999999999, 0.4857142857142856, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.3999999999999999, 0.42857142857142866, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4285714285714278, 0.3999999999999999, 0.8), (0.45714285714285685, 0.3999999999999999, 0.8), (0.4857142857142853, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5428571428571428, 0.3999999999999999, 0.8), (0.5714285714285713, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6285714285714283, 0.3999999999999999, 0.8), (0.6571428571428568, 0.3999999999999999, 0.8), (0.6857142857142853, 0.3999999999999999, 0.8), (0.7142857142857137, 0.3999999999999999, 0.8), (0.7428571428571427, 0.3999999999999999, 0.8), (0.7714285714285712, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7714285714285709), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.714285714285714), (0.8, 0.3999999999999999, 0.6857142857142855), (0.8, 0.3999999999999999, 0.657142857142857), (0.8, 0.3999999999999999, 0.6285714285714286), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5714285714285716), (0.8, 0.3999999999999999, 0.5428571428571426), (0.8, 0.3999999999999999, 0.5142857142857141), (0.8, 0.3999999999999999, 0.4857142857142856), (0.8, 0.3999999999999999, 0.45714285714285663), (0.8, 0.3999999999999999, 0.4285714285714281)],
    85: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4282352941176469, 0.3999999999999999), (0.8, 0.45647058823529385, 0.3999999999999999), (0.8, 0.4847058823529413, 0.3999999999999999), (0.8, 0.5129411764705883, 0.3999999999999999), (0.8, 0.5411764705882353, 0.3999999999999999), (0.8, 0.5694117647058823, 0.3999999999999999), (0.8, 0.5976470588235292, 0.3999999999999999), (0.8, 0.6258823529411768, 0.3999999999999999), (0.8, 0.6541176470588237, 0.3999999999999999), (0.8, 0.6823529411764706, 0.3999999999999999), (0.8, 0.7105882352941176, 0.3999999999999999), (0.8, 0.7388235294117647, 0.3999999999999999), (0.8, 0.7670588235294116, 0.3999999999999999), (0.8, 0.7952941176470592, 0.3999999999999999), (0.7764705882352942, 0.8, 0.3999999999999999), (0.7482352941176471, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6917647058823533, 0.8, 0.3999999999999999), (0.6635294117647057, 0.8, 0.3999999999999999), (0.6352941176470588, 0.8, 0.3999999999999999), (0.6070588235294118, 0.8, 0.3999999999999999), (0.5788235294117648, 0.8, 0.3999999999999999), (0.5505882352941178, 0.8, 0.3999999999999999), (0.5223529411764709, 0.8, 0.3999999999999999), (0.4941176470588234, 0.8, 0.3999999999999999), (0.4658823529411764, 0.8, 0.3999999999999999), (0.43764705882352944, 0.8, 0.3999999999999999), (0.4094117647058825, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4188235294117649), (0.3999999999999999, 0.8, 0.44705882352941195), (0.3999999999999999, 0.8, 0.47529411764705887), (0.3999999999999999, 0.8, 0.5035294117647059), (0.3999999999999999, 0.8, 0.5317647058823528), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5882352941176467), (0.3999999999999999, 0.8, 0.6164705882352943), (0.3999999999999999, 0.8, 0.6447058823529412), (0.3999999999999999, 0.8, 0.6729411764705882), (0.3999999999999999, 0.8, 0.7011764705882352), (0.3999999999999999, 0.8, 0.7294117647058826), (0.3999999999999999, 0.8, 0.7576470588235296), (0.3999999999999999, 0.8, 0.7858823529411767), (0.3999999999999999, 0.7858823529411765, 0.8), (0.3999999999999999, 0.7576470588235296, 0.8), (0.3999999999999999, 0.7294117647058825, 0.8), (0.3999999999999999, 0.7011764705882355, 0.8), (0.3999999999999999, 0.6729411764705882, 0.8), (0.3999999999999999, 0.6447058823529411, 0.8), (0.3999999999999999, 0.6164705882352941, 0.8), (0.3999999999999999, 0.5882352941176466, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5317647058823527, 0.8), (0.3999999999999999, 0.5035294117647058, 0.8), (0.3999999999999999, 0.47529411764705876, 0.8), (0.3999999999999999, 0.4470588235294118, 0.8), (0.3999999999999999, 0.4188235294117648, 0.8), (0.4094117647058817, 0.3999999999999999, 0.8), (0.4376470588235292, 0.3999999999999999, 0.8), (0.4658823529411762, 0.3999999999999999, 0.8), (0.49411764705882316, 0.3999999999999999, 0.8), (0.5223529411764707, 0.3999999999999999, 0.8), (0.5505882352941176, 0.3999999999999999, 0.8), (0.5788235294117645, 0.3999999999999999, 0.8), (0.6070588235294115, 0.3999999999999999, 0.8), (0.6352941176470586, 0.3999999999999999, 0.8), (0.6635294117647055, 0.3999999999999999, 0.8), (0.6917647058823524, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7482352941176469, 0.3999999999999999, 0.8), (0.7764705882352938, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7952941176470583), (0.8, 0.3999999999999999, 0.7670588235294113), (0.8, 0.3999999999999999, 0.7388235294117643), (0.8, 0.3999999999999999, 0.7105882352941173), (0.8, 0.3999999999999999, 0.6823529411764704), (0.8, 0.3999999999999999, 0.6541176470588235), (0.8, 0.3999999999999999, 0.6258823529411764), (0.8, 0.3999999999999999, 0.5976470588235295), (0.8, 0.3999999999999999, 0.569411764705882), (0.8, 0.3999999999999999, 0.541176470588235), (0.8, 0.3999999999999999, 0.512941176470588), (0.8, 0.3999999999999999, 0.48470588235294054), (0.8, 0.3999999999999999, 0.4564705882352936), (0.8, 0.3999999999999999, 0.4282352941176466)],
    86: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.427906976744186, 0.3999999999999999), (0.8, 0.4558139534883721, 0.3999999999999999), (0.8, 0.48372093023255824, 0.3999999999999999), (0.8, 0.5116279069767443, 0.3999999999999999), (0.8, 0.5395348837209304, 0.3999999999999999), (0.8, 0.567441860465116, 0.3999999999999999), (0.8, 0.5953488372093021, 0.3999999999999999), (0.8, 0.6232558139534883, 0.3999999999999999), (0.8, 0.6511627906976744, 0.3999999999999999), (0.8, 0.6790697674418604, 0.3999999999999999), (0.8, 0.7069767441860466, 0.3999999999999999), (0.8, 0.7348837209302326, 0.3999999999999999), (0.8, 0.7627906976744188, 0.3999999999999999), (0.8, 0.790697674418605, 0.3999999999999999), (0.7813953488372092, 0.8, 0.3999999999999999), (0.7534883720930237, 0.8, 0.3999999999999999), (0.7255813953488375, 0.8, 0.3999999999999999), (0.6976744186046515, 0.8, 0.3999999999999999), (0.6697674418604653, 0.8, 0.3999999999999999), (0.6418604651162793, 0.8, 0.3999999999999999), (0.6139534883720932, 0.8, 0.3999999999999999), (0.586046511627907, 0.8, 0.3999999999999999), (0.5581395348837209, 0.8, 0.3999999999999999), (0.5302325581395348, 0.8, 0.3999999999999999), (0.5023255813953487, 0.8, 0.3999999999999999), (0.4744186046511626, 0.8, 0.3999999999999999), (0.4465116279069765, 0.8, 0.3999999999999999), (0.4186046511627904, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4093023255813951), (0.3999999999999999, 0.8, 0.43720930232558125), (0.3999999999999999, 0.8, 0.4651162790697674), (0.3999999999999999, 0.8, 0.49302325581395345), (0.3999999999999999, 0.8, 0.5209302325581395), (0.3999999999999999, 0.8, 0.5488372093023257), (0.3999999999999999, 0.8, 0.5767441860465118), (0.3999999999999999, 0.8, 0.6046511627906973), (0.3999999999999999, 0.8, 0.6325581395348835), (0.3999999999999999, 0.8, 0.6604651162790696), (0.3999999999999999, 0.8, 0.6883720930232557), (0.3999999999999999, 0.8, 0.7162790697674417), (0.3999999999999999, 0.8, 0.7441860465116279), (0.3999999999999999, 0.8, 0.772093023255814), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7720930232558139, 0.8), (0.3999999999999999, 0.7441860465116277, 0.8), (0.3999999999999999, 0.7162790697674417, 0.8), (0.3999999999999999, 0.6883720930232555, 0.8), (0.3999999999999999, 0.6604651162790695, 0.8), (0.3999999999999999, 0.6325581395348834, 0.8), (0.3999999999999999, 0.6046511627906972, 0.8), (0.3999999999999999, 0.5767441860465117, 0.8), (0.3999999999999999, 0.5488372093023255, 0.8), (0.3999999999999999, 0.5209302325581394, 0.8), (0.3999999999999999, 0.49302325581395334, 0.8), (0.3999999999999999, 0.4651162790697672, 0.8), (0.3999999999999999, 0.43720930232558114, 0.8), (0.3999999999999999, 0.40930232558139557, 0.8), (0.4186046511627901, 0.3999999999999999, 0.8), (0.44651162790697624, 0.3999999999999999, 0.8), (0.4744186046511623, 0.3999999999999999, 0.8), (0.5023255813953484, 0.3999999999999999, 0.8), (0.5302325581395345, 0.3999999999999999, 0.8), (0.5581395348837206, 0.3999999999999999, 0.8), (0.5860465116279068, 0.3999999999999999, 0.8), (0.6139534883720928, 0.3999999999999999, 0.8), (0.6418604651162789, 0.3999999999999999, 0.8), (0.6697674418604651, 0.3999999999999999, 0.8), (0.6976744186046512, 0.3999999999999999, 0.8), (0.7255813953488373, 0.3999999999999999, 0.8), (0.7534883720930234, 0.3999999999999999, 0.8), (0.7813953488372094, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7906976744186045), (0.8, 0.3999999999999999, 0.7627906976744185), (0.8, 0.3999999999999999, 0.7348837209302324), (0.8, 0.3999999999999999, 0.7069767441860463), (0.8, 0.3999999999999999, 0.6790697674418602), (0.8, 0.3999999999999999, 0.651162790697674), (0.8, 0.3999999999999999, 0.6232558139534885), (0.8, 0.3999999999999999, 0.5953488372093024), (0.8, 0.3999999999999999, 0.5674418604651162), (0.8, 0.3999999999999999, 0.5395348837209302), (0.8, 0.3999999999999999, 0.5116279069767441), (0.8, 0.3999999999999999, 0.48372093023255797), (0.8, 0.3999999999999999, 0.45581395348837184), (0.8, 0.3999999999999999, 0.42790697674418576)],
    87: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42758620689655186, 0.3999999999999999), (0.8, 0.4551724137931033, 0.3999999999999999), (0.8, 0.48275862068965525, 0.3999999999999999), (0.8, 0.5103448275862067, 0.3999999999999999), (0.8, 0.5379310344827587, 0.3999999999999999), (0.8, 0.5655172413793101, 0.3999999999999999), (0.8, 0.593103448275862, 0.3999999999999999), (0.8, 0.6206896551724135, 0.3999999999999999), (0.8, 0.6482758620689655, 0.3999999999999999), (0.8, 0.6758620689655175, 0.3999999999999999), (0.8, 0.7034482758620688, 0.3999999999999999), (0.8, 0.7310344827586208, 0.3999999999999999), (0.8, 0.7586206896551723, 0.3999999999999999), (0.8, 0.7862068965517242, 0.3999999999999999), (0.7862068965517239, 0.8, 0.3999999999999999), (0.7586206896551726, 0.8, 0.3999999999999999), (0.731034482758621, 0.8, 0.3999999999999999), (0.7034482758620692, 0.8, 0.3999999999999999), (0.6758620689655173, 0.8, 0.3999999999999999), (0.6482758620689657, 0.8, 0.3999999999999999), (0.6206896551724138, 0.8, 0.3999999999999999), (0.5931034482758624, 0.8, 0.3999999999999999), (0.5655172413793104, 0.8, 0.3999999999999999), (0.5379310344827584, 0.8, 0.3999999999999999), (0.510344827586207, 0.8, 0.3999999999999999), (0.4827586206896555, 0.8, 0.3999999999999999), (0.4551724137931036, 0.8, 0.3999999999999999), (0.4275862068965516, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42758620689655175), (0.3999999999999999, 0.8, 0.4551724137931032), (0.3999999999999999, 0.8, 0.48275862068965514), (0.3999999999999999, 0.8, 0.5103448275862071), (0.3999999999999999, 0.8, 0.5379310344827586), (0.3999999999999999, 0.8, 0.5655172413793105), (0.3999999999999999, 0.8, 0.5931034482758619), (0.3999999999999999, 0.8, 0.6206896551724139), (0.3999999999999999, 0.8, 0.6482758620689659), (0.3999999999999999, 0.8, 0.6758620689655173), (0.3999999999999999, 0.8, 0.7034482758620688), (0.3999999999999999, 0.8, 0.7310344827586207), (0.3999999999999999, 0.8, 0.7586206896551726), (0.3999999999999999, 0.8, 0.7862068965517242), (0.3999999999999999, 0.7862068965517239, 0.8), (0.3999999999999999, 0.7586206896551726, 0.8), (0.3999999999999999, 0.7310344827586206, 0.8), (0.3999999999999999, 0.7034482758620686, 0.8), (0.3999999999999999, 0.6758620689655173, 0.8), (0.3999999999999999, 0.6482758620689657, 0.8), (0.3999999999999999, 0.6206896551724138, 0.8), (0.3999999999999999, 0.5931034482758618, 0.8), (0.3999999999999999, 0.5655172413793104, 0.8), (0.3999999999999999, 0.5379310344827584, 0.8), (0.3999999999999999, 0.510344827586207, 0.8), (0.3999999999999999, 0.482758620689655, 0.8), (0.3999999999999999, 0.455172413793103, 0.8), (0.3999999999999999, 0.4275862068965516, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.42758620689655136, 0.3999999999999999, 0.8), (0.4551724137931033, 0.3999999999999999, 0.8), (0.48275862068965525, 0.3999999999999999, 0.8), (0.5103448275862067, 0.3999999999999999, 0.8), (0.5379310344827581, 0.3999999999999999, 0.8), (0.5655172413793101, 0.3999999999999999, 0.8), (0.593103448275862, 0.3999999999999999, 0.8), (0.6206896551724135, 0.3999999999999999, 0.8), (0.6482758620689649, 0.3999999999999999, 0.8), (0.6758620689655169, 0.3999999999999999, 0.8), (0.7034482758620688, 0.3999999999999999, 0.8), (0.7310344827586208, 0.3999999999999999, 0.8), (0.7586206896551723, 0.3999999999999999, 0.8), (0.7862068965517237, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7862068965517239), (0.8, 0.3999999999999999, 0.7586206896551719), (0.8, 0.3999999999999999, 0.7310344827586206), (0.8, 0.3999999999999999, 0.7034482758620686), (0.8, 0.3999999999999999, 0.6758620689655173), (0.8, 0.3999999999999999, 0.6482758620689653), (0.8, 0.3999999999999999, 0.6206896551724133), (0.8, 0.3999999999999999, 0.5931034482758618), (0.8, 0.3999999999999999, 0.5655172413793104), (0.8, 0.3999999999999999, 0.5379310344827584), (0.8, 0.3999999999999999, 0.5103448275862065), (0.8, 0.3999999999999999, 0.482758620689655), (0.8, 0.3999999999999999, 0.455172413793103), (0.8, 0.3999999999999999, 0.4275862068965516)],
    88: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4272727272727274, 0.3999999999999999), (0.8, 0.4545454545454544, 0.3999999999999999), (0.8, 0.4818181818181819, 0.3999999999999999), (0.8, 0.5090909090909089, 0.3999999999999999), (0.8, 0.5363636363636365, 0.3999999999999999), (0.8, 0.5636363636363635, 0.3999999999999999), (0.8, 0.5909090909090909, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6454545454545455, 0.3999999999999999), (0.8, 0.6727272727272731, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7272727272727271, 0.3999999999999999), (0.8, 0.7545454545454545, 0.3999999999999999), (0.8, 0.781818181818182, 0.3999999999999999), (0.7909090909090912, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7363636363636366, 0.8, 0.3999999999999999), (0.7090909090909091, 0.8, 0.3999999999999999), (0.6818181818181821, 0.8, 0.3999999999999999), (0.6545454545454545, 0.8, 0.3999999999999999), (0.6272727272727271, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5727272727272731, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5181818181818181, 0.8, 0.3999999999999999), (0.4909090909090911, 0.8, 0.3999999999999999), (0.4636363636363635, 0.8, 0.3999999999999999), (0.4363636363636365, 0.8, 0.3999999999999999), (0.409090909090909, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41818181818181793), (0.3999999999999999, 0.8, 0.4454545454545455), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.527272727272727), (0.3999999999999999, 0.8, 0.5545454545454545), (0.3999999999999999, 0.8, 0.581818181818182), (0.3999999999999999, 0.8, 0.609090909090909), (0.3999999999999999, 0.8, 0.6363636363636366), (0.3999999999999999, 0.8, 0.6636363636363636), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.718181818181818), (0.3999999999999999, 0.8, 0.7454545454545456), (0.3999999999999999, 0.8, 0.7727272727272732), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7727272727272729, 0.8), (0.3999999999999999, 0.7454545454545454, 0.8), (0.3999999999999999, 0.7181818181818179, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6636363636363634, 0.8), (0.3999999999999999, 0.6363636363636359, 0.8), (0.3999999999999999, 0.6090909090909089, 0.8), (0.3999999999999999, 0.5818181818181819, 0.8), (0.3999999999999999, 0.5545454545454543, 0.8), (0.3999999999999999, 0.5272727272727269, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.4454545454545453, 0.8), (0.3999999999999999, 0.4181818181818178, 0.8), (0.4090909090909087, 0.3999999999999999, 0.8), (0.43636363636363623, 0.3999999999999999, 0.8), (0.4636363636363638, 0.3999999999999999, 0.8), (0.49090909090909074, 0.3999999999999999, 0.8), (0.5181818181818177, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5727272727272728, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6272727272727268, 0.3999999999999999, 0.8), (0.6545454545454543, 0.3999999999999999, 0.8), (0.6818181818181819, 0.3999999999999999, 0.8), (0.7090909090909088, 0.3999999999999999, 0.8), (0.7363636363636363, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.7909090909090908, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7818181818181817), (0.8, 0.3999999999999999, 0.7545454545454542), (0.8, 0.3999999999999999, 0.7272727272727267), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6727272727272728), (0.8, 0.3999999999999999, 0.6454545454545453), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.5909090909090907), (0.8, 0.3999999999999999, 0.5636363636363632), (0.8, 0.3999999999999999, 0.5363636363636357), (0.8, 0.3999999999999999, 0.5090909090909087), (0.8, 0.3999999999999999, 0.4818181818181817), (0.8, 0.3999999999999999, 0.45454545454545414), (0.8, 0.3999999999999999, 0.42727272727272664)],
    89: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42696629213483145, 0.3999999999999999), (0.8, 0.453932584269663, 0.3999999999999999), (0.8, 0.4808988764044945, 0.3999999999999999), (0.8, 0.5078651685393261, 0.3999999999999999), (0.8, 0.5348314606741571, 0.3999999999999999), (0.8, 0.5617977528089886, 0.3999999999999999), (0.8, 0.5887640449438202, 0.3999999999999999), (0.8, 0.6157303370786517, 0.3999999999999999), (0.8, 0.6426966292134833, 0.3999999999999999), (0.8, 0.6696629213483147, 0.3999999999999999), (0.8, 0.6966292134831462, 0.3999999999999999), (0.8, 0.7235955056179773, 0.3999999999999999), (0.8, 0.7505617977528087, 0.3999999999999999), (0.8, 0.7775280898876404, 0.3999999999999999), (0.7955056179775284, 0.8, 0.3999999999999999), (0.7685393258426968, 0.8, 0.3999999999999999), (0.7415730337078652, 0.8, 0.3999999999999999), (0.7146067415730337, 0.8, 0.3999999999999999), (0.6876404494382022, 0.8, 0.3999999999999999), (0.6606741573033706, 0.8, 0.3999999999999999), (0.6337078651685396, 0.8, 0.3999999999999999), (0.6067415730337081, 0.8, 0.3999999999999999), (0.5797752808988765, 0.8, 0.3999999999999999), (0.552808988764045, 0.8, 0.3999999999999999), (0.5258426966292135, 0.8, 0.3999999999999999), (0.4988764044943819, 0.8, 0.3999999999999999), (0.4719101123595504, 0.8, 0.3999999999999999), (0.4449438202247194, 0.8, 0.3999999999999999), (0.4179775280898873, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4089887640449436), (0.3999999999999999, 0.8, 0.43595505617977515), (0.3999999999999999, 0.8, 0.4629213483146067), (0.3999999999999999, 0.8, 0.4898876404494382), (0.3999999999999999, 0.8, 0.5168539325842698), (0.3999999999999999, 0.8, 0.5438202247191007), (0.3999999999999999, 0.8, 0.5707865168539328), (0.3999999999999999, 0.8, 0.5977528089887638), (0.3999999999999999, 0.8, 0.6247191011235954), (0.3999999999999999, 0.8, 0.6516853932584269), (0.3999999999999999, 0.8, 0.6786516853932585), (0.3999999999999999, 0.8, 0.70561797752809), (0.3999999999999999, 0.8, 0.7325842696629215), (0.3999999999999999, 0.8, 0.759550561797753), (0.3999999999999999, 0.8, 0.786516853932584), (0.3999999999999999, 0.786516853932584, 0.8), (0.3999999999999999, 0.7595505617977529, 0.8), (0.3999999999999999, 0.7325842696629215, 0.8), (0.3999999999999999, 0.7056179775280899, 0.8), (0.3999999999999999, 0.6786516853932583, 0.8), (0.3999999999999999, 0.6516853932584268, 0.8), (0.3999999999999999, 0.6247191011235957, 0.8), (0.3999999999999999, 0.5977528089887637, 0.8), (0.3999999999999999, 0.5707865168539327, 0.8), (0.3999999999999999, 0.5438202247191012, 0.8), (0.3999999999999999, 0.5168539325842696, 0.8), (0.3999999999999999, 0.4898876404494381, 0.8), (0.3999999999999999, 0.4629213483146066, 0.8), (0.3999999999999999, 0.43595505617977504, 0.8), (0.3999999999999999, 0.4089887640449435, 0.8), (0.4179775280898871, 0.3999999999999999, 0.8), (0.4449438202247191, 0.3999999999999999, 0.8), (0.47191011235955016, 0.3999999999999999, 0.8), (0.4988764044943817, 0.3999999999999999, 0.8), (0.5258426966292132, 0.3999999999999999, 0.8), (0.5528089887640447, 0.3999999999999999, 0.8), (0.5797752808988763, 0.3999999999999999, 0.8), (0.6067415730337072, 0.3999999999999999, 0.8), (0.6337078651685394, 0.3999999999999999, 0.8), (0.6606741573033703, 0.3999999999999999, 0.8), (0.6876404494382019, 0.3999999999999999, 0.8), (0.7146067415730335, 0.3999999999999999, 0.8), (0.741573033707865, 0.3999999999999999, 0.8), (0.7685393258426965, 0.3999999999999999, 0.8), (0.795505617977528, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.77752808988764), (0.8, 0.3999999999999999, 0.7505617977528091), (0.8, 0.3999999999999999, 0.723595505617977), (0.8, 0.3999999999999999, 0.696629213483146), (0.8, 0.3999999999999999, 0.6696629213483145), (0.8, 0.3999999999999999, 0.6426966292134829), (0.8, 0.3999999999999999, 0.6157303370786514), (0.8, 0.3999999999999999, 0.5887640449438198), (0.8, 0.3999999999999999, 0.5617977528089888), (0.8, 0.3999999999999999, 0.5348314606741568), (0.8, 0.3999999999999999, 0.5078651685393258), (0.8, 0.3999999999999999, 0.48089887640449425), (0.8, 0.3999999999999999, 0.4539325842696627), (0.8, 0.3999999999999999, 0.42696629213483117)],
    90: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42666666666666647, 0.3999999999999999), (0.8, 0.4533333333333331, 0.3999999999999999), (0.8, 0.4800000000000002, 0.3999999999999999), (0.8, 0.5066666666666668, 0.3999999999999999), (0.8, 0.5333333333333333, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.5866666666666664, 0.3999999999999999), (0.8, 0.6133333333333331, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6933333333333334, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.8, 0.7466666666666666, 0.3999999999999999), (0.8, 0.7733333333333331, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7733333333333334, 0.8, 0.3999999999999999), (0.7466666666666668, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6933333333333336, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6399999999999999, 0.8, 0.3999999999999999), (0.6133333333333334, 0.8, 0.3999999999999999), (0.5866666666666668, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.5333333333333337, 0.8, 0.3999999999999999), (0.5066666666666665, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.45333333333333337, 0.8, 0.3999999999999999), (0.42666666666666675, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.42666666666666686), (0.3999999999999999, 0.8, 0.4533333333333335), (0.3999999999999999, 0.8, 0.48000000000000004), (0.3999999999999999, 0.8, 0.5066666666666666), (0.3999999999999999, 0.8, 0.5333333333333332), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5866666666666669), (0.3999999999999999, 0.8, 0.6133333333333335), (0.3999999999999999, 0.8, 0.6400000000000001), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6933333333333332), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.8, 0.7466666666666669), (0.3999999999999999, 0.8, 0.7733333333333335), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7733333333333334, 0.8), (0.3999999999999999, 0.7466666666666668, 0.8), (0.3999999999999999, 0.7200000000000002, 0.8), (0.3999999999999999, 0.6933333333333331, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6399999999999999, 0.8), (0.3999999999999999, 0.6133333333333328, 0.8), (0.3999999999999999, 0.5866666666666662, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5333333333333331, 0.8), (0.3999999999999999, 0.5066666666666665, 0.8), (0.3999999999999999, 0.4799999999999999, 0.8), (0.3999999999999999, 0.45333333333333337, 0.8), (0.3999999999999999, 0.42666666666666675, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.42666666666666647, 0.3999999999999999, 0.8), (0.4533333333333331, 0.3999999999999999, 0.8), (0.4800000000000002, 0.3999999999999999, 0.8), (0.5066666666666668, 0.3999999999999999, 0.8), (0.5333333333333333, 0.3999999999999999, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.5866666666666664, 0.3999999999999999, 0.8), (0.6133333333333331, 0.3999999999999999, 0.8), (0.6399999999999997, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6933333333333334, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7466666666666666, 0.3999999999999999, 0.8), (0.7733333333333337, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7733333333333329), (0.8, 0.3999999999999999, 0.7466666666666663), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.6933333333333331), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6133333333333334), (0.8, 0.3999999999999999, 0.5866666666666662), (0.8, 0.3999999999999999, 0.5599999999999996), (0.8, 0.3999999999999999, 0.5333333333333325), (0.8, 0.3999999999999999, 0.5066666666666659), (0.8, 0.3999999999999999, 0.47999999999999937), (0.8, 0.3999999999999999, 0.4533333333333328), (0.8, 0.3999999999999999, 0.4266666666666662)],
    91: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4263736263736262, 0.3999999999999999), (0.8, 0.45274725274725247, 0.3999999999999999), (0.8, 0.4791208791208793, 0.3999999999999999), (0.8, 0.5054945054945056, 0.3999999999999999), (0.8, 0.5318681318681319, 0.3999999999999999), (0.8, 0.5582417582417581, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.6109890109890107, 0.3999999999999999), (0.8, 0.6373626373626375, 0.3999999999999999), (0.8, 0.6637362637362638, 0.3999999999999999), (0.8, 0.6901098901098901, 0.3999999999999999), (0.8, 0.7164835164835164, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.8, 0.7956043956043959, 0.3999999999999999), (0.7780219780219781, 0.8, 0.3999999999999999), (0.7516483516483518, 0.8, 0.3999999999999999), (0.7252747252747255, 0.8, 0.3999999999999999), (0.6989010989010992, 0.8, 0.3999999999999999), (0.6725274725274724, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.6197802197802198, 0.8, 0.3999999999999999), (0.5934065934065935, 0.8, 0.3999999999999999), (0.5670329670329672, 0.8, 0.3999999999999999), (0.540659340659341, 0.8, 0.3999999999999999), (0.5142857142857141, 0.8, 0.3999999999999999), (0.4879120879120878, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.43516483516483523, 0.8, 0.3999999999999999), (0.4087912087912084, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4175824175824178), (0.3999999999999999, 0.8, 0.44395604395604416), (0.3999999999999999, 0.8, 0.47032967032967044), (0.3999999999999999, 0.8, 0.4967032967032967), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.5494505494505493), (0.3999999999999999, 0.8, 0.5758241758241761), (0.3999999999999999, 0.8, 0.6021978021978024), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.654945054945055), (0.3999999999999999, 0.8, 0.6813186813186813), (0.3999999999999999, 0.8, 0.7076923076923081), (0.3999999999999999, 0.8, 0.7340659340659343), (0.3999999999999999, 0.8, 0.7604395604395606), (0.3999999999999999, 0.8, 0.7868131868131869), (0.3999999999999999, 0.7868131868131869, 0.8), (0.3999999999999999, 0.7604395604395605, 0.8), (0.3999999999999999, 0.7340659340659342, 0.8), (0.3999999999999999, 0.7076923076923074, 0.8), (0.3999999999999999, 0.6813186813186811, 0.8), (0.3999999999999999, 0.6549450549450548, 0.8), (0.3999999999999999, 0.628571428571428, 0.8), (0.3999999999999999, 0.6021978021978017, 0.8), (0.3999999999999999, 0.5758241758241754, 0.8), (0.3999999999999999, 0.5494505494505492, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.49670329670329655, 0.8), (0.3999999999999999, 0.47032967032967027, 0.8), (0.3999999999999999, 0.443956043956044, 0.8), (0.3999999999999999, 0.41758241758241715, 0.8), (0.40879120879120867, 0.3999999999999999, 0.8), (0.43516483516483495, 0.3999999999999999, 0.8), (0.4615384615384618, 0.3999999999999999, 0.8), (0.48791208791208807, 0.3999999999999999, 0.8), (0.5142857142857143, 0.3999999999999999, 0.8), (0.5406593406593406, 0.3999999999999999, 0.8), (0.5670329670329669, 0.3999999999999999, 0.8), (0.5934065934065932, 0.3999999999999999, 0.8), (0.6197802197802196, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.6725274725274726, 0.3999999999999999, 0.8), (0.6989010989010989, 0.3999999999999999, 0.8), (0.7252747252747251, 0.3999999999999999, 0.8), (0.7516483516483521, 0.3999999999999999, 0.8), (0.7780219780219784, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.795604395604395), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7164835164835162), (0.8, 0.3999999999999999, 0.6901098901098899), (0.8, 0.3999999999999999, 0.6637362637362636), (0.8, 0.3999999999999999, 0.6373626373626373), (0.8, 0.3999999999999999, 0.6109890109890105), (0.8, 0.3999999999999999, 0.5846153846153842), (0.8, 0.3999999999999999, 0.5582417582417574), (0.8, 0.3999999999999999, 0.5318681318681311), (0.8, 0.3999999999999999, 0.5054945054945048), (0.8, 0.3999999999999999, 0.47912087912087853), (0.8, 0.3999999999999999, 0.45274725274725225), (0.8, 0.3999999999999999, 0.4263736263736259)],
    92: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42608695652173917, 0.3999999999999999), (0.8, 0.4521739130434784, 0.3999999999999999), (0.8, 0.47826086956521713, 0.3999999999999999), (0.8, 0.5043478260869564, 0.3999999999999999), (0.8, 0.5304347826086957, 0.3999999999999999), (0.8, 0.5565217391304349, 0.3999999999999999), (0.8, 0.5826086956521741, 0.3999999999999999), (0.8, 0.6086956521739129, 0.3999999999999999), (0.8, 0.6347826086956522, 0.3999999999999999), (0.8, 0.6608695652173914, 0.3999999999999999), (0.8, 0.6869565217391307, 0.3999999999999999), (0.8, 0.7130434782608694, 0.3999999999999999), (0.8, 0.7391304347826086, 0.3999999999999999), (0.8, 0.7652173913043478, 0.3999999999999999), (0.8, 0.791304347826087, 0.3999999999999999), (0.7826086956521743, 0.8, 0.3999999999999999), (0.7565217391304351, 0.8, 0.3999999999999999), (0.7304347826086959, 0.8, 0.3999999999999999), (0.7043478260869566, 0.8, 0.3999999999999999), (0.6782608695652173, 0.8, 0.3999999999999999), (0.6521739130434786, 0.8, 0.3999999999999999), (0.6260869565217393, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5739130434782608, 0.8, 0.3999999999999999), (0.5478260869565216, 0.8, 0.3999999999999999), (0.5217391304347828, 0.8, 0.3999999999999999), (0.49565217391304356, 0.8, 0.3999999999999999), (0.4695652173913043, 0.8, 0.3999999999999999), (0.4434782608695651, 0.8, 0.3999999999999999), (0.4173913043478258, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40869565217391285), (0.3999999999999999, 0.8, 0.4347826086956521), (0.3999999999999999, 0.8, 0.46086956521739136), (0.3999999999999999, 0.8, 0.48695652173913007), (0.3999999999999999, 0.8, 0.5130434782608694), (0.3999999999999999, 0.8, 0.5391304347826086), (0.3999999999999999, 0.8, 0.5652173913043479), (0.3999999999999999, 0.8, 0.5913043478260871), (0.3999999999999999, 0.8, 0.6173913043478259), (0.3999999999999999, 0.8, 0.643478260869565), (0.3999999999999999, 0.8, 0.6695652173913044), (0.3999999999999999, 0.8, 0.6956521739130437), (0.3999999999999999, 0.8, 0.7217391304347829), (0.3999999999999999, 0.8, 0.7478260869565216), (0.3999999999999999, 0.8, 0.7739130434782608), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7739130434782613, 0.8), (0.3999999999999999, 0.7478260869565214, 0.8), (0.3999999999999999, 0.7217391304347827, 0.8), (0.3999999999999999, 0.6956521739130435, 0.8), (0.3999999999999999, 0.6695652173913043, 0.8), (0.3999999999999999, 0.6434782608695655, 0.8), (0.3999999999999999, 0.6173913043478257, 0.8), (0.3999999999999999, 0.591304347826087, 0.8), (0.3999999999999999, 0.5652173913043477, 0.8), (0.3999999999999999, 0.5391304347826085, 0.8), (0.3999999999999999, 0.5130434782608697, 0.8), (0.3999999999999999, 0.48695652173912995, 0.8), (0.3999999999999999, 0.46086956521739125, 0.8), (0.3999999999999999, 0.434782608695652, 0.8), (0.3999999999999999, 0.40869565217391274, 0.8), (0.41739130434782556, 0.3999999999999999, 0.8), (0.4434782608695648, 0.3999999999999999, 0.8), (0.4695652173913041, 0.3999999999999999, 0.8), (0.49565217391304334, 0.3999999999999999, 0.8), (0.5217391304347826, 0.3999999999999999, 0.8), (0.5478260869565212, 0.3999999999999999, 0.8), (0.5739130434782606, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6260869565217385, 0.3999999999999999, 0.8), (0.6521739130434783, 0.3999999999999999, 0.8), (0.678260869565217, 0.3999999999999999, 0.8), (0.7043478260869562, 0.3999999999999999, 0.8), (0.7304347826086955, 0.3999999999999999, 0.8), (0.7565217391304342, 0.3999999999999999, 0.8), (0.7826086956521741, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7913043478260868), (0.8, 0.3999999999999999, 0.7652173913043476), (0.8, 0.3999999999999999, 0.7391304347826084), (0.8, 0.3999999999999999, 0.7130434782608697), (0.8, 0.3999999999999999, 0.6869565217391298), (0.8, 0.3999999999999999, 0.6608695652173912), (0.8, 0.3999999999999999, 0.6347826086956518), (0.8, 0.3999999999999999, 0.6086956521739126), (0.8, 0.3999999999999999, 0.5826086956521739), (0.8, 0.3999999999999999, 0.5565217391304347), (0.8, 0.3999999999999999, 0.5304347826086954), (0.8, 0.3999999999999999, 0.5043478260869562), (0.8, 0.3999999999999999, 0.47826086956521685), (0.8, 0.3999999999999999, 0.45217391304347815), (0.8, 0.3999999999999999, 0.4260869565217389)],
    93: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4258064516129031, 0.3999999999999999), (0.8, 0.45161290322580633, 0.3999999999999999), (0.8, 0.47741935483870956, 0.3999999999999999), (0.8, 0.5032258064516127, 0.3999999999999999), (0.8, 0.5290322580645159, 0.3999999999999999), (0.8, 0.5548387096774192, 0.3999999999999999), (0.8, 0.5806451612903224, 0.3999999999999999), (0.8, 0.6064516129032256, 0.3999999999999999), (0.8, 0.6322580645161289, 0.3999999999999999), (0.8, 0.658064516129032, 0.3999999999999999), (0.8, 0.6838709677419352, 0.3999999999999999), (0.8, 0.7096774193548385, 0.3999999999999999), (0.8, 0.7354838709677423, 0.3999999999999999), (0.8, 0.7612903225806453, 0.3999999999999999), (0.8, 0.7870967741935486, 0.3999999999999999), (0.7870967741935484, 0.8, 0.3999999999999999), (0.7612903225806451, 0.8, 0.3999999999999999), (0.7354838709677419, 0.8, 0.3999999999999999), (0.7096774193548387, 0.8, 0.3999999999999999), (0.6838709677419355, 0.8, 0.3999999999999999), (0.6580645161290323, 0.8, 0.3999999999999999), (0.6322580645161291, 0.8, 0.3999999999999999), (0.6064516129032259, 0.8, 0.3999999999999999), (0.5806451612903226, 0.8, 0.3999999999999999), (0.5548387096774194, 0.8, 0.3999999999999999), (0.5290322580645163, 0.8, 0.3999999999999999), (0.5032258064516131, 0.8, 0.3999999999999999), (0.4774193548387098, 0.8, 0.3999999999999999), (0.4516129032258066, 0.8, 0.3999999999999999), (0.42580645161290287, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.42580645161290354), (0.3999999999999999, 0.8, 0.4516129032258067), (0.3999999999999999, 0.8, 0.47741935483870995), (0.3999999999999999, 0.8, 0.5032258064516132), (0.3999999999999999, 0.8, 0.5290322580645164), (0.3999999999999999, 0.8, 0.5548387096774196), (0.3999999999999999, 0.8, 0.5806451612903227), (0.3999999999999999, 0.8, 0.606451612903226), (0.3999999999999999, 0.8, 0.6322580645161292), (0.3999999999999999, 0.8, 0.6580645161290324), (0.3999999999999999, 0.8, 0.6838709677419357), (0.3999999999999999, 0.8, 0.7096774193548389), (0.3999999999999999, 0.8, 0.735483870967742), (0.3999999999999999, 0.8, 0.7612903225806453), (0.3999999999999999, 0.8, 0.7870967741935484), (0.3999999999999999, 0.7870967741935484, 0.8), (0.3999999999999999, 0.7612903225806451, 0.8), (0.3999999999999999, 0.7354838709677419, 0.8), (0.3999999999999999, 0.7096774193548387, 0.8), (0.3999999999999999, 0.6838709677419355, 0.8), (0.3999999999999999, 0.6580645161290323, 0.8), (0.3999999999999999, 0.6322580645161291, 0.8), (0.3999999999999999, 0.6064516129032259, 0.8), (0.3999999999999999, 0.5806451612903226, 0.8), (0.3999999999999999, 0.5548387096774194, 0.8), (0.3999999999999999, 0.5290322580645163, 0.8), (0.3999999999999999, 0.5032258064516131, 0.8), (0.3999999999999999, 0.4774193548387093, 0.8), (0.3999999999999999, 0.45161290322580605, 0.8), (0.3999999999999999, 0.42580645161290287, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.4258064516129031, 0.3999999999999999, 0.8), (0.45161290322580633, 0.3999999999999999, 0.8), (0.47741935483870956, 0.3999999999999999, 0.8), (0.5032258064516127, 0.3999999999999999, 0.8), (0.5290322580645159, 0.3999999999999999, 0.8), (0.5548387096774192, 0.3999999999999999, 0.8), (0.5806451612903224, 0.3999999999999999, 0.8), (0.6064516129032261, 0.3999999999999999, 0.8), (0.6322580645161293, 0.3999999999999999, 0.8), (0.6580645161290326, 0.3999999999999999, 0.8), (0.6838709677419358, 0.3999999999999999, 0.8), (0.709677419354839, 0.3999999999999999, 0.8), (0.7354838709677423, 0.3999999999999999, 0.8), (0.7612903225806453, 0.3999999999999999, 0.8), (0.7870967741935486, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7870967741935477), (0.8, 0.3999999999999999, 0.7612903225806447), (0.8, 0.3999999999999999, 0.7354838709677414), (0.8, 0.3999999999999999, 0.7096774193548382), (0.8, 0.3999999999999999, 0.683870967741935), (0.8, 0.3999999999999999, 0.6580645161290317), (0.8, 0.3999999999999999, 0.6322580645161285), (0.8, 0.3999999999999999, 0.6064516129032254), (0.8, 0.3999999999999999, 0.5806451612903221), (0.8, 0.3999999999999999, 0.5548387096774189), (0.8, 0.3999999999999999, 0.5290322580645157), (0.8, 0.3999999999999999, 0.5032258064516125), (0.8, 0.3999999999999999, 0.4774193548387093), (0.8, 0.3999999999999999, 0.45161290322580605), (0.8, 0.3999999999999999, 0.42580645161290287)],
    94: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4255319148936171, 0.3999999999999999), (0.8, 0.4510638297872338, 0.3999999999999999), (0.8, 0.476595744680851, 0.3999999999999999), (0.8, 0.5021276595744681, 0.3999999999999999), (0.8, 0.5276595744680849, 0.3999999999999999), (0.8, 0.553191489361702, 0.3999999999999999), (0.8, 0.5787234042553192, 0.3999999999999999), (0.8, 0.6042553191489359, 0.3999999999999999), (0.8, 0.6297872340425531, 0.3999999999999999), (0.8, 0.6553191489361703, 0.3999999999999999), (0.8, 0.6808510638297876, 0.3999999999999999), (0.8, 0.7063829787234042, 0.3999999999999999), (0.8, 0.7319148936170214, 0.3999999999999999), (0.8, 0.7574468085106385, 0.3999999999999999), (0.8, 0.7829787234042553, 0.3999999999999999), (0.7914893617021277, 0.8, 0.3999999999999999), (0.7659574468085105, 0.8, 0.3999999999999999), (0.7404255319148938, 0.8, 0.3999999999999999), (0.7148936170212767, 0.8, 0.3999999999999999), (0.6893617021276595, 0.8, 0.3999999999999999), (0.6638297872340428, 0.8, 0.3999999999999999), (0.6382978723404256, 0.8, 0.3999999999999999), (0.6127659574468084, 0.8, 0.3999999999999999), (0.5872340425531917, 0.8, 0.3999999999999999), (0.5617021276595745, 0.8, 0.3999999999999999), (0.5361702127659573, 0.8, 0.3999999999999999), (0.5106382978723407, 0.8, 0.3999999999999999), (0.48510638297872344, 0.8, 0.3999999999999999), (0.45957446808510627, 0.8, 0.3999999999999999), (0.4340425531914896, 0.8, 0.3999999999999999), (0.4085106382978724, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4170212765957447), (0.3999999999999999, 0.8, 0.44255319148936145), (0.3999999999999999, 0.8, 0.4680851063829786), (0.3999999999999999, 0.8, 0.4936170212765958), (0.3999999999999999, 0.8, 0.5191489361702125), (0.3999999999999999, 0.8, 0.5446808510638297), (0.3999999999999999, 0.8, 0.5702127659574469), (0.3999999999999999, 0.8, 0.5957446808510636), (0.3999999999999999, 0.8, 0.6212765957446807), (0.3999999999999999, 0.8, 0.6468085106382979), (0.3999999999999999, 0.8, 0.6723404255319146), (0.3999999999999999, 0.8, 0.6978723404255318), (0.3999999999999999, 0.8, 0.7234042553191491), (0.3999999999999999, 0.8, 0.7489361702127657), (0.3999999999999999, 0.8, 0.7744680851063829), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7744680851063833, 0.8), (0.3999999999999999, 0.7489361702127655, 0.8), (0.3999999999999999, 0.7234042553191489, 0.8), (0.3999999999999999, 0.6978723404255323, 0.8), (0.3999999999999999, 0.6723404255319145, 0.8), (0.3999999999999999, 0.6468085106382978, 0.8), (0.3999999999999999, 0.6212765957446812, 0.8), (0.3999999999999999, 0.5957446808510635, 0.8), (0.3999999999999999, 0.5702127659574467, 0.8), (0.3999999999999999, 0.5446808510638301, 0.8), (0.3999999999999999, 0.5191489361702124, 0.8), (0.3999999999999999, 0.4936170212765957, 0.8), (0.3999999999999999, 0.4680851063829785, 0.8), (0.3999999999999999, 0.4425531914893613, 0.8), (0.3999999999999999, 0.4170212765957446, 0.8), (0.40851063829787215, 0.3999999999999999, 0.8), (0.4340425531914893, 0.3999999999999999, 0.8), (0.459574468085106, 0.3999999999999999, 0.8), (0.4851063829787232, 0.3999999999999999, 0.8), (0.5106382978723404, 0.3999999999999999, 0.8), (0.5361702127659571, 0.3999999999999999, 0.8), (0.5617021276595743, 0.3999999999999999, 0.8), (0.5872340425531914, 0.3999999999999999, 0.8), (0.6127659574468082, 0.3999999999999999, 0.8), (0.6382978723404253, 0.3999999999999999, 0.8), (0.6638297872340426, 0.3999999999999999, 0.8), (0.6893617021276592, 0.3999999999999999, 0.8), (0.7148936170212764, 0.3999999999999999, 0.8), (0.7404255319148936, 0.3999999999999999, 0.8), (0.7659574468085103, 0.3999999999999999, 0.8), (0.7914893617021275, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7829787234042549), (0.8, 0.3999999999999999, 0.7574468085106383), (0.8, 0.3999999999999999, 0.7319148936170211), (0.8, 0.3999999999999999, 0.7063829787234039), (0.8, 0.3999999999999999, 0.6808510638297873), (0.8, 0.3999999999999999, 0.65531914893617), (0.8, 0.3999999999999999, 0.6297872340425529), (0.8, 0.3999999999999999, 0.6042553191489362), (0.8, 0.3999999999999999, 0.578723404255319), (0.8, 0.3999999999999999, 0.5531914893617018), (0.8, 0.3999999999999999, 0.5276595744680851), (0.8, 0.3999999999999999, 0.5021276595744679), (0.8, 0.3999999999999999, 0.4765957446808507), (0.8, 0.3999999999999999, 0.451063829787234), (0.8, 0.3999999999999999, 0.42553191489361686)],
    95: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42526315789473684, 0.3999999999999999), (0.8, 0.4505263157894738, 0.3999999999999999), (0.8, 0.4757894736842107, 0.3999999999999999), (0.8, 0.5010526315789471, 0.3999999999999999), (0.8, 0.5263157894736841, 0.3999999999999999), (0.8, 0.551578947368421, 0.3999999999999999), (0.8, 0.5768421052631578, 0.3999999999999999), (0.8, 0.6021052631578948, 0.3999999999999999), (0.8, 0.6273684210526318, 0.3999999999999999), (0.8, 0.6526315789473681, 0.3999999999999999), (0.8, 0.6778947368421051, 0.3999999999999999), (0.8, 0.703157894736842, 0.3999999999999999), (0.8, 0.7284210526315789, 0.3999999999999999), (0.8, 0.7536842105263158, 0.3999999999999999), (0.8, 0.7789473684210528, 0.3999999999999999), (0.7957894736842104, 0.8, 0.3999999999999999), (0.7705263157894735, 0.8, 0.3999999999999999), (0.7452631578947371, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6947368421052633, 0.8, 0.3999999999999999), (0.6694736842105264, 0.8, 0.3999999999999999), (0.6442105263157895, 0.8, 0.3999999999999999), (0.6189473684210525, 0.8, 0.3999999999999999), (0.5936842105263161, 0.8, 0.3999999999999999), (0.5684210526315792, 0.8, 0.3999999999999999), (0.5431578947368423, 0.8, 0.3999999999999999), (0.5178947368421053, 0.8, 0.3999999999999999), (0.4926315789473684, 0.8, 0.3999999999999999), (0.46736842105263143, 0.8, 0.3999999999999999), (0.4421052631578945, 0.8, 0.3999999999999999), (0.41684210526315757, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40842105263157874), (0.3999999999999999, 0.8, 0.43368421052631567), (0.3999999999999999, 0.8, 0.4589473684210526), (0.3999999999999999, 0.8, 0.48421052631578954), (0.3999999999999999, 0.8, 0.5094736842105265), (0.3999999999999999, 0.8, 0.5347368421052628), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5852631578947367), (0.3999999999999999, 0.8, 0.6105263157894737), (0.3999999999999999, 0.8, 0.6357894736842106), (0.3999999999999999, 0.8, 0.6610526315789476), (0.3999999999999999, 0.8, 0.6863157894736844), (0.3999999999999999, 0.8, 0.7115789473684213), (0.3999999999999999, 0.8, 0.7368421052631577), (0.3999999999999999, 0.8, 0.7621052631578946), (0.3999999999999999, 0.8, 0.7873684210526317), (0.3999999999999999, 0.7873684210526315, 0.8), (0.3999999999999999, 0.7621052631578951, 0.8), (0.3999999999999999, 0.7368421052631582, 0.8), (0.3999999999999999, 0.7115789473684213, 0.8), (0.3999999999999999, 0.6863157894736843, 0.8), (0.3999999999999999, 0.6610526315789473, 0.8), (0.3999999999999999, 0.6357894736842105, 0.8), (0.3999999999999999, 0.6105263157894735, 0.8), (0.3999999999999999, 0.5852631578947366, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5347368421052627, 0.8), (0.3999999999999999, 0.5094736842105263, 0.8), (0.3999999999999999, 0.4842105263157894, 0.8), (0.3999999999999999, 0.4589473684210525, 0.8), (0.3999999999999999, 0.43368421052631556, 0.8), (0.3999999999999999, 0.40842105263157913, 0.8), (0.41684210526315735, 0.3999999999999999, 0.8), (0.4421052631578943, 0.3999999999999999, 0.8), (0.4673684210526312, 0.3999999999999999, 0.8), (0.4926315789473681, 0.3999999999999999, 0.8), (0.5178947368421051, 0.3999999999999999, 0.8), (0.543157894736842, 0.3999999999999999, 0.8), (0.5684210526315789, 0.3999999999999999, 0.8), (0.5936842105263158, 0.3999999999999999, 0.8), (0.6189473684210528, 0.3999999999999999, 0.8), (0.6442105263157891, 0.3999999999999999, 0.8), (0.6694736842105261, 0.3999999999999999, 0.8), (0.6947368421052631, 0.3999999999999999, 0.8), (0.7199999999999994, 0.3999999999999999, 0.8), (0.7452631578947364, 0.3999999999999999, 0.8), (0.7705263157894733, 0.3999999999999999, 0.8), (0.7957894736842102, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7789473684210526), (0.8, 0.3999999999999999, 0.7536842105263155), (0.8, 0.3999999999999999, 0.7284210526315786), (0.8, 0.3999999999999999, 0.7031578947368418), (0.8, 0.3999999999999999, 0.6778947368421049), (0.8, 0.3999999999999999, 0.6526315789473679), (0.8, 0.3999999999999999, 0.6273684210526315), (0.8, 0.3999999999999999, 0.6021052631578946), (0.8, 0.3999999999999999, 0.5768421052631576), (0.8, 0.3999999999999999, 0.5515789473684207), (0.8, 0.3999999999999999, 0.5263157894736843), (0.8, 0.3999999999999999, 0.5010526315789474), (0.8, 0.3999999999999999, 0.47578947368421043), (0.8, 0.3999999999999999, 0.4505263157894735), (0.8, 0.3999999999999999, 0.42526315789473657)],
    96: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4250000000000001, 0.3999999999999999), (0.8, 0.44999999999999973, 0.3999999999999999), (0.8, 0.4749999999999999, 0.3999999999999999), (0.8, 0.5000000000000001, 0.3999999999999999), (0.8, 0.5249999999999998, 0.3999999999999999), (0.8, 0.5499999999999999, 0.3999999999999999), (0.8, 0.5750000000000002, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.625, 0.3999999999999999), (0.8, 0.6500000000000001, 0.3999999999999999), (0.8, 0.6749999999999998, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7250000000000002, 0.3999999999999999), (0.8, 0.7499999999999998, 0.3999999999999999), (0.8, 0.7750000000000001, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7750000000000004, 0.8, 0.3999999999999999), (0.7500000000000001, 0.8, 0.3999999999999999), (0.7249999999999999, 0.8, 0.3999999999999999), (0.7000000000000003, 0.8, 0.3999999999999999), (0.675, 0.8, 0.3999999999999999), (0.6499999999999999, 0.8, 0.3999999999999999), (0.6250000000000002, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5750000000000004, 0.8, 0.3999999999999999), (0.5500000000000003, 0.8, 0.3999999999999999), (0.525, 0.8, 0.3999999999999999), (0.5000000000000004, 0.8, 0.3999999999999999), (0.4750000000000002, 0.8, 0.3999999999999999), (0.45, 0.8, 0.3999999999999999), (0.4250000000000004, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42499999999999993), (0.3999999999999999, 0.8, 0.4499999999999996), (0.3999999999999999, 0.8, 0.4749999999999998), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5249999999999997), (0.3999999999999999, 0.8, 0.5499999999999998), (0.3999999999999999, 0.8, 0.575), (0.3999999999999999, 0.8, 0.5999999999999996), (0.3999999999999999, 0.8, 0.6249999999999999), (0.3999999999999999, 0.8, 0.65), (0.3999999999999999, 0.8, 0.6749999999999997), (0.3999999999999999, 0.8, 0.7), (0.3999999999999999, 0.8, 0.7250000000000001), (0.3999999999999999, 0.8, 0.7499999999999998), (0.3999999999999999, 0.8, 0.7749999999999999), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7750000000000004, 0.8), (0.3999999999999999, 0.7500000000000001, 0.8), (0.3999999999999999, 0.7249999999999999, 0.8), (0.3999999999999999, 0.7000000000000003, 0.8), (0.3999999999999999, 0.675, 0.8), (0.3999999999999999, 0.6499999999999999, 0.8), (0.3999999999999999, 0.6250000000000002, 0.8), (0.3999999999999999, 0.6000000000000001, 0.8), (0.3999999999999999, 0.5749999999999998, 0.8), (0.3999999999999999, 0.5500000000000003, 0.8), (0.3999999999999999, 0.525, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4750000000000002, 0.8), (0.3999999999999999, 0.45, 0.8), (0.3999999999999999, 0.4249999999999998, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.42499999999999954, 0.3999999999999999, 0.8), (0.44999999999999973, 0.3999999999999999, 0.8), (0.4749999999999994, 0.3999999999999999, 0.8), (0.4999999999999996, 0.3999999999999999, 0.8), (0.5249999999999998, 0.3999999999999999, 0.8), (0.5499999999999994, 0.3999999999999999, 0.8), (0.5749999999999996, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6249999999999994, 0.3999999999999999, 0.8), (0.6499999999999997, 0.3999999999999999, 0.8), (0.6749999999999998, 0.3999999999999999, 0.8), (0.6999999999999995, 0.3999999999999999, 0.8), (0.7249999999999996, 0.3999999999999999, 0.8), (0.7499999999999998, 0.3999999999999999, 0.8), (0.7749999999999995, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7749999999999998), (0.8, 0.3999999999999999, 0.7500000000000001), (0.8, 0.3999999999999999, 0.7249999999999999), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.675), (0.8, 0.3999999999999999, 0.6499999999999999), (0.8, 0.3999999999999999, 0.6249999999999998), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5749999999999998), (0.8, 0.3999999999999999, 0.5499999999999997), (0.8, 0.3999999999999999, 0.525), (0.8, 0.3999999999999999, 0.49999999999999983), (0.8, 0.3999999999999999, 0.47499999999999964), (0.8, 0.3999999999999999, 0.45), (0.8, 0.3999999999999999, 0.4249999999999998)],
    97: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42474226804123694, 0.3999999999999999), (0.8, 0.44948453608247396, 0.3999999999999999), (0.8, 0.474226804123711, 0.3999999999999999), (0.8, 0.49896907216494857, 0.3999999999999999), (0.8, 0.5237113402061856, 0.3999999999999999), (0.8, 0.5484536082474226, 0.3999999999999999), (0.8, 0.5731958762886596, 0.3999999999999999), (0.8, 0.5979381443298967, 0.3999999999999999), (0.8, 0.6226804123711343, 0.3999999999999999), (0.8, 0.6474226804123713, 0.3999999999999999), (0.8, 0.6721649484536083, 0.3999999999999999), (0.8, 0.6969072164948453, 0.3999999999999999), (0.8, 0.7216494845360824, 0.3999999999999999), (0.8, 0.7463917525773194, 0.3999999999999999), (0.8, 0.7711340206185565, 0.3999999999999999), (0.8, 0.7958762886597941, 0.3999999999999999), (0.7793814432989692, 0.8, 0.3999999999999999), (0.754639175257732, 0.8, 0.3999999999999999), (0.729896907216495, 0.8, 0.3999999999999999), (0.705154639175258, 0.8, 0.3999999999999999), (0.6804123711340204, 0.8, 0.3999999999999999), (0.6556701030927834, 0.8, 0.3999999999999999), (0.6309278350515464, 0.8, 0.3999999999999999), (0.6061855670103093, 0.8, 0.3999999999999999), (0.5814432989690723, 0.8, 0.3999999999999999), (0.5567010309278353, 0.8, 0.3999999999999999), (0.5319587628865983, 0.8, 0.3999999999999999), (0.5072164948453612, 0.8, 0.3999999999999999), (0.4824742268041236, 0.8, 0.3999999999999999), (0.4577319587628866, 0.8, 0.3999999999999999), (0.43298969072164956, 0.8, 0.3999999999999999), (0.40824742268041253, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.416494845360825), (0.3999999999999999, 0.8, 0.441237113402062), (0.3999999999999999, 0.8, 0.4659793814432991), (0.3999999999999999, 0.8, 0.4907216494845361), (0.3999999999999999, 0.8, 0.5154639175257731), (0.3999999999999999, 0.8, 0.5402061855670102), (0.3999999999999999, 0.8, 0.5649484536082472), (0.3999999999999999, 0.8, 0.5896907216494842), (0.3999999999999999, 0.8, 0.6144329896907218), (0.3999999999999999, 0.8, 0.6391752577319588), (0.3999999999999999, 0.8, 0.663917525773196), (0.3999999999999999, 0.8, 0.688659793814433), (0.3999999999999999, 0.8, 0.7134020618556705), (0.3999999999999999, 0.8, 0.7381443298969075), (0.3999999999999999, 0.8, 0.7628865979381445), (0.3999999999999999, 0.8, 0.7876288659793815), (0.3999999999999999, 0.7876288659793815, 0.8), (0.3999999999999999, 0.7628865979381444, 0.8), (0.3999999999999999, 0.7381443298969074, 0.8), (0.3999999999999999, 0.7134020618556703, 0.8), (0.3999999999999999, 0.6886597938144333, 0.8), (0.3999999999999999, 0.6639175257731957, 0.8), (0.3999999999999999, 0.6391752577319587, 0.8), (0.3999999999999999, 0.6144329896907217, 0.8), (0.3999999999999999, 0.5896907216494841, 0.8), (0.3999999999999999, 0.5649484536082471, 0.8), (0.3999999999999999, 0.54020618556701, 0.8), (0.3999999999999999, 0.515463917525773, 0.8), (0.3999999999999999, 0.490721649484536, 0.8), (0.3999999999999999, 0.4659793814432989, 0.8), (0.3999999999999999, 0.4412371134020619, 0.8), (0.3999999999999999, 0.4164948453608249, 0.8), (0.4082474226804117, 0.3999999999999999, 0.8), (0.4329896907216493, 0.3999999999999999, 0.8), (0.4577319587628863, 0.3999999999999999, 0.8), (0.48247422680412333, 0.3999999999999999, 0.8), (0.5072164948453609, 0.3999999999999999, 0.8), (0.5319587628865979, 0.3999999999999999, 0.8), (0.556701030927835, 0.3999999999999999, 0.8), (0.5814432989690721, 0.3999999999999999, 0.8), (0.606185567010309, 0.3999999999999999, 0.8), (0.6309278350515461, 0.3999999999999999, 0.8), (0.6556701030927832, 0.3999999999999999, 0.8), (0.6804123711340202, 0.3999999999999999, 0.8), (0.7051546391752572, 0.3999999999999999, 0.8), (0.7298969072164947, 0.3999999999999999, 0.8), (0.7546391752577317, 0.3999999999999999, 0.8), (0.7793814432989687, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7958762886597932), (0.8, 0.3999999999999999, 0.7711340206185562), (0.8, 0.3999999999999999, 0.7463917525773192), (0.8, 0.3999999999999999, 0.7216494845360821), (0.8, 0.3999999999999999, 0.6969072164948451), (0.8, 0.3999999999999999, 0.6721649484536081), (0.8, 0.3999999999999999, 0.647422680412371), (0.8, 0.3999999999999999, 0.622680412371134), (0.8, 0.3999999999999999, 0.597938144329897), (0.8, 0.3999999999999999, 0.5731958762886594), (0.8, 0.3999999999999999, 0.5484536082474224), (0.8, 0.3999999999999999, 0.5237113402061854), (0.8, 0.3999999999999999, 0.4989690721649478), (0.8, 0.3999999999999999, 0.47422680412371077), (0.8, 0.3999999999999999, 0.44948453608247374), (0.8, 0.3999999999999999, 0.42474226804123666)],
    98: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.424489795918367, 0.3999999999999999), (0.8, 0.4489795918367347, 0.3999999999999999), (0.8, 0.4734693877551018, 0.3999999999999999), (0.8, 0.4979591836734694, 0.3999999999999999), (0.8, 0.5224489795918366, 0.3999999999999999), (0.8, 0.5469387755102042, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.5959183673469389, 0.3999999999999999), (0.8, 0.6204081632653061, 0.3999999999999999), (0.8, 0.6448979591836732, 0.3999999999999999), (0.8, 0.6693877551020408, 0.3999999999999999), (0.8, 0.693877551020408, 0.3999999999999999), (0.8, 0.7183673469387757, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7673469387755104, 0.3999999999999999), (0.8, 0.7918367346938775, 0.3999999999999999), (0.783673469387755, 0.8, 0.3999999999999999), (0.759183673469388, 0.8, 0.3999999999999999), (0.7346938775510208, 0.8, 0.3999999999999999), (0.7102040816326531, 0.8, 0.3999999999999999), (0.685714285714286, 0.8, 0.3999999999999999), (0.6612244897959184, 0.8, 0.3999999999999999), (0.6367346938775513, 0.8, 0.3999999999999999), (0.6122448979591836, 0.8, 0.3999999999999999), (0.5877551020408165, 0.8, 0.3999999999999999), (0.5632653061224488, 0.8, 0.3999999999999999), (0.5387755102040818, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.489795918367347, 0.8, 0.3999999999999999), (0.46530612244897984, 0.8, 0.3999999999999999), (0.4408163265306122, 0.8, 0.3999999999999999), (0.4163265306122451, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4081632653061225), (0.3999999999999999, 0.8, 0.4326530612244896), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.4816326530612244), (0.3999999999999999, 0.8, 0.5061224489795915), (0.3999999999999999, 0.8, 0.5306122448979591), (0.3999999999999999, 0.8, 0.5551020408163263), (0.3999999999999999, 0.8, 0.5795918367346939), (0.3999999999999999, 0.8, 0.604081632653061), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6530612244897958), (0.3999999999999999, 0.8, 0.6775510204081634), (0.3999999999999999, 0.8, 0.7020408163265306), (0.3999999999999999, 0.8, 0.7265306122448977), (0.3999999999999999, 0.8, 0.7510204081632653), (0.3999999999999999, 0.8, 0.7755102040816331), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7755102040816328, 0.8), (0.3999999999999999, 0.7510204081632657, 0.8), (0.3999999999999999, 0.726530612244898, 0.8), (0.3999999999999999, 0.7020408163265304, 0.8), (0.3999999999999999, 0.6775510204081634, 0.8), (0.3999999999999999, 0.6530612244897962, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6040816326530609, 0.8), (0.3999999999999999, 0.5795918367346937, 0.8), (0.3999999999999999, 0.5551020408163266, 0.8), (0.3999999999999999, 0.5306122448979596, 0.8), (0.3999999999999999, 0.5061224489795919, 0.8), (0.3999999999999999, 0.48163265306122427, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.3999999999999999, 0.43265306122449004, 0.8), (0.3999999999999999, 0.40816326530612235, 0.8), (0.41632653061224484, 0.3999999999999999, 0.8), (0.4408163265306119, 0.3999999999999999, 0.8), (0.46530612244897906, 0.3999999999999999, 0.8), (0.48979591836734615, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5387755102040814, 0.3999999999999999, 0.8), (0.5632653061224486, 0.3999999999999999, 0.8), (0.5877551020408157, 0.3999999999999999, 0.8), (0.6122448979591834, 0.3999999999999999, 0.8), (0.636734693877551, 0.3999999999999999, 0.8), (0.6612244897959181, 0.3999999999999999, 0.8), (0.6857142857142853, 0.3999999999999999, 0.8), (0.7102040816326524, 0.3999999999999999, 0.8), (0.73469387755102, 0.3999999999999999, 0.8), (0.7591836734693876, 0.3999999999999999, 0.8), (0.7836734693877547, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7918367346938777), (0.8, 0.3999999999999999, 0.7673469387755101), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7183673469387754), (0.8, 0.3999999999999999, 0.6938775510204083), (0.8, 0.3999999999999999, 0.6693877551020411), (0.8, 0.3999999999999999, 0.6448979591836734), (0.8, 0.3999999999999999, 0.6204081632653058), (0.8, 0.3999999999999999, 0.5959183673469387), (0.8, 0.3999999999999999, 0.5714285714285716), (0.8, 0.3999999999999999, 0.546938775510204), (0.8, 0.3999999999999999, 0.5224489795918363), (0.8, 0.3999999999999999, 0.4979591836734692), (0.8, 0.3999999999999999, 0.47346938775510206), (0.8, 0.3999999999999999, 0.4489795918367344), (0.8, 0.3999999999999999, 0.4244897959183673)],
    99: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4242424242424243, 0.3999999999999999), (0.8, 0.4484848484848482, 0.3999999999999999), (0.8, 0.4727272727272726, 0.3999999999999999), (0.8, 0.496969696969697, 0.3999999999999999), (0.8, 0.5212121212121215, 0.3999999999999999), (0.8, 0.5454545454545453, 0.3999999999999999), (0.8, 0.5696969696969697, 0.3999999999999999), (0.8, 0.5939393939393941, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6424242424242423, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6909090909090907, 0.3999999999999999), (0.8, 0.7151515151515151, 0.3999999999999999), (0.8, 0.7393939393939395, 0.3999999999999999), (0.8, 0.7636363636363639, 0.3999999999999999), (0.8, 0.7878787878787878, 0.3999999999999999), (0.7878787878787881, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7393939393939393, 0.8, 0.3999999999999999), (0.7151515151515153, 0.8, 0.3999999999999999), (0.6909090909090909, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6424242424242427, 0.8, 0.3999999999999999), (0.6181818181818183, 0.8, 0.3999999999999999), (0.5939393939393939, 0.8, 0.3999999999999999), (0.5696969696969699, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5212121212121211, 0.8, 0.3999999999999999), (0.4969696969696973, 0.8, 0.3999999999999999), (0.4727272727272729, 0.8, 0.3999999999999999), (0.4484848484848485, 0.8, 0.3999999999999999), (0.42424242424242403, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.4242424242424242), (0.3999999999999999, 0.8, 0.4484848484848486), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.4969696969696969), (0.3999999999999999, 0.8, 0.5212121212121212), (0.3999999999999999, 0.8, 0.5454545454545456), (0.3999999999999999, 0.8, 0.5696969696969696), (0.3999999999999999, 0.8, 0.593939393939394), (0.3999999999999999, 0.8, 0.6181818181818184), (0.3999999999999999, 0.8, 0.6424242424242422), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7151515151515155), (0.3999999999999999, 0.8, 0.7393939393939399), (0.3999999999999999, 0.8, 0.7636363636363638), (0.3999999999999999, 0.8, 0.7878787878787881), (0.3999999999999999, 0.7878787878787874, 0.8), (0.3999999999999999, 0.7636363636363637, 0.8), (0.3999999999999999, 0.7393939393939393, 0.8), (0.3999999999999999, 0.7151515151515149, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6424242424242421, 0.8), (0.3999999999999999, 0.6181818181818183, 0.8), (0.3999999999999999, 0.5939393939393939, 0.8), (0.3999999999999999, 0.5696969696969694, 0.8), (0.3999999999999999, 0.5454545454545455, 0.8), (0.3999999999999999, 0.5212121212121206, 0.8), (0.3999999999999999, 0.49696969696969673, 0.8), (0.3999999999999999, 0.47272727272727233, 0.8), (0.3999999999999999, 0.44848484848484793, 0.8), (0.3999999999999999, 0.42424242424242403, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.4242424242424243, 0.3999999999999999, 0.8), (0.4484848484848482, 0.3999999999999999, 0.8), (0.4727272727272726, 0.3999999999999999, 0.8), (0.496969696969697, 0.3999999999999999, 0.8), (0.5212121212121209, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5696969696969697, 0.3999999999999999, 0.8), (0.5939393939393935, 0.3999999999999999, 0.8), (0.6181818181818185, 0.3999999999999999, 0.8), (0.6424242424242423, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6909090909090911, 0.3999999999999999, 0.8), (0.7151515151515151, 0.3999999999999999, 0.8), (0.7393939393939395, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.7878787878787878, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7878787878787874), (0.8, 0.3999999999999999, 0.7636363636363631), (0.8, 0.3999999999999999, 0.7393939393939393), (0.8, 0.3999999999999999, 0.7151515151515149), (0.8, 0.3999999999999999, 0.6909090909090905), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6424242424242416), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.5939393939393939), (0.8, 0.3999999999999999, 0.5696969696969689), (0.8, 0.3999999999999999, 0.545454545454545), (0.8, 0.3999999999999999, 0.5212121212121206), (0.8, 0.3999999999999999, 0.49696969696969623), (0.8, 0.3999999999999999, 0.47272727272727233), (0.8, 0.3999999999999999, 0.44848484848484793), (0.8, 0.3999999999999999, 0.42424242424242353)],
    100: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42399999999999993, 0.3999999999999999), (0.8, 0.44799999999999995, 0.3999999999999999), (0.8, 0.472, 0.3999999999999999), (0.8, 0.49600000000000005, 0.3999999999999999), (0.8, 0.52, 0.3999999999999999), (0.8, 0.544, 0.3999999999999999), (0.8, 0.5680000000000001, 0.3999999999999999), (0.8, 0.5920000000000002, 0.3999999999999999), (0.8, 0.6160000000000002, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6640000000000003, 0.3999999999999999), (0.8, 0.6880000000000003, 0.3999999999999999), (0.8, 0.7119999999999997, 0.3999999999999999), (0.8, 0.7360000000000003, 0.3999999999999999), (0.8, 0.7599999999999998, 0.3999999999999999), (0.8, 0.7839999999999998, 0.3999999999999999), (0.7920000000000003, 0.8, 0.3999999999999999), (0.7680000000000002, 0.8, 0.3999999999999999), (0.7440000000000002, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6960000000000002, 0.8, 0.3999999999999999), (0.6720000000000002, 0.8, 0.3999999999999999), (0.6480000000000001, 0.8, 0.3999999999999999), (0.6240000000000001, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5760000000000001, 0.8, 0.3999999999999999), (0.552, 0.8, 0.3999999999999999), (0.528, 0.8, 0.3999999999999999), (0.504, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.4559999999999999, 0.8, 0.3999999999999999), (0.4319999999999999, 0.8, 0.3999999999999999), (0.4079999999999998, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41600000000000015), (0.3999999999999999, 0.8, 0.44000000000000017), (0.3999999999999999, 0.8, 0.4639999999999997), (0.3999999999999999, 0.8, 0.4880000000000002), (0.3999999999999999, 0.8, 0.5119999999999998), (0.3999999999999999, 0.8, 0.5360000000000003), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5840000000000003), (0.3999999999999999, 0.8, 0.6079999999999999), (0.3999999999999999, 0.8, 0.6319999999999999), (0.3999999999999999, 0.8, 0.6559999999999999), (0.3999999999999999, 0.8, 0.6799999999999999), (0.3999999999999999, 0.8, 0.704), (0.3999999999999999, 0.8, 0.728), (0.3999999999999999, 0.8, 0.752), (0.3999999999999999, 0.8, 0.776), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.776, 0.8), (0.3999999999999999, 0.7519999999999999, 0.8), (0.3999999999999999, 0.7279999999999999, 0.8), (0.3999999999999999, 0.7039999999999998, 0.8), (0.3999999999999999, 0.6799999999999998, 0.8), (0.3999999999999999, 0.6559999999999998, 0.8), (0.3999999999999999, 0.6319999999999998, 0.8), (0.3999999999999999, 0.6079999999999998, 0.8), (0.3999999999999999, 0.5840000000000003, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5360000000000001, 0.8), (0.3999999999999999, 0.5119999999999996, 0.8), (0.3999999999999999, 0.4880000000000001, 0.8), (0.3999999999999999, 0.4639999999999995, 0.8), (0.3999999999999999, 0.44000000000000006, 0.8), (0.3999999999999999, 0.4159999999999995, 0.8), (0.4079999999999996, 0.3999999999999999, 0.8), (0.4320000000000001, 0.3999999999999999, 0.8), (0.45599999999999963, 0.3999999999999999, 0.8), (0.4800000000000002, 0.3999999999999999, 0.8), (0.5039999999999997, 0.3999999999999999, 0.8), (0.5279999999999997, 0.3999999999999999, 0.8), (0.5519999999999997, 0.3999999999999999, 0.8), (0.5759999999999997, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6239999999999999, 0.3999999999999999, 0.8), (0.6479999999999999, 0.3999999999999999, 0.8), (0.6719999999999999, 0.3999999999999999, 0.8), (0.696, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.744, 0.3999999999999999, 0.8), (0.768, 0.3999999999999999, 0.8), (0.792, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.784), (0.8, 0.3999999999999999, 0.7599999999999996), (0.8, 0.3999999999999999, 0.736), (0.8, 0.3999999999999999, 0.7119999999999995), (0.8, 0.3999999999999999, 0.688), (0.8, 0.3999999999999999, 0.6639999999999995), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6159999999999994), (0.8, 0.3999999999999999, 0.5919999999999999), (0.8, 0.3999999999999999, 0.5679999999999993), (0.8, 0.3999999999999999, 0.5439999999999998), (0.8, 0.3999999999999999, 0.5199999999999992), (0.8, 0.3999999999999999, 0.4959999999999998), (0.8, 0.3999999999999999, 0.47199999999999975), (0.8, 0.3999999999999999, 0.44799999999999973), (0.8, 0.3999999999999999, 0.42399999999999965)],
    101: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4237623762376237, 0.3999999999999999), (0.8, 0.4475247524752475, 0.3999999999999999), (0.8, 0.47128712871287126, 0.3999999999999999), (0.8, 0.4950495049504951, 0.3999999999999999), (0.8, 0.5188118811881188, 0.3999999999999999), (0.8, 0.5425742574257426, 0.3999999999999999), (0.8, 0.5663366336633664, 0.3999999999999999), (0.8, 0.5900990099009903, 0.3999999999999999), (0.8, 0.6138613861386141, 0.3999999999999999), (0.8, 0.6376237623762379, 0.3999999999999999), (0.8, 0.6613861386138616, 0.3999999999999999), (0.8, 0.6851485148514854, 0.3999999999999999), (0.8, 0.7089108910891092, 0.3999999999999999), (0.8, 0.732673267326733, 0.3999999999999999), (0.8, 0.7564356435643562, 0.3999999999999999), (0.8, 0.78019801980198, 0.3999999999999999), (0.7960396039603963, 0.8, 0.3999999999999999), (0.7722772277227725, 0.8, 0.3999999999999999), (0.7485148514851487, 0.8, 0.3999999999999999), (0.724752475247525, 0.8, 0.3999999999999999), (0.7009900990099012, 0.8, 0.3999999999999999), (0.6772277227722774, 0.8, 0.3999999999999999), (0.6534653465346536, 0.8, 0.3999999999999999), (0.6297029702970298, 0.8, 0.3999999999999999), (0.605940594059406, 0.8, 0.3999999999999999), (0.5821782178217823, 0.8, 0.3999999999999999), (0.5584158415841585, 0.8, 0.3999999999999999), (0.5346534653465347, 0.8, 0.3999999999999999), (0.5108910891089109, 0.8, 0.3999999999999999), (0.48712871287128706, 0.8, 0.3999999999999999), (0.4633663366336633, 0.8, 0.3999999999999999), (0.4396039603960395, 0.8, 0.3999999999999999), (0.41584158415841566, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40792079207920806), (0.3999999999999999, 0.8, 0.43168316831683184), (0.3999999999999999, 0.8, 0.45544554455445513), (0.3999999999999999, 0.8, 0.4792079207920789), (0.3999999999999999, 0.8, 0.5029702970297028), (0.3999999999999999, 0.8, 0.5267326732673265), (0.3999999999999999, 0.8, 0.5504950495049503), (0.3999999999999999, 0.8, 0.5742574257425741), (0.3999999999999999, 0.8, 0.5980198019801979), (0.3999999999999999, 0.8, 0.6217821782178217), (0.3999999999999999, 0.8, 0.6455445544554455), (0.3999999999999999, 0.8, 0.6693069306930692), (0.3999999999999999, 0.8, 0.693069306930693), (0.3999999999999999, 0.8, 0.7168316831683168), (0.3999999999999999, 0.8, 0.7405940594059406), (0.3999999999999999, 0.8, 0.7643564356435644), (0.3999999999999999, 0.8, 0.7881188118811882), (0.3999999999999999, 0.7881188118811882, 0.8), (0.3999999999999999, 0.7643564356435643, 0.8), (0.3999999999999999, 0.7405940594059405, 0.8), (0.3999999999999999, 0.7168316831683167, 0.8), (0.3999999999999999, 0.6930693069306929, 0.8), (0.3999999999999999, 0.6693069306930691, 0.8), (0.3999999999999999, 0.6455445544554453, 0.8), (0.3999999999999999, 0.6217821782178216, 0.8), (0.3999999999999999, 0.5980198019801978, 0.8), (0.3999999999999999, 0.5742574257425739, 0.8), (0.3999999999999999, 0.5504950495049501, 0.8), (0.3999999999999999, 0.5267326732673263, 0.8), (0.3999999999999999, 0.5029702970297025, 0.8), (0.3999999999999999, 0.47920792079207875, 0.8), (0.3999999999999999, 0.45544554455445496, 0.8), (0.3999999999999999, 0.4316831683168312, 0.8), (0.3999999999999999, 0.4079207920792074, 0.8), (0.41584158415841593, 0.3999999999999999, 0.8), (0.4396039603960397, 0.3999999999999999, 0.8), (0.46336633663366356, 0.3999999999999999, 0.8), (0.4871287128712868, 0.3999999999999999, 0.8), (0.5108910891089106, 0.3999999999999999, 0.8), (0.5346534653465344, 0.3999999999999999, 0.8), (0.5584158415841581, 0.3999999999999999, 0.8), (0.582178217821782, 0.3999999999999999, 0.8), (0.6059405940594057, 0.3999999999999999, 0.8), (0.6297029702970296, 0.3999999999999999, 0.8), (0.6534653465346534, 0.3999999999999999, 0.8), (0.6772277227722772, 0.3999999999999999, 0.8), (0.700990099009901, 0.3999999999999999, 0.8), (0.7247524752475247, 0.3999999999999999, 0.8), (0.7485148514851485, 0.3999999999999999, 0.8), (0.7722772277227723, 0.3999999999999999, 0.8), (0.7960396039603956, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7801980198019802), (0.8, 0.3999999999999999, 0.7564356435643564), (0.8, 0.3999999999999999, 0.7326732673267327), (0.8, 0.3999999999999999, 0.7089108910891089), (0.8, 0.3999999999999999, 0.6851485148514851), (0.8, 0.3999999999999999, 0.6613861386138613), (0.8, 0.3999999999999999, 0.6376237623762375), (0.8, 0.3999999999999999, 0.6138613861386137), (0.8, 0.3999999999999999, 0.59009900990099), (0.8, 0.3999999999999999, 0.5663366336633662), (0.8, 0.3999999999999999, 0.5425742574257424), (0.8, 0.3999999999999999, 0.5188118811881186), (0.8, 0.3999999999999999, 0.4950495049504948), (0.8, 0.3999999999999999, 0.47128712871287104), (0.8, 0.3999999999999999, 0.44752475247524726), (0.8, 0.3999999999999999, 0.4237623762376234)],
    102: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4235294117647057, 0.3999999999999999), (0.8, 0.4470588235294115, 0.3999999999999999), (0.8, 0.4705882352941173, 0.3999999999999999), (0.8, 0.49411764705882366, 0.3999999999999999), (0.8, 0.5176470588235295, 0.3999999999999999), (0.8, 0.5411764705882353, 0.3999999999999999), (0.8, 0.5647058823529411, 0.3999999999999999), (0.8, 0.5882352941176469, 0.3999999999999999), (0.8, 0.6117647058823527, 0.3999999999999999), (0.8, 0.635294117647059, 0.3999999999999999), (0.8, 0.6588235294117648, 0.3999999999999999), (0.8, 0.6823529411764706, 0.3999999999999999), (0.8, 0.7058823529411764, 0.3999999999999999), (0.8, 0.7294117647058822, 0.3999999999999999), (0.8, 0.752941176470588, 0.3999999999999999), (0.8, 0.7764705882352938, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7764705882352942, 0.8, 0.3999999999999999), (0.7529411764705883, 0.8, 0.3999999999999999), (0.7294117647058825, 0.8, 0.3999999999999999), (0.7058823529411767, 0.8, 0.3999999999999999), (0.6823529411764704, 0.8, 0.3999999999999999), (0.6588235294117646, 0.8, 0.3999999999999999), (0.6352941176470588, 0.8, 0.3999999999999999), (0.611764705882353, 0.8, 0.3999999999999999), (0.5882352941176472, 0.8, 0.3999999999999999), (0.5647058823529414, 0.8, 0.3999999999999999), (0.5411764705882356, 0.8, 0.3999999999999999), (0.5176470588235298, 0.8, 0.3999999999999999), (0.4941176470588234, 0.8, 0.3999999999999999), (0.4705882352941176, 0.8, 0.3999999999999999), (0.4470588235294118, 0.8, 0.3999999999999999), (0.423529411764706, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4235294117647061), (0.3999999999999999, 0.8, 0.44705882352941195), (0.3999999999999999, 0.8, 0.47058823529411775), (0.3999999999999999, 0.8, 0.49411764705882355), (0.3999999999999999, 0.8, 0.5176470588235293), (0.3999999999999999, 0.8, 0.5411764705882351), (0.3999999999999999, 0.8, 0.564705882352941), (0.3999999999999999, 0.8, 0.5882352941176467), (0.3999999999999999, 0.8, 0.6117647058823531), (0.3999999999999999, 0.8, 0.6352941176470589), (0.3999999999999999, 0.8, 0.6588235294117647), (0.3999999999999999, 0.8, 0.6823529411764706), (0.3999999999999999, 0.8, 0.7058823529411764), (0.3999999999999999, 0.8, 0.7294117647058826), (0.3999999999999999, 0.8, 0.7529411764705884), (0.3999999999999999, 0.8, 0.7764705882352942), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7764705882352942, 0.8), (0.3999999999999999, 0.7529411764705883, 0.8), (0.3999999999999999, 0.7294117647058825, 0.8), (0.3999999999999999, 0.7058823529411767, 0.8), (0.3999999999999999, 0.6823529411764704, 0.8), (0.3999999999999999, 0.6588235294117646, 0.8), (0.3999999999999999, 0.6352941176470588, 0.8), (0.3999999999999999, 0.611764705882353, 0.8), (0.3999999999999999, 0.5882352941176466, 0.8), (0.3999999999999999, 0.5647058823529408, 0.8), (0.3999999999999999, 0.541176470588235, 0.8), (0.3999999999999999, 0.5176470588235292, 0.8), (0.3999999999999999, 0.4941176470588234, 0.8), (0.3999999999999999, 0.4705882352941176, 0.8), (0.3999999999999999, 0.4470588235294118, 0.8), (0.3999999999999999, 0.423529411764706, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4235294117647057, 0.3999999999999999, 0.8), (0.4470588235294115, 0.3999999999999999, 0.8), (0.4705882352941173, 0.3999999999999999, 0.8), (0.49411764705882316, 0.3999999999999999, 0.8), (0.5176470588235295, 0.3999999999999999, 0.8), (0.5411764705882353, 0.3999999999999999, 0.8), (0.5647058823529411, 0.3999999999999999, 0.8), (0.5882352941176469, 0.3999999999999999, 0.8), (0.6117647058823527, 0.3999999999999999, 0.8), (0.6352941176470586, 0.3999999999999999, 0.8), (0.6588235294117644, 0.3999999999999999, 0.8), (0.6823529411764702, 0.3999999999999999, 0.8), (0.705882352941176, 0.3999999999999999, 0.8), (0.7294117647058822, 0.3999999999999999, 0.8), (0.752941176470588, 0.3999999999999999, 0.8), (0.7764705882352938, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7764705882352936), (0.8, 0.3999999999999999, 0.7529411764705878), (0.8, 0.3999999999999999, 0.729411764705882), (0.8, 0.3999999999999999, 0.7058823529411762), (0.8, 0.3999999999999999, 0.6823529411764704), (0.8, 0.3999999999999999, 0.6588235294117646), (0.8, 0.3999999999999999, 0.6352941176470588), (0.8, 0.3999999999999999, 0.611764705882353), (0.8, 0.3999999999999999, 0.5882352941176472), (0.8, 0.3999999999999999, 0.5647058823529408), (0.8, 0.3999999999999999, 0.541176470588235), (0.8, 0.3999999999999999, 0.5176470588235292), (0.8, 0.3999999999999999, 0.4941176470588229), (0.8, 0.3999999999999999, 0.4705882352941171), (0.8, 0.3999999999999999, 0.4470588235294113), (0.8, 0.3999999999999999, 0.42352941176470543)],
    103: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4233009708737863, 0.3999999999999999), (0.8, 0.44660194174757273, 0.3999999999999999), (0.8, 0.46990291262135914, 0.3999999999999999), (0.8, 0.49320388349514555, 0.3999999999999999), (0.8, 0.5165048543689319, 0.3999999999999999), (0.8, 0.5398058252427184, 0.3999999999999999), (0.8, 0.5631067961165047, 0.3999999999999999), (0.8, 0.5864077669902912, 0.3999999999999999), (0.8, 0.6097087378640775, 0.3999999999999999), (0.8, 0.633009708737864, 0.3999999999999999), (0.8, 0.6563106796116503, 0.3999999999999999), (0.8, 0.6796116504854368, 0.3999999999999999), (0.8, 0.7029126213592232, 0.3999999999999999), (0.8, 0.7262135922330095, 0.3999999999999999), (0.8, 0.749514563106796, 0.3999999999999999), (0.8, 0.7728155339805824, 0.3999999999999999), (0.8, 0.7961165048543688, 0.3999999999999999), (0.7805825242718449, 0.8, 0.3999999999999999), (0.7572815533980586, 0.8, 0.3999999999999999), (0.7339805825242722, 0.8, 0.3999999999999999), (0.7106796116504858, 0.8, 0.3999999999999999), (0.6873786407766993, 0.8, 0.3999999999999999), (0.664077669902913, 0.8, 0.3999999999999999), (0.6407766990291266, 0.8, 0.3999999999999999), (0.6174757281553401, 0.8, 0.3999999999999999), (0.5941747572815538, 0.8, 0.3999999999999999), (0.5708737864077673, 0.8, 0.3999999999999999), (0.547572815533981, 0.8, 0.3999999999999999), (0.5242718446601945, 0.8, 0.3999999999999999), (0.5009708737864081, 0.8, 0.3999999999999999), (0.4776699029126217, 0.8, 0.3999999999999999), (0.4543689320388353, 0.8, 0.3999999999999999), (0.4310679611650489, 0.8, 0.3999999999999999), (0.4077669902912625, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4155339805825239), (0.3999999999999999, 0.8, 0.4388349514563103), (0.3999999999999999, 0.8, 0.4621359223300967), (0.3999999999999999, 0.8, 0.48543689320388306), (0.3999999999999999, 0.8, 0.5087378640776695), (0.3999999999999999, 0.8, 0.5320388349514559), (0.3999999999999999, 0.8, 0.5553398058252428), (0.3999999999999999, 0.8, 0.5786407766990292), (0.3999999999999999, 0.8, 0.6019417475728156), (0.3999999999999999, 0.8, 0.6252427184466021), (0.3999999999999999, 0.8, 0.6485436893203884), (0.3999999999999999, 0.8, 0.6718446601941749), (0.3999999999999999, 0.8, 0.6951456310679613), (0.3999999999999999, 0.8, 0.7184466019417477), (0.3999999999999999, 0.8, 0.741747572815534), (0.3999999999999999, 0.8, 0.7650485436893205), (0.3999999999999999, 0.8, 0.788349514563107), (0.3999999999999999, 0.7883495145631068, 0.8), (0.3999999999999999, 0.7650485436893204, 0.8), (0.3999999999999999, 0.7417475728155339, 0.8), (0.3999999999999999, 0.7184466019417475, 0.8), (0.3999999999999999, 0.6951456310679611, 0.8), (0.3999999999999999, 0.6718446601941748, 0.8), (0.3999999999999999, 0.6485436893203883, 0.8), (0.3999999999999999, 0.625242718446602, 0.8), (0.3999999999999999, 0.6019417475728155, 0.8), (0.3999999999999999, 0.5786407766990291, 0.8), (0.3999999999999999, 0.5553398058252427, 0.8), (0.3999999999999999, 0.5320388349514563, 0.8), (0.3999999999999999, 0.5087378640776699, 0.8), (0.3999999999999999, 0.4854368932038835, 0.8), (0.3999999999999999, 0.4621359223300971, 0.8), (0.3999999999999999, 0.4388349514563107, 0.8), (0.3999999999999999, 0.4155339805825243, 0.8), (0.4077669902912617, 0.3999999999999999, 0.8), (0.4310679611650481, 0.3999999999999999, 0.8), (0.4543689320388345, 0.3999999999999999, 0.8), (0.4776699029126209, 0.3999999999999999, 0.8), (0.5009708737864074, 0.3999999999999999, 0.8), (0.5242718446601937, 0.3999999999999999, 0.8), (0.5475728155339801, 0.3999999999999999, 0.8), (0.5708737864077665, 0.3999999999999999, 0.8), (0.5941747572815529, 0.3999999999999999, 0.8), (0.6174757281553394, 0.3999999999999999, 0.8), (0.6407766990291257, 0.3999999999999999, 0.8), (0.6640776699029122, 0.3999999999999999, 0.8), (0.6873786407766991, 0.3999999999999999, 0.8), (0.7106796116504854, 0.3999999999999999, 0.8), (0.7339805825242719, 0.3999999999999999, 0.8), (0.7572815533980584, 0.3999999999999999, 0.8), (0.7805825242718447, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7961165048543686), (0.8, 0.3999999999999999, 0.7728155339805821), (0.8, 0.3999999999999999, 0.7495145631067957), (0.8, 0.3999999999999999, 0.7262135922330093), (0.8, 0.3999999999999999, 0.7029126213592229), (0.8, 0.3999999999999999, 0.6796116504854366), (0.8, 0.3999999999999999, 0.6563106796116501), (0.8, 0.3999999999999999, 0.6330097087378637), (0.8, 0.3999999999999999, 0.6097087378640773), (0.8, 0.3999999999999999, 0.586407766990291), (0.8, 0.3999999999999999, 0.5631067961165045), (0.8, 0.3999999999999999, 0.539805825242718), (0.8, 0.3999999999999999, 0.5165048543689317), (0.8, 0.3999999999999999, 0.49320388349514527), (0.8, 0.3999999999999999, 0.46990291262135886), (0.8, 0.3999999999999999, 0.44660194174757245), (0.8, 0.3999999999999999, 0.42330097087378604)],
    104: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4230769230769229, 0.3999999999999999), (0.8, 0.4461538461538459, 0.3999999999999999), (0.8, 0.4692307692307689, 0.3999999999999999), (0.8, 0.49230769230769245, 0.3999999999999999), (0.8, 0.5153846153846154, 0.3999999999999999), (0.8, 0.5384615384615384, 0.3999999999999999), (0.8, 0.5615384615384614, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.6076923076923074, 0.3999999999999999), (0.8, 0.630769230769231, 0.3999999999999999), (0.8, 0.653846153846154, 0.3999999999999999), (0.8, 0.676923076923077, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.723076923076923, 0.3999999999999999), (0.8, 0.746153846153846, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.8, 0.7923076923076926, 0.3999999999999999), (0.7846153846153847, 0.8, 0.3999999999999999), (0.7615384615384616, 0.8, 0.3999999999999999), (0.7384615384615386, 0.8, 0.3999999999999999), (0.7153846153846156, 0.8, 0.3999999999999999), (0.6923076923076921, 0.8, 0.3999999999999999), (0.6692307692307691, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.6230769230769231, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5769230769230771, 0.8, 0.3999999999999999), (0.5538461538461541, 0.8, 0.3999999999999999), (0.5307692307692311, 0.8, 0.3999999999999999), (0.5076923076923076, 0.8, 0.3999999999999999), (0.4846153846153845, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.4384615384615385, 0.8, 0.3999999999999999), (0.4153846153846155, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40769230769230796), (0.3999999999999999, 0.8, 0.43076923076923096), (0.3999999999999999, 0.8, 0.453846153846154), (0.3999999999999999, 0.8, 0.476923076923077), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.546153846153846), (0.3999999999999999, 0.8, 0.569230769230769), (0.3999999999999999, 0.8, 0.5923076923076925), (0.3999999999999999, 0.8, 0.6153846153846155), (0.3999999999999999, 0.8, 0.6384615384615385), (0.3999999999999999, 0.8, 0.6615384615384615), (0.3999999999999999, 0.8, 0.6846153846153846), (0.3999999999999999, 0.8, 0.7076923076923081), (0.3999999999999999, 0.8, 0.7307692307692311), (0.3999999999999999, 0.8, 0.753846153846154), (0.3999999999999999, 0.8, 0.776923076923077), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.776923076923077, 0.8), (0.3999999999999999, 0.7538461538461539, 0.8), (0.3999999999999999, 0.730769230769231, 0.8), (0.3999999999999999, 0.7076923076923074, 0.8), (0.3999999999999999, 0.6846153846153844, 0.8), (0.3999999999999999, 0.6615384615384614, 0.8), (0.3999999999999999, 0.6384615384615384, 0.8), (0.3999999999999999, 0.6153846153846149, 0.8), (0.3999999999999999, 0.5923076923076919, 0.8), (0.3999999999999999, 0.5692307692307689, 0.8), (0.3999999999999999, 0.5461538461538459, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.47692307692307684, 0.8), (0.3999999999999999, 0.45384615384615384, 0.8), (0.3999999999999999, 0.43076923076923085, 0.8), (0.3999999999999999, 0.4076923076923073, 0.8), (0.41538461538461524, 0.3999999999999999, 0.8), (0.43846153846153824, 0.3999999999999999, 0.8), (0.46153846153846123, 0.3999999999999999, 0.8), (0.4846153846153848, 0.3999999999999999, 0.8), (0.5076923076923078, 0.3999999999999999, 0.8), (0.5307692307692308, 0.3999999999999999, 0.8), (0.5538461538461538, 0.3999999999999999, 0.8), (0.5769230769230768, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6230769230769229, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.6692307692307689, 0.3999999999999999, 0.8), (0.6923076923076923, 0.3999999999999999, 0.8), (0.7153846153846153, 0.3999999999999999, 0.8), (0.7384615384615383, 0.3999999999999999, 0.8), (0.7615384615384619, 0.3999999999999999, 0.8), (0.7846153846153849, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7923076923076917), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7461538461538457), (0.8, 0.3999999999999999, 0.7230769230769227), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6769230769230767), (0.8, 0.3999999999999999, 0.6538461538461537), (0.8, 0.3999999999999999, 0.6307692307692307), (0.8, 0.3999999999999999, 0.6076923076923072), (0.8, 0.3999999999999999, 0.5846153846153842), (0.8, 0.3999999999999999, 0.5615384615384612), (0.8, 0.3999999999999999, 0.5384615384615377), (0.8, 0.3999999999999999, 0.5153846153846147), (0.8, 0.3999999999999999, 0.49230769230769167), (0.8, 0.3999999999999999, 0.4692307692307687), (0.8, 0.3999999999999999, 0.4461538461538457), (0.8, 0.3999999999999999, 0.42307692307692263)],
    105: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4228571428571427, 0.3999999999999999), (0.8, 0.4457142857142855, 0.3999999999999999), (0.8, 0.46857142857142825, 0.3999999999999999), (0.8, 0.49142857142857155, 0.3999999999999999), (0.8, 0.5142857142857143, 0.3999999999999999), (0.8, 0.5371428571428571, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.5828571428571427, 0.3999999999999999), (0.8, 0.6057142857142855, 0.3999999999999999), (0.8, 0.6285714285714288, 0.3999999999999999), (0.8, 0.6514285714285716, 0.3999999999999999), (0.8, 0.6742857142857144, 0.3999999999999999), (0.8, 0.6971428571428572, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7657142857142856, 0.3999999999999999), (0.8, 0.7885714285714289, 0.3999999999999999), (0.7885714285714285, 0.8, 0.3999999999999999), (0.7657142857142858, 0.8, 0.3999999999999999), (0.742857142857143, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6971428571428568, 0.8, 0.3999999999999999), (0.6742857142857142, 0.8, 0.3999999999999999), (0.6514285714285714, 0.8, 0.3999999999999999), (0.6285714285714286, 0.8, 0.3999999999999999), (0.6057142857142858, 0.8, 0.3999999999999999), (0.582857142857143, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.5371428571428574, 0.8, 0.3999999999999999), (0.5142857142857141, 0.8, 0.3999999999999999), (0.4914285714285713, 0.8, 0.3999999999999999), (0.4685714285714285, 0.8, 0.3999999999999999), (0.44571428571428573, 0.8, 0.3999999999999999), (0.42285714285714293, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.4228571428571431), (0.3999999999999999, 0.8, 0.4457142857142859), (0.3999999999999999, 0.8, 0.46857142857142864), (0.3999999999999999, 0.8, 0.49142857142857144), (0.3999999999999999, 0.8, 0.5142857142857142), (0.3999999999999999, 0.8, 0.537142857142857), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5828571428571432), (0.3999999999999999, 0.8, 0.6057142857142859), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6514285714285715), (0.3999999999999999, 0.8, 0.6742857142857143), (0.3999999999999999, 0.8, 0.6971428571428575), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.8, 0.7428571428571431), (0.3999999999999999, 0.8, 0.7657142857142859), (0.3999999999999999, 0.8, 0.7885714285714287), (0.3999999999999999, 0.7885714285714285, 0.8), (0.3999999999999999, 0.7657142857142858, 0.8), (0.3999999999999999, 0.742857142857143, 0.8), (0.3999999999999999, 0.7199999999999998, 0.8), (0.3999999999999999, 0.6971428571428568, 0.8), (0.3999999999999999, 0.6742857142857142, 0.8), (0.3999999999999999, 0.6514285714285714, 0.8), (0.3999999999999999, 0.628571428571428, 0.8), (0.3999999999999999, 0.6057142857142852, 0.8), (0.3999999999999999, 0.5828571428571425, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5371428571428569, 0.8), (0.3999999999999999, 0.5142857142857141, 0.8), (0.3999999999999999, 0.4914285714285713, 0.8), (0.3999999999999999, 0.4685714285714285, 0.8), (0.3999999999999999, 0.44571428571428573, 0.8), (0.3999999999999999, 0.42285714285714243, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.4228571428571427, 0.3999999999999999, 0.8), (0.4457142857142855, 0.3999999999999999, 0.8), (0.4685714285714288, 0.3999999999999999, 0.8), (0.49142857142857155, 0.3999999999999999, 0.8), (0.5142857142857143, 0.3999999999999999, 0.8), (0.5371428571428571, 0.3999999999999999, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.5828571428571427, 0.3999999999999999, 0.8), (0.6057142857142855, 0.3999999999999999, 0.8), (0.6285714285714283, 0.3999999999999999, 0.8), (0.651428571428571, 0.3999999999999999, 0.8), (0.6742857142857144, 0.3999999999999999, 0.8), (0.6971428571428572, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7428571428571433, 0.3999999999999999, 0.8), (0.765714285714286, 0.3999999999999999, 0.8), (0.7885714285714289, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.788571428571428), (0.8, 0.3999999999999999, 0.7657142857142852), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.6971428571428568), (0.8, 0.3999999999999999, 0.6742857142857142), (0.8, 0.3999999999999999, 0.6514285714285714), (0.8, 0.3999999999999999, 0.628571428571428), (0.8, 0.3999999999999999, 0.6057142857142852), (0.8, 0.3999999999999999, 0.5828571428571425), (0.8, 0.3999999999999999, 0.5599999999999992), (0.8, 0.3999999999999999, 0.5371428571428564), (0.8, 0.3999999999999999, 0.5142857142857136), (0.8, 0.3999999999999999, 0.49142857142857077), (0.8, 0.3999999999999999, 0.468571428571428), (0.8, 0.3999999999999999, 0.44571428571428523), (0.8, 0.3999999999999999, 0.42285714285714243)],
    106: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42264150943396245, 0.3999999999999999), (0.8, 0.44528301886792443, 0.3999999999999999), (0.8, 0.46792452830188697, 0.3999999999999999), (0.8, 0.49056603773584895, 0.3999999999999999), (0.8, 0.5132075471698115, 0.3999999999999999), (0.8, 0.5358490566037735, 0.3999999999999999), (0.8, 0.5584905660377361, 0.3999999999999999), (0.8, 0.581132075471698, 0.3999999999999999), (0.8, 0.6037735849056606, 0.3999999999999999), (0.8, 0.6264150943396226, 0.3999999999999999), (0.8, 0.6490566037735851, 0.3999999999999999), (0.8, 0.6716981132075471, 0.3999999999999999), (0.8, 0.6943396226415097, 0.3999999999999999), (0.8, 0.7169811320754716, 0.3999999999999999), (0.8, 0.7396226415094342, 0.3999999999999999), (0.8, 0.7622641509433962, 0.3999999999999999), (0.8, 0.7849056603773588, 0.3999999999999999), (0.7924528301886795, 0.8, 0.3999999999999999), (0.7698113207547169, 0.8, 0.3999999999999999), (0.747169811320755, 0.8, 0.3999999999999999), (0.7245283018867924, 0.8, 0.3999999999999999), (0.7018867924528305, 0.8, 0.3999999999999999), (0.6792452830188679, 0.8, 0.3999999999999999), (0.6566037735849058, 0.8, 0.3999999999999999), (0.6339622641509434, 0.8, 0.3999999999999999), (0.6113207547169813, 0.8, 0.3999999999999999), (0.5886792452830188, 0.8, 0.3999999999999999), (0.5660377358490568, 0.8, 0.3999999999999999), (0.5433962264150942, 0.8, 0.3999999999999999), (0.5207547169811323, 0.8, 0.3999999999999999), (0.49811320754716976, 0.8, 0.3999999999999999), (0.4754716981132077, 0.8, 0.3999999999999999), (0.4528301886792452, 0.8, 0.3999999999999999), (0.4301886792452832, 0.8, 0.3999999999999999), (0.40754716981132066, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4150943396226413), (0.3999999999999999, 0.8, 0.43773584905660384), (0.3999999999999999, 0.8, 0.4603773584905658), (0.3999999999999999, 0.8, 0.48301886792452836), (0.3999999999999999, 0.8, 0.5056603773584903), (0.3999999999999999, 0.8, 0.5283018867924529), (0.3999999999999999, 0.8, 0.5509433962264149), (0.3999999999999999, 0.8, 0.5735849056603775), (0.3999999999999999, 0.8, 0.5962264150943394), (0.3999999999999999, 0.8, 0.618867924528302), (0.3999999999999999, 0.8, 0.641509433962264), (0.3999999999999999, 0.8, 0.6641509433962265), (0.3999999999999999, 0.8, 0.6867924528301885), (0.3999999999999999, 0.8, 0.709433962264151), (0.3999999999999999, 0.8, 0.7320754716981135), (0.3999999999999999, 0.8, 0.7547169811320755), (0.3999999999999999, 0.8, 0.7773584905660376), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7773584905660373, 0.8), (0.3999999999999999, 0.7547169811320754, 0.8), (0.3999999999999999, 0.7320754716981135, 0.8), (0.3999999999999999, 0.7094339622641509, 0.8), (0.3999999999999999, 0.6867924528301883, 0.8), (0.3999999999999999, 0.6641509433962264, 0.8), (0.3999999999999999, 0.6415094339622643, 0.8), (0.3999999999999999, 0.6188679245283019, 0.8), (0.3999999999999999, 0.5962264150943393, 0.8), (0.3999999999999999, 0.5735849056603772, 0.8), (0.3999999999999999, 0.5509433962264153, 0.8), (0.3999999999999999, 0.5283018867924527, 0.8), (0.3999999999999999, 0.5056603773584902, 0.8), (0.3999999999999999, 0.4830188679245282, 0.8), (0.3999999999999999, 0.4603773584905662, 0.8), (0.3999999999999999, 0.4377358490566037, 0.8), (0.3999999999999999, 0.41509433962264114, 0.8), (0.4075471698113204, 0.3999999999999999, 0.8), (0.4301886792452824, 0.3999999999999999, 0.8), (0.45283018867924496, 0.3999999999999999, 0.8), (0.47547169811320744, 0.3999999999999999, 0.8), (0.4981132075471695, 0.3999999999999999, 0.8), (0.5207547169811315, 0.3999999999999999, 0.8), (0.543396226415094, 0.3999999999999999, 0.8), (0.5660377358490565, 0.3999999999999999, 0.8), (0.5886792452830185, 0.3999999999999999, 0.8), (0.6113207547169806, 0.3999999999999999, 0.8), (0.633962264150943, 0.3999999999999999, 0.8), (0.6566037735849056, 0.3999999999999999, 0.8), (0.6792452830188676, 0.3999999999999999, 0.8), (0.7018867924528296, 0.3999999999999999, 0.8), (0.7245283018867921, 0.3999999999999999, 0.8), (0.7471698113207547, 0.3999999999999999, 0.8), (0.7698113207547167, 0.3999999999999999, 0.8), (0.7924528301886786, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7849056603773585), (0.8, 0.3999999999999999, 0.7622641509433958), (0.8, 0.3999999999999999, 0.7396226415094339), (0.8, 0.3999999999999999, 0.716981132075472), (0.8, 0.3999999999999999, 0.6943396226415094), (0.8, 0.3999999999999999, 0.6716981132075468), (0.8, 0.3999999999999999, 0.6490566037735849), (0.8, 0.3999999999999999, 0.6264150943396223), (0.8, 0.3999999999999999, 0.6037735849056604), (0.8, 0.3999999999999999, 0.5811320754716978), (0.8, 0.3999999999999999, 0.5584905660377353), (0.8, 0.3999999999999999, 0.5358490566037732), (0.8, 0.3999999999999999, 0.5132075471698112), (0.8, 0.3999999999999999, 0.4905660377358487), (0.8, 0.3999999999999999, 0.4679245283018862), (0.8, 0.3999999999999999, 0.4452830188679242), (0.8, 0.3999999999999999, 0.42264150943396217)],
    107: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4224299065420557, 0.3999999999999999), (0.8, 0.4448598130841121, 0.3999999999999999), (0.8, 0.4672897196261679, 0.3999999999999999), (0.8, 0.48971962616822423, 0.3999999999999999), (0.8, 0.5121495327102801, 0.3999999999999999), (0.8, 0.5345794392523364, 0.3999999999999999), (0.8, 0.5570093457943922, 0.3999999999999999), (0.8, 0.5794392523364486, 0.3999999999999999), (0.8, 0.6018691588785045, 0.3999999999999999), (0.8, 0.6242990654205608, 0.3999999999999999), (0.8, 0.6467289719626166, 0.3999999999999999), (0.8, 0.6691588785046729, 0.3999999999999999), (0.8, 0.6915887850467288, 0.3999999999999999), (0.8, 0.7140186915887852, 0.3999999999999999), (0.8, 0.7364485981308408, 0.3999999999999999), (0.8, 0.7588785046728972, 0.3999999999999999), (0.8, 0.7813084112149531, 0.3999999999999999), (0.7962616822429907, 0.8, 0.3999999999999999), (0.773831775700935, 0.8, 0.3999999999999999), (0.7514018691588786, 0.8, 0.3999999999999999), (0.7289719626168227, 0.8, 0.3999999999999999), (0.7065420560747664, 0.8, 0.3999999999999999), (0.6841121495327106, 0.8, 0.3999999999999999), (0.6616822429906543, 0.8, 0.3999999999999999), (0.6392523364485985, 0.8, 0.3999999999999999), (0.6168224299065421, 0.8, 0.3999999999999999), (0.5943925233644862, 0.8, 0.3999999999999999), (0.5719626168224299, 0.8, 0.3999999999999999), (0.5495327102803741, 0.8, 0.3999999999999999), (0.5271028037383177, 0.8, 0.3999999999999999), (0.504672897196262, 0.8, 0.3999999999999999), (0.48224299065420556, 0.8, 0.3999999999999999), (0.4598130841121497, 0.8, 0.3999999999999999), (0.4373831775700934, 0.8, 0.3999999999999999), (0.4149532710280376, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40747663551401875), (0.3999999999999999, 0.8, 0.42990654205607454), (0.3999999999999999, 0.8, 0.45233644859813094), (0.3999999999999999, 0.8, 0.4747663551401867), (0.3999999999999999, 0.8, 0.49719626168224307), (0.3999999999999999, 0.8, 0.5196261682242989), (0.3999999999999999, 0.8, 0.5420560747663552), (0.3999999999999999, 0.8, 0.5644859813084111), (0.3999999999999999, 0.8, 0.5869158878504674), (0.3999999999999999, 0.8, 0.6093457943925232), (0.3999999999999999, 0.8, 0.6317757009345796), (0.3999999999999999, 0.8, 0.6542056074766354), (0.3999999999999999, 0.8, 0.6766355140186917), (0.3999999999999999, 0.8, 0.6990654205607476), (0.3999999999999999, 0.8, 0.7214953271028034), (0.3999999999999999, 0.8, 0.7439252336448597), (0.3999999999999999, 0.8, 0.7663551401869161), (0.3999999999999999, 0.8, 0.7887850467289719), (0.3999999999999999, 0.7887850467289723, 0.8), (0.3999999999999999, 0.766355140186916, 0.8), (0.3999999999999999, 0.7439252336448596, 0.8), (0.3999999999999999, 0.7214953271028037, 0.8), (0.3999999999999999, 0.699065420560748, 0.8), (0.3999999999999999, 0.6766355140186917, 0.8), (0.3999999999999999, 0.6542056074766353, 0.8), (0.3999999999999999, 0.6317757009345795, 0.8), (0.3999999999999999, 0.6093457943925237, 0.8), (0.3999999999999999, 0.5869158878504672, 0.8), (0.3999999999999999, 0.5644859813084109, 0.8), (0.3999999999999999, 0.5420560747663551, 0.8), (0.3999999999999999, 0.5196261682242993, 0.8), (0.3999999999999999, 0.49719626168224296, 0.8), (0.3999999999999999, 0.4747663551401866, 0.8), (0.3999999999999999, 0.45233644859813077, 0.8), (0.3999999999999999, 0.429906542056075, 0.8), (0.3999999999999999, 0.4074766355140186, 0.8), (0.4149532710280373, 0.3999999999999999, 0.8), (0.4373831775700931, 0.3999999999999999, 0.8), (0.45981308411214894, 0.3999999999999999, 0.8), (0.4822429906542053, 0.3999999999999999, 0.8), (0.5046728971962616, 0.3999999999999999, 0.8), (0.5271028037383174, 0.3999999999999999, 0.8), (0.5495327102803733, 0.3999999999999999, 0.8), (0.5719626168224297, 0.3999999999999999, 0.8), (0.594392523364486, 0.3999999999999999, 0.8), (0.6168224299065418, 0.3999999999999999, 0.8), (0.6392523364485976, 0.3999999999999999, 0.8), (0.6616822429906539, 0.3999999999999999, 0.8), (0.6841121495327103, 0.3999999999999999, 0.8), (0.7065420560747662, 0.3999999999999999, 0.8), (0.728971962616822, 0.3999999999999999, 0.8), (0.7514018691588783, 0.3999999999999999, 0.8), (0.7738317757009346, 0.3999999999999999, 0.8), (0.7962616822429904, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7813084112149533), (0.8, 0.3999999999999999, 0.758878504672897), (0.8, 0.3999999999999999, 0.7364485981308406), (0.8, 0.3999999999999999, 0.7140186915887848), (0.8, 0.3999999999999999, 0.691588785046729), (0.8, 0.3999999999999999, 0.6691588785046727), (0.8, 0.3999999999999999, 0.6467289719626168), (0.8, 0.3999999999999999, 0.624299065420561), (0.8, 0.3999999999999999, 0.6018691588785047), (0.8, 0.3999999999999999, 0.5794392523364483), (0.8, 0.3999999999999999, 0.5570093457943925), (0.8, 0.3999999999999999, 0.5345794392523366), (0.8, 0.3999999999999999, 0.5121495327102803), (0.8, 0.3999999999999999, 0.48971962616822395), (0.8, 0.3999999999999999, 0.46728971962616817), (0.8, 0.3999999999999999, 0.4448598130841124), (0.8, 0.3999999999999999, 0.422429906542056)],
    108: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4222222222222222, 0.3999999999999999), (0.8, 0.4444444444444446, 0.3999999999999999), (0.8, 0.46666666666666634, 0.3999999999999999), (0.8, 0.4888888888888887, 0.3999999999999999), (0.8, 0.5111111111111111, 0.3999999999999999), (0.8, 0.5333333333333333, 0.3999999999999999), (0.8, 0.5555555555555557, 0.3999999999999999), (0.8, 0.5777777777777775, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6222222222222221, 0.3999999999999999), (0.8, 0.6444444444444445, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6888888888888891, 0.3999999999999999), (0.8, 0.7111111111111109, 0.3999999999999999), (0.8, 0.7333333333333332, 0.3999999999999999), (0.8, 0.7555555555555555, 0.3999999999999999), (0.8, 0.7777777777777779, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7777777777777777, 0.8, 0.3999999999999999), (0.7555555555555558, 0.8, 0.3999999999999999), (0.7333333333333335, 0.8, 0.3999999999999999), (0.7111111111111112, 0.8, 0.3999999999999999), (0.6888888888888889, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6444444444444447, 0.8, 0.3999999999999999), (0.6222222222222225, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5777777777777777, 0.8, 0.3999999999999999), (0.5555555555555554, 0.8, 0.3999999999999999), (0.5333333333333337, 0.8, 0.3999999999999999), (0.5111111111111113, 0.8, 0.3999999999999999), (0.48888888888888893, 0.8, 0.3999999999999999), (0.4666666666666666, 0.8, 0.3999999999999999), (0.4444444444444443, 0.8, 0.3999999999999999), (0.4222222222222225, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4222222222222221), (0.3999999999999999, 0.8, 0.4444444444444444), (0.3999999999999999, 0.8, 0.4666666666666668), (0.3999999999999999, 0.8, 0.48888888888888854), (0.3999999999999999, 0.8, 0.5111111111111108), (0.3999999999999999, 0.8, 0.5333333333333332), (0.3999999999999999, 0.8, 0.5555555555555556), (0.3999999999999999, 0.8, 0.5777777777777778), (0.3999999999999999, 0.8, 0.5999999999999996), (0.3999999999999999, 0.8, 0.6222222222222226), (0.3999999999999999, 0.8, 0.6444444444444444), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.688888888888889), (0.3999999999999999, 0.8, 0.7111111111111108), (0.3999999999999999, 0.8, 0.7333333333333336), (0.3999999999999999, 0.8, 0.7555555555555554), (0.3999999999999999, 0.8, 0.7777777777777777), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7777777777777781, 0.8), (0.3999999999999999, 0.7555555555555553, 0.8), (0.3999999999999999, 0.7333333333333335, 0.8), (0.3999999999999999, 0.7111111111111112, 0.8), (0.3999999999999999, 0.6888888888888889, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6444444444444442, 0.8), (0.3999999999999999, 0.6222222222222225, 0.8), (0.3999999999999999, 0.6000000000000001, 0.8), (0.3999999999999999, 0.5777777777777777, 0.8), (0.3999999999999999, 0.5555555555555554, 0.8), (0.3999999999999999, 0.5333333333333331, 0.8), (0.3999999999999999, 0.5111111111111113, 0.8), (0.3999999999999999, 0.48888888888888893, 0.8), (0.3999999999999999, 0.4666666666666666, 0.8), (0.3999999999999999, 0.4444444444444443, 0.8), (0.3999999999999999, 0.42222222222222194, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4222222222222222, 0.3999999999999999, 0.8), (0.44444444444444403, 0.3999999999999999, 0.8), (0.46666666666666634, 0.3999999999999999, 0.8), (0.4888888888888887, 0.3999999999999999, 0.8), (0.5111111111111105, 0.3999999999999999, 0.8), (0.5333333333333333, 0.3999999999999999, 0.8), (0.5555555555555551, 0.3999999999999999, 0.8), (0.5777777777777775, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6222222222222216, 0.3999999999999999, 0.8), (0.6444444444444445, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6888888888888887, 0.3999999999999999, 0.8), (0.7111111111111109, 0.3999999999999999, 0.8), (0.7333333333333327, 0.3999999999999999, 0.8), (0.7555555555555555, 0.3999999999999999, 0.8), (0.7777777777777775, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7777777777777777), (0.8, 0.3999999999999999, 0.7555555555555553), (0.8, 0.3999999999999999, 0.733333333333333), (0.8, 0.3999999999999999, 0.7111111111111112), (0.8, 0.3999999999999999, 0.6888888888888889), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6444444444444442), (0.8, 0.3999999999999999, 0.6222222222222219), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5777777777777777), (0.8, 0.3999999999999999, 0.5555555555555554), (0.8, 0.3999999999999999, 0.5333333333333331), (0.8, 0.3999999999999999, 0.5111111111111107), (0.8, 0.3999999999999999, 0.48888888888888893), (0.8, 0.3999999999999999, 0.4666666666666661), (0.8, 0.3999999999999999, 0.4444444444444443), (0.8, 0.3999999999999999, 0.42222222222222194)],
    109: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.422018348623853, 0.3999999999999999), (0.8, 0.4440366972477061, 0.3999999999999999), (0.8, 0.4660550458715597, 0.3999999999999999), (0.8, 0.48807339449541276, 0.3999999999999999), (0.8, 0.5100917431192659, 0.3999999999999999), (0.8, 0.5321100917431195, 0.3999999999999999), (0.8, 0.5541284403669726, 0.3999999999999999), (0.8, 0.5761467889908256, 0.3999999999999999), (0.8, 0.5981651376146787, 0.3999999999999999), (0.8, 0.6201834862385318, 0.3999999999999999), (0.8, 0.6422018348623855, 0.3999999999999999), (0.8, 0.6642201834862386, 0.3999999999999999), (0.8, 0.6862385321100917, 0.3999999999999999), (0.8, 0.7082568807339453, 0.3999999999999999), (0.8, 0.7302752293577983, 0.3999999999999999), (0.8, 0.7522935779816514, 0.3999999999999999), (0.8, 0.7743119266055045, 0.3999999999999999), (0.8, 0.7963302752293575, 0.3999999999999999), (0.7816513761467889, 0.8, 0.3999999999999999), (0.7596330275229359, 0.8, 0.3999999999999999), (0.7376146788990827, 0.8, 0.3999999999999999), (0.7155963302752292, 0.8, 0.3999999999999999), (0.6935779816513761, 0.8, 0.3999999999999999), (0.6715596330275231, 0.8, 0.3999999999999999), (0.6495412844036699, 0.8, 0.3999999999999999), (0.6275229357798169, 0.8, 0.3999999999999999), (0.6055045871559632, 0.8, 0.3999999999999999), (0.5834862385321101, 0.8, 0.3999999999999999), (0.561467889908257, 0.8, 0.3999999999999999), (0.5394495412844034, 0.8, 0.3999999999999999), (0.5174311926605504, 0.8, 0.3999999999999999), (0.4954128440366972, 0.8, 0.3999999999999999), (0.4733944954128442, 0.8, 0.3999999999999999), (0.4513761467889911, 0.8, 0.3999999999999999), (0.4293577981651374, 0.8, 0.3999999999999999), (0.40733944954128437, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41467889908256866), (0.3999999999999999, 0.8, 0.4366972477064223), (0.3999999999999999, 0.8, 0.45871559633027537), (0.3999999999999999, 0.8, 0.48073394495412847), (0.3999999999999999, 0.8, 0.5027522935779816), (0.3999999999999999, 0.8, 0.5247706422018347), (0.3999999999999999, 0.8, 0.5467889908256882), (0.3999999999999999, 0.8, 0.5688073394495413), (0.3999999999999999, 0.8, 0.5908256880733944), (0.3999999999999999, 0.8, 0.6128440366972481), (0.3999999999999999, 0.8, 0.6348623853211012), (0.3999999999999999, 0.8, 0.6568807339449543), (0.3999999999999999, 0.8, 0.6788990825688073), (0.3999999999999999, 0.8, 0.7009174311926605), (0.3999999999999999, 0.8, 0.722935779816514), (0.3999999999999999, 0.8, 0.7449541284403671), (0.3999999999999999, 0.8, 0.7669724770642202), (0.3999999999999999, 0.8, 0.7889908256880738), (0.3999999999999999, 0.7889908256880731, 0.8), (0.3999999999999999, 0.7669724770642201, 0.8), (0.3999999999999999, 0.7449541284403669, 0.8), (0.3999999999999999, 0.7229357798165139, 0.8), (0.3999999999999999, 0.7009174311926603, 0.8), (0.3999999999999999, 0.6788990825688073, 0.8), (0.3999999999999999, 0.656880733944954, 0.8), (0.3999999999999999, 0.6348623853211005, 0.8), (0.3999999999999999, 0.6128440366972474, 0.8), (0.3999999999999999, 0.5908256880733943, 0.8), (0.3999999999999999, 0.5688073394495412, 0.8), (0.3999999999999999, 0.5467889908256881, 0.8), (0.3999999999999999, 0.5247706422018346, 0.8), (0.3999999999999999, 0.5027522935779815, 0.8), (0.3999999999999999, 0.48073394495412836, 0.8), (0.3999999999999999, 0.4587155963302747, 0.8), (0.3999999999999999, 0.43669724770642165, 0.8), (0.3999999999999999, 0.41467889908256855, 0.8), (0.4073394495412841, 0.3999999999999999, 0.8), (0.4293577981651372, 0.3999999999999999, 0.8), (0.4513761467889908, 0.3999999999999999, 0.8), (0.4733944954128439, 0.3999999999999999, 0.8), (0.495412844036697, 0.3999999999999999, 0.8), (0.5174311926605506, 0.3999999999999999, 0.8), (0.5394495412844037, 0.3999999999999999, 0.8), (0.5614678899082568, 0.3999999999999999, 0.8), (0.5834862385321098, 0.3999999999999999, 0.8), (0.6055045871559629, 0.3999999999999999, 0.8), (0.6275229357798165, 0.3999999999999999, 0.8), (0.6495412844036696, 0.3999999999999999, 0.8), (0.6715596330275228, 0.3999999999999999, 0.8), (0.6935779816513763, 0.3999999999999999, 0.8), (0.7155963302752295, 0.3999999999999999, 0.8), (0.7376146788990825, 0.3999999999999999, 0.8), (0.7596330275229356, 0.3999999999999999, 0.8), (0.7816513761467887, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7963302752293573), (0.8, 0.3999999999999999, 0.7743119266055043), (0.8, 0.3999999999999999, 0.7522935779816511), (0.8, 0.3999999999999999, 0.7302752293577975), (0.8, 0.3999999999999999, 0.7082568807339444), (0.8, 0.3999999999999999, 0.6862385321100914), (0.8, 0.3999999999999999, 0.6642201834862382), (0.8, 0.3999999999999999, 0.6422018348623852), (0.8, 0.3999999999999999, 0.6201834862385316), (0.8, 0.3999999999999999, 0.5981651376146785), (0.8, 0.3999999999999999, 0.5761467889908254), (0.8, 0.3999999999999999, 0.5541284403669717), (0.8, 0.3999999999999999, 0.5321100917431187), (0.8, 0.3999999999999999, 0.5100917431192656), (0.8, 0.3999999999999999, 0.48807339449541254), (0.8, 0.3999999999999999, 0.46605504587155944), (0.8, 0.3999999999999999, 0.44403669724770584), (0.8, 0.3999999999999999, 0.42201834862385273)],
    110: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4218181818181816, 0.3999999999999999), (0.8, 0.44363636363636333, 0.3999999999999999), (0.8, 0.46545454545454557, 0.3999999999999999), (0.8, 0.48727272727272725, 0.3999999999999999), (0.8, 0.5090909090909089, 0.3999999999999999), (0.8, 0.5309090909090907, 0.3999999999999999), (0.8, 0.5527272727272728, 0.3999999999999999), (0.8, 0.5745454545454546, 0.3999999999999999), (0.8, 0.5963636363636363, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6618181818181819, 0.3999999999999999), (0.8, 0.6836363636363636, 0.3999999999999999), (0.8, 0.7054545454545453, 0.3999999999999999), (0.8, 0.7272727272727271, 0.3999999999999999), (0.8, 0.7490909090909093, 0.3999999999999999), (0.8, 0.770909090909091, 0.3999999999999999), (0.8, 0.7927272727272727, 0.3999999999999999), (0.7854545454545454, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7418181818181819, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6981818181818185, 0.8, 0.3999999999999999), (0.6763636363636363, 0.8, 0.3999999999999999), (0.6545454545454545, 0.8, 0.3999999999999999), (0.6327272727272729, 0.8, 0.3999999999999999), (0.6109090909090912, 0.8, 0.3999999999999999), (0.5890909090909094, 0.8, 0.3999999999999999), (0.5672727272727273, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5236363636363639, 0.8, 0.3999999999999999), (0.5018181818181816, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.45818181818181825, 0.8, 0.3999999999999999), (0.4363636363636365, 0.8, 0.3999999999999999), (0.41454545454545483, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40727272727272734), (0.3999999999999999, 0.8, 0.4290909090909091), (0.3999999999999999, 0.8, 0.45090909090909076), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.4945454545454542), (0.3999999999999999, 0.8, 0.5163636363636364), (0.3999999999999999, 0.8, 0.5381818181818181), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.581818181818182), (0.3999999999999999, 0.8, 0.6036363636363637), (0.3999999999999999, 0.8, 0.6254545454545455), (0.3999999999999999, 0.8, 0.6472727272727271), (0.3999999999999999, 0.8, 0.6690909090909088), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7127272727272728), (0.3999999999999999, 0.8, 0.7345454545454544), (0.3999999999999999, 0.8, 0.7563636363636367), (0.3999999999999999, 0.8, 0.7781818181818183), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7781818181818183, 0.8), (0.3999999999999999, 0.7563636363636366, 0.8), (0.3999999999999999, 0.7345454545454544, 0.8), (0.3999999999999999, 0.7127272727272727, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6690909090909087, 0.8), (0.3999999999999999, 0.6472727272727276, 0.8), (0.3999999999999999, 0.6254545454545453, 0.8), (0.3999999999999999, 0.6036363636363636, 0.8), (0.3999999999999999, 0.5818181818181819, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5381818181818185, 0.8), (0.3999999999999999, 0.5163636363636362, 0.8), (0.3999999999999999, 0.49454545454545457, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.45090909090909065, 0.8), (0.3999999999999999, 0.4290909090909089, 0.8), (0.3999999999999999, 0.40727272727272723, 0.8), (0.41454545454545455, 0.3999999999999999, 0.8), (0.43636363636363573, 0.3999999999999999, 0.8), (0.45818181818181797, 0.3999999999999999, 0.8), (0.47999999999999965, 0.3999999999999999, 0.8), (0.5018181818181814, 0.3999999999999999, 0.8), (0.5236363636363636, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5672727272727269, 0.3999999999999999, 0.8), (0.5890909090909087, 0.3999999999999999, 0.8), (0.6109090909090904, 0.3999999999999999, 0.8), (0.6327272727272726, 0.3999999999999999, 0.8), (0.6545454545454543, 0.3999999999999999, 0.8), (0.6763636363636361, 0.3999999999999999, 0.8), (0.6981818181818182, 0.3999999999999999, 0.8), (0.7199999999999994, 0.3999999999999999, 0.8), (0.7418181818181817, 0.3999999999999999, 0.8), (0.7636363636363633, 0.3999999999999999, 0.8), (0.785454545454545, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7927272727272723), (0.8, 0.3999999999999999, 0.7709090909090907), (0.8, 0.3999999999999999, 0.749090909090909), (0.8, 0.3999999999999999, 0.7272727272727267), (0.8, 0.3999999999999999, 0.7054545454545456), (0.8, 0.3999999999999999, 0.6836363636363634), (0.8, 0.3999999999999999, 0.6618181818181816), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.5963636363636365), (0.8, 0.3999999999999999, 0.5745454545454542), (0.8, 0.3999999999999999, 0.5527272727272726), (0.8, 0.3999999999999999, 0.5309090909090909), (0.8, 0.3999999999999999, 0.5090909090909087), (0.8, 0.3999999999999999, 0.48727272727272697), (0.8, 0.3999999999999999, 0.4654545454545453), (0.8, 0.3999999999999999, 0.44363636363636305), (0.8, 0.3999999999999999, 0.42181818181818187)],
    111: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4216216216216213, 0.3999999999999999), (0.8, 0.44324324324324327, 0.3999999999999999), (0.8, 0.46486486486486467, 0.3999999999999999), (0.8, 0.4864864864864866, 0.3999999999999999), (0.8, 0.508108108108108, 0.3999999999999999), (0.8, 0.5297297297297294, 0.3999999999999999), (0.8, 0.5513513513513514, 0.3999999999999999), (0.8, 0.5729729729729728, 0.3999999999999999), (0.8, 0.5945945945945947, 0.3999999999999999), (0.8, 0.6162162162162161, 0.3999999999999999), (0.8, 0.6378378378378381, 0.3999999999999999), (0.8, 0.6594594594594595, 0.3999999999999999), (0.8, 0.6810810810810809, 0.3999999999999999), (0.8, 0.7027027027027029, 0.3999999999999999), (0.8, 0.7243243243243243, 0.3999999999999999), (0.8, 0.7459459459459461, 0.3999999999999999), (0.8, 0.7675675675675676, 0.3999999999999999), (0.8, 0.7891891891891896, 0.3999999999999999), (0.7891891891891893, 0.8, 0.3999999999999999), (0.7675675675675678, 0.8, 0.3999999999999999), (0.7459459459459459, 0.8, 0.3999999999999999), (0.7243243243243245, 0.8, 0.3999999999999999), (0.7027027027027026, 0.8, 0.3999999999999999), (0.6810810810810812, 0.8, 0.3999999999999999), (0.6594594594594597, 0.8, 0.3999999999999999), (0.6378378378378378, 0.8, 0.3999999999999999), (0.6162162162162164, 0.8, 0.3999999999999999), (0.5945945945945944, 0.8, 0.3999999999999999), (0.572972972972973, 0.8, 0.3999999999999999), (0.5513513513513516, 0.8, 0.3999999999999999), (0.5297297297297296, 0.8, 0.3999999999999999), (0.5081081081081082, 0.8, 0.3999999999999999), (0.48648648648648635, 0.8, 0.3999999999999999), (0.46486486486486495, 0.8, 0.3999999999999999), (0.44324324324324355, 0.8, 0.3999999999999999), (0.4216216216216216, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4216216216216217), (0.3999999999999999, 0.8, 0.44324324324324316), (0.3999999999999999, 0.8, 0.46486486486486456), (0.3999999999999999, 0.8, 0.48648648648648646), (0.3999999999999999, 0.8, 0.5081081081081085), (0.3999999999999999, 0.8, 0.5297297297297299), (0.3999999999999999, 0.8, 0.5513513513513513), (0.3999999999999999, 0.8, 0.5729729729729731), (0.3999999999999999, 0.8, 0.5945945945945946), (0.3999999999999999, 0.8, 0.6162162162162166), (0.3999999999999999, 0.8, 0.637837837837838), (0.3999999999999999, 0.8, 0.6594594594594594), (0.3999999999999999, 0.8, 0.6810810810810812), (0.3999999999999999, 0.8, 0.7027027027027026), (0.3999999999999999, 0.8, 0.7243243243243247), (0.3999999999999999, 0.8, 0.7459459459459461), (0.3999999999999999, 0.8, 0.7675675675675675), (0.3999999999999999, 0.8, 0.7891891891891893), (0.3999999999999999, 0.7891891891891893, 0.8), (0.3999999999999999, 0.7675675675675673, 0.8), (0.3999999999999999, 0.7459459459459459, 0.8), (0.3999999999999999, 0.7243243243243245, 0.8), (0.3999999999999999, 0.7027027027027026, 0.8), (0.3999999999999999, 0.6810810810810806, 0.8), (0.3999999999999999, 0.6594594594594592, 0.8), (0.3999999999999999, 0.6378378378378378, 0.8), (0.3999999999999999, 0.6162162162162164, 0.8), (0.3999999999999999, 0.5945945945945944, 0.8), (0.3999999999999999, 0.5729729729729724, 0.8), (0.3999999999999999, 0.551351351351351, 0.8), (0.3999999999999999, 0.5297297297297296, 0.8), (0.3999999999999999, 0.5081081081081082, 0.8), (0.3999999999999999, 0.48648648648648635, 0.8), (0.3999999999999999, 0.4648648648648644, 0.8), (0.3999999999999999, 0.443243243243243, 0.8), (0.3999999999999999, 0.4216216216216216, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4216216216216213, 0.3999999999999999, 0.8), (0.44324324324324327, 0.3999999999999999, 0.8), (0.46486486486486467, 0.3999999999999999, 0.8), (0.48648648648648607, 0.3999999999999999, 0.8), (0.5081081081081075, 0.3999999999999999, 0.8), (0.5297297297297294, 0.3999999999999999, 0.8), (0.5513513513513514, 0.3999999999999999, 0.8), (0.5729729729729728, 0.3999999999999999, 0.8), (0.5945945945945942, 0.3999999999999999, 0.8), (0.6162162162162161, 0.3999999999999999, 0.8), (0.6378378378378375, 0.3999999999999999, 0.8), (0.6594594594594595, 0.3999999999999999, 0.8), (0.6810810810810809, 0.3999999999999999, 0.8), (0.7027027027027023, 0.3999999999999999, 0.8), (0.7243243243243243, 0.3999999999999999, 0.8), (0.7459459459459461, 0.3999999999999999, 0.8), (0.7675675675675676, 0.3999999999999999, 0.8), (0.7891891891891889, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7891891891891893), (0.8, 0.3999999999999999, 0.7675675675675673), (0.8, 0.3999999999999999, 0.7459459459459454), (0.8, 0.3999999999999999, 0.724324324324324), (0.8, 0.3999999999999999, 0.7027027027027026), (0.8, 0.3999999999999999, 0.6810810810810812), (0.8, 0.3999999999999999, 0.6594594594594592), (0.8, 0.3999999999999999, 0.6378378378378373), (0.8, 0.3999999999999999, 0.6162162162162159), (0.8, 0.3999999999999999, 0.5945945945945944), (0.8, 0.3999999999999999, 0.572972972972973), (0.8, 0.3999999999999999, 0.551351351351351), (0.8, 0.3999999999999999, 0.5297297297297292), (0.8, 0.3999999999999999, 0.5081081081081078), (0.8, 0.3999999999999999, 0.48648648648648635), (0.8, 0.3999999999999999, 0.46486486486486495), (0.8, 0.3999999999999999, 0.443243243243243), (0.8, 0.3999999999999999, 0.42162162162162103)],
    112: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42142857142857126, 0.3999999999999999), (0.8, 0.4428571428571426, 0.3999999999999999), (0.8, 0.46428571428571397, 0.3999999999999999), (0.8, 0.4857142857142859, 0.3999999999999999), (0.8, 0.5071428571428572, 0.3999999999999999), (0.8, 0.5285714285714286, 0.3999999999999999), (0.8, 0.5499999999999999, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.5928571428571426, 0.3999999999999999), (0.8, 0.6142857142857141, 0.3999999999999999), (0.8, 0.6357142857142859, 0.3999999999999999), (0.8, 0.6571428571428573, 0.3999999999999999), (0.8, 0.6785714285714286, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7214285714285713, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7642857142857141, 0.3999999999999999), (0.8, 0.7857142857142854, 0.3999999999999999), (0.7928571428571429, 0.8, 0.3999999999999999), (0.7714285714285715, 0.8, 0.3999999999999999), (0.7500000000000001, 0.8, 0.3999999999999999), (0.7285714285714288, 0.8, 0.3999999999999999), (0.7071428571428574, 0.8, 0.3999999999999999), (0.685714285714286, 0.8, 0.3999999999999999), (0.6642857142857147, 0.8, 0.3999999999999999), (0.6428571428571428, 0.8, 0.3999999999999999), (0.6214285714285714, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5785714285714287, 0.8, 0.3999999999999999), (0.5571428571428574, 0.8, 0.3999999999999999), (0.535714285714286, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.49285714285714277, 0.8, 0.3999999999999999), (0.47142857142857136, 0.8, 0.3999999999999999), (0.45, 0.8, 0.3999999999999999), (0.42857142857142866, 0.8, 0.3999999999999999), (0.4071428571428573, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41428571428571404), (0.3999999999999999, 0.8, 0.4357142857142854), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.47857142857142865), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5214285714285714), (0.3999999999999999, 0.8, 0.5428571428571427), (0.3999999999999999, 0.8, 0.5642857142857141), (0.3999999999999999, 0.8, 0.5857142857142854), (0.3999999999999999, 0.8, 0.6071428571428573), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.65), (0.3999999999999999, 0.8, 0.6714285714285715), (0.3999999999999999, 0.8, 0.6928571428571428), (0.3999999999999999, 0.8, 0.7142857142857142), (0.3999999999999999, 0.8, 0.7357142857142855), (0.3999999999999999, 0.8, 0.7571428571428573), (0.3999999999999999, 0.8, 0.7785714285714287), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7785714285714287, 0.8), (0.3999999999999999, 0.7571428571428572, 0.8), (0.3999999999999999, 0.7357142857142853, 0.8), (0.3999999999999999, 0.7142857142857145, 0.8), (0.3999999999999999, 0.6928571428571426, 0.8), (0.3999999999999999, 0.6714285714285718, 0.8), (0.3999999999999999, 0.6499999999999999, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6071428571428572, 0.8), (0.3999999999999999, 0.5857142857142853, 0.8), (0.3999999999999999, 0.5642857142857145, 0.8), (0.3999999999999999, 0.5428571428571426, 0.8), (0.3999999999999999, 0.5214285714285718, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4785714285714285, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.3999999999999999, 0.4357142857142852, 0.8), (0.3999999999999999, 0.4142857142857144, 0.8), (0.40714285714285703, 0.3999999999999999, 0.8), (0.4285714285714278, 0.3999999999999999, 0.8), (0.44999999999999973, 0.3999999999999999, 0.8), (0.4714285714285711, 0.3999999999999999, 0.8), (0.49285714285714244, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5357142857142851, 0.3999999999999999, 0.8), (0.557142857142857, 0.3999999999999999, 0.8), (0.5785714285714278, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6214285714285712, 0.3999999999999999, 0.8), (0.6428571428571426, 0.3999999999999999, 0.8), (0.6642857142857139, 0.3999999999999999, 0.8), (0.6857142857142853, 0.3999999999999999, 0.8), (0.7071428571428571, 0.3999999999999999, 0.8), (0.728571428571428, 0.3999999999999999, 0.8), (0.7499999999999998, 0.3999999999999999, 0.8), (0.7714285714285712, 0.3999999999999999, 0.8), (0.7928571428571425, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7857142857142858), (0.8, 0.3999999999999999, 0.7642857142857143), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7214285714285716), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6785714285714284), (0.8, 0.3999999999999999, 0.657142857142857), (0.8, 0.3999999999999999, 0.6357142857142857), (0.8, 0.3999999999999999, 0.6142857142857143), (0.8, 0.3999999999999999, 0.5928571428571424), (0.8, 0.3999999999999999, 0.5714285714285716), (0.8, 0.3999999999999999, 0.5499999999999997), (0.8, 0.3999999999999999, 0.5285714285714284), (0.8, 0.3999999999999999, 0.507142857142857), (0.8, 0.3999999999999999, 0.4857142857142856), (0.8, 0.3999999999999999, 0.46428571428571425), (0.8, 0.3999999999999999, 0.4428571428571424), (0.8, 0.3999999999999999, 0.42142857142857154)],
    113: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4212389380530973, 0.3999999999999999), (0.8, 0.4424778761061947, 0.3999999999999999), (0.8, 0.46371681415929206, 0.3999999999999999), (0.8, 0.48495575221238946, 0.3999999999999999), (0.8, 0.5061946902654868, 0.3999999999999999), (0.8, 0.5274336283185842, 0.3999999999999999), (0.8, 0.5486725663716816, 0.3999999999999999), (0.8, 0.569911504424779, 0.3999999999999999), (0.8, 0.5911504424778758, 0.3999999999999999), (0.8, 0.6123893805309732, 0.3999999999999999), (0.8, 0.6336283185840706, 0.3999999999999999), (0.8, 0.654867256637168, 0.3999999999999999), (0.8, 0.6761061946902653, 0.3999999999999999), (0.8, 0.6973451327433628, 0.3999999999999999), (0.8, 0.7185840707964601, 0.3999999999999999), (0.8, 0.7398230088495575, 0.3999999999999999), (0.8, 0.7610619469026549, 0.3999999999999999), (0.8, 0.7823008849557522, 0.3999999999999999), (0.7964601769911506, 0.8, 0.3999999999999999), (0.7752212389380531, 0.8, 0.3999999999999999), (0.7539823008849558, 0.8, 0.3999999999999999), (0.7327433628318583, 0.8, 0.3999999999999999), (0.711504424778761, 0.8, 0.3999999999999999), (0.6902654867256641, 0.8, 0.3999999999999999), (0.6690265486725662, 0.8, 0.3999999999999999), (0.6477876106194693, 0.8, 0.3999999999999999), (0.6265486725663719, 0.8, 0.3999999999999999), (0.6053097345132745, 0.8, 0.3999999999999999), (0.5840707964601772, 0.8, 0.3999999999999999), (0.5628318584070797, 0.8, 0.3999999999999999), (0.5415929203539824, 0.8, 0.3999999999999999), (0.520353982300885, 0.8, 0.3999999999999999), (0.49911504424778763, 0.8, 0.3999999999999999), (0.47787610619469023, 0.8, 0.3999999999999999), (0.45663716814159283, 0.8, 0.3999999999999999), (0.4353982300884955, 0.8, 0.3999999999999999), (0.4141592920353981, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40707964601769925), (0.3999999999999999, 0.8, 0.4283185840707961), (0.3999999999999999, 0.8, 0.44955752212389405), (0.3999999999999999, 0.8, 0.4707964601769909), (0.3999999999999999, 0.8, 0.4920353982300888), (0.3999999999999999, 0.8, 0.5132743362831856), (0.3999999999999999, 0.8, 0.534513274336283), (0.3999999999999999, 0.8, 0.5557522123893804), (0.3999999999999999, 0.8, 0.5769911504424778), (0.3999999999999999, 0.8, 0.5982300884955752), (0.3999999999999999, 0.8, 0.6194690265486726), (0.3999999999999999, 0.8, 0.6407079646017699), (0.3999999999999999, 0.8, 0.6619469026548673), (0.3999999999999999, 0.8, 0.6831858407079647), (0.3999999999999999, 0.8, 0.7044247787610621), (0.3999999999999999, 0.8, 0.7256637168141595), (0.3999999999999999, 0.8, 0.7469026548672564), (0.3999999999999999, 0.8, 0.7681415929203543), (0.3999999999999999, 0.8, 0.7893805309734512), (0.3999999999999999, 0.789380530973451, 0.8), (0.3999999999999999, 0.7681415929203541, 0.8), (0.3999999999999999, 0.7469026548672562, 0.8), (0.3999999999999999, 0.7256637168141593, 0.8), (0.3999999999999999, 0.704424778761062, 0.8), (0.3999999999999999, 0.6831858407079646, 0.8), (0.3999999999999999, 0.6619469026548672, 0.8), (0.3999999999999999, 0.6407079646017698, 0.8), (0.3999999999999999, 0.6194690265486724, 0.8), (0.3999999999999999, 0.598230088495575, 0.8), (0.3999999999999999, 0.5769911504424776, 0.8), (0.3999999999999999, 0.5557522123893803, 0.8), (0.3999999999999999, 0.5345132743362835, 0.8), (0.3999999999999999, 0.5132743362831855, 0.8), (0.3999999999999999, 0.4920353982300887, 0.8), (0.3999999999999999, 0.4707964601769907, 0.8), (0.3999999999999999, 0.4495575221238939, 0.8), (0.3999999999999999, 0.428318584070796, 0.8), (0.3999999999999999, 0.40707964601769914, 0.8), (0.4141592920353978, 0.3999999999999999, 0.8), (0.4353982300884952, 0.3999999999999999, 0.8), (0.4566371681415926, 0.3999999999999999, 0.8), (0.47787610619468995, 0.3999999999999999, 0.8), (0.49911504424778735, 0.3999999999999999, 0.8), (0.5203539823008847, 0.3999999999999999, 0.8), (0.5415929203539821, 0.3999999999999999, 0.8), (0.5628318584070795, 0.3999999999999999, 0.8), (0.5840707964601769, 0.3999999999999999, 0.8), (0.6053097345132743, 0.3999999999999999, 0.8), (0.6265486725663711, 0.3999999999999999, 0.8), (0.6477876106194691, 0.3999999999999999, 0.8), (0.669026548672566, 0.3999999999999999, 0.8), (0.6902654867256639, 0.3999999999999999, 0.8), (0.7115044247787607, 0.3999999999999999, 0.8), (0.7327433628318586, 0.3999999999999999, 0.8), (0.7539823008849554, 0.3999999999999999, 0.8), (0.7752212389380528, 0.3999999999999999, 0.8), (0.7964601769911501, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.782300884955752), (0.8, 0.3999999999999999, 0.7610619469026547), (0.8, 0.3999999999999999, 0.7398230088495572), (0.8, 0.3999999999999999, 0.7185840707964599), (0.8, 0.3999999999999999, 0.6973451327433625), (0.8, 0.3999999999999999, 0.6761061946902651), (0.8, 0.3999999999999999, 0.6548672566371683), (0.8, 0.3999999999999999, 0.6336283185840703), (0.8, 0.3999999999999999, 0.6123893805309735), (0.8, 0.3999999999999999, 0.5911504424778756), (0.8, 0.3999999999999999, 0.5699115044247787), (0.8, 0.3999999999999999, 0.5486725663716808), (0.8, 0.3999999999999999, 0.527433628318584), (0.8, 0.3999999999999999, 0.5061946902654866), (0.8, 0.3999999999999999, 0.4849557522123892), (0.8, 0.3999999999999999, 0.4637168141592918), (0.8, 0.3999999999999999, 0.44247787610619443), (0.8, 0.3999999999999999, 0.42123893805309703)],
    114: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42105263157894735, 0.3999999999999999), (0.8, 0.4421052631578948, 0.3999999999999999), (0.8, 0.4631578947368422, 0.3999999999999999), (0.8, 0.48421052631578965, 0.3999999999999999), (0.8, 0.5052631578947366, 0.3999999999999999), (0.8, 0.5263157894736841, 0.3999999999999999), (0.8, 0.5473684210526315, 0.3999999999999999), (0.8, 0.5684210526315789, 0.3999999999999999), (0.8, 0.5894736842105264, 0.3999999999999999), (0.8, 0.6105263157894738, 0.3999999999999999), (0.8, 0.6315789473684212, 0.3999999999999999), (0.8, 0.6526315789473681, 0.3999999999999999), (0.8, 0.6736842105263157, 0.3999999999999999), (0.8, 0.6947368421052631, 0.3999999999999999), (0.8, 0.7157894736842105, 0.3999999999999999), (0.8, 0.736842105263158, 0.3999999999999999), (0.8, 0.7578947368421054, 0.3999999999999999), (0.8, 0.7789473684210528, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7789473684210526, 0.8, 0.3999999999999999), (0.7578947368421056, 0.8, 0.3999999999999999), (0.7368421052631582, 0.8, 0.3999999999999999), (0.7157894736842108, 0.8, 0.3999999999999999), (0.6947368421052633, 0.8, 0.3999999999999999), (0.6736842105263159, 0.8, 0.3999999999999999), (0.6526315789473685, 0.8, 0.3999999999999999), (0.631578947368421, 0.8, 0.3999999999999999), (0.610526315789474, 0.8, 0.3999999999999999), (0.589473684210526, 0.8, 0.3999999999999999), (0.5684210526315792, 0.8, 0.3999999999999999), (0.5473684210526317, 0.8, 0.3999999999999999), (0.5263157894736843, 0.8, 0.3999999999999999), (0.5052631578947369, 0.8, 0.3999999999999999), (0.4842105263157894, 0.8, 0.3999999999999999), (0.4631578947368425, 0.8, 0.3999999999999999), (0.4421052631578945, 0.8, 0.3999999999999999), (0.4210526315789476, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42105263157894723), (0.3999999999999999, 0.8, 0.44210526315789467), (0.3999999999999999, 0.8, 0.4631578947368421), (0.3999999999999999, 0.8, 0.48421052631578954), (0.3999999999999999, 0.8, 0.505263157894737), (0.3999999999999999, 0.8, 0.5263157894736838), (0.3999999999999999, 0.8, 0.5473684210526318), (0.3999999999999999, 0.8, 0.5684210526315787), (0.3999999999999999, 0.8, 0.5894736842105263), (0.3999999999999999, 0.8, 0.6105263157894737), (0.3999999999999999, 0.8, 0.6315789473684211), (0.3999999999999999, 0.8, 0.6526315789473686), (0.3999999999999999, 0.8, 0.6736842105263154), (0.3999999999999999, 0.8, 0.6947368421052634), (0.3999999999999999, 0.8, 0.7157894736842103), (0.3999999999999999, 0.8, 0.7368421052631577), (0.3999999999999999, 0.8, 0.7578947368421052), (0.3999999999999999, 0.8, 0.7789473684210526), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7789473684210526, 0.8), (0.3999999999999999, 0.7578947368421051, 0.8), (0.3999999999999999, 0.7368421052631582, 0.8), (0.3999999999999999, 0.7157894736842102, 0.8), (0.3999999999999999, 0.6947368421052633, 0.8), (0.3999999999999999, 0.6736842105263159, 0.8), (0.3999999999999999, 0.6526315789473685, 0.8), (0.3999999999999999, 0.631578947368421, 0.8), (0.3999999999999999, 0.6105263157894735, 0.8), (0.3999999999999999, 0.5894736842105266, 0.8), (0.3999999999999999, 0.5684210526315786, 0.8), (0.3999999999999999, 0.5473684210526317, 0.8), (0.3999999999999999, 0.5263157894736843, 0.8), (0.3999999999999999, 0.5052631578947369, 0.8), (0.3999999999999999, 0.4842105263157894, 0.8), (0.3999999999999999, 0.463157894736842, 0.8), (0.3999999999999999, 0.4421052631578945, 0.8), (0.3999999999999999, 0.42105263157894707, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.42105263157894735, 0.3999999999999999, 0.8), (0.4421052631578943, 0.3999999999999999, 0.8), (0.4631578947368417, 0.3999999999999999, 0.8), (0.48421052631578915, 0.3999999999999999, 0.8), (0.5052631578947366, 0.3999999999999999, 0.8), (0.5263157894736841, 0.3999999999999999, 0.8), (0.547368421052631, 0.3999999999999999, 0.8), (0.5684210526315789, 0.3999999999999999, 0.8), (0.5894736842105258, 0.3999999999999999, 0.8), (0.6105263157894733, 0.3999999999999999, 0.8), (0.6315789473684207, 0.3999999999999999, 0.8), (0.6526315789473681, 0.3999999999999999, 0.8), (0.6736842105263157, 0.3999999999999999, 0.8), (0.6947368421052631, 0.3999999999999999, 0.8), (0.7157894736842105, 0.3999999999999999, 0.8), (0.7368421052631573, 0.3999999999999999, 0.8), (0.7578947368421054, 0.3999999999999999, 0.8), (0.7789473684210522, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7789473684210526), (0.8, 0.3999999999999999, 0.7578947368421051), (0.8, 0.3999999999999999, 0.7368421052631576), (0.8, 0.3999999999999999, 0.7157894736842108), (0.8, 0.3999999999999999, 0.6947368421052628), (0.8, 0.3999999999999999, 0.6736842105263159), (0.8, 0.3999999999999999, 0.6526315789473685), (0.8, 0.3999999999999999, 0.631578947368421), (0.8, 0.3999999999999999, 0.6105263157894735), (0.8, 0.3999999999999999, 0.589473684210526), (0.8, 0.3999999999999999, 0.5684210526315786), (0.8, 0.3999999999999999, 0.5473684210526312), (0.8, 0.3999999999999999, 0.5263157894736843), (0.8, 0.3999999999999999, 0.5052631578947363), (0.8, 0.3999999999999999, 0.4842105263157894), (0.8, 0.3999999999999999, 0.463157894736842), (0.8, 0.3999999999999999, 0.4421052631578945), (0.8, 0.3999999999999999, 0.42105263157894707)],
    115: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4208695652173911, 0.3999999999999999), (0.8, 0.4417391304347823, 0.3999999999999999), (0.8, 0.462608695652174, 0.3999999999999999), (0.8, 0.4834782608695652, 0.3999999999999999), (0.8, 0.5043478260869564, 0.3999999999999999), (0.8, 0.5252173913043476, 0.3999999999999999), (0.8, 0.5460869565217393, 0.3999999999999999), (0.8, 0.5669565217391305, 0.3999999999999999), (0.8, 0.5878260869565217, 0.3999999999999999), (0.8, 0.6086956521739129, 0.3999999999999999), (0.8, 0.6295652173913041, 0.3999999999999999), (0.8, 0.6504347826086958, 0.3999999999999999), (0.8, 0.671304347826087, 0.3999999999999999), (0.8, 0.6921739130434782, 0.3999999999999999), (0.8, 0.7130434782608694, 0.3999999999999999), (0.8, 0.733913043478261, 0.3999999999999999), (0.8, 0.7547826086956523, 0.3999999999999999), (0.8, 0.7756521739130435, 0.3999999999999999), (0.8, 0.7965217391304347, 0.3999999999999999), (0.7826086956521743, 0.8, 0.3999999999999999), (0.7617391304347826, 0.8, 0.3999999999999999), (0.7408695652173913, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.6991304347826085, 0.8, 0.3999999999999999), (0.6782608695652173, 0.8, 0.3999999999999999), (0.6573913043478261, 0.8, 0.3999999999999999), (0.636521739130435, 0.8, 0.3999999999999999), (0.6156521739130437, 0.8, 0.3999999999999999), (0.5947826086956526, 0.8, 0.3999999999999999), (0.5739130434782608, 0.8, 0.3999999999999999), (0.5530434782608696, 0.8, 0.3999999999999999), (0.5321739130434784, 0.8, 0.3999999999999999), (0.5113043478260867, 0.8, 0.3999999999999999), (0.4904347826086955, 0.8, 0.3999999999999999), (0.4695652173913043, 0.8, 0.3999999999999999), (0.44869565217391316, 0.8, 0.3999999999999999), (0.4278260869565219, 0.8, 0.3999999999999999), (0.40695652173913077, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4139130434782609), (0.3999999999999999, 0.8, 0.4347826086956521), (0.3999999999999999, 0.8, 0.4556521739130433), (0.3999999999999999, 0.8, 0.47652173913043505), (0.3999999999999999, 0.8, 0.49739130434782625), (0.3999999999999999, 0.8, 0.5182608695652174), (0.3999999999999999, 0.8, 0.5391304347826086), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5808695652173915), (0.3999999999999999, 0.8, 0.6017391304347827), (0.3999999999999999, 0.8, 0.6226086956521739), (0.3999999999999999, 0.8, 0.643478260869565), (0.3999999999999999, 0.8, 0.6643478260869569), (0.3999999999999999, 0.8, 0.685217391304348), (0.3999999999999999, 0.8, 0.7060869565217391), (0.3999999999999999, 0.8, 0.7269565217391304), (0.3999999999999999, 0.8, 0.7478260869565216), (0.3999999999999999, 0.8, 0.7686956521739133), (0.3999999999999999, 0.8, 0.7895652173913046), (0.3999999999999999, 0.7895652173913044, 0.8), (0.3999999999999999, 0.7686956521739127, 0.8), (0.3999999999999999, 0.7478260869565214, 0.8), (0.3999999999999999, 0.7269565217391303, 0.8), (0.3999999999999999, 0.7060869565217391, 0.8), (0.3999999999999999, 0.6852173913043479, 0.8), (0.3999999999999999, 0.6643478260869566, 0.8), (0.3999999999999999, 0.6434782608695655, 0.8), (0.3999999999999999, 0.6226086956521738, 0.8), (0.3999999999999999, 0.6017391304347826, 0.8), (0.3999999999999999, 0.5808695652173909, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5391304347826085, 0.8), (0.3999999999999999, 0.5182608695652173, 0.8), (0.3999999999999999, 0.4973913043478261, 0.8), (0.3999999999999999, 0.4765217391304349, 0.8), (0.3999999999999999, 0.4556521739130432, 0.8), (0.3999999999999999, 0.434782608695652, 0.8), (0.3999999999999999, 0.4139130434782608, 0.8), (0.4069565217391305, 0.3999999999999999, 0.8), (0.4278260869565217, 0.3999999999999999, 0.8), (0.4486956521739129, 0.3999999999999999, 0.8), (0.4695652173913041, 0.3999999999999999, 0.8), (0.4904347826086952, 0.3999999999999999, 0.8), (0.5113043478260865, 0.3999999999999999, 0.8), (0.5321739130434782, 0.3999999999999999, 0.8), (0.5530434782608693, 0.3999999999999999, 0.8), (0.5739130434782611, 0.3999999999999999, 0.8), (0.5947826086956522, 0.3999999999999999, 0.8), (0.6156521739130435, 0.3999999999999999, 0.8), (0.6365217391304346, 0.3999999999999999, 0.8), (0.6573913043478259, 0.3999999999999999, 0.8), (0.678260869565217, 0.3999999999999999, 0.8), (0.6991304347826082, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7408695652173911, 0.3999999999999999, 0.8), (0.7617391304347829, 0.3999999999999999, 0.8), (0.7826086956521741, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7965217391304344), (0.8, 0.3999999999999999, 0.7756521739130433), (0.8, 0.3999999999999999, 0.754782608695652), (0.8, 0.3999999999999999, 0.7339130434782608), (0.8, 0.3999999999999999, 0.7130434782608697), (0.8, 0.3999999999999999, 0.6921739130434779), (0.8, 0.3999999999999999, 0.6713043478260867), (0.8, 0.3999999999999999, 0.650434782608695), (0.8, 0.3999999999999999, 0.6295652173913038), (0.8, 0.3999999999999999, 0.6086956521739126), (0.8, 0.3999999999999999, 0.5878260869565214), (0.8, 0.3999999999999999, 0.5669565217391302), (0.8, 0.3999999999999999, 0.546086956521739), (0.8, 0.3999999999999999, 0.5252173913043479), (0.8, 0.3999999999999999, 0.5043478260869562), (0.8, 0.3999999999999999, 0.4834782608695649), (0.8, 0.3999999999999999, 0.4626086956521732), (0.8, 0.3999999999999999, 0.441739130434782), (0.8, 0.3999999999999999, 0.42086956521739083)],
    116: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42068965517241363, 0.3999999999999999), (0.8, 0.4413793103448273, 0.3999999999999999), (0.8, 0.4620689655172416, 0.3999999999999999), (0.8, 0.48275862068965525, 0.3999999999999999), (0.8, 0.503448275862069, 0.3999999999999999), (0.8, 0.5241379310344827, 0.3999999999999999), (0.8, 0.5448275862068964, 0.3999999999999999), (0.8, 0.5655172413793101, 0.3999999999999999), (0.8, 0.5862068965517244, 0.3999999999999999), (0.8, 0.606896551724138, 0.3999999999999999), (0.8, 0.6275862068965518, 0.3999999999999999), (0.8, 0.6482758620689655, 0.3999999999999999), (0.8, 0.6689655172413792, 0.3999999999999999), (0.8, 0.6896551724137929, 0.3999999999999999), (0.8, 0.7103448275862072, 0.3999999999999999), (0.8, 0.7310344827586208, 0.3999999999999999), (0.8, 0.7517241379310345, 0.3999999999999999), (0.8, 0.7724137931034483, 0.3999999999999999), (0.8, 0.7931034482758619, 0.3999999999999999), (0.7862068965517239, 0.8, 0.3999999999999999), (0.7655172413793103, 0.8, 0.3999999999999999), (0.7448275862068965, 0.8, 0.3999999999999999), (0.7241379310344829, 0.8, 0.3999999999999999), (0.7034482758620692, 0.8, 0.3999999999999999), (0.6827586206896554, 0.8, 0.3999999999999999), (0.6620689655172417, 0.8, 0.3999999999999999), (0.6413793103448275, 0.8, 0.3999999999999999), (0.6206896551724138, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5793103448275864, 0.8, 0.3999999999999999), (0.5586206896551726, 0.8, 0.3999999999999999), (0.5379310344827584, 0.8, 0.3999999999999999), (0.5172413793103448, 0.8, 0.3999999999999999), (0.49655172413793097, 0.8, 0.3999999999999999), (0.4758620689655173, 0.8, 0.3999999999999999), (0.4551724137931036, 0.8, 0.3999999999999999), (0.43448275862068986, 0.8, 0.3999999999999999), (0.41379310344827613, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.406896551724138), (0.3999999999999999, 0.8, 0.42758620689655175), (0.3999999999999999, 0.8, 0.44827586206896547), (0.3999999999999999, 0.8, 0.46896551724137914), (0.3999999999999999, 0.8, 0.48965517241379286), (0.3999999999999999, 0.8, 0.5103448275862071), (0.3999999999999999, 0.8, 0.5310344827586209), (0.3999999999999999, 0.8, 0.5517241379310345), (0.3999999999999999, 0.8, 0.5724137931034482), (0.3999999999999999, 0.8, 0.5931034482758619), (0.3999999999999999, 0.8, 0.6137931034482762), (0.3999999999999999, 0.8, 0.6344827586206894), (0.3999999999999999, 0.8, 0.6551724137931036), (0.3999999999999999, 0.8, 0.6758620689655173), (0.3999999999999999, 0.8, 0.6965517241379311), (0.3999999999999999, 0.8, 0.7172413793103447), (0.3999999999999999, 0.8, 0.7379310344827584), (0.3999999999999999, 0.8, 0.7586206896551726), (0.3999999999999999, 0.8, 0.7793103448275864), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7793103448275862, 0.8), (0.3999999999999999, 0.7586206896551726, 0.8), (0.3999999999999999, 0.7379310344827583, 0.8), (0.3999999999999999, 0.7172413793103452, 0.8), (0.3999999999999999, 0.6965517241379309, 0.8), (0.3999999999999999, 0.6758620689655173, 0.8), (0.3999999999999999, 0.6551724137931034, 0.8), (0.3999999999999999, 0.6344827586206893, 0.8), (0.3999999999999999, 0.6137931034482761, 0.8), (0.3999999999999999, 0.5931034482758618, 0.8), (0.3999999999999999, 0.5724137931034481, 0.8), (0.3999999999999999, 0.5517241379310344, 0.8), (0.3999999999999999, 0.5310344827586206, 0.8), (0.3999999999999999, 0.510344827586207, 0.8), (0.3999999999999999, 0.48965517241379275, 0.8), (0.3999999999999999, 0.4689655172413796, 0.8), (0.3999999999999999, 0.4482758620689653, 0.8), (0.3999999999999999, 0.4275862068965516, 0.8), (0.3999999999999999, 0.4068965517241379, 0.8), (0.4137931034482759, 0.3999999999999999, 0.8), (0.4344827586206891, 0.3999999999999999, 0.8), (0.4551724137931033, 0.3999999999999999, 0.8), (0.475862068965517, 0.3999999999999999, 0.8), (0.49655172413793075, 0.3999999999999999, 0.8), (0.517241379310345, 0.3999999999999999, 0.8), (0.5379310344827581, 0.3999999999999999, 0.8), (0.5586206896551724, 0.3999999999999999, 0.8), (0.579310344827586, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6206896551724135, 0.3999999999999999, 0.8), (0.6413793103448272, 0.3999999999999999, 0.8), (0.6620689655172415, 0.3999999999999999, 0.8), (0.6827586206896546, 0.3999999999999999, 0.8), (0.7034482758620688, 0.3999999999999999, 0.8), (0.7241379310344827, 0.3999999999999999, 0.8), (0.7448275862068963, 0.3999999999999999, 0.8), (0.7655172413793105, 0.3999999999999999, 0.8), (0.7862068965517237, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7931034482758617), (0.8, 0.3999999999999999, 0.772413793103448), (0.8, 0.3999999999999999, 0.7517241379310342), (0.8, 0.3999999999999999, 0.7310344827586206), (0.8, 0.3999999999999999, 0.7103448275862069), (0.8, 0.3999999999999999, 0.6896551724137927), (0.8, 0.3999999999999999, 0.6689655172413795), (0.8, 0.3999999999999999, 0.6482758620689653), (0.8, 0.3999999999999999, 0.6275862068965515), (0.8, 0.3999999999999999, 0.6068965517241378), (0.8, 0.3999999999999999, 0.5862068965517235), (0.8, 0.3999999999999999, 0.5655172413793104), (0.8, 0.3999999999999999, 0.5448275862068961), (0.8, 0.3999999999999999, 0.5241379310344825), (0.8, 0.3999999999999999, 0.5034482758620688), (0.8, 0.3999999999999999, 0.482758620689655), (0.8, 0.3999999999999999, 0.4620689655172413), (0.8, 0.3999999999999999, 0.4413793103448271), (0.8, 0.3999999999999999, 0.42068965517241336)],
    117: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.42051282051282035, 0.3999999999999999), (0.8, 0.4410256410256408, 0.3999999999999999), (0.8, 0.46153846153846123, 0.3999999999999999), (0.8, 0.4820512820512822, 0.3999999999999999), (0.8, 0.5025641025641027, 0.3999999999999999), (0.8, 0.5230769230769231, 0.3999999999999999), (0.8, 0.5435897435897435, 0.3999999999999999), (0.8, 0.564102564102564, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.6051282051282049, 0.3999999999999999), (0.8, 0.6256410256410259, 0.3999999999999999), (0.8, 0.6461538461538463, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6871794871794872, 0.3999999999999999), (0.8, 0.7076923076923076, 0.3999999999999999), (0.8, 0.7282051282051281, 0.3999999999999999), (0.8, 0.7487179487179485, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.8, 0.78974358974359, 0.3999999999999999), (0.7897435897435898, 0.8, 0.3999999999999999), (0.7692307692307693, 0.8, 0.3999999999999999), (0.7487179487179488, 0.8, 0.3999999999999999), (0.7282051282051284, 0.8, 0.3999999999999999), (0.707692307692308, 0.8, 0.3999999999999999), (0.687179487179487, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.6256410256410256, 0.8, 0.3999999999999999), (0.6051282051282052, 0.8, 0.3999999999999999), (0.5846153846153848, 0.8, 0.3999999999999999), (0.5641025641025643, 0.8, 0.3999999999999999), (0.5435897435897439, 0.8, 0.3999999999999999), (0.5230769230769229, 0.8, 0.3999999999999999), (0.5025641025641024, 0.8, 0.3999999999999999), (0.48205128205128195, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.44102564102564107, 0.8, 0.3999999999999999), (0.42051282051282063, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.42051282051282074), (0.3999999999999999, 0.8, 0.4410256410256412), (0.3999999999999999, 0.8, 0.4615384615384617), (0.3999999999999999, 0.8, 0.4820512820512821), (0.3999999999999999, 0.8, 0.5025641025641026), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.5435897435897434), (0.3999999999999999, 0.8, 0.5641025641025639), (0.3999999999999999, 0.8, 0.5846153846153849), (0.3999999999999999, 0.8, 0.6051282051282053), (0.3999999999999999, 0.8, 0.6256410256410257), (0.3999999999999999, 0.8, 0.6461538461538462), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6871794871794876), (0.3999999999999999, 0.8, 0.7076923076923081), (0.3999999999999999, 0.8, 0.7282051282051285), (0.3999999999999999, 0.8, 0.748717948717949), (0.3999999999999999, 0.8, 0.7692307692307694), (0.3999999999999999, 0.8, 0.7897435897435898), (0.3999999999999999, 0.7897435897435898, 0.8), (0.3999999999999999, 0.7692307692307693, 0.8), (0.3999999999999999, 0.7487179487179488, 0.8), (0.3999999999999999, 0.7282051282051284, 0.8), (0.3999999999999999, 0.7076923076923074, 0.8), (0.3999999999999999, 0.687179487179487, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6461538461538455, 0.8), (0.3999999999999999, 0.6256410256410251, 0.8), (0.3999999999999999, 0.6051282051282046, 0.8), (0.3999999999999999, 0.5846153846153842, 0.8), (0.3999999999999999, 0.5641025641025638, 0.8), (0.3999999999999999, 0.5435897435897433, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.5025641025641024, 0.8), (0.3999999999999999, 0.48205128205128195, 0.8), (0.3999999999999999, 0.4615384615384615, 0.8), (0.3999999999999999, 0.44102564102564107, 0.8), (0.3999999999999999, 0.4205128205128201, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.42051282051282035, 0.3999999999999999, 0.8), (0.4410256410256408, 0.3999999999999999, 0.8), (0.4615384615384618, 0.3999999999999999, 0.8), (0.4820512820512822, 0.3999999999999999, 0.8), (0.5025641025641027, 0.3999999999999999, 0.8), (0.5230769230769231, 0.3999999999999999, 0.8), (0.5435897435897435, 0.3999999999999999, 0.8), (0.564102564102564, 0.3999999999999999, 0.8), (0.5846153846153845, 0.3999999999999999, 0.8), (0.6051282051282049, 0.3999999999999999, 0.8), (0.6256410256410254, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.6666666666666667, 0.3999999999999999, 0.8), (0.6871794871794872, 0.3999999999999999, 0.8), (0.7076923076923076, 0.3999999999999999, 0.8), (0.7282051282051281, 0.3999999999999999, 0.8), (0.7487179487179492, 0.3999999999999999, 0.8), (0.7692307692307696, 0.3999999999999999, 0.8), (0.78974358974359, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7897435897435892), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7487179487179483), (0.8, 0.3999999999999999, 0.7282051282051278), (0.8, 0.3999999999999999, 0.7076923076923074), (0.8, 0.3999999999999999, 0.687179487179487), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6461538461538455), (0.8, 0.3999999999999999, 0.6256410256410251), (0.8, 0.3999999999999999, 0.6051282051282046), (0.8, 0.3999999999999999, 0.5846153846153842), (0.8, 0.3999999999999999, 0.5641025641025632), (0.8, 0.3999999999999999, 0.5435897435897428), (0.8, 0.3999999999999999, 0.5230769230769223), (0.8, 0.3999999999999999, 0.5025641025641019), (0.8, 0.3999999999999999, 0.48205128205128145), (0.8, 0.3999999999999999, 0.461538461538461), (0.8, 0.3999999999999999, 0.4410256410256405), (0.8, 0.3999999999999999, 0.4205128205128201)],
    118: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4203389830508473, 0.3999999999999999), (0.8, 0.44067796610169474, 0.3999999999999999), (0.8, 0.46101694915254215, 0.3999999999999999), (0.8, 0.48135593220338957, 0.3999999999999999), (0.8, 0.5016949152542369, 0.3999999999999999), (0.8, 0.522033898305085, 0.3999999999999999), (0.8, 0.5423728813559323, 0.3999999999999999), (0.8, 0.5627118644067797, 0.3999999999999999), (0.8, 0.5830508474576271, 0.3999999999999999), (0.8, 0.6033898305084745, 0.3999999999999999), (0.8, 0.623728813559322, 0.3999999999999999), (0.8, 0.6440677966101693, 0.3999999999999999), (0.8, 0.6644067796610168, 0.3999999999999999), (0.8, 0.6847457627118643, 0.3999999999999999), (0.8, 0.7050847457627121, 0.3999999999999999), (0.8, 0.7254237288135595, 0.3999999999999999), (0.8, 0.745762711864407, 0.3999999999999999), (0.8, 0.7661016949152544, 0.3999999999999999), (0.8, 0.7864406779661017, 0.3999999999999999), (0.793220338983051, 0.8, 0.3999999999999999), (0.7728813559322036, 0.8, 0.3999999999999999), (0.7525423728813562, 0.8, 0.3999999999999999), (0.7322033898305087, 0.8, 0.3999999999999999), (0.7118644067796613, 0.8, 0.3999999999999999), (0.691525423728814, 0.8, 0.3999999999999999), (0.671186440677966, 0.8, 0.3999999999999999), (0.6508474576271186, 0.8, 0.3999999999999999), (0.6305084745762712, 0.8, 0.3999999999999999), (0.6101694915254238, 0.8, 0.3999999999999999), (0.5898305084745764, 0.8, 0.3999999999999999), (0.5694915254237289, 0.8, 0.3999999999999999), (0.5491525423728816, 0.8, 0.3999999999999999), (0.5288135593220341, 0.8, 0.3999999999999999), (0.5084745762711862, 0.8, 0.3999999999999999), (0.4881355932203388, 0.8, 0.3999999999999999), (0.46779661016949137, 0.8, 0.3999999999999999), (0.44745762711864395, 0.8, 0.3999999999999999), (0.42711864406779654, 0.8, 0.3999999999999999), (0.4067796610169491, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4135593220338982), (0.3999999999999999, 0.8, 0.43389830508474564), (0.3999999999999999, 0.8, 0.45423728813559305), (0.3999999999999999, 0.8, 0.47457627118644047), (0.3999999999999999, 0.8, 0.4949152542372879), (0.3999999999999999, 0.8, 0.5152542372881352), (0.3999999999999999, 0.8, 0.5355932203389833), (0.3999999999999999, 0.8, 0.5559322033898306), (0.3999999999999999, 0.8, 0.576271186440678), (0.3999999999999999, 0.8, 0.5966101694915255), (0.3999999999999999, 0.8, 0.6169491525423729), (0.3999999999999999, 0.8, 0.6372881355932203), (0.3999999999999999, 0.8, 0.6576271186440676), (0.3999999999999999, 0.8, 0.6779661016949157), (0.3999999999999999, 0.8, 0.698305084745763), (0.3999999999999999, 0.8, 0.7186440677966104), (0.3999999999999999, 0.8, 0.7389830508474579), (0.3999999999999999, 0.8, 0.7593220338983053), (0.3999999999999999, 0.8, 0.7796610169491527), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7796610169491525, 0.8), (0.3999999999999999, 0.7593220338983051, 0.8), (0.3999999999999999, 0.7389830508474577, 0.8), (0.3999999999999999, 0.7186440677966104, 0.8), (0.3999999999999999, 0.6983050847457629, 0.8), (0.3999999999999999, 0.6779661016949154, 0.8), (0.3999999999999999, 0.6576271186440681, 0.8), (0.3999999999999999, 0.6372881355932202, 0.8), (0.3999999999999999, 0.6169491525423727, 0.8), (0.3999999999999999, 0.5966101694915253, 0.8), (0.3999999999999999, 0.5762711864406779, 0.8), (0.3999999999999999, 0.5559322033898305, 0.8), (0.3999999999999999, 0.5355932203389826, 0.8), (0.3999999999999999, 0.5152542372881351, 0.8), (0.3999999999999999, 0.4949152542372877, 0.8), (0.3999999999999999, 0.4745762711864403, 0.8), (0.3999999999999999, 0.45423728813559294, 0.8), (0.3999999999999999, 0.43389830508474553, 0.8), (0.3999999999999999, 0.4135593220338981, 0.8), (0.40677966101694885, 0.3999999999999999, 0.8), (0.42711864406779626, 0.3999999999999999, 0.8), (0.4474576271186437, 0.3999999999999999, 0.8), (0.4677966101694911, 0.3999999999999999, 0.8), (0.4881355932203385, 0.3999999999999999, 0.8), (0.508474576271186, 0.3999999999999999, 0.8), (0.5288135593220333, 0.3999999999999999, 0.8), (0.5491525423728807, 0.3999999999999999, 0.8), (0.5694915254237287, 0.3999999999999999, 0.8), (0.5898305084745761, 0.3999999999999999, 0.8), (0.6101694915254235, 0.3999999999999999, 0.8), (0.6305084745762709, 0.3999999999999999, 0.8), (0.6508474576271184, 0.3999999999999999, 0.8), (0.6711864406779663, 0.3999999999999999, 0.8), (0.6915254237288138, 0.3999999999999999, 0.8), (0.7118644067796611, 0.3999999999999999, 0.8), (0.7322033898305085, 0.3999999999999999, 0.8), (0.7525423728813558, 0.3999999999999999, 0.8), (0.7728813559322033, 0.3999999999999999, 0.8), (0.7932203389830508, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7864406779661015), (0.8, 0.3999999999999999, 0.7661016949152541), (0.8, 0.3999999999999999, 0.7457627118644067), (0.8, 0.3999999999999999, 0.7254237288135592), (0.8, 0.3999999999999999, 0.7050847457627119), (0.8, 0.3999999999999999, 0.6847457627118645), (0.8, 0.3999999999999999, 0.6644067796610171), (0.8, 0.3999999999999999, 0.6440677966101691), (0.8, 0.3999999999999999, 0.6237288135593217), (0.8, 0.3999999999999999, 0.6033898305084743), (0.8, 0.3999999999999999, 0.5830508474576268), (0.8, 0.3999999999999999, 0.5627118644067794), (0.8, 0.3999999999999999, 0.5423728813559315), (0.8, 0.3999999999999999, 0.5220338983050841), (0.8, 0.3999999999999999, 0.5016949152542367), (0.8, 0.3999999999999999, 0.4813559322033893), (0.8, 0.3999999999999999, 0.4610169491525419), (0.8, 0.3999999999999999, 0.44067796610169446), (0.8, 0.3999999999999999, 0.42033898305084705)],
    119: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4201680672268906, 0.3999999999999999), (0.8, 0.4403361344537813, 0.3999999999999999), (0.8, 0.46050420168067197, 0.3999999999999999), (0.8, 0.4806722689075632, 0.3999999999999999), (0.8, 0.5008403361344539, 0.3999999999999999), (0.8, 0.5210084033613446, 0.3999999999999999), (0.8, 0.5411764705882353, 0.3999999999999999), (0.8, 0.5613445378151259, 0.3999999999999999), (0.8, 0.5815126050420167, 0.3999999999999999), (0.8, 0.6016806722689073, 0.3999999999999999), (0.8, 0.6218487394957981, 0.3999999999999999), (0.8, 0.6420168067226892, 0.3999999999999999), (0.8, 0.6621848739495799, 0.3999999999999999), (0.8, 0.6823529411764706, 0.3999999999999999), (0.8, 0.7025210084033613, 0.3999999999999999), (0.8, 0.722689075630252, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7630252100840335, 0.3999999999999999), (0.8, 0.783193277310924, 0.3999999999999999), (0.7966386554621849, 0.8, 0.3999999999999999), (0.7764705882352942, 0.8, 0.3999999999999999), (0.7563025210084034, 0.8, 0.3999999999999999), (0.7361344537815128, 0.8, 0.3999999999999999), (0.7159663865546221, 0.8, 0.3999999999999999), (0.6957983193277314, 0.8, 0.3999999999999999), (0.6756302521008402, 0.8, 0.3999999999999999), (0.6554621848739495, 0.8, 0.3999999999999999), (0.6352941176470588, 0.8, 0.3999999999999999), (0.6151260504201681, 0.8, 0.3999999999999999), (0.5949579831932774, 0.8, 0.3999999999999999), (0.5747899159663867, 0.8, 0.3999999999999999), (0.554621848739496, 0.8, 0.3999999999999999), (0.5344537815126054, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.4941176470588234, 0.8, 0.3999999999999999), (0.4739495798319327, 0.8, 0.3999999999999999), (0.453781512605042, 0.8, 0.3999999999999999), (0.43361344537815133, 0.8, 0.3999999999999999), (0.41344537815126065, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40672268907563003), (0.3999999999999999, 0.8, 0.4268907563025212), (0.3999999999999999, 0.8, 0.44705882352941195), (0.3999999999999999, 0.8, 0.46722689075630264), (0.3999999999999999, 0.8, 0.4873949579831933), (0.3999999999999999, 0.8, 0.507563025210084), (0.3999999999999999, 0.8, 0.5277310924369747), (0.3999999999999999, 0.8, 0.5478991596638654), (0.3999999999999999, 0.8, 0.5680672268907561), (0.3999999999999999, 0.8, 0.5882352941176467), (0.3999999999999999, 0.8, 0.608403361344538), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6487394957983194), (0.3999999999999999, 0.8, 0.6689075630252102), (0.3999999999999999, 0.8, 0.6890756302521008), (0.3999999999999999, 0.8, 0.7092436974789915), (0.3999999999999999, 0.8, 0.7294117647058826), (0.3999999999999999, 0.8, 0.7495798319327733), (0.3999999999999999, 0.8, 0.769747899159664), (0.3999999999999999, 0.8, 0.7899159663865547), (0.3999999999999999, 0.7899159663865547, 0.8), (0.3999999999999999, 0.7697478991596639, 0.8), (0.3999999999999999, 0.7495798319327732, 0.8), (0.3999999999999999, 0.7294117647058825, 0.8), (0.3999999999999999, 0.7092436974789919, 0.8), (0.3999999999999999, 0.6890756302521012, 0.8), (0.3999999999999999, 0.6689075630252099, 0.8), (0.3999999999999999, 0.6487394957983192, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6084033613445379, 0.8), (0.3999999999999999, 0.5882352941176466, 0.8), (0.3999999999999999, 0.568067226890756, 0.8), (0.3999999999999999, 0.5478991596638653, 0.8), (0.3999999999999999, 0.5277310924369746, 0.8), (0.3999999999999999, 0.5075630252100839, 0.8), (0.3999999999999999, 0.48739495798319316, 0.8), (0.3999999999999999, 0.46722689075630247, 0.8), (0.3999999999999999, 0.4470588235294118, 0.8), (0.3999999999999999, 0.4268907563025211, 0.8), (0.3999999999999999, 0.4067226890756304, 0.8), (0.4134453781512598, 0.3999999999999999, 0.8), (0.43361344537815105, 0.3999999999999999, 0.8), (0.45378151260504174, 0.3999999999999999, 0.8), (0.4739495798319324, 0.3999999999999999, 0.8), (0.49411764705882316, 0.3999999999999999, 0.8), (0.5142857142857143, 0.3999999999999999, 0.8), (0.534453781512605, 0.3999999999999999, 0.8), (0.5546218487394957, 0.3999999999999999, 0.8), (0.5747899159663864, 0.3999999999999999, 0.8), (0.5949579831932771, 0.3999999999999999, 0.8), (0.6151260504201679, 0.3999999999999999, 0.8), (0.6352941176470586, 0.3999999999999999, 0.8), (0.6554621848739492, 0.3999999999999999, 0.8), (0.6756302521008399, 0.3999999999999999, 0.8), (0.6957983193277306, 0.3999999999999999, 0.8), (0.7159663865546213, 0.3999999999999999, 0.8), (0.7361344537815124, 0.3999999999999999, 0.8), (0.7563025210084031, 0.3999999999999999, 0.8), (0.7764705882352938, 0.3999999999999999, 0.8), (0.7966386554621845, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7831932773109238), (0.8, 0.3999999999999999, 0.7630252100840331), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7226890756302518), (0.8, 0.3999999999999999, 0.7025210084033611), (0.8, 0.3999999999999999, 0.6823529411764704), (0.8, 0.3999999999999999, 0.6621848739495797), (0.8, 0.3999999999999999, 0.642016806722689), (0.8, 0.3999999999999999, 0.6218487394957983), (0.8, 0.3999999999999999, 0.6016806722689076), (0.8, 0.3999999999999999, 0.581512605042017), (0.8, 0.3999999999999999, 0.5613445378151263), (0.8, 0.3999999999999999, 0.541176470588235), (0.8, 0.3999999999999999, 0.5210084033613444), (0.8, 0.3999999999999999, 0.5008403361344537), (0.8, 0.3999999999999999, 0.4806722689075624), (0.8, 0.3999999999999999, 0.46050420168067174), (0.8, 0.3999999999999999, 0.440336134453781), (0.8, 0.3999999999999999, 0.4201680672268903)],
    120: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4199999999999998, 0.3999999999999999), (0.8, 0.4399999999999998, 0.3999999999999999), (0.8, 0.45999999999999974, 0.3999999999999999), (0.8, 0.4800000000000002, 0.3999999999999999), (0.8, 0.5000000000000001, 0.3999999999999999), (0.8, 0.52, 0.3999999999999999), (0.8, 0.54, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.5799999999999998, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6199999999999998, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6600000000000001, 0.3999999999999999), (0.8, 0.6800000000000002, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.8, 0.7399999999999999, 0.3999999999999999), (0.8, 0.7599999999999998, 0.3999999999999999), (0.8, 0.7799999999999998, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.78, 0.8, 0.3999999999999999), (0.76, 0.8, 0.3999999999999999), (0.7400000000000002, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7000000000000003, 0.8, 0.3999999999999999), (0.6799999999999998, 0.8, 0.3999999999999999), (0.6599999999999999, 0.8, 0.3999999999999999), (0.6399999999999999, 0.8, 0.3999999999999999), (0.62, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5800000000000001, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.5400000000000003, 0.8, 0.3999999999999999), (0.5200000000000004, 0.8, 0.3999999999999999), (0.49999999999999983, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.45999999999999996, 0.8, 0.3999999999999999), (0.44000000000000006, 0.8, 0.3999999999999999), (0.4200000000000001, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.42000000000000026), (0.3999999999999999, 0.8, 0.44000000000000017), (0.3999999999999999, 0.8, 0.46000000000000013), (0.3999999999999999, 0.8, 0.48000000000000004), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5199999999999999), (0.3999999999999999, 0.8, 0.5399999999999998), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5799999999999997), (0.3999999999999999, 0.8, 0.6000000000000002), (0.3999999999999999, 0.8, 0.6200000000000001), (0.3999999999999999, 0.8, 0.6400000000000001), (0.3999999999999999, 0.8, 0.66), (0.3999999999999999, 0.8, 0.6799999999999999), (0.3999999999999999, 0.8, 0.7), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.8, 0.7400000000000002), (0.3999999999999999, 0.8, 0.7600000000000002), (0.3999999999999999, 0.8, 0.7800000000000002), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.78, 0.8), (0.3999999999999999, 0.76, 0.8), (0.3999999999999999, 0.7400000000000002, 0.8), (0.3999999999999999, 0.7200000000000002, 0.8), (0.3999999999999999, 0.7000000000000003, 0.8), (0.3999999999999999, 0.6799999999999998, 0.8), (0.3999999999999999, 0.6599999999999999, 0.8), (0.3999999999999999, 0.6399999999999999, 0.8), (0.3999999999999999, 0.62, 0.8), (0.3999999999999999, 0.5999999999999995, 0.8), (0.3999999999999999, 0.5799999999999996, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5399999999999997, 0.8), (0.3999999999999999, 0.5199999999999998, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4799999999999999, 0.8), (0.3999999999999999, 0.45999999999999996, 0.8), (0.3999999999999999, 0.44000000000000006, 0.8), (0.3999999999999999, 0.4200000000000001, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4199999999999998, 0.3999999999999999, 0.8), (0.4399999999999998, 0.3999999999999999, 0.8), (0.45999999999999974, 0.3999999999999999, 0.8), (0.47999999999999965, 0.3999999999999999, 0.8), (0.5000000000000001, 0.3999999999999999, 0.8), (0.52, 0.3999999999999999, 0.8), (0.54, 0.3999999999999999, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.5799999999999998, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6199999999999998, 0.3999999999999999, 0.8), (0.6399999999999997, 0.3999999999999999, 0.8), (0.6599999999999996, 0.3999999999999999, 0.8), (0.6799999999999995, 0.3999999999999999, 0.8), (0.6999999999999995, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7399999999999999, 0.3999999999999999, 0.8), (0.7599999999999998, 0.3999999999999999, 0.8), (0.7799999999999998, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7799999999999996), (0.8, 0.3999999999999999, 0.7599999999999996), (0.8, 0.3999999999999999, 0.7399999999999995), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6799999999999998), (0.8, 0.3999999999999999, 0.6599999999999999), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.62), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5800000000000001), (0.8, 0.3999999999999999, 0.5599999999999996), (0.8, 0.3999999999999999, 0.5399999999999997), (0.8, 0.3999999999999999, 0.5199999999999998), (0.8, 0.3999999999999999, 0.49999999999999933), (0.8, 0.3999999999999999, 0.47999999999999937), (0.8, 0.3999999999999999, 0.45999999999999946), (0.8, 0.3999999999999999, 0.4399999999999995), (0.8, 0.3999999999999999, 0.4199999999999996)],
    121: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4198347107438015, 0.3999999999999999), (0.8, 0.4396694214876031, 0.3999999999999999), (0.8, 0.4595041322314047, 0.3999999999999999), (0.8, 0.4793388429752063, 0.3999999999999999), (0.8, 0.4991735537190084, 0.3999999999999999), (0.8, 0.51900826446281, 0.3999999999999999), (0.8, 0.5388429752066116, 0.3999999999999999), (0.8, 0.5586776859504132, 0.3999999999999999), (0.8, 0.5785123966942147, 0.3999999999999999), (0.8, 0.5983471074380163, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6380165289256201, 0.3999999999999999), (0.8, 0.6578512396694217, 0.3999999999999999), (0.8, 0.6776859504132233, 0.3999999999999999), (0.8, 0.6975206611570248, 0.3999999999999999), (0.8, 0.7173553719008265, 0.3999999999999999), (0.8, 0.737190082644628, 0.3999999999999999), (0.8, 0.7570247933884297, 0.3999999999999999), (0.8, 0.7768595041322313, 0.3999999999999999), (0.8, 0.7966942148760328, 0.3999999999999999), (0.7834710743801652, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.743801652892562, 0.8, 0.3999999999999999), (0.7239669421487605, 0.8, 0.3999999999999999), (0.7041322314049588, 0.8, 0.3999999999999999), (0.6842975206611572, 0.8, 0.3999999999999999), (0.6644628099173557, 0.8, 0.3999999999999999), (0.6446280991735536, 0.8, 0.3999999999999999), (0.624793388429752, 0.8, 0.3999999999999999), (0.6049586776859504, 0.8, 0.3999999999999999), (0.5851239669421487, 0.8, 0.3999999999999999), (0.5652892561983471, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5256198347107439, 0.8, 0.3999999999999999), (0.5057851239669419, 0.8, 0.3999999999999999), (0.48595041322314075, 0.8, 0.3999999999999999), (0.46611570247933864, 0.8, 0.3999999999999999), (0.44628099173553704, 0.8, 0.3999999999999999), (0.4264462809917354, 0.8, 0.3999999999999999), (0.4066115702479339, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41322314049586767), (0.3999999999999999, 0.8, 0.4330578512396693), (0.3999999999999999, 0.8, 0.4528925619834709), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.49256198347107405), (0.3999999999999999, 0.8, 0.5123966942148762), (0.3999999999999999, 0.8, 0.5322314049586778), (0.3999999999999999, 0.8, 0.5520661157024793), (0.3999999999999999, 0.8, 0.5719008264462809), (0.3999999999999999, 0.8, 0.5917355371900825), (0.3999999999999999, 0.8, 0.6115702479338847), (0.3999999999999999, 0.8, 0.6314049586776858), (0.3999999999999999, 0.8, 0.6512396694214879), (0.3999999999999999, 0.8, 0.6710743801652894), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7107438016528926), (0.3999999999999999, 0.8, 0.7305785123966942), (0.3999999999999999, 0.8, 0.7504132231404959), (0.3999999999999999, 0.8, 0.7702479338842975), (0.3999999999999999, 0.8, 0.7900826446280995), (0.3999999999999999, 0.7900826446280995, 0.8), (0.3999999999999999, 0.7702479338842974, 0.8), (0.3999999999999999, 0.7504132231404956, 0.8), (0.3999999999999999, 0.7305785123966941, 0.8), (0.3999999999999999, 0.7107438016528925, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6710743801652888, 0.8), (0.3999999999999999, 0.6512396694214877, 0.8), (0.3999999999999999, 0.6314049586776856, 0.8), (0.3999999999999999, 0.611570247933884, 0.8), (0.3999999999999999, 0.5917355371900824, 0.8), (0.3999999999999999, 0.5719008264462808, 0.8), (0.3999999999999999, 0.5520661157024792, 0.8), (0.3999999999999999, 0.5322314049586776, 0.8), (0.3999999999999999, 0.5123966942148761, 0.8), (0.3999999999999999, 0.49256198347107394, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.4528925619834707, 0.8), (0.3999999999999999, 0.43305785123966917, 0.8), (0.3999999999999999, 0.41322314049586756, 0.8), (0.4066115702479336, 0.3999999999999999, 0.8), (0.4264462809917352, 0.3999999999999999, 0.8), (0.4462809917355373, 0.3999999999999999, 0.8), (0.46611570247933837, 0.3999999999999999, 0.8), (0.4859504132231405, 0.3999999999999999, 0.8), (0.5057851239669421, 0.3999999999999999, 0.8), (0.5256198347107437, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5652892561983469, 0.3999999999999999, 0.8), (0.5851239669421484, 0.3999999999999999, 0.8), (0.60495867768595, 0.3999999999999999, 0.8), (0.6247933884297522, 0.3999999999999999, 0.8), (0.6446280991735532, 0.3999999999999999, 0.8), (0.6644628099173554, 0.3999999999999999, 0.8), (0.684297520661157, 0.3999999999999999, 0.8), (0.7041322314049585, 0.3999999999999999, 0.8), (0.7239669421487602, 0.3999999999999999, 0.8), (0.7438016528925617, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.783471074380165, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7966942148760325), (0.8, 0.3999999999999999, 0.776859504132231), (0.8, 0.3999999999999999, 0.7570247933884293), (0.8, 0.3999999999999999, 0.7371900826446278), (0.8, 0.3999999999999999, 0.7173553719008262), (0.8, 0.3999999999999999, 0.6975206611570246), (0.8, 0.3999999999999999, 0.6776859504132231), (0.8, 0.3999999999999999, 0.6578512396694209), (0.8, 0.3999999999999999, 0.6380165289256199), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.5983471074380161), (0.8, 0.3999999999999999, 0.5785123966942145), (0.8, 0.3999999999999999, 0.5586776859504129), (0.8, 0.3999999999999999, 0.5388429752066113), (0.8, 0.3999999999999999, 0.5190082644628092), (0.8, 0.3999999999999999, 0.4991735537190081), (0.8, 0.3999999999999999, 0.479338842975206), (0.8, 0.3999999999999999, 0.4595041322314044), (0.8, 0.3999999999999999, 0.43966942148760285), (0.8, 0.3999999999999999, 0.41983471074380124)],
    122: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41967213114754065, 0.3999999999999999), (0.8, 0.43934426229508194, 0.3999999999999999), (0.8, 0.4590163934426227, 0.3999999999999999), (0.8, 0.478688524590164, 0.3999999999999999), (0.8, 0.4983606557377047, 0.3999999999999999), (0.8, 0.518032786885246, 0.3999999999999999), (0.8, 0.5377049180327867, 0.3999999999999999), (0.8, 0.557377049180328, 0.3999999999999999), (0.8, 0.5770491803278688, 0.3999999999999999), (0.8, 0.5967213114754101, 0.3999999999999999), (0.8, 0.6163934426229508, 0.3999999999999999), (0.8, 0.6360655737704921, 0.3999999999999999), (0.8, 0.6557377049180328, 0.3999999999999999), (0.8, 0.6754098360655736, 0.3999999999999999), (0.8, 0.6950819672131148, 0.3999999999999999), (0.8, 0.7147540983606555, 0.3999999999999999), (0.8, 0.7344262295081969, 0.3999999999999999), (0.8, 0.7540983606557377, 0.3999999999999999), (0.8, 0.7737704918032788, 0.3999999999999999), (0.8, 0.7934426229508196, 0.3999999999999999), (0.7868852459016393, 0.8, 0.3999999999999999), (0.7672131147540986, 0.8, 0.3999999999999999), (0.7475409836065572, 0.8, 0.3999999999999999), (0.7278688524590164, 0.8, 0.3999999999999999), (0.7081967213114753, 0.8, 0.3999999999999999), (0.6885245901639345, 0.8, 0.3999999999999999), (0.6688524590163938, 0.8, 0.3999999999999999), (0.6491803278688525, 0.8, 0.3999999999999999), (0.6295081967213118, 0.8, 0.3999999999999999), (0.6098360655737705, 0.8, 0.3999999999999999), (0.5901639344262297, 0.8, 0.3999999999999999), (0.5704918032786884, 0.8, 0.3999999999999999), (0.5508196721311477, 0.8, 0.3999999999999999), (0.5311475409836064, 0.8, 0.3999999999999999), (0.5114754098360657, 0.8, 0.3999999999999999), (0.4918032786885249, 0.8, 0.3999999999999999), (0.4721311475409836, 0.8, 0.3999999999999999), (0.4524590163934423, 0.8, 0.3999999999999999), (0.4327868852459016, 0.8, 0.3999999999999999), (0.41311475409836085, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4065573770491804), (0.3999999999999999, 0.8, 0.4262295081967211), (0.3999999999999999, 0.8, 0.4459016393442624), (0.3999999999999999, 0.8, 0.46557377049180315), (0.3999999999999999, 0.8, 0.48524590163934445), (0.3999999999999999, 0.8, 0.5049180327868852), (0.3999999999999999, 0.8, 0.5245901639344265), (0.3999999999999999, 0.8, 0.5442622950819672), (0.3999999999999999, 0.8, 0.563934426229508), (0.3999999999999999, 0.8, 0.5836065573770493), (0.3999999999999999, 0.8, 0.6032786885245905), (0.3999999999999999, 0.8, 0.6229508196721313), (0.3999999999999999, 0.8, 0.642622950819672), (0.3999999999999999, 0.8, 0.6622950819672133), (0.3999999999999999, 0.8, 0.6819672131147541), (0.3999999999999999, 0.8, 0.7016393442622952), (0.3999999999999999, 0.8, 0.721311475409836), (0.3999999999999999, 0.8, 0.7409836065573774), (0.3999999999999999, 0.8, 0.7606557377049181), (0.3999999999999999, 0.8, 0.7803278688524593), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7803278688524593, 0.8), (0.3999999999999999, 0.7606557377049179, 0.8), (0.3999999999999999, 0.7409836065573767, 0.8), (0.3999999999999999, 0.721311475409836, 0.8), (0.3999999999999999, 0.7016393442622952, 0.8), (0.3999999999999999, 0.6819672131147538, 0.8), (0.3999999999999999, 0.6622950819672127, 0.8), (0.3999999999999999, 0.6426229508196719, 0.8), (0.3999999999999999, 0.6229508196721312, 0.8), (0.3999999999999999, 0.6032786885245903, 0.8), (0.3999999999999999, 0.583606557377049, 0.8), (0.3999999999999999, 0.5639344262295078, 0.8), (0.3999999999999999, 0.5442622950819671, 0.8), (0.3999999999999999, 0.5245901639344264, 0.8), (0.3999999999999999, 0.5049180327868851, 0.8), (0.3999999999999999, 0.4852459016393438, 0.8), (0.3999999999999999, 0.46557377049180304, 0.8), (0.3999999999999999, 0.4459016393442623, 0.8), (0.3999999999999999, 0.426229508196721, 0.8), (0.3999999999999999, 0.4065573770491797, 0.8), (0.41311475409836057, 0.3999999999999999, 0.8), (0.4327868852459013, 0.3999999999999999, 0.8), (0.4524590163934421, 0.3999999999999999, 0.8), (0.47213114754098334, 0.3999999999999999, 0.8), (0.49180327868852464, 0.3999999999999999, 0.8), (0.5114754098360654, 0.3999999999999999, 0.8), (0.5311475409836062, 0.3999999999999999, 0.8), (0.5508196721311474, 0.3999999999999999, 0.8), (0.5704918032786886, 0.3999999999999999, 0.8), (0.5901639344262294, 0.3999999999999999, 0.8), (0.6098360655737701, 0.3999999999999999, 0.8), (0.6295081967213114, 0.3999999999999999, 0.8), (0.6491803278688527, 0.3999999999999999, 0.8), (0.6688524590163936, 0.3999999999999999, 0.8), (0.6885245901639343, 0.3999999999999999, 0.8), (0.708196721311475, 0.3999999999999999, 0.8), (0.7278688524590162, 0.3999999999999999, 0.8), (0.7475409836065575, 0.3999999999999999, 0.8), (0.7672131147540983, 0.3999999999999999, 0.8), (0.7868852459016391, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7934426229508194), (0.8, 0.3999999999999999, 0.7737704918032781), (0.8, 0.3999999999999999, 0.7540983606557373), (0.8, 0.3999999999999999, 0.7344262295081966), (0.8, 0.3999999999999999, 0.7147540983606553), (0.8, 0.3999999999999999, 0.6950819672131141), (0.8, 0.3999999999999999, 0.6754098360655734), (0.8, 0.3999999999999999, 0.6557377049180325), (0.8, 0.3999999999999999, 0.6360655737704918), (0.8, 0.3999999999999999, 0.6163934426229505), (0.8, 0.3999999999999999, 0.5967213114754092), (0.8, 0.3999999999999999, 0.5770491803278684), (0.8, 0.3999999999999999, 0.5573770491803277), (0.8, 0.3999999999999999, 0.5377049180327864), (0.8, 0.3999999999999999, 0.5180327868852452), (0.8, 0.3999999999999999, 0.49836065573770444), (0.8, 0.3999999999999999, 0.4786885245901637), (0.8, 0.3999999999999999, 0.4590163934426224), (0.8, 0.3999999999999999, 0.4393442622950811), (0.8, 0.3999999999999999, 0.4196721311475404)],
    123: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.419512195121951, 0.3999999999999999), (0.8, 0.43902439024390255, 0.3999999999999999), (0.8, 0.4585365853658536, 0.3999999999999999), (0.8, 0.4780487804878047, 0.3999999999999999), (0.8, 0.4975609756097563, 0.3999999999999999), (0.8, 0.5170731707317073, 0.3999999999999999), (0.8, 0.5365853658536585, 0.3999999999999999), (0.8, 0.5560975609756095, 0.3999999999999999), (0.8, 0.575609756097561, 0.3999999999999999), (0.8, 0.5951219512195122, 0.3999999999999999), (0.8, 0.6146341463414633, 0.3999999999999999), (0.8, 0.6341463414634149, 0.3999999999999999), (0.8, 0.6536585365853659, 0.3999999999999999), (0.8, 0.673170731707317, 0.3999999999999999), (0.8, 0.6926829268292686, 0.3999999999999999), (0.8, 0.7121951219512197, 0.3999999999999999), (0.8, 0.7317073170731707, 0.3999999999999999), (0.8, 0.7512195121951223, 0.3999999999999999), (0.8, 0.7707317073170734, 0.3999999999999999), (0.8, 0.7902439024390244, 0.3999999999999999), (0.7902439024390246, 0.8, 0.3999999999999999), (0.7707317073170731, 0.8, 0.3999999999999999), (0.751219512195122, 0.8, 0.3999999999999999), (0.7317073170731709, 0.8, 0.3999999999999999), (0.7121951219512194, 0.8, 0.3999999999999999), (0.6926829268292682, 0.8, 0.3999999999999999), (0.6731707317073172, 0.8, 0.3999999999999999), (0.6536585365853662, 0.8, 0.3999999999999999), (0.6341463414634145, 0.8, 0.3999999999999999), (0.6146341463414635, 0.8, 0.3999999999999999), (0.5951219512195124, 0.8, 0.3999999999999999), (0.5756097560975608, 0.8, 0.3999999999999999), (0.5560975609756098, 0.8, 0.3999999999999999), (0.5365853658536587, 0.8, 0.3999999999999999), (0.5170731707317071, 0.8, 0.3999999999999999), (0.49756097560975604, 0.8, 0.3999999999999999), (0.47804878048780497, 0.8, 0.3999999999999999), (0.4585365853658534, 0.8, 0.3999999999999999), (0.43902439024390233, 0.8, 0.3999999999999999), (0.41951219512195126, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.41951219512195137), (0.3999999999999999, 0.8, 0.43902439024390244), (0.3999999999999999, 0.8, 0.45853658536585407), (0.3999999999999999, 0.8, 0.4780487804878051), (0.3999999999999999, 0.8, 0.49756097560975615), (0.3999999999999999, 0.8, 0.5170731707317072), (0.3999999999999999, 0.8, 0.5365853658536583), (0.3999999999999999, 0.8, 0.5560975609756099), (0.3999999999999999, 0.8, 0.5756097560975609), (0.3999999999999999, 0.8, 0.5951219512195121), (0.3999999999999999, 0.8, 0.6146341463414636), (0.3999999999999999, 0.8, 0.6341463414634148), (0.3999999999999999, 0.8, 0.6536585365853658), (0.3999999999999999, 0.8, 0.6731707317073174), (0.3999999999999999, 0.8, 0.6926829268292685), (0.3999999999999999, 0.8, 0.7121951219512195), (0.3999999999999999, 0.8, 0.7317073170731712), (0.3999999999999999, 0.8, 0.7512195121951222), (0.3999999999999999, 0.8, 0.7707317073170732), (0.3999999999999999, 0.8, 0.7902439024390249), (0.3999999999999999, 0.7902439024390242, 0.8), (0.3999999999999999, 0.7707317073170731, 0.8), (0.3999999999999999, 0.7512195121951215, 0.8), (0.3999999999999999, 0.7317073170731705, 0.8), (0.3999999999999999, 0.7121951219512194, 0.8), (0.3999999999999999, 0.6926829268292678, 0.8), (0.3999999999999999, 0.6731707317073172, 0.8), (0.3999999999999999, 0.6536585365853657, 0.8), (0.3999999999999999, 0.6341463414634141, 0.8), (0.3999999999999999, 0.6146341463414635, 0.8), (0.3999999999999999, 0.595121951219512, 0.8), (0.3999999999999999, 0.5756097560975608, 0.8), (0.3999999999999999, 0.5560975609756098, 0.8), (0.3999999999999999, 0.5365853658536581, 0.8), (0.3999999999999999, 0.5170731707317071, 0.8), (0.3999999999999999, 0.49756097560975604, 0.8), (0.3999999999999999, 0.4780487804878044, 0.8), (0.3999999999999999, 0.4585365853658534, 0.8), (0.3999999999999999, 0.43902439024390233, 0.8), (0.3999999999999999, 0.4195121951219507, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.419512195121951, 0.3999999999999999, 0.8), (0.43902439024390255, 0.3999999999999999, 0.8), (0.4585365853658536, 0.3999999999999999, 0.8), (0.4780487804878047, 0.3999999999999999, 0.8), (0.4975609756097563, 0.3999999999999999, 0.8), (0.5170731707317073, 0.3999999999999999, 0.8), (0.5365853658536585, 0.3999999999999999, 0.8), (0.55609756097561, 0.3999999999999999, 0.8), (0.5756097560975606, 0.3999999999999999, 0.8), (0.5951219512195122, 0.3999999999999999, 0.8), (0.6146341463414637, 0.3999999999999999, 0.8), (0.6341463414634143, 0.3999999999999999, 0.8), (0.6536585365853659, 0.3999999999999999, 0.8), (0.673170731707317, 0.3999999999999999, 0.8), (0.692682926829268, 0.3999999999999999, 0.8), (0.7121951219512197, 0.3999999999999999, 0.8), (0.7317073170731707, 0.3999999999999999, 0.8), (0.7512195121951217, 0.3999999999999999, 0.8), (0.7707317073170734, 0.3999999999999999, 0.8), (0.7902439024390244, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7902439024390242), (0.8, 0.3999999999999999, 0.7707317073170725), (0.8, 0.3999999999999999, 0.7512195121951215), (0.8, 0.3999999999999999, 0.7317073170731705), (0.8, 0.3999999999999999, 0.7121951219512188), (0.8, 0.3999999999999999, 0.6926829268292678), (0.8, 0.3999999999999999, 0.6731707317073168), (0.8, 0.3999999999999999, 0.6536585365853651), (0.8, 0.3999999999999999, 0.6341463414634141), (0.8, 0.3999999999999999, 0.614634146341463), (0.8, 0.3999999999999999, 0.5951219512195114), (0.8, 0.3999999999999999, 0.5756097560975608), (0.8, 0.3999999999999999, 0.5560975609756093), (0.8, 0.3999999999999999, 0.5365853658536577), (0.8, 0.3999999999999999, 0.5170731707317071), (0.8, 0.3999999999999999, 0.4975609756097555), (0.8, 0.3999999999999999, 0.4780487804878039), (0.8, 0.3999999999999999, 0.4585365853658534), (0.8, 0.3999999999999999, 0.4390243902439018), (0.8, 0.3999999999999999, 0.4195121951219507)],
    124: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4193548387096773, 0.3999999999999999), (0.8, 0.43870967741935474, 0.3999999999999999), (0.8, 0.45806451612903215, 0.3999999999999999), (0.8, 0.47741935483870956, 0.3999999999999999), (0.8, 0.496774193548387, 0.3999999999999999), (0.8, 0.5161290322580644, 0.3999999999999999), (0.8, 0.5354838709677417, 0.3999999999999999), (0.8, 0.5548387096774192, 0.3999999999999999), (0.8, 0.5741935483870966, 0.3999999999999999), (0.8, 0.593548387096774, 0.3999999999999999), (0.8, 0.6129032258064514, 0.3999999999999999), (0.8, 0.6322580645161289, 0.3999999999999999), (0.8, 0.6516129032258062, 0.3999999999999999), (0.8, 0.6709677419354836, 0.3999999999999999), (0.8, 0.6903225806451616, 0.3999999999999999), (0.8, 0.7096774193548385, 0.3999999999999999), (0.8, 0.7290322580645163, 0.3999999999999999), (0.8, 0.7483870967741932, 0.3999999999999999), (0.8, 0.7677419354838713, 0.3999999999999999), (0.8, 0.7870967741935486, 0.3999999999999999), (0.7935483870967741, 0.8, 0.3999999999999999), (0.7741935483870968, 0.8, 0.3999999999999999), (0.7548387096774194, 0.8, 0.3999999999999999), (0.7354838709677419, 0.8, 0.3999999999999999), (0.7161290322580645, 0.8, 0.3999999999999999), (0.6967741935483871, 0.8, 0.3999999999999999), (0.6774193548387097, 0.8, 0.3999999999999999), (0.6580645161290323, 0.8, 0.3999999999999999), (0.6387096774193549, 0.8, 0.3999999999999999), (0.6193548387096774, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5806451612903226, 0.8, 0.3999999999999999), (0.5612903225806453, 0.8, 0.3999999999999999), (0.5419354838709678, 0.8, 0.3999999999999999), (0.5225806451612904, 0.8, 0.3999999999999999), (0.5032258064516131, 0.8, 0.3999999999999999), (0.4838709677419356, 0.8, 0.3999999999999999), (0.4645161290322582, 0.8, 0.3999999999999999), (0.4451612903225808, 0.8, 0.3999999999999999), (0.42580645161290337, 0.8, 0.3999999999999999), (0.40645161290322596, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4129032258064514), (0.3999999999999999, 0.8, 0.4322580645161288), (0.3999999999999999, 0.8, 0.4516129032258067), (0.3999999999999999, 0.8, 0.47096774193548363), (0.3999999999999999, 0.8, 0.49032258064516154), (0.3999999999999999, 0.8, 0.5096774193548385), (0.3999999999999999, 0.8, 0.5290322580645164), (0.3999999999999999, 0.8, 0.5483870967741933), (0.3999999999999999, 0.8, 0.5677419354838712), (0.3999999999999999, 0.8, 0.587096774193548), (0.3999999999999999, 0.8, 0.606451612903226), (0.3999999999999999, 0.8, 0.6258064516129034), (0.3999999999999999, 0.8, 0.6451612903225808), (0.3999999999999999, 0.8, 0.6645161290322583), (0.3999999999999999, 0.8, 0.6838709677419357), (0.3999999999999999, 0.8, 0.703225806451613), (0.3999999999999999, 0.8, 0.7225806451612904), (0.3999999999999999, 0.8, 0.7419354838709679), (0.3999999999999999, 0.8, 0.7612903225806453), (0.3999999999999999, 0.8, 0.7806451612903227), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7806451612903225, 0.8), (0.3999999999999999, 0.7612903225806451, 0.8), (0.3999999999999999, 0.7419354838709677, 0.8), (0.3999999999999999, 0.7225806451612904, 0.8), (0.3999999999999999, 0.7032258064516129, 0.8), (0.3999999999999999, 0.6838709677419355, 0.8), (0.3999999999999999, 0.6645161290322581, 0.8), (0.3999999999999999, 0.6451612903225807, 0.8), (0.3999999999999999, 0.6258064516129033, 0.8), (0.3999999999999999, 0.6064516129032259, 0.8), (0.3999999999999999, 0.587096774193548, 0.8), (0.3999999999999999, 0.5677419354838711, 0.8), (0.3999999999999999, 0.5483870967741931, 0.8), (0.3999999999999999, 0.5290322580645163, 0.8), (0.3999999999999999, 0.5096774193548383, 0.8), (0.3999999999999999, 0.49032258064516143, 0.8), (0.3999999999999999, 0.47096774193548346, 0.8), (0.3999999999999999, 0.4516129032258066, 0.8), (0.3999999999999999, 0.43225806451612864, 0.8), (0.3999999999999999, 0.4129032258064518, 0.8), (0.40645161290322573, 0.3999999999999999, 0.8), (0.4258064516129026, 0.3999999999999999, 0.8), (0.44516129032258056, 0.3999999999999999, 0.8), (0.4645161290322574, 0.3999999999999999, 0.8), (0.48387096774193533, 0.3999999999999999, 0.8), (0.5032258064516127, 0.3999999999999999, 0.8), (0.5225806451612902, 0.3999999999999999, 0.8), (0.5419354838709676, 0.3999999999999999, 0.8), (0.5612903225806449, 0.3999999999999999, 0.8), (0.5806451612903224, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6193548387096772, 0.3999999999999999, 0.8), (0.6387096774193546, 0.3999999999999999, 0.8), (0.658064516129032, 0.3999999999999999, 0.8), (0.6774193548387095, 0.3999999999999999, 0.8), (0.6967741935483869, 0.3999999999999999, 0.8), (0.7161290322580642, 0.3999999999999999, 0.8), (0.7354838709677416, 0.3999999999999999, 0.8), (0.7548387096774191, 0.3999999999999999, 0.8), (0.7741935483870965, 0.3999999999999999, 0.8), (0.7935483870967739, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7870967741935484), (0.8, 0.3999999999999999, 0.7677419354838709), (0.8, 0.3999999999999999, 0.748387096774193), (0.8, 0.3999999999999999, 0.7290322580645161), (0.8, 0.3999999999999999, 0.7096774193548382), (0.8, 0.3999999999999999, 0.6903225806451614), (0.8, 0.3999999999999999, 0.6709677419354834), (0.8, 0.3999999999999999, 0.6516129032258065), (0.8, 0.3999999999999999, 0.6322580645161285), (0.8, 0.3999999999999999, 0.6129032258064517), (0.8, 0.3999999999999999, 0.5935483870967737), (0.8, 0.3999999999999999, 0.5741935483870968), (0.8, 0.3999999999999999, 0.5548387096774189), (0.8, 0.3999999999999999, 0.5354838709677421), (0.8, 0.3999999999999999, 0.5161290322580641), (0.8, 0.3999999999999999, 0.4967741935483872), (0.8, 0.3999999999999999, 0.4774193548387093), (0.8, 0.3999999999999999, 0.4580645161290319), (0.8, 0.3999999999999999, 0.43870967741935446), (0.8, 0.3999999999999999, 0.41935483870967705)],
    125: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4191999999999999, 0.3999999999999999), (0.8, 0.43839999999999996, 0.3999999999999999), (0.8, 0.4576, 0.3999999999999999), (0.8, 0.4768, 0.3999999999999999), (0.8, 0.49600000000000005, 0.3999999999999999), (0.8, 0.5152000000000001, 0.3999999999999999), (0.8, 0.5344000000000001, 0.3999999999999999), (0.8, 0.5536000000000001, 0.3999999999999999), (0.8, 0.5728000000000001, 0.3999999999999999), (0.8, 0.5920000000000002, 0.3999999999999999), (0.8, 0.6112000000000002, 0.3999999999999999), (0.8, 0.6304000000000002, 0.3999999999999999), (0.8, 0.6496000000000002, 0.3999999999999999), (0.8, 0.6688000000000003, 0.3999999999999999), (0.8, 0.6880000000000003, 0.3999999999999999), (0.8, 0.7072000000000003, 0.3999999999999999), (0.8, 0.7264000000000004, 0.3999999999999999), (0.8, 0.7456000000000003, 0.3999999999999999), (0.8, 0.7647999999999998, 0.3999999999999999), (0.8, 0.7839999999999998, 0.3999999999999999), (0.7968000000000004, 0.8, 0.3999999999999999), (0.7776000000000003, 0.8, 0.3999999999999999), (0.7584000000000002, 0.8, 0.3999999999999999), (0.7392000000000003, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7008000000000002, 0.8, 0.3999999999999999), (0.6816000000000002, 0.8, 0.3999999999999999), (0.6624000000000001, 0.8, 0.3999999999999999), (0.6432000000000001, 0.8, 0.3999999999999999), (0.6240000000000001, 0.8, 0.3999999999999999), (0.6048000000000001, 0.8, 0.3999999999999999), (0.5856000000000001, 0.8, 0.3999999999999999), (0.5664, 0.8, 0.3999999999999999), (0.5472, 0.8, 0.3999999999999999), (0.528, 0.8, 0.3999999999999999), (0.5087999999999999, 0.8, 0.3999999999999999), (0.4895999999999999, 0.8, 0.3999999999999999), (0.47039999999999993, 0.8, 0.3999999999999999), (0.4511999999999999, 0.8, 0.3999999999999999), (0.4319999999999999, 0.8, 0.3999999999999999), (0.41279999999999983, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40640000000000015), (0.3999999999999999, 0.8, 0.42560000000000014), (0.3999999999999999, 0.8, 0.44479999999999964), (0.3999999999999999, 0.8, 0.4639999999999997), (0.3999999999999999, 0.8, 0.4831999999999997), (0.3999999999999999, 0.8, 0.5023999999999997), (0.3999999999999999, 0.8, 0.5215999999999997), (0.3999999999999999, 0.8, 0.5407999999999997), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5791999999999998), (0.3999999999999999, 0.8, 0.5983999999999998), (0.3999999999999999, 0.8, 0.6175999999999999), (0.3999999999999999, 0.8, 0.6367999999999999), (0.3999999999999999, 0.8, 0.6559999999999999), (0.3999999999999999, 0.8, 0.6752), (0.3999999999999999, 0.8, 0.6943999999999999), (0.3999999999999999, 0.8, 0.7136), (0.3999999999999999, 0.8, 0.7328), (0.3999999999999999, 0.8, 0.752), (0.3999999999999999, 0.8, 0.7712000000000001), (0.3999999999999999, 0.8, 0.7904), (0.3999999999999999, 0.7904, 0.8), (0.3999999999999999, 0.7711999999999999, 0.8), (0.3999999999999999, 0.7519999999999999, 0.8), (0.3999999999999999, 0.7327999999999999, 0.8), (0.3999999999999999, 0.7135999999999998, 0.8), (0.3999999999999999, 0.6943999999999999, 0.8), (0.3999999999999999, 0.6751999999999998, 0.8), (0.3999999999999999, 0.6559999999999998, 0.8), (0.3999999999999999, 0.6367999999999998, 0.8), (0.3999999999999999, 0.6175999999999997, 0.8), (0.3999999999999999, 0.5983999999999997, 0.8), (0.3999999999999999, 0.5791999999999997, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5407999999999996, 0.8), (0.3999999999999999, 0.5215999999999996, 0.8), (0.3999999999999999, 0.5023999999999996, 0.8), (0.3999999999999999, 0.4831999999999996, 0.8), (0.3999999999999999, 0.4639999999999995, 0.8), (0.3999999999999999, 0.44479999999999953, 0.8), (0.3999999999999999, 0.4255999999999995, 0.8), (0.3999999999999999, 0.4063999999999995, 0.8), (0.4128000000000001, 0.3999999999999999, 0.8), (0.4320000000000001, 0.3999999999999999, 0.8), (0.45120000000000016, 0.3999999999999999, 0.8), (0.47040000000000015, 0.3999999999999999, 0.8), (0.48959999999999965, 0.3999999999999999, 0.8), (0.5087999999999997, 0.3999999999999999, 0.8), (0.5279999999999997, 0.3999999999999999, 0.8), (0.5471999999999997, 0.3999999999999999, 0.8), (0.5663999999999998, 0.3999999999999999, 0.8), (0.5855999999999998, 0.3999999999999999, 0.8), (0.6047999999999998, 0.3999999999999999, 0.8), (0.6239999999999999, 0.3999999999999999, 0.8), (0.6431999999999999, 0.3999999999999999, 0.8), (0.6623999999999999, 0.3999999999999999, 0.8), (0.6816, 0.3999999999999999, 0.8), (0.7007999999999999, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7392, 0.3999999999999999, 0.8), (0.7584, 0.3999999999999999, 0.8), (0.7776000000000001, 0.3999999999999999, 0.8), (0.7968, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.784), (0.8, 0.3999999999999999, 0.7648000000000001), (0.8, 0.3999999999999999, 0.7456), (0.8, 0.3999999999999999, 0.7264), (0.8, 0.3999999999999999, 0.7072), (0.8, 0.3999999999999999, 0.688), (0.8, 0.3999999999999999, 0.6688000000000001), (0.8, 0.3999999999999999, 0.6496), (0.8, 0.3999999999999999, 0.6304), (0.8, 0.3999999999999999, 0.6111999999999999), (0.8, 0.3999999999999999, 0.5919999999999999), (0.8, 0.3999999999999999, 0.5727999999999999), (0.8, 0.3999999999999999, 0.5535999999999999), (0.8, 0.3999999999999999, 0.5343999999999998), (0.8, 0.3999999999999999, 0.5151999999999998), (0.8, 0.3999999999999999, 0.4959999999999998), (0.8, 0.3999999999999999, 0.4767999999999997), (0.8, 0.3999999999999999, 0.45759999999999973), (0.8, 0.3999999999999999, 0.4383999999999997), (0.8, 0.3999999999999999, 0.4191999999999997)],
    126: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4190476190476189, 0.3999999999999999), (0.8, 0.43809523809523787, 0.3999999999999999), (0.8, 0.45714285714285685, 0.3999999999999999), (0.8, 0.47619047619047583, 0.3999999999999999), (0.8, 0.49523809523809537, 0.3999999999999999), (0.8, 0.5142857142857143, 0.3999999999999999), (0.8, 0.5333333333333333, 0.3999999999999999), (0.8, 0.5523809523809523, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.5904761904761903, 0.3999999999999999), (0.8, 0.6095238095238092, 0.3999999999999999), (0.8, 0.6285714285714288, 0.3999999999999999), (0.8, 0.6476190476190478, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6857142857142857, 0.3999999999999999), (0.8, 0.7047619047619047, 0.3999999999999999), (0.8, 0.7238095238095237, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7619047619047616, 0.3999999999999999), (0.8, 0.7809523809523806, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7809523809523811, 0.8, 0.3999999999999999), (0.761904761904762, 0.8, 0.3999999999999999), (0.742857142857143, 0.8, 0.3999999999999999), (0.723809523809524, 0.8, 0.3999999999999999), (0.704761904761905, 0.8, 0.3999999999999999), (0.685714285714286, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6476190476190475, 0.8, 0.3999999999999999), (0.6285714285714286, 0.8, 0.3999999999999999), (0.6095238095238096, 0.8, 0.3999999999999999), (0.5904761904761906, 0.8, 0.3999999999999999), (0.5714285714285716, 0.8, 0.3999999999999999), (0.5523809523809526, 0.8, 0.3999999999999999), (0.5333333333333337, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.49523809523809564, 0.8, 0.3999999999999999), (0.4761904761904761, 0.8, 0.3999999999999999), (0.45714285714285713, 0.8, 0.3999999999999999), (0.43809523809523815, 0.8, 0.3999999999999999), (0.41904761904761917, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4190476190476193), (0.3999999999999999, 0.8, 0.43809523809523826), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.4761904761904763), (0.3999999999999999, 0.8, 0.49523809523809526), (0.3999999999999999, 0.8, 0.5142857142857142), (0.3999999999999999, 0.8, 0.5333333333333332), (0.3999999999999999, 0.8, 0.5523809523809522), (0.3999999999999999, 0.8, 0.5714285714285712), (0.3999999999999999, 0.8, 0.5904761904761902), (0.3999999999999999, 0.8, 0.6095238095238091), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6476190476190476), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6857142857142857), (0.3999999999999999, 0.8, 0.7047619047619047), (0.3999999999999999, 0.8, 0.7238095238095241), (0.3999999999999999, 0.8, 0.7428571428571431), (0.3999999999999999, 0.8, 0.7619047619047621), (0.3999999999999999, 0.8, 0.7809523809523811), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7809523809523811, 0.8), (0.3999999999999999, 0.761904761904762, 0.8), (0.3999999999999999, 0.742857142857143, 0.8), (0.3999999999999999, 0.723809523809524, 0.8), (0.3999999999999999, 0.704761904761905, 0.8), (0.3999999999999999, 0.685714285714286, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6476190476190475, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6095238095238096, 0.8), (0.3999999999999999, 0.5904761904761906, 0.8), (0.3999999999999999, 0.5714285714285711, 0.8), (0.3999999999999999, 0.5523809523809521, 0.8), (0.3999999999999999, 0.5333333333333331, 0.8), (0.3999999999999999, 0.5142857142857141, 0.8), (0.3999999999999999, 0.4952380952380951, 0.8), (0.3999999999999999, 0.4761904761904761, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.3999999999999999, 0.43809523809523815, 0.8), (0.3999999999999999, 0.41904761904761917, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41904761904761834, 0.3999999999999999, 0.8), (0.43809523809523787, 0.3999999999999999, 0.8), (0.45714285714285685, 0.3999999999999999, 0.8), (0.47619047619047583, 0.3999999999999999, 0.8), (0.49523809523809487, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5333333333333333, 0.3999999999999999, 0.8), (0.5523809523809523, 0.3999999999999999, 0.8), (0.5714285714285713, 0.3999999999999999, 0.8), (0.5904761904761903, 0.3999999999999999, 0.8), (0.6095238095238092, 0.3999999999999999, 0.8), (0.6285714285714283, 0.3999999999999999, 0.8), (0.6476190476190473, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6857142857142853, 0.3999999999999999, 0.8), (0.7047619047619043, 0.3999999999999999, 0.8), (0.7238095238095232, 0.3999999999999999, 0.8), (0.7428571428571427, 0.3999999999999999, 0.8), (0.7619047619047616, 0.3999999999999999, 0.8), (0.7809523809523806, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7809523809523811), (0.8, 0.3999999999999999, 0.7619047619047614), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7238095238095235), (0.8, 0.3999999999999999, 0.7047619047619045), (0.8, 0.3999999999999999, 0.6857142857142855), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6476190476190475), (0.8, 0.3999999999999999, 0.6285714285714286), (0.8, 0.3999999999999999, 0.6095238095238096), (0.8, 0.3999999999999999, 0.5904761904761906), (0.8, 0.3999999999999999, 0.5714285714285716), (0.8, 0.3999999999999999, 0.5523809523809521), (0.8, 0.3999999999999999, 0.5333333333333331), (0.8, 0.3999999999999999, 0.5142857142857141), (0.8, 0.3999999999999999, 0.4952380952380951), (0.8, 0.3999999999999999, 0.4761904761904761), (0.8, 0.3999999999999999, 0.45714285714285663), (0.8, 0.3999999999999999, 0.4380952380952376), (0.8, 0.3999999999999999, 0.4190476190476186)],
    127: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41889763779527545, 0.3999999999999999), (0.8, 0.43779527559055104, 0.3999999999999999), (0.8, 0.4566929133858266, 0.3999999999999999), (0.8, 0.47559055118110216, 0.3999999999999999), (0.8, 0.49448818897637775, 0.3999999999999999), (0.8, 0.5133858267716533, 0.3999999999999999), (0.8, 0.5322834645669289, 0.3999999999999999), (0.8, 0.5511811023622044, 0.3999999999999999), (0.8, 0.5700787401574805, 0.3999999999999999), (0.8, 0.588976377952756, 0.3999999999999999), (0.8, 0.6078740157480317, 0.3999999999999999), (0.8, 0.6267716535433072, 0.3999999999999999), (0.8, 0.6456692913385828, 0.3999999999999999), (0.8, 0.6645669291338583, 0.3999999999999999), (0.8, 0.6834645669291339, 0.3999999999999999), (0.8, 0.7023622047244095, 0.3999999999999999), (0.8, 0.721259842519685, 0.3999999999999999), (0.8, 0.7401574803149606, 0.3999999999999999), (0.8, 0.7590551181102361, 0.3999999999999999), (0.8, 0.7779527559055117, 0.3999999999999999), (0.8, 0.7968503937007874, 0.3999999999999999), (0.7842519685039373, 0.8, 0.3999999999999999), (0.7653543307086612, 0.8, 0.3999999999999999), (0.7464566929133857, 0.8, 0.3999999999999999), (0.7275590551181101, 0.8, 0.3999999999999999), (0.7086614173228345, 0.8, 0.3999999999999999), (0.6897637795275591, 0.8, 0.3999999999999999), (0.6708661417322834, 0.8, 0.3999999999999999), (0.6519685039370079, 0.8, 0.3999999999999999), (0.6330708661417324, 0.8, 0.3999999999999999), (0.6141732283464567, 0.8, 0.3999999999999999), (0.5952755905511812, 0.8, 0.3999999999999999), (0.5763779527559056, 0.8, 0.3999999999999999), (0.55748031496063, 0.8, 0.3999999999999999), (0.5385826771653545, 0.8, 0.3999999999999999), (0.5196850393700789, 0.8, 0.3999999999999999), (0.5007874015748034, 0.8, 0.3999999999999999), (0.4818897637795278, 0.8, 0.3999999999999999), (0.4629921259842522, 0.8, 0.3999999999999999), (0.4440944881889767, 0.8, 0.3999999999999999), (0.4251968503937011, 0.8, 0.3999999999999999), (0.40629921259842555, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4125984251968505), (0.3999999999999999, 0.8, 0.43149606299212606), (0.3999999999999999, 0.8, 0.45039370078740165), (0.3999999999999999, 0.8, 0.4692913385826772), (0.3999999999999999, 0.8, 0.4881889763779528), (0.3999999999999999, 0.8, 0.5070866141732283), (0.3999999999999999, 0.8, 0.5259842519685038), (0.3999999999999999, 0.8, 0.5448818897637795), (0.3999999999999999, 0.8, 0.563779527559055), (0.3999999999999999, 0.8, 0.5826771653543306), (0.3999999999999999, 0.8, 0.6015748031496061), (0.3999999999999999, 0.8, 0.6204724409448823), (0.3999999999999999, 0.8, 0.6393700787401578), (0.3999999999999999, 0.8, 0.6582677165354334), (0.3999999999999999, 0.8, 0.677165354330709), (0.3999999999999999, 0.8, 0.6960629921259844), (0.3999999999999999, 0.8, 0.7149606299212601), (0.3999999999999999, 0.8, 0.7338582677165356), (0.3999999999999999, 0.8, 0.7527559055118112), (0.3999999999999999, 0.8, 0.7716535433070868), (0.3999999999999999, 0.8, 0.7905511811023622), (0.3999999999999999, 0.7905511811023622, 0.8), (0.3999999999999999, 0.7716535433070866, 0.8), (0.3999999999999999, 0.752755905511811, 0.8), (0.3999999999999999, 0.7338582677165355, 0.8), (0.3999999999999999, 0.7149606299212599, 0.8), (0.3999999999999999, 0.6960629921259844, 0.8), (0.3999999999999999, 0.6771653543307088, 0.8), (0.3999999999999999, 0.6582677165354333, 0.8), (0.3999999999999999, 0.6393700787401577, 0.8), (0.3999999999999999, 0.6204724409448821, 0.8), (0.3999999999999999, 0.6015748031496065, 0.8), (0.3999999999999999, 0.582677165354331, 0.8), (0.3999999999999999, 0.5637795275590549, 0.8), (0.3999999999999999, 0.5448818897637793, 0.8), (0.3999999999999999, 0.5259842519685037, 0.8), (0.3999999999999999, 0.5070866141732282, 0.8), (0.3999999999999999, 0.4881889763779526, 0.8), (0.3999999999999999, 0.4692913385826771, 0.8), (0.3999999999999999, 0.4503937007874015, 0.8), (0.3999999999999999, 0.43149606299212595, 0.8), (0.3999999999999999, 0.41259842519685036, 0.8), (0.4062992125984253, 0.3999999999999999, 0.8), (0.4251968503937008, 0.3999999999999999, 0.8), (0.4440944881889764, 0.3999999999999999, 0.8), (0.462992125984252, 0.3999999999999999, 0.8), (0.4818897637795275, 0.3999999999999999, 0.8), (0.5007874015748031, 0.3999999999999999, 0.8), (0.5196850393700787, 0.3999999999999999, 0.8), (0.5385826771653542, 0.3999999999999999, 0.8), (0.5574803149606298, 0.3999999999999999, 0.8), (0.5763779527559053, 0.3999999999999999, 0.8), (0.595275590551181, 0.3999999999999999, 0.8), (0.6141732283464565, 0.3999999999999999, 0.8), (0.633070866141732, 0.3999999999999999, 0.8), (0.6519685039370076, 0.3999999999999999, 0.8), (0.6708661417322832, 0.3999999999999999, 0.8), (0.6897637795275587, 0.3999999999999999, 0.8), (0.7086614173228343, 0.3999999999999999, 0.8), (0.7275590551181099, 0.3999999999999999, 0.8), (0.7464566929133853, 0.3999999999999999, 0.8), (0.765354330708661, 0.3999999999999999, 0.8), (0.7842519685039366, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7968503937007876), (0.8, 0.3999999999999999, 0.7779527559055119), (0.8, 0.3999999999999999, 0.7590551181102358), (0.8, 0.3999999999999999, 0.7401574803149603), (0.8, 0.3999999999999999, 0.7212598425196848), (0.8, 0.3999999999999999, 0.7023622047244091), (0.8, 0.3999999999999999, 0.6834645669291337), (0.8, 0.3999999999999999, 0.6645669291338581), (0.8, 0.3999999999999999, 0.6456692913385825), (0.8, 0.3999999999999999, 0.626771653543307), (0.8, 0.3999999999999999, 0.6078740157480313), (0.8, 0.3999999999999999, 0.5889763779527553), (0.8, 0.3999999999999999, 0.5700787401574797), (0.8, 0.3999999999999999, 0.5511811023622042), (0.8, 0.3999999999999999, 0.5322834645669285), (0.8, 0.3999999999999999, 0.513385826771653), (0.8, 0.3999999999999999, 0.4944881889763775), (0.8, 0.3999999999999999, 0.4755905511811019), (0.8, 0.3999999999999999, 0.45669291338582635), (0.8, 0.3999999999999999, 0.43779527559055076), (0.8, 0.3999999999999999, 0.4188976377952752)],
    128: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4187499999999999, 0.3999999999999999), (0.8, 0.43749999999999994, 0.3999999999999999), (0.8, 0.45624999999999993, 0.3999999999999999), (0.8, 0.4749999999999999, 0.3999999999999999), (0.8, 0.49374999999999997, 0.3999999999999999), (0.8, 0.5125, 0.3999999999999999), (0.8, 0.53125, 0.3999999999999999), (0.8, 0.5499999999999999, 0.3999999999999999), (0.8, 0.56875, 0.3999999999999999), (0.8, 0.5875, 0.3999999999999999), (0.8, 0.60625, 0.3999999999999999), (0.8, 0.625, 0.3999999999999999), (0.8, 0.64375, 0.3999999999999999), (0.8, 0.6625, 0.3999999999999999), (0.8, 0.68125, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.71875, 0.3999999999999999), (0.8, 0.7375, 0.3999999999999999), (0.8, 0.7562500000000001, 0.3999999999999999), (0.8, 0.7750000000000001, 0.3999999999999999), (0.8, 0.79375, 0.3999999999999999), (0.7875000000000001, 0.8, 0.3999999999999999), (0.7687500000000002, 0.8, 0.3999999999999999), (0.7500000000000001, 0.8, 0.3999999999999999), (0.7312500000000002, 0.8, 0.3999999999999999), (0.7125000000000001, 0.8, 0.3999999999999999), (0.6937500000000001, 0.8, 0.3999999999999999), (0.675, 0.8, 0.3999999999999999), (0.6562500000000001, 0.8, 0.3999999999999999), (0.6375000000000001, 0.8, 0.3999999999999999), (0.6187500000000001, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.58125, 0.8, 0.3999999999999999), (0.5625, 0.8, 0.3999999999999999), (0.5437500000000001, 0.8, 0.3999999999999999), (0.525, 0.8, 0.3999999999999999), (0.5062500000000001, 0.8, 0.3999999999999999), (0.48750000000000004, 0.8, 0.3999999999999999), (0.46875, 0.8, 0.3999999999999999), (0.45, 0.8, 0.3999999999999999), (0.43125, 0.8, 0.3999999999999999), (0.4125, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40624999999999994), (0.3999999999999999, 0.8, 0.42499999999999993), (0.3999999999999999, 0.8, 0.44375), (0.3999999999999999, 0.8, 0.46249999999999997), (0.3999999999999999, 0.8, 0.48124999999999996), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.51875), (0.3999999999999999, 0.8, 0.5375), (0.3999999999999999, 0.8, 0.55625), (0.3999999999999999, 0.8, 0.575), (0.3999999999999999, 0.8, 0.59375), (0.3999999999999999, 0.8, 0.6125), (0.3999999999999999, 0.8, 0.6312500000000001), (0.3999999999999999, 0.8, 0.65), (0.3999999999999999, 0.8, 0.6687500000000001), (0.3999999999999999, 0.8, 0.6875), (0.3999999999999999, 0.8, 0.70625), (0.3999999999999999, 0.8, 0.7250000000000001), (0.3999999999999999, 0.8, 0.7437500000000001), (0.3999999999999999, 0.8, 0.7625000000000001), (0.3999999999999999, 0.8, 0.78125), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.78125, 0.8), (0.3999999999999999, 0.7625, 0.8), (0.3999999999999999, 0.7437499999999999, 0.8), (0.3999999999999999, 0.7249999999999999, 0.8), (0.3999999999999999, 0.7062499999999999, 0.8), (0.3999999999999999, 0.6875, 0.8), (0.3999999999999999, 0.66875, 0.8), (0.3999999999999999, 0.6499999999999999, 0.8), (0.3999999999999999, 0.6312499999999999, 0.8), (0.3999999999999999, 0.6124999999999999, 0.8), (0.3999999999999999, 0.5937499999999999, 0.8), (0.3999999999999999, 0.5749999999999998, 0.8), (0.3999999999999999, 0.5562499999999999, 0.8), (0.3999999999999999, 0.5374999999999999, 0.8), (0.3999999999999999, 0.5187499999999998, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.48124999999999984, 0.8), (0.3999999999999999, 0.46249999999999986, 0.8), (0.3999999999999999, 0.44374999999999987, 0.8), (0.3999999999999999, 0.4249999999999998, 0.8), (0.3999999999999999, 0.40624999999999983, 0.8), (0.41249999999999976, 0.3999999999999999, 0.8), (0.43124999999999974, 0.3999999999999999, 0.8), (0.44999999999999973, 0.3999999999999999, 0.8), (0.4687499999999998, 0.3999999999999999, 0.8), (0.48749999999999977, 0.3999999999999999, 0.8), (0.5062499999999998, 0.3999999999999999, 0.8), (0.5249999999999998, 0.3999999999999999, 0.8), (0.5437499999999997, 0.3999999999999999, 0.8), (0.5624999999999998, 0.3999999999999999, 0.8), (0.5812499999999998, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6187499999999998, 0.3999999999999999, 0.8), (0.6374999999999998, 0.3999999999999999, 0.8), (0.6562499999999998, 0.3999999999999999, 0.8), (0.6749999999999998, 0.3999999999999999, 0.8), (0.6937499999999999, 0.3999999999999999, 0.8), (0.7124999999999999, 0.3999999999999999, 0.8), (0.7312499999999998, 0.3999999999999999, 0.8), (0.7499999999999998, 0.3999999999999999, 0.8), (0.7687499999999998, 0.3999999999999999, 0.8), (0.7874999999999999, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7937499999999997), (0.8, 0.3999999999999999, 0.7749999999999998), (0.8, 0.3999999999999999, 0.7562499999999998), (0.8, 0.3999999999999999, 0.7374999999999998), (0.8, 0.3999999999999999, 0.7187499999999998), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6812499999999997), (0.8, 0.3999999999999999, 0.6624999999999998), (0.8, 0.3999999999999999, 0.6437499999999997), (0.8, 0.3999999999999999, 0.6249999999999998), (0.8, 0.3999999999999999, 0.6062499999999997), (0.8, 0.3999999999999999, 0.5874999999999997), (0.8, 0.3999999999999999, 0.5687499999999996), (0.8, 0.3999999999999999, 0.5499999999999997), (0.8, 0.3999999999999999, 0.5312499999999997), (0.8, 0.3999999999999999, 0.5124999999999997), (0.8, 0.3999999999999999, 0.4937499999999997), (0.8, 0.3999999999999999, 0.47499999999999964), (0.8, 0.3999999999999999, 0.45624999999999966), (0.8, 0.3999999999999999, 0.43749999999999967), (0.8, 0.3999999999999999, 0.4187499999999996)],
    129: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41860465116279066, 0.3999999999999999), (0.8, 0.43720930232558136, 0.3999999999999999), (0.8, 0.4558139534883721, 0.3999999999999999), (0.8, 0.47441860465116287, 0.3999999999999999), (0.8, 0.49302325581395356, 0.3999999999999999), (0.8, 0.5116279069767443, 0.3999999999999999), (0.8, 0.5302325581395351, 0.3999999999999999), (0.8, 0.5488372093023258, 0.3999999999999999), (0.8, 0.567441860465116, 0.3999999999999999), (0.8, 0.5860465116279068, 0.3999999999999999), (0.8, 0.6046511627906975, 0.3999999999999999), (0.8, 0.6232558139534883, 0.3999999999999999), (0.8, 0.6418604651162789, 0.3999999999999999), (0.8, 0.6604651162790697, 0.3999999999999999), (0.8, 0.6790697674418604, 0.3999999999999999), (0.8, 0.6976744186046512, 0.3999999999999999), (0.8, 0.7162790697674419, 0.3999999999999999), (0.8, 0.7348837209302326, 0.3999999999999999), (0.8, 0.7534883720930234, 0.3999999999999999), (0.8, 0.7720930232558141, 0.3999999999999999), (0.8, 0.790697674418605, 0.3999999999999999), (0.7906976744186045, 0.8, 0.3999999999999999), (0.7720930232558144, 0.8, 0.3999999999999999), (0.7534883720930237, 0.8, 0.3999999999999999), (0.7348837209302329, 0.8, 0.3999999999999999), (0.7162790697674422, 0.8, 0.3999999999999999), (0.6976744186046515, 0.8, 0.3999999999999999), (0.6790697674418606, 0.8, 0.3999999999999999), (0.66046511627907, 0.8, 0.3999999999999999), (0.6418604651162793, 0.8, 0.3999999999999999), (0.6232558139534885, 0.8, 0.3999999999999999), (0.6046511627906977, 0.8, 0.3999999999999999), (0.586046511627907, 0.8, 0.3999999999999999), (0.5674418604651162, 0.8, 0.3999999999999999), (0.5488372093023255, 0.8, 0.3999999999999999), (0.5302325581395348, 0.8, 0.3999999999999999), (0.5116279069767441, 0.8, 0.3999999999999999), (0.49302325581395334, 0.8, 0.3999999999999999), (0.4744186046511626, 0.8, 0.3999999999999999), (0.45581395348837184, 0.8, 0.3999999999999999), (0.43720930232558114, 0.8, 0.3999999999999999), (0.4186046511627904, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4186046511627905), (0.3999999999999999, 0.8, 0.43720930232558125), (0.3999999999999999, 0.8, 0.455813953488372), (0.3999999999999999, 0.8, 0.4744186046511627), (0.3999999999999999, 0.8, 0.49302325581395345), (0.3999999999999999, 0.8, 0.5116279069767442), (0.3999999999999999, 0.8, 0.530232558139535), (0.3999999999999999, 0.8, 0.5488372093023257), (0.3999999999999999, 0.8, 0.5674418604651164), (0.3999999999999999, 0.8, 0.5860465116279072), (0.3999999999999999, 0.8, 0.6046511627906973), (0.3999999999999999, 0.8, 0.6232558139534881), (0.3999999999999999, 0.8, 0.6418604651162788), (0.3999999999999999, 0.8, 0.6604651162790696), (0.3999999999999999, 0.8, 0.6790697674418603), (0.3999999999999999, 0.8, 0.6976744186046511), (0.3999999999999999, 0.8, 0.7162790697674417), (0.3999999999999999, 0.8, 0.7348837209302326), (0.3999999999999999, 0.8, 0.7534883720930232), (0.3999999999999999, 0.8, 0.772093023255814), (0.3999999999999999, 0.8, 0.7906976744186047), (0.3999999999999999, 0.7906976744186045, 0.8), (0.3999999999999999, 0.7720930232558139, 0.8), (0.3999999999999999, 0.7534883720930231, 0.8), (0.3999999999999999, 0.7348837209302324, 0.8), (0.3999999999999999, 0.7162790697674417, 0.8), (0.3999999999999999, 0.6976744186046508, 0.8), (0.3999999999999999, 0.6790697674418602, 0.8), (0.3999999999999999, 0.6604651162790695, 0.8), (0.3999999999999999, 0.6418604651162787, 0.8), (0.3999999999999999, 0.623255813953488, 0.8), (0.3999999999999999, 0.6046511627906972, 0.8), (0.3999999999999999, 0.586046511627907, 0.8), (0.3999999999999999, 0.5674418604651162, 0.8), (0.3999999999999999, 0.5488372093023255, 0.8), (0.3999999999999999, 0.5302325581395348, 0.8), (0.3999999999999999, 0.5116279069767441, 0.8), (0.3999999999999999, 0.49302325581395334, 0.8), (0.3999999999999999, 0.4744186046511626, 0.8), (0.3999999999999999, 0.45581395348837184, 0.8), (0.3999999999999999, 0.43720930232558114, 0.8), (0.3999999999999999, 0.4186046511627909, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4186046511627901, 0.3999999999999999, 0.8), (0.43720930232558086, 0.3999999999999999, 0.8), (0.4558139534883716, 0.3999999999999999, 0.8), (0.4744186046511623, 0.3999999999999999, 0.8), (0.49302325581395307, 0.3999999999999999, 0.8), (0.5116279069767438, 0.3999999999999999, 0.8), (0.5302325581395345, 0.3999999999999999, 0.8), (0.5488372093023253, 0.3999999999999999, 0.8), (0.567441860465116, 0.3999999999999999, 0.8), (0.5860465116279068, 0.3999999999999999, 0.8), (0.6046511627906975, 0.3999999999999999, 0.8), (0.6232558139534883, 0.3999999999999999, 0.8), (0.6418604651162789, 0.3999999999999999, 0.8), (0.6604651162790697, 0.3999999999999999, 0.8), (0.6790697674418604, 0.3999999999999999, 0.8), (0.6976744186046512, 0.3999999999999999, 0.8), (0.7162790697674419, 0.3999999999999999, 0.8), (0.7348837209302326, 0.3999999999999999, 0.8), (0.7534883720930234, 0.3999999999999999, 0.8), (0.7720930232558141, 0.3999999999999999, 0.8), (0.790697674418605, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7906976744186045), (0.8, 0.3999999999999999, 0.7720930232558139), (0.8, 0.3999999999999999, 0.7534883720930231), (0.8, 0.3999999999999999, 0.7348837209302324), (0.8, 0.3999999999999999, 0.7162790697674417), (0.8, 0.3999999999999999, 0.6976744186046508), (0.8, 0.3999999999999999, 0.6790697674418602), (0.8, 0.3999999999999999, 0.6604651162790695), (0.8, 0.3999999999999999, 0.6418604651162787), (0.8, 0.3999999999999999, 0.6232558139534885), (0.8, 0.3999999999999999, 0.6046511627906977), (0.8, 0.3999999999999999, 0.586046511627907), (0.8, 0.3999999999999999, 0.5674418604651162), (0.8, 0.3999999999999999, 0.5488372093023255), (0.8, 0.3999999999999999, 0.5302325581395348), (0.8, 0.3999999999999999, 0.5116279069767441), (0.8, 0.3999999999999999, 0.49302325581395334), (0.8, 0.3999999999999999, 0.4744186046511626), (0.8, 0.3999999999999999, 0.45581395348837184), (0.8, 0.3999999999999999, 0.43720930232558114), (0.8, 0.3999999999999999, 0.4186046511627904)],
    130: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41846153846153833, 0.3999999999999999), (0.8, 0.4369230769230767, 0.3999999999999999), (0.8, 0.4553846153846151, 0.3999999999999999), (0.8, 0.47384615384615353, 0.3999999999999999), (0.8, 0.49230769230769245, 0.3999999999999999), (0.8, 0.5107692307692309, 0.3999999999999999), (0.8, 0.5292307692307693, 0.3999999999999999), (0.8, 0.5476923076923077, 0.3999999999999999), (0.8, 0.566153846153846, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.6030769230769228, 0.3999999999999999), (0.8, 0.6215384615384618, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6584615384615387, 0.3999999999999999), (0.8, 0.676923076923077, 0.3999999999999999), (0.8, 0.6953846153846155, 0.3999999999999999), (0.8, 0.7138461538461538, 0.3999999999999999), (0.8, 0.7323076923076922, 0.3999999999999999), (0.8, 0.7507692307692306, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.8, 0.7876923076923079, 0.3999999999999999), (0.7938461538461539, 0.8, 0.3999999999999999), (0.7753846153846153, 0.8, 0.3999999999999999), (0.756923076923077, 0.8, 0.3999999999999999), (0.7384615384615386, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7015384615384619, 0.8, 0.3999999999999999), (0.6830769230769229, 0.8, 0.3999999999999999), (0.6646153846153845, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.6276923076923077, 0.8, 0.3999999999999999), (0.6092307692307692, 0.8, 0.3999999999999999), (0.5907692307692308, 0.8, 0.3999999999999999), (0.5723076923076924, 0.8, 0.3999999999999999), (0.5538461538461541, 0.8, 0.3999999999999999), (0.5353846153846157, 0.8, 0.3999999999999999), (0.5169230769230773, 0.8, 0.3999999999999999), (0.49846153846153834, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.44307692307692315, 0.8, 0.3999999999999999), (0.42461538461538473, 0.8, 0.3999999999999999), (0.40615384615384575, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4123076923076926), (0.3999999999999999, 0.8, 0.43076923076923096), (0.3999999999999999, 0.8, 0.4492307692307694), (0.3999999999999999, 0.8, 0.4676923076923078), (0.3999999999999999, 0.8, 0.48615384615384616), (0.3999999999999999, 0.8, 0.5046153846153846), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.5415384615384614), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5784615384615381), (0.3999999999999999, 0.8, 0.5969230769230771), (0.3999999999999999, 0.8, 0.6153846153846155), (0.3999999999999999, 0.8, 0.633846153846154), (0.3999999999999999, 0.8, 0.6523076923076924), (0.3999999999999999, 0.8, 0.6707692307692308), (0.3999999999999999, 0.8, 0.6892307692307698), (0.3999999999999999, 0.8, 0.7076923076923081), (0.3999999999999999, 0.8, 0.7261538461538465), (0.3999999999999999, 0.8, 0.7446153846153849), (0.3999999999999999, 0.8, 0.7630769230769233), (0.3999999999999999, 0.8, 0.7815384615384617), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7815384615384615, 0.8), (0.3999999999999999, 0.7630769230769232, 0.8), (0.3999999999999999, 0.7446153846153847, 0.8), (0.3999999999999999, 0.7261538461538464, 0.8), (0.3999999999999999, 0.7076923076923074, 0.8), (0.3999999999999999, 0.6892307692307691, 0.8), (0.3999999999999999, 0.6707692307692306, 0.8), (0.3999999999999999, 0.6523076923076923, 0.8), (0.3999999999999999, 0.6338461538461538, 0.8), (0.3999999999999999, 0.6153846153846149, 0.8), (0.3999999999999999, 0.5969230769230764, 0.8), (0.3999999999999999, 0.578461538461538, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5415384615384613, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.5046153846153845, 0.8), (0.3999999999999999, 0.48615384615384605, 0.8), (0.3999999999999999, 0.46769230769230763, 0.8), (0.3999999999999999, 0.44923076923076927, 0.8), (0.3999999999999999, 0.43076923076923085, 0.8), (0.3999999999999999, 0.41230769230769193, 0.8), (0.40615384615384603, 0.3999999999999999, 0.8), (0.42461538461538445, 0.3999999999999999, 0.8), (0.44307692307692287, 0.3999999999999999, 0.8), (0.46153846153846123, 0.3999999999999999, 0.8), (0.4800000000000002, 0.3999999999999999, 0.8), (0.49846153846153857, 0.3999999999999999, 0.8), (0.516923076923077, 0.3999999999999999, 0.8), (0.5353846153846153, 0.3999999999999999, 0.8), (0.5538461538461538, 0.3999999999999999, 0.8), (0.5723076923076922, 0.3999999999999999, 0.8), (0.5907692307692306, 0.3999999999999999, 0.8), (0.609230769230769, 0.3999999999999999, 0.8), (0.6276923076923074, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.6646153846153842, 0.3999999999999999, 0.8), (0.6830769230769231, 0.3999999999999999, 0.8), (0.7015384615384616, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7384615384615383, 0.3999999999999999, 0.8), (0.7569230769230768, 0.3999999999999999, 0.8), (0.7753846153846158, 0.3999999999999999, 0.8), (0.7938461538461541, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7876923076923072), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7507692307692304), (0.8, 0.3999999999999999, 0.7323076923076919), (0.8, 0.3999999999999999, 0.7138461538461536), (0.8, 0.3999999999999999, 0.6953846153846152), (0.8, 0.3999999999999999, 0.6769230769230767), (0.8, 0.3999999999999999, 0.6584615384615383), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.621538461538461), (0.8, 0.3999999999999999, 0.6030769230769226), (0.8, 0.3999999999999999, 0.5846153846153842), (0.8, 0.3999999999999999, 0.5661538461538458), (0.8, 0.3999999999999999, 0.5476923076923074), (0.8, 0.3999999999999999, 0.5292307692307685), (0.8, 0.3999999999999999, 0.5107692307692301), (0.8, 0.3999999999999999, 0.49230769230769167), (0.8, 0.3999999999999999, 0.47384615384615325), (0.8, 0.3999999999999999, 0.45538461538461483), (0.8, 0.3999999999999999, 0.43692307692307647), (0.8, 0.3999999999999999, 0.41846153846153805)],
    131: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4183206106870226, 0.3999999999999999), (0.8, 0.43664122137404576, 0.3999999999999999), (0.8, 0.45496183206106844, 0.3999999999999999), (0.8, 0.47328244274809167, 0.3999999999999999), (0.8, 0.49160305343511435, 0.3999999999999999), (0.8, 0.5099236641221375, 0.3999999999999999), (0.8, 0.5282442748091603, 0.3999999999999999), (0.8, 0.5465648854961834, 0.3999999999999999), (0.8, 0.564885496183206, 0.3999999999999999), (0.8, 0.5832061068702288, 0.3999999999999999), (0.8, 0.601526717557252, 0.3999999999999999), (0.8, 0.6198473282442747, 0.3999999999999999), (0.8, 0.6381679389312979, 0.3999999999999999), (0.8, 0.6564885496183205, 0.3999999999999999), (0.8, 0.6748091603053437, 0.3999999999999999), (0.8, 0.6931297709923664, 0.3999999999999999), (0.8, 0.7114503816793896, 0.3999999999999999), (0.8, 0.7297709923664122, 0.3999999999999999), (0.8, 0.7480916030534349, 0.3999999999999999), (0.8, 0.7664122137404581, 0.3999999999999999), (0.8, 0.7847328244274807, 0.3999999999999999), (0.7969465648854961, 0.8, 0.3999999999999999), (0.7786259541984735, 0.8, 0.3999999999999999), (0.7603053435114503, 0.8, 0.3999999999999999), (0.7419847328244276, 0.8, 0.3999999999999999), (0.7236641221374045, 0.8, 0.3999999999999999), (0.7053435114503818, 0.8, 0.3999999999999999), (0.687022900763359, 0.8, 0.3999999999999999), (0.668702290076336, 0.8, 0.3999999999999999), (0.6503816793893132, 0.8, 0.3999999999999999), (0.6320610687022901, 0.8, 0.3999999999999999), (0.6137404580152673, 0.8, 0.3999999999999999), (0.5954198473282447, 0.8, 0.3999999999999999), (0.5770992366412214, 0.8, 0.3999999999999999), (0.5587786259541982, 0.8, 0.3999999999999999), (0.5404580152671756, 0.8, 0.3999999999999999), (0.5221374045801529, 0.8, 0.3999999999999999), (0.5038167938931297, 0.8, 0.3999999999999999), (0.48549618320610705, 0.8, 0.3999999999999999), (0.4671755725190838, 0.8, 0.3999999999999999), (0.4488549618320612, 0.8, 0.3999999999999999), (0.4305343511450385, 0.8, 0.3999999999999999), (0.4122137404580153, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4061068702290079), (0.3999999999999999, 0.8, 0.42442748091603055), (0.3999999999999999, 0.8, 0.44274809160305323), (0.3999999999999999, 0.8, 0.4610687022900764), (0.3999999999999999, 0.8, 0.4793893129770991), (0.3999999999999999, 0.8, 0.4977099236641223), (0.3999999999999999, 0.8, 0.516030534351145), (0.3999999999999999, 0.8, 0.5343511450381676), (0.3999999999999999, 0.8, 0.5526717557251908), (0.3999999999999999, 0.8, 0.5709923664122141), (0.3999999999999999, 0.8, 0.5893129770992367), (0.3999999999999999, 0.8, 0.6076335877862594), (0.3999999999999999, 0.8, 0.6259541984732826), (0.3999999999999999, 0.8, 0.6442748091603052), (0.3999999999999999, 0.8, 0.6625954198473285), (0.3999999999999999, 0.8, 0.6809160305343511), (0.3999999999999999, 0.8, 0.6992366412213737), (0.3999999999999999, 0.8, 0.717557251908397), (0.3999999999999999, 0.8, 0.7358778625954197), (0.3999999999999999, 0.8, 0.7541984732824429), (0.3999999999999999, 0.8, 0.7725190839694656), (0.3999999999999999, 0.8, 0.7908396946564888), (0.3999999999999999, 0.7908396946564886, 0.8), (0.3999999999999999, 0.7725190839694654, 0.8), (0.3999999999999999, 0.7541984732824427, 0.8), (0.3999999999999999, 0.7358778625954201, 0.8), (0.3999999999999999, 0.7175572519083968, 0.8), (0.3999999999999999, 0.6992366412213737, 0.8), (0.3999999999999999, 0.680916030534351, 0.8), (0.3999999999999999, 0.6625954198473283, 0.8), (0.3999999999999999, 0.6442748091603057, 0.8), (0.3999999999999999, 0.6259541984732825, 0.8), (0.3999999999999999, 0.6076335877862592, 0.8), (0.3999999999999999, 0.5893129770992366, 0.8), (0.3999999999999999, 0.5709923664122138, 0.8), (0.3999999999999999, 0.5526717557251907, 0.8), (0.3999999999999999, 0.5343511450381675, 0.8), (0.3999999999999999, 0.5160305343511449, 0.8), (0.3999999999999999, 0.49770992366412214, 0.8), (0.3999999999999999, 0.47938931297709947, 0.8), (0.3999999999999999, 0.4610687022900763, 0.8), (0.3999999999999999, 0.44274809160305306, 0.8), (0.3999999999999999, 0.4244274809160304, 0.8), (0.3999999999999999, 0.4061068702290077, 0.8), (0.412213740458015, 0.3999999999999999, 0.8), (0.43053435114503824, 0.3999999999999999, 0.8), (0.4488549618320609, 0.3999999999999999, 0.8), (0.4671755725190836, 0.3999999999999999, 0.8), (0.4854961832061062, 0.3999999999999999, 0.8), (0.5038167938931295, 0.3999999999999999, 0.8), (0.5221374045801527, 0.3999999999999999, 0.8), (0.5404580152671753, 0.3999999999999999, 0.8), (0.558778625954198, 0.3999999999999999, 0.8), (0.5770992366412212, 0.3999999999999999, 0.8), (0.5954198473282444, 0.3999999999999999, 0.8), (0.6137404580152671, 0.3999999999999999, 0.8), (0.6320610687022897, 0.3999999999999999, 0.8), (0.6503816793893125, 0.3999999999999999, 0.8), (0.6687022900763356, 0.3999999999999999, 0.8), (0.6870229007633588, 0.3999999999999999, 0.8), (0.7053435114503814, 0.3999999999999999, 0.8), (0.7236641221374042, 0.3999999999999999, 0.8), (0.7419847328244273, 0.3999999999999999, 0.8), (0.76030534351145, 0.3999999999999999, 0.8), (0.7786259541984732, 0.3999999999999999, 0.8), (0.7969465648854959, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7847328244274812), (0.8, 0.3999999999999999, 0.7664122137404579), (0.8, 0.3999999999999999, 0.7480916030534346), (0.8, 0.3999999999999999, 0.729770992366412), (0.8, 0.3999999999999999, 0.7114503816793893), (0.8, 0.3999999999999999, 0.6931297709923661), (0.8, 0.3999999999999999, 0.6748091603053434), (0.8, 0.3999999999999999, 0.6564885496183203), (0.8, 0.3999999999999999, 0.6381679389312975), (0.8, 0.3999999999999999, 0.6198473282442749), (0.8, 0.3999999999999999, 0.6015267175572517), (0.8, 0.3999999999999999, 0.5832061068702286), (0.8, 0.3999999999999999, 0.5648854961832058), (0.8, 0.3999999999999999, 0.5465648854961831), (0.8, 0.3999999999999999, 0.5282442748091605), (0.8, 0.3999999999999999, 0.5099236641221373), (0.8, 0.3999999999999999, 0.49160305343511407), (0.8, 0.3999999999999999, 0.4732824427480914), (0.8, 0.3999999999999999, 0.4549618320610687), (0.8, 0.3999999999999999, 0.43664122137404554), (0.8, 0.3999999999999999, 0.4183206106870223)],
    132: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4181818181818181, 0.3999999999999999), (0.8, 0.43636363636363623, 0.3999999999999999), (0.8, 0.4545454545454544, 0.3999999999999999), (0.8, 0.4727272727272726, 0.3999999999999999), (0.8, 0.49090909090909074, 0.3999999999999999), (0.8, 0.5090909090909089, 0.3999999999999999), (0.8, 0.5272727272727271, 0.3999999999999999), (0.8, 0.5454545454545453, 0.3999999999999999), (0.8, 0.5636363636363635, 0.3999999999999999), (0.8, 0.5818181818181816, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6363636363636361, 0.3999999999999999), (0.8, 0.6545454545454543, 0.3999999999999999), (0.8, 0.6727272727272731, 0.3999999999999999), (0.8, 0.6909090909090907, 0.3999999999999999), (0.8, 0.7090909090909094, 0.3999999999999999), (0.8, 0.7272727272727271, 0.3999999999999999), (0.8, 0.7454545454545457, 0.3999999999999999), (0.8, 0.7636363636363639, 0.3999999999999999), (0.8, 0.781818181818182, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7818181818181817, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7454545454545454, 0.8, 0.3999999999999999), (0.7272727272727273, 0.8, 0.3999999999999999), (0.7090909090909091, 0.8, 0.3999999999999999), (0.6909090909090909, 0.8, 0.3999999999999999), (0.6727272727272728, 0.8, 0.3999999999999999), (0.6545454545454545, 0.8, 0.3999999999999999), (0.6363636363636365, 0.8, 0.3999999999999999), (0.6181818181818183, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5818181818181819, 0.8, 0.3999999999999999), (0.5636363636363637, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5272727272727273, 0.8, 0.3999999999999999), (0.5090909090909093, 0.8, 0.3999999999999999), (0.4909090909090911, 0.8, 0.3999999999999999), (0.4727272727272729, 0.8, 0.3999999999999999), (0.4545454545454547, 0.8, 0.3999999999999999), (0.4363636363636365, 0.8, 0.3999999999999999), (0.4181818181818183, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.41818181818181793), (0.3999999999999999, 0.8, 0.4363636363636367), (0.3999999999999999, 0.8, 0.4545454545454543), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.49090909090909063), (0.3999999999999999, 0.8, 0.5090909090909094), (0.3999999999999999, 0.8, 0.527272727272727), (0.3999999999999999, 0.8, 0.5454545454545456), (0.3999999999999999, 0.8, 0.5636363636363638), (0.3999999999999999, 0.8, 0.581818181818182), (0.3999999999999999, 0.8, 0.6000000000000002), (0.3999999999999999, 0.8, 0.6181818181818184), (0.3999999999999999, 0.8, 0.6363636363636366), (0.3999999999999999, 0.8, 0.6545454545454548), (0.3999999999999999, 0.8, 0.6727272727272728), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7090909090909092), (0.3999999999999999, 0.8, 0.7272727272727274), (0.3999999999999999, 0.8, 0.7454545454545456), (0.3999999999999999, 0.8, 0.7636363636363638), (0.3999999999999999, 0.8, 0.781818181818182), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7818181818181817, 0.8), (0.3999999999999999, 0.7636363636363637, 0.8), (0.3999999999999999, 0.7454545454545454, 0.8), (0.3999999999999999, 0.7272727272727273, 0.8), (0.3999999999999999, 0.7090909090909091, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6727272727272722, 0.8), (0.3999999999999999, 0.6545454545454545, 0.8), (0.3999999999999999, 0.6363636363636359, 0.8), (0.3999999999999999, 0.6181818181818183, 0.8), (0.3999999999999999, 0.5999999999999995, 0.8), (0.3999999999999999, 0.5818181818181819, 0.8), (0.3999999999999999, 0.5636363636363632, 0.8), (0.3999999999999999, 0.5454545454545455, 0.8), (0.3999999999999999, 0.5272727272727269, 0.8), (0.3999999999999999, 0.5090909090909093, 0.8), (0.3999999999999999, 0.4909090909090905, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.45454545454545414, 0.8), (0.3999999999999999, 0.4363636363636365, 0.8), (0.3999999999999999, 0.4181818181818178, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.4181818181818181, 0.3999999999999999, 0.8), (0.43636363636363623, 0.3999999999999999, 0.8), (0.4545454545454544, 0.3999999999999999, 0.8), (0.4727272727272726, 0.3999999999999999, 0.8), (0.49090909090909074, 0.3999999999999999, 0.8), (0.5090909090909089, 0.3999999999999999, 0.8), (0.5272727272727271, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5636363636363635, 0.3999999999999999, 0.8), (0.5818181818181816, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6181818181818179, 0.3999999999999999, 0.8), (0.6363636363636361, 0.3999999999999999, 0.8), (0.6545454545454543, 0.3999999999999999, 0.8), (0.6727272727272725, 0.3999999999999999, 0.8), (0.6909090909090907, 0.3999999999999999, 0.8), (0.7090909090909088, 0.3999999999999999, 0.8), (0.7272727272727275, 0.3999999999999999, 0.8), (0.7454545454545451, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.7818181818181815, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7818181818181817), (0.8, 0.3999999999999999, 0.7636363636363631), (0.8, 0.3999999999999999, 0.7454545454545454), (0.8, 0.3999999999999999, 0.7272727272727267), (0.8, 0.3999999999999999, 0.7090909090909091), (0.8, 0.3999999999999999, 0.6909090909090905), (0.8, 0.3999999999999999, 0.6727272727272728), (0.8, 0.3999999999999999, 0.6545454545454541), (0.8, 0.3999999999999999, 0.6363636363636365), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.5999999999999995), (0.8, 0.3999999999999999, 0.5818181818181813), (0.8, 0.3999999999999999, 0.5636363636363632), (0.8, 0.3999999999999999, 0.545454545454545), (0.8, 0.3999999999999999, 0.5272727272727269), (0.8, 0.3999999999999999, 0.5090909090909087), (0.8, 0.3999999999999999, 0.4909090909090905), (0.8, 0.3999999999999999, 0.47272727272727233), (0.8, 0.3999999999999999, 0.45454545454545414), (0.8, 0.3999999999999999, 0.436363636363636), (0.8, 0.3999999999999999, 0.4181818181818178)],
    133: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41804511278195494, 0.3999999999999999), (0.8, 0.43609022556391, 0.3999999999999999), (0.8, 0.45413533834586445, 0.3999999999999999), (0.8, 0.4721804511278195, 0.3999999999999999), (0.8, 0.4902255639097745, 0.3999999999999999), (0.8, 0.508270676691729, 0.3999999999999999), (0.8, 0.5263157894736841, 0.3999999999999999), (0.8, 0.544360902255639, 0.3999999999999999), (0.8, 0.562406015037594, 0.3999999999999999), (0.8, 0.5804511278195491, 0.3999999999999999), (0.8, 0.5984962406015036, 0.3999999999999999), (0.8, 0.6165413533834586, 0.3999999999999999), (0.8, 0.6345864661654137, 0.3999999999999999), (0.8, 0.6526315789473681, 0.3999999999999999), (0.8, 0.6706766917293232, 0.3999999999999999), (0.8, 0.6887218045112782, 0.3999999999999999), (0.8, 0.7067669172932332, 0.3999999999999999), (0.8, 0.7248120300751882, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7609022556390977, 0.3999999999999999), (0.8, 0.7789473684210528, 0.3999999999999999), (0.8, 0.7969924812030074, 0.3999999999999999), (0.784962406015038, 0.8, 0.3999999999999999), (0.7669172932330829, 0.8, 0.3999999999999999), (0.7488721804511278, 0.8, 0.3999999999999999), (0.7308270676691728, 0.8, 0.3999999999999999), (0.7127819548872183, 0.8, 0.3999999999999999), (0.6947368421052633, 0.8, 0.3999999999999999), (0.6766917293233083, 0.8, 0.3999999999999999), (0.6586466165413538, 0.8, 0.3999999999999999), (0.6406015037593987, 0.8, 0.3999999999999999), (0.6225563909774438, 0.8, 0.3999999999999999), (0.6045112781954887, 0.8, 0.3999999999999999), (0.5864661654135337, 0.8, 0.3999999999999999), (0.5684210526315792, 0.8, 0.3999999999999999), (0.5503759398496242, 0.8, 0.3999999999999999), (0.5323308270676691, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.4962406015037596, 0.8, 0.3999999999999999), (0.47819548872180456, 0.8, 0.3999999999999999), (0.46015037593984953, 0.8, 0.3999999999999999), (0.4421052631578945, 0.8, 0.3999999999999999), (0.42406015037594, 0.8, 0.3999999999999999), (0.406015037593985, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41203007518796997), (0.3999999999999999, 0.8, 0.43007518796992444), (0.3999999999999999, 0.8, 0.4481203007518795), (0.3999999999999999, 0.8, 0.4661654135338345), (0.3999999999999999, 0.8, 0.48421052631578954), (0.3999999999999999, 0.8, 0.5022556390977446), (0.3999999999999999, 0.8, 0.520300751879699), (0.3999999999999999, 0.8, 0.5383458646616541), (0.3999999999999999, 0.8, 0.5563909774436091), (0.3999999999999999, 0.8, 0.5744360902255636), (0.3999999999999999, 0.8, 0.5924812030075186), (0.3999999999999999, 0.8, 0.6105263157894737), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6466165413533838), (0.3999999999999999, 0.8, 0.6646616541353383), (0.3999999999999999, 0.8, 0.6827067669172933), (0.3999999999999999, 0.8, 0.7007518796992482), (0.3999999999999999, 0.8, 0.7187969924812028), (0.3999999999999999, 0.8, 0.7368421052631577), (0.3999999999999999, 0.8, 0.7548872180451127), (0.3999999999999999, 0.8, 0.7729323308270678), (0.3999999999999999, 0.8, 0.7909774436090229), (0.3999999999999999, 0.7909774436090227, 0.8), (0.3999999999999999, 0.7729323308270677, 0.8), (0.3999999999999999, 0.7548872180451127, 0.8), (0.3999999999999999, 0.7368421052631582, 0.8), (0.3999999999999999, 0.7187969924812032, 0.8), (0.3999999999999999, 0.7007518796992481, 0.8), (0.3999999999999999, 0.682706766917293, 0.8), (0.3999999999999999, 0.6646616541353381, 0.8), (0.3999999999999999, 0.6466165413533835, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6105263157894735, 0.8), (0.3999999999999999, 0.592481203007519, 0.8), (0.3999999999999999, 0.574436090225564, 0.8), (0.3999999999999999, 0.556390977443609, 0.8), (0.3999999999999999, 0.5383458646616539, 0.8), (0.3999999999999999, 0.5203007518796989, 0.8), (0.3999999999999999, 0.5022556390977444, 0.8), (0.3999999999999999, 0.4842105263157894, 0.8), (0.3999999999999999, 0.4661654135338344, 0.8), (0.3999999999999999, 0.4481203007518799, 0.8), (0.3999999999999999, 0.4300751879699249, 0.8), (0.3999999999999999, 0.41203007518796986, 0.8), (0.4060150375939847, 0.3999999999999999, 0.8), (0.42406015037593975, 0.3999999999999999, 0.8), (0.4421052631578943, 0.3999999999999999, 0.8), (0.4601503759398493, 0.3999999999999999, 0.8), (0.4781954887218043, 0.3999999999999999, 0.8), (0.4962406015037588, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5323308270676689, 0.3999999999999999, 0.8), (0.5503759398496239, 0.3999999999999999, 0.8), (0.5684210526315789, 0.3999999999999999, 0.8), (0.5864661654135335, 0.3999999999999999, 0.8), (0.6045112781954884, 0.3999999999999999, 0.8), (0.6225563909774434, 0.3999999999999999, 0.8), (0.640601503759398, 0.3999999999999999, 0.8), (0.6586466165413529, 0.3999999999999999, 0.8), (0.676691729323308, 0.3999999999999999, 0.8), (0.6947368421052631, 0.3999999999999999, 0.8), (0.7127819548872181, 0.3999999999999999, 0.8), (0.7308270676691726, 0.3999999999999999, 0.8), (0.7488721804511276, 0.3999999999999999, 0.8), (0.7669172932330826, 0.3999999999999999, 0.8), (0.7849624060150371, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7969924812030076), (0.8, 0.3999999999999999, 0.7789473684210526), (0.8, 0.3999999999999999, 0.7609022556390974), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7248120300751879), (0.8, 0.3999999999999999, 0.7067669172932329), (0.8, 0.3999999999999999, 0.688721804511278), (0.8, 0.3999999999999999, 0.6706766917293234), (0.8, 0.3999999999999999, 0.6526315789473685), (0.8, 0.3999999999999999, 0.6345864661654134), (0.8, 0.3999999999999999, 0.6165413533834584), (0.8, 0.3999999999999999, 0.5984962406015033), (0.8, 0.3999999999999999, 0.5804511278195488), (0.8, 0.3999999999999999, 0.5624060150375938), (0.8, 0.3999999999999999, 0.5443609022556388), (0.8, 0.3999999999999999, 0.5263157894736843), (0.8, 0.3999999999999999, 0.5082706766917293), (0.8, 0.3999999999999999, 0.49022556390977423), (0.8, 0.3999999999999999, 0.4721804511278192), (0.8, 0.3999999999999999, 0.45413533834586417), (0.8, 0.3999999999999999, 0.4360902255639097), (0.8, 0.3999999999999999, 0.41804511278195466)],
    134: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41791044776119374, 0.3999999999999999), (0.8, 0.43582089552238806, 0.3999999999999999), (0.8, 0.4537313432835819, 0.3999999999999999), (0.8, 0.47164179104477627, 0.3999999999999999), (0.8, 0.4895522388059701, 0.3999999999999999), (0.8, 0.5074626865671639, 0.3999999999999999), (0.8, 0.5253731343283583, 0.3999999999999999), (0.8, 0.5432835820895521, 0.3999999999999999), (0.8, 0.5611940298507464, 0.3999999999999999), (0.8, 0.5791044776119403, 0.3999999999999999), (0.8, 0.597014925373134, 0.3999999999999999), (0.8, 0.6149253731343285, 0.3999999999999999), (0.8, 0.6328358208955223, 0.3999999999999999), (0.8, 0.6507462686567166, 0.3999999999999999), (0.8, 0.6686567164179105, 0.3999999999999999), (0.8, 0.6865671641791042, 0.3999999999999999), (0.8, 0.7044776119402987, 0.3999999999999999), (0.8, 0.7223880597014924, 0.3999999999999999), (0.8, 0.7402985074626868, 0.3999999999999999), (0.8, 0.7582089552238807, 0.3999999999999999), (0.8, 0.7761194029850749, 0.3999999999999999), (0.8, 0.7940298507462689, 0.3999999999999999), (0.7880597014925377, 0.8, 0.3999999999999999), (0.7701492537313432, 0.8, 0.3999999999999999), (0.7522388059701495, 0.8, 0.3999999999999999), (0.7343283582089556, 0.8, 0.3999999999999999), (0.7164179104477613, 0.8, 0.3999999999999999), (0.6985074626865675, 0.8, 0.3999999999999999), (0.6805970149253731, 0.8, 0.3999999999999999), (0.6626865671641793, 0.8, 0.3999999999999999), (0.6447761194029848, 0.8, 0.3999999999999999), (0.6268656716417911, 0.8, 0.3999999999999999), (0.6089552238805972, 0.8, 0.3999999999999999), (0.5910447761194029, 0.8, 0.3999999999999999), (0.5731343283582091, 0.8, 0.3999999999999999), (0.5552238805970152, 0.8, 0.3999999999999999), (0.5373134328358209, 0.8, 0.3999999999999999), (0.5194029850746271, 0.8, 0.3999999999999999), (0.5014925373134327, 0.8, 0.3999999999999999), (0.4835820895522389, 0.8, 0.3999999999999999), (0.46567164179104453, 0.8, 0.3999999999999999), (0.4477611940298507, 0.8, 0.3999999999999999), (0.4298507462686569, 0.8, 0.3999999999999999), (0.41194029850746255, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4059701492537312), (0.3999999999999999, 0.8, 0.42388059701492503), (0.3999999999999999, 0.8, 0.4417910447761194), (0.3999999999999999, 0.8, 0.45970149253731324), (0.3999999999999999, 0.8, 0.47761194029850756), (0.3999999999999999, 0.8, 0.4955223880597014), (0.3999999999999999, 0.8, 0.5134328358208957), (0.3999999999999999, 0.8, 0.5313432835820896), (0.3999999999999999, 0.8, 0.5492537313432834), (0.3999999999999999, 0.8, 0.5671641791044777), (0.3999999999999999, 0.8, 0.5850746268656716), (0.3999999999999999, 0.8, 0.6029850746268653), (0.3999999999999999, 0.8, 0.6208955223880598), (0.3999999999999999, 0.8, 0.6388059701492536), (0.3999999999999999, 0.8, 0.6567164179104479), (0.3999999999999999, 0.8, 0.6746268656716418), (0.3999999999999999, 0.8, 0.6925373134328361), (0.3999999999999999, 0.8, 0.7104477611940299), (0.3999999999999999, 0.8, 0.7283582089552237), (0.3999999999999999, 0.8, 0.7462686567164181), (0.3999999999999999, 0.8, 0.764179104477612), (0.3999999999999999, 0.8, 0.7820895522388058), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7820895522388056, 0.8), (0.3999999999999999, 0.7641791044776118, 0.8), (0.3999999999999999, 0.746268656716418, 0.8), (0.3999999999999999, 0.7283582089552236, 0.8), (0.3999999999999999, 0.7104477611940299, 0.8), (0.3999999999999999, 0.692537313432836, 0.8), (0.3999999999999999, 0.6746268656716417, 0.8), (0.3999999999999999, 0.6567164179104478, 0.8), (0.3999999999999999, 0.638805970149254, 0.8), (0.3999999999999999, 0.6208955223880597, 0.8), (0.3999999999999999, 0.6029850746268652, 0.8), (0.3999999999999999, 0.5850746268656715, 0.8), (0.3999999999999999, 0.5671641791044776, 0.8), (0.3999999999999999, 0.5492537313432833, 0.8), (0.3999999999999999, 0.5313432835820895, 0.8), (0.3999999999999999, 0.5134328358208956, 0.8), (0.3999999999999999, 0.4955223880597013, 0.8), (0.3999999999999999, 0.47761194029850745, 0.8), (0.3999999999999999, 0.4597014925373136, 0.8), (0.3999999999999999, 0.44179104477611925, 0.8), (0.3999999999999999, 0.4238805970149249, 0.8), (0.3999999999999999, 0.4059701492537311, 0.8), (0.4119402985074623, 0.3999999999999999, 0.8), (0.42985074626865666, 0.3999999999999999, 0.8), (0.4477611940298505, 0.3999999999999999, 0.8), (0.46567164179104426, 0.3999999999999999, 0.8), (0.48358208955223864, 0.3999999999999999, 0.8), (0.5014925373134325, 0.3999999999999999, 0.8), (0.5194029850746262, 0.3999999999999999, 0.8), (0.5373134328358207, 0.3999999999999999, 0.8), (0.555223880597015, 0.3999999999999999, 0.8), (0.5731343283582088, 0.3999999999999999, 0.8), (0.5910447761194026, 0.3999999999999999, 0.8), (0.608955223880597, 0.3999999999999999, 0.8), (0.6268656716417909, 0.3999999999999999, 0.8), (0.6447761194029846, 0.3999999999999999, 0.8), (0.6626865671641791, 0.3999999999999999, 0.8), (0.6805970149253728, 0.3999999999999999, 0.8), (0.6985074626865666, 0.3999999999999999, 0.8), (0.716417910447761, 0.3999999999999999, 0.8), (0.7343283582089553, 0.3999999999999999, 0.8), (0.7522388059701491, 0.3999999999999999, 0.8), (0.770149253731343, 0.3999999999999999, 0.8), (0.7880597014925372, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7940298507462684), (0.8, 0.3999999999999999, 0.7761194029850746), (0.8, 0.3999999999999999, 0.7582089552238803), (0.8, 0.3999999999999999, 0.740298507462686), (0.8, 0.3999999999999999, 0.7223880597014927), (0.8, 0.3999999999999999, 0.7044776119402983), (0.8, 0.3999999999999999, 0.686567164179104), (0.8, 0.3999999999999999, 0.6686567164179102), (0.8, 0.3999999999999999, 0.6507462686567164), (0.8, 0.3999999999999999, 0.632835820895522), (0.8, 0.3999999999999999, 0.6149253731343282), (0.8, 0.3999999999999999, 0.5970149253731344), (0.8, 0.3999999999999999, 0.57910447761194), (0.8, 0.3999999999999999, 0.5611940298507456), (0.8, 0.3999999999999999, 0.5432835820895523), (0.8, 0.3999999999999999, 0.525373134328358), (0.8, 0.3999999999999999, 0.5074626865671636), (0.8, 0.3999999999999999, 0.4895522388059698), (0.8, 0.3999999999999999, 0.471641791044776), (0.8, 0.3999999999999999, 0.45373134328358167), (0.8, 0.3999999999999999, 0.43582089552238784), (0.8, 0.3999999999999999, 0.417910447761194)],
    135: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41777777777777747, 0.3999999999999999), (0.8, 0.43555555555555553, 0.3999999999999999), (0.8, 0.4533333333333331, 0.3999999999999999), (0.8, 0.47111111111111115, 0.3999999999999999), (0.8, 0.4888888888888887, 0.3999999999999999), (0.8, 0.5066666666666668, 0.3999999999999999), (0.8, 0.5244444444444443, 0.3999999999999999), (0.8, 0.5422222222222224, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.5777777777777775, 0.3999999999999999), (0.8, 0.5955555555555555, 0.3999999999999999), (0.8, 0.6133333333333331, 0.3999999999999999), (0.8, 0.6311111111111112, 0.3999999999999999), (0.8, 0.6488888888888887, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6844444444444444, 0.3999999999999999), (0.8, 0.7022222222222224, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.8, 0.7377777777777781, 0.3999999999999999), (0.8, 0.7555555555555555, 0.3999999999999999), (0.8, 0.7733333333333331, 0.3999999999999999), (0.8, 0.7911111111111111, 0.3999999999999999), (0.7911111111111115, 0.8, 0.3999999999999999), (0.7733333333333334, 0.8, 0.3999999999999999), (0.7555555555555558, 0.8, 0.3999999999999999), (0.7377777777777778, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7022222222222221, 0.8, 0.3999999999999999), (0.6844444444444446, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.648888888888889, 0.8, 0.3999999999999999), (0.6311111111111114, 0.8, 0.3999999999999999), (0.6133333333333334, 0.8, 0.3999999999999999), (0.5955555555555553, 0.8, 0.3999999999999999), (0.5777777777777777, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.5422222222222222, 0.8, 0.3999999999999999), (0.5244444444444446, 0.8, 0.3999999999999999), (0.5066666666666665, 0.8, 0.3999999999999999), (0.48888888888888893, 0.8, 0.3999999999999999), (0.47111111111111087, 0.8, 0.3999999999999999), (0.45333333333333337, 0.8, 0.3999999999999999), (0.4355555555555558, 0.8, 0.3999999999999999), (0.4177777777777777, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.41777777777777786), (0.3999999999999999, 0.8, 0.4355555555555554), (0.3999999999999999, 0.8, 0.4533333333333335), (0.3999999999999999, 0.8, 0.47111111111111104), (0.3999999999999999, 0.8, 0.4888888888888891), (0.3999999999999999, 0.8, 0.5066666666666666), (0.3999999999999999, 0.8, 0.5244444444444447), (0.3999999999999999, 0.8, 0.5422222222222223), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5777777777777778), (0.3999999999999999, 0.8, 0.595555555555556), (0.3999999999999999, 0.8, 0.6133333333333335), (0.3999999999999999, 0.8, 0.6311111111111111), (0.3999999999999999, 0.8, 0.6488888888888891), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6844444444444447), (0.3999999999999999, 0.8, 0.7022222222222223), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.8, 0.7377777777777779), (0.3999999999999999, 0.8, 0.7555555555555554), (0.3999999999999999, 0.8, 0.7733333333333335), (0.3999999999999999, 0.8, 0.7911111111111111), (0.3999999999999999, 0.7911111111111109, 0.8), (0.3999999999999999, 0.7733333333333334, 0.8), (0.3999999999999999, 0.7555555555555553, 0.8), (0.3999999999999999, 0.7377777777777778, 0.8), (0.3999999999999999, 0.7200000000000002, 0.8), (0.3999999999999999, 0.7022222222222221, 0.8), (0.3999999999999999, 0.6844444444444441, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.648888888888889, 0.8), (0.3999999999999999, 0.631111111111111, 0.8), (0.3999999999999999, 0.6133333333333328, 0.8), (0.3999999999999999, 0.5955555555555553, 0.8), (0.3999999999999999, 0.5777777777777777, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5422222222222222, 0.8), (0.3999999999999999, 0.5244444444444446, 0.8), (0.3999999999999999, 0.5066666666666665, 0.8), (0.3999999999999999, 0.48888888888888843, 0.8), (0.3999999999999999, 0.47111111111111087, 0.8), (0.3999999999999999, 0.45333333333333337, 0.8), (0.3999999999999999, 0.43555555555555525, 0.8), (0.3999999999999999, 0.4177777777777772, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.41777777777777747, 0.3999999999999999, 0.8), (0.43555555555555553, 0.3999999999999999, 0.8), (0.4533333333333331, 0.3999999999999999, 0.8), (0.4711111111111106, 0.3999999999999999, 0.8), (0.4888888888888887, 0.3999999999999999, 0.8), (0.5066666666666668, 0.3999999999999999, 0.8), (0.5244444444444443, 0.3999999999999999, 0.8), (0.5422222222222218, 0.3999999999999999, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.577777777777778, 0.3999999999999999, 0.8), (0.5955555555555555, 0.3999999999999999, 0.8), (0.6133333333333331, 0.3999999999999999, 0.8), (0.6311111111111112, 0.3999999999999999, 0.8), (0.6488888888888887, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6844444444444444, 0.3999999999999999, 0.8), (0.7022222222222224, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7377777777777774, 0.3999999999999999, 0.8), (0.7555555555555555, 0.3999999999999999, 0.8), (0.7733333333333337, 0.3999999999999999, 0.8), (0.7911111111111111, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7911111111111109), (0.8, 0.3999999999999999, 0.7733333333333329), (0.8, 0.3999999999999999, 0.7555555555555553), (0.8, 0.3999999999999999, 0.7377777777777778), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.7022222222222216), (0.8, 0.3999999999999999, 0.6844444444444441), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6488888888888884), (0.8, 0.3999999999999999, 0.6311111111111104), (0.8, 0.3999999999999999, 0.6133333333333334), (0.8, 0.3999999999999999, 0.5955555555555553), (0.8, 0.3999999999999999, 0.5777777777777772), (0.8, 0.3999999999999999, 0.5599999999999996), (0.8, 0.3999999999999999, 0.5422222222222222), (0.8, 0.3999999999999999, 0.524444444444444), (0.8, 0.3999999999999999, 0.5066666666666659), (0.8, 0.3999999999999999, 0.48888888888888843), (0.8, 0.3999999999999999, 0.47111111111111087), (0.8, 0.3999999999999999, 0.4533333333333328), (0.8, 0.3999999999999999, 0.43555555555555475), (0.8, 0.3999999999999999, 0.4177777777777777)],
    136: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41764705882352926, 0.3999999999999999), (0.8, 0.4352941176470586, 0.3999999999999999), (0.8, 0.45294117647058796, 0.3999999999999999), (0.8, 0.4705882352941173, 0.3999999999999999), (0.8, 0.4882352941176472, 0.3999999999999999), (0.8, 0.5058823529411766, 0.3999999999999999), (0.8, 0.5235294117647059, 0.3999999999999999), (0.8, 0.5411764705882353, 0.3999999999999999), (0.8, 0.5588235294117646, 0.3999999999999999), (0.8, 0.576470588235294, 0.3999999999999999), (0.8, 0.5941176470588233, 0.3999999999999999), (0.8, 0.6117647058823527, 0.3999999999999999), (0.8, 0.6294117647058826, 0.3999999999999999), (0.8, 0.6470588235294119, 0.3999999999999999), (0.8, 0.6647058823529413, 0.3999999999999999), (0.8, 0.6823529411764706, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7176470588235293, 0.3999999999999999), (0.8, 0.7352941176470587, 0.3999999999999999), (0.8, 0.752941176470588, 0.3999999999999999), (0.8, 0.7705882352941175, 0.3999999999999999), (0.8, 0.7882352941176474, 0.3999999999999999), (0.7941176470588236, 0.8, 0.3999999999999999), (0.7764705882352942, 0.8, 0.3999999999999999), (0.7588235294117648, 0.8, 0.3999999999999999), (0.7411764705882354, 0.8, 0.3999999999999999), (0.7235294117647061, 0.8, 0.3999999999999999), (0.7058823529411767, 0.8, 0.3999999999999999), (0.6882352941176474, 0.8, 0.3999999999999999), (0.6705882352941175, 0.8, 0.3999999999999999), (0.6529411764705881, 0.8, 0.3999999999999999), (0.6352941176470588, 0.8, 0.3999999999999999), (0.6176470588235294, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5823529411764707, 0.8, 0.3999999999999999), (0.5647058823529414, 0.8, 0.3999999999999999), (0.547058823529412, 0.8, 0.3999999999999999), (0.5294117647058827, 0.8, 0.3999999999999999), (0.5117647058823533, 0.8, 0.3999999999999999), (0.4941176470588234, 0.8, 0.3999999999999999), (0.47647058823529403, 0.8, 0.3999999999999999), (0.4588235294117647, 0.8, 0.3999999999999999), (0.44117647058823534, 0.8, 0.3999999999999999), (0.423529411764706, 0.8, 0.3999999999999999), (0.40588235294117664, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4117647058823532), (0.3999999999999999, 0.8, 0.42941176470588255), (0.3999999999999999, 0.8, 0.44705882352941195), (0.3999999999999999, 0.8, 0.4647058823529413), (0.3999999999999999, 0.8, 0.48235294117647065), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5176470588235293), (0.3999999999999999, 0.8, 0.5352941176470587), (0.3999999999999999, 0.8, 0.552941176470588), (0.3999999999999999, 0.8, 0.5705882352941174), (0.3999999999999999, 0.8, 0.5882352941176467), (0.3999999999999999, 0.8, 0.6058823529411766), (0.3999999999999999, 0.8, 0.623529411764706), (0.3999999999999999, 0.8, 0.6411764705882353), (0.3999999999999999, 0.8, 0.6588235294117647), (0.3999999999999999, 0.8, 0.6764705882352942), (0.3999999999999999, 0.8, 0.6941176470588235), (0.3999999999999999, 0.8, 0.7117647058823533), (0.3999999999999999, 0.8, 0.7294117647058826), (0.3999999999999999, 0.8, 0.747058823529412), (0.3999999999999999, 0.8, 0.7647058823529413), (0.3999999999999999, 0.8, 0.7823529411764707), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7823529411764707, 0.8), (0.3999999999999999, 0.7647058823529412, 0.8), (0.3999999999999999, 0.7470588235294119, 0.8), (0.3999999999999999, 0.7294117647058825, 0.8), (0.3999999999999999, 0.7117647058823532, 0.8), (0.3999999999999999, 0.6941176470588238, 0.8), (0.3999999999999999, 0.6764705882352939, 0.8), (0.3999999999999999, 0.6588235294117646, 0.8), (0.3999999999999999, 0.6411764705882352, 0.8), (0.3999999999999999, 0.6235294117647059, 0.8), (0.3999999999999999, 0.605882352941176, 0.8), (0.3999999999999999, 0.5882352941176466, 0.8), (0.3999999999999999, 0.5705882352941173, 0.8), (0.3999999999999999, 0.5529411764705879, 0.8), (0.3999999999999999, 0.5352941176470586, 0.8), (0.3999999999999999, 0.5176470588235292, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4823529411764705, 0.8), (0.3999999999999999, 0.46470588235294114, 0.8), (0.3999999999999999, 0.4470588235294118, 0.8), (0.3999999999999999, 0.42941176470588244, 0.8), (0.3999999999999999, 0.4117647058823531, 0.8), (0.4058823529411758, 0.3999999999999999, 0.8), (0.4235294117647057, 0.3999999999999999, 0.8), (0.44117647058823506, 0.3999999999999999, 0.8), (0.4588235294117644, 0.3999999999999999, 0.8), (0.47647058823529376, 0.3999999999999999, 0.8), (0.49411764705882316, 0.3999999999999999, 0.8), (0.511764705882353, 0.3999999999999999, 0.8), (0.5294117647058824, 0.3999999999999999, 0.8), (0.5470588235294117, 0.3999999999999999, 0.8), (0.5647058823529411, 0.3999999999999999, 0.8), (0.5823529411764705, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6176470588235292, 0.3999999999999999, 0.8), (0.6352941176470586, 0.3999999999999999, 0.8), (0.6529411764705879, 0.3999999999999999, 0.8), (0.6705882352941173, 0.3999999999999999, 0.8), (0.6882352941176466, 0.3999999999999999, 0.8), (0.705882352941176, 0.3999999999999999, 0.8), (0.7235294117647058, 0.3999999999999999, 0.8), (0.7411764705882351, 0.3999999999999999, 0.8), (0.7588235294117645, 0.3999999999999999, 0.8), (0.7764705882352938, 0.3999999999999999, 0.8), (0.7941176470588232, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7882352941176465), (0.8, 0.3999999999999999, 0.7705882352941171), (0.8, 0.3999999999999999, 0.7529411764705878), (0.8, 0.3999999999999999, 0.7352941176470584), (0.8, 0.3999999999999999, 0.7176470588235291), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6823529411764704), (0.8, 0.3999999999999999, 0.664705882352941), (0.8, 0.3999999999999999, 0.6470588235294117), (0.8, 0.3999999999999999, 0.6294117647058823), (0.8, 0.3999999999999999, 0.611764705882353), (0.8, 0.3999999999999999, 0.5941176470588236), (0.8, 0.3999999999999999, 0.5764705882352937), (0.8, 0.3999999999999999, 0.5588235294117644), (0.8, 0.3999999999999999, 0.541176470588235), (0.8, 0.3999999999999999, 0.5235294117647057), (0.8, 0.3999999999999999, 0.5058823529411763), (0.8, 0.3999999999999999, 0.48823529411764643), (0.8, 0.3999999999999999, 0.4705882352941171), (0.8, 0.3999999999999999, 0.45294117647058774), (0.8, 0.3999999999999999, 0.43529411764705833), (0.8, 0.3999999999999999, 0.417647058823529)],
    137: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4175182481751826, 0.3999999999999999), (0.8, 0.43503649635036484, 0.3999999999999999), (0.8, 0.45255474452554756, 0.3999999999999999), (0.8, 0.4700729927007298, 0.3999999999999999), (0.8, 0.4875912408759125, 0.3999999999999999), (0.8, 0.5051094890510948, 0.3999999999999999), (0.8, 0.5226277372262774, 0.3999999999999999), (0.8, 0.5401459854014596, 0.3999999999999999), (0.8, 0.5576642335766424, 0.3999999999999999), (0.8, 0.5751824817518245, 0.3999999999999999), (0.8, 0.5927007299270073, 0.3999999999999999), (0.8, 0.6102189781021895, 0.3999999999999999), (0.8, 0.6277372262773723, 0.3999999999999999), (0.8, 0.6452554744525549, 0.3999999999999999), (0.8, 0.6627737226277373, 0.3999999999999999), (0.8, 0.6802919708029199, 0.3999999999999999), (0.8, 0.6978102189781021, 0.3999999999999999), (0.8, 0.7153284671532849, 0.3999999999999999), (0.8, 0.732846715328467, 0.3999999999999999), (0.8, 0.7503649635036498, 0.3999999999999999), (0.8, 0.767883211678832, 0.3999999999999999), (0.8, 0.7854014598540147, 0.3999999999999999), (0.7970802919708033, 0.8, 0.3999999999999999), (0.7795620437956206, 0.8, 0.3999999999999999), (0.7620437956204378, 0.8, 0.3999999999999999), (0.7445255474452557, 0.8, 0.3999999999999999), (0.7270072992700733, 0.8, 0.3999999999999999), (0.7094890510948907, 0.8, 0.3999999999999999), (0.691970802919708, 0.8, 0.3999999999999999), (0.6744525547445257, 0.8, 0.3999999999999999), (0.656934306569343, 0.8, 0.3999999999999999), (0.6394160583941608, 0.8, 0.3999999999999999), (0.621897810218978, 0.8, 0.3999999999999999), (0.6043795620437958, 0.8, 0.3999999999999999), (0.5868613138686132, 0.8, 0.3999999999999999), (0.5693430656934304, 0.8, 0.3999999999999999), (0.5518248175182482, 0.8, 0.3999999999999999), (0.534306569343066, 0.8, 0.3999999999999999), (0.5167883211678833, 0.8, 0.3999999999999999), (0.49927007299270054, 0.8, 0.3999999999999999), (0.4817518248175183, 0.8, 0.3999999999999999), (0.4642335766423356, 0.8, 0.3999999999999999), (0.44671532846715345, 0.8, 0.3999999999999999), (0.4291970802919707, 0.8, 0.3999999999999999), (0.41167883211678846, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4058394160583942), (0.3999999999999999, 0.8, 0.4233576642335764), (0.3999999999999999, 0.8, 0.4408759124087591), (0.3999999999999999, 0.8, 0.45839416058394133), (0.3999999999999999, 0.8, 0.47591240875912405), (0.3999999999999999, 0.8, 0.49343065693430677), (0.3999999999999999, 0.8, 0.510948905109489), (0.3999999999999999, 0.8, 0.5284671532846712), (0.3999999999999999, 0.8, 0.545985401459854), (0.3999999999999999, 0.8, 0.5635036496350366), (0.3999999999999999, 0.8, 0.5810218978102188), (0.3999999999999999, 0.8, 0.5985401459854016), (0.3999999999999999, 0.8, 0.6160583941605838), (0.3999999999999999, 0.8, 0.6335766423357665), (0.3999999999999999, 0.8, 0.6510948905109487), (0.3999999999999999, 0.8, 0.6686131386861315), (0.3999999999999999, 0.8, 0.6861313868613141), (0.3999999999999999, 0.8, 0.7036496350364965), (0.3999999999999999, 0.8, 0.7211678832116786), (0.3999999999999999, 0.8, 0.7386861313868613), (0.3999999999999999, 0.8, 0.7562043795620441), (0.3999999999999999, 0.8, 0.7737226277372262), (0.3999999999999999, 0.8, 0.791240875912409), (0.3999999999999999, 0.7912408759124088, 0.8), (0.3999999999999999, 0.7737226277372261, 0.8), (0.3999999999999999, 0.7562043795620439, 0.8), (0.3999999999999999, 0.7386861313868611, 0.8), (0.3999999999999999, 0.7211678832116785, 0.8), (0.3999999999999999, 0.7036496350364962, 0.8), (0.3999999999999999, 0.6861313868613141, 0.8), (0.3999999999999999, 0.6686131386861314, 0.8), (0.3999999999999999, 0.6510948905109486, 0.8), (0.3999999999999999, 0.6335766423357664, 0.8), (0.3999999999999999, 0.6160583941605842, 0.8), (0.3999999999999999, 0.5985401459854015, 0.8), (0.3999999999999999, 0.5810218978102187, 0.8), (0.3999999999999999, 0.5635036496350365, 0.8), (0.3999999999999999, 0.5459854014598543, 0.8), (0.3999999999999999, 0.5284671532846711, 0.8), (0.3999999999999999, 0.5109489051094889, 0.8), (0.3999999999999999, 0.49343065693430666, 0.8), (0.3999999999999999, 0.47591240875912394, 0.8), (0.3999999999999999, 0.4583941605839412, 0.8), (0.3999999999999999, 0.440875912408759, 0.8), (0.3999999999999999, 0.4233576642335768, 0.8), (0.3999999999999999, 0.4058394160583941, 0.8), (0.41167883211678824, 0.3999999999999999, 0.8), (0.4291970802919704, 0.3999999999999999, 0.8), (0.4467153284671526, 0.3999999999999999, 0.8), (0.46423357664233533, 0.3999999999999999, 0.8), (0.4817518248175181, 0.3999999999999999, 0.8), (0.49927007299270026, 0.3999999999999999, 0.8), (0.516788321167883, 0.3999999999999999, 0.8), (0.5343065693430658, 0.3999999999999999, 0.8), (0.551824817518248, 0.3999999999999999, 0.8), (0.5693430656934302, 0.3999999999999999, 0.8), (0.586861313868613, 0.3999999999999999, 0.8), (0.6043795620437956, 0.3999999999999999, 0.8), (0.6218978102189778, 0.3999999999999999, 0.8), (0.63941605839416, 0.3999999999999999, 0.8), (0.6569343065693427, 0.3999999999999999, 0.8), (0.6744525547445255, 0.3999999999999999, 0.8), (0.6919708029197077, 0.3999999999999999, 0.8), (0.7094890510948904, 0.3999999999999999, 0.8), (0.7270072992700731, 0.3999999999999999, 0.8), (0.7445255474452553, 0.3999999999999999, 0.8), (0.7620437956204376, 0.3999999999999999, 0.8), (0.7795620437956203, 0.3999999999999999, 0.8), (0.7970802919708031, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7854014598540144), (0.8, 0.3999999999999999, 0.7678832116788322), (0.8, 0.3999999999999999, 0.7503649635036496), (0.8, 0.3999999999999999, 0.7328467153284668), (0.8, 0.3999999999999999, 0.7153284671532846), (0.8, 0.3999999999999999, 0.6978102189781024), (0.8, 0.3999999999999999, 0.6802919708029196), (0.8, 0.3999999999999999, 0.6627737226277369), (0.8, 0.3999999999999999, 0.6452554744525547), (0.8, 0.3999999999999999, 0.6277372262773719), (0.8, 0.3999999999999999, 0.6102189781021893), (0.8, 0.3999999999999999, 0.5927007299270071), (0.8, 0.3999999999999999, 0.5751824817518248), (0.8, 0.3999999999999999, 0.5576642335766421), (0.8, 0.3999999999999999, 0.5401459854014594), (0.8, 0.3999999999999999, 0.5226277372262772), (0.8, 0.3999999999999999, 0.505109489051095), (0.8, 0.3999999999999999, 0.4875912408759122), (0.8, 0.3999999999999999, 0.4700729927007295), (0.8, 0.3999999999999999, 0.45255474452554734), (0.8, 0.3999999999999999, 0.43503649635036457), (0.8, 0.3999999999999999, 0.41751824817518185)],
    138: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41739130434782606, 0.3999999999999999), (0.8, 0.4347826086956523, 0.3999999999999999), (0.8, 0.4521739130434784, 0.3999999999999999), (0.8, 0.4695652173913041, 0.3999999999999999), (0.8, 0.48695652173913023, 0.3999999999999999), (0.8, 0.5043478260869564, 0.3999999999999999), (0.8, 0.5217391304347826, 0.3999999999999999), (0.8, 0.5391304347826087, 0.3999999999999999), (0.8, 0.5565217391304349, 0.3999999999999999), (0.8, 0.5739130434782611, 0.3999999999999999), (0.8, 0.5913043478260868, 0.3999999999999999), (0.8, 0.6086956521739129, 0.3999999999999999), (0.8, 0.6260869565217391, 0.3999999999999999), (0.8, 0.6434782608695653, 0.3999999999999999), (0.8, 0.6608695652173914, 0.3999999999999999), (0.8, 0.6782608695652176, 0.3999999999999999), (0.8, 0.6956521739130437, 0.3999999999999999), (0.8, 0.7130434782608694, 0.3999999999999999), (0.8, 0.7304347826086955, 0.3999999999999999), (0.8, 0.7478260869565216, 0.3999999999999999), (0.8, 0.7652173913043478, 0.3999999999999999), (0.8, 0.7826086956521741, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7826086956521743, 0.8, 0.3999999999999999), (0.7652173913043482, 0.8, 0.3999999999999999), (0.747826086956522, 0.8, 0.3999999999999999), (0.7304347826086959, 0.8, 0.3999999999999999), (0.7130434782608697, 0.8, 0.3999999999999999), (0.6956521739130435, 0.8, 0.3999999999999999), (0.6782608695652173, 0.8, 0.3999999999999999), (0.6608695652173912, 0.8, 0.3999999999999999), (0.6434782608695655, 0.8, 0.3999999999999999), (0.6260869565217393, 0.8, 0.3999999999999999), (0.6086956521739132, 0.8, 0.3999999999999999), (0.591304347826087, 0.8, 0.3999999999999999), (0.5739130434782608, 0.8, 0.3999999999999999), (0.5565217391304347, 0.8, 0.3999999999999999), (0.539130434782609, 0.8, 0.3999999999999999), (0.5217391304347828, 0.8, 0.3999999999999999), (0.5043478260869567, 0.8, 0.3999999999999999), (0.4869565217391305, 0.8, 0.3999999999999999), (0.4695652173913043, 0.8, 0.3999999999999999), (0.45217391304347815, 0.8, 0.3999999999999999), (0.434782608695652, 0.8, 0.3999999999999999), (0.4173913043478258, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41739130434782595), (0.3999999999999999, 0.8, 0.4347826086956521), (0.3999999999999999, 0.8, 0.4521739130434783), (0.3999999999999999, 0.8, 0.46956521739130447), (0.3999999999999999, 0.8, 0.4869565217391306), (0.3999999999999999, 0.8, 0.5043478260869563), (0.3999999999999999, 0.8, 0.5217391304347825), (0.3999999999999999, 0.8, 0.5391304347826086), (0.3999999999999999, 0.8, 0.5565217391304348), (0.3999999999999999, 0.8, 0.5739130434782609), (0.3999999999999999, 0.8, 0.5913043478260871), (0.3999999999999999, 0.8, 0.6086956521739133), (0.3999999999999999, 0.8, 0.6260869565217395), (0.3999999999999999, 0.8, 0.643478260869565), (0.3999999999999999, 0.8, 0.6608695652173913), (0.3999999999999999, 0.8, 0.6782608695652175), (0.3999999999999999, 0.8, 0.6956521739130437), (0.3999999999999999, 0.8, 0.7130434782608698), (0.3999999999999999, 0.8, 0.7304347826086954), (0.3999999999999999, 0.8, 0.7478260869565216), (0.3999999999999999, 0.8, 0.7652173913043477), (0.3999999999999999, 0.8, 0.7826086956521738), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7826086956521738, 0.8), (0.3999999999999999, 0.7652173913043476, 0.8), (0.3999999999999999, 0.7478260869565214, 0.8), (0.3999999999999999, 0.7304347826086952, 0.8), (0.3999999999999999, 0.7130434782608691, 0.8), (0.3999999999999999, 0.6956521739130435, 0.8), (0.3999999999999999, 0.6782608695652173, 0.8), (0.3999999999999999, 0.6608695652173912, 0.8), (0.3999999999999999, 0.6434782608695655, 0.8), (0.3999999999999999, 0.6260869565217393, 0.8), (0.3999999999999999, 0.6086956521739132, 0.8), (0.3999999999999999, 0.591304347826087, 0.8), (0.3999999999999999, 0.5739130434782608, 0.8), (0.3999999999999999, 0.5565217391304347, 0.8), (0.3999999999999999, 0.5391304347826085, 0.8), (0.3999999999999999, 0.5217391304347823, 0.8), (0.3999999999999999, 0.5043478260869562, 0.8), (0.3999999999999999, 0.48695652173912995, 0.8), (0.3999999999999999, 0.4695652173913038, 0.8), (0.3999999999999999, 0.45217391304347815, 0.8), (0.3999999999999999, 0.434782608695652, 0.8), (0.3999999999999999, 0.4173913043478258, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41739130434782556, 0.3999999999999999, 0.8), (0.4347826086956517, 0.3999999999999999, 0.8), (0.45217391304347787, 0.3999999999999999, 0.8), (0.4695652173913041, 0.3999999999999999, 0.8), (0.48695652173913023, 0.3999999999999999, 0.8), (0.5043478260869564, 0.3999999999999999, 0.8), (0.5217391304347826, 0.3999999999999999, 0.8), (0.5391304347826087, 0.3999999999999999, 0.8), (0.5565217391304349, 0.3999999999999999, 0.8), (0.5739130434782611, 0.3999999999999999, 0.8), (0.5913043478260868, 0.3999999999999999, 0.8), (0.6086956521739129, 0.3999999999999999, 0.8), (0.6260869565217391, 0.3999999999999999, 0.8), (0.6434782608695647, 0.3999999999999999, 0.8), (0.6608695652173908, 0.3999999999999999, 0.8), (0.678260869565217, 0.3999999999999999, 0.8), (0.6956521739130432, 0.3999999999999999, 0.8), (0.7130434782608694, 0.3999999999999999, 0.8), (0.7304347826086955, 0.3999999999999999, 0.8), (0.7478260869565216, 0.3999999999999999, 0.8), (0.7652173913043478, 0.3999999999999999, 0.8), (0.7826086956521741, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7826086956521738), (0.8, 0.3999999999999999, 0.7652173913043476), (0.8, 0.3999999999999999, 0.7478260869565214), (0.8, 0.3999999999999999, 0.7304347826086952), (0.8, 0.3999999999999999, 0.7130434782608697), (0.8, 0.3999999999999999, 0.6956521739130435), (0.8, 0.3999999999999999, 0.6782608695652173), (0.8, 0.3999999999999999, 0.6608695652173912), (0.8, 0.3999999999999999, 0.6434782608695649), (0.8, 0.3999999999999999, 0.6260869565217388), (0.8, 0.3999999999999999, 0.6086956521739126), (0.8, 0.3999999999999999, 0.5913043478260864), (0.8, 0.3999999999999999, 0.5739130434782602), (0.8, 0.3999999999999999, 0.5565217391304341), (0.8, 0.3999999999999999, 0.5391304347826085), (0.8, 0.3999999999999999, 0.5217391304347823), (0.8, 0.3999999999999999, 0.5043478260869562), (0.8, 0.3999999999999999, 0.48695652173912995), (0.8, 0.3999999999999999, 0.4695652173913043), (0.8, 0.3999999999999999, 0.45217391304347815), (0.8, 0.3999999999999999, 0.434782608695652), (0.8, 0.3999999999999999, 0.4173913043478258)],
    139: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4172661870503595, 0.3999999999999999), (0.8, 0.43453237410071915, 0.3999999999999999), (0.8, 0.4517985611510793, 0.3999999999999999), (0.8, 0.4690647482014389, 0.3999999999999999), (0.8, 0.4863309352517985, 0.3999999999999999), (0.8, 0.5035971223021581, 0.3999999999999999), (0.8, 0.5208633093525177, 0.3999999999999999), (0.8, 0.5381294964028779, 0.3999999999999999), (0.8, 0.5553956834532374, 0.3999999999999999), (0.8, 0.5726618705035971, 0.3999999999999999), (0.8, 0.5899280575539567, 0.3999999999999999), (0.8, 0.6071942446043163, 0.3999999999999999), (0.8, 0.6244604316546765, 0.3999999999999999), (0.8, 0.6417266187050361, 0.3999999999999999), (0.8, 0.6589928057553956, 0.3999999999999999), (0.8, 0.6762589928057553, 0.3999999999999999), (0.8, 0.6935251798561148, 0.3999999999999999), (0.8, 0.710791366906475, 0.3999999999999999), (0.8, 0.7280575539568346, 0.3999999999999999), (0.8, 0.7453237410071942, 0.3999999999999999), (0.8, 0.7625899280575539, 0.3999999999999999), (0.8, 0.7798561151079135, 0.3999999999999999), (0.8, 0.7971223021582736, 0.3999999999999999), (0.785611510791367, 0.8, 0.3999999999999999), (0.7683453237410074, 0.8, 0.3999999999999999), (0.7510791366906477, 0.8, 0.3999999999999999), (0.7338129496402876, 0.8, 0.3999999999999999), (0.716546762589928, 0.8, 0.3999999999999999), (0.6992805755395683, 0.8, 0.3999999999999999), (0.6820143884892087, 0.8, 0.3999999999999999), (0.6647482014388492, 0.8, 0.3999999999999999), (0.6474820143884895, 0.8, 0.3999999999999999), (0.6302158273381294, 0.8, 0.3999999999999999), (0.6129496402877698, 0.8, 0.3999999999999999), (0.5956834532374101, 0.8, 0.3999999999999999), (0.5784172661870506, 0.8, 0.3999999999999999), (0.5611510791366904, 0.8, 0.3999999999999999), (0.5438848920863308, 0.8, 0.3999999999999999), (0.5266187050359712, 0.8, 0.3999999999999999), (0.5093525179856115, 0.8, 0.3999999999999999), (0.492086330935252, 0.8, 0.3999999999999999), (0.47482014388489235, 0.8, 0.3999999999999999), (0.4575539568345322, 0.8, 0.3999999999999999), (0.4402877697841726, 0.8, 0.3999999999999999), (0.42302158273381296, 0.8, 0.3999999999999999), (0.40575539568345337, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4115107913669067), (0.3999999999999999, 0.8, 0.4287769784172663), (0.3999999999999999, 0.8, 0.44604316546762596), (0.3999999999999999, 0.8, 0.46330935251798555), (0.3999999999999999, 0.8, 0.48057553956834514), (0.3999999999999999, 0.8, 0.4978417266187048), (0.3999999999999999, 0.8, 0.5151079136690649), (0.3999999999999999, 0.8, 0.5323741007194245), (0.3999999999999999, 0.8, 0.5496402877697841), (0.3999999999999999, 0.8, 0.5669064748201442), (0.3999999999999999, 0.8, 0.5841726618705039), (0.3999999999999999, 0.8, 0.6014388489208635), (0.3999999999999999, 0.8, 0.6187050359712232), (0.3999999999999999, 0.8, 0.6359712230215827), (0.3999999999999999, 0.8, 0.6532374100719424), (0.3999999999999999, 0.8, 0.6705035971223019), (0.3999999999999999, 0.8, 0.6877697841726621), (0.3999999999999999, 0.8, 0.7050359712230216), (0.3999999999999999, 0.8, 0.7223021582733813), (0.3999999999999999, 0.8, 0.7395683453237414), (0.3999999999999999, 0.8, 0.756834532374101), (0.3999999999999999, 0.8, 0.7741007194244607), (0.3999999999999999, 0.8, 0.7913669064748203), (0.3999999999999999, 0.7913669064748201, 0.8), (0.3999999999999999, 0.7741007194244606, 0.8), (0.3999999999999999, 0.7568345323741009, 0.8), (0.3999999999999999, 0.7395683453237407, 0.8), (0.3999999999999999, 0.7223021582733812, 0.8), (0.3999999999999999, 0.7050359712230216, 0.8), (0.3999999999999999, 0.6877697841726614, 0.8), (0.3999999999999999, 0.6705035971223019, 0.8), (0.3999999999999999, 0.6532374100719422, 0.8), (0.3999999999999999, 0.6359712230215826, 0.8), (0.3999999999999999, 0.618705035971223, 0.8), (0.3999999999999999, 0.6014388489208634, 0.8), (0.3999999999999999, 0.5841726618705038, 0.8), (0.3999999999999999, 0.5669064748201436, 0.8), (0.3999999999999999, 0.549640287769784, 0.8), (0.3999999999999999, 0.5323741007194238, 0.8), (0.3999999999999999, 0.5151079136690643, 0.8), (0.3999999999999999, 0.4978417266187046, 0.8), (0.3999999999999999, 0.48057553956834503, 0.8), (0.3999999999999999, 0.46330935251798544, 0.8), (0.3999999999999999, 0.4460431654676258, 0.8), (0.3999999999999999, 0.4287769784172662, 0.8), (0.3999999999999999, 0.4115107913669066, 0.8), (0.4057553956834531, 0.3999999999999999, 0.8), (0.42302158273381274, 0.3999999999999999, 0.8), (0.4402877697841729, 0.3999999999999999, 0.8), (0.4575539568345325, 0.3999999999999999, 0.8), (0.4748201438848921, 0.3999999999999999, 0.8), (0.49208633093525167, 0.3999999999999999, 0.8), (0.5093525179856113, 0.3999999999999999, 0.8), (0.526618705035971, 0.3999999999999999, 0.8), (0.5438848920863305, 0.3999999999999999, 0.8), (0.5611510791366902, 0.3999999999999999, 0.8), (0.5784172661870502, 0.3999999999999999, 0.8), (0.5956834532374099, 0.3999999999999999, 0.8), (0.6129496402877701, 0.3999999999999999, 0.8), (0.6302158273381296, 0.3999999999999999, 0.8), (0.6474820143884893, 0.3999999999999999, 0.8), (0.6647482014388488, 0.3999999999999999, 0.8), (0.6820143884892085, 0.3999999999999999, 0.8), (0.6992805755395681, 0.3999999999999999, 0.8), (0.7165467625899278, 0.3999999999999999, 0.8), (0.7338129496402879, 0.3999999999999999, 0.8), (0.7510791366906475, 0.3999999999999999, 0.8), (0.7683453237410071, 0.3999999999999999, 0.8), (0.7856115107913673, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7971223021582727), (0.8, 0.3999999999999999, 0.7798561151079133), (0.8, 0.3999999999999999, 0.7625899280575537), (0.8, 0.3999999999999999, 0.745323741007194), (0.8, 0.3999999999999999, 0.7280575539568344), (0.8, 0.3999999999999999, 0.7107913669064747), (0.8, 0.3999999999999999, 0.6935251798561146), (0.8, 0.3999999999999999, 0.676258992805755), (0.8, 0.3999999999999999, 0.6589928057553954), (0.8, 0.3999999999999999, 0.6417266187050352), (0.8, 0.3999999999999999, 0.6244604316546757), (0.8, 0.3999999999999999, 0.607194244604316), (0.8, 0.3999999999999999, 0.5899280575539564), (0.8, 0.3999999999999999, 0.5726618705035968), (0.8, 0.3999999999999999, 0.5553956834532372), (0.8, 0.3999999999999999, 0.5381294964028775), (0.8, 0.3999999999999999, 0.5208633093525175), (0.8, 0.3999999999999999, 0.5035971223021578), (0.8, 0.3999999999999999, 0.4863309352517982), (0.8, 0.3999999999999999, 0.46906474820143806), (0.8, 0.3999999999999999, 0.45179856115107847), (0.8, 0.3999999999999999, 0.4345323741007189), (0.8, 0.3999999999999999, 0.4172661870503592)],
    140: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.417142857142857, 0.3999999999999999), (0.8, 0.4342857142857141, 0.3999999999999999), (0.8, 0.4514285714285712, 0.3999999999999999), (0.8, 0.46857142857142825, 0.3999999999999999), (0.8, 0.4857142857142859, 0.3999999999999999), (0.8, 0.502857142857143, 0.3999999999999999), (0.8, 0.52, 0.3999999999999999), (0.8, 0.5371428571428571, 0.3999999999999999), (0.8, 0.5542857142857143, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.5885714285714284, 0.3999999999999999), (0.8, 0.6057142857142855, 0.3999999999999999), (0.8, 0.6228571428571431, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6571428571428573, 0.3999999999999999), (0.8, 0.6742857142857144, 0.3999999999999999), (0.8, 0.6914285714285715, 0.3999999999999999), (0.8, 0.7085714285714286, 0.3999999999999999), (0.8, 0.7257142857142856, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7599999999999998, 0.3999999999999999), (0.8, 0.7771428571428569, 0.3999999999999999), (0.8, 0.7942857142857145, 0.3999999999999999), (0.7885714285714285, 0.8, 0.3999999999999999), (0.7714285714285715, 0.8, 0.3999999999999999), (0.7542857142857144, 0.8, 0.3999999999999999), (0.7371428571428573, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7028571428571431, 0.8, 0.3999999999999999), (0.685714285714286, 0.8, 0.3999999999999999), (0.6685714285714284, 0.8, 0.3999999999999999), (0.6514285714285714, 0.8, 0.3999999999999999), (0.6342857142857142, 0.8, 0.3999999999999999), (0.6171428571428572, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.582857142857143, 0.8, 0.3999999999999999), (0.5657142857142858, 0.8, 0.3999999999999999), (0.5485714285714288, 0.8, 0.3999999999999999), (0.5314285714285717, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.497142857142857, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.46285714285714286, 0.8, 0.3999999999999999), (0.44571428571428573, 0.8, 0.3999999999999999), (0.42857142857142866, 0.8, 0.3999999999999999), (0.4114285714285716, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40571428571428547), (0.3999999999999999, 0.8, 0.4228571428571431), (0.3999999999999999, 0.8, 0.44000000000000017), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.47428571428571437), (0.3999999999999999, 0.8, 0.49142857142857144), (0.3999999999999999, 0.8, 0.5085714285714286), (0.3999999999999999, 0.8, 0.5257142857142856), (0.3999999999999999, 0.8, 0.5428571428571427), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5771428571428568), (0.3999999999999999, 0.8, 0.594285714285714), (0.3999999999999999, 0.8, 0.6114285714285715), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6457142857142858), (0.3999999999999999, 0.8, 0.6628571428571428), (0.3999999999999999, 0.8, 0.6799999999999999), (0.3999999999999999, 0.8, 0.6971428571428571), (0.3999999999999999, 0.8, 0.7142857142857142), (0.3999999999999999, 0.8, 0.7314285714285718), (0.3999999999999999, 0.8, 0.7485714285714289), (0.3999999999999999, 0.8, 0.7657142857142859), (0.3999999999999999, 0.8, 0.7828571428571429), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7828571428571429, 0.8), (0.3999999999999999, 0.7657142857142858, 0.8), (0.3999999999999999, 0.7485714285714287, 0.8), (0.3999999999999999, 0.7314285714285715, 0.8), (0.3999999999999999, 0.7142857142857145, 0.8), (0.3999999999999999, 0.6971428571428575, 0.8), (0.3999999999999999, 0.6800000000000004, 0.8), (0.3999999999999999, 0.6628571428571428, 0.8), (0.3999999999999999, 0.6457142857142857, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6114285714285714, 0.8), (0.3999999999999999, 0.5942857142857139, 0.8), (0.3999999999999999, 0.5771428571428567, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5428571428571426, 0.8), (0.3999999999999999, 0.5257142857142855, 0.8), (0.3999999999999999, 0.5085714285714285, 0.8), (0.3999999999999999, 0.4914285714285713, 0.8), (0.3999999999999999, 0.4742857142857142, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.3999999999999999, 0.44000000000000006, 0.8), (0.3999999999999999, 0.42285714285714293, 0.8), (0.3999999999999999, 0.40571428571428586, 0.8), (0.41142857142857076, 0.3999999999999999, 0.8), (0.4285714285714284, 0.3999999999999999, 0.8), (0.4457142857142855, 0.3999999999999999, 0.8), (0.4628571428571426, 0.3999999999999999, 0.8), (0.47999999999999965, 0.3999999999999999, 0.8), (0.4971428571428567, 0.3999999999999999, 0.8), (0.5142857142857143, 0.3999999999999999, 0.8), (0.5314285714285715, 0.3999999999999999, 0.8), (0.5485714285714285, 0.3999999999999999, 0.8), (0.5657142857142856, 0.3999999999999999, 0.8), (0.5828571428571427, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6171428571428569, 0.3999999999999999, 0.8), (0.634285714285714, 0.3999999999999999, 0.8), (0.651428571428571, 0.3999999999999999, 0.8), (0.6685714285714282, 0.3999999999999999, 0.8), (0.6857142857142853, 0.3999999999999999, 0.8), (0.7028571428571424, 0.3999999999999999, 0.8), (0.7199999999999994, 0.3999999999999999, 0.8), (0.7371428571428571, 0.3999999999999999, 0.8), (0.7542857142857141, 0.3999999999999999, 0.8), (0.7714285714285712, 0.3999999999999999, 0.8), (0.7885714285714283, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7942857142857138), (0.8, 0.3999999999999999, 0.7771428571428567), (0.8, 0.3999999999999999, 0.7599999999999996), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7257142857142853), (0.8, 0.3999999999999999, 0.7085714285714283), (0.8, 0.3999999999999999, 0.6914285714285713), (0.8, 0.3999999999999999, 0.6742857142857142), (0.8, 0.3999999999999999, 0.657142857142857), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6228571428571429), (0.8, 0.3999999999999999, 0.6057142857142858), (0.8, 0.3999999999999999, 0.5885714285714286), (0.8, 0.3999999999999999, 0.5714285714285716), (0.8, 0.3999999999999999, 0.5542857142857139), (0.8, 0.3999999999999999, 0.5371428571428569), (0.8, 0.3999999999999999, 0.5199999999999998), (0.8, 0.3999999999999999, 0.5028571428571427), (0.8, 0.3999999999999999, 0.4857142857142851), (0.8, 0.3999999999999999, 0.468571428571428), (0.8, 0.3999999999999999, 0.4514285714285709), (0.8, 0.3999999999999999, 0.43428571428571383), (0.8, 0.3999999999999999, 0.4171428571428567)],
    141: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41702127659574434, 0.3999999999999999), (0.8, 0.4340425531914893, 0.3999999999999999), (0.8, 0.4510638297872338, 0.3999999999999999), (0.8, 0.46808510638297873, 0.3999999999999999), (0.8, 0.4851063829787232, 0.3999999999999999), (0.8, 0.5021276595744681, 0.3999999999999999), (0.8, 0.5191489361702126, 0.3999999999999999), (0.8, 0.5361702127659576, 0.3999999999999999), (0.8, 0.553191489361702, 0.3999999999999999), (0.8, 0.5702127659574465, 0.3999999999999999), (0.8, 0.5872340425531914, 0.3999999999999999), (0.8, 0.6042553191489359, 0.3999999999999999), (0.8, 0.6212765957446809, 0.3999999999999999), (0.8, 0.6382978723404253, 0.3999999999999999), (0.8, 0.6553191489361703, 0.3999999999999999), (0.8, 0.6723404255319148, 0.3999999999999999), (0.8, 0.6893617021276597, 0.3999999999999999), (0.8, 0.7063829787234042, 0.3999999999999999), (0.8, 0.7234042553191491, 0.3999999999999999), (0.8, 0.7404255319148936, 0.3999999999999999), (0.8, 0.7574468085106385, 0.3999999999999999), (0.8, 0.774468085106383, 0.3999999999999999), (0.8, 0.7914893617021275, 0.3999999999999999), (0.7914893617021277, 0.8, 0.3999999999999999), (0.7744680851063833, 0.8, 0.3999999999999999), (0.7574468085106383, 0.8, 0.3999999999999999), (0.7404255319148938, 0.8, 0.3999999999999999), (0.7234042553191489, 0.8, 0.3999999999999999), (0.7063829787234044, 0.8, 0.3999999999999999), (0.6893617021276595, 0.8, 0.3999999999999999), (0.672340425531915, 0.8, 0.3999999999999999), (0.6553191489361706, 0.8, 0.3999999999999999), (0.6382978723404256, 0.8, 0.3999999999999999), (0.6212765957446812, 0.8, 0.3999999999999999), (0.6042553191489362, 0.8, 0.3999999999999999), (0.5872340425531917, 0.8, 0.3999999999999999), (0.5702127659574467, 0.8, 0.3999999999999999), (0.5531914893617023, 0.8, 0.3999999999999999), (0.5361702127659573, 0.8, 0.3999999999999999), (0.5191489361702128, 0.8, 0.3999999999999999), (0.5021276595744685, 0.8, 0.3999999999999999), (0.48510638297872344, 0.8, 0.3999999999999999), (0.4680851063829785, 0.8, 0.3999999999999999), (0.451063829787234, 0.8, 0.3999999999999999), (0.4340425531914896, 0.8, 0.3999999999999999), (0.4170212765957446, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4170212765957447), (0.3999999999999999, 0.8, 0.4340425531914892), (0.3999999999999999, 0.8, 0.4510638297872342), (0.3999999999999999, 0.8, 0.4680851063829786), (0.3999999999999999, 0.8, 0.4851063829787236), (0.3999999999999999, 0.8, 0.502127659574468), (0.3999999999999999, 0.8, 0.5191489361702125), (0.3999999999999999, 0.8, 0.5361702127659574), (0.3999999999999999, 0.8, 0.5531914893617025), (0.3999999999999999, 0.8, 0.5702127659574469), (0.3999999999999999, 0.8, 0.5872340425531913), (0.3999999999999999, 0.8, 0.6042553191489363), (0.3999999999999999, 0.8, 0.6212765957446807), (0.3999999999999999, 0.8, 0.6382978723404258), (0.3999999999999999, 0.8, 0.6553191489361702), (0.3999999999999999, 0.8, 0.6723404255319146), (0.3999999999999999, 0.8, 0.6893617021276597), (0.3999999999999999, 0.8, 0.7063829787234046), (0.3999999999999999, 0.8, 0.7234042553191491), (0.3999999999999999, 0.8, 0.7404255319148935), (0.3999999999999999, 0.8, 0.7574468085106385), (0.3999999999999999, 0.8, 0.7744680851063829), (0.3999999999999999, 0.8, 0.7914893617021279), (0.3999999999999999, 0.7914893617021277, 0.8), (0.3999999999999999, 0.7744680851063833, 0.8), (0.3999999999999999, 0.7574468085106383, 0.8), (0.3999999999999999, 0.7404255319148934, 0.8), (0.3999999999999999, 0.7234042553191489, 0.8), (0.3999999999999999, 0.7063829787234044, 0.8), (0.3999999999999999, 0.6893617021276595, 0.8), (0.3999999999999999, 0.6723404255319145, 0.8), (0.3999999999999999, 0.65531914893617, 0.8), (0.3999999999999999, 0.6382978723404256, 0.8), (0.3999999999999999, 0.6212765957446812, 0.8), (0.3999999999999999, 0.6042553191489362, 0.8), (0.3999999999999999, 0.5872340425531912, 0.8), (0.3999999999999999, 0.5702127659574467, 0.8), (0.3999999999999999, 0.5531914893617023, 0.8), (0.3999999999999999, 0.5361702127659573, 0.8), (0.3999999999999999, 0.5191489361702124, 0.8), (0.3999999999999999, 0.5021276595744679, 0.8), (0.3999999999999999, 0.48510638297872344, 0.8), (0.3999999999999999, 0.4680851063829785, 0.8), (0.3999999999999999, 0.451063829787234, 0.8), (0.3999999999999999, 0.43404255319148904, 0.8), (0.3999999999999999, 0.4170212765957446, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41702127659574434, 0.3999999999999999, 0.8), (0.4340425531914893, 0.3999999999999999, 0.8), (0.4510638297872338, 0.3999999999999999, 0.8), (0.46808510638297823, 0.3999999999999999, 0.8), (0.4851063829787232, 0.3999999999999999, 0.8), (0.5021276595744681, 0.3999999999999999, 0.8), (0.5191489361702126, 0.3999999999999999, 0.8), (0.5361702127659571, 0.3999999999999999, 0.8), (0.5531914893617015, 0.3999999999999999, 0.8), (0.5702127659574465, 0.3999999999999999, 0.8), (0.5872340425531914, 0.3999999999999999, 0.8), (0.6042553191489359, 0.3999999999999999, 0.8), (0.6212765957446804, 0.3999999999999999, 0.8), (0.6382978723404253, 0.3999999999999999, 0.8), (0.6553191489361703, 0.3999999999999999, 0.8), (0.6723404255319148, 0.3999999999999999, 0.8), (0.6893617021276592, 0.3999999999999999, 0.8), (0.7063829787234042, 0.3999999999999999, 0.8), (0.7234042553191486, 0.3999999999999999, 0.8), (0.7404255319148936, 0.3999999999999999, 0.8), (0.7574468085106381, 0.3999999999999999, 0.8), (0.7744680851063825, 0.3999999999999999, 0.8), (0.7914893617021275, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7914893617021272), (0.8, 0.3999999999999999, 0.7744680851063828), (0.8, 0.3999999999999999, 0.7574468085106383), (0.8, 0.3999999999999999, 0.7404255319148934), (0.8, 0.3999999999999999, 0.7234042553191484), (0.8, 0.3999999999999999, 0.7063829787234039), (0.8, 0.3999999999999999, 0.6893617021276595), (0.8, 0.3999999999999999, 0.672340425531915), (0.8, 0.3999999999999999, 0.65531914893617), (0.8, 0.3999999999999999, 0.6382978723404251), (0.8, 0.3999999999999999, 0.6212765957446806), (0.8, 0.3999999999999999, 0.6042553191489362), (0.8, 0.3999999999999999, 0.5872340425531912), (0.8, 0.3999999999999999, 0.5702127659574462), (0.8, 0.3999999999999999, 0.5531914893617018), (0.8, 0.3999999999999999, 0.5361702127659573), (0.8, 0.3999999999999999, 0.5191489361702128), (0.8, 0.3999999999999999, 0.5021276595744679), (0.8, 0.3999999999999999, 0.48510638297872294), (0.8, 0.3999999999999999, 0.4680851063829785), (0.8, 0.3999999999999999, 0.451063829787234), (0.8, 0.3999999999999999, 0.43404255319148904), (0.8, 0.3999999999999999, 0.41702127659574406)],
    142: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4169014084507041, 0.3999999999999999), (0.8, 0.4338028169014083, 0.3999999999999999), (0.8, 0.4507042253521125, 0.3999999999999999), (0.8, 0.4676056338028167, 0.3999999999999999), (0.8, 0.4845070422535209, 0.3999999999999999), (0.8, 0.5014084507042251, 0.3999999999999999), (0.8, 0.5183098591549293, 0.3999999999999999), (0.8, 0.5352112676056335, 0.3999999999999999), (0.8, 0.5521126760563377, 0.3999999999999999), (0.8, 0.5690140845070419, 0.3999999999999999), (0.8, 0.5859154929577468, 0.3999999999999999), (0.8, 0.6028169014084505, 0.3999999999999999), (0.8, 0.6197183098591552, 0.3999999999999999), (0.8, 0.6366197183098594, 0.3999999999999999), (0.8, 0.6535211267605636, 0.3999999999999999), (0.8, 0.6704225352112678, 0.3999999999999999), (0.8, 0.687323943661972, 0.3999999999999999), (0.8, 0.7042253521126762, 0.3999999999999999), (0.8, 0.7211267605633804, 0.3999999999999999), (0.8, 0.7380281690140846, 0.3999999999999999), (0.8, 0.7549295774647888, 0.3999999999999999), (0.8, 0.771830985915493, 0.3999999999999999), (0.8, 0.7887323943661972, 0.3999999999999999), (0.7943661971830986, 0.8, 0.3999999999999999), (0.7774647887323944, 0.8, 0.3999999999999999), (0.7605633802816902, 0.8, 0.3999999999999999), (0.743661971830986, 0.8, 0.3999999999999999), (0.7267605633802818, 0.8, 0.3999999999999999), (0.7098591549295776, 0.8, 0.3999999999999999), (0.6929577464788734, 0.8, 0.3999999999999999), (0.6760563380281692, 0.8, 0.3999999999999999), (0.659154929577465, 0.8, 0.3999999999999999), (0.6422535211267608, 0.8, 0.3999999999999999), (0.6253521126760562, 0.8, 0.3999999999999999), (0.6084507042253524, 0.8, 0.3999999999999999), (0.5915492957746477, 0.8, 0.3999999999999999), (0.574647887323944, 0.8, 0.3999999999999999), (0.5577464788732392, 0.8, 0.3999999999999999), (0.540845070422535, 0.8, 0.3999999999999999), (0.5239436619718308, 0.8, 0.3999999999999999), (0.5070422535211266, 0.8, 0.3999999999999999), (0.49014084507042244, 0.8, 0.3999999999999999), (0.47323943661971823, 0.8, 0.3999999999999999), (0.45633802816901403, 0.8, 0.3999999999999999), (0.43943661971830983, 0.8, 0.3999999999999999), (0.4225352112676056, 0.8, 0.3999999999999999), (0.4056338028169014, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41126760563380277), (0.3999999999999999, 0.8, 0.42816901408450697), (0.3999999999999999, 0.8, 0.4450704225352112), (0.3999999999999999, 0.8, 0.4619718309859154), (0.3999999999999999, 0.8, 0.4788732394366196), (0.3999999999999999, 0.8, 0.4957746478873238), (0.3999999999999999, 0.8, 0.512676056338028), (0.3999999999999999, 0.8, 0.5295774647887322), (0.3999999999999999, 0.8, 0.5464788732394364), (0.3999999999999999, 0.8, 0.5633802816901412), (0.3999999999999999, 0.8, 0.5802816901408449), (0.3999999999999999, 0.8, 0.5971830985915496), (0.3999999999999999, 0.8, 0.6140845070422533), (0.3999999999999999, 0.8, 0.630985915492958), (0.3999999999999999, 0.8, 0.6478873239436622), (0.3999999999999999, 0.8, 0.6647887323943664), (0.3999999999999999, 0.8, 0.6816901408450706), (0.3999999999999999, 0.8, 0.6985915492957748), (0.3999999999999999, 0.8, 0.715492957746479), (0.3999999999999999, 0.8, 0.7323943661971832), (0.3999999999999999, 0.8, 0.7492957746478874), (0.3999999999999999, 0.8, 0.7661971830985916), (0.3999999999999999, 0.8, 0.7830985915492958), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7830985915492958, 0.8), (0.3999999999999999, 0.7661971830985915, 0.8), (0.3999999999999999, 0.7492957746478873, 0.8), (0.3999999999999999, 0.7323943661971831, 0.8), (0.3999999999999999, 0.7154929577464784, 0.8), (0.3999999999999999, 0.6985915492957747, 0.8), (0.3999999999999999, 0.68169014084507, 0.8), (0.3999999999999999, 0.6647887323943663, 0.8), (0.3999999999999999, 0.6478873239436616, 0.8), (0.3999999999999999, 0.6309859154929579, 0.8), (0.3999999999999999, 0.6140845070422531, 0.8), (0.3999999999999999, 0.5971830985915495, 0.8), (0.3999999999999999, 0.5802816901408447, 0.8), (0.3999999999999999, 0.563380281690141, 0.8), (0.3999999999999999, 0.5464788732394363, 0.8), (0.3999999999999999, 0.5295774647887326, 0.8), (0.3999999999999999, 0.5126760563380279, 0.8), (0.3999999999999999, 0.49577464788732367, 0.8), (0.3999999999999999, 0.47887323943661947, 0.8), (0.3999999999999999, 0.46197183098591527, 0.8), (0.3999999999999999, 0.44507042253521106, 0.8), (0.3999999999999999, 0.4281690140845068, 0.8), (0.3999999999999999, 0.4112676056338026, 0.8), (0.40563380281690115, 0.3999999999999999, 0.8), (0.42253521126760535, 0.3999999999999999, 0.8), (0.43943661971830955, 0.3999999999999999, 0.8), (0.45633802816901375, 0.3999999999999999, 0.8), (0.4732394366197185, 0.3999999999999999, 0.8), (0.49014084507042216, 0.3999999999999999, 0.8), (0.507042253521127, 0.3999999999999999, 0.8), (0.5239436619718306, 0.3999999999999999, 0.8), (0.5408450704225354, 0.3999999999999999, 0.8), (0.557746478873239, 0.3999999999999999, 0.8), (0.5746478873239438, 0.3999999999999999, 0.8), (0.5915492957746474, 0.3999999999999999, 0.8), (0.6084507042253522, 0.3999999999999999, 0.8), (0.6253521126760558, 0.3999999999999999, 0.8), (0.6422535211267606, 0.3999999999999999, 0.8), (0.6591549295774642, 0.3999999999999999, 0.8), (0.676056338028169, 0.3999999999999999, 0.8), (0.6929577464788732, 0.3999999999999999, 0.8), (0.7098591549295774, 0.3999999999999999, 0.8), (0.7267605633802816, 0.3999999999999999, 0.8), (0.7436619718309858, 0.3999999999999999, 0.8), (0.76056338028169, 0.3999999999999999, 0.8), (0.7774647887323942, 0.3999999999999999, 0.8), (0.7943661971830984, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.788732394366197), (0.8, 0.3999999999999999, 0.7718309859154928), (0.8, 0.3999999999999999, 0.7549295774647886), (0.8, 0.3999999999999999, 0.7380281690140844), (0.8, 0.3999999999999999, 0.7211267605633802), (0.8, 0.3999999999999999, 0.7042253521126753), (0.8, 0.3999999999999999, 0.6873239436619718), (0.8, 0.3999999999999999, 0.6704225352112669), (0.8, 0.3999999999999999, 0.6535211267605633), (0.8, 0.3999999999999999, 0.6366197183098585), (0.8, 0.3999999999999999, 0.6197183098591549), (0.8, 0.3999999999999999, 0.6028169014084501), (0.8, 0.3999999999999999, 0.5859154929577465), (0.8, 0.3999999999999999, 0.5690140845070417), (0.8, 0.3999999999999999, 0.5521126760563381), (0.8, 0.3999999999999999, 0.5352112676056333), (0.8, 0.3999999999999999, 0.5183098591549291), (0.8, 0.3999999999999999, 0.5014084507042249), (0.8, 0.3999999999999999, 0.4845070422535207), (0.8, 0.3999999999999999, 0.4676056338028165), (0.8, 0.3999999999999999, 0.4507042253521123), (0.8, 0.3999999999999999, 0.43380281690140804), (0.8, 0.3999999999999999, 0.41690140845070384)],
    143: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41678321678321695, 0.3999999999999999), (0.8, 0.43356643356643343, 0.3999999999999999), (0.8, 0.45034965034965047, 0.3999999999999999), (0.8, 0.46713286713286695, 0.3999999999999999), (0.8, 0.48391608391608393, 0.3999999999999999), (0.8, 0.5006993006993005, 0.3999999999999999), (0.8, 0.5174825174825175, 0.3999999999999999), (0.8, 0.5342657342657344, 0.3999999999999999), (0.8, 0.5510489510489509, 0.3999999999999999), (0.8, 0.5678321678321679, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.6013986013986015, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.634965034965035, 0.3999999999999999), (0.8, 0.651748251748252, 0.3999999999999999), (0.8, 0.6685314685314685, 0.3999999999999999), (0.8, 0.6853146853146855, 0.3999999999999999), (0.8, 0.702097902097902, 0.3999999999999999), (0.8, 0.718881118881119, 0.3999999999999999), (0.8, 0.7356643356643355, 0.3999999999999999), (0.8, 0.7524475524475525, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.8, 0.7860139860139861, 0.3999999999999999), (0.7972027972027971, 0.8, 0.3999999999999999), (0.7804195804195806, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7468531468531472, 0.8, 0.3999999999999999), (0.73006993006993, 0.8, 0.3999999999999999), (0.7132867132867136, 0.8, 0.3999999999999999), (0.6965034965034966, 0.8, 0.3999999999999999), (0.6797202797202802, 0.8, 0.3999999999999999), (0.6629370629370631, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.6293706293706296, 0.8, 0.3999999999999999), (0.6125874125874126, 0.8, 0.3999999999999999), (0.5958041958041961, 0.8, 0.3999999999999999), (0.579020979020979, 0.8, 0.3999999999999999), (0.562237762237762, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5286713286713285, 0.8, 0.3999999999999999), (0.511888111888112, 0.8, 0.3999999999999999), (0.495104895104895, 0.8, 0.3999999999999999), (0.47832167832167855, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.444755244755245, 0.8, 0.3999999999999999), (0.427972027972028, 0.8, 0.3999999999999999), (0.411188811188811, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40559440559440546), (0.3999999999999999, 0.8, 0.42237762237762244), (0.3999999999999999, 0.8, 0.439160839160839), (0.3999999999999999, 0.8, 0.45594405594405596), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.4895104895104895), (0.3999999999999999, 0.8, 0.506293706293706), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.53986013986014), (0.3999999999999999, 0.8, 0.5566433566433565), (0.3999999999999999, 0.8, 0.5734265734265735), (0.3999999999999999, 0.8, 0.59020979020979), (0.3999999999999999, 0.8, 0.6069930069930071), (0.3999999999999999, 0.8, 0.6237762237762241), (0.3999999999999999, 0.8, 0.6405594405594406), (0.3999999999999999, 0.8, 0.6573426573426575), (0.3999999999999999, 0.8, 0.674125874125874), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7076923076923081), (0.3999999999999999, 0.8, 0.7244755244755245), (0.3999999999999999, 0.8, 0.741258741258741), (0.3999999999999999, 0.8, 0.7580419580419581), (0.3999999999999999, 0.8, 0.7748251748251751), (0.3999999999999999, 0.8, 0.7916083916083916), (0.3999999999999999, 0.7916083916083914, 0.8), (0.3999999999999999, 0.774825174825175, 0.8), (0.3999999999999999, 0.758041958041958, 0.8), (0.3999999999999999, 0.7412587412587409, 0.8), (0.3999999999999999, 0.7244755244755244, 0.8), (0.3999999999999999, 0.707692307692308, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.674125874125874, 0.8), (0.3999999999999999, 0.6573426573426568, 0.8), (0.3999999999999999, 0.6405594405594404, 0.8), (0.3999999999999999, 0.6237762237762239, 0.8), (0.3999999999999999, 0.6069930069930068, 0.8), (0.3999999999999999, 0.5902097902097899, 0.8), (0.3999999999999999, 0.5734265734265733, 0.8), (0.3999999999999999, 0.5566433566433568, 0.8), (0.3999999999999999, 0.5398601398601399, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.5062937062937058, 0.8), (0.3999999999999999, 0.48951048951048937, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.45594405594405585, 0.8), (0.3999999999999999, 0.4391608391608388, 0.8), (0.3999999999999999, 0.42237762237762233, 0.8), (0.3999999999999999, 0.4055944055944053, 0.8), (0.41118881118881073, 0.3999999999999999, 0.8), (0.4279720279720277, 0.3999999999999999, 0.8), (0.44475524475524475, 0.3999999999999999, 0.8), (0.46153846153846123, 0.3999999999999999, 0.8), (0.4783216783216777, 0.3999999999999999, 0.8), (0.49510489510489475, 0.3999999999999999, 0.8), (0.5118881118881118, 0.3999999999999999, 0.8), (0.5286713286713288, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5622377622377618, 0.3999999999999999, 0.8), (0.5790209790209788, 0.3999999999999999, 0.8), (0.5958041958041959, 0.3999999999999999, 0.8), (0.6125874125874123, 0.3999999999999999, 0.8), (0.6293706293706288, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.6629370629370628, 0.3999999999999999, 0.8), (0.6797202797202799, 0.3999999999999999, 0.8), (0.6965034965034964, 0.3999999999999999, 0.8), (0.7132867132867129, 0.3999999999999999, 0.8), (0.7300699300699298, 0.3999999999999999, 0.8), (0.7468531468531469, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.7804195804195804, 0.3999999999999999, 0.8), (0.7972027972027969, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7860139860139859), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7524475524475522), (0.8, 0.3999999999999999, 0.7356643356643358), (0.8, 0.3999999999999999, 0.7188811188811188), (0.8, 0.3999999999999999, 0.7020979020979017), (0.8, 0.3999999999999999, 0.6853146853146848), (0.8, 0.3999999999999999, 0.6685314685314683), (0.8, 0.3999999999999999, 0.6517482517482518), (0.8, 0.3999999999999999, 0.6349650349650348), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.6013986013986012), (0.8, 0.3999999999999999, 0.5846153846153842), (0.8, 0.3999999999999999, 0.5678321678321677), (0.8, 0.3999999999999999, 0.5510489510489507), (0.8, 0.3999999999999999, 0.5342657342657336), (0.8, 0.3999999999999999, 0.5174825174825172), (0.8, 0.3999999999999999, 0.5006993006993007), (0.8, 0.3999999999999999, 0.48391608391608365), (0.8, 0.3999999999999999, 0.46713286713286667), (0.8, 0.3999999999999999, 0.45034965034964963), (0.8, 0.3999999999999999, 0.43356643356643315), (0.8, 0.3999999999999999, 0.41678321678321667)],
    144: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4166666666666665, 0.3999999999999999), (0.8, 0.4333333333333331, 0.3999999999999999), (0.8, 0.44999999999999973, 0.3999999999999999), (0.8, 0.46666666666666634, 0.3999999999999999), (0.8, 0.4833333333333335, 0.3999999999999999), (0.8, 0.5000000000000001, 0.3999999999999999), (0.8, 0.5166666666666667, 0.3999999999999999), (0.8, 0.5333333333333333, 0.3999999999999999), (0.8, 0.5499999999999999, 0.3999999999999999), (0.8, 0.5666666666666665, 0.3999999999999999), (0.8, 0.5833333333333333, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6166666666666665, 0.3999999999999999), (0.8, 0.6333333333333335, 0.3999999999999999), (0.8, 0.6500000000000001, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6833333333333333, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7166666666666666, 0.3999999999999999), (0.8, 0.7333333333333332, 0.3999999999999999), (0.8, 0.7499999999999998, 0.3999999999999999), (0.8, 0.7666666666666665, 0.3999999999999999), (0.8, 0.7833333333333337, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7833333333333334, 0.8, 0.3999999999999999), (0.7666666666666667, 0.8, 0.3999999999999999), (0.7500000000000001, 0.8, 0.3999999999999999), (0.7333333333333335, 0.8, 0.3999999999999999), (0.7166666666666669, 0.8, 0.3999999999999999), (0.7000000000000003, 0.8, 0.3999999999999999), (0.6833333333333337, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6499999999999999, 0.8, 0.3999999999999999), (0.6333333333333333, 0.8, 0.3999999999999999), (0.6166666666666667, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5833333333333335, 0.8, 0.3999999999999999), (0.5666666666666669, 0.8, 0.3999999999999999), (0.5500000000000003, 0.8, 0.3999999999999999), (0.5333333333333337, 0.8, 0.3999999999999999), (0.5166666666666665, 0.8, 0.3999999999999999), (0.5000000000000004, 0.8, 0.3999999999999999), (0.4833333333333332, 0.8, 0.3999999999999999), (0.4666666666666666, 0.8, 0.3999999999999999), (0.45, 0.8, 0.3999999999999999), (0.4333333333333334, 0.8, 0.3999999999999999), (0.4166666666666668, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4166666666666664), (0.3999999999999999, 0.8, 0.4333333333333335), (0.3999999999999999, 0.8, 0.4499999999999996), (0.3999999999999999, 0.8, 0.4666666666666668), (0.3999999999999999, 0.8, 0.4833333333333334), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5166666666666666), (0.3999999999999999, 0.8, 0.5333333333333332), (0.3999999999999999, 0.8, 0.5499999999999998), (0.3999999999999999, 0.8, 0.5666666666666664), (0.3999999999999999, 0.8, 0.5833333333333336), (0.3999999999999999, 0.8, 0.5999999999999996), (0.3999999999999999, 0.8, 0.6166666666666668), (0.3999999999999999, 0.8, 0.6333333333333334), (0.3999999999999999, 0.8, 0.65), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6833333333333333), (0.3999999999999999, 0.8, 0.7), (0.3999999999999999, 0.8, 0.7166666666666666), (0.3999999999999999, 0.8, 0.7333333333333336), (0.3999999999999999, 0.8, 0.7499999999999998), (0.3999999999999999, 0.8, 0.7666666666666668), (0.3999999999999999, 0.8, 0.7833333333333334), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7833333333333334, 0.8), (0.3999999999999999, 0.7666666666666667, 0.8), (0.3999999999999999, 0.7500000000000001, 0.8), (0.3999999999999999, 0.7333333333333335, 0.8), (0.3999999999999999, 0.7166666666666663, 0.8), (0.3999999999999999, 0.7000000000000003, 0.8), (0.3999999999999999, 0.6833333333333331, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6499999999999999, 0.8), (0.3999999999999999, 0.6333333333333333, 0.8), (0.3999999999999999, 0.6166666666666667, 0.8), (0.3999999999999999, 0.6000000000000001, 0.8), (0.3999999999999999, 0.5833333333333335, 0.8), (0.3999999999999999, 0.5666666666666663, 0.8), (0.3999999999999999, 0.5500000000000003, 0.8), (0.3999999999999999, 0.5333333333333331, 0.8), (0.3999999999999999, 0.516666666666667, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4833333333333332, 0.8), (0.3999999999999999, 0.4666666666666666, 0.8), (0.3999999999999999, 0.45, 0.8), (0.3999999999999999, 0.4333333333333334, 0.8), (0.3999999999999999, 0.41666666666666624, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4166666666666665, 0.3999999999999999, 0.8), (0.4333333333333326, 0.3999999999999999, 0.8), (0.44999999999999973, 0.3999999999999999, 0.8), (0.46666666666666634, 0.3999999999999999, 0.8), (0.48333333333333295, 0.3999999999999999, 0.8), (0.4999999999999996, 0.3999999999999999, 0.8), (0.5166666666666662, 0.3999999999999999, 0.8), (0.5333333333333333, 0.3999999999999999, 0.8), (0.5499999999999994, 0.3999999999999999, 0.8), (0.5666666666666665, 0.3999999999999999, 0.8), (0.5833333333333326, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6166666666666665, 0.3999999999999999, 0.8), (0.6333333333333331, 0.3999999999999999, 0.8), (0.6499999999999997, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6833333333333333, 0.3999999999999999, 0.8), (0.6999999999999995, 0.3999999999999999, 0.8), (0.7166666666666666, 0.3999999999999999, 0.8), (0.7333333333333327, 0.3999999999999999, 0.8), (0.7499999999999998, 0.3999999999999999, 0.8), (0.7666666666666665, 0.3999999999999999, 0.8), (0.783333333333333, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7833333333333334), (0.8, 0.3999999999999999, 0.7666666666666662), (0.8, 0.3999999999999999, 0.7500000000000001), (0.8, 0.3999999999999999, 0.733333333333333), (0.8, 0.3999999999999999, 0.7166666666666669), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6833333333333331), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6499999999999999), (0.8, 0.3999999999999999, 0.6333333333333333), (0.8, 0.3999999999999999, 0.6166666666666661), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5833333333333329), (0.8, 0.3999999999999999, 0.5666666666666669), (0.8, 0.3999999999999999, 0.5499999999999997), (0.8, 0.3999999999999999, 0.5333333333333331), (0.8, 0.3999999999999999, 0.5166666666666665), (0.8, 0.3999999999999999, 0.49999999999999983), (0.8, 0.3999999999999999, 0.4833333333333332), (0.8, 0.3999999999999999, 0.4666666666666661), (0.8, 0.3999999999999999, 0.45), (0.8, 0.3999999999999999, 0.43333333333333285), (0.8, 0.3999999999999999, 0.4166666666666668)],
    145: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41655172413793096, 0.3999999999999999), (0.8, 0.43310344827586206, 0.3999999999999999), (0.8, 0.44965517241379316, 0.3999999999999999), (0.8, 0.4662068965517242, 0.3999999999999999), (0.8, 0.48275862068965525, 0.3999999999999999), (0.8, 0.49931034482758635, 0.3999999999999999), (0.8, 0.5158620689655175, 0.3999999999999999), (0.8, 0.5324137931034485, 0.3999999999999999), (0.8, 0.548965517241379, 0.3999999999999999), (0.8, 0.5655172413793101, 0.3999999999999999), (0.8, 0.5820689655172412, 0.3999999999999999), (0.8, 0.5986206896551722, 0.3999999999999999), (0.8, 0.6151724137931034, 0.3999999999999999), (0.8, 0.6317241379310344, 0.3999999999999999), (0.8, 0.6482758620689655, 0.3999999999999999), (0.8, 0.6648275862068966, 0.3999999999999999), (0.8, 0.6813793103448276, 0.3999999999999999), (0.8, 0.6979310344827587, 0.3999999999999999), (0.8, 0.7144827586206898, 0.3999999999999999), (0.8, 0.7310344827586208, 0.3999999999999999), (0.8, 0.747586206896552, 0.3999999999999999), (0.8, 0.764137931034483, 0.3999999999999999), (0.8, 0.7806896551724141, 0.3999999999999999), (0.8, 0.7972413793103446, 0.3999999999999999), (0.7862068965517239, 0.8, 0.3999999999999999), (0.7696551724137934, 0.8, 0.3999999999999999), (0.7531034482758623, 0.8, 0.3999999999999999), (0.7365517241379314, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7034482758620692, 0.8, 0.3999999999999999), (0.6868965517241381, 0.8, 0.3999999999999999), (0.670344827586207, 0.8, 0.3999999999999999), (0.6537931034482759, 0.8, 0.3999999999999999), (0.6372413793103449, 0.8, 0.3999999999999999), (0.6206896551724138, 0.8, 0.3999999999999999), (0.6041379310344827, 0.8, 0.3999999999999999), (0.5875862068965516, 0.8, 0.3999999999999999), (0.5710344827586206, 0.8, 0.3999999999999999), (0.55448275862069, 0.8, 0.3999999999999999), (0.5379310344827584, 0.8, 0.3999999999999999), (0.5213793103448279, 0.8, 0.3999999999999999), (0.5048275862068963, 0.8, 0.3999999999999999), (0.4882758620689657, 0.8, 0.3999999999999999), (0.4717241379310346, 0.8, 0.3999999999999999), (0.4551724137931036, 0.8, 0.3999999999999999), (0.4386206896551725, 0.8, 0.3999999999999999), (0.42206896551724143, 0.8, 0.3999999999999999), (0.40551724137931033, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41103448275862065), (0.3999999999999999, 0.8, 0.42758620689655175), (0.3999999999999999, 0.8, 0.44413793103448285), (0.3999999999999999, 0.8, 0.4606896551724139), (0.3999999999999999, 0.8, 0.47724137931034494), (0.3999999999999999, 0.8, 0.4937931034482755), (0.3999999999999999, 0.8, 0.5103448275862071), (0.3999999999999999, 0.8, 0.5268965517241376), (0.3999999999999999, 0.8, 0.5434482758620692), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5765517241379309), (0.3999999999999999, 0.8, 0.5931034482758619), (0.3999999999999999, 0.8, 0.609655172413793), (0.3999999999999999, 0.8, 0.6262068965517241), (0.3999999999999999, 0.8, 0.6427586206896552), (0.3999999999999999, 0.8, 0.6593103448275862), (0.3999999999999999, 0.8, 0.6758620689655173), (0.3999999999999999, 0.8, 0.6924137931034484), (0.3999999999999999, 0.8, 0.7089655172413795), (0.3999999999999999, 0.8, 0.7255172413793105), (0.3999999999999999, 0.8, 0.7420689655172417), (0.3999999999999999, 0.8, 0.7586206896551726), (0.3999999999999999, 0.8, 0.7751724137931033), (0.3999999999999999, 0.8, 0.7917241379310349), (0.3999999999999999, 0.7917241379310347, 0.8), (0.3999999999999999, 0.7751724137931031, 0.8), (0.3999999999999999, 0.7586206896551726, 0.8), (0.3999999999999999, 0.7420689655172414, 0.8), (0.3999999999999999, 0.7255172413793104, 0.8), (0.3999999999999999, 0.7089655172413794, 0.8), (0.3999999999999999, 0.6924137931034482, 0.8), (0.3999999999999999, 0.6758620689655173, 0.8), (0.3999999999999999, 0.6593103448275861, 0.8), (0.3999999999999999, 0.6427586206896551, 0.8), (0.3999999999999999, 0.626206896551724, 0.8), (0.3999999999999999, 0.6096551724137929, 0.8), (0.3999999999999999, 0.5931034482758618, 0.8), (0.3999999999999999, 0.5765517241379312, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5434482758620691, 0.8), (0.3999999999999999, 0.5268965517241375, 0.8), (0.3999999999999999, 0.510344827586207, 0.8), (0.3999999999999999, 0.4937931034482754, 0.8), (0.3999999999999999, 0.4772413793103448, 0.8), (0.3999999999999999, 0.4606896551724138, 0.8), (0.3999999999999999, 0.4441379310344827, 0.8), (0.3999999999999999, 0.4275862068965516, 0.8), (0.3999999999999999, 0.41103448275862053, 0.8), (0.4055172413793101, 0.3999999999999999, 0.8), (0.42206896551724116, 0.3999999999999999, 0.8), (0.43862068965517226, 0.3999999999999999, 0.8), (0.4551724137931033, 0.3999999999999999, 0.8), (0.47172413793103385, 0.3999999999999999, 0.8), (0.48827586206896545, 0.3999999999999999, 0.8), (0.504827586206896, 0.3999999999999999, 0.8), (0.5213793103448277, 0.3999999999999999, 0.8), (0.5379310344827581, 0.3999999999999999, 0.8), (0.5544827586206897, 0.3999999999999999, 0.8), (0.5710344827586202, 0.3999999999999999, 0.8), (0.5875862068965514, 0.3999999999999999, 0.8), (0.6041379310344824, 0.3999999999999999, 0.8), (0.6206896551724135, 0.3999999999999999, 0.8), (0.6372413793103446, 0.3999999999999999, 0.8), (0.6537931034482757, 0.3999999999999999, 0.8), (0.6703448275862067, 0.3999999999999999, 0.8), (0.6868965517241379, 0.3999999999999999, 0.8), (0.7034482758620688, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.736551724137931, 0.3999999999999999, 0.8), (0.7531034482758616, 0.3999999999999999, 0.8), (0.7696551724137932, 0.3999999999999999, 0.8), (0.7862068965517237, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7972413793103443), (0.8, 0.3999999999999999, 0.7806896551724138), (0.8, 0.3999999999999999, 0.7641379310344822), (0.8, 0.3999999999999999, 0.7475862068965516), (0.8, 0.3999999999999999, 0.7310344827586206), (0.8, 0.3999999999999999, 0.7144827586206894), (0.8, 0.3999999999999999, 0.6979310344827585), (0.8, 0.3999999999999999, 0.6813793103448273), (0.8, 0.3999999999999999, 0.6648275862068963), (0.8, 0.3999999999999999, 0.6482758620689653), (0.8, 0.3999999999999999, 0.6317241379310341), (0.8, 0.3999999999999999, 0.6151724137931031), (0.8, 0.3999999999999999, 0.5986206896551726), (0.8, 0.3999999999999999, 0.5820689655172409), (0.8, 0.3999999999999999, 0.5655172413793104), (0.8, 0.3999999999999999, 0.5489655172413788), (0.8, 0.3999999999999999, 0.5324137931034483), (0.8, 0.3999999999999999, 0.5158620689655167), (0.8, 0.3999999999999999, 0.4993103448275861), (0.8, 0.3999999999999999, 0.482758620689655), (0.8, 0.3999999999999999, 0.4662068965517239), (0.8, 0.3999999999999999, 0.4496551724137929), (0.8, 0.3999999999999999, 0.4331034482758618), (0.8, 0.3999999999999999, 0.41655172413793073)],
    146: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4164383561643835, 0.3999999999999999), (0.8, 0.4328767123287672, 0.3999999999999999), (0.8, 0.44931506849315084, 0.3999999999999999), (0.8, 0.46575342465753444, 0.3999999999999999), (0.8, 0.48219178082191755, 0.3999999999999999), (0.8, 0.49863013698630115, 0.3999999999999999), (0.8, 0.5150684931506848, 0.3999999999999999), (0.8, 0.5315068493150684, 0.3999999999999999), (0.8, 0.547945205479452, 0.3999999999999999), (0.8, 0.5643835616438357, 0.3999999999999999), (0.8, 0.5808219178082193, 0.3999999999999999), (0.8, 0.5972602739726024, 0.3999999999999999), (0.8, 0.6136986301369861, 0.3999999999999999), (0.8, 0.6301369863013697, 0.3999999999999999), (0.8, 0.6465753424657533, 0.3999999999999999), (0.8, 0.6630136986301369, 0.3999999999999999), (0.8, 0.6794520547945206, 0.3999999999999999), (0.8, 0.6958904109589042, 0.3999999999999999), (0.8, 0.7123287671232879, 0.3999999999999999), (0.8, 0.7287671232876716, 0.3999999999999999), (0.8, 0.7452054794520546, 0.3999999999999999), (0.8, 0.7616438356164382, 0.3999999999999999), (0.8, 0.7780821917808218, 0.3999999999999999), (0.8, 0.7945205479452055, 0.3999999999999999), (0.789041095890411, 0.8, 0.3999999999999999), (0.7726027397260274, 0.8, 0.3999999999999999), (0.7561643835616438, 0.8, 0.3999999999999999), (0.7397260273972607, 0.8, 0.3999999999999999), (0.7232876712328771, 0.8, 0.3999999999999999), (0.7068493150684934, 0.8, 0.3999999999999999), (0.6904109589041099, 0.8, 0.3999999999999999), (0.6739726027397261, 0.8, 0.3999999999999999), (0.6575342465753425, 0.8, 0.3999999999999999), (0.6410958904109589, 0.8, 0.3999999999999999), (0.6246575342465752, 0.8, 0.3999999999999999), (0.6082191780821916, 0.8, 0.3999999999999999), (0.5917808219178086, 0.8, 0.3999999999999999), (0.5753424657534248, 0.8, 0.3999999999999999), (0.5589041095890412, 0.8, 0.3999999999999999), (0.5424657534246576, 0.8, 0.3999999999999999), (0.526027397260274, 0.8, 0.3999999999999999), (0.5095890410958903, 0.8, 0.3999999999999999), (0.4931506849315067, 0.8, 0.3999999999999999), (0.4767123287671236, 0.8, 0.3999999999999999), (0.46027397260273945, 0.8, 0.3999999999999999), (0.44383561643835634, 0.8, 0.3999999999999999), (0.42739726027397273, 0.8, 0.3999999999999999), (0.4109589041095891, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4054794520547945), (0.3999999999999999, 0.8, 0.4219178082191781), (0.3999999999999999, 0.8, 0.43835616438356123), (0.3999999999999999, 0.8, 0.4547945205479454), (0.3999999999999999, 0.8, 0.4712328767123285), (0.3999999999999999, 0.8, 0.4876712328767121), (0.3999999999999999, 0.8, 0.5041095890410958), (0.3999999999999999, 0.8, 0.5205479452054794), (0.3999999999999999, 0.8, 0.536986301369863), (0.3999999999999999, 0.8, 0.5534246575342466), (0.3999999999999999, 0.8, 0.5698630136986302), (0.3999999999999999, 0.8, 0.5863013698630134), (0.3999999999999999, 0.8, 0.6027397260273976), (0.3999999999999999, 0.8, 0.6191780821917807), (0.3999999999999999, 0.8, 0.6356164383561643), (0.3999999999999999, 0.8, 0.6520547945205479), (0.3999999999999999, 0.8, 0.6684931506849316), (0.3999999999999999, 0.8, 0.6849315068493151), (0.3999999999999999, 0.8, 0.7013698630136983), (0.3999999999999999, 0.8, 0.7178082191780825), (0.3999999999999999, 0.8, 0.7342465753424656), (0.3999999999999999, 0.8, 0.7506849315068491), (0.3999999999999999, 0.8, 0.7671232876712328), (0.3999999999999999, 0.8, 0.7835616438356166), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7835616438356163, 0.8), (0.3999999999999999, 0.7671232876712327, 0.8), (0.3999999999999999, 0.7506849315068496, 0.8), (0.3999999999999999, 0.7342465753424654, 0.8), (0.3999999999999999, 0.7178082191780824, 0.8), (0.3999999999999999, 0.7013698630136986, 0.8), (0.3999999999999999, 0.6849315068493151, 0.8), (0.3999999999999999, 0.6684931506849314, 0.8), (0.3999999999999999, 0.6520547945205478, 0.8), (0.3999999999999999, 0.6356164383561647, 0.8), (0.3999999999999999, 0.6191780821917805, 0.8), (0.3999999999999999, 0.6027397260273974, 0.8), (0.3999999999999999, 0.5863013698630137, 0.8), (0.3999999999999999, 0.5698630136986301, 0.8), (0.3999999999999999, 0.5534246575342465, 0.8), (0.3999999999999999, 0.5369863013698629, 0.8), (0.3999999999999999, 0.5205479452054793, 0.8), (0.3999999999999999, 0.5041095890410956, 0.8), (0.3999999999999999, 0.48767123287671255, 0.8), (0.3999999999999999, 0.4712328767123284, 0.8), (0.3999999999999999, 0.4547945205479453, 0.8), (0.3999999999999999, 0.4383561643835616, 0.8), (0.3999999999999999, 0.421917808219178, 0.8), (0.3999999999999999, 0.40547945205479435, 0.8), (0.4109589041095888, 0.3999999999999999, 0.8), (0.4273972602739719, 0.3999999999999999, 0.8), (0.4438356164383561, 0.3999999999999999, 0.8), (0.46027397260273917, 0.3999999999999999, 0.8), (0.47671232876712283, 0.3999999999999999, 0.8), (0.4931506849315065, 0.3999999999999999, 0.8), (0.5095890410958901, 0.3999999999999999, 0.8), (0.5260273972602737, 0.3999999999999999, 0.8), (0.5424657534246573, 0.3999999999999999, 0.8), (0.558904109589041, 0.3999999999999999, 0.8), (0.5753424657534241, 0.3999999999999999, 0.8), (0.5917808219178082, 0.3999999999999999, 0.8), (0.6082191780821914, 0.3999999999999999, 0.8), (0.624657534246575, 0.3999999999999999, 0.8), (0.6410958904109586, 0.3999999999999999, 0.8), (0.6575342465753422, 0.3999999999999999, 0.8), (0.6739726027397259, 0.3999999999999999, 0.8), (0.690410958904109, 0.3999999999999999, 0.8), (0.7068493150684931, 0.3999999999999999, 0.8), (0.7232876712328762, 0.3999999999999999, 0.8), (0.7397260273972599, 0.3999999999999999, 0.8), (0.7561643835616435, 0.3999999999999999, 0.8), (0.7726027397260271, 0.3999999999999999, 0.8), (0.7890410958904108, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7945205479452053), (0.8, 0.3999999999999999, 0.7780821917808216), (0.8, 0.3999999999999999, 0.7616438356164386), (0.8, 0.3999999999999999, 0.7452054794520544), (0.8, 0.3999999999999999, 0.7287671232876712), (0.8, 0.3999999999999999, 0.7123287671232876), (0.8, 0.3999999999999999, 0.6958904109589039), (0.8, 0.3999999999999999, 0.6794520547945204), (0.8, 0.3999999999999999, 0.6630136986301367), (0.8, 0.3999999999999999, 0.6465753424657537), (0.8, 0.3999999999999999, 0.6301369863013695), (0.8, 0.3999999999999999, 0.6136986301369863), (0.8, 0.3999999999999999, 0.5972602739726027), (0.8, 0.3999999999999999, 0.580821917808219), (0.8, 0.3999999999999999, 0.5643835616438354), (0.8, 0.3999999999999999, 0.5479452054794518), (0.8, 0.3999999999999999, 0.5315068493150682), (0.8, 0.3999999999999999, 0.5150684931506846), (0.8, 0.3999999999999999, 0.49863013698630143), (0.8, 0.3999999999999999, 0.48219178082191727), (0.8, 0.3999999999999999, 0.46575342465753417), (0.8, 0.3999999999999999, 0.44931506849315056), (0.8, 0.3999999999999999, 0.4328767123287669), (0.8, 0.3999999999999999, 0.4164383561643833)],
    147: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41632653061224484, 0.3999999999999999), (0.8, 0.43265306122448977, 0.3999999999999999), (0.8, 0.4489795918367347, 0.3999999999999999), (0.8, 0.4653061224489796, 0.3999999999999999), (0.8, 0.4816326530612245, 0.3999999999999999), (0.8, 0.4979591836734694, 0.3999999999999999), (0.8, 0.5142857142857143, 0.3999999999999999), (0.8, 0.5306122448979593, 0.3999999999999999), (0.8, 0.5469387755102042, 0.3999999999999999), (0.8, 0.5632653061224491, 0.3999999999999999), (0.8, 0.579591836734694, 0.3999999999999999), (0.8, 0.5959183673469389, 0.3999999999999999), (0.8, 0.6122448979591839, 0.3999999999999999), (0.8, 0.6285714285714288, 0.3999999999999999), (0.8, 0.6448979591836732, 0.3999999999999999), (0.8, 0.6612244897959181, 0.3999999999999999), (0.8, 0.6775510204081631, 0.3999999999999999), (0.8, 0.693877551020408, 0.3999999999999999), (0.8, 0.7102040816326529, 0.3999999999999999), (0.8, 0.7265306122448978, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7591836734693876, 0.3999999999999999), (0.8, 0.7755102040816326, 0.3999999999999999), (0.8, 0.7918367346938775, 0.3999999999999999), (0.7918367346938777, 0.8, 0.3999999999999999), (0.7755102040816328, 0.8, 0.3999999999999999), (0.759183673469388, 0.8, 0.3999999999999999), (0.742857142857143, 0.8, 0.3999999999999999), (0.726530612244898, 0.8, 0.3999999999999999), (0.7102040816326531, 0.8, 0.3999999999999999), (0.6938775510204083, 0.8, 0.3999999999999999), (0.6775510204081634, 0.8, 0.3999999999999999), (0.6612244897959184, 0.8, 0.3999999999999999), (0.6448979591836734, 0.8, 0.3999999999999999), (0.6285714285714286, 0.8, 0.3999999999999999), (0.6122448979591836, 0.8, 0.3999999999999999), (0.5959183673469387, 0.8, 0.3999999999999999), (0.5795918367346937, 0.8, 0.3999999999999999), (0.5632653061224488, 0.8, 0.3999999999999999), (0.5469387755102044, 0.8, 0.3999999999999999), (0.530612244897959, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.4979591836734692, 0.8, 0.3999999999999999), (0.48163265306122477, 0.8, 0.3999999999999999), (0.46530612244897934, 0.8, 0.3999999999999999), (0.44897959183673497, 0.8, 0.3999999999999999), (0.43265306122449004, 0.8, 0.3999999999999999), (0.4163265306122451, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41632653061224467), (0.3999999999999999, 0.8, 0.4326530612244896), (0.3999999999999999, 0.8, 0.4489795918367345), (0.3999999999999999, 0.8, 0.46530612244897945), (0.3999999999999999, 0.8, 0.4816326530612244), (0.3999999999999999, 0.8, 0.4979591836734693), (0.3999999999999999, 0.8, 0.5142857142857142), (0.3999999999999999, 0.8, 0.5306122448979591), (0.3999999999999999, 0.8, 0.5469387755102041), (0.3999999999999999, 0.8, 0.563265306122449), (0.3999999999999999, 0.8, 0.5795918367346939), (0.3999999999999999, 0.8, 0.5959183673469388), (0.3999999999999999, 0.8, 0.6122448979591838), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6448979591836737), (0.3999999999999999, 0.8, 0.6612244897959185), (0.3999999999999999, 0.8, 0.6775510204081634), (0.3999999999999999, 0.8, 0.6938775510204084), (0.3999999999999999, 0.8, 0.7102040816326534), (0.3999999999999999, 0.8, 0.7265306122448977), (0.3999999999999999, 0.8, 0.7428571428571431), (0.3999999999999999, 0.8, 0.7591836734693875), (0.3999999999999999, 0.8, 0.7755102040816331), (0.3999999999999999, 0.8, 0.7918367346938773), (0.3999999999999999, 0.7918367346938773, 0.8), (0.3999999999999999, 0.7755102040816328, 0.8), (0.3999999999999999, 0.7591836734693873, 0.8), (0.3999999999999999, 0.742857142857143, 0.8), (0.3999999999999999, 0.7265306122448976, 0.8), (0.3999999999999999, 0.7102040816326531, 0.8), (0.3999999999999999, 0.6938775510204083, 0.8), (0.3999999999999999, 0.6775510204081634, 0.8), (0.3999999999999999, 0.6612244897959184, 0.8), (0.3999999999999999, 0.6448979591836734, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6122448979591836, 0.8), (0.3999999999999999, 0.5959183673469387, 0.8), (0.3999999999999999, 0.5795918367346937, 0.8), (0.3999999999999999, 0.5632653061224488, 0.8), (0.3999999999999999, 0.546938775510204, 0.8), (0.3999999999999999, 0.530612244897959, 0.8), (0.3999999999999999, 0.5142857142857141, 0.8), (0.3999999999999999, 0.4979591836734692, 0.8), (0.3999999999999999, 0.48163265306122427, 0.8), (0.3999999999999999, 0.46530612244897984, 0.8), (0.3999999999999999, 0.4489795918367344, 0.8), (0.3999999999999999, 0.43265306122449004, 0.8), (0.3999999999999999, 0.41632653061224456, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41632653061224484, 0.3999999999999999, 0.8), (0.4326530612244892, 0.3999999999999999, 0.8), (0.4489795918367347, 0.3999999999999999, 0.8), (0.46530612244897906, 0.3999999999999999, 0.8), (0.4816326530612245, 0.3999999999999999, 0.8), (0.4979591836734689, 0.3999999999999999, 0.8), (0.5142857142857143, 0.3999999999999999, 0.8), (0.5306122448979588, 0.3999999999999999, 0.8), (0.5469387755102036, 0.3999999999999999, 0.8), (0.5632653061224486, 0.3999999999999999, 0.8), (0.5795918367346935, 0.3999999999999999, 0.8), (0.5959183673469385, 0.3999999999999999, 0.8), (0.6122448979591834, 0.3999999999999999, 0.8), (0.6285714285714283, 0.3999999999999999, 0.8), (0.6448979591836732, 0.3999999999999999, 0.8), (0.6612244897959181, 0.3999999999999999, 0.8), (0.6775510204081631, 0.3999999999999999, 0.8), (0.693877551020408, 0.3999999999999999, 0.8), (0.7102040816326529, 0.3999999999999999, 0.8), (0.7265306122448978, 0.3999999999999999, 0.8), (0.7428571428571427, 0.3999999999999999, 0.8), (0.7591836734693876, 0.3999999999999999, 0.8), (0.775510204081632, 0.3999999999999999, 0.8), (0.7918367346938775, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7918367346938777), (0.8, 0.3999999999999999, 0.7755102040816324), (0.8, 0.3999999999999999, 0.759183673469388), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.726530612244898), (0.8, 0.3999999999999999, 0.7102040816326527), (0.8, 0.3999999999999999, 0.6938775510204083), (0.8, 0.3999999999999999, 0.6775510204081627), (0.8, 0.3999999999999999, 0.6612244897959184), (0.8, 0.3999999999999999, 0.644897959183673), (0.8, 0.3999999999999999, 0.6285714285714286), (0.8, 0.3999999999999999, 0.6122448979591831), (0.8, 0.3999999999999999, 0.5959183673469387), (0.8, 0.3999999999999999, 0.5795918367346937), (0.8, 0.3999999999999999, 0.5632653061224488), (0.8, 0.3999999999999999, 0.546938775510204), (0.8, 0.3999999999999999, 0.530612244897959), (0.8, 0.3999999999999999, 0.5142857142857141), (0.8, 0.3999999999999999, 0.4979591836734692), (0.8, 0.3999999999999999, 0.48163265306122427), (0.8, 0.3999999999999999, 0.46530612244897934), (0.8, 0.3999999999999999, 0.4489795918367344), (0.8, 0.3999999999999999, 0.4326530612244895), (0.8, 0.3999999999999999, 0.41632653061224456)],
    148: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41621621621621624, 0.3999999999999999), (0.8, 0.43243243243243257, 0.3999999999999999), (0.8, 0.44864864864864834, 0.3999999999999999), (0.8, 0.46486486486486467, 0.3999999999999999), (0.8, 0.481081081081081, 0.3999999999999999), (0.8, 0.4972972972972973, 0.3999999999999999), (0.8, 0.5135135135135136, 0.3999999999999999), (0.8, 0.5297297297297294, 0.3999999999999999), (0.8, 0.5459459459459457, 0.3999999999999999), (0.8, 0.5621621621621621, 0.3999999999999999), (0.8, 0.5783783783783784, 0.3999999999999999), (0.8, 0.5945945945945947, 0.3999999999999999), (0.8, 0.610810810810811, 0.3999999999999999), (0.8, 0.6270270270270268, 0.3999999999999999), (0.8, 0.6432432432432431, 0.3999999999999999), (0.8, 0.6594594594594595, 0.3999999999999999), (0.8, 0.6756756756756759, 0.3999999999999999), (0.8, 0.6918918918918922, 0.3999999999999999), (0.8, 0.7081081081081084, 0.3999999999999999), (0.8, 0.7243243243243243, 0.3999999999999999), (0.8, 0.7405405405405405, 0.3999999999999999), (0.8, 0.7567567567567568, 0.3999999999999999), (0.8, 0.7729729729729732, 0.3999999999999999), (0.8, 0.7891891891891896, 0.3999999999999999), (0.7945945945945949, 0.8, 0.3999999999999999), (0.7783783783783786, 0.8, 0.3999999999999999), (0.7621621621621621, 0.8, 0.3999999999999999), (0.7459459459459459, 0.8, 0.3999999999999999), (0.7297297297297296, 0.8, 0.3999999999999999), (0.7135135135135138, 0.8, 0.3999999999999999), (0.6972972972972975, 0.8, 0.3999999999999999), (0.6810810810810812, 0.8, 0.3999999999999999), (0.6648648648648648, 0.8, 0.3999999999999999), (0.6486486486486485, 0.8, 0.3999999999999999), (0.6324324324324327, 0.8, 0.3999999999999999), (0.6162162162162164, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5837837837837838, 0.8, 0.3999999999999999), (0.5675675675675674, 0.8, 0.3999999999999999), (0.5513513513513516, 0.8, 0.3999999999999999), (0.5351351351351353, 0.8, 0.3999999999999999), (0.518918918918919, 0.8, 0.3999999999999999), (0.5027027027027027, 0.8, 0.3999999999999999), (0.48648648648648635, 0.8, 0.3999999999999999), (0.4702702702702706, 0.8, 0.3999999999999999), (0.4540540540540537, 0.8, 0.3999999999999999), (0.4378378378378379, 0.8, 0.3999999999999999), (0.4216216216216216, 0.8, 0.3999999999999999), (0.40540540540540526, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4108108108108105), (0.3999999999999999, 0.8, 0.42702702702702733), (0.3999999999999999, 0.8, 0.44324324324324316), (0.3999999999999999, 0.8, 0.45945945945945943), (0.3999999999999999, 0.8, 0.47567567567567576), (0.3999999999999999, 0.8, 0.4918918918918921), (0.3999999999999999, 0.8, 0.5081081081081085), (0.3999999999999999, 0.8, 0.5243243243243242), (0.3999999999999999, 0.8, 0.5405405405405406), (0.3999999999999999, 0.8, 0.5567567567567568), (0.3999999999999999, 0.8, 0.5729729729729731), (0.3999999999999999, 0.8, 0.5891891891891895), (0.3999999999999999, 0.8, 0.6054054054054053), (0.3999999999999999, 0.8, 0.6216216216216216), (0.3999999999999999, 0.8, 0.637837837837838), (0.3999999999999999, 0.8, 0.6540540540540543), (0.3999999999999999, 0.8, 0.6702702702702705), (0.3999999999999999, 0.8, 0.6864864864864864), (0.3999999999999999, 0.8, 0.7027027027027026), (0.3999999999999999, 0.8, 0.718918918918919), (0.3999999999999999, 0.8, 0.7351351351351354), (0.3999999999999999, 0.8, 0.7513513513513517), (0.3999999999999999, 0.8, 0.7675675675675675), (0.3999999999999999, 0.8, 0.7837837837837838), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7837837837837835, 0.8), (0.3999999999999999, 0.7675675675675673, 0.8), (0.3999999999999999, 0.7513513513513514, 0.8), (0.3999999999999999, 0.7351351351351347, 0.8), (0.3999999999999999, 0.7189189189189189, 0.8), (0.3999999999999999, 0.7027027027027026, 0.8), (0.3999999999999999, 0.6864864864864862, 0.8), (0.3999999999999999, 0.6702702702702705, 0.8), (0.3999999999999999, 0.6540540540540536, 0.8), (0.3999999999999999, 0.6378378378378378, 0.8), (0.3999999999999999, 0.6216216216216215, 0.8), (0.3999999999999999, 0.6054054054054051, 0.8), (0.3999999999999999, 0.5891891891891894, 0.8), (0.3999999999999999, 0.5729729729729724, 0.8), (0.3999999999999999, 0.5567567567567567, 0.8), (0.3999999999999999, 0.5405405405405403, 0.8), (0.3999999999999999, 0.5243243243243241, 0.8), (0.3999999999999999, 0.5081081081081078, 0.8), (0.3999999999999999, 0.4918918918918914, 0.8), (0.3999999999999999, 0.47567567567567565, 0.8), (0.3999999999999999, 0.4594594594594593, 0.8), (0.3999999999999999, 0.443243243243243, 0.8), (0.3999999999999999, 0.42702702702702666, 0.8), (0.3999999999999999, 0.41081081081081033, 0.8), (0.405405405405405, 0.3999999999999999, 0.8), (0.4216216216216213, 0.3999999999999999, 0.8), (0.43783783783783764, 0.3999999999999999, 0.8), (0.45405405405405397, 0.3999999999999999, 0.8), (0.4702702702702703, 0.3999999999999999, 0.8), (0.48648648648648607, 0.3999999999999999, 0.8), (0.5027027027027029, 0.3999999999999999, 0.8), (0.5189189189189187, 0.3999999999999999, 0.8), (0.535135135135135, 0.3999999999999999, 0.8), (0.5513513513513514, 0.3999999999999999, 0.8), (0.5675675675675671, 0.3999999999999999, 0.8), (0.583783783783784, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6162162162162161, 0.3999999999999999, 0.8), (0.6324324324324324, 0.3999999999999999, 0.8), (0.6486486486486482, 0.3999999999999999, 0.8), (0.6648648648648652, 0.3999999999999999, 0.8), (0.6810810810810809, 0.3999999999999999, 0.8), (0.6972972972972973, 0.3999999999999999, 0.8), (0.7135135135135136, 0.3999999999999999, 0.8), (0.7297297297297294, 0.3999999999999999, 0.8), (0.7459459459459461, 0.3999999999999999, 0.8), (0.7621621621621619, 0.3999999999999999, 0.8), (0.7783783783783782, 0.3999999999999999, 0.8), (0.7945945945945947, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7891891891891887), (0.8, 0.3999999999999999, 0.7729729729729724), (0.8, 0.3999999999999999, 0.7567567567567566), (0.8, 0.3999999999999999, 0.7405405405405403), (0.8, 0.3999999999999999, 0.724324324324324), (0.8, 0.3999999999999999, 0.7081081081081076), (0.8, 0.3999999999999999, 0.6918918918918913), (0.8, 0.3999999999999999, 0.6756756756756755), (0.8, 0.3999999999999999, 0.6594594594594592), (0.8, 0.3999999999999999, 0.6432432432432429), (0.8, 0.3999999999999999, 0.6270270270270266), (0.8, 0.3999999999999999, 0.6108108108108102), (0.8, 0.3999999999999999, 0.5945945945945944), (0.8, 0.3999999999999999, 0.5783783783783776), (0.8, 0.3999999999999999, 0.5621621621621617), (0.8, 0.3999999999999999, 0.5459459459459455), (0.8, 0.3999999999999999, 0.5297297297297292), (0.8, 0.3999999999999999, 0.5135135135135134), (0.8, 0.3999999999999999, 0.4972972972972965), (0.8, 0.3999999999999999, 0.4810810810810807), (0.8, 0.3999999999999999, 0.4648648648648644), (0.8, 0.3999999999999999, 0.44864864864864806), (0.8, 0.3999999999999999, 0.4324324324324323), (0.8, 0.3999999999999999, 0.4162162162162154)],
    149: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41610738255033575, 0.3999999999999999), (0.8, 0.43221476510067103, 0.3999999999999999), (0.8, 0.44832214765100686, 0.3999999999999999), (0.8, 0.46442953020134214, 0.3999999999999999), (0.8, 0.4805369127516779, 0.3999999999999999), (0.8, 0.4966442953020132, 0.3999999999999999), (0.8, 0.5127516778523491, 0.3999999999999999), (0.8, 0.5288590604026844, 0.3999999999999999), (0.8, 0.5449664429530201, 0.3999999999999999), (0.8, 0.5610738255033554, 0.3999999999999999), (0.8, 0.5771812080536912, 0.3999999999999999), (0.8, 0.5932885906040265, 0.3999999999999999), (0.8, 0.6093959731543623, 0.3999999999999999), (0.8, 0.6255033557046982, 0.3999999999999999), (0.8, 0.6416107382550335, 0.3999999999999999), (0.8, 0.6577181208053693, 0.3999999999999999), (0.8, 0.6738255033557046, 0.3999999999999999), (0.8, 0.6899328859060404, 0.3999999999999999), (0.8, 0.7060402684563757, 0.3999999999999999), (0.8, 0.7221476510067115, 0.3999999999999999), (0.8, 0.7382550335570468, 0.3999999999999999), (0.8, 0.7543624161073825, 0.3999999999999999), (0.8, 0.7704697986577185, 0.3999999999999999), (0.8, 0.7865771812080538, 0.3999999999999999), (0.7973154362416106, 0.8, 0.3999999999999999), (0.7812080536912753, 0.8, 0.3999999999999999), (0.7651006711409396, 0.8, 0.3999999999999999), (0.7489932885906043, 0.8, 0.3999999999999999), (0.7328859060402684, 0.8, 0.3999999999999999), (0.7167785234899331, 0.8, 0.3999999999999999), (0.7006711409395974, 0.8, 0.3999999999999999), (0.6845637583892621, 0.8, 0.3999999999999999), (0.6684563758389263, 0.8, 0.3999999999999999), (0.652348993288591, 0.8, 0.3999999999999999), (0.6362416107382551, 0.8, 0.3999999999999999), (0.6201342281879193, 0.8, 0.3999999999999999), (0.604026845637584, 0.8, 0.3999999999999999), (0.5879194630872482, 0.8, 0.3999999999999999), (0.5718120805369129, 0.8, 0.3999999999999999), (0.5557046979865771, 0.8, 0.3999999999999999), (0.5395973154362418, 0.8, 0.3999999999999999), (0.523489932885906, 0.8, 0.3999999999999999), (0.5073825503355707, 0.8, 0.3999999999999999), (0.4912751677852349, 0.8, 0.3999999999999999), (0.47516778523489905, 0.8, 0.3999999999999999), (0.4590604026845638, 0.8, 0.3999999999999999), (0.4429530201342285, 0.8, 0.3999999999999999), (0.42684563758389266, 0.8, 0.3999999999999999), (0.4107382550335569, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4053691275167784), (0.3999999999999999, 0.8, 0.4214765100671142), (0.3999999999999999, 0.8, 0.4375838926174495), (0.3999999999999999, 0.8, 0.4536912751677853), (0.3999999999999999, 0.8, 0.46979865771812057), (0.3999999999999999, 0.8, 0.4859060402684564), (0.3999999999999999, 0.8, 0.5020134228187917), (0.3999999999999999, 0.8, 0.5181208053691275), (0.3999999999999999, 0.8, 0.5342281879194634), (0.3999999999999999, 0.8, 0.5503355704697986), (0.3999999999999999, 0.8, 0.5664429530201339), (0.3999999999999999, 0.8, 0.5825503355704698), (0.3999999999999999, 0.8, 0.5986577181208056), (0.3999999999999999, 0.8, 0.6147651006711409), (0.3999999999999999, 0.8, 0.6308724832214767), (0.3999999999999999, 0.8, 0.646979865771812), (0.3999999999999999, 0.8, 0.6630872483221477), (0.3999999999999999, 0.8, 0.6791946308724837), (0.3999999999999999, 0.8, 0.6953020134228189), (0.3999999999999999, 0.8, 0.7114093959731542), (0.3999999999999999, 0.8, 0.72751677852349), (0.3999999999999999, 0.8, 0.7436241610738258), (0.3999999999999999, 0.8, 0.7597315436241611), (0.3999999999999999, 0.8, 0.7758389261744969), (0.3999999999999999, 0.8, 0.7919463087248322), (0.3999999999999999, 0.791946308724832, 0.8), (0.3999999999999999, 0.7758389261744962, 0.8), (0.3999999999999999, 0.759731543624161, 0.8), (0.3999999999999999, 0.7436241610738257, 0.8), (0.3999999999999999, 0.7275167785234898, 0.8), (0.3999999999999999, 0.711409395973154, 0.8), (0.3999999999999999, 0.6953020134228187, 0.8), (0.3999999999999999, 0.6791946308724834, 0.8), (0.3999999999999999, 0.6630872483221477, 0.8), (0.3999999999999999, 0.6469798657718118, 0.8), (0.3999999999999999, 0.6308724832214765, 0.8), (0.3999999999999999, 0.6147651006711412, 0.8), (0.3999999999999999, 0.5986577181208054, 0.8), (0.3999999999999999, 0.5825503355704695, 0.8), (0.3999999999999999, 0.5664429530201338, 0.8), (0.3999999999999999, 0.5503355704697985, 0.8), (0.3999999999999999, 0.5342281879194632, 0.8), (0.3999999999999999, 0.5181208053691274, 0.8), (0.3999999999999999, 0.5020134228187916, 0.8), (0.3999999999999999, 0.4859060402684563, 0.8), (0.3999999999999999, 0.469798657718121, 0.8), (0.3999999999999999, 0.4536912751677852, 0.8), (0.3999999999999999, 0.43758389261744934, 0.8), (0.3999999999999999, 0.42147651006711406, 0.8), (0.3999999999999999, 0.4053691275167782, 0.8), (0.4107382550335566, 0.3999999999999999, 0.8), (0.4268456375838924, 0.3999999999999999, 0.8), (0.4429530201342282, 0.3999999999999999, 0.8), (0.4590604026845635, 0.3999999999999999, 0.8), (0.4751677852348988, 0.3999999999999999, 0.8), (0.4912751677852346, 0.3999999999999999, 0.8), (0.5073825503355704, 0.3999999999999999, 0.8), (0.5234899328859057, 0.3999999999999999, 0.8), (0.539597315436241, 0.3999999999999999, 0.8), (0.5557046979865768, 0.3999999999999999, 0.8), (0.5718120805369127, 0.3999999999999999, 0.8), (0.5879194630872485, 0.3999999999999999, 0.8), (0.6040268456375838, 0.3999999999999999, 0.8), (0.6201342281879191, 0.3999999999999999, 0.8), (0.6362416107382549, 0.3999999999999999, 0.8), (0.6523489932885906, 0.3999999999999999, 0.8), (0.6684563758389259, 0.3999999999999999, 0.8), (0.6845637583892612, 0.3999999999999999, 0.8), (0.7006711409395971, 0.3999999999999999, 0.8), (0.7167785234899329, 0.3999999999999999, 0.8), (0.7328859060402682, 0.3999999999999999, 0.8), (0.7489932885906034, 0.3999999999999999, 0.8), (0.7651006711409393, 0.3999999999999999, 0.8), (0.7812080536912751, 0.3999999999999999, 0.8), (0.7973154362416108, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7865771812080535), (0.8, 0.3999999999999999, 0.7704697986577181), (0.8, 0.3999999999999999, 0.7543624161073823), (0.8, 0.3999999999999999, 0.7382550335570466), (0.8, 0.3999999999999999, 0.7221476510067113), (0.8, 0.3999999999999999, 0.706040268456376), (0.8, 0.3999999999999999, 0.6899328859060401), (0.8, 0.3999999999999999, 0.6738255033557043), (0.8, 0.3999999999999999, 0.6577181208053691), (0.8, 0.3999999999999999, 0.6416107382550332), (0.8, 0.3999999999999999, 0.625503355704698), (0.8, 0.3999999999999999, 0.6093959731543621), (0.8, 0.3999999999999999, 0.5932885906040263), (0.8, 0.3999999999999999, 0.577181208053691), (0.8, 0.3999999999999999, 0.5610738255033557), (0.8, 0.3999999999999999, 0.5449664429530199), (0.8, 0.3999999999999999, 0.528859060402684), (0.8, 0.3999999999999999, 0.5127516778523488), (0.8, 0.3999999999999999, 0.4966442953020135), (0.8, 0.3999999999999999, 0.48053691275167765), (0.8, 0.3999999999999999, 0.46442953020134187), (0.8, 0.3999999999999999, 0.44832214765100603), (0.8, 0.3999999999999999, 0.43221476510067075), (0.8, 0.3999999999999999, 0.41610738255033547)],
    150: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41599999999999976, 0.3999999999999999), (0.8, 0.4320000000000001, 0.3999999999999999), (0.8, 0.44799999999999995, 0.3999999999999999), (0.8, 0.4639999999999998, 0.3999999999999999), (0.8, 0.4800000000000002, 0.3999999999999999), (0.8, 0.49600000000000005, 0.3999999999999999), (0.8, 0.5119999999999999, 0.3999999999999999), (0.8, 0.5279999999999997, 0.3999999999999999), (0.8, 0.544, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.5759999999999997, 0.3999999999999999), (0.8, 0.5920000000000002, 0.3999999999999999), (0.8, 0.608, 0.3999999999999999), (0.8, 0.6239999999999999, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.656, 0.3999999999999999), (0.8, 0.6719999999999999, 0.3999999999999999), (0.8, 0.6880000000000003, 0.3999999999999999), (0.8, 0.7040000000000002, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.8, 0.7360000000000003, 0.3999999999999999), (0.8, 0.7520000000000002, 0.3999999999999999), (0.8, 0.768, 0.3999999999999999), (0.8, 0.7839999999999998, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.784, 0.8, 0.3999999999999999), (0.7680000000000002, 0.8, 0.3999999999999999), (0.7519999999999999, 0.8, 0.3999999999999999), (0.736, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7039999999999998, 0.8, 0.3999999999999999), (0.688, 0.8, 0.3999999999999999), (0.6720000000000002, 0.8, 0.3999999999999999), (0.6560000000000004, 0.8, 0.3999999999999999), (0.6399999999999999, 0.8, 0.3999999999999999), (0.6240000000000001, 0.8, 0.3999999999999999), (0.6080000000000002, 0.8, 0.3999999999999999), (0.5919999999999999, 0.8, 0.3999999999999999), (0.5760000000000001, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.5439999999999998, 0.8, 0.3999999999999999), (0.528, 0.8, 0.3999999999999999), (0.5120000000000001, 0.8, 0.3999999999999999), (0.4959999999999998, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.4640000000000001, 0.8, 0.3999999999999999), (0.44799999999999973, 0.8, 0.3999999999999999), (0.4319999999999999, 0.8, 0.3999999999999999), (0.41600000000000004, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.41600000000000015), (0.3999999999999999, 0.8, 0.432), (0.3999999999999999, 0.8, 0.44799999999999984), (0.3999999999999999, 0.8, 0.4640000000000002), (0.3999999999999999, 0.8, 0.48000000000000004), (0.3999999999999999, 0.8, 0.4959999999999999), (0.3999999999999999, 0.8, 0.5119999999999998), (0.3999999999999999, 0.8, 0.5280000000000001), (0.3999999999999999, 0.8, 0.5439999999999999), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5760000000000002), (0.3999999999999999, 0.8, 0.592), (0.3999999999999999, 0.8, 0.6079999999999999), (0.3999999999999999, 0.8, 0.6240000000000002), (0.3999999999999999, 0.8, 0.6400000000000001), (0.3999999999999999, 0.8, 0.6559999999999999), (0.3999999999999999, 0.8, 0.6720000000000004), (0.3999999999999999, 0.8, 0.6880000000000002), (0.3999999999999999, 0.8, 0.704), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.8, 0.7360000000000002), (0.3999999999999999, 0.8, 0.752), (0.3999999999999999, 0.8, 0.7680000000000005), (0.3999999999999999, 0.8, 0.7840000000000003), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7839999999999996, 0.8), (0.3999999999999999, 0.7679999999999998, 0.8), (0.3999999999999999, 0.7519999999999999, 0.8), (0.3999999999999999, 0.7359999999999995, 0.8), (0.3999999999999999, 0.7200000000000002, 0.8), (0.3999999999999999, 0.7039999999999998, 0.8), (0.3999999999999999, 0.6879999999999995, 0.8), (0.3999999999999999, 0.6720000000000002, 0.8), (0.3999999999999999, 0.6559999999999998, 0.8), (0.3999999999999999, 0.6399999999999999, 0.8), (0.3999999999999999, 0.6240000000000001, 0.8), (0.3999999999999999, 0.6079999999999998, 0.8), (0.3999999999999999, 0.5919999999999999, 0.8), (0.3999999999999999, 0.5760000000000001, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5439999999999998, 0.8), (0.3999999999999999, 0.528, 0.8), (0.3999999999999999, 0.5119999999999996, 0.8), (0.3999999999999999, 0.4959999999999998, 0.8), (0.3999999999999999, 0.4799999999999999, 0.8), (0.3999999999999999, 0.4639999999999995, 0.8), (0.3999999999999999, 0.44799999999999973, 0.8), (0.3999999999999999, 0.4319999999999999, 0.8), (0.3999999999999999, 0.4159999999999995, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.41599999999999976, 0.3999999999999999, 0.8), (0.4320000000000001, 0.3999999999999999, 0.8), (0.44799999999999995, 0.3999999999999999, 0.8), (0.4639999999999998, 0.3999999999999999, 0.8), (0.4800000000000002, 0.3999999999999999, 0.8), (0.4959999999999995, 0.3999999999999999, 0.8), (0.5119999999999999, 0.3999999999999999, 0.8), (0.5280000000000002, 0.3999999999999999, 0.8), (0.5439999999999996, 0.3999999999999999, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.5760000000000003, 0.3999999999999999, 0.8), (0.5919999999999996, 0.3999999999999999, 0.8), (0.608, 0.3999999999999999, 0.8), (0.6239999999999999, 0.3999999999999999, 0.8), (0.6399999999999997, 0.3999999999999999, 0.8), (0.656, 0.3999999999999999, 0.8), (0.6719999999999999, 0.3999999999999999, 0.8), (0.6879999999999997, 0.3999999999999999, 0.8), (0.7040000000000002, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7359999999999998, 0.3999999999999999, 0.8), (0.7520000000000002, 0.3999999999999999, 0.8), (0.768, 0.3999999999999999, 0.8), (0.7839999999999998, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7839999999999996), (0.8, 0.3999999999999999, 0.7679999999999998), (0.8, 0.3999999999999999, 0.7519999999999993), (0.8, 0.3999999999999999, 0.7359999999999995), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.7039999999999993), (0.8, 0.3999999999999999, 0.688), (0.8, 0.3999999999999999, 0.6719999999999997), (0.8, 0.3999999999999999, 0.6559999999999993), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6239999999999996), (0.8, 0.3999999999999999, 0.6079999999999992), (0.8, 0.3999999999999999, 0.5919999999999999), (0.8, 0.3999999999999999, 0.5759999999999995), (0.8, 0.3999999999999999, 0.5599999999999996), (0.8, 0.3999999999999999, 0.5439999999999998), (0.8, 0.3999999999999999, 0.5279999999999995), (0.8, 0.3999999999999999, 0.5119999999999996), (0.8, 0.3999999999999999, 0.4959999999999998), (0.8, 0.3999999999999999, 0.47999999999999937), (0.8, 0.3999999999999999, 0.4639999999999995), (0.8, 0.3999999999999999, 0.44799999999999973), (0.8, 0.3999999999999999, 0.43199999999999933), (0.8, 0.3999999999999999, 0.4159999999999995)],
    151: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4158940397350993, 0.3999999999999999), (0.8, 0.43178807947019876, 0.3999999999999999), (0.8, 0.4476821192052982, 0.3999999999999999), (0.8, 0.46357615894039705, 0.3999999999999999), (0.8, 0.4794701986754965, 0.3999999999999999), (0.8, 0.4953642384105959, 0.3999999999999999), (0.8, 0.5112582781456954, 0.3999999999999999), (0.8, 0.5271523178807948, 0.3999999999999999), (0.8, 0.5430463576158941, 0.3999999999999999), (0.8, 0.5589403973509931, 0.3999999999999999), (0.8, 0.5748344370860925, 0.3999999999999999), (0.8, 0.5907284768211919, 0.3999999999999999), (0.8, 0.6066225165562914, 0.3999999999999999), (0.8, 0.6225165562913908, 0.3999999999999999), (0.8, 0.6384105960264902, 0.3999999999999999), (0.8, 0.6543046357615896, 0.3999999999999999), (0.8, 0.6701986754966885, 0.3999999999999999), (0.8, 0.6860927152317879, 0.3999999999999999), (0.8, 0.7019867549668874, 0.3999999999999999), (0.8, 0.7178807947019867, 0.3999999999999999), (0.8, 0.7337748344370862, 0.3999999999999999), (0.8, 0.7496688741721856, 0.3999999999999999), (0.8, 0.765562913907285, 0.3999999999999999), (0.8, 0.7814569536423839, 0.3999999999999999), (0.8, 0.7973509933774834, 0.3999999999999999), (0.7867549668874174, 0.8, 0.3999999999999999), (0.7708609271523179, 0.8, 0.3999999999999999), (0.7549668874172185, 0.8, 0.3999999999999999), (0.7390728476821191, 0.8, 0.3999999999999999), (0.7231788079470203, 0.8, 0.3999999999999999), (0.7072847682119208, 0.8, 0.3999999999999999), (0.6913907284768214, 0.8, 0.3999999999999999), (0.675496688741722, 0.8, 0.3999999999999999), (0.6596026490066225, 0.8, 0.3999999999999999), (0.6437086092715231, 0.8, 0.3999999999999999), (0.6278145695364242, 0.8, 0.3999999999999999), (0.6119205298013247, 0.8, 0.3999999999999999), (0.5960264900662253, 0.8, 0.3999999999999999), (0.5801324503311259, 0.8, 0.3999999999999999), (0.5642384105960265, 0.8, 0.3999999999999999), (0.548344370860927, 0.8, 0.3999999999999999), (0.5324503311258276, 0.8, 0.3999999999999999), (0.5165562913907288, 0.8, 0.3999999999999999), (0.5006622516556294, 0.8, 0.3999999999999999), (0.4847682119205299, 0.8, 0.3999999999999999), (0.4688741721854305, 0.8, 0.3999999999999999), (0.4529801324503311, 0.8, 0.3999999999999999), (0.43708609271523163, 0.8, 0.3999999999999999), (0.4211920529801322, 0.8, 0.3999999999999999), (0.40529801324503334, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41059602649006605), (0.3999999999999999, 0.8, 0.4264900662251655), (0.3999999999999999, 0.8, 0.4423841059602649), (0.3999999999999999, 0.8, 0.45827814569536435), (0.3999999999999999, 0.8, 0.47417218543046324), (0.3999999999999999, 0.8, 0.4900662251655632), (0.3999999999999999, 0.8, 0.505960264900662), (0.3999999999999999, 0.8, 0.5218543046357615), (0.3999999999999999, 0.8, 0.5377483443708609), (0.3999999999999999, 0.8, 0.5536423841059603), (0.3999999999999999, 0.8, 0.5695364238410597), (0.3999999999999999, 0.8, 0.5854304635761587), (0.3999999999999999, 0.8, 0.6013245033112586), (0.3999999999999999, 0.8, 0.6172185430463575), (0.3999999999999999, 0.8, 0.633112582781457), (0.3999999999999999, 0.8, 0.6490066225165564), (0.3999999999999999, 0.8, 0.6649006622516558), (0.3999999999999999, 0.8, 0.6807947019867553), (0.3999999999999999, 0.8, 0.6966887417218541), (0.3999999999999999, 0.8, 0.7125827814569535), (0.3999999999999999, 0.8, 0.7284768211920529), (0.3999999999999999, 0.8, 0.7443708609271524), (0.3999999999999999, 0.8, 0.7602649006622517), (0.3999999999999999, 0.8, 0.7761589403973512), (0.3999999999999999, 0.8, 0.7920529801324507), (0.3999999999999999, 0.7920529801324505, 0.8), (0.3999999999999999, 0.7761589403973506, 0.8), (0.3999999999999999, 0.7602649006622517, 0.8), (0.3999999999999999, 0.7443708609271522, 0.8), (0.3999999999999999, 0.7284768211920528, 0.8), (0.3999999999999999, 0.7125827814569539, 0.8), (0.3999999999999999, 0.6966887417218539, 0.8), (0.3999999999999999, 0.6807947019867551, 0.8), (0.3999999999999999, 0.6649006622516557, 0.8), (0.3999999999999999, 0.6490066225165563, 0.8), (0.3999999999999999, 0.6331125827814568, 0.8), (0.3999999999999999, 0.6172185430463574, 0.8), (0.3999999999999999, 0.6013245033112585, 0.8), (0.3999999999999999, 0.5854304635761585, 0.8), (0.3999999999999999, 0.5695364238410596, 0.8), (0.3999999999999999, 0.5536423841059602, 0.8), (0.3999999999999999, 0.5377483443708608, 0.8), (0.3999999999999999, 0.5218543046357613, 0.8), (0.3999999999999999, 0.5059602649006619, 0.8), (0.3999999999999999, 0.49006622516556303, 0.8), (0.3999999999999999, 0.4741721854304631, 0.8), (0.3999999999999999, 0.4582781456953642, 0.8), (0.3999999999999999, 0.4423841059602648, 0.8), (0.3999999999999999, 0.42649006622516533, 0.8), (0.3999999999999999, 0.41059602649006594, 0.8), (0.40529801324503306, 0.3999999999999999, 0.8), (0.42119205298013196, 0.3999999999999999, 0.8), (0.4370860927152319, 0.3999999999999999, 0.8), (0.4529801324503308, 0.3999999999999999, 0.8), (0.4688741721854302, 0.3999999999999999, 0.8), (0.48476821192052966, 0.3999999999999999, 0.8), (0.5006622516556285, 0.3999999999999999, 0.8), (0.5165562913907285, 0.3999999999999999, 0.8), (0.5324503311258274, 0.3999999999999999, 0.8), (0.5483443708609268, 0.3999999999999999, 0.8), (0.5642384105960262, 0.3999999999999999, 0.8), (0.5801324503311256, 0.3999999999999999, 0.8), (0.5960264900662251, 0.3999999999999999, 0.8), (0.6119205298013239, 0.3999999999999999, 0.8), (0.6278145695364239, 0.3999999999999999, 0.8), (0.6437086092715228, 0.3999999999999999, 0.8), (0.6596026490066222, 0.3999999999999999, 0.8), (0.6754966887417218, 0.3999999999999999, 0.8), (0.691390728476821, 0.3999999999999999, 0.8), (0.7072847682119205, 0.3999999999999999, 0.8), (0.7231788079470194, 0.3999999999999999, 0.8), (0.7390728476821193, 0.3999999999999999, 0.8), (0.7549668874172182, 0.3999999999999999, 0.8), (0.7708609271523177, 0.3999999999999999, 0.8), (0.7867549668874172, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7973509933774832), (0.8, 0.3999999999999999, 0.7814569536423837), (0.8, 0.3999999999999999, 0.7655629139072848), (0.8, 0.3999999999999999, 0.7496688741721849), (0.8, 0.3999999999999999, 0.733774834437086), (0.8, 0.3999999999999999, 0.7178807947019865), (0.8, 0.3999999999999999, 0.7019867549668871), (0.8, 0.3999999999999999, 0.6860927152317882), (0.8, 0.3999999999999999, 0.6701986754966882), (0.8, 0.3999999999999999, 0.6543046357615894), (0.8, 0.3999999999999999, 0.6384105960264894), (0.8, 0.3999999999999999, 0.6225165562913906), (0.8, 0.3999999999999999, 0.6066225165562911), (0.8, 0.3999999999999999, 0.5907284768211917), (0.8, 0.3999999999999999, 0.5748344370860927), (0.8, 0.3999999999999999, 0.5589403973509928), (0.8, 0.3999999999999999, 0.5430463576158939), (0.8, 0.3999999999999999, 0.5271523178807945), (0.8, 0.3999999999999999, 0.5112582781456951), (0.8, 0.3999999999999999, 0.4953642384105957), (0.8, 0.3999999999999999, 0.47947019867549623), (0.8, 0.3999999999999999, 0.46357615894039733), (0.8, 0.3999999999999999, 0.4476821192052974), (0.8, 0.3999999999999999, 0.4317880794701985), (0.8, 0.3999999999999999, 0.4158940397350991)],
    152: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4157894736842104, 0.3999999999999999), (0.8, 0.4315789473684208, 0.3999999999999999), (0.8, 0.44736842105263125, 0.3999999999999999), (0.8, 0.4631578947368422, 0.3999999999999999), (0.8, 0.4789473684210527, 0.3999999999999999), (0.8, 0.49473684210526314, 0.3999999999999999), (0.8, 0.5105263157894736, 0.3999999999999999), (0.8, 0.5263157894736841, 0.3999999999999999), (0.8, 0.5421052631578944, 0.3999999999999999), (0.8, 0.5578947368421054, 0.3999999999999999), (0.8, 0.5736842105263159, 0.3999999999999999), (0.8, 0.5894736842105264, 0.3999999999999999), (0.8, 0.6052631578947368, 0.3999999999999999), (0.8, 0.6210526315789473, 0.3999999999999999), (0.8, 0.6368421052631577, 0.3999999999999999), (0.8, 0.6526315789473681, 0.3999999999999999), (0.8, 0.6684210526315791, 0.3999999999999999), (0.8, 0.6842105263157896, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7157894736842105, 0.3999999999999999), (0.8, 0.7315789473684209, 0.3999999999999999), (0.8, 0.7473684210526319, 0.3999999999999999), (0.8, 0.7631578947368424, 0.3999999999999999), (0.8, 0.7789473684210528, 0.3999999999999999), (0.8, 0.7947368421052632, 0.3999999999999999), (0.7894736842105265, 0.8, 0.3999999999999999), (0.7736842105263161, 0.8, 0.3999999999999999), (0.7578947368421056, 0.8, 0.3999999999999999), (0.7421052631578946, 0.8, 0.3999999999999999), (0.7263157894736842, 0.8, 0.3999999999999999), (0.7105263157894737, 0.8, 0.3999999999999999), (0.6947368421052633, 0.8, 0.3999999999999999), (0.6789473684210529, 0.8, 0.3999999999999999), (0.6631578947368424, 0.8, 0.3999999999999999), (0.6473684210526319, 0.8, 0.3999999999999999), (0.631578947368421, 0.8, 0.3999999999999999), (0.6157894736842106, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5842105263157896, 0.8, 0.3999999999999999), (0.5684210526315792, 0.8, 0.3999999999999999), (0.5526315789473681, 0.8, 0.3999999999999999), (0.5368421052631582, 0.8, 0.3999999999999999), (0.5210526315789473, 0.8, 0.3999999999999999), (0.5052631578947369, 0.8, 0.3999999999999999), (0.4894736842105264, 0.8, 0.3999999999999999), (0.47368421052631593, 0.8, 0.3999999999999999), (0.4578947368421055, 0.8, 0.3999999999999999), (0.4421052631578945, 0.8, 0.3999999999999999), (0.4263157894736841, 0.8, 0.3999999999999999), (0.41052631578947363, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40526315789473677), (0.3999999999999999, 0.8, 0.42105263157894723), (0.3999999999999999, 0.8, 0.43684210526315764), (0.3999999999999999, 0.8, 0.4526315789473681), (0.3999999999999999, 0.8, 0.46842105263157907), (0.3999999999999999, 0.8, 0.48421052631578954), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5157894736842105), (0.3999999999999999, 0.8, 0.5315789473684209), (0.3999999999999999, 0.8, 0.5473684210526318), (0.3999999999999999, 0.8, 0.5631578947368417), (0.3999999999999999, 0.8, 0.5789473684210528), (0.3999999999999999, 0.8, 0.5947368421052632), (0.3999999999999999, 0.8, 0.6105263157894737), (0.3999999999999999, 0.8, 0.6263157894736842), (0.3999999999999999, 0.8, 0.6421052631578945), (0.3999999999999999, 0.8, 0.6578947368421055), (0.3999999999999999, 0.8, 0.6736842105263154), (0.3999999999999999, 0.8, 0.6894736842105265), (0.3999999999999999, 0.8, 0.7052631578947368), (0.3999999999999999, 0.8, 0.7210526315789474), (0.3999999999999999, 0.8, 0.7368421052631577), (0.3999999999999999, 0.8, 0.7526315789473682), (0.3999999999999999, 0.8, 0.7684210526315792), (0.3999999999999999, 0.8, 0.7842105263157897), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7842105263157895, 0.8), (0.3999999999999999, 0.7684210526315791, 0.8), (0.3999999999999999, 0.7526315789473681, 0.8), (0.3999999999999999, 0.7368421052631582, 0.8), (0.3999999999999999, 0.7210526315789472, 0.8), (0.3999999999999999, 0.7052631578947368, 0.8), (0.3999999999999999, 0.6894736842105262, 0.8), (0.3999999999999999, 0.6736842105263159, 0.8), (0.3999999999999999, 0.6578947368421054, 0.8), (0.3999999999999999, 0.6421052631578944, 0.8), (0.3999999999999999, 0.6263157894736845, 0.8), (0.3999999999999999, 0.6105263157894735, 0.8), (0.3999999999999999, 0.5947368421052631, 0.8), (0.3999999999999999, 0.5789473684210527, 0.8), (0.3999999999999999, 0.5631578947368422, 0.8), (0.3999999999999999, 0.5473684210526317, 0.8), (0.3999999999999999, 0.5315789473684207, 0.8), (0.3999999999999999, 0.5157894736842108, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4842105263157894, 0.8), (0.3999999999999999, 0.46842105263157896, 0.8), (0.3999999999999999, 0.452631578947368, 0.8), (0.3999999999999999, 0.4368421052631581, 0.8), (0.3999999999999999, 0.42105263157894707, 0.8), (0.3999999999999999, 0.40526315789473666, 0.8), (0.41052631578947335, 0.3999999999999999, 0.8), (0.4263157894736838, 0.3999999999999999, 0.8), (0.4421052631578943, 0.3999999999999999, 0.8), (0.45789473684210524, 0.3999999999999999, 0.8), (0.47368421052631515, 0.3999999999999999, 0.8), (0.4894736842105261, 0.3999999999999999, 0.8), (0.5052631578947366, 0.3999999999999999, 0.8), (0.521052631578947, 0.3999999999999999, 0.8), (0.5368421052631575, 0.3999999999999999, 0.8), (0.5526315789473679, 0.3999999999999999, 0.8), (0.5684210526315789, 0.3999999999999999, 0.8), (0.5842105263157888, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6157894736842102, 0.3999999999999999, 0.8), (0.6315789473684207, 0.3999999999999999, 0.8), (0.6473684210526317, 0.3999999999999999, 0.8), (0.6631578947368416, 0.3999999999999999, 0.8), (0.6789473684210525, 0.3999999999999999, 0.8), (0.6947368421052631, 0.3999999999999999, 0.8), (0.7105263157894735, 0.3999999999999999, 0.8), (0.7263157894736839, 0.3999999999999999, 0.8), (0.7421052631578944, 0.3999999999999999, 0.8), (0.7578947368421054, 0.3999999999999999, 0.8), (0.7736842105263153, 0.3999999999999999, 0.8), (0.7894736842105263, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.794736842105263), (0.8, 0.3999999999999999, 0.7789473684210526), (0.8, 0.3999999999999999, 0.763157894736842), (0.8, 0.3999999999999999, 0.7473684210526317), (0.8, 0.3999999999999999, 0.7315789473684207), (0.8, 0.3999999999999999, 0.7157894736842108), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6842105263157894), (0.8, 0.3999999999999999, 0.6684210526315788), (0.8, 0.3999999999999999, 0.6526315789473685), (0.8, 0.3999999999999999, 0.636842105263158), (0.8, 0.3999999999999999, 0.621052631578947), (0.8, 0.3999999999999999, 0.6052631578947371), (0.8, 0.3999999999999999, 0.589473684210526), (0.8, 0.3999999999999999, 0.5736842105263156), (0.8, 0.3999999999999999, 0.5578947368421052), (0.8, 0.3999999999999999, 0.5421052631578942), (0.8, 0.3999999999999999, 0.5263157894736843), (0.8, 0.3999999999999999, 0.5105263157894733), (0.8, 0.3999999999999999, 0.49473684210526286), (0.8, 0.3999999999999999, 0.4789473684210524), (0.8, 0.3999999999999999, 0.463157894736842), (0.8, 0.3999999999999999, 0.4473684210526315), (0.8, 0.3999999999999999, 0.43157894736842056), (0.8, 0.3999999999999999, 0.4157894736842106)],
    153: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4156862745098038, 0.3999999999999999), (0.8, 0.43137254901960764, 0.3999999999999999), (0.8, 0.4470588235294115, 0.3999999999999999), (0.8, 0.4627450980392154, 0.3999999999999999), (0.8, 0.4784313725490198, 0.3999999999999999), (0.8, 0.49411764705882366, 0.3999999999999999), (0.8, 0.5098039215686275, 0.3999999999999999), (0.8, 0.5254901960784314, 0.3999999999999999), (0.8, 0.5411764705882353, 0.3999999999999999), (0.8, 0.5568627450980391, 0.3999999999999999), (0.8, 0.572549019607843, 0.3999999999999999), (0.8, 0.5882352941176469, 0.3999999999999999), (0.8, 0.6039215686274507, 0.3999999999999999), (0.8, 0.6196078431372551, 0.3999999999999999), (0.8, 0.635294117647059, 0.3999999999999999), (0.8, 0.6509803921568629, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6823529411764706, 0.3999999999999999), (0.8, 0.6980392156862745, 0.3999999999999999), (0.8, 0.7137254901960783, 0.3999999999999999), (0.8, 0.7294117647058822, 0.3999999999999999), (0.8, 0.7450980392156861, 0.3999999999999999), (0.8, 0.7607843137254899, 0.3999999999999999), (0.8, 0.7764705882352938, 0.3999999999999999), (0.8, 0.7921568627450983, 0.3999999999999999), (0.7921568627450981, 0.8, 0.3999999999999999), (0.7764705882352942, 0.8, 0.3999999999999999), (0.7607843137254903, 0.8, 0.3999999999999999), (0.7450980392156864, 0.8, 0.3999999999999999), (0.7294117647058825, 0.8, 0.3999999999999999), (0.7137254901960787, 0.8, 0.3999999999999999), (0.6980392156862748, 0.8, 0.3999999999999999), (0.6823529411764704, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6509803921568627, 0.8, 0.3999999999999999), (0.6352941176470588, 0.8, 0.3999999999999999), (0.6196078431372549, 0.8, 0.3999999999999999), (0.603921568627451, 0.8, 0.3999999999999999), (0.5882352941176472, 0.8, 0.3999999999999999), (0.5725490196078433, 0.8, 0.3999999999999999), (0.5568627450980395, 0.8, 0.3999999999999999), (0.5411764705882356, 0.8, 0.3999999999999999), (0.5254901960784317, 0.8, 0.3999999999999999), (0.5098039215686273, 0.8, 0.3999999999999999), (0.4941176470588234, 0.8, 0.3999999999999999), (0.4784313725490195, 0.8, 0.3999999999999999), (0.46274509803921565, 0.8, 0.3999999999999999), (0.4470588235294118, 0.8, 0.3999999999999999), (0.4313725490196079, 0.8, 0.3999999999999999), (0.41568627450980405, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.41568627450980417), (0.3999999999999999, 0.8, 0.43137254901960803), (0.3999999999999999, 0.8, 0.44705882352941195), (0.3999999999999999, 0.8, 0.4627450980392158), (0.3999999999999999, 0.8, 0.4784313725490197), (0.3999999999999999, 0.8, 0.49411764705882355), (0.3999999999999999, 0.8, 0.5098039215686274), (0.3999999999999999, 0.8, 0.5254901960784313), (0.3999999999999999, 0.8, 0.5411764705882351), (0.3999999999999999, 0.8, 0.556862745098039), (0.3999999999999999, 0.8, 0.5725490196078429), (0.3999999999999999, 0.8, 0.5882352941176473), (0.3999999999999999, 0.8, 0.6039215686274512), (0.3999999999999999, 0.8, 0.619607843137255), (0.3999999999999999, 0.8, 0.6352941176470589), (0.3999999999999999, 0.8, 0.6509803921568628), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6823529411764706), (0.3999999999999999, 0.8, 0.6980392156862749), (0.3999999999999999, 0.8, 0.7137254901960788), (0.3999999999999999, 0.8, 0.7294117647058826), (0.3999999999999999, 0.8, 0.7450980392156865), (0.3999999999999999, 0.8, 0.7607843137254904), (0.3999999999999999, 0.8, 0.7764705882352942), (0.3999999999999999, 0.8, 0.7921568627450981), (0.3999999999999999, 0.7921568627450981, 0.8), (0.3999999999999999, 0.7764705882352942, 0.8), (0.3999999999999999, 0.7607843137254903, 0.8), (0.3999999999999999, 0.7450980392156864, 0.8), (0.3999999999999999, 0.7294117647058825, 0.8), (0.3999999999999999, 0.7137254901960787, 0.8), (0.3999999999999999, 0.6980392156862743, 0.8), (0.3999999999999999, 0.6823529411764704, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6509803921568627, 0.8), (0.3999999999999999, 0.6352941176470588, 0.8), (0.3999999999999999, 0.6196078431372544, 0.8), (0.3999999999999999, 0.6039215686274505, 0.8), (0.3999999999999999, 0.5882352941176466, 0.8), (0.3999999999999999, 0.5725490196078428, 0.8), (0.3999999999999999, 0.5568627450980389, 0.8), (0.3999999999999999, 0.541176470588235, 0.8), (0.3999999999999999, 0.5254901960784312, 0.8), (0.3999999999999999, 0.5098039215686273, 0.8), (0.3999999999999999, 0.4941176470588234, 0.8), (0.3999999999999999, 0.4784313725490195, 0.8), (0.3999999999999999, 0.46274509803921565, 0.8), (0.3999999999999999, 0.4470588235294118, 0.8), (0.3999999999999999, 0.4313725490196079, 0.8), (0.3999999999999999, 0.41568627450980405, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.4156862745098038, 0.3999999999999999, 0.8), (0.43137254901960764, 0.3999999999999999, 0.8), (0.4470588235294115, 0.3999999999999999, 0.8), (0.4627450980392154, 0.3999999999999999, 0.8), (0.4784313725490198, 0.3999999999999999, 0.8), (0.49411764705882366, 0.3999999999999999, 0.8), (0.5098039215686275, 0.3999999999999999, 0.8), (0.5254901960784314, 0.3999999999999999, 0.8), (0.5411764705882353, 0.3999999999999999, 0.8), (0.5568627450980391, 0.3999999999999999, 0.8), (0.572549019607843, 0.3999999999999999, 0.8), (0.5882352941176469, 0.3999999999999999, 0.8), (0.6039215686274507, 0.3999999999999999, 0.8), (0.6196078431372547, 0.3999999999999999, 0.8), (0.6352941176470586, 0.3999999999999999, 0.8), (0.6509803921568624, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6823529411764702, 0.3999999999999999, 0.8), (0.6980392156862745, 0.3999999999999999, 0.8), (0.7137254901960783, 0.3999999999999999, 0.8), (0.7294117647058822, 0.3999999999999999, 0.8), (0.7450980392156861, 0.3999999999999999, 0.8), (0.7607843137254899, 0.3999999999999999, 0.8), (0.7764705882352945, 0.3999999999999999, 0.8), (0.7921568627450983, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7921568627450974), (0.8, 0.3999999999999999, 0.7764705882352936), (0.8, 0.3999999999999999, 0.7607843137254897), (0.8, 0.3999999999999999, 0.7450980392156858), (0.8, 0.3999999999999999, 0.729411764705882), (0.8, 0.3999999999999999, 0.7137254901960781), (0.8, 0.3999999999999999, 0.6980392156862743), (0.8, 0.3999999999999999, 0.6823529411764704), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6509803921568627), (0.8, 0.3999999999999999, 0.6352941176470588), (0.8, 0.3999999999999999, 0.6196078431372549), (0.8, 0.3999999999999999, 0.6039215686274505), (0.8, 0.3999999999999999, 0.5882352941176466), (0.8, 0.3999999999999999, 0.5725490196078428), (0.8, 0.3999999999999999, 0.5568627450980389), (0.8, 0.3999999999999999, 0.541176470588235), (0.8, 0.3999999999999999, 0.5254901960784306), (0.8, 0.3999999999999999, 0.5098039215686268), (0.8, 0.3999999999999999, 0.4941176470588229), (0.8, 0.3999999999999999, 0.478431372549019), (0.8, 0.3999999999999999, 0.46274509803921515), (0.8, 0.3999999999999999, 0.4470588235294113), (0.8, 0.3999999999999999, 0.43137254901960737), (0.8, 0.3999999999999999, 0.4156862745098035)],
    154: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4155844155844156, 0.3999999999999999), (0.8, 0.4311688311688308, 0.3999999999999999), (0.8, 0.44675324675324657, 0.3999999999999999), (0.8, 0.46233766233766227, 0.3999999999999999), (0.8, 0.477922077922078, 0.3999999999999999), (0.8, 0.4935064935064932, 0.3999999999999999), (0.8, 0.5090909090909089, 0.3999999999999999), (0.8, 0.5246753246753246, 0.3999999999999999), (0.8, 0.5402597402597404, 0.3999999999999999), (0.8, 0.5558441558441556, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.587012987012987, 0.3999999999999999), (0.8, 0.6025974025974028, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6337662337662338, 0.3999999999999999), (0.8, 0.6493506493506495, 0.3999999999999999), (0.8, 0.6649350649350652, 0.3999999999999999), (0.8, 0.6805194805194803, 0.3999999999999999), (0.8, 0.6961038961038961, 0.3999999999999999), (0.8, 0.7116883116883118, 0.3999999999999999), (0.8, 0.7272727272727275, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7584415584415585, 0.3999999999999999), (0.8, 0.7740259740259742, 0.3999999999999999), (0.8, 0.7896103896103899, 0.3999999999999999), (0.7948051948051951, 0.8, 0.3999999999999999), (0.7792207792207793, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7480519480519484, 0.8, 0.3999999999999999), (0.7324675324675327, 0.8, 0.3999999999999999), (0.7168831168831169, 0.8, 0.3999999999999999), (0.7012987012987013, 0.8, 0.3999999999999999), (0.6857142857142855, 0.8, 0.3999999999999999), (0.6701298701298704, 0.8, 0.3999999999999999), (0.6545454545454545, 0.8, 0.3999999999999999), (0.6389610389610388, 0.8, 0.3999999999999999), (0.6233766233766237, 0.8, 0.3999999999999999), (0.6077922077922079, 0.8, 0.3999999999999999), (0.5922077922077922, 0.8, 0.3999999999999999), (0.5766233766233765, 0.8, 0.3999999999999999), (0.5610389610389608, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5298701298701298, 0.8, 0.3999999999999999), (0.5142857142857141, 0.8, 0.3999999999999999), (0.4987012987012989, 0.8, 0.3999999999999999), (0.48311688311688317, 0.8, 0.3999999999999999), (0.46753246753246747, 0.8, 0.3999999999999999), (0.4519480519480517, 0.8, 0.3999999999999999), (0.4363636363636365, 0.8, 0.3999999999999999), (0.4207792207792208, 0.8, 0.3999999999999999), (0.40519480519480505, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4103896103896101), (0.3999999999999999, 0.8, 0.4259740259740258), (0.3999999999999999, 0.8, 0.44155844155844154), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.4883116883116882), (0.3999999999999999, 0.8, 0.503896103896104), (0.3999999999999999, 0.8, 0.5194805194805197), (0.3999999999999999, 0.8, 0.5350649350649348), (0.3999999999999999, 0.8, 0.5506493506493506), (0.3999999999999999, 0.8, 0.5662337662337663), (0.3999999999999999, 0.8, 0.581818181818182), (0.3999999999999999, 0.8, 0.5974025974025977), (0.3999999999999999, 0.8, 0.612987012987013), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6441558441558444), (0.3999999999999999, 0.8, 0.6597402597402596), (0.3999999999999999, 0.8, 0.6753246753246753), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7064935064935067), (0.3999999999999999, 0.8, 0.7220779220779225), (0.3999999999999999, 0.8, 0.7376623376623377), (0.3999999999999999, 0.8, 0.7532467532467535), (0.3999999999999999, 0.8, 0.7688311688311692), (0.3999999999999999, 0.8, 0.7844155844155845), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7844155844155842, 0.8), (0.3999999999999999, 0.7688311688311685, 0.8), (0.3999999999999999, 0.7532467532467528, 0.8), (0.3999999999999999, 0.7376623376623376, 0.8), (0.3999999999999999, 0.7220779220779219, 0.8), (0.3999999999999999, 0.7064935064935067, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6753246753246752, 0.8), (0.3999999999999999, 0.6597402597402595, 0.8), (0.3999999999999999, 0.6441558441558437, 0.8), (0.3999999999999999, 0.628571428571428, 0.8), (0.3999999999999999, 0.6129870129870129, 0.8), (0.3999999999999999, 0.597402597402597, 0.8), (0.3999999999999999, 0.5818181818181819, 0.8), (0.3999999999999999, 0.5662337662337662, 0.8), (0.3999999999999999, 0.5506493506493504, 0.8), (0.3999999999999999, 0.5350649350649347, 0.8), (0.3999999999999999, 0.519480519480519, 0.8), (0.3999999999999999, 0.5038961038961038, 0.8), (0.3999999999999999, 0.48831168831168803, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.3999999999999999, 0.44155844155844143, 0.8), (0.3999999999999999, 0.42597402597402567, 0.8), (0.3999999999999999, 0.41038961038960997, 0.8), (0.40519480519480533, 0.3999999999999999, 0.8), (0.42077922077922053, 0.3999999999999999, 0.8), (0.43636363636363623, 0.3999999999999999, 0.8), (0.45194805194805143, 0.3999999999999999, 0.8), (0.4675324675324672, 0.3999999999999999, 0.8), (0.4831168831168829, 0.3999999999999999, 0.8), (0.49870129870129865, 0.3999999999999999, 0.8), (0.5142857142857143, 0.3999999999999999, 0.8), (0.52987012987013, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.561038961038961, 0.3999999999999999, 0.8), (0.5766233766233761, 0.3999999999999999, 0.8), (0.592207792207792, 0.3999999999999999, 0.8), (0.6077922077922077, 0.3999999999999999, 0.8), (0.6233766233766234, 0.3999999999999999, 0.8), (0.6389610389610392, 0.3999999999999999, 0.8), (0.6545454545454549, 0.3999999999999999, 0.8), (0.6701298701298701, 0.3999999999999999, 0.8), (0.6857142857142857, 0.3999999999999999, 0.8), (0.701298701298701, 0.3999999999999999, 0.8), (0.7168831168831167, 0.3999999999999999, 0.8), (0.7324675324675325, 0.3999999999999999, 0.8), (0.7480519480519481, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.7792207792207797, 0.3999999999999999, 0.8), (0.7948051948051948, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7896103896103897), (0.8, 0.3999999999999999, 0.774025974025974), (0.8, 0.3999999999999999, 0.7584415584415583), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7272727272727267), (0.8, 0.3999999999999999, 0.711688311688311), (0.8, 0.3999999999999999, 0.6961038961038959), (0.8, 0.3999999999999999, 0.6805194805194801), (0.8, 0.3999999999999999, 0.6649350649350649), (0.8, 0.3999999999999999, 0.6493506493506491), (0.8, 0.3999999999999999, 0.6337662337662334), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.602597402597402), (0.8, 0.3999999999999999, 0.5870129870129863), (0.8, 0.3999999999999999, 0.5714285714285711), (0.8, 0.3999999999999999, 0.5558441558441554), (0.8, 0.3999999999999999, 0.5402597402597401), (0.8, 0.3999999999999999, 0.5246753246753244), (0.8, 0.3999999999999999, 0.5090909090909087), (0.8, 0.3999999999999999, 0.49350649350649295), (0.8, 0.3999999999999999, 0.4779220779220772), (0.8, 0.3999999999999999, 0.4623376623376615), (0.8, 0.3999999999999999, 0.4467532467532463), (0.8, 0.3999999999999999, 0.4311688311688306), (0.8, 0.3999999999999999, 0.4155844155844154)],
    155: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41548387096774164, 0.3999999999999999), (0.8, 0.4309677419354839, 0.3999999999999999), (0.8, 0.4464516129032256, 0.3999999999999999), (0.8, 0.46193548387096783, 0.3999999999999999), (0.8, 0.47741935483870956, 0.3999999999999999), (0.8, 0.4929032258064518, 0.3999999999999999), (0.8, 0.5083870967741935, 0.3999999999999999), (0.8, 0.5238709677419352, 0.3999999999999999), (0.8, 0.5393548387096775, 0.3999999999999999), (0.8, 0.5548387096774192, 0.3999999999999999), (0.8, 0.5703225806451614, 0.3999999999999999), (0.8, 0.5858064516129031, 0.3999999999999999), (0.8, 0.6012903225806454, 0.3999999999999999), (0.8, 0.6167741935483871, 0.3999999999999999), (0.8, 0.6322580645161289, 0.3999999999999999), (0.8, 0.647741935483871, 0.3999999999999999), (0.8, 0.6632258064516128, 0.3999999999999999), (0.8, 0.6787096774193551, 0.3999999999999999), (0.8, 0.6941935483870967, 0.3999999999999999), (0.8, 0.7096774193548385, 0.3999999999999999), (0.8, 0.7251612903225807, 0.3999999999999999), (0.8, 0.7406451612903224, 0.3999999999999999), (0.8, 0.7561290322580647, 0.3999999999999999), (0.8, 0.7716129032258063, 0.3999999999999999), (0.8, 0.7870967741935486, 0.3999999999999999), (0.7974193548387098, 0.8, 0.3999999999999999), (0.7819354838709676, 0.8, 0.3999999999999999), (0.7664516129032259, 0.8, 0.3999999999999999), (0.7509677419354841, 0.8, 0.3999999999999999), (0.7354838709677419, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7045161290322579, 0.8, 0.3999999999999999), (0.6890322580645163, 0.8, 0.3999999999999999), (0.6735483870967746, 0.8, 0.3999999999999999), (0.6580645161290323, 0.8, 0.3999999999999999), (0.6425806451612905, 0.8, 0.3999999999999999), (0.6270967741935484, 0.8, 0.3999999999999999), (0.6116129032258066, 0.8, 0.3999999999999999), (0.5961290322580649, 0.8, 0.3999999999999999), (0.5806451612903226, 0.8, 0.3999999999999999), (0.5651612903225804, 0.8, 0.3999999999999999), (0.5496774193548387, 0.8, 0.3999999999999999), (0.534193548387097, 0.8, 0.3999999999999999), (0.5187096774193547, 0.8, 0.3999999999999999), (0.5032258064516131, 0.8, 0.3999999999999999), (0.4877419354838708, 0.8, 0.3999999999999999), (0.47225806451612906, 0.8, 0.3999999999999999), (0.45677419354838733, 0.8, 0.3999999999999999), (0.4412903225806451, 0.8, 0.3999999999999999), (0.42580645161290337, 0.8, 0.3999999999999999), (0.41032258064516114, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4051612903225805), (0.3999999999999999, 0.8, 0.42064516129032226), (0.3999999999999999, 0.8, 0.4361290322580645), (0.3999999999999999, 0.8, 0.4516129032258067), (0.3999999999999999, 0.8, 0.46709677419354845), (0.3999999999999999, 0.8, 0.4825806451612902), (0.3999999999999999, 0.8, 0.4980645161290324), (0.3999999999999999, 0.8, 0.5135483870967741), (0.3999999999999999, 0.8, 0.5290322580645164), (0.3999999999999999, 0.8, 0.5445161290322581), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.575483870967742), (0.3999999999999999, 0.8, 0.5909677419354837), (0.3999999999999999, 0.8, 0.606451612903226), (0.3999999999999999, 0.8, 0.6219354838709678), (0.3999999999999999, 0.8, 0.6374193548387095), (0.3999999999999999, 0.8, 0.6529032258064517), (0.3999999999999999, 0.8, 0.668387096774194), (0.3999999999999999, 0.8, 0.6838709677419357), (0.3999999999999999, 0.8, 0.6993548387096773), (0.3999999999999999, 0.8, 0.7148387096774196), (0.3999999999999999, 0.8, 0.7303225806451613), (0.3999999999999999, 0.8, 0.7458064516129035), (0.3999999999999999, 0.8, 0.7612903225806453), (0.3999999999999999, 0.8, 0.776774193548387), (0.3999999999999999, 0.8, 0.7922580645161292), (0.3999999999999999, 0.792258064516129, 0.8), (0.3999999999999999, 0.776774193548387, 0.8), (0.3999999999999999, 0.7612903225806451, 0.8), (0.3999999999999999, 0.7458064516129035, 0.8), (0.3999999999999999, 0.7303225806451612, 0.8), (0.3999999999999999, 0.7148387096774189, 0.8), (0.3999999999999999, 0.6993548387096773, 0.8), (0.3999999999999999, 0.6838709677419355, 0.8), (0.3999999999999999, 0.6683870967741938, 0.8), (0.3999999999999999, 0.6529032258064515, 0.8), (0.3999999999999999, 0.6374193548387093, 0.8), (0.3999999999999999, 0.6219354838709676, 0.8), (0.3999999999999999, 0.6064516129032259, 0.8), (0.3999999999999999, 0.5909677419354842, 0.8), (0.3999999999999999, 0.5754838709677419, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.544516129032258, 0.8), (0.3999999999999999, 0.5290322580645163, 0.8), (0.3999999999999999, 0.513548387096774, 0.8), (0.3999999999999999, 0.49806451612903174, 0.8), (0.3999999999999999, 0.48258064516129, 0.8), (0.3999999999999999, 0.46709677419354834, 0.8), (0.3999999999999999, 0.4516129032258066, 0.8), (0.3999999999999999, 0.4361290322580644, 0.8), (0.3999999999999999, 0.4206451612903221, 0.8), (0.3999999999999999, 0.4051612903225804, 0.8), (0.41032258064516086, 0.3999999999999999, 0.8), (0.4258064516129026, 0.3999999999999999, 0.8), (0.4412903225806448, 0.3999999999999999, 0.8), (0.4567741935483871, 0.3999999999999999, 0.8), (0.4722580645161288, 0.3999999999999999, 0.8), (0.4877419354838705, 0.3999999999999999, 0.8), (0.5032258064516127, 0.3999999999999999, 0.8), (0.518709677419355, 0.3999999999999999, 0.8), (0.5341935483870968, 0.3999999999999999, 0.8), (0.5496774193548384, 0.3999999999999999, 0.8), (0.5651612903225801, 0.3999999999999999, 0.8), (0.5806451612903224, 0.3999999999999999, 0.8), (0.5961290322580647, 0.3999999999999999, 0.8), (0.6116129032258063, 0.3999999999999999, 0.8), (0.627096774193548, 0.3999999999999999, 0.8), (0.6425806451612898, 0.3999999999999999, 0.8), (0.658064516129032, 0.3999999999999999, 0.8), (0.6735483870967742, 0.3999999999999999, 0.8), (0.6890322580645161, 0.3999999999999999, 0.8), (0.7045161290322577, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7354838709677416, 0.3999999999999999, 0.8), (0.7509677419354839, 0.3999999999999999, 0.8), (0.7664516129032256, 0.3999999999999999, 0.8), (0.7819354838709673, 0.3999999999999999, 0.8), (0.7974193548387096, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7870967741935477), (0.8, 0.3999999999999999, 0.7716129032258061), (0.8, 0.3999999999999999, 0.7561290322580644), (0.8, 0.3999999999999999, 0.7406451612903227), (0.8, 0.3999999999999999, 0.7251612903225804), (0.8, 0.3999999999999999, 0.7096774193548382), (0.8, 0.3999999999999999, 0.6941935483870965), (0.8, 0.3999999999999999, 0.6787096774193548), (0.8, 0.3999999999999999, 0.6632258064516126), (0.8, 0.3999999999999999, 0.6477419354838708), (0.8, 0.3999999999999999, 0.6322580645161285), (0.8, 0.3999999999999999, 0.6167741935483868), (0.8, 0.3999999999999999, 0.6012903225806451), (0.8, 0.3999999999999999, 0.5858064516129029), (0.8, 0.3999999999999999, 0.5703225806451606), (0.8, 0.3999999999999999, 0.5548387096774189), (0.8, 0.3999999999999999, 0.5393548387096772), (0.8, 0.3999999999999999, 0.5238709677419355), (0.8, 0.3999999999999999, 0.5083870967741932), (0.8, 0.3999999999999999, 0.49290322580645096), (0.8, 0.3999999999999999, 0.4774193548387093), (0.8, 0.3999999999999999, 0.46193548387096756), (0.8, 0.3999999999999999, 0.4464516129032259), (0.8, 0.3999999999999999, 0.4309677419354836), (0.8, 0.3999999999999999, 0.41548387096774136)],
    156: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41538461538461524, 0.3999999999999999), (0.8, 0.43076923076923057, 0.3999999999999999), (0.8, 0.4461538461538459, 0.3999999999999999), (0.8, 0.46153846153846123, 0.3999999999999999), (0.8, 0.47692307692307656, 0.3999999999999999), (0.8, 0.49230769230769245, 0.3999999999999999), (0.8, 0.5076923076923078, 0.3999999999999999), (0.8, 0.5230769230769231, 0.3999999999999999), (0.8, 0.5384615384615384, 0.3999999999999999), (0.8, 0.5538461538461538, 0.3999999999999999), (0.8, 0.5692307692307691, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6153846153846152, 0.3999999999999999), (0.8, 0.630769230769231, 0.3999999999999999), (0.8, 0.6461538461538463, 0.3999999999999999), (0.8, 0.6615384615384616, 0.3999999999999999), (0.8, 0.676923076923077, 0.3999999999999999), (0.8, 0.6923076923076923, 0.3999999999999999), (0.8, 0.7076923076923076, 0.3999999999999999), (0.8, 0.723076923076923, 0.3999999999999999), (0.8, 0.7384615384615383, 0.3999999999999999), (0.8, 0.7538461538461536, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.8, 0.7846153846153843, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7846153846153847, 0.8, 0.3999999999999999), (0.7692307692307693, 0.8, 0.3999999999999999), (0.7538461538461539, 0.8, 0.3999999999999999), (0.7384615384615386, 0.8, 0.3999999999999999), (0.7230769230769233, 0.8, 0.3999999999999999), (0.707692307692308, 0.8, 0.3999999999999999), (0.6923076923076926, 0.8, 0.3999999999999999), (0.6769230769230767, 0.8, 0.3999999999999999), (0.6615384615384614, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.6307692307692307, 0.8, 0.3999999999999999), (0.6153846153846154, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5846153846153848, 0.8, 0.3999999999999999), (0.5692307692307694, 0.8, 0.3999999999999999), (0.5538461538461541, 0.8, 0.3999999999999999), (0.5384615384615388, 0.8, 0.3999999999999999), (0.5230769230769234, 0.8, 0.3999999999999999), (0.5076923076923081, 0.8, 0.3999999999999999), (0.4923076923076922, 0.8, 0.3999999999999999), (0.47692307692307684, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.4461538461538462, 0.8, 0.3999999999999999), (0.43076923076923085, 0.8, 0.3999999999999999), (0.4153846153846155, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41538461538461563), (0.3999999999999999, 0.8, 0.43076923076923096), (0.3999999999999999, 0.8, 0.44615384615384635), (0.3999999999999999, 0.8, 0.4615384615384617), (0.3999999999999999, 0.8, 0.476923076923077), (0.3999999999999999, 0.8, 0.49230769230769234), (0.3999999999999999, 0.8, 0.5076923076923077), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.5384615384615383), (0.3999999999999999, 0.8, 0.5538461538461537), (0.3999999999999999, 0.8, 0.569230769230769), (0.3999999999999999, 0.8, 0.5846153846153843), (0.3999999999999999, 0.8, 0.5999999999999996), (0.3999999999999999, 0.8, 0.6153846153846155), (0.3999999999999999, 0.8, 0.6307692307692309), (0.3999999999999999, 0.8, 0.6461538461538462), (0.3999999999999999, 0.8, 0.6615384615384615), (0.3999999999999999, 0.8, 0.676923076923077), (0.3999999999999999, 0.8, 0.6923076923076923), (0.3999999999999999, 0.8, 0.7076923076923076), (0.3999999999999999, 0.8, 0.7230769230769234), (0.3999999999999999, 0.8, 0.7384615384615387), (0.3999999999999999, 0.8, 0.753846153846154), (0.3999999999999999, 0.8, 0.7692307692307694), (0.3999999999999999, 0.8, 0.7846153846153847), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7846153846153847, 0.8), (0.3999999999999999, 0.7692307692307693, 0.8), (0.3999999999999999, 0.7538461538461539, 0.8), (0.3999999999999999, 0.7384615384615386, 0.8), (0.3999999999999999, 0.7230769230769233, 0.8), (0.3999999999999999, 0.707692307692308, 0.8), (0.3999999999999999, 0.6923076923076926, 0.8), (0.3999999999999999, 0.6769230769230773, 0.8), (0.3999999999999999, 0.6615384615384614, 0.8), (0.3999999999999999, 0.6461538461538461, 0.8), (0.3999999999999999, 0.6307692307692307, 0.8), (0.3999999999999999, 0.6153846153846154, 0.8), (0.3999999999999999, 0.6000000000000001, 0.8), (0.3999999999999999, 0.5846153846153842, 0.8), (0.3999999999999999, 0.5692307692307689, 0.8), (0.3999999999999999, 0.5538461538461535, 0.8), (0.3999999999999999, 0.5384615384615382, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.5076923076923076, 0.8), (0.3999999999999999, 0.4923076923076922, 0.8), (0.3999999999999999, 0.47692307692307684, 0.8), (0.3999999999999999, 0.4615384615384615, 0.8), (0.3999999999999999, 0.4461538461538462, 0.8), (0.3999999999999999, 0.43076923076923085, 0.8), (0.3999999999999999, 0.4153846153846155, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4153846153846147, 0.3999999999999999, 0.8), (0.43076923076923057, 0.3999999999999999, 0.8), (0.4461538461538459, 0.3999999999999999, 0.8), (0.46153846153846123, 0.3999999999999999, 0.8), (0.47692307692307656, 0.3999999999999999, 0.8), (0.4923076923076919, 0.3999999999999999, 0.8), (0.5076923076923078, 0.3999999999999999, 0.8), (0.5230769230769231, 0.3999999999999999, 0.8), (0.5384615384615384, 0.3999999999999999, 0.8), (0.5538461538461538, 0.3999999999999999, 0.8), (0.5692307692307691, 0.3999999999999999, 0.8), (0.5846153846153845, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6153846153846152, 0.3999999999999999, 0.8), (0.6307692307692305, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.6615384615384612, 0.3999999999999999, 0.8), (0.6769230769230765, 0.3999999999999999, 0.8), (0.6923076923076918, 0.3999999999999999, 0.8), (0.7076923076923072, 0.3999999999999999, 0.8), (0.7230769230769225, 0.3999999999999999, 0.8), (0.7384615384615383, 0.3999999999999999, 0.8), (0.7538461538461536, 0.3999999999999999, 0.8), (0.769230769230769, 0.3999999999999999, 0.8), (0.7846153846153843, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.784615384615384), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7538461538461534), (0.8, 0.3999999999999999, 0.7384615384615381), (0.8, 0.3999999999999999, 0.7230769230769227), (0.8, 0.3999999999999999, 0.7076923076923074), (0.8, 0.3999999999999999, 0.6923076923076921), (0.8, 0.3999999999999999, 0.6769230769230767), (0.8, 0.3999999999999999, 0.6615384615384614), (0.8, 0.3999999999999999, 0.6461538461538461), (0.8, 0.3999999999999999, 0.6307692307692307), (0.8, 0.3999999999999999, 0.6153846153846154), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5846153846153848), (0.8, 0.3999999999999999, 0.5692307692307694), (0.8, 0.3999999999999999, 0.5538461538461535), (0.8, 0.3999999999999999, 0.5384615384615382), (0.8, 0.3999999999999999, 0.5230769230769229), (0.8, 0.3999999999999999, 0.5076923076923076), (0.8, 0.3999999999999999, 0.4923076923076922), (0.8, 0.3999999999999999, 0.47692307692307634), (0.8, 0.3999999999999999, 0.461538461538461), (0.8, 0.3999999999999999, 0.4461538461538457), (0.8, 0.3999999999999999, 0.4307692307692303), (0.8, 0.3999999999999999, 0.41538461538461496)],
    157: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41528662420382156, 0.3999999999999999), (0.8, 0.4305732484076432, 0.3999999999999999), (0.8, 0.44585987261146487, 0.3999999999999999), (0.8, 0.4611464968152865, 0.3999999999999999), (0.8, 0.4764331210191082, 0.3999999999999999), (0.8, 0.4917197452229298, 0.3999999999999999), (0.8, 0.5070063694267515, 0.3999999999999999), (0.8, 0.5222929936305731, 0.3999999999999999), (0.8, 0.5375796178343948, 0.3999999999999999), (0.8, 0.5528662420382164, 0.3999999999999999), (0.8, 0.5681528662420381, 0.3999999999999999), (0.8, 0.5834394904458597, 0.3999999999999999), (0.8, 0.5987261146496815, 0.3999999999999999), (0.8, 0.6140127388535032, 0.3999999999999999), (0.8, 0.6292993630573248, 0.3999999999999999), (0.8, 0.6445859872611465, 0.3999999999999999), (0.8, 0.6598726114649681, 0.3999999999999999), (0.8, 0.6751592356687898, 0.3999999999999999), (0.8, 0.6904458598726114, 0.3999999999999999), (0.8, 0.7057324840764331, 0.3999999999999999), (0.8, 0.7210191082802547, 0.3999999999999999), (0.8, 0.7363057324840764, 0.3999999999999999), (0.8, 0.751592356687898, 0.3999999999999999), (0.8, 0.7668789808917197, 0.3999999999999999), (0.8, 0.7821656050955414, 0.3999999999999999), (0.8, 0.7974522292993631, 0.3999999999999999), (0.7872611464968156, 0.8, 0.3999999999999999), (0.7719745222929939, 0.8, 0.3999999999999999), (0.7566878980891723, 0.8, 0.3999999999999999), (0.7414012738853506, 0.8, 0.3999999999999999), (0.726114649681529, 0.8, 0.3999999999999999), (0.7108280254777073, 0.8, 0.3999999999999999), (0.6955414012738856, 0.8, 0.3999999999999999), (0.680254777070064, 0.8, 0.3999999999999999), (0.6649681528662423, 0.8, 0.3999999999999999), (0.6496815286624206, 0.8, 0.3999999999999999), (0.6343949044585989, 0.8, 0.3999999999999999), (0.6191082802547773, 0.8, 0.3999999999999999), (0.6038216560509556, 0.8, 0.3999999999999999), (0.588535031847134, 0.8, 0.3999999999999999), (0.5732484076433123, 0.8, 0.3999999999999999), (0.5579617834394907, 0.8, 0.3999999999999999), (0.542675159235669, 0.8, 0.3999999999999999), (0.5273885350318473, 0.8, 0.3999999999999999), (0.5121019108280257, 0.8, 0.3999999999999999), (0.496815286624204, 0.8, 0.3999999999999999), (0.48152866242038234, 0.8, 0.3999999999999999), (0.4662420382165607, 0.8, 0.3999999999999999), (0.45095541401273853, 0.8, 0.3999999999999999), (0.4356687898089174, 0.8, 0.3999999999999999), (0.42038216560509517, 0.8, 0.3999999999999999), (0.4050955414012741, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41019108280254807), (0.3999999999999999, 0.8, 0.4254777070063692), (0.3999999999999999, 0.8, 0.4407643312101914), (0.3999999999999999, 0.8, 0.4560509554140125), (0.3999999999999999, 0.8, 0.47133757961783473), (0.3999999999999999, 0.8, 0.48662420382165583), (0.3999999999999999, 0.8, 0.501910828025478), (0.3999999999999999, 0.8, 0.5171974522292991), (0.3999999999999999, 0.8, 0.5324840764331213), (0.3999999999999999, 0.8, 0.5477707006369424), (0.3999999999999999, 0.8, 0.5630573248407647), (0.3999999999999999, 0.8, 0.5783439490445857), (0.3999999999999999, 0.8, 0.593630573248408), (0.3999999999999999, 0.8, 0.608917197452229), (0.3999999999999999, 0.8, 0.6242038216560513), (0.3999999999999999, 0.8, 0.6394904458598725), (0.3999999999999999, 0.8, 0.6547770700636946), (0.3999999999999999, 0.8, 0.6700636942675158), (0.3999999999999999, 0.8, 0.6853503184713379), (0.3999999999999999, 0.8, 0.7006369426751591), (0.3999999999999999, 0.8, 0.7159235668789812), (0.3999999999999999, 0.8, 0.7312101910828024), (0.3999999999999999, 0.8, 0.7464968152866245), (0.3999999999999999, 0.8, 0.7617834394904457), (0.3999999999999999, 0.8, 0.7770700636942678), (0.3999999999999999, 0.8, 0.792356687898089), (0.3999999999999999, 0.7923566878980888, 0.8), (0.3999999999999999, 0.7770700636942678, 0.8), (0.3999999999999999, 0.7617834394904455, 0.8), (0.3999999999999999, 0.7464968152866245, 0.8), (0.3999999999999999, 0.7312101910828022, 0.8), (0.3999999999999999, 0.7159235668789812, 0.8), (0.3999999999999999, 0.7006369426751589, 0.8), (0.3999999999999999, 0.6853503184713379, 0.8), (0.3999999999999999, 0.6700636942675156, 0.8), (0.3999999999999999, 0.6547770700636945, 0.8), (0.3999999999999999, 0.6394904458598722, 0.8), (0.3999999999999999, 0.6242038216560511, 0.8), (0.3999999999999999, 0.6089171974522289, 0.8), (0.3999999999999999, 0.5936305732484078, 0.8), (0.3999999999999999, 0.5783439490445856, 0.8), (0.3999999999999999, 0.5630573248407645, 0.8), (0.3999999999999999, 0.5477707006369423, 0.8), (0.3999999999999999, 0.5324840764331207, 0.8), (0.3999999999999999, 0.517197452229299, 0.8), (0.3999999999999999, 0.5019108280254774, 0.8), (0.3999999999999999, 0.4866242038216557, 0.8), (0.3999999999999999, 0.47133757961783407, 0.8), (0.3999999999999999, 0.4560509554140124, 0.8), (0.3999999999999999, 0.4407643312101907, 0.8), (0.3999999999999999, 0.42547770700636905, 0.8), (0.3999999999999999, 0.4101910828025474, 0.8), (0.4050955414012738, 0.3999999999999999, 0.8), (0.42038216560509545, 0.3999999999999999, 0.8), (0.4356687898089171, 0.3999999999999999, 0.8), (0.45095541401273875, 0.3999999999999999, 0.8), (0.4662420382165604, 0.3999999999999999, 0.8), (0.48152866242038206, 0.3999999999999999, 0.8), (0.49681528662420377, 0.3999999999999999, 0.8), (0.5121019108280254, 0.3999999999999999, 0.8), (0.527388535031847, 0.3999999999999999, 0.8), (0.5426751592356687, 0.3999999999999999, 0.8), (0.5579617834394903, 0.3999999999999999, 0.8), (0.573248407643312, 0.3999999999999999, 0.8), (0.5885350318471337, 0.3999999999999999, 0.8), (0.6038216560509554, 0.3999999999999999, 0.8), (0.619108280254777, 0.3999999999999999, 0.8), (0.6343949044585987, 0.3999999999999999, 0.8), (0.6496815286624203, 0.3999999999999999, 0.8), (0.664968152866242, 0.3999999999999999, 0.8), (0.6802547770700637, 0.3999999999999999, 0.8), (0.6955414012738853, 0.3999999999999999, 0.8), (0.710828025477707, 0.3999999999999999, 0.8), (0.7261146496815286, 0.3999999999999999, 0.8), (0.7414012738853503, 0.3999999999999999, 0.8), (0.7566878980891719, 0.3999999999999999, 0.8), (0.7719745222929936, 0.3999999999999999, 0.8), (0.7872611464968153, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7974522292993627), (0.8, 0.3999999999999999, 0.782165605095541), (0.8, 0.3999999999999999, 0.7668789808917195), (0.8, 0.3999999999999999, 0.7515923566878977), (0.8, 0.3999999999999999, 0.736305732484076), (0.8, 0.3999999999999999, 0.7210191082802544), (0.8, 0.3999999999999999, 0.7057324840764327), (0.8, 0.3999999999999999, 0.6904458598726111), (0.8, 0.3999999999999999, 0.6751592356687894), (0.8, 0.3999999999999999, 0.6598726114649678), (0.8, 0.3999999999999999, 0.6445859872611461), (0.8, 0.3999999999999999, 0.6292993630573245), (0.8, 0.3999999999999999, 0.6140127388535028), (0.8, 0.3999999999999999, 0.5987261146496812), (0.8, 0.3999999999999999, 0.5834394904458595), (0.8, 0.3999999999999999, 0.5681528662420379), (0.8, 0.3999999999999999, 0.5528662420382162), (0.8, 0.3999999999999999, 0.5375796178343946), (0.8, 0.3999999999999999, 0.5222929936305729), (0.8, 0.3999999999999999, 0.5070063694267513), (0.8, 0.3999999999999999, 0.4917197452229296), (0.8, 0.3999999999999999, 0.47643312101910795), (0.8, 0.3999999999999999, 0.4611464968152863), (0.8, 0.3999999999999999, 0.44585987261146465), (0.8, 0.3999999999999999, 0.43057324840764294), (0.8, 0.3999999999999999, 0.4152866242038213)],
    158: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4151898734177215, 0.3999999999999999), (0.8, 0.4303797468354431, 0.3999999999999999), (0.8, 0.4455696202531647, 0.3999999999999999), (0.8, 0.4607594936708858, 0.3999999999999999), (0.8, 0.4759493670886074, 0.3999999999999999), (0.8, 0.491139240506329, 0.3999999999999999), (0.8, 0.5063291139240507, 0.3999999999999999), (0.8, 0.5215189873417723, 0.3999999999999999), (0.8, 0.5367088607594939, 0.3999999999999999), (0.8, 0.5518987341772149, 0.3999999999999999), (0.8, 0.5670886075949365, 0.3999999999999999), (0.8, 0.5822784810126581, 0.3999999999999999), (0.8, 0.5974683544303797, 0.3999999999999999), (0.8, 0.6126582278481013, 0.3999999999999999), (0.8, 0.6278481012658229, 0.3999999999999999), (0.8, 0.6430379746835445, 0.3999999999999999), (0.8, 0.6582278481012656, 0.3999999999999999), (0.8, 0.6734177215189872, 0.3999999999999999), (0.8, 0.6886075949367088, 0.3999999999999999), (0.8, 0.7037974683544304, 0.3999999999999999), (0.8, 0.718987341772152, 0.3999999999999999), (0.8, 0.7341772151898736, 0.3999999999999999), (0.8, 0.7493670886075947, 0.3999999999999999), (0.8, 0.7645569620253163, 0.3999999999999999), (0.8, 0.7797468354430379, 0.3999999999999999), (0.8, 0.7949367088607595, 0.3999999999999999), (0.789873417721519, 0.8, 0.3999999999999999), (0.7746835443037975, 0.8, 0.3999999999999999), (0.7594936708860758, 0.8, 0.3999999999999999), (0.7443037974683548, 0.8, 0.3999999999999999), (0.7291139240506332, 0.8, 0.3999999999999999), (0.7139240506329116, 0.8, 0.3999999999999999), (0.69873417721519, 0.8, 0.3999999999999999), (0.6835443037974684, 0.8, 0.3999999999999999), (0.6683544303797468, 0.8, 0.3999999999999999), (0.6531645569620257, 0.8, 0.3999999999999999), (0.6379746835443041, 0.8, 0.3999999999999999), (0.6227848101265825, 0.8, 0.3999999999999999), (0.6075949367088609, 0.8, 0.3999999999999999), (0.5924050632911393, 0.8, 0.3999999999999999), (0.5772151898734177, 0.8, 0.3999999999999999), (0.5620253164556961, 0.8, 0.3999999999999999), (0.5468354430379745, 0.8, 0.3999999999999999), (0.5316455696202533, 0.8, 0.3999999999999999), (0.5164556962025317, 0.8, 0.3999999999999999), (0.5012658227848101, 0.8, 0.3999999999999999), (0.48607594936708853, 0.8, 0.3999999999999999), (0.47088607594936693, 0.8, 0.3999999999999999), (0.4556962025316459, 0.8, 0.3999999999999999), (0.4405063291139243, 0.8, 0.3999999999999999), (0.4253164556962027, 0.8, 0.3999999999999999), (0.4101265822784811, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4050632911392405), (0.3999999999999999, 0.8, 0.4202531645569621), (0.3999999999999999, 0.8, 0.4354430379746837), (0.3999999999999999, 0.8, 0.4506329113924053), (0.3999999999999999, 0.8, 0.4658227848101264), (0.3999999999999999, 0.8, 0.481012658227848), (0.3999999999999999, 0.8, 0.4962025316455696), (0.3999999999999999, 0.8, 0.5113924050632912), (0.3999999999999999, 0.8, 0.5265822784810128), (0.3999999999999999, 0.8, 0.5417721518987338), (0.3999999999999999, 0.8, 0.5569620253164554), (0.3999999999999999, 0.8, 0.572151898734177), (0.3999999999999999, 0.8, 0.5873417721518988), (0.3999999999999999, 0.8, 0.6025316455696202), (0.3999999999999999, 0.8, 0.617721518987342), (0.3999999999999999, 0.8, 0.6329113924050636), (0.3999999999999999, 0.8, 0.6481012658227852), (0.3999999999999999, 0.8, 0.6632911392405062), (0.3999999999999999, 0.8, 0.6784810126582278), (0.3999999999999999, 0.8, 0.6936708860759494), (0.3999999999999999, 0.8, 0.708860759493671), (0.3999999999999999, 0.8, 0.7240506329113926), (0.3999999999999999, 0.8, 0.7392405063291136), (0.3999999999999999, 0.8, 0.7544303797468352), (0.3999999999999999, 0.8, 0.7696202531645568), (0.3999999999999999, 0.8, 0.7848101265822784), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7848101265822784, 0.8), (0.3999999999999999, 0.7696202531645567, 0.8), (0.3999999999999999, 0.7544303797468351, 0.8), (0.3999999999999999, 0.7392405063291135, 0.8), (0.3999999999999999, 0.7240506329113925, 0.8), (0.3999999999999999, 0.7088607594936709, 0.8), (0.3999999999999999, 0.6936708860759493, 0.8), (0.3999999999999999, 0.6784810126582281, 0.8), (0.3999999999999999, 0.6632911392405065, 0.8), (0.3999999999999999, 0.6481012658227849, 0.8), (0.3999999999999999, 0.6329113924050633, 0.8), (0.3999999999999999, 0.6177215189873417, 0.8), (0.3999999999999999, 0.6025316455696201, 0.8), (0.3999999999999999, 0.5873417721518985, 0.8), (0.3999999999999999, 0.5721518987341769, 0.8), (0.3999999999999999, 0.5569620253164553, 0.8), (0.3999999999999999, 0.5417721518987337, 0.8), (0.3999999999999999, 0.5265822784810127, 0.8), (0.3999999999999999, 0.5113924050632911, 0.8), (0.3999999999999999, 0.49620253164556943, 0.8), (0.3999999999999999, 0.48101265822784783, 0.8), (0.3999999999999999, 0.4658227848101268, 0.8), (0.3999999999999999, 0.4506329113924052, 0.8), (0.3999999999999999, 0.4354430379746836, 0.8), (0.3999999999999999, 0.42025316455696193, 0.8), (0.3999999999999999, 0.40506329113924033, 0.8), (0.4101265822784808, 0.3999999999999999, 0.8), (0.4253164556962024, 0.3999999999999999, 0.8), (0.440506329113924, 0.3999999999999999, 0.8), (0.4556962025316456, 0.3999999999999999, 0.8), (0.4708860759493667, 0.3999999999999999, 0.8), (0.4860759493670883, 0.3999999999999999, 0.8), (0.5012658227848099, 0.3999999999999999, 0.8), (0.5164556962025315, 0.3999999999999999, 0.8), (0.5316455696202526, 0.3999999999999999, 0.8), (0.5468354430379742, 0.3999999999999999, 0.8), (0.5620253164556958, 0.3999999999999999, 0.8), (0.5772151898734174, 0.3999999999999999, 0.8), (0.592405063291139, 0.3999999999999999, 0.8), (0.6075949367088606, 0.3999999999999999, 0.8), (0.6227848101265823, 0.3999999999999999, 0.8), (0.6379746835443039, 0.3999999999999999, 0.8), (0.6531645569620255, 0.3999999999999999, 0.8), (0.6683544303797471, 0.3999999999999999, 0.8), (0.6835443037974681, 0.3999999999999999, 0.8), (0.6987341772151897, 0.3999999999999999, 0.8), (0.7139240506329113, 0.3999999999999999, 0.8), (0.7291139240506324, 0.3999999999999999, 0.8), (0.744303797468354, 0.3999999999999999, 0.8), (0.7594936708860756, 0.3999999999999999, 0.8), (0.7746835443037972, 0.3999999999999999, 0.8), (0.7898734177215188, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7949367088607593), (0.8, 0.3999999999999999, 0.7797468354430377), (0.8, 0.3999999999999999, 0.7645569620253161), (0.8, 0.3999999999999999, 0.7493670886075945), (0.8, 0.3999999999999999, 0.7341772151898729), (0.8, 0.3999999999999999, 0.7189873417721517), (0.8, 0.3999999999999999, 0.7037974683544301), (0.8, 0.3999999999999999, 0.6886075949367085), (0.8, 0.3999999999999999, 0.6734177215189875), (0.8, 0.3999999999999999, 0.6582278481012659), (0.8, 0.3999999999999999, 0.6430379746835443), (0.8, 0.3999999999999999, 0.6278481012658227), (0.8, 0.3999999999999999, 0.6126582278481011), (0.8, 0.3999999999999999, 0.5974683544303795), (0.8, 0.3999999999999999, 0.5822784810126578), (0.8, 0.3999999999999999, 0.5670886075949362), (0.8, 0.3999999999999999, 0.5518987341772146), (0.8, 0.3999999999999999, 0.536708860759493), (0.8, 0.3999999999999999, 0.5215189873417719), (0.8, 0.3999999999999999, 0.5063291139240503), (0.8, 0.3999999999999999, 0.49113924050632873), (0.8, 0.3999999999999999, 0.4759493670886077), (0.8, 0.3999999999999999, 0.4607594936708861), (0.8, 0.3999999999999999, 0.4455696202531645), (0.8, 0.3999999999999999, 0.43037974683544283), (0.8, 0.3999999999999999, 0.41518987341772123)],
    159: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4150943396226414, 0.3999999999999999), (0.8, 0.4301886792452829, 0.3999999999999999), (0.8, 0.44528301886792443, 0.3999999999999999), (0.8, 0.46037735849056594, 0.3999999999999999), (0.8, 0.47547169811320744, 0.3999999999999999), (0.8, 0.49056603773584895, 0.3999999999999999), (0.8, 0.5056603773584905, 0.3999999999999999), (0.8, 0.520754716981132, 0.3999999999999999), (0.8, 0.5358490566037735, 0.3999999999999999), (0.8, 0.550943396226415, 0.3999999999999999), (0.8, 0.5660377358490565, 0.3999999999999999), (0.8, 0.581132075471698, 0.3999999999999999), (0.8, 0.5962264150943396, 0.3999999999999999), (0.8, 0.6113207547169811, 0.3999999999999999), (0.8, 0.6264150943396226, 0.3999999999999999), (0.8, 0.6415094339622641, 0.3999999999999999), (0.8, 0.6566037735849056, 0.3999999999999999), (0.8, 0.6716981132075471, 0.3999999999999999), (0.8, 0.6867924528301886, 0.3999999999999999), (0.8, 0.7018867924528301, 0.3999999999999999), (0.8, 0.7169811320754716, 0.3999999999999999), (0.8, 0.7320754716981132, 0.3999999999999999), (0.8, 0.7471698113207547, 0.3999999999999999), (0.8, 0.7622641509433962, 0.3999999999999999), (0.8, 0.7773584905660378, 0.3999999999999999), (0.8, 0.7924528301886793, 0.3999999999999999), (0.7924528301886795, 0.8, 0.3999999999999999), (0.777358490566038, 0.8, 0.3999999999999999), (0.7622641509433965, 0.8, 0.3999999999999999), (0.747169811320755, 0.8, 0.3999999999999999), (0.7320754716981135, 0.8, 0.3999999999999999), (0.716981132075472, 0.8, 0.3999999999999999), (0.7018867924528305, 0.8, 0.3999999999999999), (0.686792452830189, 0.8, 0.3999999999999999), (0.6716981132075475, 0.8, 0.3999999999999999), (0.6566037735849058, 0.8, 0.3999999999999999), (0.6415094339622643, 0.8, 0.3999999999999999), (0.6264150943396228, 0.8, 0.3999999999999999), (0.6113207547169813, 0.8, 0.3999999999999999), (0.5962264150943398, 0.8, 0.3999999999999999), (0.5811320754716983, 0.8, 0.3999999999999999), (0.5660377358490568, 0.8, 0.3999999999999999), (0.5509433962264153, 0.8, 0.3999999999999999), (0.5358490566037738, 0.8, 0.3999999999999999), (0.5207547169811323, 0.8, 0.3999999999999999), (0.5056603773584908, 0.8, 0.3999999999999999), (0.4905660377358492, 0.8, 0.3999999999999999), (0.4754716981132077, 0.8, 0.3999999999999999), (0.4603773584905657, 0.8, 0.3999999999999999), (0.4452830188679247, 0.8, 0.3999999999999999), (0.43018867924528265, 0.8, 0.3999999999999999), (0.4150943396226417, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.4150943396226413), (0.3999999999999999, 0.8, 0.4301886792452833), (0.3999999999999999, 0.8, 0.4452830188679243), (0.3999999999999999, 0.8, 0.4603773584905664), (0.3999999999999999, 0.8, 0.47547169811320733), (0.3999999999999999, 0.8, 0.4905660377358494), (0.3999999999999999, 0.8, 0.5056603773584903), (0.3999999999999999, 0.8, 0.5207547169811324), (0.3999999999999999, 0.8, 0.5358490566037734), (0.3999999999999999, 0.8, 0.5509433962264154), (0.3999999999999999, 0.8, 0.5660377358490564), (0.3999999999999999, 0.8, 0.5811320754716984), (0.3999999999999999, 0.8, 0.5962264150943394), (0.3999999999999999, 0.8, 0.6113207547169814), (0.3999999999999999, 0.8, 0.6264150943396225), (0.3999999999999999, 0.8, 0.6415094339622645), (0.3999999999999999, 0.8, 0.6566037735849055), (0.3999999999999999, 0.8, 0.6716981132075475), (0.3999999999999999, 0.8, 0.6867924528301885), (0.3999999999999999, 0.8, 0.7018867924528305), (0.3999999999999999, 0.8, 0.7169811320754715), (0.3999999999999999, 0.8, 0.7320754716981135), (0.3999999999999999, 0.8, 0.7471698113207546), (0.3999999999999999, 0.8, 0.7622641509433965), (0.3999999999999999, 0.8, 0.7773584905660376), (0.3999999999999999, 0.8, 0.7924528301886795), (0.3999999999999999, 0.7924528301886795, 0.8), (0.3999999999999999, 0.7773584905660373, 0.8), (0.3999999999999999, 0.7622641509433965, 0.8), (0.3999999999999999, 0.7471698113207543, 0.8), (0.3999999999999999, 0.7320754716981135, 0.8), (0.3999999999999999, 0.7169811320754713, 0.8), (0.3999999999999999, 0.7018867924528305, 0.8), (0.3999999999999999, 0.6867924528301883, 0.8), (0.3999999999999999, 0.6716981132075475, 0.8), (0.3999999999999999, 0.6566037735849053, 0.8), (0.3999999999999999, 0.6415094339622643, 0.8), (0.3999999999999999, 0.6264150943396223, 0.8), (0.3999999999999999, 0.6113207547169813, 0.8), (0.3999999999999999, 0.5962264150943393, 0.8), (0.3999999999999999, 0.5811320754716983, 0.8), (0.3999999999999999, 0.5660377358490563, 0.8), (0.3999999999999999, 0.5509433962264147, 0.8), (0.3999999999999999, 0.5358490566037732, 0.8), (0.3999999999999999, 0.5207547169811317, 0.8), (0.3999999999999999, 0.5056603773584902, 0.8), (0.3999999999999999, 0.4905660377358487, 0.8), (0.3999999999999999, 0.4754716981132072, 0.8), (0.3999999999999999, 0.4603773584905657, 0.8), (0.3999999999999999, 0.4452830188679242, 0.8), (0.3999999999999999, 0.43018867924528265, 0.8), (0.3999999999999999, 0.41509433962264114, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.4150943396226414, 0.3999999999999999, 0.8), (0.4301886792452829, 0.3999999999999999, 0.8), (0.44528301886792443, 0.3999999999999999, 0.8), (0.46037735849056594, 0.3999999999999999, 0.8), (0.47547169811320744, 0.3999999999999999, 0.8), (0.49056603773584895, 0.3999999999999999, 0.8), (0.5056603773584905, 0.3999999999999999, 0.8), (0.520754716981132, 0.3999999999999999, 0.8), (0.5358490566037735, 0.3999999999999999, 0.8), (0.550943396226415, 0.3999999999999999, 0.8), (0.5660377358490565, 0.3999999999999999, 0.8), (0.581132075471698, 0.3999999999999999, 0.8), (0.5962264150943396, 0.3999999999999999, 0.8), (0.6113207547169811, 0.3999999999999999, 0.8), (0.6264150943396226, 0.3999999999999999, 0.8), (0.6415094339622641, 0.3999999999999999, 0.8), (0.6566037735849056, 0.3999999999999999, 0.8), (0.6716981132075471, 0.3999999999999999, 0.8), (0.6867924528301886, 0.3999999999999999, 0.8), (0.7018867924528301, 0.3999999999999999, 0.8), (0.7169811320754716, 0.3999999999999999, 0.8), (0.7320754716981132, 0.3999999999999999, 0.8), (0.7471698113207547, 0.3999999999999999, 0.8), (0.7622641509433962, 0.3999999999999999, 0.8), (0.7773584905660378, 0.3999999999999999, 0.8), (0.7924528301886793, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7924528301886788), (0.8, 0.3999999999999999, 0.7773584905660373), (0.8, 0.3999999999999999, 0.7622641509433958), (0.8, 0.3999999999999999, 0.7471698113207543), (0.8, 0.3999999999999999, 0.7320754716981128), (0.8, 0.3999999999999999, 0.7169811320754713), (0.8, 0.3999999999999999, 0.7018867924528298), (0.8, 0.3999999999999999, 0.6867924528301883), (0.8, 0.3999999999999999, 0.6716981132075468), (0.8, 0.3999999999999999, 0.6566037735849053), (0.8, 0.3999999999999999, 0.6415094339622638), (0.8, 0.3999999999999999, 0.6264150943396223), (0.8, 0.3999999999999999, 0.6113207547169808), (0.8, 0.3999999999999999, 0.5962264150943393), (0.8, 0.3999999999999999, 0.5811320754716978), (0.8, 0.3999999999999999, 0.5660377358490563), (0.8, 0.3999999999999999, 0.5509433962264147), (0.8, 0.3999999999999999, 0.5358490566037732), (0.8, 0.3999999999999999, 0.5207547169811317), (0.8, 0.3999999999999999, 0.5056603773584902), (0.8, 0.3999999999999999, 0.4905660377358487), (0.8, 0.3999999999999999, 0.4754716981132072), (0.8, 0.3999999999999999, 0.4603773584905657), (0.8, 0.3999999999999999, 0.4452830188679242), (0.8, 0.3999999999999999, 0.43018867924528265), (0.8, 0.3999999999999999, 0.41509433962264114)],
    160: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41500000000000015, 0.3999999999999999), (0.8, 0.4299999999999998, 0.3999999999999999), (0.8, 0.44500000000000006, 0.3999999999999999), (0.8, 0.45999999999999974, 0.3999999999999999), (0.8, 0.4749999999999999, 0.3999999999999999), (0.8, 0.49000000000000016, 0.3999999999999999), (0.8, 0.5049999999999999, 0.3999999999999999), (0.8, 0.52, 0.3999999999999999), (0.8, 0.5349999999999997, 0.3999999999999999), (0.8, 0.5499999999999999, 0.3999999999999999), (0.8, 0.5650000000000002, 0.3999999999999999), (0.8, 0.5799999999999998, 0.3999999999999999), (0.8, 0.5950000000000001, 0.3999999999999999), (0.8, 0.6099999999999998, 0.3999999999999999), (0.8, 0.625, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6549999999999999, 0.3999999999999999), (0.8, 0.6700000000000002, 0.3999999999999999), (0.8, 0.6849999999999998, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7150000000000003, 0.3999999999999999), (0.8, 0.73, 0.3999999999999999), (0.8, 0.7450000000000001, 0.3999999999999999), (0.8, 0.7599999999999998, 0.3999999999999999), (0.8, 0.7750000000000001, 0.3999999999999999), (0.8, 0.7900000000000003, 0.3999999999999999), (0.7950000000000002, 0.8, 0.3999999999999999), (0.78, 0.8, 0.3999999999999999), (0.7650000000000003, 0.8, 0.3999999999999999), (0.7500000000000001, 0.8, 0.3999999999999999), (0.7349999999999999, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7050000000000001, 0.8, 0.3999999999999999), (0.6900000000000004, 0.8, 0.3999999999999999), (0.675, 0.8, 0.3999999999999999), (0.6599999999999999, 0.8, 0.3999999999999999), (0.6450000000000002, 0.8, 0.3999999999999999), (0.63, 0.8, 0.3999999999999999), (0.6150000000000003, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5849999999999999, 0.8, 0.3999999999999999), (0.5700000000000002, 0.8, 0.3999999999999999), (0.5549999999999999, 0.8, 0.3999999999999999), (0.5400000000000003, 0.8, 0.3999999999999999), (0.525, 0.8, 0.3999999999999999), (0.5099999999999998, 0.8, 0.3999999999999999), (0.49500000000000016, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.46500000000000025, 0.8, 0.3999999999999999), (0.45, 0.8, 0.3999999999999999), (0.4349999999999998, 0.8, 0.3999999999999999), (0.4200000000000001, 0.8, 0.3999999999999999), (0.4049999999999999, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40999999999999975), (0.3999999999999999, 0.8, 0.42499999999999993), (0.3999999999999999, 0.8, 0.44000000000000017), (0.3999999999999999, 0.8, 0.45499999999999985), (0.3999999999999999, 0.8, 0.4700000000000001), (0.3999999999999999, 0.8, 0.48499999999999976), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5150000000000002), (0.3999999999999999, 0.8, 0.5299999999999999), (0.3999999999999999, 0.8, 0.5450000000000002), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.575), (0.3999999999999999, 0.8, 0.5900000000000002), (0.3999999999999999, 0.8, 0.6049999999999999), (0.3999999999999999, 0.8, 0.6200000000000001), (0.3999999999999999, 0.8, 0.6349999999999998), (0.3999999999999999, 0.8, 0.65), (0.3999999999999999, 0.8, 0.6650000000000003), (0.3999999999999999, 0.8, 0.6799999999999999), (0.3999999999999999, 0.8, 0.6950000000000002), (0.3999999999999999, 0.8, 0.7099999999999999), (0.3999999999999999, 0.8, 0.7250000000000001), (0.3999999999999999, 0.8, 0.7400000000000002), (0.3999999999999999, 0.8, 0.7549999999999999), (0.3999999999999999, 0.8, 0.7700000000000002), (0.3999999999999999, 0.8, 0.7849999999999999), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7849999999999997, 0.8), (0.3999999999999999, 0.7699999999999996, 0.8), (0.3999999999999999, 0.7549999999999999, 0.8), (0.3999999999999999, 0.7400000000000002, 0.8), (0.3999999999999999, 0.7249999999999999, 0.8), (0.3999999999999999, 0.7099999999999997, 0.8), (0.3999999999999999, 0.6949999999999995, 0.8), (0.3999999999999999, 0.6799999999999998, 0.8), (0.3999999999999999, 0.6650000000000001, 0.8), (0.3999999999999999, 0.6499999999999999, 0.8), (0.3999999999999999, 0.6349999999999997, 0.8), (0.3999999999999999, 0.6199999999999994, 0.8), (0.3999999999999999, 0.6049999999999998, 0.8), (0.3999999999999999, 0.5900000000000001, 0.8), (0.3999999999999999, 0.5749999999999998, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5449999999999995, 0.8), (0.3999999999999999, 0.5299999999999998, 0.8), (0.3999999999999999, 0.5150000000000001, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.48499999999999965, 0.8), (0.3999999999999999, 0.4699999999999994, 0.8), (0.3999999999999999, 0.45499999999999974, 0.8), (0.3999999999999999, 0.44000000000000006, 0.8), (0.3999999999999999, 0.4249999999999998, 0.8), (0.3999999999999999, 0.4099999999999996, 0.8), (0.40500000000000014, 0.3999999999999999, 0.8), (0.4199999999999998, 0.3999999999999999, 0.8), (0.43499999999999955, 0.3999999999999999, 0.8), (0.44999999999999973, 0.3999999999999999, 0.8), (0.46499999999999997, 0.3999999999999999, 0.8), (0.4800000000000002, 0.3999999999999999, 0.8), (0.4949999999999999, 0.3999999999999999, 0.8), (0.5099999999999996, 0.3999999999999999, 0.8), (0.5249999999999998, 0.3999999999999999, 0.8), (0.54, 0.3999999999999999, 0.8), (0.5550000000000002, 0.3999999999999999, 0.8), (0.5699999999999998, 0.3999999999999999, 0.8), (0.5849999999999995, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.615, 0.3999999999999999, 0.8), (0.6300000000000002, 0.3999999999999999, 0.8), (0.6449999999999999, 0.3999999999999999, 0.8), (0.6599999999999996, 0.3999999999999999, 0.8), (0.6749999999999998, 0.3999999999999999, 0.8), (0.6900000000000001, 0.3999999999999999, 0.8), (0.7050000000000003, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7349999999999997, 0.3999999999999999, 0.8), (0.7499999999999998, 0.3999999999999999, 0.8), (0.7650000000000001, 0.3999999999999999, 0.8), (0.7800000000000002, 0.3999999999999999, 0.8), (0.7949999999999999, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.79), (0.8, 0.3999999999999999, 0.7749999999999998), (0.8, 0.3999999999999999, 0.7599999999999996), (0.8, 0.3999999999999999, 0.7449999999999993), (0.8, 0.3999999999999999, 0.7299999999999996), (0.8, 0.3999999999999999, 0.715), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6849999999999996), (0.8, 0.3999999999999999, 0.6699999999999993), (0.8, 0.3999999999999999, 0.6549999999999996), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6249999999999998), (0.8, 0.3999999999999999, 0.6099999999999995), (0.8, 0.3999999999999999, 0.5949999999999993), (0.8, 0.3999999999999999, 0.5799999999999996), (0.8, 0.3999999999999999, 0.565), (0.8, 0.3999999999999999, 0.5499999999999997), (0.8, 0.3999999999999999, 0.5349999999999995), (0.8, 0.3999999999999999, 0.5199999999999992), (0.8, 0.3999999999999999, 0.5049999999999996), (0.8, 0.3999999999999999, 0.4899999999999999), (0.8, 0.3999999999999999, 0.47499999999999964), (0.8, 0.3999999999999999, 0.45999999999999946), (0.8, 0.3999999999999999, 0.44499999999999923), (0.8, 0.3999999999999999, 0.42999999999999955), (0.8, 0.3999999999999999, 0.41499999999999987)],
    161: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4149068322981363, 0.3999999999999999), (0.8, 0.4298136645962733, 0.3999999999999999), (0.8, 0.4447204968944097, 0.3999999999999999), (0.8, 0.4596273291925466, 0.3999999999999999), (0.8, 0.47453416149068306, 0.3999999999999999), (0.8, 0.48944099378882, 0.3999999999999999), (0.8, 0.5043478260869564, 0.3999999999999999), (0.8, 0.5192546583850933, 0.3999999999999999), (0.8, 0.5341614906832297, 0.3999999999999999), (0.8, 0.5490683229813662, 0.3999999999999999), (0.8, 0.5639751552795031, 0.3999999999999999), (0.8, 0.5788819875776395, 0.3999999999999999), (0.8, 0.5937888198757765, 0.3999999999999999), (0.8, 0.6086956521739129, 0.3999999999999999), (0.8, 0.6236024844720498, 0.3999999999999999), (0.8, 0.6385093167701863, 0.3999999999999999), (0.8, 0.6534161490683232, 0.3999999999999999), (0.8, 0.6683229813664596, 0.3999999999999999), (0.8, 0.683229813664596, 0.3999999999999999), (0.8, 0.698136645962733, 0.3999999999999999), (0.8, 0.7130434782608694, 0.3999999999999999), (0.8, 0.7279503105590064, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7577639751552796, 0.3999999999999999), (0.8, 0.7726708074534161, 0.3999999999999999), (0.8, 0.787577639751553, 0.3999999999999999), (0.7975155279503108, 0.8, 0.3999999999999999), (0.7826086956521743, 0.8, 0.3999999999999999), (0.7677018633540373, 0.8, 0.3999999999999999), (0.752795031055901, 0.8, 0.3999999999999999), (0.737888198757764, 0.8, 0.3999999999999999), (0.7229813664596276, 0.8, 0.3999999999999999), (0.7080745341614907, 0.8, 0.3999999999999999), (0.6931677018633542, 0.8, 0.3999999999999999), (0.6782608695652173, 0.8, 0.3999999999999999), (0.663354037267081, 0.8, 0.3999999999999999), (0.6484472049689445, 0.8, 0.3999999999999999), (0.6335403726708075, 0.8, 0.3999999999999999), (0.6186335403726712, 0.8, 0.3999999999999999), (0.6037267080745342, 0.8, 0.3999999999999999), (0.5888198757763977, 0.8, 0.3999999999999999), (0.5739130434782608, 0.8, 0.3999999999999999), (0.5590062111801244, 0.8, 0.3999999999999999), (0.5440993788819874, 0.8, 0.3999999999999999), (0.5291925465838511, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.4993788819875777, 0.8, 0.3999999999999999), (0.48447204968944074, 0.8, 0.3999999999999999), (0.4695652173913043, 0.8, 0.3999999999999999), (0.4546583850931679, 0.8, 0.3999999999999999), (0.439751552795031, 0.8, 0.3999999999999999), (0.42484472049689453, 0.8, 0.3999999999999999), (0.4099378881987576, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4049689440993788), (0.3999999999999999, 0.8, 0.41987577639751517), (0.3999999999999999, 0.8, 0.4347826086956521), (0.3999999999999999, 0.8, 0.44968944099378905), (0.3999999999999999, 0.8, 0.4645962732919255), (0.3999999999999999, 0.8, 0.4795031055900619), (0.3999999999999999, 0.8, 0.4944099378881988), (0.3999999999999999, 0.8, 0.5093167701863353), (0.3999999999999999, 0.8, 0.5242236024844722), (0.3999999999999999, 0.8, 0.5391304347826086), (0.3999999999999999, 0.8, 0.554037267080745), (0.3999999999999999, 0.8, 0.5689440993788819), (0.3999999999999999, 0.8, 0.5838509316770188), (0.3999999999999999, 0.8, 0.5987577639751553), (0.3999999999999999, 0.8, 0.6136645962732917), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.643478260869565), (0.3999999999999999, 0.8, 0.658385093167702), (0.3999999999999999, 0.8, 0.6732919254658385), (0.3999999999999999, 0.8, 0.6881987577639749), (0.3999999999999999, 0.8, 0.7031055900621118), (0.3999999999999999, 0.8, 0.7180124223602488), (0.3999999999999999, 0.8, 0.7329192546583851), (0.3999999999999999, 0.8, 0.7478260869565216), (0.3999999999999999, 0.8, 0.7627329192546586), (0.3999999999999999, 0.8, 0.7776397515527949), (0.3999999999999999, 0.8, 0.7925465838509318), (0.3999999999999999, 0.7925465838509318, 0.8), (0.3999999999999999, 0.7776397515527953, 0.8), (0.3999999999999999, 0.7627329192546584, 0.8), (0.3999999999999999, 0.7478260869565214, 0.8), (0.3999999999999999, 0.732919254658385, 0.8), (0.3999999999999999, 0.7180124223602486, 0.8), (0.3999999999999999, 0.7031055900621122, 0.8), (0.3999999999999999, 0.6881987577639752, 0.8), (0.3999999999999999, 0.6732919254658383, 0.8), (0.3999999999999999, 0.6583850931677019, 0.8), (0.3999999999999999, 0.6434782608695655, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6136645962732916, 0.8), (0.3999999999999999, 0.5987577639751552, 0.8), (0.3999999999999999, 0.5838509316770188, 0.8), (0.3999999999999999, 0.5689440993788818, 0.8), (0.3999999999999999, 0.5540372670807454, 0.8), (0.3999999999999999, 0.5391304347826085, 0.8), (0.3999999999999999, 0.5242236024844721, 0.8), (0.3999999999999999, 0.5093167701863357, 0.8), (0.3999999999999999, 0.4944099378881987, 0.8), (0.3999999999999999, 0.47950310559006176, 0.8), (0.3999999999999999, 0.4645962732919253, 0.8), (0.3999999999999999, 0.44968944099378894, 0.8), (0.3999999999999999, 0.434782608695652, 0.8), (0.3999999999999999, 0.41987577639751555, 0.8), (0.3999999999999999, 0.4049689440993786, 0.8), (0.4099378881987573, 0.3999999999999999, 0.8), (0.42484472049689376, 0.3999999999999999, 0.8), (0.4397515527950307, 0.3999999999999999, 0.8), (0.45465838509316764, 0.3999999999999999, 0.8), (0.4695652173913041, 0.3999999999999999, 0.8), (0.48447204968944046, 0.3999999999999999, 0.8), (0.4993788819875774, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5291925465838507, 0.3999999999999999, 0.8), (0.5440993788819872, 0.3999999999999999, 0.8), (0.5590062111801236, 0.3999999999999999, 0.8), (0.5739130434782606, 0.3999999999999999, 0.8), (0.5888198757763975, 0.3999999999999999, 0.8), (0.6037267080745339, 0.3999999999999999, 0.8), (0.6186335403726704, 0.3999999999999999, 0.8), (0.6335403726708073, 0.3999999999999999, 0.8), (0.6484472049689437, 0.3999999999999999, 0.8), (0.6633540372670806, 0.3999999999999999, 0.8), (0.678260869565217, 0.3999999999999999, 0.8), (0.6931677018633535, 0.3999999999999999, 0.8), (0.7080745341614905, 0.3999999999999999, 0.8), (0.7229813664596274, 0.3999999999999999, 0.8), (0.7378881987577637, 0.3999999999999999, 0.8), (0.7527950310559002, 0.3999999999999999, 0.8), (0.7677018633540371, 0.3999999999999999, 0.8), (0.7826086956521736, 0.3999999999999999, 0.8), (0.7975155279503106, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7875776397515528), (0.8, 0.3999999999999999, 0.7726708074534163), (0.8, 0.3999999999999999, 0.7577639751552794), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.727950310559006), (0.8, 0.3999999999999999, 0.7130434782608697), (0.8, 0.3999999999999999, 0.6981366459627327), (0.8, 0.3999999999999999, 0.6832298136645962), (0.8, 0.3999999999999999, 0.6683229813664593), (0.8, 0.3999999999999999, 0.6534161490683229), (0.8, 0.3999999999999999, 0.6385093167701865), (0.8, 0.3999999999999999, 0.6236024844720496), (0.8, 0.3999999999999999, 0.6086956521739126), (0.8, 0.3999999999999999, 0.5937888198757763), (0.8, 0.3999999999999999, 0.5788819875776398), (0.8, 0.3999999999999999, 0.5639751552795028), (0.8, 0.3999999999999999, 0.5490683229813664), (0.8, 0.3999999999999999, 0.5341614906832295), (0.8, 0.3999999999999999, 0.5192546583850931), (0.8, 0.3999999999999999, 0.5043478260869567), (0.8, 0.3999999999999999, 0.4894409937888197), (0.8, 0.3999999999999999, 0.4745341614906828), (0.8, 0.3999999999999999, 0.45962732919254634), (0.8, 0.3999999999999999, 0.44472049689440996), (0.8, 0.3999999999999999, 0.429813664596273), (0.8, 0.3999999999999999, 0.4149068322981366)],
    162: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4148148148148148, 0.3999999999999999), (0.8, 0.4296296296296297, 0.3999999999999999), (0.8, 0.4444444444444446, 0.3999999999999999), (0.8, 0.4592592592592595, 0.3999999999999999), (0.8, 0.4740740740740738, 0.3999999999999999), (0.8, 0.4888888888888887, 0.3999999999999999), (0.8, 0.5037037037037035, 0.3999999999999999), (0.8, 0.5185185185185185, 0.3999999999999999), (0.8, 0.5333333333333333, 0.3999999999999999), (0.8, 0.5481481481481483, 0.3999999999999999), (0.8, 0.5629629629629631, 0.3999999999999999), (0.8, 0.5777777777777775, 0.3999999999999999), (0.8, 0.5925925925925923, 0.3999999999999999), (0.8, 0.6074074074074073, 0.3999999999999999), (0.8, 0.6222222222222221, 0.3999999999999999), (0.8, 0.6370370370370371, 0.3999999999999999), (0.8, 0.6518518518518519, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6814814814814817, 0.3999999999999999), (0.8, 0.6962962962962966, 0.3999999999999999), (0.8, 0.7111111111111109, 0.3999999999999999), (0.8, 0.7259259259259259, 0.3999999999999999), (0.8, 0.7407407407407407, 0.3999999999999999), (0.8, 0.7555555555555555, 0.3999999999999999), (0.8, 0.7703703703703705, 0.3999999999999999), (0.8, 0.7851851851851854, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7851851851851857, 0.8, 0.3999999999999999), (0.7703703703703707, 0.8, 0.3999999999999999), (0.7555555555555558, 0.8, 0.3999999999999999), (0.7407407407407409, 0.8, 0.3999999999999999), (0.7259259259259261, 0.8, 0.3999999999999999), (0.7111111111111112, 0.8, 0.3999999999999999), (0.6962962962962963, 0.8, 0.3999999999999999), (0.6814814814814814, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6518518518518521, 0.8, 0.3999999999999999), (0.6370370370370373, 0.8, 0.3999999999999999), (0.6222222222222225, 0.8, 0.3999999999999999), (0.6074074074074075, 0.8, 0.3999999999999999), (0.5925925925925927, 0.8, 0.3999999999999999), (0.5777777777777777, 0.8, 0.3999999999999999), (0.5629629629629633, 0.8, 0.3999999999999999), (0.5481481481481485, 0.8, 0.3999999999999999), (0.5333333333333337, 0.8, 0.3999999999999999), (0.5185185185185187, 0.8, 0.3999999999999999), (0.5037037037037039, 0.8, 0.3999999999999999), (0.48888888888888893, 0.8, 0.3999999999999999), (0.4740740740740741, 0.8, 0.3999999999999999), (0.4592592592592592, 0.8, 0.3999999999999999), (0.4444444444444443, 0.8, 0.3999999999999999), (0.4296296296296294, 0.8, 0.3999999999999999), (0.4148148148148145, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41481481481481464), (0.3999999999999999, 0.8, 0.42962962962962953), (0.3999999999999999, 0.8, 0.4444444444444444), (0.3999999999999999, 0.8, 0.4592592592592593), (0.3999999999999999, 0.8, 0.47407407407407365), (0.3999999999999999, 0.8, 0.48888888888888854), (0.3999999999999999, 0.8, 0.5037037037037034), (0.3999999999999999, 0.8, 0.5185185185185184), (0.3999999999999999, 0.8, 0.5333333333333332), (0.3999999999999999, 0.8, 0.548148148148148), (0.3999999999999999, 0.8, 0.562962962962963), (0.3999999999999999, 0.8, 0.5777777777777778), (0.3999999999999999, 0.8, 0.5925925925925928), (0.3999999999999999, 0.8, 0.6074074074074076), (0.3999999999999999, 0.8, 0.6222222222222226), (0.3999999999999999, 0.8, 0.6370370370370368), (0.3999999999999999, 0.8, 0.6518518518518518), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6814814814814816), (0.3999999999999999, 0.8, 0.6962962962962964), (0.3999999999999999, 0.8, 0.7111111111111108), (0.3999999999999999, 0.8, 0.7259259259259256), (0.3999999999999999, 0.8, 0.7407407407407405), (0.3999999999999999, 0.8, 0.7555555555555554), (0.3999999999999999, 0.8, 0.7703703703703704), (0.3999999999999999, 0.8, 0.7851851851851852), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.785185185185185, 0.8), (0.3999999999999999, 0.7703703703703701, 0.8), (0.3999999999999999, 0.7555555555555553, 0.8), (0.3999999999999999, 0.7407407407407405, 0.8), (0.3999999999999999, 0.7259259259259261, 0.8), (0.3999999999999999, 0.7111111111111112, 0.8), (0.3999999999999999, 0.6962962962962963, 0.8), (0.3999999999999999, 0.6814814814814814, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6518518518518521, 0.8), (0.3999999999999999, 0.6370370370370373, 0.8), (0.3999999999999999, 0.6222222222222225, 0.8), (0.3999999999999999, 0.6074074074074075, 0.8), (0.3999999999999999, 0.5925925925925927, 0.8), (0.3999999999999999, 0.5777777777777777, 0.8), (0.3999999999999999, 0.5629629629629629, 0.8), (0.3999999999999999, 0.5481481481481479, 0.8), (0.3999999999999999, 0.5333333333333331, 0.8), (0.3999999999999999, 0.5185185185185182, 0.8), (0.3999999999999999, 0.5037037037037033, 0.8), (0.3999999999999999, 0.48888888888888893, 0.8), (0.3999999999999999, 0.4740740740740741, 0.8), (0.3999999999999999, 0.4592592592592592, 0.8), (0.3999999999999999, 0.4444444444444443, 0.8), (0.3999999999999999, 0.4296296296296294, 0.8), (0.3999999999999999, 0.4148148148148151, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41481481481481425, 0.3999999999999999, 0.8), (0.42962962962962914, 0.3999999999999999, 0.8), (0.44444444444444403, 0.3999999999999999, 0.8), (0.4592592592592589, 0.3999999999999999, 0.8), (0.4740740740740738, 0.3999999999999999, 0.8), (0.4888888888888887, 0.3999999999999999, 0.8), (0.5037037037037035, 0.3999999999999999, 0.8), (0.5185185185185185, 0.3999999999999999, 0.8), (0.5333333333333333, 0.3999999999999999, 0.8), (0.5481481481481477, 0.3999999999999999, 0.8), (0.5629629629629626, 0.3999999999999999, 0.8), (0.5777777777777775, 0.3999999999999999, 0.8), (0.5925925925925923, 0.3999999999999999, 0.8), (0.6074074074074073, 0.3999999999999999, 0.8), (0.6222222222222216, 0.3999999999999999, 0.8), (0.6370370370370365, 0.3999999999999999, 0.8), (0.6518518518518513, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6814814814814811, 0.3999999999999999, 0.8), (0.696296296296296, 0.3999999999999999, 0.8), (0.7111111111111109, 0.3999999999999999, 0.8), (0.7259259259259259, 0.3999999999999999, 0.8), (0.7407407407407407, 0.3999999999999999, 0.8), (0.7555555555555555, 0.3999999999999999, 0.8), (0.7703703703703705, 0.3999999999999999, 0.8), (0.7851851851851848, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.785185185185185), (0.8, 0.3999999999999999, 0.7703703703703701), (0.8, 0.3999999999999999, 0.7555555555555553), (0.8, 0.3999999999999999, 0.7407407407407409), (0.8, 0.3999999999999999, 0.7259259259259261), (0.8, 0.3999999999999999, 0.7111111111111112), (0.8, 0.3999999999999999, 0.6962962962962963), (0.8, 0.3999999999999999, 0.6814814814814814), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6518518518518517), (0.8, 0.3999999999999999, 0.6370370370370367), (0.8, 0.3999999999999999, 0.6222222222222219), (0.8, 0.3999999999999999, 0.607407407407407), (0.8, 0.3999999999999999, 0.5925925925925921), (0.8, 0.3999999999999999, 0.5777777777777777), (0.8, 0.3999999999999999, 0.5629629629629629), (0.8, 0.3999999999999999, 0.5481481481481479), (0.8, 0.3999999999999999, 0.5333333333333331), (0.8, 0.3999999999999999, 0.5185185185185182), (0.8, 0.3999999999999999, 0.5037037037037039), (0.8, 0.3999999999999999, 0.48888888888888893), (0.8, 0.3999999999999999, 0.4740740740740741), (0.8, 0.3999999999999999, 0.4592592592592592), (0.8, 0.3999999999999999, 0.4444444444444443), (0.8, 0.3999999999999999, 0.4296296296296294), (0.8, 0.3999999999999999, 0.4148148148148145)],
    163: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4147239263803679, 0.3999999999999999), (0.8, 0.42944785276073594, 0.3999999999999999), (0.8, 0.44417177914110395, 0.3999999999999999), (0.8, 0.4588957055214725, 0.3999999999999999), (0.8, 0.47361963190184053, 0.3999999999999999), (0.8, 0.48834355828220855, 0.3999999999999999), (0.8, 0.5030674846625766, 0.3999999999999999), (0.8, 0.5177914110429446, 0.3999999999999999), (0.8, 0.5325153374233126, 0.3999999999999999), (0.8, 0.5472392638036812, 0.3999999999999999), (0.8, 0.5619631901840492, 0.3999999999999999), (0.8, 0.5766871165644172, 0.3999999999999999), (0.8, 0.5914110429447852, 0.3999999999999999), (0.8, 0.6061349693251532, 0.3999999999999999), (0.8, 0.6208588957055212, 0.3999999999999999), (0.8, 0.6355828220858898, 0.3999999999999999), (0.8, 0.6503067484662578, 0.3999999999999999), (0.8, 0.6650306748466259, 0.3999999999999999), (0.8, 0.6797546012269939, 0.3999999999999999), (0.8, 0.694478527607362, 0.3999999999999999), (0.8, 0.70920245398773, 0.3999999999999999), (0.8, 0.7239263803680984, 0.3999999999999999), (0.8, 0.7386503067484664, 0.3999999999999999), (0.8, 0.7533742331288344, 0.3999999999999999), (0.8, 0.7680981595092025, 0.3999999999999999), (0.8, 0.7828220858895705, 0.3999999999999999), (0.8, 0.7975460122699385, 0.3999999999999999), (0.7877300613496936, 0.8, 0.3999999999999999), (0.7730061349693251, 0.8, 0.3999999999999999), (0.7582822085889571, 0.8, 0.3999999999999999), (0.7435582822085891, 0.8, 0.3999999999999999), (0.7288343558282211, 0.8, 0.3999999999999999), (0.7141104294478531, 0.8, 0.3999999999999999), (0.6993865030674844, 0.8, 0.3999999999999999), (0.6846625766871164, 0.8, 0.3999999999999999), (0.6699386503067484, 0.8, 0.3999999999999999), (0.6552147239263804, 0.8, 0.3999999999999999), (0.6404907975460123, 0.8, 0.3999999999999999), (0.6257668711656443, 0.8, 0.3999999999999999), (0.6110429447852763, 0.8, 0.3999999999999999), (0.5963190184049083, 0.8, 0.3999999999999999), (0.5815950920245399, 0.8, 0.3999999999999999), (0.5668711656441717, 0.8, 0.3999999999999999), (0.5521472392638037, 0.8, 0.3999999999999999), (0.5374233128834357, 0.8, 0.3999999999999999), (0.5226993865030677, 0.8, 0.3999999999999999), (0.5079754601226991, 0.8, 0.3999999999999999), (0.4932515337423311, 0.8, 0.3999999999999999), (0.4785276073619631, 0.8, 0.3999999999999999), (0.4638036809815951, 0.8, 0.3999999999999999), (0.44907975460122707, 0.8, 0.3999999999999999), (0.43435582822085905, 0.8, 0.3999999999999999), (0.41963190184049104, 0.8, 0.3999999999999999), (0.40490797546012247, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4098159509202455), (0.3999999999999999, 0.8, 0.4245398773006135), (0.3999999999999999, 0.8, 0.4392638036809815), (0.3999999999999999, 0.8, 0.4539877300613495), (0.3999999999999999, 0.8, 0.4687116564417181), (0.3999999999999999, 0.8, 0.4834355828220861), (0.3999999999999999, 0.8, 0.4981595092024541), (0.3999999999999999, 0.8, 0.5128834355828221), (0.3999999999999999, 0.8, 0.5276073619631901), (0.3999999999999999, 0.8, 0.5423312883435581), (0.3999999999999999, 0.8, 0.5570552147239262), (0.3999999999999999, 0.8, 0.5717791411042942), (0.3999999999999999, 0.8, 0.5865030674846627), (0.3999999999999999, 0.8, 0.6012269938650308), (0.3999999999999999, 0.8, 0.6159509202453988), (0.3999999999999999, 0.8, 0.6306748466257668), (0.3999999999999999, 0.8, 0.6453987730061348), (0.3999999999999999, 0.8, 0.6601226993865034), (0.3999999999999999, 0.8, 0.6748466257668715), (0.3999999999999999, 0.8, 0.6895705521472395), (0.3999999999999999, 0.8, 0.7042944785276075), (0.3999999999999999, 0.8, 0.7190184049079755), (0.3999999999999999, 0.8, 0.7337423312883435), (0.3999999999999999, 0.8, 0.7484662576687116), (0.3999999999999999, 0.8, 0.76319018404908), (0.3999999999999999, 0.8, 0.777914110429448), (0.3999999999999999, 0.8, 0.792638036809816), (0.3999999999999999, 0.792638036809816, 0.8), (0.3999999999999999, 0.7779141104294474, 0.8), (0.3999999999999999, 0.7631901840490793, 0.8), (0.3999999999999999, 0.7484662576687113, 0.8), (0.3999999999999999, 0.7337423312883433, 0.8), (0.3999999999999999, 0.7190184049079753, 0.8), (0.3999999999999999, 0.7042944785276073, 0.8), (0.3999999999999999, 0.6895705521472393, 0.8), (0.3999999999999999, 0.6748466257668713, 0.8), (0.3999999999999999, 0.6601226993865033, 0.8), (0.3999999999999999, 0.6453987730061352, 0.8), (0.3999999999999999, 0.6306748466257667, 0.8), (0.3999999999999999, 0.6159509202453987, 0.8), (0.3999999999999999, 0.6012269938650306, 0.8), (0.3999999999999999, 0.5865030674846621, 0.8), (0.3999999999999999, 0.5717791411042941, 0.8), (0.3999999999999999, 0.557055214723926, 0.8), (0.3999999999999999, 0.542331288343558, 0.8), (0.3999999999999999, 0.52760736196319, 0.8), (0.3999999999999999, 0.512883435582822, 0.8), (0.3999999999999999, 0.498159509202454, 0.8), (0.3999999999999999, 0.483435582822086, 0.8), (0.3999999999999999, 0.46871165644171797, 0.8), (0.3999999999999999, 0.4539877300613494, 0.8), (0.3999999999999999, 0.4392638036809814, 0.8), (0.3999999999999999, 0.4245398773006134, 0.8), (0.3999999999999999, 0.4098159509202448, 0.8), (0.40490797546012275, 0.3999999999999999, 0.8), (0.41963190184049076, 0.3999999999999999, 0.8), (0.4343558282208588, 0.3999999999999999, 0.8), (0.44907975460122684, 0.3999999999999999, 0.8), (0.46380368098159486, 0.3999999999999999, 0.8), (0.47852760736196287, 0.3999999999999999, 0.8), (0.4932515337423309, 0.3999999999999999, 0.8), (0.5079754601226989, 0.3999999999999999, 0.8), (0.5226993865030669, 0.3999999999999999, 0.8), (0.5374233128834355, 0.3999999999999999, 0.8), (0.5521472392638035, 0.3999999999999999, 0.8), (0.5668711656441715, 0.3999999999999999, 0.8), (0.5815950920245401, 0.3999999999999999, 0.8), (0.5963190184049081, 0.3999999999999999, 0.8), (0.6110429447852761, 0.3999999999999999, 0.8), (0.6257668711656441, 0.3999999999999999, 0.8), (0.6404907975460121, 0.3999999999999999, 0.8), (0.6552147239263801, 0.3999999999999999, 0.8), (0.6699386503067482, 0.3999999999999999, 0.8), (0.6846625766871162, 0.3999999999999999, 0.8), (0.6993865030674842, 0.3999999999999999, 0.8), (0.7141104294478527, 0.3999999999999999, 0.8), (0.7288343558282208, 0.3999999999999999, 0.8), (0.7435582822085888, 0.3999999999999999, 0.8), (0.7582822085889573, 0.3999999999999999, 0.8), (0.7730061349693254, 0.3999999999999999, 0.8), (0.7877300613496934, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7975460122699383), (0.8, 0.3999999999999999, 0.7828220858895703), (0.8, 0.3999999999999999, 0.7680981595092022), (0.8, 0.3999999999999999, 0.7533742331288342), (0.8, 0.3999999999999999, 0.7386503067484662), (0.8, 0.3999999999999999, 0.7239263803680982), (0.8, 0.3999999999999999, 0.7092024539877302), (0.8, 0.3999999999999999, 0.6944785276073616), (0.8, 0.3999999999999999, 0.6797546012269936), (0.8, 0.3999999999999999, 0.6650306748466256), (0.8, 0.3999999999999999, 0.650306748466257), (0.8, 0.3999999999999999, 0.635582822085889), (0.8, 0.3999999999999999, 0.620858895705521), (0.8, 0.3999999999999999, 0.606134969325153), (0.8, 0.3999999999999999, 0.591411042944785), (0.8, 0.3999999999999999, 0.576687116564417), (0.8, 0.3999999999999999, 0.5619631901840489), (0.8, 0.3999999999999999, 0.5472392638036809), (0.8, 0.3999999999999999, 0.5325153374233129), (0.8, 0.3999999999999999, 0.5177914110429443), (0.8, 0.3999999999999999, 0.5030674846625763), (0.8, 0.3999999999999999, 0.48834355828220827), (0.8, 0.3999999999999999, 0.47361963190183975), (0.8, 0.3999999999999999, 0.45889570552147174), (0.8, 0.3999999999999999, 0.44417177914110373), (0.8, 0.3999999999999999, 0.42944785276073566), (0.8, 0.3999999999999999, 0.41472392638036765)],
    164: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41463414634146334, 0.3999999999999999), (0.8, 0.42926829268292677, 0.3999999999999999), (0.8, 0.4439024390243902, 0.3999999999999999), (0.8, 0.4585365853658536, 0.3999999999999999), (0.8, 0.47317073170731705, 0.3999999999999999), (0.8, 0.4878048780487805, 0.3999999999999999), (0.8, 0.5024390243902439, 0.3999999999999999), (0.8, 0.5170731707317073, 0.3999999999999999), (0.8, 0.5317073170731708, 0.3999999999999999), (0.8, 0.5463414634146342, 0.3999999999999999), (0.8, 0.5609756097560976, 0.3999999999999999), (0.8, 0.575609756097561, 0.3999999999999999), (0.8, 0.5902439024390246, 0.3999999999999999), (0.8, 0.604878048780488, 0.3999999999999999), (0.8, 0.6195121951219514, 0.3999999999999999), (0.8, 0.6341463414634149, 0.3999999999999999), (0.8, 0.6487804878048783, 0.3999999999999999), (0.8, 0.6634146341463417, 0.3999999999999999), (0.8, 0.6780487804878051, 0.3999999999999999), (0.8, 0.6926829268292686, 0.3999999999999999), (0.8, 0.7073170731707314, 0.3999999999999999), (0.8, 0.7219512195121954, 0.3999999999999999), (0.8, 0.7365853658536583, 0.3999999999999999), (0.8, 0.7512195121951223, 0.3999999999999999), (0.8, 0.7658536585365852, 0.3999999999999999), (0.8, 0.7804878048780486, 0.3999999999999999), (0.8, 0.795121951219512, 0.3999999999999999), (0.7902439024390246, 0.8, 0.3999999999999999), (0.7756097560975612, 0.8, 0.3999999999999999), (0.7609756097560978, 0.8, 0.3999999999999999), (0.7463414634146344, 0.8, 0.3999999999999999), (0.7317073170731709, 0.8, 0.3999999999999999), (0.7170731707317075, 0.8, 0.3999999999999999), (0.7024390243902441, 0.8, 0.3999999999999999), (0.6878048780487807, 0.8, 0.3999999999999999), (0.6731707317073172, 0.8, 0.3999999999999999), (0.6585365853658538, 0.8, 0.3999999999999999), (0.6439024390243904, 0.8, 0.3999999999999999), (0.6292682926829269, 0.8, 0.3999999999999999), (0.6146341463414635, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5853658536585367, 0.8, 0.3999999999999999), (0.5707317073170732, 0.8, 0.3999999999999999), (0.5560975609756098, 0.8, 0.3999999999999999), (0.5414634146341464, 0.8, 0.3999999999999999), (0.526829268292683, 0.8, 0.3999999999999999), (0.5121951219512195, 0.8, 0.3999999999999999), (0.49756097560975604, 0.8, 0.3999999999999999), (0.4829268292682926, 0.8, 0.3999999999999999), (0.4682926829268292, 0.8, 0.3999999999999999), (0.45365853658536576, 0.8, 0.3999999999999999), (0.43902439024390233, 0.8, 0.3999999999999999), (0.42439024390243885, 0.8, 0.3999999999999999), (0.4097560975609754, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40487804878048794), (0.3999999999999999, 0.8, 0.41951219512195137), (0.3999999999999999, 0.8, 0.4341463414634148), (0.3999999999999999, 0.8, 0.4487804878048782), (0.3999999999999999, 0.8, 0.46341463414634165), (0.3999999999999999, 0.8, 0.4780487804878046), (0.3999999999999999, 0.8, 0.4926829268292685), (0.3999999999999999, 0.8, 0.5073170731707315), (0.3999999999999999, 0.8, 0.5219512195121954), (0.3999999999999999, 0.8, 0.5365853658536583), (0.3999999999999999, 0.8, 0.5512195121951222), (0.3999999999999999, 0.8, 0.5658536585365852), (0.3999999999999999, 0.8, 0.5804878048780491), (0.3999999999999999, 0.8, 0.5951219512195121), (0.3999999999999999, 0.8, 0.609756097560976), (0.3999999999999999, 0.8, 0.6243902439024389), (0.3999999999999999, 0.8, 0.6390243902439023), (0.3999999999999999, 0.8, 0.6536585365853658), (0.3999999999999999, 0.8, 0.6682926829268292), (0.3999999999999999, 0.8, 0.6829268292682926), (0.3999999999999999, 0.8, 0.697560975609756), (0.3999999999999999, 0.8, 0.7121951219512195), (0.3999999999999999, 0.8, 0.7268292682926829), (0.3999999999999999, 0.8, 0.7414634146341463), (0.3999999999999999, 0.8, 0.7560975609756098), (0.3999999999999999, 0.8, 0.7707317073170732), (0.3999999999999999, 0.8, 0.7853658536585366), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7853658536585366, 0.8), (0.3999999999999999, 0.7707317073170731, 0.8), (0.3999999999999999, 0.7560975609756097, 0.8), (0.3999999999999999, 0.7414634146341462, 0.8), (0.3999999999999999, 0.7268292682926828, 0.8), (0.3999999999999999, 0.7121951219512194, 0.8), (0.3999999999999999, 0.6975609756097559, 0.8), (0.3999999999999999, 0.6829268292682925, 0.8), (0.3999999999999999, 0.6682926829268291, 0.8), (0.3999999999999999, 0.6536585365853657, 0.8), (0.3999999999999999, 0.6390243902439022, 0.8), (0.3999999999999999, 0.6243902439024388, 0.8), (0.3999999999999999, 0.6097560975609754, 0.8), (0.3999999999999999, 0.595121951219512, 0.8), (0.3999999999999999, 0.580487804878049, 0.8), (0.3999999999999999, 0.565853658536585, 0.8), (0.3999999999999999, 0.5512195121951221, 0.8), (0.3999999999999999, 0.5365853658536581, 0.8), (0.3999999999999999, 0.5219512195121953, 0.8), (0.3999999999999999, 0.5073170731707313, 0.8), (0.3999999999999999, 0.4926829268292684, 0.8), (0.3999999999999999, 0.4780487804878044, 0.8), (0.3999999999999999, 0.46341463414634154, 0.8), (0.3999999999999999, 0.44878048780487756, 0.8), (0.3999999999999999, 0.4341463414634147, 0.8), (0.3999999999999999, 0.4195121951219507, 0.8), (0.3999999999999999, 0.40487804878048783, 0.8), (0.4097560975609757, 0.3999999999999999, 0.8), (0.4243902439024386, 0.3999999999999999, 0.8), (0.43902439024390255, 0.3999999999999999, 0.8), (0.4536585365853655, 0.3999999999999999, 0.8), (0.46829268292682946, 0.3999999999999999, 0.8), (0.48292682926829233, 0.3999999999999999, 0.8), (0.4975609756097563, 0.3999999999999999, 0.8), (0.5121951219512192, 0.3999999999999999, 0.8), (0.5268292682926826, 0.3999999999999999, 0.8), (0.541463414634146, 0.3999999999999999, 0.8), (0.5560975609756095, 0.3999999999999999, 0.8), (0.5707317073170729, 0.3999999999999999, 0.8), (0.5853658536585364, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6146341463414633, 0.3999999999999999, 0.8), (0.6292682926829267, 0.3999999999999999, 0.8), (0.6439024390243901, 0.3999999999999999, 0.8), (0.6585365853658536, 0.3999999999999999, 0.8), (0.673170731707317, 0.3999999999999999, 0.8), (0.6878048780487804, 0.3999999999999999, 0.8), (0.7024390243902439, 0.3999999999999999, 0.8), (0.7170731707317073, 0.3999999999999999, 0.8), (0.7317073170731707, 0.3999999999999999, 0.8), (0.7463414634146341, 0.3999999999999999, 0.8), (0.7609756097560976, 0.3999999999999999, 0.8), (0.775609756097561, 0.3999999999999999, 0.8), (0.7902439024390244, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7951219512195118), (0.8, 0.3999999999999999, 0.7804878048780484), (0.8, 0.3999999999999999, 0.7658536585365849), (0.8, 0.3999999999999999, 0.751219512195122), (0.8, 0.3999999999999999, 0.7365853658536581), (0.8, 0.3999999999999999, 0.7219512195121951), (0.8, 0.3999999999999999, 0.7073170731707312), (0.8, 0.3999999999999999, 0.6926829268292682), (0.8, 0.3999999999999999, 0.6780487804878044), (0.8, 0.3999999999999999, 0.6634146341463414), (0.8, 0.3999999999999999, 0.6487804878048775), (0.8, 0.3999999999999999, 0.6341463414634145), (0.8, 0.3999999999999999, 0.6195121951219507), (0.8, 0.3999999999999999, 0.6048780487804877), (0.8, 0.3999999999999999, 0.5902439024390237), (0.8, 0.3999999999999999, 0.5756097560975608), (0.8, 0.3999999999999999, 0.5609756097560968), (0.8, 0.3999999999999999, 0.546341463414634), (0.8, 0.3999999999999999, 0.53170731707317), (0.8, 0.3999999999999999, 0.5170731707317071), (0.8, 0.3999999999999999, 0.5024390243902431), (0.8, 0.3999999999999999, 0.48780487804878025), (0.8, 0.3999999999999999, 0.47317073170731627), (0.8, 0.3999999999999999, 0.4585365853658534), (0.8, 0.3999999999999999, 0.44390243902438997), (0.8, 0.3999999999999999, 0.4292682926829265), (0.8, 0.3999999999999999, 0.41463414634146306)],
    165: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41454545454545455, 0.3999999999999999), (0.8, 0.4290909090909092, 0.3999999999999999), (0.8, 0.44363636363636333, 0.3999999999999999), (0.8, 0.45818181818181797, 0.3999999999999999), (0.8, 0.4727272727272726, 0.3999999999999999), (0.8, 0.48727272727272725, 0.3999999999999999), (0.8, 0.5018181818181819, 0.3999999999999999), (0.8, 0.5163636363636366, 0.3999999999999999), (0.8, 0.5309090909090907, 0.3999999999999999), (0.8, 0.5454545454545453, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.5745454545454546, 0.3999999999999999), (0.8, 0.5890909090909092, 0.3999999999999999), (0.8, 0.6036363636363639, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6327272727272726, 0.3999999999999999), (0.8, 0.6472727272727272, 0.3999999999999999), (0.8, 0.6618181818181819, 0.3999999999999999), (0.8, 0.6763636363636365, 0.3999999999999999), (0.8, 0.6909090909090907, 0.3999999999999999), (0.8, 0.7054545454545453, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.8, 0.7345454545454546, 0.3999999999999999), (0.8, 0.7490909090909093, 0.3999999999999999), (0.8, 0.7636363636363639, 0.3999999999999999), (0.8, 0.7781818181818181, 0.3999999999999999), (0.8, 0.7927272727272727, 0.3999999999999999), (0.792727272727273, 0.8, 0.3999999999999999), (0.7781818181818183, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.749090909090909, 0.8, 0.3999999999999999), (0.7345454545454548, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7054545454545456, 0.8, 0.3999999999999999), (0.6909090909090909, 0.8, 0.3999999999999999), (0.6763636363636363, 0.8, 0.3999999999999999), (0.6618181818181822, 0.8, 0.3999999999999999), (0.6472727272727276, 0.8, 0.3999999999999999), (0.6327272727272729, 0.8, 0.3999999999999999), (0.6181818181818183, 0.8, 0.3999999999999999), (0.6036363636363636, 0.8, 0.3999999999999999), (0.5890909090909094, 0.8, 0.3999999999999999), (0.5745454545454542, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5309090909090909, 0.8, 0.3999999999999999), (0.5163636363636362, 0.8, 0.3999999999999999), (0.5018181818181816, 0.8, 0.3999999999999999), (0.4872727272727275, 0.8, 0.3999999999999999), (0.4727272727272729, 0.8, 0.3999999999999999), (0.45818181818181825, 0.8, 0.3999999999999999), (0.4436363636363636, 0.8, 0.3999999999999999), (0.4290909090909089, 0.8, 0.3999999999999999), (0.41454545454545483, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41454545454545444), (0.3999999999999999, 0.8, 0.4290909090909091), (0.3999999999999999, 0.8, 0.4436363636363637), (0.3999999999999999, 0.8, 0.45818181818181836), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.4872727272727271), (0.3999999999999999, 0.8, 0.5018181818181817), (0.3999999999999999, 0.8, 0.5163636363636364), (0.3999999999999999, 0.8, 0.530909090909091), (0.3999999999999999, 0.8, 0.5454545454545456), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5745454545454545), (0.3999999999999999, 0.8, 0.5890909090909091), (0.3999999999999999, 0.8, 0.6036363636363637), (0.3999999999999999, 0.8, 0.6181818181818184), (0.3999999999999999, 0.8, 0.6327272727272725), (0.3999999999999999, 0.8, 0.6472727272727271), (0.3999999999999999, 0.8, 0.6618181818181817), (0.3999999999999999, 0.8, 0.6763636363636365), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7054545454545458), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.8, 0.7345454545454544), (0.3999999999999999, 0.8, 0.749090909090909), (0.3999999999999999, 0.8, 0.7636363636363638), (0.3999999999999999, 0.8, 0.7781818181818183), (0.3999999999999999, 0.8, 0.792727272727273), (0.3999999999999999, 0.792727272727273, 0.8), (0.3999999999999999, 0.7781818181818183, 0.8), (0.3999999999999999, 0.7636363636363637, 0.8), (0.3999999999999999, 0.749090909090909, 0.8), (0.3999999999999999, 0.7345454545454544, 0.8), (0.3999999999999999, 0.7200000000000002, 0.8), (0.3999999999999999, 0.7054545454545451, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6763636363636363, 0.8), (0.3999999999999999, 0.6618181818181816, 0.8), (0.3999999999999999, 0.6472727272727276, 0.8), (0.3999999999999999, 0.6327272727272724, 0.8), (0.3999999999999999, 0.6181818181818183, 0.8), (0.3999999999999999, 0.6036363636363636, 0.8), (0.3999999999999999, 0.589090909090909, 0.8), (0.3999999999999999, 0.5745454545454542, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5454545454545455, 0.8), (0.3999999999999999, 0.5309090909090909, 0.8), (0.3999999999999999, 0.5163636363636362, 0.8), (0.3999999999999999, 0.5018181818181816, 0.8), (0.3999999999999999, 0.48727272727272697, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.4581818181818177, 0.8), (0.3999999999999999, 0.4436363636363636, 0.8), (0.3999999999999999, 0.4290909090909089, 0.8), (0.3999999999999999, 0.4145454545454543, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41454545454545455, 0.3999999999999999, 0.8), (0.42909090909090863, 0.3999999999999999, 0.8), (0.44363636363636333, 0.3999999999999999, 0.8), (0.45818181818181797, 0.3999999999999999, 0.8), (0.4727272727272726, 0.3999999999999999, 0.8), (0.48727272727272725, 0.3999999999999999, 0.8), (0.5018181818181814, 0.3999999999999999, 0.8), (0.5163636363636366, 0.3999999999999999, 0.8), (0.5309090909090907, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.574545454545454, 0.3999999999999999, 0.8), (0.5890909090909092, 0.3999999999999999, 0.8), (0.6036363636363633, 0.3999999999999999, 0.8), (0.6181818181818179, 0.3999999999999999, 0.8), (0.6327272727272726, 0.3999999999999999, 0.8), (0.6472727272727268, 0.3999999999999999, 0.8), (0.6618181818181819, 0.3999999999999999, 0.8), (0.6763636363636361, 0.3999999999999999, 0.8), (0.6909090909090907, 0.3999999999999999, 0.8), (0.7054545454545453, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7345454545454546, 0.3999999999999999, 0.8), (0.7490909090909087, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.7781818181818181, 0.3999999999999999, 0.8), (0.7927272727272727, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7927272727272723), (0.8, 0.3999999999999999, 0.7781818181818183), (0.8, 0.3999999999999999, 0.7636363636363631), (0.8, 0.3999999999999999, 0.749090909090909), (0.8, 0.3999999999999999, 0.7345454545454544), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.7054545454545456), (0.8, 0.3999999999999999, 0.6909090909090905), (0.8, 0.3999999999999999, 0.6763636363636363), (0.8, 0.3999999999999999, 0.6618181818181816), (0.8, 0.3999999999999999, 0.647272727272727), (0.8, 0.3999999999999999, 0.6327272727272724), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.6036363636363636), (0.8, 0.3999999999999999, 0.5890909090909084), (0.8, 0.3999999999999999, 0.5745454545454542), (0.8, 0.3999999999999999, 0.5599999999999996), (0.8, 0.3999999999999999, 0.545454545454545), (0.8, 0.3999999999999999, 0.5309090909090909), (0.8, 0.3999999999999999, 0.5163636363636357), (0.8, 0.3999999999999999, 0.5018181818181816), (0.8, 0.3999999999999999, 0.48727272727272697), (0.8, 0.3999999999999999, 0.47272727272727233), (0.8, 0.3999999999999999, 0.45818181818181825), (0.8, 0.3999999999999999, 0.44363636363636305), (0.8, 0.3999999999999999, 0.4290909090909089), (0.8, 0.3999999999999999, 0.4145454545454543)],
    166: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4144578313253013, 0.3999999999999999), (0.8, 0.42891566265060216, 0.3999999999999999), (0.8, 0.44337349397590353, 0.3999999999999999), (0.8, 0.45783132530120496, 0.3999999999999999), (0.8, 0.4722891566265058, 0.3999999999999999), (0.8, 0.48674698795180715, 0.3999999999999999), (0.8, 0.5012048192771086, 0.3999999999999999), (0.8, 0.5156626506024095, 0.3999999999999999), (0.8, 0.5301204819277108, 0.3999999999999999), (0.8, 0.5445783132530122, 0.3999999999999999), (0.8, 0.5590361445783131, 0.3999999999999999), (0.8, 0.5734939759036144, 0.3999999999999999), (0.8, 0.5879518072289158, 0.3999999999999999), (0.8, 0.6024096385542167, 0.3999999999999999), (0.8, 0.6168674698795181, 0.3999999999999999), (0.8, 0.6313253012048194, 0.3999999999999999), (0.8, 0.6457831325301203, 0.3999999999999999), (0.8, 0.6602409638554217, 0.3999999999999999), (0.8, 0.6746987951807231, 0.3999999999999999), (0.8, 0.689156626506024, 0.3999999999999999), (0.8, 0.7036144578313254, 0.3999999999999999), (0.8, 0.7180722891566267, 0.3999999999999999), (0.8, 0.7325301204819277, 0.3999999999999999), (0.8, 0.746987951807229, 0.3999999999999999), (0.8, 0.7614457831325303, 0.3999999999999999), (0.8, 0.7759036144578313, 0.3999999999999999), (0.8, 0.7903614457831327, 0.3999999999999999), (0.7951807228915662, 0.8, 0.3999999999999999), (0.7807228915662654, 0.8, 0.3999999999999999), (0.766265060240964, 0.8, 0.3999999999999999), (0.7518072289156625, 0.8, 0.3999999999999999), (0.7373493975903617, 0.8, 0.3999999999999999), (0.7228915662650603, 0.8, 0.3999999999999999), (0.7084337349397589, 0.8, 0.3999999999999999), (0.693975903614458, 0.8, 0.3999999999999999), (0.6795180722891567, 0.8, 0.3999999999999999), (0.6650602409638553, 0.8, 0.3999999999999999), (0.6506024096385544, 0.8, 0.3999999999999999), (0.636144578313253, 0.8, 0.3999999999999999), (0.6216867469879521, 0.8, 0.3999999999999999), (0.6072289156626508, 0.8, 0.3999999999999999), (0.5927710843373494, 0.8, 0.3999999999999999), (0.578313253012048, 0.8, 0.3999999999999999), (0.5638554216867471, 0.8, 0.3999999999999999), (0.5493975903614458, 0.8, 0.3999999999999999), (0.5349397590361449, 0.8, 0.3999999999999999), (0.5204819277108435, 0.8, 0.3999999999999999), (0.5060240963855421, 0.8, 0.3999999999999999), (0.4915662650602407, 0.8, 0.3999999999999999), (0.47710843373493983, 0.8, 0.3999999999999999), (0.46265060240963846, 0.8, 0.3999999999999999), (0.44819277108433764, 0.8, 0.3999999999999999), (0.4337349397590362, 0.8, 0.3999999999999999), (0.41927710843373484, 0.8, 0.3999999999999999), (0.40481927710843346, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40963855421686735), (0.3999999999999999, 0.8, 0.4240963855421688), (0.3999999999999999, 0.8, 0.4385542168674696), (0.3999999999999999, 0.8, 0.453012048192771), (0.3999999999999999, 0.8, 0.4674698795180724), (0.3999999999999999, 0.8, 0.48192771084337377), (0.3999999999999999, 0.8, 0.49638554216867464), (0.3999999999999999, 0.8, 0.510843373493976), (0.3999999999999999, 0.8, 0.5253012048192769), (0.3999999999999999, 0.8, 0.5397590361445783), (0.3999999999999999, 0.8, 0.5542168674698796), (0.3999999999999999, 0.8, 0.5686746987951811), (0.3999999999999999, 0.8, 0.5831325301204819), (0.3999999999999999, 0.8, 0.5975903614457833), (0.3999999999999999, 0.8, 0.6120481927710841), (0.3999999999999999, 0.8, 0.6265060240963856), (0.3999999999999999, 0.8, 0.640963855421687), (0.3999999999999999, 0.8, 0.6554216867469883), (0.3999999999999999, 0.8, 0.6698795180722892), (0.3999999999999999, 0.8, 0.6843373493975906), (0.3999999999999999, 0.8, 0.6987951807228914), (0.3999999999999999, 0.8, 0.7132530120481928), (0.3999999999999999, 0.8, 0.7277108433734942), (0.3999999999999999, 0.8, 0.7421686746987957), (0.3999999999999999, 0.8, 0.7566265060240964), (0.3999999999999999, 0.8, 0.7710843373493979), (0.3999999999999999, 0.8, 0.7855421686746986), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7855421686746986, 0.8), (0.3999999999999999, 0.7710843373493972, 0.8), (0.3999999999999999, 0.7566265060240963, 0.8), (0.3999999999999999, 0.742168674698795, 0.8), (0.3999999999999999, 0.727710843373494, 0.8), (0.3999999999999999, 0.7132530120481927, 0.8), (0.3999999999999999, 0.6987951807228914, 0.8), (0.3999999999999999, 0.68433734939759, 0.8), (0.3999999999999999, 0.6698795180722891, 0.8), (0.3999999999999999, 0.6554216867469876, 0.8), (0.3999999999999999, 0.6409638554216868, 0.8), (0.3999999999999999, 0.6265060240963854, 0.8), (0.3999999999999999, 0.612048192771084, 0.8), (0.3999999999999999, 0.5975903614457826, 0.8), (0.3999999999999999, 0.5831325301204817, 0.8), (0.3999999999999999, 0.568674698795181, 0.8), (0.3999999999999999, 0.5542168674698795, 0.8), (0.3999999999999999, 0.5397590361445781, 0.8), (0.3999999999999999, 0.5253012048192768, 0.8), (0.3999999999999999, 0.5108433734939754, 0.8), (0.3999999999999999, 0.49638554216867453, 0.8), (0.3999999999999999, 0.48192771084337366, 0.8), (0.3999999999999999, 0.4674698795180723, 0.8), (0.3999999999999999, 0.45301204819277086, 0.8), (0.3999999999999999, 0.4385542168674695, 0.8), (0.3999999999999999, 0.4240963855421681, 0.8), (0.3999999999999999, 0.40963855421686723, 0.8), (0.4048192771084332, 0.3999999999999999, 0.8), (0.41927710843373456, 0.3999999999999999, 0.8), (0.43373493975903593, 0.3999999999999999, 0.8), (0.44819277108433736, 0.3999999999999999, 0.8), (0.46265060240963873, 0.3999999999999999, 0.8), (0.4771084337349396, 0.3999999999999999, 0.8), (0.4915662650602405, 0.3999999999999999, 0.8), (0.5060240963855418, 0.3999999999999999, 0.8), (0.5204819277108432, 0.3999999999999999, 0.8), (0.5349397590361447, 0.3999999999999999, 0.8), (0.549397590361446, 0.3999999999999999, 0.8), (0.5638554216867468, 0.3999999999999999, 0.8), (0.5783132530120477, 0.3999999999999999, 0.8), (0.5927710843373492, 0.3999999999999999, 0.8), (0.6072289156626505, 0.3999999999999999, 0.8), (0.6216867469879519, 0.3999999999999999, 0.8), (0.6361445783132533, 0.3999999999999999, 0.8), (0.6506024096385541, 0.3999999999999999, 0.8), (0.6650602409638551, 0.3999999999999999, 0.8), (0.6795180722891564, 0.3999999999999999, 0.8), (0.6939759036144577, 0.3999999999999999, 0.8), (0.7084337349397591, 0.3999999999999999, 0.8), (0.7228915662650606, 0.3999999999999999, 0.8), (0.7373493975903613, 0.3999999999999999, 0.8), (0.7518072289156623, 0.3999999999999999, 0.8), (0.7662650602409636, 0.3999999999999999, 0.8), (0.780722891566265, 0.3999999999999999, 0.8), (0.7951807228915664, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7903614457831318), (0.8, 0.3999999999999999, 0.7759036144578311), (0.8, 0.3999999999999999, 0.7614457831325301), (0.8, 0.3999999999999999, 0.7469879518072287), (0.8, 0.3999999999999999, 0.7325301204819273), (0.8, 0.3999999999999999, 0.718072289156626), (0.8, 0.3999999999999999, 0.7036144578313246), (0.8, 0.3999999999999999, 0.6891566265060237), (0.8, 0.3999999999999999, 0.6746987951807228), (0.8, 0.3999999999999999, 0.6602409638554214), (0.8, 0.3999999999999999, 0.6457831325301201), (0.8, 0.3999999999999999, 0.6313253012048187), (0.8, 0.3999999999999999, 0.6168674698795173), (0.8, 0.3999999999999999, 0.6024096385542165), (0.8, 0.3999999999999999, 0.5879518072289156), (0.8, 0.3999999999999999, 0.5734939759036142), (0.8, 0.3999999999999999, 0.5590361445783127), (0.8, 0.3999999999999999, 0.5445783132530114), (0.8, 0.3999999999999999, 0.53012048192771), (0.8, 0.3999999999999999, 0.5156626506024091), (0.8, 0.3999999999999999, 0.5012048192771084), (0.8, 0.3999999999999999, 0.48674698795180693), (0.8, 0.3999999999999999, 0.4722891566265055), (0.8, 0.3999999999999999, 0.45783132530120413), (0.8, 0.3999999999999999, 0.4433734939759033), (0.8, 0.3999999999999999, 0.4289156626506019), (0.8, 0.3999999999999999, 0.414457831325301)],
    167: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4143712574850297, 0.3999999999999999), (0.8, 0.42874251497006, 0.3999999999999999), (0.8, 0.4431137724550898, 0.3999999999999999), (0.8, 0.45748502994011964, 0.3999999999999999), (0.8, 0.4718562874251494, 0.3999999999999999), (0.8, 0.4862275449101797, 0.3999999999999999), (0.8, 0.5005988023952095, 0.3999999999999999), (0.8, 0.5149700598802394, 0.3999999999999999), (0.8, 0.5293413173652697, 0.3999999999999999), (0.8, 0.5437125748502994, 0.3999999999999999), (0.8, 0.5580838323353292, 0.3999999999999999), (0.8, 0.5724550898203595, 0.3999999999999999), (0.8, 0.5868263473053894, 0.3999999999999999), (0.8, 0.6011976047904192, 0.3999999999999999), (0.8, 0.6155688622754489, 0.3999999999999999), (0.8, 0.6299401197604793, 0.3999999999999999), (0.8, 0.644311377245509, 0.3999999999999999), (0.8, 0.6586826347305388, 0.3999999999999999), (0.8, 0.6730538922155691, 0.3999999999999999), (0.8, 0.687425149700599, 0.3999999999999999), (0.8, 0.7017964071856287, 0.3999999999999999), (0.8, 0.7161676646706585, 0.3999999999999999), (0.8, 0.7305389221556888, 0.3999999999999999), (0.8, 0.7449101796407187, 0.3999999999999999), (0.8, 0.7592814371257484, 0.3999999999999999), (0.8, 0.7736526946107788, 0.3999999999999999), (0.8, 0.7880239520958086, 0.3999999999999999), (0.7976047904191619, 0.8, 0.3999999999999999), (0.783233532934132, 0.8, 0.3999999999999999), (0.7688622754491017, 0.8, 0.3999999999999999), (0.7544910179640719, 0.8, 0.3999999999999999), (0.7401197604790422, 0.8, 0.3999999999999999), (0.7257485029940118, 0.8, 0.3999999999999999), (0.711377245508982, 0.8, 0.3999999999999999), (0.6970059880239523, 0.8, 0.3999999999999999), (0.6826347305389224, 0.8, 0.3999999999999999), (0.6682634730538921, 0.8, 0.3999999999999999), (0.6538922155688623, 0.8, 0.3999999999999999), (0.6395209580838326, 0.8, 0.3999999999999999), (0.6251497005988023, 0.8, 0.3999999999999999), (0.6107784431137724, 0.8, 0.3999999999999999), (0.5964071856287426, 0.8, 0.3999999999999999), (0.5820359281437129, 0.8, 0.3999999999999999), (0.5676646706586825, 0.8, 0.3999999999999999), (0.5532934131736527, 0.8, 0.3999999999999999), (0.5389221556886229, 0.8, 0.3999999999999999), (0.5245508982035926, 0.8, 0.3999999999999999), (0.5101796407185628, 0.8, 0.3999999999999999), (0.495808383233533, 0.8, 0.3999999999999999), (0.4814371257485032, 0.8, 0.3999999999999999), (0.4670658682634729, 0.8, 0.3999999999999999), (0.4526946107784431, 0.8, 0.3999999999999999), (0.4383233532934133, 0.8, 0.3999999999999999), (0.423952095808383, 0.8, 0.3999999999999999), (0.4095808383233532, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4047904191616766), (0.3999999999999999, 0.8, 0.41916167664670634), (0.3999999999999999, 0.8, 0.43353293413173666), (0.3999999999999999, 0.8, 0.4479041916167665), (0.3999999999999999, 0.8, 0.46227544910179624), (0.3999999999999999, 0.8, 0.47664670658682656), (0.3999999999999999, 0.8, 0.4910179640718564), (0.3999999999999999, 0.8, 0.5053892215568861), (0.3999999999999999, 0.8, 0.5197604790419159), (0.3999999999999999, 0.8, 0.5341317365269462), (0.3999999999999999, 0.8, 0.5485029940119761), (0.3999999999999999, 0.8, 0.5628742514970059), (0.3999999999999999, 0.8, 0.5772455089820362), (0.3999999999999999, 0.8, 0.591616766467066), (0.3999999999999999, 0.8, 0.6059880239520957), (0.3999999999999999, 0.8, 0.6203592814371256), (0.3999999999999999, 0.8, 0.6347305389221559), (0.3999999999999999, 0.8, 0.6491017964071857), (0.3999999999999999, 0.8, 0.663473053892216), (0.3999999999999999, 0.8, 0.6778443113772459), (0.3999999999999999, 0.8, 0.6922155688622755), (0.3999999999999999, 0.8, 0.7065868263473054), (0.3999999999999999, 0.8, 0.7209580838323352), (0.3999999999999999, 0.8, 0.7353293413173655), (0.3999999999999999, 0.8, 0.7497005988023953), (0.3999999999999999, 0.8, 0.7640718562874256), (0.3999999999999999, 0.8, 0.7784431137724555), (0.3999999999999999, 0.8, 0.7928143712574851), (0.3999999999999999, 0.7928143712574851, 0.8), (0.3999999999999999, 0.7784431137724552, 0.8), (0.3999999999999999, 0.7640718562874249, 0.8), (0.3999999999999999, 0.7497005988023951, 0.8), (0.3999999999999999, 0.7353293413173648, 0.8), (0.3999999999999999, 0.7209580838323351, 0.8), (0.3999999999999999, 0.7065868263473052, 0.8), (0.3999999999999999, 0.6922155688622755, 0.8), (0.3999999999999999, 0.6778443113772457, 0.8), (0.3999999999999999, 0.6634730538922153, 0.8), (0.3999999999999999, 0.6491017964071856, 0.8), (0.3999999999999999, 0.6347305389221553, 0.8), (0.3999999999999999, 0.6203592814371255, 0.8), (0.3999999999999999, 0.6059880239520956, 0.8), (0.3999999999999999, 0.5916167664670658, 0.8), (0.3999999999999999, 0.5772455089820361, 0.8), (0.3999999999999999, 0.5628742514970058, 0.8), (0.3999999999999999, 0.5485029940119759, 0.8), (0.3999999999999999, 0.5341317365269456, 0.8), (0.3999999999999999, 0.5197604790419158, 0.8), (0.3999999999999999, 0.505389221556886, 0.8), (0.3999999999999999, 0.49101796407185627, 0.8), (0.3999999999999999, 0.47664670658682645, 0.8), (0.3999999999999999, 0.46227544910179613, 0.8), (0.3999999999999999, 0.4479041916167663, 0.8), (0.3999999999999999, 0.433532934131736, 0.8), (0.3999999999999999, 0.4191616766467062, 0.8), (0.3999999999999999, 0.4047904191616764, 0.8), (0.4095808383233529, 0.3999999999999999, 0.8), (0.4239520958083827, 0.3999999999999999, 0.8), (0.43832335329341304, 0.3999999999999999, 0.8), (0.45269461077844286, 0.3999999999999999, 0.8), (0.4670658682634732, 0.3999999999999999, 0.8), (0.48143712574850295, 0.3999999999999999, 0.8), (0.49580838323353277, 0.3999999999999999, 0.8), (0.5101796407185626, 0.3999999999999999, 0.8), (0.5245508982035924, 0.3999999999999999, 0.8), (0.5389221556886227, 0.3999999999999999, 0.8), (0.553293413173653, 0.3999999999999999, 0.8), (0.5676646706586828, 0.3999999999999999, 0.8), (0.5820359281437126, 0.3999999999999999, 0.8), (0.5964071856287424, 0.3999999999999999, 0.8), (0.6107784431137722, 0.3999999999999999, 0.8), (0.6251497005988019, 0.3999999999999999, 0.8), (0.6395209580838322, 0.3999999999999999, 0.8), (0.6538922155688626, 0.3999999999999999, 0.8), (0.6682634730538923, 0.3999999999999999, 0.8), (0.6826347305389222, 0.3999999999999999, 0.8), (0.697005988023952, 0.3999999999999999, 0.8), (0.7113772455089817, 0.3999999999999999, 0.8), (0.7257485029940116, 0.3999999999999999, 0.8), (0.7401197604790419, 0.3999999999999999, 0.8), (0.7544910179640723, 0.3999999999999999, 0.8), (0.768862275449102, 0.3999999999999999, 0.8), (0.7832335329341318, 0.3999999999999999, 0.8), (0.7976047904191617, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7880239520958083), (0.8, 0.3999999999999999, 0.773652694610778), (0.8, 0.3999999999999999, 0.7592814371257481), (0.8, 0.3999999999999999, 0.7449101796407178), (0.8, 0.3999999999999999, 0.730538922155688), (0.8, 0.3999999999999999, 0.7161676646706583), (0.8, 0.3999999999999999, 0.7017964071856284), (0.8, 0.3999999999999999, 0.6874251497005988), (0.8, 0.3999999999999999, 0.6730538922155684), (0.8, 0.3999999999999999, 0.6586826347305386), (0.8, 0.3999999999999999, 0.6443113772455082), (0.8, 0.3999999999999999, 0.6299401197604785), (0.8, 0.3999999999999999, 0.6155688622754487), (0.8, 0.3999999999999999, 0.6011976047904188), (0.8, 0.3999999999999999, 0.5868263473053891), (0.8, 0.3999999999999999, 0.5724550898203588), (0.8, 0.3999999999999999, 0.558083832335329), (0.8, 0.3999999999999999, 0.5437125748502987), (0.8, 0.3999999999999999, 0.5293413173652688), (0.8, 0.3999999999999999, 0.514970059880239), (0.8, 0.3999999999999999, 0.5005988023952093), (0.8, 0.3999999999999999, 0.48622754491017944), (0.8, 0.3999999999999999, 0.4718562874251491), (0.8, 0.3999999999999999, 0.45748502994011936), (0.8, 0.3999999999999999, 0.44311377245508904), (0.8, 0.3999999999999999, 0.4287425149700592), (0.8, 0.3999999999999999, 0.41437125748502945)],
    168: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41428571428571415, 0.3999999999999999), (0.8, 0.4285714285714284, 0.3999999999999999), (0.8, 0.4428571428571426, 0.3999999999999999), (0.8, 0.45714285714285685, 0.3999999999999999), (0.8, 0.4714285714285711, 0.3999999999999999), (0.8, 0.4857142857142859, 0.3999999999999999), (0.8, 0.5000000000000001, 0.3999999999999999), (0.8, 0.5142857142857143, 0.3999999999999999), (0.8, 0.5285714285714286, 0.3999999999999999), (0.8, 0.5428571428571428, 0.3999999999999999), (0.8, 0.557142857142857, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.5857142857142856, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6142857142857141, 0.3999999999999999), (0.8, 0.6285714285714288, 0.3999999999999999), (0.8, 0.642857142857143, 0.3999999999999999), (0.8, 0.6571428571428573, 0.3999999999999999), (0.8, 0.6714285714285715, 0.3999999999999999), (0.8, 0.6857142857142857, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7142857142857142, 0.3999999999999999), (0.8, 0.7285714285714284, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7571428571428569, 0.3999999999999999), (0.8, 0.7714285714285712, 0.3999999999999999), (0.8, 0.7857142857142854, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7857142857142858, 0.8, 0.3999999999999999), (0.7714285714285715, 0.8, 0.3999999999999999), (0.7571428571428572, 0.8, 0.3999999999999999), (0.742857142857143, 0.8, 0.3999999999999999), (0.7285714285714288, 0.8, 0.3999999999999999), (0.7142857142857145, 0.8, 0.3999999999999999), (0.7000000000000003, 0.8, 0.3999999999999999), (0.685714285714286, 0.8, 0.3999999999999999), (0.6714285714285713, 0.8, 0.3999999999999999), (0.657142857142857, 0.8, 0.3999999999999999), (0.6428571428571428, 0.8, 0.3999999999999999), (0.6285714285714286, 0.8, 0.3999999999999999), (0.6142857142857143, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5857142857142859, 0.8, 0.3999999999999999), (0.5714285714285716, 0.8, 0.3999999999999999), (0.5571428571428574, 0.8, 0.3999999999999999), (0.5428571428571431, 0.8, 0.3999999999999999), (0.5285714285714289, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.5000000000000004, 0.8, 0.3999999999999999), (0.4857142857142856, 0.8, 0.3999999999999999), (0.47142857142857136, 0.8, 0.3999999999999999), (0.45714285714285713, 0.8, 0.3999999999999999), (0.4428571428571429, 0.8, 0.3999999999999999), (0.42857142857142866, 0.8, 0.3999999999999999), (0.4142857142857144, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41428571428571404), (0.3999999999999999, 0.8, 0.42857142857142877), (0.3999999999999999, 0.8, 0.44285714285714306), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.47142857142857153), (0.3999999999999999, 0.8, 0.48571428571428577), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5142857142857142), (0.3999999999999999, 0.8, 0.5285714285714285), (0.3999999999999999, 0.8, 0.5428571428571427), (0.3999999999999999, 0.8, 0.5571428571428569), (0.3999999999999999, 0.8, 0.5714285714285712), (0.3999999999999999, 0.8, 0.5857142857142854), (0.3999999999999999, 0.8, 0.5999999999999996), (0.3999999999999999, 0.8, 0.6142857142857144), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6428571428571429), (0.3999999999999999, 0.8, 0.6571428571428571), (0.3999999999999999, 0.8, 0.6714285714285715), (0.3999999999999999, 0.8, 0.6857142857142857), (0.3999999999999999, 0.8, 0.7), (0.3999999999999999, 0.8, 0.7142857142857142), (0.3999999999999999, 0.8, 0.7285714285714289), (0.3999999999999999, 0.8, 0.7428571428571431), (0.3999999999999999, 0.8, 0.7571428571428573), (0.3999999999999999, 0.8, 0.7714285714285716), (0.3999999999999999, 0.8, 0.7857142857142858), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7857142857142858, 0.8), (0.3999999999999999, 0.7714285714285715, 0.8), (0.3999999999999999, 0.7571428571428572, 0.8), (0.3999999999999999, 0.742857142857143, 0.8), (0.3999999999999999, 0.7285714285714288, 0.8), (0.3999999999999999, 0.7142857142857145, 0.8), (0.3999999999999999, 0.7000000000000003, 0.8), (0.3999999999999999, 0.685714285714286, 0.8), (0.3999999999999999, 0.6714285714285718, 0.8), (0.3999999999999999, 0.657142857142857, 0.8), (0.3999999999999999, 0.6428571428571428, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6142857142857143, 0.8), (0.3999999999999999, 0.6000000000000001, 0.8), (0.3999999999999999, 0.5857142857142853, 0.8), (0.3999999999999999, 0.5714285714285711, 0.8), (0.3999999999999999, 0.5571428571428568, 0.8), (0.3999999999999999, 0.5428571428571426, 0.8), (0.3999999999999999, 0.5285714285714284, 0.8), (0.3999999999999999, 0.5142857142857141, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4857142857142856, 0.8), (0.3999999999999999, 0.47142857142857136, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.3999999999999999, 0.4428571428571429, 0.8), (0.3999999999999999, 0.42857142857142866, 0.8), (0.3999999999999999, 0.4142857142857144, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4142857142857136, 0.3999999999999999, 0.8), (0.4285714285714278, 0.3999999999999999, 0.8), (0.4428571428571426, 0.3999999999999999, 0.8), (0.45714285714285685, 0.3999999999999999, 0.8), (0.4714285714285711, 0.3999999999999999, 0.8), (0.4857142857142853, 0.3999999999999999, 0.8), (0.4999999999999996, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5285714285714286, 0.3999999999999999, 0.8), (0.5428571428571428, 0.3999999999999999, 0.8), (0.557142857142857, 0.3999999999999999, 0.8), (0.5714285714285713, 0.3999999999999999, 0.8), (0.5857142857142856, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6142857142857141, 0.3999999999999999, 0.8), (0.6285714285714283, 0.3999999999999999, 0.8), (0.6428571428571426, 0.3999999999999999, 0.8), (0.6571428571428568, 0.3999999999999999, 0.8), (0.671428571428571, 0.3999999999999999, 0.8), (0.6857142857142853, 0.3999999999999999, 0.8), (0.6999999999999995, 0.3999999999999999, 0.8), (0.7142857142857137, 0.3999999999999999, 0.8), (0.728571428571428, 0.3999999999999999, 0.8), (0.7428571428571427, 0.3999999999999999, 0.8), (0.7571428571428569, 0.3999999999999999, 0.8), (0.7714285714285712, 0.3999999999999999, 0.8), (0.7857142857142854, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7857142857142858), (0.8, 0.3999999999999999, 0.7714285714285709), (0.8, 0.3999999999999999, 0.7571428571428567), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7285714285714282), (0.8, 0.3999999999999999, 0.714285714285714), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6857142857142855), (0.8, 0.3999999999999999, 0.6714285714285713), (0.8, 0.3999999999999999, 0.657142857142857), (0.8, 0.3999999999999999, 0.6428571428571428), (0.8, 0.3999999999999999, 0.6285714285714286), (0.8, 0.3999999999999999, 0.6142857142857143), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5857142857142859), (0.8, 0.3999999999999999, 0.5714285714285716), (0.8, 0.3999999999999999, 0.5571428571428574), (0.8, 0.3999999999999999, 0.5428571428571426), (0.8, 0.3999999999999999, 0.5285714285714284), (0.8, 0.3999999999999999, 0.5142857142857141), (0.8, 0.3999999999999999, 0.49999999999999983), (0.8, 0.3999999999999999, 0.4857142857142856), (0.8, 0.3999999999999999, 0.47142857142857086), (0.8, 0.3999999999999999, 0.45714285714285663), (0.8, 0.3999999999999999, 0.4428571428571424), (0.8, 0.3999999999999999, 0.4285714285714281), (0.8, 0.3999999999999999, 0.41428571428571387)],
    169: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41420118343195267, 0.3999999999999999), (0.8, 0.42840236686390537, 0.3999999999999999), (0.8, 0.44260355029585813, 0.3999999999999999), (0.8, 0.45680473372781033, 0.3999999999999999), (0.8, 0.4710059171597631, 0.3999999999999999), (0.8, 0.4852071005917158, 0.3999999999999999), (0.8, 0.49940828402366855, 0.3999999999999999), (0.8, 0.5136094674556213, 0.3999999999999999), (0.8, 0.5278106508875741, 0.3999999999999999), (0.8, 0.5420118343195268, 0.3999999999999999), (0.8, 0.5562130177514795, 0.3999999999999999), (0.8, 0.5704142011834317, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.5988165680473372, 0.3999999999999999), (0.8, 0.6130177514792899, 0.3999999999999999), (0.8, 0.6272189349112427, 0.3999999999999999), (0.8, 0.6414201183431955, 0.3999999999999999), (0.8, 0.6556213017751482, 0.3999999999999999), (0.8, 0.6698224852071004, 0.3999999999999999), (0.8, 0.6840236686390531, 0.3999999999999999), (0.8, 0.6982248520710059, 0.3999999999999999), (0.8, 0.7124260355029586, 0.3999999999999999), (0.8, 0.7266272189349113, 0.3999999999999999), (0.8, 0.7408284023668641, 0.3999999999999999), (0.8, 0.7550295857988167, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.8, 0.7834319526627218, 0.3999999999999999), (0.8, 0.7976331360946745, 0.3999999999999999), (0.788165680473373, 0.8, 0.3999999999999999), (0.7739644970414202, 0.8, 0.3999999999999999), (0.7597633136094675, 0.8, 0.3999999999999999), (0.7455621301775147, 0.8, 0.3999999999999999), (0.7313609467455625, 0.8, 0.3999999999999999), (0.7171597633136098, 0.8, 0.3999999999999999), (0.7029585798816571, 0.8, 0.3999999999999999), (0.6887573964497042, 0.8, 0.3999999999999999), (0.6745562130177516, 0.8, 0.3999999999999999), (0.6603550295857988, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.6319526627218939, 0.8, 0.3999999999999999), (0.6177514792899411, 0.8, 0.3999999999999999), (0.6035502958579884, 0.8, 0.3999999999999999), (0.5893491124260356, 0.8, 0.3999999999999999), (0.5751479289940828, 0.8, 0.3999999999999999), (0.5609467455621302, 0.8, 0.3999999999999999), (0.5467455621301774, 0.8, 0.3999999999999999), (0.5325443786982252, 0.8, 0.3999999999999999), (0.5183431952662719, 0.8, 0.3999999999999999), (0.5041420118343197, 0.8, 0.3999999999999999), (0.48994082840236697, 0.8, 0.3999999999999999), (0.47573964497041427, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.4473372781065088, 0.8, 0.3999999999999999), (0.43313609467455655, 0.8, 0.3999999999999999), (0.4189349112426033, 0.8, 0.3999999999999999), (0.4047337278106511, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4094674556213016), (0.3999999999999999, 0.8, 0.42366863905325436), (0.3999999999999999, 0.8, 0.43786982248520706), (0.3999999999999999, 0.8, 0.4520710059171598), (0.3999999999999999, 0.8, 0.4662721893491126), (0.3999999999999999, 0.8, 0.4804733727810653), (0.3999999999999999, 0.8, 0.49467455621301754), (0.3999999999999999, 0.8, 0.5088757396449702), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.5372781065088758), (0.3999999999999999, 0.8, 0.5514792899408285), (0.3999999999999999, 0.8, 0.5656804733727812), (0.3999999999999999, 0.8, 0.5798816568047339), (0.3999999999999999, 0.8, 0.5940828402366861), (0.3999999999999999, 0.8, 0.6082840236686389), (0.3999999999999999, 0.8, 0.6224852071005916), (0.3999999999999999, 0.8, 0.6366863905325444), (0.3999999999999999, 0.8, 0.6508875739644971), (0.3999999999999999, 0.8, 0.6650887573964499), (0.3999999999999999, 0.8, 0.6792899408284025), (0.3999999999999999, 0.8, 0.6934911242603548), (0.3999999999999999, 0.8, 0.7076923076923076), (0.3999999999999999, 0.8, 0.7218934911242603), (0.3999999999999999, 0.8, 0.736094674556213), (0.3999999999999999, 0.8, 0.7502958579881658), (0.3999999999999999, 0.8, 0.7644970414201185), (0.3999999999999999, 0.8, 0.7786982248520713), (0.3999999999999999, 0.8, 0.7928994082840235), (0.3999999999999999, 0.7928994082840233, 0.8), (0.3999999999999999, 0.7786982248520711, 0.8), (0.3999999999999999, 0.7644970414201184, 0.8), (0.3999999999999999, 0.7502958579881656, 0.8), (0.3999999999999999, 0.7360946745562129, 0.8), (0.3999999999999999, 0.7218934911242602, 0.8), (0.3999999999999999, 0.707692307692308, 0.8), (0.3999999999999999, 0.6934911242603548, 0.8), (0.3999999999999999, 0.6792899408284025, 0.8), (0.3999999999999999, 0.6650887573964497, 0.8), (0.3999999999999999, 0.650887573964497, 0.8), (0.3999999999999999, 0.6366863905325443, 0.8), (0.3999999999999999, 0.6224852071005915, 0.8), (0.3999999999999999, 0.6082840236686393, 0.8), (0.3999999999999999, 0.594082840236686, 0.8), (0.3999999999999999, 0.5798816568047338, 0.8), (0.3999999999999999, 0.565680473372781, 0.8), (0.3999999999999999, 0.5514792899408283, 0.8), (0.3999999999999999, 0.5372781065088756, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.5088757396449707, 0.8), (0.3999999999999999, 0.49467455621301737, 0.8), (0.3999999999999999, 0.48047337278106517, 0.8), (0.3999999999999999, 0.4662721893491124, 0.8), (0.3999999999999999, 0.4520710059171597, 0.8), (0.3999999999999999, 0.43786982248520695, 0.8), (0.3999999999999999, 0.4236686390532542, 0.8), (0.3999999999999999, 0.409467455621302, 0.8), (0.4047337278106508, 0.3999999999999999, 0.8), (0.418934911242603, 0.3999999999999999, 0.8), (0.4331360946745563, 0.3999999999999999, 0.8), (0.44733727810650853, 0.3999999999999999, 0.8), (0.46153846153846123, 0.3999999999999999, 0.8), (0.475739644970414, 0.3999999999999999, 0.8), (0.4899408284023662, 0.3999999999999999, 0.8), (0.5041420118343195, 0.3999999999999999, 0.8), (0.5183431952662717, 0.3999999999999999, 0.8), (0.5325443786982249, 0.3999999999999999, 0.8), (0.5467455621301771, 0.3999999999999999, 0.8), (0.5609467455621299, 0.3999999999999999, 0.8), (0.5751479289940826, 0.3999999999999999, 0.8), (0.5893491124260354, 0.3999999999999999, 0.8), (0.6035502958579881, 0.3999999999999999, 0.8), (0.6177514792899403, 0.3999999999999999, 0.8), (0.6319526627218937, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.6603550295857985, 0.3999999999999999, 0.8), (0.6745562130177514, 0.3999999999999999, 0.8), (0.688757396449704, 0.3999999999999999, 0.8), (0.7029585798816568, 0.3999999999999999, 0.8), (0.717159763313609, 0.3999999999999999, 0.8), (0.7313609467455622, 0.3999999999999999, 0.8), (0.7455621301775144, 0.3999999999999999, 0.8), (0.7597633136094673, 0.3999999999999999, 0.8), (0.7739644970414199, 0.3999999999999999, 0.8), (0.7881656804733728, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7976331360946742), (0.8, 0.3999999999999999, 0.783431952662722), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7550295857988165), (0.8, 0.3999999999999999, 0.7408284023668639), (0.8, 0.3999999999999999, 0.726627218934911), (0.8, 0.3999999999999999, 0.7124260355029584), (0.8, 0.3999999999999999, 0.6982248520710056), (0.8, 0.3999999999999999, 0.6840236686390534), (0.8, 0.3999999999999999, 0.6698224852071002), (0.8, 0.3999999999999999, 0.6556213017751479), (0.8, 0.3999999999999999, 0.6414201183431951), (0.8, 0.3999999999999999, 0.6272189349112425), (0.8, 0.3999999999999999, 0.6130177514792897), (0.8, 0.3999999999999999, 0.598816568047337), (0.8, 0.3999999999999999, 0.5846153846153848), (0.8, 0.3999999999999999, 0.5704142011834314), (0.8, 0.3999999999999999, 0.5562130177514792), (0.8, 0.3999999999999999, 0.5420118343195259), (0.8, 0.3999999999999999, 0.5278106508875737), (0.8, 0.3999999999999999, 0.5136094674556211), (0.8, 0.3999999999999999, 0.49940828402366827), (0.8, 0.3999999999999999, 0.48520710059171607), (0.8, 0.3999999999999999, 0.4710059171597628), (0.8, 0.3999999999999999, 0.4568047337278106), (0.8, 0.3999999999999999, 0.44260355029585735), (0.8, 0.3999999999999999, 0.4284023668639051), (0.8, 0.3999999999999999, 0.4142011834319524)],
    170: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41411764705882337, 0.3999999999999999), (0.8, 0.4282352941176469, 0.3999999999999999), (0.8, 0.4423529411764704, 0.3999999999999999), (0.8, 0.45647058823529385, 0.3999999999999999), (0.8, 0.4705882352941173, 0.3999999999999999), (0.8, 0.4847058823529413, 0.3999999999999999), (0.8, 0.49882352941176483, 0.3999999999999999), (0.8, 0.5129411764705883, 0.3999999999999999), (0.8, 0.5270588235294118, 0.3999999999999999), (0.8, 0.5411764705882353, 0.3999999999999999), (0.8, 0.5552941176470587, 0.3999999999999999), (0.8, 0.5694117647058823, 0.3999999999999999), (0.8, 0.5835294117647057, 0.3999999999999999), (0.8, 0.5976470588235292, 0.3999999999999999), (0.8, 0.6117647058823527, 0.3999999999999999), (0.8, 0.6258823529411768, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6541176470588237, 0.3999999999999999), (0.8, 0.6682352941176473, 0.3999999999999999), (0.8, 0.6823529411764706, 0.3999999999999999), (0.8, 0.6964705882352942, 0.3999999999999999), (0.8, 0.7105882352941176, 0.3999999999999999), (0.8, 0.7247058823529411, 0.3999999999999999), (0.8, 0.7388235294117647, 0.3999999999999999), (0.8, 0.752941176470588, 0.3999999999999999), (0.8, 0.7670588235294116, 0.3999999999999999), (0.8, 0.7811764705882351, 0.3999999999999999), (0.8, 0.7952941176470592, 0.3999999999999999), (0.7905882352941176, 0.8, 0.3999999999999999), (0.7764705882352942, 0.8, 0.3999999999999999), (0.7623529411764707, 0.8, 0.3999999999999999), (0.7482352941176471, 0.8, 0.3999999999999999), (0.7341176470588238, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7058823529411767, 0.8, 0.3999999999999999), (0.6917647058823533, 0.8, 0.3999999999999999), (0.6776470588235293, 0.8, 0.3999999999999999), (0.6635294117647057, 0.8, 0.3999999999999999), (0.6494117647058822, 0.8, 0.3999999999999999), (0.6352941176470588, 0.8, 0.3999999999999999), (0.6211764705882353, 0.8, 0.3999999999999999), (0.6070588235294118, 0.8, 0.3999999999999999), (0.5929411764705883, 0.8, 0.3999999999999999), (0.5788235294117648, 0.8, 0.3999999999999999), (0.5647058823529414, 0.8, 0.3999999999999999), (0.5505882352941178, 0.8, 0.3999999999999999), (0.5364705882352944, 0.8, 0.3999999999999999), (0.5223529411764709, 0.8, 0.3999999999999999), (0.5082352941176475, 0.8, 0.3999999999999999), (0.4941176470588234, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.4658823529411764, 0.8, 0.3999999999999999), (0.45176470588235296, 0.8, 0.3999999999999999), (0.43764705882352944, 0.8, 0.3999999999999999), (0.423529411764706, 0.8, 0.3999999999999999), (0.4094117647058825, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4047058823529409), (0.3999999999999999, 0.8, 0.4188235294117649), (0.3999999999999999, 0.8, 0.43294117647058844), (0.3999999999999999, 0.8, 0.44705882352941195), (0.3999999999999999, 0.8, 0.4611764705882354), (0.3999999999999999, 0.8, 0.47529411764705887), (0.3999999999999999, 0.8, 0.4894117647058824), (0.3999999999999999, 0.8, 0.5035294117647059), (0.3999999999999999, 0.8, 0.5176470588235293), (0.3999999999999999, 0.8, 0.5317647058823528), (0.3999999999999999, 0.8, 0.5458823529411763), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5741176470588233), (0.3999999999999999, 0.8, 0.5882352941176467), (0.3999999999999999, 0.8, 0.6023529411764708), (0.3999999999999999, 0.8, 0.6164705882352943), (0.3999999999999999, 0.8, 0.6305882352941178), (0.3999999999999999, 0.8, 0.6447058823529412), (0.3999999999999999, 0.8, 0.6588235294117647), (0.3999999999999999, 0.8, 0.6729411764705882), (0.3999999999999999, 0.8, 0.6870588235294117), (0.3999999999999999, 0.8, 0.7011764705882352), (0.3999999999999999, 0.8, 0.7152941176470592), (0.3999999999999999, 0.8, 0.7294117647058826), (0.3999999999999999, 0.8, 0.7435294117647062), (0.3999999999999999, 0.8, 0.7576470588235296), (0.3999999999999999, 0.8, 0.7717647058823531), (0.3999999999999999, 0.8, 0.7858823529411767), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7858823529411765, 0.8), (0.3999999999999999, 0.771764705882353, 0.8), (0.3999999999999999, 0.7576470588235296, 0.8), (0.3999999999999999, 0.743529411764706, 0.8), (0.3999999999999999, 0.7294117647058825, 0.8), (0.3999999999999999, 0.7152941176470591, 0.8), (0.3999999999999999, 0.7011764705882355, 0.8), (0.3999999999999999, 0.6870588235294122, 0.8), (0.3999999999999999, 0.6729411764705882, 0.8), (0.3999999999999999, 0.6588235294117646, 0.8), (0.3999999999999999, 0.6447058823529411, 0.8), (0.3999999999999999, 0.6305882352941177, 0.8), (0.3999999999999999, 0.6164705882352941, 0.8), (0.3999999999999999, 0.6023529411764701, 0.8), (0.3999999999999999, 0.5882352941176466, 0.8), (0.3999999999999999, 0.5741176470588232, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5458823529411762, 0.8), (0.3999999999999999, 0.5317647058823527, 0.8), (0.3999999999999999, 0.5176470588235292, 0.8), (0.3999999999999999, 0.5035294117647058, 0.8), (0.3999999999999999, 0.4894117647058822, 0.8), (0.3999999999999999, 0.47529411764705876, 0.8), (0.3999999999999999, 0.4611764705882353, 0.8), (0.3999999999999999, 0.4470588235294118, 0.8), (0.3999999999999999, 0.43294117647058833, 0.8), (0.3999999999999999, 0.4188235294117648, 0.8), (0.3999999999999999, 0.40470588235294136, 0.8), (0.4094117647058817, 0.3999999999999999, 0.8), (0.4235294117647057, 0.3999999999999999, 0.8), (0.4376470588235292, 0.3999999999999999, 0.8), (0.4517647058823527, 0.3999999999999999, 0.8), (0.4658823529411762, 0.3999999999999999, 0.8), (0.47999999999999965, 0.3999999999999999, 0.8), (0.49411764705882316, 0.3999999999999999, 0.8), (0.5082352941176471, 0.3999999999999999, 0.8), (0.5223529411764707, 0.3999999999999999, 0.8), (0.5364705882352941, 0.3999999999999999, 0.8), (0.5505882352941176, 0.3999999999999999, 0.8), (0.5647058823529411, 0.3999999999999999, 0.8), (0.5788235294117645, 0.3999999999999999, 0.8), (0.5929411764705881, 0.3999999999999999, 0.8), (0.6070588235294115, 0.3999999999999999, 0.8), (0.621176470588235, 0.3999999999999999, 0.8), (0.6352941176470586, 0.3999999999999999, 0.8), (0.649411764705882, 0.3999999999999999, 0.8), (0.6635294117647055, 0.3999999999999999, 0.8), (0.677647058823529, 0.3999999999999999, 0.8), (0.6917647058823524, 0.3999999999999999, 0.8), (0.705882352941176, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7341176470588234, 0.3999999999999999, 0.8), (0.7482352941176469, 0.3999999999999999, 0.8), (0.7623529411764705, 0.3999999999999999, 0.8), (0.7764705882352938, 0.3999999999999999, 0.8), (0.7905882352941174, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7952941176470583), (0.8, 0.3999999999999999, 0.7811764705882347), (0.8, 0.3999999999999999, 0.7670588235294113), (0.8, 0.3999999999999999, 0.7529411764705878), (0.8, 0.3999999999999999, 0.7388235294117643), (0.8, 0.3999999999999999, 0.7247058823529409), (0.8, 0.3999999999999999, 0.7105882352941173), (0.8, 0.3999999999999999, 0.696470588235294), (0.8, 0.3999999999999999, 0.6823529411764704), (0.8, 0.3999999999999999, 0.6682352941176469), (0.8, 0.3999999999999999, 0.6541176470588235), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6258823529411764), (0.8, 0.3999999999999999, 0.611764705882353), (0.8, 0.3999999999999999, 0.5976470588235295), (0.8, 0.3999999999999999, 0.5835294117647061), (0.8, 0.3999999999999999, 0.569411764705882), (0.8, 0.3999999999999999, 0.5552941176470585), (0.8, 0.3999999999999999, 0.541176470588235), (0.8, 0.3999999999999999, 0.5270588235294116), (0.8, 0.3999999999999999, 0.512941176470588), (0.8, 0.3999999999999999, 0.49882352941176406), (0.8, 0.3999999999999999, 0.48470588235294054), (0.8, 0.3999999999999999, 0.4705882352941171), (0.8, 0.3999999999999999, 0.4564705882352936), (0.8, 0.3999999999999999, 0.4423529411764701), (0.8, 0.3999999999999999, 0.4282352941176466), (0.8, 0.3999999999999999, 0.41411764705882315)],
    171: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41403508771929803, 0.3999999999999999), (0.8, 0.42807017543859616, 0.3999999999999999), (0.8, 0.4421052631578948, 0.3999999999999999), (0.8, 0.4561403508771929, 0.3999999999999999), (0.8, 0.470175438596491, 0.3999999999999999), (0.8, 0.48421052631578965, 0.3999999999999999), (0.8, 0.49824561403508777, 0.3999999999999999), (0.8, 0.5122807017543859, 0.3999999999999999), (0.8, 0.5263157894736841, 0.3999999999999999), (0.8, 0.5403508771929821, 0.3999999999999999), (0.8, 0.5543859649122808, 0.3999999999999999), (0.8, 0.5684210526315789, 0.3999999999999999), (0.8, 0.582456140350877, 0.3999999999999999), (0.8, 0.5964912280701756, 0.3999999999999999), (0.8, 0.6105263157894738, 0.3999999999999999), (0.8, 0.6245614035087719, 0.3999999999999999), (0.8, 0.63859649122807, 0.3999999999999999), (0.8, 0.6526315789473681, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6807017543859649, 0.3999999999999999), (0.8, 0.6947368421052631, 0.3999999999999999), (0.8, 0.7087719298245616, 0.3999999999999999), (0.8, 0.7228070175438598, 0.3999999999999999), (0.8, 0.736842105263158, 0.3999999999999999), (0.8, 0.750877192982456, 0.3999999999999999), (0.8, 0.7649122807017541, 0.3999999999999999), (0.8, 0.7789473684210528, 0.3999999999999999), (0.8, 0.7929824561403509, 0.3999999999999999), (0.7929824561403511, 0.8, 0.3999999999999999), (0.7789473684210526, 0.8, 0.3999999999999999), (0.7649122807017544, 0.8, 0.3999999999999999), (0.7508771929824563, 0.8, 0.3999999999999999), (0.7368421052631582, 0.8, 0.3999999999999999), (0.7228070175438601, 0.8, 0.3999999999999999), (0.7087719298245614, 0.8, 0.3999999999999999), (0.6947368421052633, 0.8, 0.3999999999999999), (0.6807017543859653, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6526315789473685, 0.8, 0.3999999999999999), (0.6385964912280703, 0.8, 0.3999999999999999), (0.6245614035087722, 0.8, 0.3999999999999999), (0.610526315789474, 0.8, 0.3999999999999999), (0.5964912280701754, 0.8, 0.3999999999999999), (0.5824561403508772, 0.8, 0.3999999999999999), (0.5684210526315792, 0.8, 0.3999999999999999), (0.5543859649122805, 0.8, 0.3999999999999999), (0.5403508771929824, 0.8, 0.3999999999999999), (0.5263157894736843, 0.8, 0.3999999999999999), (0.5122807017543862, 0.8, 0.3999999999999999), (0.49824561403508805, 0.8, 0.3999999999999999), (0.4842105263157894, 0.8, 0.3999999999999999), (0.4701754385964913, 0.8, 0.3999999999999999), (0.4561403508771932, 0.8, 0.3999999999999999), (0.4421052631578945, 0.8, 0.3999999999999999), (0.4280701754385964, 0.8, 0.3999999999999999), (0.4140350877192983, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41403508771929787), (0.3999999999999999, 0.8, 0.42807017543859655), (0.3999999999999999, 0.8, 0.44210526315789467), (0.3999999999999999, 0.8, 0.4561403508771928), (0.3999999999999999, 0.8, 0.4701754385964914), (0.3999999999999999, 0.8, 0.48421052631578954), (0.3999999999999999, 0.8, 0.49824561403508766), (0.3999999999999999, 0.8, 0.5122807017543858), (0.3999999999999999, 0.8, 0.5263157894736838), (0.3999999999999999, 0.8, 0.5403508771929826), (0.3999999999999999, 0.8, 0.5543859649122806), (0.3999999999999999, 0.8, 0.5684210526315787), (0.3999999999999999, 0.8, 0.5824561403508774), (0.3999999999999999, 0.8, 0.5964912280701755), (0.3999999999999999, 0.8, 0.6105263157894737), (0.3999999999999999, 0.8, 0.6245614035087718), (0.3999999999999999, 0.8, 0.6385964912280699), (0.3999999999999999, 0.8, 0.6526315789473686), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6807017543859648), (0.3999999999999999, 0.8, 0.6947368421052634), (0.3999999999999999, 0.8, 0.7087719298245616), (0.3999999999999999, 0.8, 0.7228070175438597), (0.3999999999999999, 0.8, 0.7368421052631577), (0.3999999999999999, 0.8, 0.7508771929824558), (0.3999999999999999, 0.8, 0.7649122807017545), (0.3999999999999999, 0.8, 0.7789473684210526), (0.3999999999999999, 0.8, 0.7929824561403507), (0.3999999999999999, 0.7929824561403507, 0.8), (0.3999999999999999, 0.7789473684210526, 0.8), (0.3999999999999999, 0.7649122807017544, 0.8), (0.3999999999999999, 0.7508771929824563, 0.8), (0.3999999999999999, 0.7368421052631582, 0.8), (0.3999999999999999, 0.7228070175438595, 0.8), (0.3999999999999999, 0.7087719298245614, 0.8), (0.3999999999999999, 0.6947368421052633, 0.8), (0.3999999999999999, 0.6807017543859646, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6526315789473685, 0.8), (0.3999999999999999, 0.6385964912280703, 0.8), (0.3999999999999999, 0.6245614035087722, 0.8), (0.3999999999999999, 0.6105263157894735, 0.8), (0.3999999999999999, 0.5964912280701754, 0.8), (0.3999999999999999, 0.5824561403508772, 0.8), (0.3999999999999999, 0.5684210526315786, 0.8), (0.3999999999999999, 0.5543859649122805, 0.8), (0.3999999999999999, 0.5403508771929824, 0.8), (0.3999999999999999, 0.5263157894736843, 0.8), (0.3999999999999999, 0.5122807017543862, 0.8), (0.3999999999999999, 0.49824561403508755, 0.8), (0.3999999999999999, 0.4842105263157894, 0.8), (0.3999999999999999, 0.4701754385964913, 0.8), (0.3999999999999999, 0.4561403508771926, 0.8), (0.3999999999999999, 0.4421052631578945, 0.8), (0.3999999999999999, 0.4280701754385964, 0.8), (0.3999999999999999, 0.4140350877192983, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41403508771929803, 0.3999999999999999, 0.8), (0.42807017543859616, 0.3999999999999999, 0.8), (0.4421052631578943, 0.3999999999999999, 0.8), (0.4561403508771929, 0.3999999999999999, 0.8), (0.470175438596491, 0.3999999999999999, 0.8), (0.48421052631578915, 0.3999999999999999, 0.8), (0.49824561403508727, 0.3999999999999999, 0.8), (0.5122807017543853, 0.3999999999999999, 0.8), (0.5263157894736841, 0.3999999999999999, 0.8), (0.5403508771929821, 0.3999999999999999, 0.8), (0.5543859649122802, 0.3999999999999999, 0.8), (0.5684210526315789, 0.3999999999999999, 0.8), (0.582456140350877, 0.3999999999999999, 0.8), (0.5964912280701752, 0.3999999999999999, 0.8), (0.6105263157894733, 0.3999999999999999, 0.8), (0.6245614035087714, 0.3999999999999999, 0.8), (0.63859649122807, 0.3999999999999999, 0.8), (0.6526315789473681, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6807017543859649, 0.3999999999999999, 0.8), (0.6947368421052631, 0.3999999999999999, 0.8), (0.7087719298245612, 0.3999999999999999, 0.8), (0.7228070175438592, 0.3999999999999999, 0.8), (0.7368421052631573, 0.3999999999999999, 0.8), (0.750877192982456, 0.3999999999999999, 0.8), (0.7649122807017541, 0.3999999999999999, 0.8), (0.7789473684210522, 0.3999999999999999, 0.8), (0.7929824561403509, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7929824561403507), (0.8, 0.3999999999999999, 0.7789473684210526), (0.8, 0.3999999999999999, 0.7649122807017544), (0.8, 0.3999999999999999, 0.7508771929824563), (0.8, 0.3999999999999999, 0.7368421052631576), (0.8, 0.3999999999999999, 0.7228070175438595), (0.8, 0.3999999999999999, 0.7087719298245614), (0.8, 0.3999999999999999, 0.6947368421052628), (0.8, 0.3999999999999999, 0.6807017543859646), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6526315789473685), (0.8, 0.3999999999999999, 0.6385964912280703), (0.8, 0.3999999999999999, 0.6245614035087717), (0.8, 0.3999999999999999, 0.6105263157894735), (0.8, 0.3999999999999999, 0.5964912280701754), (0.8, 0.3999999999999999, 0.5824561403508768), (0.8, 0.3999999999999999, 0.5684210526315786), (0.8, 0.3999999999999999, 0.5543859649122805), (0.8, 0.3999999999999999, 0.5403508771929824), (0.8, 0.3999999999999999, 0.5263157894736843), (0.8, 0.3999999999999999, 0.5122807017543857), (0.8, 0.3999999999999999, 0.49824561403508755), (0.8, 0.3999999999999999, 0.4842105263157894), (0.8, 0.3999999999999999, 0.47017543859649075), (0.8, 0.3999999999999999, 0.4561403508771926), (0.8, 0.3999999999999999, 0.4421052631578945), (0.8, 0.3999999999999999, 0.4280701754385964), (0.8, 0.3999999999999999, 0.4140350877192983)],
    172: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41395348837209295, 0.3999999999999999), (0.8, 0.427906976744186, 0.3999999999999999), (0.8, 0.4418604651162791, 0.3999999999999999), (0.8, 0.4558139534883721, 0.3999999999999999), (0.8, 0.46976744186046515, 0.3999999999999999), (0.8, 0.48372093023255824, 0.3999999999999999), (0.8, 0.4976744186046513, 0.3999999999999999), (0.8, 0.5116279069767443, 0.3999999999999999), (0.8, 0.5255813953488374, 0.3999999999999999), (0.8, 0.5395348837209304, 0.3999999999999999), (0.8, 0.5534883720930235, 0.3999999999999999), (0.8, 0.567441860465116, 0.3999999999999999), (0.8, 0.581395348837209, 0.3999999999999999), (0.8, 0.5953488372093021, 0.3999999999999999), (0.8, 0.6093023255813952, 0.3999999999999999), (0.8, 0.6232558139534883, 0.3999999999999999), (0.8, 0.6372093023255813, 0.3999999999999999), (0.8, 0.6511627906976744, 0.3999999999999999), (0.8, 0.6651162790697673, 0.3999999999999999), (0.8, 0.6790697674418604, 0.3999999999999999), (0.8, 0.6930232558139535, 0.3999999999999999), (0.8, 0.7069767441860466, 0.3999999999999999), (0.8, 0.7209302325581396, 0.3999999999999999), (0.8, 0.7348837209302326, 0.3999999999999999), (0.8, 0.7488372093023257, 0.3999999999999999), (0.8, 0.7627906976744188, 0.3999999999999999), (0.8, 0.7767441860465119, 0.3999999999999999), (0.8, 0.790697674418605, 0.3999999999999999), (0.7953488372093023, 0.8, 0.3999999999999999), (0.7813953488372092, 0.8, 0.3999999999999999), (0.7674418604651168, 0.8, 0.3999999999999999), (0.7534883720930237, 0.8, 0.3999999999999999), (0.7395348837209306, 0.8, 0.3999999999999999), (0.7255813953488375, 0.8, 0.3999999999999999), (0.7116279069767445, 0.8, 0.3999999999999999), (0.6976744186046515, 0.8, 0.3999999999999999), (0.6837209302325584, 0.8, 0.3999999999999999), (0.6697674418604653, 0.8, 0.3999999999999999), (0.6558139534883722, 0.8, 0.3999999999999999), (0.6418604651162793, 0.8, 0.3999999999999999), (0.6279069767441862, 0.8, 0.3999999999999999), (0.6139534883720932, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.586046511627907, 0.8, 0.3999999999999999), (0.5720930232558139, 0.8, 0.3999999999999999), (0.5581395348837209, 0.8, 0.3999999999999999), (0.5441860465116278, 0.8, 0.3999999999999999), (0.5302325581395348, 0.8, 0.3999999999999999), (0.5162790697674418, 0.8, 0.3999999999999999), (0.5023255813953487, 0.8, 0.3999999999999999), (0.4883720930232556, 0.8, 0.3999999999999999), (0.4744186046511626, 0.8, 0.3999999999999999), (0.46046511627906955, 0.8, 0.3999999999999999), (0.4465116279069765, 0.8, 0.3999999999999999), (0.4325581395348834, 0.8, 0.3999999999999999), (0.4186046511627904, 0.8, 0.3999999999999999), (0.40465116279069785, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4093023255813951), (0.3999999999999999, 0.8, 0.4232558139534882), (0.3999999999999999, 0.8, 0.43720930232558125), (0.3999999999999999, 0.8, 0.4511627906976743), (0.3999999999999999, 0.8, 0.4651162790697674), (0.3999999999999999, 0.8, 0.4790697674418604), (0.3999999999999999, 0.8, 0.49302325581395345), (0.3999999999999999, 0.8, 0.5069767441860465), (0.3999999999999999, 0.8, 0.5209302325581395), (0.3999999999999999, 0.8, 0.5348837209302326), (0.3999999999999999, 0.8, 0.5488372093023257), (0.3999999999999999, 0.8, 0.5627906976744187), (0.3999999999999999, 0.8, 0.5767441860465118), (0.3999999999999999, 0.8, 0.5906976744186049), (0.3999999999999999, 0.8, 0.6046511627906973), (0.3999999999999999, 0.8, 0.6186046511627904), (0.3999999999999999, 0.8, 0.6325581395348835), (0.3999999999999999, 0.8, 0.6465116279069765), (0.3999999999999999, 0.8, 0.6604651162790696), (0.3999999999999999, 0.8, 0.6744186046511627), (0.3999999999999999, 0.8, 0.6883720930232557), (0.3999999999999999, 0.8, 0.7023255813953487), (0.3999999999999999, 0.8, 0.7162790697674417), (0.3999999999999999, 0.8, 0.7302325581395348), (0.3999999999999999, 0.8, 0.7441860465116279), (0.3999999999999999, 0.8, 0.758139534883721), (0.3999999999999999, 0.8, 0.772093023255814), (0.3999999999999999, 0.8, 0.786046511627907), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.786046511627907, 0.8), (0.3999999999999999, 0.7720930232558139, 0.8), (0.3999999999999999, 0.7581395348837208, 0.8), (0.3999999999999999, 0.7441860465116277, 0.8), (0.3999999999999999, 0.7302325581395347, 0.8), (0.3999999999999999, 0.7162790697674417, 0.8), (0.3999999999999999, 0.7023255813953486, 0.8), (0.3999999999999999, 0.6883720930232555, 0.8), (0.3999999999999999, 0.6744186046511624, 0.8), (0.3999999999999999, 0.6604651162790695, 0.8), (0.3999999999999999, 0.6465116279069764, 0.8), (0.3999999999999999, 0.6325581395348834, 0.8), (0.3999999999999999, 0.6186046511627903, 0.8), (0.3999999999999999, 0.6046511627906972, 0.8), (0.3999999999999999, 0.5906976744186042, 0.8), (0.3999999999999999, 0.5767441860465117, 0.8), (0.3999999999999999, 0.5627906976744186, 0.8), (0.3999999999999999, 0.5488372093023255, 0.8), (0.3999999999999999, 0.5348837209302325, 0.8), (0.3999999999999999, 0.5209302325581394, 0.8), (0.3999999999999999, 0.5069767441860464, 0.8), (0.3999999999999999, 0.49302325581395334, 0.8), (0.3999999999999999, 0.47906976744186025, 0.8), (0.3999999999999999, 0.4651162790697672, 0.8), (0.3999999999999999, 0.4511627906976742, 0.8), (0.3999999999999999, 0.43720930232558114, 0.8), (0.3999999999999999, 0.4232558139534886, 0.8), (0.3999999999999999, 0.40930232558139557, 0.8), (0.40465116279069707, 0.3999999999999999, 0.8), (0.4186046511627901, 0.3999999999999999, 0.8), (0.43255813953488315, 0.3999999999999999, 0.8), (0.44651162790697624, 0.3999999999999999, 0.8), (0.4604651162790693, 0.3999999999999999, 0.8), (0.4744186046511623, 0.3999999999999999, 0.8), (0.48837209302325535, 0.3999999999999999, 0.8), (0.5023255813953484, 0.3999999999999999, 0.8), (0.5162790697674415, 0.3999999999999999, 0.8), (0.5302325581395345, 0.3999999999999999, 0.8), (0.5441860465116276, 0.3999999999999999, 0.8), (0.5581395348837206, 0.3999999999999999, 0.8), (0.5720930232558137, 0.3999999999999999, 0.8), (0.5860465116279068, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6139534883720928, 0.3999999999999999, 0.8), (0.6279069767441859, 0.3999999999999999, 0.8), (0.6418604651162789, 0.3999999999999999, 0.8), (0.655813953488372, 0.3999999999999999, 0.8), (0.6697674418604651, 0.3999999999999999, 0.8), (0.6837209302325582, 0.3999999999999999, 0.8), (0.6976744186046512, 0.3999999999999999, 0.8), (0.7116279069767442, 0.3999999999999999, 0.8), (0.7255813953488373, 0.3999999999999999, 0.8), (0.7395348837209303, 0.3999999999999999, 0.8), (0.7534883720930234, 0.3999999999999999, 0.8), (0.7674418604651164, 0.3999999999999999, 0.8), (0.7813953488372094, 0.3999999999999999, 0.8), (0.7953488372093025, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7906976744186045), (0.8, 0.3999999999999999, 0.7767441860465116), (0.8, 0.3999999999999999, 0.7627906976744185), (0.8, 0.3999999999999999, 0.7488372093023254), (0.8, 0.3999999999999999, 0.7348837209302324), (0.8, 0.3999999999999999, 0.7209302325581393), (0.8, 0.3999999999999999, 0.7069767441860463), (0.8, 0.3999999999999999, 0.6930232558139533), (0.8, 0.3999999999999999, 0.6790697674418602), (0.8, 0.3999999999999999, 0.6651162790697671), (0.8, 0.3999999999999999, 0.651162790697674), (0.8, 0.3999999999999999, 0.6372093023255816), (0.8, 0.3999999999999999, 0.6232558139534885), (0.8, 0.3999999999999999, 0.6093023255813954), (0.8, 0.3999999999999999, 0.5953488372093024), (0.8, 0.3999999999999999, 0.5813953488372093), (0.8, 0.3999999999999999, 0.5674418604651162), (0.8, 0.3999999999999999, 0.5534883720930233), (0.8, 0.3999999999999999, 0.5395348837209302), (0.8, 0.3999999999999999, 0.5255813953488371), (0.8, 0.3999999999999999, 0.5116279069767441), (0.8, 0.3999999999999999, 0.497674418604651), (0.8, 0.3999999999999999, 0.48372093023255797), (0.8, 0.3999999999999999, 0.46976744186046493), (0.8, 0.3999999999999999, 0.45581395348837184), (0.8, 0.3999999999999999, 0.4418604651162788), (0.8, 0.3999999999999999, 0.42790697674418576), (0.8, 0.3999999999999999, 0.41395348837209267)],
    173: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4138728323699422, 0.3999999999999999), (0.8, 0.42774566473988457, 0.3999999999999999), (0.8, 0.44161849710982637, 0.3999999999999999), (0.8, 0.45549132947976867, 0.3999999999999999), (0.8, 0.469364161849711, 0.3999999999999999), (0.8, 0.4832369942196533, 0.3999999999999999), (0.8, 0.4971098265895951, 0.3999999999999999), (0.8, 0.5109826589595374, 0.3999999999999999), (0.8, 0.5248554913294798, 0.3999999999999999), (0.8, 0.5387283236994221, 0.3999999999999999), (0.8, 0.5526011560693639, 0.3999999999999999), (0.8, 0.5664739884393062, 0.3999999999999999), (0.8, 0.5803468208092486, 0.3999999999999999), (0.8, 0.5942196531791909, 0.3999999999999999), (0.8, 0.6080924855491326, 0.3999999999999999), (0.8, 0.6219653179190751, 0.3999999999999999), (0.8, 0.6358381502890174, 0.3999999999999999), (0.8, 0.6497109826589597, 0.3999999999999999), (0.8, 0.6635838150289015, 0.3999999999999999), (0.8, 0.6774566473988438, 0.3999999999999999), (0.8, 0.6913294797687861, 0.3999999999999999), (0.8, 0.7052023121387285, 0.3999999999999999), (0.8, 0.7190751445086707, 0.3999999999999999), (0.8, 0.7329479768786126, 0.3999999999999999), (0.8, 0.7468208092485549, 0.3999999999999999), (0.8, 0.7606936416184973, 0.3999999999999999), (0.8, 0.7745664739884396, 0.3999999999999999), (0.8, 0.7884393063583814, 0.3999999999999999), (0.7976878612716765, 0.8, 0.3999999999999999), (0.7838150289017343, 0.8, 0.3999999999999999), (0.7699421965317919, 0.8, 0.3999999999999999), (0.7560693641618501, 0.8, 0.3999999999999999), (0.7421965317919077, 0.8, 0.3999999999999999), (0.7283236994219654, 0.8, 0.3999999999999999), (0.7144508670520231, 0.8, 0.3999999999999999), (0.7005780346820814, 0.8, 0.3999999999999999), (0.6867052023121389, 0.8, 0.3999999999999999), (0.6728323699421966, 0.8, 0.3999999999999999), (0.6589595375722543, 0.8, 0.3999999999999999), (0.6450867052023125, 0.8, 0.3999999999999999), (0.6312138728323702, 0.8, 0.3999999999999999), (0.6173410404624279, 0.8, 0.3999999999999999), (0.6034682080924855, 0.8, 0.3999999999999999), (0.5895953757225432, 0.8, 0.3999999999999999), (0.5757225433526014, 0.8, 0.3999999999999999), (0.561849710982659, 0.8, 0.3999999999999999), (0.5479768786127167, 0.8, 0.3999999999999999), (0.534104046242775, 0.8, 0.3999999999999999), (0.5202312138728327, 0.8, 0.3999999999999999), (0.5063583815028903, 0.8, 0.3999999999999999), (0.49248554913294795, 0.8, 0.3999999999999999), (0.47861271676300565, 0.8, 0.3999999999999999), (0.46473988439306385, 0.8, 0.3999999999999999), (0.4508670520231215, 0.8, 0.3999999999999999), (0.4369942196531792, 0.8, 0.3999999999999999), (0.42312138728323684, 0.8, 0.3999999999999999), (0.40924855491329454, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4046242774566472), (0.3999999999999999, 0.8, 0.41849710982658955), (0.3999999999999999, 0.8, 0.43236994219653185), (0.3999999999999999, 0.8, 0.44624277456647365), (0.3999999999999999, 0.8, 0.460115606936416), (0.3999999999999999, 0.8, 0.4739884393063583), (0.3999999999999999, 0.8, 0.48786127167630067), (0.3999999999999999, 0.8, 0.501734104046243), (0.3999999999999999, 0.8, 0.5156069364161848), (0.3999999999999999, 0.8, 0.5294797687861271), (0.3999999999999999, 0.8, 0.5433526011560694), (0.3999999999999999, 0.8, 0.5572254335260112), (0.3999999999999999, 0.8, 0.5710982658959536), (0.3999999999999999, 0.8, 0.5849710982658959), (0.3999999999999999, 0.8, 0.5988439306358382), (0.3999999999999999, 0.8, 0.6127167630057806), (0.3999999999999999, 0.8, 0.6265895953757223), (0.3999999999999999, 0.8, 0.6404624277456646), (0.3999999999999999, 0.8, 0.6543352601156069), (0.3999999999999999, 0.8, 0.6682080924855494), (0.3999999999999999, 0.8, 0.6820809248554917), (0.3999999999999999, 0.8, 0.6959537572254335), (0.3999999999999999, 0.8, 0.7098265895953757), (0.3999999999999999, 0.8, 0.7236994219653181), (0.3999999999999999, 0.8, 0.7375722543352599), (0.3999999999999999, 0.8, 0.7514450867052023), (0.3999999999999999, 0.8, 0.7653179190751446), (0.3999999999999999, 0.8, 0.7791907514450869), (0.3999999999999999, 0.8, 0.7930635838150293), (0.3999999999999999, 0.7930635838150291, 0.8), (0.3999999999999999, 0.7791907514450866, 0.8), (0.3999999999999999, 0.7653179190751445, 0.8), (0.3999999999999999, 0.7514450867052026, 0.8), (0.3999999999999999, 0.7375722543352597, 0.8), (0.3999999999999999, 0.7236994219653179, 0.8), (0.3999999999999999, 0.7098265895953757, 0.8), (0.3999999999999999, 0.6959537572254333, 0.8), (0.3999999999999999, 0.6820809248554915, 0.8), (0.3999999999999999, 0.6682080924855491, 0.8), (0.3999999999999999, 0.6543352601156068, 0.8), (0.3999999999999999, 0.6404624277456651, 0.8), (0.3999999999999999, 0.6265895953757222, 0.8), (0.3999999999999999, 0.6127167630057804, 0.8), (0.3999999999999999, 0.5988439306358381, 0.8), (0.3999999999999999, 0.5849710982658958, 0.8), (0.3999999999999999, 0.5710982658959539, 0.8), (0.3999999999999999, 0.5572254335260116, 0.8), (0.3999999999999999, 0.5433526011560693, 0.8), (0.3999999999999999, 0.5294797687861275, 0.8), (0.3999999999999999, 0.5156069364161846, 0.8), (0.3999999999999999, 0.5017341040462429, 0.8), (0.3999999999999999, 0.4878612716763005, 0.8), (0.3999999999999999, 0.4739884393063582, 0.8), (0.3999999999999999, 0.4601156069364164, 0.8), (0.3999999999999999, 0.44624277456647354, 0.8), (0.3999999999999999, 0.43236994219653174, 0.8), (0.3999999999999999, 0.4184971098265894, 0.8), (0.3999999999999999, 0.4046242774566471, 0.8), (0.40924855491329426, 0.3999999999999999, 0.8), (0.42312138728323656, 0.3999999999999999, 0.8), (0.4369942196531789, 0.3999999999999999, 0.8), (0.4508670520231207, 0.3999999999999999, 0.8), (0.4647398843930636, 0.3999999999999999, 0.8), (0.4786127167630054, 0.3999999999999999, 0.8), (0.49248554913294773, 0.3999999999999999, 0.8), (0.50635838150289, 0.3999999999999999, 0.8), (0.5202312138728318, 0.3999999999999999, 0.8), (0.5341040462427742, 0.3999999999999999, 0.8), (0.5479768786127165, 0.3999999999999999, 0.8), (0.5618497109826582, 0.3999999999999999, 0.8), (0.5757225433526011, 0.3999999999999999, 0.8), (0.589595375722543, 0.3999999999999999, 0.8), (0.6034682080924852, 0.3999999999999999, 0.8), (0.6173410404624275, 0.3999999999999999, 0.8), (0.6312138728323694, 0.3999999999999999, 0.8), (0.6450867052023123, 0.3999999999999999, 0.8), (0.658959537572254, 0.3999999999999999, 0.8), (0.6728323699421963, 0.3999999999999999, 0.8), (0.6867052023121387, 0.3999999999999999, 0.8), (0.7005780346820805, 0.3999999999999999, 0.8), (0.7144508670520229, 0.3999999999999999, 0.8), (0.7283236994219651, 0.3999999999999999, 0.8), (0.7421965317919069, 0.3999999999999999, 0.8), (0.7560693641618498, 0.3999999999999999, 0.8), (0.7699421965317916, 0.3999999999999999, 0.8), (0.7838150289017338, 0.3999999999999999, 0.8), (0.7976878612716762, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7884393063583817), (0.8, 0.3999999999999999, 0.7745664739884393), (0.8, 0.3999999999999999, 0.760693641618497), (0.8, 0.3999999999999999, 0.7468208092485551), (0.8, 0.3999999999999999, 0.7329479768786122), (0.8, 0.3999999999999999, 0.7190751445086705), (0.8, 0.3999999999999999, 0.7052023121387282), (0.8, 0.3999999999999999, 0.6913294797687859), (0.8, 0.3999999999999999, 0.6774566473988441), (0.8, 0.3999999999999999, 0.6635838150289013), (0.8, 0.3999999999999999, 0.6497109826589594), (0.8, 0.3999999999999999, 0.6358381502890171), (0.8, 0.3999999999999999, 0.6219653179190747), (0.8, 0.3999999999999999, 0.608092485549133), (0.8, 0.3999999999999999, 0.5942196531791907), (0.8, 0.3999999999999999, 0.5803468208092483), (0.8, 0.3999999999999999, 0.5664739884393065), (0.8, 0.3999999999999999, 0.5526011560693637), (0.8, 0.3999999999999999, 0.5387283236994218), (0.8, 0.3999999999999999, 0.5248554913294795), (0.8, 0.3999999999999999, 0.5109826589595372), (0.8, 0.3999999999999999, 0.4971098265895954), (0.8, 0.3999999999999999, 0.48323699421965305), (0.8, 0.3999999999999999, 0.46936416184971075), (0.8, 0.3999999999999999, 0.45549132947976895), (0.8, 0.3999999999999999, 0.4416184971098261), (0.8, 0.3999999999999999, 0.4277456647398843), (0.8, 0.3999999999999999, 0.413872832369942)],
    174: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4137931034482759, 0.3999999999999999), (0.8, 0.42758620689655186, 0.3999999999999999), (0.8, 0.4413793103448273, 0.3999999999999999), (0.8, 0.4551724137931033, 0.3999999999999999), (0.8, 0.4689655172413793, 0.3999999999999999), (0.8, 0.48275862068965525, 0.3999999999999999), (0.8, 0.49655172413793075, 0.3999999999999999), (0.8, 0.5103448275862067, 0.3999999999999999), (0.8, 0.5241379310344827, 0.3999999999999999), (0.8, 0.5379310344827587, 0.3999999999999999), (0.8, 0.5517241379310347, 0.3999999999999999), (0.8, 0.5655172413793101, 0.3999999999999999), (0.8, 0.579310344827586, 0.3999999999999999), (0.8, 0.593103448275862, 0.3999999999999999), (0.8, 0.606896551724138, 0.3999999999999999), (0.8, 0.6206896551724135, 0.3999999999999999), (0.8, 0.6344827586206895, 0.3999999999999999), (0.8, 0.6482758620689655, 0.3999999999999999), (0.8, 0.6620689655172415, 0.3999999999999999), (0.8, 0.6758620689655175, 0.3999999999999999), (0.8, 0.6896551724137929, 0.3999999999999999), (0.8, 0.7034482758620688, 0.3999999999999999), (0.8, 0.7172413793103449, 0.3999999999999999), (0.8, 0.7310344827586208, 0.3999999999999999), (0.8, 0.7448275862068968, 0.3999999999999999), (0.8, 0.7586206896551723, 0.3999999999999999), (0.8, 0.7724137931034483, 0.3999999999999999), (0.8, 0.7862068965517242, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7862068965517239, 0.8, 0.3999999999999999), (0.7724137931034485, 0.8, 0.3999999999999999), (0.7586206896551726, 0.8, 0.3999999999999999), (0.7448275862068965, 0.8, 0.3999999999999999), (0.731034482758621, 0.8, 0.3999999999999999), (0.7172413793103452, 0.8, 0.3999999999999999), (0.7034482758620692, 0.8, 0.3999999999999999), (0.6896551724137931, 0.8, 0.3999999999999999), (0.6758620689655173, 0.8, 0.3999999999999999), (0.6620689655172417, 0.8, 0.3999999999999999), (0.6482758620689657, 0.8, 0.3999999999999999), (0.6344827586206898, 0.8, 0.3999999999999999), (0.6206896551724138, 0.8, 0.3999999999999999), (0.6068965517241378, 0.8, 0.3999999999999999), (0.5931034482758624, 0.8, 0.3999999999999999), (0.5793103448275864, 0.8, 0.3999999999999999), (0.5655172413793104, 0.8, 0.3999999999999999), (0.5517241379310344, 0.8, 0.3999999999999999), (0.5379310344827584, 0.8, 0.3999999999999999), (0.5241379310344829, 0.8, 0.3999999999999999), (0.510344827586207, 0.8, 0.3999999999999999), (0.49655172413793097, 0.8, 0.3999999999999999), (0.4827586206896555, 0.8, 0.3999999999999999), (0.468965517241379, 0.8, 0.3999999999999999), (0.4551724137931036, 0.8, 0.3999999999999999), (0.4413793103448276, 0.8, 0.3999999999999999), (0.4275862068965516, 0.8, 0.3999999999999999), (0.41379310344827613, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41379310344827575), (0.3999999999999999, 0.8, 0.42758620689655175), (0.3999999999999999, 0.8, 0.44137931034482775), (0.3999999999999999, 0.8, 0.4551724137931032), (0.3999999999999999, 0.8, 0.46896551724137914), (0.3999999999999999, 0.8, 0.48275862068965514), (0.3999999999999999, 0.8, 0.49655172413793114), (0.3999999999999999, 0.8, 0.5103448275862071), (0.3999999999999999, 0.8, 0.5241379310344826), (0.3999999999999999, 0.8, 0.5379310344827586), (0.3999999999999999, 0.8, 0.5517241379310345), (0.3999999999999999, 0.8, 0.5655172413793105), (0.3999999999999999, 0.8, 0.5793103448275865), (0.3999999999999999, 0.8, 0.5931034482758619), (0.3999999999999999, 0.8, 0.6068965517241379), (0.3999999999999999, 0.8, 0.6206896551724139), (0.3999999999999999, 0.8, 0.6344827586206894), (0.3999999999999999, 0.8, 0.6482758620689659), (0.3999999999999999, 0.8, 0.6620689655172414), (0.3999999999999999, 0.8, 0.6758620689655173), (0.3999999999999999, 0.8, 0.6896551724137934), (0.3999999999999999, 0.8, 0.7034482758620688), (0.3999999999999999, 0.8, 0.7172413793103447), (0.3999999999999999, 0.8, 0.7310344827586207), (0.3999999999999999, 0.8, 0.7448275862068967), (0.3999999999999999, 0.8, 0.7586206896551726), (0.3999999999999999, 0.8, 0.7724137931034482), (0.3999999999999999, 0.8, 0.7862068965517242), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7862068965517239, 0.8), (0.3999999999999999, 0.772413793103448, 0.8), (0.3999999999999999, 0.7586206896551726, 0.8), (0.3999999999999999, 0.7448275862068965, 0.8), (0.3999999999999999, 0.7310344827586206, 0.8), (0.3999999999999999, 0.7172413793103452, 0.8), (0.3999999999999999, 0.7034482758620686, 0.8), (0.3999999999999999, 0.6896551724137931, 0.8), (0.3999999999999999, 0.6758620689655173, 0.8), (0.3999999999999999, 0.6620689655172411, 0.8), (0.3999999999999999, 0.6482758620689657, 0.8), (0.3999999999999999, 0.6344827586206893, 0.8), (0.3999999999999999, 0.6206896551724138, 0.8), (0.3999999999999999, 0.6068965517241378, 0.8), (0.3999999999999999, 0.5931034482758618, 0.8), (0.3999999999999999, 0.5793103448275864, 0.8), (0.3999999999999999, 0.5655172413793104, 0.8), (0.3999999999999999, 0.5517241379310344, 0.8), (0.3999999999999999, 0.5379310344827584, 0.8), (0.3999999999999999, 0.5241379310344825, 0.8), (0.3999999999999999, 0.510344827586207, 0.8), (0.3999999999999999, 0.49655172413793097, 0.8), (0.3999999999999999, 0.482758620689655, 0.8), (0.3999999999999999, 0.4689655172413796, 0.8), (0.3999999999999999, 0.455172413793103, 0.8), (0.3999999999999999, 0.4413793103448276, 0.8), (0.3999999999999999, 0.4275862068965516, 0.8), (0.3999999999999999, 0.41379310344827563, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4137931034482759, 0.3999999999999999, 0.8), (0.42758620689655136, 0.3999999999999999, 0.8), (0.4413793103448273, 0.3999999999999999, 0.8), (0.4551724137931033, 0.3999999999999999, 0.8), (0.46896551724137875, 0.3999999999999999, 0.8), (0.48275862068965525, 0.3999999999999999, 0.8), (0.49655172413793075, 0.3999999999999999, 0.8), (0.5103448275862067, 0.3999999999999999, 0.8), (0.5241379310344827, 0.3999999999999999, 0.8), (0.5379310344827581, 0.3999999999999999, 0.8), (0.5517241379310341, 0.3999999999999999, 0.8), (0.5655172413793101, 0.3999999999999999, 0.8), (0.579310344827586, 0.3999999999999999, 0.8), (0.593103448275862, 0.3999999999999999, 0.8), (0.6068965517241375, 0.3999999999999999, 0.8), (0.6206896551724135, 0.3999999999999999, 0.8), (0.6344827586206895, 0.3999999999999999, 0.8), (0.6482758620689649, 0.3999999999999999, 0.8), (0.6620689655172415, 0.3999999999999999, 0.8), (0.6758620689655169, 0.3999999999999999, 0.8), (0.6896551724137929, 0.3999999999999999, 0.8), (0.7034482758620688, 0.3999999999999999, 0.8), (0.7172413793103443, 0.3999999999999999, 0.8), (0.7310344827586208, 0.3999999999999999, 0.8), (0.7448275862068963, 0.3999999999999999, 0.8), (0.7586206896551723, 0.3999999999999999, 0.8), (0.7724137931034483, 0.3999999999999999, 0.8), (0.7862068965517237, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7862068965517239), (0.8, 0.3999999999999999, 0.772413793103448), (0.8, 0.3999999999999999, 0.7586206896551719), (0.8, 0.3999999999999999, 0.7448275862068965), (0.8, 0.3999999999999999, 0.7310344827586206), (0.8, 0.3999999999999999, 0.7172413793103446), (0.8, 0.3999999999999999, 0.7034482758620686), (0.8, 0.3999999999999999, 0.6896551724137927), (0.8, 0.3999999999999999, 0.6758620689655173), (0.8, 0.3999999999999999, 0.6620689655172411), (0.8, 0.3999999999999999, 0.6482758620689653), (0.8, 0.3999999999999999, 0.6344827586206898), (0.8, 0.3999999999999999, 0.6206896551724133), (0.8, 0.3999999999999999, 0.6068965517241378), (0.8, 0.3999999999999999, 0.5931034482758618), (0.8, 0.3999999999999999, 0.5793103448275858), (0.8, 0.3999999999999999, 0.5655172413793104), (0.8, 0.3999999999999999, 0.5517241379310338), (0.8, 0.3999999999999999, 0.5379310344827584), (0.8, 0.3999999999999999, 0.5241379310344825), (0.8, 0.3999999999999999, 0.5103448275862065), (0.8, 0.3999999999999999, 0.49655172413793097), (0.8, 0.3999999999999999, 0.482758620689655), (0.8, 0.3999999999999999, 0.468965517241379), (0.8, 0.3999999999999999, 0.455172413793103), (0.8, 0.3999999999999999, 0.4413793103448271), (0.8, 0.3999999999999999, 0.4275862068965516), (0.8, 0.3999999999999999, 0.41379310344827563)],
    175: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4137142857142858, 0.3999999999999999), (0.8, 0.42742857142857116, 0.3999999999999999), (0.8, 0.441142857142857, 0.3999999999999999), (0.8, 0.4548571428571429, 0.3999999999999999), (0.8, 0.46857142857142825, 0.3999999999999999), (0.8, 0.48228571428571415, 0.3999999999999999), (0.8, 0.49600000000000005, 0.3999999999999999), (0.8, 0.5097142857142859, 0.3999999999999999), (0.8, 0.5234285714285712, 0.3999999999999999), (0.8, 0.5371428571428571, 0.3999999999999999), (0.8, 0.550857142857143, 0.3999999999999999), (0.8, 0.5645714285714284, 0.3999999999999999), (0.8, 0.5782857142857143, 0.3999999999999999), (0.8, 0.5920000000000002, 0.3999999999999999), (0.8, 0.6057142857142855, 0.3999999999999999), (0.8, 0.6194285714285714, 0.3999999999999999), (0.8, 0.6331428571428572, 0.3999999999999999), (0.8, 0.6468571428571426, 0.3999999999999999), (0.8, 0.6605714285714285, 0.3999999999999999), (0.8, 0.6742857142857144, 0.3999999999999999), (0.8, 0.6880000000000003, 0.3999999999999999), (0.8, 0.7017142857142856, 0.3999999999999999), (0.8, 0.7154285714285715, 0.3999999999999999), (0.8, 0.7291428571428573, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7565714285714287, 0.3999999999999999), (0.8, 0.7702857142857145, 0.3999999999999999), (0.8, 0.7839999999999998, 0.3999999999999999), (0.8, 0.7977142857142858, 0.3999999999999999), (0.7885714285714285, 0.8, 0.3999999999999999), (0.7748571428571432, 0.8, 0.3999999999999999), (0.7611428571428573, 0.8, 0.3999999999999999), (0.7474285714285714, 0.8, 0.3999999999999999), (0.7337142857142855, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7062857142857144, 0.8, 0.3999999999999999), (0.6925714285714284, 0.8, 0.3999999999999999), (0.678857142857143, 0.8, 0.3999999999999999), (0.6651428571428573, 0.8, 0.3999999999999999), (0.6514285714285714, 0.8, 0.3999999999999999), (0.637714285714286, 0.8, 0.3999999999999999), (0.6240000000000001, 0.8, 0.3999999999999999), (0.6102857142857142, 0.8, 0.3999999999999999), (0.5965714285714289, 0.8, 0.3999999999999999), (0.582857142857143, 0.8, 0.3999999999999999), (0.5691428571428571, 0.8, 0.3999999999999999), (0.5554285714285712, 0.8, 0.3999999999999999), (0.5417142857142858, 0.8, 0.3999999999999999), (0.528, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.5005714285714288, 0.8, 0.3999999999999999), (0.4868571428571429, 0.8, 0.3999999999999999), (0.473142857142857, 0.8, 0.3999999999999999), (0.45942857142857163, 0.8, 0.3999999999999999), (0.44571428571428573, 0.8, 0.3999999999999999), (0.4319999999999999, 0.8, 0.3999999999999999), (0.4182857142857145, 0.8, 0.3999999999999999), (0.40457142857142864, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4091428571428572), (0.3999999999999999, 0.8, 0.4228571428571431), (0.3999999999999999, 0.8, 0.43657142857142844), (0.3999999999999999, 0.8, 0.45028571428571434), (0.3999999999999999, 0.8, 0.4639999999999997), (0.3999999999999999, 0.8, 0.47771428571428554), (0.3999999999999999, 0.8, 0.49142857142857144), (0.3999999999999999, 0.8, 0.5051428571428573), (0.3999999999999999, 0.8, 0.5188571428571427), (0.3999999999999999, 0.8, 0.5325714285714286), (0.3999999999999999, 0.8, 0.5462857142857145), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5737142857142856), (0.3999999999999999, 0.8, 0.5874285714285716), (0.3999999999999999, 0.8, 0.6011428571428574), (0.3999999999999999, 0.8, 0.6148571428571428), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.642285714285714), (0.3999999999999999, 0.8, 0.6559999999999999), (0.3999999999999999, 0.8, 0.6697142857142858), (0.3999999999999999, 0.8, 0.6834285714285717), (0.3999999999999999, 0.8, 0.6971428571428571), (0.3999999999999999, 0.8, 0.7108571428571429), (0.3999999999999999, 0.8, 0.7245714285714289), (0.3999999999999999, 0.8, 0.7382857142857142), (0.3999999999999999, 0.8, 0.752), (0.3999999999999999, 0.8, 0.7657142857142859), (0.3999999999999999, 0.8, 0.7794285714285718), (0.3999999999999999, 0.8, 0.7931428571428571), (0.3999999999999999, 0.7931428571428569, 0.8), (0.3999999999999999, 0.7794285714285716, 0.8), (0.3999999999999999, 0.7657142857142858, 0.8), (0.3999999999999999, 0.7519999999999999, 0.8), (0.3999999999999999, 0.738285714285714, 0.8), (0.3999999999999999, 0.7245714285714282, 0.8), (0.3999999999999999, 0.7108571428571429, 0.8), (0.3999999999999999, 0.6971428571428575, 0.8), (0.3999999999999999, 0.6834285714285715, 0.8), (0.3999999999999999, 0.6697142857142857, 0.8), (0.3999999999999999, 0.6559999999999998, 0.8), (0.3999999999999999, 0.6422857142857139, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6148571428571427, 0.8), (0.3999999999999999, 0.6011428571428573, 0.8), (0.3999999999999999, 0.5874285714285714, 0.8), (0.3999999999999999, 0.5737142857142855, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5462857142857138, 0.8), (0.3999999999999999, 0.5325714285714285, 0.8), (0.3999999999999999, 0.5188571428571431, 0.8), (0.3999999999999999, 0.5051428571428572, 0.8), (0.3999999999999999, 0.4914285714285713, 0.8), (0.3999999999999999, 0.4777142857142854, 0.8), (0.3999999999999999, 0.4639999999999995, 0.8), (0.3999999999999999, 0.4502857142857142, 0.8), (0.3999999999999999, 0.43657142857142833, 0.8), (0.3999999999999999, 0.42285714285714293, 0.8), (0.3999999999999999, 0.4091428571428571, 0.8), (0.40457142857142836, 0.3999999999999999, 0.8), (0.41828571428571426, 0.3999999999999999, 0.8), (0.4320000000000001, 0.3999999999999999, 0.8), (0.4457142857142855, 0.3999999999999999, 0.8), (0.45942857142857085, 0.3999999999999999, 0.8), (0.4731428571428567, 0.3999999999999999, 0.8), (0.4868571428571426, 0.3999999999999999, 0.8), (0.5005714285714284, 0.3999999999999999, 0.8), (0.5142857142857143, 0.3999999999999999, 0.8), (0.5279999999999997, 0.3999999999999999, 0.8), (0.5417142857142856, 0.3999999999999999, 0.8), (0.5554285714285709, 0.3999999999999999, 0.8), (0.5691428571428568, 0.3999999999999999, 0.8), (0.5828571428571427, 0.3999999999999999, 0.8), (0.5965714285714286, 0.3999999999999999, 0.8), (0.6102857142857144, 0.3999999999999999, 0.8), (0.6239999999999999, 0.3999999999999999, 0.8), (0.6377142857142852, 0.3999999999999999, 0.8), (0.651428571428571, 0.3999999999999999, 0.8), (0.665142857142857, 0.3999999999999999, 0.8), (0.6788571428571428, 0.3999999999999999, 0.8), (0.6925714285714287, 0.3999999999999999, 0.8), (0.7062857142857141, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7337142857142853, 0.3999999999999999, 0.8), (0.7474285714285711, 0.3999999999999999, 0.8), (0.7611428571428571, 0.3999999999999999, 0.8), (0.7748571428571429, 0.3999999999999999, 0.8), (0.7885714285714289, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7977142857142854), (0.8, 0.3999999999999999, 0.784), (0.8, 0.3999999999999999, 0.7702857142857142), (0.8, 0.3999999999999999, 0.7565714285714283), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7291428571428566), (0.8, 0.3999999999999999, 0.7154285714285713), (0.8, 0.3999999999999999, 0.7017142857142853), (0.8, 0.3999999999999999, 0.688), (0.8, 0.3999999999999999, 0.6742857142857142), (0.8, 0.3999999999999999, 0.6605714285714283), (0.8, 0.3999999999999999, 0.6468571428571424), (0.8, 0.3999999999999999, 0.633142857142857), (0.8, 0.3999999999999999, 0.6194285714285711), (0.8, 0.3999999999999999, 0.6057142857142858), (0.8, 0.3999999999999999, 0.5919999999999999), (0.8, 0.3999999999999999, 0.578285714285714), (0.8, 0.3999999999999999, 0.5645714285714281), (0.8, 0.3999999999999999, 0.5508571428571423), (0.8, 0.3999999999999999, 0.5371428571428569), (0.8, 0.3999999999999999, 0.523428571428571), (0.8, 0.3999999999999999, 0.5097142857142857), (0.8, 0.3999999999999999, 0.4959999999999998), (0.8, 0.3999999999999999, 0.4822857142857139), (0.8, 0.3999999999999999, 0.468571428571428), (0.8, 0.3999999999999999, 0.4548571428571426), (0.8, 0.3999999999999999, 0.4411428571428568), (0.8, 0.3999999999999999, 0.4274285714285714), (0.8, 0.3999999999999999, 0.41371428571428553)],
    176: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4136363636363634, 0.3999999999999999), (0.8, 0.4272727272727274, 0.3999999999999999), (0.8, 0.4409090909090909, 0.3999999999999999), (0.8, 0.4545454545454544, 0.3999999999999999), (0.8, 0.4681818181818179, 0.3999999999999999), (0.8, 0.4818181818181819, 0.3999999999999999), (0.8, 0.4954545454545454, 0.3999999999999999), (0.8, 0.5090909090909089, 0.3999999999999999), (0.8, 0.5227272727272725, 0.3999999999999999), (0.8, 0.5363636363636365, 0.3999999999999999), (0.8, 0.5499999999999999, 0.3999999999999999), (0.8, 0.5636363636363635, 0.3999999999999999), (0.8, 0.5772727272727275, 0.3999999999999999), (0.8, 0.5909090909090909, 0.3999999999999999), (0.8, 0.6045454545454545, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6318181818181821, 0.3999999999999999), (0.8, 0.6454545454545455, 0.3999999999999999), (0.8, 0.659090909090909, 0.3999999999999999), (0.8, 0.6727272727272731, 0.3999999999999999), (0.8, 0.6863636363636365, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7136363636363635, 0.3999999999999999), (0.8, 0.7272727272727271, 0.3999999999999999), (0.8, 0.740909090909091, 0.3999999999999999), (0.8, 0.7545454545454545, 0.3999999999999999), (0.8, 0.7681818181818181, 0.3999999999999999), (0.8, 0.781818181818182, 0.3999999999999999), (0.8, 0.7954545454545456, 0.3999999999999999), (0.7909090909090912, 0.8, 0.3999999999999999), (0.7772727272727271, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7500000000000001, 0.8, 0.3999999999999999), (0.7363636363636366, 0.8, 0.3999999999999999), (0.7227272727272727, 0.8, 0.3999999999999999), (0.7090909090909091, 0.8, 0.3999999999999999), (0.6954545454545455, 0.8, 0.3999999999999999), (0.6818181818181821, 0.8, 0.3999999999999999), (0.6681818181818181, 0.8, 0.3999999999999999), (0.6545454545454545, 0.8, 0.3999999999999999), (0.6409090909090911, 0.8, 0.3999999999999999), (0.6272727272727271, 0.8, 0.3999999999999999), (0.6136363636363635, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5863636363636366, 0.8, 0.3999999999999999), (0.5727272727272731, 0.8, 0.3999999999999999), (0.5590909090909091, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5318181818181821, 0.8, 0.3999999999999999), (0.5181818181818181, 0.8, 0.3999999999999999), (0.5045454545454545, 0.8, 0.3999999999999999), (0.4909090909090911, 0.8, 0.3999999999999999), (0.477272727272727, 0.8, 0.3999999999999999), (0.4636363636363635, 0.8, 0.3999999999999999), (0.45, 0.8, 0.3999999999999999), (0.4363636363636365, 0.8, 0.3999999999999999), (0.422727272727273, 0.8, 0.3999999999999999), (0.409090909090909, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40454545454545443), (0.3999999999999999, 0.8, 0.41818181818181793), (0.3999999999999999, 0.8, 0.431818181818182), (0.3999999999999999, 0.8, 0.4454545454545455), (0.3999999999999999, 0.8, 0.459090909090909), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.4863636363636365), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5136363636363634), (0.3999999999999999, 0.8, 0.527272727272727), (0.3999999999999999, 0.8, 0.540909090909091), (0.3999999999999999, 0.8, 0.5545454545454545), (0.3999999999999999, 0.8, 0.568181818181818), (0.3999999999999999, 0.8, 0.581818181818182), (0.3999999999999999, 0.8, 0.5954545454545456), (0.3999999999999999, 0.8, 0.609090909090909), (0.3999999999999999, 0.8, 0.622727272727273), (0.3999999999999999, 0.8, 0.6363636363636366), (0.3999999999999999, 0.8, 0.65), (0.3999999999999999, 0.8, 0.6636363636363636), (0.3999999999999999, 0.8, 0.677272727272727), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7045454545454546), (0.3999999999999999, 0.8, 0.718181818181818), (0.3999999999999999, 0.8, 0.7318181818181821), (0.3999999999999999, 0.8, 0.7454545454545456), (0.3999999999999999, 0.8, 0.759090909090909), (0.3999999999999999, 0.8, 0.7727272727272732), (0.3999999999999999, 0.8, 0.7863636363636366), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7863636363636359, 0.8), (0.3999999999999999, 0.7727272727272729, 0.8), (0.3999999999999999, 0.7590909090909089, 0.8), (0.3999999999999999, 0.7454545454545454, 0.8), (0.3999999999999999, 0.7318181818181819, 0.8), (0.3999999999999999, 0.7181818181818179, 0.8), (0.3999999999999999, 0.7045454545454544, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6772727272727269, 0.8), (0.3999999999999999, 0.6636363636363634, 0.8), (0.3999999999999999, 0.6499999999999999, 0.8), (0.3999999999999999, 0.6363636363636359, 0.8), (0.3999999999999999, 0.6227272727272729, 0.8), (0.3999999999999999, 0.6090909090909089, 0.8), (0.3999999999999999, 0.5954545454545453, 0.8), (0.3999999999999999, 0.5818181818181819, 0.8), (0.3999999999999999, 0.5681818181818179, 0.8), (0.3999999999999999, 0.5545454545454543, 0.8), (0.3999999999999999, 0.5409090909090909, 0.8), (0.3999999999999999, 0.5272727272727269, 0.8), (0.3999999999999999, 0.5136363636363633, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.48636363636363583, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.4590909090909088, 0.8), (0.3999999999999999, 0.4454545454545453, 0.8), (0.3999999999999999, 0.4318181818181818, 0.8), (0.3999999999999999, 0.4181818181818178, 0.8), (0.3999999999999999, 0.4045454545454543, 0.8), (0.4090909090909087, 0.3999999999999999, 0.8), (0.42272727272727273, 0.3999999999999999, 0.8), (0.43636363636363623, 0.3999999999999999, 0.8), (0.44999999999999973, 0.3999999999999999, 0.8), (0.4636363636363638, 0.3999999999999999, 0.8), (0.47727272727272674, 0.3999999999999999, 0.8), (0.49090909090909074, 0.3999999999999999, 0.8), (0.5045454545454543, 0.3999999999999999, 0.8), (0.5181818181818177, 0.3999999999999999, 0.8), (0.5318181818181817, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5590909090909087, 0.3999999999999999, 0.8), (0.5727272727272728, 0.3999999999999999, 0.8), (0.5863636363636363, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6136363636363639, 0.3999999999999999, 0.8), (0.6272727272727268, 0.3999999999999999, 0.8), (0.6409090909090909, 0.3999999999999999, 0.8), (0.6545454545454543, 0.3999999999999999, 0.8), (0.6681818181818178, 0.3999999999999999, 0.8), (0.6818181818181819, 0.3999999999999999, 0.8), (0.6954545454545453, 0.3999999999999999, 0.8), (0.7090909090909088, 0.3999999999999999, 0.8), (0.7227272727272729, 0.3999999999999999, 0.8), (0.7363636363636363, 0.3999999999999999, 0.8), (0.7499999999999998, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.7772727272727269, 0.3999999999999999, 0.8), (0.7909090909090908, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7954545454545452), (0.8, 0.3999999999999999, 0.7818181818181817), (0.8, 0.3999999999999999, 0.7681818181818177), (0.8, 0.3999999999999999, 0.7545454545454542), (0.8, 0.3999999999999999, 0.7409090909090907), (0.8, 0.3999999999999999, 0.7272727272727267), (0.8, 0.3999999999999999, 0.7136363636363632), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6863636363636357), (0.8, 0.3999999999999999, 0.6727272727272728), (0.8, 0.3999999999999999, 0.6590909090909087), (0.8, 0.3999999999999999, 0.6454545454545453), (0.8, 0.3999999999999999, 0.6318181818181817), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.6045454545454542), (0.8, 0.3999999999999999, 0.5909090909090907), (0.8, 0.3999999999999999, 0.5772727272727267), (0.8, 0.3999999999999999, 0.5636363636363632), (0.8, 0.3999999999999999, 0.5499999999999997), (0.8, 0.3999999999999999, 0.5363636363636357), (0.8, 0.3999999999999999, 0.5227272727272727), (0.8, 0.3999999999999999, 0.5090909090909087), (0.8, 0.3999999999999999, 0.4954545454545452), (0.8, 0.3999999999999999, 0.4818181818181817), (0.8, 0.3999999999999999, 0.46818181818181764), (0.8, 0.3999999999999999, 0.45454545454545414), (0.8, 0.3999999999999999, 0.44090909090909064), (0.8, 0.3999999999999999, 0.42727272727272664), (0.8, 0.3999999999999999, 0.41363636363636314)],
    177: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41355932203389834, 0.3999999999999999), (0.8, 0.42711864406779626, 0.3999999999999999), (0.8, 0.44067796610169474, 0.3999999999999999), (0.8, 0.45423728813559316, 0.3999999999999999), (0.8, 0.46779661016949164, 0.3999999999999999), (0.8, 0.48135593220338957, 0.3999999999999999), (0.8, 0.494915254237288, 0.3999999999999999), (0.8, 0.5084745762711864, 0.3999999999999999), (0.8, 0.522033898305085, 0.3999999999999999), (0.8, 0.5355932203389828, 0.3999999999999999), (0.8, 0.5491525423728812, 0.3999999999999999), (0.8, 0.5627118644067797, 0.3999999999999999), (0.8, 0.5762711864406782, 0.3999999999999999), (0.8, 0.5898305084745761, 0.3999999999999999), (0.8, 0.6033898305084745, 0.3999999999999999), (0.8, 0.616949152542373, 0.3999999999999999), (0.8, 0.6305084745762709, 0.3999999999999999), (0.8, 0.6440677966101693, 0.3999999999999999), (0.8, 0.6576271186440679, 0.3999999999999999), (0.8, 0.6711864406779663, 0.3999999999999999), (0.8, 0.6847457627118643, 0.3999999999999999), (0.8, 0.6983050847457626, 0.3999999999999999), (0.8, 0.7118644067796611, 0.3999999999999999), (0.8, 0.7254237288135595, 0.3999999999999999), (0.8, 0.7389830508474575, 0.3999999999999999), (0.8, 0.7525423728813558, 0.3999999999999999), (0.8, 0.7661016949152544, 0.3999999999999999), (0.8, 0.7796610169491522, 0.3999999999999999), (0.8, 0.7932203389830508, 0.3999999999999999), (0.793220338983051, 0.8, 0.3999999999999999), (0.7796610169491525, 0.8, 0.3999999999999999), (0.7661016949152541, 0.8, 0.3999999999999999), (0.7525423728813562, 0.8, 0.3999999999999999), (0.7389830508474577, 0.8, 0.3999999999999999), (0.7254237288135592, 0.8, 0.3999999999999999), (0.7118644067796613, 0.8, 0.3999999999999999), (0.6983050847457629, 0.8, 0.3999999999999999), (0.6847457627118645, 0.8, 0.3999999999999999), (0.671186440677966, 0.8, 0.3999999999999999), (0.6576271186440681, 0.8, 0.3999999999999999), (0.6440677966101697, 0.8, 0.3999999999999999), (0.6305084745762712, 0.8, 0.3999999999999999), (0.6169491525423727, 0.8, 0.3999999999999999), (0.6033898305084748, 0.8, 0.3999999999999999), (0.5898305084745764, 0.8, 0.3999999999999999), (0.5762711864406779, 0.8, 0.3999999999999999), (0.56271186440678, 0.8, 0.3999999999999999), (0.5491525423728816, 0.8, 0.3999999999999999), (0.535593220338983, 0.8, 0.3999999999999999), (0.5220338983050846, 0.8, 0.3999999999999999), (0.5084745762711862, 0.8, 0.3999999999999999), (0.49491525423728827, 0.8, 0.3999999999999999), (0.4813559322033898, 0.8, 0.3999999999999999), (0.46779661016949137, 0.8, 0.3999999999999999), (0.45423728813559344, 0.8, 0.3999999999999999), (0.440677966101695, 0.8, 0.3999999999999999), (0.42711864406779654, 0.8, 0.3999999999999999), (0.4135593220338986, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4135593220338982), (0.3999999999999999, 0.8, 0.42711864406779665), (0.3999999999999999, 0.8, 0.44067796610169513), (0.3999999999999999, 0.8, 0.45423728813559305), (0.3999999999999999, 0.8, 0.4677966101694915), (0.3999999999999999, 0.8, 0.48135593220338996), (0.3999999999999999, 0.8, 0.4949152542372879), (0.3999999999999999, 0.8, 0.5084745762711863), (0.3999999999999999, 0.8, 0.5220338983050847), (0.3999999999999999, 0.8, 0.5355932203389833), (0.3999999999999999, 0.8, 0.5491525423728817), (0.3999999999999999, 0.8, 0.5627118644067796), (0.3999999999999999, 0.8, 0.576271186440678), (0.3999999999999999, 0.8, 0.5898305084745765), (0.3999999999999999, 0.8, 0.6033898305084744), (0.3999999999999999, 0.8, 0.6169491525423729), (0.3999999999999999, 0.8, 0.6305084745762713), (0.3999999999999999, 0.8, 0.6440677966101692), (0.3999999999999999, 0.8, 0.6576271186440676), (0.3999999999999999, 0.8, 0.6711864406779662), (0.3999999999999999, 0.8, 0.6847457627118646), (0.3999999999999999, 0.8, 0.698305084745763), (0.3999999999999999, 0.8, 0.7118644067796609), (0.3999999999999999, 0.8, 0.7254237288135594), (0.3999999999999999, 0.8, 0.7389830508474579), (0.3999999999999999, 0.8, 0.7525423728813558), (0.3999999999999999, 0.8, 0.7661016949152543), (0.3999999999999999, 0.8, 0.7796610169491527), (0.3999999999999999, 0.8, 0.7932203389830506), (0.3999999999999999, 0.7932203389830506, 0.8), (0.3999999999999999, 0.7796610169491525, 0.8), (0.3999999999999999, 0.7661016949152541, 0.8), (0.3999999999999999, 0.7525423728813556, 0.8), (0.3999999999999999, 0.7389830508474577, 0.8), (0.3999999999999999, 0.7254237288135592, 0.8), (0.3999999999999999, 0.7118644067796609, 0.8), (0.3999999999999999, 0.6983050847457629, 0.8), (0.3999999999999999, 0.6847457627118645, 0.8), (0.3999999999999999, 0.671186440677966, 0.8), (0.3999999999999999, 0.6576271186440681, 0.8), (0.3999999999999999, 0.6440677966101691, 0.8), (0.3999999999999999, 0.6305084745762712, 0.8), (0.3999999999999999, 0.6169491525423727, 0.8), (0.3999999999999999, 0.6033898305084743, 0.8), (0.3999999999999999, 0.5898305084745764, 0.8), (0.3999999999999999, 0.5762711864406779, 0.8), (0.3999999999999999, 0.5627118644067794, 0.8), (0.3999999999999999, 0.5491525423728816, 0.8), (0.3999999999999999, 0.5355932203389826, 0.8), (0.3999999999999999, 0.5220338983050846, 0.8), (0.3999999999999999, 0.5084745762711862, 0.8), (0.3999999999999999, 0.4949152542372877, 0.8), (0.3999999999999999, 0.4813559322033898, 0.8), (0.3999999999999999, 0.46779661016949137, 0.8), (0.3999999999999999, 0.45423728813559294, 0.8), (0.3999999999999999, 0.440677966101695, 0.8), (0.3999999999999999, 0.42711864406779654, 0.8), (0.3999999999999999, 0.4135593220338981, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41355932203389834, 0.3999999999999999, 0.8), (0.42711864406779626, 0.3999999999999999, 0.8), (0.44067796610169474, 0.3999999999999999, 0.8), (0.45423728813559316, 0.3999999999999999, 0.8), (0.4677966101694911, 0.3999999999999999, 0.8), (0.48135593220338957, 0.3999999999999999, 0.8), (0.494915254237288, 0.3999999999999999, 0.8), (0.508474576271186, 0.3999999999999999, 0.8), (0.522033898305085, 0.3999999999999999, 0.8), (0.5355932203389828, 0.3999999999999999, 0.8), (0.5491525423728807, 0.3999999999999999, 0.8), (0.5627118644067797, 0.3999999999999999, 0.8), (0.5762711864406777, 0.3999999999999999, 0.8), (0.5898305084745761, 0.3999999999999999, 0.8), (0.6033898305084745, 0.3999999999999999, 0.8), (0.6169491525423725, 0.3999999999999999, 0.8), (0.6305084745762709, 0.3999999999999999, 0.8), (0.6440677966101693, 0.3999999999999999, 0.8), (0.6576271186440673, 0.3999999999999999, 0.8), (0.6711864406779663, 0.3999999999999999, 0.8), (0.6847457627118643, 0.3999999999999999, 0.8), (0.6983050847457626, 0.3999999999999999, 0.8), (0.7118644067796611, 0.3999999999999999, 0.8), (0.725423728813559, 0.3999999999999999, 0.8), (0.7389830508474575, 0.3999999999999999, 0.8), (0.7525423728813558, 0.3999999999999999, 0.8), (0.7661016949152538, 0.3999999999999999, 0.8), (0.7796610169491522, 0.3999999999999999, 0.8), (0.7932203389830508, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.793220338983051), (0.8, 0.3999999999999999, 0.779661016949152), (0.8, 0.3999999999999999, 0.7661016949152541), (0.8, 0.3999999999999999, 0.7525423728813556), (0.8, 0.3999999999999999, 0.7389830508474572), (0.8, 0.3999999999999999, 0.7254237288135592), (0.8, 0.3999999999999999, 0.7118644067796609), (0.8, 0.3999999999999999, 0.6983050847457624), (0.8, 0.3999999999999999, 0.6847457627118645), (0.8, 0.3999999999999999, 0.6711864406779655), (0.8, 0.3999999999999999, 0.6576271186440675), (0.8, 0.3999999999999999, 0.6440677966101691), (0.8, 0.3999999999999999, 0.6305084745762707), (0.8, 0.3999999999999999, 0.6169491525423727), (0.8, 0.3999999999999999, 0.6033898305084743), (0.8, 0.3999999999999999, 0.5898305084745759), (0.8, 0.3999999999999999, 0.5762711864406779), (0.8, 0.3999999999999999, 0.5627118644067794), (0.8, 0.3999999999999999, 0.549152542372881), (0.8, 0.3999999999999999, 0.535593220338983), (0.8, 0.3999999999999999, 0.5220338983050841), (0.8, 0.3999999999999999, 0.5084745762711862), (0.8, 0.3999999999999999, 0.4949152542372877), (0.8, 0.3999999999999999, 0.4813559322033893), (0.8, 0.3999999999999999, 0.46779661016949137), (0.8, 0.3999999999999999, 0.45423728813559294), (0.8, 0.3999999999999999, 0.44067796610169446), (0.8, 0.3999999999999999, 0.42711864406779654), (0.8, 0.3999999999999999, 0.4135593220338981)],
    178: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41348314606741543, 0.3999999999999999), (0.8, 0.42696629213483145, 0.3999999999999999), (0.8, 0.44044943820224697, 0.3999999999999999), (0.8, 0.453932584269663, 0.3999999999999999), (0.8, 0.4674157303370785, 0.3999999999999999), (0.8, 0.4808988764044945, 0.3999999999999999), (0.8, 0.49438202247191004, 0.3999999999999999), (0.8, 0.5078651685393261, 0.3999999999999999), (0.8, 0.5213483146067416, 0.3999999999999999), (0.8, 0.5348314606741571, 0.3999999999999999), (0.8, 0.5483146067415731, 0.3999999999999999), (0.8, 0.5617977528089886, 0.3999999999999999), (0.8, 0.5752808988764047, 0.3999999999999999), (0.8, 0.5887640449438202, 0.3999999999999999), (0.8, 0.6022471910112361, 0.3999999999999999), (0.8, 0.6157303370786517, 0.3999999999999999), (0.8, 0.6292134831460672, 0.3999999999999999), (0.8, 0.6426966292134833, 0.3999999999999999), (0.8, 0.6561797752808987, 0.3999999999999999), (0.8, 0.6696629213483147, 0.3999999999999999), (0.8, 0.6831460674157303, 0.3999999999999999), (0.8, 0.6966292134831462, 0.3999999999999999), (0.8, 0.7101123595505618, 0.3999999999999999), (0.8, 0.7235955056179773, 0.3999999999999999), (0.8, 0.7370786516853933, 0.3999999999999999), (0.8, 0.7505617977528087, 0.3999999999999999), (0.8, 0.7640449438202248, 0.3999999999999999), (0.8, 0.7775280898876404, 0.3999999999999999), (0.8, 0.7910112359550563, 0.3999999999999999), (0.7955056179775284, 0.8, 0.3999999999999999), (0.7820224719101128, 0.8, 0.3999999999999999), (0.7685393258426968, 0.8, 0.3999999999999999), (0.7550561797752807, 0.8, 0.3999999999999999), (0.7415730337078652, 0.8, 0.3999999999999999), (0.7280898876404498, 0.8, 0.3999999999999999), (0.7146067415730337, 0.8, 0.3999999999999999), (0.7011235955056182, 0.8, 0.3999999999999999), (0.6876404494382022, 0.8, 0.3999999999999999), (0.6741573033707866, 0.8, 0.3999999999999999), (0.6606741573033706, 0.8, 0.3999999999999999), (0.6471910112359551, 0.8, 0.3999999999999999), (0.6337078651685396, 0.8, 0.3999999999999999), (0.6202247191011236, 0.8, 0.3999999999999999), (0.6067415730337081, 0.8, 0.3999999999999999), (0.593258426966292, 0.8, 0.3999999999999999), (0.5797752808988765, 0.8, 0.3999999999999999), (0.5662921348314605, 0.8, 0.3999999999999999), (0.552808988764045, 0.8, 0.3999999999999999), (0.5393258426966295, 0.8, 0.3999999999999999), (0.5258426966292135, 0.8, 0.3999999999999999), (0.5123595505617979, 0.8, 0.3999999999999999), (0.4988764044943819, 0.8, 0.3999999999999999), (0.48539325842696646, 0.8, 0.3999999999999999), (0.4719101123595504, 0.8, 0.3999999999999999), (0.4584269662921349, 0.8, 0.3999999999999999), (0.4449438202247194, 0.8, 0.3999999999999999), (0.4314606741573034, 0.8, 0.3999999999999999), (0.4179775280898873, 0.8, 0.3999999999999999), (0.40449438202247184, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4089887640449436), (0.3999999999999999, 0.8, 0.4224719101123596), (0.3999999999999999, 0.8, 0.43595505617977515), (0.3999999999999999, 0.8, 0.44943820224719067), (0.3999999999999999, 0.8, 0.4629213483146067), (0.3999999999999999, 0.8, 0.4764044943820227), (0.3999999999999999, 0.8, 0.4898876404494382), (0.3999999999999999, 0.8, 0.5033707865168537), (0.3999999999999999, 0.8, 0.5168539325842698), (0.3999999999999999, 0.8, 0.5303370786516852), (0.3999999999999999, 0.8, 0.5438202247191007), (0.3999999999999999, 0.8, 0.5573033707865168), (0.3999999999999999, 0.8, 0.5707865168539328), (0.3999999999999999, 0.8, 0.5842696629213484), (0.3999999999999999, 0.8, 0.5977528089887638), (0.3999999999999999, 0.8, 0.6112359550561799), (0.3999999999999999, 0.8, 0.6247191011235954), (0.3999999999999999, 0.8, 0.6382022471910114), (0.3999999999999999, 0.8, 0.6516853932584269), (0.3999999999999999, 0.8, 0.665168539325843), (0.3999999999999999, 0.8, 0.6786516853932585), (0.3999999999999999, 0.8, 0.6921348314606739), (0.3999999999999999, 0.8, 0.70561797752809), (0.3999999999999999, 0.8, 0.7191011235955055), (0.3999999999999999, 0.8, 0.7325842696629215), (0.3999999999999999, 0.8, 0.7460674157303371), (0.3999999999999999, 0.8, 0.759550561797753), (0.3999999999999999, 0.8, 0.7730337078651686), (0.3999999999999999, 0.8, 0.786516853932584), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.786516853932584, 0.8), (0.3999999999999999, 0.7730337078651685, 0.8), (0.3999999999999999, 0.7595505617977529, 0.8), (0.3999999999999999, 0.7460674157303369, 0.8), (0.3999999999999999, 0.7325842696629215, 0.8), (0.3999999999999999, 0.7191011235955058, 0.8), (0.3999999999999999, 0.7056179775280899, 0.8), (0.3999999999999999, 0.6921348314606739, 0.8), (0.3999999999999999, 0.6786516853932583, 0.8), (0.3999999999999999, 0.6651685393258429, 0.8), (0.3999999999999999, 0.6516853932584268, 0.8), (0.3999999999999999, 0.6382022471910113, 0.8), (0.3999999999999999, 0.6247191011235957, 0.8), (0.3999999999999999, 0.6112359550561798, 0.8), (0.3999999999999999, 0.5977528089887637, 0.8), (0.3999999999999999, 0.5842696629213482, 0.8), (0.3999999999999999, 0.5707865168539327, 0.8), (0.3999999999999999, 0.5573033707865167, 0.8), (0.3999999999999999, 0.5438202247191012, 0.8), (0.3999999999999999, 0.5303370786516857, 0.8), (0.3999999999999999, 0.5168539325842696, 0.8), (0.3999999999999999, 0.5033707865168536, 0.8), (0.3999999999999999, 0.4898876404494381, 0.8), (0.3999999999999999, 0.4764044943820226, 0.8), (0.3999999999999999, 0.4629213483146066, 0.8), (0.3999999999999999, 0.44943820224719055, 0.8), (0.3999999999999999, 0.43595505617977504, 0.8), (0.3999999999999999, 0.4224719101123595, 0.8), (0.3999999999999999, 0.4089887640449435, 0.8), (0.40449438202247157, 0.3999999999999999, 0.8), (0.4179775280898871, 0.3999999999999999, 0.8), (0.4314606741573031, 0.3999999999999999, 0.8), (0.4449438202247191, 0.3999999999999999, 0.8), (0.45842696629213464, 0.3999999999999999, 0.8), (0.47191011235955016, 0.3999999999999999, 0.8), (0.4853932584269662, 0.3999999999999999, 0.8), (0.4988764044943817, 0.3999999999999999, 0.8), (0.5123595505617972, 0.3999999999999999, 0.8), (0.5258426966292132, 0.3999999999999999, 0.8), (0.5393258426966292, 0.3999999999999999, 0.8), (0.5528089887640447, 0.3999999999999999, 0.8), (0.5662921348314602, 0.3999999999999999, 0.8), (0.5797752808988763, 0.3999999999999999, 0.8), (0.5932584269662918, 0.3999999999999999, 0.8), (0.6067415730337072, 0.3999999999999999, 0.8), (0.6202247191011233, 0.3999999999999999, 0.8), (0.6337078651685394, 0.3999999999999999, 0.8), (0.6471910112359549, 0.3999999999999999, 0.8), (0.6606741573033703, 0.3999999999999999, 0.8), (0.6741573033707864, 0.3999999999999999, 0.8), (0.6876404494382019, 0.3999999999999999, 0.8), (0.7011235955056174, 0.3999999999999999, 0.8), (0.7146067415730335, 0.3999999999999999, 0.8), (0.7280898876404495, 0.3999999999999999, 0.8), (0.741573033707865, 0.3999999999999999, 0.8), (0.7550561797752804, 0.3999999999999999, 0.8), (0.7685393258426965, 0.3999999999999999, 0.8), (0.7820224719101125, 0.3999999999999999, 0.8), (0.795505617977528, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7910112359550561), (0.8, 0.3999999999999999, 0.77752808988764), (0.8, 0.3999999999999999, 0.7640449438202246), (0.8, 0.3999999999999999, 0.7505617977528091), (0.8, 0.3999999999999999, 0.7370786516853931), (0.8, 0.3999999999999999, 0.723595505617977), (0.8, 0.3999999999999999, 0.7101123595505615), (0.8, 0.3999999999999999, 0.696629213483146), (0.8, 0.3999999999999999, 0.6831460674157299), (0.8, 0.3999999999999999, 0.6696629213483145), (0.8, 0.3999999999999999, 0.656179775280899), (0.8, 0.3999999999999999, 0.6426966292134829), (0.8, 0.3999999999999999, 0.629213483146067), (0.8, 0.3999999999999999, 0.6157303370786514), (0.8, 0.3999999999999999, 0.6022471910112359), (0.8, 0.3999999999999999, 0.5887640449438198), (0.8, 0.3999999999999999, 0.5752808988764043), (0.8, 0.3999999999999999, 0.5617977528089888), (0.8, 0.3999999999999999, 0.5483146067415728), (0.8, 0.3999999999999999, 0.5348314606741568), (0.8, 0.3999999999999999, 0.5213483146067412), (0.8, 0.3999999999999999, 0.5078651685393258), (0.8, 0.3999999999999999, 0.49438202247190977), (0.8, 0.3999999999999999, 0.48089887640449425), (0.8, 0.3999999999999999, 0.4674157303370787), (0.8, 0.3999999999999999, 0.4539325842696627), (0.8, 0.3999999999999999, 0.4404494382022467), (0.8, 0.3999999999999999, 0.42696629213483117), (0.8, 0.3999999999999999, 0.41348314606741565)],
    179: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4134078212290503, 0.3999999999999999), (0.8, 0.4268156424581007, 0.3999999999999999), (0.8, 0.4402234636871506, 0.3999999999999999), (0.8, 0.45363128491620097, 0.3999999999999999), (0.8, 0.4670391061452514, 0.3999999999999999), (0.8, 0.4804469273743018, 0.3999999999999999), (0.8, 0.49385474860335166, 0.3999999999999999), (0.8, 0.507262569832402, 0.3999999999999999), (0.8, 0.5206703910614525, 0.3999999999999999), (0.8, 0.5340782122905029, 0.3999999999999999), (0.8, 0.5474860335195533, 0.3999999999999999), (0.8, 0.5608938547486031, 0.3999999999999999), (0.8, 0.5743016759776536, 0.3999999999999999), (0.8, 0.587709497206704, 0.3999999999999999), (0.8, 0.6011173184357543, 0.3999999999999999), (0.8, 0.6145251396648043, 0.3999999999999999), (0.8, 0.6279329608938546, 0.3999999999999999), (0.8, 0.641340782122905, 0.3999999999999999), (0.8, 0.6547486033519554, 0.3999999999999999), (0.8, 0.6681564245810059, 0.3999999999999999), (0.8, 0.6815642458100557, 0.3999999999999999), (0.8, 0.6949720670391062, 0.3999999999999999), (0.8, 0.7083798882681565, 0.3999999999999999), (0.8, 0.7217877094972069, 0.3999999999999999), (0.8, 0.7351955307262568, 0.3999999999999999), (0.8, 0.7486033519553073, 0.3999999999999999), (0.8, 0.7620111731843575, 0.3999999999999999), (0.8, 0.775418994413408, 0.3999999999999999), (0.8, 0.7888268156424585, 0.3999999999999999), (0.797765363128492, 0.8, 0.3999999999999999), (0.7843575418994415, 0.8, 0.3999999999999999), (0.7709497206703911, 0.8, 0.3999999999999999), (0.7575418994413408, 0.8, 0.3999999999999999), (0.7441340782122908, 0.8, 0.3999999999999999), (0.7307262569832405, 0.8, 0.3999999999999999), (0.71731843575419, 0.8, 0.3999999999999999), (0.7039106145251397, 0.8, 0.3999999999999999), (0.6905027932960892, 0.8, 0.3999999999999999), (0.6770949720670394, 0.8, 0.3999999999999999), (0.6636871508379889, 0.8, 0.3999999999999999), (0.6502793296089385, 0.8, 0.3999999999999999), (0.6368715083798882, 0.8, 0.3999999999999999), (0.6234636871508383, 0.8, 0.3999999999999999), (0.6100558659217878, 0.8, 0.3999999999999999), (0.5966480446927375, 0.8, 0.3999999999999999), (0.5832402234636871, 0.8, 0.3999999999999999), (0.5698324022346366, 0.8, 0.3999999999999999), (0.5564245810055868, 0.8, 0.3999999999999999), (0.5430167597765364, 0.8, 0.3999999999999999), (0.529608938547486, 0.8, 0.3999999999999999), (0.5162011173184355, 0.8, 0.3999999999999999), (0.5027932960893857, 0.8, 0.3999999999999999), (0.4893854748603353, 0.8, 0.3999999999999999), (0.4759776536312849, 0.8, 0.3999999999999999), (0.4625698324022345, 0.8, 0.3999999999999999), (0.4491620111731841, 0.8, 0.3999999999999999), (0.43575418994413423, 0.8, 0.3999999999999999), (0.4223463687150838, 0.8, 0.3999999999999999), (0.4089385474860334, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40446927374301694), (0.3999999999999999, 0.8, 0.4178770949720668), (0.3999999999999999, 0.8, 0.4312849162011172), (0.3999999999999999, 0.8, 0.44469273743016763), (0.3999999999999999, 0.8, 0.458100558659218), (0.3999999999999999, 0.8, 0.47150837988826844), (0.3999999999999999, 0.8, 0.48491620111731826), (0.3999999999999999, 0.8, 0.4983240223463687), (0.3999999999999999, 0.8, 0.5117318435754191), (0.3999999999999999, 0.8, 0.5251396648044695), (0.3999999999999999, 0.8, 0.5385474860335193), (0.3999999999999999, 0.8, 0.5519553072625698), (0.3999999999999999, 0.8, 0.5653631284916202), (0.3999999999999999, 0.8, 0.5787709497206706), (0.3999999999999999, 0.8, 0.5921787709497209), (0.3999999999999999, 0.8, 0.6055865921787709), (0.3999999999999999, 0.8, 0.6189944134078212), (0.3999999999999999, 0.8, 0.6324022346368716), (0.3999999999999999, 0.8, 0.6458100558659221), (0.3999999999999999, 0.8, 0.6592178770949719), (0.3999999999999999, 0.8, 0.6726256983240224), (0.3999999999999999, 0.8, 0.6860335195530727), (0.3999999999999999, 0.8, 0.6994413407821232), (0.3999999999999999, 0.8, 0.7128491620111735), (0.3999999999999999, 0.8, 0.7262569832402235), (0.3999999999999999, 0.8, 0.7396648044692737), (0.3999999999999999, 0.8, 0.7530726256983242), (0.3999999999999999, 0.8, 0.7664804469273746), (0.3999999999999999, 0.8, 0.7798882681564245), (0.3999999999999999, 0.8, 0.7932960893854748), (0.3999999999999999, 0.7932960893854748, 0.8), (0.3999999999999999, 0.7798882681564243, 0.8), (0.3999999999999999, 0.7664804469273739, 0.8), (0.3999999999999999, 0.7530726256983236, 0.8), (0.3999999999999999, 0.7396648044692737, 0.8), (0.3999999999999999, 0.7262569832402233, 0.8), (0.3999999999999999, 0.7128491620111734, 0.8), (0.3999999999999999, 0.6994413407821229, 0.8), (0.3999999999999999, 0.6860335195530727, 0.8), (0.3999999999999999, 0.6726256983240222, 0.8), (0.3999999999999999, 0.6592178770949718, 0.8), (0.3999999999999999, 0.6458100558659214, 0.8), (0.3999999999999999, 0.632402234636871, 0.8), (0.3999999999999999, 0.6189944134078211, 0.8), (0.3999999999999999, 0.6055865921787708, 0.8), (0.3999999999999999, 0.5921787709497208, 0.8), (0.3999999999999999, 0.5787709497206704, 0.8), (0.3999999999999999, 0.5653631284916201, 0.8), (0.3999999999999999, 0.5519553072625696, 0.8), (0.3999999999999999, 0.5385474860335192, 0.8), (0.3999999999999999, 0.5251396648044688, 0.8), (0.3999999999999999, 0.5117318435754185, 0.8), (0.3999999999999999, 0.4983240223463686, 0.8), (0.3999999999999999, 0.48491620111731815, 0.8), (0.3999999999999999, 0.47150837988826827, 0.8), (0.3999999999999999, 0.4581005586592179, 0.8), (0.3999999999999999, 0.44469273743016746, 0.8), (0.3999999999999999, 0.4312849162011171, 0.8), (0.3999999999999999, 0.41787709497206665, 0.8), (0.3999999999999999, 0.4044692737430163, 0.8), (0.4089385474860337, 0.3999999999999999, 0.8), (0.4223463687150836, 0.3999999999999999, 0.8), (0.43575418994413395, 0.3999999999999999, 0.8), (0.44916201117318383, 0.3999999999999999, 0.8), (0.46256983240223426, 0.3999999999999999, 0.8), (0.47597765363128464, 0.3999999999999999, 0.8), (0.489385474860335, 0.3999999999999999, 0.8), (0.5027932960893855, 0.3999999999999999, 0.8), (0.5162011173184359, 0.3999999999999999, 0.8), (0.5296089385474863, 0.3999999999999999, 0.8), (0.5430167597765361, 0.3999999999999999, 0.8), (0.5564245810055866, 0.3999999999999999, 0.8), (0.5698324022346364, 0.3999999999999999, 0.8), (0.5832402234636869, 0.3999999999999999, 0.8), (0.5966480446927372, 0.3999999999999999, 0.8), (0.6100558659217876, 0.3999999999999999, 0.8), (0.623463687150838, 0.3999999999999999, 0.8), (0.6368715083798884, 0.3999999999999999, 0.8), (0.6502793296089389, 0.3999999999999999, 0.8), (0.6636871508379887, 0.3999999999999999, 0.8), (0.6770949720670392, 0.3999999999999999, 0.8), (0.690502793296089, 0.3999999999999999, 0.8), (0.7039106145251394, 0.3999999999999999, 0.8), (0.7173184357541897, 0.3999999999999999, 0.8), (0.7307262569832402, 0.3999999999999999, 0.8), (0.7441340782122905, 0.3999999999999999, 0.8), (0.757541899441341, 0.3999999999999999, 0.8), (0.7709497206703914, 0.3999999999999999, 0.8), (0.7843575418994413, 0.3999999999999999, 0.8), (0.7977653631284916, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.788826815642458), (0.8, 0.3999999999999999, 0.7754189944134078), (0.8, 0.3999999999999999, 0.7620111731843573), (0.8, 0.3999999999999999, 0.7486033519553069), (0.8, 0.3999999999999999, 0.7351955307262565), (0.8, 0.3999999999999999, 0.721787709497206), (0.8, 0.3999999999999999, 0.7083798882681558), (0.8, 0.3999999999999999, 0.6949720670391059), (0.8, 0.3999999999999999, 0.6815642458100555), (0.8, 0.3999999999999999, 0.6681564245810057), (0.8, 0.3999999999999999, 0.6547486033519552), (0.8, 0.3999999999999999, 0.6413407821229048), (0.8, 0.3999999999999999, 0.6279329608938544), (0.8, 0.3999999999999999, 0.6145251396648039), (0.8, 0.3999999999999999, 0.6011173184357536), (0.8, 0.3999999999999999, 0.5877094972067032), (0.8, 0.3999999999999999, 0.5743016759776532), (0.8, 0.3999999999999999, 0.5608938547486029), (0.8, 0.3999999999999999, 0.547486033519553), (0.8, 0.3999999999999999, 0.5340782122905026), (0.8, 0.3999999999999999, 0.5206703910614522), (0.8, 0.3999999999999999, 0.5072625698324018), (0.8, 0.3999999999999999, 0.4938547486033514), (0.8, 0.3999999999999999, 0.480446927374301), (0.8, 0.3999999999999999, 0.46703910614525057), (0.8, 0.3999999999999999, 0.45363128491620075), (0.8, 0.3999999999999999, 0.4402234636871503), (0.8, 0.3999999999999999, 0.42681564245810044), (0.8, 0.3999999999999999, 0.41340782122905007)],
    180: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4133333333333332, 0.3999999999999999), (0.8, 0.42666666666666647, 0.3999999999999999), (0.8, 0.4399999999999998, 0.3999999999999999), (0.8, 0.4533333333333331, 0.3999999999999999), (0.8, 0.46666666666666634, 0.3999999999999999), (0.8, 0.4800000000000002, 0.3999999999999999), (0.8, 0.4933333333333335, 0.3999999999999999), (0.8, 0.5066666666666668, 0.3999999999999999), (0.8, 0.52, 0.3999999999999999), (0.8, 0.5333333333333333, 0.3999999999999999), (0.8, 0.5466666666666666, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.5733333333333333, 0.3999999999999999), (0.8, 0.5866666666666664, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6133333333333331, 0.3999999999999999), (0.8, 0.6266666666666669, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6533333333333335, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6800000000000002, 0.3999999999999999), (0.8, 0.6933333333333334, 0.3999999999999999), (0.8, 0.7066666666666667, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.8, 0.7333333333333332, 0.3999999999999999), (0.8, 0.7466666666666666, 0.3999999999999999), (0.8, 0.7599999999999998, 0.3999999999999999), (0.8, 0.7733333333333331, 0.3999999999999999), (0.8, 0.7866666666666668, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7866666666666666, 0.8, 0.3999999999999999), (0.7733333333333334, 0.8, 0.3999999999999999), (0.76, 0.8, 0.3999999999999999), (0.7466666666666668, 0.8, 0.3999999999999999), (0.7333333333333335, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.706666666666667, 0.8, 0.3999999999999999), (0.6933333333333336, 0.8, 0.3999999999999999), (0.6799999999999998, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6533333333333332, 0.8, 0.3999999999999999), (0.6399999999999999, 0.8, 0.3999999999999999), (0.6266666666666667, 0.8, 0.3999999999999999), (0.6133333333333334, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5866666666666668, 0.8, 0.3999999999999999), (0.5733333333333335, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.5466666666666669, 0.8, 0.3999999999999999), (0.5333333333333337, 0.8, 0.3999999999999999), (0.5200000000000004, 0.8, 0.3999999999999999), (0.5066666666666665, 0.8, 0.3999999999999999), (0.4933333333333332, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.4666666666666666, 0.8, 0.3999999999999999), (0.45333333333333337, 0.8, 0.3999999999999999), (0.44000000000000006, 0.8, 0.3999999999999999), (0.42666666666666675, 0.8, 0.3999999999999999), (0.41333333333333344, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.4133333333333336), (0.3999999999999999, 0.8, 0.42666666666666686), (0.3999999999999999, 0.8, 0.44000000000000017), (0.3999999999999999, 0.8, 0.4533333333333335), (0.3999999999999999, 0.8, 0.4666666666666668), (0.3999999999999999, 0.8, 0.48000000000000004), (0.3999999999999999, 0.8, 0.49333333333333335), (0.3999999999999999, 0.8, 0.5066666666666666), (0.3999999999999999, 0.8, 0.5199999999999999), (0.3999999999999999, 0.8, 0.5333333333333332), (0.3999999999999999, 0.8, 0.5466666666666665), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.573333333333333), (0.3999999999999999, 0.8, 0.5866666666666669), (0.3999999999999999, 0.8, 0.6000000000000002), (0.3999999999999999, 0.8, 0.6133333333333335), (0.3999999999999999, 0.8, 0.6266666666666668), (0.3999999999999999, 0.8, 0.6400000000000001), (0.3999999999999999, 0.8, 0.6533333333333333), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6799999999999999), (0.3999999999999999, 0.8, 0.6933333333333332), (0.3999999999999999, 0.8, 0.706666666666667), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.8, 0.7333333333333336), (0.3999999999999999, 0.8, 0.7466666666666669), (0.3999999999999999, 0.8, 0.7600000000000002), (0.3999999999999999, 0.8, 0.7733333333333335), (0.3999999999999999, 0.8, 0.7866666666666668), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7866666666666666, 0.8), (0.3999999999999999, 0.7733333333333334, 0.8), (0.3999999999999999, 0.76, 0.8), (0.3999999999999999, 0.7466666666666668, 0.8), (0.3999999999999999, 0.7333333333333335, 0.8), (0.3999999999999999, 0.7200000000000002, 0.8), (0.3999999999999999, 0.706666666666667, 0.8), (0.3999999999999999, 0.6933333333333331, 0.8), (0.3999999999999999, 0.6799999999999998, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6533333333333332, 0.8), (0.3999999999999999, 0.6399999999999999, 0.8), (0.3999999999999999, 0.6266666666666662, 0.8), (0.3999999999999999, 0.6133333333333328, 0.8), (0.3999999999999999, 0.5999999999999995, 0.8), (0.3999999999999999, 0.5866666666666662, 0.8), (0.3999999999999999, 0.5733333333333329, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5466666666666664, 0.8), (0.3999999999999999, 0.5333333333333331, 0.8), (0.3999999999999999, 0.5199999999999998, 0.8), (0.3999999999999999, 0.5066666666666665, 0.8), (0.3999999999999999, 0.4933333333333332, 0.8), (0.3999999999999999, 0.4799999999999999, 0.8), (0.3999999999999999, 0.4666666666666666, 0.8), (0.3999999999999999, 0.45333333333333337, 0.8), (0.3999999999999999, 0.44000000000000006, 0.8), (0.3999999999999999, 0.42666666666666675, 0.8), (0.3999999999999999, 0.41333333333333344, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.4133333333333332, 0.3999999999999999, 0.8), (0.42666666666666647, 0.3999999999999999, 0.8), (0.4399999999999998, 0.3999999999999999, 0.8), (0.4533333333333331, 0.3999999999999999, 0.8), (0.46666666666666634, 0.3999999999999999, 0.8), (0.4800000000000002, 0.3999999999999999, 0.8), (0.4933333333333335, 0.3999999999999999, 0.8), (0.5066666666666668, 0.3999999999999999, 0.8), (0.52, 0.3999999999999999, 0.8), (0.5333333333333333, 0.3999999999999999, 0.8), (0.5466666666666666, 0.3999999999999999, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.5733333333333333, 0.3999999999999999, 0.8), (0.5866666666666664, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6133333333333331, 0.3999999999999999, 0.8), (0.6266666666666664, 0.3999999999999999, 0.8), (0.6399999999999997, 0.3999999999999999, 0.8), (0.653333333333333, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6799999999999995, 0.3999999999999999, 0.8), (0.6933333333333334, 0.3999999999999999, 0.8), (0.7066666666666667, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7333333333333332, 0.3999999999999999, 0.8), (0.7466666666666666, 0.3999999999999999, 0.8), (0.7599999999999998, 0.3999999999999999, 0.8), (0.7733333333333337, 0.3999999999999999, 0.8), (0.7866666666666668, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7866666666666662), (0.8, 0.3999999999999999, 0.7733333333333329), (0.8, 0.3999999999999999, 0.7599999999999996), (0.8, 0.3999999999999999, 0.7466666666666663), (0.8, 0.3999999999999999, 0.733333333333333), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.7066666666666663), (0.8, 0.3999999999999999, 0.6933333333333331), (0.8, 0.3999999999999999, 0.6799999999999998), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6533333333333332), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6266666666666667), (0.8, 0.3999999999999999, 0.6133333333333334), (0.8, 0.3999999999999999, 0.5999999999999995), (0.8, 0.3999999999999999, 0.5866666666666662), (0.8, 0.3999999999999999, 0.5733333333333329), (0.8, 0.3999999999999999, 0.5599999999999996), (0.8, 0.3999999999999999, 0.5466666666666664), (0.8, 0.3999999999999999, 0.5333333333333325), (0.8, 0.3999999999999999, 0.5199999999999992), (0.8, 0.3999999999999999, 0.5066666666666659), (0.8, 0.3999999999999999, 0.4933333333333327), (0.8, 0.3999999999999999, 0.47999999999999937), (0.8, 0.3999999999999999, 0.4666666666666661), (0.8, 0.3999999999999999, 0.4533333333333328), (0.8, 0.3999999999999999, 0.4399999999999995), (0.8, 0.3999999999999999, 0.4266666666666662), (0.8, 0.3999999999999999, 0.41333333333333294)],
    181: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41325966850828744, 0.3999999999999999), (0.8, 0.4265193370165744, 0.3999999999999999), (0.8, 0.439779005524862, 0.3999999999999999), (0.8, 0.45303867403314896, 0.3999999999999999), (0.8, 0.4662983425414365, 0.3999999999999999), (0.8, 0.4795580110497235, 0.3999999999999999), (0.8, 0.49281767955801103, 0.3999999999999999), (0.8, 0.506077348066298, 0.3999999999999999), (0.8, 0.5193370165745855, 0.3999999999999999), (0.8, 0.5325966850828731, 0.3999999999999999), (0.8, 0.54585635359116, 0.3999999999999999), (0.8, 0.5591160220994476, 0.3999999999999999), (0.8, 0.5723756906077346, 0.3999999999999999), (0.8, 0.5856353591160222, 0.3999999999999999), (0.8, 0.5988950276243091, 0.3999999999999999), (0.8, 0.6121546961325967, 0.3999999999999999), (0.8, 0.6254143646408842, 0.3999999999999999), (0.8, 0.6386740331491711, 0.3999999999999999), (0.8, 0.6519337016574587, 0.3999999999999999), (0.8, 0.6651933701657458, 0.3999999999999999), (0.8, 0.6784530386740333, 0.3999999999999999), (0.8, 0.6917127071823203, 0.3999999999999999), (0.8, 0.7049723756906078, 0.3999999999999999), (0.8, 0.7182320441988953, 0.3999999999999999), (0.8, 0.7314917127071823, 0.3999999999999999), (0.8, 0.7447513812154698, 0.3999999999999999), (0.8, 0.7580110497237569, 0.3999999999999999), (0.8, 0.7712707182320444, 0.3999999999999999), (0.8, 0.7845303867403313, 0.3999999999999999), (0.8, 0.7977900552486188, 0.3999999999999999), (0.7889502762430938, 0.8, 0.3999999999999999), (0.7756906077348067, 0.8, 0.3999999999999999), (0.7624309392265198, 0.8, 0.3999999999999999), (0.7491712707182323, 0.8, 0.3999999999999999), (0.7359116022099448, 0.8, 0.3999999999999999), (0.7226519337016577, 0.8, 0.3999999999999999), (0.7093922651933702, 0.8, 0.3999999999999999), (0.6961325966850832, 0.8, 0.3999999999999999), (0.6828729281767957, 0.8, 0.3999999999999999), (0.6696132596685087, 0.8, 0.3999999999999999), (0.6563535911602212, 0.8, 0.3999999999999999), (0.6430939226519337, 0.8, 0.3999999999999999), (0.6298342541436466, 0.8, 0.3999999999999999), (0.616574585635359, 0.8, 0.3999999999999999), (0.6033149171270721, 0.8, 0.3999999999999999), (0.5900552486187846, 0.8, 0.3999999999999999), (0.5767955801104976, 0.8, 0.3999999999999999), (0.5635359116022101, 0.8, 0.3999999999999999), (0.5502762430939225, 0.8, 0.3999999999999999), (0.5370165745856355, 0.8, 0.3999999999999999), (0.5237569060773479, 0.8, 0.3999999999999999), (0.510497237569061, 0.8, 0.3999999999999999), (0.49723756906077343, 0.8, 0.3999999999999999), (0.48397790055248646, 0.8, 0.3999999999999999), (0.47071823204419894, 0.8, 0.3999999999999999), (0.4574585635359114, 0.8, 0.3999999999999999), (0.4441988950276244, 0.8, 0.3999999999999999), (0.4309392265193374, 0.8, 0.3999999999999999), (0.41767955801104983, 0.8, 0.3999999999999999), (0.4044198895027623, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4088397790055246), (0.3999999999999999, 0.8, 0.4220994475138121), (0.3999999999999999, 0.8, 0.4353591160220997), (0.3999999999999999, 0.8, 0.44861878453038667), (0.3999999999999999, 0.8, 0.4618784530386737), (0.3999999999999999, 0.8, 0.4751381215469612), (0.3999999999999999, 0.8, 0.48839779005524875), (0.3999999999999999, 0.8, 0.5016574585635357), (0.3999999999999999, 0.8, 0.5149171270718232), (0.3999999999999999, 0.8, 0.5281767955801108), (0.3999999999999999, 0.8, 0.5414364640883977), (0.3999999999999999, 0.8, 0.5546961325966848), (0.3999999999999999, 0.8, 0.5679558011049723), (0.3999999999999999, 0.8, 0.5812154696132599), (0.3999999999999999, 0.8, 0.5944751381215468), (0.3999999999999999, 0.8, 0.6077348066298344), (0.3999999999999999, 0.8, 0.6209944751381213), (0.3999999999999999, 0.8, 0.6342541436464089), (0.3999999999999999, 0.8, 0.647513812154696), (0.3999999999999999, 0.8, 0.6607734806629835), (0.3999999999999999, 0.8, 0.674033149171271), (0.3999999999999999, 0.8, 0.687292817679558), (0.3999999999999999, 0.8, 0.7005524861878455), (0.3999999999999999, 0.8, 0.7138121546961325), (0.3999999999999999, 0.8, 0.72707182320442), (0.3999999999999999, 0.8, 0.7403314917127071), (0.3999999999999999, 0.8, 0.7535911602209946), (0.3999999999999999, 0.8, 0.7668508287292821), (0.3999999999999999, 0.8, 0.780110497237569), (0.3999999999999999, 0.8, 0.7933701657458561), (0.3999999999999999, 0.7933701657458565, 0.8), (0.3999999999999999, 0.780110497237569, 0.8), (0.3999999999999999, 0.7668508287292819, 0.8), (0.3999999999999999, 0.7535911602209944, 0.8), (0.3999999999999999, 0.7403314917127068, 0.8), (0.3999999999999999, 0.7270718232044199, 0.8), (0.3999999999999999, 0.7138121546961329, 0.8), (0.3999999999999999, 0.7005524861878454, 0.8), (0.3999999999999999, 0.6872928176795579, 0.8), (0.3999999999999999, 0.6740331491712708, 0.8), (0.3999999999999999, 0.6607734806629832, 0.8), (0.3999999999999999, 0.6475138121546957, 0.8), (0.3999999999999999, 0.6342541436464088, 0.8), (0.3999999999999999, 0.6209944751381218, 0.8), (0.3999999999999999, 0.6077348066298343, 0.8), (0.3999999999999999, 0.5944751381215467, 0.8), (0.3999999999999999, 0.5812154696132596, 0.8), (0.3999999999999999, 0.5679558011049721, 0.8), (0.3999999999999999, 0.5546961325966846, 0.8), (0.3999999999999999, 0.5414364640883976, 0.8), (0.3999999999999999, 0.5281767955801107, 0.8), (0.3999999999999999, 0.5149171270718231, 0.8), (0.3999999999999999, 0.5016574585635356, 0.8), (0.3999999999999999, 0.4883977900552486, 0.8), (0.3999999999999999, 0.4751381215469616, 0.8), (0.3999999999999999, 0.4618784530386741, 0.8), (0.3999999999999999, 0.44861878453038656, 0.8), (0.3999999999999999, 0.43535911602209953, 0.8), (0.3999999999999999, 0.422099447513812, 0.8), (0.3999999999999999, 0.4088397790055245, 0.8), (0.4044198895027621, 0.3999999999999999, 0.8), (0.41767955801104906, 0.3999999999999999, 0.8), (0.4309392265193366, 0.3999999999999999, 0.8), (0.4441988950276241, 0.3999999999999999, 0.8), (0.45745856353591113, 0.3999999999999999, 0.8), (0.47071823204419866, 0.3999999999999999, 0.8), (0.4839779005524862, 0.3999999999999999, 0.8), (0.49723756906077315, 0.3999999999999999, 0.8), (0.5104972375690602, 0.3999999999999999, 0.8), (0.5237569060773477, 0.3999999999999999, 0.8), (0.5370165745856352, 0.3999999999999999, 0.8), (0.5502762430939222, 0.3999999999999999, 0.8), (0.5635359116022097, 0.3999999999999999, 0.8), (0.5767955801104973, 0.3999999999999999, 0.8), (0.5900552486187843, 0.3999999999999999, 0.8), (0.6033149171270713, 0.3999999999999999, 0.8), (0.6165745856353588, 0.3999999999999999, 0.8), (0.6298342541436464, 0.3999999999999999, 0.8), (0.6430939226519333, 0.3999999999999999, 0.8), (0.6563535911602209, 0.3999999999999999, 0.8), (0.6696132596685085, 0.3999999999999999, 0.8), (0.6828729281767953, 0.3999999999999999, 0.8), (0.6961325966850824, 0.3999999999999999, 0.8), (0.70939226519337, 0.3999999999999999, 0.8), (0.7226519337016575, 0.3999999999999999, 0.8), (0.7359116022099444, 0.3999999999999999, 0.8), (0.7491712707182314, 0.3999999999999999, 0.8), (0.7624309392265189, 0.3999999999999999, 0.8), (0.7756906077348065, 0.3999999999999999, 0.8), (0.7889502762430936, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7977900552486186), (0.8, 0.3999999999999999, 0.784530386740331), (0.8, 0.3999999999999999, 0.7712707182320441), (0.8, 0.3999999999999999, 0.7580110497237571), (0.8, 0.3999999999999999, 0.7447513812154696), (0.8, 0.3999999999999999, 0.731491712707182), (0.8, 0.3999999999999999, 0.718232044198895), (0.8, 0.3999999999999999, 0.7049723756906074), (0.8, 0.3999999999999999, 0.6917127071823199), (0.8, 0.3999999999999999, 0.6784530386740331), (0.8, 0.3999999999999999, 0.665193370165746), (0.8, 0.3999999999999999, 0.6519337016574585), (0.8, 0.3999999999999999, 0.6386740331491709), (0.8, 0.3999999999999999, 0.625414364640884), (0.8, 0.3999999999999999, 0.6121546961325964), (0.8, 0.3999999999999999, 0.5988950276243089), (0.8, 0.3999999999999999, 0.5856353591160219), (0.8, 0.3999999999999999, 0.5723756906077349), (0.8, 0.3999999999999999, 0.5591160220994473), (0.8, 0.3999999999999999, 0.5458563535911598), (0.8, 0.3999999999999999, 0.5325966850828728), (0.8, 0.3999999999999999, 0.5193370165745853), (0.8, 0.3999999999999999, 0.5060773480662978), (0.8, 0.3999999999999999, 0.49281767955801076), (0.8, 0.3999999999999999, 0.47955801104972373), (0.8, 0.3999999999999999, 0.4662983425414362), (0.8, 0.3999999999999999, 0.4530386740331487), (0.8, 0.3999999999999999, 0.4397790055248617), (0.8, 0.3999999999999999, 0.4265193370165747), (0.8, 0.3999999999999999, 0.41325966850828716)],
    182: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41318681318681305, 0.3999999999999999), (0.8, 0.4263736263736262, 0.3999999999999999), (0.8, 0.43956043956043933, 0.3999999999999999), (0.8, 0.45274725274725247, 0.3999999999999999), (0.8, 0.4659340659340656, 0.3999999999999999), (0.8, 0.4791208791208793, 0.3999999999999999), (0.8, 0.49230769230769245, 0.3999999999999999), (0.8, 0.5054945054945056, 0.3999999999999999), (0.8, 0.5186813186813187, 0.3999999999999999), (0.8, 0.5318681318681319, 0.3999999999999999), (0.8, 0.545054945054945, 0.3999999999999999), (0.8, 0.5582417582417581, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.5978021978021976, 0.3999999999999999), (0.8, 0.6109890109890107, 0.3999999999999999), (0.8, 0.6241758241758244, 0.3999999999999999), (0.8, 0.6373626373626375, 0.3999999999999999), (0.8, 0.6505494505494507, 0.3999999999999999), (0.8, 0.6637362637362638, 0.3999999999999999), (0.8, 0.676923076923077, 0.3999999999999999), (0.8, 0.6901098901098901, 0.3999999999999999), (0.8, 0.7032967032967032, 0.3999999999999999), (0.8, 0.7164835164835164, 0.3999999999999999), (0.8, 0.7296703296703295, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7560439560439558, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.8, 0.7824175824175827, 0.3999999999999999), (0.8, 0.7956043956043959, 0.3999999999999999), (0.7912087912087913, 0.8, 0.3999999999999999), (0.7780219780219781, 0.8, 0.3999999999999999), (0.7648351648351649, 0.8, 0.3999999999999999), (0.7516483516483518, 0.8, 0.3999999999999999), (0.7384615384615386, 0.8, 0.3999999999999999), (0.7252747252747255, 0.8, 0.3999999999999999), (0.7120879120879123, 0.8, 0.3999999999999999), (0.6989010989010992, 0.8, 0.3999999999999999), (0.6857142857142855, 0.8, 0.3999999999999999), (0.6725274725274724, 0.8, 0.3999999999999999), (0.6593406593406592, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.6329670329670329, 0.8, 0.3999999999999999), (0.6197802197802198, 0.8, 0.3999999999999999), (0.6065934065934067, 0.8, 0.3999999999999999), (0.5934065934065935, 0.8, 0.3999999999999999), (0.5802197802197804, 0.8, 0.3999999999999999), (0.5670329670329672, 0.8, 0.3999999999999999), (0.5538461538461541, 0.8, 0.3999999999999999), (0.540659340659341, 0.8, 0.3999999999999999), (0.5274725274725278, 0.8, 0.3999999999999999), (0.5142857142857141, 0.8, 0.3999999999999999), (0.501098901098901, 0.8, 0.3999999999999999), (0.4879120879120878, 0.8, 0.3999999999999999), (0.47472527472527465, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.44835164835164837, 0.8, 0.3999999999999999), (0.43516483516483523, 0.8, 0.3999999999999999), (0.4219780219780221, 0.8, 0.3999999999999999), (0.4087912087912084, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4043956043956047), (0.3999999999999999, 0.8, 0.4175824175824178), (0.3999999999999999, 0.8, 0.43076923076923096), (0.3999999999999999, 0.8, 0.44395604395604416), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.47032967032967044), (0.3999999999999999, 0.8, 0.4835164835164836), (0.3999999999999999, 0.8, 0.4967032967032967), (0.3999999999999999, 0.8, 0.5098901098901099), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.5362637362637361), (0.3999999999999999, 0.8, 0.5494505494505493), (0.3999999999999999, 0.8, 0.5626373626373624), (0.3999999999999999, 0.8, 0.5758241758241761), (0.3999999999999999, 0.8, 0.5890109890109892), (0.3999999999999999, 0.8, 0.6021978021978024), (0.3999999999999999, 0.8, 0.6153846153846155), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6417582417582418), (0.3999999999999999, 0.8, 0.654945054945055), (0.3999999999999999, 0.8, 0.6681318681318682), (0.3999999999999999, 0.8, 0.6813186813186813), (0.3999999999999999, 0.8, 0.6945054945054949), (0.3999999999999999, 0.8, 0.7076923076923081), (0.3999999999999999, 0.8, 0.7208791208791212), (0.3999999999999999, 0.8, 0.7340659340659343), (0.3999999999999999, 0.8, 0.7472527472527475), (0.3999999999999999, 0.8, 0.7604395604395606), (0.3999999999999999, 0.8, 0.7736263736263738), (0.3999999999999999, 0.8, 0.7868131868131869), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7868131868131869, 0.8), (0.3999999999999999, 0.7736263736263737, 0.8), (0.3999999999999999, 0.7604395604395605, 0.8), (0.3999999999999999, 0.7472527472527474, 0.8), (0.3999999999999999, 0.7340659340659342, 0.8), (0.3999999999999999, 0.7208791208791211, 0.8), (0.3999999999999999, 0.7076923076923074, 0.8), (0.3999999999999999, 0.6945054945054943, 0.8), (0.3999999999999999, 0.6813186813186811, 0.8), (0.3999999999999999, 0.668131868131868, 0.8), (0.3999999999999999, 0.6549450549450548, 0.8), (0.3999999999999999, 0.6417582417582411, 0.8), (0.3999999999999999, 0.628571428571428, 0.8), (0.3999999999999999, 0.6153846153846149, 0.8), (0.3999999999999999, 0.6021978021978017, 0.8), (0.3999999999999999, 0.5890109890109886, 0.8), (0.3999999999999999, 0.5758241758241754, 0.8), (0.3999999999999999, 0.5626373626373623, 0.8), (0.3999999999999999, 0.5494505494505492, 0.8), (0.3999999999999999, 0.536263736263736, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.5098901098901097, 0.8), (0.3999999999999999, 0.49670329670329655, 0.8), (0.3999999999999999, 0.4835164835164834, 0.8), (0.3999999999999999, 0.47032967032967027, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.3999999999999999, 0.443956043956044, 0.8), (0.3999999999999999, 0.43076923076923085, 0.8), (0.3999999999999999, 0.41758241758241715, 0.8), (0.3999999999999999, 0.404395604395604, 0.8), (0.40879120879120867, 0.3999999999999999, 0.8), (0.4219780219780218, 0.3999999999999999, 0.8), (0.43516483516483495, 0.3999999999999999, 0.8), (0.4483516483516481, 0.3999999999999999, 0.8), (0.4615384615384618, 0.3999999999999999, 0.8), (0.4747252747252749, 0.3999999999999999, 0.8), (0.48791208791208807, 0.3999999999999999, 0.8), (0.5010989010989012, 0.3999999999999999, 0.8), (0.5142857142857143, 0.3999999999999999, 0.8), (0.5274725274725275, 0.3999999999999999, 0.8), (0.5406593406593406, 0.3999999999999999, 0.8), (0.5538461538461538, 0.3999999999999999, 0.8), (0.5670329670329669, 0.3999999999999999, 0.8), (0.58021978021978, 0.3999999999999999, 0.8), (0.5934065934065932, 0.3999999999999999, 0.8), (0.6065934065934063, 0.3999999999999999, 0.8), (0.6197802197802196, 0.3999999999999999, 0.8), (0.6329670329670327, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.659340659340659, 0.3999999999999999, 0.8), (0.6725274725274726, 0.3999999999999999, 0.8), (0.6857142857142857, 0.3999999999999999, 0.8), (0.6989010989010989, 0.3999999999999999, 0.8), (0.712087912087912, 0.3999999999999999, 0.8), (0.7252747252747251, 0.3999999999999999, 0.8), (0.7384615384615383, 0.3999999999999999, 0.8), (0.7516483516483521, 0.3999999999999999, 0.8), (0.7648351648351652, 0.3999999999999999, 0.8), (0.7780219780219784, 0.3999999999999999, 0.8), (0.7912087912087915, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.795604395604395), (0.8, 0.3999999999999999, 0.7824175824175819), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7560439560439556), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7296703296703293), (0.8, 0.3999999999999999, 0.7164835164835162), (0.8, 0.3999999999999999, 0.703296703296703), (0.8, 0.3999999999999999, 0.6901098901098899), (0.8, 0.3999999999999999, 0.6769230769230767), (0.8, 0.3999999999999999, 0.6637362637362636), (0.8, 0.3999999999999999, 0.6505494505494505), (0.8, 0.3999999999999999, 0.6373626373626373), (0.8, 0.3999999999999999, 0.6241758241758236), (0.8, 0.3999999999999999, 0.6109890109890105), (0.8, 0.3999999999999999, 0.5978021978021973), (0.8, 0.3999999999999999, 0.5846153846153842), (0.8, 0.3999999999999999, 0.5714285714285711), (0.8, 0.3999999999999999, 0.5582417582417574), (0.8, 0.3999999999999999, 0.5450549450549442), (0.8, 0.3999999999999999, 0.5318681318681311), (0.8, 0.3999999999999999, 0.518681318681318), (0.8, 0.3999999999999999, 0.5054945054945048), (0.8, 0.3999999999999999, 0.49230769230769167), (0.8, 0.3999999999999999, 0.47912087912087853), (0.8, 0.3999999999999999, 0.4659340659340654), (0.8, 0.3999999999999999, 0.45274725274725225), (0.8, 0.3999999999999999, 0.43956043956043905), (0.8, 0.3999999999999999, 0.4263736263736259), (0.8, 0.3999999999999999, 0.4131868131868128)],
    183: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41311475409836057, 0.3999999999999999), (0.8, 0.42622950819672123, 0.3999999999999999), (0.8, 0.43934426229508194, 0.3999999999999999), (0.8, 0.4524590163934426, 0.3999999999999999), (0.8, 0.46557377049180326, 0.3999999999999999), (0.8, 0.478688524590164, 0.3999999999999999), (0.8, 0.49180327868852464, 0.3999999999999999), (0.8, 0.5049180327868853, 0.3999999999999999), (0.8, 0.518032786885246, 0.3999999999999999), (0.8, 0.5311475409836066, 0.3999999999999999), (0.8, 0.5442622950819673, 0.3999999999999999), (0.8, 0.557377049180328, 0.3999999999999999), (0.8, 0.5704918032786886, 0.3999999999999999), (0.8, 0.5836065573770494, 0.3999999999999999), (0.8, 0.5967213114754101, 0.3999999999999999), (0.8, 0.6098360655737707, 0.3999999999999999), (0.8, 0.6229508196721314, 0.3999999999999999), (0.8, 0.6360655737704921, 0.3999999999999999), (0.8, 0.6491803278688522, 0.3999999999999999), (0.8, 0.6622950819672129, 0.3999999999999999), (0.8, 0.6754098360655736, 0.3999999999999999), (0.8, 0.6885245901639343, 0.3999999999999999), (0.8, 0.7016393442622949, 0.3999999999999999), (0.8, 0.7147540983606555, 0.3999999999999999), (0.8, 0.7278688524590162, 0.3999999999999999), (0.8, 0.7409836065573769, 0.3999999999999999), (0.8, 0.7540983606557377, 0.3999999999999999), (0.8, 0.7672131147540983, 0.3999999999999999), (0.8, 0.7803278688524589, 0.3999999999999999), (0.8, 0.7934426229508196, 0.3999999999999999), (0.7934426229508198, 0.8, 0.3999999999999999), (0.7803278688524593, 0.8, 0.3999999999999999), (0.7672131147540986, 0.8, 0.3999999999999999), (0.7540983606557379, 0.8, 0.3999999999999999), (0.7409836065573772, 0.8, 0.3999999999999999), (0.7278688524590164, 0.8, 0.3999999999999999), (0.7147540983606558, 0.8, 0.3999999999999999), (0.7016393442622952, 0.8, 0.3999999999999999), (0.6885245901639345, 0.8, 0.3999999999999999), (0.6754098360655738, 0.8, 0.3999999999999999), (0.6622950819672131, 0.8, 0.3999999999999999), (0.6491803278688525, 0.8, 0.3999999999999999), (0.6360655737704918, 0.8, 0.3999999999999999), (0.6229508196721312, 0.8, 0.3999999999999999), (0.6098360655737705, 0.8, 0.3999999999999999), (0.5967213114754097, 0.8, 0.3999999999999999), (0.583606557377049, 0.8, 0.3999999999999999), (0.5704918032786884, 0.8, 0.3999999999999999), (0.5573770491803277, 0.8, 0.3999999999999999), (0.5442622950819671, 0.8, 0.3999999999999999), (0.5311475409836064, 0.8, 0.3999999999999999), (0.5180327868852462, 0.8, 0.3999999999999999), (0.5049180327868851, 0.8, 0.3999999999999999), (0.4918032786885249, 0.8, 0.3999999999999999), (0.4786885245901637, 0.8, 0.3999999999999999), (0.46557377049180354, 0.8, 0.3999999999999999), (0.4524590163934423, 0.8, 0.3999999999999999), (0.4393442622950822, 0.8, 0.3999999999999999), (0.426229508196721, 0.8, 0.3999999999999999), (0.41311475409836085, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41311475409836046), (0.3999999999999999, 0.8, 0.4262295081967211), (0.3999999999999999, 0.8, 0.4393442622950818), (0.3999999999999999, 0.8, 0.4524590163934425), (0.3999999999999999, 0.8, 0.46557377049180315), (0.3999999999999999, 0.8, 0.4786885245901638), (0.3999999999999999, 0.8, 0.49180327868852447), (0.3999999999999999, 0.8, 0.5049180327868852), (0.3999999999999999, 0.8, 0.5180327868852459), (0.3999999999999999, 0.8, 0.5311475409836065), (0.3999999999999999, 0.8, 0.5442622950819672), (0.3999999999999999, 0.8, 0.5573770491803278), (0.3999999999999999, 0.8, 0.5704918032786885), (0.3999999999999999, 0.8, 0.5836065573770493), (0.3999999999999999, 0.8, 0.5967213114754099), (0.3999999999999999, 0.8, 0.6098360655737706), (0.3999999999999999, 0.8, 0.6229508196721313), (0.3999999999999999, 0.8, 0.6360655737704919), (0.3999999999999999, 0.8, 0.6491803278688526), (0.3999999999999999, 0.8, 0.6622950819672133), (0.3999999999999999, 0.8, 0.675409836065574), (0.3999999999999999, 0.8, 0.6885245901639346), (0.3999999999999999, 0.8, 0.7016393442622952), (0.3999999999999999, 0.8, 0.714754098360656), (0.3999999999999999, 0.8, 0.7278688524590167), (0.3999999999999999, 0.8, 0.7409836065573767), (0.3999999999999999, 0.8, 0.754098360655738), (0.3999999999999999, 0.8, 0.7672131147540981), (0.3999999999999999, 0.8, 0.7803278688524593), (0.3999999999999999, 0.8, 0.7934426229508196), (0.3999999999999999, 0.7934426229508194, 0.8), (0.3999999999999999, 0.7803278688524593, 0.8), (0.3999999999999999, 0.767213114754098, 0.8), (0.3999999999999999, 0.7540983606557379, 0.8), (0.3999999999999999, 0.7409836065573767, 0.8), (0.3999999999999999, 0.7278688524590164, 0.8), (0.3999999999999999, 0.7147540983606553, 0.8), (0.3999999999999999, 0.7016393442622952, 0.8), (0.3999999999999999, 0.688524590163934, 0.8), (0.3999999999999999, 0.6754098360655738, 0.8), (0.3999999999999999, 0.6622950819672131, 0.8), (0.3999999999999999, 0.6491803278688525, 0.8), (0.3999999999999999, 0.6360655737704918, 0.8), (0.3999999999999999, 0.6229508196721312, 0.8), (0.3999999999999999, 0.6098360655737705, 0.8), (0.3999999999999999, 0.5967213114754097, 0.8), (0.3999999999999999, 0.583606557377049, 0.8), (0.3999999999999999, 0.5704918032786884, 0.8), (0.3999999999999999, 0.5573770491803277, 0.8), (0.3999999999999999, 0.5442622950819671, 0.8), (0.3999999999999999, 0.5311475409836064, 0.8), (0.3999999999999999, 0.5180327868852457, 0.8), (0.3999999999999999, 0.5049180327868851, 0.8), (0.3999999999999999, 0.49180327868852436, 0.8), (0.3999999999999999, 0.4786885245901637, 0.8), (0.3999999999999999, 0.46557377049180304, 0.8), (0.3999999999999999, 0.4524590163934423, 0.8), (0.3999999999999999, 0.43934426229508167, 0.8), (0.3999999999999999, 0.4262295081967215, 0.8), (0.3999999999999999, 0.4131147540983603, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41311475409836057, 0.3999999999999999, 0.8), (0.42622950819672073, 0.3999999999999999, 0.8), (0.43934426229508194, 0.3999999999999999, 0.8), (0.4524590163934421, 0.3999999999999999, 0.8), (0.46557377049180326, 0.3999999999999999, 0.8), (0.4786885245901634, 0.3999999999999999, 0.8), (0.49180327868852464, 0.3999999999999999, 0.8), (0.5049180327868847, 0.3999999999999999, 0.8), (0.518032786885246, 0.3999999999999999, 0.8), (0.5311475409836062, 0.3999999999999999, 0.8), (0.5442622950819673, 0.3999999999999999, 0.8), (0.5573770491803275, 0.3999999999999999, 0.8), (0.5704918032786886, 0.3999999999999999, 0.8), (0.5836065573770488, 0.3999999999999999, 0.8), (0.5967213114754101, 0.3999999999999999, 0.8), (0.6098360655737701, 0.3999999999999999, 0.8), (0.6229508196721308, 0.3999999999999999, 0.8), (0.6360655737704916, 0.3999999999999999, 0.8), (0.6491803278688522, 0.3999999999999999, 0.8), (0.6622950819672129, 0.3999999999999999, 0.8), (0.6754098360655736, 0.3999999999999999, 0.8), (0.6885245901639343, 0.3999999999999999, 0.8), (0.7016393442622949, 0.3999999999999999, 0.8), (0.7147540983606555, 0.3999999999999999, 0.8), (0.7278688524590162, 0.3999999999999999, 0.8), (0.7409836065573769, 0.3999999999999999, 0.8), (0.7540983606557377, 0.3999999999999999, 0.8), (0.7672131147540983, 0.3999999999999999, 0.8), (0.7803278688524589, 0.3999999999999999, 0.8), (0.7934426229508196, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7934426229508194), (0.8, 0.3999999999999999, 0.7803278688524586), (0.8, 0.3999999999999999, 0.767213114754098), (0.8, 0.3999999999999999, 0.7540983606557373), (0.8, 0.3999999999999999, 0.7409836065573772), (0.8, 0.3999999999999999, 0.727868852459016), (0.8, 0.3999999999999999, 0.7147540983606558), (0.8, 0.3999999999999999, 0.7016393442622946), (0.8, 0.3999999999999999, 0.6885245901639345), (0.8, 0.3999999999999999, 0.6754098360655734), (0.8, 0.3999999999999999, 0.6622950819672131), (0.8, 0.3999999999999999, 0.6491803278688519), (0.8, 0.3999999999999999, 0.6360655737704918), (0.8, 0.3999999999999999, 0.6229508196721306), (0.8, 0.3999999999999999, 0.6098360655737705), (0.8, 0.3999999999999999, 0.5967213114754092), (0.8, 0.3999999999999999, 0.583606557377049), (0.8, 0.3999999999999999, 0.5704918032786879), (0.8, 0.3999999999999999, 0.5573770491803277), (0.8, 0.3999999999999999, 0.5442622950819666), (0.8, 0.3999999999999999, 0.5311475409836064), (0.8, 0.3999999999999999, 0.5180327868852457), (0.8, 0.3999999999999999, 0.5049180327868851), (0.8, 0.3999999999999999, 0.49180327868852436), (0.8, 0.3999999999999999, 0.4786885245901637), (0.8, 0.3999999999999999, 0.46557377049180304), (0.8, 0.3999999999999999, 0.4524590163934423), (0.8, 0.3999999999999999, 0.43934426229508167), (0.8, 0.3999999999999999, 0.426229508196721), (0.8, 0.3999999999999999, 0.4131147540983603)],
    184: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4130434782608693, 0.3999999999999999), (0.8, 0.42608695652173917, 0.3999999999999999), (0.8, 0.43913043478260855, 0.3999999999999999), (0.8, 0.4521739130434784, 0.3999999999999999), (0.8, 0.4652173913043478, 0.3999999999999999), (0.8, 0.47826086956521713, 0.3999999999999999), (0.8, 0.491304347826087, 0.3999999999999999), (0.8, 0.5043478260869564, 0.3999999999999999), (0.8, 0.5173913043478258, 0.3999999999999999), (0.8, 0.5304347826086957, 0.3999999999999999), (0.8, 0.543478260869565, 0.3999999999999999), (0.8, 0.5565217391304349, 0.3999999999999999), (0.8, 0.5695652173913043, 0.3999999999999999), (0.8, 0.5826086956521741, 0.3999999999999999), (0.8, 0.5956521739130435, 0.3999999999999999), (0.8, 0.6086956521739129, 0.3999999999999999), (0.8, 0.6217391304347828, 0.3999999999999999), (0.8, 0.6347826086956522, 0.3999999999999999), (0.8, 0.6478260869565216, 0.3999999999999999), (0.8, 0.6608695652173914, 0.3999999999999999), (0.8, 0.6739130434782608, 0.3999999999999999), (0.8, 0.6869565217391307, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7130434782608694, 0.3999999999999999), (0.8, 0.7260869565217393, 0.3999999999999999), (0.8, 0.7391304347826086, 0.3999999999999999), (0.8, 0.7521739130434786, 0.3999999999999999), (0.8, 0.7652173913043478, 0.3999999999999999), (0.8, 0.7782608695652173, 0.3999999999999999), (0.8, 0.791304347826087, 0.3999999999999999), (0.7956521739130438, 0.8, 0.3999999999999999), (0.7826086956521743, 0.8, 0.3999999999999999), (0.7695652173913045, 0.8, 0.3999999999999999), (0.7565217391304351, 0.8, 0.3999999999999999), (0.7434782608695651, 0.8, 0.3999999999999999), (0.7304347826086959, 0.8, 0.3999999999999999), (0.7173913043478259, 0.8, 0.3999999999999999), (0.7043478260869566, 0.8, 0.3999999999999999), (0.6913043478260872, 0.8, 0.3999999999999999), (0.6782608695652173, 0.8, 0.3999999999999999), (0.665217391304348, 0.8, 0.3999999999999999), (0.6521739130434786, 0.8, 0.3999999999999999), (0.6391304347826087, 0.8, 0.3999999999999999), (0.6260869565217393, 0.8, 0.3999999999999999), (0.6130434782608695, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5869565217391307, 0.8, 0.3999999999999999), (0.5739130434782608, 0.8, 0.3999999999999999), (0.5608695652173914, 0.8, 0.3999999999999999), (0.5478260869565216, 0.8, 0.3999999999999999), (0.5347826086956522, 0.8, 0.3999999999999999), (0.5217391304347828, 0.8, 0.3999999999999999), (0.508695652173913, 0.8, 0.3999999999999999), (0.49565217391304356, 0.8, 0.3999999999999999), (0.48260869565217424, 0.8, 0.3999999999999999), (0.4695652173913043, 0.8, 0.3999999999999999), (0.456521739130435, 0.8, 0.3999999999999999), (0.4434782608695651, 0.8, 0.3999999999999999), (0.4304347826086957, 0.8, 0.3999999999999999), (0.4173913043478258, 0.8, 0.3999999999999999), (0.40434782608695646, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40869565217391285), (0.3999999999999999, 0.8, 0.4217391304347827), (0.3999999999999999, 0.8, 0.4347826086956521), (0.3999999999999999, 0.8, 0.4478260869565215), (0.3999999999999999, 0.8, 0.46086956521739136), (0.3999999999999999, 0.8, 0.47391304347826074), (0.3999999999999999, 0.8, 0.48695652173913007), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5130434782608694), (0.3999999999999999, 0.8, 0.5260869565217392), (0.3999999999999999, 0.8, 0.5391304347826086), (0.3999999999999999, 0.8, 0.5521739130434785), (0.3999999999999999, 0.8, 0.5652173913043479), (0.3999999999999999, 0.8, 0.5782608695652172), (0.3999999999999999, 0.8, 0.5913043478260871), (0.3999999999999999, 0.8, 0.6043478260869565), (0.3999999999999999, 0.8, 0.6173913043478259), (0.3999999999999999, 0.8, 0.6304347826086958), (0.3999999999999999, 0.8, 0.643478260869565), (0.3999999999999999, 0.8, 0.656521739130435), (0.3999999999999999, 0.8, 0.6695652173913044), (0.3999999999999999, 0.8, 0.6826086956521742), (0.3999999999999999, 0.8, 0.6956521739130437), (0.3999999999999999, 0.8, 0.708695652173913), (0.3999999999999999, 0.8, 0.7217391304347829), (0.3999999999999999, 0.8, 0.7347826086956522), (0.3999999999999999, 0.8, 0.7478260869565216), (0.3999999999999999, 0.8, 0.7608695652173915), (0.3999999999999999, 0.8, 0.7739130434782608), (0.3999999999999999, 0.8, 0.7869565217391301), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7869565217391301, 0.8), (0.3999999999999999, 0.7739130434782613, 0.8), (0.3999999999999999, 0.7608695652173914, 0.8), (0.3999999999999999, 0.7478260869565214, 0.8), (0.3999999999999999, 0.7347826086956522, 0.8), (0.3999999999999999, 0.7217391304347827, 0.8), (0.3999999999999999, 0.7086956521739128, 0.8), (0.3999999999999999, 0.6956521739130435, 0.8), (0.3999999999999999, 0.6826086956521742, 0.8), (0.3999999999999999, 0.6695652173913043, 0.8), (0.3999999999999999, 0.6565217391304349, 0.8), (0.3999999999999999, 0.6434782608695655, 0.8), (0.3999999999999999, 0.6304347826086956, 0.8), (0.3999999999999999, 0.6173913043478257, 0.8), (0.3999999999999999, 0.6043478260869564, 0.8), (0.3999999999999999, 0.591304347826087, 0.8), (0.3999999999999999, 0.578260869565217, 0.8), (0.3999999999999999, 0.5652173913043477, 0.8), (0.3999999999999999, 0.5521739130434784, 0.8), (0.3999999999999999, 0.5391304347826085, 0.8), (0.3999999999999999, 0.5260869565217391, 0.8), (0.3999999999999999, 0.5130434782608697, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.48695652173912995, 0.8), (0.3999999999999999, 0.47391304347826113, 0.8), (0.3999999999999999, 0.46086956521739125, 0.8), (0.3999999999999999, 0.4478260869565214, 0.8), (0.3999999999999999, 0.434782608695652, 0.8), (0.3999999999999999, 0.4217391304347826, 0.8), (0.3999999999999999, 0.40869565217391274, 0.8), (0.4043478260869562, 0.3999999999999999, 0.8), (0.41739130434782556, 0.3999999999999999, 0.8), (0.43043478260869544, 0.3999999999999999, 0.8), (0.4434782608695648, 0.3999999999999999, 0.8), (0.45652173913043415, 0.3999999999999999, 0.8), (0.4695652173913041, 0.3999999999999999, 0.8), (0.48260869565217396, 0.3999999999999999, 0.8), (0.49565217391304334, 0.3999999999999999, 0.8), (0.5086956521739127, 0.3999999999999999, 0.8), (0.5217391304347826, 0.3999999999999999, 0.8), (0.534782608695652, 0.3999999999999999, 0.8), (0.5478260869565212, 0.3999999999999999, 0.8), (0.5608695652173912, 0.3999999999999999, 0.8), (0.5739130434782606, 0.3999999999999999, 0.8), (0.5869565217391299, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6130434782608697, 0.3999999999999999, 0.8), (0.6260869565217385, 0.3999999999999999, 0.8), (0.6391304347826084, 0.3999999999999999, 0.8), (0.6521739130434783, 0.3999999999999999, 0.8), (0.6652173913043478, 0.3999999999999999, 0.8), (0.678260869565217, 0.3999999999999999, 0.8), (0.691304347826087, 0.3999999999999999, 0.8), (0.7043478260869562, 0.3999999999999999, 0.8), (0.7173913043478257, 0.3999999999999999, 0.8), (0.7304347826086955, 0.3999999999999999, 0.8), (0.7434782608695649, 0.3999999999999999, 0.8), (0.7565217391304342, 0.3999999999999999, 0.8), (0.7695652173913041, 0.3999999999999999, 0.8), (0.7826086956521741, 0.3999999999999999, 0.8), (0.7956521739130433, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7913043478260868), (0.8, 0.3999999999999999, 0.7782608695652169), (0.8, 0.3999999999999999, 0.7652173913043476), (0.8, 0.3999999999999999, 0.7521739130434782), (0.8, 0.3999999999999999, 0.7391304347826084), (0.8, 0.3999999999999999, 0.7260869565217389), (0.8, 0.3999999999999999, 0.7130434782608697), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6869565217391298), (0.8, 0.3999999999999999, 0.673913043478261), (0.8, 0.3999999999999999, 0.6608695652173912), (0.8, 0.3999999999999999, 0.6478260869565212), (0.8, 0.3999999999999999, 0.6347826086956518), (0.8, 0.3999999999999999, 0.6217391304347826), (0.8, 0.3999999999999999, 0.6086956521739126), (0.8, 0.3999999999999999, 0.5956521739130433), (0.8, 0.3999999999999999, 0.5826086956521739), (0.8, 0.3999999999999999, 0.569565217391304), (0.8, 0.3999999999999999, 0.5565217391304347), (0.8, 0.3999999999999999, 0.5434782608695653), (0.8, 0.3999999999999999, 0.5304347826086954), (0.8, 0.3999999999999999, 0.5173913043478255), (0.8, 0.3999999999999999, 0.5043478260869562), (0.8, 0.3999999999999999, 0.4913043478260868), (0.8, 0.3999999999999999, 0.47826086956521685), (0.8, 0.3999999999999999, 0.4652173913043475), (0.8, 0.3999999999999999, 0.45217391304347815), (0.8, 0.3999999999999999, 0.43913043478260827), (0.8, 0.3999999999999999, 0.4260869565217389), (0.8, 0.3999999999999999, 0.4130434782608695)],
    185: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41297297297297275, 0.3999999999999999), (0.8, 0.4259459459459456, 0.3999999999999999), (0.8, 0.438918918918919, 0.3999999999999999), (0.8, 0.45189189189189183, 0.3999999999999999), (0.8, 0.46486486486486467, 0.3999999999999999), (0.8, 0.47783783783783806, 0.3999999999999999), (0.8, 0.4908108108108109, 0.3999999999999999), (0.8, 0.5037837837837837, 0.3999999999999999), (0.8, 0.5167567567567566, 0.3999999999999999), (0.8, 0.5297297297297294, 0.3999999999999999), (0.8, 0.5427027027027028, 0.3999999999999999), (0.8, 0.5556756756756757, 0.3999999999999999), (0.8, 0.5686486486486485, 0.3999999999999999), (0.8, 0.5816216216216219, 0.3999999999999999), (0.8, 0.5945945945945947, 0.3999999999999999), (0.8, 0.6075675675675676, 0.3999999999999999), (0.8, 0.6205405405405404, 0.3999999999999999), (0.8, 0.6335135135135133, 0.3999999999999999), (0.8, 0.6464864864864867, 0.3999999999999999), (0.8, 0.6594594594594595, 0.3999999999999999), (0.8, 0.6724324324324323, 0.3999999999999999), (0.8, 0.6854054054054057, 0.3999999999999999), (0.8, 0.6983783783783786, 0.3999999999999999), (0.8, 0.7113513513513514, 0.3999999999999999), (0.8, 0.7243243243243243, 0.3999999999999999), (0.8, 0.7372972972972971, 0.3999999999999999), (0.8, 0.7502702702702704, 0.3999999999999999), (0.8, 0.7632432432432433, 0.3999999999999999), (0.8, 0.7762162162162161, 0.3999999999999999), (0.8, 0.7891891891891896, 0.3999999999999999), (0.7978378378378379, 0.8, 0.3999999999999999), (0.7848648648648651, 0.8, 0.3999999999999999), (0.7718918918918921, 0.8, 0.3999999999999999), (0.7589189189189193, 0.8, 0.3999999999999999), (0.7459459459459459, 0.8, 0.3999999999999999), (0.732972972972973, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7070270270270269, 0.8, 0.3999999999999999), (0.6940540540540541, 0.8, 0.3999999999999999), (0.6810810810810812, 0.8, 0.3999999999999999), (0.6681081081081084, 0.8, 0.3999999999999999), (0.6551351351351354, 0.8, 0.3999999999999999), (0.642162162162162, 0.8, 0.3999999999999999), (0.6291891891891892, 0.8, 0.3999999999999999), (0.6162162162162164, 0.8, 0.3999999999999999), (0.603243243243243, 0.8, 0.3999999999999999), (0.5902702702702701, 0.8, 0.3999999999999999), (0.5772972972972973, 0.8, 0.3999999999999999), (0.5643243243243244, 0.8, 0.3999999999999999), (0.5513513513513516, 0.8, 0.3999999999999999), (0.5383783783783782, 0.8, 0.3999999999999999), (0.5254054054054054, 0.8, 0.3999999999999999), (0.5124324324324325, 0.8, 0.3999999999999999), (0.4994594594594592, 0.8, 0.3999999999999999), (0.48648648648648635, 0.8, 0.3999999999999999), (0.4735135135135135, 0.8, 0.3999999999999999), (0.46054054054054067, 0.8, 0.3999999999999999), (0.4475675675675678, 0.8, 0.3999999999999999), (0.43459459459459443, 0.8, 0.3999999999999999), (0.4216216216216216, 0.8, 0.3999999999999999), (0.40864864864864875, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4043243243243246), (0.3999999999999999, 0.8, 0.4172972972972974), (0.3999999999999999, 0.8, 0.43027027027027026), (0.3999999999999999, 0.8, 0.44324324324324316), (0.3999999999999999, 0.8, 0.456216216216216), (0.3999999999999999, 0.8, 0.46918918918918934), (0.3999999999999999, 0.8, 0.4821621621621622), (0.3999999999999999, 0.8, 0.495135135135135), (0.3999999999999999, 0.8, 0.5081081081081085), (0.3999999999999999, 0.8, 0.5210810810810813), (0.3999999999999999, 0.8, 0.5340540540540542), (0.3999999999999999, 0.8, 0.547027027027027), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5729729729729731), (0.3999999999999999, 0.8, 0.585945945945946), (0.3999999999999999, 0.8, 0.5989189189189189), (0.3999999999999999, 0.8, 0.6118918918918922), (0.3999999999999999, 0.8, 0.6248648648648651), (0.3999999999999999, 0.8, 0.637837837837838), (0.3999999999999999, 0.8, 0.6508108108108108), (0.3999999999999999, 0.8, 0.6637837837837837), (0.3999999999999999, 0.8, 0.676756756756757), (0.3999999999999999, 0.8, 0.6897297297297298), (0.3999999999999999, 0.8, 0.7027027027027026), (0.3999999999999999, 0.8, 0.7156756756756761), (0.3999999999999999, 0.8, 0.728648648648649), (0.3999999999999999, 0.8, 0.7416216216216218), (0.3999999999999999, 0.8, 0.7545945945945947), (0.3999999999999999, 0.8, 0.7675675675675675), (0.3999999999999999, 0.8, 0.7805405405405408), (0.3999999999999999, 0.8, 0.7935135135135136), (0.3999999999999999, 0.7935135135135136, 0.8), (0.3999999999999999, 0.7805405405405401, 0.8), (0.3999999999999999, 0.7675675675675673, 0.8), (0.3999999999999999, 0.7545945945945944, 0.8), (0.3999999999999999, 0.7416216216216216, 0.8), (0.3999999999999999, 0.7286486486486488, 0.8), (0.3999999999999999, 0.7156756756756755, 0.8), (0.3999999999999999, 0.7027027027027026, 0.8), (0.3999999999999999, 0.6897297297297298, 0.8), (0.3999999999999999, 0.6767567567567563, 0.8), (0.3999999999999999, 0.6637837837837834, 0.8), (0.3999999999999999, 0.6508108108108106, 0.8), (0.3999999999999999, 0.6378378378378378, 0.8), (0.3999999999999999, 0.6248648648648649, 0.8), (0.3999999999999999, 0.6118918918918915, 0.8), (0.3999999999999999, 0.5989189189189187, 0.8), (0.3999999999999999, 0.585945945945946, 0.8), (0.3999999999999999, 0.5729729729729724, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5470270270270268, 0.8), (0.3999999999999999, 0.5340540540540539, 0.8), (0.3999999999999999, 0.5210810810810811, 0.8), (0.3999999999999999, 0.5081081081081078, 0.8), (0.3999999999999999, 0.4951351351351349, 0.8), (0.3999999999999999, 0.48216216216216207, 0.8), (0.3999999999999999, 0.46918918918918867, 0.8), (0.3999999999999999, 0.45621621621621583, 0.8), (0.3999999999999999, 0.443243243243243, 0.8), (0.3999999999999999, 0.43027027027027015, 0.8), (0.3999999999999999, 0.4172972972972973, 0.8), (0.3999999999999999, 0.4043243243243239, 0.8), (0.40864864864864847, 0.3999999999999999, 0.8), (0.4216216216216213, 0.3999999999999999, 0.8), (0.4345945945945947, 0.3999999999999999, 0.8), (0.44756756756756755, 0.3999999999999999, 0.8), (0.4605405405405404, 0.3999999999999999, 0.8), (0.47351351351351323, 0.3999999999999999, 0.8), (0.48648648648648607, 0.3999999999999999, 0.8), (0.49945945945945946, 0.3999999999999999, 0.8), (0.5124324324324323, 0.3999999999999999, 0.8), (0.5254054054054051, 0.3999999999999999, 0.8), (0.5383783783783785, 0.3999999999999999, 0.8), (0.5513513513513514, 0.3999999999999999, 0.8), (0.5643243243243242, 0.3999999999999999, 0.8), (0.5772972972972971, 0.3999999999999999, 0.8), (0.5902702702702699, 0.3999999999999999, 0.8), (0.6032432432432433, 0.3999999999999999, 0.8), (0.6162162162162161, 0.3999999999999999, 0.8), (0.629189189189189, 0.3999999999999999, 0.8), (0.6421621621621624, 0.3999999999999999, 0.8), (0.6551351351351352, 0.3999999999999999, 0.8), (0.6681081081081081, 0.3999999999999999, 0.8), (0.6810810810810809, 0.3999999999999999, 0.8), (0.6940540540540537, 0.3999999999999999, 0.8), (0.7070270270270271, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7329729729729728, 0.3999999999999999, 0.8), (0.7459459459459461, 0.3999999999999999, 0.8), (0.7589189189189189, 0.3999999999999999, 0.8), (0.7718918918918919, 0.3999999999999999, 0.8), (0.7848648648648646, 0.3999999999999999, 0.8), (0.7978378378378375, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7891891891891887), (0.8, 0.3999999999999999, 0.7762162162162158), (0.8, 0.3999999999999999, 0.763243243243243), (0.8, 0.3999999999999999, 0.7502702702702697), (0.8, 0.3999999999999999, 0.7372972972972969), (0.8, 0.3999999999999999, 0.724324324324324), (0.8, 0.3999999999999999, 0.7113513513513512), (0.8, 0.3999999999999999, 0.6983783783783784), (0.8, 0.3999999999999999, 0.6854054054054048), (0.8, 0.3999999999999999, 0.672432432432432), (0.8, 0.3999999999999999, 0.6594594594594592), (0.8, 0.3999999999999999, 0.6464864864864859), (0.8, 0.3999999999999999, 0.633513513513513), (0.8, 0.3999999999999999, 0.6205405405405402), (0.8, 0.3999999999999999, 0.6075675675675672), (0.8, 0.3999999999999999, 0.5945945945945944), (0.8, 0.3999999999999999, 0.581621621621621), (0.8, 0.3999999999999999, 0.5686486486486482), (0.8, 0.3999999999999999, 0.5556756756756753), (0.8, 0.3999999999999999, 0.542702702702702), (0.8, 0.3999999999999999, 0.5297297297297292), (0.8, 0.3999999999999999, 0.5167567567567564), (0.8, 0.3999999999999999, 0.5037837837837835), (0.8, 0.3999999999999999, 0.4908108108108106), (0.8, 0.3999999999999999, 0.47783783783783723), (0.8, 0.3999999999999999, 0.4648648648648644), (0.8, 0.3999999999999999, 0.45189189189189155), (0.8, 0.3999999999999999, 0.43891891891891816), (0.8, 0.3999999999999999, 0.4259459459459453), (0.8, 0.3999999999999999, 0.4129729729729725)],
    186: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4129032258064515, 0.3999999999999999), (0.8, 0.4258064516129031, 0.3999999999999999), (0.8, 0.43870967741935474, 0.3999999999999999), (0.8, 0.45161290322580633, 0.3999999999999999), (0.8, 0.4645161290322579, 0.3999999999999999), (0.8, 0.47741935483870956, 0.3999999999999999), (0.8, 0.49032258064516115, 0.3999999999999999), (0.8, 0.5032258064516127, 0.3999999999999999), (0.8, 0.5161290322580644, 0.3999999999999999), (0.8, 0.5290322580645159, 0.3999999999999999), (0.8, 0.5419354838709676, 0.3999999999999999), (0.8, 0.5548387096774192, 0.3999999999999999), (0.8, 0.5677419354838708, 0.3999999999999999), (0.8, 0.5806451612903224, 0.3999999999999999), (0.8, 0.593548387096774, 0.3999999999999999), (0.8, 0.6064516129032256, 0.3999999999999999), (0.8, 0.6193548387096772, 0.3999999999999999), (0.8, 0.6322580645161289, 0.3999999999999999), (0.8, 0.6451612903225804, 0.3999999999999999), (0.8, 0.658064516129032, 0.3999999999999999), (0.8, 0.6709677419354836, 0.3999999999999999), (0.8, 0.6838709677419352, 0.3999999999999999), (0.8, 0.6967741935483873, 0.3999999999999999), (0.8, 0.7096774193548385, 0.3999999999999999), (0.8, 0.7225806451612906, 0.3999999999999999), (0.8, 0.7354838709677423, 0.3999999999999999), (0.8, 0.7483870967741938, 0.3999999999999999), (0.8, 0.7612903225806453, 0.3999999999999999), (0.8, 0.774193548387097, 0.3999999999999999), (0.8, 0.7870967741935486, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7870967741935484, 0.8, 0.3999999999999999), (0.7741935483870968, 0.8, 0.3999999999999999), (0.7612903225806451, 0.8, 0.3999999999999999), (0.7483870967741935, 0.8, 0.3999999999999999), (0.7354838709677419, 0.8, 0.3999999999999999), (0.7225806451612904, 0.8, 0.3999999999999999), (0.7096774193548387, 0.8, 0.3999999999999999), (0.6967741935483871, 0.8, 0.3999999999999999), (0.6838709677419355, 0.8, 0.3999999999999999), (0.6709677419354839, 0.8, 0.3999999999999999), (0.6580645161290323, 0.8, 0.3999999999999999), (0.6451612903225807, 0.8, 0.3999999999999999), (0.6322580645161291, 0.8, 0.3999999999999999), (0.6193548387096774, 0.8, 0.3999999999999999), (0.6064516129032259, 0.8, 0.3999999999999999), (0.5935483870967743, 0.8, 0.3999999999999999), (0.5806451612903226, 0.8, 0.3999999999999999), (0.5677419354838711, 0.8, 0.3999999999999999), (0.5548387096774194, 0.8, 0.3999999999999999), (0.5419354838709678, 0.8, 0.3999999999999999), (0.5290322580645163, 0.8, 0.3999999999999999), (0.5161290322580646, 0.8, 0.3999999999999999), (0.5032258064516131, 0.8, 0.3999999999999999), (0.49032258064516143, 0.8, 0.3999999999999999), (0.4774193548387098, 0.8, 0.3999999999999999), (0.4645161290322582, 0.8, 0.3999999999999999), (0.4516129032258066, 0.8, 0.3999999999999999), (0.43870967741935446, 0.8, 0.3999999999999999), (0.42580645161290287, 0.8, 0.3999999999999999), (0.4129032258064512, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.4129032258064519), (0.3999999999999999, 0.8, 0.42580645161290354), (0.3999999999999999, 0.8, 0.4387096774193551), (0.3999999999999999, 0.8, 0.4516129032258067), (0.3999999999999999, 0.8, 0.46451612903225836), (0.3999999999999999, 0.8, 0.47741935483870995), (0.3999999999999999, 0.8, 0.49032258064516154), (0.3999999999999999, 0.8, 0.5032258064516132), (0.3999999999999999, 0.8, 0.5161290322580647), (0.3999999999999999, 0.8, 0.5290322580645164), (0.3999999999999999, 0.8, 0.541935483870968), (0.3999999999999999, 0.8, 0.5548387096774196), (0.3999999999999999, 0.8, 0.5677419354838712), (0.3999999999999999, 0.8, 0.5806451612903227), (0.3999999999999999, 0.8, 0.5935483870967744), (0.3999999999999999, 0.8, 0.606451612903226), (0.3999999999999999, 0.8, 0.6193548387096777), (0.3999999999999999, 0.8, 0.6322580645161292), (0.3999999999999999, 0.8, 0.6451612903225808), (0.3999999999999999, 0.8, 0.6580645161290324), (0.3999999999999999, 0.8, 0.670967741935484), (0.3999999999999999, 0.8, 0.6838709677419357), (0.3999999999999999, 0.8, 0.6967741935483873), (0.3999999999999999, 0.8, 0.7096774193548389), (0.3999999999999999, 0.8, 0.7225806451612904), (0.3999999999999999, 0.8, 0.735483870967742), (0.3999999999999999, 0.8, 0.7483870967741937), (0.3999999999999999, 0.8, 0.7612903225806453), (0.3999999999999999, 0.8, 0.7741935483870969), (0.3999999999999999, 0.8, 0.7870967741935484), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7870967741935484, 0.8), (0.3999999999999999, 0.7741935483870968, 0.8), (0.3999999999999999, 0.7612903225806451, 0.8), (0.3999999999999999, 0.7483870967741935, 0.8), (0.3999999999999999, 0.7354838709677419, 0.8), (0.3999999999999999, 0.7225806451612904, 0.8), (0.3999999999999999, 0.7096774193548387, 0.8), (0.3999999999999999, 0.6967741935483871, 0.8), (0.3999999999999999, 0.6838709677419355, 0.8), (0.3999999999999999, 0.6709677419354839, 0.8), (0.3999999999999999, 0.6580645161290323, 0.8), (0.3999999999999999, 0.6451612903225807, 0.8), (0.3999999999999999, 0.6322580645161291, 0.8), (0.3999999999999999, 0.6193548387096774, 0.8), (0.3999999999999999, 0.6064516129032259, 0.8), (0.3999999999999999, 0.5935483870967743, 0.8), (0.3999999999999999, 0.5806451612903226, 0.8), (0.3999999999999999, 0.5677419354838711, 0.8), (0.3999999999999999, 0.5548387096774194, 0.8), (0.3999999999999999, 0.5419354838709678, 0.8), (0.3999999999999999, 0.5290322580645163, 0.8), (0.3999999999999999, 0.5161290322580646, 0.8), (0.3999999999999999, 0.5032258064516131, 0.8), (0.3999999999999999, 0.49032258064516143, 0.8), (0.3999999999999999, 0.4774193548387093, 0.8), (0.3999999999999999, 0.4645161290322577, 0.8), (0.3999999999999999, 0.45161290322580605, 0.8), (0.3999999999999999, 0.43870967741935446, 0.8), (0.3999999999999999, 0.42580645161290287, 0.8), (0.3999999999999999, 0.4129032258064512, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.4129032258064515, 0.3999999999999999, 0.8), (0.4258064516129031, 0.3999999999999999, 0.8), (0.43870967741935474, 0.3999999999999999, 0.8), (0.45161290322580633, 0.3999999999999999, 0.8), (0.4645161290322579, 0.3999999999999999, 0.8), (0.47741935483870956, 0.3999999999999999, 0.8), (0.49032258064516115, 0.3999999999999999, 0.8), (0.5032258064516127, 0.3999999999999999, 0.8), (0.5161290322580644, 0.3999999999999999, 0.8), (0.5290322580645159, 0.3999999999999999, 0.8), (0.5419354838709676, 0.3999999999999999, 0.8), (0.5548387096774192, 0.3999999999999999, 0.8), (0.5677419354838708, 0.3999999999999999, 0.8), (0.5806451612903224, 0.3999999999999999, 0.8), (0.5935483870967745, 0.3999999999999999, 0.8), (0.6064516129032261, 0.3999999999999999, 0.8), (0.6193548387096778, 0.3999999999999999, 0.8), (0.6322580645161293, 0.3999999999999999, 0.8), (0.645161290322581, 0.3999999999999999, 0.8), (0.6580645161290326, 0.3999999999999999, 0.8), (0.6709677419354843, 0.3999999999999999, 0.8), (0.6838709677419358, 0.3999999999999999, 0.8), (0.6967741935483873, 0.3999999999999999, 0.8), (0.709677419354839, 0.3999999999999999, 0.8), (0.7225806451612906, 0.3999999999999999, 0.8), (0.7354838709677423, 0.3999999999999999, 0.8), (0.7483870967741938, 0.3999999999999999, 0.8), (0.7612903225806453, 0.3999999999999999, 0.8), (0.774193548387097, 0.3999999999999999, 0.8), (0.7870967741935486, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7870967741935477), (0.8, 0.3999999999999999, 0.7741935483870962), (0.8, 0.3999999999999999, 0.7612903225806447), (0.8, 0.3999999999999999, 0.748387096774193), (0.8, 0.3999999999999999, 0.7354838709677414), (0.8, 0.3999999999999999, 0.7225806451612897), (0.8, 0.3999999999999999, 0.7096774193548382), (0.8, 0.3999999999999999, 0.6967741935483867), (0.8, 0.3999999999999999, 0.683870967741935), (0.8, 0.3999999999999999, 0.6709677419354834), (0.8, 0.3999999999999999, 0.6580645161290317), (0.8, 0.3999999999999999, 0.6451612903225802), (0.8, 0.3999999999999999, 0.6322580645161285), (0.8, 0.3999999999999999, 0.619354838709677), (0.8, 0.3999999999999999, 0.6064516129032254), (0.8, 0.3999999999999999, 0.5935483870967737), (0.8, 0.3999999999999999, 0.5806451612903221), (0.8, 0.3999999999999999, 0.5677419354838705), (0.8, 0.3999999999999999, 0.5548387096774189), (0.8, 0.3999999999999999, 0.5419354838709673), (0.8, 0.3999999999999999, 0.5290322580645157), (0.8, 0.3999999999999999, 0.5161290322580641), (0.8, 0.3999999999999999, 0.5032258064516125), (0.8, 0.3999999999999999, 0.4903225806451609), (0.8, 0.3999999999999999, 0.4774193548387093), (0.8, 0.3999999999999999, 0.4645161290322577), (0.8, 0.3999999999999999, 0.45161290322580605), (0.8, 0.3999999999999999, 0.43870967741935446), (0.8, 0.3999999999999999, 0.42580645161290287), (0.8, 0.3999999999999999, 0.4129032258064512)],
    187: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41283422459893043, 0.3999999999999999), (0.8, 0.42566844919786095, 0.3999999999999999), (0.8, 0.43850267379679153, 0.3999999999999999), (0.8, 0.45133689839572205, 0.3999999999999999), (0.8, 0.4641711229946526, 0.3999999999999999), (0.8, 0.4770053475935826, 0.3999999999999999), (0.8, 0.4898395721925131, 0.3999999999999999), (0.8, 0.5026737967914436, 0.3999999999999999), (0.8, 0.5155080213903742, 0.3999999999999999), (0.8, 0.5283422459893048, 0.3999999999999999), (0.8, 0.5411764705882353, 0.3999999999999999), (0.8, 0.5540106951871658, 0.3999999999999999), (0.8, 0.5668449197860963, 0.3999999999999999), (0.8, 0.5796791443850269, 0.3999999999999999), (0.8, 0.5925133689839575, 0.3999999999999999), (0.8, 0.6053475935828875, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6310160427807485, 0.3999999999999999), (0.8, 0.6438502673796791, 0.3999999999999999), (0.8, 0.6566844919786096, 0.3999999999999999), (0.8, 0.6695187165775401, 0.3999999999999999), (0.8, 0.6823529411764706, 0.3999999999999999), (0.8, 0.6951871657754012, 0.3999999999999999), (0.8, 0.7080213903743318, 0.3999999999999999), (0.8, 0.7208556149732623, 0.3999999999999999), (0.8, 0.7336898395721928, 0.3999999999999999), (0.8, 0.7465240641711228, 0.3999999999999999), (0.8, 0.7593582887700534, 0.3999999999999999), (0.8, 0.7721925133689839, 0.3999999999999999), (0.8, 0.7850267379679143, 0.3999999999999999), (0.8, 0.7978609625668449, 0.3999999999999999), (0.7893048128342246, 0.8, 0.3999999999999999), (0.7764705882352942, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7508021390374331, 0.8, 0.3999999999999999), (0.7379679144385031, 0.8, 0.3999999999999999), (0.7251336898395726, 0.8, 0.3999999999999999), (0.712299465240642, 0.8, 0.3999999999999999), (0.6994652406417114, 0.8, 0.3999999999999999), (0.6866310160427809, 0.8, 0.3999999999999999), (0.6737967914438504, 0.8, 0.3999999999999999), (0.6609625668449198, 0.8, 0.3999999999999999), (0.6481283422459894, 0.8, 0.3999999999999999), (0.6352941176470588, 0.8, 0.3999999999999999), (0.6224598930481282, 0.8, 0.3999999999999999), (0.6096256684491977, 0.8, 0.3999999999999999), (0.5967914438502672, 0.8, 0.3999999999999999), (0.5839572192513371, 0.8, 0.3999999999999999), (0.5711229946524066, 0.8, 0.3999999999999999), (0.5582887700534761, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5326203208556151, 0.8, 0.3999999999999999), (0.5197860962566845, 0.8, 0.3999999999999999), (0.5069518716577539, 0.8, 0.3999999999999999), (0.4941176470588234, 0.8, 0.3999999999999999), (0.4812834224598934, 0.8, 0.3999999999999999), (0.46844919786096284, 0.8, 0.3999999999999999), (0.4556149732620323, 0.8, 0.3999999999999999), (0.4427807486631018, 0.8, 0.3999999999999999), (0.4299465240641713, 0.8, 0.3999999999999999), (0.4171122994652407, 0.8, 0.3999999999999999), (0.4042780748663102, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40855614973262033), (0.3999999999999999, 0.8, 0.42139037433155085), (0.3999999999999999, 0.8, 0.4342245989304814), (0.3999999999999999, 0.8, 0.44705882352941195), (0.3999999999999999, 0.8, 0.4598930481283425), (0.3999999999999999, 0.8, 0.47272727272727244), (0.3999999999999999, 0.8, 0.485561497326203), (0.3999999999999999, 0.8, 0.49839572192513354), (0.3999999999999999, 0.8, 0.5112299465240641), (0.3999999999999999, 0.8, 0.5240641711229946), (0.3999999999999999, 0.8, 0.5368983957219251), (0.3999999999999999, 0.8, 0.5497326203208557), (0.3999999999999999, 0.8, 0.5625668449197863), (0.3999999999999999, 0.8, 0.5754010695187162), (0.3999999999999999, 0.8, 0.5882352941176467), (0.3999999999999999, 0.8, 0.6010695187165773), (0.3999999999999999, 0.8, 0.6139037433155079), (0.3999999999999999, 0.8, 0.6267379679144384), (0.3999999999999999, 0.8, 0.6395721925133689), (0.3999999999999999, 0.8, 0.6524064171122994), (0.3999999999999999, 0.8, 0.66524064171123), (0.3999999999999999, 0.8, 0.6780748663101606), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.7037433155080216), (0.3999999999999999, 0.8, 0.7165775401069521), (0.3999999999999999, 0.8, 0.7294117647058826), (0.3999999999999999, 0.8, 0.7422459893048127), (0.3999999999999999, 0.8, 0.7550802139037431), (0.3999999999999999, 0.8, 0.7679144385026737), (0.3999999999999999, 0.8, 0.7807486631016043), (0.3999999999999999, 0.8, 0.7935828877005349), (0.3999999999999999, 0.7935828877005346, 0.8), (0.3999999999999999, 0.7807486631016047, 0.8), (0.3999999999999999, 0.7679144385026742, 0.8), (0.3999999999999999, 0.7550802139037436, 0.8), (0.3999999999999999, 0.742245989304813, 0.8), (0.3999999999999999, 0.7294117647058825, 0.8), (0.3999999999999999, 0.7165775401069521, 0.8), (0.3999999999999999, 0.7037433155080215, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6780748663101603, 0.8), (0.3999999999999999, 0.6652406417112299, 0.8), (0.3999999999999999, 0.6524064171122993, 0.8), (0.3999999999999999, 0.6395721925133688, 0.8), (0.3999999999999999, 0.6267379679144383, 0.8), (0.3999999999999999, 0.6139037433155077, 0.8), (0.3999999999999999, 0.6010695187165772, 0.8), (0.3999999999999999, 0.5882352941176466, 0.8), (0.3999999999999999, 0.5754010695187166, 0.8), (0.3999999999999999, 0.562566844919786, 0.8), (0.3999999999999999, 0.5497326203208556, 0.8), (0.3999999999999999, 0.536898395721925, 0.8), (0.3999999999999999, 0.5240641711229945, 0.8), (0.3999999999999999, 0.5112299465240645, 0.8), (0.3999999999999999, 0.4983957219251339, 0.8), (0.3999999999999999, 0.4855614973262034, 0.8), (0.3999999999999999, 0.4727272727272729, 0.8), (0.3999999999999999, 0.4598930481283423, 0.8), (0.3999999999999999, 0.4470588235294118, 0.8), (0.3999999999999999, 0.43422459893048126, 0.8), (0.3999999999999999, 0.4213903743315507, 0.8), (0.3999999999999999, 0.40855614973262017, 0.8), (0.4042780748663099, 0.3999999999999999, 0.8), (0.4171122994652404, 0.3999999999999999, 0.8), (0.429946524064171, 0.3999999999999999, 0.8), (0.4427807486631015, 0.3999999999999999, 0.8), (0.45561497326203204, 0.3999999999999999, 0.8), (0.4684491978609626, 0.3999999999999999, 0.8), (0.4812834224598926, 0.3999999999999999, 0.8), (0.49411764705882316, 0.3999999999999999, 0.8), (0.5069518716577537, 0.3999999999999999, 0.8), (0.5197860962566843, 0.3999999999999999, 0.8), (0.5326203208556147, 0.3999999999999999, 0.8), (0.5454545454545447, 0.3999999999999999, 0.8), (0.5582887700534753, 0.3999999999999999, 0.8), (0.5711229946524058, 0.3999999999999999, 0.8), (0.5839572192513364, 0.3999999999999999, 0.8), (0.596791443850267, 0.3999999999999999, 0.8), (0.6096256684491974, 0.3999999999999999, 0.8), (0.622459893048128, 0.3999999999999999, 0.8), (0.6352941176470586, 0.3999999999999999, 0.8), (0.648128342245989, 0.3999999999999999, 0.8), (0.6609625668449196, 0.3999999999999999, 0.8), (0.6737967914438501, 0.3999999999999999, 0.8), (0.6866310160427807, 0.3999999999999999, 0.8), (0.6994652406417112, 0.3999999999999999, 0.8), (0.7122994652406418, 0.3999999999999999, 0.8), (0.7251336898395723, 0.3999999999999999, 0.8), (0.7379679144385027, 0.3999999999999999, 0.8), (0.7508021390374329, 0.3999999999999999, 0.8), (0.7636363636363633, 0.3999999999999999, 0.8), (0.7764705882352938, 0.3999999999999999, 0.8), (0.7893048128342244, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7978609625668447), (0.8, 0.3999999999999999, 0.7850267379679148), (0.8, 0.3999999999999999, 0.7721925133689842), (0.8, 0.3999999999999999, 0.7593582887700536), (0.8, 0.3999999999999999, 0.746524064171123), (0.8, 0.3999999999999999, 0.7336898395721925), (0.8, 0.3999999999999999, 0.720855614973262), (0.8, 0.3999999999999999, 0.7080213903743315), (0.8, 0.3999999999999999, 0.695187165775401), (0.8, 0.3999999999999999, 0.6823529411764704), (0.8, 0.3999999999999999, 0.6695187165775398), (0.8, 0.3999999999999999, 0.6566844919786093), (0.8, 0.3999999999999999, 0.6438502673796788), (0.8, 0.3999999999999999, 0.6310160427807483), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.6053475935828871), (0.8, 0.3999999999999999, 0.5925133689839571), (0.8, 0.3999999999999999, 0.5796791443850267), (0.8, 0.3999999999999999, 0.5668449197860961), (0.8, 0.3999999999999999, 0.5540106951871655), (0.8, 0.3999999999999999, 0.541176470588235), (0.8, 0.3999999999999999, 0.528342245989305), (0.8, 0.3999999999999999, 0.5155080213903744), (0.8, 0.3999999999999999, 0.502673796791444), (0.8, 0.3999999999999999, 0.4898395721925134), (0.8, 0.3999999999999999, 0.4770053475935829), (0.8, 0.3999999999999999, 0.46417112299465235), (0.8, 0.3999999999999999, 0.4513368983957218), (0.8, 0.3999999999999999, 0.43850267379679125), (0.8, 0.3999999999999999, 0.42566844919786073), (0.8, 0.3999999999999999, 0.41283422459893016)],
    188: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4127659574468082, 0.3999999999999999), (0.8, 0.4255319148936171, 0.3999999999999999), (0.8, 0.43829787234042544, 0.3999999999999999), (0.8, 0.4510638297872338, 0.3999999999999999), (0.8, 0.46382978723404267, 0.3999999999999999), (0.8, 0.476595744680851, 0.3999999999999999), (0.8, 0.4893617021276593, 0.3999999999999999), (0.8, 0.5021276595744681, 0.3999999999999999), (0.8, 0.5148936170212766, 0.3999999999999999), (0.8, 0.5276595744680849, 0.3999999999999999), (0.8, 0.5404255319148937, 0.3999999999999999), (0.8, 0.553191489361702, 0.3999999999999999), (0.8, 0.5659574468085103, 0.3999999999999999), (0.8, 0.5787234042553192, 0.3999999999999999), (0.8, 0.5914893617021276, 0.3999999999999999), (0.8, 0.6042553191489359, 0.3999999999999999), (0.8, 0.6170212765957448, 0.3999999999999999), (0.8, 0.6297872340425531, 0.3999999999999999), (0.8, 0.6425531914893614, 0.3999999999999999), (0.8, 0.6553191489361703, 0.3999999999999999), (0.8, 0.6680851063829787, 0.3999999999999999), (0.8, 0.6808510638297876, 0.3999999999999999), (0.8, 0.6936170212765959, 0.3999999999999999), (0.8, 0.7063829787234042, 0.3999999999999999), (0.8, 0.7191489361702126, 0.3999999999999999), (0.8, 0.7319148936170214, 0.3999999999999999), (0.8, 0.7446808510638296, 0.3999999999999999), (0.8, 0.7574468085106385, 0.3999999999999999), (0.8, 0.7702127659574469, 0.3999999999999999), (0.8, 0.7829787234042553, 0.3999999999999999), (0.8, 0.7957446808510635, 0.3999999999999999), (0.7914893617021277, 0.8, 0.3999999999999999), (0.7787234042553195, 0.8, 0.3999999999999999), (0.7659574468085105, 0.8, 0.3999999999999999), (0.7531914893617022, 0.8, 0.3999999999999999), (0.7404255319148938, 0.8, 0.3999999999999999), (0.7276595744680849, 0.8, 0.3999999999999999), (0.7148936170212767, 0.8, 0.3999999999999999), (0.7021276595744683, 0.8, 0.3999999999999999), (0.6893617021276595, 0.8, 0.3999999999999999), (0.6765957446808512, 0.8, 0.3999999999999999), (0.6638297872340428, 0.8, 0.3999999999999999), (0.651063829787234, 0.8, 0.3999999999999999), (0.6382978723404256, 0.8, 0.3999999999999999), (0.6255319148936173, 0.8, 0.3999999999999999), (0.6127659574468084, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5872340425531917, 0.8, 0.3999999999999999), (0.5744680851063828, 0.8, 0.3999999999999999), (0.5617021276595745, 0.8, 0.3999999999999999), (0.5489361702127662, 0.8, 0.3999999999999999), (0.5361702127659573, 0.8, 0.3999999999999999), (0.523404255319149, 0.8, 0.3999999999999999), (0.5106382978723407, 0.8, 0.3999999999999999), (0.4978723404255318, 0.8, 0.3999999999999999), (0.48510638297872344, 0.8, 0.3999999999999999), (0.47234042553191513, 0.8, 0.3999999999999999), (0.45957446808510627, 0.8, 0.3999999999999999), (0.44680851063829796, 0.8, 0.3999999999999999), (0.4340425531914896, 0.8, 0.3999999999999999), (0.42127659574468074, 0.8, 0.3999999999999999), (0.4085106382978724, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4042553191489364), (0.3999999999999999, 0.8, 0.4170212765957447), (0.3999999999999999, 0.8, 0.4297872340425531), (0.3999999999999999, 0.8, 0.44255319148936145), (0.3999999999999999, 0.8, 0.4553191489361703), (0.3999999999999999, 0.8, 0.4680851063829786), (0.3999999999999999, 0.8, 0.4808510638297875), (0.3999999999999999, 0.8, 0.4936170212765958), (0.3999999999999999, 0.8, 0.5063829787234042), (0.3999999999999999, 0.8, 0.5191489361702125), (0.3999999999999999, 0.8, 0.5319148936170214), (0.3999999999999999, 0.8, 0.5446808510638297), (0.3999999999999999, 0.8, 0.5574468085106385), (0.3999999999999999, 0.8, 0.5702127659574469), (0.3999999999999999, 0.8, 0.5829787234042552), (0.3999999999999999, 0.8, 0.5957446808510636), (0.3999999999999999, 0.8, 0.6085106382978724), (0.3999999999999999, 0.8, 0.6212765957446807), (0.3999999999999999, 0.8, 0.6340425531914896), (0.3999999999999999, 0.8, 0.6468085106382979), (0.3999999999999999, 0.8, 0.6595744680851063), (0.3999999999999999, 0.8, 0.6723404255319146), (0.3999999999999999, 0.8, 0.6851063829787235), (0.3999999999999999, 0.8, 0.6978723404255318), (0.3999999999999999, 0.8, 0.7106382978723407), (0.3999999999999999, 0.8, 0.7234042553191491), (0.3999999999999999, 0.8, 0.7361702127659573), (0.3999999999999999, 0.8, 0.7489361702127657), (0.3999999999999999, 0.8, 0.7617021276595746), (0.3999999999999999, 0.8, 0.7744680851063829), (0.3999999999999999, 0.8, 0.7872340425531918), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7872340425531916, 0.8), (0.3999999999999999, 0.7744680851063833, 0.8), (0.3999999999999999, 0.7617021276595743, 0.8), (0.3999999999999999, 0.7489361702127655, 0.8), (0.3999999999999999, 0.7361702127659573, 0.8), (0.3999999999999999, 0.7234042553191489, 0.8), (0.3999999999999999, 0.7106382978723406, 0.8), (0.3999999999999999, 0.6978723404255323, 0.8), (0.3999999999999999, 0.6851063829787234, 0.8), (0.3999999999999999, 0.6723404255319145, 0.8), (0.3999999999999999, 0.6595744680851061, 0.8), (0.3999999999999999, 0.6468085106382978, 0.8), (0.3999999999999999, 0.6340425531914895, 0.8), (0.3999999999999999, 0.6212765957446812, 0.8), (0.3999999999999999, 0.6085106382978723, 0.8), (0.3999999999999999, 0.5957446808510635, 0.8), (0.3999999999999999, 0.5829787234042552, 0.8), (0.3999999999999999, 0.5702127659574467, 0.8), (0.3999999999999999, 0.5574468085106384, 0.8), (0.3999999999999999, 0.5446808510638301, 0.8), (0.3999999999999999, 0.5319148936170213, 0.8), (0.3999999999999999, 0.5191489361702124, 0.8), (0.3999999999999999, 0.506382978723404, 0.8), (0.3999999999999999, 0.4936170212765957, 0.8), (0.3999999999999999, 0.4808510638297874, 0.8), (0.3999999999999999, 0.4680851063829785, 0.8), (0.3999999999999999, 0.45531914893617015, 0.8), (0.3999999999999999, 0.4425531914893613, 0.8), (0.3999999999999999, 0.429787234042553, 0.8), (0.3999999999999999, 0.4170212765957446, 0.8), (0.3999999999999999, 0.4042553191489363, 0.8), (0.40851063829787215, 0.3999999999999999, 0.8), (0.42127659574468046, 0.3999999999999999, 0.8), (0.4340425531914893, 0.3999999999999999, 0.8), (0.4468085106382977, 0.3999999999999999, 0.8), (0.459574468085106, 0.3999999999999999, 0.8), (0.47234042553191435, 0.3999999999999999, 0.8), (0.4851063829787232, 0.3999999999999999, 0.8), (0.4978723404255315, 0.3999999999999999, 0.8), (0.5106382978723404, 0.3999999999999999, 0.8), (0.5234042553191487, 0.3999999999999999, 0.8), (0.5361702127659571, 0.3999999999999999, 0.8), (0.5489361702127654, 0.3999999999999999, 0.8), (0.5617021276595743, 0.3999999999999999, 0.8), (0.5744680851063826, 0.3999999999999999, 0.8), (0.5872340425531914, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6127659574468082, 0.3999999999999999, 0.8), (0.6255319148936165, 0.3999999999999999, 0.8), (0.6382978723404253, 0.3999999999999999, 0.8), (0.6510638297872342, 0.3999999999999999, 0.8), (0.6638297872340426, 0.3999999999999999, 0.8), (0.6765957446808508, 0.3999999999999999, 0.8), (0.6893617021276592, 0.3999999999999999, 0.8), (0.7021276595744675, 0.3999999999999999, 0.8), (0.7148936170212764, 0.3999999999999999, 0.8), (0.7276595744680853, 0.3999999999999999, 0.8), (0.7404255319148936, 0.3999999999999999, 0.8), (0.753191489361702, 0.3999999999999999, 0.8), (0.7659574468085103, 0.3999999999999999, 0.8), (0.7787234042553186, 0.3999999999999999, 0.8), (0.7914893617021275, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7957446808510633), (0.8, 0.3999999999999999, 0.7829787234042549), (0.8, 0.3999999999999999, 0.7702127659574467), (0.8, 0.3999999999999999, 0.7574468085106383), (0.8, 0.3999999999999999, 0.74468085106383), (0.8, 0.3999999999999999, 0.7319148936170211), (0.8, 0.3999999999999999, 0.7191489361702122), (0.8, 0.3999999999999999, 0.7063829787234039), (0.8, 0.3999999999999999, 0.6936170212765955), (0.8, 0.3999999999999999, 0.6808510638297873), (0.8, 0.3999999999999999, 0.6680851063829785), (0.8, 0.3999999999999999, 0.65531914893617), (0.8, 0.3999999999999999, 0.6425531914893612), (0.8, 0.3999999999999999, 0.6297872340425529), (0.8, 0.3999999999999999, 0.6170212765957446), (0.8, 0.3999999999999999, 0.6042553191489362), (0.8, 0.3999999999999999, 0.5914893617021273), (0.8, 0.3999999999999999, 0.578723404255319), (0.8, 0.3999999999999999, 0.5659574468085101), (0.8, 0.3999999999999999, 0.5531914893617018), (0.8, 0.3999999999999999, 0.5404255319148934), (0.8, 0.3999999999999999, 0.5276595744680851), (0.8, 0.3999999999999999, 0.5148936170212762), (0.8, 0.3999999999999999, 0.5021276595744679), (0.8, 0.3999999999999999, 0.48936170212765906), (0.8, 0.3999999999999999, 0.4765957446808507), (0.8, 0.3999999999999999, 0.4638297872340424), (0.8, 0.3999999999999999, 0.451063829787234), (0.8, 0.3999999999999999, 0.43829787234042517), (0.8, 0.3999999999999999, 0.42553191489361686), (0.8, 0.3999999999999999, 0.412765957446808)],
    189: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41269841269841273, 0.3999999999999999), (0.8, 0.42539682539682555, 0.3999999999999999), (0.8, 0.43809523809523787, 0.3999999999999999), (0.8, 0.45079365079365075, 0.3999999999999999), (0.8, 0.46349206349206357, 0.3999999999999999), (0.8, 0.47619047619047583, 0.3999999999999999), (0.8, 0.4888888888888887, 0.3999999999999999), (0.8, 0.5015873015873016, 0.3999999999999999), (0.8, 0.5142857142857143, 0.3999999999999999), (0.8, 0.5269841269841272, 0.3999999999999999), (0.8, 0.5396825396825395, 0.3999999999999999), (0.8, 0.5523809523809523, 0.3999999999999999), (0.8, 0.5650793650793652, 0.3999999999999999), (0.8, 0.5777777777777775, 0.3999999999999999), (0.8, 0.5904761904761903, 0.3999999999999999), (0.8, 0.6031746031746031, 0.3999999999999999), (0.8, 0.615873015873016, 0.3999999999999999), (0.8, 0.6285714285714288, 0.3999999999999999), (0.8, 0.6412698412698411, 0.3999999999999999), (0.8, 0.653968253968254, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6793650793650792, 0.3999999999999999), (0.8, 0.6920634920634919, 0.3999999999999999), (0.8, 0.7047619047619047, 0.3999999999999999), (0.8, 0.7174603174603176, 0.3999999999999999), (0.8, 0.7301587301587305, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7555555555555555, 0.3999999999999999), (0.8, 0.7682539682539684, 0.3999999999999999), (0.8, 0.7809523809523806, 0.3999999999999999), (0.8, 0.7936507936507935, 0.3999999999999999), (0.7936507936507937, 0.8, 0.3999999999999999), (0.7809523809523811, 0.8, 0.3999999999999999), (0.7682539682539682, 0.8, 0.3999999999999999), (0.7555555555555558, 0.8, 0.3999999999999999), (0.742857142857143, 0.8, 0.3999999999999999), (0.7301587301587302, 0.8, 0.3999999999999999), (0.7174603174603178, 0.8, 0.3999999999999999), (0.704761904761905, 0.8, 0.3999999999999999), (0.6920634920634923, 0.8, 0.3999999999999999), (0.6793650793650794, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6539682539682542, 0.8, 0.3999999999999999), (0.6412698412698414, 0.8, 0.3999999999999999), (0.6285714285714286, 0.8, 0.3999999999999999), (0.6158730158730162, 0.8, 0.3999999999999999), (0.6031746031746034, 0.8, 0.3999999999999999), (0.5904761904761906, 0.8, 0.3999999999999999), (0.5777777777777777, 0.8, 0.3999999999999999), (0.5650793650793648, 0.8, 0.3999999999999999), (0.5523809523809526, 0.8, 0.3999999999999999), (0.5396825396825398, 0.8, 0.3999999999999999), (0.5269841269841269, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.5015873015873018, 0.8, 0.3999999999999999), (0.48888888888888893, 0.8, 0.3999999999999999), (0.4761904761904761, 0.8, 0.3999999999999999), (0.4634920634920633, 0.8, 0.3999999999999999), (0.45079365079365097, 0.8, 0.3999999999999999), (0.43809523809523815, 0.8, 0.3999999999999999), (0.42539682539682533, 0.8, 0.3999999999999999), (0.412698412698413, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4126984126984126), (0.3999999999999999, 0.8, 0.42539682539682544), (0.3999999999999999, 0.8, 0.43809523809523826), (0.3999999999999999, 0.8, 0.4507936507936506), (0.3999999999999999, 0.8, 0.4634920634920634), (0.3999999999999999, 0.8, 0.4761904761904763), (0.3999999999999999, 0.8, 0.48888888888888854), (0.3999999999999999, 0.8, 0.5015873015873014), (0.3999999999999999, 0.8, 0.5142857142857142), (0.3999999999999999, 0.8, 0.5269841269841271), (0.3999999999999999, 0.8, 0.5396825396825399), (0.3999999999999999, 0.8, 0.5523809523809522), (0.3999999999999999, 0.8, 0.5650793650793651), (0.3999999999999999, 0.8, 0.5777777777777778), (0.3999999999999999, 0.8, 0.5904761904761902), (0.3999999999999999, 0.8, 0.603174603174603), (0.3999999999999999, 0.8, 0.6158730158730159), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6412698412698415), (0.3999999999999999, 0.8, 0.6539682539682539), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6793650793650795), (0.3999999999999999, 0.8, 0.6920634920634918), (0.3999999999999999, 0.8, 0.7047619047619047), (0.3999999999999999, 0.8, 0.7174603174603175), (0.3999999999999999, 0.8, 0.7301587301587302), (0.3999999999999999, 0.8, 0.7428571428571431), (0.3999999999999999, 0.8, 0.7555555555555554), (0.3999999999999999, 0.8, 0.7682539682539683), (0.3999999999999999, 0.8, 0.7809523809523811), (0.3999999999999999, 0.8, 0.7936507936507935), (0.3999999999999999, 0.7936507936507937, 0.8), (0.3999999999999999, 0.7809523809523811, 0.8), (0.3999999999999999, 0.7682539682539682, 0.8), (0.3999999999999999, 0.7555555555555553, 0.8), (0.3999999999999999, 0.742857142857143, 0.8), (0.3999999999999999, 0.7301587301587302, 0.8), (0.3999999999999999, 0.7174603174603174, 0.8), (0.3999999999999999, 0.704761904761905, 0.8), (0.3999999999999999, 0.6920634920634923, 0.8), (0.3999999999999999, 0.6793650793650794, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6539682539682536, 0.8), (0.3999999999999999, 0.6412698412698414, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6158730158730157, 0.8), (0.3999999999999999, 0.6031746031746034, 0.8), (0.3999999999999999, 0.5904761904761906, 0.8), (0.3999999999999999, 0.5777777777777777, 0.8), (0.3999999999999999, 0.5650793650793648, 0.8), (0.3999999999999999, 0.5523809523809521, 0.8), (0.3999999999999999, 0.5396825396825398, 0.8), (0.3999999999999999, 0.5269841269841269, 0.8), (0.3999999999999999, 0.5142857142857141, 0.8), (0.3999999999999999, 0.5015873015873018, 0.8), (0.3999999999999999, 0.48888888888888893, 0.8), (0.3999999999999999, 0.4761904761904761, 0.8), (0.3999999999999999, 0.4634920634920633, 0.8), (0.3999999999999999, 0.45079365079365047, 0.8), (0.3999999999999999, 0.43809523809523815, 0.8), (0.3999999999999999, 0.42539682539682533, 0.8), (0.3999999999999999, 0.41269841269841245, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41269841269841223, 0.3999999999999999, 0.8), (0.42539682539682505, 0.3999999999999999, 0.8), (0.43809523809523787, 0.3999999999999999, 0.8), (0.45079365079365075, 0.3999999999999999, 0.8), (0.463492063492063, 0.3999999999999999, 0.8), (0.47619047619047583, 0.3999999999999999, 0.8), (0.4888888888888887, 0.3999999999999999, 0.8), (0.501587301587301, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5269841269841267, 0.3999999999999999, 0.8), (0.5396825396825395, 0.3999999999999999, 0.8), (0.5523809523809523, 0.3999999999999999, 0.8), (0.5650793650793646, 0.3999999999999999, 0.8), (0.5777777777777775, 0.3999999999999999, 0.8), (0.5904761904761903, 0.3999999999999999, 0.8), (0.6031746031746026, 0.3999999999999999, 0.8), (0.6158730158730155, 0.3999999999999999, 0.8), (0.6285714285714283, 0.3999999999999999, 0.8), (0.6412698412698411, 0.3999999999999999, 0.8), (0.653968253968254, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6793650793650792, 0.3999999999999999, 0.8), (0.6920634920634919, 0.3999999999999999, 0.8), (0.7047619047619043, 0.3999999999999999, 0.8), (0.7174603174603171, 0.3999999999999999, 0.8), (0.7301587301587299, 0.3999999999999999, 0.8), (0.7428571428571427, 0.3999999999999999, 0.8), (0.7555555555555555, 0.3999999999999999, 0.8), (0.7682539682539679, 0.3999999999999999, 0.8), (0.7809523809523806, 0.3999999999999999, 0.8), (0.7936507936507935, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7936507936507937), (0.8, 0.3999999999999999, 0.7809523809523811), (0.8, 0.3999999999999999, 0.7682539682539682), (0.8, 0.3999999999999999, 0.7555555555555553), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7301587301587302), (0.8, 0.3999999999999999, 0.7174603174603174), (0.8, 0.3999999999999999, 0.7047619047619045), (0.8, 0.3999999999999999, 0.6920634920634923), (0.8, 0.3999999999999999, 0.6793650793650794), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6539682539682536), (0.8, 0.3999999999999999, 0.6412698412698409), (0.8, 0.3999999999999999, 0.6285714285714286), (0.8, 0.3999999999999999, 0.6158730158730157), (0.8, 0.3999999999999999, 0.6031746031746029), (0.8, 0.3999999999999999, 0.5904761904761906), (0.8, 0.3999999999999999, 0.5777777777777777), (0.8, 0.3999999999999999, 0.5650793650793648), (0.8, 0.3999999999999999, 0.5523809523809521), (0.8, 0.3999999999999999, 0.5396825396825392), (0.8, 0.3999999999999999, 0.5269841269841269), (0.8, 0.3999999999999999, 0.5142857142857141), (0.8, 0.3999999999999999, 0.5015873015873012), (0.8, 0.3999999999999999, 0.48888888888888893), (0.8, 0.3999999999999999, 0.4761904761904761), (0.8, 0.3999999999999999, 0.4634920634920633), (0.8, 0.3999999999999999, 0.45079365079365047), (0.8, 0.3999999999999999, 0.4380952380952376), (0.8, 0.3999999999999999, 0.42539682539682533), (0.8, 0.3999999999999999, 0.41269841269841245)],
    190: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41263157894736835, 0.3999999999999999), (0.8, 0.42526315789473684, 0.3999999999999999), (0.8, 0.4378947368421053, 0.3999999999999999), (0.8, 0.4505263157894738, 0.3999999999999999), (0.8, 0.4631578947368422, 0.3999999999999999), (0.8, 0.4757894736842107, 0.3999999999999999), (0.8, 0.48842105263157864, 0.3999999999999999), (0.8, 0.5010526315789471, 0.3999999999999999), (0.8, 0.5136842105263155, 0.3999999999999999), (0.8, 0.5263157894736841, 0.3999999999999999), (0.8, 0.5389473684210525, 0.3999999999999999), (0.8, 0.551578947368421, 0.3999999999999999), (0.8, 0.5642105263157894, 0.3999999999999999), (0.8, 0.5768421052631578, 0.3999999999999999), (0.8, 0.5894736842105264, 0.3999999999999999), (0.8, 0.6021052631578948, 0.3999999999999999), (0.8, 0.6147368421052632, 0.3999999999999999), (0.8, 0.6273684210526318, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6526315789473681, 0.3999999999999999), (0.8, 0.6652631578947366, 0.3999999999999999), (0.8, 0.6778947368421051, 0.3999999999999999), (0.8, 0.6905263157894735, 0.3999999999999999), (0.8, 0.703157894736842, 0.3999999999999999), (0.8, 0.7157894736842105, 0.3999999999999999), (0.8, 0.7284210526315789, 0.3999999999999999), (0.8, 0.7410526315789474, 0.3999999999999999), (0.8, 0.7536842105263158, 0.3999999999999999), (0.8, 0.7663157894736843, 0.3999999999999999), (0.8, 0.7789473684210528, 0.3999999999999999), (0.8, 0.7915789473684212, 0.3999999999999999), (0.7957894736842104, 0.8, 0.3999999999999999), (0.7831578947368425, 0.8, 0.3999999999999999), (0.7705263157894735, 0.8, 0.3999999999999999), (0.7578947368421056, 0.8, 0.3999999999999999), (0.7452631578947371, 0.8, 0.3999999999999999), (0.7326315789473687, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7073684210526318, 0.8, 0.3999999999999999), (0.6947368421052633, 0.8, 0.3999999999999999), (0.6821052631578948, 0.8, 0.3999999999999999), (0.6694736842105264, 0.8, 0.3999999999999999), (0.6568421052631579, 0.8, 0.3999999999999999), (0.6442105263157895, 0.8, 0.3999999999999999), (0.631578947368421, 0.8, 0.3999999999999999), (0.6189473684210525, 0.8, 0.3999999999999999), (0.606315789473684, 0.8, 0.3999999999999999), (0.5936842105263161, 0.8, 0.3999999999999999), (0.5810526315789476, 0.8, 0.3999999999999999), (0.5684210526315792, 0.8, 0.3999999999999999), (0.5557894736842107, 0.8, 0.3999999999999999), (0.5431578947368423, 0.8, 0.3999999999999999), (0.5305263157894737, 0.8, 0.3999999999999999), (0.5178947368421053, 0.8, 0.3999999999999999), (0.5052631578947369, 0.8, 0.3999999999999999), (0.4926315789473684, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.46736842105263143, 0.8, 0.3999999999999999), (0.45473684210526355, 0.8, 0.3999999999999999), (0.4421052631578945, 0.8, 0.3999999999999999), (0.42947368421052656, 0.8, 0.3999999999999999), (0.41684210526315757, 0.8, 0.3999999999999999), (0.4042105263157897, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40842105263157874), (0.3999999999999999, 0.8, 0.42105263157894723), (0.3999999999999999, 0.8, 0.43368421052631567), (0.3999999999999999, 0.8, 0.44631578947368417), (0.3999999999999999, 0.8, 0.4589473684210526), (0.3999999999999999, 0.8, 0.4715789473684211), (0.3999999999999999, 0.8, 0.48421052631578954), (0.3999999999999999, 0.8, 0.49684210526315803), (0.3999999999999999, 0.8, 0.5094736842105265), (0.3999999999999999, 0.8, 0.522105263157895), (0.3999999999999999, 0.8, 0.5347368421052628), (0.3999999999999999, 0.8, 0.5473684210526318), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5726315789473683), (0.3999999999999999, 0.8, 0.5852631578947367), (0.3999999999999999, 0.8, 0.5978947368421051), (0.3999999999999999, 0.8, 0.6105263157894737), (0.3999999999999999, 0.8, 0.6231578947368421), (0.3999999999999999, 0.8, 0.6357894736842106), (0.3999999999999999, 0.8, 0.648421052631579), (0.3999999999999999, 0.8, 0.6610526315789476), (0.3999999999999999, 0.8, 0.673684210526316), (0.3999999999999999, 0.8, 0.6863157894736844), (0.3999999999999999, 0.8, 0.6989473684210523), (0.3999999999999999, 0.8, 0.7115789473684213), (0.3999999999999999, 0.8, 0.7242105263157893), (0.3999999999999999, 0.8, 0.7368421052631577), (0.3999999999999999, 0.8, 0.7494736842105263), (0.3999999999999999, 0.8, 0.7621052631578946), (0.3999999999999999, 0.8, 0.7747368421052632), (0.3999999999999999, 0.8, 0.7873684210526317), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7873684210526315, 0.8), (0.3999999999999999, 0.7747368421052631, 0.8), (0.3999999999999999, 0.7621052631578951, 0.8), (0.3999999999999999, 0.7494736842105261, 0.8), (0.3999999999999999, 0.7368421052631582, 0.8), (0.3999999999999999, 0.7242105263157892, 0.8), (0.3999999999999999, 0.7115789473684213, 0.8), (0.3999999999999999, 0.6989473684210523, 0.8), (0.3999999999999999, 0.6863157894736843, 0.8), (0.3999999999999999, 0.6736842105263159, 0.8), (0.3999999999999999, 0.6610526315789473, 0.8), (0.3999999999999999, 0.6484210526315789, 0.8), (0.3999999999999999, 0.6357894736842105, 0.8), (0.3999999999999999, 0.623157894736842, 0.8), (0.3999999999999999, 0.6105263157894735, 0.8), (0.3999999999999999, 0.597894736842105, 0.8), (0.3999999999999999, 0.5852631578947366, 0.8), (0.3999999999999999, 0.5726315789473686, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5473684210526317, 0.8), (0.3999999999999999, 0.5347368421052627, 0.8), (0.3999999999999999, 0.5221052631578948, 0.8), (0.3999999999999999, 0.5094736842105263, 0.8), (0.3999999999999999, 0.49684210526315786, 0.8), (0.3999999999999999, 0.4842105263157894, 0.8), (0.3999999999999999, 0.47157894736842093, 0.8), (0.3999999999999999, 0.4589473684210525, 0.8), (0.3999999999999999, 0.446315789473684, 0.8), (0.3999999999999999, 0.43368421052631556, 0.8), (0.3999999999999999, 0.42105263157894707, 0.8), (0.3999999999999999, 0.40842105263157913, 0.8), (0.4042105263157894, 0.3999999999999999, 0.8), (0.41684210526315735, 0.3999999999999999, 0.8), (0.42947368421052634, 0.3999999999999999, 0.8), (0.4421052631578943, 0.3999999999999999, 0.8), (0.4547368421052633, 0.3999999999999999, 0.8), (0.4673684210526312, 0.3999999999999999, 0.8), (0.47999999999999965, 0.3999999999999999, 0.8), (0.4926315789473681, 0.3999999999999999, 0.8), (0.5052631578947366, 0.3999999999999999, 0.8), (0.5178947368421051, 0.3999999999999999, 0.8), (0.5305263157894735, 0.3999999999999999, 0.8), (0.543157894736842, 0.3999999999999999, 0.8), (0.55578947368421, 0.3999999999999999, 0.8), (0.5684210526315789, 0.3999999999999999, 0.8), (0.5810526315789468, 0.3999999999999999, 0.8), (0.5936842105263158, 0.3999999999999999, 0.8), (0.6063157894736838, 0.3999999999999999, 0.8), (0.6189473684210528, 0.3999999999999999, 0.8), (0.6315789473684207, 0.3999999999999999, 0.8), (0.6442105263157891, 0.3999999999999999, 0.8), (0.6568421052631577, 0.3999999999999999, 0.8), (0.6694736842105261, 0.3999999999999999, 0.8), (0.6821052631578945, 0.3999999999999999, 0.8), (0.6947368421052631, 0.3999999999999999, 0.8), (0.7073684210526314, 0.3999999999999999, 0.8), (0.7199999999999994, 0.3999999999999999, 0.8), (0.7326315789473684, 0.3999999999999999, 0.8), (0.7452631578947364, 0.3999999999999999, 0.8), (0.7578947368421054, 0.3999999999999999, 0.8), (0.7705263157894733, 0.3999999999999999, 0.8), (0.7831578947368423, 0.3999999999999999, 0.8), (0.7957894736842102, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7915789473684209), (0.8, 0.3999999999999999, 0.7789473684210526), (0.8, 0.3999999999999999, 0.7663157894736841), (0.8, 0.3999999999999999, 0.7536842105263155), (0.8, 0.3999999999999999, 0.7410526315789472), (0.8, 0.3999999999999999, 0.7284210526315786), (0.8, 0.3999999999999999, 0.7157894736842102), (0.8, 0.3999999999999999, 0.7031578947368418), (0.8, 0.3999999999999999, 0.6905263157894739), (0.8, 0.3999999999999999, 0.6778947368421049), (0.8, 0.3999999999999999, 0.6652631578947369), (0.8, 0.3999999999999999, 0.6526315789473679), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6273684210526315), (0.8, 0.3999999999999999, 0.614736842105263), (0.8, 0.3999999999999999, 0.6021052631578946), (0.8, 0.3999999999999999, 0.589473684210526), (0.8, 0.3999999999999999, 0.5768421052631576), (0.8, 0.3999999999999999, 0.5642105263157892), (0.8, 0.3999999999999999, 0.5515789473684207), (0.8, 0.3999999999999999, 0.5389473684210522), (0.8, 0.3999999999999999, 0.5263157894736843), (0.8, 0.3999999999999999, 0.5136842105263153), (0.8, 0.3999999999999999, 0.5010526315789474), (0.8, 0.3999999999999999, 0.48842105263157837), (0.8, 0.3999999999999999, 0.47578947368421043), (0.8, 0.3999999999999999, 0.46315789473684144), (0.8, 0.3999999999999999, 0.4505263157894735), (0.8, 0.3999999999999999, 0.43789473684210506), (0.8, 0.3999999999999999, 0.42526315789473657), (0.8, 0.3999999999999999, 0.4126315789473681)],
    191: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4125654450261778, 0.3999999999999999), (0.8, 0.4251308900523557, 0.3999999999999999), (0.8, 0.4376963350785341, 0.3999999999999999), (0.8, 0.450261780104712, 0.3999999999999999), (0.8, 0.4628272251308899, 0.3999999999999999), (0.8, 0.4753926701570678, 0.3999999999999999), (0.8, 0.4879581151832462, 0.3999999999999999), (0.8, 0.5005235602094241, 0.3999999999999999), (0.8, 0.5130890052356021, 0.3999999999999999), (0.8, 0.5256544502617799, 0.3999999999999999), (0.8, 0.5382198952879583, 0.3999999999999999), (0.8, 0.5507853403141363, 0.3999999999999999), (0.8, 0.5633507853403141, 0.3999999999999999), (0.8, 0.575916230366492, 0.3999999999999999), (0.8, 0.5884816753926699, 0.3999999999999999), (0.8, 0.6010471204188483, 0.3999999999999999), (0.8, 0.6136125654450263, 0.3999999999999999), (0.8, 0.6261780104712041, 0.3999999999999999), (0.8, 0.6387434554973821, 0.3999999999999999), (0.8, 0.6513089005235599, 0.3999999999999999), (0.8, 0.6638743455497385, 0.3999999999999999), (0.8, 0.6764397905759163, 0.3999999999999999), (0.8, 0.6890052356020941, 0.3999999999999999), (0.8, 0.7015706806282727, 0.3999999999999999), (0.8, 0.7141361256544505, 0.3999999999999999), (0.8, 0.7267015706806284, 0.3999999999999999), (0.8, 0.7392670157068062, 0.3999999999999999), (0.8, 0.7518324607329842, 0.3999999999999999), (0.8, 0.7643979057591626, 0.3999999999999999), (0.8, 0.7769633507853404, 0.3999999999999999), (0.8, 0.7895287958115185, 0.3999999999999999), (0.797905759162304, 0.8, 0.3999999999999999), (0.7853403141361259, 0.8, 0.3999999999999999), (0.7727748691099476, 0.8, 0.3999999999999999), (0.7602094240837697, 0.8, 0.3999999999999999), (0.7476439790575917, 0.8, 0.3999999999999999), (0.7350785340314139, 0.8, 0.3999999999999999), (0.7225130890052355, 0.8, 0.3999999999999999), (0.7099476439790575, 0.8, 0.3999999999999999), (0.6973821989528797, 0.8, 0.3999999999999999), (0.6848167539267018, 0.8, 0.3999999999999999), (0.6722513089005233, 0.8, 0.3999999999999999), (0.6596858638743455, 0.8, 0.3999999999999999), (0.6471204188481676, 0.8, 0.3999999999999999), (0.6345549738219897, 0.8, 0.3999999999999999), (0.6219895287958118, 0.8, 0.3999999999999999), (0.6094240837696333, 0.8, 0.3999999999999999), (0.5968586387434555, 0.8, 0.3999999999999999), (0.5842931937172775, 0.8, 0.3999999999999999), (0.5717277486910997, 0.8, 0.3999999999999999), (0.5591623036649218, 0.8, 0.3999999999999999), (0.5465968586387433, 0.8, 0.3999999999999999), (0.5340314136125655, 0.8, 0.3999999999999999), (0.5214659685863876, 0.8, 0.3999999999999999), (0.5089005235602091, 0.8, 0.3999999999999999), (0.49633507853403125, 0.8, 0.3999999999999999), (0.48376963350785335, 0.8, 0.3999999999999999), (0.47120418848167545, 0.8, 0.3999999999999999), (0.45863874345549754, 0.8, 0.3999999999999999), (0.44607329842931914, 0.8, 0.3999999999999999), (0.43350785340314124, 0.8, 0.3999999999999999), (0.42094240837696334, 0.8, 0.3999999999999999), (0.40837696335078544, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4041884816753924), (0.3999999999999999, 0.8, 0.41675392670157085), (0.3999999999999999, 0.8, 0.4293193717277487), (0.3999999999999999, 0.8, 0.4418848167539266), (0.3999999999999999, 0.8, 0.45445026178010506), (0.3999999999999999, 0.8, 0.46701570680628296), (0.3999999999999999, 0.8, 0.47958115183246086), (0.3999999999999999, 0.8, 0.4921465968586387), (0.3999999999999999, 0.8, 0.5047120418848167), (0.3999999999999999, 0.8, 0.5172774869109951), (0.3999999999999999, 0.8, 0.5298429319371729), (0.3999999999999999, 0.8, 0.5424083769633509), (0.3999999999999999, 0.8, 0.5549738219895287), (0.3999999999999999, 0.8, 0.5675392670157067), (0.3999999999999999, 0.8, 0.5801047120418851), (0.3999999999999999, 0.8, 0.5926701570680629), (0.3999999999999999, 0.8, 0.6052356020942409), (0.3999999999999999, 0.8, 0.6178010471204187), (0.3999999999999999, 0.8, 0.6303664921465967), (0.3999999999999999, 0.8, 0.6429319371727751), (0.3999999999999999, 0.8, 0.6554973821989529), (0.3999999999999999, 0.8, 0.6680628272251309), (0.3999999999999999, 0.8, 0.6806282722513093), (0.3999999999999999, 0.8, 0.6931937172774871), (0.3999999999999999, 0.8, 0.7057591623036651), (0.3999999999999999, 0.8, 0.718324607329843), (0.3999999999999999, 0.8, 0.7308900523560209), (0.3999999999999999, 0.8, 0.7434554973821993), (0.3999999999999999, 0.8, 0.7560209424083773), (0.3999999999999999, 0.8, 0.7685863874345551), (0.3999999999999999, 0.8, 0.7811518324607329), (0.3999999999999999, 0.8, 0.7937172774869108), (0.3999999999999999, 0.7937172774869108, 0.8), (0.3999999999999999, 0.7811518324607329, 0.8), (0.3999999999999999, 0.768586387434555, 0.8), (0.3999999999999999, 0.7560209424083766, 0.8), (0.3999999999999999, 0.7434554973821992, 0.8), (0.3999999999999999, 0.7308900523560207, 0.8), (0.3999999999999999, 0.7183246073298428, 0.8), (0.3999999999999999, 0.705759162303665, 0.8), (0.3999999999999999, 0.6931937172774865, 0.8), (0.3999999999999999, 0.6806282722513086, 0.8), (0.3999999999999999, 0.6680628272251308, 0.8), (0.3999999999999999, 0.6554973821989528, 0.8), (0.3999999999999999, 0.642931937172775, 0.8), (0.3999999999999999, 0.6303664921465966, 0.8), (0.3999999999999999, 0.6178010471204186, 0.8), (0.3999999999999999, 0.6052356020942408, 0.8), (0.3999999999999999, 0.5926701570680623, 0.8), (0.3999999999999999, 0.580104712041885, 0.8), (0.3999999999999999, 0.5675392670157065, 0.8), (0.3999999999999999, 0.5549738219895286, 0.8), (0.3999999999999999, 0.5424083769633508, 0.8), (0.3999999999999999, 0.5298429319371722, 0.8), (0.3999999999999999, 0.517277486910995, 0.8), (0.3999999999999999, 0.5047120418848166, 0.8), (0.3999999999999999, 0.4921465968586386, 0.8), (0.3999999999999999, 0.4795811518324607, 0.8), (0.3999999999999999, 0.4670157068062823, 0.8), (0.3999999999999999, 0.4544502617801044, 0.8), (0.3999999999999999, 0.4418848167539265, 0.8), (0.3999999999999999, 0.42931937172774803, 0.8), (0.3999999999999999, 0.4167539267015707, 0.8), (0.3999999999999999, 0.4041884816753923, 0.8), (0.40837696335078516, 0.3999999999999999, 0.8), (0.42094240837696306, 0.3999999999999999, 0.8), (0.4335078534031415, 0.3999999999999999, 0.8), (0.44607329842931887, 0.3999999999999999, 0.8), (0.45863874345549727, 0.3999999999999999, 0.8), (0.47120418848167517, 0.3999999999999999, 0.8), (0.48376963350785307, 0.3999999999999999, 0.8), (0.4963350785340315, 0.3999999999999999, 0.8), (0.5089005235602094, 0.3999999999999999, 0.8), (0.5214659685863873, 0.3999999999999999, 0.8), (0.5340314136125657, 0.3999999999999999, 0.8), (0.5465968586387431, 0.3999999999999999, 0.8), (0.5591623036649215, 0.3999999999999999, 0.8), (0.5717277486910994, 0.3999999999999999, 0.8), (0.5842931937172773, 0.3999999999999999, 0.8), (0.5968586387434557, 0.3999999999999999, 0.8), (0.6094240837696331, 0.3999999999999999, 0.8), (0.6219895287958115, 0.3999999999999999, 0.8), (0.6345549738219894, 0.3999999999999999, 0.8), (0.6471204188481673, 0.3999999999999999, 0.8), (0.6596858638743457, 0.3999999999999999, 0.8), (0.6722513089005236, 0.3999999999999999, 0.8), (0.6848167539267016, 0.3999999999999999, 0.8), (0.6973821989528795, 0.3999999999999999, 0.8), (0.7099476439790573, 0.3999999999999999, 0.8), (0.7225130890052358, 0.3999999999999999, 0.8), (0.7350785340314137, 0.3999999999999999, 0.8), (0.7476439790575915, 0.3999999999999999, 0.8), (0.76020942408377, 0.3999999999999999, 0.8), (0.7727748691099473, 0.3999999999999999, 0.8), (0.7853403141361257, 0.3999999999999999, 0.8), (0.7979057591623036, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.789528795811518), (0.8, 0.3999999999999999, 0.7769633507853397), (0.8, 0.3999999999999999, 0.7643979057591623), (0.8, 0.3999999999999999, 0.7518324607329838), (0.8, 0.3999999999999999, 0.739267015706806), (0.8, 0.3999999999999999, 0.7267015706806281), (0.8, 0.3999999999999999, 0.7141361256544496), (0.8, 0.3999999999999999, 0.7015706806282718), (0.8, 0.3999999999999999, 0.6890052356020939), (0.8, 0.3999999999999999, 0.6764397905759154), (0.8, 0.3999999999999999, 0.6638743455497381), (0.8, 0.3999999999999999, 0.6513089005235597), (0.8, 0.3999999999999999, 0.6387434554973818), (0.8, 0.3999999999999999, 0.6261780104712039), (0.8, 0.3999999999999999, 0.6136125654450255), (0.8, 0.3999999999999999, 0.6010471204188481), (0.8, 0.3999999999999999, 0.5884816753926697), (0.8, 0.3999999999999999, 0.5759162303664918), (0.8, 0.3999999999999999, 0.5633507853403139), (0.8, 0.3999999999999999, 0.5507853403141354), (0.8, 0.3999999999999999, 0.5382198952879576), (0.8, 0.3999999999999999, 0.5256544502617797), (0.8, 0.3999999999999999, 0.5130890052356017), (0.8, 0.3999999999999999, 0.5005235602094239), (0.8, 0.3999999999999999, 0.48795811518324544), (0.8, 0.3999999999999999, 0.47539267015706754), (0.8, 0.3999999999999999, 0.46282722513088964), (0.8, 0.3999999999999999, 0.45026178010471124), (0.8, 0.3999999999999999, 0.43769633507853384), (0.8, 0.3999999999999999, 0.42513089005235544), (0.8, 0.3999999999999999, 0.41256544502617754)],
    192: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41249999999999976, 0.3999999999999999), (0.8, 0.4250000000000001, 0.3999999999999999), (0.8, 0.43749999999999994, 0.3999999999999999), (0.8, 0.44999999999999973, 0.3999999999999999), (0.8, 0.46250000000000013, 0.3999999999999999), (0.8, 0.4749999999999999, 0.3999999999999999), (0.8, 0.48749999999999977, 0.3999999999999999), (0.8, 0.5000000000000001, 0.3999999999999999), (0.8, 0.5125, 0.3999999999999999), (0.8, 0.5249999999999998, 0.3999999999999999), (0.8, 0.5375000000000001, 0.3999999999999999), (0.8, 0.5499999999999999, 0.3999999999999999), (0.8, 0.5624999999999998, 0.3999999999999999), (0.8, 0.5750000000000002, 0.3999999999999999), (0.8, 0.5875, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6125000000000002, 0.3999999999999999), (0.8, 0.625, 0.3999999999999999), (0.8, 0.6374999999999998, 0.3999999999999999), (0.8, 0.6500000000000001, 0.3999999999999999), (0.8, 0.6625, 0.3999999999999999), (0.8, 0.6749999999999998, 0.3999999999999999), (0.8, 0.6875000000000002, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7124999999999999, 0.3999999999999999), (0.8, 0.7250000000000002, 0.3999999999999999), (0.8, 0.7375, 0.3999999999999999), (0.8, 0.7499999999999998, 0.3999999999999999), (0.8, 0.7625000000000002, 0.3999999999999999), (0.8, 0.7750000000000001, 0.3999999999999999), (0.8, 0.7874999999999999, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7875000000000001, 0.8, 0.3999999999999999), (0.7750000000000004, 0.8, 0.3999999999999999), (0.7625, 0.8, 0.3999999999999999), (0.7500000000000001, 0.8, 0.3999999999999999), (0.7375000000000003, 0.8, 0.3999999999999999), (0.7249999999999999, 0.8, 0.3999999999999999), (0.7125000000000001, 0.8, 0.3999999999999999), (0.7000000000000003, 0.8, 0.3999999999999999), (0.6875, 0.8, 0.3999999999999999), (0.675, 0.8, 0.3999999999999999), (0.6625000000000003, 0.8, 0.3999999999999999), (0.6499999999999999, 0.8, 0.3999999999999999), (0.6375000000000001, 0.8, 0.3999999999999999), (0.6250000000000002, 0.8, 0.3999999999999999), (0.6124999999999999, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5875000000000002, 0.8, 0.3999999999999999), (0.5750000000000004, 0.8, 0.3999999999999999), (0.5625, 0.8, 0.3999999999999999), (0.5500000000000003, 0.8, 0.3999999999999999), (0.5375000000000004, 0.8, 0.3999999999999999), (0.525, 0.8, 0.3999999999999999), (0.5125000000000002, 0.8, 0.3999999999999999), (0.5000000000000004, 0.8, 0.3999999999999999), (0.48750000000000004, 0.8, 0.3999999999999999), (0.4750000000000002, 0.8, 0.3999999999999999), (0.46250000000000036, 0.8, 0.3999999999999999), (0.45, 0.8, 0.3999999999999999), (0.43750000000000017, 0.8, 0.3999999999999999), (0.4250000000000004, 0.8, 0.3999999999999999), (0.4125, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4124999999999996), (0.3999999999999999, 0.8, 0.42499999999999993), (0.3999999999999999, 0.8, 0.4374999999999998), (0.3999999999999999, 0.8, 0.4499999999999996), (0.3999999999999999, 0.8, 0.46249999999999997), (0.3999999999999999, 0.8, 0.4749999999999998), (0.3999999999999999, 0.8, 0.4874999999999996), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5124999999999998), (0.3999999999999999, 0.8, 0.5249999999999997), (0.3999999999999999, 0.8, 0.5375), (0.3999999999999999, 0.8, 0.5499999999999998), (0.3999999999999999, 0.8, 0.5624999999999997), (0.3999999999999999, 0.8, 0.575), (0.3999999999999999, 0.8, 0.5874999999999999), (0.3999999999999999, 0.8, 0.5999999999999996), (0.3999999999999999, 0.8, 0.6125), (0.3999999999999999, 0.8, 0.6249999999999999), (0.3999999999999999, 0.8, 0.6374999999999997), (0.3999999999999999, 0.8, 0.65), (0.3999999999999999, 0.8, 0.6624999999999999), (0.3999999999999999, 0.8, 0.6749999999999997), (0.3999999999999999, 0.8, 0.6875), (0.3999999999999999, 0.8, 0.7), (0.3999999999999999, 0.8, 0.7124999999999997), (0.3999999999999999, 0.8, 0.7250000000000001), (0.3999999999999999, 0.8, 0.7374999999999998), (0.3999999999999999, 0.8, 0.7499999999999998), (0.3999999999999999, 0.8, 0.7625000000000001), (0.3999999999999999, 0.8, 0.7749999999999999), (0.3999999999999999, 0.8, 0.7874999999999996), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7875000000000001, 0.8), (0.3999999999999999, 0.7750000000000004, 0.8), (0.3999999999999999, 0.7625, 0.8), (0.3999999999999999, 0.7500000000000001, 0.8), (0.3999999999999999, 0.7375000000000003, 0.8), (0.3999999999999999, 0.7249999999999999, 0.8), (0.3999999999999999, 0.7125000000000001, 0.8), (0.3999999999999999, 0.7000000000000003, 0.8), (0.3999999999999999, 0.6875, 0.8), (0.3999999999999999, 0.675, 0.8), (0.3999999999999999, 0.6625000000000003, 0.8), (0.3999999999999999, 0.6499999999999999, 0.8), (0.3999999999999999, 0.6375000000000001, 0.8), (0.3999999999999999, 0.6250000000000002, 0.8), (0.3999999999999999, 0.6124999999999999, 0.8), (0.3999999999999999, 0.6000000000000001, 0.8), (0.3999999999999999, 0.5875000000000002, 0.8), (0.3999999999999999, 0.5749999999999998, 0.8), (0.3999999999999999, 0.5625, 0.8), (0.3999999999999999, 0.5500000000000003, 0.8), (0.3999999999999999, 0.5374999999999999, 0.8), (0.3999999999999999, 0.525, 0.8), (0.3999999999999999, 0.5125000000000002, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.48750000000000004, 0.8), (0.3999999999999999, 0.4750000000000002, 0.8), (0.3999999999999999, 0.46249999999999986, 0.8), (0.3999999999999999, 0.45, 0.8), (0.3999999999999999, 0.43750000000000017, 0.8), (0.3999999999999999, 0.4249999999999998, 0.8), (0.3999999999999999, 0.4125, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41249999999999976, 0.3999999999999999, 0.8), (0.42499999999999954, 0.3999999999999999, 0.8), (0.4374999999999994, 0.3999999999999999, 0.8), (0.44999999999999973, 0.3999999999999999, 0.8), (0.4624999999999996, 0.3999999999999999, 0.8), (0.4749999999999994, 0.3999999999999999, 0.8), (0.48749999999999977, 0.3999999999999999, 0.8), (0.4999999999999996, 0.3999999999999999, 0.8), (0.5124999999999994, 0.3999999999999999, 0.8), (0.5249999999999998, 0.3999999999999999, 0.8), (0.5374999999999996, 0.3999999999999999, 0.8), (0.5499999999999994, 0.3999999999999999, 0.8), (0.5624999999999998, 0.3999999999999999, 0.8), (0.5749999999999996, 0.3999999999999999, 0.8), (0.5874999999999995, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6124999999999996, 0.3999999999999999, 0.8), (0.6249999999999994, 0.3999999999999999, 0.8), (0.6374999999999998, 0.3999999999999999, 0.8), (0.6499999999999997, 0.3999999999999999, 0.8), (0.6624999999999994, 0.3999999999999999, 0.8), (0.6749999999999998, 0.3999999999999999, 0.8), (0.6874999999999997, 0.3999999999999999, 0.8), (0.6999999999999995, 0.3999999999999999, 0.8), (0.7124999999999999, 0.3999999999999999, 0.8), (0.7249999999999996, 0.3999999999999999, 0.8), (0.7374999999999995, 0.3999999999999999, 0.8), (0.7499999999999998, 0.3999999999999999, 0.8), (0.7624999999999997, 0.3999999999999999, 0.8), (0.7749999999999995, 0.3999999999999999, 0.8), (0.7874999999999999, 0.3999999999999999, 0.8), (0.7999999999999996, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7875000000000001), (0.8, 0.3999999999999999, 0.7749999999999998), (0.8, 0.3999999999999999, 0.7625), (0.8, 0.3999999999999999, 0.7500000000000001), (0.8, 0.3999999999999999, 0.7374999999999998), (0.8, 0.3999999999999999, 0.7249999999999999), (0.8, 0.3999999999999999, 0.7125000000000001), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.6875), (0.8, 0.3999999999999999, 0.675), (0.8, 0.3999999999999999, 0.6624999999999998), (0.8, 0.3999999999999999, 0.6499999999999999), (0.8, 0.3999999999999999, 0.6375000000000001), (0.8, 0.3999999999999999, 0.6249999999999998), (0.8, 0.3999999999999999, 0.6124999999999999), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5874999999999997), (0.8, 0.3999999999999999, 0.5749999999999998), (0.8, 0.3999999999999999, 0.5625), (0.8, 0.3999999999999999, 0.5499999999999997), (0.8, 0.3999999999999999, 0.5374999999999999), (0.8, 0.3999999999999999, 0.525), (0.8, 0.3999999999999999, 0.5124999999999997), (0.8, 0.3999999999999999, 0.49999999999999983), (0.8, 0.3999999999999999, 0.48750000000000004), (0.8, 0.3999999999999999, 0.47499999999999964), (0.8, 0.3999999999999999, 0.46249999999999986), (0.8, 0.3999999999999999, 0.45), (0.8, 0.3999999999999999, 0.43749999999999967), (0.8, 0.3999999999999999, 0.4249999999999998), (0.8, 0.3999999999999999, 0.4125)],
    193: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4124352331606217, 0.3999999999999999), (0.8, 0.42487046632124353, 0.3999999999999999), (0.8, 0.4373056994818653, 0.3999999999999999), (0.8, 0.44974093264248716, 0.3999999999999999), (0.8, 0.46217616580310894, 0.3999999999999999), (0.8, 0.4746113989637308, 0.3999999999999999), (0.8, 0.48704663212435206, 0.3999999999999999), (0.8, 0.49948186528497385, 0.3999999999999999), (0.8, 0.5119170984455956, 0.3999999999999999), (0.8, 0.5243523316062175, 0.3999999999999999), (0.8, 0.5367875647668393, 0.3999999999999999), (0.8, 0.5492227979274611, 0.3999999999999999), (0.8, 0.5616580310880829, 0.3999999999999999), (0.8, 0.5740932642487047, 0.3999999999999999), (0.8, 0.5865284974093266, 0.3999999999999999), (0.8, 0.5989637305699483, 0.3999999999999999), (0.8, 0.6113989637305701, 0.3999999999999999), (0.8, 0.6238341968911915, 0.3999999999999999), (0.8, 0.6362694300518132, 0.3999999999999999), (0.8, 0.648704663212435, 0.3999999999999999), (0.8, 0.6611398963730568, 0.3999999999999999), (0.8, 0.6735751295336787, 0.3999999999999999), (0.8, 0.6860103626943005, 0.3999999999999999), (0.8, 0.6984455958549223, 0.3999999999999999), (0.8, 0.7108808290155442, 0.3999999999999999), (0.8, 0.7233160621761658, 0.3999999999999999), (0.8, 0.7357512953367877, 0.3999999999999999), (0.8, 0.7481865284974095, 0.3999999999999999), (0.8, 0.7606217616580313, 0.3999999999999999), (0.8, 0.7730569948186532, 0.3999999999999999), (0.8, 0.7854922279792749, 0.3999999999999999), (0.8, 0.7979274611398963, 0.3999999999999999), (0.7896373056994821, 0.8, 0.3999999999999999), (0.7772020725388604, 0.8, 0.3999999999999999), (0.7647668393782385, 0.8, 0.3999999999999999), (0.7523316062176166, 0.8, 0.3999999999999999), (0.739896373056995, 0.8, 0.3999999999999999), (0.7274611398963731, 0.8, 0.3999999999999999), (0.7150259067357513, 0.8, 0.3999999999999999), (0.7025906735751295, 0.8, 0.3999999999999999), (0.6901554404145076, 0.8, 0.3999999999999999), (0.6777202072538864, 0.8, 0.3999999999999999), (0.6652849740932646, 0.8, 0.3999999999999999), (0.6528497409326428, 0.8, 0.3999999999999999), (0.6404145077720209, 0.8, 0.3999999999999999), (0.6279792746113991, 0.8, 0.3999999999999999), (0.6155440414507773, 0.8, 0.3999999999999999), (0.6031088082901556, 0.8, 0.3999999999999999), (0.5906735751295337, 0.8, 0.3999999999999999), (0.5782383419689119, 0.8, 0.3999999999999999), (0.5658031088082901, 0.8, 0.3999999999999999), (0.5533678756476683, 0.8, 0.3999999999999999), (0.5409326424870464, 0.8, 0.3999999999999999), (0.5284974093264246, 0.8, 0.3999999999999999), (0.5160621761658029, 0.8, 0.3999999999999999), (0.5036269430051811, 0.8, 0.3999999999999999), (0.49119170984455973, 0.8, 0.3999999999999999), (0.47875647668393795, 0.8, 0.3999999999999999), (0.46632124352331616, 0.8, 0.3999999999999999), (0.4538860103626943, 0.8, 0.3999999999999999), (0.44145077720207254, 0.8, 0.3999999999999999), (0.4290155440414507, 0.8, 0.3999999999999999), (0.4165803108808289, 0.8, 0.3999999999999999), (0.4041450777202071, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4082901554404147), (0.3999999999999999, 0.8, 0.4207253886010359), (0.3999999999999999, 0.8, 0.43316062176165776), (0.3999999999999999, 0.8, 0.4455958549222796), (0.3999999999999999, 0.8, 0.4580310880829014), (0.3999999999999999, 0.8, 0.47046632124352317), (0.3999999999999999, 0.8, 0.482901554404145), (0.3999999999999999, 0.8, 0.4953367875647668), (0.3999999999999999, 0.8, 0.5077720207253886), (0.3999999999999999, 0.8, 0.5202072538860104), (0.3999999999999999, 0.8, 0.5326424870466322), (0.3999999999999999, 0.8, 0.5450777202072541), (0.3999999999999999, 0.8, 0.5575129533678759), (0.3999999999999999, 0.8, 0.5699481865284977), (0.3999999999999999, 0.8, 0.5823834196891196), (0.3999999999999999, 0.8, 0.5948186528497413), (0.3999999999999999, 0.8, 0.6072538860103626), (0.3999999999999999, 0.8, 0.6196891191709843), (0.3999999999999999, 0.8, 0.6321243523316062), (0.3999999999999999, 0.8, 0.644559585492228), (0.3999999999999999, 0.8, 0.6569948186528498), (0.3999999999999999, 0.8, 0.6694300518134717), (0.3999999999999999, 0.8, 0.6818652849740934), (0.3999999999999999, 0.8, 0.6943005181347153), (0.3999999999999999, 0.8, 0.7067357512953371), (0.3999999999999999, 0.8, 0.7191709844559584), (0.3999999999999999, 0.8, 0.7316062176165801), (0.3999999999999999, 0.8, 0.744041450777202), (0.3999999999999999, 0.8, 0.7564766839378237), (0.3999999999999999, 0.8, 0.7689119170984455), (0.3999999999999999, 0.8, 0.7813471502590674), (0.3999999999999999, 0.8, 0.7937823834196891), (0.3999999999999999, 0.7937823834196891, 0.8), (0.3999999999999999, 0.7813471502590672, 0.8), (0.3999999999999999, 0.7689119170984454, 0.8), (0.3999999999999999, 0.7564766839378236, 0.8), (0.3999999999999999, 0.7440414507772017, 0.8), (0.3999999999999999, 0.7316062176165801, 0.8), (0.3999999999999999, 0.7191709844559582, 0.8), (0.3999999999999999, 0.7067357512953364, 0.8), (0.3999999999999999, 0.6943005181347146, 0.8), (0.3999999999999999, 0.6818652849740927, 0.8), (0.3999999999999999, 0.6694300518134715, 0.8), (0.3999999999999999, 0.6569948186528497, 0.8), (0.3999999999999999, 0.6445595854922279, 0.8), (0.3999999999999999, 0.632124352331606, 0.8), (0.3999999999999999, 0.6196891191709842, 0.8), (0.3999999999999999, 0.6072538860103625, 0.8), (0.3999999999999999, 0.5948186528497411, 0.8), (0.3999999999999999, 0.5823834196891193, 0.8), (0.3999999999999999, 0.5699481865284975, 0.8), (0.3999999999999999, 0.5575129533678758, 0.8), (0.3999999999999999, 0.5450777202072539, 0.8), (0.3999999999999999, 0.5326424870466321, 0.8), (0.3999999999999999, 0.5202072538860103, 0.8), (0.3999999999999999, 0.5077720207253885, 0.8), (0.3999999999999999, 0.4953367875647667, 0.8), (0.3999999999999999, 0.48290155440414484, 0.8), (0.3999999999999999, 0.47046632124352306, 0.8), (0.3999999999999999, 0.45803108808290127, 0.8), (0.3999999999999999, 0.44559585492227943, 0.8), (0.3999999999999999, 0.43316062176165765, 0.8), (0.3999999999999999, 0.4207253886010358, 0.8), (0.3999999999999999, 0.408290155440414, 0.8), (0.40414507772020736, 0.3999999999999999, 0.8), (0.41658031088082914, 0.3999999999999999, 0.8), (0.429015544041451, 0.3999999999999999, 0.8), (0.44145077720207226, 0.3999999999999999, 0.8), (0.45388601036269405, 0.3999999999999999, 0.8), (0.4663212435233159, 0.3999999999999999, 0.8), (0.47875647668393767, 0.3999999999999999, 0.8), (0.4911917098445595, 0.3999999999999999, 0.8), (0.5036269430051813, 0.3999999999999999, 0.8), (0.5160621761658026, 0.3999999999999999, 0.8), (0.5284974093264244, 0.3999999999999999, 0.8), (0.5409326424870462, 0.3999999999999999, 0.8), (0.553367875647668, 0.3999999999999999, 0.8), (0.5658031088082898, 0.3999999999999999, 0.8), (0.5782383419689117, 0.3999999999999999, 0.8), (0.5906735751295334, 0.3999999999999999, 0.8), (0.6031088082901552, 0.3999999999999999, 0.8), (0.6155440414507771, 0.3999999999999999, 0.8), (0.6279792746113989, 0.3999999999999999, 0.8), (0.6404145077720207, 0.3999999999999999, 0.8), (0.6528497409326425, 0.3999999999999999, 0.8), (0.6652849740932643, 0.3999999999999999, 0.8), (0.6777202072538862, 0.3999999999999999, 0.8), (0.6901554404145079, 0.3999999999999999, 0.8), (0.7025906735751297, 0.3999999999999999, 0.8), (0.7150259067357516, 0.3999999999999999, 0.8), (0.7274611398963733, 0.3999999999999999, 0.8), (0.7398963730569946, 0.3999999999999999, 0.8), (0.7523316062176164, 0.3999999999999999, 0.8), (0.7647668393782383, 0.3999999999999999, 0.8), (0.77720207253886, 0.3999999999999999, 0.8), (0.7896373056994819, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7979274611398959), (0.8, 0.3999999999999999, 0.7854922279792746), (0.8, 0.3999999999999999, 0.7730569948186529), (0.8, 0.3999999999999999, 0.7606217616580311), (0.8, 0.3999999999999999, 0.7481865284974092), (0.8, 0.3999999999999999, 0.7357512953367875), (0.8, 0.3999999999999999, 0.7233160621761656), (0.8, 0.3999999999999999, 0.7108808290155438), (0.8, 0.3999999999999999, 0.698445595854922), (0.8, 0.3999999999999999, 0.6860103626943002), (0.8, 0.3999999999999999, 0.6735751295336785), (0.8, 0.3999999999999999, 0.6611398963730566), (0.8, 0.3999999999999999, 0.6487046632124348), (0.8, 0.3999999999999999, 0.636269430051813), (0.8, 0.3999999999999999, 0.6238341968911911), (0.8, 0.3999999999999999, 0.6113989637305693), (0.8, 0.3999999999999999, 0.5989637305699476), (0.8, 0.3999999999999999, 0.5865284974093257), (0.8, 0.3999999999999999, 0.5740932642487039), (0.8, 0.3999999999999999, 0.5616580310880827), (0.8, 0.3999999999999999, 0.5492227979274609), (0.8, 0.3999999999999999, 0.536787564766839), (0.8, 0.3999999999999999, 0.5243523316062172), (0.8, 0.3999999999999999, 0.5119170984455954), (0.8, 0.3999999999999999, 0.49948186528497357), (0.8, 0.3999999999999999, 0.4870466321243523), (0.8, 0.3999999999999999, 0.4746113989637305), (0.8, 0.3999999999999999, 0.4621761658031087), (0.8, 0.3999999999999999, 0.4497409326424869), (0.8, 0.3999999999999999, 0.4373056994818651), (0.8, 0.3999999999999999, 0.42487046632124326), (0.8, 0.3999999999999999, 0.4124352331606215)],
    194: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4123711340206184, 0.3999999999999999), (0.8, 0.42474226804123694, 0.3999999999999999), (0.8, 0.43711340206185545, 0.3999999999999999), (0.8, 0.44948453608247396, 0.3999999999999999), (0.8, 0.4618556701030925, 0.3999999999999999), (0.8, 0.474226804123711, 0.3999999999999999), (0.8, 0.48659793814433006, 0.3999999999999999), (0.8, 0.49896907216494857, 0.3999999999999999), (0.8, 0.5113402061855671, 0.3999999999999999), (0.8, 0.5237113402061856, 0.3999999999999999), (0.8, 0.5360824742268041, 0.3999999999999999), (0.8, 0.5484536082474226, 0.3999999999999999), (0.8, 0.5608247422680411, 0.3999999999999999), (0.8, 0.5731958762886596, 0.3999999999999999), (0.8, 0.5855670103092783, 0.3999999999999999), (0.8, 0.5979381443298967, 0.3999999999999999), (0.8, 0.6103092783505152, 0.3999999999999999), (0.8, 0.6226804123711343, 0.3999999999999999), (0.8, 0.6350515463917528, 0.3999999999999999), (0.8, 0.6474226804123713, 0.3999999999999999), (0.8, 0.6597938144329898, 0.3999999999999999), (0.8, 0.6721649484536083, 0.3999999999999999), (0.8, 0.6845360824742268, 0.3999999999999999), (0.8, 0.6969072164948453, 0.3999999999999999), (0.8, 0.7092783505154638, 0.3999999999999999), (0.8, 0.7216494845360824, 0.3999999999999999), (0.8, 0.7340206185567009, 0.3999999999999999), (0.8, 0.7463917525773194, 0.3999999999999999), (0.8, 0.7587628865979379, 0.3999999999999999), (0.8, 0.7711340206185565, 0.3999999999999999), (0.8, 0.7835051546391749, 0.3999999999999999), (0.8, 0.7958762886597941, 0.3999999999999999), (0.7917525773195877, 0.8, 0.3999999999999999), (0.7793814432989692, 0.8, 0.3999999999999999), (0.7670103092783506, 0.8, 0.3999999999999999), (0.754639175257732, 0.8, 0.3999999999999999), (0.7422680412371135, 0.8, 0.3999999999999999), (0.729896907216495, 0.8, 0.3999999999999999), (0.7175257731958765, 0.8, 0.3999999999999999), (0.705154639175258, 0.8, 0.3999999999999999), (0.6927835051546395, 0.8, 0.3999999999999999), (0.6804123711340204, 0.8, 0.3999999999999999), (0.6680412371134019, 0.8, 0.3999999999999999), (0.6556701030927834, 0.8, 0.3999999999999999), (0.6432989690721649, 0.8, 0.3999999999999999), (0.6309278350515464, 0.8, 0.3999999999999999), (0.6185567010309279, 0.8, 0.3999999999999999), (0.6061855670103093, 0.8, 0.3999999999999999), (0.5938144329896908, 0.8, 0.3999999999999999), (0.5814432989690723, 0.8, 0.3999999999999999), (0.5690721649484538, 0.8, 0.3999999999999999), (0.5567010309278353, 0.8, 0.3999999999999999), (0.5443298969072168, 0.8, 0.3999999999999999), (0.5319587628865983, 0.8, 0.3999999999999999), (0.5195876288659798, 0.8, 0.3999999999999999), (0.5072164948453612, 0.8, 0.3999999999999999), (0.4948453608247421, 0.8, 0.3999999999999999), (0.4824742268041236, 0.8, 0.3999999999999999), (0.4701030927835051, 0.8, 0.3999999999999999), (0.4577319587628866, 0.8, 0.3999999999999999), (0.44536082474226807, 0.8, 0.3999999999999999), (0.43298969072164956, 0.8, 0.3999999999999999), (0.42061855670103104, 0.8, 0.3999999999999999), (0.40824742268041253, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40412371134020597), (0.3999999999999999, 0.8, 0.416494845360825), (0.3999999999999999, 0.8, 0.4288659793814435), (0.3999999999999999, 0.8, 0.441237113402062), (0.3999999999999999, 0.8, 0.4536082474226806), (0.3999999999999999, 0.8, 0.4659793814432991), (0.3999999999999999, 0.8, 0.4783505154639176), (0.3999999999999999, 0.8, 0.4907216494845361), (0.3999999999999999, 0.8, 0.5030927835051546), (0.3999999999999999, 0.8, 0.5154639175257731), (0.3999999999999999, 0.8, 0.5278350515463917), (0.3999999999999999, 0.8, 0.5402061855670102), (0.3999999999999999, 0.8, 0.5525773195876287), (0.3999999999999999, 0.8, 0.5649484536082472), (0.3999999999999999, 0.8, 0.5773195876288657), (0.3999999999999999, 0.8, 0.5896907216494842), (0.3999999999999999, 0.8, 0.6020618556701033), (0.3999999999999999, 0.8, 0.6144329896907218), (0.3999999999999999, 0.8, 0.6268041237113403), (0.3999999999999999, 0.8, 0.6391752577319588), (0.3999999999999999, 0.8, 0.6515463917525773), (0.3999999999999999, 0.8, 0.663917525773196), (0.3999999999999999, 0.8, 0.6762886597938145), (0.3999999999999999, 0.8, 0.688659793814433), (0.3999999999999999, 0.8, 0.7010309278350515), (0.3999999999999999, 0.8, 0.7134020618556705), (0.3999999999999999, 0.8, 0.725773195876289), (0.3999999999999999, 0.8, 0.7381443298969075), (0.3999999999999999, 0.8, 0.750515463917526), (0.3999999999999999, 0.8, 0.7628865979381445), (0.3999999999999999, 0.8, 0.775257731958763), (0.3999999999999999, 0.8, 0.7876288659793815), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7876288659793815, 0.8), (0.3999999999999999, 0.775257731958763, 0.8), (0.3999999999999999, 0.7628865979381444, 0.8), (0.3999999999999999, 0.7505154639175259, 0.8), (0.3999999999999999, 0.7381443298969074, 0.8), (0.3999999999999999, 0.7257731958762889, 0.8), (0.3999999999999999, 0.7134020618556703, 0.8), (0.3999999999999999, 0.7010309278350518, 0.8), (0.3999999999999999, 0.6886597938144333, 0.8), (0.3999999999999999, 0.6762886597938143, 0.8), (0.3999999999999999, 0.6639175257731957, 0.8), (0.3999999999999999, 0.6515463917525772, 0.8), (0.3999999999999999, 0.6391752577319587, 0.8), (0.3999999999999999, 0.6268041237113402, 0.8), (0.3999999999999999, 0.6144329896907217, 0.8), (0.3999999999999999, 0.6020618556701026, 0.8), (0.3999999999999999, 0.5896907216494841, 0.8), (0.3999999999999999, 0.5773195876288656, 0.8), (0.3999999999999999, 0.5649484536082471, 0.8), (0.3999999999999999, 0.5525773195876286, 0.8), (0.3999999999999999, 0.54020618556701, 0.8), (0.3999999999999999, 0.5278350515463915, 0.8), (0.3999999999999999, 0.515463917525773, 0.8), (0.3999999999999999, 0.5030927835051545, 0.8), (0.3999999999999999, 0.490721649484536, 0.8), (0.3999999999999999, 0.47835051546391744, 0.8), (0.3999999999999999, 0.4659793814432989, 0.8), (0.3999999999999999, 0.4536082474226804, 0.8), (0.3999999999999999, 0.4412371134020619, 0.8), (0.3999999999999999, 0.4288659793814434, 0.8), (0.3999999999999999, 0.4164948453608249, 0.8), (0.3999999999999999, 0.40412371134020636, 0.8), (0.4082474226804117, 0.3999999999999999, 0.8), (0.4206185567010302, 0.3999999999999999, 0.8), (0.4329896907216493, 0.3999999999999999, 0.8), (0.4453608247422678, 0.3999999999999999, 0.8), (0.4577319587628863, 0.3999999999999999, 0.8), (0.4701030927835048, 0.3999999999999999, 0.8), (0.48247422680412333, 0.3999999999999999, 0.8), (0.4948453608247419, 0.3999999999999999, 0.8), (0.5072164948453609, 0.3999999999999999, 0.8), (0.5195876288659794, 0.3999999999999999, 0.8), (0.5319587628865979, 0.3999999999999999, 0.8), (0.5443298969072164, 0.3999999999999999, 0.8), (0.556701030927835, 0.3999999999999999, 0.8), (0.5690721649484535, 0.3999999999999999, 0.8), (0.5814432989690721, 0.3999999999999999, 0.8), (0.5938144329896905, 0.3999999999999999, 0.8), (0.606185567010309, 0.3999999999999999, 0.8), (0.6185567010309276, 0.3999999999999999, 0.8), (0.6309278350515461, 0.3999999999999999, 0.8), (0.6432989690721647, 0.3999999999999999, 0.8), (0.6556701030927832, 0.3999999999999999, 0.8), (0.6680412371134017, 0.3999999999999999, 0.8), (0.6804123711340202, 0.3999999999999999, 0.8), (0.6927835051546387, 0.3999999999999999, 0.8), (0.7051546391752572, 0.3999999999999999, 0.8), (0.7175257731958757, 0.3999999999999999, 0.8), (0.7298969072164947, 0.3999999999999999, 0.8), (0.7422680412371132, 0.3999999999999999, 0.8), (0.7546391752577317, 0.3999999999999999, 0.8), (0.7670103092783503, 0.3999999999999999, 0.8), (0.7793814432989687, 0.3999999999999999, 0.8), (0.7917525773195873, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7958762886597932), (0.8, 0.3999999999999999, 0.7835051546391747), (0.8, 0.3999999999999999, 0.7711340206185562), (0.8, 0.3999999999999999, 0.7587628865979377), (0.8, 0.3999999999999999, 0.7463917525773192), (0.8, 0.3999999999999999, 0.7340206185567006), (0.8, 0.3999999999999999, 0.7216494845360821), (0.8, 0.3999999999999999, 0.7092783505154636), (0.8, 0.3999999999999999, 0.6969072164948451), (0.8, 0.3999999999999999, 0.6845360824742266), (0.8, 0.3999999999999999, 0.6721649484536081), (0.8, 0.3999999999999999, 0.6597938144329896), (0.8, 0.3999999999999999, 0.647422680412371), (0.8, 0.3999999999999999, 0.6350515463917525), (0.8, 0.3999999999999999, 0.622680412371134), (0.8, 0.3999999999999999, 0.6103092783505155), (0.8, 0.3999999999999999, 0.597938144329897), (0.8, 0.3999999999999999, 0.5855670103092785), (0.8, 0.3999999999999999, 0.5731958762886594), (0.8, 0.3999999999999999, 0.5608247422680409), (0.8, 0.3999999999999999, 0.5484536082474224), (0.8, 0.3999999999999999, 0.5360824742268039), (0.8, 0.3999999999999999, 0.5237113402061854), (0.8, 0.3999999999999999, 0.5113402061855669), (0.8, 0.3999999999999999, 0.4989690721649478), (0.8, 0.3999999999999999, 0.4865979381443293), (0.8, 0.3999999999999999, 0.47422680412371077), (0.8, 0.3999999999999999, 0.46185567010309225), (0.8, 0.3999999999999999, 0.44948453608247374), (0.8, 0.3999999999999999, 0.43711340206185517), (0.8, 0.3999999999999999, 0.42474226804123666), (0.8, 0.3999999999999999, 0.41237113402061815)],
    195: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41230769230769215, 0.3999999999999999), (0.8, 0.42461538461538445, 0.3999999999999999), (0.8, 0.4369230769230767, 0.3999999999999999), (0.8, 0.449230769230769, 0.3999999999999999), (0.8, 0.46153846153846123, 0.3999999999999999), (0.8, 0.47384615384615353, 0.3999999999999999), (0.8, 0.4861538461538463, 0.3999999999999999), (0.8, 0.49846153846153857, 0.3999999999999999), (0.8, 0.5107692307692309, 0.3999999999999999), (0.8, 0.5230769230769231, 0.3999999999999999), (0.8, 0.5353846153846153, 0.3999999999999999), (0.8, 0.5476923076923077, 0.3999999999999999), (0.8, 0.5599999999999999, 0.3999999999999999), (0.8, 0.5723076923076922, 0.3999999999999999), (0.8, 0.5846153846153845, 0.3999999999999999), (0.8, 0.5969230769230768, 0.3999999999999999), (0.8, 0.609230769230769, 0.3999999999999999), (0.8, 0.6215384615384618, 0.3999999999999999), (0.8, 0.6338461538461541, 0.3999999999999999), (0.8, 0.6461538461538463, 0.3999999999999999), (0.8, 0.6584615384615387, 0.3999999999999999), (0.8, 0.6707692307692309, 0.3999999999999999), (0.8, 0.6830769230769231, 0.3999999999999999), (0.8, 0.6953846153846155, 0.3999999999999999), (0.8, 0.7076923076923076, 0.3999999999999999), (0.8, 0.72, 0.3999999999999999), (0.8, 0.7323076923076922, 0.3999999999999999), (0.8, 0.7446153846153845, 0.3999999999999999), (0.8, 0.7569230769230768, 0.3999999999999999), (0.8, 0.769230769230769, 0.3999999999999999), (0.8, 0.7815384615384613, 0.3999999999999999), (0.8, 0.7938461538461541, 0.3999999999999999), (0.7938461538461539, 0.8, 0.3999999999999999), (0.7815384615384615, 0.8, 0.3999999999999999), (0.7692307692307693, 0.8, 0.3999999999999999), (0.756923076923077, 0.8, 0.3999999999999999), (0.7446153846153847, 0.8, 0.3999999999999999), (0.7323076923076925, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.707692307692308, 0.8, 0.3999999999999999), (0.6953846153846157, 0.8, 0.3999999999999999), (0.6830769230769229, 0.8, 0.3999999999999999), (0.6707692307692306, 0.8, 0.3999999999999999), (0.6584615384615383, 0.8, 0.3999999999999999), (0.6461538461538461, 0.8, 0.3999999999999999), (0.6338461538461538, 0.8, 0.3999999999999999), (0.6215384615384616, 0.8, 0.3999999999999999), (0.6092307692307692, 0.8, 0.3999999999999999), (0.596923076923077, 0.8, 0.3999999999999999), (0.5846153846153848, 0.8, 0.3999999999999999), (0.5723076923076924, 0.8, 0.3999999999999999), (0.5600000000000002, 0.8, 0.3999999999999999), (0.5476923076923079, 0.8, 0.3999999999999999), (0.5353846153846157, 0.8, 0.3999999999999999), (0.5230769230769234, 0.8, 0.3999999999999999), (0.5107692307692311, 0.8, 0.3999999999999999), (0.49846153846153834, 0.8, 0.3999999999999999), (0.48615384615384605, 0.8, 0.3999999999999999), (0.4738461538461538, 0.8, 0.3999999999999999), (0.4615384615384615, 0.8, 0.3999999999999999), (0.44923076923076927, 0.8, 0.3999999999999999), (0.43692307692307697, 0.8, 0.3999999999999999), (0.42461538461538473, 0.8, 0.3999999999999999), (0.41230769230769243, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4123076923076926), (0.3999999999999999, 0.8, 0.42461538461538484), (0.3999999999999999, 0.8, 0.43692307692307714), (0.3999999999999999, 0.8, 0.4492307692307694), (0.3999999999999999, 0.8, 0.4615384615384617), (0.3999999999999999, 0.8, 0.4738461538461539), (0.3999999999999999, 0.8, 0.48615384615384616), (0.3999999999999999, 0.8, 0.49846153846153846), (0.3999999999999999, 0.8, 0.5107692307692308), (0.3999999999999999, 0.8, 0.523076923076923), (0.3999999999999999, 0.8, 0.5353846153846152), (0.3999999999999999, 0.8, 0.5476923076923075), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5723076923076921), (0.3999999999999999, 0.8, 0.5846153846153843), (0.3999999999999999, 0.8, 0.5969230769230771), (0.3999999999999999, 0.8, 0.6092307692307694), (0.3999999999999999, 0.8, 0.6215384615384617), (0.3999999999999999, 0.8, 0.633846153846154), (0.3999999999999999, 0.8, 0.6461538461538462), (0.3999999999999999, 0.8, 0.6584615384615384), (0.3999999999999999, 0.8, 0.6707692307692308), (0.3999999999999999, 0.8, 0.683076923076923), (0.3999999999999999, 0.8, 0.6953846153846153), (0.3999999999999999, 0.8, 0.7076923076923081), (0.3999999999999999, 0.8, 0.7200000000000004), (0.3999999999999999, 0.8, 0.7323076923076925), (0.3999999999999999, 0.8, 0.7446153846153849), (0.3999999999999999, 0.8, 0.7569230769230771), (0.3999999999999999, 0.8, 0.7692307692307694), (0.3999999999999999, 0.8, 0.7815384615384617), (0.3999999999999999, 0.8, 0.7938461538461539), (0.3999999999999999, 0.7938461538461539, 0.8), (0.3999999999999999, 0.7815384615384615, 0.8), (0.3999999999999999, 0.7692307692307693, 0.8), (0.3999999999999999, 0.756923076923077, 0.8), (0.3999999999999999, 0.7446153846153847, 0.8), (0.3999999999999999, 0.7323076923076925, 0.8), (0.3999999999999999, 0.7200000000000002, 0.8), (0.3999999999999999, 0.707692307692308, 0.8), (0.3999999999999999, 0.6953846153846157, 0.8), (0.3999999999999999, 0.6830769230769229, 0.8), (0.3999999999999999, 0.6707692307692306, 0.8), (0.3999999999999999, 0.6584615384615383, 0.8), (0.3999999999999999, 0.6461538461538461, 0.8), (0.3999999999999999, 0.6338461538461538, 0.8), (0.3999999999999999, 0.6215384615384616, 0.8), (0.3999999999999999, 0.6092307692307687, 0.8), (0.3999999999999999, 0.5969230769230764, 0.8), (0.3999999999999999, 0.5846153846153842, 0.8), (0.3999999999999999, 0.572307692307692, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5476923076923074, 0.8), (0.3999999999999999, 0.5353846153846151, 0.8), (0.3999999999999999, 0.5230769230769229, 0.8), (0.3999999999999999, 0.5107692307692306, 0.8), (0.3999999999999999, 0.49846153846153834, 0.8), (0.3999999999999999, 0.48615384615384605, 0.8), (0.3999999999999999, 0.4738461538461538, 0.8), (0.3999999999999999, 0.4615384615384615, 0.8), (0.3999999999999999, 0.44923076923076927, 0.8), (0.3999999999999999, 0.43692307692307697, 0.8), (0.3999999999999999, 0.42461538461538473, 0.8), (0.3999999999999999, 0.41230769230769243, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41230769230769165, 0.3999999999999999, 0.8), (0.42461538461538445, 0.3999999999999999, 0.8), (0.4369230769230767, 0.3999999999999999, 0.8), (0.449230769230769, 0.3999999999999999, 0.8), (0.46153846153846123, 0.3999999999999999, 0.8), (0.47384615384615353, 0.3999999999999999, 0.8), (0.48615384615384577, 0.3999999999999999, 0.8), (0.49846153846153857, 0.3999999999999999, 0.8), (0.5107692307692309, 0.3999999999999999, 0.8), (0.5230769230769231, 0.3999999999999999, 0.8), (0.5353846153846153, 0.3999999999999999, 0.8), (0.5476923076923077, 0.3999999999999999, 0.8), (0.5599999999999999, 0.3999999999999999, 0.8), (0.5723076923076922, 0.3999999999999999, 0.8), (0.5846153846153845, 0.3999999999999999, 0.8), (0.5969230769230768, 0.3999999999999999, 0.8), (0.609230769230769, 0.3999999999999999, 0.8), (0.6215384615384613, 0.3999999999999999, 0.8), (0.6338461538461535, 0.3999999999999999, 0.8), (0.6461538461538459, 0.3999999999999999, 0.8), (0.6584615384615381, 0.3999999999999999, 0.8), (0.6707692307692303, 0.3999999999999999, 0.8), (0.6830769230769227, 0.3999999999999999, 0.8), (0.6953846153846148, 0.3999999999999999, 0.8), (0.7076923076923072, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7323076923076922, 0.3999999999999999, 0.8), (0.7446153846153845, 0.3999999999999999, 0.8), (0.7569230769230768, 0.3999999999999999, 0.8), (0.769230769230769, 0.3999999999999999, 0.8), (0.7815384615384613, 0.3999999999999999, 0.8), (0.7938461538461541, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7938461538461532), (0.8, 0.3999999999999999, 0.7815384615384611), (0.8, 0.3999999999999999, 0.7692307692307687), (0.8, 0.3999999999999999, 0.7569230769230765), (0.8, 0.3999999999999999, 0.7446153846153842), (0.8, 0.3999999999999999, 0.7323076923076919), (0.8, 0.3999999999999999, 0.7199999999999998), (0.8, 0.3999999999999999, 0.7076923076923074), (0.8, 0.3999999999999999, 0.6953846153846152), (0.8, 0.3999999999999999, 0.6830769230769229), (0.8, 0.3999999999999999, 0.6707692307692306), (0.8, 0.3999999999999999, 0.6584615384615383), (0.8, 0.3999999999999999, 0.6461538461538461), (0.8, 0.3999999999999999, 0.6338461538461538), (0.8, 0.3999999999999999, 0.6215384615384616), (0.8, 0.3999999999999999, 0.6092307692307692), (0.8, 0.3999999999999999, 0.596923076923077), (0.8, 0.3999999999999999, 0.5846153846153842), (0.8, 0.3999999999999999, 0.572307692307692), (0.8, 0.3999999999999999, 0.5599999999999996), (0.8, 0.3999999999999999, 0.5476923076923074), (0.8, 0.3999999999999999, 0.5353846153846151), (0.8, 0.3999999999999999, 0.5230769230769229), (0.8, 0.3999999999999999, 0.5107692307692301), (0.8, 0.3999999999999999, 0.4984615384615378), (0.8, 0.3999999999999999, 0.4861538461538455), (0.8, 0.3999999999999999, 0.47384615384615325), (0.8, 0.3999999999999999, 0.461538461538461), (0.8, 0.3999999999999999, 0.4492307692307687), (0.8, 0.3999999999999999, 0.43692307692307647), (0.8, 0.3999999999999999, 0.4246153846153842), (0.8, 0.3999999999999999, 0.41230769230769193)],
    196: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41224489795918345, 0.3999999999999999), (0.8, 0.424489795918367, 0.3999999999999999), (0.8, 0.4367346938775511, 0.3999999999999999), (0.8, 0.4489795918367347, 0.3999999999999999), (0.8, 0.46122448979591824, 0.3999999999999999), (0.8, 0.4734693877551018, 0.3999999999999999), (0.8, 0.4857142857142859, 0.3999999999999999), (0.8, 0.4979591836734694, 0.3999999999999999), (0.8, 0.510204081632653, 0.3999999999999999), (0.8, 0.5224489795918366, 0.3999999999999999), (0.8, 0.5346938775510202, 0.3999999999999999), (0.8, 0.5469387755102042, 0.3999999999999999), (0.8, 0.5591836734693878, 0.3999999999999999), (0.8, 0.5714285714285713, 0.3999999999999999), (0.8, 0.5836734693877549, 0.3999999999999999), (0.8, 0.5959183673469389, 0.3999999999999999), (0.8, 0.6081632653061225, 0.3999999999999999), (0.8, 0.6204081632653061, 0.3999999999999999), (0.8, 0.6326530612244896, 0.3999999999999999), (0.8, 0.6448979591836732, 0.3999999999999999), (0.8, 0.6571428571428573, 0.3999999999999999), (0.8, 0.6693877551020408, 0.3999999999999999), (0.8, 0.6816326530612244, 0.3999999999999999), (0.8, 0.693877551020408, 0.3999999999999999), (0.8, 0.7061224489795921, 0.3999999999999999), (0.8, 0.7183673469387757, 0.3999999999999999), (0.8, 0.7306122448979592, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7551020408163268, 0.3999999999999999), (0.8, 0.7673469387755104, 0.3999999999999999), (0.8, 0.7795918367346939, 0.3999999999999999), (0.8, 0.7918367346938775, 0.3999999999999999), (0.7959183673469392, 0.8, 0.3999999999999999), (0.783673469387755, 0.8, 0.3999999999999999), (0.7714285714285715, 0.8, 0.3999999999999999), (0.759183673469388, 0.8, 0.3999999999999999), (0.7469387755102044, 0.8, 0.3999999999999999), (0.7346938775510208, 0.8, 0.3999999999999999), (0.7224489795918367, 0.8, 0.3999999999999999), (0.7102040816326531, 0.8, 0.3999999999999999), (0.6979591836734695, 0.8, 0.3999999999999999), (0.685714285714286, 0.8, 0.3999999999999999), (0.6734693877551019, 0.8, 0.3999999999999999), (0.6612244897959184, 0.8, 0.3999999999999999), (0.6489795918367348, 0.8, 0.3999999999999999), (0.6367346938775513, 0.8, 0.3999999999999999), (0.6244897959183672, 0.8, 0.3999999999999999), (0.6122448979591836, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5877551020408165, 0.8, 0.3999999999999999), (0.5755102040816329, 0.8, 0.3999999999999999), (0.5632653061224488, 0.8, 0.3999999999999999), (0.5510204081632653, 0.8, 0.3999999999999999), (0.5387755102040818, 0.8, 0.3999999999999999), (0.5265306122448982, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.5020408163265305, 0.8, 0.3999999999999999), (0.489795918367347, 0.8, 0.3999999999999999), (0.47755102040816344, 0.8, 0.3999999999999999), (0.46530612244897984, 0.8, 0.3999999999999999), (0.4530612244897963, 0.8, 0.3999999999999999), (0.4408163265306122, 0.8, 0.3999999999999999), (0.42857142857142866, 0.8, 0.3999999999999999), (0.4163265306122451, 0.8, 0.3999999999999999), (0.404081632653061, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4081632653061225), (0.3999999999999999, 0.8, 0.42040816326530606), (0.3999999999999999, 0.8, 0.4326530612244896), (0.3999999999999999, 0.8, 0.4448979591836732), (0.3999999999999999, 0.8, 0.4571428571428573), (0.3999999999999999, 0.8, 0.46938775510204084), (0.3999999999999999, 0.8, 0.4816326530612244), (0.3999999999999999, 0.8, 0.4938775510204079), (0.3999999999999999, 0.8, 0.5061224489795915), (0.3999999999999999, 0.8, 0.5183673469387756), (0.3999999999999999, 0.8, 0.5306122448979591), (0.3999999999999999, 0.8, 0.5428571428571427), (0.3999999999999999, 0.8, 0.5551020408163263), (0.3999999999999999, 0.8, 0.5673469387755098), (0.3999999999999999, 0.8, 0.5795918367346939), (0.3999999999999999, 0.8, 0.5918367346938774), (0.3999999999999999, 0.8, 0.604081632653061), (0.3999999999999999, 0.8, 0.6163265306122452), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6408163265306123), (0.3999999999999999, 0.8, 0.6530612244897958), (0.3999999999999999, 0.8, 0.6653061224489794), (0.3999999999999999, 0.8, 0.6775510204081634), (0.3999999999999999, 0.8, 0.689795918367347), (0.3999999999999999, 0.8, 0.7020408163265306), (0.3999999999999999, 0.8, 0.7142857142857142), (0.3999999999999999, 0.8, 0.7265306122448977), (0.3999999999999999, 0.8, 0.7387755102040818), (0.3999999999999999, 0.8, 0.7510204081632653), (0.3999999999999999, 0.8, 0.7632653061224489), (0.3999999999999999, 0.8, 0.7755102040816331), (0.3999999999999999, 0.8, 0.787755102040816), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7877551020408164, 0.8), (0.3999999999999999, 0.7755102040816328, 0.8), (0.3999999999999999, 0.7632653061224488, 0.8), (0.3999999999999999, 0.7510204081632657, 0.8), (0.3999999999999999, 0.7387755102040816, 0.8), (0.3999999999999999, 0.726530612244898, 0.8), (0.3999999999999999, 0.7142857142857145, 0.8), (0.3999999999999999, 0.7020408163265304, 0.8), (0.3999999999999999, 0.6897959183673469, 0.8), (0.3999999999999999, 0.6775510204081634, 0.8), (0.3999999999999999, 0.6653061224489792, 0.8), (0.3999999999999999, 0.6530612244897962, 0.8), (0.3999999999999999, 0.6408163265306122, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.616326530612245, 0.8), (0.3999999999999999, 0.6040816326530609, 0.8), (0.3999999999999999, 0.5918367346938779, 0.8), (0.3999999999999999, 0.5795918367346937, 0.8), (0.3999999999999999, 0.5673469387755102, 0.8), (0.3999999999999999, 0.5551020408163266, 0.8), (0.3999999999999999, 0.5428571428571426, 0.8), (0.3999999999999999, 0.5306122448979596, 0.8), (0.3999999999999999, 0.5183673469387755, 0.8), (0.3999999999999999, 0.5061224489795919, 0.8), (0.3999999999999999, 0.49387755102040837, 0.8), (0.3999999999999999, 0.48163265306122427, 0.8), (0.3999999999999999, 0.46938775510204067, 0.8), (0.3999999999999999, 0.45714285714285713, 0.8), (0.3999999999999999, 0.44489795918367303, 0.8), (0.3999999999999999, 0.43265306122449004, 0.8), (0.3999999999999999, 0.42040816326530595, 0.8), (0.3999999999999999, 0.40816326530612235, 0.8), (0.40408163265306074, 0.3999999999999999, 0.8), (0.41632653061224484, 0.3999999999999999, 0.8), (0.4285714285714278, 0.3999999999999999, 0.8), (0.4408163265306119, 0.3999999999999999, 0.8), (0.4530612244897955, 0.3999999999999999, 0.8), (0.46530612244897906, 0.3999999999999999, 0.8), (0.47755102040816316, 0.3999999999999999, 0.8), (0.48979591836734615, 0.3999999999999999, 0.8), (0.5020408163265303, 0.3999999999999999, 0.8), (0.5142857142857138, 0.3999999999999999, 0.8), (0.5265306122448974, 0.3999999999999999, 0.8), (0.5387755102040814, 0.3999999999999999, 0.8), (0.551020408163265, 0.3999999999999999, 0.8), (0.5632653061224486, 0.3999999999999999, 0.8), (0.5755102040816327, 0.3999999999999999, 0.8), (0.5877551020408157, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6122448979591834, 0.3999999999999999, 0.8), (0.624489795918367, 0.3999999999999999, 0.8), (0.636734693877551, 0.3999999999999999, 0.8), (0.648979591836734, 0.3999999999999999, 0.8), (0.6612244897959181, 0.3999999999999999, 0.8), (0.6734693877551017, 0.3999999999999999, 0.8), (0.6857142857142853, 0.3999999999999999, 0.8), (0.6979591836734693, 0.3999999999999999, 0.8), (0.7102040816326524, 0.3999999999999999, 0.8), (0.7224489795918365, 0.3999999999999999, 0.8), (0.73469387755102, 0.3999999999999999, 0.8), (0.7469387755102035, 0.3999999999999999, 0.8), (0.7591836734693876, 0.3999999999999999, 0.8), (0.7714285714285712, 0.3999999999999999, 0.8), (0.7836734693877547, 0.3999999999999999, 0.8), (0.7959183673469388, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7918367346938777), (0.8, 0.3999999999999999, 0.7795918367346937), (0.8, 0.3999999999999999, 0.7673469387755101), (0.8, 0.3999999999999999, 0.7551020408163265), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.7306122448979595), (0.8, 0.3999999999999999, 0.7183673469387754), (0.8, 0.3999999999999999, 0.7061224489795919), (0.8, 0.3999999999999999, 0.6938775510204083), (0.8, 0.3999999999999999, 0.6816326530612242), (0.8, 0.3999999999999999, 0.6693877551020411), (0.8, 0.3999999999999999, 0.657142857142857), (0.8, 0.3999999999999999, 0.6448979591836734), (0.8, 0.3999999999999999, 0.6326530612244899), (0.8, 0.3999999999999999, 0.6204081632653058), (0.8, 0.3999999999999999, 0.6081632653061223), (0.8, 0.3999999999999999, 0.5959183673469387), (0.8, 0.3999999999999999, 0.5836734693877546), (0.8, 0.3999999999999999, 0.5714285714285716), (0.8, 0.3999999999999999, 0.5591836734693875), (0.8, 0.3999999999999999, 0.546938775510204), (0.8, 0.3999999999999999, 0.5346938775510204), (0.8, 0.3999999999999999, 0.5224489795918363), (0.8, 0.3999999999999999, 0.5102040816326533), (0.8, 0.3999999999999999, 0.4979591836734692), (0.8, 0.3999999999999999, 0.4857142857142856), (0.8, 0.3999999999999999, 0.47346938775510206), (0.8, 0.3999999999999999, 0.46122448979591796), (0.8, 0.3999999999999999, 0.4489795918367344), (0.8, 0.3999999999999999, 0.4367346938775509), (0.8, 0.3999999999999999, 0.4244897959183673), (0.8, 0.3999999999999999, 0.41224489795918373)],
    197: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41218274111675096, 0.3999999999999999), (0.8, 0.4243654822335025, 0.3999999999999999), (0.8, 0.43654822335025356, 0.3999999999999999), (0.8, 0.44873096446700517, 0.3999999999999999), (0.8, 0.4609137055837562, 0.3999999999999999), (0.8, 0.47309644670050777, 0.3999999999999999), (0.8, 0.4852791878172588, 0.3999999999999999), (0.8, 0.49746192893400987, 0.3999999999999999), (0.8, 0.5096446700507614, 0.3999999999999999), (0.8, 0.5218274111675125, 0.3999999999999999), (0.8, 0.5340101522842641, 0.3999999999999999), (0.8, 0.5461928934010151, 0.3999999999999999), (0.8, 0.5583756345177666, 0.3999999999999999), (0.8, 0.5705583756345177, 0.3999999999999999), (0.8, 0.5827411167512688, 0.3999999999999999), (0.8, 0.5949238578680204, 0.3999999999999999), (0.8, 0.6071065989847714, 0.3999999999999999), (0.8, 0.6192893401015229, 0.3999999999999999), (0.8, 0.631472081218274, 0.3999999999999999), (0.8, 0.6436548223350256, 0.3999999999999999), (0.8, 0.6558375634517766, 0.3999999999999999), (0.8, 0.6680203045685277, 0.3999999999999999), (0.8, 0.6802030456852792, 0.3999999999999999), (0.8, 0.6923857868020302, 0.3999999999999999), (0.8, 0.7045685279187819, 0.3999999999999999), (0.8, 0.7167512690355329, 0.3999999999999999), (0.8, 0.7289340101522845, 0.3999999999999999), (0.8, 0.7411167512690355, 0.3999999999999999), (0.8, 0.7532994923857871, 0.3999999999999999), (0.8, 0.7654822335025382, 0.3999999999999999), (0.8, 0.7776649746192892, 0.3999999999999999), (0.8, 0.7898477157360408, 0.3999999999999999), (0.7979695431472085, 0.8, 0.3999999999999999), (0.7857868020304568, 0.8, 0.3999999999999999), (0.7736040609137058, 0.8, 0.3999999999999999), (0.7614213197969542, 0.8, 0.3999999999999999), (0.7492385786802032, 0.8, 0.3999999999999999), (0.7370558375634522, 0.8, 0.3999999999999999), (0.7248730964467005, 0.8, 0.3999999999999999), (0.7126903553299495, 0.8, 0.3999999999999999), (0.7005076142131978, 0.8, 0.3999999999999999), (0.6883248730964469, 0.8, 0.3999999999999999), (0.6761421319796953, 0.8, 0.3999999999999999), (0.6639593908629442, 0.8, 0.3999999999999999), (0.6517766497461932, 0.8, 0.3999999999999999), (0.6395939086294417, 0.8, 0.3999999999999999), (0.6274111675126905, 0.8, 0.3999999999999999), (0.615228426395939, 0.8, 0.3999999999999999), (0.603045685279188, 0.8, 0.3999999999999999), (0.5908629441624363, 0.8, 0.3999999999999999), (0.5786802030456853, 0.8, 0.3999999999999999), (0.5664974619289342, 0.8, 0.3999999999999999), (0.5543147208121827, 0.8, 0.3999999999999999), (0.5421319796954317, 0.8, 0.3999999999999999), (0.5299492385786801, 0.8, 0.3999999999999999), (0.517766497461929, 0.8, 0.3999999999999999), (0.5055837563451775, 0.8, 0.3999999999999999), (0.49340101522842644, 0.8, 0.3999999999999999), (0.4812182741116754, 0.8, 0.3999999999999999), (0.46903553299492384, 0.8, 0.3999999999999999), (0.4568527918781728, 0.8, 0.3999999999999999), (0.4446700507614212, 0.8, 0.3999999999999999), (0.43248730964467014, 0.8, 0.3999999999999999), (0.4203045685279186, 0.8, 0.3999999999999999), (0.40812182741116754, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40406091370558345), (0.3999999999999999, 0.8, 0.41624365482233505), (0.3999999999999999, 0.8, 0.42842639593908605), (0.3999999999999999, 0.8, 0.44060913705583765), (0.3999999999999999, 0.8, 0.4527918781725887), (0.3999999999999999, 0.8, 0.46497461928934025), (0.3999999999999999, 0.8, 0.4771573604060913), (0.3999999999999999, 0.8, 0.48934010152284235), (0.3999999999999999, 0.8, 0.5015228426395939), (0.3999999999999999, 0.8, 0.513705583756345), (0.3999999999999999, 0.8, 0.5258883248730966), (0.3999999999999999, 0.8, 0.5380710659898476), (0.3999999999999999, 0.8, 0.5502538071065992), (0.3999999999999999, 0.8, 0.5624365482233502), (0.3999999999999999, 0.8, 0.5746192893401012), (0.3999999999999999, 0.8, 0.5868020304568529), (0.3999999999999999, 0.8, 0.5989847715736039), (0.3999999999999999, 0.8, 0.6111675126903554), (0.3999999999999999, 0.8, 0.6233502538071065), (0.3999999999999999, 0.8, 0.6355329949238581), (0.3999999999999999, 0.8, 0.6477157360406092), (0.3999999999999999, 0.8, 0.6598984771573602), (0.3999999999999999, 0.8, 0.6720812182741118), (0.3999999999999999, 0.8, 0.6842639593908628), (0.3999999999999999, 0.8, 0.6964467005076144), (0.3999999999999999, 0.8, 0.7086294416243655), (0.3999999999999999, 0.8, 0.7208121827411169), (0.3999999999999999, 0.8, 0.732994923857868), (0.3999999999999999, 0.8, 0.7451776649746191), (0.3999999999999999, 0.8, 0.7573604060913706), (0.3999999999999999, 0.8, 0.7695431472081217), (0.3999999999999999, 0.8, 0.7817258883248732), (0.3999999999999999, 0.8, 0.7939086294416242), (0.3999999999999999, 0.7939086294416242, 0.8), (0.3999999999999999, 0.7817258883248732, 0.8), (0.3999999999999999, 0.7695431472081221, 0.8), (0.3999999999999999, 0.7573604060913706, 0.8), (0.3999999999999999, 0.7451776649746189, 0.8), (0.3999999999999999, 0.7329949238578684, 0.8), (0.3999999999999999, 0.7208121827411169, 0.8), (0.3999999999999999, 0.7086294416243653, 0.8), (0.3999999999999999, 0.6964467005076143, 0.8), (0.3999999999999999, 0.6842639593908633, 0.8), (0.3999999999999999, 0.6720812182741116, 0.8), (0.3999999999999999, 0.65989847715736, 0.8), (0.3999999999999999, 0.6477157360406095, 0.8), (0.3999999999999999, 0.635532994923858, 0.8), (0.3999999999999999, 0.6233502538071064, 0.8), (0.3999999999999999, 0.6111675126903553, 0.8), (0.3999999999999999, 0.5989847715736043, 0.8), (0.3999999999999999, 0.5868020304568526, 0.8), (0.3999999999999999, 0.5746192893401011, 0.8), (0.3999999999999999, 0.5624365482233507, 0.8), (0.3999999999999999, 0.550253807106599, 0.8), (0.3999999999999999, 0.5380710659898474, 0.8), (0.3999999999999999, 0.5258883248730964, 0.8), (0.3999999999999999, 0.5137055837563453, 0.8), (0.3999999999999999, 0.5015228426395938, 0.8), (0.3999999999999999, 0.48934010152284224, 0.8), (0.3999999999999999, 0.4771573604060917, 0.8), (0.3999999999999999, 0.46497461928934014, 0.8), (0.3999999999999999, 0.4527918781725886, 0.8), (0.3999999999999999, 0.44060913705583754, 0.8), (0.3999999999999999, 0.4284263959390865, 0.8), (0.3999999999999999, 0.4162436548223349, 0.8), (0.3999999999999999, 0.40406091370558334, 0.8), (0.40812182741116676, 0.3999999999999999, 0.8), (0.4203045685279183, 0.3999999999999999, 0.8), (0.4324873096446699, 0.3999999999999999, 0.8), (0.44467005076142097, 0.3999999999999999, 0.8), (0.45685279187817196, 0.3999999999999999, 0.8), (0.46903553299492357, 0.3999999999999999, 0.8), (0.4812182741116751, 0.3999999999999999, 0.8), (0.4934010152284256, 0.3999999999999999, 0.8), (0.5055837563451773, 0.3999999999999999, 0.8), (0.5177664974619288, 0.3999999999999999, 0.8), (0.5299492385786798, 0.3999999999999999, 0.8), (0.5421319796954309, 0.3999999999999999, 0.8), (0.5543147208121825, 0.3999999999999999, 0.8), (0.566497461928934, 0.3999999999999999, 0.8), (0.5786802030456846, 0.3999999999999999, 0.8), (0.5908629441624361, 0.3999999999999999, 0.8), (0.6030456852791877, 0.3999999999999999, 0.8), (0.6152284263959388, 0.3999999999999999, 0.8), (0.6274111675126898, 0.3999999999999999, 0.8), (0.6395939086294413, 0.3999999999999999, 0.8), (0.651776649746193, 0.3999999999999999, 0.8), (0.6639593908629435, 0.3999999999999999, 0.8), (0.676142131979695, 0.3999999999999999, 0.8), (0.6883248730964466, 0.3999999999999999, 0.8), (0.7005076142131976, 0.3999999999999999, 0.8), (0.7126903553299486, 0.3999999999999999, 0.8), (0.7248730964467003, 0.3999999999999999, 0.8), (0.7370558375634518, 0.3999999999999999, 0.8), (0.7492385786802029, 0.3999999999999999, 0.8), (0.7614213197969539, 0.3999999999999999, 0.8), (0.7736040609137055, 0.3999999999999999, 0.8), (0.7857868020304566, 0.3999999999999999, 0.8), (0.7979695431472076, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7898477157360404), (0.8, 0.3999999999999999, 0.777664974619289), (0.8, 0.3999999999999999, 0.7654822335025379), (0.8, 0.3999999999999999, 0.7532994923857868), (0.8, 0.3999999999999999, 0.7411167512690353), (0.8, 0.3999999999999999, 0.7289340101522842), (0.8, 0.3999999999999999, 0.7167512690355331), (0.8, 0.3999999999999999, 0.7045685279187817), (0.8, 0.3999999999999999, 0.69238578680203), (0.8, 0.3999999999999999, 0.680203045685279), (0.8, 0.3999999999999999, 0.668020304568528), (0.8, 0.3999999999999999, 0.6558375634517764), (0.8, 0.3999999999999999, 0.6436548223350254), (0.8, 0.3999999999999999, 0.6314720812182743), (0.8, 0.3999999999999999, 0.6192893401015227), (0.8, 0.3999999999999999, 0.6071065989847712), (0.8, 0.3999999999999999, 0.59492385786802), (0.8, 0.3999999999999999, 0.582741116751269), (0.8, 0.3999999999999999, 0.5705583756345174), (0.8, 0.3999999999999999, 0.5583756345177664), (0.8, 0.3999999999999999, 0.5461928934010154), (0.8, 0.3999999999999999, 0.5340101522842637), (0.8, 0.3999999999999999, 0.5218274111675122), (0.8, 0.3999999999999999, 0.5096446700507612), (0.8, 0.3999999999999999, 0.49746192893401014), (0.8, 0.3999999999999999, 0.48527918781725854), (0.8, 0.3999999999999999, 0.4730964467005075), (0.8, 0.3999999999999999, 0.46091370558375644), (0.8, 0.3999999999999999, 0.4487309644670049), (0.8, 0.3999999999999999, 0.4365482233502533), (0.8, 0.3999999999999999, 0.42436548223350223), (0.8, 0.3999999999999999, 0.41218274111675124)],
    198: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41212121212121183, 0.3999999999999999), (0.8, 0.4242424242424243, 0.3999999999999999), (0.8, 0.43636363636363623, 0.3999999999999999), (0.8, 0.4484848484848482, 0.3999999999999999), (0.8, 0.4606060606060607, 0.3999999999999999), (0.8, 0.4727272727272726, 0.3999999999999999), (0.8, 0.4848484848484851, 0.3999999999999999), (0.8, 0.496969696969697, 0.3999999999999999), (0.8, 0.5090909090909089, 0.3999999999999999), (0.8, 0.5212121212121215, 0.3999999999999999), (0.8, 0.5333333333333333, 0.3999999999999999), (0.8, 0.5454545454545453, 0.3999999999999999), (0.8, 0.5575757575757577, 0.3999999999999999), (0.8, 0.5696969696969697, 0.3999999999999999), (0.8, 0.5818181818181816, 0.3999999999999999), (0.8, 0.5939393939393941, 0.3999999999999999), (0.8, 0.6060606060606061, 0.3999999999999999), (0.8, 0.6181818181818179, 0.3999999999999999), (0.8, 0.6303030303030305, 0.3999999999999999), (0.8, 0.6424242424242423, 0.3999999999999999), (0.8, 0.6545454545454543, 0.3999999999999999), (0.8, 0.6666666666666667, 0.3999999999999999), (0.8, 0.6787878787878787, 0.3999999999999999), (0.8, 0.6909090909090907, 0.3999999999999999), (0.8, 0.7030303030303031, 0.3999999999999999), (0.8, 0.7151515151515151, 0.3999999999999999), (0.8, 0.7272727272727275, 0.3999999999999999), (0.8, 0.7393939393939395, 0.3999999999999999), (0.8, 0.7515151515151515, 0.3999999999999999), (0.8, 0.7636363636363639, 0.3999999999999999), (0.8, 0.7757575757575759, 0.3999999999999999), (0.8, 0.7878787878787878, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7878787878787881, 0.8, 0.3999999999999999), (0.7757575757575756, 0.8, 0.3999999999999999), (0.7636363636363637, 0.8, 0.3999999999999999), (0.7515151515151517, 0.8, 0.3999999999999999), (0.7393939393939393, 0.8, 0.3999999999999999), (0.7272727272727273, 0.8, 0.3999999999999999), (0.7151515151515153, 0.8, 0.3999999999999999), (0.7030303030303029, 0.8, 0.3999999999999999), (0.6909090909090909, 0.8, 0.3999999999999999), (0.6787878787878789, 0.8, 0.3999999999999999), (0.6666666666666665, 0.8, 0.3999999999999999), (0.6545454545454545, 0.8, 0.3999999999999999), (0.6424242424242427, 0.8, 0.3999999999999999), (0.6303030303030301, 0.8, 0.3999999999999999), (0.6181818181818183, 0.8, 0.3999999999999999), (0.6060606060606063, 0.8, 0.3999999999999999), (0.5939393939393939, 0.8, 0.3999999999999999), (0.5818181818181819, 0.8, 0.3999999999999999), (0.5696969696969699, 0.8, 0.3999999999999999), (0.5575757575757575, 0.8, 0.3999999999999999), (0.5454545454545455, 0.8, 0.3999999999999999), (0.5333333333333337, 0.8, 0.3999999999999999), (0.5212121212121211, 0.8, 0.3999999999999999), (0.5090909090909093, 0.8, 0.3999999999999999), (0.4969696969696973, 0.8, 0.3999999999999999), (0.4848484848484848, 0.8, 0.3999999999999999), (0.4727272727272729, 0.8, 0.3999999999999999), (0.4606060606060604, 0.8, 0.3999999999999999), (0.4484848484848485, 0.8, 0.3999999999999999), (0.436363636363636, 0.8, 0.3999999999999999), (0.42424242424242403, 0.8, 0.3999999999999999), (0.4121212121212121, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4000000000000003), (0.3999999999999999, 0.8, 0.4121212121212122), (0.3999999999999999, 0.8, 0.4242424242424242), (0.3999999999999999, 0.8, 0.4363636363636367), (0.3999999999999999, 0.8, 0.4484848484848486), (0.3999999999999999, 0.8, 0.4606060606060605), (0.3999999999999999, 0.8, 0.472727272727273), (0.3999999999999999, 0.8, 0.4848484848484849), (0.3999999999999999, 0.8, 0.4969696969696969), (0.3999999999999999, 0.8, 0.5090909090909094), (0.3999999999999999, 0.8, 0.5212121212121212), (0.3999999999999999, 0.8, 0.5333333333333332), (0.3999999999999999, 0.8, 0.5454545454545456), (0.3999999999999999, 0.8, 0.5575757575757576), (0.3999999999999999, 0.8, 0.5696969696969696), (0.3999999999999999, 0.8, 0.581818181818182), (0.3999999999999999, 0.8, 0.593939393939394), (0.3999999999999999, 0.8, 0.6060606060606059), (0.3999999999999999, 0.8, 0.6181818181818184), (0.3999999999999999, 0.8, 0.6303030303030304), (0.3999999999999999, 0.8, 0.6424242424242422), (0.3999999999999999, 0.8, 0.6545454545454548), (0.3999999999999999, 0.8, 0.6666666666666667), (0.3999999999999999, 0.8, 0.6787878787878792), (0.3999999999999999, 0.8, 0.6909090909090911), (0.3999999999999999, 0.8, 0.703030303030303), (0.3999999999999999, 0.8, 0.7151515151515155), (0.3999999999999999, 0.8, 0.7272727272727274), (0.3999999999999999, 0.8, 0.7393939393939399), (0.3999999999999999, 0.8, 0.7515151515151518), (0.3999999999999999, 0.8, 0.7636363636363638), (0.3999999999999999, 0.8, 0.7757575757575763), (0.3999999999999999, 0.8, 0.7878787878787881), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7878787878787874, 0.8), (0.3999999999999999, 0.7757575757575756, 0.8), (0.3999999999999999, 0.7636363636363637, 0.8), (0.3999999999999999, 0.7515151515151511, 0.8), (0.3999999999999999, 0.7393939393939393, 0.8), (0.3999999999999999, 0.7272727272727273, 0.8), (0.3999999999999999, 0.7151515151515149, 0.8), (0.3999999999999999, 0.7030303030303029, 0.8), (0.3999999999999999, 0.6909090909090909, 0.8), (0.3999999999999999, 0.6787878787878785, 0.8), (0.3999999999999999, 0.6666666666666665, 0.8), (0.3999999999999999, 0.6545454545454545, 0.8), (0.3999999999999999, 0.6424242424242421, 0.8), (0.3999999999999999, 0.6303030303030301, 0.8), (0.3999999999999999, 0.6181818181818183, 0.8), (0.3999999999999999, 0.6060606060606057, 0.8), (0.3999999999999999, 0.5939393939393939, 0.8), (0.3999999999999999, 0.5818181818181819, 0.8), (0.3999999999999999, 0.5696969696969694, 0.8), (0.3999999999999999, 0.557575757575757, 0.8), (0.3999999999999999, 0.5454545454545455, 0.8), (0.3999999999999999, 0.5333333333333331, 0.8), (0.3999999999999999, 0.5212121212121206, 0.8), (0.3999999999999999, 0.5090909090909093, 0.8), (0.3999999999999999, 0.49696969696969673, 0.8), (0.3999999999999999, 0.48484848484848425, 0.8), (0.3999999999999999, 0.47272727272727233, 0.8), (0.3999999999999999, 0.4606060606060604, 0.8), (0.3999999999999999, 0.44848484848484793, 0.8), (0.3999999999999999, 0.436363636363636, 0.8), (0.3999999999999999, 0.42424242424242403, 0.8), (0.3999999999999999, 0.41212121212121156, 0.8), (0.3999999999999999, 0.3999999999999999, 0.8), (0.41212121212121183, 0.3999999999999999, 0.8), (0.4242424242424243, 0.3999999999999999, 0.8), (0.43636363636363623, 0.3999999999999999, 0.8), (0.4484848484848482, 0.3999999999999999, 0.8), (0.4606060606060607, 0.3999999999999999, 0.8), (0.4727272727272726, 0.3999999999999999, 0.8), (0.48484848484848453, 0.3999999999999999, 0.8), (0.496969696969697, 0.3999999999999999, 0.8), (0.5090909090909089, 0.3999999999999999, 0.8), (0.5212121212121209, 0.3999999999999999, 0.8), (0.5333333333333333, 0.3999999999999999, 0.8), (0.5454545454545453, 0.3999999999999999, 0.8), (0.5575757575757572, 0.3999999999999999, 0.8), (0.5696969696969697, 0.3999999999999999, 0.8), (0.5818181818181822, 0.3999999999999999, 0.8), (0.5939393939393935, 0.3999999999999999, 0.8), (0.6060606060606061, 0.3999999999999999, 0.8), (0.6181818181818185, 0.3999999999999999, 0.8), (0.6303030303030299, 0.3999999999999999, 0.8), (0.6424242424242423, 0.3999999999999999, 0.8), (0.6545454545454549, 0.3999999999999999, 0.8), (0.6666666666666663, 0.3999999999999999, 0.8), (0.6787878787878787, 0.3999999999999999, 0.8), (0.6909090909090911, 0.3999999999999999, 0.8), (0.7030303030303031, 0.3999999999999999, 0.8), (0.7151515151515151, 0.3999999999999999, 0.8), (0.7272727272727275, 0.3999999999999999, 0.8), (0.7393939393939395, 0.3999999999999999, 0.8), (0.7515151515151515, 0.3999999999999999, 0.8), (0.7636363636363639, 0.3999999999999999, 0.8), (0.7757575757575759, 0.3999999999999999, 0.8), (0.7878787878787878, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7878787878787874), (0.8, 0.3999999999999999, 0.7757575757575756), (0.8, 0.3999999999999999, 0.7636363636363631), (0.8, 0.3999999999999999, 0.7515151515151511), (0.8, 0.3999999999999999, 0.7393939393939393), (0.8, 0.3999999999999999, 0.7272727272727267), (0.8, 0.3999999999999999, 0.7151515151515149), (0.8, 0.3999999999999999, 0.7030303030303029), (0.8, 0.3999999999999999, 0.6909090909090905), (0.8, 0.3999999999999999, 0.6787878787878785), (0.8, 0.3999999999999999, 0.6666666666666665), (0.8, 0.3999999999999999, 0.6545454545454541), (0.8, 0.3999999999999999, 0.6424242424242416), (0.8, 0.3999999999999999, 0.6303030303030301), (0.8, 0.3999999999999999, 0.6181818181818177), (0.8, 0.3999999999999999, 0.6060606060606052), (0.8, 0.3999999999999999, 0.5939393939393939), (0.8, 0.3999999999999999, 0.5818181818181813), (0.8, 0.3999999999999999, 0.5696969696969689), (0.8, 0.3999999999999999, 0.557575757575757), (0.8, 0.3999999999999999, 0.545454545454545), (0.8, 0.3999999999999999, 0.5333333333333325), (0.8, 0.3999999999999999, 0.5212121212121206), (0.8, 0.3999999999999999, 0.5090909090909087), (0.8, 0.3999999999999999, 0.49696969696969623), (0.8, 0.3999999999999999, 0.48484848484848425), (0.8, 0.3999999999999999, 0.47272727272727233), (0.8, 0.3999999999999999, 0.46060606060605985), (0.8, 0.3999999999999999, 0.44848484848484793), (0.8, 0.3999999999999999, 0.436363636363636), (0.8, 0.3999999999999999, 0.42424242424242353), (0.8, 0.3999999999999999, 0.41212121212121156)],
    199: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41206030150753736, 0.3999999999999999), (0.8, 0.42412060301507537, 0.3999999999999999), (0.8, 0.4361809045226129, 0.3999999999999999), (0.8, 0.4482412060301509, 0.3999999999999999), (0.8, 0.4603015075376884, 0.3999999999999999), (0.8, 0.47236180904522584, 0.3999999999999999), (0.8, 0.48442211055276385, 0.3999999999999999), (0.8, 0.49648241206030136, 0.3999999999999999), (0.8, 0.5085427135678393, 0.3999999999999999), (0.8, 0.5206030150753769, 0.3999999999999999), (0.8, 0.5326633165829143, 0.3999999999999999), (0.8, 0.5447236180904523, 0.3999999999999999), (0.8, 0.5567839195979898, 0.3999999999999999), (0.8, 0.5688442211055278, 0.3999999999999999), (0.8, 0.5809045226130652, 0.3999999999999999), (0.8, 0.5929648241206028, 0.3999999999999999), (0.8, 0.6050251256281408, 0.3999999999999999), (0.8, 0.6170854271356783, 0.3999999999999999), (0.8, 0.6291457286432163, 0.3999999999999999), (0.8, 0.6412060301507537, 0.3999999999999999), (0.8, 0.6532663316582912, 0.3999999999999999), (0.8, 0.6653266331658292, 0.3999999999999999), (0.8, 0.6773869346733667, 0.3999999999999999), (0.8, 0.6894472361809048, 0.3999999999999999), (0.8, 0.7015075376884422, 0.3999999999999999), (0.8, 0.7135678391959797, 0.3999999999999999), (0.8, 0.7256281407035177, 0.3999999999999999), (0.8, 0.7376884422110552, 0.3999999999999999), (0.8, 0.7497487437185932, 0.3999999999999999), (0.8, 0.7618090452261306, 0.3999999999999999), (0.8, 0.7738693467336681, 0.3999999999999999), (0.8, 0.7859296482412061, 0.3999999999999999), (0.8, 0.7979899497487437, 0.3999999999999999), (0.7899497487437186, 0.8, 0.3999999999999999), (0.777889447236181, 0.8, 0.3999999999999999), (0.7658291457286436, 0.8, 0.3999999999999999), (0.7537688442211056, 0.8, 0.3999999999999999), (0.7417085427135681, 0.8, 0.3999999999999999), (0.7296482412060301, 0.8, 0.3999999999999999), (0.7175879396984925, 0.8, 0.3999999999999999), (0.7055276381909552, 0.8, 0.3999999999999999), (0.6934673366834172, 0.8, 0.3999999999999999), (0.6814070351758796, 0.8, 0.3999999999999999), (0.6693467336683416, 0.8, 0.3999999999999999), (0.6572864321608042, 0.8, 0.3999999999999999), (0.6452261306532667, 0.8, 0.3999999999999999), (0.6331658291457287, 0.8, 0.3999999999999999), (0.6211055276381912, 0.8, 0.3999999999999999), (0.6090452261306532, 0.8, 0.3999999999999999), (0.5969849246231157, 0.8, 0.3999999999999999), (0.5849246231155782, 0.8, 0.3999999999999999), (0.5728643216080402, 0.8, 0.3999999999999999), (0.5608040201005027, 0.8, 0.3999999999999999), (0.5487437185929647, 0.8, 0.3999999999999999), (0.5366834170854272, 0.8, 0.3999999999999999), (0.5246231155778898, 0.8, 0.3999999999999999), (0.5125628140703518, 0.8, 0.3999999999999999), (0.5005025125628143, 0.8, 0.3999999999999999), (0.48844221105527624, 0.8, 0.3999999999999999), (0.4763819095477388, 0.8, 0.3999999999999999), (0.4643216080402013, 0.8, 0.3999999999999999), (0.4522613065326633, 0.8, 0.3999999999999999), (0.4402010050251258, 0.8, 0.3999999999999999), (0.4281407035175878, 0.8, 0.3999999999999999), (0.4160804020100503, 0.8, 0.3999999999999999), (0.40402010050251286, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40804020100502514), (0.3999999999999999, 0.8, 0.4201005025125626), (0.3999999999999999, 0.8, 0.4321608040201006), (0.3999999999999999, 0.8, 0.4442211055276381), (0.3999999999999999, 0.8, 0.45628140703517556), (0.3999999999999999, 0.8, 0.46834170854271356), (0.3999999999999999, 0.8, 0.48040201005025107), (0.3999999999999999, 0.8, 0.4924623115577891), (0.3999999999999999, 0.8, 0.5045226130653265), (0.3999999999999999, 0.8, 0.516582914572864), (0.3999999999999999, 0.8, 0.528643216080402), (0.3999999999999999, 0.8, 0.54070351758794), (0.3999999999999999, 0.8, 0.5527638190954776), (0.3999999999999999, 0.8, 0.564824120603015), (0.3999999999999999, 0.8, 0.5768844221105525), (0.3999999999999999, 0.8, 0.5889447236180905), (0.3999999999999999, 0.8, 0.6010050251256285), (0.3999999999999999, 0.8, 0.613065326633166), (0.3999999999999999, 0.8, 0.6251256281407035), (0.3999999999999999, 0.8, 0.637185929648241), (0.3999999999999999, 0.8, 0.649246231155779), (0.3999999999999999, 0.8, 0.661306532663317), (0.3999999999999999, 0.8, 0.6733668341708545), (0.3999999999999999, 0.8, 0.6854271356783919), (0.3999999999999999, 0.8, 0.6974874371859294), (0.3999999999999999, 0.8, 0.7095477386934674), (0.3999999999999999, 0.8, 0.7216080402010054), (0.3999999999999999, 0.8, 0.7336683417085429), (0.3999999999999999, 0.8, 0.7457286432160803), (0.3999999999999999, 0.8, 0.7577889447236179), (0.3999999999999999, 0.8, 0.7698492462311559), (0.3999999999999999, 0.8, 0.7819095477386939), (0.3999999999999999, 0.8, 0.7939698492462313), (0.3999999999999999, 0.7939698492462313, 0.8), (0.3999999999999999, 0.7819095477386937, 0.8), (0.3999999999999999, 0.7698492462311557, 0.8), (0.3999999999999999, 0.7577889447236177, 0.8), (0.3999999999999999, 0.7457286432160802, 0.8), (0.3999999999999999, 0.7336683417085428, 0.8), (0.3999999999999999, 0.7216080402010052, 0.8), (0.3999999999999999, 0.7095477386934672, 0.8), (0.3999999999999999, 0.6974874371859292, 0.8), (0.3999999999999999, 0.6854271356783919, 0.8), (0.3999999999999999, 0.6733668341708543, 0.8), (0.3999999999999999, 0.6613065326633168, 0.8), (0.3999999999999999, 0.6492462311557788, 0.8), (0.3999999999999999, 0.6371859296482408, 0.8), (0.3999999999999999, 0.6251256281407034, 0.8), (0.3999999999999999, 0.6130653266331658, 0.8), (0.3999999999999999, 0.6010050251256284, 0.8), (0.3999999999999999, 0.5889447236180904, 0.8), (0.3999999999999999, 0.5768844221105524, 0.8), (0.3999999999999999, 0.5648241206030149, 0.8), (0.3999999999999999, 0.5527638190954773, 0.8), (0.3999999999999999, 0.5407035175879399, 0.8), (0.3999999999999999, 0.5286432160804019, 0.8), (0.3999999999999999, 0.5165829145728639, 0.8), (0.3999999999999999, 0.5045226130653264, 0.8), (0.3999999999999999, 0.49246231155778897, 0.8), (0.3999999999999999, 0.48040201005025146, 0.8), (0.3999999999999999, 0.46834170854271345, 0.8), (0.3999999999999999, 0.45628140703517545, 0.8), (0.3999999999999999, 0.44422110552763794, 0.8), (0.3999999999999999, 0.4321608040201005, 0.8), (0.3999999999999999, 0.420100502512563, 0.8), (0.3999999999999999, 0.40804020100502497, 0.8), (0.4040201005025126, 0.3999999999999999, 0.8), (0.41608040201005003, 0.3999999999999999, 0.8), (0.42814070351758754, 0.3999999999999999, 0.8), (0.440201005025125, 0.3999999999999999, 0.8), (0.45226130653266305, 0.3999999999999999, 0.8), (0.46432160804020106, 0.3999999999999999, 0.8), (0.4763819095477385, 0.3999999999999999, 0.8), (0.48844221105527597, 0.3999999999999999, 0.8), (0.5005025125628135, 0.3999999999999999, 0.8), (0.5125628140703515, 0.3999999999999999, 0.8), (0.5246231155778895, 0.3999999999999999, 0.8), (0.536683417085427, 0.3999999999999999, 0.8), (0.5487437185929644, 0.3999999999999999, 0.8), (0.5608040201005019, 0.3999999999999999, 0.8), (0.5728643216080399, 0.3999999999999999, 0.8), (0.584924623115578, 0.3999999999999999, 0.8), (0.5969849246231155, 0.3999999999999999, 0.8), (0.6090452261306529, 0.3999999999999999, 0.8), (0.6211055276381909, 0.3999999999999999, 0.8), (0.6331658291457284, 0.3999999999999999, 0.8), (0.6452261306532664, 0.3999999999999999, 0.8), (0.6572864321608038, 0.3999999999999999, 0.8), (0.6693467336683414, 0.3999999999999999, 0.8), (0.6814070351758794, 0.3999999999999999, 0.8), (0.6934673366834169, 0.3999999999999999, 0.8), (0.7055276381909549, 0.3999999999999999, 0.8), (0.7175879396984923, 0.3999999999999999, 0.8), (0.7296482412060299, 0.3999999999999999, 0.8), (0.7417085427135679, 0.3999999999999999, 0.8), (0.7537688442211052, 0.3999999999999999, 0.8), (0.7658291457286434, 0.3999999999999999, 0.8), (0.7778894472361808, 0.3999999999999999, 0.8), (0.7899497487437184, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7979899497487433), (0.8, 0.3999999999999999, 0.7859296482412059), (0.8, 0.3999999999999999, 0.7738693467336679), (0.8, 0.3999999999999999, 0.7618090452261304), (0.8, 0.3999999999999999, 0.7497487437185929), (0.8, 0.3999999999999999, 0.7376884422110549), (0.8, 0.3999999999999999, 0.7256281407035174), (0.8, 0.3999999999999999, 0.7135678391959794), (0.8, 0.3999999999999999, 0.7015075376884419), (0.8, 0.3999999999999999, 0.6894472361809045), (0.8, 0.3999999999999999, 0.6773869346733665), (0.8, 0.3999999999999999, 0.665326633165829), (0.8, 0.3999999999999999, 0.653266331658291), (0.8, 0.3999999999999999, 0.6412060301507535), (0.8, 0.3999999999999999, 0.629145728643216), (0.8, 0.3999999999999999, 0.617085427135678), (0.8, 0.3999999999999999, 0.6050251256281405), (0.8, 0.3999999999999999, 0.5929648241206025), (0.8, 0.3999999999999999, 0.580904522613065), (0.8, 0.3999999999999999, 0.5688442211055276), (0.8, 0.3999999999999999, 0.5567839195979896), (0.8, 0.3999999999999999, 0.544723618090452), (0.8, 0.3999999999999999, 0.532663316582914), (0.8, 0.3999999999999999, 0.5206030150753765), (0.8, 0.3999999999999999, 0.5085427135678391), (0.8, 0.3999999999999999, 0.4964824120603011), (0.8, 0.3999999999999999, 0.4844221105527636), (0.8, 0.3999999999999999, 0.47236180904522557), (0.8, 0.3999999999999999, 0.4603015075376881), (0.8, 0.3999999999999999, 0.4482412060301506), (0.8, 0.3999999999999999, 0.4361809045226126), (0.8, 0.3999999999999999, 0.4241206030150746), (0.8, 0.3999999999999999, 0.41206030150753714)],
    200: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41199999999999964, 0.3999999999999999), (0.8, 0.42399999999999993, 0.3999999999999999), (0.8, 0.43599999999999967, 0.3999999999999999), (0.8, 0.44799999999999995, 0.3999999999999999), (0.8, 0.45999999999999974, 0.3999999999999999), (0.8, 0.472, 0.3999999999999999), (0.8, 0.48399999999999976, 0.3999999999999999), (0.8, 0.49600000000000005, 0.3999999999999999), (0.8, 0.5079999999999998, 0.3999999999999999), (0.8, 0.52, 0.3999999999999999), (0.8, 0.5319999999999998, 0.3999999999999999), (0.8, 0.544, 0.3999999999999999), (0.8, 0.5559999999999998, 0.3999999999999999), (0.8, 0.5680000000000001, 0.3999999999999999), (0.8, 0.5799999999999998, 0.3999999999999999), (0.8, 0.5920000000000002, 0.3999999999999999), (0.8, 0.6039999999999999, 0.3999999999999999), (0.8, 0.6160000000000002, 0.3999999999999999), (0.8, 0.6279999999999999, 0.3999999999999999), (0.8, 0.6400000000000002, 0.3999999999999999), (0.8, 0.6519999999999999, 0.3999999999999999), (0.8, 0.6640000000000003, 0.3999999999999999), (0.8, 0.6759999999999999, 0.3999999999999999), (0.8, 0.6880000000000003, 0.3999999999999999), (0.8, 0.7, 0.3999999999999999), (0.8, 0.7119999999999997, 0.3999999999999999), (0.8, 0.724, 0.3999999999999999), (0.8, 0.7360000000000003, 0.3999999999999999), (0.8, 0.748, 0.3999999999999999), (0.8, 0.7599999999999998, 0.3999999999999999), (0.8, 0.7720000000000001, 0.3999999999999999), (0.8, 0.7839999999999998, 0.3999999999999999), (0.8, 0.796, 0.3999999999999999), (0.7920000000000003, 0.8, 0.3999999999999999), (0.78, 0.8, 0.3999999999999999), (0.7680000000000002, 0.8, 0.3999999999999999), (0.756, 0.8, 0.3999999999999999), (0.7440000000000002, 0.8, 0.3999999999999999), (0.732, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.708, 0.8, 0.3999999999999999), (0.6960000000000002, 0.8, 0.3999999999999999), (0.6839999999999999, 0.8, 0.3999999999999999), (0.6720000000000002, 0.8, 0.3999999999999999), (0.6599999999999999, 0.8, 0.3999999999999999), (0.6480000000000001, 0.8, 0.3999999999999999), (0.6359999999999999, 0.8, 0.3999999999999999), (0.6240000000000001, 0.8, 0.3999999999999999), (0.6119999999999998, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5880000000000003, 0.8, 0.3999999999999999), (0.5760000000000001, 0.8, 0.3999999999999999), (0.5639999999999997, 0.8, 0.3999999999999999), (0.552, 0.8, 0.3999999999999999), (0.5400000000000003, 0.8, 0.3999999999999999), (0.528, 0.8, 0.3999999999999999), (0.5159999999999997, 0.8, 0.3999999999999999), (0.504, 0.8, 0.3999999999999999), (0.4920000000000002, 0.8, 0.3999999999999999), (0.4799999999999999, 0.8, 0.3999999999999999), (0.4680000000000002, 0.8, 0.3999999999999999), (0.4559999999999999, 0.8, 0.3999999999999999), (0.4440000000000002, 0.8, 0.3999999999999999), (0.4319999999999999, 0.8, 0.3999999999999999), (0.4200000000000001, 0.8, 0.3999999999999999), (0.4079999999999998, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40399999999999986), (0.3999999999999999, 0.8, 0.41600000000000015), (0.3999999999999999, 0.8, 0.4279999999999999), (0.3999999999999999, 0.8, 0.44000000000000017), (0.3999999999999999, 0.8, 0.45199999999999996), (0.3999999999999999, 0.8, 0.4639999999999997), (0.3999999999999999, 0.8, 0.476), (0.3999999999999999, 0.8, 0.4880000000000002), (0.3999999999999999, 0.8, 0.5), (0.3999999999999999, 0.8, 0.5119999999999998), (0.3999999999999999, 0.8, 0.524), (0.3999999999999999, 0.8, 0.5360000000000003), (0.3999999999999999, 0.8, 0.548), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5720000000000001), (0.3999999999999999, 0.8, 0.5840000000000003), (0.3999999999999999, 0.8, 0.5960000000000001), (0.3999999999999999, 0.8, 0.6079999999999999), (0.3999999999999999, 0.8, 0.6200000000000001), (0.3999999999999999, 0.8, 0.6319999999999999), (0.3999999999999999, 0.8, 0.6440000000000001), (0.3999999999999999, 0.8, 0.6559999999999999), (0.3999999999999999, 0.8, 0.6680000000000001), (0.3999999999999999, 0.8, 0.6799999999999999), (0.3999999999999999, 0.8, 0.6920000000000002), (0.3999999999999999, 0.8, 0.704), (0.3999999999999999, 0.8, 0.7160000000000002), (0.3999999999999999, 0.8, 0.728), (0.3999999999999999, 0.8, 0.7400000000000002), (0.3999999999999999, 0.8, 0.752), (0.3999999999999999, 0.8, 0.7639999999999998), (0.3999999999999999, 0.8, 0.776), (0.3999999999999999, 0.8, 0.7880000000000003), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7880000000000003, 0.8), (0.3999999999999999, 0.776, 0.8), (0.3999999999999999, 0.7639999999999997, 0.8), (0.3999999999999999, 0.7519999999999999, 0.8), (0.3999999999999999, 0.7400000000000002, 0.8), (0.3999999999999999, 0.7279999999999999, 0.8), (0.3999999999999999, 0.7159999999999995, 0.8), (0.3999999999999999, 0.7039999999999998, 0.8), (0.3999999999999999, 0.6920000000000002, 0.8), (0.3999999999999999, 0.6799999999999998, 0.8), (0.3999999999999999, 0.6679999999999995, 0.8), (0.3999999999999999, 0.6559999999999998, 0.8), (0.3999999999999999, 0.644, 0.8), (0.3999999999999999, 0.6319999999999998, 0.8), (0.3999999999999999, 0.6199999999999994, 0.8), (0.3999999999999999, 0.6079999999999998, 0.8), (0.3999999999999999, 0.596, 0.8), (0.3999999999999999, 0.5840000000000003, 0.8), (0.3999999999999999, 0.572, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5479999999999999, 0.8), (0.3999999999999999, 0.5360000000000001, 0.8), (0.3999999999999999, 0.5239999999999999, 0.8), (0.3999999999999999, 0.5119999999999996, 0.8), (0.3999999999999999, 0.49999999999999983, 0.8), (0.3999999999999999, 0.4880000000000001, 0.8), (0.3999999999999999, 0.4759999999999998, 0.8), (0.3999999999999999, 0.4639999999999995, 0.8), (0.3999999999999999, 0.4519999999999998, 0.8), (0.3999999999999999, 0.44000000000000006, 0.8), (0.3999999999999999, 0.42799999999999977, 0.8), (0.3999999999999999, 0.4159999999999995, 0.8), (0.3999999999999999, 0.40399999999999975, 0.8), (0.4079999999999996, 0.3999999999999999, 0.8), (0.4199999999999998, 0.3999999999999999, 0.8), (0.4320000000000001, 0.3999999999999999, 0.8), (0.4439999999999999, 0.3999999999999999, 0.8), (0.45599999999999963, 0.3999999999999999, 0.8), (0.4679999999999999, 0.3999999999999999, 0.8), (0.4800000000000002, 0.3999999999999999, 0.8), (0.49199999999999994, 0.3999999999999999, 0.8), (0.5039999999999997, 0.3999999999999999, 0.8), (0.5159999999999995, 0.3999999999999999, 0.8), (0.5279999999999997, 0.3999999999999999, 0.8), (0.54, 0.3999999999999999, 0.8), (0.5519999999999997, 0.3999999999999999, 0.8), (0.5639999999999995, 0.3999999999999999, 0.8), (0.5759999999999997, 0.3999999999999999, 0.8), (0.5880000000000001, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6119999999999995, 0.3999999999999999, 0.8), (0.6239999999999999, 0.3999999999999999, 0.8), (0.6360000000000001, 0.3999999999999999, 0.8), (0.6479999999999999, 0.3999999999999999, 0.8), (0.6599999999999996, 0.3999999999999999, 0.8), (0.6719999999999999, 0.3999999999999999, 0.8), (0.6840000000000002, 0.3999999999999999, 0.8), (0.696, 0.3999999999999999, 0.8), (0.7079999999999997, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7320000000000002, 0.3999999999999999, 0.8), (0.744, 0.3999999999999999, 0.8), (0.7559999999999998, 0.3999999999999999, 0.8), (0.768, 0.3999999999999999, 0.8), (0.7800000000000002, 0.3999999999999999, 0.8), (0.792, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7959999999999998), (0.8, 0.3999999999999999, 0.784), (0.8, 0.3999999999999999, 0.7719999999999998), (0.8, 0.3999999999999999, 0.7599999999999996), (0.8, 0.3999999999999999, 0.7479999999999998), (0.8, 0.3999999999999999, 0.736), (0.8, 0.3999999999999999, 0.7239999999999998), (0.8, 0.3999999999999999, 0.7119999999999995), (0.8, 0.3999999999999999, 0.6999999999999997), (0.8, 0.3999999999999999, 0.688), (0.8, 0.3999999999999999, 0.6759999999999997), (0.8, 0.3999999999999999, 0.6639999999999995), (0.8, 0.3999999999999999, 0.6519999999999997), (0.8, 0.3999999999999999, 0.6399999999999999), (0.8, 0.3999999999999999, 0.6279999999999997), (0.8, 0.3999999999999999, 0.6159999999999994), (0.8, 0.3999999999999999, 0.6039999999999996), (0.8, 0.3999999999999999, 0.5919999999999999), (0.8, 0.3999999999999999, 0.5799999999999996), (0.8, 0.3999999999999999, 0.5679999999999993), (0.8, 0.3999999999999999, 0.5559999999999996), (0.8, 0.3999999999999999, 0.5439999999999998), (0.8, 0.3999999999999999, 0.5319999999999996), (0.8, 0.3999999999999999, 0.5199999999999992), (0.8, 0.3999999999999999, 0.5079999999999996), (0.8, 0.3999999999999999, 0.4959999999999998), (0.8, 0.3999999999999999, 0.484), (0.8, 0.3999999999999999, 0.47199999999999975), (0.8, 0.3999999999999999, 0.45999999999999946), (0.8, 0.3999999999999999, 0.44799999999999973), (0.8, 0.3999999999999999, 0.43599999999999994), (0.8, 0.3999999999999999, 0.42399999999999965), (0.8, 0.3999999999999999, 0.41199999999999937)],
    201: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41194029850746283, 0.3999999999999999), (0.8, 0.4238805970149252, 0.3999999999999999), (0.8, 0.43582089552238806, 0.3999999999999999), (0.8, 0.4477611940298505, 0.3999999999999999), (0.8, 0.45970149253731335, 0.3999999999999999), (0.8, 0.47164179104477627, 0.3999999999999999), (0.8, 0.48358208955223864, 0.3999999999999999), (0.8, 0.49552238805970156, 0.3999999999999999), (0.8, 0.5074626865671639, 0.3999999999999999), (0.8, 0.5194029850746268, 0.3999999999999999), (0.8, 0.5313432835820897, 0.3999999999999999), (0.8, 0.5432835820895521, 0.3999999999999999), (0.8, 0.555223880597015, 0.3999999999999999), (0.8, 0.5671641791044774, 0.3999999999999999), (0.8, 0.5791044776119403, 0.3999999999999999), (0.8, 0.5910447761194032, 0.3999999999999999), (0.8, 0.6029850746268656, 0.3999999999999999), (0.8, 0.6149253731343285, 0.3999999999999999), (0.8, 0.6268656716417909, 0.3999999999999999), (0.8, 0.6388059701492537, 0.3999999999999999), (0.8, 0.6507462686567166, 0.3999999999999999), (0.8, 0.6626865671641791, 0.3999999999999999), (0.8, 0.6746268656716419, 0.3999999999999999), (0.8, 0.6865671641791042, 0.3999999999999999), (0.8, 0.6985074626865672, 0.3999999999999999), (0.8, 0.7104477611940301, 0.3999999999999999), (0.8, 0.7223880597014924, 0.3999999999999999), (0.8, 0.7343283582089553, 0.3999999999999999), (0.8, 0.7462686567164176, 0.3999999999999999), (0.8, 0.7582089552238807, 0.3999999999999999), (0.8, 0.7701492537313435, 0.3999999999999999), (0.8, 0.7820895522388058, 0.3999999999999999), (0.8, 0.7940298507462689, 0.3999999999999999), (0.7940298507462691, 0.8, 0.3999999999999999), (0.782089552238806, 0.8, 0.3999999999999999), (0.7701492537313432, 0.8, 0.3999999999999999), (0.7582089552238809, 0.8, 0.3999999999999999), (0.746268656716418, 0.8, 0.3999999999999999), (0.7343283582089556, 0.8, 0.3999999999999999), (0.7223880597014927, 0.8, 0.3999999999999999), (0.7104477611940299, 0.8, 0.3999999999999999), (0.6985074626865675, 0.8, 0.3999999999999999), (0.6865671641791045, 0.8, 0.3999999999999999), (0.6746268656716421, 0.8, 0.3999999999999999), (0.6626865671641793, 0.8, 0.3999999999999999), (0.6507462686567164, 0.8, 0.3999999999999999), (0.638805970149254, 0.8, 0.3999999999999999), (0.6268656716417911, 0.8, 0.3999999999999999), (0.6149253731343287, 0.8, 0.3999999999999999), (0.6029850746268658, 0.8, 0.3999999999999999), (0.5910447761194029, 0.8, 0.3999999999999999), (0.5791044776119405, 0.8, 0.3999999999999999), (0.5671641791044776, 0.8, 0.3999999999999999), (0.5552238805970152, 0.8, 0.3999999999999999), (0.5432835820895523, 0.8, 0.3999999999999999), (0.5313432835820895, 0.8, 0.3999999999999999), (0.5194029850746271, 0.8, 0.3999999999999999), (0.5074626865671642, 0.8, 0.3999999999999999), (0.4955223880597018, 0.8, 0.3999999999999999), (0.4835820895522389, 0.8, 0.3999999999999999), (0.471641791044776, 0.8, 0.3999999999999999), (0.4597014925373136, 0.8, 0.3999999999999999), (0.4477611940298507, 0.8, 0.3999999999999999), (0.43582089552238834, 0.8, 0.3999999999999999), (0.4238805970149254, 0.8, 0.3999999999999999), (0.41194029850746255, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.41194029850746267), (0.3999999999999999, 0.8, 0.42388059701492503), (0.3999999999999999, 0.8, 0.43582089552238795), (0.3999999999999999, 0.8, 0.4477611940298509), (0.3999999999999999, 0.8, 0.45970149253731324), (0.3999999999999999, 0.8, 0.4716417910447761), (0.3999999999999999, 0.8, 0.48358208955223847), (0.3999999999999999, 0.8, 0.4955223880597014), (0.3999999999999999, 0.8, 0.5074626865671643), (0.3999999999999999, 0.8, 0.5194029850746267), (0.3999999999999999, 0.8, 0.5313432835820896), (0.3999999999999999, 0.8, 0.543283582089552), (0.3999999999999999, 0.8, 0.5552238805970149), (0.3999999999999999, 0.8, 0.5671641791044777), (0.3999999999999999, 0.8, 0.5791044776119401), (0.3999999999999999, 0.8, 0.591044776119403), (0.3999999999999999, 0.8, 0.6029850746268653), (0.3999999999999999, 0.8, 0.6149253731343283), (0.3999999999999999, 0.8, 0.6268656716417912), (0.3999999999999999, 0.8, 0.6388059701492536), (0.3999999999999999, 0.8, 0.6507462686567165), (0.3999999999999999, 0.8, 0.6626865671641788), (0.3999999999999999, 0.8, 0.6746268656716418), (0.3999999999999999, 0.8, 0.6865671641791047), (0.3999999999999999, 0.8, 0.698507462686567), (0.3999999999999999, 0.8, 0.7104477611940299), (0.3999999999999999, 0.8, 0.7223880597014922), (0.3999999999999999, 0.8, 0.7343283582089553), (0.3999999999999999, 0.8, 0.7462686567164181), (0.3999999999999999, 0.8, 0.7582089552238804), (0.3999999999999999, 0.8, 0.7701492537313434), (0.3999999999999999, 0.8, 0.7820895522388058), (0.3999999999999999, 0.8, 0.7940298507462686), (0.3999999999999999, 0.7940298507462684, 0.8), (0.3999999999999999, 0.7820895522388056, 0.8), (0.3999999999999999, 0.7701492537313432, 0.8), (0.3999999999999999, 0.7582089552238809, 0.8), (0.3999999999999999, 0.746268656716418, 0.8), (0.3999999999999999, 0.734328358208955, 0.8), (0.3999999999999999, 0.7223880597014922, 0.8), (0.3999999999999999, 0.7104477611940299, 0.8), (0.3999999999999999, 0.6985074626865675, 0.8), (0.3999999999999999, 0.6865671641791045, 0.8), (0.3999999999999999, 0.6746268656716417, 0.8), (0.3999999999999999, 0.6626865671641787, 0.8), (0.3999999999999999, 0.6507462686567164, 0.8), (0.3999999999999999, 0.638805970149254, 0.8), (0.3999999999999999, 0.6268656716417911, 0.8), (0.3999999999999999, 0.6149253731343282, 0.8), (0.3999999999999999, 0.6029850746268652, 0.8), (0.3999999999999999, 0.5910447761194029, 0.8), (0.3999999999999999, 0.5791044776119405, 0.8), (0.3999999999999999, 0.5671641791044776, 0.8), (0.3999999999999999, 0.5552238805970147, 0.8), (0.3999999999999999, 0.5432835820895519, 0.8), (0.3999999999999999, 0.5313432835820895, 0.8), (0.3999999999999999, 0.5194029850746271, 0.8), (0.3999999999999999, 0.5074626865671642, 0.8), (0.3999999999999999, 0.4955223880597013, 0.8), (0.3999999999999999, 0.48358208955223836, 0.8), (0.3999999999999999, 0.471641791044776, 0.8), (0.3999999999999999, 0.4597014925373136, 0.8), (0.3999999999999999, 0.4477611940298507, 0.8), (0.3999999999999999, 0.43582089552238784, 0.8), (0.3999999999999999, 0.4238805970149249, 0.8), (0.3999999999999999, 0.41194029850746255, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.4119402985074623, 0.3999999999999999, 0.8), (0.4238805970149252, 0.3999999999999999, 0.8), (0.43582089552238806, 0.3999999999999999, 0.8), (0.4477611940298505, 0.3999999999999999, 0.8), (0.45970149253731285, 0.3999999999999999, 0.8), (0.4716417910447757, 0.3999999999999999, 0.8), (0.48358208955223864, 0.3999999999999999, 0.8), (0.49552238805970156, 0.3999999999999999, 0.8), (0.5074626865671639, 0.3999999999999999, 0.8), (0.5194029850746262, 0.3999999999999999, 0.8), (0.5313432835820892, 0.3999999999999999, 0.8), (0.5432835820895521, 0.3999999999999999, 0.8), (0.555223880597015, 0.3999999999999999, 0.8), (0.5671641791044774, 0.3999999999999999, 0.8), (0.5791044776119397, 0.3999999999999999, 0.8), (0.5910447761194026, 0.3999999999999999, 0.8), (0.6029850746268656, 0.3999999999999999, 0.8), (0.6149253731343285, 0.3999999999999999, 0.8), (0.6268656716417909, 0.3999999999999999, 0.8), (0.6388059701492532, 0.3999999999999999, 0.8), (0.650746268656716, 0.3999999999999999, 0.8), (0.6626865671641791, 0.3999999999999999, 0.8), (0.6746268656716419, 0.3999999999999999, 0.8), (0.6865671641791042, 0.3999999999999999, 0.8), (0.6985074626865666, 0.3999999999999999, 0.8), (0.7104477611940295, 0.3999999999999999, 0.8), (0.7223880597014924, 0.3999999999999999, 0.8), (0.7343283582089553, 0.3999999999999999, 0.8), (0.7462686567164176, 0.3999999999999999, 0.8), (0.75820895522388, 0.3999999999999999, 0.8), (0.770149253731343, 0.3999999999999999, 0.8), (0.7820895522388058, 0.3999999999999999, 0.8), (0.7940298507462689, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7940298507462684), (0.8, 0.3999999999999999, 0.782089552238806), (0.8, 0.3999999999999999, 0.7701492537313432), (0.8, 0.3999999999999999, 0.7582089552238803), (0.8, 0.3999999999999999, 0.7462686567164174), (0.8, 0.3999999999999999, 0.734328358208955), (0.8, 0.3999999999999999, 0.7223880597014927), (0.8, 0.3999999999999999, 0.7104477611940299), (0.8, 0.3999999999999999, 0.6985074626865668), (0.8, 0.3999999999999999, 0.686567164179104), (0.8, 0.3999999999999999, 0.6746268656716417), (0.8, 0.3999999999999999, 0.6626865671641793), (0.8, 0.3999999999999999, 0.6507462686567164), (0.8, 0.3999999999999999, 0.6388059701492534), (0.8, 0.3999999999999999, 0.6268656716417905), (0.8, 0.3999999999999999, 0.6149253731343282), (0.8, 0.3999999999999999, 0.6029850746268658), (0.8, 0.3999999999999999, 0.5910447761194029), (0.8, 0.3999999999999999, 0.57910447761194), (0.8, 0.3999999999999999, 0.567164179104477), (0.8, 0.3999999999999999, 0.5552238805970147), (0.8, 0.3999999999999999, 0.5432835820895523), (0.8, 0.3999999999999999, 0.5313432835820895), (0.8, 0.3999999999999999, 0.5194029850746266), (0.8, 0.3999999999999999, 0.5074626865671636), (0.8, 0.3999999999999999, 0.4955223880597013), (0.8, 0.3999999999999999, 0.4835820895522389), (0.8, 0.3999999999999999, 0.471641791044776), (0.8, 0.3999999999999999, 0.4597014925373131), (0.8, 0.3999999999999999, 0.4477611940298502), (0.8, 0.3999999999999999, 0.43582089552238784), (0.8, 0.3999999999999999, 0.4238805970149254), (0.8, 0.3999999999999999, 0.41194029850746255)],
    202: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4118811881188118, 0.3999999999999999), (0.8, 0.4237623762376237, 0.3999999999999999), (0.8, 0.4356435643564356, 0.3999999999999999), (0.8, 0.4475247524752475, 0.3999999999999999), (0.8, 0.45940594059405937, 0.3999999999999999), (0.8, 0.47128712871287126, 0.3999999999999999), (0.8, 0.48316831683168315, 0.3999999999999999), (0.8, 0.4950495049504951, 0.3999999999999999), (0.8, 0.5069306930693069, 0.3999999999999999), (0.8, 0.5188118811881188, 0.3999999999999999), (0.8, 0.5306930693069307, 0.3999999999999999), (0.8, 0.5425742574257426, 0.3999999999999999), (0.8, 0.5544554455445545, 0.3999999999999999), (0.8, 0.5663366336633664, 0.3999999999999999), (0.8, 0.5782178217821783, 0.3999999999999999), (0.8, 0.5900990099009903, 0.3999999999999999), (0.8, 0.6019801980198022, 0.3999999999999999), (0.8, 0.6138613861386141, 0.3999999999999999), (0.8, 0.625742574257426, 0.3999999999999999), (0.8, 0.6376237623762379, 0.3999999999999999), (0.8, 0.6495049504950497, 0.3999999999999999), (0.8, 0.6613861386138616, 0.3999999999999999), (0.8, 0.6732673267326735, 0.3999999999999999), (0.8, 0.6851485148514854, 0.3999999999999999), (0.8, 0.6970297029702973, 0.3999999999999999), (0.8, 0.7089108910891092, 0.3999999999999999), (0.8, 0.7207920792079211, 0.3999999999999999), (0.8, 0.732673267326733, 0.3999999999999999), (0.8, 0.7445544554455443, 0.3999999999999999), (0.8, 0.7564356435643562, 0.3999999999999999), (0.8, 0.7683168316831681, 0.3999999999999999), (0.8, 0.78019801980198, 0.3999999999999999), (0.8, 0.7920792079207919, 0.3999999999999999), (0.7960396039603963, 0.8, 0.3999999999999999), (0.7841584158415844, 0.8, 0.3999999999999999), (0.7722772277227725, 0.8, 0.3999999999999999), (0.7603960396039606, 0.8, 0.3999999999999999), (0.7485148514851487, 0.8, 0.3999999999999999), (0.7366336633663368, 0.8, 0.3999999999999999), (0.724752475247525, 0.8, 0.3999999999999999), (0.7128712871287131, 0.8, 0.3999999999999999), (0.7009900990099012, 0.8, 0.3999999999999999), (0.6891089108910893, 0.8, 0.3999999999999999), (0.6772277227722774, 0.8, 0.3999999999999999), (0.6653465346534655, 0.8, 0.3999999999999999), (0.6534653465346536, 0.8, 0.3999999999999999), (0.6415841584158417, 0.8, 0.3999999999999999), (0.6297029702970298, 0.8, 0.3999999999999999), (0.6178217821782179, 0.8, 0.3999999999999999), (0.605940594059406, 0.8, 0.3999999999999999), (0.5940594059405941, 0.8, 0.3999999999999999), (0.5821782178217823, 0.8, 0.3999999999999999), (0.5702970297029704, 0.8, 0.3999999999999999), (0.5584158415841585, 0.8, 0.3999999999999999), (0.5465346534653466, 0.8, 0.3999999999999999), (0.5346534653465347, 0.8, 0.3999999999999999), (0.5227722772277228, 0.8, 0.3999999999999999), (0.5108910891089109, 0.8, 0.3999999999999999), (0.49900990099009895, 0.8, 0.3999999999999999), (0.48712871287128706, 0.8, 0.3999999999999999), (0.47524752475247517, 0.8, 0.3999999999999999), (0.4633663366336633, 0.8, 0.3999999999999999), (0.4514851485148514, 0.8, 0.3999999999999999), (0.4396039603960395, 0.8, 0.3999999999999999), (0.42772277227722755, 0.8, 0.3999999999999999), (0.41584158415841566, 0.8, 0.3999999999999999), (0.40396039603960376, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40792079207920806), (0.3999999999999999, 0.8, 0.41980198019801995), (0.3999999999999999, 0.8, 0.43168316831683184), (0.3999999999999999, 0.8, 0.44356435643564324), (0.3999999999999999, 0.8, 0.45544554455445513), (0.3999999999999999, 0.8, 0.467326732673267), (0.3999999999999999, 0.8, 0.4792079207920789), (0.3999999999999999, 0.8, 0.4910891089108908), (0.3999999999999999, 0.8, 0.5029702970297028), (0.3999999999999999, 0.8, 0.5148514851485146), (0.3999999999999999, 0.8, 0.5267326732673265), (0.3999999999999999, 0.8, 0.5386138613861384), (0.3999999999999999, 0.8, 0.5504950495049503), (0.3999999999999999, 0.8, 0.5623762376237622), (0.3999999999999999, 0.8, 0.5742574257425741), (0.3999999999999999, 0.8, 0.586138613861386), (0.3999999999999999, 0.8, 0.5980198019801979), (0.3999999999999999, 0.8, 0.6099009900990098), (0.3999999999999999, 0.8, 0.6217821782178217), (0.3999999999999999, 0.8, 0.6336633663366336), (0.3999999999999999, 0.8, 0.6455445544554455), (0.3999999999999999, 0.8, 0.6574257425742573), (0.3999999999999999, 0.8, 0.6693069306930692), (0.3999999999999999, 0.8, 0.6811881188118811), (0.3999999999999999, 0.8, 0.693069306930693), (0.3999999999999999, 0.8, 0.7049504950495049), (0.3999999999999999, 0.8, 0.7168316831683168), (0.3999999999999999, 0.8, 0.7287128712871287), (0.3999999999999999, 0.8, 0.7405940594059406), (0.3999999999999999, 0.8, 0.7524752475247525), (0.3999999999999999, 0.8, 0.7643564356435644), (0.3999999999999999, 0.8, 0.7762376237623763), (0.3999999999999999, 0.8, 0.7881188118811882), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7881188118811882, 0.8), (0.3999999999999999, 0.7762376237623763, 0.8), (0.3999999999999999, 0.7643564356435643, 0.8), (0.3999999999999999, 0.7524752475247524, 0.8), (0.3999999999999999, 0.7405940594059405, 0.8), (0.3999999999999999, 0.7287128712871286, 0.8), (0.3999999999999999, 0.7168316831683167, 0.8), (0.3999999999999999, 0.7049504950495048, 0.8), (0.3999999999999999, 0.6930693069306929, 0.8), (0.3999999999999999, 0.681188118811881, 0.8), (0.3999999999999999, 0.6693069306930691, 0.8), (0.3999999999999999, 0.6574257425742572, 0.8), (0.3999999999999999, 0.6455445544554453, 0.8), (0.3999999999999999, 0.6336633663366334, 0.8), (0.3999999999999999, 0.6217821782178216, 0.8), (0.3999999999999999, 0.6099009900990097, 0.8), (0.3999999999999999, 0.5980198019801978, 0.8), (0.3999999999999999, 0.5861386138613858, 0.8), (0.3999999999999999, 0.5742574257425739, 0.8), (0.3999999999999999, 0.562376237623762, 0.8), (0.3999999999999999, 0.5504950495049501, 0.8), (0.3999999999999999, 0.5386138613861382, 0.8), (0.3999999999999999, 0.5267326732673263, 0.8), (0.3999999999999999, 0.5148514851485144, 0.8), (0.3999999999999999, 0.5029702970297025, 0.8), (0.3999999999999999, 0.49108910891089064, 0.8), (0.3999999999999999, 0.47920792079207875, 0.8), (0.3999999999999999, 0.46732673267326685, 0.8), (0.3999999999999999, 0.45544554455445496, 0.8), (0.3999999999999999, 0.44356435643564307, 0.8), (0.3999999999999999, 0.4316831683168312, 0.8), (0.3999999999999999, 0.4198019801980193, 0.8), (0.3999999999999999, 0.4079207920792074, 0.8), (0.40396039603960404, 0.3999999999999999, 0.8), (0.41584158415841593, 0.3999999999999999, 0.8), (0.4277227722772278, 0.3999999999999999, 0.8), (0.4396039603960397, 0.3999999999999999, 0.8), (0.45148514851485166, 0.3999999999999999, 0.8), (0.46336633663366356, 0.3999999999999999, 0.8), (0.4752475247524749, 0.3999999999999999, 0.8), (0.4871287128712868, 0.3999999999999999, 0.8), (0.4990099009900987, 0.3999999999999999, 0.8), (0.5108910891089106, 0.3999999999999999, 0.8), (0.5227722772277225, 0.3999999999999999, 0.8), (0.5346534653465344, 0.3999999999999999, 0.8), (0.5465346534653462, 0.3999999999999999, 0.8), (0.5584158415841581, 0.3999999999999999, 0.8), (0.57029702970297, 0.3999999999999999, 0.8), (0.582178217821782, 0.3999999999999999, 0.8), (0.5940594059405938, 0.3999999999999999, 0.8), (0.6059405940594057, 0.3999999999999999, 0.8), (0.6178217821782177, 0.3999999999999999, 0.8), (0.6297029702970296, 0.3999999999999999, 0.8), (0.6415841584158415, 0.3999999999999999, 0.8), (0.6534653465346534, 0.3999999999999999, 0.8), (0.6653465346534653, 0.3999999999999999, 0.8), (0.6772277227722772, 0.3999999999999999, 0.8), (0.689108910891089, 0.3999999999999999, 0.8), (0.700990099009901, 0.3999999999999999, 0.8), (0.7128712871287128, 0.3999999999999999, 0.8), (0.7247524752475247, 0.3999999999999999, 0.8), (0.7366336633663366, 0.3999999999999999, 0.8), (0.7485148514851485, 0.3999999999999999, 0.8), (0.7603960396039604, 0.3999999999999999, 0.8), (0.7722772277227723, 0.3999999999999999, 0.8), (0.7841584158415837, 0.3999999999999999, 0.8), (0.7960396039603956, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7920792079207921), (0.8, 0.3999999999999999, 0.7801980198019802), (0.8, 0.3999999999999999, 0.7683168316831684), (0.8, 0.3999999999999999, 0.7564356435643564), (0.8, 0.3999999999999999, 0.7445544554455445), (0.8, 0.3999999999999999, 0.7326732673267327), (0.8, 0.3999999999999999, 0.7207920792079208), (0.8, 0.3999999999999999, 0.7089108910891089), (0.8, 0.3999999999999999, 0.697029702970297), (0.8, 0.3999999999999999, 0.6851485148514851), (0.8, 0.3999999999999999, 0.6732673267326732), (0.8, 0.3999999999999999, 0.6613861386138613), (0.8, 0.3999999999999999, 0.6495049504950494), (0.8, 0.3999999999999999, 0.6376237623762375), (0.8, 0.3999999999999999, 0.6257425742574256), (0.8, 0.3999999999999999, 0.6138613861386137), (0.8, 0.3999999999999999, 0.6019801980198018), (0.8, 0.3999999999999999, 0.59009900990099), (0.8, 0.3999999999999999, 0.5782178217821781), (0.8, 0.3999999999999999, 0.5663366336633662), (0.8, 0.3999999999999999, 0.5544554455445543), (0.8, 0.3999999999999999, 0.5425742574257424), (0.8, 0.3999999999999999, 0.5306930693069305), (0.8, 0.3999999999999999, 0.5188118811881186), (0.8, 0.3999999999999999, 0.5069306930693067), (0.8, 0.3999999999999999, 0.4950495049504948), (0.8, 0.3999999999999999, 0.48316831683168293), (0.8, 0.3999999999999999, 0.47128712871287104), (0.8, 0.3999999999999999, 0.45940594059405915), (0.8, 0.3999999999999999, 0.44752475247524726), (0.8, 0.3999999999999999, 0.4356435643564353), (0.8, 0.3999999999999999, 0.4237623762376234), (0.8, 0.3999999999999999, 0.4118811881188115)],
    203: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4118226600985223, 0.3999999999999999), (0.8, 0.4236453201970442, 0.3999999999999999), (0.8, 0.43546798029556666, 0.3999999999999999), (0.8, 0.44729064039408856, 0.3999999999999999), (0.8, 0.45911330049261095, 0.3999999999999999), (0.8, 0.47093596059113285, 0.3999999999999999), (0.8, 0.48275862068965525, 0.3999999999999999), (0.8, 0.49458128078817715, 0.3999999999999999), (0.8, 0.5064039408866996, 0.3999999999999999), (0.8, 0.5182266009852214, 0.3999999999999999), (0.8, 0.530049261083744, 0.3999999999999999), (0.8, 0.5418719211822658, 0.3999999999999999), (0.8, 0.5536945812807882, 0.3999999999999999), (0.8, 0.5655172413793101, 0.3999999999999999), (0.8, 0.5773399014778325, 0.3999999999999999), (0.8, 0.5891625615763544, 0.3999999999999999), (0.8, 0.6009852216748769, 0.3999999999999999), (0.8, 0.6128078817733993, 0.3999999999999999), (0.8, 0.6246305418719211, 0.3999999999999999), (0.8, 0.6364532019704436, 0.3999999999999999), (0.8, 0.6482758620689655, 0.3999999999999999), (0.8, 0.6600985221674879, 0.3999999999999999), (0.8, 0.6719211822660098, 0.3999999999999999), (0.8, 0.6837438423645322, 0.3999999999999999), (0.8, 0.6955665024630542, 0.3999999999999999), (0.8, 0.7073891625615765, 0.3999999999999999), (0.8, 0.7192118226600984, 0.3999999999999999), (0.8, 0.7310344827586208, 0.3999999999999999), (0.8, 0.7428571428571427, 0.3999999999999999), (0.8, 0.7546798029556652, 0.3999999999999999), (0.8, 0.766502463054187, 0.3999999999999999), (0.8, 0.7783251231527095, 0.3999999999999999), (0.8, 0.7901477832512314, 0.3999999999999999), (0.7980295566502464, 0.8, 0.3999999999999999), (0.7862068965517239, 0.8, 0.3999999999999999), (0.7743842364532021, 0.8, 0.3999999999999999), (0.7625615763546802, 0.8, 0.3999999999999999), (0.7507389162561577, 0.8, 0.3999999999999999), (0.7389162561576353, 0.8, 0.3999999999999999), (0.7270935960591134, 0.8, 0.3999999999999999), (0.7152709359605911, 0.8, 0.3999999999999999), (0.7034482758620692, 0.8, 0.3999999999999999), (0.6916256157635468, 0.8, 0.3999999999999999), (0.6798029556650249, 0.8, 0.3999999999999999), (0.6679802955665024, 0.8, 0.3999999999999999), (0.6561576354679806, 0.8, 0.3999999999999999), (0.644334975369458, 0.8, 0.3999999999999999), (0.6325123152709362, 0.8, 0.3999999999999999), (0.6206896551724138, 0.8, 0.3999999999999999), (0.6088669950738919, 0.8, 0.3999999999999999), (0.5970443349753695, 0.8, 0.3999999999999999), (0.5852216748768471, 0.8, 0.3999999999999999), (0.5733990147783251, 0.8, 0.3999999999999999), (0.5615763546798033, 0.8, 0.3999999999999999), (0.5497536945812809, 0.8, 0.3999999999999999), (0.5379310344827584, 0.8, 0.3999999999999999), (0.5261083743842365, 0.8, 0.3999999999999999), (0.5142857142857147, 0.8, 0.3999999999999999), (0.5024630541871922, 0.8, 0.3999999999999999), (0.4906403940886698, 0.8, 0.3999999999999999), (0.4788177339901479, 0.8, 0.3999999999999999), (0.4669950738916255, 0.8, 0.3999999999999999), (0.4551724137931036, 0.8, 0.3999999999999999), (0.4433497536945812, 0.8, 0.3999999999999999), (0.4315270935960593, 0.8, 0.3999999999999999), (0.41970443349753683, 0.8, 0.3999999999999999), (0.40788177339901494, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40394088669950745), (0.3999999999999999, 0.8, 0.41576354679802985), (0.3999999999999999, 0.8, 0.42758620689655175), (0.3999999999999999, 0.8, 0.43940886699507364), (0.3999999999999999, 0.8, 0.45123152709359604), (0.3999999999999999, 0.8, 0.4630541871921185), (0.3999999999999999, 0.8, 0.4748768472906404), (0.3999999999999999, 0.8, 0.48669950738916223), (0.3999999999999999, 0.8, 0.4985221674876847), (0.3999999999999999, 0.8, 0.5103448275862071), (0.3999999999999999, 0.8, 0.522167487684729), (0.3999999999999999, 0.8, 0.5339901477832514), (0.3999999999999999, 0.8, 0.5458128078817733), (0.3999999999999999, 0.8, 0.5576354679802957), (0.3999999999999999, 0.8, 0.5694581280788176), (0.3999999999999999, 0.8, 0.5812807881773401), (0.3999999999999999, 0.8, 0.5931034482758619), (0.3999999999999999, 0.8, 0.6049261083743843), (0.3999999999999999, 0.8, 0.6167487684729063), (0.3999999999999999, 0.8, 0.6285714285714287), (0.3999999999999999, 0.8, 0.6403940886699506), (0.3999999999999999, 0.8, 0.652216748768473), (0.3999999999999999, 0.8, 0.6640394088669954), (0.3999999999999999, 0.8, 0.6758620689655173), (0.3999999999999999, 0.8, 0.6876847290640392), (0.3999999999999999, 0.8, 0.6995073891625616), (0.3999999999999999, 0.8, 0.7113300492610841), (0.3999999999999999, 0.8, 0.723152709359606), (0.3999999999999999, 0.8, 0.7349753694581278), (0.3999999999999999, 0.8, 0.7467980295566503), (0.3999999999999999, 0.8, 0.7586206896551726), (0.3999999999999999, 0.8, 0.7704433497536946), (0.3999999999999999, 0.8, 0.782266009852217), (0.3999999999999999, 0.8, 0.7940886699507388), (0.3999999999999999, 0.7940886699507388, 0.8), (0.3999999999999999, 0.7822660098522163, 0.8), (0.3999999999999999, 0.7704433497536944, 0.8), (0.3999999999999999, 0.7586206896551726, 0.8), (0.3999999999999999, 0.7467980295566501, 0.8), (0.3999999999999999, 0.7349753694581277, 0.8), (0.3999999999999999, 0.7231527093596057, 0.8), (0.3999999999999999, 0.7113300492610839, 0.8), (0.3999999999999999, 0.6995073891625615, 0.8), (0.3999999999999999, 0.6876847290640391, 0.8), (0.3999999999999999, 0.6758620689655173, 0.8), (0.3999999999999999, 0.6640394088669953, 0.8), (0.3999999999999999, 0.6522167487684729, 0.8), (0.3999999999999999, 0.6403940886699504, 0.8), (0.3999999999999999, 0.6285714285714286, 0.8), (0.3999999999999999, 0.6167487684729067, 0.8), (0.3999999999999999, 0.6049261083743842, 0.8), (0.3999999999999999, 0.5931034482758618, 0.8), (0.3999999999999999, 0.5812807881773394, 0.8), (0.3999999999999999, 0.5694581280788175, 0.8), (0.3999999999999999, 0.5576354679802956, 0.8), (0.3999999999999999, 0.5458128078817732, 0.8), (0.3999999999999999, 0.5339901477832507, 0.8), (0.3999999999999999, 0.5221674876847289, 0.8), (0.3999999999999999, 0.510344827586207, 0.8), (0.3999999999999999, 0.4985221674876846, 0.8), (0.3999999999999999, 0.4866995073891621, 0.8), (0.3999999999999999, 0.4748768472906402, 0.8), (0.3999999999999999, 0.4630541871921183, 0.8), (0.3999999999999999, 0.45123152709359593, 0.8), (0.3999999999999999, 0.4394088669950735, 0.8), (0.3999999999999999, 0.4275862068965516, 0.8), (0.3999999999999999, 0.41576354679802974, 0.8), (0.3999999999999999, 0.4039408866995073, 0.8), (0.40788177339901466, 0.3999999999999999, 0.8), (0.41970443349753656, 0.3999999999999999, 0.8), (0.431527093596059, 0.3999999999999999, 0.8), (0.4433497536945809, 0.3999999999999999, 0.8), (0.4551724137931033, 0.3999999999999999, 0.8), (0.46699507389162576, 0.3999999999999999, 0.8), (0.4788177339901476, 0.3999999999999999, 0.8), (0.49064039408866955, 0.3999999999999999, 0.8), (0.502463054187192, 0.3999999999999999, 0.8), (0.5142857142857143, 0.3999999999999999, 0.8), (0.5261083743842363, 0.3999999999999999, 0.8), (0.5379310344827581, 0.3999999999999999, 0.8), (0.5497536945812805, 0.3999999999999999, 0.8), (0.5615763546798029, 0.3999999999999999, 0.8), (0.5733990147783249, 0.3999999999999999, 0.8), (0.5852216748768468, 0.3999999999999999, 0.8), (0.5970443349753692, 0.3999999999999999, 0.8), (0.6088669950738916, 0.3999999999999999, 0.8), (0.6206896551724135, 0.3999999999999999, 0.8), (0.6325123152709354, 0.3999999999999999, 0.8), (0.6443349753694578, 0.3999999999999999, 0.8), (0.6561576354679802, 0.3999999999999999, 0.8), (0.6679802955665026, 0.3999999999999999, 0.8), (0.6798029556650246, 0.3999999999999999, 0.8), (0.6916256157635465, 0.3999999999999999, 0.8), (0.7034482758620688, 0.3999999999999999, 0.8), (0.7152709359605913, 0.3999999999999999, 0.8), (0.7270935960591132, 0.3999999999999999, 0.8), (0.738916256157635, 0.3999999999999999, 0.8), (0.7507389162561575, 0.3999999999999999, 0.8), (0.7625615763546799, 0.3999999999999999, 0.8), (0.7743842364532019, 0.3999999999999999, 0.8), (0.7862068965517237, 0.3999999999999999, 0.8), (0.7980295566502462, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7901477832512311), (0.8, 0.3999999999999999, 0.7783251231527093), (0.8, 0.3999999999999999, 0.7665024630541873), (0.8, 0.3999999999999999, 0.754679802955665), (0.8, 0.3999999999999999, 0.7428571428571424), (0.8, 0.3999999999999999, 0.73103448275862), (0.8, 0.3999999999999999, 0.7192118226600981), (0.8, 0.3999999999999999, 0.7073891625615762), (0.8, 0.3999999999999999, 0.6955665024630538), (0.8, 0.3999999999999999, 0.6837438423645315), (0.8, 0.3999999999999999, 0.6719211822660096), (0.8, 0.3999999999999999, 0.6600985221674877), (0.8, 0.3999999999999999, 0.6482758620689653), (0.8, 0.3999999999999999, 0.6364532019704428), (0.8, 0.3999999999999999, 0.6246305418719209), (0.8, 0.3999999999999999, 0.6128078817733991), (0.8, 0.3999999999999999, 0.6009852216748766), (0.8, 0.3999999999999999, 0.5891625615763542), (0.8, 0.3999999999999999, 0.5773399014778322), (0.8, 0.3999999999999999, 0.5655172413793104), (0.8, 0.3999999999999999, 0.553694581280788), (0.8, 0.3999999999999999, 0.5418719211822656), (0.8, 0.3999999999999999, 0.5300492610837436), (0.8, 0.3999999999999999, 0.5182266009852212), (0.8, 0.3999999999999999, 0.5064039408866994), (0.8, 0.3999999999999999, 0.4945812807881769), (0.8, 0.3999999999999999, 0.48275862068965447), (0.8, 0.3999999999999999, 0.4709359605911326), (0.8, 0.3999999999999999, 0.4591133004926107), (0.8, 0.3999999999999999, 0.4472906403940883), (0.8, 0.3999999999999999, 0.4354679802955658), (0.8, 0.3999999999999999, 0.42364532019704393), (0.8, 0.3999999999999999, 0.4118226600985221)],
    204: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4117647058823528, 0.3999999999999999), (0.8, 0.4235294117647057, 0.3999999999999999), (0.8, 0.4352941176470586, 0.3999999999999999), (0.8, 0.4470588235294115, 0.3999999999999999), (0.8, 0.4588235294117644, 0.3999999999999999), (0.8, 0.4705882352941173, 0.3999999999999999), (0.8, 0.48235294117647076, 0.3999999999999999), (0.8, 0.49411764705882366, 0.3999999999999999), (0.8, 0.5058823529411766, 0.3999999999999999), (0.8, 0.5176470588235295, 0.3999999999999999), (0.8, 0.5294117647058824, 0.3999999999999999), (0.8, 0.5411764705882353, 0.3999999999999999), (0.8, 0.5529411764705882, 0.3999999999999999), (0.8, 0.5647058823529411, 0.3999999999999999), (0.8, 0.576470588235294, 0.3999999999999999), (0.8, 0.5882352941176469, 0.3999999999999999), (0.8, 0.5999999999999998, 0.3999999999999999), (0.8, 0.6117647058823527, 0.3999999999999999), (0.8, 0.6235294117647061, 0.3999999999999999), (0.8, 0.635294117647059, 0.3999999999999999), (0.8, 0.6470588235294119, 0.3999999999999999), (0.8, 0.6588235294117648, 0.3999999999999999), (0.8, 0.6705882352941177, 0.3999999999999999), (0.8, 0.6823529411764706, 0.3999999999999999), (0.8, 0.6941176470588235, 0.3999999999999999), (0.8, 0.7058823529411764, 0.3999999999999999), (0.8, 0.7176470588235293, 0.3999999999999999), (0.8, 0.7294117647058822, 0.3999999999999999), (0.8, 0.7411764705882351, 0.3999999999999999), (0.8, 0.752941176470588, 0.3999999999999999), (0.8, 0.764705882352941, 0.3999999999999999), (0.8, 0.7764705882352938, 0.3999999999999999), (0.8, 0.7882352941176474, 0.3999999999999999), (0.8, 0.8, 0.3999999999999999), (0.7882352941176471, 0.8, 0.3999999999999999), (0.7764705882352942, 0.8, 0.3999999999999999), (0.7647058823529412, 0.8, 0.3999999999999999), (0.7529411764705883, 0.8, 0.3999999999999999), (0.7411764705882354, 0.8, 0.3999999999999999), (0.7294117647058825, 0.8, 0.3999999999999999), (0.7176470588235296, 0.8, 0.3999999999999999), (0.7058823529411767, 0.8, 0.3999999999999999), (0.6941176470588238, 0.8, 0.3999999999999999), (0.6823529411764704, 0.8, 0.3999999999999999), (0.6705882352941175, 0.8, 0.3999999999999999), (0.6588235294117646, 0.8, 0.3999999999999999), (0.6470588235294117, 0.8, 0.3999999999999999), (0.6352941176470588, 0.8, 0.3999999999999999), (0.6235294117647059, 0.8, 0.3999999999999999), (0.611764705882353, 0.8, 0.3999999999999999), (0.6000000000000001, 0.8, 0.3999999999999999), (0.5882352941176472, 0.8, 0.3999999999999999), (0.5764705882352943, 0.8, 0.3999999999999999), (0.5647058823529414, 0.8, 0.3999999999999999), (0.5529411764705885, 0.8, 0.3999999999999999), (0.5411764705882356, 0.8, 0.3999999999999999), (0.5294117647058827, 0.8, 0.3999999999999999), (0.5176470588235298, 0.8, 0.3999999999999999), (0.5058823529411769, 0.8, 0.3999999999999999), (0.4941176470588234, 0.8, 0.3999999999999999), (0.4823529411764705, 0.8, 0.3999999999999999), (0.4705882352941176, 0.8, 0.3999999999999999), (0.4588235294117647, 0.8, 0.3999999999999999), (0.4470588235294118, 0.8, 0.3999999999999999), (0.4352941176470589, 0.8, 0.3999999999999999), (0.423529411764706, 0.8, 0.3999999999999999), (0.4117647058823531, 0.8, 0.3999999999999999), (0.4000000000000002, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4117647058823532), (0.3999999999999999, 0.8, 0.4235294117647061), (0.3999999999999999, 0.8, 0.435294117647059), (0.3999999999999999, 0.8, 0.44705882352941195), (0.3999999999999999, 0.8, 0.45882352941176485), (0.3999999999999999, 0.8, 0.47058823529411775), (0.3999999999999999, 0.8, 0.48235294117647065), (0.3999999999999999, 0.8, 0.49411764705882355), (0.3999999999999999, 0.8, 0.5058823529411764), (0.3999999999999999, 0.8, 0.5176470588235293), (0.3999999999999999, 0.8, 0.5294117647058822), (0.3999999999999999, 0.8, 0.5411764705882351), (0.3999999999999999, 0.8, 0.552941176470588), (0.3999999999999999, 0.8, 0.564705882352941), (0.3999999999999999, 0.8, 0.5764705882352938), (0.3999999999999999, 0.8, 0.5882352941176467), (0.3999999999999999, 0.8, 0.6000000000000002), (0.3999999999999999, 0.8, 0.6117647058823531), (0.3999999999999999, 0.8, 0.623529411764706), (0.3999999999999999, 0.8, 0.6352941176470589), (0.3999999999999999, 0.8, 0.6470588235294118), (0.3999999999999999, 0.8, 0.6588235294117647), (0.3999999999999999, 0.8, 0.6705882352941177), (0.3999999999999999, 0.8, 0.6823529411764706), (0.3999999999999999, 0.8, 0.6941176470588235), (0.3999999999999999, 0.8, 0.7058823529411764), (0.3999999999999999, 0.8, 0.7176470588235297), (0.3999999999999999, 0.8, 0.7294117647058826), (0.3999999999999999, 0.8, 0.7411764705882355), (0.3999999999999999, 0.8, 0.7529411764705884), (0.3999999999999999, 0.8, 0.7647058823529413), (0.3999999999999999, 0.8, 0.7764705882352942), (0.3999999999999999, 0.8, 0.7882352941176471), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7882352941176471, 0.8), (0.3999999999999999, 0.7764705882352942, 0.8), (0.3999999999999999, 0.7647058823529412, 0.8), (0.3999999999999999, 0.7529411764705883, 0.8), (0.3999999999999999, 0.7411764705882354, 0.8), (0.3999999999999999, 0.7294117647058825, 0.8), (0.3999999999999999, 0.7176470588235296, 0.8), (0.3999999999999999, 0.7058823529411767, 0.8), (0.3999999999999999, 0.6941176470588238, 0.8), (0.3999999999999999, 0.6823529411764704, 0.8), (0.3999999999999999, 0.6705882352941175, 0.8), (0.3999999999999999, 0.6588235294117646, 0.8), (0.3999999999999999, 0.6470588235294117, 0.8), (0.3999999999999999, 0.6352941176470588, 0.8), (0.3999999999999999, 0.6235294117647059, 0.8), (0.3999999999999999, 0.611764705882353, 0.8), (0.3999999999999999, 0.5999999999999995, 0.8), (0.3999999999999999, 0.5882352941176466, 0.8), (0.3999999999999999, 0.5764705882352937, 0.8), (0.3999999999999999, 0.5647058823529408, 0.8), (0.3999999999999999, 0.5529411764705879, 0.8), (0.3999999999999999, 0.541176470588235, 0.8), (0.3999999999999999, 0.5294117647058821, 0.8), (0.3999999999999999, 0.5176470588235292, 0.8), (0.3999999999999999, 0.5058823529411763, 0.8), (0.3999999999999999, 0.4941176470588234, 0.8), (0.3999999999999999, 0.4823529411764705, 0.8), (0.3999999999999999, 0.4705882352941176, 0.8), (0.3999999999999999, 0.4588235294117647, 0.8), (0.3999999999999999, 0.4470588235294118, 0.8), (0.3999999999999999, 0.4352941176470589, 0.8), (0.3999999999999999, 0.423529411764706, 0.8), (0.3999999999999999, 0.4117647058823531, 0.8), (0.3999999999999999, 0.4000000000000002, 0.8), (0.41176470588235226, 0.3999999999999999, 0.8), (0.4235294117647057, 0.3999999999999999, 0.8), (0.4352941176470586, 0.3999999999999999, 0.8), (0.4470588235294115, 0.3999999999999999, 0.8), (0.4588235294117644, 0.3999999999999999, 0.8), (0.4705882352941173, 0.3999999999999999, 0.8), (0.4823529411764702, 0.3999999999999999, 0.8), (0.49411764705882316, 0.3999999999999999, 0.8), (0.5058823529411766, 0.3999999999999999, 0.8), (0.5176470588235295, 0.3999999999999999, 0.8), (0.5294117647058824, 0.3999999999999999, 0.8), (0.5411764705882353, 0.3999999999999999, 0.8), (0.5529411764705882, 0.3999999999999999, 0.8), (0.5647058823529411, 0.3999999999999999, 0.8), (0.576470588235294, 0.3999999999999999, 0.8), (0.5882352941176469, 0.3999999999999999, 0.8), (0.5999999999999998, 0.3999999999999999, 0.8), (0.6117647058823527, 0.3999999999999999, 0.8), (0.6235294117647057, 0.3999999999999999, 0.8), (0.6352941176470586, 0.3999999999999999, 0.8), (0.6470588235294115, 0.3999999999999999, 0.8), (0.6588235294117644, 0.3999999999999999, 0.8), (0.6705882352941173, 0.3999999999999999, 0.8), (0.6823529411764702, 0.3999999999999999, 0.8), (0.6941176470588231, 0.3999999999999999, 0.8), (0.705882352941176, 0.3999999999999999, 0.8), (0.7176470588235289, 0.3999999999999999, 0.8), (0.7294117647058822, 0.3999999999999999, 0.8), (0.7411764705882351, 0.3999999999999999, 0.8), (0.752941176470588, 0.3999999999999999, 0.8), (0.764705882352941, 0.3999999999999999, 0.8), (0.7764705882352938, 0.3999999999999999, 0.8), (0.7882352941176467, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7999999999999994), (0.8, 0.3999999999999999, 0.7882352941176465), (0.8, 0.3999999999999999, 0.7764705882352936), (0.8, 0.3999999999999999, 0.7647058823529407), (0.8, 0.3999999999999999, 0.7529411764705878), (0.8, 0.3999999999999999, 0.7411764705882349), (0.8, 0.3999999999999999, 0.729411764705882), (0.8, 0.3999999999999999, 0.7176470588235291), (0.8, 0.3999999999999999, 0.7058823529411762), (0.8, 0.3999999999999999, 0.6941176470588233), (0.8, 0.3999999999999999, 0.6823529411764704), (0.8, 0.3999999999999999, 0.6705882352941175), (0.8, 0.3999999999999999, 0.6588235294117646), (0.8, 0.3999999999999999, 0.6470588235294117), (0.8, 0.3999999999999999, 0.6352941176470588), (0.8, 0.3999999999999999, 0.6235294117647059), (0.8, 0.3999999999999999, 0.611764705882353), (0.8, 0.3999999999999999, 0.6000000000000001), (0.8, 0.3999999999999999, 0.5882352941176472), (0.8, 0.3999999999999999, 0.5764705882352937), (0.8, 0.3999999999999999, 0.5647058823529408), (0.8, 0.3999999999999999, 0.5529411764705879), (0.8, 0.3999999999999999, 0.541176470588235), (0.8, 0.3999999999999999, 0.5294117647058821), (0.8, 0.3999999999999999, 0.5176470588235292), (0.8, 0.3999999999999999, 0.5058823529411763), (0.8, 0.3999999999999999, 0.4941176470588229), (0.8, 0.3999999999999999, 0.48235294117647), (0.8, 0.3999999999999999, 0.4705882352941171), (0.8, 0.3999999999999999, 0.4588235294117642), (0.8, 0.3999999999999999, 0.4470588235294113), (0.8, 0.3999999999999999, 0.43529411764705833), (0.8, 0.3999999999999999, 0.42352941176470543), (0.8, 0.3999999999999999, 0.41176470588235253)],
    205: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.41170731707317065, 0.3999999999999999), (0.8, 0.4234146341463414, 0.3999999999999999), (0.8, 0.43512195121951214, 0.3999999999999999), (0.8, 0.4468292682926829, 0.3999999999999999), (0.8, 0.4585365853658536, 0.3999999999999999), (0.8, 0.47024390243902436, 0.3999999999999999), (0.8, 0.4819512195121951, 0.3999999999999999), (0.8, 0.49365853658536585, 0.3999999999999999), (0.8, 0.5053658536585366, 0.3999999999999999), (0.8, 0.5170731707317073, 0.3999999999999999), (0.8, 0.5287804878048781, 0.3999999999999999), (0.8, 0.5404878048780488, 0.3999999999999999), (0.8, 0.5521951219512196, 0.3999999999999999), (0.8, 0.5639024390243903, 0.3999999999999999), (0.8, 0.575609756097561, 0.3999999999999999), (0.8, 0.5873170731707318, 0.3999999999999999), (0.8, 0.5990243902439026, 0.3999999999999999), (0.8, 0.6107317073170734, 0.3999999999999999), (0.8, 0.6224390243902441, 0.3999999999999999), (0.8, 0.6341463414634149, 0.3999999999999999), (0.8, 0.6458536585365856, 0.3999999999999999), (0.8, 0.6575609756097563, 0.3999999999999999), (0.8, 0.6692682926829271, 0.3999999999999999), (0.8, 0.6809756097560978, 0.3999999999999999), (0.8, 0.6926829268292686, 0.3999999999999999), (0.8, 0.7043902439024393, 0.3999999999999999), (0.8, 0.7160975609756101, 0.3999999999999999), (0.8, 0.7278048780487808, 0.3999999999999999), (0.8, 0.739512195121951, 0.3999999999999999), (0.8, 0.7512195121951217, 0.3999999999999999), (0.8, 0.7629268292682925, 0.3999999999999999), (0.8, 0.7746341463414632, 0.3999999999999999), (0.8, 0.786341463414634, 0.3999999999999999), (0.8, 0.7980487804878047, 0.3999999999999999), (0.7902439024390246, 0.8, 0.3999999999999999), (0.7785365853658539, 0.8, 0.3999999999999999), (0.7668292682926832, 0.8, 0.3999999999999999), (0.7551219512195124, 0.8, 0.3999999999999999), (0.7434146341463417, 0.8, 0.3999999999999999), (0.7317073170731709, 0.8, 0.3999999999999999), (0.7200000000000002, 0.8, 0.3999999999999999), (0.7082926829268295, 0.8, 0.3999999999999999), (0.6965853658536587, 0.8, 0.3999999999999999), (0.684878048780488, 0.8, 0.3999999999999999), (0.6731707317073172, 0.8, 0.3999999999999999), (0.6614634146341465, 0.8, 0.3999999999999999), (0.6497560975609757, 0.8, 0.3999999999999999), (0.638048780487805, 0.8, 0.3999999999999999), (0.6263414634146343, 0.8, 0.3999999999999999), (0.6146341463414635, 0.8, 0.3999999999999999), (0.6029268292682928, 0.8, 0.3999999999999999), (0.591219512195122, 0.8, 0.3999999999999999), (0.5795121951219513, 0.8, 0.3999999999999999), (0.5678048780487805, 0.8, 0.3999999999999999), (0.5560975609756098, 0.8, 0.3999999999999999), (0.5443902439024391, 0.8, 0.3999999999999999), (0.5326829268292683, 0.8, 0.3999999999999999), (0.5209756097560976, 0.8, 0.3999999999999999), (0.5092682926829268, 0.8, 0.3999999999999999), (0.49756097560975604, 0.8, 0.3999999999999999), (0.4858536585365853, 0.8, 0.3999999999999999), (0.47414634146341456, 0.8, 0.3999999999999999), (0.4624390243902438, 0.8, 0.3999999999999999), (0.45073170731707307, 0.8, 0.3999999999999999), (0.43902439024390233, 0.8, 0.3999999999999999), (0.42731707317073153, 0.8, 0.3999999999999999), (0.4156097560975608, 0.8, 0.3999999999999999), (0.40390243902439005, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.40780487804878063), (0.3999999999999999, 0.8, 0.41951219512195137), (0.3999999999999999, 0.8, 0.4312195121951216), (0.3999999999999999, 0.8, 0.44292682926829235), (0.3999999999999999, 0.8, 0.4546341463414631), (0.3999999999999999, 0.8, 0.46634146341463384), (0.3999999999999999, 0.8, 0.4780487804878046), (0.3999999999999999, 0.8, 0.4897560975609753), (0.3999999999999999, 0.8, 0.5014634146341461), (0.3999999999999999, 0.8, 0.5131707317073169), (0.3999999999999999, 0.8, 0.5248780487804876), (0.3999999999999999, 0.8, 0.5365853658536583), (0.3999999999999999, 0.8, 0.5482926829268291), (0.3999999999999999, 0.8, 0.5599999999999998), (0.3999999999999999, 0.8, 0.5717073170731706), (0.3999999999999999, 0.8, 0.5834146341463413), (0.3999999999999999, 0.8, 0.5951219512195121), (0.3999999999999999, 0.8, 0.6068292682926828), (0.3999999999999999, 0.8, 0.6185365853658535), (0.3999999999999999, 0.8, 0.6302439024390243), (0.3999999999999999, 0.8, 0.641951219512195), (0.3999999999999999, 0.8, 0.6536585365853658), (0.3999999999999999, 0.8, 0.6653658536585365), (0.3999999999999999, 0.8, 0.6770731707317073), (0.3999999999999999, 0.8, 0.688780487804878), (0.3999999999999999, 0.8, 0.7004878048780487), (0.3999999999999999, 0.8, 0.7121951219512195), (0.3999999999999999, 0.8, 0.7239024390243902), (0.3999999999999999, 0.8, 0.735609756097561), (0.3999999999999999, 0.8, 0.7473170731707317), (0.3999999999999999, 0.8, 0.7590243902439024), (0.3999999999999999, 0.8, 0.7707317073170732), (0.3999999999999999, 0.8, 0.7824390243902439), (0.3999999999999999, 0.8, 0.7941463414634147), (0.3999999999999999, 0.7941463414634147, 0.8), (0.3999999999999999, 0.7824390243902439, 0.8), (0.3999999999999999, 0.7707317073170731, 0.8), (0.3999999999999999, 0.7590243902439023, 0.8), (0.3999999999999999, 0.7473170731707316, 0.8), (0.3999999999999999, 0.7356097560975609, 0.8), (0.3999999999999999, 0.7239024390243901, 0.8), (0.3999999999999999, 0.7121951219512194, 0.8), (0.3999999999999999, 0.7004878048780486, 0.8), (0.3999999999999999, 0.6887804878048779, 0.8), (0.3999999999999999, 0.6770731707317071, 0.8), (0.3999999999999999, 0.6653658536585364, 0.8), (0.3999999999999999, 0.6536585365853657, 0.8), (0.3999999999999999, 0.6419512195121949, 0.8), (0.3999999999999999, 0.6302439024390242, 0.8), (0.3999999999999999, 0.6185365853658534, 0.8), (0.3999999999999999, 0.6068292682926827, 0.8), (0.3999999999999999, 0.595121951219512, 0.8), (0.3999999999999999, 0.5834146341463411, 0.8), (0.3999999999999999, 0.5717073170731704, 0.8), (0.3999999999999999, 0.5599999999999996, 0.8), (0.3999999999999999, 0.5482926829268289, 0.8), (0.3999999999999999, 0.5365853658536581, 0.8), (0.3999999999999999, 0.5248780487804874, 0.8), (0.3999999999999999, 0.5131707317073166, 0.8), (0.3999999999999999, 0.5014634146341459, 0.8), (0.3999999999999999, 0.48975609756097516, 0.8), (0.3999999999999999, 0.4780487804878044, 0.8), (0.3999999999999999, 0.4663414634146337, 0.8), (0.3999999999999999, 0.45463414634146293, 0.8), (0.3999999999999999, 0.4429268292682922, 0.8), (0.3999999999999999, 0.43121951219512145, 0.8), (0.3999999999999999, 0.4195121951219507, 0.8), (0.3999999999999999, 0.40780487804877996, 0.8), (0.4039024390243903, 0.3999999999999999, 0.8), (0.41560975609756107, 0.3999999999999999, 0.8), (0.4273170731707318, 0.3999999999999999, 0.8), (0.43902439024390255, 0.3999999999999999, 0.8), (0.4507317073170728, 0.3999999999999999, 0.8), (0.46243902439024354, 0.3999999999999999, 0.8), (0.4741463414634143, 0.3999999999999999, 0.8), (0.485853658536585, 0.3999999999999999, 0.8), (0.49756097560975576, 0.3999999999999999, 0.8), (0.5092682926829265, 0.3999999999999999, 0.8), (0.5209756097560972, 0.3999999999999999, 0.8), (0.532682926829268, 0.3999999999999999, 0.8), (0.5443902439024387, 0.3999999999999999, 0.8), (0.5560975609756095, 0.3999999999999999, 0.8), (0.5678048780487802, 0.3999999999999999, 0.8), (0.579512195121951, 0.3999999999999999, 0.8), (0.5912195121951217, 0.3999999999999999, 0.8), (0.6029268292682924, 0.3999999999999999, 0.8), (0.6146341463414633, 0.3999999999999999, 0.8), (0.626341463414634, 0.3999999999999999, 0.8), (0.6380487804878048, 0.3999999999999999, 0.8), (0.6497560975609755, 0.3999999999999999, 0.8), (0.6614634146341463, 0.3999999999999999, 0.8), (0.673170731707317, 0.3999999999999999, 0.8), (0.6848780487804877, 0.3999999999999999, 0.8), (0.6965853658536585, 0.3999999999999999, 0.8), (0.7082926829268292, 0.3999999999999999, 0.8), (0.72, 0.3999999999999999, 0.8), (0.7317073170731707, 0.3999999999999999, 0.8), (0.7434146341463415, 0.3999999999999999, 0.8), (0.7551219512195116, 0.3999999999999999, 0.8), (0.7668292682926824, 0.3999999999999999, 0.8), (0.7785365853658532, 0.3999999999999999, 0.8), (0.790243902439024, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7980487804878049), (0.8, 0.3999999999999999, 0.7863414634146342), (0.8, 0.3999999999999999, 0.7746341463414635), (0.8, 0.3999999999999999, 0.7629268292682928), (0.8, 0.3999999999999999, 0.751219512195122), (0.8, 0.3999999999999999, 0.7395121951219512), (0.8, 0.3999999999999999, 0.7278048780487805), (0.8, 0.3999999999999999, 0.7160975609756097), (0.8, 0.3999999999999999, 0.704390243902439), (0.8, 0.3999999999999999, 0.6926829268292682), (0.8, 0.3999999999999999, 0.6809756097560975), (0.8, 0.3999999999999999, 0.6692682926829268), (0.8, 0.3999999999999999, 0.657560975609756), (0.8, 0.3999999999999999, 0.6458536585365853), (0.8, 0.3999999999999999, 0.6341463414634145), (0.8, 0.3999999999999999, 0.6224390243902438), (0.8, 0.3999999999999999, 0.610731707317073), (0.8, 0.3999999999999999, 0.5990243902439023), (0.8, 0.3999999999999999, 0.5873170731707316), (0.8, 0.3999999999999999, 0.5756097560975608), (0.8, 0.3999999999999999, 0.5639024390243901), (0.8, 0.3999999999999999, 0.5521951219512193), (0.8, 0.3999999999999999, 0.5404878048780486), (0.8, 0.3999999999999999, 0.5287804878048779), (0.8, 0.3999999999999999, 0.5170731707317071), (0.8, 0.3999999999999999, 0.5053658536585364), (0.8, 0.3999999999999999, 0.4936585365853656), (0.8, 0.3999999999999999, 0.4819512195121949), (0.8, 0.3999999999999999, 0.47024390243902414), (0.8, 0.3999999999999999, 0.4585365853658534), (0.8, 0.3999999999999999, 0.44682926829268266), (0.8, 0.3999999999999999, 0.43512195121951186), (0.8, 0.3999999999999999, 0.4234146341463411), (0.8, 0.3999999999999999, 0.4117073170731704)],
    206: [(0.8, 0.3999999999999999, 0.3999999999999999), (0.8, 0.4116504854368931, 0.3999999999999999), (0.8, 0.4233009708737863, 0.3999999999999999), (0.8, 0.4349514563106795, 0.3999999999999999), (0.8, 0.44660194174757273, 0.3999999999999999), (0.8, 0.4582524271844659, 0.3999999999999999), (0.8, 0.46990291262135914, 0.3999999999999999), (0.8, 0.4815533980582523, 0.3999999999999999), (0.8, 0.49320388349514555, 0.3999999999999999), (0.8, 0.5048543689320387, 0.3999999999999999), (0.8, 0.5165048543689319, 0.3999999999999999), (0.8, 0.5281553398058252, 0.3999999999999999), (0.8, 0.5398058252427184, 0.3999999999999999), (0.8, 0.5514563106796115, 0.3999999999999999), (0.8, 0.5631067961165047, 0.3999999999999999), (0.8, 0.5747572815533979, 0.3999999999999999), (0.8, 0.5864077669902912, 0.3999999999999999), (0.8, 0.5980582524271844, 0.3999999999999999), (0.8, 0.6097087378640775, 0.3999999999999999), (0.8, 0.6213592233009708, 0.3999999999999999), (0.8, 0.633009708737864, 0.3999999999999999), (0.8, 0.6446601941747572, 0.3999999999999999), (0.8, 0.6563106796116503, 0.3999999999999999), (0.8, 0.6679611650485435, 0.3999999999999999), (0.8, 0.6796116504854368, 0.3999999999999999), (0.8, 0.69126213592233, 0.3999999999999999), (0.8, 0.7029126213592232, 0.3999999999999999), (0.8, 0.7145631067961165, 0.3999999999999999), (0.8, 0.7262135922330095, 0.3999999999999999), (0.8, 0.7378640776699028, 0.3999999999999999), (0.8, 0.749514563106796, 0.3999999999999999), (0.8, 0.7611650485436892, 0.3999999999999999), (0.8, 0.7728155339805824, 0.3999999999999999), (0.8, 0.7844660194174755, 0.3999999999999999), (0.8, 0.7961165048543688, 0.3999999999999999), (0.7922330097087382, 0.8, 0.3999999999999999), (0.7805825242718449, 0.8, 0.3999999999999999), (0.7689320388349518, 0.8, 0.3999999999999999), (0.7572815533980586, 0.8, 0.3999999999999999), (0.7456310679611653, 0.8, 0.3999999999999999), (0.7339805825242722, 0.8, 0.3999999999999999), (0.7223300970873789, 0.8, 0.3999999999999999), (0.7106796116504858, 0.8, 0.3999999999999999), (0.6990291262135926, 0.8, 0.3999999999999999), (0.6873786407766993, 0.8, 0.3999999999999999), (0.6757281553398062, 0.8, 0.3999999999999999), (0.664077669902913, 0.8, 0.3999999999999999), (0.6524271844660198, 0.8, 0.3999999999999999), (0.6407766990291266, 0.8, 0.3999999999999999), (0.6291262135922333, 0.8, 0.3999999999999999), (0.6174757281553401, 0.8, 0.3999999999999999), (0.605825242718447, 0.8, 0.3999999999999999), (0.5941747572815538, 0.8, 0.3999999999999999), (0.5825242718446599, 0.8, 0.3999999999999999), (0.5708737864077673, 0.8, 0.3999999999999999), (0.5592233009708736, 0.8, 0.3999999999999999), (0.547572815533981, 0.8, 0.3999999999999999), (0.5359223300970872, 0.8, 0.3999999999999999), (0.5242718446601945, 0.8, 0.3999999999999999), (0.5126213592233008, 0.8, 0.3999999999999999), (0.5009708737864081, 0.8, 0.3999999999999999), (0.48932038834951436, 0.8, 0.3999999999999999), (0.4776699029126217, 0.8, 0.3999999999999999), (0.46601941747572795, 0.8, 0.3999999999999999), (0.4543689320388353, 0.8, 0.3999999999999999), (0.4427184466019416, 0.8, 0.3999999999999999), (0.4310679611650489, 0.8, 0.3999999999999999), (0.41941747572815513, 0.8, 0.3999999999999999), (0.4077669902912625, 0.8, 0.3999999999999999), (0.3999999999999999, 0.8, 0.4038834951456312), (0.3999999999999999, 0.8, 0.4155339805825239), (0.3999999999999999, 0.8, 0.4271844660194176), (0.3999999999999999, 0.8, 0.4388349514563103), (0.3999999999999999, 0.8, 0.450485436893204), (0.3999999999999999, 0.8, 0.4621359223300967), (0.3999999999999999, 0.8, 0.47378640776699044), (0.3999999999999999, 0.8, 0.48543689320388306), (0.3999999999999999, 0.8, 0.49708737864077684), (0.3999999999999999, 0.8, 0.5087378640776695), (0.3999999999999999, 0.8, 0.5203883495145633), (0.3999999999999999, 0.8, 0.5320388349514559), (0.3999999999999999, 0.8, 0.5436893203883496), (0.3999999999999999, 0.8, 0.5553398058252428), (0.3999999999999999, 0.8, 0.5669902912621361), (0.3999999999999999, 0.8, 0.5786407766990292), (0.3999999999999999, 0.8, 0.5902912621359224), (0.3999999999999999, 0.8, 0.6019417475728156), (0.3999999999999999, 0.8, 0.6135922330097089), (0.3999999999999999, 0.8, 0.6252427184466021), (0.3999999999999999, 0.8, 0.6368932038834952), (0.3999999999999999, 0.8, 0.6485436893203884), (0.3999999999999999, 0.8, 0.6601941747572817), (0.3999999999999999, 0.8, 0.6718446601941749), (0.3999999999999999, 0.8, 0.6834951456310681), (0.3999999999999999, 0.8, 0.6951456310679613), (0.3999999999999999, 0.8, 0.7067961165048544), (0.3999999999999999, 0.8, 0.7184466019417477), (0.3999999999999999, 0.8, 0.7300970873786409), (0.3999999999999999, 0.8, 0.741747572815534), (0.3999999999999999, 0.8, 0.7533980582524273), (0.3999999999999999, 0.8, 0.7650485436893205), (0.3999999999999999, 0.8, 0.7766990291262137), (0.3999999999999999, 0.8, 0.788349514563107), (0.3999999999999999, 0.8, 0.8), (0.3999999999999999, 0.7883495145631068, 0.8), (0.3999999999999999, 0.7766990291262135, 0.8), (0.3999999999999999, 0.7650485436893204, 0.8), (0.3999999999999999, 0.7533980582524271, 0.8), (0.3999999999999999, 0.7417475728155339, 0.8), (0.3999999999999999, 0.7300970873786408, 0.8), (0.3999999999999999, 0.7184466019417475, 0.8), (0.3999999999999999, 0.7067961165048544, 0.8), (0.3999999999999999, 0.6951456310679611, 0.8), (0.3999999999999999, 0.683495145631068, 0.8), (0.3999999999999999, 0.6718446601941748, 0.8), (0.3999999999999999, 0.6601941747572815, 0.8), (0.3999999999999999, 0.6485436893203883, 0.8), (0.3999999999999999, 0.6368932038834951, 0.8), (0.3999999999999999, 0.625242718446602, 0.8), (0.3999999999999999, 0.6135922330097088, 0.8), (0.3999999999999999, 0.6019417475728155, 0.8), (0.3999999999999999, 0.5902912621359223, 0.8), (0.3999999999999999, 0.5786407766990291, 0.8), (0.3999999999999999, 0.5669902912621358, 0.8), (0.3999999999999999, 0.5553398058252427, 0.8), (0.3999999999999999, 0.5436893203883495, 0.8), (0.3999999999999999, 0.5320388349514563, 0.8), (0.3999999999999999, 0.5203883495145631, 0.8), (0.3999999999999999, 0.5087378640776699, 0.8), (0.3999999999999999, 0.4970873786407767, 0.8), (0.3999999999999999, 0.4854368932038835, 0.8), (0.3999999999999999, 0.47378640776699027, 0.8), (0.3999999999999999, 0.4621359223300971, 0.8), (0.3999999999999999, 0.45048543689320386, 0.8), (0.3999999999999999, 0.4388349514563107, 0.8), (0.3999999999999999, 0.42718446601941745, 0.8), (0.3999999999999999, 0.4155339805825243, 0.8), (0.3999999999999999, 0.40388349514563104, 0.8), (0.4077669902912617, 0.3999999999999999, 0.8), (0.4194174757281549, 0.3999999999999999, 0.8), (0.4310679611650481, 0.3999999999999999, 0.8), (0.4427184466019413, 0.3999999999999999, 0.8), (0.4543689320388345, 0.3999999999999999, 0.8), (0.4660194174757277, 0.3999999999999999, 0.8), (0.4776699029126209, 0.3999999999999999, 0.8), (0.4893203883495141, 0.3999999999999999, 0.8), (0.5009708737864074, 0.3999999999999999, 0.8), (0.5126213592233005, 0.3999999999999999, 0.8), (0.5242718446601937, 0.3999999999999999, 0.8), (0.5359223300970869, 0.3999999999999999, 0.8), (0.5475728155339801, 0.3999999999999999, 0.8), (0.5592233009708734, 0.3999999999999999, 0.8), (0.5708737864077665, 0.3999999999999999, 0.8), (0.5825242718446597, 0.3999999999999999, 0.8), (0.5941747572815529, 0.3999999999999999, 0.8), (0.6058252427184462, 0.3999999999999999, 0.8), (0.6174757281553394, 0.3999999999999999, 0.8), (0.6291262135922325, 0.3999999999999999, 0.8), (0.6407766990291257, 0.3999999999999999, 0.8), (0.652427184466019, 0.3999999999999999, 0.8), (0.6640776699029122, 0.3999999999999999, 0.8), (0.6757281553398053, 0.3999999999999999, 0.8), (0.6873786407766991, 0.3999999999999999, 0.8), (0.6990291262135917, 0.3999999999999999, 0.8), (0.7106796116504854, 0.3999999999999999, 0.8), (0.7223300970873782, 0.3999999999999999, 0.8), (0.7339805825242719, 0.3999999999999999, 0.8), (0.7456310679611646, 0.3999999999999999, 0.8), (0.7572815533980584, 0.3999999999999999, 0.8), (0.768932038834951, 0.3999999999999999, 0.8), (0.7805825242718447, 0.3999999999999999, 0.8), (0.7922330097087373, 0.3999999999999999, 0.8), (0.8, 0.3999999999999999, 0.7961165048543686), (0.8, 0.3999999999999999, 0.784466019417476), (0.8, 0.3999999999999999, 0.7728155339805821), (0.8, 0.3999999999999999, 0.7611650485436894), (0.8, 0.3999999999999999, 0.7495145631067957), (0.8, 0.3999999999999999, 0.737864077669903), (0.8, 0.3999999999999999, 0.