# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubscriptionArgs', 'Subscription']

@pulumi.input_type
class SubscriptionArgs:
    def __init__(__self__, *,
                 changes: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionChangeArgs']]]] = None,
                 destination: Optional[pulumi.Input['SubscriptionDestinationArgs']] = None,
                 format: Optional[pulumi.Input['SubscriptionFormatArgs']] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageArgs']]]] = None):
        """
        The set of arguments for constructing a Subscription resource.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionChangeArgs']]] changes: The change notifications subscribed to
        :param pulumi.Input['SubscriptionDestinationArgs'] destination: The Message Queue into which the notifications are to be sentSee also the [Destination API
               Docs](https://docs.commercetools.com/api/projects/subscriptions#destination)
        :param pulumi.Input['SubscriptionFormatArgs'] format: The [format](https://docs.commercetools.com/api/projects/subscriptions#format) in which the payload is delivered
        :param pulumi.Input[str] key: User-specific unique identifier for the subscription
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageArgs']]] messages: The messages subscribed to
        """
        if changes is not None:
            pulumi.set(__self__, "changes", changes)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if messages is not None:
            pulumi.set(__self__, "messages", messages)

    @property
    @pulumi.getter
    def changes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionChangeArgs']]]]:
        """
        The change notifications subscribed to
        """
        return pulumi.get(self, "changes")

    @changes.setter
    def changes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionChangeArgs']]]]):
        pulumi.set(self, "changes", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['SubscriptionDestinationArgs']]:
        """
        The Message Queue into which the notifications are to be sentSee also the [Destination API
        Docs](https://docs.commercetools.com/api/projects/subscriptions#destination)
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['SubscriptionDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input['SubscriptionFormatArgs']]:
        """
        The [format](https://docs.commercetools.com/api/projects/subscriptions#format) in which the payload is delivered
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input['SubscriptionFormatArgs']]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        User-specific unique identifier for the subscription
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageArgs']]]]:
        """
        The messages subscribed to
        """
        return pulumi.get(self, "messages")

    @messages.setter
    def messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageArgs']]]]):
        pulumi.set(self, "messages", value)


@pulumi.input_type
class _SubscriptionState:
    def __init__(__self__, *,
                 changes: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionChangeArgs']]]] = None,
                 destination: Optional[pulumi.Input['SubscriptionDestinationArgs']] = None,
                 format: Optional[pulumi.Input['SubscriptionFormatArgs']] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageArgs']]]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Subscription resources.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionChangeArgs']]] changes: The change notifications subscribed to
        :param pulumi.Input['SubscriptionDestinationArgs'] destination: The Message Queue into which the notifications are to be sentSee also the [Destination API
               Docs](https://docs.commercetools.com/api/projects/subscriptions#destination)
        :param pulumi.Input['SubscriptionFormatArgs'] format: The [format](https://docs.commercetools.com/api/projects/subscriptions#format) in which the payload is delivered
        :param pulumi.Input[str] key: User-specific unique identifier for the subscription
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageArgs']]] messages: The messages subscribed to
        """
        if changes is not None:
            pulumi.set(__self__, "changes", changes)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if messages is not None:
            pulumi.set(__self__, "messages", messages)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def changes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionChangeArgs']]]]:
        """
        The change notifications subscribed to
        """
        return pulumi.get(self, "changes")

    @changes.setter
    def changes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionChangeArgs']]]]):
        pulumi.set(self, "changes", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['SubscriptionDestinationArgs']]:
        """
        The Message Queue into which the notifications are to be sentSee also the [Destination API
        Docs](https://docs.commercetools.com/api/projects/subscriptions#destination)
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['SubscriptionDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input['SubscriptionFormatArgs']]:
        """
        The [format](https://docs.commercetools.com/api/projects/subscriptions#format) in which the payload is delivered
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input['SubscriptionFormatArgs']]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        User-specific unique identifier for the subscription
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageArgs']]]]:
        """
        The messages subscribed to
        """
        return pulumi.get(self, "messages")

    @messages.setter
    def messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionMessageArgs']]]]):
        pulumi.set(self, "messages", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class Subscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 changes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionChangeArgs']]]]] = None,
                 destination: Optional[pulumi.Input[pulumi.InputType['SubscriptionDestinationArgs']]] = None,
                 format: Optional[pulumi.Input[pulumi.InputType['SubscriptionFormatArgs']]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionMessageArgs']]]]] = None,
                 __props__=None):
        """
        Create a Subscription resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionChangeArgs']]]] changes: The change notifications subscribed to
        :param pulumi.Input[pulumi.InputType['SubscriptionDestinationArgs']] destination: The Message Queue into which the notifications are to be sentSee also the [Destination API
               Docs](https://docs.commercetools.com/api/projects/subscriptions#destination)
        :param pulumi.Input[pulumi.InputType['SubscriptionFormatArgs']] format: The [format](https://docs.commercetools.com/api/projects/subscriptions#format) in which the payload is delivered
        :param pulumi.Input[str] key: User-specific unique identifier for the subscription
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionMessageArgs']]]] messages: The messages subscribed to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SubscriptionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Subscription resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 changes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionChangeArgs']]]]] = None,
                 destination: Optional[pulumi.Input[pulumi.InputType['SubscriptionDestinationArgs']]] = None,
                 format: Optional[pulumi.Input[pulumi.InputType['SubscriptionFormatArgs']]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionMessageArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionArgs.__new__(SubscriptionArgs)

            __props__.__dict__["changes"] = changes
            __props__.__dict__["destination"] = destination
            __props__.__dict__["format"] = format
            __props__.__dict__["key"] = key
            __props__.__dict__["messages"] = messages
            __props__.__dict__["version"] = None
        super(Subscription, __self__).__init__(
            'commercetools:index/subscription:Subscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            changes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionChangeArgs']]]]] = None,
            destination: Optional[pulumi.Input[pulumi.InputType['SubscriptionDestinationArgs']]] = None,
            format: Optional[pulumi.Input[pulumi.InputType['SubscriptionFormatArgs']]] = None,
            key: Optional[pulumi.Input[str]] = None,
            messages: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionMessageArgs']]]]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'Subscription':
        """
        Get an existing Subscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionChangeArgs']]]] changes: The change notifications subscribed to
        :param pulumi.Input[pulumi.InputType['SubscriptionDestinationArgs']] destination: The Message Queue into which the notifications are to be sentSee also the [Destination API
               Docs](https://docs.commercetools.com/api/projects/subscriptions#destination)
        :param pulumi.Input[pulumi.InputType['SubscriptionFormatArgs']] format: The [format](https://docs.commercetools.com/api/projects/subscriptions#format) in which the payload is delivered
        :param pulumi.Input[str] key: User-specific unique identifier for the subscription
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubscriptionMessageArgs']]]] messages: The messages subscribed to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriptionState.__new__(_SubscriptionState)

        __props__.__dict__["changes"] = changes
        __props__.__dict__["destination"] = destination
        __props__.__dict__["format"] = format
        __props__.__dict__["key"] = key
        __props__.__dict__["messages"] = messages
        __props__.__dict__["version"] = version
        return Subscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def changes(self) -> pulumi.Output[Optional[Sequence['outputs.SubscriptionChange']]]:
        """
        The change notifications subscribed to
        """
        return pulumi.get(self, "changes")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[Optional['outputs.SubscriptionDestination']]:
        """
        The Message Queue into which the notifications are to be sentSee also the [Destination API
        Docs](https://docs.commercetools.com/api/projects/subscriptions#destination)
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional['outputs.SubscriptionFormat']]:
        """
        The [format](https://docs.commercetools.com/api/projects/subscriptions#format) in which the payload is delivered
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[str]]:
        """
        User-specific unique identifier for the subscription
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def messages(self) -> pulumi.Output[Optional[Sequence['outputs.SubscriptionMessage']]]:
        """
        The messages subscribed to
        """
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        return pulumi.get(self, "version")

