# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class ResourceDirectoryFolderNode(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        children: List['ResourceDirectoryFolderNode'] = None,
        display_name: str = None,
        folder_id: str = None,
        folder_name: str = None,
        parent_folder_id: str = None,
    ):
        self.account_id = account_id
        self.children = children
        self.display_name = display_name
        self.folder_id = folder_id
        self.folder_name = folder_name
        self.parent_folder_id = parent_folder_id

    def validate(self):
        if self.children:
            for k in self.children:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        result['Children'] = []
        if self.children is not None:
            for k in self.children:
                result['Children'].append(k.to_map() if k else None)
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.folder_name is not None:
            result['FolderName'] = self.folder_name
        if self.parent_folder_id is not None:
            result['ParentFolderId'] = self.parent_folder_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        self.children = []
        if m.get('Children') is not None:
            for k in m.get('Children'):
                temp_model = ResourceDirectoryFolderNode()
                self.children.append(temp_model.from_map(k))
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('FolderName') is not None:
            self.folder_name = m.get('FolderName')
        if m.get('ParentFolderId') is not None:
            self.parent_folder_id = m.get('ParentFolderId')
        return self


class ActiveAggregateConfigRulesRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
        config_rule_ids: str = None,
    ):
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The rule ID.
        self.compliance_pack_id = compliance_pack_id
        # The error code returned.
        # 
        # *   If the rule is enabled, no error code is returned.
        # *   If the rule fails to be enabled, an error code is returned. For more information about error codes, see [Error codes](https://error-center.alibabacloud.com/status/product/Config).
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class ActiveAggregateConfigRulesResponseBodyOperateRuleResultOperateRuleItemList(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The error code.
        self.error_code = error_code
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ActiveAggregateConfigRulesResponseBodyOperateRuleResult(TeaModel):
    def __init__(
        self,
        operate_rule_item_list: List[ActiveAggregateConfigRulesResponseBodyOperateRuleResultOperateRuleItemList] = None,
    ):
        # The result information about the operation.
        self.operate_rule_item_list = operate_rule_item_list

    def validate(self):
        if self.operate_rule_item_list:
            for k in self.operate_rule_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateRuleItemList'] = []
        if self.operate_rule_item_list is not None:
            for k in self.operate_rule_item_list:
                result['OperateRuleItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_rule_item_list = []
        if m.get('OperateRuleItemList') is not None:
            for k in m.get('OperateRuleItemList'):
                temp_model = ActiveAggregateConfigRulesResponseBodyOperateRuleResultOperateRuleItemList()
                self.operate_rule_item_list.append(temp_model.from_map(k))
        return self


class ActiveAggregateConfigRulesResponseBody(TeaModel):
    def __init__(
        self,
        operate_rule_result: ActiveAggregateConfigRulesResponseBodyOperateRuleResult = None,
        request_id: str = None,
    ):
        # The results of the operations.
        self.operate_rule_result = operate_rule_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.operate_rule_result:
            self.operate_rule_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_rule_result is not None:
            result['OperateRuleResult'] = self.operate_rule_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateRuleResult') is not None:
            temp_model = ActiveAggregateConfigRulesResponseBodyOperateRuleResult()
            self.operate_rule_result = temp_model.from_map(m['OperateRuleResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ActiveAggregateConfigRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ActiveAggregateConfigRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ActiveAggregateConfigRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ActiveConfigRulesRequest(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        config_rule_ids: str = None,
    ):
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The rule ID. Separate multiple rule IDs with commas (,).
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class ActiveConfigRulesResponseBodyOperateRuleResultOperateRuleItemList(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The error code.
        # 
        # *   If the rule is enabled, no error code is returned.
        # *   If the rule fails to be enabled, an error code is returned. For more information about error codes, see [Error codes](https://next.api.aliyun.com/document/Config/2020-09-07/errorCode).
        self.error_code = error_code
        # Indicates whether the rule is enabled. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ActiveConfigRulesResponseBodyOperateRuleResult(TeaModel):
    def __init__(
        self,
        operate_rule_item_list: List[ActiveConfigRulesResponseBodyOperateRuleResultOperateRuleItemList] = None,
    ):
        # The returned results.
        self.operate_rule_item_list = operate_rule_item_list

    def validate(self):
        if self.operate_rule_item_list:
            for k in self.operate_rule_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateRuleItemList'] = []
        if self.operate_rule_item_list is not None:
            for k in self.operate_rule_item_list:
                result['OperateRuleItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_rule_item_list = []
        if m.get('OperateRuleItemList') is not None:
            for k in m.get('OperateRuleItemList'):
                temp_model = ActiveConfigRulesResponseBodyOperateRuleResultOperateRuleItemList()
                self.operate_rule_item_list.append(temp_model.from_map(k))
        return self


class ActiveConfigRulesResponseBody(TeaModel):
    def __init__(
        self,
        operate_rule_result: ActiveConfigRulesResponseBodyOperateRuleResult = None,
        request_id: str = None,
    ):
        # The returned results.
        self.operate_rule_result = operate_rule_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.operate_rule_result:
            self.operate_rule_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_rule_result is not None:
            result['OperateRuleResult'] = self.operate_rule_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateRuleResult') is not None:
            temp_model = ActiveConfigRulesResponseBodyOperateRuleResult()
            self.operate_rule_result = temp_model.from_map(m['OperateRuleResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ActiveConfigRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ActiveConfigRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ActiveConfigRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachAggregateConfigRuleToCompliancePackRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
        config_rule_ids: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListAggregateCompliancePacks](https://help.aliyun.com/document_detail/262059.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id
        # The rule IDs. Separate multiple rule IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        # 
        # This parameter is required.
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class AttachAggregateConfigRuleToCompliancePackResponseBodyOperateRuleResultOperateRuleItemList(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The error code.
        # 
        # *   This parameter is empty if the rule is added to the compliance package.
        # *   An error code is returned if the rule fails to be added to the compliance package. For more information about error codes, see [Error codes](https://error-center.alibabacloud.com/status/product/Config).
        self.error_code = error_code
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AttachAggregateConfigRuleToCompliancePackResponseBodyOperateRuleResult(TeaModel):
    def __init__(
        self,
        operate_rule_item_list: List[AttachAggregateConfigRuleToCompliancePackResponseBodyOperateRuleResultOperateRuleItemList] = None,
    ):
        # The result of the operation to add the rule.
        self.operate_rule_item_list = operate_rule_item_list

    def validate(self):
        if self.operate_rule_item_list:
            for k in self.operate_rule_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateRuleItemList'] = []
        if self.operate_rule_item_list is not None:
            for k in self.operate_rule_item_list:
                result['OperateRuleItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_rule_item_list = []
        if m.get('OperateRuleItemList') is not None:
            for k in m.get('OperateRuleItemList'):
                temp_model = AttachAggregateConfigRuleToCompliancePackResponseBodyOperateRuleResultOperateRuleItemList()
                self.operate_rule_item_list.append(temp_model.from_map(k))
        return self


class AttachAggregateConfigRuleToCompliancePackResponseBody(TeaModel):
    def __init__(
        self,
        operate_rule_result: AttachAggregateConfigRuleToCompliancePackResponseBodyOperateRuleResult = None,
        request_id: str = None,
    ):
        # The results of the operations to add one or more rules.
        self.operate_rule_result = operate_rule_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.operate_rule_result:
            self.operate_rule_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_rule_result is not None:
            result['OperateRuleResult'] = self.operate_rule_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateRuleResult') is not None:
            temp_model = AttachAggregateConfigRuleToCompliancePackResponseBodyOperateRuleResult()
            self.operate_rule_result = temp_model.from_map(m['OperateRuleResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachAggregateConfigRuleToCompliancePackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachAggregateConfigRuleToCompliancePackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachAggregateConfigRuleToCompliancePackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachConfigRuleToCompliancePackRequest(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        config_rule_ids: str = None,
    ):
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListCompliancePacks](https://help.aliyun.com/document_detail/263332.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id
        # The rule ID. Separate multiple rule IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a rule, see [ListConfigRules](https://help.aliyun.com/document_detail/169607.html).
        # 
        # This parameter is required.
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class AttachConfigRuleToCompliancePackResponseBodyOperateRuleResultOperateRuleItemList(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The error code returned.
        # 
        # *   This parameter is empty if the rule is added to the compliance package.
        # *   An error code is returned if the rule fails to be added to the compliance package. For more information about error codes, see [Error codes](https://error-center.alibabacloud.com/status/product/Config).
        self.error_code = error_code
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AttachConfigRuleToCompliancePackResponseBodyOperateRuleResult(TeaModel):
    def __init__(
        self,
        operate_rule_item_list: List[AttachConfigRuleToCompliancePackResponseBodyOperateRuleResultOperateRuleItemList] = None,
    ):
        # The result of the operation to add the rule.
        self.operate_rule_item_list = operate_rule_item_list

    def validate(self):
        if self.operate_rule_item_list:
            for k in self.operate_rule_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateRuleItemList'] = []
        if self.operate_rule_item_list is not None:
            for k in self.operate_rule_item_list:
                result['OperateRuleItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_rule_item_list = []
        if m.get('OperateRuleItemList') is not None:
            for k in m.get('OperateRuleItemList'):
                temp_model = AttachConfigRuleToCompliancePackResponseBodyOperateRuleResultOperateRuleItemList()
                self.operate_rule_item_list.append(temp_model.from_map(k))
        return self


class AttachConfigRuleToCompliancePackResponseBody(TeaModel):
    def __init__(
        self,
        operate_rule_result: AttachConfigRuleToCompliancePackResponseBodyOperateRuleResult = None,
        request_id: str = None,
    ):
        # The results of the operations to add one or more rules.
        self.operate_rule_result = operate_rule_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.operate_rule_result:
            self.operate_rule_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_rule_result is not None:
            result['OperateRuleResult'] = self.operate_rule_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateRuleResult') is not None:
            temp_model = AttachConfigRuleToCompliancePackResponseBodyOperateRuleResult()
            self.operate_rule_result = temp_model.from_map(m['OperateRuleResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachConfigRuleToCompliancePackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachConfigRuleToCompliancePackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachConfigRuleToCompliancePackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyCompliancePacksRequest(TeaModel):
    def __init__(
        self,
        des_aggregator_ids: str = None,
        src_aggregator_id: str = None,
        src_compliance_pack_ids: str = None,
    ):
        # The IDs of the destination account groups into which the compliance packages are replicated. Separate multiple account group IDs with commas (,).
        # 
        # > If this parameter is left empty, the compliance packages are replicated to the current account group.
        self.des_aggregator_ids = des_aggregator_ids
        # The ID of the account group to which the compliance packages belong.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        self.src_aggregator_id = src_aggregator_id
        # The IDs of the compliance packages. Separate multiple compliance package IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListCompliancePacks](https://help.aliyun.com/document_detail/263332.html).
        # 
        # This parameter is required.
        self.src_compliance_pack_ids = src_compliance_pack_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.des_aggregator_ids is not None:
            result['DesAggregatorIds'] = self.des_aggregator_ids
        if self.src_aggregator_id is not None:
            result['SrcAggregatorId'] = self.src_aggregator_id
        if self.src_compliance_pack_ids is not None:
            result['SrcCompliancePackIds'] = self.src_compliance_pack_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesAggregatorIds') is not None:
            self.des_aggregator_ids = m.get('DesAggregatorIds')
        if m.get('SrcAggregatorId') is not None:
            self.src_aggregator_id = m.get('SrcAggregatorId')
        if m.get('SrcCompliancePackIds') is not None:
            self.src_compliance_pack_ids = m.get('SrcCompliancePackIds')
        return self


class CopyCompliancePacksResponseBody(TeaModel):
    def __init__(
        self,
        copy_rules_result: bool = None,
        request_id: str = None,
    ):
        # Indicates whether the compliance packages are replicated. Valid values:
        # 
        # *   true
        # *   false
        self.copy_rules_result = copy_rules_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.copy_rules_result is not None:
            result['CopyRulesResult'] = self.copy_rules_result
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CopyRulesResult') is not None:
            self.copy_rules_result = m.get('CopyRulesResult')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyCompliancePacksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CopyCompliancePacksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyCompliancePacksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyConfigRulesRequest(TeaModel):
    def __init__(
        self,
        des_aggregator_ids: str = None,
        src_aggregator_id: str = None,
        src_config_rule_ids: str = None,
    ):
        # The IDs of the destination account groups into which the rules are replicated. Separate multiple account group IDs with commas (,).
        # 
        # > If you leave this parameter empty, the compliance packages are replicated into the same account group.
        self.des_aggregator_ids = des_aggregator_ids
        # The ID of the account group to which the rules belong.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        self.src_aggregator_id = src_aggregator_id
        # The rule IDs. Separate multiple rule IDs with commas (,).
        # 
        # This parameter is required.
        self.src_config_rule_ids = src_config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.des_aggregator_ids is not None:
            result['DesAggregatorIds'] = self.des_aggregator_ids
        if self.src_aggregator_id is not None:
            result['SrcAggregatorId'] = self.src_aggregator_id
        if self.src_config_rule_ids is not None:
            result['SrcConfigRuleIds'] = self.src_config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesAggregatorIds') is not None:
            self.des_aggregator_ids = m.get('DesAggregatorIds')
        if m.get('SrcAggregatorId') is not None:
            self.src_aggregator_id = m.get('SrcAggregatorId')
        if m.get('SrcConfigRuleIds') is not None:
            self.src_config_rule_ids = m.get('SrcConfigRuleIds')
        return self


class CopyConfigRulesResponseBody(TeaModel):
    def __init__(
        self,
        copy_rules_result: bool = None,
        request_id: str = None,
    ):
        # Indicates whether the rules are replicated. Valid values:
        # 
        # *   true
        # *   false
        self.copy_rules_result = copy_rules_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.copy_rules_result is not None:
            result['CopyRulesResult'] = self.copy_rules_result
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CopyRulesResult') is not None:
            self.copy_rules_result = m.get('CopyRulesResult')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyConfigRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CopyConfigRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyConfigRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAdvancedSearchFileRequest(TeaModel):
    def __init__(
        self,
        sql: str = None,
    ):
        # The SQL statement used to query resources.
        # 
        # This parameter is required.
        self.sql = sql

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sql is not None:
            result['Sql'] = self.sql
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Sql') is not None:
            self.sql = m.get('Sql')
        return self


class CreateAdvancedSearchFileResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAdvancedSearchFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAdvancedSearchFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAdvancedSearchFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAggregateAdvancedSearchFileRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        sql: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The SQL statement used to query resources.
        # 
        # This parameter is required.
        self.sql = sql

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.sql is not None:
            result['Sql'] = self.sql
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('Sql') is not None:
            self.sql = m.get('Sql')
        return self


class CreateAggregateAdvancedSearchFileResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAggregateAdvancedSearchFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAggregateAdvancedSearchFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAggregateAdvancedSearchFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAggregateCompliancePackRequestConfigRulesConfigRuleParameters(TeaModel):
    def __init__(
        self,
        parameter_name: str = None,
        parameter_value: str = None,
    ):
        # The name of the input parameter.
        # 
        # You must configure the `ParameterName` and `ParameterValue` parameters or neither of them. If the managed rule has an input parameter but no default value exists, you must configure this parameter. For more information about how to obtain the name of an input parameter for a managed rule, see [ListCompliancePackTemplates](https://help.aliyun.com/document_detail/261176.html).
        self.parameter_name = parameter_name
        # The value of the input parameter.
        # 
        # You must configure the `ParameterName` and `ParameterValue` parameters or neither of them. If the managed rule has an input parameter but no default value exists, you must configure this parameter. For more information about how to obtain the value of an input parameter for a managed rule, see [ListCompliancePackTemplates](https://help.aliyun.com/document_detail/261176.html).
        self.parameter_value = parameter_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_value is not None:
            result['ParameterValue'] = self.parameter_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterValue') is not None:
            self.parameter_value = m.get('ParameterValue')
        return self


class CreateAggregateCompliancePackRequestConfigRules(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        config_rule_name: str = None,
        config_rule_parameters: List[CreateAggregateCompliancePackRequestConfigRulesConfigRuleParameters] = None,
        description: str = None,
        managed_rule_identifier: str = None,
        risk_level: int = None,
    ):
        # The rule ID. If you configure this parameter, Cloud Config adds the rule that has the specified ID to the compliance package.
        # 
        # You need to only configure the `ManagedRuleIdentifier` or `ConfigRuleId` parameter. If you configure both parameters, the value of the `ConfigRuleId` parameter takes precedence. For more information about how to obtain the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        self.config_rule_id = config_rule_id
        # The rule name.
        self.config_rule_name = config_rule_name
        # The input parameters of the rule.
        self.config_rule_parameters = config_rule_parameters
        # The rule description.
        self.description = description
        # The identifier of the managed rule. Cloud Config automatically creates a rule based on the identifier of the managed rule and adds the rule to the current compliance package.
        # 
        # You need to only configure the `ManagedRuleIdentifier` or `ConfigRuleId` parameter. If you configure both parameters, the value of the `ConfigRuleId` parameter takes precedence. For more information about how to obtain the identifier of a managed rule, see [ListCompliancePackTemplates](https://help.aliyun.com/document_detail/261176.html).
        self.managed_rule_identifier = managed_rule_identifier
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high
        # *   2: medium
        # *   3: low
        self.risk_level = risk_level

    def validate(self):
        if self.config_rule_parameters:
            for k in self.config_rule_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        result['ConfigRuleParameters'] = []
        if self.config_rule_parameters is not None:
            for k in self.config_rule_parameters:
                result['ConfigRuleParameters'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.managed_rule_identifier is not None:
            result['ManagedRuleIdentifier'] = self.managed_rule_identifier
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        self.config_rule_parameters = []
        if m.get('ConfigRuleParameters') is not None:
            for k in m.get('ConfigRuleParameters'):
                temp_model = CreateAggregateCompliancePackRequestConfigRulesConfigRuleParameters()
                self.config_rule_parameters.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ManagedRuleIdentifier') is not None:
            self.managed_rule_identifier = m.get('ManagedRuleIdentifier')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class CreateAggregateCompliancePackRequestExcludeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The tag key.
        self.tag_key = tag_key
        # The tag value.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateAggregateCompliancePackRequestTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The tag key.
        self.tag_key = tag_key
        # The tag value.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateAggregateCompliancePackRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        client_token: str = None,
        compliance_pack_name: str = None,
        compliance_pack_template_id: str = None,
        config_rules: List[CreateAggregateCompliancePackRequestConfigRules] = None,
        default_enable: bool = None,
        description: str = None,
        exclude_region_ids_scope: str = None,
        exclude_resource_group_ids_scope: str = None,
        exclude_resource_ids_scope: str = None,
        exclude_tags_scope: List[CreateAggregateCompliancePackRequestExcludeTagsScope] = None,
        region_ids_scope: str = None,
        resource_group_ids_scope: str = None,
        resource_ids_scope: str = None,
        risk_level: int = None,
        tag_key_scope: str = None,
        tag_value_scope: str = None,
        tags_scope: List[CreateAggregateCompliancePackRequestTagsScope] = None,
        template_content: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The client token that you want to use to ensure the idempotency of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.``
        self.client_token = client_token
        # The name of the compliance package.
        # 
        # This parameter is required.
        self.compliance_pack_name = compliance_pack_name
        # The ID of the compliance package template from which you want to create a compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package template, see [ListCompliancePackTemplates](https://help.aliyun.com/document_detail/261176.html).
        self.compliance_pack_template_id = compliance_pack_template_id
        # The rules in the compliance package.
        # 
        # >  You must configure this parameter or the `TemplateContent` parameter.
        self.config_rules = config_rules
        # Specifies whether to enable the rule together with the compliance package. Valid values:
        # 
        # *   true: The system enables the rule together with the compliance package.
        # *   false: The system does not enable the rule together with the compliance package.
        self.default_enable = default_enable
        # The description of the compliance package.
        self.description = description
        # The IDs of the regions excluded from the compliance evaluations performed by the compliance package. Separate multiple region IDs with commas (,).
        self.exclude_region_ids_scope = exclude_region_ids_scope
        # The IDs of the resource groups excluded from the compliance evaluations performed by the rule. Separate multiple resource group IDs with commas (,).
        self.exclude_resource_group_ids_scope = exclude_resource_group_ids_scope
        # The ID of the resource that you do not want to evaluate by using the compliance package. Separate multiple resource IDs with commas (,).
        self.exclude_resource_ids_scope = exclude_resource_ids_scope
        # The tags that are excluded.
        self.exclude_tags_scope = exclude_tags_scope
        # The ID of the region whose resources you want to evaluate by using the compliance package. Separate multiple region IDs with commas (,).
        self.region_ids_scope = region_ids_scope
        # The ID of the resource group whose resources you want to evaluate by using the compliance package. Separate multiple resource group IDs with commas (,).
        self.resource_group_ids_scope = resource_group_ids_scope
        # The IDs of the resources to which the rule applies. Separate multiple resource IDs with commas (,).
        self.resource_ids_scope = resource_ids_scope
        # The risk level of the resources that are not compliant with the rules in the compliance package. Valid values:
        # 
        # *   1: high
        # *   2 (default): medium
        # *   3: low
        self.risk_level = risk_level
        # The tag key of the resource that you want to evaluate by using the compliance package.
        self.tag_key_scope = tag_key_scope
        # The tag value of the resource that you want to evaluate by using the compliance package.
        # 
        # >  You must configure the TagValueScope parameter together with the TagKeyScope parameter.
        self.tag_value_scope = tag_value_scope
        # The tag scope.
        self.tags_scope = tags_scope
        # The information about the template that is used to create the compliance package. You can call the GetAggregateCompliancePack operation to view the details of an existing compliance package. You can also write a compliance package template. For more information, see [Write a compliance package template in a configuration file](https://help.aliyun.com/document_detail/2659733.html).
        # 
        # >  You must configure this parameter or the `TemplateContent` parameter.
        self.template_content = template_content

    def validate(self):
        if self.config_rules:
            for k in self.config_rules:
                if k:
                    k.validate()
        if self.exclude_tags_scope:
            for k in self.exclude_tags_scope:
                if k:
                    k.validate()
        if self.tags_scope:
            for k in self.tags_scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.compliance_pack_name is not None:
            result['CompliancePackName'] = self.compliance_pack_name
        if self.compliance_pack_template_id is not None:
            result['CompliancePackTemplateId'] = self.compliance_pack_template_id
        result['ConfigRules'] = []
        if self.config_rules is not None:
            for k in self.config_rules:
                result['ConfigRules'].append(k.to_map() if k else None)
        if self.default_enable is not None:
            result['DefaultEnable'] = self.default_enable
        if self.description is not None:
            result['Description'] = self.description
        if self.exclude_region_ids_scope is not None:
            result['ExcludeRegionIdsScope'] = self.exclude_region_ids_scope
        if self.exclude_resource_group_ids_scope is not None:
            result['ExcludeResourceGroupIdsScope'] = self.exclude_resource_group_ids_scope
        if self.exclude_resource_ids_scope is not None:
            result['ExcludeResourceIdsScope'] = self.exclude_resource_ids_scope
        result['ExcludeTagsScope'] = []
        if self.exclude_tags_scope is not None:
            for k in self.exclude_tags_scope:
                result['ExcludeTagsScope'].append(k.to_map() if k else None)
        if self.region_ids_scope is not None:
            result['RegionIdsScope'] = self.region_ids_scope
        if self.resource_group_ids_scope is not None:
            result['ResourceGroupIdsScope'] = self.resource_group_ids_scope
        if self.resource_ids_scope is not None:
            result['ResourceIdsScope'] = self.resource_ids_scope
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.tag_key_scope is not None:
            result['TagKeyScope'] = self.tag_key_scope
        if self.tag_value_scope is not None:
            result['TagValueScope'] = self.tag_value_scope
        result['TagsScope'] = []
        if self.tags_scope is not None:
            for k in self.tags_scope:
                result['TagsScope'].append(k.to_map() if k else None)
        if self.template_content is not None:
            result['TemplateContent'] = self.template_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CompliancePackName') is not None:
            self.compliance_pack_name = m.get('CompliancePackName')
        if m.get('CompliancePackTemplateId') is not None:
            self.compliance_pack_template_id = m.get('CompliancePackTemplateId')
        self.config_rules = []
        if m.get('ConfigRules') is not None:
            for k in m.get('ConfigRules'):
                temp_model = CreateAggregateCompliancePackRequestConfigRules()
                self.config_rules.append(temp_model.from_map(k))
        if m.get('DefaultEnable') is not None:
            self.default_enable = m.get('DefaultEnable')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExcludeRegionIdsScope') is not None:
            self.exclude_region_ids_scope = m.get('ExcludeRegionIdsScope')
        if m.get('ExcludeResourceGroupIdsScope') is not None:
            self.exclude_resource_group_ids_scope = m.get('ExcludeResourceGroupIdsScope')
        if m.get('ExcludeResourceIdsScope') is not None:
            self.exclude_resource_ids_scope = m.get('ExcludeResourceIdsScope')
        self.exclude_tags_scope = []
        if m.get('ExcludeTagsScope') is not None:
            for k in m.get('ExcludeTagsScope'):
                temp_model = CreateAggregateCompliancePackRequestExcludeTagsScope()
                self.exclude_tags_scope.append(temp_model.from_map(k))
        if m.get('RegionIdsScope') is not None:
            self.region_ids_scope = m.get('RegionIdsScope')
        if m.get('ResourceGroupIdsScope') is not None:
            self.resource_group_ids_scope = m.get('ResourceGroupIdsScope')
        if m.get('ResourceIdsScope') is not None:
            self.resource_ids_scope = m.get('ResourceIdsScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('TagKeyScope') is not None:
            self.tag_key_scope = m.get('TagKeyScope')
        if m.get('TagValueScope') is not None:
            self.tag_value_scope = m.get('TagValueScope')
        self.tags_scope = []
        if m.get('TagsScope') is not None:
            for k in m.get('TagsScope'):
                temp_model = CreateAggregateCompliancePackRequestTagsScope()
                self.tags_scope.append(temp_model.from_map(k))
        if m.get('TemplateContent') is not None:
            self.template_content = m.get('TemplateContent')
        return self


class CreateAggregateCompliancePackShrinkRequestExcludeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The tag key.
        self.tag_key = tag_key
        # The tag value.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateAggregateCompliancePackShrinkRequestTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The tag key.
        self.tag_key = tag_key
        # The tag value.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateAggregateCompliancePackShrinkRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        client_token: str = None,
        compliance_pack_name: str = None,
        compliance_pack_template_id: str = None,
        config_rules_shrink: str = None,
        default_enable: bool = None,
        description: str = None,
        exclude_region_ids_scope: str = None,
        exclude_resource_group_ids_scope: str = None,
        exclude_resource_ids_scope: str = None,
        exclude_tags_scope: List[CreateAggregateCompliancePackShrinkRequestExcludeTagsScope] = None,
        region_ids_scope: str = None,
        resource_group_ids_scope: str = None,
        resource_ids_scope: str = None,
        risk_level: int = None,
        tag_key_scope: str = None,
        tag_value_scope: str = None,
        tags_scope: List[CreateAggregateCompliancePackShrinkRequestTagsScope] = None,
        template_content: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The client token that you want to use to ensure the idempotency of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.``
        self.client_token = client_token
        # The name of the compliance package.
        # 
        # This parameter is required.
        self.compliance_pack_name = compliance_pack_name
        # The ID of the compliance package template from which you want to create a compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package template, see [ListCompliancePackTemplates](https://help.aliyun.com/document_detail/261176.html).
        self.compliance_pack_template_id = compliance_pack_template_id
        # The rules in the compliance package.
        # 
        # >  You must configure this parameter or the `TemplateContent` parameter.
        self.config_rules_shrink = config_rules_shrink
        # Specifies whether to enable the rule together with the compliance package. Valid values:
        # 
        # *   true: The system enables the rule together with the compliance package.
        # *   false: The system does not enable the rule together with the compliance package.
        self.default_enable = default_enable
        # The description of the compliance package.
        self.description = description
        # The IDs of the regions excluded from the compliance evaluations performed by the compliance package. Separate multiple region IDs with commas (,).
        self.exclude_region_ids_scope = exclude_region_ids_scope
        # The IDs of the resource groups excluded from the compliance evaluations performed by the rule. Separate multiple resource group IDs with commas (,).
        self.exclude_resource_group_ids_scope = exclude_resource_group_ids_scope
        # The ID of the resource that you do not want to evaluate by using the compliance package. Separate multiple resource IDs with commas (,).
        self.exclude_resource_ids_scope = exclude_resource_ids_scope
        # The tags that are excluded.
        self.exclude_tags_scope = exclude_tags_scope
        # The ID of the region whose resources you want to evaluate by using the compliance package. Separate multiple region IDs with commas (,).
        self.region_ids_scope = region_ids_scope
        # The ID of the resource group whose resources you want to evaluate by using the compliance package. Separate multiple resource group IDs with commas (,).
        self.resource_group_ids_scope = resource_group_ids_scope
        # The IDs of the resources to which the rule applies. Separate multiple resource IDs with commas (,).
        self.resource_ids_scope = resource_ids_scope
        # The risk level of the resources that are not compliant with the rules in the compliance package. Valid values:
        # 
        # *   1: high
        # *   2 (default): medium
        # *   3: low
        self.risk_level = risk_level
        # The tag key of the resource that you want to evaluate by using the compliance package.
        self.tag_key_scope = tag_key_scope
        # The tag value of the resource that you want to evaluate by using the compliance package.
        # 
        # >  You must configure the TagValueScope parameter together with the TagKeyScope parameter.
        self.tag_value_scope = tag_value_scope
        # The tag scope.
        self.tags_scope = tags_scope
        # The information about the template that is used to create the compliance package. You can call the GetAggregateCompliancePack operation to view the details of an existing compliance package. You can also write a compliance package template. For more information, see [Write a compliance package template in a configuration file](https://help.aliyun.com/document_detail/2659733.html).
        # 
        # >  You must configure this parameter or the `TemplateContent` parameter.
        self.template_content = template_content

    def validate(self):
        if self.exclude_tags_scope:
            for k in self.exclude_tags_scope:
                if k:
                    k.validate()
        if self.tags_scope:
            for k in self.tags_scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.compliance_pack_name is not None:
            result['CompliancePackName'] = self.compliance_pack_name
        if self.compliance_pack_template_id is not None:
            result['CompliancePackTemplateId'] = self.compliance_pack_template_id
        if self.config_rules_shrink is not None:
            result['ConfigRules'] = self.config_rules_shrink
        if self.default_enable is not None:
            result['DefaultEnable'] = self.default_enable
        if self.description is not None:
            result['Description'] = self.description
        if self.exclude_region_ids_scope is not None:
            result['ExcludeRegionIdsScope'] = self.exclude_region_ids_scope
        if self.exclude_resource_group_ids_scope is not None:
            result['ExcludeResourceGroupIdsScope'] = self.exclude_resource_group_ids_scope
        if self.exclude_resource_ids_scope is not None:
            result['ExcludeResourceIdsScope'] = self.exclude_resource_ids_scope
        result['ExcludeTagsScope'] = []
        if self.exclude_tags_scope is not None:
            for k in self.exclude_tags_scope:
                result['ExcludeTagsScope'].append(k.to_map() if k else None)
        if self.region_ids_scope is not None:
            result['RegionIdsScope'] = self.region_ids_scope
        if self.resource_group_ids_scope is not None:
            result['ResourceGroupIdsScope'] = self.resource_group_ids_scope
        if self.resource_ids_scope is not None:
            result['ResourceIdsScope'] = self.resource_ids_scope
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.tag_key_scope is not None:
            result['TagKeyScope'] = self.tag_key_scope
        if self.tag_value_scope is not None:
            result['TagValueScope'] = self.tag_value_scope
        result['TagsScope'] = []
        if self.tags_scope is not None:
            for k in self.tags_scope:
                result['TagsScope'].append(k.to_map() if k else None)
        if self.template_content is not None:
            result['TemplateContent'] = self.template_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CompliancePackName') is not None:
            self.compliance_pack_name = m.get('CompliancePackName')
        if m.get('CompliancePackTemplateId') is not None:
            self.compliance_pack_template_id = m.get('CompliancePackTemplateId')
        if m.get('ConfigRules') is not None:
            self.config_rules_shrink = m.get('ConfigRules')
        if m.get('DefaultEnable') is not None:
            self.default_enable = m.get('DefaultEnable')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExcludeRegionIdsScope') is not None:
            self.exclude_region_ids_scope = m.get('ExcludeRegionIdsScope')
        if m.get('ExcludeResourceGroupIdsScope') is not None:
            self.exclude_resource_group_ids_scope = m.get('ExcludeResourceGroupIdsScope')
        if m.get('ExcludeResourceIdsScope') is not None:
            self.exclude_resource_ids_scope = m.get('ExcludeResourceIdsScope')
        self.exclude_tags_scope = []
        if m.get('ExcludeTagsScope') is not None:
            for k in m.get('ExcludeTagsScope'):
                temp_model = CreateAggregateCompliancePackShrinkRequestExcludeTagsScope()
                self.exclude_tags_scope.append(temp_model.from_map(k))
        if m.get('RegionIdsScope') is not None:
            self.region_ids_scope = m.get('RegionIdsScope')
        if m.get('ResourceGroupIdsScope') is not None:
            self.resource_group_ids_scope = m.get('ResourceGroupIdsScope')
        if m.get('ResourceIdsScope') is not None:
            self.resource_ids_scope = m.get('ResourceIdsScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('TagKeyScope') is not None:
            self.tag_key_scope = m.get('TagKeyScope')
        if m.get('TagValueScope') is not None:
            self.tag_value_scope = m.get('TagValueScope')
        self.tags_scope = []
        if m.get('TagsScope') is not None:
            for k in m.get('TagsScope'):
                temp_model = CreateAggregateCompliancePackShrinkRequestTagsScope()
                self.tags_scope.append(temp_model.from_map(k))
        if m.get('TemplateContent') is not None:
            self.template_content = m.get('TemplateContent')
        return self


class CreateAggregateCompliancePackResponseBody(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        request_id: str = None,
    ):
        # The compliance package ID.
        self.compliance_pack_id = compliance_pack_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAggregateCompliancePackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAggregateCompliancePackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAggregateCompliancePackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAggregateConfigDeliveryChannelRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        client_token: str = None,
        compliant_snapshot: bool = None,
        configuration_item_change_notification: bool = None,
        configuration_snapshot: bool = None,
        delivery_channel_condition: str = None,
        delivery_channel_name: str = None,
        delivery_channel_target_arn: str = None,
        delivery_channel_type: str = None,
        delivery_snapshot_time: str = None,
        description: str = None,
        non_compliant_notification: bool = None,
        oversized_data_osstarget_arn: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests.
        # 
        # The `token` can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see [Ensure idempotence](https://help.aliyun.com/document_detail/25693.html)
        self.client_token = client_token
        # Specifies whether to deliver scheduled compliant snapshots. Cloud Config delivers scheduled compliant snapshots to Log Service at `04:00Z` and `16:00Z` every day. The time is displayed in UTC. Valid values:
        # 
        # *   true: Cloud Config delivers scheduled compliant snapshots.
        # *   false: Cloud Config does not deliver scheduled compliant snapshots. This is the default value.
        self.compliant_snapshot = compliant_snapshot
        # Specifies whether to deliver resource change logs. If you set this parameter to true, Cloud Config delivers resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:
        # 
        # *   true: Cloud Config delivers resource change logs.
        # *   false: Cloud Config does not deliver resource change logs. This is the default value.
        # 
        # > This parameter is available for delivery channels of the OSS, SLS, and MNS types.
        self.configuration_item_change_notification = configuration_item_change_notification
        # Specifies whether to deliver scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots to OSS, MNS, or Log Service at `04:00Z` and `16:00Z` every day. The time is displayed in UTC. Valid values:
        # 
        # *   true: Cloud Config delivers scheduled resource snapshots.
        # *   false: Cloud Config does not deliver scheduled resource snapshots. This is the default value.
        self.configuration_snapshot = configuration_snapshot
        # The rule that you want to attach to the delivery channel. This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
        # 
        # *   If you set the DeliveryChannelType parameter to MNS, take note of the following settings of the lowest risk level and the resource types of the events to which you want to subscribe:
        # 
        #     *   The lowest risk level of the events to which you want to subscribe is in the following format: `{"filterType":"RuleRiskLevel","value":"1","multiple":false}`.
        # 
        #         The `value` field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
        # 
        #     *   The setting of the resource types of the events to which you want to subscribe is in the following format: `{"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}`.
        # 
        #         The `values` field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array. Example:
        # 
        # `[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}]`
        # 
        # *   If you set the DeliveryChannelType parameter to SLS, the setting of the resource types of the snapshots to which you want to deliver is in the following format: `{"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}`.
        # 
        #     The `values` field specifies the resource types of the snapshots to which you want to deliver. The value of the field is a JSON array. Example:
        # 
        # `[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}]`
        self.delivery_channel_condition = delivery_channel_condition
        # The name of the delivery channel.
        # 
        # > If you do not configure this parameter, this parameter is left empty.
        self.delivery_channel_name = delivery_channel_name
        # The ARN of the delivery destination. Valid values:
        # 
        # *   `acs:oss:{RegionId}:{accountId}:{bucketName}` if your delivery destination is an OSS bucket. Example: `acs:oss:cn-shanghai:100931896542****:new-bucket`.
        # *   `acs:mns:{RegionId}:{accountId}:/topics/{topicName}` if your delivery destination is an MNS topic. Example: `acs:mns:cn-shanghai:100931896542****:/topics/topic1`.
        # *   `acs:log:{RegionId}:{accountId}:project/{projectName}/logstore/{logstoreName}` if your delivery destination is a Log Service Logstore. Example: `acs:log:cn-shanghai:100931896542****:project/project1/logstore/logstore1`.
        # 
        # This parameter is required.
        self.delivery_channel_target_arn = delivery_channel_target_arn
        # The type of the delivery channel. Valid values:
        # 
        # *   OSS: Object Storage Service (OSS)
        # *   MNS: Message Service (MNS)
        # *   SLS: Log Service
        # 
        # This parameter is required.
        self.delivery_channel_type = delivery_channel_type
        # The time when you want Cloud Config to deliver scheduled resource snapshots every day.
        # 
        # Format: `HH:mmZ`. This time is displayed in UTC.
        # 
        # > When you enable the scheduled resource delivery feature, you can configure this parameter to specify a custom delivery time. If you do not configure this parameter, Cloud Config automatically delivers scheduled resource snapshots at `04:00Z` and `16:00Z` every day.
        self.delivery_snapshot_time = delivery_snapshot_time
        # The description of the delivery channel.
        self.description = description
        # Specifies whether to deliver resource non-compliance events. If you set this parameter to true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are considered non-compliant. Valid values:
        # 
        # *   true: Cloud Config delivers resource non-compliance events.
        # *   false: Cloud Config does not deliver resource non-compliance events. This is the default value.
        # 
        # > This parameter is available only for delivery channels of the SLS or MNS type.
        self.non_compliant_notification = non_compliant_notification
        # The ARN of the OSS bucket to which you want to transfer the delivery data when the size of the data exceeds the specified upper limit of the delivery channel. Format: `acs:oss:{RegionId}:{accountId}:{bucketName}`.
        # 
        # If you do not configure this parameter, Cloud Config delivers only summary data.
        # 
        # > This parameter is available only for delivery channels of the SLS or MNS type. The upper limit on the storage size of delivery channels of the SLS type is 1 MB, and the maximum storage size of delivery channels of the MNS type is 64 KB.
        self.oversized_data_osstarget_arn = oversized_data_osstarget_arn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.compliant_snapshot is not None:
            result['CompliantSnapshot'] = self.compliant_snapshot
        if self.configuration_item_change_notification is not None:
            result['ConfigurationItemChangeNotification'] = self.configuration_item_change_notification
        if self.configuration_snapshot is not None:
            result['ConfigurationSnapshot'] = self.configuration_snapshot
        if self.delivery_channel_condition is not None:
            result['DeliveryChannelCondition'] = self.delivery_channel_condition
        if self.delivery_channel_name is not None:
            result['DeliveryChannelName'] = self.delivery_channel_name
        if self.delivery_channel_target_arn is not None:
            result['DeliveryChannelTargetArn'] = self.delivery_channel_target_arn
        if self.delivery_channel_type is not None:
            result['DeliveryChannelType'] = self.delivery_channel_type
        if self.delivery_snapshot_time is not None:
            result['DeliverySnapshotTime'] = self.delivery_snapshot_time
        if self.description is not None:
            result['Description'] = self.description
        if self.non_compliant_notification is not None:
            result['NonCompliantNotification'] = self.non_compliant_notification
        if self.oversized_data_osstarget_arn is not None:
            result['OversizedDataOSSTargetArn'] = self.oversized_data_osstarget_arn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CompliantSnapshot') is not None:
            self.compliant_snapshot = m.get('CompliantSnapshot')
        if m.get('ConfigurationItemChangeNotification') is not None:
            self.configuration_item_change_notification = m.get('ConfigurationItemChangeNotification')
        if m.get('ConfigurationSnapshot') is not None:
            self.configuration_snapshot = m.get('ConfigurationSnapshot')
        if m.get('DeliveryChannelCondition') is not None:
            self.delivery_channel_condition = m.get('DeliveryChannelCondition')
        if m.get('DeliveryChannelName') is not None:
            self.delivery_channel_name = m.get('DeliveryChannelName')
        if m.get('DeliveryChannelTargetArn') is not None:
            self.delivery_channel_target_arn = m.get('DeliveryChannelTargetArn')
        if m.get('DeliveryChannelType') is not None:
            self.delivery_channel_type = m.get('DeliveryChannelType')
        if m.get('DeliverySnapshotTime') is not None:
            self.delivery_snapshot_time = m.get('DeliverySnapshotTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NonCompliantNotification') is not None:
            self.non_compliant_notification = m.get('NonCompliantNotification')
        if m.get('OversizedDataOSSTargetArn') is not None:
            self.oversized_data_osstarget_arn = m.get('OversizedDataOSSTargetArn')
        return self


class CreateAggregateConfigDeliveryChannelResponseBody(TeaModel):
    def __init__(
        self,
        delivery_channel_id: str = None,
        request_id: str = None,
    ):
        # The ID of the delivery channel.
        self.delivery_channel_id = delivery_channel_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_channel_id is not None:
            result['DeliveryChannelId'] = self.delivery_channel_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryChannelId') is not None:
            self.delivery_channel_id = m.get('DeliveryChannelId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAggregateConfigDeliveryChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAggregateConfigDeliveryChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAggregateConfigDeliveryChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAggregateConfigRuleRequestExcludeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The tag key of the resource that you want to exclude.
        self.tag_key = tag_key
        # The tag value of the resource that you want to exclude.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateAggregateConfigRuleRequestTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The tag key.
        self.tag_key = tag_key
        # The tag value.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateAggregateConfigRuleRequest(TeaModel):
    def __init__(
        self,
        account_ids_scope: str = None,
        aggregator_id: str = None,
        client_token: str = None,
        config_rule_name: str = None,
        config_rule_trigger_types: str = None,
        description: str = None,
        exclude_account_ids_scope: str = None,
        exclude_folder_ids_scope: str = None,
        exclude_region_ids_scope: str = None,
        exclude_resource_group_ids_scope: str = None,
        exclude_resource_ids_scope: str = None,
        exclude_tags_scope: List[CreateAggregateConfigRuleRequestExcludeTagsScope] = None,
        extend_content: str = None,
        folder_ids_scope: str = None,
        input_parameters: Dict[str, Any] = None,
        maximum_execution_frequency: str = None,
        region_ids_scope: str = None,
        resource_group_ids_scope: str = None,
        resource_ids_scope: str = None,
        resource_types_scope: List[str] = None,
        risk_level: int = None,
        source_identifier: str = None,
        source_owner: str = None,
        tag_key_logic_scope: str = None,
        tag_key_scope: str = None,
        tag_value_scope: str = None,
        tags_scope: List[CreateAggregateConfigRuleRequestTagsScope] = None,
    ):
        # The IDs of the member accounts to which the rule applies, which means that the resources within the member accounts are evaluated based on the rule. Separate multiple member account IDs with commas (,).
        self.account_ids_scope = account_ids_scope
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The `token` can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token
        # The rule name.
        # 
        # This parameter is required.
        self.config_rule_name = config_rule_name
        # The trigger type of the rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The rule is triggered by configuration changes.
        # *   ScheduledNotification: The rule is periodically triggered.
        # 
        # This parameter is required.
        self.config_rule_trigger_types = config_rule_trigger_types
        # The description of the rule.
        self.description = description
        # The ID of the member account to which the rule does not apply, which means that the resources within the member account are not evaluated based on the rule. Separate multiple member account IDs with commas (,).
        # 
        # > This parameter applies only to a managed rule.
        self.exclude_account_ids_scope = exclude_account_ids_scope
        # The ID of the resource directory to which the rule does not apply, which means that the resources within member accounts in the resource directory are not evaluated based on the rule. Separate multiple resource directory IDs with commas (,).
        # 
        # > 
        # 
        # *   This parameter applies only to a rule of a global account group.
        # 
        # *   This parameter applies only to a managed rule.
        self.exclude_folder_ids_scope = exclude_folder_ids_scope
        # The IDs of the regions to which the rule not applies. Separate multiple region IDs with commas (,).
        self.exclude_region_ids_scope = exclude_region_ids_scope
        # ExcludeResourceGroupIdsScope. Separate multiple resource group IDs with commas (,).
        self.exclude_resource_group_ids_scope = exclude_resource_group_ids_scope
        # The ID of the resource to be excluded from the compliance evaluations performed by the rule. Separate multiple resource IDs with commas (,).
        # 
        # > This parameter applies only to a managed rule.
        self.exclude_resource_ids_scope = exclude_resource_ids_scope
        # The scope of the tag that is excluded.
        self.exclude_tags_scope = exclude_tags_scope
        # The extended content, which is temporarily only used to configure the trigger time with a 24-hour cycle trigger.
        self.extend_content = extend_content
        # The ID of the resource directory to which the rule applies, which means that the resources within member accounts in the resource directory are evaluated based on the rule.
        # 
        # > 
        # 
        # *   This parameter applies only to a rule of a global account group.
        # 
        # *   This parameter applies only to a managed rule.
        self.folder_ids_scope = folder_ids_scope
        # The input parameter of the rule.
        self.input_parameters = input_parameters
        # The interval at which the rule is triggered. Valid values:
        # 
        # *   One_Hour
        # *   Three_Hours
        # *   Six_Hours
        # *   Twelve_Hours
        # *   TwentyFour_Hours (default)
        # 
        # >  This parameter is required if the `ConfigRuleTriggerTypes` parameter is set to `ScheduledNotification`.
        self.maximum_execution_frequency = maximum_execution_frequency
        # The ID of the region to which the rule applies. Separate multiple region IDs with commas (,).
        # 
        # > This parameter applies only to a managed rule.
        self.region_ids_scope = region_ids_scope
        # The ID of the resource group to which the rule applies. Separate multiple resource group IDs with commas (,).
        # 
        # > This parameter applies only to a managed rule.
        self.resource_group_ids_scope = resource_group_ids_scope
        # The IDs of the resources included from the compliance evaluations performed by the rule. Separate multiple resource IDs with commas (,).
        self.resource_ids_scope = resource_ids_scope
        # The type of the resource evaluated by the rule. Separate multiple resource types with commas (,).
        # 
        # This parameter is required.
        self.resource_types_scope = resource_types_scope
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high
        # *   2: medium
        # *   3: low
        # 
        # This parameter is required.
        self.risk_level = risk_level
        # The identifier of the rule.
        # 
        # *   If you set the SourceOwner parameter to ALIYUN, set this parameter to the name of the managed rule.
        # *   If you set the SourceOwner parameter to CUSTOM_FC, set this parameter to the Alibaba Cloud Resource Name (ARN) of the relevant function in Function Compute.
        # 
        # For more information about how to query the name of a managed rule, see [Managed rules](https://help.aliyun.com/document_detail/127404.html).
        # 
        # This parameter is required.
        self.source_identifier = source_identifier
        # The type of the rule. Valid values:
        # 
        # *   ALIYUN: a managed rule.
        # *   CUSTOM_FC: a custom rule.
        # 
        # This parameter is required.
        self.source_owner = source_owner
        # The logical relationship among the tag keys if you specify multiple tag keys for the `TagKeyScope` parameter. For example, if you set the `TagKeyScope` parameter to `ECS,OSS` and the TagKeyLogicScope parameter to `AND`, the rule applies to resources with both the `ECS` and `OSS` tag keys. Valid values:
        # 
        # *   AND
        # *   OR
        self.tag_key_logic_scope = tag_key_logic_scope
        # The tag key used to filter resources. The rule applies only to the resources with the specified tag key. Separate multiple parameter values with commas (,).
        # 
        # > This parameter applies only to a managed rule. You must configure the `TagKeyScope` and `TagValueScope` parameters at the same time.
        self.tag_key_scope = tag_key_scope
        # The tag value used to filter resources. The rule applies only to the resources with the specified tag value.
        # 
        # > This parameter applies only to a managed rule. You must configure the `TagKeyScope` and `TagValueScope` parameters at the same time.
        self.tag_value_scope = tag_value_scope
        # The tag scope.
        self.tags_scope = tags_scope

    def validate(self):
        if self.exclude_tags_scope:
            for k in self.exclude_tags_scope:
                if k:
                    k.validate()
        if self.tags_scope:
            for k in self.tags_scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_ids_scope is not None:
            result['AccountIdsScope'] = self.account_ids_scope
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        if self.config_rule_trigger_types is not None:
            result['ConfigRuleTriggerTypes'] = self.config_rule_trigger_types
        if self.description is not None:
            result['Description'] = self.description
        if self.exclude_account_ids_scope is not None:
            result['ExcludeAccountIdsScope'] = self.exclude_account_ids_scope
        if self.exclude_folder_ids_scope is not None:
            result['ExcludeFolderIdsScope'] = self.exclude_folder_ids_scope
        if self.exclude_region_ids_scope is not None:
            result['ExcludeRegionIdsScope'] = self.exclude_region_ids_scope
        if self.exclude_resource_group_ids_scope is not None:
            result['ExcludeResourceGroupIdsScope'] = self.exclude_resource_group_ids_scope
        if self.exclude_resource_ids_scope is not None:
            result['ExcludeResourceIdsScope'] = self.exclude_resource_ids_scope
        result['ExcludeTagsScope'] = []
        if self.exclude_tags_scope is not None:
            for k in self.exclude_tags_scope:
                result['ExcludeTagsScope'].append(k.to_map() if k else None)
        if self.extend_content is not None:
            result['ExtendContent'] = self.extend_content
        if self.folder_ids_scope is not None:
            result['FolderIdsScope'] = self.folder_ids_scope
        if self.input_parameters is not None:
            result['InputParameters'] = self.input_parameters
        if self.maximum_execution_frequency is not None:
            result['MaximumExecutionFrequency'] = self.maximum_execution_frequency
        if self.region_ids_scope is not None:
            result['RegionIdsScope'] = self.region_ids_scope
        if self.resource_group_ids_scope is not None:
            result['ResourceGroupIdsScope'] = self.resource_group_ids_scope
        if self.resource_ids_scope is not None:
            result['ResourceIdsScope'] = self.resource_ids_scope
        if self.resource_types_scope is not None:
            result['ResourceTypesScope'] = self.resource_types_scope
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.source_identifier is not None:
            result['SourceIdentifier'] = self.source_identifier
        if self.source_owner is not None:
            result['SourceOwner'] = self.source_owner
        if self.tag_key_logic_scope is not None:
            result['TagKeyLogicScope'] = self.tag_key_logic_scope
        if self.tag_key_scope is not None:
            result['TagKeyScope'] = self.tag_key_scope
        if self.tag_value_scope is not None:
            result['TagValueScope'] = self.tag_value_scope
        result['TagsScope'] = []
        if self.tags_scope is not None:
            for k in self.tags_scope:
                result['TagsScope'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountIdsScope') is not None:
            self.account_ids_scope = m.get('AccountIdsScope')
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        if m.get('ConfigRuleTriggerTypes') is not None:
            self.config_rule_trigger_types = m.get('ConfigRuleTriggerTypes')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExcludeAccountIdsScope') is not None:
            self.exclude_account_ids_scope = m.get('ExcludeAccountIdsScope')
        if m.get('ExcludeFolderIdsScope') is not None:
            self.exclude_folder_ids_scope = m.get('ExcludeFolderIdsScope')
        if m.get('ExcludeRegionIdsScope') is not None:
            self.exclude_region_ids_scope = m.get('ExcludeRegionIdsScope')
        if m.get('ExcludeResourceGroupIdsScope') is not None:
            self.exclude_resource_group_ids_scope = m.get('ExcludeResourceGroupIdsScope')
        if m.get('ExcludeResourceIdsScope') is not None:
            self.exclude_resource_ids_scope = m.get('ExcludeResourceIdsScope')
        self.exclude_tags_scope = []
        if m.get('ExcludeTagsScope') is not None:
            for k in m.get('ExcludeTagsScope'):
                temp_model = CreateAggregateConfigRuleRequestExcludeTagsScope()
                self.exclude_tags_scope.append(temp_model.from_map(k))
        if m.get('ExtendContent') is not None:
            self.extend_content = m.get('ExtendContent')
        if m.get('FolderIdsScope') is not None:
            self.folder_ids_scope = m.get('FolderIdsScope')
        if m.get('InputParameters') is not None:
            self.input_parameters = m.get('InputParameters')
        if m.get('MaximumExecutionFrequency') is not None:
            self.maximum_execution_frequency = m.get('MaximumExecutionFrequency')
        if m.get('RegionIdsScope') is not None:
            self.region_ids_scope = m.get('RegionIdsScope')
        if m.get('ResourceGroupIdsScope') is not None:
            self.resource_group_ids_scope = m.get('ResourceGroupIdsScope')
        if m.get('ResourceIdsScope') is not None:
            self.resource_ids_scope = m.get('ResourceIdsScope')
        if m.get('ResourceTypesScope') is not None:
            self.resource_types_scope = m.get('ResourceTypesScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SourceIdentifier') is not None:
            self.source_identifier = m.get('SourceIdentifier')
        if m.get('SourceOwner') is not None:
            self.source_owner = m.get('SourceOwner')
        if m.get('TagKeyLogicScope') is not None:
            self.tag_key_logic_scope = m.get('TagKeyLogicScope')
        if m.get('TagKeyScope') is not None:
            self.tag_key_scope = m.get('TagKeyScope')
        if m.get('TagValueScope') is not None:
            self.tag_value_scope = m.get('TagValueScope')
        self.tags_scope = []
        if m.get('TagsScope') is not None:
            for k in m.get('TagsScope'):
                temp_model = CreateAggregateConfigRuleRequestTagsScope()
                self.tags_scope.append(temp_model.from_map(k))
        return self


class CreateAggregateConfigRuleShrinkRequestExcludeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The tag key of the resource that you want to exclude.
        self.tag_key = tag_key
        # The tag value of the resource that you want to exclude.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateAggregateConfigRuleShrinkRequestTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The tag key.
        self.tag_key = tag_key
        # The tag value.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateAggregateConfigRuleShrinkRequest(TeaModel):
    def __init__(
        self,
        account_ids_scope: str = None,
        aggregator_id: str = None,
        client_token: str = None,
        config_rule_name: str = None,
        config_rule_trigger_types: str = None,
        description: str = None,
        exclude_account_ids_scope: str = None,
        exclude_folder_ids_scope: str = None,
        exclude_region_ids_scope: str = None,
        exclude_resource_group_ids_scope: str = None,
        exclude_resource_ids_scope: str = None,
        exclude_tags_scope: List[CreateAggregateConfigRuleShrinkRequestExcludeTagsScope] = None,
        extend_content: str = None,
        folder_ids_scope: str = None,
        input_parameters_shrink: str = None,
        maximum_execution_frequency: str = None,
        region_ids_scope: str = None,
        resource_group_ids_scope: str = None,
        resource_ids_scope: str = None,
        resource_types_scope_shrink: str = None,
        risk_level: int = None,
        source_identifier: str = None,
        source_owner: str = None,
        tag_key_logic_scope: str = None,
        tag_key_scope: str = None,
        tag_value_scope: str = None,
        tags_scope: List[CreateAggregateConfigRuleShrinkRequestTagsScope] = None,
    ):
        # The IDs of the member accounts to which the rule applies, which means that the resources within the member accounts are evaluated based on the rule. Separate multiple member account IDs with commas (,).
        self.account_ids_scope = account_ids_scope
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The `token` can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token
        # The rule name.
        # 
        # This parameter is required.
        self.config_rule_name = config_rule_name
        # The trigger type of the rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The rule is triggered by configuration changes.
        # *   ScheduledNotification: The rule is periodically triggered.
        # 
        # This parameter is required.
        self.config_rule_trigger_types = config_rule_trigger_types
        # The description of the rule.
        self.description = description
        # The ID of the member account to which the rule does not apply, which means that the resources within the member account are not evaluated based on the rule. Separate multiple member account IDs with commas (,).
        # 
        # > This parameter applies only to a managed rule.
        self.exclude_account_ids_scope = exclude_account_ids_scope
        # The ID of the resource directory to which the rule does not apply, which means that the resources within member accounts in the resource directory are not evaluated based on the rule. Separate multiple resource directory IDs with commas (,).
        # 
        # > 
        # 
        # *   This parameter applies only to a rule of a global account group.
        # 
        # *   This parameter applies only to a managed rule.
        self.exclude_folder_ids_scope = exclude_folder_ids_scope
        # The IDs of the regions to which the rule not applies. Separate multiple region IDs with commas (,).
        self.exclude_region_ids_scope = exclude_region_ids_scope
        # ExcludeResourceGroupIdsScope. Separate multiple resource group IDs with commas (,).
        self.exclude_resource_group_ids_scope = exclude_resource_group_ids_scope
        # The ID of the resource to be excluded from the compliance evaluations performed by the rule. Separate multiple resource IDs with commas (,).
        # 
        # > This parameter applies only to a managed rule.
        self.exclude_resource_ids_scope = exclude_resource_ids_scope
        # The scope of the tag that is excluded.
        self.exclude_tags_scope = exclude_tags_scope
        # The extended content, which is temporarily only used to configure the trigger time with a 24-hour cycle trigger.
        self.extend_content = extend_content
        # The ID of the resource directory to which the rule applies, which means that the resources within member accounts in the resource directory are evaluated based on the rule.
        # 
        # > 
        # 
        # *   This parameter applies only to a rule of a global account group.
        # 
        # *   This parameter applies only to a managed rule.
        self.folder_ids_scope = folder_ids_scope
        # The input parameter of the rule.
        self.input_parameters_shrink = input_parameters_shrink
        # The interval at which the rule is triggered. Valid values:
        # 
        # *   One_Hour
        # *   Three_Hours
        # *   Six_Hours
        # *   Twelve_Hours
        # *   TwentyFour_Hours (default)
        # 
        # >  This parameter is required if the `ConfigRuleTriggerTypes` parameter is set to `ScheduledNotification`.
        self.maximum_execution_frequency = maximum_execution_frequency
        # The ID of the region to which the rule applies. Separate multiple region IDs with commas (,).
        # 
        # > This parameter applies only to a managed rule.
        self.region_ids_scope = region_ids_scope
        # The ID of the resource group to which the rule applies. Separate multiple resource group IDs with commas (,).
        # 
        # > This parameter applies only to a managed rule.
        self.resource_group_ids_scope = resource_group_ids_scope
        # The IDs of the resources included from the compliance evaluations performed by the rule. Separate multiple resource IDs with commas (,).
        self.resource_ids_scope = resource_ids_scope
        # The type of the resource evaluated by the rule. Separate multiple resource types with commas (,).
        # 
        # This parameter is required.
        self.resource_types_scope_shrink = resource_types_scope_shrink
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high
        # *   2: medium
        # *   3: low
        # 
        # This parameter is required.
        self.risk_level = risk_level
        # The identifier of the rule.
        # 
        # *   If you set the SourceOwner parameter to ALIYUN, set this parameter to the name of the managed rule.
        # *   If you set the SourceOwner parameter to CUSTOM_FC, set this parameter to the Alibaba Cloud Resource Name (ARN) of the relevant function in Function Compute.
        # 
        # For more information about how to query the name of a managed rule, see [Managed rules](https://help.aliyun.com/document_detail/127404.html).
        # 
        # This parameter is required.
        self.source_identifier = source_identifier
        # The type of the rule. Valid values:
        # 
        # *   ALIYUN: a managed rule.
        # *   CUSTOM_FC: a custom rule.
        # 
        # This parameter is required.
        self.source_owner = source_owner
        # The logical relationship among the tag keys if you specify multiple tag keys for the `TagKeyScope` parameter. For example, if you set the `TagKeyScope` parameter to `ECS,OSS` and the TagKeyLogicScope parameter to `AND`, the rule applies to resources with both the `ECS` and `OSS` tag keys. Valid values:
        # 
        # *   AND
        # *   OR
        self.tag_key_logic_scope = tag_key_logic_scope
        # The tag key used to filter resources. The rule applies only to the resources with the specified tag key. Separate multiple parameter values with commas (,).
        # 
        # > This parameter applies only to a managed rule. You must configure the `TagKeyScope` and `TagValueScope` parameters at the same time.
        self.tag_key_scope = tag_key_scope
        # The tag value used to filter resources. The rule applies only to the resources with the specified tag value.
        # 
        # > This parameter applies only to a managed rule. You must configure the `TagKeyScope` and `TagValueScope` parameters at the same time.
        self.tag_value_scope = tag_value_scope
        # The tag scope.
        self.tags_scope = tags_scope

    def validate(self):
        if self.exclude_tags_scope:
            for k in self.exclude_tags_scope:
                if k:
                    k.validate()
        if self.tags_scope:
            for k in self.tags_scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_ids_scope is not None:
            result['AccountIdsScope'] = self.account_ids_scope
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        if self.config_rule_trigger_types is not None:
            result['ConfigRuleTriggerTypes'] = self.config_rule_trigger_types
        if self.description is not None:
            result['Description'] = self.description
        if self.exclude_account_ids_scope is not None:
            result['ExcludeAccountIdsScope'] = self.exclude_account_ids_scope
        if self.exclude_folder_ids_scope is not None:
            result['ExcludeFolderIdsScope'] = self.exclude_folder_ids_scope
        if self.exclude_region_ids_scope is not None:
            result['ExcludeRegionIdsScope'] = self.exclude_region_ids_scope
        if self.exclude_resource_group_ids_scope is not None:
            result['ExcludeResourceGroupIdsScope'] = self.exclude_resource_group_ids_scope
        if self.exclude_resource_ids_scope is not None:
            result['ExcludeResourceIdsScope'] = self.exclude_resource_ids_scope
        result['ExcludeTagsScope'] = []
        if self.exclude_tags_scope is not None:
            for k in self.exclude_tags_scope:
                result['ExcludeTagsScope'].append(k.to_map() if k else None)
        if self.extend_content is not None:
            result['ExtendContent'] = self.extend_content
        if self.folder_ids_scope is not None:
            result['FolderIdsScope'] = self.folder_ids_scope
        if self.input_parameters_shrink is not None:
            result['InputParameters'] = self.input_parameters_shrink
        if self.maximum_execution_frequency is not None:
            result['MaximumExecutionFrequency'] = self.maximum_execution_frequency
        if self.region_ids_scope is not None:
            result['RegionIdsScope'] = self.region_ids_scope
        if self.resource_group_ids_scope is not None:
            result['ResourceGroupIdsScope'] = self.resource_group_ids_scope
        if self.resource_ids_scope is not None:
            result['ResourceIdsScope'] = self.resource_ids_scope
        if self.resource_types_scope_shrink is not None:
            result['ResourceTypesScope'] = self.resource_types_scope_shrink
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.source_identifier is not None:
            result['SourceIdentifier'] = self.source_identifier
        if self.source_owner is not None:
            result['SourceOwner'] = self.source_owner
        if self.tag_key_logic_scope is not None:
            result['TagKeyLogicScope'] = self.tag_key_logic_scope
        if self.tag_key_scope is not None:
            result['TagKeyScope'] = self.tag_key_scope
        if self.tag_value_scope is not None:
            result['TagValueScope'] = self.tag_value_scope
        result['TagsScope'] = []
        if self.tags_scope is not None:
            for k in self.tags_scope:
                result['TagsScope'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountIdsScope') is not None:
            self.account_ids_scope = m.get('AccountIdsScope')
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        if m.get('ConfigRuleTriggerTypes') is not None:
            self.config_rule_trigger_types = m.get('ConfigRuleTriggerTypes')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExcludeAccountIdsScope') is not None:
            self.exclude_account_ids_scope = m.get('ExcludeAccountIdsScope')
        if m.get('ExcludeFolderIdsScope') is not None:
            self.exclude_folder_ids_scope = m.get('ExcludeFolderIdsScope')
        if m.get('ExcludeRegionIdsScope') is not None:
            self.exclude_region_ids_scope = m.get('ExcludeRegionIdsScope')
        if m.get('ExcludeResourceGroupIdsScope') is not None:
            self.exclude_resource_group_ids_scope = m.get('ExcludeResourceGroupIdsScope')
        if m.get('ExcludeResourceIdsScope') is not None:
            self.exclude_resource_ids_scope = m.get('ExcludeResourceIdsScope')
        self.exclude_tags_scope = []
        if m.get('ExcludeTagsScope') is not None:
            for k in m.get('ExcludeTagsScope'):
                temp_model = CreateAggregateConfigRuleShrinkRequestExcludeTagsScope()
                self.exclude_tags_scope.append(temp_model.from_map(k))
        if m.get('ExtendContent') is not None:
            self.extend_content = m.get('ExtendContent')
        if m.get('FolderIdsScope') is not None:
            self.folder_ids_scope = m.get('FolderIdsScope')
        if m.get('InputParameters') is not None:
            self.input_parameters_shrink = m.get('InputParameters')
        if m.get('MaximumExecutionFrequency') is not None:
            self.maximum_execution_frequency = m.get('MaximumExecutionFrequency')
        if m.get('RegionIdsScope') is not None:
            self.region_ids_scope = m.get('RegionIdsScope')
        if m.get('ResourceGroupIdsScope') is not None:
            self.resource_group_ids_scope = m.get('ResourceGroupIdsScope')
        if m.get('ResourceIdsScope') is not None:
            self.resource_ids_scope = m.get('ResourceIdsScope')
        if m.get('ResourceTypesScope') is not None:
            self.resource_types_scope_shrink = m.get('ResourceTypesScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SourceIdentifier') is not None:
            self.source_identifier = m.get('SourceIdentifier')
        if m.get('SourceOwner') is not None:
            self.source_owner = m.get('SourceOwner')
        if m.get('TagKeyLogicScope') is not None:
            self.tag_key_logic_scope = m.get('TagKeyLogicScope')
        if m.get('TagKeyScope') is not None:
            self.tag_key_scope = m.get('TagKeyScope')
        if m.get('TagValueScope') is not None:
            self.tag_value_scope = m.get('TagValueScope')
        self.tags_scope = []
        if m.get('TagsScope') is not None:
            for k in m.get('TagsScope'):
                temp_model = CreateAggregateConfigRuleShrinkRequestTagsScope()
                self.tags_scope.append(temp_model.from_map(k))
        return self


class CreateAggregateConfigRuleResponseBody(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        request_id: str = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAggregateConfigRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAggregateConfigRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAggregateConfigRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAggregateRemediationRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        client_token: str = None,
        config_rule_id: str = None,
        invoke_type: str = None,
        params: str = None,
        remediation_template_id: str = None,
        remediation_type: str = None,
        source_type: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The `token` can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token
        # The rule ID.
        # 
        # For more information about how to obtain the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id
        # The execution mode of the remediation template. Valid values:
        # 
        # *   NON_EXECUTION: The remediation template is not executed.
        # *   AUTO_EXECUTION: The remediation template is automatically executed.
        # *   MANUAL_EXECUTION: The remediation template is manually executed.
        # *   NOT_CONFIG: The execution mode is not specified.
        # 
        # This parameter is required.
        self.invoke_type = invoke_type
        # The configuration of the remediation template.
        # 
        # For more information about how to obtain the configuration of the remediation template, see [ListRemediationTemplates](https://help.aliyun.com/document_detail/416781.html). You can view the `TemplateDefinition` response parameter to obtain the configuration of the remediation template.
        # 
        # This parameter is required.
        self.params = params
        # The ID of the remediation template.
        # 
        # *   If you set the `RemediationType` parameter to `OOS`, set this parameter to the identifier of the relevant official remediation template, such as `ACS-OSS-PutBucketAcl`. For more information about how to obtain the remediation template identifier, see [ListRemediationTemplates](https://help.aliyun.com/document_detail/416781.html).
        # *   If you set the `RemediationType` parameter to `FC`, set this parameter to the Alibaba Cloud Resource Name (ARN) of the relevant Function Compute resource, such as `acs:fc:cn-hangzhou:100931896542****:services/ConfigService.LATEST/functions/test-php`.
        # 
        # This parameter is required.
        self.remediation_template_id = remediation_template_id
        # The type of the remediation template. Valid values:
        # 
        # *   OOS: stands for Operation Orchestration Service and indicates official remediation.
        # *   FC: stands for Function Compute and indicates custom remediation.
        # 
        # This parameter is required.
        self.remediation_type = remediation_type
        # The source of remediation template. Valid values:
        # 
        # *   ALIYUN (default): official template.
        # *   CUSTOM: custom template.
        # *   NONE: none.
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.invoke_type is not None:
            result['InvokeType'] = self.invoke_type
        if self.params is not None:
            result['Params'] = self.params
        if self.remediation_template_id is not None:
            result['RemediationTemplateId'] = self.remediation_template_id
        if self.remediation_type is not None:
            result['RemediationType'] = self.remediation_type
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('InvokeType') is not None:
            self.invoke_type = m.get('InvokeType')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RemediationTemplateId') is not None:
            self.remediation_template_id = m.get('RemediationTemplateId')
        if m.get('RemediationType') is not None:
            self.remediation_type = m.get('RemediationType')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class CreateAggregateRemediationResponseBody(TeaModel):
    def __init__(
        self,
        remediation_id: str = None,
        request_id: str = None,
    ):
        # The ID of the remediation template.
        self.remediation_id = remediation_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remediation_id is not None:
            result['RemediationId'] = self.remediation_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemediationId') is not None:
            self.remediation_id = m.get('RemediationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAggregateRemediationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAggregateRemediationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAggregateRemediationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAggregatorRequestAggregatorAccounts(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        account_name: str = None,
        account_type: str = None,
    ):
        # The member account ID. For more information about how to obtain the ID of a member account, see [ListAccounts](https://help.aliyun.com/document_detail/160016.html).
        self.account_id = account_id
        # The name of the member account. For more information about how to obtain the name of a member account, see [ListAccounts](https://help.aliyun.com/document_detail/160016.html).
        self.account_name = account_name
        # The type of the member account. Set this parameter to ResourceDirectory.
        self.account_type = account_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        return self


class CreateAggregatorRequest(TeaModel):
    def __init__(
        self,
        aggregator_accounts: List[CreateAggregatorRequestAggregatorAccounts] = None,
        aggregator_name: str = None,
        aggregator_type: str = None,
        client_token: str = None,
        description: str = None,
        folder_id: str = None,
    ):
        # The information about the member accounts in the account group. Example:
        # 
        #     [{
        #     	"accountId": 171322098523****,
        #     	"accountType":"ResourceDirectory",
        #                     "accountName":"Alice"
        #     }, {
        #     	"accountId": 100532098349****,
        #     	"accountType":"ResourceDirectory",
        #                     "accountName":"Tom"
        #     }]
        # 
        # >  If `AggregatorType` is set to `RD` or `FOLDER`, this parameter can be left empty, which indicates that all accounts in the resource directory are added to the global account group.
        self.aggregator_accounts = aggregator_accounts
        # The name of the account group.
        # 
        # This parameter is required.
        self.aggregator_name = aggregator_name
        # The type of the account group. Valid values:
        # 
        # *   RD: global account group.
        # *   FOLDER: account group of the folder.
        # *   CUSTOM (default): custom account group.
        self.aggregator_type = aggregator_type
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The `token` can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token
        # The description of the account group.
        # 
        # This parameter is required.
        self.description = description
        # The ID of the folder to which the account group is attached. You must specify this parameter if `AggregatorType` is set to `FOLDER`.
        self.folder_id = folder_id

    def validate(self):
        if self.aggregator_accounts:
            for k in self.aggregator_accounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AggregatorAccounts'] = []
        if self.aggregator_accounts is not None:
            for k in self.aggregator_accounts:
                result['AggregatorAccounts'].append(k.to_map() if k else None)
        if self.aggregator_name is not None:
            result['AggregatorName'] = self.aggregator_name
        if self.aggregator_type is not None:
            result['AggregatorType'] = self.aggregator_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.aggregator_accounts = []
        if m.get('AggregatorAccounts') is not None:
            for k in m.get('AggregatorAccounts'):
                temp_model = CreateAggregatorRequestAggregatorAccounts()
                self.aggregator_accounts.append(temp_model.from_map(k))
        if m.get('AggregatorName') is not None:
            self.aggregator_name = m.get('AggregatorName')
        if m.get('AggregatorType') is not None:
            self.aggregator_type = m.get('AggregatorType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class CreateAggregatorShrinkRequest(TeaModel):
    def __init__(
        self,
        aggregator_accounts_shrink: str = None,
        aggregator_name: str = None,
        aggregator_type: str = None,
        client_token: str = None,
        description: str = None,
        folder_id: str = None,
    ):
        # The information about the member accounts in the account group. Example:
        # 
        #     [{
        #     	"accountId": 171322098523****,
        #     	"accountType":"ResourceDirectory",
        #                     "accountName":"Alice"
        #     }, {
        #     	"accountId": 100532098349****,
        #     	"accountType":"ResourceDirectory",
        #                     "accountName":"Tom"
        #     }]
        # 
        # >  If `AggregatorType` is set to `RD` or `FOLDER`, this parameter can be left empty, which indicates that all accounts in the resource directory are added to the global account group.
        self.aggregator_accounts_shrink = aggregator_accounts_shrink
        # The name of the account group.
        # 
        # This parameter is required.
        self.aggregator_name = aggregator_name
        # The type of the account group. Valid values:
        # 
        # *   RD: global account group.
        # *   FOLDER: account group of the folder.
        # *   CUSTOM (default): custom account group.
        self.aggregator_type = aggregator_type
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The `token` can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token
        # The description of the account group.
        # 
        # This parameter is required.
        self.description = description
        # The ID of the folder to which the account group is attached. You must specify this parameter if `AggregatorType` is set to `FOLDER`.
        self.folder_id = folder_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_accounts_shrink is not None:
            result['AggregatorAccounts'] = self.aggregator_accounts_shrink
        if self.aggregator_name is not None:
            result['AggregatorName'] = self.aggregator_name
        if self.aggregator_type is not None:
            result['AggregatorType'] = self.aggregator_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorAccounts') is not None:
            self.aggregator_accounts_shrink = m.get('AggregatorAccounts')
        if m.get('AggregatorName') is not None:
            self.aggregator_name = m.get('AggregatorName')
        if m.get('AggregatorType') is not None:
            self.aggregator_type = m.get('AggregatorType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class CreateAggregatorResponseBody(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        request_id: str = None,
    ):
        # The account group ID.
        self.aggregator_id = aggregator_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAggregatorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAggregatorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAggregatorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCompliancePackRequestConfigRulesConfigRuleParameters(TeaModel):
    def __init__(
        self,
        parameter_name: str = None,
        parameter_value: str = None,
    ):
        # The name of the input parameter.
        # 
        # You must specify both `ParameterName` and `ParameterValue` or neither of them. If the managed rule has an input parameter but no default value is specified, you must specify this parameter. You can call the [ListCompliancePackTemplates](https://help.aliyun.com/document_detail/261176.html) operation to obtain the names of input parameters of the managed rule.
        self.parameter_name = parameter_name
        # The value of the input parameter.
        # 
        # You must specify both `ParameterName` and `ParameterValue` or neither of them. If the managed rule has an input parameter but no default value is specified, you must specify this parameter. You can call the [ListCompliancePackTemplates](https://help.aliyun.com/document_detail/261176.html) operation to obtain the values of input parameters of the managed rule.
        self.parameter_value = parameter_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_value is not None:
            result['ParameterValue'] = self.parameter_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterValue') is not None:
            self.parameter_value = m.get('ParameterValue')
        return self


class CreateCompliancePackRequestConfigRules(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        config_rule_name: str = None,
        config_rule_parameters: List[CreateCompliancePackRequestConfigRulesConfigRuleParameters] = None,
        description: str = None,
        managed_rule_identifier: str = None,
        risk_level: int = None,
    ):
        # The rule ID. If you specify this parameter, Cloud Config adds the rule that has the specified ID to the compliance package.
        # 
        # You need to only specify `ManagedRuleIdentifier` or `ConfigRuleId`. If you specify both parameters, Cloud Config adds a rule based on the value of `ConfigRuleId`. You can call the [ListConfigRules](https://help.aliyun.com/document_detail/169607.html) operation to obtain the rule ID.
        self.config_rule_id = config_rule_id
        # The name of the rule.
        self.config_rule_name = config_rule_name
        # The input parameters of the rule.
        self.config_rule_parameters = config_rule_parameters
        # The description of the rule.
        self.description = description
        # The identifier of the managed rule. Cloud Config automatically creates a managed rule based on the specified identifier and adds the rule to the compliance package.
        # 
        # You need to only specify `ManagedRuleIdentifier` or `ConfigRuleId`. If you specify both parameters, Cloud Config adds a rule based on the value of `ConfigRuleId`. You can call the [ListCompliancePackTemplates](https://help.aliyun.com/document_detail/261176.html) operation to obtain the identifier of the managed rule.
        self.managed_rule_identifier = managed_rule_identifier
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high.
        # *   2: medium.
        # *   3: low.
        self.risk_level = risk_level

    def validate(self):
        if self.config_rule_parameters:
            for k in self.config_rule_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        result['ConfigRuleParameters'] = []
        if self.config_rule_parameters is not None:
            for k in self.config_rule_parameters:
                result['ConfigRuleParameters'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.managed_rule_identifier is not None:
            result['ManagedRuleIdentifier'] = self.managed_rule_identifier
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        self.config_rule_parameters = []
        if m.get('ConfigRuleParameters') is not None:
            for k in m.get('ConfigRuleParameters'):
                temp_model = CreateCompliancePackRequestConfigRulesConfigRuleParameters()
                self.config_rule_parameters.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ManagedRuleIdentifier') is not None:
            self.managed_rule_identifier = m.get('ManagedRuleIdentifier')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class CreateCompliancePackRequestExcludeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # TagKey
        self.tag_key = tag_key
        # TagValue
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateCompliancePackRequestTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # Tagkey
        self.tag_key = tag_key
        # TagValue
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateCompliancePackRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        compliance_pack_name: str = None,
        compliance_pack_template_id: str = None,
        config_rules: List[CreateCompliancePackRequestConfigRules] = None,
        default_enable: bool = None,
        description: str = None,
        exclude_region_ids_scope: str = None,
        exclude_resource_group_ids_scope: str = None,
        exclude_resource_ids_scope: str = None,
        exclude_tags_scope: List[CreateCompliancePackRequestExcludeTagsScope] = None,
        region_ids_scope: str = None,
        resource_group_ids_scope: str = None,
        resource_ids_scope: str = None,
        risk_level: int = None,
        tag_key_scope: str = None,
        tag_value_scope: str = None,
        tags_scope: List[CreateCompliancePackRequestTagsScope] = None,
        template_content: str = None,
    ):
        # The client token that you want to use to ensure the idempotency of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.``
        self.client_token = client_token
        # The name of the compliance package.
        # 
        # This parameter is required.
        self.compliance_pack_name = compliance_pack_name
        # The ID of the compliance package template.
        # 
        # You can call the [ListCompliancePackTemplates](https://help.aliyun.com/document_detail/261176.html) operation to obtain the ID of the compliance package.
        self.compliance_pack_template_id = compliance_pack_template_id
        # The rules in the compliance package. You must specify either this parameter or TemplateContent.
        self.config_rules = config_rules
        # Specifies whether to enable the rule together with the compliance package. Valid values:
        # 
        # *   true: The system enables the rule together with the compliance package.
        # *   false: The system does not enable the rule together with the compliance package.
        self.default_enable = default_enable
        # The description of the compliance package.
        self.description = description
        # ExcludeRegionIdsScope
        self.exclude_region_ids_scope = exclude_region_ids_scope
        # ExcludeResourceGroupIdsScope. Separate multiple resource group IDs with commas (,).
        self.exclude_resource_group_ids_scope = exclude_resource_group_ids_scope
        # The ID of the resource that you do not want to evaluate by using the compliance package. Separate multiple resource IDs with commas (,).
        self.exclude_resource_ids_scope = exclude_resource_ids_scope
        # ExcludeTagsScope
        self.exclude_tags_scope = exclude_tags_scope
        # The ID of the region whose resources you want to evaluate by using the compliance package. Separate multiple region IDs with commas (,).
        self.region_ids_scope = region_ids_scope
        # The ID of the resource group whose resources you want to evaluate by using the compliance package. Separate multiple resource group IDs with commas (,).
        self.resource_group_ids_scope = resource_group_ids_scope
        # ResourceIdsScope
        self.resource_ids_scope = resource_ids_scope
        # The risk level of the resources that are not compliant with the rules in the compliance package. Default value: 2. Valid values:
        # 
        # *   1: high.
        # *   2: medium.
        # *   3: low.
        self.risk_level = risk_level
        # The tag key of the resource that you want to evaluate by using the compliance package.
        self.tag_key_scope = tag_key_scope
        # The tag value of the resource that you want to evaluate by using the compliance package.
        # 
        # >  You must configure the TagValueScope parameter together with the TagKeyScope parameter.
        self.tag_value_scope = tag_value_scope
        # TagsScope
        self.tags_scope = tags_scope
        # The information about the template that is used to generate the compliance package. You can call an API operation to view the details of an existing compliance package or write a compliance package template. For more information, see [Write a compliance package template in a configuration file](https://help.aliyun.com/document_detail/2659733.html). You must specify one of ConfigRules and TemplateContent.
        self.template_content = template_content

    def validate(self):
        if self.config_rules:
            for k in self.config_rules:
                if k:
                    k.validate()
        if self.exclude_tags_scope:
            for k in self.exclude_tags_scope:
                if k:
                    k.validate()
        if self.tags_scope:
            for k in self.tags_scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.compliance_pack_name is not None:
            result['CompliancePackName'] = self.compliance_pack_name
        if self.compliance_pack_template_id is not None:
            result['CompliancePackTemplateId'] = self.compliance_pack_template_id
        result['ConfigRules'] = []
        if self.config_rules is not None:
            for k in self.config_rules:
                result['ConfigRules'].append(k.to_map() if k else None)
        if self.default_enable is not None:
            result['DefaultEnable'] = self.default_enable
        if self.description is not None:
            result['Description'] = self.description
        if self.exclude_region_ids_scope is not None:
            result['ExcludeRegionIdsScope'] = self.exclude_region_ids_scope
        if self.exclude_resource_group_ids_scope is not None:
            result['ExcludeResourceGroupIdsScope'] = self.exclude_resource_group_ids_scope
        if self.exclude_resource_ids_scope is not None:
            result['ExcludeResourceIdsScope'] = self.exclude_resource_ids_scope
        result['ExcludeTagsScope'] = []
        if self.exclude_tags_scope is not None:
            for k in self.exclude_tags_scope:
                result['ExcludeTagsScope'].append(k.to_map() if k else None)
        if self.region_ids_scope is not None:
            result['RegionIdsScope'] = self.region_ids_scope
        if self.resource_group_ids_scope is not None:
            result['ResourceGroupIdsScope'] = self.resource_group_ids_scope
        if self.resource_ids_scope is not None:
            result['ResourceIdsScope'] = self.resource_ids_scope
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.tag_key_scope is not None:
            result['TagKeyScope'] = self.tag_key_scope
        if self.tag_value_scope is not None:
            result['TagValueScope'] = self.tag_value_scope
        result['TagsScope'] = []
        if self.tags_scope is not None:
            for k in self.tags_scope:
                result['TagsScope'].append(k.to_map() if k else None)
        if self.template_content is not None:
            result['TemplateContent'] = self.template_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CompliancePackName') is not None:
            self.compliance_pack_name = m.get('CompliancePackName')
        if m.get('CompliancePackTemplateId') is not None:
            self.compliance_pack_template_id = m.get('CompliancePackTemplateId')
        self.config_rules = []
        if m.get('ConfigRules') is not None:
            for k in m.get('ConfigRules'):
                temp_model = CreateCompliancePackRequestConfigRules()
                self.config_rules.append(temp_model.from_map(k))
        if m.get('DefaultEnable') is not None:
            self.default_enable = m.get('DefaultEnable')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExcludeRegionIdsScope') is not None:
            self.exclude_region_ids_scope = m.get('ExcludeRegionIdsScope')
        if m.get('ExcludeResourceGroupIdsScope') is not None:
            self.exclude_resource_group_ids_scope = m.get('ExcludeResourceGroupIdsScope')
        if m.get('ExcludeResourceIdsScope') is not None:
            self.exclude_resource_ids_scope = m.get('ExcludeResourceIdsScope')
        self.exclude_tags_scope = []
        if m.get('ExcludeTagsScope') is not None:
            for k in m.get('ExcludeTagsScope'):
                temp_model = CreateCompliancePackRequestExcludeTagsScope()
                self.exclude_tags_scope.append(temp_model.from_map(k))
        if m.get('RegionIdsScope') is not None:
            self.region_ids_scope = m.get('RegionIdsScope')
        if m.get('ResourceGroupIdsScope') is not None:
            self.resource_group_ids_scope = m.get('ResourceGroupIdsScope')
        if m.get('ResourceIdsScope') is not None:
            self.resource_ids_scope = m.get('ResourceIdsScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('TagKeyScope') is not None:
            self.tag_key_scope = m.get('TagKeyScope')
        if m.get('TagValueScope') is not None:
            self.tag_value_scope = m.get('TagValueScope')
        self.tags_scope = []
        if m.get('TagsScope') is not None:
            for k in m.get('TagsScope'):
                temp_model = CreateCompliancePackRequestTagsScope()
                self.tags_scope.append(temp_model.from_map(k))
        if m.get('TemplateContent') is not None:
            self.template_content = m.get('TemplateContent')
        return self


class CreateCompliancePackShrinkRequestExcludeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # TagKey
        self.tag_key = tag_key
        # TagValue
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateCompliancePackShrinkRequestTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # Tagkey
        self.tag_key = tag_key
        # TagValue
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateCompliancePackShrinkRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        compliance_pack_name: str = None,
        compliance_pack_template_id: str = None,
        config_rules_shrink: str = None,
        default_enable: bool = None,
        description: str = None,
        exclude_region_ids_scope: str = None,
        exclude_resource_group_ids_scope: str = None,
        exclude_resource_ids_scope: str = None,
        exclude_tags_scope: List[CreateCompliancePackShrinkRequestExcludeTagsScope] = None,
        region_ids_scope: str = None,
        resource_group_ids_scope: str = None,
        resource_ids_scope: str = None,
        risk_level: int = None,
        tag_key_scope: str = None,
        tag_value_scope: str = None,
        tags_scope: List[CreateCompliancePackShrinkRequestTagsScope] = None,
        template_content: str = None,
    ):
        # The client token that you want to use to ensure the idempotency of the request. You can use the client to generate the value, but you must ensure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.``
        self.client_token = client_token
        # The name of the compliance package.
        # 
        # This parameter is required.
        self.compliance_pack_name = compliance_pack_name
        # The ID of the compliance package template.
        # 
        # You can call the [ListCompliancePackTemplates](https://help.aliyun.com/document_detail/261176.html) operation to obtain the ID of the compliance package.
        self.compliance_pack_template_id = compliance_pack_template_id
        # The rules in the compliance package. You must specify either this parameter or TemplateContent.
        self.config_rules_shrink = config_rules_shrink
        # Specifies whether to enable the rule together with the compliance package. Valid values:
        # 
        # *   true: The system enables the rule together with the compliance package.
        # *   false: The system does not enable the rule together with the compliance package.
        self.default_enable = default_enable
        # The description of the compliance package.
        self.description = description
        # ExcludeRegionIdsScope
        self.exclude_region_ids_scope = exclude_region_ids_scope
        # ExcludeResourceGroupIdsScope. Separate multiple resource group IDs with commas (,).
        self.exclude_resource_group_ids_scope = exclude_resource_group_ids_scope
        # The ID of the resource that you do not want to evaluate by using the compliance package. Separate multiple resource IDs with commas (,).
        self.exclude_resource_ids_scope = exclude_resource_ids_scope
        # ExcludeTagsScope
        self.exclude_tags_scope = exclude_tags_scope
        # The ID of the region whose resources you want to evaluate by using the compliance package. Separate multiple region IDs with commas (,).
        self.region_ids_scope = region_ids_scope
        # The ID of the resource group whose resources you want to evaluate by using the compliance package. Separate multiple resource group IDs with commas (,).
        self.resource_group_ids_scope = resource_group_ids_scope
        # ResourceIdsScope
        self.resource_ids_scope = resource_ids_scope
        # The risk level of the resources that are not compliant with the rules in the compliance package. Default value: 2. Valid values:
        # 
        # *   1: high.
        # *   2: medium.
        # *   3: low.
        self.risk_level = risk_level
        # The tag key of the resource that you want to evaluate by using the compliance package.
        self.tag_key_scope = tag_key_scope
        # The tag value of the resource that you want to evaluate by using the compliance package.
        # 
        # >  You must configure the TagValueScope parameter together with the TagKeyScope parameter.
        self.tag_value_scope = tag_value_scope
        # TagsScope
        self.tags_scope = tags_scope
        # The information about the template that is used to generate the compliance package. You can call an API operation to view the details of an existing compliance package or write a compliance package template. For more information, see [Write a compliance package template in a configuration file](https://help.aliyun.com/document_detail/2659733.html). You must specify one of ConfigRules and TemplateContent.
        self.template_content = template_content

    def validate(self):
        if self.exclude_tags_scope:
            for k in self.exclude_tags_scope:
                if k:
                    k.validate()
        if self.tags_scope:
            for k in self.tags_scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.compliance_pack_name is not None:
            result['CompliancePackName'] = self.compliance_pack_name
        if self.compliance_pack_template_id is not None:
            result['CompliancePackTemplateId'] = self.compliance_pack_template_id
        if self.config_rules_shrink is not None:
            result['ConfigRules'] = self.config_rules_shrink
        if self.default_enable is not None:
            result['DefaultEnable'] = self.default_enable
        if self.description is not None:
            result['Description'] = self.description
        if self.exclude_region_ids_scope is not None:
            result['ExcludeRegionIdsScope'] = self.exclude_region_ids_scope
        if self.exclude_resource_group_ids_scope is not None:
            result['ExcludeResourceGroupIdsScope'] = self.exclude_resource_group_ids_scope
        if self.exclude_resource_ids_scope is not None:
            result['ExcludeResourceIdsScope'] = self.exclude_resource_ids_scope
        result['ExcludeTagsScope'] = []
        if self.exclude_tags_scope is not None:
            for k in self.exclude_tags_scope:
                result['ExcludeTagsScope'].append(k.to_map() if k else None)
        if self.region_ids_scope is not None:
            result['RegionIdsScope'] = self.region_ids_scope
        if self.resource_group_ids_scope is not None:
            result['ResourceGroupIdsScope'] = self.resource_group_ids_scope
        if self.resource_ids_scope is not None:
            result['ResourceIdsScope'] = self.resource_ids_scope
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.tag_key_scope is not None:
            result['TagKeyScope'] = self.tag_key_scope
        if self.tag_value_scope is not None:
            result['TagValueScope'] = self.tag_value_scope
        result['TagsScope'] = []
        if self.tags_scope is not None:
            for k in self.tags_scope:
                result['TagsScope'].append(k.to_map() if k else None)
        if self.template_content is not None:
            result['TemplateContent'] = self.template_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CompliancePackName') is not None:
            self.compliance_pack_name = m.get('CompliancePackName')
        if m.get('CompliancePackTemplateId') is not None:
            self.compliance_pack_template_id = m.get('CompliancePackTemplateId')
        if m.get('ConfigRules') is not None:
            self.config_rules_shrink = m.get('ConfigRules')
        if m.get('DefaultEnable') is not None:
            self.default_enable = m.get('DefaultEnable')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExcludeRegionIdsScope') is not None:
            self.exclude_region_ids_scope = m.get('ExcludeRegionIdsScope')
        if m.get('ExcludeResourceGroupIdsScope') is not None:
            self.exclude_resource_group_ids_scope = m.get('ExcludeResourceGroupIdsScope')
        if m.get('ExcludeResourceIdsScope') is not None:
            self.exclude_resource_ids_scope = m.get('ExcludeResourceIdsScope')
        self.exclude_tags_scope = []
        if m.get('ExcludeTagsScope') is not None:
            for k in m.get('ExcludeTagsScope'):
                temp_model = CreateCompliancePackShrinkRequestExcludeTagsScope()
                self.exclude_tags_scope.append(temp_model.from_map(k))
        if m.get('RegionIdsScope') is not None:
            self.region_ids_scope = m.get('RegionIdsScope')
        if m.get('ResourceGroupIdsScope') is not None:
            self.resource_group_ids_scope = m.get('ResourceGroupIdsScope')
        if m.get('ResourceIdsScope') is not None:
            self.resource_ids_scope = m.get('ResourceIdsScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('TagKeyScope') is not None:
            self.tag_key_scope = m.get('TagKeyScope')
        if m.get('TagValueScope') is not None:
            self.tag_value_scope = m.get('TagValueScope')
        self.tags_scope = []
        if m.get('TagsScope') is not None:
            for k in m.get('TagsScope'):
                temp_model = CreateCompliancePackShrinkRequestTagsScope()
                self.tags_scope.append(temp_model.from_map(k))
        if m.get('TemplateContent') is not None:
            self.template_content = m.get('TemplateContent')
        return self


class CreateCompliancePackResponseBody(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        request_id: str = None,
    ):
        # The compliance package ID.
        self.compliance_pack_id = compliance_pack_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCompliancePackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCompliancePackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCompliancePackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConfigDeliveryChannelRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        compliant_snapshot: bool = None,
        configuration_item_change_notification: bool = None,
        configuration_snapshot: bool = None,
        delivery_channel_condition: str = None,
        delivery_channel_name: str = None,
        delivery_channel_target_arn: str = None,
        delivery_channel_type: str = None,
        delivery_snapshot_time: str = None,
        description: str = None,
        non_compliant_notification: bool = None,
        oversized_data_osstarget_arn: str = None,
    ):
        # The client token that is used to ensure the idempotency of the request. You can use the client to generate the token, but you must ensure that the token is unique among different requests.
        # 
        # The `token` can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see [How to ensure idempotence](https://help.aliyun.com/document_detail/25693.html).
        self.client_token = client_token
        # Specifies whether to deliver scheduled compliant snapshots. Cloud Config delivers scheduled compliant snapshots at `04:00Z` and `16:00Z` to Log Service every day. The time is displayed in UTC. Valid values:
        # 
        # *   true: Cloud Config delivers scheduled compliant snapshots.
        # *   false (default): Cloud Config does not deliver scheduled compliant snapshots.
        self.compliant_snapshot = compliant_snapshot
        # Specifies whether to deliver resource change logs. If you set this parameter to true, Cloud Config delivers resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:
        # 
        # *   true: Cloud Config delivers resource change logs.
        # *   false (default): Cloud Config does not deliver resource change logs.
        # 
        # > This parameter is available for delivery channels of the OSS, SLS, and MNS types.
        self.configuration_item_change_notification = configuration_item_change_notification
        # Specifies whether to deliver scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at `04:00Z` and `16:00Z` to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:
        # 
        # *   true: Cloud Config delivers scheduled resource snapshots.
        # *   false (default): Cloud Config does not deliver scheduled resource snapshots.
        self.configuration_snapshot = configuration_snapshot
        # The rule that you want to attach to the delivery channel. This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
        # 
        # *   If the value of the DeliveryChannelType parameter is MNS, take note of the following settings of the lowest risk level and resource types of the events to which you subscribed:
        # 
        #     *   The setting of the lowest risk level for the events to which you want to subscribe is in the following format: `{"filterType":"RuleRiskLevel","value":"1","multiple":false}`.
        # 
        #         The `value` field indicates the lowest risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
        # 
        #     *   The setting of the resource types of the events to which you want to subscribe is in the following format: `{"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}`.
        # 
        #         The `values` field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array. Examples:
        # 
        # `[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}]`
        # 
        # *   If you set the DeliveryChannelType parameter to SLS, the setting of the resource types of the snapshots to which you want to deliver is in the following format: `{"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}`.
        # 
        #     The `values` field specifies the resource types of the snapshots to which you want to deliver. The value of the field is a JSON array. Examples:
        # 
        # `[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}]`
        self.delivery_channel_condition = delivery_channel_condition
        # The name of the delivery channel.
        # 
        # > If you do not configure this parameter, this parameter is left empty.
        self.delivery_channel_name = delivery_channel_name
        # The Alibaba Cloud Resource Name (ARN) of the delivery destination. Valid values:
        # 
        # *   `acs:oss:{RegionId}:{accountId}:{bucketName}` if your delivery destination is an OSS bucket. Example: `acs:oss:cn-shanghai:100931896542****:new-bucket`.
        # *   `acs:mns:{RegionId}:{accountId}:/topics/{topicName}` if your delivery destination is an MNS topic. Example: `acs:mns:cn-shanghai:100931896542****:/topics/topic1`.
        # *   `acs:log:{RegionId}:{accountId}:project/{projectName}/logstore/{logstoreName}` if your delivery destination is a Log Service Logstore. Example: `acs:log:cn-shanghai:100931896542****:project/project1/logstore/logstore1`.
        # 
        # This parameter is required.
        self.delivery_channel_target_arn = delivery_channel_target_arn
        # The type of the delivery channel. Valid values:
        # 
        # *   OSS: Object Storage Service (OSS)
        # *   MNS: Message Service (MNS)
        # *   SLS: Log Service
        # 
        # This parameter is required.
        self.delivery_channel_type = delivery_channel_type
        # The time when you want Cloud Config to deliver scheduled resource snapshots every day.
        # 
        # Format: `HH:mmZ`. This time is displayed in UTC.
        # 
        # > When you enable the scheduled resource delivery feature, you can configure this parameter to specify a custom delivery time. If you do not configure this parameter, Cloud Config automatically delivers scheduled resource snapshots at `04:00Z` and `16:00Z` every day.
        self.delivery_snapshot_time = delivery_snapshot_time
        # The description of the delivery channel.
        self.description = description
        # Specifies whether to deliver resource non-compliance events. If you set this parameter to true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are considered non-compliant. Valid values:
        # 
        # *   true: Cloud Config delivers resource non-compliance events.
        # *   false (default): Cloud Config does not deliver resource non-compliance events.
        # 
        # > This parameter is available only for delivery channels of the SLS or MNS type.
        self.non_compliant_notification = non_compliant_notification
        # The ARN of the OSS bucket to which you want to transfer the delivery data when the size of the data exceeds the specified upper limit of the delivery channel. Format: `acs:oss:{RegionId}:{accountId}:{bucketName}`.
        # 
        # If you do not configure this parameter, Cloud Config delivers only summary data.
        # 
        # > This parameter is available only for delivery channels of the SLS or MNS type. The maximum storage size of delivery channels of the SLS type is 1 MB, and the maximum storage size of delivery channels of the MNS type is 64 KB.
        self.oversized_data_osstarget_arn = oversized_data_osstarget_arn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.compliant_snapshot is not None:
            result['CompliantSnapshot'] = self.compliant_snapshot
        if self.configuration_item_change_notification is not None:
            result['ConfigurationItemChangeNotification'] = self.configuration_item_change_notification
        if self.configuration_snapshot is not None:
            result['ConfigurationSnapshot'] = self.configuration_snapshot
        if self.delivery_channel_condition is not None:
            result['DeliveryChannelCondition'] = self.delivery_channel_condition
        if self.delivery_channel_name is not None:
            result['DeliveryChannelName'] = self.delivery_channel_name
        if self.delivery_channel_target_arn is not None:
            result['DeliveryChannelTargetArn'] = self.delivery_channel_target_arn
        if self.delivery_channel_type is not None:
            result['DeliveryChannelType'] = self.delivery_channel_type
        if self.delivery_snapshot_time is not None:
            result['DeliverySnapshotTime'] = self.delivery_snapshot_time
        if self.description is not None:
            result['Description'] = self.description
        if self.non_compliant_notification is not None:
            result['NonCompliantNotification'] = self.non_compliant_notification
        if self.oversized_data_osstarget_arn is not None:
            result['OversizedDataOSSTargetArn'] = self.oversized_data_osstarget_arn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CompliantSnapshot') is not None:
            self.compliant_snapshot = m.get('CompliantSnapshot')
        if m.get('ConfigurationItemChangeNotification') is not None:
            self.configuration_item_change_notification = m.get('ConfigurationItemChangeNotification')
        if m.get('ConfigurationSnapshot') is not None:
            self.configuration_snapshot = m.get('ConfigurationSnapshot')
        if m.get('DeliveryChannelCondition') is not None:
            self.delivery_channel_condition = m.get('DeliveryChannelCondition')
        if m.get('DeliveryChannelName') is not None:
            self.delivery_channel_name = m.get('DeliveryChannelName')
        if m.get('DeliveryChannelTargetArn') is not None:
            self.delivery_channel_target_arn = m.get('DeliveryChannelTargetArn')
        if m.get('DeliveryChannelType') is not None:
            self.delivery_channel_type = m.get('DeliveryChannelType')
        if m.get('DeliverySnapshotTime') is not None:
            self.delivery_snapshot_time = m.get('DeliverySnapshotTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NonCompliantNotification') is not None:
            self.non_compliant_notification = m.get('NonCompliantNotification')
        if m.get('OversizedDataOSSTargetArn') is not None:
            self.oversized_data_osstarget_arn = m.get('OversizedDataOSSTargetArn')
        return self


class CreateConfigDeliveryChannelResponseBody(TeaModel):
    def __init__(
        self,
        delivery_channel_id: str = None,
        request_id: str = None,
    ):
        # The ID of the delivery channel.
        self.delivery_channel_id = delivery_channel_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_channel_id is not None:
            result['DeliveryChannelId'] = self.delivery_channel_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryChannelId') is not None:
            self.delivery_channel_id = m.get('DeliveryChannelId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateConfigDeliveryChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateConfigDeliveryChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateConfigDeliveryChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConfigRuleRequestExcludeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # TagKey
        self.tag_key = tag_key
        # TagValue
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateConfigRuleRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateConfigRuleRequestTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # TagKey
        self.tag_key = tag_key
        # TagValue
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateConfigRuleRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        config_rule_name: str = None,
        config_rule_trigger_types: str = None,
        description: str = None,
        exclude_region_ids_scope: str = None,
        exclude_resource_group_ids_scope: str = None,
        exclude_resource_ids_scope: str = None,
        exclude_tags_scope: List[CreateConfigRuleRequestExcludeTagsScope] = None,
        extend_content: str = None,
        input_parameters: Dict[str, Any] = None,
        maximum_execution_frequency: str = None,
        region_ids_scope: str = None,
        resource_group_ids_scope: str = None,
        resource_ids_scope: str = None,
        resource_types_scope: List[str] = None,
        risk_level: int = None,
        source_identifier: str = None,
        source_owner: str = None,
        tag: List[CreateConfigRuleRequestTag] = None,
        tag_key_logic_scope: str = None,
        tag_key_scope: str = None,
        tag_value_scope: str = None,
        tags_scope: List[CreateConfigRuleRequestTagsScope] = None,
    ):
        # The client token that you want to use to ensure the idempotency of the request. You can use the client to generate the value, but you must make sure that the value is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.``
        self.client_token = client_token
        # The name of the rule.
        # 
        # This parameter is required.
        self.config_rule_name = config_rule_name
        # The trigger type of the rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The rule is triggered by configuration changes.
        # *   ScheduledNotification: The rule is periodically triggered.
        # 
        # >  If a rule supports the preceding trigger types, separate the types with a comma (,).
        # 
        # This parameter is required.
        self.config_rule_trigger_types = config_rule_trigger_types
        # The description of the rule.
        self.description = description
        # ExcludeRegionIdsScope
        self.exclude_region_ids_scope = exclude_region_ids_scope
        # ExcludeResourceGroupIdsScope
        self.exclude_resource_group_ids_scope = exclude_resource_group_ids_scope
        # The ID of the resource to be excluded from the compliance evaluations performed by the rule. Separate multiple resource IDs with commas (,).
        # 
        # >  This parameter applies only to managed rules.
        self.exclude_resource_ids_scope = exclude_resource_ids_scope
        # ExcludeTagsScope
        self.exclude_tags_scope = exclude_tags_scope
        # Optional field, only used in conjunction with the 24-hour cycle execution to set the trigger time.
        self.extend_content = extend_content
        # The input parameter of the rule.
        self.input_parameters = input_parameters
        # The intervals at which the rule is triggered. Valid values:
        # 
        # *   One_Hour: 1 hour.
        # *   Three_Hours: 3 hours.
        # *   Six_Hours: 6 hours.
        # *   Twelve_Hours: 12 hours.
        # *   TwentyFour_Hours (default): 24 hours.
        # 
        # >  This parameter is required if the ConfigRuleTriggerTypes parameter is set to ScheduledNotification.
        self.maximum_execution_frequency = maximum_execution_frequency
        # The ID of the region to which the rule applies. Separate multiple region IDs with commas (,).
        # 
        # >  This parameter applies only to managed rules.
        self.region_ids_scope = region_ids_scope
        # The ID of the resource group to which the rule applies. Separate multiple resource group IDs with commas (,).
        # 
        # >  This parameter applies only to managed rules.
        self.resource_group_ids_scope = resource_group_ids_scope
        # ResourceIdsScope
        self.resource_ids_scope = resource_ids_scope
        # The type of the resource to be evaluated by the rule. Separate multiple resource types with commas (,).
        # 
        # This parameter is required.
        self.resource_types_scope = resource_types_scope
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high.
        # *   2: medium.
        # *   3: low.
        # 
        # This parameter is required.
        self.risk_level = risk_level
        # The ID of the rule.
        # 
        # *   If you set the SourceOwner parameter to ALIYUN, set this parameter to the name of the managed rule.
        # *   If you set the SourceOwner parameter to CUSTOM_FC, set this parameter to the Alibaba Cloud Resource Name (ARN) of the relevant function in Function Compute.
        # 
        # For more information about how to query the name of a managed rule, see [Managed rules](https://help.aliyun.com/document_detail/127404.html).
        # 
        # This parameter is required.
        self.source_identifier = source_identifier
        # The type of the rule Valid values:
        # 
        # *   ALIYUN: managed rule.
        # *   CUSTOM_FC: custom rule.
        # 
        # This parameter is required.
        self.source_owner = source_owner
        self.tag = tag
        # The logical relationship among the tag keys if you specify multiple tag keys for `TagKeyScope`. For example, if you set `TagKeyScope` to `ECS,OSS` and set TagKeyLogicScope to `AND`, the rule applies to resources with both the `ECS` and `OSS` tag keys. Valid values:
        # 
        # *   AND
        # *   OR
        self.tag_key_logic_scope = tag_key_logic_scope
        # The tag key used to filter resources. The rule applies only to the resources with the specified tag key.
        # 
        # >  This parameter applies only to managed rules. You must specify both `TagKeyScope` and `TagValueScope`.
        self.tag_key_scope = tag_key_scope
        # The tag value used to filter resources. The rule applies only to the resources that use the specified tag value.
        # 
        # >  This parameter applies only to managed rules. You must specify both `TagKeyScope` and `TagValueScope`.
        self.tag_value_scope = tag_value_scope
        # TagsScope
        self.tags_scope = tags_scope

    def validate(self):
        if self.exclude_tags_scope:
            for k in self.exclude_tags_scope:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.tags_scope:
            for k in self.tags_scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        if self.config_rule_trigger_types is not None:
            result['ConfigRuleTriggerTypes'] = self.config_rule_trigger_types
        if self.description is not None:
            result['Description'] = self.description
        if self.exclude_region_ids_scope is not None:
            result['ExcludeRegionIdsScope'] = self.exclude_region_ids_scope
        if self.exclude_resource_group_ids_scope is not None:
            result['ExcludeResourceGroupIdsScope'] = self.exclude_resource_group_ids_scope
        if self.exclude_resource_ids_scope is not None:
            result['ExcludeResourceIdsScope'] = self.exclude_resource_ids_scope
        result['ExcludeTagsScope'] = []
        if self.exclude_tags_scope is not None:
            for k in self.exclude_tags_scope:
                result['ExcludeTagsScope'].append(k.to_map() if k else None)
        if self.extend_content is not None:
            result['ExtendContent'] = self.extend_content
        if self.input_parameters is not None:
            result['InputParameters'] = self.input_parameters
        if self.maximum_execution_frequency is not None:
            result['MaximumExecutionFrequency'] = self.maximum_execution_frequency
        if self.region_ids_scope is not None:
            result['RegionIdsScope'] = self.region_ids_scope
        if self.resource_group_ids_scope is not None:
            result['ResourceGroupIdsScope'] = self.resource_group_ids_scope
        if self.resource_ids_scope is not None:
            result['ResourceIdsScope'] = self.resource_ids_scope
        if self.resource_types_scope is not None:
            result['ResourceTypesScope'] = self.resource_types_scope
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.source_identifier is not None:
            result['SourceIdentifier'] = self.source_identifier
        if self.source_owner is not None:
            result['SourceOwner'] = self.source_owner
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.tag_key_logic_scope is not None:
            result['TagKeyLogicScope'] = self.tag_key_logic_scope
        if self.tag_key_scope is not None:
            result['TagKeyScope'] = self.tag_key_scope
        if self.tag_value_scope is not None:
            result['TagValueScope'] = self.tag_value_scope
        result['TagsScope'] = []
        if self.tags_scope is not None:
            for k in self.tags_scope:
                result['TagsScope'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        if m.get('ConfigRuleTriggerTypes') is not None:
            self.config_rule_trigger_types = m.get('ConfigRuleTriggerTypes')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExcludeRegionIdsScope') is not None:
            self.exclude_region_ids_scope = m.get('ExcludeRegionIdsScope')
        if m.get('ExcludeResourceGroupIdsScope') is not None:
            self.exclude_resource_group_ids_scope = m.get('ExcludeResourceGroupIdsScope')
        if m.get('ExcludeResourceIdsScope') is not None:
            self.exclude_resource_ids_scope = m.get('ExcludeResourceIdsScope')
        self.exclude_tags_scope = []
        if m.get('ExcludeTagsScope') is not None:
            for k in m.get('ExcludeTagsScope'):
                temp_model = CreateConfigRuleRequestExcludeTagsScope()
                self.exclude_tags_scope.append(temp_model.from_map(k))
        if m.get('ExtendContent') is not None:
            self.extend_content = m.get('ExtendContent')
        if m.get('InputParameters') is not None:
            self.input_parameters = m.get('InputParameters')
        if m.get('MaximumExecutionFrequency') is not None:
            self.maximum_execution_frequency = m.get('MaximumExecutionFrequency')
        if m.get('RegionIdsScope') is not None:
            self.region_ids_scope = m.get('RegionIdsScope')
        if m.get('ResourceGroupIdsScope') is not None:
            self.resource_group_ids_scope = m.get('ResourceGroupIdsScope')
        if m.get('ResourceIdsScope') is not None:
            self.resource_ids_scope = m.get('ResourceIdsScope')
        if m.get('ResourceTypesScope') is not None:
            self.resource_types_scope = m.get('ResourceTypesScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SourceIdentifier') is not None:
            self.source_identifier = m.get('SourceIdentifier')
        if m.get('SourceOwner') is not None:
            self.source_owner = m.get('SourceOwner')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateConfigRuleRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TagKeyLogicScope') is not None:
            self.tag_key_logic_scope = m.get('TagKeyLogicScope')
        if m.get('TagKeyScope') is not None:
            self.tag_key_scope = m.get('TagKeyScope')
        if m.get('TagValueScope') is not None:
            self.tag_value_scope = m.get('TagValueScope')
        self.tags_scope = []
        if m.get('TagsScope') is not None:
            for k in m.get('TagsScope'):
                temp_model = CreateConfigRuleRequestTagsScope()
                self.tags_scope.append(temp_model.from_map(k))
        return self


class CreateConfigRuleShrinkRequestExcludeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # TagKey
        self.tag_key = tag_key
        # TagValue
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateConfigRuleShrinkRequestTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # TagKey
        self.tag_key = tag_key
        # TagValue
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateConfigRuleShrinkRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        config_rule_name: str = None,
        config_rule_trigger_types: str = None,
        description: str = None,
        exclude_region_ids_scope: str = None,
        exclude_resource_group_ids_scope: str = None,
        exclude_resource_ids_scope: str = None,
        exclude_tags_scope: List[CreateConfigRuleShrinkRequestExcludeTagsScope] = None,
        extend_content: str = None,
        input_parameters_shrink: str = None,
        maximum_execution_frequency: str = None,
        region_ids_scope: str = None,
        resource_group_ids_scope: str = None,
        resource_ids_scope: str = None,
        resource_types_scope_shrink: str = None,
        risk_level: int = None,
        source_identifier: str = None,
        source_owner: str = None,
        tag_shrink: str = None,
        tag_key_logic_scope: str = None,
        tag_key_scope: str = None,
        tag_value_scope: str = None,
        tags_scope: List[CreateConfigRuleShrinkRequestTagsScope] = None,
    ):
        # The client token that you want to use to ensure the idempotency of the request. You can use the client to generate the value, but you must make sure that the value is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.``
        self.client_token = client_token
        # The name of the rule.
        # 
        # This parameter is required.
        self.config_rule_name = config_rule_name
        # The trigger type of the rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The rule is triggered by configuration changes.
        # *   ScheduledNotification: The rule is periodically triggered.
        # 
        # >  If a rule supports the preceding trigger types, separate the types with a comma (,).
        # 
        # This parameter is required.
        self.config_rule_trigger_types = config_rule_trigger_types
        # The description of the rule.
        self.description = description
        # ExcludeRegionIdsScope
        self.exclude_region_ids_scope = exclude_region_ids_scope
        # ExcludeResourceGroupIdsScope
        self.exclude_resource_group_ids_scope = exclude_resource_group_ids_scope
        # The ID of the resource to be excluded from the compliance evaluations performed by the rule. Separate multiple resource IDs with commas (,).
        # 
        # >  This parameter applies only to managed rules.
        self.exclude_resource_ids_scope = exclude_resource_ids_scope
        # ExcludeTagsScope
        self.exclude_tags_scope = exclude_tags_scope
        # Optional field, only used in conjunction with the 24-hour cycle execution to set the trigger time.
        self.extend_content = extend_content
        # The input parameter of the rule.
        self.input_parameters_shrink = input_parameters_shrink
        # The intervals at which the rule is triggered. Valid values:
        # 
        # *   One_Hour: 1 hour.
        # *   Three_Hours: 3 hours.
        # *   Six_Hours: 6 hours.
        # *   Twelve_Hours: 12 hours.
        # *   TwentyFour_Hours (default): 24 hours.
        # 
        # >  This parameter is required if the ConfigRuleTriggerTypes parameter is set to ScheduledNotification.
        self.maximum_execution_frequency = maximum_execution_frequency
        # The ID of the region to which the rule applies. Separate multiple region IDs with commas (,).
        # 
        # >  This parameter applies only to managed rules.
        self.region_ids_scope = region_ids_scope
        # The ID of the resource group to which the rule applies. Separate multiple resource group IDs with commas (,).
        # 
        # >  This parameter applies only to managed rules.
        self.resource_group_ids_scope = resource_group_ids_scope
        # ResourceIdsScope
        self.resource_ids_scope = resource_ids_scope
        # The type of the resource to be evaluated by the rule. Separate multiple resource types with commas (,).
        # 
        # This parameter is required.
        self.resource_types_scope_shrink = resource_types_scope_shrink
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high.
        # *   2: medium.
        # *   3: low.
        # 
        # This parameter is required.
        self.risk_level = risk_level
        # The ID of the rule.
        # 
        # *   If you set the SourceOwner parameter to ALIYUN, set this parameter to the name of the managed rule.
        # *   If you set the SourceOwner parameter to CUSTOM_FC, set this parameter to the Alibaba Cloud Resource Name (ARN) of the relevant function in Function Compute.
        # 
        # For more information about how to query the name of a managed rule, see [Managed rules](https://help.aliyun.com/document_detail/127404.html).
        # 
        # This parameter is required.
        self.source_identifier = source_identifier
        # The type of the rule Valid values:
        # 
        # *   ALIYUN: managed rule.
        # *   CUSTOM_FC: custom rule.
        # 
        # This parameter is required.
        self.source_owner = source_owner
        self.tag_shrink = tag_shrink
        # The logical relationship among the tag keys if you specify multiple tag keys for `TagKeyScope`. For example, if you set `TagKeyScope` to `ECS,OSS` and set TagKeyLogicScope to `AND`, the rule applies to resources with both the `ECS` and `OSS` tag keys. Valid values:
        # 
        # *   AND
        # *   OR
        self.tag_key_logic_scope = tag_key_logic_scope
        # The tag key used to filter resources. The rule applies only to the resources with the specified tag key.
        # 
        # >  This parameter applies only to managed rules. You must specify both `TagKeyScope` and `TagValueScope`.
        self.tag_key_scope = tag_key_scope
        # The tag value used to filter resources. The rule applies only to the resources that use the specified tag value.
        # 
        # >  This parameter applies only to managed rules. You must specify both `TagKeyScope` and `TagValueScope`.
        self.tag_value_scope = tag_value_scope
        # TagsScope
        self.tags_scope = tags_scope

    def validate(self):
        if self.exclude_tags_scope:
            for k in self.exclude_tags_scope:
                if k:
                    k.validate()
        if self.tags_scope:
            for k in self.tags_scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        if self.config_rule_trigger_types is not None:
            result['ConfigRuleTriggerTypes'] = self.config_rule_trigger_types
        if self.description is not None:
            result['Description'] = self.description
        if self.exclude_region_ids_scope is not None:
            result['ExcludeRegionIdsScope'] = self.exclude_region_ids_scope
        if self.exclude_resource_group_ids_scope is not None:
            result['ExcludeResourceGroupIdsScope'] = self.exclude_resource_group_ids_scope
        if self.exclude_resource_ids_scope is not None:
            result['ExcludeResourceIdsScope'] = self.exclude_resource_ids_scope
        result['ExcludeTagsScope'] = []
        if self.exclude_tags_scope is not None:
            for k in self.exclude_tags_scope:
                result['ExcludeTagsScope'].append(k.to_map() if k else None)
        if self.extend_content is not None:
            result['ExtendContent'] = self.extend_content
        if self.input_parameters_shrink is not None:
            result['InputParameters'] = self.input_parameters_shrink
        if self.maximum_execution_frequency is not None:
            result['MaximumExecutionFrequency'] = self.maximum_execution_frequency
        if self.region_ids_scope is not None:
            result['RegionIdsScope'] = self.region_ids_scope
        if self.resource_group_ids_scope is not None:
            result['ResourceGroupIdsScope'] = self.resource_group_ids_scope
        if self.resource_ids_scope is not None:
            result['ResourceIdsScope'] = self.resource_ids_scope
        if self.resource_types_scope_shrink is not None:
            result['ResourceTypesScope'] = self.resource_types_scope_shrink
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.source_identifier is not None:
            result['SourceIdentifier'] = self.source_identifier
        if self.source_owner is not None:
            result['SourceOwner'] = self.source_owner
        if self.tag_shrink is not None:
            result['Tag'] = self.tag_shrink
        if self.tag_key_logic_scope is not None:
            result['TagKeyLogicScope'] = self.tag_key_logic_scope
        if self.tag_key_scope is not None:
            result['TagKeyScope'] = self.tag_key_scope
        if self.tag_value_scope is not None:
            result['TagValueScope'] = self.tag_value_scope
        result['TagsScope'] = []
        if self.tags_scope is not None:
            for k in self.tags_scope:
                result['TagsScope'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        if m.get('ConfigRuleTriggerTypes') is not None:
            self.config_rule_trigger_types = m.get('ConfigRuleTriggerTypes')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExcludeRegionIdsScope') is not None:
            self.exclude_region_ids_scope = m.get('ExcludeRegionIdsScope')
        if m.get('ExcludeResourceGroupIdsScope') is not None:
            self.exclude_resource_group_ids_scope = m.get('ExcludeResourceGroupIdsScope')
        if m.get('ExcludeResourceIdsScope') is not None:
            self.exclude_resource_ids_scope = m.get('ExcludeResourceIdsScope')
        self.exclude_tags_scope = []
        if m.get('ExcludeTagsScope') is not None:
            for k in m.get('ExcludeTagsScope'):
                temp_model = CreateConfigRuleShrinkRequestExcludeTagsScope()
                self.exclude_tags_scope.append(temp_model.from_map(k))
        if m.get('ExtendContent') is not None:
            self.extend_content = m.get('ExtendContent')
        if m.get('InputParameters') is not None:
            self.input_parameters_shrink = m.get('InputParameters')
        if m.get('MaximumExecutionFrequency') is not None:
            self.maximum_execution_frequency = m.get('MaximumExecutionFrequency')
        if m.get('RegionIdsScope') is not None:
            self.region_ids_scope = m.get('RegionIdsScope')
        if m.get('ResourceGroupIdsScope') is not None:
            self.resource_group_ids_scope = m.get('ResourceGroupIdsScope')
        if m.get('ResourceIdsScope') is not None:
            self.resource_ids_scope = m.get('ResourceIdsScope')
        if m.get('ResourceTypesScope') is not None:
            self.resource_types_scope_shrink = m.get('ResourceTypesScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SourceIdentifier') is not None:
            self.source_identifier = m.get('SourceIdentifier')
        if m.get('SourceOwner') is not None:
            self.source_owner = m.get('SourceOwner')
        if m.get('Tag') is not None:
            self.tag_shrink = m.get('Tag')
        if m.get('TagKeyLogicScope') is not None:
            self.tag_key_logic_scope = m.get('TagKeyLogicScope')
        if m.get('TagKeyScope') is not None:
            self.tag_key_scope = m.get('TagKeyScope')
        if m.get('TagValueScope') is not None:
            self.tag_value_scope = m.get('TagValueScope')
        self.tags_scope = []
        if m.get('TagsScope') is not None:
            for k in m.get('TagsScope'):
                temp_model = CreateConfigRuleShrinkRequestTagsScope()
                self.tags_scope.append(temp_model.from_map(k))
        return self


class CreateConfigRuleResponseBody(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        request_id: str = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateConfigRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateConfigRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateConfigRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeliveryChannelRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        configuration_item_change_notification: bool = None,
        configuration_snapshot: bool = None,
        delivery_channel_assume_role_arn: str = None,
        delivery_channel_condition: str = None,
        delivery_channel_name: str = None,
        delivery_channel_target_arn: str = None,
        delivery_channel_type: str = None,
        description: str = None,
        non_compliant_notification: bool = None,
        oversized_data_osstarget_arn: str = None,
    ):
        # The client token that is used to ensure the idempotency of the request. You can use the client to generate the token, but you must ensure that the token is unique among different requests.
        # 
        # The `token` can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see [How to ensure idempotence](https://help.aliyun.com/document_detail/25693.html).
        self.client_token = client_token
        # Specifies whether to deliver resource change logs to the specified destination. If you set this parameter to true, Cloud Config delivers resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:
        # 
        # *   true
        # *   false (default)
        # 
        # > This parameter is available for delivery channels of the OSS, SLS, and MNS types.
        self.configuration_item_change_notification = configuration_item_change_notification
        # Specifies whether to deliver scheduled resource snapshots to the OSS bucket. If the value of this parameter is true, the scheduled resource snapshots are delivered to the specified OSS bucket at 00:00:00 and 12:00:00 on a daily basis. Valid values:
        # 
        # *   true
        # *   false (default)
        # 
        # > This parameter is applicable only to delivery channels of the OSS type.
        self.configuration_snapshot = configuration_snapshot
        # The ARN of the role that you want to assign to the delivery channel. Specify the ARN in the following format: `acs:ram::{accountId}:role/aliyunserviceroleforconfig`.
        # 
        # This parameter is required.
        self.delivery_channel_assume_role_arn = delivery_channel_assume_role_arn
        # The rule that you want to attach to the delivery channel. This parameter is available only for delivery channels of the MNS type.
        # 
        # This parameter specifies the lowest risk level and the resource types for the events to which you want to subscribe.
        # 
        # *   The setting of the lowest risk level for the events to which you want to subscribe is in the following format: `{"filterType":"RuleRiskLevel","value":"1","multiple":false}`.
        # 
        #     The `value` field indicates the lowest risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
        # 
        # *   The setting of the resource types of the events to which you want to subscribe is in the following format: `{"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}`.
        # 
        #     The `values` field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array. Examples:
        # 
        # `[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}]`
        self.delivery_channel_condition = delivery_channel_condition
        # The name of the delivery channel.
        # 
        # > If you do not configure this parameter, this parameter is left empty.
        self.delivery_channel_name = delivery_channel_name
        # The Alibaba Cloud Resource Name (ARN) of the delivery destination. Valid values:
        # 
        # *   `acs:oss:{RegionId}:{accountId}:{bucketName}` if your delivery destination is an OSS bucket. Example: `acs:oss:cn-shanghai:100931896542****:new-bucket`.
        # *   `acs:mns:{RegionId}:{accountId}:/topics/{topicName}` if your delivery destination is an MNS topic. Example: `acs:mns:cn-shanghai:100931896542****:/topics/topic1`.
        # *   `acs:log:{RegionId}:{accountId}:project/{projectName}/logstore/{logstoreName}` if your delivery destination is a Log Service Logstore. Example: `acs:log:cn-shanghai:100931896542****:project/project1/logstore/logstore1`.
        # 
        # This parameter is required.
        self.delivery_channel_target_arn = delivery_channel_target_arn
        # The type of the delivery channel. Valid values:
        # 
        # *   OSS: Object Storage Service (OSS)
        # *   MNS: Message Service (MNS)
        # *   SLS: Log Service
        # 
        # This parameter is required.
        self.delivery_channel_type = delivery_channel_type
        # The description of the delivery channel.
        self.description = description
        # Specifies whether to deliver resource non-compliance events. If you set this parameter to true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are considered non-compliant. Valid values:
        # 
        # *   true
        # *   false (default)
        # 
        # > This parameter is available only for delivery channels of the SLS or MNS type.
        self.non_compliant_notification = non_compliant_notification
        # The ARN of the OSS bucket to which you want to transfer the delivery data when the size of the data exceeds the specified upper limit of the delivery channel. Format: `acs:oss:{RegionId}:{accountId}:{bucketName}`.
        # 
        # If you do not configure this parameter, Cloud Config delivers only summary data.
        # 
        # > This parameter is available only for delivery channels of the SLS or MNS type. The maximum storage size of delivery channels of the SLS type is 1 MB, and the maximum storage size of delivery channels of the MNS type is 64 KB.
        self.oversized_data_osstarget_arn = oversized_data_osstarget_arn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.configuration_item_change_notification is not None:
            result['ConfigurationItemChangeNotification'] = self.configuration_item_change_notification
        if self.configuration_snapshot is not None:
            result['ConfigurationSnapshot'] = self.configuration_snapshot
        if self.delivery_channel_assume_role_arn is not None:
            result['DeliveryChannelAssumeRoleArn'] = self.delivery_channel_assume_role_arn
        if self.delivery_channel_condition is not None:
            result['DeliveryChannelCondition'] = self.delivery_channel_condition
        if self.delivery_channel_name is not None:
            result['DeliveryChannelName'] = self.delivery_channel_name
        if self.delivery_channel_target_arn is not None:
            result['DeliveryChannelTargetArn'] = self.delivery_channel_target_arn
        if self.delivery_channel_type is not None:
            result['DeliveryChannelType'] = self.delivery_channel_type
        if self.description is not None:
            result['Description'] = self.description
        if self.non_compliant_notification is not None:
            result['NonCompliantNotification'] = self.non_compliant_notification
        if self.oversized_data_osstarget_arn is not None:
            result['OversizedDataOSSTargetArn'] = self.oversized_data_osstarget_arn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConfigurationItemChangeNotification') is not None:
            self.configuration_item_change_notification = m.get('ConfigurationItemChangeNotification')
        if m.get('ConfigurationSnapshot') is not None:
            self.configuration_snapshot = m.get('ConfigurationSnapshot')
        if m.get('DeliveryChannelAssumeRoleArn') is not None:
            self.delivery_channel_assume_role_arn = m.get('DeliveryChannelAssumeRoleArn')
        if m.get('DeliveryChannelCondition') is not None:
            self.delivery_channel_condition = m.get('DeliveryChannelCondition')
        if m.get('DeliveryChannelName') is not None:
            self.delivery_channel_name = m.get('DeliveryChannelName')
        if m.get('DeliveryChannelTargetArn') is not None:
            self.delivery_channel_target_arn = m.get('DeliveryChannelTargetArn')
        if m.get('DeliveryChannelType') is not None:
            self.delivery_channel_type = m.get('DeliveryChannelType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NonCompliantNotification') is not None:
            self.non_compliant_notification = m.get('NonCompliantNotification')
        if m.get('OversizedDataOSSTargetArn') is not None:
            self.oversized_data_osstarget_arn = m.get('OversizedDataOSSTargetArn')
        return self


class CreateDeliveryChannelResponseBody(TeaModel):
    def __init__(
        self,
        delivery_channel_id: str = None,
        request_id: str = None,
    ):
        # The ID of the delivery channel.
        self.delivery_channel_id = delivery_channel_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_channel_id is not None:
            result['DeliveryChannelId'] = self.delivery_channel_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryChannelId') is not None:
            self.delivery_channel_id = m.get('DeliveryChannelId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDeliveryChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDeliveryChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDeliveryChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRemediationRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        config_rule_id: str = None,
        invoke_type: str = None,
        params: str = None,
        remediation_template_id: str = None,
        remediation_type: str = None,
        source_type: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The `token` can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token
        # The rule ID.
        # 
        # For more information about how to obtain the ID of a rule, see [ListConfigRules](https://help.aliyun.com/document_detail/169607.html).
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id
        # The execution mode of the remediation template. Valid values:
        # 
        # *   NON_EXECUTION: The remediation template is not executed.
        # *   AUTO_EXECUTION: The remediation template is automatically executed.
        # *   MANUAL_EXECUTION: The remediation template is manually executed.
        # *   NOT_CONFIG: The execution mode is not specified.
        # 
        # This parameter is required.
        self.invoke_type = invoke_type
        # The configuration of the remediation template.
        # 
        # For more information about how to obtain the remediation template configuration, see the `TemplateDefinition` response parameter provided in [ListRemediationTemplates](https://help.aliyun.com/document_detail/416781.html).
        # 
        # This parameter is required.
        self.params = params
        # The ID of the remediation template.
        # 
        # *   If you set the `RemediationType` parameter to `OOS`, set this parameter to the identifier of the relevant official remediation template, such as `ACS-OSS-PutBucketAcl`. For more information about how to obtain the remediation template identifier, see [ListRemediationTemplates](https://help.aliyun.com/document_detail/416781.html).
        # *   If you set the `RemediationType` parameter to `FC`, set this parameter to the Alibaba Cloud Resource Name (ARN) of the relevant Function Compute resource, such as `acs:fc:cn-hangzhou:100931896542****:services/ConfigService.LATEST/functions/test-php`.
        # 
        # This parameter is required.
        self.remediation_template_id = remediation_template_id
        # The type of the remediation template. Valid values:
        # 
        # *   OOS: Operation Orchestration Service (official remediation)
        # *   FC: Function Compute (custom remediation)
        # 
        # This parameter is required.
        self.remediation_type = remediation_type
        # The source of remediation. Valid values:
        # 
        # *   ALIYUN (default): official template.
        # *   CUSTOM: custom template.
        # *   NONE: none.
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.invoke_type is not None:
            result['InvokeType'] = self.invoke_type
        if self.params is not None:
            result['Params'] = self.params
        if self.remediation_template_id is not None:
            result['RemediationTemplateId'] = self.remediation_template_id
        if self.remediation_type is not None:
            result['RemediationType'] = self.remediation_type
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('InvokeType') is not None:
            self.invoke_type = m.get('InvokeType')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RemediationTemplateId') is not None:
            self.remediation_template_id = m.get('RemediationTemplateId')
        if m.get('RemediationType') is not None:
            self.remediation_type = m.get('RemediationType')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class CreateRemediationResponseBody(TeaModel):
    def __init__(
        self,
        remediation_id: str = None,
        request_id: str = None,
    ):
        # The ID of the remediation template.
        self.remediation_id = remediation_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remediation_id is not None:
            result['RemediationId'] = self.remediation_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemediationId') is not None:
            self.remediation_id = m.get('RemediationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRemediationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRemediationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRemediationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeactiveAggregateConfigRulesRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
        config_rule_ids: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListAggregateCompliancePacks](https://help.aliyun.com/document_detail/262059.html).
        self.compliance_pack_id = compliance_pack_id
        # The rule ID. Separate multiple rule IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class DeactiveAggregateConfigRulesResponseBodyOperateRuleResultOperateRuleItemList(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The error code.
        # 
        # *   If the rule is disabled, no error code is returned.
        # *   If the rule fails to be disabled, an error code is returned. For more information about error codes, see [Error codes](https://error-center.alibabacloud.com/status/product/Config).
        self.error_code = error_code
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeactiveAggregateConfigRulesResponseBodyOperateRuleResult(TeaModel):
    def __init__(
        self,
        operate_rule_item_list: List[DeactiveAggregateConfigRulesResponseBodyOperateRuleResultOperateRuleItemList] = None,
    ):
        # The operations that are performed to disable the rule.
        self.operate_rule_item_list = operate_rule_item_list

    def validate(self):
        if self.operate_rule_item_list:
            for k in self.operate_rule_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateRuleItemList'] = []
        if self.operate_rule_item_list is not None:
            for k in self.operate_rule_item_list:
                result['OperateRuleItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_rule_item_list = []
        if m.get('OperateRuleItemList') is not None:
            for k in m.get('OperateRuleItemList'):
                temp_model = DeactiveAggregateConfigRulesResponseBodyOperateRuleResultOperateRuleItemList()
                self.operate_rule_item_list.append(temp_model.from_map(k))
        return self


class DeactiveAggregateConfigRulesResponseBody(TeaModel):
    def __init__(
        self,
        operate_rule_result: DeactiveAggregateConfigRulesResponseBodyOperateRuleResult = None,
        request_id: str = None,
    ):
        # The results of the operations that are performed to disable the specified rules.
        self.operate_rule_result = operate_rule_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.operate_rule_result:
            self.operate_rule_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_rule_result is not None:
            result['OperateRuleResult'] = self.operate_rule_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateRuleResult') is not None:
            temp_model = DeactiveAggregateConfigRulesResponseBodyOperateRuleResult()
            self.operate_rule_result = temp_model.from_map(m['OperateRuleResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeactiveAggregateConfigRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeactiveAggregateConfigRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeactiveAggregateConfigRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeactiveConfigRulesRequest(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        config_rule_ids: str = None,
    ):
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListCompliancePacks](https://help.aliyun.com/document_detail/263332.html).
        self.compliance_pack_id = compliance_pack_id
        # The ID of the rule. Separate multiple rule IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a rule, see [ListConfigRules](https://help.aliyun.com/document_detail/169607.html).
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class DeactiveConfigRulesResponseBodyOperateRuleResultOperateRuleItemList(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The error code.
        # 
        # *   If the rule is disabled, no error code is returned.
        # *   If the rule fails to be disabled, an error code is returned. For more information about error codes, see [Error codes](https://error-center.alibabacloud.com/status/product/Config).
        self.error_code = error_code
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeactiveConfigRulesResponseBodyOperateRuleResult(TeaModel):
    def __init__(
        self,
        operate_rule_item_list: List[DeactiveConfigRulesResponseBodyOperateRuleResultOperateRuleItemList] = None,
    ):
        # The operations that are performed to disable the rule.
        self.operate_rule_item_list = operate_rule_item_list

    def validate(self):
        if self.operate_rule_item_list:
            for k in self.operate_rule_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateRuleItemList'] = []
        if self.operate_rule_item_list is not None:
            for k in self.operate_rule_item_list:
                result['OperateRuleItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_rule_item_list = []
        if m.get('OperateRuleItemList') is not None:
            for k in m.get('OperateRuleItemList'):
                temp_model = DeactiveConfigRulesResponseBodyOperateRuleResultOperateRuleItemList()
                self.operate_rule_item_list.append(temp_model.from_map(k))
        return self


class DeactiveConfigRulesResponseBody(TeaModel):
    def __init__(
        self,
        operate_rule_result: DeactiveConfigRulesResponseBodyOperateRuleResult = None,
        request_id: str = None,
    ):
        # The results of the operations that are performed to disable the specified rules.
        self.operate_rule_result = operate_rule_result
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.operate_rule_result:
            self.operate_rule_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_rule_result is not None:
            result['OperateRuleResult'] = self.operate_rule_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateRuleResult') is not None:
            temp_model = DeactiveConfigRulesResponseBodyOperateRuleResult()
            self.operate_rule_result = temp_model.from_map(m['OperateRuleResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeactiveConfigRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeactiveConfigRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeactiveConfigRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAggregateCompliancePacksRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        client_token: str = None,
        compliance_pack_ids: str = None,
        delete_rule: bool = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The `token` can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token
        # The ID of the compliance package. Separate multiple compliance package IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListAggregateCompliancePacks](https://help.aliyun.com/document_detail/262059.html).
        # 
        # This parameter is required.
        self.compliance_pack_ids = compliance_pack_ids
        # Specifies whether to delete the rules in the compliance package. Valid values:
        # 
        # *   true: The rules are deleted.
        # *   false (default): The rules are not deleted.
        self.delete_rule = delete_rule

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.compliance_pack_ids is not None:
            result['CompliancePackIds'] = self.compliance_pack_ids
        if self.delete_rule is not None:
            result['DeleteRule'] = self.delete_rule
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CompliancePackIds') is not None:
            self.compliance_pack_ids = m.get('CompliancePackIds')
        if m.get('DeleteRule') is not None:
            self.delete_rule = m.get('DeleteRule')
        return self


class DeleteAggregateCompliancePacksResponseBodyOperateCompliancePacksResultOperateCompliancePacks(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The error code returned.
        # 
        # *   If the compliance package is deleted, no error code is returned.
        # *   If the compliance package fails to be deleted, an error code is returned. For more information about error codes, see [Error codes](https://error-center.alibabacloud.com/status/product/Config).
        self.error_code = error_code
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteAggregateCompliancePacksResponseBodyOperateCompliancePacksResult(TeaModel):
    def __init__(
        self,
        operate_compliance_packs: List[DeleteAggregateCompliancePacksResponseBodyOperateCompliancePacksResultOperateCompliancePacks] = None,
    ):
        # An array that contains the deleted compliance packages.
        self.operate_compliance_packs = operate_compliance_packs

    def validate(self):
        if self.operate_compliance_packs:
            for k in self.operate_compliance_packs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateCompliancePacks'] = []
        if self.operate_compliance_packs is not None:
            for k in self.operate_compliance_packs:
                result['OperateCompliancePacks'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_compliance_packs = []
        if m.get('OperateCompliancePacks') is not None:
            for k in m.get('OperateCompliancePacks'):
                temp_model = DeleteAggregateCompliancePacksResponseBodyOperateCompliancePacksResultOperateCompliancePacks()
                self.operate_compliance_packs.append(temp_model.from_map(k))
        return self


class DeleteAggregateCompliancePacksResponseBody(TeaModel):
    def __init__(
        self,
        operate_compliance_packs_result: DeleteAggregateCompliancePacksResponseBodyOperateCompliancePacksResult = None,
        request_id: str = None,
    ):
        # The results of the delete operations.
        self.operate_compliance_packs_result = operate_compliance_packs_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.operate_compliance_packs_result:
            self.operate_compliance_packs_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_compliance_packs_result is not None:
            result['OperateCompliancePacksResult'] = self.operate_compliance_packs_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateCompliancePacksResult') is not None:
            temp_model = DeleteAggregateCompliancePacksResponseBodyOperateCompliancePacksResult()
            self.operate_compliance_packs_result = temp_model.from_map(m['OperateCompliancePacksResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAggregateCompliancePacksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAggregateCompliancePacksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAggregateCompliancePacksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAggregateConfigDeliveryChannelRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        delivery_channel_id: str = None,
    ):
        # The ID of the account group.
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the delivery channel.
        # 
        # For more information about how to obtain the ID of a delivery channel, see [ListAggregateConfigDeliveryChannels](https://help.aliyun.com/document_detail/429842.html).
        # 
        # This parameter is required.
        self.delivery_channel_id = delivery_channel_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.delivery_channel_id is not None:
            result['DeliveryChannelId'] = self.delivery_channel_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('DeliveryChannelId') is not None:
            self.delivery_channel_id = m.get('DeliveryChannelId')
        return self


class DeleteAggregateConfigDeliveryChannelResponseBody(TeaModel):
    def __init__(
        self,
        delivery_channel_id: str = None,
        request_id: str = None,
    ):
        # The ID of the delivery channel.
        self.delivery_channel_id = delivery_channel_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_channel_id is not None:
            result['DeliveryChannelId'] = self.delivery_channel_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryChannelId') is not None:
            self.delivery_channel_id = m.get('DeliveryChannelId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAggregateConfigDeliveryChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAggregateConfigDeliveryChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAggregateConfigDeliveryChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAggregateConfigRulesRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        config_rule_ids: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The rule ID. Separate multiple rule IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        # 
        # This parameter is required.
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class DeleteAggregateConfigRulesResponseBodyOperateRuleResultOperateRuleItemList(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The error code returned.
        # 
        # *   If the rule is deleted, no error code is returned.
        # *   If the rule fails to be deleted, an error code is returned. For more information about error codes, see [Error codes](https://error-center.alibabacloud.com/status/product/Config).
        self.error_code = error_code
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteAggregateConfigRulesResponseBodyOperateRuleResult(TeaModel):
    def __init__(
        self,
        operate_rule_item_list: List[DeleteAggregateConfigRulesResponseBodyOperateRuleResultOperateRuleItemList] = None,
    ):
        # The details of the result.
        self.operate_rule_item_list = operate_rule_item_list

    def validate(self):
        if self.operate_rule_item_list:
            for k in self.operate_rule_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateRuleItemList'] = []
        if self.operate_rule_item_list is not None:
            for k in self.operate_rule_item_list:
                result['OperateRuleItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_rule_item_list = []
        if m.get('OperateRuleItemList') is not None:
            for k in m.get('OperateRuleItemList'):
                temp_model = DeleteAggregateConfigRulesResponseBodyOperateRuleResultOperateRuleItemList()
                self.operate_rule_item_list.append(temp_model.from_map(k))
        return self


class DeleteAggregateConfigRulesResponseBody(TeaModel):
    def __init__(
        self,
        operate_rule_result: DeleteAggregateConfigRulesResponseBodyOperateRuleResult = None,
        request_id: str = None,
    ):
        # The results of the delete operations.
        self.operate_rule_result = operate_rule_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.operate_rule_result:
            self.operate_rule_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_rule_result is not None:
            result['OperateRuleResult'] = self.operate_rule_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateRuleResult') is not None:
            temp_model = DeleteAggregateConfigRulesResponseBodyOperateRuleResult()
            self.operate_rule_result = temp_model.from_map(m['OperateRuleResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAggregateConfigRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAggregateConfigRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAggregateConfigRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAggregateRemediationsRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        remediation_ids: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the remediation template. Separate multiple remediation template IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a remediation template, see [ListAggregateRemediations](https://help.aliyun.com/document_detail/270036.html).
        # 
        # This parameter is required.
        self.remediation_ids = remediation_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.remediation_ids is not None:
            result['RemediationIds'] = self.remediation_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('RemediationIds') is not None:
            self.remediation_ids = m.get('RemediationIds')
        return self


class DeleteAggregateRemediationsResponseBodyRemediationDeleteResults(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        remediation_id: str = None,
        success: bool = None,
    ):
        # The error code returned.
        # 
        # *   If the remediation template is deleted, no error code is returned.
        # *   If the remediation template fails to be deleted, an error code is returned. For more information about error codes, see [Error codes](https://error-center.alibabacloud.com/status/product/Config).
        self.error_message = error_message
        # The ID of the remediation template.
        self.remediation_id = remediation_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.remediation_id is not None:
            result['RemediationId'] = self.remediation_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RemediationId') is not None:
            self.remediation_id = m.get('RemediationId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteAggregateRemediationsResponseBody(TeaModel):
    def __init__(
        self,
        remediation_delete_results: List[DeleteAggregateRemediationsResponseBodyRemediationDeleteResults] = None,
        request_id: str = None,
    ):
        # The results of the delete operation.
        self.remediation_delete_results = remediation_delete_results
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.remediation_delete_results:
            for k in self.remediation_delete_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RemediationDeleteResults'] = []
        if self.remediation_delete_results is not None:
            for k in self.remediation_delete_results:
                result['RemediationDeleteResults'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.remediation_delete_results = []
        if m.get('RemediationDeleteResults') is not None:
            for k in m.get('RemediationDeleteResults'):
                temp_model = DeleteAggregateRemediationsResponseBodyRemediationDeleteResults()
                self.remediation_delete_results.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAggregateRemediationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAggregateRemediationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAggregateRemediationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAggregatorsRequest(TeaModel):
    def __init__(
        self,
        aggregator_ids: str = None,
        client_token: str = None,
    ):
        # The ID of the account group. Separate multiple IDs with commas (,).
        # 
        # This parameter is required.
        self.aggregator_ids = aggregator_ids
        # The client token that you want to use to ensure the idempotency of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_ids is not None:
            result['AggregatorIds'] = self.aggregator_ids
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorIds') is not None:
            self.aggregator_ids = m.get('AggregatorIds')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class DeleteAggregatorsResponseBodyOperateAggregatorsResultOperateAggregators(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The ID of the account group.
        self.aggregator_id = aggregator_id
        # The error code returned.
        # 
        # > No error code is returned for the account group if the account group is deleted.
        self.error_code = error_code
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteAggregatorsResponseBodyOperateAggregatorsResult(TeaModel):
    def __init__(
        self,
        operate_aggregators: List[DeleteAggregatorsResponseBodyOperateAggregatorsResultOperateAggregators] = None,
    ):
        # The details of the account group.
        self.operate_aggregators = operate_aggregators

    def validate(self):
        if self.operate_aggregators:
            for k in self.operate_aggregators:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateAggregators'] = []
        if self.operate_aggregators is not None:
            for k in self.operate_aggregators:
                result['OperateAggregators'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_aggregators = []
        if m.get('OperateAggregators') is not None:
            for k in m.get('OperateAggregators'):
                temp_model = DeleteAggregatorsResponseBodyOperateAggregatorsResultOperateAggregators()
                self.operate_aggregators.append(temp_model.from_map(k))
        return self


class DeleteAggregatorsResponseBody(TeaModel):
    def __init__(
        self,
        operate_aggregators_result: DeleteAggregatorsResponseBodyOperateAggregatorsResult = None,
        request_id: str = None,
    ):
        # The returned result.
        self.operate_aggregators_result = operate_aggregators_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.operate_aggregators_result:
            self.operate_aggregators_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_aggregators_result is not None:
            result['OperateAggregatorsResult'] = self.operate_aggregators_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateAggregatorsResult') is not None:
            temp_model = DeleteAggregatorsResponseBodyOperateAggregatorsResult()
            self.operate_aggregators_result = temp_model.from_map(m['OperateAggregatorsResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAggregatorsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAggregatorsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAggregatorsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCompliancePacksRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        compliance_pack_ids: str = None,
        delete_rule: bool = None,
    ):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The `token` can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token
        # The ID of the compliance package. Separate multiple compliance package IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListCompliancePacks](https://help.aliyun.com/document_detail/263332.html).
        # 
        # This parameter is required.
        self.compliance_pack_ids = compliance_pack_ids
        # Specifies whether to delete the rules in the compliance package. Valid values:
        # 
        # *   true: The rules are deleted.
        # *   false (default): The rules are not deleted.
        self.delete_rule = delete_rule

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.compliance_pack_ids is not None:
            result['CompliancePackIds'] = self.compliance_pack_ids
        if self.delete_rule is not None:
            result['DeleteRule'] = self.delete_rule
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CompliancePackIds') is not None:
            self.compliance_pack_ids = m.get('CompliancePackIds')
        if m.get('DeleteRule') is not None:
            self.delete_rule = m.get('DeleteRule')
        return self


class DeleteCompliancePacksResponseBodyOperateCompliancePacksResultOperateCompliancePacks(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The error code returned.
        # 
        # *   If the compliance package is deleted, no error code is returned.
        # *   If the compliance package fails to be deleted, an error code is returned. For more information about error codes, see [Error codes](https://error-center.alibabacloud.com/status/product/Config).
        self.error_code = error_code
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCompliancePacksResponseBodyOperateCompliancePacksResult(TeaModel):
    def __init__(
        self,
        operate_compliance_packs: List[DeleteCompliancePacksResponseBodyOperateCompliancePacksResultOperateCompliancePacks] = None,
    ):
        # An array that contains compliance packages that are deleted.
        self.operate_compliance_packs = operate_compliance_packs

    def validate(self):
        if self.operate_compliance_packs:
            for k in self.operate_compliance_packs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateCompliancePacks'] = []
        if self.operate_compliance_packs is not None:
            for k in self.operate_compliance_packs:
                result['OperateCompliancePacks'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_compliance_packs = []
        if m.get('OperateCompliancePacks') is not None:
            for k in m.get('OperateCompliancePacks'):
                temp_model = DeleteCompliancePacksResponseBodyOperateCompliancePacksResultOperateCompliancePacks()
                self.operate_compliance_packs.append(temp_model.from_map(k))
        return self


class DeleteCompliancePacksResponseBody(TeaModel):
    def __init__(
        self,
        operate_compliance_packs_result: DeleteCompliancePacksResponseBodyOperateCompliancePacksResult = None,
        request_id: str = None,
    ):
        # The returned result.
        self.operate_compliance_packs_result = operate_compliance_packs_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.operate_compliance_packs_result:
            self.operate_compliance_packs_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_compliance_packs_result is not None:
            result['OperateCompliancePacksResult'] = self.operate_compliance_packs_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateCompliancePacksResult') is not None:
            temp_model = DeleteCompliancePacksResponseBodyOperateCompliancePacksResult()
            self.operate_compliance_packs_result = temp_model.from_map(m['OperateCompliancePacksResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCompliancePacksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCompliancePacksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCompliancePacksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConfigDeliveryChannelRequest(TeaModel):
    def __init__(
        self,
        delivery_channel_id: str = None,
    ):
        # The ID of the delivery channel.
        # 
        # For more information about how to obtain the ID of a delivery channel, see [DescribeDeliveryChannels](https://help.aliyun.com/document_detail/429841.html).
        # 
        # This parameter is required.
        self.delivery_channel_id = delivery_channel_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_channel_id is not None:
            result['DeliveryChannelId'] = self.delivery_channel_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryChannelId') is not None:
            self.delivery_channel_id = m.get('DeliveryChannelId')
        return self


class DeleteConfigDeliveryChannelResponseBody(TeaModel):
    def __init__(
        self,
        delivery_channel_id: str = None,
        request_id: str = None,
    ):
        # The ID of the delivery channel.
        self.delivery_channel_id = delivery_channel_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_channel_id is not None:
            result['DeliveryChannelId'] = self.delivery_channel_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryChannelId') is not None:
            self.delivery_channel_id = m.get('DeliveryChannelId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteConfigDeliveryChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteConfigDeliveryChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteConfigDeliveryChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConfigRulesRequest(TeaModel):
    def __init__(
        self,
        config_rule_ids: str = None,
    ):
        # The rule IDs. Separate multiple rule IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a rule, see [ListConfigRules](https://help.aliyun.com/document_detail/609222.html).
        # 
        # This parameter is required.
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class DeleteConfigRulesResponseBodyOperateRuleResultOperateRuleItemList(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The error code.
        # 
        # *   If the rule is disabled, no error code is returned.
        # *   If the rule fails to be disabled, an error code is returned. For more information about error codes, see [Error codes](https://api.alibabacloud.com/document/Config/2020-09-07/errorCode).
        self.error_code = error_code
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConfigRulesResponseBodyOperateRuleResult(TeaModel):
    def __init__(
        self,
        operate_rule_item_list: List[DeleteConfigRulesResponseBodyOperateRuleResultOperateRuleItemList] = None,
    ):
        # The result of the delete operation.
        self.operate_rule_item_list = operate_rule_item_list

    def validate(self):
        if self.operate_rule_item_list:
            for k in self.operate_rule_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateRuleItemList'] = []
        if self.operate_rule_item_list is not None:
            for k in self.operate_rule_item_list:
                result['OperateRuleItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_rule_item_list = []
        if m.get('OperateRuleItemList') is not None:
            for k in m.get('OperateRuleItemList'):
                temp_model = DeleteConfigRulesResponseBodyOperateRuleResultOperateRuleItemList()
                self.operate_rule_item_list.append(temp_model.from_map(k))
        return self


class DeleteConfigRulesResponseBody(TeaModel):
    def __init__(
        self,
        operate_rule_result: DeleteConfigRulesResponseBodyOperateRuleResult = None,
        request_id: str = None,
    ):
        # The results of the delete operations.
        self.operate_rule_result = operate_rule_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.operate_rule_result:
            self.operate_rule_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_rule_result is not None:
            result['OperateRuleResult'] = self.operate_rule_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateRuleResult') is not None:
            temp_model = DeleteConfigRulesResponseBodyOperateRuleResult()
            self.operate_rule_result = temp_model.from_map(m['OperateRuleResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteConfigRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteConfigRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteConfigRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRemediationsRequest(TeaModel):
    def __init__(
        self,
        remediation_ids: str = None,
    ):
        # The ID of the remediation template. Separate multiple remediation template IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a remediation template, see [ListRemediations](https://help.aliyun.com/document_detail/270772.html).
        # 
        # This parameter is required.
        self.remediation_ids = remediation_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remediation_ids is not None:
            result['RemediationIds'] = self.remediation_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemediationIds') is not None:
            self.remediation_ids = m.get('RemediationIds')
        return self


class DeleteRemediationsResponseBodyRemediationDeleteResults(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        remediation_id: str = None,
        success: bool = None,
    ):
        # The error code returned.
        # 
        # *   If the remediation template is deleted, no error code is returned.
        # *   If the remediation template fails to be deleted, an error code is returned. For more information about error codes, see [Error codes](https://error-center.alibabacloud.com/status/product/Config).
        self.error_message = error_message
        # The ID of the remediation template.
        self.remediation_id = remediation_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.remediation_id is not None:
            result['RemediationId'] = self.remediation_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RemediationId') is not None:
            self.remediation_id = m.get('RemediationId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteRemediationsResponseBody(TeaModel):
    def __init__(
        self,
        remediation_delete_results: List[DeleteRemediationsResponseBodyRemediationDeleteResults] = None,
        request_id: str = None,
    ):
        # The returned result.
        self.remediation_delete_results = remediation_delete_results
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.remediation_delete_results:
            for k in self.remediation_delete_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RemediationDeleteResults'] = []
        if self.remediation_delete_results is not None:
            for k in self.remediation_delete_results:
                result['RemediationDeleteResults'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.remediation_delete_results = []
        if m.get('RemediationDeleteResults') is not None:
            for k in m.get('RemediationDeleteResults'):
                temp_model = DeleteRemediationsResponseBodyRemediationDeleteResults()
                self.remediation_delete_results.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRemediationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteRemediationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRemediationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRemediationRequest(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        remediation_id: str = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The ID of the remediation configuration.
        self.remediation_id = remediation_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.remediation_id is not None:
            result['RemediationId'] = self.remediation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('RemediationId') is not None:
            self.remediation_id = m.get('RemediationId')
        return self


class DescribeRemediationResponseBodyRemediation(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        config_rule_id: str = None,
        invoke_type: str = None,
        last_successful_invocation_id: str = None,
        last_successful_invocation_time: int = None,
        last_successful_invocation_type: str = None,
        remediation_id: str = None,
        remediation_origin_params: str = None,
        remediation_source_type: str = None,
        remediation_template_id: str = None,
        remediation_type: str = None,
    ):
        # The ID of the Alibaba Cloud account.
        self.account_id = account_id
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The execution mode of the remediation template. Valid values:
        # 
        # *   NON_EXECUTION: The remediation template was not executed.
        # *   AUTO_EXECUTION: The remediation template was automatically executed.
        # *   MANUAL_EXECUTION: The remediation template was manually executed.
        # *   NOT_CONFIG: The execution mode was not specified.
        self.invoke_type = invoke_type
        # The record ID of the last successful execution of the remediation template.
        self.last_successful_invocation_id = last_successful_invocation_id
        # The timestamp of the last successful execution of the remediation template. Unit: milliseconds.
        self.last_successful_invocation_time = last_successful_invocation_time
        # The mode of the last successful execution of the remediation template. Valid values:
        # 
        # *   NON_EXECUTION: The remediation template was not executed.
        # *   AUTO_EXECUTION: The remediation template was automatically executed.
        # *   MANUAL_EXECUTION: The remediation template was manually executed.
        # *   NOT_CONFIG: The execution mode was not specified.
        self.last_successful_invocation_type = last_successful_invocation_type
        # The ID of the remediation configuration.
        self.remediation_id = remediation_id
        # The converted configuration of the remediation template. This parameter is returned only for an OOS remediation template.
        # 
        # This parameter is required.
        self.remediation_origin_params = remediation_origin_params
        # The source of the remediation template. Valid values:
        # 
        # *   ALIYUN: official template
        # *   CUSTOM: custom template
        # *   NONE: none
        self.remediation_source_type = remediation_source_type
        # The ID of the remediation template.
        self.remediation_template_id = remediation_template_id
        # The type of the remediation template. Valid values:
        # 
        # *   OOS: Operation Orchestration Service (official remediation)
        # *   FC: Function Compute (custom remediation)
        self.remediation_type = remediation_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.invoke_type is not None:
            result['InvokeType'] = self.invoke_type
        if self.last_successful_invocation_id is not None:
            result['LastSuccessfulInvocationId'] = self.last_successful_invocation_id
        if self.last_successful_invocation_time is not None:
            result['LastSuccessfulInvocationTime'] = self.last_successful_invocation_time
        if self.last_successful_invocation_type is not None:
            result['LastSuccessfulInvocationType'] = self.last_successful_invocation_type
        if self.remediation_id is not None:
            result['RemediationId'] = self.remediation_id
        if self.remediation_origin_params is not None:
            result['RemediationOriginParams'] = self.remediation_origin_params
        if self.remediation_source_type is not None:
            result['RemediationSourceType'] = self.remediation_source_type
        if self.remediation_template_id is not None:
            result['RemediationTemplateId'] = self.remediation_template_id
        if self.remediation_type is not None:
            result['RemediationType'] = self.remediation_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('InvokeType') is not None:
            self.invoke_type = m.get('InvokeType')
        if m.get('LastSuccessfulInvocationId') is not None:
            self.last_successful_invocation_id = m.get('LastSuccessfulInvocationId')
        if m.get('LastSuccessfulInvocationTime') is not None:
            self.last_successful_invocation_time = m.get('LastSuccessfulInvocationTime')
        if m.get('LastSuccessfulInvocationType') is not None:
            self.last_successful_invocation_type = m.get('LastSuccessfulInvocationType')
        if m.get('RemediationId') is not None:
            self.remediation_id = m.get('RemediationId')
        if m.get('RemediationOriginParams') is not None:
            self.remediation_origin_params = m.get('RemediationOriginParams')
        if m.get('RemediationSourceType') is not None:
            self.remediation_source_type = m.get('RemediationSourceType')
        if m.get('RemediationTemplateId') is not None:
            self.remediation_template_id = m.get('RemediationTemplateId')
        if m.get('RemediationType') is not None:
            self.remediation_type = m.get('RemediationType')
        return self


class DescribeRemediationResponseBody(TeaModel):
    def __init__(
        self,
        remediation: DescribeRemediationResponseBodyRemediation = None,
        request_id: str = None,
    ):
        # The details of the remediation configuration.
        self.remediation = remediation
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.remediation:
            self.remediation.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remediation is not None:
            result['Remediation'] = self.remediation.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Remediation') is not None:
            temp_model = DescribeRemediationResponseBodyRemediation()
            self.remediation = temp_model.from_map(m['Remediation'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRemediationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRemediationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRemediationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachAggregateConfigRuleToCompliancePackRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
        config_rule_ids: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListAggregateCompliancePacks](https://help.aliyun.com/document_detail/262059.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id
        # The rule IDs. Separate multiple rule IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        # 
        # This parameter is required.
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class DetachAggregateConfigRuleToCompliancePackResponseBodyOperateRuleResultOperateRuleItemList(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The error code.
        # 
        # *   This parameter is empty if the rule is removed from the compliance package.
        # *   An error code is returned if the rule fails to be removed from the compliance package. For more information about error codes, see [Error codes](https://error-center.alibabacloud.com/status/product/Config).
        self.error_code = error_code
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DetachAggregateConfigRuleToCompliancePackResponseBodyOperateRuleResult(TeaModel):
    def __init__(
        self,
        operate_rule_item_list: List[DetachAggregateConfigRuleToCompliancePackResponseBodyOperateRuleResultOperateRuleItemList] = None,
    ):
        # The result of the operation to remove the rule.
        self.operate_rule_item_list = operate_rule_item_list

    def validate(self):
        if self.operate_rule_item_list:
            for k in self.operate_rule_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateRuleItemList'] = []
        if self.operate_rule_item_list is not None:
            for k in self.operate_rule_item_list:
                result['OperateRuleItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_rule_item_list = []
        if m.get('OperateRuleItemList') is not None:
            for k in m.get('OperateRuleItemList'):
                temp_model = DetachAggregateConfigRuleToCompliancePackResponseBodyOperateRuleResultOperateRuleItemList()
                self.operate_rule_item_list.append(temp_model.from_map(k))
        return self


class DetachAggregateConfigRuleToCompliancePackResponseBody(TeaModel):
    def __init__(
        self,
        operate_rule_result: DetachAggregateConfigRuleToCompliancePackResponseBodyOperateRuleResult = None,
        request_id: str = None,
    ):
        # The results of the operations to remove one or more rules.
        self.operate_rule_result = operate_rule_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.operate_rule_result:
            self.operate_rule_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_rule_result is not None:
            result['OperateRuleResult'] = self.operate_rule_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateRuleResult') is not None:
            temp_model = DetachAggregateConfigRuleToCompliancePackResponseBodyOperateRuleResult()
            self.operate_rule_result = temp_model.from_map(m['OperateRuleResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DetachAggregateConfigRuleToCompliancePackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DetachAggregateConfigRuleToCompliancePackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DetachAggregateConfigRuleToCompliancePackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachConfigRuleToCompliancePackRequest(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        config_rule_ids: str = None,
    ):
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListCompliancePacks](https://help.aliyun.com/document_detail/263332.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id
        # The rule ID. Separate multiple rule IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a rule, see [ListConfigRules](https://help.aliyun.com/document_detail/169607.html).
        # 
        # This parameter is required.
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class DetachConfigRuleToCompliancePackResponseBodyOperateRuleResultOperateRuleItemList(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The error code returned.
        # 
        # *   This parameter is empty if the rule is removed from the compliance package.
        # *   An error code is returned if the rule fails to be removed from the compliance package. For more information about error codes, see [Error codes](https://error-center.alibabacloud.com/status/product/Config).
        self.error_code = error_code
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DetachConfigRuleToCompliancePackResponseBodyOperateRuleResult(TeaModel):
    def __init__(
        self,
        operate_rule_item_list: List[DetachConfigRuleToCompliancePackResponseBodyOperateRuleResultOperateRuleItemList] = None,
    ):
        # The result of the operation to remove the rule.
        self.operate_rule_item_list = operate_rule_item_list

    def validate(self):
        if self.operate_rule_item_list:
            for k in self.operate_rule_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperateRuleItemList'] = []
        if self.operate_rule_item_list is not None:
            for k in self.operate_rule_item_list:
                result['OperateRuleItemList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.operate_rule_item_list = []
        if m.get('OperateRuleItemList') is not None:
            for k in m.get('OperateRuleItemList'):
                temp_model = DetachConfigRuleToCompliancePackResponseBodyOperateRuleResultOperateRuleItemList()
                self.operate_rule_item_list.append(temp_model.from_map(k))
        return self


class DetachConfigRuleToCompliancePackResponseBody(TeaModel):
    def __init__(
        self,
        operate_rule_result: DetachConfigRuleToCompliancePackResponseBodyOperateRuleResult = None,
        request_id: str = None,
    ):
        # The results of the operations to remove one or more rules.
        self.operate_rule_result = operate_rule_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.operate_rule_result:
            self.operate_rule_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_rule_result is not None:
            result['OperateRuleResult'] = self.operate_rule_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperateRuleResult') is not None:
            temp_model = DetachConfigRuleToCompliancePackResponseBodyOperateRuleResult()
            self.operate_rule_result = temp_model.from_map(m['OperateRuleResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DetachConfigRuleToCompliancePackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DetachConfigRuleToCompliancePackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DetachConfigRuleToCompliancePackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EvaluatePreConfigRulesRequestResourceEvaluateItemsRules(TeaModel):
    def __init__(
        self,
        identifier: str = None,
        input_parameters: str = None,
    ):
        # The identifier of the evaluation rule.
        # 
        # For more information about how to obtain the identifier of an evaluation rule, see [ListManagedRules](https://help.aliyun.com/document_detail/467810.html).
        self.identifier = identifier
        # The input parameters of the evaluation rule.
        self.input_parameters = input_parameters

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.input_parameters is not None:
            result['InputParameters'] = self.input_parameters
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('InputParameters') is not None:
            self.input_parameters = m.get('InputParameters')
        return self


class EvaluatePreConfigRulesRequestResourceEvaluateItems(TeaModel):
    def __init__(
        self,
        resource_logical_id: str = None,
        resource_properties: str = None,
        resource_type: str = None,
        rules: List[EvaluatePreConfigRulesRequestResourceEvaluateItemsRules] = None,
    ):
        # The logical ID of the resource.
        self.resource_logical_id = resource_logical_id
        # The properties of the resource.
        self.resource_properties = resource_properties
        # The type of the resource.
        self.resource_type = resource_type
        # The evaluation rules.
        self.rules = rules

    def validate(self):
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_logical_id is not None:
            result['ResourceLogicalId'] = self.resource_logical_id
        if self.resource_properties is not None:
            result['ResourceProperties'] = self.resource_properties
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceLogicalId') is not None:
            self.resource_logical_id = m.get('ResourceLogicalId')
        if m.get('ResourceProperties') is not None:
            self.resource_properties = m.get('ResourceProperties')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = EvaluatePreConfigRulesRequestResourceEvaluateItemsRules()
                self.rules.append(temp_model.from_map(k))
        return self


class EvaluatePreConfigRulesRequest(TeaModel):
    def __init__(
        self,
        enable_managed_rules: bool = None,
        resource_evaluate_items: List[EvaluatePreConfigRulesRequestResourceEvaluateItems] = None,
    ):
        # Specifies whether to enable the managed rule. Valid values:
        # 
        # *   true: enables the managed rule.
        # *   false: does not enable the managed rule. This is the default value.
        # 
        # >  After you create an evaluation rule, a managed rule that has the same settings as the evaluation rule is created. After you create a resource, the managed rule can be used to continuously check the compliance of the resource.
        self.enable_managed_rules = enable_managed_rules
        # The resources that you want to evaluate.
        # 
        # This parameter is required.
        self.resource_evaluate_items = resource_evaluate_items

    def validate(self):
        if self.resource_evaluate_items:
            for k in self.resource_evaluate_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_managed_rules is not None:
            result['EnableManagedRules'] = self.enable_managed_rules
        result['ResourceEvaluateItems'] = []
        if self.resource_evaluate_items is not None:
            for k in self.resource_evaluate_items:
                result['ResourceEvaluateItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableManagedRules') is not None:
            self.enable_managed_rules = m.get('EnableManagedRules')
        self.resource_evaluate_items = []
        if m.get('ResourceEvaluateItems') is not None:
            for k in m.get('ResourceEvaluateItems'):
                temp_model = EvaluatePreConfigRulesRequestResourceEvaluateItems()
                self.resource_evaluate_items.append(temp_model.from_map(k))
        return self


class EvaluatePreConfigRulesShrinkRequest(TeaModel):
    def __init__(
        self,
        enable_managed_rules: bool = None,
        resource_evaluate_items_shrink: str = None,
    ):
        # Specifies whether to enable the managed rule. Valid values:
        # 
        # *   true: enables the managed rule.
        # *   false: does not enable the managed rule. This is the default value.
        # 
        # >  After you create an evaluation rule, a managed rule that has the same settings as the evaluation rule is created. After you create a resource, the managed rule can be used to continuously check the compliance of the resource.
        self.enable_managed_rules = enable_managed_rules
        # The resources that you want to evaluate.
        # 
        # This parameter is required.
        self.resource_evaluate_items_shrink = resource_evaluate_items_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_managed_rules is not None:
            result['EnableManagedRules'] = self.enable_managed_rules
        if self.resource_evaluate_items_shrink is not None:
            result['ResourceEvaluateItems'] = self.resource_evaluate_items_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableManagedRules') is not None:
            self.enable_managed_rules = m.get('EnableManagedRules')
        if m.get('ResourceEvaluateItems') is not None:
            self.resource_evaluate_items_shrink = m.get('ResourceEvaluateItems')
        return self


class EvaluatePreConfigRulesResponseBodyResourceEvaluationsRules(TeaModel):
    def __init__(
        self,
        annotation: str = None,
        compliance_type: str = None,
        help_url: str = None,
        identifier: str = None,
    ):
        # The reason why the resource was evaluated as incompliant.
        self.annotation = annotation
        # The compliance type of the resource that was evaluated by using the evaluation rule. Valid values:
        # 
        # *   COMPLIANT: The resource was evaluated as compliant.
        # *   NON_COMPLIANT: The resource was evaluated as incompliant.
        # *   NOT_APPLICABLE: The evaluation rule does not apply to the resource.
        self.compliance_type = compliance_type
        # The URL of the topic that describes how the managed rule remediates the incompliant configurations.
        self.help_url = help_url
        # The identifier of the evaluation rule.
        self.identifier = identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotation is not None:
            result['Annotation'] = self.annotation
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.help_url is not None:
            result['HelpUrl'] = self.help_url
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Annotation') is not None:
            self.annotation = m.get('Annotation')
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('HelpUrl') is not None:
            self.help_url = m.get('HelpUrl')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        return self


class EvaluatePreConfigRulesResponseBodyResourceEvaluations(TeaModel):
    def __init__(
        self,
        resource_logical_id: str = None,
        resource_type: str = None,
        rules: List[EvaluatePreConfigRulesResponseBodyResourceEvaluationsRules] = None,
    ):
        # The logical ID of the resource.
        # 
        # >  If the ResourceLogicalId request parameter is left empty, the value of the ResourceLogicalId response parameter is generated based on the value of the `ResourceProperties` parameter.
        self.resource_logical_id = resource_logical_id
        # The type of the resource.
        self.resource_type = resource_type
        # The evaluation rules.
        self.rules = rules

    def validate(self):
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_logical_id is not None:
            result['ResourceLogicalId'] = self.resource_logical_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceLogicalId') is not None:
            self.resource_logical_id = m.get('ResourceLogicalId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = EvaluatePreConfigRulesResponseBodyResourceEvaluationsRules()
                self.rules.append(temp_model.from_map(k))
        return self


class EvaluatePreConfigRulesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_evaluations: List[EvaluatePreConfigRulesResponseBodyResourceEvaluations] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The details of the compliance evaluation result.
        self.resource_evaluations = resource_evaluations

    def validate(self):
        if self.resource_evaluations:
            for k in self.resource_evaluations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ResourceEvaluations'] = []
        if self.resource_evaluations is not None:
            for k in self.resource_evaluations:
                result['ResourceEvaluations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.resource_evaluations = []
        if m.get('ResourceEvaluations') is not None:
            for k in m.get('ResourceEvaluations'):
                temp_model = EvaluatePreConfigRulesResponseBodyResourceEvaluations()
                self.resource_evaluations.append(temp_model.from_map(k))
        return self


class EvaluatePreConfigRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EvaluatePreConfigRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EvaluatePreConfigRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateAggregateCompliancePackReportRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        client_token: str = None,
        compliance_pack_id: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The `token` can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListAggregateCompliancePacks](https://help.aliyun.com/document_detail/262059.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        return self


class GenerateAggregateCompliancePackReportResponseBody(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        request_id: str = None,
    ):
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GenerateAggregateCompliancePackReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateAggregateCompliancePackReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateAggregateCompliancePackReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateAggregateConfigRulesReportRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        client_token: str = None,
        config_rule_ids: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The `token` can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token
        # The rule ID. Separate multiple rule IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class GenerateAggregateConfigRulesReportResponseBody(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        report_id: str = None,
        request_id: str = None,
    ):
        # The ID of the account group.
        self.aggregator_id = aggregator_id
        # The ID of the compliance evaluation report.
        self.report_id = report_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GenerateAggregateConfigRulesReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateAggregateConfigRulesReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateAggregateConfigRulesReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateAggregateResourceInventoryRequest(TeaModel):
    def __init__(
        self,
        account_ids: str = None,
        aggregator_id: str = None,
        regions: str = None,
        resource_deleted: int = None,
        resource_types: str = None,
    ):
        # The IDs of member accounts in the account group. Separate multiple member account IDs with commas (,).
        self.account_ids = account_ids
        # The ID of the account group.
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The IDs of the regions to which the resources belong. Separate multiple region IDs with commas (,).
        self.regions = regions
        # Indicates whether the resource is deleted. Valid values:
        # 
        # *   1 (default): The resource is retained.
        # *   0: The resource is deleted.
        self.resource_deleted = resource_deleted
        # The resource types. Separate multiple resource types with commas (,).
        self.resource_types = resource_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_ids is not None:
            result['AccountIds'] = self.account_ids
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.regions is not None:
            result['Regions'] = self.regions
        if self.resource_deleted is not None:
            result['ResourceDeleted'] = self.resource_deleted
        if self.resource_types is not None:
            result['ResourceTypes'] = self.resource_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountIds') is not None:
            self.account_ids = m.get('AccountIds')
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('Regions') is not None:
            self.regions = m.get('Regions')
        if m.get('ResourceDeleted') is not None:
            self.resource_deleted = m.get('ResourceDeleted')
        if m.get('ResourceTypes') is not None:
            self.resource_types = m.get('ResourceTypes')
        return self


class GenerateAggregateResourceInventoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GenerateAggregateResourceInventoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateAggregateResourceInventoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateAggregateResourceInventoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateCompliancePackReportRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        compliance_pack_id: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The `token` can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListCompliancePacks](https://help.aliyun.com/document_detail/263332.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        return self


class GenerateCompliancePackReportResponseBody(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        request_id: str = None,
    ):
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GenerateCompliancePackReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateCompliancePackReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateCompliancePackReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateConfigRulesReportRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        config_rule_ids: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must make sure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token
        # The ID of the rule. Separate multiple rule IDs with commas (,).
        # 
        # For more information about how to query the ID of a rule, see [ListConfigRules](https://help.aliyun.com/document_detail/169607.html).
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class GenerateConfigRulesReportResponseBody(TeaModel):
    def __init__(
        self,
        report_id: str = None,
        request_id: str = None,
    ):
        # The ID of the compliance evaluation report.
        self.report_id = report_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GenerateConfigRulesReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateConfigRulesReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateConfigRulesReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateResourceInventoryRequest(TeaModel):
    def __init__(
        self,
        regions: str = None,
        resource_deleted: int = None,
        resource_types: str = None,
    ):
        # The region IDs of the resources. Separate multiple region IDs with commas (,).
        self.regions = regions
        # Indicates whether the resource is deleted. Valid values:
        # 
        # *   1 (default): The resource is retained.
        # *   0: The resource is deleted.
        self.resource_deleted = resource_deleted
        # The resource types. Separate multiple resource types with commas (,).
        self.resource_types = resource_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.regions is not None:
            result['Regions'] = self.regions
        if self.resource_deleted is not None:
            result['ResourceDeleted'] = self.resource_deleted
        if self.resource_types is not None:
            result['ResourceTypes'] = self.resource_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Regions') is not None:
            self.regions = m.get('Regions')
        if m.get('ResourceDeleted') is not None:
            self.resource_deleted = m.get('ResourceDeleted')
        if m.get('ResourceTypes') is not None:
            self.resource_types = m.get('ResourceTypes')
        return self


class GenerateResourceInventoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GenerateResourceInventoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateResourceInventoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateResourceInventoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAdvancedSearchFileResponseBodyResourceSearch(TeaModel):
    def __init__(
        self,
        download_url: str = None,
        resource_inventory_generate_time: int = None,
        status: str = None,
    ):
        # The download URL of the resource file.
        self.download_url = download_url
        # The time when the resource file was generated. The value is a timestamp. Unit: milliseconds.
        self.resource_inventory_generate_time = resource_inventory_generate_time
        # The generation status of the resource file. Valid values:
        # 
        # *   CREATING: The resource file is being generated.
        # *   COMPLETE: The resource file is generated.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.resource_inventory_generate_time is not None:
            result['ResourceInventoryGenerateTime'] = self.resource_inventory_generate_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('ResourceInventoryGenerateTime') is not None:
            self.resource_inventory_generate_time = m.get('ResourceInventoryGenerateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetAdvancedSearchFileResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_search: GetAdvancedSearchFileResponseBodyResourceSearch = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The information about the resource file.
        self.resource_search = resource_search

    def validate(self):
        if self.resource_search:
            self.resource_search.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_search is not None:
            result['ResourceSearch'] = self.resource_search.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceSearch') is not None:
            temp_model = GetAdvancedSearchFileResponseBodyResourceSearch()
            self.resource_search = temp_model.from_map(m['ResourceSearch'])
        return self


class GetAdvancedSearchFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAdvancedSearchFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAdvancedSearchFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateAccountComplianceByPackRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListAggregateCompliancePacks](https://help.aliyun.com/document_detail/262059.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        return self


class GetAggregateAccountComplianceByPackResponseBodyAccountComplianceResultAccountCompliances(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        account_name: str = None,
        compliance_type: str = None,
    ):
        # The ID of the member account in the account group.
        self.account_id = account_id
        # The name of the member account in the account group.
        self.account_name = account_name
        # The compliance evaluation result. Valid values:
        # 
        # *   COMPLIANT: The resource was evaluated as compliant.
        # *   NON_COMPLIANT: The resource was evaluated as incompliant.
        # *   NOT_APPLICABLE: The rule did not apply to your resource.
        # *   INSUFFICIENT_DATA: No resource data was available.
        self.compliance_type = compliance_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        return self


class GetAggregateAccountComplianceByPackResponseBodyAccountComplianceResult(TeaModel):
    def __init__(
        self,
        account_compliances: List[GetAggregateAccountComplianceByPackResponseBodyAccountComplianceResultAccountCompliances] = None,
        compliance_pack_id: str = None,
        non_compliant_count: int = None,
        total_count: int = None,
    ):
        # The compliance evaluation result of member accounts.
        self.account_compliances = account_compliances
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The number of non-compliant member accounts.
        self.non_compliant_count = non_compliant_count
        # The total number of member accounts.
        self.total_count = total_count

    def validate(self):
        if self.account_compliances:
            for k in self.account_compliances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccountCompliances'] = []
        if self.account_compliances is not None:
            for k in self.account_compliances:
                result['AccountCompliances'].append(k.to_map() if k else None)
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.non_compliant_count is not None:
            result['NonCompliantCount'] = self.non_compliant_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.account_compliances = []
        if m.get('AccountCompliances') is not None:
            for k in m.get('AccountCompliances'):
                temp_model = GetAggregateAccountComplianceByPackResponseBodyAccountComplianceResultAccountCompliances()
                self.account_compliances.append(temp_model.from_map(k))
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('NonCompliantCount') is not None:
            self.non_compliant_count = m.get('NonCompliantCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetAggregateAccountComplianceByPackResponseBody(TeaModel):
    def __init__(
        self,
        account_compliance_result: GetAggregateAccountComplianceByPackResponseBodyAccountComplianceResult = None,
        request_id: str = None,
    ):
        # The compliance evaluation results of member accounts for which the compliance package takes effect in an account group.
        self.account_compliance_result = account_compliance_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.account_compliance_result:
            self.account_compliance_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_compliance_result is not None:
            result['AccountComplianceResult'] = self.account_compliance_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountComplianceResult') is not None:
            temp_model = GetAggregateAccountComplianceByPackResponseBodyAccountComplianceResult()
            self.account_compliance_result = temp_model.from_map(m['AccountComplianceResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateAccountComplianceByPackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateAccountComplianceByPackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateAccountComplianceByPackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateAdvancedSearchFileRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        return self


class GetAggregateAdvancedSearchFileResponseBodyResourceSearch(TeaModel):
    def __init__(
        self,
        download_url: str = None,
        resource_inventory_generate_time: int = None,
        status: str = None,
    ):
        # The download URL of the resource file.
        self.download_url = download_url
        # The time when the resource file was generated. The value is a timestamp.
        # 
        # Unit: milliseconds.
        self.resource_inventory_generate_time = resource_inventory_generate_time
        # The generation status of the resource file. Valid values:
        # 
        # *   CREATING: The resource file is being generated.
        # *   COMPLETE: The resource file is generated.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.resource_inventory_generate_time is not None:
            result['ResourceInventoryGenerateTime'] = self.resource_inventory_generate_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('ResourceInventoryGenerateTime') is not None:
            self.resource_inventory_generate_time = m.get('ResourceInventoryGenerateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetAggregateAdvancedSearchFileResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_search: GetAggregateAdvancedSearchFileResponseBodyResourceSearch = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The information about the resource file.
        self.resource_search = resource_search

    def validate(self):
        if self.resource_search:
            self.resource_search.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_search is not None:
            result['ResourceSearch'] = self.resource_search.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceSearch') is not None:
            temp_model = GetAggregateAdvancedSearchFileResponseBodyResourceSearch()
            self.resource_search = temp_model.from_map(m['ResourceSearch'])
        return self


class GetAggregateAdvancedSearchFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateAdvancedSearchFileResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateAdvancedSearchFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateCompliancePackRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListAggregateCompliancePacks](https://help.aliyun.com/document_detail/262059.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        return self


class GetAggregateCompliancePackResponseBodyCompliancePackConfigRulesConfigRuleParameters(TeaModel):
    def __init__(
        self,
        parameter_name: str = None,
        parameter_value: str = None,
        required: bool = None,
    ):
        # The name of the input parameter.
        self.parameter_name = parameter_name
        # The value of the input parameter.
        self.parameter_value = parameter_value
        # Indicates whether the input parameter was required. Valid values:
        # 
        # *   true
        # *   false
        self.required = required

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_value is not None:
            result['ParameterValue'] = self.parameter_value
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterValue') is not None:
            self.parameter_value = m.get('ParameterValue')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class GetAggregateCompliancePackResponseBodyCompliancePackConfigRules(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        config_rule_name: str = None,
        config_rule_parameters: List[GetAggregateCompliancePackResponseBodyCompliancePackConfigRulesConfigRuleParameters] = None,
        description: str = None,
        managed_rule_identifier: str = None,
        resource_types_scope: str = None,
        risk_level: int = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The name of the rule.
        self.config_rule_name = config_rule_name
        # The details of the input parameter of the rule.
        self.config_rule_parameters = config_rule_parameters
        # The description of the rule.
        self.description = description
        # The ID of the rule template.
        self.managed_rule_identifier = managed_rule_identifier
        # The type of the resource evaluated based on the rule. Multiple resource types are separated with commas (,).
        self.resource_types_scope = resource_types_scope
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high
        # *   2: medium
        # *   3: low
        self.risk_level = risk_level

    def validate(self):
        if self.config_rule_parameters:
            for k in self.config_rule_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        result['ConfigRuleParameters'] = []
        if self.config_rule_parameters is not None:
            for k in self.config_rule_parameters:
                result['ConfigRuleParameters'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.managed_rule_identifier is not None:
            result['ManagedRuleIdentifier'] = self.managed_rule_identifier
        if self.resource_types_scope is not None:
            result['ResourceTypesScope'] = self.resource_types_scope
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        self.config_rule_parameters = []
        if m.get('ConfigRuleParameters') is not None:
            for k in m.get('ConfigRuleParameters'):
                temp_model = GetAggregateCompliancePackResponseBodyCompliancePackConfigRulesConfigRuleParameters()
                self.config_rule_parameters.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ManagedRuleIdentifier') is not None:
            self.managed_rule_identifier = m.get('ManagedRuleIdentifier')
        if m.get('ResourceTypesScope') is not None:
            self.resource_types_scope = m.get('ResourceTypesScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class GetAggregateCompliancePackResponseBodyCompliancePackScopeExcludeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The key of the tag.
        self.tag_key = tag_key
        # The value of the tag.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class GetAggregateCompliancePackResponseBodyCompliancePackScopeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The key of the tag.
        self.tag_key = tag_key
        # The value of the tag.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class GetAggregateCompliancePackResponseBodyCompliancePackScope(TeaModel):
    def __init__(
        self,
        exclude_region_ids_scope: str = None,
        exclude_resource_group_ids_scope: str = None,
        exclude_resource_ids_scope: str = None,
        exclude_tags_scope: List[GetAggregateCompliancePackResponseBodyCompliancePackScopeExcludeTagsScope] = None,
        region_ids_scope: str = None,
        resource_group_ids_scope: str = None,
        resource_ids_scope: str = None,
        tag_key_scope: str = None,
        tag_value_scope: str = None,
        tags_scope: List[GetAggregateCompliancePackResponseBodyCompliancePackScopeTagsScope] = None,
    ):
        # The IDs of regions that are excluded. Separate multiple region IDs with commas (,).
        self.exclude_region_ids_scope = exclude_region_ids_scope
        # The IDs of the resource groups whose resources you do not want to evaluate by using the compliance package. Separate multiple resource group IDs with commas (,).
        self.exclude_resource_group_ids_scope = exclude_resource_group_ids_scope
        # The ID of the resource that is not evaluated by using the compliance package.
        self.exclude_resource_ids_scope = exclude_resource_ids_scope
        # The scope of the tag that is excluded.
        self.exclude_tags_scope = exclude_tags_scope
        # The ID of the region whose resources were evaluated by using the compliance package.
        self.region_ids_scope = region_ids_scope
        # The ID of the resource group whose resources are evaluated by using the compliance package.
        self.resource_group_ids_scope = resource_group_ids_scope
        # The IDs of the resources to which the rule applies. Separate multiple resource IDs with commas (,).
        self.resource_ids_scope = resource_ids_scope
        # The tag key of the resource that is evaluated by using the compliance package.
        self.tag_key_scope = tag_key_scope
        # The tag value of the resource that is evaluated by using the compliance package.
        self.tag_value_scope = tag_value_scope
        # The tag scope.
        self.tags_scope = tags_scope

    def validate(self):
        if self.exclude_tags_scope:
            for k in self.exclude_tags_scope:
                if k:
                    k.validate()
        if self.tags_scope:
            for k in self.tags_scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_region_ids_scope is not None:
            result['ExcludeRegionIdsScope'] = self.exclude_region_ids_scope
        if self.exclude_resource_group_ids_scope is not None:
            result['ExcludeResourceGroupIdsScope'] = self.exclude_resource_group_ids_scope
        if self.exclude_resource_ids_scope is not None:
            result['ExcludeResourceIdsScope'] = self.exclude_resource_ids_scope
        result['ExcludeTagsScope'] = []
        if self.exclude_tags_scope is not None:
            for k in self.exclude_tags_scope:
                result['ExcludeTagsScope'].append(k.to_map() if k else None)
        if self.region_ids_scope is not None:
            result['RegionIdsScope'] = self.region_ids_scope
        if self.resource_group_ids_scope is not None:
            result['ResourceGroupIdsScope'] = self.resource_group_ids_scope
        if self.resource_ids_scope is not None:
            result['ResourceIdsScope'] = self.resource_ids_scope
        if self.tag_key_scope is not None:
            result['TagKeyScope'] = self.tag_key_scope
        if self.tag_value_scope is not None:
            result['TagValueScope'] = self.tag_value_scope
        result['TagsScope'] = []
        if self.tags_scope is not None:
            for k in self.tags_scope:
                result['TagsScope'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeRegionIdsScope') is not None:
            self.exclude_region_ids_scope = m.get('ExcludeRegionIdsScope')
        if m.get('ExcludeResourceGroupIdsScope') is not None:
            self.exclude_resource_group_ids_scope = m.get('ExcludeResourceGroupIdsScope')
        if m.get('ExcludeResourceIdsScope') is not None:
            self.exclude_resource_ids_scope = m.get('ExcludeResourceIdsScope')
        self.exclude_tags_scope = []
        if m.get('ExcludeTagsScope') is not None:
            for k in m.get('ExcludeTagsScope'):
                temp_model = GetAggregateCompliancePackResponseBodyCompliancePackScopeExcludeTagsScope()
                self.exclude_tags_scope.append(temp_model.from_map(k))
        if m.get('RegionIdsScope') is not None:
            self.region_ids_scope = m.get('RegionIdsScope')
        if m.get('ResourceGroupIdsScope') is not None:
            self.resource_group_ids_scope = m.get('ResourceGroupIdsScope')
        if m.get('ResourceIdsScope') is not None:
            self.resource_ids_scope = m.get('ResourceIdsScope')
        if m.get('TagKeyScope') is not None:
            self.tag_key_scope = m.get('TagKeyScope')
        if m.get('TagValueScope') is not None:
            self.tag_value_scope = m.get('TagValueScope')
        self.tags_scope = []
        if m.get('TagsScope') is not None:
            for k in m.get('TagsScope'):
                temp_model = GetAggregateCompliancePackResponseBodyCompliancePackScopeTagsScope()
                self.tags_scope.append(temp_model.from_map(k))
        return self


class GetAggregateCompliancePackResponseBodyCompliancePack(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
        compliance_pack_name: str = None,
        compliance_pack_template_id: str = None,
        config_rules: List[GetAggregateCompliancePackResponseBodyCompliancePackConfigRules] = None,
        create_timestamp: int = None,
        description: str = None,
        risk_level: int = None,
        scope: GetAggregateCompliancePackResponseBodyCompliancePackScope = None,
        status: str = None,
        template_content: str = None,
    ):
        # The ID of the management account to which the compliance package belongs.
        self.account_id = account_id
        # The ID of the account group.
        self.aggregator_id = aggregator_id
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The name of the compliance package.
        self.compliance_pack_name = compliance_pack_name
        # The ID of the compliance package template.
        self.compliance_pack_template_id = compliance_pack_template_id
        # The rules in the compliance package.
        self.config_rules = config_rules
        # The timestamp when the compliance package was created. Unit: milliseconds.
        self.create_timestamp = create_timestamp
        # The description of the compliance package.
        self.description = description
        # The risk level of the resources that are not compliant with the rules in the compliance package. Valid values:
        # 
        # *   1: high
        # *   2: medium
        # *   3: low
        self.risk_level = risk_level
        # The evaluation scope of the compliance package.
        self.scope = scope
        # The status of the compliance package. Valid values:
        # 
        # *   ACTIVE: The compliance package was normal.
        # *   CREATING: The compliance package was being created.
        self.status = status
        # The information about the current compliance package template. The rules in the template do not contain custom function rules. You can quickly create the same compliance package for other accounts or account groups based on the template information.
        self.template_content = template_content

    def validate(self):
        if self.config_rules:
            for k in self.config_rules:
                if k:
                    k.validate()
        if self.scope:
            self.scope.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.compliance_pack_name is not None:
            result['CompliancePackName'] = self.compliance_pack_name
        if self.compliance_pack_template_id is not None:
            result['CompliancePackTemplateId'] = self.compliance_pack_template_id
        result['ConfigRules'] = []
        if self.config_rules is not None:
            for k in self.config_rules:
                result['ConfigRules'].append(k.to_map() if k else None)
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.description is not None:
            result['Description'] = self.description
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.scope is not None:
            result['Scope'] = self.scope.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.template_content is not None:
            result['TemplateContent'] = self.template_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('CompliancePackName') is not None:
            self.compliance_pack_name = m.get('CompliancePackName')
        if m.get('CompliancePackTemplateId') is not None:
            self.compliance_pack_template_id = m.get('CompliancePackTemplateId')
        self.config_rules = []
        if m.get('ConfigRules') is not None:
            for k in m.get('ConfigRules'):
                temp_model = GetAggregateCompliancePackResponseBodyCompliancePackConfigRules()
                self.config_rules.append(temp_model.from_map(k))
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('Scope') is not None:
            temp_model = GetAggregateCompliancePackResponseBodyCompliancePackScope()
            self.scope = temp_model.from_map(m['Scope'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateContent') is not None:
            self.template_content = m.get('TemplateContent')
        return self


class GetAggregateCompliancePackResponseBody(TeaModel):
    def __init__(
        self,
        compliance_pack: GetAggregateCompliancePackResponseBodyCompliancePack = None,
        request_id: str = None,
    ):
        # The details of the compliance package.
        self.compliance_pack = compliance_pack
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.compliance_pack:
            self.compliance_pack.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack is not None:
            result['CompliancePack'] = self.compliance_pack.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePack') is not None:
            temp_model = GetAggregateCompliancePackResponseBodyCompliancePack()
            self.compliance_pack = temp_model.from_map(m['CompliancePack'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateCompliancePackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateCompliancePackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateCompliancePackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateCompliancePackReportRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListAggregateCompliancePacks](https://help.aliyun.com/document_detail/262059.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        return self


class GetAggregateCompliancePackReportResponseBodyCompliancePackReport(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        compliance_pack_id: str = None,
        report_create_timestamp: int = None,
        report_status: str = None,
        report_url: str = None,
    ):
        # The ID of the management account to which the compliance package belongs.
        self.account_id = account_id
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The timestamp when the compliance evaluation report was generated. Unit: milliseconds.
        self.report_create_timestamp = report_create_timestamp
        # The status of the compliance evaluation report. Valid values:
        # 
        # *   NONE: The compliance evaluation report is not generated.
        # *   CREATING: The compliance evaluation report is being generated.
        # *   COMPLETE: The compliance evaluation report is generated.
        self.report_status = report_status
        # The URL that is used to download the compliance evaluation report.
        self.report_url = report_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.report_create_timestamp is not None:
            result['ReportCreateTimestamp'] = self.report_create_timestamp
        if self.report_status is not None:
            result['ReportStatus'] = self.report_status
        if self.report_url is not None:
            result['ReportUrl'] = self.report_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ReportCreateTimestamp') is not None:
            self.report_create_timestamp = m.get('ReportCreateTimestamp')
        if m.get('ReportStatus') is not None:
            self.report_status = m.get('ReportStatus')
        if m.get('ReportUrl') is not None:
            self.report_url = m.get('ReportUrl')
        return self


class GetAggregateCompliancePackReportResponseBody(TeaModel):
    def __init__(
        self,
        compliance_pack_report: GetAggregateCompliancePackReportResponseBodyCompliancePackReport = None,
        request_id: str = None,
    ):
        # The compliance evaluation report that is generated based on a compliance package.
        self.compliance_pack_report = compliance_pack_report
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.compliance_pack_report:
            self.compliance_pack_report.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_report is not None:
            result['CompliancePackReport'] = self.compliance_pack_report.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackReport') is not None:
            temp_model = GetAggregateCompliancePackReportResponseBodyCompliancePackReport()
            self.compliance_pack_report = temp_model.from_map(m['CompliancePackReport'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateCompliancePackReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateCompliancePackReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateCompliancePackReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateComplianceSummaryRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
    ):
        # The ID of the account group.
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        return self


class GetAggregateComplianceSummaryResponseBodyComplianceSummaryComplianceSummaryByConfigRule(TeaModel):
    def __init__(
        self,
        compliance_summary_timestamp: int = None,
        compliant_count: int = None,
        non_compliant_count: int = None,
        total_count: int = None,
    ):
        # The time when the compliance statistics were collected. Unit: milliseconds.
        self.compliance_summary_timestamp = compliance_summary_timestamp
        # The number of compliant rules.
        self.compliant_count = compliant_count
        # The number of non-compliant rules.
        self.non_compliant_count = non_compliant_count
        # The total number of rules.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_summary_timestamp is not None:
            result['ComplianceSummaryTimestamp'] = self.compliance_summary_timestamp
        if self.compliant_count is not None:
            result['CompliantCount'] = self.compliant_count
        if self.non_compliant_count is not None:
            result['NonCompliantCount'] = self.non_compliant_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceSummaryTimestamp') is not None:
            self.compliance_summary_timestamp = m.get('ComplianceSummaryTimestamp')
        if m.get('CompliantCount') is not None:
            self.compliant_count = m.get('CompliantCount')
        if m.get('NonCompliantCount') is not None:
            self.non_compliant_count = m.get('NonCompliantCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetAggregateComplianceSummaryResponseBodyComplianceSummaryComplianceSummaryByResource(TeaModel):
    def __init__(
        self,
        compliance_summary_timestamp: int = None,
        compliant_count: int = None,
        non_compliant_count: int = None,
        total_count: int = None,
    ):
        # The time when the compliance statistics were collected. Unit: milliseconds.
        self.compliance_summary_timestamp = compliance_summary_timestamp
        # The number of compliant resources.
        self.compliant_count = compliant_count
        # The number of non-compliant resources.
        self.non_compliant_count = non_compliant_count
        # The total number of resources.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_summary_timestamp is not None:
            result['ComplianceSummaryTimestamp'] = self.compliance_summary_timestamp
        if self.compliant_count is not None:
            result['CompliantCount'] = self.compliant_count
        if self.non_compliant_count is not None:
            result['NonCompliantCount'] = self.non_compliant_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceSummaryTimestamp') is not None:
            self.compliance_summary_timestamp = m.get('ComplianceSummaryTimestamp')
        if m.get('CompliantCount') is not None:
            self.compliant_count = m.get('CompliantCount')
        if m.get('NonCompliantCount') is not None:
            self.non_compliant_count = m.get('NonCompliantCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetAggregateComplianceSummaryResponseBodyComplianceSummary(TeaModel):
    def __init__(
        self,
        compliance_summary_by_config_rule: GetAggregateComplianceSummaryResponseBodyComplianceSummaryComplianceSummaryByConfigRule = None,
        compliance_summary_by_resource: GetAggregateComplianceSummaryResponseBodyComplianceSummaryComplianceSummaryByResource = None,
    ):
        # The summary of compliance statistics from the rule dimension.
        self.compliance_summary_by_config_rule = compliance_summary_by_config_rule
        # The summary of compliance statistics from the resource dimension.
        self.compliance_summary_by_resource = compliance_summary_by_resource

    def validate(self):
        if self.compliance_summary_by_config_rule:
            self.compliance_summary_by_config_rule.validate()
        if self.compliance_summary_by_resource:
            self.compliance_summary_by_resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_summary_by_config_rule is not None:
            result['ComplianceSummaryByConfigRule'] = self.compliance_summary_by_config_rule.to_map()
        if self.compliance_summary_by_resource is not None:
            result['ComplianceSummaryByResource'] = self.compliance_summary_by_resource.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceSummaryByConfigRule') is not None:
            temp_model = GetAggregateComplianceSummaryResponseBodyComplianceSummaryComplianceSummaryByConfigRule()
            self.compliance_summary_by_config_rule = temp_model.from_map(m['ComplianceSummaryByConfigRule'])
        if m.get('ComplianceSummaryByResource') is not None:
            temp_model = GetAggregateComplianceSummaryResponseBodyComplianceSummaryComplianceSummaryByResource()
            self.compliance_summary_by_resource = temp_model.from_map(m['ComplianceSummaryByResource'])
        return self


class GetAggregateComplianceSummaryResponseBody(TeaModel):
    def __init__(
        self,
        compliance_summary: GetAggregateComplianceSummaryResponseBodyComplianceSummary = None,
        request_id: str = None,
    ):
        # The compliance statistics.
        self.compliance_summary = compliance_summary
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.compliance_summary:
            self.compliance_summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_summary is not None:
            result['ComplianceSummary'] = self.compliance_summary.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceSummary') is not None:
            temp_model = GetAggregateComplianceSummaryResponseBodyComplianceSummary()
            self.compliance_summary = temp_model.from_map(m['ComplianceSummary'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateComplianceSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateComplianceSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateComplianceSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateConfigDeliveryChannelRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        delivery_channel_id: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the delivery channel.
        # 
        # For more information about how to obtain the ID of a delivery channel, see [ListAggregateConfigDeliveryChannels](https://help.aliyun.com/document_detail/429842.html).
        # 
        # This parameter is required.
        self.delivery_channel_id = delivery_channel_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.delivery_channel_id is not None:
            result['DeliveryChannelId'] = self.delivery_channel_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('DeliveryChannelId') is not None:
            self.delivery_channel_id = m.get('DeliveryChannelId')
        return self


class GetAggregateConfigDeliveryChannelResponseBodyDeliveryChannel(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        aggregator_id: str = None,
        compliant_snapshot: bool = None,
        configuration_item_change_notification: bool = None,
        configuration_snapshot: bool = None,
        delivery_channel_assume_role_arn: str = None,
        delivery_channel_condition: str = None,
        delivery_channel_id: str = None,
        delivery_channel_name: str = None,
        delivery_channel_target_arn: str = None,
        delivery_channel_type: str = None,
        delivery_snapshot_time: str = None,
        description: str = None,
        non_compliant_notification: bool = None,
        oversized_data_osstarget_arn: str = None,
        status: int = None,
    ):
        # The ID of the member in the account group.
        self.account_id = account_id
        # The ID of the account group.
        self.aggregator_id = aggregator_id
        # Indicates whether the specified destination receives scheduled compliant snapshots. Cloud Config delivers scheduled compliant snapshots at `04:00Z` and `16:00Z` to Log Service every day. The time is displayed in UTC. Valid values:
        # 
        # *   true: The specified destination receives scheduled compliant snapshots.
        # *   false: The specified destination does not receive scheduled compliant snapshots.
        self.compliant_snapshot = compliant_snapshot
        # Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:
        # 
        # *   true: The specified destination receives resource change logs.
        # *   false: The specified destination does not receive resource change logs.
        self.configuration_item_change_notification = configuration_item_change_notification
        # Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at `04:00Z` and `16:00Z` to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:
        # 
        # *   true: The specified destination receives scheduled resource snapshots.
        # *   false: The specified destination does not receive scheduled resource snapshots.
        self.configuration_snapshot = configuration_snapshot
        # The ARN of the role that is assigned to the delivery channel.
        self.delivery_channel_assume_role_arn = delivery_channel_assume_role_arn
        # The rule that is attached to the delivery channel. This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
        # 
        # *   If the value of the DeliveryChannelType parameter is MNS, take note of the following settings of the lowest risk level and resource types of the events to which you subscribed:
        # 
        #     *   The lowest risk level of the events to which you want to subscribe is in the following format: `{"filterType":"RuleRiskLevel","value":"1","multiple":false}`.
        # 
        #         The `value` field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
        # 
        #     *   The setting of the resource types of the events to which you want to subscribe is in the following format: `{"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}`.
        # 
        #         The `values` field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array. Examples:
        # 
        # `[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}]`
        # 
        # *   If you set the DeliveryChannelType parameter to SLS, the setting of the resource types of the snapshots to which you want to deliver is in the following format: `{"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}`.
        # 
        #     The `values` field specifies the resource types of the snapshots to which you want to deliver. The value of the field is a JSON array. Examples:
        # 
        # `[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}]`
        self.delivery_channel_condition = delivery_channel_condition
        # The ID of the delivery channel.
        self.delivery_channel_id = delivery_channel_id
        # The name of the delivery channel.
        self.delivery_channel_name = delivery_channel_name
        # The ARN of the delivery destination.
        # 
        # *   If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
        # *   If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
        # *   If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        self.delivery_channel_target_arn = delivery_channel_target_arn
        # The type of the delivery channel. Valid values:
        # 
        # *   OSS: Object Storage Service (OSS)
        # *   MNS: Message Service (MNS)
        # *   SLS: Log Service
        self.delivery_channel_type = delivery_channel_type
        # The time when Cloud Config delivers scheduled resources snapshots every day.
        # 
        # Format: `HH:mmZ`. This time is displayed in UTC.
        self.delivery_snapshot_time = delivery_snapshot_time
        # The description of the delivery channel.
        self.description = description
        # Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:
        # 
        # *   true: The specified destination receives resource non-compliance events.
        # *   false: The specified destination does not receive resource non-compliance events.
        self.non_compliant_notification = non_compliant_notification
        # The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
        self.oversized_data_osstarget_arn = oversized_data_osstarget_arn
        # The status of the delivery channel. Valid values:
        # 
        # *   0: The delivery channel is disabled.
        # *   1: The delivery channel is enabled.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliant_snapshot is not None:
            result['CompliantSnapshot'] = self.compliant_snapshot
        if self.configuration_item_change_notification is not None:
            result['ConfigurationItemChangeNotification'] = self.configuration_item_change_notification
        if self.configuration_snapshot is not None:
            result['ConfigurationSnapshot'] = self.configuration_snapshot
        if self.delivery_channel_assume_role_arn is not None:
            result['DeliveryChannelAssumeRoleArn'] = self.delivery_channel_assume_role_arn
        if self.delivery_channel_condition is not None:
            result['DeliveryChannelCondition'] = self.delivery_channel_condition
        if self.delivery_channel_id is not None:
            result['DeliveryChannelId'] = self.delivery_channel_id
        if self.delivery_channel_name is not None:
            result['DeliveryChannelName'] = self.delivery_channel_name
        if self.delivery_channel_target_arn is not None:
            result['DeliveryChannelTargetArn'] = self.delivery_channel_target_arn
        if self.delivery_channel_type is not None:
            result['DeliveryChannelType'] = self.delivery_channel_type
        if self.delivery_snapshot_time is not None:
            result['DeliverySnapshotTime'] = self.delivery_snapshot_time
        if self.description is not None:
            result['Description'] = self.description
        if self.non_compliant_notification is not None:
            result['NonCompliantNotification'] = self.non_compliant_notification
        if self.oversized_data_osstarget_arn is not None:
            result['OversizedDataOSSTargetArn'] = self.oversized_data_osstarget_arn
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliantSnapshot') is not None:
            self.compliant_snapshot = m.get('CompliantSnapshot')
        if m.get('ConfigurationItemChangeNotification') is not None:
            self.configuration_item_change_notification = m.get('ConfigurationItemChangeNotification')
        if m.get('ConfigurationSnapshot') is not None:
            self.configuration_snapshot = m.get('ConfigurationSnapshot')
        if m.get('DeliveryChannelAssumeRoleArn') is not None:
            self.delivery_channel_assume_role_arn = m.get('DeliveryChannelAssumeRoleArn')
        if m.get('DeliveryChannelCondition') is not None:
            self.delivery_channel_condition = m.get('DeliveryChannelCondition')
        if m.get('DeliveryChannelId') is not None:
            self.delivery_channel_id = m.get('DeliveryChannelId')
        if m.get('DeliveryChannelName') is not None:
            self.delivery_channel_name = m.get('DeliveryChannelName')
        if m.get('DeliveryChannelTargetArn') is not None:
            self.delivery_channel_target_arn = m.get('DeliveryChannelTargetArn')
        if m.get('DeliveryChannelType') is not None:
            self.delivery_channel_type = m.get('DeliveryChannelType')
        if m.get('DeliverySnapshotTime') is not None:
            self.delivery_snapshot_time = m.get('DeliverySnapshotTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NonCompliantNotification') is not None:
            self.non_compliant_notification = m.get('NonCompliantNotification')
        if m.get('OversizedDataOSSTargetArn') is not None:
            self.oversized_data_osstarget_arn = m.get('OversizedDataOSSTargetArn')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetAggregateConfigDeliveryChannelResponseBody(TeaModel):
    def __init__(
        self,
        delivery_channel: GetAggregateConfigDeliveryChannelResponseBodyDeliveryChannel = None,
        request_id: str = None,
    ):
        # The information about a delivery channel.
        self.delivery_channel = delivery_channel
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.delivery_channel:
            self.delivery_channel.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_channel is not None:
            result['DeliveryChannel'] = self.delivery_channel.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryChannel') is not None:
            temp_model = GetAggregateConfigDeliveryChannelResponseBodyDeliveryChannel()
            self.delivery_channel = temp_model.from_map(m['DeliveryChannel'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateConfigDeliveryChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateConfigDeliveryChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateConfigDeliveryChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateConfigRuleRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetAggregateConfigRuleRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        config_rule_id: str = None,
        tag: List[GetAggregateConfigRuleRequestTag] = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the rule.
        # 
        # You can call the [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html) operation to obtain the rule ID.
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = GetAggregateConfigRuleRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class GetAggregateConfigRuleShrinkRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        config_rule_id: str = None,
        tag_shrink: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the rule.
        # 
        # You can call the [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html) operation to obtain the rule ID.
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id
        self.tag_shrink = tag_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.tag_shrink is not None:
            result['Tag'] = self.tag_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('Tag') is not None:
            self.tag_shrink = m.get('Tag')
        return self


class GetAggregateConfigRuleResponseBodyConfigRuleCompliance(TeaModel):
    def __init__(
        self,
        compliance_type: str = None,
        count: int = None,
    ):
        # The statistics on the compliance evaluation results by compliance type. Valid values:
        # 
        # *   COMPLIANT: The resources are evaluated as compliant.
        # *   NON_COMPLIANT: The resources are evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to your resources.
        # *   INSUFFICIENT_DATA: No resource data is available.
        self.compliance_type = compliance_type
        # The number of evaluated resources.
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetAggregateConfigRuleResponseBodyConfigRuleConfigRuleEvaluationStatus(TeaModel):
    def __init__(
        self,
        first_activated_timestamp: int = None,
        first_evaluation_started: bool = None,
        last_error_code: str = None,
        last_error_message: str = None,
        last_failed_evaluation_timestamp: int = None,
        last_failed_invocation_timestamp: int = None,
        last_successful_evaluation_timestamp: int = None,
        last_successful_invocation_timestamp: int = None,
    ):
        # The timestamp when the rule was first triggered.
        self.first_activated_timestamp = first_activated_timestamp
        # Indicates whether resources were evaluated based on the rule. Valid values:
        # 
        # *   true: Resources were evaluated based on the rule.
        # *   false: Resources were not evaluated based on the rule.
        self.first_evaluation_started = first_evaluation_started
        # The error code returned for the last failed compliance evaluation.
        self.last_error_code = last_error_code
        # The error message returned for the last failed compliance evaluation.
        self.last_error_message = last_error_message
        # The timestamp when the last failed compliance evaluation of the rule ended. Unit: milliseconds.
        self.last_failed_evaluation_timestamp = last_failed_evaluation_timestamp
        # The timestamp when the last failed compliance evaluation of the rule started. Unit: milliseconds.
        self.last_failed_invocation_timestamp = last_failed_invocation_timestamp
        # The timestamp when the last successful compliance evaluation of the rule ended. Unit: milliseconds.
        self.last_successful_evaluation_timestamp = last_successful_evaluation_timestamp
        # The timestamp when the last successful compliance evaluation of the rule started. Unit: milliseconds.
        self.last_successful_invocation_timestamp = last_successful_invocation_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.first_activated_timestamp is not None:
            result['FirstActivatedTimestamp'] = self.first_activated_timestamp
        if self.first_evaluation_started is not None:
            result['FirstEvaluationStarted'] = self.first_evaluation_started
        if self.last_error_code is not None:
            result['LastErrorCode'] = self.last_error_code
        if self.last_error_message is not None:
            result['LastErrorMessage'] = self.last_error_message
        if self.last_failed_evaluation_timestamp is not None:
            result['LastFailedEvaluationTimestamp'] = self.last_failed_evaluation_timestamp
        if self.last_failed_invocation_timestamp is not None:
            result['LastFailedInvocationTimestamp'] = self.last_failed_invocation_timestamp
        if self.last_successful_evaluation_timestamp is not None:
            result['LastSuccessfulEvaluationTimestamp'] = self.last_successful_evaluation_timestamp
        if self.last_successful_invocation_timestamp is not None:
            result['LastSuccessfulInvocationTimestamp'] = self.last_successful_invocation_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirstActivatedTimestamp') is not None:
            self.first_activated_timestamp = m.get('FirstActivatedTimestamp')
        if m.get('FirstEvaluationStarted') is not None:
            self.first_evaluation_started = m.get('FirstEvaluationStarted')
        if m.get('LastErrorCode') is not None:
            self.last_error_code = m.get('LastErrorCode')
        if m.get('LastErrorMessage') is not None:
            self.last_error_message = m.get('LastErrorMessage')
        if m.get('LastFailedEvaluationTimestamp') is not None:
            self.last_failed_evaluation_timestamp = m.get('LastFailedEvaluationTimestamp')
        if m.get('LastFailedInvocationTimestamp') is not None:
            self.last_failed_invocation_timestamp = m.get('LastFailedInvocationTimestamp')
        if m.get('LastSuccessfulEvaluationTimestamp') is not None:
            self.last_successful_evaluation_timestamp = m.get('LastSuccessfulEvaluationTimestamp')
        if m.get('LastSuccessfulInvocationTimestamp') is not None:
            self.last_successful_invocation_timestamp = m.get('LastSuccessfulInvocationTimestamp')
        return self


class GetAggregateConfigRuleResponseBodyConfigRuleCreateBy(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        aggregator_name: str = None,
        compliance_pack_id: str = None,
        compliance_pack_name: str = None,
        creator_id: str = None,
        creator_name: str = None,
        creator_type: str = None,
    ):
        # The ID of the account group.
        self.aggregator_id = aggregator_id
        # The name of the account group.
        self.aggregator_name = aggregator_name
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The name of the compliance package.
        self.compliance_pack_name = compliance_pack_name
        # The ID of the account that was used to create the rule.
        self.creator_id = creator_id
        # The name of the account that was used to create the rule.
        self.creator_name = creator_name
        # The type of the entity to which the rule belongs. The value is fixed to `AGGREGATOR`, which indicates an account group.
        self.creator_type = creator_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.aggregator_name is not None:
            result['AggregatorName'] = self.aggregator_name
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.compliance_pack_name is not None:
            result['CompliancePackName'] = self.compliance_pack_name
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        if self.creator_type is not None:
            result['CreatorType'] = self.creator_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('AggregatorName') is not None:
            self.aggregator_name = m.get('AggregatorName')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('CompliancePackName') is not None:
            self.compliance_pack_name = m.get('CompliancePackName')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        if m.get('CreatorType') is not None:
            self.creator_type = m.get('CreatorType')
        return self


class GetAggregateConfigRuleResponseBodyConfigRuleExcludeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The key of the tag.
        self.tag_key = tag_key
        # The value of the tag.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class GetAggregateConfigRuleResponseBodyConfigRuleManagedRuleSourceDetails(TeaModel):
    def __init__(
        self,
        event_source: str = None,
        maximum_execution_frequency: str = None,
        message_type: str = None,
    ):
        # The event source of the managed rule.
        # 
        # >  Only events related to Cloud Config are supported. The value is fixed to aliyun.config.
        self.event_source = event_source
        # The intervals at which the managed rule is triggered. Valid values:
        # 
        # *   One_Hour: 1 hour.
        # *   Three_Hours: 3 hours.
        # *   Six_Hours: 6 hours.
        # *   Twelve_Hours: 12 hours
        # *   TwentyFour_Hours: 24 hours
        self.maximum_execution_frequency = maximum_execution_frequency
        # The trigger type of the rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The managed rule is triggered by configuration changes.
        # *   ScheduledNotification: The managed rule is periodically triggered.
        self.message_type = message_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_source is not None:
            result['EventSource'] = self.event_source
        if self.maximum_execution_frequency is not None:
            result['MaximumExecutionFrequency'] = self.maximum_execution_frequency
        if self.message_type is not None:
            result['MessageType'] = self.message_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventSource') is not None:
            self.event_source = m.get('EventSource')
        if m.get('MaximumExecutionFrequency') is not None:
            self.maximum_execution_frequency = m.get('MaximumExecutionFrequency')
        if m.get('MessageType') is not None:
            self.message_type = m.get('MessageType')
        return self


class GetAggregateConfigRuleResponseBodyConfigRuleManagedRule(TeaModel):
    def __init__(
        self,
        compulsory_input_parameter_details: Dict[str, Any] = None,
        description: str = None,
        identifier: str = None,
        labels: List[str] = None,
        managed_rule_name: str = None,
        optional_input_parameter_details: Dict[str, Any] = None,
        source_details: List[GetAggregateConfigRuleResponseBodyConfigRuleManagedRuleSourceDetails] = None,
    ):
        # The required input parameters of the managed rule.
        self.compulsory_input_parameter_details = compulsory_input_parameter_details
        # The description of the managed rule.
        self.description = description
        # The identifier of the managed rule.
        self.identifier = identifier
        # The tags of the managed rule.
        self.labels = labels
        # The name of the managed rule.
        self.managed_rule_name = managed_rule_name
        # The optional input parameters of the managed rule.
        self.optional_input_parameter_details = optional_input_parameter_details
        # The details of the source of the managed rule.
        self.source_details = source_details

    def validate(self):
        if self.source_details:
            for k in self.source_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compulsory_input_parameter_details is not None:
            result['CompulsoryInputParameterDetails'] = self.compulsory_input_parameter_details
        if self.description is not None:
            result['Description'] = self.description
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.managed_rule_name is not None:
            result['ManagedRuleName'] = self.managed_rule_name
        if self.optional_input_parameter_details is not None:
            result['OptionalInputParameterDetails'] = self.optional_input_parameter_details
        result['SourceDetails'] = []
        if self.source_details is not None:
            for k in self.source_details:
                result['SourceDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompulsoryInputParameterDetails') is not None:
            self.compulsory_input_parameter_details = m.get('CompulsoryInputParameterDetails')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('ManagedRuleName') is not None:
            self.managed_rule_name = m.get('ManagedRuleName')
        if m.get('OptionalInputParameterDetails') is not None:
            self.optional_input_parameter_details = m.get('OptionalInputParameterDetails')
        self.source_details = []
        if m.get('SourceDetails') is not None:
            for k in m.get('SourceDetails'):
                temp_model = GetAggregateConfigRuleResponseBodyConfigRuleManagedRuleSourceDetails()
                self.source_details.append(temp_model.from_map(k))
        return self


class GetAggregateConfigRuleResponseBodyConfigRuleSourceSourceDetails(TeaModel):
    def __init__(
        self,
        event_source: str = None,
        maximum_execution_frequency: str = None,
        message_type: str = None,
    ):
        # The event source of the managed rule.
        # 
        # >  Only events related to Cloud Config are supported. The value is fixed to aliyun.config.
        self.event_source = event_source
        # The intervals at which the managed rule is triggered. Valid values:
        # 
        # *   One_Hour: 1 hour.
        # *   Three_Hours: 3 hours.
        # *   Six_Hours: 6 hours.
        # *   Twelve_Hours: 12 hours
        # *   TwentyFour_Hours: 24 hours
        self.maximum_execution_frequency = maximum_execution_frequency
        # The trigger type of the rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The managed rule is triggered by configuration changes.
        # *   ScheduledNotification: The managed rule is periodically triggered.
        self.message_type = message_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_source is not None:
            result['EventSource'] = self.event_source
        if self.maximum_execution_frequency is not None:
            result['MaximumExecutionFrequency'] = self.maximum_execution_frequency
        if self.message_type is not None:
            result['MessageType'] = self.message_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventSource') is not None:
            self.event_source = m.get('EventSource')
        if m.get('MaximumExecutionFrequency') is not None:
            self.maximum_execution_frequency = m.get('MaximumExecutionFrequency')
        if m.get('MessageType') is not None:
            self.message_type = m.get('MessageType')
        return self


class GetAggregateConfigRuleResponseBodyConfigRuleSource(TeaModel):
    def __init__(
        self,
        identifier: str = None,
        owner: str = None,
        source_details: List[GetAggregateConfigRuleResponseBodyConfigRuleSourceSourceDetails] = None,
    ):
        # The identifier of the rule.
        # 
        # *   If the rule was created based on a managed rule, the value of this parameter is the name of the managed rule.
        # *   If the rule is a custom rule, the value of this parameter is the Alibaba Cloud Resource Name (ARN) of the relevant function in Function Compute.
        self.identifier = identifier
        # The way in which the rule was created. Valid values:
        # 
        # *   CUSTOM_FC: The rule is a custom rule.
        # *   ALIYUN: The rule was created based on a managed rule of Alibaba Cloud.
        self.owner = owner
        # The details of the source of the rule.
        self.source_details = source_details

    def validate(self):
        if self.source_details:
            for k in self.source_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.owner is not None:
            result['Owner'] = self.owner
        result['SourceDetails'] = []
        if self.source_details is not None:
            for k in self.source_details:
                result['SourceDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        self.source_details = []
        if m.get('SourceDetails') is not None:
            for k in m.get('SourceDetails'):
                temp_model = GetAggregateConfigRuleResponseBodyConfigRuleSourceSourceDetails()
                self.source_details.append(temp_model.from_map(k))
        return self


class GetAggregateConfigRuleResponseBodyConfigRuleTags(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class GetAggregateConfigRuleResponseBodyConfigRuleTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The key of the tag.
        self.tag_key = tag_key
        # The value of the tag.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class GetAggregateConfigRuleResponseBodyConfigRule(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        account_ids_scope: str = None,
        compliance: GetAggregateConfigRuleResponseBodyConfigRuleCompliance = None,
        config_rule_arn: str = None,
        config_rule_evaluation_status: GetAggregateConfigRuleResponseBodyConfigRuleConfigRuleEvaluationStatus = None,
        config_rule_id: str = None,
        config_rule_name: str = None,
        config_rule_state: str = None,
        config_rule_trigger_types: str = None,
        create_by: GetAggregateConfigRuleResponseBodyConfigRuleCreateBy = None,
        create_timestamp: int = None,
        description: str = None,
        exclude_account_ids_scope: str = None,
        exclude_folder_ids_scope: str = None,
        exclude_region_ids_scope: str = None,
        exclude_resource_group_ids_scope: str = None,
        exclude_resource_ids_scope: str = None,
        exclude_tags_scope: List[GetAggregateConfigRuleResponseBodyConfigRuleExcludeTagsScope] = None,
        extend_content: str = None,
        folder_ids_scope: str = None,
        input_parameters: Dict[str, Any] = None,
        managed_rule: GetAggregateConfigRuleResponseBodyConfigRuleManagedRule = None,
        maximum_execution_frequency: str = None,
        modified_timestamp: int = None,
        region_ids_scope: str = None,
        resource_group_ids_scope: str = None,
        resource_ids_scope: str = None,
        resource_types_scope: str = None,
        risk_level: int = None,
        source: GetAggregateConfigRuleResponseBodyConfigRuleSource = None,
        tag_key_logic_scope: str = None,
        tag_key_scope: str = None,
        tag_value_scope: str = None,
        tags: List[GetAggregateConfigRuleResponseBodyConfigRuleTags] = None,
        tags_scope: List[GetAggregateConfigRuleResponseBodyConfigRuleTagsScope] = None,
    ):
        # The ID of the Alibaba Cloud account to which the rule belongs.
        self.account_id = account_id
        # The IDs of the members to which the rule applies. Separate multiple member IDs with commas (,).
        self.account_ids_scope = account_ids_scope
        # The details of compliance evaluation results.
        self.compliance = compliance
        # The ARN of the managed rule.
        self.config_rule_arn = config_rule_arn
        # The information about compliance evaluations performed by the rule.
        self.config_rule_evaluation_status = config_rule_evaluation_status
        # The ID of the rule.
        self.config_rule_id = config_rule_id
        # The name of the monitoring rule.
        self.config_rule_name = config_rule_name
        # The status of the rule. Valid values:
        # 
        # *   ACTIVE: The rule is being used to monitor resource configurations.
        # *   DELETING: The rule is being deleted.
        # *   EVALUATING: The rule is triggered and is being used to monitor resource configurations.
        # *   INACTIVE: The rule is disabled and is no longer used to monitor resource configurations.
        self.config_rule_state = config_rule_state
        # The trigger type of the rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The managed rule is triggered by configuration changes.
        # *   ScheduledNotification: The managed rule is periodically triggered.
        self.config_rule_trigger_types = config_rule_trigger_types
        # The information about the creation of the rule.
        self.create_by = create_by
        # The timestamp when the rule was created. Unit: milliseconds.
        self.create_timestamp = create_timestamp
        # The description of the managed rule.
        self.description = description
        # The ID of the member account to which the rule does not apply, which means that the resources within the member account are not evaluated based on the rule.
        # 
        # >  This parameter applies only to a managed rule.
        self.exclude_account_ids_scope = exclude_account_ids_scope
        # The ID of the resource directory to which the rule does not apply, which means that the resources within member accounts in the resource directory are not evaluated based on the rule.
        # 
        # > 
        # *   This parameter applies only to a rule of a global account group.
        # *   This parameter applies only to a managed rule.
        self.exclude_folder_ids_scope = exclude_folder_ids_scope
        # The IDs of the regions excluded from the compliance evaluations performed by the rule. Separate multiple region IDs with commas (,).
        self.exclude_region_ids_scope = exclude_region_ids_scope
        # The IDs of the resource groups excluded from the compliance evaluations performed by the rule. Separate multiple resource group IDs with commas (,).
        self.exclude_resource_group_ids_scope = exclude_resource_group_ids_scope
        # The ID of the resource excluded from the compliance evaluations performed by the rule.
        self.exclude_resource_ids_scope = exclude_resource_ids_scope
        # The scope of the tag that is excluded.
        self.exclude_tags_scope = exclude_tags_scope
        # The extended content, which is temporarily only used to configure the trigger time with a 24-hour cycle trigger.
        self.extend_content = extend_content
        # The ID of the resource directory to which the rule applies, which means that the resources within member accounts in the resource directory are evaluated based on the rule.
        # 
        # > 
        # *   This parameter applies only to rules of a global account group.
        # *   This parameter applies only to managed rules.
        self.folder_ids_scope = folder_ids_scope
        # The input parameters of the rule.
        self.input_parameters = input_parameters
        # The details of the managed rule.
        self.managed_rule = managed_rule
        # The intervals at which the managed rule is triggered. Valid values:
        # 
        # *   One_Hour: 1 hour.
        # *   Three_Hours: 3 hours.
        # *   Six_Hours: 6 hours.
        # *   Twelve_Hours: 12 hours
        # *   TwentyFour_Hours: 24 hours
        self.maximum_execution_frequency = maximum_execution_frequency
        # The timestamp when the rule was last updated. Unit: milliseconds.
        self.modified_timestamp = modified_timestamp
        # The ID of the region to which the rule applies.
        self.region_ids_scope = region_ids_scope
        # The ID of the resource group to which the rule applies.
        self.resource_group_ids_scope = resource_group_ids_scope
        # The IDs of the resources to which the rule applies. Separate multiple resource IDs with commas (,).
        self.resource_ids_scope = resource_ids_scope
        # The type of the resource evaluated by the rule.
        self.resource_types_scope = resource_types_scope
        # The risk level of the resources that are not compliant with the rule. Valid values:
        # 
        # *   1: high risk level
        # *   2: medium risk level
        # *   3: low risk level
        self.risk_level = risk_level
        # The information about how the rule was created.
        self.source = source
        # The logical relationship among the tag keys if you specify multiple tag keys by using the `TagKeyScope` parameter. For example, if the `TagKeyScope` parameter is set to `ECS,OSS` and the TagKeyLogicScope parameter is set to `AND`, the rule applies to resources with both the `ECS` and `OSS` tag keys. Valid values:
        # 
        # *   AND: the logical relationship of AND
        # *   OR: the logical relationship of OR
        self.tag_key_logic_scope = tag_key_logic_scope
        # The tag key used to filter resources. The rule applies only to the resources with the specified tag key.
        self.tag_key_scope = tag_key_scope
        # The tag value used to filter resources. The rule applies only to the resources with the specified tag value.
        self.tag_value_scope = tag_value_scope
        self.tags = tags
        # The tag scope.
        self.tags_scope = tags_scope

    def validate(self):
        if self.compliance:
            self.compliance.validate()
        if self.config_rule_evaluation_status:
            self.config_rule_evaluation_status.validate()
        if self.create_by:
            self.create_by.validate()
        if self.exclude_tags_scope:
            for k in self.exclude_tags_scope:
                if k:
                    k.validate()
        if self.managed_rule:
            self.managed_rule.validate()
        if self.source:
            self.source.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()
        if self.tags_scope:
            for k in self.tags_scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.account_ids_scope is not None:
            result['AccountIdsScope'] = self.account_ids_scope
        if self.compliance is not None:
            result['Compliance'] = self.compliance.to_map()
        if self.config_rule_arn is not None:
            result['ConfigRuleArn'] = self.config_rule_arn
        if self.config_rule_evaluation_status is not None:
            result['ConfigRuleEvaluationStatus'] = self.config_rule_evaluation_status.to_map()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        if self.config_rule_state is not None:
            result['ConfigRuleState'] = self.config_rule_state
        if self.config_rule_trigger_types is not None:
            result['ConfigRuleTriggerTypes'] = self.config_rule_trigger_types
        if self.create_by is not None:
            result['CreateBy'] = self.create_by.to_map()
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.description is not None:
            result['Description'] = self.description
        if self.exclude_account_ids_scope is not None:
            result['ExcludeAccountIdsScope'] = self.exclude_account_ids_scope
        if self.exclude_folder_ids_scope is not None:
            result['ExcludeFolderIdsScope'] = self.exclude_folder_ids_scope
        if self.exclude_region_ids_scope is not None:
            result['ExcludeRegionIdsScope'] = self.exclude_region_ids_scope
        if self.exclude_resource_group_ids_scope is not None:
            result['ExcludeResourceGroupIdsScope'] = self.exclude_resource_group_ids_scope
        if self.exclude_resource_ids_scope is not None:
            result['ExcludeResourceIdsScope'] = self.exclude_resource_ids_scope
        result['ExcludeTagsScope'] = []
        if self.exclude_tags_scope is not None:
            for k in self.exclude_tags_scope:
                result['ExcludeTagsScope'].append(k.to_map() if k else None)
        if self.extend_content is not None:
            result['ExtendContent'] = self.extend_content
        if self.folder_ids_scope is not None:
            result['FolderIdsScope'] = self.folder_ids_scope
        if self.input_parameters is not None:
            result['InputParameters'] = self.input_parameters
        if self.managed_rule is not None:
            result['ManagedRule'] = self.managed_rule.to_map()
        if self.maximum_execution_frequency is not None:
            result['MaximumExecutionFrequency'] = self.maximum_execution_frequency
        if self.modified_timestamp is not None:
            result['ModifiedTimestamp'] = self.modified_timestamp
        if self.region_ids_scope is not None:
            result['RegionIdsScope'] = self.region_ids_scope
        if self.resource_group_ids_scope is not None:
            result['ResourceGroupIdsScope'] = self.resource_group_ids_scope
        if self.resource_ids_scope is not None:
            result['ResourceIdsScope'] = self.resource_ids_scope
        if self.resource_types_scope is not None:
            result['ResourceTypesScope'] = self.resource_types_scope
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.source is not None:
            result['Source'] = self.source.to_map()
        if self.tag_key_logic_scope is not None:
            result['TagKeyLogicScope'] = self.tag_key_logic_scope
        if self.tag_key_scope is not None:
            result['TagKeyScope'] = self.tag_key_scope
        if self.tag_value_scope is not None:
            result['TagValueScope'] = self.tag_value_scope
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        result['TagsScope'] = []
        if self.tags_scope is not None:
            for k in self.tags_scope:
                result['TagsScope'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AccountIdsScope') is not None:
            self.account_ids_scope = m.get('AccountIdsScope')
        if m.get('Compliance') is not None:
            temp_model = GetAggregateConfigRuleResponseBodyConfigRuleCompliance()
            self.compliance = temp_model.from_map(m['Compliance'])
        if m.get('ConfigRuleArn') is not None:
            self.config_rule_arn = m.get('ConfigRuleArn')
        if m.get('ConfigRuleEvaluationStatus') is not None:
            temp_model = GetAggregateConfigRuleResponseBodyConfigRuleConfigRuleEvaluationStatus()
            self.config_rule_evaluation_status = temp_model.from_map(m['ConfigRuleEvaluationStatus'])
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        if m.get('ConfigRuleState') is not None:
            self.config_rule_state = m.get('ConfigRuleState')
        if m.get('ConfigRuleTriggerTypes') is not None:
            self.config_rule_trigger_types = m.get('ConfigRuleTriggerTypes')
        if m.get('CreateBy') is not None:
            temp_model = GetAggregateConfigRuleResponseBodyConfigRuleCreateBy()
            self.create_by = temp_model.from_map(m['CreateBy'])
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExcludeAccountIdsScope') is not None:
            self.exclude_account_ids_scope = m.get('ExcludeAccountIdsScope')
        if m.get('ExcludeFolderIdsScope') is not None:
            self.exclude_folder_ids_scope = m.get('ExcludeFolderIdsScope')
        if m.get('ExcludeRegionIdsScope') is not None:
            self.exclude_region_ids_scope = m.get('ExcludeRegionIdsScope')
        if m.get('ExcludeResourceGroupIdsScope') is not None:
            self.exclude_resource_group_ids_scope = m.get('ExcludeResourceGroupIdsScope')
        if m.get('ExcludeResourceIdsScope') is not None:
            self.exclude_resource_ids_scope = m.get('ExcludeResourceIdsScope')
        self.exclude_tags_scope = []
        if m.get('ExcludeTagsScope') is not None:
            for k in m.get('ExcludeTagsScope'):
                temp_model = GetAggregateConfigRuleResponseBodyConfigRuleExcludeTagsScope()
                self.exclude_tags_scope.append(temp_model.from_map(k))
        if m.get('ExtendContent') is not None:
            self.extend_content = m.get('ExtendContent')
        if m.get('FolderIdsScope') is not None:
            self.folder_ids_scope = m.get('FolderIdsScope')
        if m.get('InputParameters') is not None:
            self.input_parameters = m.get('InputParameters')
        if m.get('ManagedRule') is not None:
            temp_model = GetAggregateConfigRuleResponseBodyConfigRuleManagedRule()
            self.managed_rule = temp_model.from_map(m['ManagedRule'])
        if m.get('MaximumExecutionFrequency') is not None:
            self.maximum_execution_frequency = m.get('MaximumExecutionFrequency')
        if m.get('ModifiedTimestamp') is not None:
            self.modified_timestamp = m.get('ModifiedTimestamp')
        if m.get('RegionIdsScope') is not None:
            self.region_ids_scope = m.get('RegionIdsScope')
        if m.get('ResourceGroupIdsScope') is not None:
            self.resource_group_ids_scope = m.get('ResourceGroupIdsScope')
        if m.get('ResourceIdsScope') is not None:
            self.resource_ids_scope = m.get('ResourceIdsScope')
        if m.get('ResourceTypesScope') is not None:
            self.resource_types_scope = m.get('ResourceTypesScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('Source') is not None:
            temp_model = GetAggregateConfigRuleResponseBodyConfigRuleSource()
            self.source = temp_model.from_map(m['Source'])
        if m.get('TagKeyLogicScope') is not None:
            self.tag_key_logic_scope = m.get('TagKeyLogicScope')
        if m.get('TagKeyScope') is not None:
            self.tag_key_scope = m.get('TagKeyScope')
        if m.get('TagValueScope') is not None:
            self.tag_value_scope = m.get('TagValueScope')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = GetAggregateConfigRuleResponseBodyConfigRuleTags()
                self.tags.append(temp_model.from_map(k))
        self.tags_scope = []
        if m.get('TagsScope') is not None:
            for k in m.get('TagsScope'):
                temp_model = GetAggregateConfigRuleResponseBodyConfigRuleTagsScope()
                self.tags_scope.append(temp_model.from_map(k))
        return self


class GetAggregateConfigRuleResponseBody(TeaModel):
    def __init__(
        self,
        config_rule: GetAggregateConfigRuleResponseBodyConfigRule = None,
        request_id: str = None,
    ):
        # The rules.
        self.config_rule = config_rule
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.config_rule:
            self.config_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule is not None:
            result['ConfigRule'] = self.config_rule.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRule') is not None:
            temp_model = GetAggregateConfigRuleResponseBodyConfigRule()
            self.config_rule = temp_model.from_map(m['ConfigRule'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateConfigRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateConfigRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateConfigRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateConfigRuleComplianceByPackRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
    ):
        # The ID of the account group.
        # 
        # For information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the compliance package.
        # 
        # For information about how to obtain the ID of a compliance package, see [ListAggregateCompliancePacks](https://help.aliyun.com/document_detail/262059.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        return self


class GetAggregateConfigRuleComplianceByPackResponseBodyConfigRuleComplianceResultConfigRuleCompliances(TeaModel):
    def __init__(
        self,
        compliance_type: str = None,
        config_rule_id: str = None,
        config_rule_name: str = None,
    ):
        # The compliance evaluation result returned by the rule. Valid values:
        # 
        # *   COMPLIANT: The relevant resources are evaluated as compliant.
        # *   NON_COMPLIANT: The relevant resources are evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to your resources.
        # *   INSUFFICIENT_DATA: No resource data is available.
        self.compliance_type = compliance_type
        # The ID of the rule.
        self.config_rule_id = config_rule_id
        # The name of the rule.
        self.config_rule_name = config_rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        return self


class GetAggregateConfigRuleComplianceByPackResponseBodyConfigRuleComplianceResult(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        config_rule_compliances: List[GetAggregateConfigRuleComplianceByPackResponseBodyConfigRuleComplianceResultConfigRuleCompliances] = None,
        non_compliant_count: int = None,
        total_count: int = None,
    ):
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The information about rules in the compliance package.
        self.config_rule_compliances = config_rule_compliances
        # The number of rules against which specific resources are evaluated as non-compliant.
        self.non_compliant_count = non_compliant_count
        # The total number of rules in the compliance package.
        self.total_count = total_count

    def validate(self):
        if self.config_rule_compliances:
            for k in self.config_rule_compliances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        result['ConfigRuleCompliances'] = []
        if self.config_rule_compliances is not None:
            for k in self.config_rule_compliances:
                result['ConfigRuleCompliances'].append(k.to_map() if k else None)
        if self.non_compliant_count is not None:
            result['NonCompliantCount'] = self.non_compliant_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        self.config_rule_compliances = []
        if m.get('ConfigRuleCompliances') is not None:
            for k in m.get('ConfigRuleCompliances'):
                temp_model = GetAggregateConfigRuleComplianceByPackResponseBodyConfigRuleComplianceResultConfigRuleCompliances()
                self.config_rule_compliances.append(temp_model.from_map(k))
        if m.get('NonCompliantCount') is not None:
            self.non_compliant_count = m.get('NonCompliantCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetAggregateConfigRuleComplianceByPackResponseBody(TeaModel):
    def __init__(
        self,
        config_rule_compliance_result: GetAggregateConfigRuleComplianceByPackResponseBodyConfigRuleComplianceResult = None,
        request_id: str = None,
    ):
        # The compliance evaluation results that are returned by rules in the compliance package.
        self.config_rule_compliance_result = config_rule_compliance_result
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.config_rule_compliance_result:
            self.config_rule_compliance_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_compliance_result is not None:
            result['ConfigRuleComplianceResult'] = self.config_rule_compliance_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleComplianceResult') is not None:
            temp_model = GetAggregateConfigRuleComplianceByPackResponseBodyConfigRuleComplianceResult()
            self.config_rule_compliance_result = temp_model.from_map(m['ConfigRuleComplianceResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateConfigRuleComplianceByPackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateConfigRuleComplianceByPackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateConfigRuleComplianceByPackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateConfigRuleSummaryByRiskLevelRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        return self


class GetAggregateConfigRuleSummaryByRiskLevelResponseBodyConfigRuleSummaries(TeaModel):
    def __init__(
        self,
        compliant_count: int = None,
        non_compliant_count: int = None,
        risk_level: int = None,
    ):
        # The number of rules against which specific resources are evaluated as compliant.
        self.compliant_count = compliant_count
        # The number of rules against which specific resources are evaluated as non-compliant.
        self.non_compliant_count = non_compliant_count
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high
        # *   2: medium
        # *   3: low
        self.risk_level = risk_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliant_count is not None:
            result['CompliantCount'] = self.compliant_count
        if self.non_compliant_count is not None:
            result['NonCompliantCount'] = self.non_compliant_count
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliantCount') is not None:
            self.compliant_count = m.get('CompliantCount')
        if m.get('NonCompliantCount') is not None:
            self.non_compliant_count = m.get('NonCompliantCount')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class GetAggregateConfigRuleSummaryByRiskLevelResponseBody(TeaModel):
    def __init__(
        self,
        config_rule_summaries: List[GetAggregateConfigRuleSummaryByRiskLevelResponseBodyConfigRuleSummaries] = None,
        request_id: str = None,
    ):
        # The summary of compliance evaluation results by rule risk level.
        self.config_rule_summaries = config_rule_summaries
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.config_rule_summaries:
            for k in self.config_rule_summaries:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigRuleSummaries'] = []
        if self.config_rule_summaries is not None:
            for k in self.config_rule_summaries:
                result['ConfigRuleSummaries'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_rule_summaries = []
        if m.get('ConfigRuleSummaries') is not None:
            for k in m.get('ConfigRuleSummaries'):
                temp_model = GetAggregateConfigRuleSummaryByRiskLevelResponseBodyConfigRuleSummaries()
                self.config_rule_summaries.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateConfigRuleSummaryByRiskLevelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateConfigRuleSummaryByRiskLevelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateConfigRuleSummaryByRiskLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateConfigRulesReportRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        report_id: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the compliance evaluation report.
        self.report_id = report_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        return self


class GetAggregateConfigRulesReportResponseBodyConfigRulesReport(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        aggregator_id: str = None,
        report_create_timestamp: int = None,
        report_id: str = None,
        report_status: str = None,
        report_url: str = None,
    ):
        # The ID of the management account to which the rules belong.
        self.account_id = account_id
        # The ID of the account group.
        self.aggregator_id = aggregator_id
        # The timestamp when the compliance evaluation report was generated. Unit: milliseconds.
        self.report_create_timestamp = report_create_timestamp
        # The ID of the compliance evaluation report.
        self.report_id = report_id
        # The status of the compliance evaluation report. Valid values:
        # 
        # *   NONE: The compliance evaluation report was not generated.
        # *   CREATING: The compliance evaluation report was being generated.
        # *   COMPLETE: The compliance evaluation report was generated.
        self.report_status = report_status
        # The URL that is used to download the compliance evaluation report.
        self.report_url = report_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.report_create_timestamp is not None:
            result['ReportCreateTimestamp'] = self.report_create_timestamp
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.report_status is not None:
            result['ReportStatus'] = self.report_status
        if self.report_url is not None:
            result['ReportUrl'] = self.report_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ReportCreateTimestamp') is not None:
            self.report_create_timestamp = m.get('ReportCreateTimestamp')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('ReportStatus') is not None:
            self.report_status = m.get('ReportStatus')
        if m.get('ReportUrl') is not None:
            self.report_url = m.get('ReportUrl')
        return self


class GetAggregateConfigRulesReportResponseBody(TeaModel):
    def __init__(
        self,
        config_rules_report: GetAggregateConfigRulesReportResponseBodyConfigRulesReport = None,
        request_id: str = None,
    ):
        # The information about the compliance evaluation report.
        self.config_rules_report = config_rules_report
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.config_rules_report:
            self.config_rules_report.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rules_report is not None:
            result['ConfigRulesReport'] = self.config_rules_report.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRulesReport') is not None:
            temp_model = GetAggregateConfigRulesReportResponseBodyConfigRulesReport()
            self.config_rules_report = temp_model.from_map(m['ConfigRulesReport'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateConfigRulesReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateConfigRulesReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateConfigRulesReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateDiscoveredResourceRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_option: int = None,
        region: str = None,
        resource_account_id: int = None,
        resource_id: str = None,
        resource_owner_id: int = None,
        resource_type: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # Specifies whether to query the compliance results of the resource. Valid values:
        # 
        # *   0 (default): does not query the compliance results of the resource.
        # *   1: queries the compliance results of the resource.
        self.compliance_option = compliance_option
        # The ID of the region in which the resource resides.
        # 
        # For more information about how to query the ID of a region in which the resource resides, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/411691.html).
        # 
        # This parameter is required.
        self.region = region
        # The ID of the Alibaba Cloud account to which the specified resource belongs in the account group.
        self.resource_account_id = resource_account_id
        # The resource ID.
        # 
        # For more information about how to obtain the ID of a resource, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/411691.html).
        # 
        # This parameter is required.
        self.resource_id = resource_id
        self.resource_owner_id = resource_owner_id
        # The type of the resource.
        # 
        # For more information about how to obtain the type of a resource, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/411691.html).
        # 
        # This parameter is required.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_option is not None:
            result['ComplianceOption'] = self.compliance_option
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_account_id is not None:
            result['ResourceAccountId'] = self.resource_account_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ComplianceOption') is not None:
            self.compliance_option = m.get('ComplianceOption')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceAccountId') is not None:
            self.resource_account_id = m.get('ResourceAccountId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class GetAggregateDiscoveredResourceResponseBodyDiscoveredResourceDetail(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        availability_zone: str = None,
        compliance_type: str = None,
        configuration: str = None,
        region: str = None,
        resource_creation_time: int = None,
        resource_deleted: int = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_status: str = None,
        resource_type: str = None,
        tags: str = None,
    ):
        # The ID of the Alibaba Cloud account to which the resource belongs.
        self.account_id = account_id
        # The ID of the zone in which the resource resides.
        self.availability_zone = availability_zone
        # The compliance evaluation result of the resource. Valid values:
        # 
        # *   COMPLIANT: The resource is evaluated as compliant.
        # *   NON_COMPLIANT: The resource is evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to the resource.
        # *   INSUFFICIENT_DATA: No data is available.
        # *   IGNORED: The resource is ignored during compliance evaluation.
        self.compliance_type = compliance_type
        # The configuration of the resource.
        self.configuration = configuration
        # The region ID.
        self.region = region
        # The timestamp when the resource was created.
        self.resource_creation_time = resource_creation_time
        # Indicates whether the resource was deleted. Valid values:
        # 
        # *   1: The resource was not deleted.
        # *   0: The resource was deleted.
        self.resource_deleted = resource_deleted
        # The resource ID.
        self.resource_id = resource_id
        # The name of the resource.
        self.resource_name = resource_name
        # The status of the resource. The value of this parameter varies based on the resource type and may be empty.
        # 
        # *   If the ResourceType parameter is set to ACS::ECS::Instance, the resource is an ECS instance that has a specific state. In this case, the valid values of this parameter are Running and Stopped.
        # *   If the ResourceType parameter is ACS::OSS::Bucket, the resource is an Object Storage Service (OSS) bucket that is not in a specific state. In this case, this parameter is left empty.
        self.resource_status = resource_status
        # The type of the resource.
        self.resource_type = resource_type
        # The tags of the resource.
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.availability_zone is not None:
            result['AvailabilityZone'] = self.availability_zone
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_creation_time is not None:
            result['ResourceCreationTime'] = self.resource_creation_time
        if self.resource_deleted is not None:
            result['ResourceDeleted'] = self.resource_deleted
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_status is not None:
            result['ResourceStatus'] = self.resource_status
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AvailabilityZone') is not None:
            self.availability_zone = m.get('AvailabilityZone')
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceCreationTime') is not None:
            self.resource_creation_time = m.get('ResourceCreationTime')
        if m.get('ResourceDeleted') is not None:
            self.resource_deleted = m.get('ResourceDeleted')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceStatus') is not None:
            self.resource_status = m.get('ResourceStatus')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class GetAggregateDiscoveredResourceResponseBody(TeaModel):
    def __init__(
        self,
        discovered_resource_detail: GetAggregateDiscoveredResourceResponseBodyDiscoveredResourceDetail = None,
        request_id: str = None,
    ):
        # The details of the resource.
        self.discovered_resource_detail = discovered_resource_detail
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.discovered_resource_detail:
            self.discovered_resource_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discovered_resource_detail is not None:
            result['DiscoveredResourceDetail'] = self.discovered_resource_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiscoveredResourceDetail') is not None:
            temp_model = GetAggregateDiscoveredResourceResponseBodyDiscoveredResourceDetail()
            self.discovered_resource_detail = temp_model.from_map(m['DiscoveredResourceDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateDiscoveredResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateDiscoveredResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateDiscoveredResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateResourceComplianceByConfigRuleRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_type: str = None,
        config_rule_id: str = None,
        resource_account_id: int = None,
        resource_owner_id: int = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The compliance evaluation result of the resources. Valid values:
        # 
        # *   COMPLIANT: The resource is evaluated as compliant.
        # *   NON_COMPLIANT: The resource is evaluated as incompliant.
        # *   NOT_APPLICABLE: The rule does not apply to your resources.
        # *   INSUFFICIENT_DATA: No resource data is available.
        self.compliance_type = compliance_type
        # The ID of the rule.
        # 
        # For more information about how to obtain the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id
        # The ID of the Alibaba Cloud account to which the resources in the account group belong.
        # 
        # > You can use either the ResourceAccountId or ResourceOwnerId parameter. We recommend that you use the ResourceAccountId parameter.
        self.resource_account_id = resource_account_id
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.resource_account_id is not None:
            result['ResourceAccountId'] = self.resource_account_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ResourceAccountId') is not None:
            self.resource_account_id = m.get('ResourceAccountId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetAggregateResourceComplianceByConfigRuleResponseBodyComplianceResultCompliances(TeaModel):
    def __init__(
        self,
        compliance_type: str = None,
        count: int = None,
    ):
        # The compliance evaluation results of the resources. Valid values:
        # 
        # *   COMPLIANT: The resource was evaluated as compliant.
        # *   NON_COMPLIANT: The resource was evaluated as incompliant.
        # *   NOT_APPLICABLE: The rule did not apply to your resources.
        # *   INSUFFICIENT_DATA: No resource data was available.
        self.compliance_type = compliance_type
        # The number of resources that have compliance evaluation results. For example, if the value of the `ComplianceType` parameter is `COMPLIANT`, this parameter value indicates the number of compliant resources.
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetAggregateResourceComplianceByConfigRuleResponseBodyComplianceResult(TeaModel):
    def __init__(
        self,
        compliances: List[GetAggregateResourceComplianceByConfigRuleResponseBodyComplianceResultCompliances] = None,
        total_count: int = None,
    ):
        # The compliance list result.
        self.compliances = compliances
        # The total number of evaluated resources.
        self.total_count = total_count

    def validate(self):
        if self.compliances:
            for k in self.compliances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Compliances'] = []
        if self.compliances is not None:
            for k in self.compliances:
                result['Compliances'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliances = []
        if m.get('Compliances') is not None:
            for k in m.get('Compliances'):
                temp_model = GetAggregateResourceComplianceByConfigRuleResponseBodyComplianceResultCompliances()
                self.compliances.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetAggregateResourceComplianceByConfigRuleResponseBody(TeaModel):
    def __init__(
        self,
        compliance_result: GetAggregateResourceComplianceByConfigRuleResponseBodyComplianceResult = None,
        request_id: str = None,
    ):
        # The compliance result.
        self.compliance_result = compliance_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.compliance_result:
            self.compliance_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_result is not None:
            result['ComplianceResult'] = self.compliance_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceResult') is not None:
            temp_model = GetAggregateResourceComplianceByConfigRuleResponseBodyComplianceResult()
            self.compliance_result = temp_model.from_map(m['ComplianceResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateResourceComplianceByConfigRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateResourceComplianceByConfigRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateResourceComplianceByConfigRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateResourceComplianceByPackRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListAggregateCompliancePacks](https://help.aliyun.com/document_detail/262059.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        return self


class GetAggregateResourceComplianceByPackResponseBodyResourceComplianceResult(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        non_compliant_count: int = None,
        total_count: int = None,
    ):
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The number of non-compliant resources.
        self.non_compliant_count = non_compliant_count
        # The total number of resources.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.non_compliant_count is not None:
            result['NonCompliantCount'] = self.non_compliant_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('NonCompliantCount') is not None:
            self.non_compliant_count = m.get('NonCompliantCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetAggregateResourceComplianceByPackResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_compliance_result: GetAggregateResourceComplianceByPackResponseBodyResourceComplianceResult = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The compliance evaluation results returned.
        self.resource_compliance_result = resource_compliance_result

    def validate(self):
        if self.resource_compliance_result:
            self.resource_compliance_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_compliance_result is not None:
            result['ResourceComplianceResult'] = self.resource_compliance_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceComplianceResult') is not None:
            temp_model = GetAggregateResourceComplianceByPackResponseBodyResourceComplianceResult()
            self.resource_compliance_result = temp_model.from_map(m['ResourceComplianceResult'])
        return self


class GetAggregateResourceComplianceByPackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateResourceComplianceByPackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateResourceComplianceByPackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateResourceComplianceGroupByRegionRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        config_rule_ids: str = None,
    ):
        # The ID of the account group.
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The rule IDs. Separate multiple rule IDs with commas (,).
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class GetAggregateResourceComplianceGroupByRegionResponseBodyComplianceResultComplianceResultListCompliances(TeaModel):
    def __init__(
        self,
        compliance_type: str = None,
        count: int = None,
    ):
        # The evaluation result. Valid values:
        # 
        # *   COMPLIANT: The resource is evaluated as compliant.
        # *   NON_COMPLIANT: The resource is evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to the resource.
        # *   INSUFFICIENT_DATA: No data is available.
        self.compliance_type = compliance_type
        # The total number of evaluation results.
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetAggregateResourceComplianceGroupByRegionResponseBodyComplianceResultComplianceResultList(TeaModel):
    def __init__(
        self,
        compliances: List[GetAggregateResourceComplianceGroupByRegionResponseBodyComplianceResultComplianceResultListCompliances] = None,
        region_id: str = None,
    ):
        # The queried evaluation results.
        self.compliances = compliances
        # The region ID of the evaluated resource.
        self.region_id = region_id

    def validate(self):
        if self.compliances:
            for k in self.compliances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Compliances'] = []
        if self.compliances is not None:
            for k in self.compliances:
                result['Compliances'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliances = []
        if m.get('Compliances') is not None:
            for k in m.get('Compliances'):
                temp_model = GetAggregateResourceComplianceGroupByRegionResponseBodyComplianceResultComplianceResultListCompliances()
                self.compliances.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetAggregateResourceComplianceGroupByRegionResponseBodyComplianceResult(TeaModel):
    def __init__(
        self,
        compliance_result_list: List[GetAggregateResourceComplianceGroupByRegionResponseBodyComplianceResultComplianceResultList] = None,
    ):
        # The evaluation results grouped by region.
        self.compliance_result_list = compliance_result_list

    def validate(self):
        if self.compliance_result_list:
            for k in self.compliance_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ComplianceResultList'] = []
        if self.compliance_result_list is not None:
            for k in self.compliance_result_list:
                result['ComplianceResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliance_result_list = []
        if m.get('ComplianceResultList') is not None:
            for k in m.get('ComplianceResultList'):
                temp_model = GetAggregateResourceComplianceGroupByRegionResponseBodyComplianceResultComplianceResultList()
                self.compliance_result_list.append(temp_model.from_map(k))
        return self


class GetAggregateResourceComplianceGroupByRegionResponseBody(TeaModel):
    def __init__(
        self,
        compliance_result: GetAggregateResourceComplianceGroupByRegionResponseBodyComplianceResult = None,
        request_id: str = None,
    ):
        # The queried evaluation results.
        self.compliance_result = compliance_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.compliance_result:
            self.compliance_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_result is not None:
            result['ComplianceResult'] = self.compliance_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceResult') is not None:
            temp_model = GetAggregateResourceComplianceGroupByRegionResponseBodyComplianceResult()
            self.compliance_result = temp_model.from_map(m['ComplianceResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateResourceComplianceGroupByRegionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateResourceComplianceGroupByRegionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateResourceComplianceGroupByRegionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateResourceComplianceGroupByResourceTypeRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        config_rule_ids: str = None,
    ):
        # The ID of the account group.
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the rule. Separate multiple rule IDs with commas (,).
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class GetAggregateResourceComplianceGroupByResourceTypeResponseBodyComplianceResultComplianceResultListCompliances(TeaModel):
    def __init__(
        self,
        compliance_type: str = None,
        count: int = None,
    ):
        # The evaluation result. Valid values:
        # 
        # *   COMPLIANT: The resource is evaluated as compliant.
        # *   NON_COMPLIANT: The resource is evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to the resource.
        # *   INSUFFICIENT_DATA: No data is available.
        self.compliance_type = compliance_type
        # The number of statistical results.
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetAggregateResourceComplianceGroupByResourceTypeResponseBodyComplianceResultComplianceResultList(TeaModel):
    def __init__(
        self,
        compliances: List[GetAggregateResourceComplianceGroupByResourceTypeResponseBodyComplianceResultComplianceResultListCompliances] = None,
        resource_type: str = None,
    ):
        # The queried evaluation results.
        self.compliances = compliances
        # The type of the evaluated resource.
        self.resource_type = resource_type

    def validate(self):
        if self.compliances:
            for k in self.compliances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Compliances'] = []
        if self.compliances is not None:
            for k in self.compliances:
                result['Compliances'].append(k.to_map() if k else None)
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliances = []
        if m.get('Compliances') is not None:
            for k in m.get('Compliances'):
                temp_model = GetAggregateResourceComplianceGroupByResourceTypeResponseBodyComplianceResultComplianceResultListCompliances()
                self.compliances.append(temp_model.from_map(k))
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class GetAggregateResourceComplianceGroupByResourceTypeResponseBodyComplianceResult(TeaModel):
    def __init__(
        self,
        compliance_result_list: List[GetAggregateResourceComplianceGroupByResourceTypeResponseBodyComplianceResultComplianceResultList] = None,
    ):
        # The evaluation results grouped by resource type.
        self.compliance_result_list = compliance_result_list

    def validate(self):
        if self.compliance_result_list:
            for k in self.compliance_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ComplianceResultList'] = []
        if self.compliance_result_list is not None:
            for k in self.compliance_result_list:
                result['ComplianceResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliance_result_list = []
        if m.get('ComplianceResultList') is not None:
            for k in m.get('ComplianceResultList'):
                temp_model = GetAggregateResourceComplianceGroupByResourceTypeResponseBodyComplianceResultComplianceResultList()
                self.compliance_result_list.append(temp_model.from_map(k))
        return self


class GetAggregateResourceComplianceGroupByResourceTypeResponseBody(TeaModel):
    def __init__(
        self,
        compliance_result: GetAggregateResourceComplianceGroupByResourceTypeResponseBodyComplianceResult = None,
        request_id: str = None,
    ):
        # The queried evaluation results.
        self.compliance_result = compliance_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.compliance_result:
            self.compliance_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_result is not None:
            result['ComplianceResult'] = self.compliance_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceResult') is not None:
            temp_model = GetAggregateResourceComplianceGroupByResourceTypeResponseBodyComplianceResult()
            self.compliance_result = temp_model.from_map(m['ComplianceResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateResourceComplianceGroupByResourceTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateResourceComplianceGroupByResourceTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateResourceComplianceGroupByResourceTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateResourceComplianceTimelineRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        end_time: int = None,
        max_results: int = None,
        next_token: str = None,
        region: str = None,
        resource_account_id: int = None,
        resource_id: str = None,
        resource_owner_id: int = None,
        resource_type: str = None,
        start_time: int = None,
    ):
        # The ID of the account group.
        # 
        # For information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The end of the time range to query. The default value indicates the time when the GetAggregateResourceConfigurationTimeline operation is called. Unit: milliseconds.
        self.end_time = end_time
        # The maximum number of entries returned for a single request. Valid values: 1 to 100.
        self.max_results = max_results
        # The `token` that is used to initiate the next request if the response of the current request is truncated. You can use the token to initiate another request and obtain the remaining records.
        self.next_token = next_token
        # The ID of the region where the resource resides.
        # 
        # For more information about how to obtain the ID of a region, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        # 
        # This parameter is required.
        self.region = region
        # The ID of the Alibaba Cloud account to which the resources in the account group belong.
        # 
        # > You can use either the ResourceAccountId or ResourceOwnerId parameter. We recommend that you use the ResourceAccountId parameter.
        self.resource_account_id = resource_account_id
        # The resource ID.
        # 
        # For more information about how to query the ID of a resource, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        # 
        # This parameter is required.
        self.resource_id = resource_id
        self.resource_owner_id = resource_owner_id
        # The resource type.
        # 
        # For more information about how to obtain the type of a resource, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        # 
        # This parameter is required.
        self.resource_type = resource_type
        # The beginning of the time range to query. By default, Cloud Config retrieves the configuration changes in the last 30 days for the specified resource. Unit: milliseconds.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_account_id is not None:
            result['ResourceAccountId'] = self.resource_account_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceAccountId') is not None:
            self.resource_account_id = m.get('ResourceAccountId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetAggregateResourceComplianceTimelineResponseBodyResourceComplianceTimelineComplianceList(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        availability_zone: str = None,
        capture_time: int = None,
        configuration: str = None,
        configuration_diff: str = None,
        region: str = None,
        resource_create_time: int = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_status: str = None,
        resource_type: str = None,
        tags: str = None,
    ):
        # The ID of the Alibaba Cloud account to which the resource belongs.
        self.account_id = account_id
        # The ID of the zone in which the resource resides.
        self.availability_zone = availability_zone
        # The timestamp when the compliance evaluation was recorded. Unit: milliseconds.
        self.capture_time = capture_time
        # The information about the rules that evaluated the resource and the compliance evaluation result.
        self.configuration = configuration
        # The details of the resource change that triggered the compliance evaluation.
        self.configuration_diff = configuration_diff
        # The ID of the region in which the resource resides.
        self.region = region
        # The timestamp when the resource was created. Unit: milliseconds.
        self.resource_create_time = resource_create_time
        # The ID of the resource.
        self.resource_id = resource_id
        # The name of the resource.
        self.resource_name = resource_name
        # The status of the resource. The parameter value varies based on the resource type and may be left empty. Examples:
        # 
        # *   If the ResourceType parameter is set to ACS::ECS::Instance, the resource is an Elastic Compute Service (ECS) instance that has a specific state. In this case, the valid values of this parameter are Running and Stopped.
        # *   If the ResourceType parameter is set to ACS::OSS::Bucket, the resource is an OSS bucket that does not have a specific state. In this case, this parameter is left empty.
        self.resource_status = resource_status
        # The type of the resource.
        self.resource_type = resource_type
        # The tags of the resource.
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.availability_zone is not None:
            result['AvailabilityZone'] = self.availability_zone
        if self.capture_time is not None:
            result['CaptureTime'] = self.capture_time
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.configuration_diff is not None:
            result['ConfigurationDiff'] = self.configuration_diff
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_create_time is not None:
            result['ResourceCreateTime'] = self.resource_create_time
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_status is not None:
            result['ResourceStatus'] = self.resource_status
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AvailabilityZone') is not None:
            self.availability_zone = m.get('AvailabilityZone')
        if m.get('CaptureTime') is not None:
            self.capture_time = m.get('CaptureTime')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ConfigurationDiff') is not None:
            self.configuration_diff = m.get('ConfigurationDiff')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceCreateTime') is not None:
            self.resource_create_time = m.get('ResourceCreateTime')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceStatus') is not None:
            self.resource_status = m.get('ResourceStatus')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class GetAggregateResourceComplianceTimelineResponseBodyResourceComplianceTimeline(TeaModel):
    def __init__(
        self,
        compliance_list: List[GetAggregateResourceComplianceTimelineResponseBodyResourceComplianceTimelineComplianceList] = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # The status of the resource. The parameter value varies based on the resource type and may be left empty. Examples:
        # 
        # *   If the value of the ResourceType parameter is ACS::ECS::Instance, the resource is an Elastic Compute Service (ECS) instance that has a specific state. In this case, the valid values of this parameter are Running and Stopped.
        # *   If the value of the ResourceType parameter is ACS::OSS::Bucket, the resource is an Object Storage Service (OSS) bucket that is not in a specific state. In this case, this parameter is empty.
        self.compliance_list = compliance_list
        # The maximum number of entries returned for a single request.
        self.max_results = max_results
        # A pagination token. It can be used in the next request to retrieve a new page of results.
        self.next_token = next_token

    def validate(self):
        if self.compliance_list:
            for k in self.compliance_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ComplianceList'] = []
        if self.compliance_list is not None:
            for k in self.compliance_list:
                result['ComplianceList'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliance_list = []
        if m.get('ComplianceList') is not None:
            for k in m.get('ComplianceList'):
                temp_model = GetAggregateResourceComplianceTimelineResponseBodyResourceComplianceTimelineComplianceList()
                self.compliance_list.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class GetAggregateResourceComplianceTimelineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_compliance_timeline: GetAggregateResourceComplianceTimelineResponseBodyResourceComplianceTimeline = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The information about the compliance timeline.
        self.resource_compliance_timeline = resource_compliance_timeline

    def validate(self):
        if self.resource_compliance_timeline:
            self.resource_compliance_timeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_compliance_timeline is not None:
            result['ResourceComplianceTimeline'] = self.resource_compliance_timeline.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceComplianceTimeline') is not None:
            temp_model = GetAggregateResourceComplianceTimelineResponseBodyResourceComplianceTimeline()
            self.resource_compliance_timeline = temp_model.from_map(m['ResourceComplianceTimeline'])
        return self


class GetAggregateResourceComplianceTimelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateResourceComplianceTimelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateResourceComplianceTimelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateResourceConfigurationTimelineRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        end_time: int = None,
        max_results: int = None,
        next_token: str = None,
        region: str = None,
        resource_account_id: int = None,
        resource_id: str = None,
        resource_owner_id: int = None,
        resource_type: str = None,
        start_time: int = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The end of the time range to query. The default value indicates the time when the GetAggregateResourceConfigurationTimeline operation is called. Unit: milliseconds.
        self.end_time = end_time
        # The maximum number of entries to return for a single request. Valid values: 1 to 100.
        self.max_results = max_results
        # The `token` that is used to initiate the next request if the response of the current request is truncated. You can use the token to initiate another request and obtain the remaining records.
        self.next_token = next_token
        # The ID of the region in which the resource resides.
        # 
        # For more information about how to obtain the ID of a region, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        # 
        # This parameter is required.
        self.region = region
        # The ID of the Alibaba Cloud account to which the resource in the account group belongs.
        self.resource_account_id = resource_account_id
        # The resource ID.
        # 
        # For more information about how to query the ID of a resource, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        # 
        # This parameter is required.
        self.resource_id = resource_id
        self.resource_owner_id = resource_owner_id
        # The type of the resource.
        # 
        # For more information about how to obtain the type of a resource, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        # 
        # This parameter is required.
        self.resource_type = resource_type
        # The beginning of the time range to query. By default, Cloud Config retrieves the configuration changes in the last 30 days for the specified resource. Unit: milliseconds.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_account_id is not None:
            result['ResourceAccountId'] = self.resource_account_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceAccountId') is not None:
            self.resource_account_id = m.get('ResourceAccountId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetAggregateResourceConfigurationTimelineResponseBodyResourceConfigurationTimelineConfigurationList(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        availability_zone: str = None,
        capture_time: str = None,
        configuration_diff: str = None,
        region: str = None,
        resource_create_time: str = None,
        resource_event_type: str = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_type: str = None,
        tags: str = None,
    ):
        # The ID of the Alibaba Cloud account to which the resource belongs.
        self.account_id = account_id
        # The ID of the zone in which the resource resides.
        self.availability_zone = availability_zone
        # The timestamp when the resource change snapshot was recorded. Unit: milliseconds.
        self.capture_time = capture_time
        # The details of the resource change that triggered the compliance evaluation.
        self.configuration_diff = configuration_diff
        # The ID of the region in which the resource resides.
        self.region = region
        # The timestamp when the resource was created. Unit: milliseconds.
        self.resource_create_time = resource_create_time
        # The type of the resource change event involved. Valid values:
        # 
        # *   DISCOVERED: A resource is created.
        # *   DISCOVERED_REVISED: A resource is created by periodic remediation tasks.
        # *   MODIFY: A resource is modified.
        # *   MODIFY_REVISED: A resource is modified by periodic remediation tasks.
        # *   REMOVE: A resource is deleted.
        # 
        # > 
        # *   To ensure the integrity of resources, periodic remediation tasks are run to check data and generate events that indicate the creation of new resources. Such events are infrequent.
        # *   The time when a resource change event is generated by a periodic remediation task is considered as the detection time of Cloud Config. The detection time is later than the time when the resource is modified.
        self.resource_event_type = resource_event_type
        # The ID of the resource.
        self.resource_id = resource_id
        # The name of the resource.
        self.resource_name = resource_name
        # The type of the resource.
        self.resource_type = resource_type
        # The tags of the resource.
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.availability_zone is not None:
            result['AvailabilityZone'] = self.availability_zone
        if self.capture_time is not None:
            result['CaptureTime'] = self.capture_time
        if self.configuration_diff is not None:
            result['ConfigurationDiff'] = self.configuration_diff
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_create_time is not None:
            result['ResourceCreateTime'] = self.resource_create_time
        if self.resource_event_type is not None:
            result['ResourceEventType'] = self.resource_event_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AvailabilityZone') is not None:
            self.availability_zone = m.get('AvailabilityZone')
        if m.get('CaptureTime') is not None:
            self.capture_time = m.get('CaptureTime')
        if m.get('ConfigurationDiff') is not None:
            self.configuration_diff = m.get('ConfigurationDiff')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceCreateTime') is not None:
            self.resource_create_time = m.get('ResourceCreateTime')
        if m.get('ResourceEventType') is not None:
            self.resource_event_type = m.get('ResourceEventType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class GetAggregateResourceConfigurationTimelineResponseBodyResourceConfigurationTimeline(TeaModel):
    def __init__(
        self,
        configuration_list: List[GetAggregateResourceConfigurationTimelineResponseBodyResourceConfigurationTimelineConfigurationList] = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # The resource name.
        self.configuration_list = configuration_list
        # The maximum number of entries returned for a single request.
        self.max_results = max_results
        # The token that is used to initiate the next request.
        self.next_token = next_token

    def validate(self):
        if self.configuration_list:
            for k in self.configuration_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigurationList'] = []
        if self.configuration_list is not None:
            for k in self.configuration_list:
                result['ConfigurationList'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.configuration_list = []
        if m.get('ConfigurationList') is not None:
            for k in m.get('ConfigurationList'):
                temp_model = GetAggregateResourceConfigurationTimelineResponseBodyResourceConfigurationTimelineConfigurationList()
                self.configuration_list.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class GetAggregateResourceConfigurationTimelineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_configuration_timeline: GetAggregateResourceConfigurationTimelineResponseBodyResourceConfigurationTimeline = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The configuration timeline of the resource.
        self.resource_configuration_timeline = resource_configuration_timeline

    def validate(self):
        if self.resource_configuration_timeline:
            self.resource_configuration_timeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_configuration_timeline is not None:
            result['ResourceConfigurationTimeline'] = self.resource_configuration_timeline.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceConfigurationTimeline') is not None:
            temp_model = GetAggregateResourceConfigurationTimelineResponseBodyResourceConfigurationTimeline()
            self.resource_configuration_timeline = temp_model.from_map(m['ResourceConfigurationTimeline'])
        return self


class GetAggregateResourceConfigurationTimelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateResourceConfigurationTimelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateResourceConfigurationTimelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateResourceCountsGroupByRegionRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        folder_id: str = None,
        resource_account_id: int = None,
        resource_owner_id: int = None,
        resource_type: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the folder in the resource directory. For more information about how to obtain the ID of a folder, see [View the basic information of a folder](https://help.aliyun.com/document_detail/111223.html).
        self.folder_id = folder_id
        # The ID of the Alibaba Cloud account to which the resources in the account group belong.
        # 
        # > You can use either the ResourceAccountId or ResourceOwnerId parameter. We recommend that you use the ResourceAccountId parameter.
        self.resource_account_id = resource_account_id
        self.resource_owner_id = resource_owner_id
        # The resource type.
        # 
        # For more information about how to obtain the type of a resource, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.resource_account_id is not None:
            result['ResourceAccountId'] = self.resource_account_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('ResourceAccountId') is not None:
            self.resource_account_id = m.get('ResourceAccountId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class GetAggregateResourceCountsGroupByRegionResponseBodyDiscoveredResourceCountsSummary(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        region: str = None,
        resource_count: int = None,
    ):
        # The dimension by which statistics are collected.
        # 
        # >  In most cases, the `Region` parameter is returned instead of the GroupName parameter.
        self.group_name = group_name
        # The ID of the region by which statistics are collected.
        self.region = region
        # The total number of resources in the region.
        self.resource_count = resource_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_count is not None:
            result['ResourceCount'] = self.resource_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceCount') is not None:
            self.resource_count = m.get('ResourceCount')
        return self


class GetAggregateResourceCountsGroupByRegionResponseBody(TeaModel):
    def __init__(
        self,
        discovered_resource_counts_summary: List[GetAggregateResourceCountsGroupByRegionResponseBodyDiscoveredResourceCountsSummary] = None,
        request_id: str = None,
    ):
        # The ID of the region by which statistics are collected.
        self.discovered_resource_counts_summary = discovered_resource_counts_summary
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.discovered_resource_counts_summary:
            for k in self.discovered_resource_counts_summary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiscoveredResourceCountsSummary'] = []
        if self.discovered_resource_counts_summary is not None:
            for k in self.discovered_resource_counts_summary:
                result['DiscoveredResourceCountsSummary'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.discovered_resource_counts_summary = []
        if m.get('DiscoveredResourceCountsSummary') is not None:
            for k in m.get('DiscoveredResourceCountsSummary'):
                temp_model = GetAggregateResourceCountsGroupByRegionResponseBodyDiscoveredResourceCountsSummary()
                self.discovered_resource_counts_summary.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateResourceCountsGroupByRegionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateResourceCountsGroupByRegionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateResourceCountsGroupByRegionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateResourceCountsGroupByResourceTypeRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        folder_id: str = None,
        region: str = None,
        resource_account_id: int = None,
        resource_owner_id: int = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the folder in the resource directory.
        # 
        # For more information about how to obtain the ID of a folder, see [View the basic information of a folder](https://help.aliyun.com/document_detail/111223.html).
        self.folder_id = folder_id
        # The region ID.
        self.region = region
        # The ID of the Alibaba Cloud account to which the resources in the account group belong.
        # 
        # > You can specify either the ResourceAccountId or ResourceOwnerId parameter. We recommend that you specify the ResourceAccountId parameter.
        self.resource_account_id = resource_account_id
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_account_id is not None:
            result['ResourceAccountId'] = self.resource_account_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceAccountId') is not None:
            self.resource_account_id = m.get('ResourceAccountId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetAggregateResourceCountsGroupByResourceTypeResponseBodyDiscoveredResourceCountsSummary(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        resource_count: int = None,
        resource_type: str = None,
    ):
        # This parameter is expired. The resource type by which statistics are collected.
        self.group_name = group_name
        # The total number of resources in the region.
        self.resource_count = resource_count
        # The resource type by which statistics are collected.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.resource_count is not None:
            result['ResourceCount'] = self.resource_count
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('ResourceCount') is not None:
            self.resource_count = m.get('ResourceCount')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class GetAggregateResourceCountsGroupByResourceTypeResponseBody(TeaModel):
    def __init__(
        self,
        discovered_resource_counts_summary: List[GetAggregateResourceCountsGroupByResourceTypeResponseBodyDiscoveredResourceCountsSummary] = None,
        request_id: str = None,
    ):
        # The resource type by which the statistics are collected.
        self.discovered_resource_counts_summary = discovered_resource_counts_summary
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.discovered_resource_counts_summary:
            for k in self.discovered_resource_counts_summary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiscoveredResourceCountsSummary'] = []
        if self.discovered_resource_counts_summary is not None:
            for k in self.discovered_resource_counts_summary:
                result['DiscoveredResourceCountsSummary'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.discovered_resource_counts_summary = []
        if m.get('DiscoveredResourceCountsSummary') is not None:
            for k in m.get('DiscoveredResourceCountsSummary'):
                temp_model = GetAggregateResourceCountsGroupByResourceTypeResponseBodyDiscoveredResourceCountsSummary()
                self.discovered_resource_counts_summary.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregateResourceCountsGroupByResourceTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateResourceCountsGroupByResourceTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateResourceCountsGroupByResourceTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregateResourceInventoryRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        return self


class GetAggregateResourceInventoryResponseBodyResourceInventory(TeaModel):
    def __init__(
        self,
        download_url: str = None,
        resource_inventory_generate_time: int = None,
        status: str = None,
    ):
        # The download URL of the resource inventory.
        self.download_url = download_url
        # The time when the resource inventory was generated. The value is a timestamp.
        # 
        # Unit: milliseconds.
        self.resource_inventory_generate_time = resource_inventory_generate_time
        # The generation status of the resource inventory. Valid values:
        # 
        # *   CREATING: The resource inventory is being generated.
        # *   COMPLETE: The resource inventory is generated.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.resource_inventory_generate_time is not None:
            result['ResourceInventoryGenerateTime'] = self.resource_inventory_generate_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('ResourceInventoryGenerateTime') is not None:
            self.resource_inventory_generate_time = m.get('ResourceInventoryGenerateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetAggregateResourceInventoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_inventory: GetAggregateResourceInventoryResponseBodyResourceInventory = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The information about the resource inventory.
        self.resource_inventory = resource_inventory

    def validate(self):
        if self.resource_inventory:
            self.resource_inventory.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_inventory is not None:
            result['ResourceInventory'] = self.resource_inventory.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceInventory') is not None:
            temp_model = GetAggregateResourceInventoryResponseBodyResourceInventory()
            self.resource_inventory = temp_model.from_map(m['ResourceInventory'])
        return self


class GetAggregateResourceInventoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregateResourceInventoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregateResourceInventoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAggregatorRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
    ):
        # The ID of the account group.
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        return self


class GetAggregatorResponseBodyAggregatorAggregatorAccounts(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        account_name: str = None,
        account_type: str = None,
        recorder_status: str = None,
    ):
        # The ID of the member.
        self.account_id = account_id
        # The display name of the member.
        self.account_name = account_name
        # The resource directory to which the member belongs. Valid value: ResourceDirectory. ResourceDirectory indicates that the member belongs to a resource directory.
        self.account_type = account_type
        # The status of the configuration recorder for the member. Valid values:
        # 
        # *   REGISTRABLE: The configuration recorder is not registered.
        # *   BUILDING: The configuration recorder is being deployed.
        # *   REGISTERED: The configuration recorder is registered.
        # *   REBUILDING: The configuration recorder is being redeployed.
        self.recorder_status = recorder_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.recorder_status is not None:
            result['RecorderStatus'] = self.recorder_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('RecorderStatus') is not None:
            self.recorder_status = m.get('RecorderStatus')
        return self


class GetAggregatorResponseBodyAggregator(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        aggregator_account_count: int = None,
        aggregator_accounts: List[GetAggregatorResponseBodyAggregatorAggregatorAccounts] = None,
        aggregator_create_timestamp: str = None,
        aggregator_id: str = None,
        aggregator_name: str = None,
        aggregator_status: int = None,
        aggregator_type: str = None,
        description: str = None,
        folder_id: str = None,
    ):
        # The ID of the management account that is used to create the account group.
        self.account_id = account_id
        # The number of members in the account group.
        self.aggregator_account_count = aggregator_account_count
        # The information about the members in the account group.
        self.aggregator_accounts = aggregator_accounts
        # The timestamp generated when the account group was created.
        # 
        # Unit: milliseconds.
        self.aggregator_create_timestamp = aggregator_create_timestamp
        # The ID of the account group.
        self.aggregator_id = aggregator_id
        # The name of the account group.
        self.aggregator_name = aggregator_name
        # The status of the account group. Valid values:
        # 
        # *   0: The account group is being created.
        # *   1: The account group was created.
        self.aggregator_status = aggregator_status
        # The type of the account group. Valid values:
        # 
        # *   RD: a global account group.
        # *   FOLDER: an account group for a folder.
        # *   CUSTOM: a custom account group.
        self.aggregator_type = aggregator_type
        # The description of the account group.
        self.description = description
        # The ID of the attached folder of the account group.
        self.folder_id = folder_id

    def validate(self):
        if self.aggregator_accounts:
            for k in self.aggregator_accounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.aggregator_account_count is not None:
            result['AggregatorAccountCount'] = self.aggregator_account_count
        result['AggregatorAccounts'] = []
        if self.aggregator_accounts is not None:
            for k in self.aggregator_accounts:
                result['AggregatorAccounts'].append(k.to_map() if k else None)
        if self.aggregator_create_timestamp is not None:
            result['AggregatorCreateTimestamp'] = self.aggregator_create_timestamp
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.aggregator_name is not None:
            result['AggregatorName'] = self.aggregator_name
        if self.aggregator_status is not None:
            result['AggregatorStatus'] = self.aggregator_status
        if self.aggregator_type is not None:
            result['AggregatorType'] = self.aggregator_type
        if self.description is not None:
            result['Description'] = self.description
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AggregatorAccountCount') is not None:
            self.aggregator_account_count = m.get('AggregatorAccountCount')
        self.aggregator_accounts = []
        if m.get('AggregatorAccounts') is not None:
            for k in m.get('AggregatorAccounts'):
                temp_model = GetAggregatorResponseBodyAggregatorAggregatorAccounts()
                self.aggregator_accounts.append(temp_model.from_map(k))
        if m.get('AggregatorCreateTimestamp') is not None:
            self.aggregator_create_timestamp = m.get('AggregatorCreateTimestamp')
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('AggregatorName') is not None:
            self.aggregator_name = m.get('AggregatorName')
        if m.get('AggregatorStatus') is not None:
            self.aggregator_status = m.get('AggregatorStatus')
        if m.get('AggregatorType') is not None:
            self.aggregator_type = m.get('AggregatorType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class GetAggregatorResponseBody(TeaModel):
    def __init__(
        self,
        aggregator: GetAggregatorResponseBodyAggregator = None,
        request_id: str = None,
    ):
        # The details of the account group.
        self.aggregator = aggregator
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.aggregator:
            self.aggregator.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator is not None:
            result['Aggregator'] = self.aggregator.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Aggregator') is not None:
            temp_model = GetAggregatorResponseBodyAggregator()
            self.aggregator = temp_model.from_map(m['Aggregator'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAggregatorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAggregatorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAggregatorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCompliancePackRequest(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
    ):
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListCompliancePacks](https://help.aliyun.com/document_detail/263332.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        return self


class GetCompliancePackResponseBodyCompliancePackConfigRulesConfigRuleParameters(TeaModel):
    def __init__(
        self,
        parameter_name: str = None,
        parameter_value: str = None,
        required: bool = None,
    ):
        # The name of the input parameter.
        self.parameter_name = parameter_name
        # The value of the input parameter.
        self.parameter_value = parameter_value
        # Indicates whether the input parameters are required. Valid values:
        # 
        # *   true
        # *   false
        self.required = required

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_value is not None:
            result['ParameterValue'] = self.parameter_value
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterValue') is not None:
            self.parameter_value = m.get('ParameterValue')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class GetCompliancePackResponseBodyCompliancePackConfigRules(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        config_rule_name: str = None,
        config_rule_parameters: List[GetCompliancePackResponseBodyCompliancePackConfigRulesConfigRuleParameters] = None,
        description: str = None,
        managed_rule_identifier: str = None,
        resource_types_scope: str = None,
        risk_level: int = None,
    ):
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The rule name.
        self.config_rule_name = config_rule_name
        # The input parameters of the rule.
        self.config_rule_parameters = config_rule_parameters
        # The rule description.
        self.description = description
        # The identifier of the managed rule.
        self.managed_rule_identifier = managed_rule_identifier
        # The type of the resource evaluated based on the rule. Separate multiple resource types with commas (,).
        self.resource_types_scope = resource_types_scope
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high
        # *   2: medium
        # *   3: low
        self.risk_level = risk_level

    def validate(self):
        if self.config_rule_parameters:
            for k in self.config_rule_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        result['ConfigRuleParameters'] = []
        if self.config_rule_parameters is not None:
            for k in self.config_rule_parameters:
                result['ConfigRuleParameters'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.managed_rule_identifier is not None:
            result['ManagedRuleIdentifier'] = self.managed_rule_identifier
        if self.resource_types_scope is not None:
            result['ResourceTypesScope'] = self.resource_types_scope
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        self.config_rule_parameters = []
        if m.get('ConfigRuleParameters') is not None:
            for k in m.get('ConfigRuleParameters'):
                temp_model = GetCompliancePackResponseBodyCompliancePackConfigRulesConfigRuleParameters()
                self.config_rule_parameters.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ManagedRuleIdentifier') is not None:
            self.managed_rule_identifier = m.get('ManagedRuleIdentifier')
        if m.get('ResourceTypesScope') is not None:
            self.resource_types_scope = m.get('ResourceTypesScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class GetCompliancePackResponseBodyCompliancePackScopeExcludeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The tag key.
        self.tag_key = tag_key
        # The tag value.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class GetCompliancePackResponseBodyCompliancePackScopeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The tag key.
        self.tag_key = tag_key
        # The tag value.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class GetCompliancePackResponseBodyCompliancePackScope(TeaModel):
    def __init__(
        self,
        exclude_region_ids_scope: str = None,
        exclude_resource_group_ids_scope: str = None,
        exclude_resource_ids_scope: str = None,
        exclude_tags_scope: List[GetCompliancePackResponseBodyCompliancePackScopeExcludeTagsScope] = None,
        region_ids_scope: str = None,
        resource_group_ids_scope: str = None,
        resource_ids_scope: str = None,
        tag_key_scope: str = None,
        tag_value_scope: str = None,
        tags_scope: List[GetCompliancePackResponseBodyCompliancePackScopeTagsScope] = None,
    ):
        # Excluded region scope, multiple regions should be separated by commas.
        self.exclude_region_ids_scope = exclude_region_ids_scope
        # Excluded resourceGroup scope, multiple resourceGroup should be separated by commas.
        self.exclude_resource_group_ids_scope = exclude_resource_group_ids_scope
        # The ID of the resource that you do not want to evaluate by using the compliance package.
        self.exclude_resource_ids_scope = exclude_resource_ids_scope
        # Exclude tag scope.
        # 
        # This parameter is required.
        self.exclude_tags_scope = exclude_tags_scope
        # The ID of the region whose resources you want to evaluate by using the compliance package.
        self.region_ids_scope = region_ids_scope
        # The ID of the resource group whose resources you want to evaluate by using the compliance package.
        self.resource_group_ids_scope = resource_group_ids_scope
        # Include ResourceId scope, multiple resourceIds should be separated by commas.
        self.resource_ids_scope = resource_ids_scope
        # The tag key of the resource that you want to evaluate by using the compliance package.
        self.tag_key_scope = tag_key_scope
        # The tag value of the resource that you want to evaluate by using the compliance package.
        self.tag_value_scope = tag_value_scope
        # Include tag scope.
        # 
        # This parameter is required.
        self.tags_scope = tags_scope

    def validate(self):
        if self.exclude_tags_scope:
            for k in self.exclude_tags_scope:
                if k:
                    k.validate()
        if self.tags_scope:
            for k in self.tags_scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_region_ids_scope is not None:
            result['ExcludeRegionIdsScope'] = self.exclude_region_ids_scope
        if self.exclude_resource_group_ids_scope is not None:
            result['ExcludeResourceGroupIdsScope'] = self.exclude_resource_group_ids_scope
        if self.exclude_resource_ids_scope is not None:
            result['ExcludeResourceIdsScope'] = self.exclude_resource_ids_scope
        result['ExcludeTagsScope'] = []
        if self.exclude_tags_scope is not None:
            for k in self.exclude_tags_scope:
                result['ExcludeTagsScope'].append(k.to_map() if k else None)
        if self.region_ids_scope is not None:
            result['RegionIdsScope'] = self.region_ids_scope
        if self.resource_group_ids_scope is not None:
            result['ResourceGroupIdsScope'] = self.resource_group_ids_scope
        if self.resource_ids_scope is not None:
            result['ResourceIdsScope'] = self.resource_ids_scope
        if self.tag_key_scope is not None:
            result['TagKeyScope'] = self.tag_key_scope
        if self.tag_value_scope is not None:
            result['TagValueScope'] = self.tag_value_scope
        result['TagsScope'] = []
        if self.tags_scope is not None:
            for k in self.tags_scope:
                result['TagsScope'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeRegionIdsScope') is not None:
            self.exclude_region_ids_scope = m.get('ExcludeRegionIdsScope')
        if m.get('ExcludeResourceGroupIdsScope') is not None:
            self.exclude_resource_group_ids_scope = m.get('ExcludeResourceGroupIdsScope')
        if m.get('ExcludeResourceIdsScope') is not None:
            self.exclude_resource_ids_scope = m.get('ExcludeResourceIdsScope')
        self.exclude_tags_scope = []
        if m.get('ExcludeTagsScope') is not None:
            for k in m.get('ExcludeTagsScope'):
                temp_model = GetCompliancePackResponseBodyCompliancePackScopeExcludeTagsScope()
                self.exclude_tags_scope.append(temp_model.from_map(k))
        if m.get('RegionIdsScope') is not None:
            self.region_ids_scope = m.get('RegionIdsScope')
        if m.get('ResourceGroupIdsScope') is not None:
            self.resource_group_ids_scope = m.get('ResourceGroupIdsScope')
        if m.get('ResourceIdsScope') is not None:
            self.resource_ids_scope = m.get('ResourceIdsScope')
        if m.get('TagKeyScope') is not None:
            self.tag_key_scope = m.get('TagKeyScope')
        if m.get('TagValueScope') is not None:
            self.tag_value_scope = m.get('TagValueScope')
        self.tags_scope = []
        if m.get('TagsScope') is not None:
            for k in m.get('TagsScope'):
                temp_model = GetCompliancePackResponseBodyCompliancePackScopeTagsScope()
                self.tags_scope.append(temp_model.from_map(k))
        return self


class GetCompliancePackResponseBodyCompliancePack(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        compliance_pack_id: str = None,
        compliance_pack_name: str = None,
        compliance_pack_template_id: str = None,
        config_rules: List[GetCompliancePackResponseBodyCompliancePackConfigRules] = None,
        create_timestamp: int = None,
        description: str = None,
        risk_level: int = None,
        scope: GetCompliancePackResponseBodyCompliancePackScope = None,
        status: str = None,
        template_content: str = None,
    ):
        # The ID of the Alibaba Cloud account to which the compliance package belongs.
        self.account_id = account_id
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The name of the compliance package.
        self.compliance_pack_name = compliance_pack_name
        # The ID of the compliance package template.
        self.compliance_pack_template_id = compliance_pack_template_id
        # The rules in the compliance package.
        self.config_rules = config_rules
        # The timestamp when the compliance package was created. Unit: milliseconds.
        self.create_timestamp = create_timestamp
        # The description of the compliance package.
        self.description = description
        # The risk level of the resources that are not compliant with the rules in the compliance package. Valid values:
        # 
        # *   1: high
        # *   2: medium
        # *   3: low
        self.risk_level = risk_level
        # The resource group for which the compliance package took effect.
        self.scope = scope
        # The status of the compliance package. Valid values:
        # 
        # *   ACTIVE: The compliance package is normal.
        # *   CREATING: The compliance package is being created.
        self.status = status
        # The information about the current compliance package template. The rules in the template do not contain custom function rules. You can quickly create the same compliance package for other accounts or account groups based on the template information.
        self.template_content = template_content

    def validate(self):
        if self.config_rules:
            for k in self.config_rules:
                if k:
                    k.validate()
        if self.scope:
            self.scope.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.compliance_pack_name is not None:
            result['CompliancePackName'] = self.compliance_pack_name
        if self.compliance_pack_template_id is not None:
            result['CompliancePackTemplateId'] = self.compliance_pack_template_id
        result['ConfigRules'] = []
        if self.config_rules is not None:
            for k in self.config_rules:
                result['ConfigRules'].append(k.to_map() if k else None)
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.description is not None:
            result['Description'] = self.description
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.scope is not None:
            result['Scope'] = self.scope.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.template_content is not None:
            result['TemplateContent'] = self.template_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('CompliancePackName') is not None:
            self.compliance_pack_name = m.get('CompliancePackName')
        if m.get('CompliancePackTemplateId') is not None:
            self.compliance_pack_template_id = m.get('CompliancePackTemplateId')
        self.config_rules = []
        if m.get('ConfigRules') is not None:
            for k in m.get('ConfigRules'):
                temp_model = GetCompliancePackResponseBodyCompliancePackConfigRules()
                self.config_rules.append(temp_model.from_map(k))
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('Scope') is not None:
            temp_model = GetCompliancePackResponseBodyCompliancePackScope()
            self.scope = temp_model.from_map(m['Scope'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateContent') is not None:
            self.template_content = m.get('TemplateContent')
        return self


class GetCompliancePackResponseBody(TeaModel):
    def __init__(
        self,
        compliance_pack: GetCompliancePackResponseBodyCompliancePack = None,
        request_id: str = None,
    ):
        # The details of the compliance package.
        self.compliance_pack = compliance_pack
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.compliance_pack:
            self.compliance_pack.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack is not None:
            result['CompliancePack'] = self.compliance_pack.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePack') is not None:
            temp_model = GetCompliancePackResponseBodyCompliancePack()
            self.compliance_pack = temp_model.from_map(m['CompliancePack'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCompliancePackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCompliancePackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCompliancePackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCompliancePackReportRequest(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
    ):
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListCompliancePacks](https://help.aliyun.com/document_detail/263332.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        return self


class GetCompliancePackReportResponseBodyCompliancePackReport(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        compliance_pack_id: str = None,
        report_create_timestamp: int = None,
        report_status: str = None,
        report_url: str = None,
    ):
        # The ID of the Alibaba Cloud account to which the compliance package belongs.
        self.account_id = account_id
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The timestamp when the compliance evaluation report was generated. Unit: milliseconds.
        self.report_create_timestamp = report_create_timestamp
        # The status of the compliance evaluation report. Valid values:
        # 
        # *   NONE: The compliance evaluation report is not generated.
        # *   CREATING: The compliance evaluation report is being generated.
        # *   COMPLETE: The compliance evaluation report is generated.
        self.report_status = report_status
        # The URL that is used to download the compliance evaluation report.
        self.report_url = report_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.report_create_timestamp is not None:
            result['ReportCreateTimestamp'] = self.report_create_timestamp
        if self.report_status is not None:
            result['ReportStatus'] = self.report_status
        if self.report_url is not None:
            result['ReportUrl'] = self.report_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ReportCreateTimestamp') is not None:
            self.report_create_timestamp = m.get('ReportCreateTimestamp')
        if m.get('ReportStatus') is not None:
            self.report_status = m.get('ReportStatus')
        if m.get('ReportUrl') is not None:
            self.report_url = m.get('ReportUrl')
        return self


class GetCompliancePackReportResponseBody(TeaModel):
    def __init__(
        self,
        compliance_pack_report: GetCompliancePackReportResponseBodyCompliancePackReport = None,
        request_id: str = None,
    ):
        # The information about the compliance evaluation report.
        self.compliance_pack_report = compliance_pack_report
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.compliance_pack_report:
            self.compliance_pack_report.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_report is not None:
            result['CompliancePackReport'] = self.compliance_pack_report.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackReport') is not None:
            temp_model = GetCompliancePackReportResponseBodyCompliancePackReport()
            self.compliance_pack_report = temp_model.from_map(m['CompliancePackReport'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetCompliancePackReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCompliancePackReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCompliancePackReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetComplianceSummaryResponseBodyComplianceSummaryComplianceSummaryByConfigRule(TeaModel):
    def __init__(
        self,
        compliance_summary_timestamp: int = None,
        compliant_count: int = None,
        non_compliant_count: int = None,
        total_count: int = None,
    ):
        # The time when the compliance summary was generated. Unit: milliseconds.
        self.compliance_summary_timestamp = compliance_summary_timestamp
        # The number of rules evaluated as compliant.
        self.compliant_count = compliant_count
        # The number of rules evaluated as non-compliant.
        self.non_compliant_count = non_compliant_count
        # The total number of rules.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_summary_timestamp is not None:
            result['ComplianceSummaryTimestamp'] = self.compliance_summary_timestamp
        if self.compliant_count is not None:
            result['CompliantCount'] = self.compliant_count
        if self.non_compliant_count is not None:
            result['NonCompliantCount'] = self.non_compliant_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceSummaryTimestamp') is not None:
            self.compliance_summary_timestamp = m.get('ComplianceSummaryTimestamp')
        if m.get('CompliantCount') is not None:
            self.compliant_count = m.get('CompliantCount')
        if m.get('NonCompliantCount') is not None:
            self.non_compliant_count = m.get('NonCompliantCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetComplianceSummaryResponseBodyComplianceSummaryComplianceSummaryByResource(TeaModel):
    def __init__(
        self,
        compliance_summary_timestamp: int = None,
        compliant_count: int = None,
        non_compliant_count: int = None,
        total_count: int = None,
    ):
        # The time when the compliance summary was generated. Unit: milliseconds.
        self.compliance_summary_timestamp = compliance_summary_timestamp
        # The number of resources evaluated as compliant.
        self.compliant_count = compliant_count
        # The number of resources evaluated as non-compliant.
        self.non_compliant_count = non_compliant_count
        # The total number of resources.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_summary_timestamp is not None:
            result['ComplianceSummaryTimestamp'] = self.compliance_summary_timestamp
        if self.compliant_count is not None:
            result['CompliantCount'] = self.compliant_count
        if self.non_compliant_count is not None:
            result['NonCompliantCount'] = self.non_compliant_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceSummaryTimestamp') is not None:
            self.compliance_summary_timestamp = m.get('ComplianceSummaryTimestamp')
        if m.get('CompliantCount') is not None:
            self.compliant_count = m.get('CompliantCount')
        if m.get('NonCompliantCount') is not None:
            self.non_compliant_count = m.get('NonCompliantCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetComplianceSummaryResponseBodyComplianceSummary(TeaModel):
    def __init__(
        self,
        compliance_summary_by_config_rule: GetComplianceSummaryResponseBodyComplianceSummaryComplianceSummaryByConfigRule = None,
        compliance_summary_by_resource: GetComplianceSummaryResponseBodyComplianceSummaryComplianceSummaryByResource = None,
    ):
        # The summary of compliance statistics from the rule dimension.
        self.compliance_summary_by_config_rule = compliance_summary_by_config_rule
        # The summary of compliance statistics from the resource dimension.
        self.compliance_summary_by_resource = compliance_summary_by_resource

    def validate(self):
        if self.compliance_summary_by_config_rule:
            self.compliance_summary_by_config_rule.validate()
        if self.compliance_summary_by_resource:
            self.compliance_summary_by_resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_summary_by_config_rule is not None:
            result['ComplianceSummaryByConfigRule'] = self.compliance_summary_by_config_rule.to_map()
        if self.compliance_summary_by_resource is not None:
            result['ComplianceSummaryByResource'] = self.compliance_summary_by_resource.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceSummaryByConfigRule') is not None:
            temp_model = GetComplianceSummaryResponseBodyComplianceSummaryComplianceSummaryByConfigRule()
            self.compliance_summary_by_config_rule = temp_model.from_map(m['ComplianceSummaryByConfigRule'])
        if m.get('ComplianceSummaryByResource') is not None:
            temp_model = GetComplianceSummaryResponseBodyComplianceSummaryComplianceSummaryByResource()
            self.compliance_summary_by_resource = temp_model.from_map(m['ComplianceSummaryByResource'])
        return self


class GetComplianceSummaryResponseBody(TeaModel):
    def __init__(
        self,
        compliance_summary: GetComplianceSummaryResponseBodyComplianceSummary = None,
        request_id: str = None,
    ):
        # The summary of compliance statistics.
        self.compliance_summary = compliance_summary
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.compliance_summary:
            self.compliance_summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_summary is not None:
            result['ComplianceSummary'] = self.compliance_summary.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceSummary') is not None:
            temp_model = GetComplianceSummaryResponseBodyComplianceSummary()
            self.compliance_summary = temp_model.from_map(m['ComplianceSummary'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetComplianceSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetComplianceSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetComplianceSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigDeliveryChannelRequest(TeaModel):
    def __init__(
        self,
        delivery_channel_id: str = None,
    ):
        # The ID of the delivery channel.
        # 
        # For more information about how to obtain the ID of a delivery channel, see [DescribeDeliveryChannels](https://help.aliyun.com/document_detail/429841.html).
        # 
        # This parameter is required.
        self.delivery_channel_id = delivery_channel_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_channel_id is not None:
            result['DeliveryChannelId'] = self.delivery_channel_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryChannelId') is not None:
            self.delivery_channel_id = m.get('DeliveryChannelId')
        return self


class GetConfigDeliveryChannelResponseBodyDeliveryChannel(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        compliant_snapshot: bool = None,
        configuration_item_change_notification: bool = None,
        configuration_snapshot: bool = None,
        delivery_channel_assume_role_arn: str = None,
        delivery_channel_condition: str = None,
        delivery_channel_id: str = None,
        delivery_channel_name: str = None,
        delivery_channel_target_arn: str = None,
        delivery_channel_type: str = None,
        delivery_snapshot_time: str = None,
        description: str = None,
        non_compliant_notification: bool = None,
        oversized_data_osstarget_arn: str = None,
        status: int = None,
    ):
        # The ID of your Alibaba Cloud account.
        self.account_id = account_id
        # Indicates whether the specified destination receives scheduled compliant snapshots. Cloud Config delivers scheduled compliant snapshots at `04:00Z` and `16:00Z` to Log Service every day. The time is displayed in UTC. Valid values:
        # 
        # *   true: The specified destination receives scheduled compliant snapshots.
        # *   false: The specified destination does not receive scheduled compliant snapshots.
        self.compliant_snapshot = compliant_snapshot
        # Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:
        # 
        # *   true: The specified destination receives resource change logs.
        # *   false: The specified destination does not receive resource change logs.
        self.configuration_item_change_notification = configuration_item_change_notification
        # Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at `04:00Z` and `16:00Z` to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:
        # 
        # *   true: The specified destination receives scheduled resource snapshots.
        # *   false: The specified destination does not receive scheduled resource snapshots.
        self.configuration_snapshot = configuration_snapshot
        # The Alibaba Cloud Resource Name (ARN) of the role assumed by the delivery channel.
        self.delivery_channel_assume_role_arn = delivery_channel_assume_role_arn
        # The rule that is attached to the delivery channel. This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
        # 
        # *   If the value of the DeliveryChannelType parameter is MNS, take note of the following settings of the lowest risk level and resource types of the events to which you subscribed:
        # 
        #     *   The setting of the lowest risk level for the events to which you want to subscribe is in the following format: `{"filterType":"RuleRiskLevel","value":"1","multiple":false}`.
        # 
        #         The `value` field indicates the lowest risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
        # 
        #     *   The setting of the resource types of the events to which you want to subscribe is in the following format: `{"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}`.
        # 
        #         The `values` field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array. Examples:
        # 
        # `[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}]`
        # 
        # *   If you set the DeliveryChannelType parameter to SLS, the setting of the resource types of the snapshots to which you want to deliver is in the following format: `{"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}`.
        # 
        #     The `values` field specifies the resource types of the snapshots to which you want to deliver. The value of the field is a JSON array. Examples:
        # 
        # `[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}]`
        self.delivery_channel_condition = delivery_channel_condition
        # The ID of the delivery channel.
        self.delivery_channel_id = delivery_channel_id
        # The name of the delivery channel.
        self.delivery_channel_name = delivery_channel_name
        # The Alibaba Cloud Resource Name (ARN) of the delivery destination.
        # 
        # *   If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
        # *   If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
        # *   If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        self.delivery_channel_target_arn = delivery_channel_target_arn
        # The type of the delivery channel. Valid values:
        # 
        # *   OSS: Object Storage Service (OSS)
        # *   MNS: Message Service (MNS)
        # *   SLS: Log Service
        self.delivery_channel_type = delivery_channel_type
        # The time when Cloud Config delivers scheduled resources snapshots every day.
        # 
        # Format: `HH:mmZ`. This time is displayed in UTC.
        self.delivery_snapshot_time = delivery_snapshot_time
        # The description of the delivery channel.
        self.description = description
        # Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:
        # 
        # *   true: The specified destination receives resource non-compliance events.
        # *   false: The specified destination does not receive resource non-compliance events.
        self.non_compliant_notification = non_compliant_notification
        # The ARN of the OSS bucket to which you want to transfer the delivery data when the size of the data exceeds the specified upper limit of the delivery channel.
        self.oversized_data_osstarget_arn = oversized_data_osstarget_arn
        # The status of the delivery channel. Valid values:
        # 
        # *   0: The delivery channel is disabled.
        # *   1: The delivery channel is enabled.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.compliant_snapshot is not None:
            result['CompliantSnapshot'] = self.compliant_snapshot
        if self.configuration_item_change_notification is not None:
            result['ConfigurationItemChangeNotification'] = self.configuration_item_change_notification
        if self.configuration_snapshot is not None:
            result['ConfigurationSnapshot'] = self.configuration_snapshot
        if self.delivery_channel_assume_role_arn is not None:
            result['DeliveryChannelAssumeRoleArn'] = self.delivery_channel_assume_role_arn
        if self.delivery_channel_condition is not None:
            result['DeliveryChannelCondition'] = self.delivery_channel_condition
        if self.delivery_channel_id is not None:
            result['DeliveryChannelId'] = self.delivery_channel_id
        if self.delivery_channel_name is not None:
            result['DeliveryChannelName'] = self.delivery_channel_name
        if self.delivery_channel_target_arn is not None:
            result['DeliveryChannelTargetArn'] = self.delivery_channel_target_arn
        if self.delivery_channel_type is not None:
            result['DeliveryChannelType'] = self.delivery_channel_type
        if self.delivery_snapshot_time is not None:
            result['DeliverySnapshotTime'] = self.delivery_snapshot_time
        if self.description is not None:
            result['Description'] = self.description
        if self.non_compliant_notification is not None:
            result['NonCompliantNotification'] = self.non_compliant_notification
        if self.oversized_data_osstarget_arn is not None:
            result['OversizedDataOSSTargetArn'] = self.oversized_data_osstarget_arn
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('CompliantSnapshot') is not None:
            self.compliant_snapshot = m.get('CompliantSnapshot')
        if m.get('ConfigurationItemChangeNotification') is not None:
            self.configuration_item_change_notification = m.get('ConfigurationItemChangeNotification')
        if m.get('ConfigurationSnapshot') is not None:
            self.configuration_snapshot = m.get('ConfigurationSnapshot')
        if m.get('DeliveryChannelAssumeRoleArn') is not None:
            self.delivery_channel_assume_role_arn = m.get('DeliveryChannelAssumeRoleArn')
        if m.get('DeliveryChannelCondition') is not None:
            self.delivery_channel_condition = m.get('DeliveryChannelCondition')
        if m.get('DeliveryChannelId') is not None:
            self.delivery_channel_id = m.get('DeliveryChannelId')
        if m.get('DeliveryChannelName') is not None:
            self.delivery_channel_name = m.get('DeliveryChannelName')
        if m.get('DeliveryChannelTargetArn') is not None:
            self.delivery_channel_target_arn = m.get('DeliveryChannelTargetArn')
        if m.get('DeliveryChannelType') is not None:
            self.delivery_channel_type = m.get('DeliveryChannelType')
        if m.get('DeliverySnapshotTime') is not None:
            self.delivery_snapshot_time = m.get('DeliverySnapshotTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NonCompliantNotification') is not None:
            self.non_compliant_notification = m.get('NonCompliantNotification')
        if m.get('OversizedDataOSSTargetArn') is not None:
            self.oversized_data_osstarget_arn = m.get('OversizedDataOSSTargetArn')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetConfigDeliveryChannelResponseBody(TeaModel):
    def __init__(
        self,
        delivery_channel: GetConfigDeliveryChannelResponseBodyDeliveryChannel = None,
        request_id: str = None,
    ):
        # The information about the delivery channel.
        self.delivery_channel = delivery_channel
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.delivery_channel:
            self.delivery_channel.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_channel is not None:
            result['DeliveryChannel'] = self.delivery_channel.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryChannel') is not None:
            temp_model = GetConfigDeliveryChannelResponseBodyDeliveryChannel()
            self.delivery_channel = temp_model.from_map(m['DeliveryChannel'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetConfigDeliveryChannelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetConfigDeliveryChannelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetConfigDeliveryChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigRuleRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetConfigRuleRequest(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        tag: List[GetConfigRuleRequestTag] = None,
    ):
        # The rule ID.
        # 
        # For more information about how to obtain the ID of a rule, see [ListConfigRules](https://help.aliyun.com/document_detail/169607.html).
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = GetConfigRuleRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class GetConfigRuleShrinkRequest(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        tag_shrink: str = None,
    ):
        # The rule ID.
        # 
        # For more information about how to obtain the ID of a rule, see [ListConfigRules](https://help.aliyun.com/document_detail/169607.html).
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id
        self.tag_shrink = tag_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.tag_shrink is not None:
            result['Tag'] = self.tag_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('Tag') is not None:
            self.tag_shrink = m.get('Tag')
        return self


class GetConfigRuleResponseBodyConfigRuleCompliance(TeaModel):
    def __init__(
        self,
        compliance_type: str = None,
        count: int = None,
    ):
        # The statistics on the compliance evaluation results by compliance type. Valid values:
        # 
        # *   COMPLIANT: The resource was evaluated as compliant.
        # *   NON_COMPLIANT: The resource was evaluated as incompliant.
        # *   NOT_APPLICABLE: The rule did not apply to your resource.
        # *   INSUFFICIENT_DATA: No resource data was available.
        self.compliance_type = compliance_type
        # The number of evaluated resources.
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetConfigRuleResponseBodyConfigRuleConfigRuleEvaluationStatus(TeaModel):
    def __init__(
        self,
        first_activated_timestamp: int = None,
        first_evaluation_started: bool = None,
        last_error_code: str = None,
        last_error_message: str = None,
        last_failed_evaluation_timestamp: int = None,
        last_failed_invocation_timestamp: int = None,
        last_successful_evaluation_timestamp: int = None,
        last_successful_invocation_timestamp: int = None,
    ):
        # The timestamp generated when the rule was first triggered. Unit: millisecond.
        self.first_activated_timestamp = first_activated_timestamp
        # Indicates whether resource configurations were evaluated based on the rule. Valid values:
        # 
        # *   true: Resource configurations were evaluated based on the rule.
        # *   false: Resource configurations were not evaluated based on the rule.
        self.first_evaluation_started = first_evaluation_started
        # The error code returned for the previous failed compliance evaluation.
        self.last_error_code = last_error_code
        # The error message returned for the previous failed compliance evaluation.
        self.last_error_message = last_error_message
        # The timestamp generated when the previous failed compliance evaluation of the rule ended. Unit: millisecond.
        self.last_failed_evaluation_timestamp = last_failed_evaluation_timestamp
        # The timestamp generated when the previous failed compliance evaluation of the rule started. Unit: millisecond.
        self.last_failed_invocation_timestamp = last_failed_invocation_timestamp
        # The timestamp generated when the previous successful compliance evaluation of the rule ended. Unit: millisecond.
        self.last_successful_evaluation_timestamp = last_successful_evaluation_timestamp
        # The timestamp generated when the previous successful compliance evaluation of the rule started. Unit: millisecond.
        self.last_successful_invocation_timestamp = last_successful_invocation_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.first_activated_timestamp is not None:
            result['FirstActivatedTimestamp'] = self.first_activated_timestamp
        if self.first_evaluation_started is not None:
            result['FirstEvaluationStarted'] = self.first_evaluation_started
        if self.last_error_code is not None:
            result['LastErrorCode'] = self.last_error_code
        if self.last_error_message is not None:
            result['LastErrorMessage'] = self.last_error_message
        if self.last_failed_evaluation_timestamp is not None:
            result['LastFailedEvaluationTimestamp'] = self.last_failed_evaluation_timestamp
        if self.last_failed_invocation_timestamp is not None:
            result['LastFailedInvocationTimestamp'] = self.last_failed_invocation_timestamp
        if self.last_successful_evaluation_timestamp is not None:
            result['LastSuccessfulEvaluationTimestamp'] = self.last_successful_evaluation_timestamp
        if self.last_successful_invocation_timestamp is not None:
            result['LastSuccessfulInvocationTimestamp'] = self.last_successful_invocation_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirstActivatedTimestamp') is not None:
            self.first_activated_timestamp = m.get('FirstActivatedTimestamp')
        if m.get('FirstEvaluationStarted') is not None:
            self.first_evaluation_started = m.get('FirstEvaluationStarted')
        if m.get('LastErrorCode') is not None:
            self.last_error_code = m.get('LastErrorCode')
        if m.get('LastErrorMessage') is not None:
            self.last_error_message = m.get('LastErrorMessage')
        if m.get('LastFailedEvaluationTimestamp') is not None:
            self.last_failed_evaluation_timestamp = m.get('LastFailedEvaluationTimestamp')
        if m.get('LastFailedInvocationTimestamp') is not None:
            self.last_failed_invocation_timestamp = m.get('LastFailedInvocationTimestamp')
        if m.get('LastSuccessfulEvaluationTimestamp') is not None:
            self.last_successful_evaluation_timestamp = m.get('LastSuccessfulEvaluationTimestamp')
        if m.get('LastSuccessfulInvocationTimestamp') is not None:
            self.last_successful_invocation_timestamp = m.get('LastSuccessfulInvocationTimestamp')
        return self


class GetConfigRuleResponseBodyConfigRuleCreateBy(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        compliance_pack_name: str = None,
        creator_id: str = None,
        creator_name: str = None,
    ):
        # The compliance package ID.
        self.compliance_pack_id = compliance_pack_id
        # The name of the compliance package.
        self.compliance_pack_name = compliance_pack_name
        # The ID of the account that was used to create the rule.
        self.creator_id = creator_id
        # The name of the account that was used to create the rule.
        self.creator_name = creator_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.compliance_pack_name is not None:
            result['CompliancePackName'] = self.compliance_pack_name
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('CompliancePackName') is not None:
            self.compliance_pack_name = m.get('CompliancePackName')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        return self


class GetConfigRuleResponseBodyConfigRuleExcludeTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The tag key.
        self.tag_key = tag_key
        # The tag value.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class GetConfigRuleResponseBodyConfigRuleManagedRuleSourceDetails(TeaModel):
    def __init__(
        self,
        event_source: str = None,
        maximum_execution_frequency: str = None,
        message_type: str = None,
    ):
        # The event source.
        # 
        # >  Only aliyun.config is returned, which indicates that only events related to Cloud Config are supported.
        self.event_source = event_source
        # The interval at which the rule is triggered. Valid values:
        # 
        # *   One_Hour
        # *   Three_Hours
        # *   Six_Hours
        # *   Twelve_Hours
        # *   TwentyFour_Hours
        # 
        # >  This parameter is returned if the rule is periodically triggered.
        self.maximum_execution_frequency = maximum_execution_frequency
        # The trigger type of the rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The rule is triggered by configuration changes.
        # *   ScheduledNotification: The rule is periodically triggered.
        self.message_type = message_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_source is not None:
            result['EventSource'] = self.event_source
        if self.maximum_execution_frequency is not None:
            result['MaximumExecutionFrequency'] = self.maximum_execution_frequency
        if self.message_type is not None:
            result['MessageType'] = self.message_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventSource') is not None:
            self.event_source = m.get('EventSource')
        if m.get('MaximumExecutionFrequency') is not None:
            self.maximum_execution_frequency = m.get('MaximumExecutionFrequency')
        if m.get('MessageType') is not None:
            self.message_type = m.get('MessageType')
        return self


class GetConfigRuleResponseBodyConfigRuleManagedRule(TeaModel):
    def __init__(
        self,
        compulsory_input_parameter_details: Dict[str, Any] = None,
        description: str = None,
        identifier: str = None,
        labels: List[str] = None,
        managed_rule_name: str = None,
        optional_input_parameter_details: Dict[str, Any] = None,
        source_details: List[GetConfigRuleResponseBodyConfigRuleManagedRuleSourceDetails] = None,
    ):
        # The settings of the required input parameters for the managed rule.
        self.compulsory_input_parameter_details = compulsory_input_parameter_details
        # The description of the managed rule.
        self.description = description
        # The identifier of the managed rule.
        self.identifier = identifier
        # The rule tags.
        self.labels = labels
        # The name of the managed rule.
        self.managed_rule_name = managed_rule_name
        # The settings of the optional input parameters for the managed rule.
        self.optional_input_parameter_details = optional_input_parameter_details
        # The details of the source of the managed rule.
        self.source_details = source_details

    def validate(self):
        if self.source_details:
            for k in self.source_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compulsory_input_parameter_details is not None:
            result['CompulsoryInputParameterDetails'] = self.compulsory_input_parameter_details
        if self.description is not None:
            result['Description'] = self.description
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.managed_rule_name is not None:
            result['ManagedRuleName'] = self.managed_rule_name
        if self.optional_input_parameter_details is not None:
            result['OptionalInputParameterDetails'] = self.optional_input_parameter_details
        result['SourceDetails'] = []
        if self.source_details is not None:
            for k in self.source_details:
                result['SourceDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompulsoryInputParameterDetails') is not None:
            self.compulsory_input_parameter_details = m.get('CompulsoryInputParameterDetails')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('ManagedRuleName') is not None:
            self.managed_rule_name = m.get('ManagedRuleName')
        if m.get('OptionalInputParameterDetails') is not None:
            self.optional_input_parameter_details = m.get('OptionalInputParameterDetails')
        self.source_details = []
        if m.get('SourceDetails') is not None:
            for k in m.get('SourceDetails'):
                temp_model = GetConfigRuleResponseBodyConfigRuleManagedRuleSourceDetails()
                self.source_details.append(temp_model.from_map(k))
        return self


class GetConfigRuleResponseBodyConfigRuleScope(TeaModel):
    def __init__(
        self,
        compliance_resource_types: List[str] = None,
    ):
        # The types of the resources to be evaluated against the rule. You can also view the resource types by using the ResourceTypesScope parameter.
        self.compliance_resource_types = compliance_resource_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_resource_types is not None:
            result['ComplianceResourceTypes'] = self.compliance_resource_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceResourceTypes') is not None:
            self.compliance_resource_types = m.get('ComplianceResourceTypes')
        return self


class GetConfigRuleResponseBodyConfigRuleSourceSourceDetails(TeaModel):
    def __init__(
        self,
        event_source: str = None,
        maximum_execution_frequency: str = None,
        message_type: str = None,
    ):
        # The event source.
        # 
        # >  Only aliyun.config is returned, which indicates that only events related to Cloud Config are supported.
        self.event_source = event_source
        # The interval at which the rule is triggered. Valid values:
        # 
        # *   One_Hour
        # *   Three_Hours
        # *   Six_Hours
        # *   Twelve_Hours
        # *   TwentyFour_Hours
        # 
        # >  This parameter is returned if the rule is periodically triggered.
        self.maximum_execution_frequency = maximum_execution_frequency
        # The trigger type of the rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The rule is triggered by configuration changes.
        # *   ScheduledNotification: The rule is periodically triggered.
        self.message_type = message_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_source is not None:
            result['EventSource'] = self.event_source
        if self.maximum_execution_frequency is not None:
            result['MaximumExecutionFrequency'] = self.maximum_execution_frequency
        if self.message_type is not None:
            result['MessageType'] = self.message_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventSource') is not None:
            self.event_source = m.get('EventSource')
        if m.get('MaximumExecutionFrequency') is not None:
            self.maximum_execution_frequency = m.get('MaximumExecutionFrequency')
        if m.get('MessageType') is not None:
            self.message_type = m.get('MessageType')
        return self


class GetConfigRuleResponseBodyConfigRuleSource(TeaModel):
    def __init__(
        self,
        identifier: str = None,
        owner: str = None,
        source_details: List[GetConfigRuleResponseBodyConfigRuleSourceSourceDetails] = None,
    ):
        # The identifier of the rule.
        # 
        # *   If the rule is a managed rule, the value of this parameter is the identifier of the managed rule.
        # *   If the rule is a custom rule, the value of this parameter is the Alibaba Cloud Resource Name (ARN) of a function.
        self.identifier = identifier
        # The type of the rule. Valid values:
        # 
        # *   CUSTOM_FC: a custom rule.
        # *   ALIYUN: a managed rule.
        self.owner = owner
        # The details of the source of the rule.
        self.source_details = source_details

    def validate(self):
        if self.source_details:
            for k in self.source_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.owner is not None:
            result['Owner'] = self.owner
        result['SourceDetails'] = []
        if self.source_details is not None:
            for k in self.source_details:
                result['SourceDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        self.source_details = []
        if m.get('SourceDetails') is not None:
            for k in m.get('SourceDetails'):
                temp_model = GetConfigRuleResponseBodyConfigRuleSourceSourceDetails()
                self.source_details.append(temp_model.from_map(k))
        return self


class GetConfigRuleResponseBodyConfigRuleTags(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class GetConfigRuleResponseBodyConfigRuleTagsScope(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # TagKey
        self.tag_key = tag_key
        # TagValue
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class GetConfigRuleResponseBodyConfigRule(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        compliance: GetConfigRuleResponseBodyConfigRuleCompliance = None,
        config_rule_arn: str = None,
        config_rule_evaluation_status: GetConfigRuleResponseBodyConfigRuleConfigRuleEvaluationStatus = None,
        config_rule_id: str = None,
        config_rule_name: str = None,
        config_rule_state: str = None,
        config_rule_trigger_types: str = None,
        create_by: GetConfigRuleResponseBodyConfigRuleCreateBy = None,
        create_timestamp: int = None,
        description: str = None,
        exclude_region_ids_scope: str = None,
        exclude_resource_group_ids_scope: str = None,
        exclude_resource_ids_scope: str = None,
        exclude_tags_scope: List[GetConfigRuleResponseBodyConfigRuleExcludeTagsScope] = None,
        extend_content: str = None,
        input_parameters: Dict[str, Any] = None,
        managed_rule: GetConfigRuleResponseBodyConfigRuleManagedRule = None,
        maximum_execution_frequency: str = None,
        modified_timestamp: int = None,
        region_ids_scope: str = None,
        resource_group_ids_scope: str = None,
        resource_ids_scope: str = None,
        resource_types_scope: str = None,
        risk_level: int = None,
        scope: GetConfigRuleResponseBodyConfigRuleScope = None,
        source: GetConfigRuleResponseBodyConfigRuleSource = None,
        tag_key_logic_scope: str = None,
        tag_key_scope: str = None,
        tag_value_scope: str = None,
        tags: List[GetConfigRuleResponseBodyConfigRuleTags] = None,
        tags_scope: List[GetConfigRuleResponseBodyConfigRuleTagsScope] = None,
    ):
        # The ID of the Alibaba Cloud account to which the rule belongs.
        self.account_id = account_id
        # The details of compliance evaluation results.
        self.compliance = compliance
        # The ARN of the managed rule.
        self.config_rule_arn = config_rule_arn
        # The information about compliance evaluations performed by the rule.
        self.config_rule_evaluation_status = config_rule_evaluation_status
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The name of the rule.
        self.config_rule_name = config_rule_name
        # The status of the rule. Valid values:
        # 
        # *   ACTIVE: The rule is enabled.
        # *   DELETING: The rule is being deleted.
        # *   EVALUATING: The rule is being used to evaluate resource configurations.
        # *   INACTIVE: The rule is disabled.
        self.config_rule_state = config_rule_state
        # The trigger type of the rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The rule was triggered by configuration changes.
        # *   ScheduledNotification: The rule was periodically triggered.
        self.config_rule_trigger_types = config_rule_trigger_types
        # The information about the creation of the rule.
        self.create_by = create_by
        # The timestamp generated when the rule was created. Unit: millisecond.
        self.create_timestamp = create_timestamp
        # The description of the managed rule.
        self.description = description
        # ExcludeRegionIdsScope
        self.exclude_region_ids_scope = exclude_region_ids_scope
        # ExcludeResourceGroupIdsScope
        self.exclude_resource_group_ids_scope = exclude_resource_group_ids_scope
        # The ID of the resource excluded from the compliance evaluations performed by the rule.
        self.exclude_resource_ids_scope = exclude_resource_ids_scope
        # ExcludeTagsScope
        self.exclude_tags_scope = exclude_tags_scope
        # Optional field, only used in conjunction with the 24-hour cycle execution to set the trigger time.
        self.extend_content = extend_content
        # The input parameters of the rule.
        self.input_parameters = input_parameters
        # The details of the managed rule.
        self.managed_rule = managed_rule
        # The interval at which the rule is triggered. Valid values:
        # 
        # *   One_Hour
        # *   Three_Hours
        # *   Six_Hours
        # *   Twelve_Hours
        # *   TwentyFour_Hours
        # 
        # >  This parameter is returned if the rule is periodically triggered.
        self.maximum_execution_frequency = maximum_execution_frequency
        # The timestamp generated when the rule was last updated. Unit: millisecond.
        self.modified_timestamp = modified_timestamp
        # The ID of the region to which the rule applies.
        self.region_ids_scope = region_ids_scope
        # The ID of the resource group to which the rule applies.
        self.resource_group_ids_scope = resource_group_ids_scope
        # ResourceIdsScope
        self.resource_ids_scope = resource_ids_scope
        # The type of the resource to be evaluated by the rule.
        self.resource_types_scope = resource_types_scope
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high.
        # *   2: medium.
        # *   3: low.
        self.risk_level = risk_level
        # The effective scope of the rule.
        self.scope = scope
        # The information about how the rule was created.
        self.source = source
        # The ID of the member account to which the rule does not apply, which means that the resources within the member account are not evaluated based on the rule.
        # 
        # > This parameter applies only to a managed rule.
        self.tag_key_logic_scope = tag_key_logic_scope
        # The tag key used to filter resources. The rule applies only to the resources with the specified tag key.
        # 
        # > The `TagKeyScope` and `TagValueScope` parameters are returned at the same time.
        self.tag_key_scope = tag_key_scope
        # The tag value used to filter resources. The rule applies only to the resources with the specified tag value.
        # 
        # > The `TagKeyScope` and `TagValueScope` parameters are returned at the same time.
        self.tag_value_scope = tag_value_scope
        self.tags = tags
        # TagsScope
        self.tags_scope = tags_scope

    def validate(self):
        if self.compliance:
            self.compliance.validate()
        if self.config_rule_evaluation_status:
            self.config_rule_evaluation_status.validate()
        if self.create_by:
            self.create_by.validate()
        if self.exclude_tags_scope:
            for k in self.exclude_tags_scope:
                if k:
                    k.validate()
        if self.managed_rule:
            self.managed_rule.validate()
        if self.scope:
            self.scope.validate()
        if self.source:
            self.source.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()
        if self.tags_scope:
            for k in self.tags_scope:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.compliance is not None:
            result['Compliance'] = self.compliance.to_map()
        if self.config_rule_arn is not None:
            result['ConfigRuleArn'] = self.config_rule_arn
        if self.config_rule_evaluation_status is not None:
            result['ConfigRuleEvaluationStatus'] = self.config_rule_evaluation_status.to_map()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        if self.config_rule_state is not None:
            result['ConfigRuleState'] = self.config_rule_state
        if self.config_rule_trigger_types is not None:
            result['ConfigRuleTriggerTypes'] = self.config_rule_trigger_types
        if self.create_by is not None:
            result['CreateBy'] = self.create_by.to_map()
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.description is not None:
            result['Description'] = self.description
        if self.exclude_region_ids_scope is not None:
            result['ExcludeRegionIdsScope'] = self.exclude_region_ids_scope
        if self.exclude_resource_group_ids_scope is not None:
            result['ExcludeResourceGroupIdsScope'] = self.exclude_resource_group_ids_scope
        if self.exclude_resource_ids_scope is not None:
            result['ExcludeResourceIdsScope'] = self.exclude_resource_ids_scope
        result['ExcludeTagsScope'] = []
        if self.exclude_tags_scope is not None:
            for k in self.exclude_tags_scope:
                result['ExcludeTagsScope'].append(k.to_map() if k else None)
        if self.extend_content is not None:
            result['ExtendContent'] = self.extend_content
        if self.input_parameters is not None:
            result['InputParameters'] = self.input_parameters
        if self.managed_rule is not None:
            result['ManagedRule'] = self.managed_rule.to_map()
        if self.maximum_execution_frequency is not None:
            result['MaximumExecutionFrequency'] = self.maximum_execution_frequency
        if self.modified_timestamp is not None:
            result['ModifiedTimestamp'] = self.modified_timestamp
        if self.region_ids_scope is not None:
            result['RegionIdsScope'] = self.region_ids_scope
        if self.resource_group_ids_scope is not None:
            result['ResourceGroupIdsScope'] = self.resource_group_ids_scope
        if self.resource_ids_scope is not None:
            result['ResourceIdsScope'] = self.resource_ids_scope
        if self.resource_types_scope is not None:
            result['ResourceTypesScope'] = self.resource_types_scope
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.scope is not None:
            result['Scope'] = self.scope.to_map()
        if self.source is not None:
            result['Source'] = self.source.to_map()
        if self.tag_key_logic_scope is not None:
            result['TagKeyLogicScope'] = self.tag_key_logic_scope
        if self.tag_key_scope is not None:
            result['TagKeyScope'] = self.tag_key_scope
        if self.tag_value_scope is not None:
            result['TagValueScope'] = self.tag_value_scope
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        result['TagsScope'] = []
        if self.tags_scope is not None:
            for k in self.tags_scope:
                result['TagsScope'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('Compliance') is not None:
            temp_model = GetConfigRuleResponseBodyConfigRuleCompliance()
            self.compliance = temp_model.from_map(m['Compliance'])
        if m.get('ConfigRuleArn') is not None:
            self.config_rule_arn = m.get('ConfigRuleArn')
        if m.get('ConfigRuleEvaluationStatus') is not None:
            temp_model = GetConfigRuleResponseBodyConfigRuleConfigRuleEvaluationStatus()
            self.config_rule_evaluation_status = temp_model.from_map(m['ConfigRuleEvaluationStatus'])
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        if m.get('ConfigRuleState') is not None:
            self.config_rule_state = m.get('ConfigRuleState')
        if m.get('ConfigRuleTriggerTypes') is not None:
            self.config_rule_trigger_types = m.get('ConfigRuleTriggerTypes')
        if m.get('CreateBy') is not None:
            temp_model = GetConfigRuleResponseBodyConfigRuleCreateBy()
            self.create_by = temp_model.from_map(m['CreateBy'])
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExcludeRegionIdsScope') is not None:
            self.exclude_region_ids_scope = m.get('ExcludeRegionIdsScope')
        if m.get('ExcludeResourceGroupIdsScope') is not None:
            self.exclude_resource_group_ids_scope = m.get('ExcludeResourceGroupIdsScope')
        if m.get('ExcludeResourceIdsScope') is not None:
            self.exclude_resource_ids_scope = m.get('ExcludeResourceIdsScope')
        self.exclude_tags_scope = []
        if m.get('ExcludeTagsScope') is not None:
            for k in m.get('ExcludeTagsScope'):
                temp_model = GetConfigRuleResponseBodyConfigRuleExcludeTagsScope()
                self.exclude_tags_scope.append(temp_model.from_map(k))
        if m.get('ExtendContent') is not None:
            self.extend_content = m.get('ExtendContent')
        if m.get('InputParameters') is not None:
            self.input_parameters = m.get('InputParameters')
        if m.get('ManagedRule') is not None:
            temp_model = GetConfigRuleResponseBodyConfigRuleManagedRule()
            self.managed_rule = temp_model.from_map(m['ManagedRule'])
        if m.get('MaximumExecutionFrequency') is not None:
            self.maximum_execution_frequency = m.get('MaximumExecutionFrequency')
        if m.get('ModifiedTimestamp') is not None:
            self.modified_timestamp = m.get('ModifiedTimestamp')
        if m.get('RegionIdsScope') is not None:
            self.region_ids_scope = m.get('RegionIdsScope')
        if m.get('ResourceGroupIdsScope') is not None:
            self.resource_group_ids_scope = m.get('ResourceGroupIdsScope')
        if m.get('ResourceIdsScope') is not None:
            self.resource_ids_scope = m.get('ResourceIdsScope')
        if m.get('ResourceTypesScope') is not None:
            self.resource_types_scope = m.get('ResourceTypesScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('Scope') is not None:
            temp_model = GetConfigRuleResponseBodyConfigRuleScope()
            self.scope = temp_model.from_map(m['Scope'])
        if m.get('Source') is not None:
            temp_model = GetConfigRuleResponseBodyConfigRuleSource()
            self.source = temp_model.from_map(m['Source'])
        if m.get('TagKeyLogicScope') is not None:
            self.tag_key_logic_scope = m.get('TagKeyLogicScope')
        if m.get('TagKeyScope') is not None:
            self.tag_key_scope = m.get('TagKeyScope')
        if m.get('TagValueScope') is not None:
            self.tag_value_scope = m.get('TagValueScope')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = GetConfigRuleResponseBodyConfigRuleTags()
                self.tags.append(temp_model.from_map(k))
        self.tags_scope = []
        if m.get('TagsScope') is not None:
            for k in m.get('TagsScope'):
                temp_model = GetConfigRuleResponseBodyConfigRuleTagsScope()
                self.tags_scope.append(temp_model.from_map(k))
        return self


class GetConfigRuleResponseBody(TeaModel):
    def __init__(
        self,
        config_rule: GetConfigRuleResponseBodyConfigRule = None,
        request_id: str = None,
    ):
        # The details of the rule.
        self.config_rule = config_rule
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.config_rule:
            self.config_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule is not None:
            result['ConfigRule'] = self.config_rule.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRule') is not None:
            temp_model = GetConfigRuleResponseBodyConfigRule()
            self.config_rule = temp_model.from_map(m['ConfigRule'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetConfigRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetConfigRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetConfigRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigRuleComplianceByPackRequest(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
    ):
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListCompliancePacks](https://help.aliyun.com/document_detail/263332.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        return self


class GetConfigRuleComplianceByPackResponseBodyConfigRuleComplianceResultConfigRuleCompliances(TeaModel):
    def __init__(
        self,
        compliance_type: str = None,
        config_rule_id: str = None,
        config_rule_name: str = None,
    ):
        # The compliance evaluation result. Valid values:
        # 
        # *   COMPLIANT: The relevant resources are evaluated as compliant.
        # *   NON_COMPLIANT: The relevant resources are evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to your resources.
        # *   INSUFFICIENT_DATA: No resource data is available.
        self.compliance_type = compliance_type
        # The ID of the rule enabled in the compliance package.
        self.config_rule_id = config_rule_id
        # The name of the rule enabled in the compliance package.
        self.config_rule_name = config_rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        return self


class GetConfigRuleComplianceByPackResponseBodyConfigRuleComplianceResult(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        config_rule_compliances: List[GetConfigRuleComplianceByPackResponseBodyConfigRuleComplianceResultConfigRuleCompliances] = None,
        non_compliant_count: int = None,
        total_count: int = None,
    ):
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The rule enabled in the compliance package and the compliance evaluation result returned by the rule.
        self.config_rule_compliances = config_rule_compliances
        # The number of rules against which specific resources are evaluated as non-compliant.
        self.non_compliant_count = non_compliant_count
        # The total number of rules enabled in the compliance package.
        self.total_count = total_count

    def validate(self):
        if self.config_rule_compliances:
            for k in self.config_rule_compliances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        result['ConfigRuleCompliances'] = []
        if self.config_rule_compliances is not None:
            for k in self.config_rule_compliances:
                result['ConfigRuleCompliances'].append(k.to_map() if k else None)
        if self.non_compliant_count is not None:
            result['NonCompliantCount'] = self.non_compliant_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        self.config_rule_compliances = []
        if m.get('ConfigRuleCompliances') is not None:
            for k in m.get('ConfigRuleCompliances'):
                temp_model = GetConfigRuleComplianceByPackResponseBodyConfigRuleComplianceResultConfigRuleCompliances()
                self.config_rule_compliances.append(temp_model.from_map(k))
        if m.get('NonCompliantCount') is not None:
            self.non_compliant_count = m.get('NonCompliantCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetConfigRuleComplianceByPackResponseBody(TeaModel):
    def __init__(
        self,
        config_rule_compliance_result: GetConfigRuleComplianceByPackResponseBodyConfigRuleComplianceResult = None,
        request_id: str = None,
    ):
        # The information about the compliance evaluation results returned.
        self.config_rule_compliance_result = config_rule_compliance_result
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.config_rule_compliance_result:
            self.config_rule_compliance_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_compliance_result is not None:
            result['ConfigRuleComplianceResult'] = self.config_rule_compliance_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleComplianceResult') is not None:
            temp_model = GetConfigRuleComplianceByPackResponseBodyConfigRuleComplianceResult()
            self.config_rule_compliance_result = temp_model.from_map(m['ConfigRuleComplianceResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetConfigRuleComplianceByPackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetConfigRuleComplianceByPackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetConfigRuleComplianceByPackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigRuleSummaryByRiskLevelResponseBodyConfigRuleSummaries(TeaModel):
    def __init__(
        self,
        compliant_count: int = None,
        non_compliant_count: int = None,
        risk_level: int = None,
    ):
        # The number of rules against which specific resources are evaluated as compliant.
        self.compliant_count = compliant_count
        # The number of rules against which specific resources are evaluated as non-compliant.
        self.non_compliant_count = non_compliant_count
        # The risk level of the resources that are not compliant with the rules. Valid values:
        # 
        # *   1: high risk level.
        # *   2: medium risk level.
        # *   3: low risk level.
        self.risk_level = risk_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliant_count is not None:
            result['CompliantCount'] = self.compliant_count
        if self.non_compliant_count is not None:
            result['NonCompliantCount'] = self.non_compliant_count
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliantCount') is not None:
            self.compliant_count = m.get('CompliantCount')
        if m.get('NonCompliantCount') is not None:
            self.non_compliant_count = m.get('NonCompliantCount')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class GetConfigRuleSummaryByRiskLevelResponseBody(TeaModel):
    def __init__(
        self,
        config_rule_summaries: List[GetConfigRuleSummaryByRiskLevelResponseBodyConfigRuleSummaries] = None,
        request_id: str = None,
    ):
        # The summary of compliance evaluation results by rule risk level.
        self.config_rule_summaries = config_rule_summaries
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.config_rule_summaries:
            for k in self.config_rule_summaries:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigRuleSummaries'] = []
        if self.config_rule_summaries is not None:
            for k in self.config_rule_summaries:
                result['ConfigRuleSummaries'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_rule_summaries = []
        if m.get('ConfigRuleSummaries') is not None:
            for k in m.get('ConfigRuleSummaries'):
                temp_model = GetConfigRuleSummaryByRiskLevelResponseBodyConfigRuleSummaries()
                self.config_rule_summaries.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetConfigRuleSummaryByRiskLevelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetConfigRuleSummaryByRiskLevelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetConfigRuleSummaryByRiskLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigRulesReportRequest(TeaModel):
    def __init__(
        self,
        report_id: str = None,
    ):
        # The ID of the compliance evaluation report.
        self.report_id = report_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        return self


class GetConfigRulesReportResponseBodyConfigRulesReport(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        report_create_timestamp: int = None,
        report_id: str = None,
        report_status: str = None,
        report_url: str = None,
    ):
        # The ID of the Alibaba Cloud account to which the rules belong.
        self.account_id = account_id
        # The timestamp when the compliance evaluation report was generated. Unit: milliseconds.
        self.report_create_timestamp = report_create_timestamp
        # The ID of the compliance evaluation report.
        self.report_id = report_id
        # The status of the compliance evaluation report. Valid values:
        # 
        # *   NONE: The compliance evaluation report is not generated.
        # *   CREATING: The compliance evaluation report is being generated.
        # *   COMPLETE: The compliance evaluation report is generated.
        self.report_status = report_status
        # The URL that is used to download the compliance evaluation report.
        self.report_url = report_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.report_create_timestamp is not None:
            result['ReportCreateTimestamp'] = self.report_create_timestamp
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.report_status is not None:
            result['ReportStatus'] = self.report_status
        if self.report_url is not None:
            result['ReportUrl'] = self.report_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('ReportCreateTimestamp') is not None:
            self.report_create_timestamp = m.get('ReportCreateTimestamp')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('ReportStatus') is not None:
            self.report_status = m.get('ReportStatus')
        if m.get('ReportUrl') is not None:
            self.report_url = m.get('ReportUrl')
        return self


class GetConfigRulesReportResponseBody(TeaModel):
    def __init__(
        self,
        config_rules_report: GetConfigRulesReportResponseBodyConfigRulesReport = None,
        request_id: str = None,
    ):
        # The information about the compliance evaluation report.
        self.config_rules_report = config_rules_report
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.config_rules_report:
            self.config_rules_report.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rules_report is not None:
            result['ConfigRulesReport'] = self.config_rules_report.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRulesReport') is not None:
            temp_model = GetConfigRulesReportResponseBodyConfigRulesReport()
            self.config_rules_report = temp_model.from_map(m['ConfigRulesReport'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetConfigRulesReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetConfigRulesReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetConfigRulesReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigurationRecorderResponseBodyConfigurationRecorder(TeaModel):
    def __init__(
        self,
        configuration_recorder_status: str = None,
        resource_types: List[str] = None,
    ):
        # The status of the configuration recorder. Valid values:
        # 
        # *   REGISTRABLE: The configuration recorder has not been registered.
        # *   BUILDING: The configuration recorder is being deployed.
        # *   REGISTERED: The configuration recorder has been registered.
        # *   REBUILDING: The configuration recorder is being redeployed.
        self.configuration_recorder_status = configuration_recorder_status
        # The types of resources that are monitored.
        self.resource_types = resource_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_recorder_status is not None:
            result['ConfigurationRecorderStatus'] = self.configuration_recorder_status
        if self.resource_types is not None:
            result['ResourceTypes'] = self.resource_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationRecorderStatus') is not None:
            self.configuration_recorder_status = m.get('ConfigurationRecorderStatus')
        if m.get('ResourceTypes') is not None:
            self.resource_types = m.get('ResourceTypes')
        return self


class GetConfigurationRecorderResponseBody(TeaModel):
    def __init__(
        self,
        configuration_recorder: GetConfigurationRecorderResponseBodyConfigurationRecorder = None,
        request_id: str = None,
    ):
        # The details of the configuration recorder that monitors resources.
        self.configuration_recorder = configuration_recorder
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.configuration_recorder:
            self.configuration_recorder.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_recorder is not None:
            result['ConfigurationRecorder'] = self.configuration_recorder.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationRecorder') is not None:
            temp_model = GetConfigurationRecorderResponseBodyConfigurationRecorder()
            self.configuration_recorder = temp_model.from_map(m['ConfigurationRecorder'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetConfigurationRecorderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetConfigurationRecorderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetConfigurationRecorderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDiscoveredResourceRequest(TeaModel):
    def __init__(
        self,
        compliance_option: int = None,
        region: str = None,
        resource_id: str = None,
        resource_type: str = None,
    ):
        # Specifies whether to query the compliance results of the resource. Valid values:
        # 
        # *   0 (default): does not query the compliance results of the resource.
        # *   1: queries the compliance results of the resource.
        self.compliance_option = compliance_option
        # The ID of the region in which the resource resides.
        # 
        # For more information about how to query the region ID of a resource, see [ListDiscoveredResources](https://help.aliyun.com/document_detail/411702.html).
        self.region = region
        # The resource ID.
        # 
        # For more information about how to obtain the ID of a resource, see [ListDiscoveredResources](https://help.aliyun.com/document_detail/411702.html).
        # 
        # This parameter is required.
        self.resource_id = resource_id
        # The type of the resource.
        # 
        # For more information about how to obtain the type of a resource, see [ListDiscoveredResources](https://help.aliyun.com/document_detail/411702.html).
        # 
        # This parameter is required.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_option is not None:
            result['ComplianceOption'] = self.compliance_option
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceOption') is not None:
            self.compliance_option = m.get('ComplianceOption')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class GetDiscoveredResourceResponseBodyDiscoveredResourceDetail(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        availability_zone: str = None,
        compliance_type: str = None,
        configuration: str = None,
        region: str = None,
        resource_creation_time: int = None,
        resource_deleted: int = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_status: str = None,
        resource_type: str = None,
        tags: str = None,
    ):
        # The ID of the Alibaba Cloud account to which the resource belongs.
        self.account_id = account_id
        # The ID of the zone in which the resource resides.
        self.availability_zone = availability_zone
        # The compliance evaluation result of the resource. Valid values:
        # 
        # *   COMPLIANT: The resource is evaluated as compliant.
        # *   NON_COMPLIANT: The resource is evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to the resources.
        # *   INSUFFICIENT_DATA: No data is available.
        self.compliance_type = compliance_type
        # The configuration of the resource.
        self.configuration = configuration
        # The region ID.
        self.region = region
        # The timestamp when the resource was created.
        self.resource_creation_time = resource_creation_time
        # Indicates whether the resource was deleted. Valid values:
        # 
        # *   1: The resource was not deleted.
        # *   0: The resource was deleted.
        self.resource_deleted = resource_deleted
        # The resource ID.
        self.resource_id = resource_id
        # The name of the resource.
        self.resource_name = resource_name
        # The status of the resource. The value of this parameter varies based on the resource type and may be empty.
        # 
        # *   If the ResourceType parameter is set to ACS::ECS::Instance, the resource is an ECS instance that has a specific state. In this case, the valid values of this parameter are Running and Stopped.
        # *   If the ResourceType parameter is ACS::OSS::Bucket, the resource is an Object Storage Service (OSS) bucket that is not in a specific state. In this case, this parameter is left empty.
        self.resource_status = resource_status
        # The type of the resource.
        self.resource_type = resource_type
        # The tags of the resource.
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.availability_zone is not None:
            result['AvailabilityZone'] = self.availability_zone
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_creation_time is not None:
            result['ResourceCreationTime'] = self.resource_creation_time
        if self.resource_deleted is not None:
            result['ResourceDeleted'] = self.resource_deleted
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_status is not None:
            result['ResourceStatus'] = self.resource_status
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AvailabilityZone') is not None:
            self.availability_zone = m.get('AvailabilityZone')
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceCreationTime') is not None:
            self.resource_creation_time = m.get('ResourceCreationTime')
        if m.get('ResourceDeleted') is not None:
            self.resource_deleted = m.get('ResourceDeleted')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceStatus') is not None:
            self.resource_status = m.get('ResourceStatus')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class GetDiscoveredResourceResponseBody(TeaModel):
    def __init__(
        self,
        discovered_resource_detail: GetDiscoveredResourceResponseBodyDiscoveredResourceDetail = None,
        request_id: str = None,
    ):
        # The details of the resource.
        self.discovered_resource_detail = discovered_resource_detail
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.discovered_resource_detail:
            self.discovered_resource_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discovered_resource_detail is not None:
            result['DiscoveredResourceDetail'] = self.discovered_resource_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiscoveredResourceDetail') is not None:
            temp_model = GetDiscoveredResourceResponseBodyDiscoveredResourceDetail()
            self.discovered_resource_detail = temp_model.from_map(m['DiscoveredResourceDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDiscoveredResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDiscoveredResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDiscoveredResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDiscoveredResourceCountsGroupByRegionRequest(TeaModel):
    def __init__(
        self,
        resource_type: str = None,
    ):
        # The resource type.
        # 
        # For more information about how to obtain the type of a resource, see [ListDiscoveredResources](https://help.aliyun.com/document_detail/169620.html).
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class GetDiscoveredResourceCountsGroupByRegionResponseBodyDiscoveredResourceCountsSummary(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        region: str = None,
        resource_count: int = None,
    ):
        # The dimension by which statistics are collected.
        # 
        # >  In most cases, the `Region` parameter instead of the GroupName parameter is returned.
        self.group_name = group_name
        # The ID of the region by which statistics are collected.
        self.region = region
        # The total number of resources.
        self.resource_count = resource_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_count is not None:
            result['ResourceCount'] = self.resource_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceCount') is not None:
            self.resource_count = m.get('ResourceCount')
        return self


class GetDiscoveredResourceCountsGroupByRegionResponseBody(TeaModel):
    def __init__(
        self,
        discovered_resource_counts_summary: List[GetDiscoveredResourceCountsGroupByRegionResponseBodyDiscoveredResourceCountsSummary] = None,
        request_id: str = None,
    ):
        # The statistics on the resources.
        self.discovered_resource_counts_summary = discovered_resource_counts_summary
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.discovered_resource_counts_summary:
            for k in self.discovered_resource_counts_summary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiscoveredResourceCountsSummary'] = []
        if self.discovered_resource_counts_summary is not None:
            for k in self.discovered_resource_counts_summary:
                result['DiscoveredResourceCountsSummary'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.discovered_resource_counts_summary = []
        if m.get('DiscoveredResourceCountsSummary') is not None:
            for k in m.get('DiscoveredResourceCountsSummary'):
                temp_model = GetDiscoveredResourceCountsGroupByRegionResponseBodyDiscoveredResourceCountsSummary()
                self.discovered_resource_counts_summary.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDiscoveredResourceCountsGroupByRegionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDiscoveredResourceCountsGroupByRegionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDiscoveredResourceCountsGroupByRegionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDiscoveredResourceCountsGroupByResourceTypeRequest(TeaModel):
    def __init__(
        self,
        region: str = None,
    ):
        # The region ID.
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class GetDiscoveredResourceCountsGroupByResourceTypeResponseBodyDiscoveredResourceCountsSummary(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        resource_count: int = None,
        resource_type: str = None,
    ):
        # The resource type by which the statistics are collected.
        # 
        # > We recommend that you use the `ResourceType` parameter.
        self.group_name = group_name
        # The total number of resources.
        self.resource_count = resource_count
        # The resource type by which the statistics are collected.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.resource_count is not None:
            result['ResourceCount'] = self.resource_count
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('ResourceCount') is not None:
            self.resource_count = m.get('ResourceCount')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class GetDiscoveredResourceCountsGroupByResourceTypeResponseBody(TeaModel):
    def __init__(
        self,
        discovered_resource_counts_summary: List[GetDiscoveredResourceCountsGroupByResourceTypeResponseBodyDiscoveredResourceCountsSummary] = None,
        request_id: str = None,
    ):
        # The statistics on the resources.
        self.discovered_resource_counts_summary = discovered_resource_counts_summary
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.discovered_resource_counts_summary:
            for k in self.discovered_resource_counts_summary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiscoveredResourceCountsSummary'] = []
        if self.discovered_resource_counts_summary is not None:
            for k in self.discovered_resource_counts_summary:
                result['DiscoveredResourceCountsSummary'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.discovered_resource_counts_summary = []
        if m.get('DiscoveredResourceCountsSummary') is not None:
            for k in m.get('DiscoveredResourceCountsSummary'):
                temp_model = GetDiscoveredResourceCountsGroupByResourceTypeResponseBodyDiscoveredResourceCountsSummary()
                self.discovered_resource_counts_summary.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDiscoveredResourceCountsGroupByResourceTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDiscoveredResourceCountsGroupByResourceTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDiscoveredResourceCountsGroupByResourceTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIntegratedServiceStatusRequest(TeaModel):
    def __init__(
        self,
        service_code: str = None,
    ):
        # The identity of the cloud service that is integrated with Cloud Config. Valid values:
        # 
        # *   eventbridge: EventBridge
        # *   cms: CloudMonitor
        # *   bpstudio: Cloud Architect Design Tools (CADT)
        # 
        # This parameter is required.
        self.service_code = service_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_code is not None:
            result['ServiceCode'] = self.service_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceCode') is not None:
            self.service_code = m.get('ServiceCode')
        return self


class GetIntegratedServiceStatusResponseBody(TeaModel):
    def __init__(
        self,
        aggregator_delivery_data_type: str = None,
        data: bool = None,
        integrated_types: str = None,
        request_id: str = None,
    ):
        # The type of the event that is integrated across accounts. Valid values:
        # 
        # *   NonCompliantNotification: non-compliance event
        self.aggregator_delivery_data_type = aggregator_delivery_data_type
        # Indicates whether the product has been integrated. Valid values:
        # 
        # *   true
        # *   false
        self.data = data
        # The types of the integrated events. Separate multiple event types with commas (,). Valid values:
        # 
        # *   ConfigurationItemChangeNotification: resource change event
        # *   NonCompliantNotification: non-compliance event
        self.integrated_types = integrated_types
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_delivery_data_type is not None:
            result['AggregatorDeliveryDataType'] = self.aggregator_delivery_data_type
        if self.data is not None:
            result['Data'] = self.data
        if self.integrated_types is not None:
            result['IntegratedTypes'] = self.integrated_types
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorDeliveryDataType') is not None:
            self.aggregator_delivery_data_type = m.get('AggregatorDeliveryDataType')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('IntegratedTypes') is not None:
            self.integrated_types = m.get('IntegratedTypes')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetIntegratedServiceStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetIntegratedServiceStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetIntegratedServiceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetManagedRuleRequest(TeaModel):
    def __init__(
        self,
        identifier: str = None,
    ):
        # The identifier of the managed rule.
        # 
        # For more information about how to obtain the identifier of a managed rule, see [ListManagedRules](https://help.aliyun.com/document_detail/421144.html).
        # 
        # This parameter is required.
        self.identifier = identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        return self


class GetManagedRuleResponseBodyManagedRuleScope(TeaModel):
    def __init__(
        self,
        compliance_resource_types: List[str] = None,
    ):
        # The types of resources to which the managed rule applies.
        self.compliance_resource_types = compliance_resource_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_resource_types is not None:
            result['ComplianceResourceTypes'] = self.compliance_resource_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceResourceTypes') is not None:
            self.compliance_resource_types = m.get('ComplianceResourceTypes')
        return self


class GetManagedRuleResponseBodyManagedRuleSourceDetails(TeaModel):
    def __init__(
        self,
        maximum_execution_frequency: str = None,
        message_type: str = None,
    ):
        # The interval at which the rule is triggered. Valid values: Valid values:
        # 
        # *   One_Hour
        # *   Three_Hours
        # *   Six_Hours
        # *   Twelve_Hours
        # *   TwentyFour_Hours
        self.maximum_execution_frequency = maximum_execution_frequency
        # The trigger type of the rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The rule is triggered by configuration changes.
        # *   ScheduledNotification: The rule is periodically triggered.
        self.message_type = message_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.maximum_execution_frequency is not None:
            result['MaximumExecutionFrequency'] = self.maximum_execution_frequency
        if self.message_type is not None:
            result['MessageType'] = self.message_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaximumExecutionFrequency') is not None:
            self.maximum_execution_frequency = m.get('MaximumExecutionFrequency')
        if m.get('MessageType') is not None:
            self.message_type = m.get('MessageType')
        return self


class GetManagedRuleResponseBodyManagedRule(TeaModel):
    def __init__(
        self,
        compulsory_input_parameter_details: Dict[str, Any] = None,
        config_rule_name: str = None,
        description: str = None,
        help_urls: str = None,
        identifier: str = None,
        labels: List[str] = None,
        optional_input_parameter_details: Dict[str, Any] = None,
        risk_level: int = None,
        scope: GetManagedRuleResponseBodyManagedRuleScope = None,
        source_details: List[GetManagedRuleResponseBodyManagedRuleSourceDetails] = None,
    ):
        # The details of the required input parameters for the managed rule.
        self.compulsory_input_parameter_details = compulsory_input_parameter_details
        # The name of the managed rule.
        self.config_rule_name = config_rule_name
        # The description of the managed rule.
        self.description = description
        # The URL of the topic that provides guidance on remediation for the managed rule.
        self.help_urls = help_urls
        # The identifier of the managed rule.
        self.identifier = identifier
        # The tags of the managed rule.
        self.labels = labels
        # The details of the optional input parameters for the managed rule.
        self.optional_input_parameter_details = optional_input_parameter_details
        # The risk level of the managed rule. Valid values:
        # 
        # *   1: high
        # *   2: medium
        # *   3: low
        self.risk_level = risk_level
        # The effective scope of the managed rule.
        self.scope = scope
        # The information about the trigger type of the managed rule.
        self.source_details = source_details

    def validate(self):
        if self.scope:
            self.scope.validate()
        if self.source_details:
            for k in self.source_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compulsory_input_parameter_details is not None:
            result['CompulsoryInputParameterDetails'] = self.compulsory_input_parameter_details
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        if self.description is not None:
            result['Description'] = self.description
        if self.help_urls is not None:
            result['HelpUrls'] = self.help_urls
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.optional_input_parameter_details is not None:
            result['OptionalInputParameterDetails'] = self.optional_input_parameter_details
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.scope is not None:
            result['Scope'] = self.scope.to_map()
        result['SourceDetails'] = []
        if self.source_details is not None:
            for k in self.source_details:
                result['SourceDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompulsoryInputParameterDetails') is not None:
            self.compulsory_input_parameter_details = m.get('CompulsoryInputParameterDetails')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HelpUrls') is not None:
            self.help_urls = m.get('HelpUrls')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('OptionalInputParameterDetails') is not None:
            self.optional_input_parameter_details = m.get('OptionalInputParameterDetails')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('Scope') is not None:
            temp_model = GetManagedRuleResponseBodyManagedRuleScope()
            self.scope = temp_model.from_map(m['Scope'])
        self.source_details = []
        if m.get('SourceDetails') is not None:
            for k in m.get('SourceDetails'):
                temp_model = GetManagedRuleResponseBodyManagedRuleSourceDetails()
                self.source_details.append(temp_model.from_map(k))
        return self


class GetManagedRuleResponseBody(TeaModel):
    def __init__(
        self,
        managed_rule: GetManagedRuleResponseBodyManagedRule = None,
        request_id: str = None,
    ):
        # The details of the managed rule.
        self.managed_rule = managed_rule
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.managed_rule:
            self.managed_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.managed_rule is not None:
            result['ManagedRule'] = self.managed_rule.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ManagedRule') is not None:
            temp_model = GetManagedRuleResponseBodyManagedRule()
            self.managed_rule = temp_model.from_map(m['ManagedRule'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetManagedRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetManagedRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetManagedRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRemediationTemplateRequest(TeaModel):
    def __init__(
        self,
        template_identifier: str = None,
    ):
        # The ID of the automatic remediation template.
        # 
        # For more information about how to obtain the ID of a remediation template, see [Compliance library](https://help.aliyun.com/document_detail/2337741.html).
        self.template_identifier = template_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_identifier is not None:
            result['TemplateIdentifier'] = self.template_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateIdentifier') is not None:
            self.template_identifier = m.get('TemplateIdentifier')
        return self


class GetRemediationTemplateResponseBodyRemediationTemplates(TeaModel):
    def __init__(
        self,
        managed_rule_identifier: str = None,
        remediation_type: str = None,
        template_definition: str = None,
        template_description: str = None,
        template_identifier: str = None,
        template_name: str = None,
    ):
        # The ID of the supported rule template.
        # 
        # This parameter is required.
        self.managed_rule_identifier = managed_rule_identifier
        # The type of the automatic remediation template. The value is set to OOS.
        self.remediation_type = remediation_type
        # The parameters of the automatic remediation template.
        self.template_definition = template_definition
        # The description of the automatic remediation template.
        # 
        # This parameter is required.
        self.template_description = template_description
        # The ID of the automatic remediation template.
        self.template_identifier = template_identifier
        # The name of the automatic remediation template.
        self.template_name = template_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.managed_rule_identifier is not None:
            result['ManagedRuleIdentifier'] = self.managed_rule_identifier
        if self.remediation_type is not None:
            result['RemediationType'] = self.remediation_type
        if self.template_definition is not None:
            result['TemplateDefinition'] = self.template_definition
        if self.template_description is not None:
            result['TemplateDescription'] = self.template_description
        if self.template_identifier is not None:
            result['TemplateIdentifier'] = self.template_identifier
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ManagedRuleIdentifier') is not None:
            self.managed_rule_identifier = m.get('ManagedRuleIdentifier')
        if m.get('RemediationType') is not None:
            self.remediation_type = m.get('RemediationType')
        if m.get('TemplateDefinition') is not None:
            self.template_definition = m.get('TemplateDefinition')
        if m.get('TemplateDescription') is not None:
            self.template_description = m.get('TemplateDescription')
        if m.get('TemplateIdentifier') is not None:
            self.template_identifier = m.get('TemplateIdentifier')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        return self


class GetRemediationTemplateResponseBody(TeaModel):
    def __init__(
        self,
        remediation_templates: List[GetRemediationTemplateResponseBodyRemediationTemplates] = None,
        request_id: str = None,
    ):
        # The information about the automatic remediation template.
        self.remediation_templates = remediation_templates
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.remediation_templates:
            for k in self.remediation_templates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RemediationTemplates'] = []
        if self.remediation_templates is not None:
            for k in self.remediation_templates:
                result['RemediationTemplates'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.remediation_templates = []
        if m.get('RemediationTemplates') is not None:
            for k in m.get('RemediationTemplates'):
                temp_model = GetRemediationTemplateResponseBodyRemediationTemplates()
                self.remediation_templates.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRemediationTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRemediationTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRemediationTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetResourceComplianceByConfigRuleRequest(TeaModel):
    def __init__(
        self,
        compliance_type: str = None,
        config_rule_id: str = None,
    ):
        # The compliance evaluation result. Valid values:
        # 
        # *   COMPLIANT: The resources are evaluated as compliant.
        # *   NON_COMPLIANT: The resources are evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to the resources.
        # *   INSUFFICIENT_DATA: No data is available.
        self.compliance_type = compliance_type
        # The rule ID.
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        return self


class GetResourceComplianceByConfigRuleResponseBodyComplianceResultCompliances(TeaModel):
    def __init__(
        self,
        compliance_type: str = None,
        count: int = None,
    ):
        # The compliance evaluation results of the resources. Valid values:
        # 
        # *   COMPLIANT: The resource was evaluated as compliant.
        # *   NON_COMPLIANT: The resource was evaluated as incompliant.
        # *   NOT_APPLICABLE: The rule did not apply to your resources.
        # *   INSUFFICIENT_DATA: No resource data was available.
        self.compliance_type = compliance_type
        # The number of resources that have compliance evaluation results. For example, if the value of the `ComplianceType` parameter is `COMPLIANT`, this parameter value indicates the number of compliant resources.
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetResourceComplianceByConfigRuleResponseBodyComplianceResult(TeaModel):
    def __init__(
        self,
        compliances: List[GetResourceComplianceByConfigRuleResponseBodyComplianceResultCompliances] = None,
        total_count: int = None,
    ):
        # The compliance evaluation results based on compliance types.
        self.compliances = compliances
        # The total number of evaluated resources.
        self.total_count = total_count

    def validate(self):
        if self.compliances:
            for k in self.compliances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Compliances'] = []
        if self.compliances is not None:
            for k in self.compliances:
                result['Compliances'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliances = []
        if m.get('Compliances') is not None:
            for k in m.get('Compliances'):
                temp_model = GetResourceComplianceByConfigRuleResponseBodyComplianceResultCompliances()
                self.compliances.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetResourceComplianceByConfigRuleResponseBody(TeaModel):
    def __init__(
        self,
        compliance_result: GetResourceComplianceByConfigRuleResponseBodyComplianceResult = None,
        request_id: str = None,
    ):
        # The compliance result.
        self.compliance_result = compliance_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.compliance_result:
            self.compliance_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_result is not None:
            result['ComplianceResult'] = self.compliance_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceResult') is not None:
            temp_model = GetResourceComplianceByConfigRuleResponseBodyComplianceResult()
            self.compliance_result = temp_model.from_map(m['ComplianceResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetResourceComplianceByConfigRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetResourceComplianceByConfigRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetResourceComplianceByConfigRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetResourceComplianceByPackRequest(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
    ):
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListCompliancePacks](https://help.aliyun.com/document_detail/263332.html).
        # 
        # This parameter is required.
        self.compliance_pack_id = compliance_pack_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        return self


class GetResourceComplianceByPackResponseBodyResourceComplianceResult(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        non_compliant_count: int = None,
        total_count: int = None,
    ):
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The number of non-compliant resources.
        self.non_compliant_count = non_compliant_count
        # The total number of resources.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.non_compliant_count is not None:
            result['NonCompliantCount'] = self.non_compliant_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('NonCompliantCount') is not None:
            self.non_compliant_count = m.get('NonCompliantCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetResourceComplianceByPackResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_compliance_result: GetResourceComplianceByPackResponseBodyResourceComplianceResult = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The compliance evaluation results returned.
        self.resource_compliance_result = resource_compliance_result

    def validate(self):
        if self.resource_compliance_result:
            self.resource_compliance_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_compliance_result is not None:
            result['ResourceComplianceResult'] = self.resource_compliance_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceComplianceResult') is not None:
            temp_model = GetResourceComplianceByPackResponseBodyResourceComplianceResult()
            self.resource_compliance_result = temp_model.from_map(m['ResourceComplianceResult'])
        return self


class GetResourceComplianceByPackResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetResourceComplianceByPackResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetResourceComplianceByPackResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetResourceComplianceGroupByRegionRequest(TeaModel):
    def __init__(
        self,
        config_rule_ids: str = None,
    ):
        # The rule IDs. Separate multiple rule IDs with commas (,).
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class GetResourceComplianceGroupByRegionResponseBodyComplianceResultComplianceResultListCompliances(TeaModel):
    def __init__(
        self,
        compliance_type: str = None,
        count: int = None,
    ):
        # The evaluation result. Valid values:
        # 
        # *   COMPLIANT: The resources are evaluated as compliant.
        # *   NON_COMPLIANT: The resources are evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to the resources.
        # *   INSUFFICIENT_DATA: No resource data is available.
        self.compliance_type = compliance_type
        # The total number of evaluation results.
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetResourceComplianceGroupByRegionResponseBodyComplianceResultComplianceResultList(TeaModel):
    def __init__(
        self,
        compliances: List[GetResourceComplianceGroupByRegionResponseBodyComplianceResultComplianceResultListCompliances] = None,
        region_id: str = None,
    ):
        # The queried evaluation results.
        self.compliances = compliances
        # The region ID of the evaluated resource.
        self.region_id = region_id

    def validate(self):
        if self.compliances:
            for k in self.compliances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Compliances'] = []
        if self.compliances is not None:
            for k in self.compliances:
                result['Compliances'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliances = []
        if m.get('Compliances') is not None:
            for k in m.get('Compliances'):
                temp_model = GetResourceComplianceGroupByRegionResponseBodyComplianceResultComplianceResultListCompliances()
                self.compliances.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetResourceComplianceGroupByRegionResponseBodyComplianceResult(TeaModel):
    def __init__(
        self,
        compliance_result_list: List[GetResourceComplianceGroupByRegionResponseBodyComplianceResultComplianceResultList] = None,
    ):
        # The evaluation results grouped by region.
        self.compliance_result_list = compliance_result_list

    def validate(self):
        if self.compliance_result_list:
            for k in self.compliance_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ComplianceResultList'] = []
        if self.compliance_result_list is not None:
            for k in self.compliance_result_list:
                result['ComplianceResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliance_result_list = []
        if m.get('ComplianceResultList') is not None:
            for k in m.get('ComplianceResultList'):
                temp_model = GetResourceComplianceGroupByRegionResponseBodyComplianceResultComplianceResultList()
                self.compliance_result_list.append(temp_model.from_map(k))
        return self


class GetResourceComplianceGroupByRegionResponseBody(TeaModel):
    def __init__(
        self,
        compliance_result: GetResourceComplianceGroupByRegionResponseBodyComplianceResult = None,
        request_id: str = None,
    ):
        # The queried evaluation results.
        self.compliance_result = compliance_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.compliance_result:
            self.compliance_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_result is not None:
            result['ComplianceResult'] = self.compliance_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceResult') is not None:
            temp_model = GetResourceComplianceGroupByRegionResponseBodyComplianceResult()
            self.compliance_result = temp_model.from_map(m['ComplianceResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetResourceComplianceGroupByRegionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetResourceComplianceGroupByRegionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetResourceComplianceGroupByRegionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetResourceComplianceGroupByResourceTypeRequest(TeaModel):
    def __init__(
        self,
        config_rule_ids: str = None,
    ):
        # The rule IDs. Separate multiple rule IDs with commas (,).
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class GetResourceComplianceGroupByResourceTypeResponseBodyComplianceResultComplianceResultListCompliances(TeaModel):
    def __init__(
        self,
        compliance_type: str = None,
        count: int = None,
    ):
        # The evaluation result. Valid values:
        # 
        # *   COMPLIANT: The resource is evaluated as compliant.
        # *   NON_COMPLIANT: The resource is evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to the resource.
        # *   INSUFFICIENT_DATA: No data is available.
        self.compliance_type = compliance_type
        # The total number of evaluation results.
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetResourceComplianceGroupByResourceTypeResponseBodyComplianceResultComplianceResultList(TeaModel):
    def __init__(
        self,
        compliances: List[GetResourceComplianceGroupByResourceTypeResponseBodyComplianceResultComplianceResultListCompliances] = None,
        resource_type: str = None,
    ):
        # The queried evaluation results.
        self.compliances = compliances
        # The type of the evaluated resource.
        self.resource_type = resource_type

    def validate(self):
        if self.compliances:
            for k in self.compliances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Compliances'] = []
        if self.compliances is not None:
            for k in self.compliances:
                result['Compliances'].append(k.to_map() if k else None)
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliances = []
        if m.get('Compliances') is not None:
            for k in m.get('Compliances'):
                temp_model = GetResourceComplianceGroupByResourceTypeResponseBodyComplianceResultComplianceResultListCompliances()
                self.compliances.append(temp_model.from_map(k))
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class GetResourceComplianceGroupByResourceTypeResponseBodyComplianceResult(TeaModel):
    def __init__(
        self,
        compliance_result_list: List[GetResourceComplianceGroupByResourceTypeResponseBodyComplianceResultComplianceResultList] = None,
    ):
        # The evaluation results grouped by resource type.
        self.compliance_result_list = compliance_result_list

    def validate(self):
        if self.compliance_result_list:
            for k in self.compliance_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ComplianceResultList'] = []
        if self.compliance_result_list is not None:
            for k in self.compliance_result_list:
                result['ComplianceResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliance_result_list = []
        if m.get('ComplianceResultList') is not None:
            for k in m.get('ComplianceResultList'):
                temp_model = GetResourceComplianceGroupByResourceTypeResponseBodyComplianceResultComplianceResultList()
                self.compliance_result_list.append(temp_model.from_map(k))
        return self


class GetResourceComplianceGroupByResourceTypeResponseBody(TeaModel):
    def __init__(
        self,
        compliance_result: GetResourceComplianceGroupByResourceTypeResponseBodyComplianceResult = None,
        request_id: str = None,
    ):
        # The queried evaluation results.
        self.compliance_result = compliance_result
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.compliance_result:
            self.compliance_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_result is not None:
            result['ComplianceResult'] = self.compliance_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceResult') is not None:
            temp_model = GetResourceComplianceGroupByResourceTypeResponseBodyComplianceResult()
            self.compliance_result = temp_model.from_map(m['ComplianceResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetResourceComplianceGroupByResourceTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetResourceComplianceGroupByResourceTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetResourceComplianceGroupByResourceTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetResourceComplianceTimelineRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        max_results: int = None,
        next_token: str = None,
        region: str = None,
        resource_id: str = None,
        resource_type: str = None,
        start_time: int = None,
    ):
        # The timestamp that specifies the end of the time range to query. The default value is the time when the GetResourceComplianceTimeline operation is called. Unit: milliseconds.
        self.end_time = end_time
        # The maximum number of entries to return for a single request. Valid values: 1 to 100.
        self.max_results = max_results
        # The token that is used to initiate the next request. If the response of the current request is truncated, this token is used to initiate another request and obtain the remaining entries.
        self.next_token = next_token
        # The ID of the region where the resource resides.
        # 
        # This parameter is required.
        self.region = region
        # The ID of the resource.
        # 
        # For more information about how to obtain the ID of a resource, see [ListDiscoveredResources](https://help.aliyun.com/document_detail/169620.html).
        # 
        # This parameter is required.
        self.resource_id = resource_id
        # The type of the resource.
        # 
        # For more information about how to obtain the type of a resource, see [ListDiscoveredResources](https://help.aliyun.com/document_detail/169620.html).
        # 
        # This parameter is required.
        self.resource_type = resource_type
        # The timestamp that specifies the beginning of the time range to query. By default, Cloud Config retrieves the compliance evaluations in the last 30 days for the specified resource. Unit: milliseconds.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetResourceComplianceTimelineResponseBodyResourceComplianceTimelineComplianceList(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        availability_zone: str = None,
        capture_time: int = None,
        configuration: str = None,
        configuration_diff: str = None,
        region: str = None,
        resource_create_time: int = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_status: str = None,
        resource_type: str = None,
        tags: str = None,
    ):
        # The ID of the Alibaba Cloud account to which the resource belongs.
        self.account_id = account_id
        # The ID of the zone in which the resource resides.
        self.availability_zone = availability_zone
        # The timestamp when the compliance evaluation was recorded. Unit: milliseconds.
        self.capture_time = capture_time
        # The rules associated with the resource and the compliance details of the rules.
        self.configuration = configuration
        # The details of the resource changes that trigger the compliance evaluation.
        self.configuration_diff = configuration_diff
        # The region ID.
        self.region = region
        # The time when the resource was created. Unit: milliseconds.
        self.resource_create_time = resource_create_time
        # The resource ID.
        self.resource_id = resource_id
        # The resource name.
        self.resource_name = resource_name
        # The status of the resource. The parameter value varies based on the resource type and may be left empty. Examples:
        # 
        # *   If the ResourceType parameter is set to ACS::ECS::Instance, the resource is an Elastic Compute Service (ECS) instance that has a specific state. In this case, the valid values of this parameter are Running and Stopped.
        # *   If the ResourceType parameter is ACS::OSS::Bucket, the resource is an Object Storage Service (OSS) bucket that is not in a specific state. In this case, this parameter is left empty.
        self.resource_status = resource_status
        # The type of the resource.
        self.resource_type = resource_type
        # The tags of the resource.
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.availability_zone is not None:
            result['AvailabilityZone'] = self.availability_zone
        if self.capture_time is not None:
            result['CaptureTime'] = self.capture_time
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.configuration_diff is not None:
            result['ConfigurationDiff'] = self.configuration_diff
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_create_time is not None:
            result['ResourceCreateTime'] = self.resource_create_time
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_status is not None:
            result['ResourceStatus'] = self.resource_status
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AvailabilityZone') is not None:
            self.availability_zone = m.get('AvailabilityZone')
        if m.get('CaptureTime') is not None:
            self.capture_time = m.get('CaptureTime')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ConfigurationDiff') is not None:
            self.configuration_diff = m.get('ConfigurationDiff')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceCreateTime') is not None:
            self.resource_create_time = m.get('ResourceCreateTime')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceStatus') is not None:
            self.resource_status = m.get('ResourceStatus')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class GetResourceComplianceTimelineResponseBodyResourceComplianceTimeline(TeaModel):
    def __init__(
        self,
        compliance_list: List[GetResourceComplianceTimelineResponseBodyResourceComplianceTimelineComplianceList] = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # The compliance evaluation records on the compliance timeline.
        self.compliance_list = compliance_list
        # The maximum number of entries that can be returned for a single request.
        self.max_results = max_results
        # The token that is used to initiate the next request.
        self.next_token = next_token

    def validate(self):
        if self.compliance_list:
            for k in self.compliance_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ComplianceList'] = []
        if self.compliance_list is not None:
            for k in self.compliance_list:
                result['ComplianceList'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliance_list = []
        if m.get('ComplianceList') is not None:
            for k in m.get('ComplianceList'):
                temp_model = GetResourceComplianceTimelineResponseBodyResourceComplianceTimelineComplianceList()
                self.compliance_list.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class GetResourceComplianceTimelineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_compliance_timeline: GetResourceComplianceTimelineResponseBodyResourceComplianceTimeline = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The information about the compliance timeline.
        self.resource_compliance_timeline = resource_compliance_timeline

    def validate(self):
        if self.resource_compliance_timeline:
            self.resource_compliance_timeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_compliance_timeline is not None:
            result['ResourceComplianceTimeline'] = self.resource_compliance_timeline.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceComplianceTimeline') is not None:
            temp_model = GetResourceComplianceTimelineResponseBodyResourceComplianceTimeline()
            self.resource_compliance_timeline = temp_model.from_map(m['ResourceComplianceTimeline'])
        return self


class GetResourceComplianceTimelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetResourceComplianceTimelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetResourceComplianceTimelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetResourceConfigurationTimelineRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        max_results: int = None,
        next_token: str = None,
        region: str = None,
        resource_id: str = None,
        resource_type: str = None,
        start_time: int = None,
    ):
        # The end of the time range to query. The default value indicates the time when the GetResourceConfigurationTimeline operation is called. Unit: milliseconds.
        self.end_time = end_time
        # The maximum number of entries to return for a single request. Valid values: 1 to 100.
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. You do not need to specify this parameter for the first request. You must specify the token that is obtained from the previous query as the value of `NextToken`.
        self.next_token = next_token
        # The region ID.
        # 
        # This parameter is required.
        self.region = region
        # The resource IDs.
        # 
        # For more information about how to query the ID of a resource, see [ListDiscoveredResources](https://help.aliyun.com/document_detail/169620.html).
        # 
        # This parameter is required.
        self.resource_id = resource_id
        # The resource type.
        # 
        # For more information about how to obtain the type of a resource, see [ListDiscoveredResources](https://help.aliyun.com/document_detail/169620.html).
        # 
        # This parameter is required.
        self.resource_type = resource_type
        # The beginning of the time range to query. By default, Cloud Config retrieves the configuration changes in the last 30 days for the specified resource. Unit: milliseconds.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetResourceConfigurationTimelineResponseBodyResourceConfigurationTimelineConfigurationList(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        availability_zone: str = None,
        capture_time: str = None,
        configuration_diff: str = None,
        region: str = None,
        relationship: str = None,
        relationship_diff: str = None,
        resource_create_time: str = None,
        resource_event_type: str = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_type: str = None,
        tags: str = None,
    ):
        # The ID of the Alibaba Cloud account to which the resource belongs.
        self.account_id = account_id
        # The zone ID.
        self.availability_zone = availability_zone
        # The time when the resource change snapshot was recorded. Unit: milliseconds.
        self.capture_time = capture_time
        # The details of the resource changes that trigger the compliance evaluation.
        self.configuration_diff = configuration_diff
        # The region ID.
        self.region = region
        # The details of each resource that is associated with the current resource, including the region ID, resource relationship, resource ID, and resource type.
        self.relationship = relationship
        # The change records of the resource relationship.
        self.relationship_diff = relationship_diff
        # The time when the resource was created. Unit: milliseconds.
        self.resource_create_time = resource_create_time
        # The type of the resource change event. Valid values:
        # 
        # *   DISCOVERED: A resource is created.
        # *   DISCOVERED_REVISED: A resource is created by periodic remediation tasks.
        # *   MODIFY: A resource is modified.
        # *   MODIFY_REVISED: A resource is modified by periodic remediation tasks.
        # *   REMOVE: A resource is deleted.
        # 
        # > 
        # 
        # *   To ensure the integrity of resources, periodic remediation tasks are run to check data and generate events that indicate the creation of new resources. Such events are infrequent.
        # 
        # *   The time when a resource change event is generated by a periodic remediation task is considered as the detection time of Cloud Config. The detection time is later than the time when the resource is modified.
        self.resource_event_type = resource_event_type
        # The resource ID.
        self.resource_id = resource_id
        # The resource name.
        self.resource_name = resource_name
        # The resource type.
        self.resource_type = resource_type
        # The tags of the resource.
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.availability_zone is not None:
            result['AvailabilityZone'] = self.availability_zone
        if self.capture_time is not None:
            result['CaptureTime'] = self.capture_time
        if self.configuration_diff is not None:
            result['ConfigurationDiff'] = self.configuration_diff
        if self.region is not None:
            result['Region'] = self.region
        if self.relationship is not None:
            result['Relationship'] = self.relationship
        if self.relationship_diff is not None:
            result['RelationshipDiff'] = self.relationship_diff
        if self.resource_create_time is not None:
            result['ResourceCreateTime'] = self.resource_create_time
        if self.resource_event_type is not None:
            result['ResourceEventType'] = self.resource_event_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AvailabilityZone') is not None:
            self.availability_zone = m.get('AvailabilityZone')
        if m.get('CaptureTime') is not None:
            self.capture_time = m.get('CaptureTime')
        if m.get('ConfigurationDiff') is not None:
            self.configuration_diff = m.get('ConfigurationDiff')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Relationship') is not None:
            self.relationship = m.get('Relationship')
        if m.get('RelationshipDiff') is not None:
            self.relationship_diff = m.get('RelationshipDiff')
        if m.get('ResourceCreateTime') is not None:
            self.resource_create_time = m.get('ResourceCreateTime')
        if m.get('ResourceEventType') is not None:
            self.resource_event_type = m.get('ResourceEventType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class GetResourceConfigurationTimelineResponseBodyResourceConfigurationTimeline(TeaModel):
    def __init__(
        self,
        configuration_list: List[GetResourceConfigurationTimelineResponseBodyResourceConfigurationTimelineConfigurationList] = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # The configuration changes on the configuration timeline.
        self.configuration_list = configuration_list
        # The maximum number of entries returned for a single request.
        self.max_results = max_results
        # A pagination token. It can be used in the next request to retrieve a new page of results.
        self.next_token = next_token

    def validate(self):
        if self.configuration_list:
            for k in self.configuration_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigurationList'] = []
        if self.configuration_list is not None:
            for k in self.configuration_list:
                result['ConfigurationList'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.configuration_list = []
        if m.get('ConfigurationList') is not None:
            for k in m.get('ConfigurationList'):
                temp_model = GetResourceConfigurationTimelineResponseBodyResourceConfigurationTimelineConfigurationList()
                self.configuration_list.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class GetResourceConfigurationTimelineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_configuration_timeline: GetResourceConfigurationTimelineResponseBodyResourceConfigurationTimeline = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The configuration timeline of the resource.
        self.resource_configuration_timeline = resource_configuration_timeline

    def validate(self):
        if self.resource_configuration_timeline:
            self.resource_configuration_timeline.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_configuration_timeline is not None:
            result['ResourceConfigurationTimeline'] = self.resource_configuration_timeline.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceConfigurationTimeline') is not None:
            temp_model = GetResourceConfigurationTimelineResponseBodyResourceConfigurationTimeline()
            self.resource_configuration_timeline = temp_model.from_map(m['ResourceConfigurationTimeline'])
        return self


class GetResourceConfigurationTimelineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetResourceConfigurationTimelineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetResourceConfigurationTimelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetResourceInventoryResponseBodyResourceInventory(TeaModel):
    def __init__(
        self,
        download_url: str = None,
        resource_inventory_generate_time: int = None,
        status: str = None,
    ):
        # The download URL of the resource inventory.
        self.download_url = download_url
        # The time when the resource inventory was generated. The value is a timestamp.
        self.resource_inventory_generate_time = resource_inventory_generate_time
        # The generation status of the resource inventory. Valid values:
        # 
        # *   CREATING: The resource inventory is being generated.
        # *   COMPLETE: The resource inventory is generated.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.resource_inventory_generate_time is not None:
            result['ResourceInventoryGenerateTime'] = self.resource_inventory_generate_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('ResourceInventoryGenerateTime') is not None:
            self.resource_inventory_generate_time = m.get('ResourceInventoryGenerateTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetResourceInventoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_inventory: GetResourceInventoryResponseBodyResourceInventory = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The information about the resource inventory.
        self.resource_inventory = resource_inventory

    def validate(self):
        if self.resource_inventory:
            self.resource_inventory.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_inventory is not None:
            result['ResourceInventory'] = self.resource_inventory.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceInventory') is not None:
            temp_model = GetResourceInventoryResponseBodyResourceInventory()
            self.resource_inventory = temp_model.from_map(m['ResourceInventory'])
        return self


class GetResourceInventoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetResourceInventoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetResourceInventoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSupportedResourceRelationConfigRequest(TeaModel):
    def __init__(
        self,
        resource_type: str = None,
    ):
        # The resource type.
        # 
        # This parameter is required.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class GetSupportedResourceRelationConfigResponseBodyResourceRelationConfigList(TeaModel):
    def __init__(
        self,
        relation_type: str = None,
        target_resource_type: str = None,
    ):
        # The type of the relationship between the resource and the object. Valid values:
        # 
        # *   IsContained: The object is included as part of the resource.
        # *   IsAttachedTo: The object is added to the resource.
        # *   IsAssociatedIn: The object is associated with the resource.
        # *   Contains: The actual value contains the expected value.
        self.relation_type = relation_type
        # The resource type.
        self.target_resource_type = target_resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.relation_type is not None:
            result['RelationType'] = self.relation_type
        if self.target_resource_type is not None:
            result['TargetResourceType'] = self.target_resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RelationType') is not None:
            self.relation_type = m.get('RelationType')
        if m.get('TargetResourceType') is not None:
            self.target_resource_type = m.get('TargetResourceType')
        return self


class GetSupportedResourceRelationConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_relation_config_list: List[GetSupportedResourceRelationConfigResponseBodyResourceRelationConfigList] = None,
    ):
        # The request ID.
        self.request_id = request_id
        # An array that contains the relationships.
        self.resource_relation_config_list = resource_relation_config_list

    def validate(self):
        if self.resource_relation_config_list:
            for k in self.resource_relation_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ResourceRelationConfigList'] = []
        if self.resource_relation_config_list is not None:
            for k in self.resource_relation_config_list:
                result['ResourceRelationConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.resource_relation_config_list = []
        if m.get('ResourceRelationConfigList') is not None:
            for k in m.get('ResourceRelationConfigList'):
                temp_model = GetSupportedResourceRelationConfigResponseBodyResourceRelationConfigList()
                self.resource_relation_config_list.append(temp_model.from_map(k))
        return self


class GetSupportedResourceRelationConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSupportedResourceRelationConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSupportedResourceRelationConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class IgnoreAggregateEvaluationResultsRequestResources(TeaModel):
    def __init__(
        self,
        region: str = None,
        resource_account_id: int = None,
        resource_id: str = None,
        resource_type: str = None,
    ):
        # The ID of the region in which the resource resides.
        # 
        # For more information about how to obtain the ID of a region, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        # 
        # This parameter is required.
        self.region = region
        # The ID of the Alibaba Cloud account to which the resources belong.
        # 
        # >  You must specify the ID of the current management account or a member account in the account group of the management account.
        # 
        # This parameter is required.
        self.resource_account_id = resource_account_id
        # The ID of the resource.
        # 
        # For more information about how to query the ID of a resource, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        # 
        # This parameter is required.
        self.resource_id = resource_id
        # The type of the resource.
        # 
        # For more information about how to query the type of a resource, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        # 
        # This parameter is required.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_account_id is not None:
            result['ResourceAccountId'] = self.resource_account_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceAccountId') is not None:
            self.resource_account_id = m.get('ResourceAccountId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class IgnoreAggregateEvaluationResultsRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        config_rule_id: str = None,
        ignore_date: str = None,
        reason: str = None,
        resources: List[IgnoreAggregateEvaluationResultsRequestResources] = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the rule.
        # 
        # For more information about how to obtain the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id
        # The date from which the system automatically re-evaluates the ignored incompliant resources.
        # 
        # >  If you leave this parameter empty, the system does not automatically re-evaluate the ignored incompliant resources. You must manually re-evaluate the ignored incompliant resources.
        self.ignore_date = ignore_date
        # The reason why you ignore the resource.
        self.reason = reason
        # The resources to be ignored.
        # 
        # This parameter is required.
        self.resources = resources

    def validate(self):
        if self.resources:
            for k in self.resources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.ignore_date is not None:
            result['IgnoreDate'] = self.ignore_date
        if self.reason is not None:
            result['Reason'] = self.reason
        result['Resources'] = []
        if self.resources is not None:
            for k in self.resources:
                result['Resources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('IgnoreDate') is not None:
            self.ignore_date = m.get('IgnoreDate')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        self.resources = []
        if m.get('Resources') is not None:
            for k in m.get('Resources'):
                temp_model = IgnoreAggregateEvaluationResultsRequestResources()
                self.resources.append(temp_model.from_map(k))
        return self


class IgnoreAggregateEvaluationResultsShrinkRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        config_rule_id: str = None,
        ignore_date: str = None,
        reason: str = None,
        resources_shrink: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the rule.
        # 
        # For more information about how to obtain the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id
        # The date from which the system automatically re-evaluates the ignored incompliant resources.
        # 
        # >  If you leave this parameter empty, the system does not automatically re-evaluate the ignored incompliant resources. You must manually re-evaluate the ignored incompliant resources.
        self.ignore_date = ignore_date
        # The reason why you ignore the resource.
        self.reason = reason
        # The resources to be ignored.
        # 
        # This parameter is required.
        self.resources_shrink = resources_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.ignore_date is not None:
            result['IgnoreDate'] = self.ignore_date
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.resources_shrink is not None:
            result['Resources'] = self.resources_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('IgnoreDate') is not None:
            self.ignore_date = m.get('IgnoreDate')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Resources') is not None:
            self.resources_shrink = m.get('Resources')
        return self


class IgnoreAggregateEvaluationResultsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class IgnoreAggregateEvaluationResultsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: IgnoreAggregateEvaluationResultsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = IgnoreAggregateEvaluationResultsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class IgnoreEvaluationResultsRequestResources(TeaModel):
    def __init__(
        self,
        region: str = None,
        resource_account_id: int = None,
        resource_id: str = None,
        resource_type: str = None,
    ):
        # The ID of the region in which the resource resides.
        # 
        # For more information about how to obtain the ID of the region in which a resource resides, see [ListDiscoveredResources](https://help.aliyun.com/document_detail/169620.html).
        # 
        # This parameter is required.
        self.region = region
        # The ID of the Alibaba Cloud account to which the resources belong.
        # 
        # This parameter is required.
        self.resource_account_id = resource_account_id
        # The ID of the resource.
        # 
        # For more information about how to obtain the ID of a resource, see [ListDiscoveredResources](https://help.aliyun.com/document_detail/169620.html).
        # 
        # This parameter is required.
        self.resource_id = resource_id
        # The type of the resource.
        # 
        # For more information about how to obtain the type of a resource, see [ListDiscoveredResources](https://help.aliyun.com/document_detail/169620.html).
        # 
        # This parameter is required.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_account_id is not None:
            result['ResourceAccountId'] = self.resource_account_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceAccountId') is not None:
            self.resource_account_id = m.get('ResourceAccountId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class IgnoreEvaluationResultsRequest(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        ignore_date: str = None,
        reason: str = None,
        resources: List[IgnoreEvaluationResultsRequestResources] = None,
    ):
        # The ID of the rule.
        # 
        # For more information about how to obtain the ID of a rule, see [ListConfigRules](https://help.aliyun.com/document_detail/169607.html).
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id
        # The date from which the system automatically re-evaluates the ignored incompliant resources.
        # 
        # >  If you leave this parameter empty, the system does not automatically re-evaluate the ignored incompliant resources. You must manually re-evaluate the ignored incompliant resources.
        self.ignore_date = ignore_date
        # The reason why you want to ignore the resource.
        self.reason = reason
        # The resources to be ignored.
        # 
        # This parameter is required.
        self.resources = resources

    def validate(self):
        if self.resources:
            for k in self.resources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.ignore_date is not None:
            result['IgnoreDate'] = self.ignore_date
        if self.reason is not None:
            result['Reason'] = self.reason
        result['Resources'] = []
        if self.resources is not None:
            for k in self.resources:
                result['Resources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('IgnoreDate') is not None:
            self.ignore_date = m.get('IgnoreDate')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        self.resources = []
        if m.get('Resources') is not None:
            for k in m.get('Resources'):
                temp_model = IgnoreEvaluationResultsRequestResources()
                self.resources.append(temp_model.from_map(k))
        return self


class IgnoreEvaluationResultsShrinkRequest(TeaModel):
    def __init__(
        self,
        config_rule_id: str = None,
        ignore_date: str = None,
        reason: str = None,
        resources_shrink: str = None,
    ):
        # The ID of the rule.
        # 
        # For more information about how to obtain the ID of a rule, see [ListConfigRules](https://help.aliyun.com/document_detail/169607.html).
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id
        # The date from which the system automatically re-evaluates the ignored incompliant resources.
        # 
        # >  If you leave this parameter empty, the system does not automatically re-evaluate the ignored incompliant resources. You must manually re-evaluate the ignored incompliant resources.
        self.ignore_date = ignore_date
        # The reason why you want to ignore the resource.
        self.reason = reason
        # The resources to be ignored.
        # 
        # This parameter is required.
        self.resources_shrink = resources_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.ignore_date is not None:
            result['IgnoreDate'] = self.ignore_date
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.resources_shrink is not None:
            result['Resources'] = self.resources_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('IgnoreDate') is not None:
            self.ignore_date = m.get('IgnoreDate')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Resources') is not None:
            self.resources_shrink = m.get('Resources')
        return self


class IgnoreEvaluationResultsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class IgnoreEvaluationResultsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: IgnoreEvaluationResultsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = IgnoreEvaluationResultsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAggregateCompliancePacksRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        page_number: int = None,
        page_size: int = None,
        status: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The number of the page to return.
        # 
        # Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page.
        # 
        # Valid values: 1 to 100. Default value: 10.
        self.page_size = page_size
        # The status of the one or more compliance packages to be queried. Valid values:
        # 
        # *   ACTIVE: compliance packages that are available for use.
        # *   CREATING: compliance packages that are being created.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListAggregateCompliancePacksResponseBodyCompliancePacksResultCompliancePacks(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
        compliance_pack_name: str = None,
        compliance_pack_template_id: str = None,
        create_timestamp: int = None,
        description: str = None,
        risk_level: int = None,
        status: str = None,
    ):
        # The ID of the management account to which the compliance package belongs.
        self.account_id = account_id
        # The ID of the account group.
        self.aggregator_id = aggregator_id
        # The ID of the compliance package.
        self.compliance_pack_id = compliance_pack_id
        # The name of the compliance package.
        self.compliance_pack_name = compliance_pack_name
        # The ID of the compliance package template.
        self.compliance_pack_template_id = compliance_pack_template_id
        # The timestamp when the compliance package was created. Unit: milliseconds.
        self.create_timestamp = create_timestamp
        # The description of the compliance package.
        self.description = description
        # The risk level of the resources that are not compliant with the managed rules in the compliance package. Valid values:
        # 
        # *   1: high risk level.
        # *   2: medium risk level.
        # *   3: low risk level.
        self.risk_level = risk_level
        # The status of the compliance package. Valid values:
        # 
        # *   ACTIVE: The compliance package is available for use.
        # *   CREATING: The compliance package is being created.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.compliance_pack_name is not None:
            result['CompliancePackName'] = self.compliance_pack_name
        if self.compliance_pack_template_id is not None:
            result['CompliancePackTemplateId'] = self.compliance_pack_template_id
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.description is not None:
            result['Description'] = self.description
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('CompliancePackName') is not None:
            self.compliance_pack_name = m.get('CompliancePackName')
        if m.get('CompliancePackTemplateId') is not None:
            self.compliance_pack_template_id = m.get('CompliancePackTemplateId')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListAggregateCompliancePacksResponseBodyCompliancePacksResult(TeaModel):
    def __init__(
        self,
        compliance_packs: List[ListAggregateCompliancePacksResponseBodyCompliancePacksResultCompliancePacks] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The details of the compliance package.
        self.compliance_packs = compliance_packs
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of compliance packages returned.
        self.total_count = total_count

    def validate(self):
        if self.compliance_packs:
            for k in self.compliance_packs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CompliancePacks'] = []
        if self.compliance_packs is not None:
            for k in self.compliance_packs:
                result['CompliancePacks'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.compliance_packs = []
        if m.get('CompliancePacks') is not None:
            for k in m.get('CompliancePacks'):
                temp_model = ListAggregateCompliancePacksResponseBodyCompliancePacksResultCompliancePacks()
                self.compliance_packs.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAggregateCompliancePacksResponseBody(TeaModel):
    def __init__(
        self,
        compliance_packs_result: ListAggregateCompliancePacksResponseBodyCompliancePacksResult = None,
        request_id: str = None,
    ):
        # The information about the compliance packages.
        self.compliance_packs_result = compliance_packs_result
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.compliance_packs_result:
            self.compliance_packs_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_packs_result is not None:
            result['CompliancePacksResult'] = self.compliance_packs_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePacksResult') is not None:
            temp_model = ListAggregateCompliancePacksResponseBodyCompliancePacksResult()
            self.compliance_packs_result = temp_model.from_map(m['CompliancePacksResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAggregateCompliancePacksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAggregateCompliancePacksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAggregateCompliancePacksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAggregateConfigDeliveryChannelsRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        delivery_channel_ids: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The IDs of the delivery channels. Separate multiple IDs with commas (,).
        self.delivery_channel_ids = delivery_channel_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.delivery_channel_ids is not None:
            result['DeliveryChannelIds'] = self.delivery_channel_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('DeliveryChannelIds') is not None:
            self.delivery_channel_ids = m.get('DeliveryChannelIds')
        return self


class ListAggregateConfigDeliveryChannelsResponseBodyDeliveryChannels(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        aggregator_id: str = None,
        compliant_snapshot: bool = None,
        configuration_item_change_notification: bool = None,
        configuration_snapshot: bool = None,
        delivery_channel_assume_role_arn: str = None,
        delivery_channel_condition: str = None,
        delivery_channel_id: str = None,
        delivery_channel_name: str = None,
        delivery_channel_target_arn: str = None,
        delivery_channel_type: str = None,
        delivery_snapshot_time: str = None,
        description: str = None,
        non_compliant_notification: bool = None,
        oversized_data_osstarget_arn: str = None,
        status: int = None,
    ):
        # The ID of the member in the account group.
        self.account_id = account_id
        # The ID of the account group.
        self.aggregator_id = aggregator_id
        # Indicates whether the specified destination receives scheduled compliant snapshots. Cloud Config delivers scheduled compliant snapshots at `04:00Z` and `16:00Z` to Log Service every day. The time is displayed in UTC. Valid values:
        # 
        # *   true: The specified destination receives scheduled compliant snapshots.
        # *   false: The specified destination does not receive scheduled compliant snapshots.
        self.compliant_snapshot = compliant_snapshot
        # Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:
        # 
        # *   true: The specified destination receives resource change logs.
        # *   false: The specified destination does not receive resource change logs.
        self.configuration_item_change_notification = configuration_item_change_notification
        # Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at `04:00Z` and `16:00Z` to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:
        # 
        # *   true: The specified destination receives scheduled resource snapshots.
        # *   false: The specified destination does not receive scheduled resource snapshots.
        self.configuration_snapshot = configuration_snapshot
        # The ARN of the role that is assigned to the delivery channel.
        self.delivery_channel_assume_role_arn = delivery_channel_assume_role_arn
        # The rule that is attached to the delivery channel. This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
        # 
        # *   If the value of the DeliveryChannelType parameter is MNS, take note of the following settings of the lowest risk level and resource types of the events to which you subscribed:
        # 
        #     *   The lowest risk level of the events to which you want to subscribe is in the following format: `{"filterType":"RuleRiskLevel","value":"1","multiple":false}`.
        # 
        #         The `value` field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
        # 
        #     *   The setting of the resource types of the events to which you want to subscribe is in the following format: `{"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}`.
        # 
        #         The `values` field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array. Examples:
        # 
        # `[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}]`
        # 
        # *   If you set the DeliveryChannelType parameter to SLS, the setting of the resource types of the snapshots to which you want to deliver is in the following format: `{"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}`.
        # 
        #     The `values` field specifies the resource types of the snapshots to which you want to deliver. The value of the field is a JSON array. Examples:
        # 
        # `[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}]`
        self.delivery_channel_condition = delivery_channel_condition
        # The ID of the delivery channel.
        self.delivery_channel_id = delivery_channel_id
        # The name of the delivery channel.
        self.delivery_channel_name = delivery_channel_name
        # The ARN of the delivery destination.
        # 
        # *   If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
        # *   If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
        # *   If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        self.delivery_channel_target_arn = delivery_channel_target_arn
        # The type of the delivery channel. Valid values:
        # 
        # *   OSS: Object Storage Service (OSS)
        # *   MNS: Message Service (MNS)
        # *   SLS: Log Service
        self.delivery_channel_type = delivery_channel_type
        # The time when Cloud Config delivers scheduled resources snapshots every day.
        # 
        # Format: `HH:mmZ`. This time is displayed in UTC.
        self.delivery_snapshot_time = delivery_snapshot_time
        # The description of the delivery channel.
        self.description = description
        # Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:
        # 
        # *   true: The specified destination receives resource non-compliance events.
        # *   false: The specified destination does not receive resource non-compliance events.
        self.non_compliant_notification = non_compliant_notification
        # The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
        self.oversized_data_osstarget_arn = oversized_data_osstarget_arn
        # The status of the delivery channel. Valid values:
        # 
        # *   0: The delivery channel is disabled.
        # *   1: The delivery channel is enabled.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliant_snapshot is not None:
            result['CompliantSnapshot'] = self.compliant_snapshot
        if self.configuration_item_change_notification is not None:
            result['ConfigurationItemChangeNotification'] = self.configuration_item_change_notification
        if self.configuration_snapshot is not None:
            result['ConfigurationSnapshot'] = self.configuration_snapshot
        if self.delivery_channel_assume_role_arn is not None:
            result['DeliveryChannelAssumeRoleArn'] = self.delivery_channel_assume_role_arn
        if self.delivery_channel_condition is not None:
            result['DeliveryChannelCondition'] = self.delivery_channel_condition
        if self.delivery_channel_id is not None:
            result['DeliveryChannelId'] = self.delivery_channel_id
        if self.delivery_channel_name is not None:
            result['DeliveryChannelName'] = self.delivery_channel_name
        if self.delivery_channel_target_arn is not None:
            result['DeliveryChannelTargetArn'] = self.delivery_channel_target_arn
        if self.delivery_channel_type is not None:
            result['DeliveryChannelType'] = self.delivery_channel_type
        if self.delivery_snapshot_time is not None:
            result['DeliverySnapshotTime'] = self.delivery_snapshot_time
        if self.description is not None:
            result['Description'] = self.description
        if self.non_compliant_notification is not None:
            result['NonCompliantNotification'] = self.non_compliant_notification
        if self.oversized_data_osstarget_arn is not None:
            result['OversizedDataOSSTargetArn'] = self.oversized_data_osstarget_arn
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliantSnapshot') is not None:
            self.compliant_snapshot = m.get('CompliantSnapshot')
        if m.get('ConfigurationItemChangeNotification') is not None:
            self.configuration_item_change_notification = m.get('ConfigurationItemChangeNotification')
        if m.get('ConfigurationSnapshot') is not None:
            self.configuration_snapshot = m.get('ConfigurationSnapshot')
        if m.get('DeliveryChannelAssumeRoleArn') is not None:
            self.delivery_channel_assume_role_arn = m.get('DeliveryChannelAssumeRoleArn')
        if m.get('DeliveryChannelCondition') is not None:
            self.delivery_channel_condition = m.get('DeliveryChannelCondition')
        if m.get('DeliveryChannelId') is not None:
            self.delivery_channel_id = m.get('DeliveryChannelId')
        if m.get('DeliveryChannelName') is not None:
            self.delivery_channel_name = m.get('DeliveryChannelName')
        if m.get('DeliveryChannelTargetArn') is not None:
            self.delivery_channel_target_arn = m.get('DeliveryChannelTargetArn')
        if m.get('DeliveryChannelType') is not None:
            self.delivery_channel_type = m.get('DeliveryChannelType')
        if m.get('DeliverySnapshotTime') is not None:
            self.delivery_snapshot_time = m.get('DeliverySnapshotTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NonCompliantNotification') is not None:
            self.non_compliant_notification = m.get('NonCompliantNotification')
        if m.get('OversizedDataOSSTargetArn') is not None:
            self.oversized_data_osstarget_arn = m.get('OversizedDataOSSTargetArn')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListAggregateConfigDeliveryChannelsResponseBody(TeaModel):
    def __init__(
        self,
        delivery_channels: List[ListAggregateConfigDeliveryChannelsResponseBodyDeliveryChannels] = None,
        request_id: str = None,
    ):
        # The information about the delivery channels.
        self.delivery_channels = delivery_channels
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.delivery_channels:
            for k in self.delivery_channels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeliveryChannels'] = []
        if self.delivery_channels is not None:
            for k in self.delivery_channels:
                result['DeliveryChannels'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.delivery_channels = []
        if m.get('DeliveryChannels') is not None:
            for k in m.get('DeliveryChannels'):
                temp_model = ListAggregateConfigDeliveryChannelsResponseBodyDeliveryChannels()
                self.delivery_channels.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAggregateConfigDeliveryChannelsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAggregateConfigDeliveryChannelsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAggregateConfigDeliveryChannelsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAggregateConfigRuleEvaluationResultsRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
        compliance_type: str = None,
        config_rule_id: str = None,
        max_results: int = None,
        next_token: str = None,
        regions: str = None,
        resource_account_id: int = None,
        resource_group_ids: str = None,
        resource_owner_id: int = None,
        resource_types: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The ID of the compliance package.
        # 
        # For more information about how to obtain the ID of a compliance package, see [ListAggregateCompliancePacks](https://help.aliyun.com/document_detail/262059.html).
        self.compliance_pack_id = compliance_pack_id
        # The compliance evaluation result of the resource. Valid values:
        # 
        # *   COMPLIANT: The resource is evaluated as compliant.
        # *   NON_COMPLIANT: The resource is evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to your resource.
        # *   INSUFFICIENT_DATA: No data is available.
        # *   IGNORED: The resource is ignored during compliance evaluation.
        self.compliance_type = compliance_type
        # The rule ID.
        # 
        # For more information about how to query the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        self.config_rule_id = config_rule_id
        # The maximum number of entries to return in a request. Valid values: 1 to 100.
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. You do not need to specify this parameter for the first request. You must specify the token that is obtained from the previous query as the value of `NextToken`.
        self.next_token = next_token
        # The ID of the region whose resources you want to evaluate. Separate multiple region IDs with commas (,).
        self.regions = regions
        # Member accountId to which the resource to be queried belongs.
        self.resource_account_id = resource_account_id
        # The ID of the resource group whose resources you want to evaluate. Separate multiple resource group IDs with commas (,).
        self.resource_group_ids = resource_group_ids
        self.resource_owner_id = resource_owner_id
        # The type of the resources that you want to evaluate. Separate multiple resource types with commas (,).
        self.resource_types = resource_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.regions is not None:
            result['Regions'] = self.regions
        if self.resource_account_id is not None:
            result['ResourceAccountId'] = self.resource_account_id
        if self.resource_group_ids is not None:
            result['ResourceGroupIds'] = self.resource_group_ids
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_types is not None:
            result['ResourceTypes'] = self.resource_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Regions') is not None:
            self.regions = m.get('Regions')
        if m.get('ResourceAccountId') is not None:
            self.resource_account_id = m.get('ResourceAccountId')
        if m.get('ResourceGroupIds') is not None:
            self.resource_group_ids = m.get('ResourceGroupIds')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceTypes') is not None:
            self.resource_types = m.get('ResourceTypes')
        return self


class ListAggregateConfigRuleEvaluationResultsResponseBodyEvaluationResultsEvaluationResultListEvaluationResultIdentifierEvaluationResultQualifier(TeaModel):
    def __init__(
        self,
        compliance_pack_id: str = None,
        config_rule_arn: str = None,
        config_rule_id: str = None,
        config_rule_name: str = None,
        ignore_date: str = None,
        region_id: str = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_owner_id: int = None,
        resource_type: str = None,
    ):
        # The ID of the compliance package to which the rule belongs.
        self.compliance_pack_id = compliance_pack_id
        # The ARN of the rule.
        self.config_rule_arn = config_rule_arn
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The rule name.
        self.config_rule_name = config_rule_name
        # The date on which the system automatically re-evaluates the ignored incompliant resources.
        # 
        # >  If the value of this parameter is left empty, the system does not automatically re-evaluate the ignored incompliant resources. You must manually re-evaluate the ignored incompliant resources.
        self.ignore_date = ignore_date
        # The ID of the region in which your resources reside.
        self.region_id = region_id
        # The resource ID.
        self.resource_id = resource_id
        # The resource name.
        self.resource_name = resource_name
        # The ID of the Alibaba Cloud account to which the resource belongs.
        self.resource_owner_id = resource_owner_id
        # The type of the resource.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.config_rule_arn is not None:
            result['ConfigRuleArn'] = self.config_rule_arn
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        if self.ignore_date is not None:
            result['IgnoreDate'] = self.ignore_date
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ConfigRuleArn') is not None:
            self.config_rule_arn = m.get('ConfigRuleArn')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        if m.get('IgnoreDate') is not None:
            self.ignore_date = m.get('IgnoreDate')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class ListAggregateConfigRuleEvaluationResultsResponseBodyEvaluationResultsEvaluationResultListEvaluationResultIdentifier(TeaModel):
    def __init__(
        self,
        evaluation_result_qualifier: ListAggregateConfigRuleEvaluationResultsResponseBodyEvaluationResultsEvaluationResultListEvaluationResultIdentifierEvaluationResultQualifier = None,
        ordering_timestamp: int = None,
    ):
        # The information about the evaluated resource in the compliance evaluation result.
        self.evaluation_result_qualifier = evaluation_result_qualifier
        # The timestamp when the compliance evaluation was performed. Unit: milliseconds.
        # 
        # >  This timestamp indicates the time when the rule was triggered. You can obtain the timestamp from the `ConfigRuleInvokedTimestamp` parameter.
        self.ordering_timestamp = ordering_timestamp

    def validate(self):
        if self.evaluation_result_qualifier:
            self.evaluation_result_qualifier.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.evaluation_result_qualifier is not None:
            result['EvaluationResultQualifier'] = self.evaluation_result_qualifier.to_map()
        if self.ordering_timestamp is not None:
            result['OrderingTimestamp'] = self.ordering_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EvaluationResultQualifier') is not None:
            temp_model = ListAggregateConfigRuleEvaluationResultsResponseBodyEvaluationResultsEvaluationResultListEvaluationResultIdentifierEvaluationResultQualifier()
            self.evaluation_result_qualifier = temp_model.from_map(m['EvaluationResultQualifier'])
        if m.get('OrderingTimestamp') is not None:
            self.ordering_timestamp = m.get('OrderingTimestamp')
        return self


class ListAggregateConfigRuleEvaluationResultsResponseBodyEvaluationResultsEvaluationResultList(TeaModel):
    def __init__(
        self,
        annotation: str = None,
        compliance_type: str = None,
        config_rule_invoked_timestamp: int = None,
        evaluation_result_identifier: ListAggregateConfigRuleEvaluationResultsResponseBodyEvaluationResultsEvaluationResultListEvaluationResultIdentifier = None,
        invoking_event_message_type: str = None,
        remediation_enabled: bool = None,
        result_recorded_timestamp: int = None,
        risk_level: int = None,
    ):
        # The annotation to the resource that is evaluated as non-compliant. The following parameters may be returned:
        # 
        # *   `configuration`: the current resource configuration that is evaluated as incompliant by using the rule.
        # *   `desiredValue`: the expected resource configuration that is evaluated as compliant.
        # *   `operator`: the operator that compares the current configuration with the expected configuration of the resource.
        # *   `property`: the JSON path of the current configuration in the resource property struct.
        # *   `reason`: the reason why the resource is evaluated as non-compliant.
        self.annotation = annotation
        # The compliance evaluation result of the resource. Valid values:
        # 
        # *   COMPLIANT: The resource is evaluated as compliant.
        # *   NON_COMPLIANT: The resource is evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to your resource.
        # *   INSUFFICIENT_DATA: No data is available.
        # *   IGNORED: The resource is ignored during compliance evaluation.
        self.compliance_type = compliance_type
        # The timestamp when the rule was triggered for the compliance evaluation. Unit: milliseconds.
        self.config_rule_invoked_timestamp = config_rule_invoked_timestamp
        # The identifying information about the compliance evaluation result.
        self.evaluation_result_identifier = evaluation_result_identifier
        # The trigger type of the rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The rule is triggered by configuration changes.
        # *   ScheduledNotification: The rule is periodically triggered.
        self.invoking_event_message_type = invoking_event_message_type
        # Indicates whether the remediation template is enabled. Valid values:
        # 
        # *   true
        # *   false
        self.remediation_enabled = remediation_enabled
        # The timestamp when the compliance evaluation result was recorded. The value of this parameter is a UNIX timestamp in milliseconds.
        self.result_recorded_timestamp = result_recorded_timestamp
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high
        # *   2: medium.
        # *   3: low.
        self.risk_level = risk_level

    def validate(self):
        if self.evaluation_result_identifier:
            self.evaluation_result_identifier.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotation is not None:
            result['Annotation'] = self.annotation
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.config_rule_invoked_timestamp is not None:
            result['ConfigRuleInvokedTimestamp'] = self.config_rule_invoked_timestamp
        if self.evaluation_result_identifier is not None:
            result['EvaluationResultIdentifier'] = self.evaluation_result_identifier.to_map()
        if self.invoking_event_message_type is not None:
            result['InvokingEventMessageType'] = self.invoking_event_message_type
        if self.remediation_enabled is not None:
            result['RemediationEnabled'] = self.remediation_enabled
        if self.result_recorded_timestamp is not None:
            result['ResultRecordedTimestamp'] = self.result_recorded_timestamp
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Annotation') is not None:
            self.annotation = m.get('Annotation')
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('ConfigRuleInvokedTimestamp') is not None:
            self.config_rule_invoked_timestamp = m.get('ConfigRuleInvokedTimestamp')
        if m.get('EvaluationResultIdentifier') is not None:
            temp_model = ListAggregateConfigRuleEvaluationResultsResponseBodyEvaluationResultsEvaluationResultListEvaluationResultIdentifier()
            self.evaluation_result_identifier = temp_model.from_map(m['EvaluationResultIdentifier'])
        if m.get('InvokingEventMessageType') is not None:
            self.invoking_event_message_type = m.get('InvokingEventMessageType')
        if m.get('RemediationEnabled') is not None:
            self.remediation_enabled = m.get('RemediationEnabled')
        if m.get('ResultRecordedTimestamp') is not None:
            self.result_recorded_timestamp = m.get('ResultRecordedTimestamp')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class ListAggregateConfigRuleEvaluationResultsResponseBodyEvaluationResults(TeaModel):
    def __init__(
        self,
        evaluation_result_list: List[ListAggregateConfigRuleEvaluationResultsResponseBodyEvaluationResultsEvaluationResultList] = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # The details of the compliance evaluation result.
        self.evaluation_result_list = evaluation_result_list
        # The maximum number of entries returned on each page.
        self.max_results = max_results
        # A pagination token. It can be used in the next request to retrieve a new page of results.
        self.next_token = next_token

    def validate(self):
        if self.evaluation_result_list:
            for k in self.evaluation_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EvaluationResultList'] = []
        if self.evaluation_result_list is not None:
            for k in self.evaluation_result_list:
                result['EvaluationResultList'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.evaluation_result_list = []
        if m.get('EvaluationResultList') is not None:
            for k in m.get('EvaluationResultList'):
                temp_model = ListAggregateConfigRuleEvaluationResultsResponseBodyEvaluationResultsEvaluationResultList()
                self.evaluation_result_list.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListAggregateConfigRuleEvaluationResultsResponseBody(TeaModel):
    def __init__(
        self,
        evaluation_results: ListAggregateConfigRuleEvaluationResultsResponseBodyEvaluationResults = None,
        request_id: str = None,
    ):
        # The information about the compliance evaluation results returned.
        self.evaluation_results = evaluation_results
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.evaluation_results:
            self.evaluation_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.evaluation_results is not None:
            result['EvaluationResults'] = self.evaluation_results.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EvaluationResults') is not None:
            temp_model = ListAggregateConfigRuleEvaluationResultsResponseBodyEvaluationResults()
            self.evaluation_results = temp_model.from_map(m['EvaluationResults'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAggregateConfigRuleEvaluationResultsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAggregateConfigRuleEvaluationResultsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAggregateConfigRuleEvaluationResultsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAggregateConfigRuleEvaluationStatisticsRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        return self


class ListAggregateConfigRuleEvaluationStatisticsResponseBodyEvaluationResults(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        non_compliant_resource_cnt: int = None,
        non_compliant_rule_cnt: int = None,
        statistic_date: str = None,
        total_resource_cnt: int = None,
        total_rule_cnt: int = None,
    ):
        # The ID of the account group.
        self.aggregator_id = aggregator_id
        # The number of resources that are evaluated as non-compliant.
        self.non_compliant_resource_cnt = non_compliant_resource_cnt
        # The number of rules based on which resources are evaluated as non-compliant.
        self.non_compliant_rule_cnt = non_compliant_rule_cnt
        # The date on which the statistics are obtained.
        self.statistic_date = statistic_date
        # The total number of resources.
        self.total_resource_cnt = total_resource_cnt
        # The total number of rules.
        self.total_rule_cnt = total_rule_cnt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.non_compliant_resource_cnt is not None:
            result['NonCompliantResourceCnt'] = self.non_compliant_resource_cnt
        if self.non_compliant_rule_cnt is not None:
            result['NonCompliantRuleCnt'] = self.non_compliant_rule_cnt
        if self.statistic_date is not None:
            result['StatisticDate'] = self.statistic_date
        if self.total_resource_cnt is not None:
            result['TotalResourceCnt'] = self.total_resource_cnt
        if self.total_rule_cnt is not None:
            result['TotalRuleCnt'] = self.total_rule_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('NonCompliantResourceCnt') is not None:
            self.non_compliant_resource_cnt = m.get('NonCompliantResourceCnt')
        if m.get('NonCompliantRuleCnt') is not None:
            self.non_compliant_rule_cnt = m.get('NonCompliantRuleCnt')
        if m.get('StatisticDate') is not None:
            self.statistic_date = m.get('StatisticDate')
        if m.get('TotalResourceCnt') is not None:
            self.total_resource_cnt = m.get('TotalResourceCnt')
        if m.get('TotalRuleCnt') is not None:
            self.total_rule_cnt = m.get('TotalRuleCnt')
        return self


class ListAggregateConfigRuleEvaluationStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        evaluation_results: List[ListAggregateConfigRuleEvaluationStatisticsResponseBodyEvaluationResults] = None,
        request_id: str = None,
    ):
        # The statistics of compliance evaluation results.
        self.evaluation_results = evaluation_results
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.evaluation_results:
            for k in self.evaluation_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EvaluationResults'] = []
        if self.evaluation_results is not None:
            for k in self.evaluation_results:
                result['EvaluationResults'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.evaluation_results = []
        if m.get('EvaluationResults') is not None:
            for k in m.get('EvaluationResults'):
                temp_model = ListAggregateConfigRuleEvaluationStatisticsResponseBodyEvaluationResults()
                self.evaluation_results.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAggregateConfigRuleEvaluationStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAggregateConfigRuleEvaluationStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAggregateConfigRuleEvaluationStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAggregateConfigRulesRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_pack_id: str = None,
        compliance_type: str = None,
        config_rule_name: str = None,
        config_rule_state: str = None,
        keyword: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_types: str = None,
        risk_level: int = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The compliance package ID.
        self.compliance_pack_id = compliance_pack_id
        # The compliance evaluation result. Valid values:
        # 
        # *   COMPLIANT: The resources are evaluated as compliant.
        # *   NON_COMPLIANT: The resources are evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to the resources.
        # *   INSUFFICIENT_DATA: No data is available.
        self.compliance_type = compliance_type
        # The name of the rule.
        self.config_rule_name = config_rule_name
        # The status of the rule. Valid values:
        # 
        # *   ACTIVE: The rule is being used to monitor resource configurations.
        # *   DELETING: The rule is being deleted.
        # *   EVALUATING: The rule is triggered and is being used to monitor resource configurations.
        # *   INACTIVE: The rule is disabled.
        self.config_rule_state = config_rule_state
        # The keyword that is used for queries.
        # 
        # You can perform a fuzzy search by rule ID, rule name, rule description, or managed rule ID.
        self.keyword = keyword
        # The page number.
        # 
        # Pages start from page 1. Default value: 1
        self.page_number = page_number
        # The number of entries per page.
        # 
        # Valid values: 1 to 100. Minimum value: 1. Default value: 10
        self.page_size = page_size
        # Resource type for the rule to evaluate.
        self.resource_types = resource_types
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high
        # *   2: medium
        # *   3: low
        self.risk_level = risk_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        if self.config_rule_state is not None:
            result['ConfigRuleState'] = self.config_rule_state
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_types is not None:
            result['ResourceTypes'] = self.resource_types
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        if m.get('ConfigRuleState') is not None:
            self.config_rule_state = m.get('ConfigRuleState')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceTypes') is not None:
            self.resource_types = m.get('ResourceTypes')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class ListAggregateConfigRulesResponseBodyConfigRulesConfigRuleListCompliance(TeaModel):
    def __init__(
        self,
        compliance_type: str = None,
        count: int = None,
    ):
        # The compliance evaluation result. Valid values:
        # 
        # *   COMPLIANT: The resources are evaluated as compliant.
        # *   NON_COMPLIANT: The resources are evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to the resources.
        # *   INSUFFICIENT_DATA: No data is available.
        self.compliance_type = compliance_type
        # The number of evaluation resources that correspond to the summary result of the rule compliance evaluation.
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class ListAggregateConfigRulesResponseBodyConfigRulesConfigRuleListCreateBy(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        aggregator_name: str = None,
        compliance_pack_id: str = None,
        compliance_pack_name: str = None,
        creator_id: str = None,
        creator_name: str = None,
        creator_type: str = None,
    ):
        # The account group ID.
        self.aggregator_id = aggregator_id
        # The name of the account group.
        self.aggregator_name = aggregator_name
        # The compliance package ID.
        self.compliance_pack_id = compliance_pack_id
        # The name of the compliance package.
        self.compliance_pack_name = compliance_pack_name
        # The ID of the management account that created the rule.
        self.creator_id = creator_id
        # The name of the management account that create the rule.
        self.creator_name = creator_name
        # The type of the creator of the rule. The value is fixed to AGGREGATOR, which indicates an account group.
        self.creator_type = creator_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.aggregator_name is not None:
            result['AggregatorName'] = self.aggregator_name
        if self.compliance_pack_id is not None:
            result['CompliancePackId'] = self.compliance_pack_id
        if self.compliance_pack_name is not None:
            result['CompliancePackName'] = self.compliance_pack_name
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        if self.creator_type is not None:
            result['CreatorType'] = self.creator_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('AggregatorName') is not None:
            self.aggregator_name = m.get('AggregatorName')
        if m.get('CompliancePackId') is not None:
            self.compliance_pack_id = m.get('CompliancePackId')
        if m.get('CompliancePackName') is not None:
            self.compliance_pack_name = m.get('CompliancePackName')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        if m.get('CreatorType') is not None:
            self.creator_type = m.get('CreatorType')
        return self


class ListAggregateConfigRulesResponseBodyConfigRulesConfigRuleListTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key of the rule.
        self.key = key
        # The tag value of the rule.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListAggregateConfigRulesResponseBodyConfigRulesConfigRuleList(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        automation_type: str = None,
        compliance: ListAggregateConfigRulesResponseBodyConfigRulesConfigRuleListCompliance = None,
        config_rule_arn: str = None,
        config_rule_id: str = None,
        config_rule_name: str = None,
        config_rule_state: str = None,
        create_by: ListAggregateConfigRulesResponseBodyConfigRulesConfigRuleListCreateBy = None,
        description: str = None,
        resource_types_scope: str = None,
        risk_level: int = None,
        source_identifier: str = None,
        source_owner: str = None,
        tags: List[ListAggregateConfigRulesResponseBodyConfigRulesConfigRuleListTags] = None,
    ):
        # The ID of the management account to which the rules belong.
        self.account_id = account_id
        # The type of the remediation template. Only OOS is returned, which indicates CloudOps Orchestration Service.
        self.automation_type = automation_type
        # The compliance evaluation result.
        self.compliance = compliance
        # The ARN of the rule.
        self.config_rule_arn = config_rule_arn
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The name of the rule.
        self.config_rule_name = config_rule_name
        # The status of the rule. Valid values:
        # 
        # *   ACTIVE: The rule is being used to monitor resource configurations.
        # *   DELETING: The rule is being deleted.
        # *   EVALUATING: The rule is triggered and is being used to monitor resource configurations.
        # *   INACTIVE: The rule is disabled.
        self.config_rule_state = config_rule_state
        # The information about the creation of the rule.
        self.create_by = create_by
        # The description of the rule.
        self.description = description
        # The types of resources evaluated by the rule. Multiple resource types are separated with commas (,).
        self.resource_types_scope = resource_types_scope
        # The risk level of the resources that do not comply with the rule. Valid values:
        # 
        # *   1: high
        # *   2: medium
        # *   3: low
        self.risk_level = risk_level
        # The identifier of the rule.
        # 
        # *   If the rule is a managed rule, the value of this parameter is the name of the managed rule.
        # *   If the rule is a custom rule, the value of this parameter is the Alibaba Cloud Resource Name (ARN) of a function.
        self.source_identifier = source_identifier
        # The type of the rule. Valid values:
        # 
        # *   CUSTOM_FC: a custom rule.
        # *   ALIYUN: a managed rule.
        self.source_owner = source_owner
        # The tags of the rule.
        self.tags = tags

    def validate(self):
        if self.compliance:
            self.compliance.validate()
        if self.create_by:
            self.create_by.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.automation_type is not None:
            result['AutomationType'] = self.automation_type
        if self.compliance is not None:
            result['Compliance'] = self.compliance.to_map()
        if self.config_rule_arn is not None:
            result['ConfigRuleArn'] = self.config_rule_arn
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        if self.config_rule_state is not None:
            result['ConfigRuleState'] = self.config_rule_state
        if self.create_by is not None:
            result['CreateBy'] = self.create_by.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.resource_types_scope is not None:
            result['ResourceTypesScope'] = self.resource_types_scope
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.source_identifier is not None:
            result['SourceIdentifier'] = self.source_identifier
        if self.source_owner is not None:
            result['SourceOwner'] = self.source_owner
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AutomationType') is not None:
            self.automation_type = m.get('AutomationType')
        if m.get('Compliance') is not None:
            temp_model = ListAggregateConfigRulesResponseBodyConfigRulesConfigRuleListCompliance()
            self.compliance = temp_model.from_map(m['Compliance'])
        if m.get('ConfigRuleArn') is not None:
            self.config_rule_arn = m.get('ConfigRuleArn')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        if m.get('ConfigRuleState') is not None:
            self.config_rule_state = m.get('ConfigRuleState')
        if m.get('CreateBy') is not None:
            temp_model = ListAggregateConfigRulesResponseBodyConfigRulesConfigRuleListCreateBy()
            self.create_by = temp_model.from_map(m['CreateBy'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResourceTypesScope') is not None:
            self.resource_types_scope = m.get('ResourceTypesScope')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SourceIdentifier') is not None:
            self.source_identifier = m.get('SourceIdentifier')
        if m.get('SourceOwner') is not None:
            self.source_owner = m.get('SourceOwner')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListAggregateConfigRulesResponseBodyConfigRulesConfigRuleListTags()
                self.tags.append(temp_model.from_map(k))
        return self


class ListAggregateConfigRulesResponseBodyConfigRules(TeaModel):
    def __init__(
        self,
        config_rule_list: List[ListAggregateConfigRulesResponseBodyConfigRulesConfigRuleList] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The details of the rule.
        self.config_rule_list = config_rule_list
        # The number of the page returned.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of rules.
        self.total_count = total_count

    def validate(self):
        if self.config_rule_list:
            for k in self.config_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigRuleList'] = []
        if self.config_rule_list is not None:
            for k in self.config_rule_list:
                result['ConfigRuleList'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_rule_list = []
        if m.get('ConfigRuleList') is not None:
            for k in m.get('ConfigRuleList'):
                temp_model = ListAggregateConfigRulesResponseBodyConfigRulesConfigRuleList()
                self.config_rule_list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAggregateConfigRulesResponseBody(TeaModel):
    def __init__(
        self,
        config_rules: ListAggregateConfigRulesResponseBodyConfigRules = None,
        request_id: str = None,
    ):
        # The queried rules.
        self.config_rules = config_rules
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.config_rules:
            self.config_rules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rules is not None:
            result['ConfigRules'] = self.config_rules.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRules') is not None:
            temp_model = ListAggregateConfigRulesResponseBodyConfigRules()
            self.config_rules = temp_model.from_map(m['ConfigRules'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAggregateConfigRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAggregateConfigRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAggregateConfigRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAggregateDiscoveredResourcesRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        end_update_timestamp: int = None,
        exclude_resource_types: str = None,
        max_results: int = None,
        next_token: str = None,
        regions: str = None,
        resource_account_id: int = None,
        resource_deleted: int = None,
        resource_id: str = None,
        resource_owner_id: int = None,
        resource_types: str = None,
        start_update_timestamp: int = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of the account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        self.end_update_timestamp = end_update_timestamp
        self.exclude_resource_types = exclude_resource_types
        # The maximum number of entries to return for a single request. Valid values: 1 to 100.
        # 
        # This parameter is required.
        self.max_results = max_results
        # The `token` that you want to use to initiate the current request. If the response of the previous request is truncated, you can use this token to initiate another request and obtain the remaining entries.
        self.next_token = next_token
        # The ID of the region in which the resource resides. Separate multiple region IDs with commas (,).
        self.regions = regions
        # The ID of the Alibaba Cloud account to which the specified resource belongs in the account group.
        self.resource_account_id = resource_account_id
        # The status of the resource. Valid values:
        # 
        # *   0: The resource is deleted. If a resource is deleted from the desired cloud service, **Deleted** is displayed in the resource list in the Cloud Config console.
        # *   1 (default): The resource is retained. If a resource is managed as expected, **Active** is displayed in the resource list in the Cloud Config console.
        self.resource_deleted = resource_deleted
        # The resource ID.
        self.resource_id = resource_id
        self.resource_owner_id = resource_owner_id
        # The type of the resource. Separate multiple resource types with commas (,).
        self.resource_types = resource_types
        self.start_update_timestamp = start_update_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.end_update_timestamp is not None:
            result['EndUpdateTimestamp'] = self.end_update_timestamp
        if self.exclude_resource_types is not None:
            result['ExcludeResourceTypes'] = self.exclude_resource_types
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.regions is not None:
            result['Regions'] = self.regions
        if self.resource_account_id is not None:
            result['ResourceAccountId'] = self.resource_account_id
        if self.resource_deleted is not None:
            result['ResourceDeleted'] = self.resource_deleted
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_types is not None:
            result['ResourceTypes'] = self.resource_types
        if self.start_update_timestamp is not None:
            result['StartUpdateTimestamp'] = self.start_update_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('EndUpdateTimestamp') is not None:
            self.end_update_timestamp = m.get('EndUpdateTimestamp')
        if m.get('ExcludeResourceTypes') is not None:
            self.exclude_resource_types = m.get('ExcludeResourceTypes')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Regions') is not None:
            self.regions = m.get('Regions')
        if m.get('ResourceAccountId') is not None:
            self.resource_account_id = m.get('ResourceAccountId')
        if m.get('ResourceDeleted') is not None:
            self.resource_deleted = m.get('ResourceDeleted')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceTypes') is not None:
            self.resource_types = m.get('ResourceTypes')
        if m.get('StartUpdateTimestamp') is not None:
            self.start_update_timestamp = m.get('StartUpdateTimestamp')
        return self


class ListAggregateDiscoveredResourcesResponseBodyDiscoveredResourceProfilesDiscoveredResourceProfileList(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        availability_zone: str = None,
        region: str = None,
        resource_creation_time: int = None,
        resource_deleted: int = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_owner_id: int = None,
        resource_status: str = None,
        resource_type: str = None,
        tags: str = None,
        update_time: int = None,
        version: int = None,
    ):
        # The ID of the Alibaba Cloud account to which the resource belongs. We recommend that you use the ResourceOwnerId parameter.
        self.account_id = account_id
        # The ID of the zone in which the resource resides.
        self.availability_zone = availability_zone
        # The region ID.
        self.region = region
        # The time when the resource was created. Unit: milliseconds.
        self.resource_creation_time = resource_creation_time
        # The status of the resource. Valid values:
        # 
        # *   0: The resource is deleted.
        # *   1: The resource is retained.
        self.resource_deleted = resource_deleted
        # The resource ID.
        self.resource_id = resource_id
        # The resource name.
        self.resource_name = resource_name
        # The ID of the Alibaba Cloud account to which the resource belongs.
        self.resource_owner_id = resource_owner_id
        # The status of the resource. The value of this parameter varies with the resource type and may be empty. Examples:
        # 
        # *   If the value of the ResourceType parameter is ACS::ECS::Instance, the resource is an Elastic Compute Service (ECS) instance that is in a specific state. In this case, the valid values of this parameter are Running and Stopped.
        # *   If the value of the ResourceType parameter is ACS::OSS::Bucket, the resource is an Object Storage Service (OSS) bucket that is not in a specific state. In this case, this parameter is empty.
        self.resource_status = resource_status
        # The resource type.
        self.resource_type = resource_type
        # The tags of the resource.
        self.tags = tags
        self.update_time = update_time
        # The build version of the resource.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.availability_zone is not None:
            result['AvailabilityZone'] = self.availability_zone
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_creation_time is not None:
            result['ResourceCreationTime'] = self.resource_creation_time
        if self.resource_deleted is not None:
            result['ResourceDeleted'] = self.resource_deleted
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_status is not None:
            result['ResourceStatus'] = self.resource_status
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AvailabilityZone') is not None:
            self.availability_zone = m.get('AvailabilityZone')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceCreationTime') is not None:
            self.resource_creation_time = m.get('ResourceCreationTime')
        if m.get('ResourceDeleted') is not None:
            self.resource_deleted = m.get('ResourceDeleted')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceStatus') is not None:
            self.resource_status = m.get('ResourceStatus')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class ListAggregateDiscoveredResourcesResponseBodyDiscoveredResourceProfiles(TeaModel):
    def __init__(
        self,
        discovered_resource_profile_list: List[ListAggregateDiscoveredResourcesResponseBodyDiscoveredResourceProfilesDiscoveredResourceProfileList] = None,
        max_results: int = None,
        next_token: str = None,
        total_count: int = None,
    ):
        # The queried resource.
        self.discovered_resource_profile_list = discovered_resource_profile_list
        # The maximum number of entries returned on each page.
        self.max_results = max_results
        # The token that was used to initiate the next request.
        self.next_token = next_token
        # The total number of resources.
        self.total_count = total_count

    def validate(self):
        if self.discovered_resource_profile_list:
            for k in self.discovered_resource_profile_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiscoveredResourceProfileList'] = []
        if self.discovered_resource_profile_list is not None:
            for k in self.discovered_resource_profile_list:
                result['DiscoveredResourceProfileList'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.discovered_resource_profile_list = []
        if m.get('DiscoveredResourceProfileList') is not None:
            for k in m.get('DiscoveredResourceProfileList'):
                temp_model = ListAggregateDiscoveredResourcesResponseBodyDiscoveredResourceProfilesDiscoveredResourceProfileList()
                self.discovered_resource_profile_list.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAggregateDiscoveredResourcesResponseBody(TeaModel):
    def __init__(
        self,
        discovered_resource_profiles: ListAggregateDiscoveredResourcesResponseBodyDiscoveredResourceProfiles = None,
        request_id: str = None,
    ):
        # The queried resources.
        self.discovered_resource_profiles = discovered_resource_profiles
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.discovered_resource_profiles:
            self.discovered_resource_profiles.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discovered_resource_profiles is not None:
            result['DiscoveredResourceProfiles'] = self.discovered_resource_profiles.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiscoveredResourceProfiles') is not None:
            temp_model = ListAggregateDiscoveredResourcesResponseBodyDiscoveredResourceProfiles()
            self.discovered_resource_profiles = temp_model.from_map(m['DiscoveredResourceProfiles'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAggregateDiscoveredResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAggregateDiscoveredResourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAggregateDiscoveredResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAggregateRemediationExecutionsRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        config_rule_id: str = None,
        execution_status: str = None,
        max_results: int = None,
        next_token: str = None,
        resource_account_id: int = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The rule ID.
        # 
        # For more information about how to obtain the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        # 
        # This parameter is required.
        self.config_rule_id = config_rule_id
        # The status of the remediation. Valid values:
        # 
        # *   Success
        # *   Failed
        self.execution_status = execution_status
        # The maximum number of entries to return for a single request. Valid values: 10 to 100.
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. You do not need to specify this parameter for the first request. You must specify the token that is obtained from the previous query as the value of NextToken.
        self.next_token = next_token
        # The ID of the member account in the account group.
        self.resource_account_id = resource_account_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.execution_status is not None:
            result['ExecutionStatus'] = self.execution_status
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.resource_account_id is not None:
            result['ResourceAccountId'] = self.resource_account_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ExecutionStatus') is not None:
            self.execution_status = m.get('ExecutionStatus')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ResourceAccountId') is not None:
            self.resource_account_id = m.get('ResourceAccountId')
        return self


class ListAggregateRemediationExecutionsResponseBodyRemediationExecutionDataRemediationExecutions(TeaModel):
    def __init__(
        self,
        execution_create_date: str = None,
        execution_invocation_id: str = None,
        execution_resource_ids: str = None,
        execution_resource_type: str = None,
        execution_status: str = None,
        execution_status_message: str = None,
    ):
        # The time when the remediation record was created.
        self.execution_create_date = execution_create_date
        # The invocation ID of the remediation record.
        self.execution_invocation_id = execution_invocation_id
        # The IDs of the remediated resources. Multiple resource IDs are separated with commas (,).
        self.execution_resource_ids = execution_resource_ids
        # The resource type.
        self.execution_resource_type = execution_resource_type
        # The status of the remediation. Valid values:
        # 
        # *   Success
        # *   Failed
        self.execution_status = execution_status
        # The error message returned when the remediation fails.
        self.execution_status_message = execution_status_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execution_create_date is not None:
            result['ExecutionCreateDate'] = self.execution_create_date
        if self.execution_invocation_id is not None:
            result['ExecutionInvocationId'] = self.execution_invocation_id
        if self.execution_resource_ids is not None:
            result['ExecutionResourceIds'] = self.execution_resource_ids
        if self.execution_resource_type is not None:
            result['ExecutionResourceType'] = self.execution_resource_type
        if self.execution_status is not None:
            result['ExecutionStatus'] = self.execution_status
        if self.execution_status_message is not None:
            result['ExecutionStatusMessage'] = self.execution_status_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExecutionCreateDate') is not None:
            self.execution_create_date = m.get('ExecutionCreateDate')
        if m.get('ExecutionInvocationId') is not None:
            self.execution_invocation_id = m.get('ExecutionInvocationId')
        if m.get('ExecutionResourceIds') is not None:
            self.execution_resource_ids = m.get('ExecutionResourceIds')
        if m.get('ExecutionResourceType') is not None:
            self.execution_resource_type = m.get('ExecutionResourceType')
        if m.get('ExecutionStatus') is not None:
            self.execution_status = m.get('ExecutionStatus')
        if m.get('ExecutionStatusMessage') is not None:
            self.execution_status_message = m.get('ExecutionStatusMessage')
        return self


class ListAggregateRemediationExecutionsResponseBodyRemediationExecutionData(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        remediation_executions: List[ListAggregateRemediationExecutionsResponseBodyRemediationExecutionDataRemediationExecutions] = None,
    ):
        # The maximum number of entries returned for a single request.
        self.max_results = max_results
        # A pagination token. It can be used in the next request to retrieve a new page of results.
        self.next_token = next_token
        # The queried remediation records.
        self.remediation_executions = remediation_executions

    def validate(self):
        if self.remediation_executions:
            for k in self.remediation_executions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['RemediationExecutions'] = []
        if self.remediation_executions is not None:
            for k in self.remediation_executions:
                result['RemediationExecutions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.remediation_executions = []
        if m.get('RemediationExecutions') is not None:
            for k in m.get('RemediationExecutions'):
                temp_model = ListAggregateRemediationExecutionsResponseBodyRemediationExecutionDataRemediationExecutions()
                self.remediation_executions.append(temp_model.from_map(k))
        return self


class ListAggregateRemediationExecutionsResponseBody(TeaModel):
    def __init__(
        self,
        remediation_execution_data: ListAggregateRemediationExecutionsResponseBodyRemediationExecutionData = None,
        request_id: str = None,
    ):
        # The queried remediation records.
        self.remediation_execution_data = remediation_execution_data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.remediation_execution_data:
            self.remediation_execution_data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remediation_execution_data is not None:
            result['RemediationExecutionData'] = self.remediation_execution_data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemediationExecutionData') is not None:
            temp_model = ListAggregateRemediationExecutionsResponseBodyRemediationExecutionData()
            self.remediation_execution_data = temp_model.from_map(m['RemediationExecutionData'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAggregateRemediationExecutionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAggregateRemediationExecutionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAggregateRemediationExecutionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAggregateRemediationsRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        config_rule_ids: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The rule IDs. Separate multiple rule IDs with commas (,).
        # 
        # For more information about how to obtain the ID of a rule, see [ListAggregateConfigRules](https://help.aliyun.com/document_detail/264148.html).
        # 
        # This parameter is required.
        self.config_rule_ids = config_rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.config_rule_ids is not None:
            result['ConfigRuleIds'] = self.config_rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ConfigRuleIds') is not None:
            self.config_rule_ids = m.get('ConfigRuleIds')
        return self


class ListAggregateRemediationsResponseBodyRemediations(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        aggregator_id: str = None,
        config_rule_id: str = None,
        invoke_type: str = None,
        last_successful_invocation_id: str = None,
        last_successful_invocation_time: int = None,
        last_successful_invocation_type: str = None,
        remediaiton_origin_params: str = None,
        remediation_id: str = None,
        remediation_source_type: str = None,
        remediation_template_id: str = None,
        remediation_type: str = None,
    ):
        # The ID of the Alibaba Cloud account to which the resource belongs.
        self.account_id = account_id
        # The ID of the account group.
        self.aggregator_id = aggregator_id
        # The rule ID.
        self.config_rule_id = config_rule_id
        # The execution mode of the remediation template. Valid values:
        # 
        # *   NON_EXECUTION: The remediation template is not executed.
        # *   AUTO_EXECUTION: The remediation template is automatically executed.
        # *   MANUAL_EXECUTION: The remediation template is manually executed.
        # *   NOT_CONFIG: The execution mode is not specified.
        self.invoke_type = invoke_type
        # The ID of the last successful execution of the remediation template.
        self.last_successful_invocation_id = last_successful_invocation_id
        # The timestamp of the last successful execution of the remediation template. Unit: milliseconds.
        self.last_successful_invocation_time = last_successful_invocation_time
        # The mode of the last successful execution of the remediation template. Valid values:
        # 
        # *   NON_EXECUTION: The remediation template is not executed.
        # *   AUTO_EXECUTION: The remediation template is automatically executed.
        # *   MANUAL_EXECUTION: The remediation template is manually executed.
        # *   NOT_CONFIG: The execution mode is not specified.
        self.last_successful_invocation_type = last_successful_invocation_type
        # The converted configuration of the remediation template. This parameter is returned only for an OOS remediation template.
        self.remediaiton_origin_params = remediaiton_origin_params
        # The ID of the remediation template.
        self.remediation_id = remediation_id
        # The source of remediation template. Valid values:
        # 
        # *   ALIYUN: official template.
        # *   CUSTOM: custom template.
        # *   NONE: none.
        self.remediation_source_type = remediation_source_type
        # The ID of the remediation template.
        self.remediation_template_id = remediation_template_id
        # The type of the remediation template. Valid values:
        # 
        # *   OOS: Operation Orchestration Service (official remediation).
        # *   FC: Function Compute (custom remediation).
        self.remediation_type = remediation_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.invoke_type is not None:
            result['InvokeType'] = self.invoke_type
        if self.last_successful_invocation_id is not None:
            result['LastSuccessfulInvocationId'] = self.last_successful_invocation_id
        if self.last_successful_invocation_time is not None:
            result['LastSuccessfulInvocationTime'] = self.last_successful_invocation_time
        if self.last_successful_invocation_type is not None:
            result['LastSuccessfulInvocationType'] = self.last_successful_invocation_type
        if self.remediaiton_origin_params is not None:
            result['RemediaitonOriginParams'] = self.remediaiton_origin_params
        if self.remediation_id is not None:
            result['RemediationId'] = self.remediation_id
        if self.remediation_source_type is not None:
            result['RemediationSourceType'] = self.remediation_source_type
        if self.remediation_template_id is not None:
            result['RemediationTemplateId'] = self.remediation_template_id
        if self.remediation_type is not None:
            result['RemediationType'] = self.remediation_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('InvokeType') is not None:
            self.invoke_type = m.get('InvokeType')
        if m.get('LastSuccessfulInvocationId') is not None:
            self.last_successful_invocation_id = m.get('LastSuccessfulInvocationId')
        if m.get('LastSuccessfulInvocationTime') is not None:
            self.last_successful_invocation_time = m.get('LastSuccessfulInvocationTime')
        if m.get('LastSuccessfulInvocationType') is not None:
            self.last_successful_invocation_type = m.get('LastSuccessfulInvocationType')
        if m.get('RemediaitonOriginParams') is not None:
            self.remediaiton_origin_params = m.get('RemediaitonOriginParams')
        if m.get('RemediationId') is not None:
            self.remediation_id = m.get('RemediationId')
        if m.get('RemediationSourceType') is not None:
            self.remediation_source_type = m.get('RemediationSourceType')
        if m.get('RemediationTemplateId') is not None:
            self.remediation_template_id = m.get('RemediationTemplateId')
        if m.get('RemediationType') is not None:
            self.remediation_type = m.get('RemediationType')
        return self


class ListAggregateRemediationsResponseBody(TeaModel):
    def __init__(
        self,
        remediations: List[ListAggregateRemediationsResponseBodyRemediations] = None,
        request_id: str = None,
    ):
        # An array that contains remediation templates.
        self.remediations = remediations
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.remediations:
            for k in self.remediations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Remediations'] = []
        if self.remediations is not None:
            for k in self.remediations:
                result['Remediations'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.remediations = []
        if m.get('Remediations') is not None:
            for k in m.get('Remediations'):
                temp_model = ListAggregateRemediationsResponseBodyRemediations()
                self.remediations.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAggregateRemediationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAggregateRemediationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAggregateRemediationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAggregateResourceEvaluationResultsRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        compliance_type: str = None,
        max_results: int = None,
        next_token: str = None,
        region: str = None,
        resource_id: str = None,
        resource_type: str = None,
    ):
        # The ID of the account group.
        # 
        # For more information about how to obtain the ID of an account group, see [ListAggregators](https://help.aliyun.com/document_detail/255797.html).
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The compliance evaluation result of the resource. Valid values:
        # 
        # *   COMPLIANT: The resource is evaluated as compliant.
        # *   NON_COMPLIANT: The resource is evaluated as non-compliant.
        # *   NOT_APPLICABLE: The rule does not apply to the resource.
        # *   INSUFFICIENT_DATA: No data is available.
        # *   IGNORED: The resource is ignored during compliance evaluation.
        self.compliance_type = compliance_type
        # The maximum number of entries to return for a single request. Valid values: 1 to 100.
        self.max_results = max_results
        # The token that you want to use to initiate the current request. If the response of the previous request is truncated, you can use this token to initiate another request and obtain the remaining entries.``
        self.next_token = next_token
        # The ID of the region where one or more resources that you want to query reside. For example, the value `global` indicates global regions and the value `cn-hangzhou` indicates the China (Hangzhou) region.
        # 
        # For more information about how to obtain the ID of a region, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        self.region = region
        # The ID of the resource.
        # 
        # For more information about how to obtain the ID of a resource, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        self.resource_id = resource_id
        # The type of the resource.
        # 
        # For more information about how to query the type of a resource, see [ListAggregateDiscoveredResources](https://help.aliyun.com/document_detail/265983.html).
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class ListAggregateResourceEvaluationResultsResponseBodyEvaluationResultsEvaluationResultListEvaluationResultIdentifierEvaluationResultQualifier(TeaModel):
    def __init__(
        self,
        config_rule_arn: str = None,
        config_rule_id: str = None,
        config_rule_name: str = None,
        ignore_date: str = None,
        region_id: str = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_type: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) of the rule.
        self.config_rule_arn = config_rule_arn
        # The ID of the rule.
        self.config_rule_id = config_rule_id
        # The name of the monitoring rule.
        self.config_rule_name = config_rule_name
        # The date from which the system automatically re-evaluates the ignored incompliant resources.
        # 
        # >  If the value of this parameter is left empty, the system does not automatically re-evaluate the ignored incompliant resources. You must manually re-evaluate the ignored incompliant resources.
        self.ignore_date = ignore_date
        # The ID of the region where the resource resides.
        self.region_id = region_id
        # The ID of the resource.
        self.resource_id = resource_id
        # The name of the resource.
        self.resource_name = resource_name
        # The type of the resource.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_rule_arn is not None:
            result['ConfigRuleArn'] = self.config_rule_arn
        if self.config_rule_id is not None:
            result['ConfigRuleId'] = self.config_rule_id
        if self.config_rule_name is not None:
            result['ConfigRuleName'] = self.config_rule_name
        if self.ignore_date is not None:
            result['IgnoreDate'] = self.ignore_date
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigRuleArn') is not None:
            self.config_rule_arn = m.get('ConfigRuleArn')
        if m.get('ConfigRuleId') is not None:
            self.config_rule_id = m.get('ConfigRuleId')
        if m.get('ConfigRuleName') is not None:
            self.config_rule_name = m.get('ConfigRuleName')
        if m.get('IgnoreDate') is not None:
            self.ignore_date = m.get('IgnoreDate')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class ListAggregateResourceEvaluationResultsResponseBodyEvaluationResultsEvaluationResultListEvaluationResultIdentifier(TeaModel):
    def __init__(
        self,
        evaluation_result_qualifier: ListAggregateResourceEvaluationResultsResponseBodyEvaluationResultsEvaluationResultListEvaluationResultIdentifierEvaluationResultQualifier = None,
        ordering_timestamp: int = None,
    ):
        # The information about the evaluated resource in the compliance evaluation result.
        self.evaluation_result_qualifier = evaluation_result_qualifier
        # The timestamp when the compliance evaluation was performed. Unit: milliseconds.
        self.ordering_timestamp = ordering_timestamp

    def validate(self):
        if self.evaluation_result_qualifier:
            self.evaluation_result_qualifier.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.evaluation_result_qualifier is not None:
            result['EvaluationResultQualifier'] = self.evaluation_result_qualifier.to_map()
        if self.ordering_timestamp is not None:
            result['OrderingTimestamp'] = self.ordering_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EvaluationResultQualifier') is not None:
            temp_model = ListAggregateResourceEvaluationResultsResponseBodyEvaluationResultsEvaluationResultListEvaluationResultIdentifierEvaluationResultQualifier()
            self.evaluation_result_qualifier = temp_model.from_map(m['EvaluationResultQualifier'])
        if m.get('OrderingTimestamp') is not None:
            self.ordering_timestamp = m.get('OrderingTimestamp')
        return self


class ListAggregateResourceEvaluationResultsResponseBodyEvaluationResultsEvaluationResultList(TeaModel):
    def __init__(
        self,
        annotation: str = None,
        compliance_type: str = None,
        config_rule_invoked_timestamp: int = None,
        evaluation_result_identifier: ListAggregateResourceEvaluationResultsResponseBodyEvaluationResultsEvaluationResultListEvaluationResultIdentifier = None,
        invoking_event_message_type: str = None,
        remediation_enabled: bool = None,
        result_recorded_timestamp: int = None,
        risk_level: int = None,
    ):
        # The annotation to the resource that is evaluated as incompliant.
        self.annotation = annotation
        # The compliance evaluation result of the resources. Valid values:
        # 
        # *   COMPLIANT: The resources are evaluated as compliant.
        # *   NON_COMPLIANT: The resources are evaluated as incompliant.
        # *   NOT_APPLICABLE: The rule does not apply to your resources.
        # *   INSUFFICIENT_DATA: No resource data is available.
        # *   IGNORED: The resource is ignored during compliance evaluation.
        self.compliance_type = compliance_type
        # The timestamp when the rule was triggered. Unit: milliseconds.
        self.config_rule_invoked_timestamp = config_rule_invoked_timestamp
        # The identifying information about the compliance evaluation result.
        self.evaluation_result_identifier = evaluation_result_identifier
        # The trigger type of the managed rule. Valid values:
        # 
        # *   ConfigurationItemChangeNotification: The managed rule is triggered by configuration changes.
        # *   ScheduledNotification: The managed rule is periodically triggered.
        self.invoking_event_message_type = invoking_event_message_type
        # Indicates whether the remediation template is enabled. Valid values:
        # 
        # - true: The remediation template is enabled.
        # - false: The remediation template is disabled.
        self.remediation_enabled = remediation_enabled
        # The timestamp when the compliance evaluation result was recorded. Unit: milliseconds.
        self.result_recorded_timestamp = result_recorded_timestamp
        # The risk level of the resources that are not compliant with the rule. Valid values:
        # 
        # *   1: high risk level
        # *   2: medium risk level
        # *   3: low risk level
        self.risk_level = risk_level

    def validate(self):
        if self.evaluation_result_identifier:
            self.evaluation_result_identifier.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotation is not None:
            result['Annotation'] = self.annotation
        if self.compliance_type is not None:
            result['ComplianceType'] = self.compliance_type
        if self.config_rule_invoked_timestamp is not None:
            result['ConfigRuleInvokedTimestamp'] = self.config_rule_invoked_timestamp
        if self.evaluation_result_identifier is not None:
            result['EvaluationResultIdentifier'] = self.evaluation_result_identifier.to_map()
        if self.invoking_event_message_type is not None:
            result['InvokingEventMessageType'] = self.invoking_event_message_type
        if self.remediation_enabled is not None:
            result['RemediationEnabled'] = self.remediation_enabled
        if self.result_recorded_timestamp is not None:
            result['ResultRecordedTimestamp'] = self.result_recorded_timestamp
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Annotation') is not None:
            self.annotation = m.get('Annotation')
        if m.get('ComplianceType') is not None:
            self.compliance_type = m.get('ComplianceType')
        if m.get('ConfigRuleInvokedTimestamp') is not None:
            self.config_rule_invoked_timestamp = m.get('ConfigRuleInvokedTimestamp')
        if m.get('EvaluationResultIdentifier') is not None:
            temp_model = ListAggregateResourceEvaluationResultsResponseBodyEvaluationResultsEvaluationResultListEvaluationResultIdentifier()
            self.evaluation_result_identifier = temp_model.from_map(m['EvaluationResultIdentifier'])
        if m.get('InvokingEventMessageType') is not None:
            self.invoking_event_message_type = m.get('InvokingEventMessageType')
        if m.get('RemediationEnabled') is not None:
            self.remediation_enabled = m.get('RemediationEnabled')
        if m.get('ResultRecordedTimestamp') is not None:
            self.result_recorded_timestamp = m.get('ResultRecordedTimestamp')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class ListAggregateResourceEvaluationResultsResponseBodyEvaluationResults(TeaModel):
    def __init__(
        self,
        evaluation_result_list: List[ListAggregateResourceEvaluationResultsResponseBodyEvaluationResultsEvaluationResultList] = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # The details of the compliance evaluation result.
        self.evaluation_result_list = evaluation_result_list
        # The maximum number of entries returned on each page.
        self.max_results = max_results
        # The token that was used to initiate the next request.
        self.next_token = next_token

    def validate(self):
        if self.evaluation_result_list:
            for k in self.evaluation_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EvaluationResultList'] = []
        if self.evaluation_result_list is not None:
            for k in self.evaluation_result_list:
                result['EvaluationResultList'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.evaluation_result_list = []
        if m.get('EvaluationResultList') is not None:
            for k in m.get('EvaluationResultList'):
                temp_model = ListAggregateResourceEvaluationResultsResponseBodyEvaluationResultsEvaluationResultList()
                self.evaluation_result_list.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListAggregateResourceEvaluationResultsResponseBody(TeaModel):
    def __init__(
        self,
        evaluation_results: ListAggregateResourceEvaluationResultsResponseBodyEvaluationResults = None,
        request_id: str = None,
    ):
        # The information about the compliance evaluation results returned.
        self.evaluation_results = evaluation_results
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.evaluation_results:
            self.evaluation_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.evaluation_results is not None:
            result['EvaluationResults'] = self.evaluation_results.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EvaluationResults') is not None:
            temp_model = ListAggregateResourceEvaluationResultsResponseBodyEvaluationResults()
            self.evaluation_results = temp_model.from_map(m['EvaluationResults'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAggregateResourceEvaluationResultsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAggregateResourceEvaluationResultsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAggregateResourceEvaluationResultsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAggregateResourceRelationsRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        max_results: int = None,
        next_token: str = None,
        region: str = None,
        relation_type: str = None,
        resource_account_id: int = None,
        resource_id: str = None,
        resource_type: str = None,
        target_resource_id: str = None,
        target_resource_type: str = None,
    ):
        # The ID of the account group.
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The maximum number of entries to return for a single request. Valid values: 1 to 1000.
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. You do not need to specify this parameter for the first request. You must specify the token that is obtained from the previous query as the value of NextToken.
        self.next_token = next_token
        # The ID of the region in which the resource resides.
        # 
        # This parameter is required.
        self.region = region
        # The type of the relationship between the resource and the object.
        # 
        # Valid values:
        # 
        # *   IsContained: The object is included as part of the resource.
        # *   IsAttachedTo: The object is added to the resource.
        # *   IsAssociatedIn: The object is associated with the resource.
        # *   Contains: The object contains the resource.
        self.relation_type = relation_type
        # The ID of the Alibaba Cloud account to which the resources in the account group belong.
        # 
        # This parameter is required.
        self.resource_account_id = resource_account_id
        # The resource ID.
        # 
        # This parameter is required.
        self.resource_id = resource_id
        # The type of the resource.
        # 
        # This parameter is required.
        self.resource_type = resource_type
        # The ID of the resource that is associated with the object.
        self.target_resource_id = target_resource_id
        # The type of the resource that is associated with the object.
        self.target_resource_type = target_resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region is not None:
            result['Region'] = self.region
        if self.relation_type is not None:
            result['RelationType'] = self.relation_type
        if self.resource_account_id is not None:
            result['ResourceAccountId'] = self.resource_account_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.target_resource_id is not None:
            result['TargetResourceId'] = self.target_resource_id
        if self.target_resource_type is not None:
            result['TargetResourceType'] = self.target_resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RelationType') is not None:
            self.relation_type = m.get('RelationType')
        if m.get('ResourceAccountId') is not None:
            self.resource_account_id = m.get('ResourceAccountId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('TargetResourceId') is not None:
            self.target_resource_id = m.get('TargetResourceId')
        if m.get('TargetResourceType') is not None:
            self.target_resource_type = m.get('TargetResourceType')
        return self


class ListAggregateResourceRelationsResponseBodyResourceRelationsResourceRelationList(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        relation_type: str = None,
        source_resource_id: str = None,
        source_resource_region_id: str = None,
        source_resource_type: str = None,
        target_resource_id: str = None,
        target_resource_type: str = None,
    ):
        # The Alibaba Cloud account ID of the resource owner.
        self.account_id = account_id
        # The type of the relationship between the resource and the object.
        # 
        # Valid values:
        # 
        # *   IsContained: The object is included as part of the resource.
        # *   IsAttachedTo: The object is added to the resource.
        # *   IsAssociatedIn: The object is associated with the resource.
        # *   Contains: The object contains the resource.
        self.relation_type = relation_type
        # The resource ID of the current resource.
        self.source_resource_id = source_resource_id
        # The region ID of the current resource.
        self.source_resource_region_id = source_resource_region_id
        # The type of the resource.
        self.source_resource_type = source_resource_type
        # The resource ID of the resource that is associated with the object.
        self.target_resource_id = target_resource_id
        # The type of the resource that is associated with the object.
        self.target_resource_type = target_resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.relation_type is not None:
            result['RelationType'] = self.relation_type
        if self.source_resource_id is not None:
            result['SourceResourceId'] = self.source_resource_id
        if self.source_resource_region_id is not None:
            result['SourceResourceRegionId'] = self.source_resource_region_id
        if self.source_resource_type is not None:
            result['SourceResourceType'] = self.source_resource_type
        if self.target_resource_id is not None:
            result['TargetResourceId'] = self.target_resource_id
        if self.target_resource_type is not None:
            result['TargetResourceType'] = self.target_resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('RelationType') is not None:
            self.relation_type = m.get('RelationType')
        if m.get('SourceResourceId') is not None:
            self.source_resource_id = m.get('SourceResourceId')
        if m.get('SourceResourceRegionId') is not None:
            self.source_resource_region_id = m.get('SourceResourceRegionId')
        if m.get('SourceResourceType') is not None:
            self.source_resource_type = m.get('SourceResourceType')
        if m.get('TargetResourceId') is not None:
            self.target_resource_id = m.get('TargetResourceId')
        if m.get('TargetResourceType') is not None:
            self.target_resource_type = m.get('TargetResourceType')
        return self


class ListAggregateResourceRelationsResponseBodyResourceRelations(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        resource_relation_list: List[ListAggregateResourceRelationsResponseBodyResourceRelationsResourceRelationList] = None,
    ):
        # The maximum number of entries returned on each page.
        self.max_results = max_results
        # The token that was used to initiate the next request.
        self.next_token = next_token
        # An array that contains the relationships.
        self.resource_relation_list = resource_relation_list

    def validate(self):
        if self.resource_relation_list:
            for k in self.resource_relation_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['ResourceRelationList'] = []
        if self.resource_relation_list is not None:
            for k in self.resource_relation_list:
                result['ResourceRelationList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.resource_relation_list = []
        if m.get('ResourceRelationList') is not None:
            for k in m.get('ResourceRelationList'):
                temp_model = ListAggregateResourceRelationsResponseBodyResourceRelationsResourceRelationList()
                self.resource_relation_list.append(temp_model.from_map(k))
        return self


class ListAggregateResourceRelationsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_relations: ListAggregateResourceRelationsResponseBodyResourceRelations = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The result of the relationship.
        self.resource_relations = resource_relations

    def validate(self):
        if self.resource_relations:
            self.resource_relations.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_relations is not None:
            result['ResourceRelations'] = self.resource_relations.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceRelations') is not None:
            temp_model = ListAggregateResourceRelationsResponseBodyResourceRelations()
            self.resource_relations = temp_model.from_map(m['ResourceRelations'])
        return self


class ListAggregateResourceRelationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAggregateResourceRelationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAggregateResourceRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAggregateResourcesByAdvancedSearchRequest(TeaModel):
    def __init__(
        self,
        aggregator_id: str = None,
        sql: str = None,
    ):
        # The ID of the account group.
        # 
        # This parameter is required.
        self.aggregator_id = aggregator_id
        # The SQL query statement.
        # 
        # This parameter is required.
        self.sql = sql

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregator_id is not None:
            result['AggregatorId'] = self.aggregator_id
        if self.sql is not None:
            result['Sql'] = self.sql
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregatorId') is not None:
            self.aggregator_id = m.get('AggregatorId')
        if m.get('Sql') is not None:
            self.sql = m.get('Sql')
        return self


class ListAggregateResourcesByAdvancedSearchResponseBodyQueryResultsQueryResultList(TeaModel):
    def __init__(
        self,
        columns: List[str] = None,
        values: List[Any] = None,
    ):
        # The field names.
        self.columns = columns
        # The resource data.
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.columns is not None:
            result['Columns'] = self.columns
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Columns') is not None:
            self.columns = m.get('Columns')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class ListAggregateResourcesByAdvancedSearchResponseBodyQueryResults(TeaModel):
    def __init__(
        self,
        query_result_list: ListAggregateResourcesByAdvancedSearchResponseBodyQueryResultsQueryResultList = None,
    ):
        # The queried resources. A maximum of 1,000 data records can be returned. To view more data, use the download URL of the resource file.
        self.query_result_list = query_result_list

    def validate(self):
        if self.query_result_list:
            self.query_result_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.query_result_list is not None:
            result['QueryResultList'] = self.query_result_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QueryResultList') is not None:
            temp_model = ListAggregateResourcesByAdvancedSearchResponseBodyQueryResultsQueryResultList()
            self.query_result_list = temp_model.from_map(m['QueryResultList'])
        return self


class ListAggregateResourcesByAdvancedSearchResponseBody(TeaModel):
    def __init__(
        self,
        query_results: ListAggregateResourcesByAdvancedSearchResponseBodyQueryResults = None,
        request_id: str = None,
    ):
        # The returned data.
        self.query_results = query_results
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.query_results:
            self.query_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.query_results is not None:
            result['QueryResults'] = self.query_results.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QueryResults') is not None:
            temp_model = ListAggregateResourcesByAdvancedSearchResponseBodyQueryResults()
            self.query_results = temp_model.from_map(m['QueryResults'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAggregateResourcesByAdvancedSearchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAggregateResourcesByAdvancedSearchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAggregateResourcesByAdvancedSearchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAggregatorsRequest(TeaModel):
    def __ini