# coding: utf-8

"""
    3Di API

    3Di simulation API (latest stable version: v3)   Framework release: 2.11.1   3Di core release: 2.2.3  deployed on:  02:06PM (UTC) on January 13, 2022  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: info@nelen-schuurmans.nl
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from threedi_api_client.openapi.api_client import ApiClient
from threedi_api_client.openapi.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class V3Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def auth_profile_list(self, **kwargs):  # noqa: E501
        """auth_profile_list  # noqa: E501

        Read-only API endpoint for viewing user details for current user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_profile_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.auth_profile_list_with_http_info(**kwargs)  # noqa: E501

    def auth_profile_list_with_http_info(self, **kwargs):  # noqa: E501
        """auth_profile_list  # noqa: E501

        Read-only API endpoint for viewing user details for current user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_profile_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(User, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method auth_profile_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/auth/profile/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='User',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def auth_refresh_token_create(self, data, **kwargs):  # noqa: E501
        """Refresh API authentication token by refresh_token.  # noqa: E501

        Post \"refresh\" token as \"refresh\".  The return \"access\" token needs to be sent as HTTP authentication header with every request with 'Bearer ' prefix (case-sensitive).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_refresh_token_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Refresh data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Tokens
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.auth_refresh_token_create_with_http_info(data, **kwargs)  # noqa: E501

    def auth_refresh_token_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """Refresh API authentication token by refresh_token.  # noqa: E501

        Post \"refresh\" token as \"refresh\".  The return \"access\" token needs to be sent as HTTP authentication header with every request with 'Bearer ' prefix (case-sensitive).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_refresh_token_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Refresh data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Tokens, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method auth_refresh_token_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `auth_refresh_token_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/auth/refresh-token/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tokens',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def auth_token_create(self, data, **kwargs):  # noqa: E501
        """Get an API authentication JWT token.  # noqa: E501

        Post your username & password to get an \"access\" and \"refresh\" JWT token.  The \"access\" token needs to be sent as HTTP authentication header with every request with a 'Bearer ' prefix (case-sensitive).  Note that the \"access\" token expires after some time.  The \"refresh\" token can be used to get a new access token via the \"refresh\" endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_token_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Authenticate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Tokens
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.auth_token_create_with_http_info(data, **kwargs)  # noqa: E501

    def auth_token_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """Get an API authentication JWT token.  # noqa: E501

        Post your username & password to get an \"access\" and \"refresh\" JWT token.  The \"access\" token needs to be sent as HTTP authentication header with every request with a 'Bearer ' prefix (case-sensitive).  Note that the \"access\" token expires after some time.  The \"refresh\" token can be used to get a new access token via the \"refresh\" endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_token_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Authenticate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Tokens, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method auth_token_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `auth_token_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/auth/token/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tokens',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def auth_users_list(self, **kwargs):  # noqa: E501
        """Read-only API endpoint for viewing user details.  # noqa: E501

        - superusers and staff users might view all users - user with a manage role might view all users for the   organisations they have the manage role for - regular users might view their user details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_users_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str username:
        :param str username__iexact:
        :param str username__contains:
        :param str username__icontains:
        :param str username__in: Multiple values may be separated by commas.
        :param str username__startswith:
        :param str username__istartswith:
        :param str username__endswith:
        :param str username__regex:
        :param str email:
        :param str email__iexact:
        :param str email__contains:
        :param str email__icontains:
        :param str email__in: Multiple values may be separated by commas.
        :param str email__startswith:
        :param str email__istartswith:
        :param str email__endswith:
        :param str email__regex:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse2005
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.auth_users_list_with_http_info(**kwargs)  # noqa: E501

    def auth_users_list_with_http_info(self, **kwargs):  # noqa: E501
        """Read-only API endpoint for viewing user details.  # noqa: E501

        - superusers and staff users might view all users - user with a manage role might view all users for the   organisations they have the manage role for - regular users might view their user details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_users_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str username:
        :param str username__iexact:
        :param str username__contains:
        :param str username__icontains:
        :param str username__in: Multiple values may be separated by commas.
        :param str username__startswith:
        :param str username__istartswith:
        :param str username__endswith:
        :param str username__regex:
        :param str email:
        :param str email__iexact:
        :param str email__contains:
        :param str email__icontains:
        :param str email__in: Multiple values may be separated by commas.
        :param str email__startswith:
        :param str email__istartswith:
        :param str email__endswith:
        :param str email__regex:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse2005, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'username',
            'username__iexact',
            'username__contains',
            'username__icontains',
            'username__in',
            'username__startswith',
            'username__istartswith',
            'username__endswith',
            'username__regex',
            'email',
            'email__iexact',
            'email__contains',
            'email__icontains',
            'email__in',
            'email__startswith',
            'email__istartswith',
            'email__endswith',
            'email__regex',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method auth_users_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in local_var_params and local_var_params['username'] is not None:  # noqa: E501
            query_params.append(('username', local_var_params['username']))  # noqa: E501
        if 'username__iexact' in local_var_params and local_var_params['username__iexact'] is not None:  # noqa: E501
            query_params.append(('username__iexact', local_var_params['username__iexact']))  # noqa: E501
        if 'username__contains' in local_var_params and local_var_params['username__contains'] is not None:  # noqa: E501
            query_params.append(('username__contains', local_var_params['username__contains']))  # noqa: E501
        if 'username__icontains' in local_var_params and local_var_params['username__icontains'] is not None:  # noqa: E501
            query_params.append(('username__icontains', local_var_params['username__icontains']))  # noqa: E501
        if 'username__in' in local_var_params and local_var_params['username__in'] is not None:  # noqa: E501
            query_params.append(('username__in', local_var_params['username__in']))  # noqa: E501
        if 'username__startswith' in local_var_params and local_var_params['username__startswith'] is not None:  # noqa: E501
            query_params.append(('username__startswith', local_var_params['username__startswith']))  # noqa: E501
        if 'username__istartswith' in local_var_params and local_var_params['username__istartswith'] is not None:  # noqa: E501
            query_params.append(('username__istartswith', local_var_params['username__istartswith']))  # noqa: E501
        if 'username__endswith' in local_var_params and local_var_params['username__endswith'] is not None:  # noqa: E501
            query_params.append(('username__endswith', local_var_params['username__endswith']))  # noqa: E501
        if 'username__regex' in local_var_params and local_var_params['username__regex'] is not None:  # noqa: E501
            query_params.append(('username__regex', local_var_params['username__regex']))  # noqa: E501
        if 'email' in local_var_params and local_var_params['email'] is not None:  # noqa: E501
            query_params.append(('email', local_var_params['email']))  # noqa: E501
        if 'email__iexact' in local_var_params and local_var_params['email__iexact'] is not None:  # noqa: E501
            query_params.append(('email__iexact', local_var_params['email__iexact']))  # noqa: E501
        if 'email__contains' in local_var_params and local_var_params['email__contains'] is not None:  # noqa: E501
            query_params.append(('email__contains', local_var_params['email__contains']))  # noqa: E501
        if 'email__icontains' in local_var_params and local_var_params['email__icontains'] is not None:  # noqa: E501
            query_params.append(('email__icontains', local_var_params['email__icontains']))  # noqa: E501
        if 'email__in' in local_var_params and local_var_params['email__in'] is not None:  # noqa: E501
            query_params.append(('email__in', local_var_params['email__in']))  # noqa: E501
        if 'email__startswith' in local_var_params and local_var_params['email__startswith'] is not None:  # noqa: E501
            query_params.append(('email__startswith', local_var_params['email__startswith']))  # noqa: E501
        if 'email__istartswith' in local_var_params and local_var_params['email__istartswith'] is not None:  # noqa: E501
            query_params.append(('email__istartswith', local_var_params['email__istartswith']))  # noqa: E501
        if 'email__endswith' in local_var_params and local_var_params['email__endswith'] is not None:  # noqa: E501
            query_params.append(('email__endswith', local_var_params['email__endswith']))  # noqa: E501
        if 'email__regex' in local_var_params and local_var_params['email__regex'] is not None:  # noqa: E501
            query_params.append(('email__regex', local_var_params['email__regex']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/auth/users/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2005',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def auth_users_read(self, id, **kwargs):  # noqa: E501
        """auth_users_read  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_users_read(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this user. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.auth_users_read_with_http_info(id, **kwargs)  # noqa: E501

    def auth_users_read_with_http_info(self, id, **kwargs):  # noqa: E501
        """auth_users_read  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_users_read_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this user. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(User, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method auth_users_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `auth_users_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/auth/users/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='User',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contracts_create(self, data, **kwargs):  # noqa: E501
        """contracts_create  # noqa: E501

        API endpoint for interacting with contracts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.contracts_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Contract data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Contract
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.contracts_create_with_http_info(data, **kwargs)  # noqa: E501

    def contracts_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """contracts_create  # noqa: E501

        API endpoint for interacting with contracts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.contracts_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Contract data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Contract, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contracts_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `contracts_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/contracts/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Contract',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contracts_delete(self, id, **kwargs):  # noqa: E501
        """contracts_delete  # noqa: E501

        API endpoint for interacting with contracts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.contracts_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this contract. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.contracts_delete_with_http_info(id, **kwargs)  # noqa: E501

    def contracts_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """contracts_delete  # noqa: E501

        API endpoint for interacting with contracts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.contracts_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this contract. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contracts_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `contracts_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/contracts/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contracts_list(self, **kwargs):  # noqa: E501
        """Overview of organisations that have a valid 3Di contract.  # noqa: E501

        List all organisations that already have used some fraction of their calculation quota (for the current year - the `hours_used` property is based on the current calender year) ``` ?hours_used__gt=0 ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.contracts_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float organisation__id:
        :param float organisation__id__gt:
        :param float organisation__id__gte:
        :param float organisation__id__lt:
        :param float organisation__id__lte:
        :param str organisation__id__isnull:
        :param str organisation__name:
        :param str organisation__name__iexact:
        :param str organisation__name__contains:
        :param str organisation__name__icontains:
        :param str organisation__name__in: Multiple values may be separated by commas.
        :param str organisation__name__startswith:
        :param str organisation__name__istartswith:
        :param str organisation__name__endswith:
        :param str organisation__name__regex:
        :param str organisation__unique_id:
        :param str organisation__unique_id__iexact:
        :param str organisation__unique_id__contains:
        :param str organisation__unique_id__icontains:
        :param str organisation__unique_id__in: Multiple values may be separated by commas.
        :param str organisation__unique_id__startswith:
        :param str organisation__unique_id__istartswith:
        :param str organisation__unique_id__endswith:
        :param str organisation__unique_id__regex:
        :param float hours_used__gt:
        :param float hours_used__lt:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse2006
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.contracts_list_with_http_info(**kwargs)  # noqa: E501

    def contracts_list_with_http_info(self, **kwargs):  # noqa: E501
        """Overview of organisations that have a valid 3Di contract.  # noqa: E501

        List all organisations that already have used some fraction of their calculation quota (for the current year - the `hours_used` property is based on the current calender year) ``` ?hours_used__gt=0 ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.contracts_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float organisation__id:
        :param float organisation__id__gt:
        :param float organisation__id__gte:
        :param float organisation__id__lt:
        :param float organisation__id__lte:
        :param str organisation__id__isnull:
        :param str organisation__name:
        :param str organisation__name__iexact:
        :param str organisation__name__contains:
        :param str organisation__name__icontains:
        :param str organisation__name__in: Multiple values may be separated by commas.
        :param str organisation__name__startswith:
        :param str organisation__name__istartswith:
        :param str organisation__name__endswith:
        :param str organisation__name__regex:
        :param str organisation__unique_id:
        :param str organisation__unique_id__iexact:
        :param str organisation__unique_id__contains:
        :param str organisation__unique_id__icontains:
        :param str organisation__unique_id__in: Multiple values may be separated by commas.
        :param str organisation__unique_id__startswith:
        :param str organisation__unique_id__istartswith:
        :param str organisation__unique_id__endswith:
        :param str organisation__unique_id__regex:
        :param float hours_used__gt:
        :param float hours_used__lt:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse2006, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'organisation__id',
            'organisation__id__gt',
            'organisation__id__gte',
            'organisation__id__lt',
            'organisation__id__lte',
            'organisation__id__isnull',
            'organisation__name',
            'organisation__name__iexact',
            'organisation__name__contains',
            'organisation__name__icontains',
            'organisation__name__in',
            'organisation__name__startswith',
            'organisation__name__istartswith',
            'organisation__name__endswith',
            'organisation__name__regex',
            'organisation__unique_id',
            'organisation__unique_id__iexact',
            'organisation__unique_id__contains',
            'organisation__unique_id__icontains',
            'organisation__unique_id__in',
            'organisation__unique_id__startswith',
            'organisation__unique_id__istartswith',
            'organisation__unique_id__endswith',
            'organisation__unique_id__regex',
            'hours_used__gt',
            'hours_used__lt',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contracts_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'organisation__id' in local_var_params and local_var_params['organisation__id'] is not None:  # noqa: E501
            query_params.append(('organisation__id', local_var_params['organisation__id']))  # noqa: E501
        if 'organisation__id__gt' in local_var_params and local_var_params['organisation__id__gt'] is not None:  # noqa: E501
            query_params.append(('organisation__id__gt', local_var_params['organisation__id__gt']))  # noqa: E501
        if 'organisation__id__gte' in local_var_params and local_var_params['organisation__id__gte'] is not None:  # noqa: E501
            query_params.append(('organisation__id__gte', local_var_params['organisation__id__gte']))  # noqa: E501
        if 'organisation__id__lt' in local_var_params and local_var_params['organisation__id__lt'] is not None:  # noqa: E501
            query_params.append(('organisation__id__lt', local_var_params['organisation__id__lt']))  # noqa: E501
        if 'organisation__id__lte' in local_var_params and local_var_params['organisation__id__lte'] is not None:  # noqa: E501
            query_params.append(('organisation__id__lte', local_var_params['organisation__id__lte']))  # noqa: E501
        if 'organisation__id__isnull' in local_var_params and local_var_params['organisation__id__isnull'] is not None:  # noqa: E501
            query_params.append(('organisation__id__isnull', local_var_params['organisation__id__isnull']))  # noqa: E501
        if 'organisation__name' in local_var_params and local_var_params['organisation__name'] is not None:  # noqa: E501
            query_params.append(('organisation__name', local_var_params['organisation__name']))  # noqa: E501
        if 'organisation__name__iexact' in local_var_params and local_var_params['organisation__name__iexact'] is not None:  # noqa: E501
            query_params.append(('organisation__name__iexact', local_var_params['organisation__name__iexact']))  # noqa: E501
        if 'organisation__name__contains' in local_var_params and local_var_params['organisation__name__contains'] is not None:  # noqa: E501
            query_params.append(('organisation__name__contains', local_var_params['organisation__name__contains']))  # noqa: E501
        if 'organisation__name__icontains' in local_var_params and local_var_params['organisation__name__icontains'] is not None:  # noqa: E501
            query_params.append(('organisation__name__icontains', local_var_params['organisation__name__icontains']))  # noqa: E501
        if 'organisation__name__in' in local_var_params and local_var_params['organisation__name__in'] is not None:  # noqa: E501
            query_params.append(('organisation__name__in', local_var_params['organisation__name__in']))  # noqa: E501
        if 'organisation__name__startswith' in local_var_params and local_var_params['organisation__name__startswith'] is not None:  # noqa: E501
            query_params.append(('organisation__name__startswith', local_var_params['organisation__name__startswith']))  # noqa: E501
        if 'organisation__name__istartswith' in local_var_params and local_var_params['organisation__name__istartswith'] is not None:  # noqa: E501
            query_params.append(('organisation__name__istartswith', local_var_params['organisation__name__istartswith']))  # noqa: E501
        if 'organisation__name__endswith' in local_var_params and local_var_params['organisation__name__endswith'] is not None:  # noqa: E501
            query_params.append(('organisation__name__endswith', local_var_params['organisation__name__endswith']))  # noqa: E501
        if 'organisation__name__regex' in local_var_params and local_var_params['organisation__name__regex'] is not None:  # noqa: E501
            query_params.append(('organisation__name__regex', local_var_params['organisation__name__regex']))  # noqa: E501
        if 'organisation__unique_id' in local_var_params and local_var_params['organisation__unique_id'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id', local_var_params['organisation__unique_id']))  # noqa: E501
        if 'organisation__unique_id__iexact' in local_var_params and local_var_params['organisation__unique_id__iexact'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__iexact', local_var_params['organisation__unique_id__iexact']))  # noqa: E501
        if 'organisation__unique_id__contains' in local_var_params and local_var_params['organisation__unique_id__contains'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__contains', local_var_params['organisation__unique_id__contains']))  # noqa: E501
        if 'organisation__unique_id__icontains' in local_var_params and local_var_params['organisation__unique_id__icontains'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__icontains', local_var_params['organisation__unique_id__icontains']))  # noqa: E501
        if 'organisation__unique_id__in' in local_var_params and local_var_params['organisation__unique_id__in'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__in', local_var_params['organisation__unique_id__in']))  # noqa: E501
        if 'organisation__unique_id__startswith' in local_var_params and local_var_params['organisation__unique_id__startswith'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__startswith', local_var_params['organisation__unique_id__startswith']))  # noqa: E501
        if 'organisation__unique_id__istartswith' in local_var_params and local_var_params['organisation__unique_id__istartswith'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__istartswith', local_var_params['organisation__unique_id__istartswith']))  # noqa: E501
        if 'organisation__unique_id__endswith' in local_var_params and local_var_params['organisation__unique_id__endswith'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__endswith', local_var_params['organisation__unique_id__endswith']))  # noqa: E501
        if 'organisation__unique_id__regex' in local_var_params and local_var_params['organisation__unique_id__regex'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__regex', local_var_params['organisation__unique_id__regex']))  # noqa: E501
        if 'hours_used__gt' in local_var_params and local_var_params['hours_used__gt'] is not None:  # noqa: E501
            query_params.append(('hours_used__gt', local_var_params['hours_used__gt']))  # noqa: E501
        if 'hours_used__lt' in local_var_params and local_var_params['hours_used__lt'] is not None:  # noqa: E501
            query_params.append(('hours_used__lt', local_var_params['hours_used__lt']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/contracts/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2006',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contracts_partial_update(self, id, data, **kwargs):  # noqa: E501
        """contracts_partial_update  # noqa: E501

        API endpoint for interacting with contracts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.contracts_partial_update(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this contract. (required)
        :param Contract data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Contract
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.contracts_partial_update_with_http_info(id, data, **kwargs)  # noqa: E501

    def contracts_partial_update_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """contracts_partial_update  # noqa: E501

        API endpoint for interacting with contracts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.contracts_partial_update_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this contract. (required)
        :param Contract data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Contract, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contracts_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `contracts_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `contracts_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/contracts/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Contract',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contracts_read(self, id, **kwargs):  # noqa: E501
        """contracts_read  # noqa: E501

        API endpoint for interacting with contracts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.contracts_read(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this contract. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Contract
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.contracts_read_with_http_info(id, **kwargs)  # noqa: E501

    def contracts_read_with_http_info(self, id, **kwargs):  # noqa: E501
        """contracts_read  # noqa: E501

        API endpoint for interacting with contracts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.contracts_read_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this contract. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Contract, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contracts_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `contracts_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/contracts/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Contract',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def contracts_update(self, id, data, **kwargs):  # noqa: E501
        """contracts_update  # noqa: E501

        API endpoint for interacting with contracts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.contracts_update(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this contract. (required)
        :param Contract data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Contract
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.contracts_update_with_http_info(id, data, **kwargs)  # noqa: E501

    def contracts_update_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """contracts_update  # noqa: E501

        API endpoint for interacting with contracts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.contracts_update_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this contract. (required)
        :param Contract data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Contract, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method contracts_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `contracts_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `contracts_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/contracts/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Contract',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_delete(self, id, **kwargs):  # noqa: E501
        """files_delete  # noqa: E501

        A simple ViewSet for viewing simulations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_delete_with_http_info(id, **kwargs)  # noqa: E501

    def files_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """files_delete  # noqa: E501

        A simple ViewSet for viewing simulations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `files_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/files/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_destroy_file(self, id, **kwargs):  # noqa: E501
        """files_destroy_file  # noqa: E501

        A simple ViewSet for viewing simulations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_destroy_file(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_destroy_file_with_http_info(id, **kwargs)  # noqa: E501

    def files_destroy_file_with_http_info(self, id, **kwargs):  # noqa: E501
        """files_destroy_file  # noqa: E501

        A simple ViewSet for viewing simulations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_destroy_file_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(File, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_destroy_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `files_destroy_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/files/{id}/destroy_file/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='File',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_download(self, id, **kwargs):  # noqa: E501
        """files_download  # noqa: E501

        Endpoint for downloading files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_download(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_download_with_http_info(id, **kwargs)  # noqa: E501

    def files_download_with_http_info(self, id, **kwargs):  # noqa: E501
        """files_download  # noqa: E501

        Endpoint for downloading files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_download_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `files_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/files/{id}/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_list(self, **kwargs):  # noqa: E501
        """files_list  # noqa: E501

        A simple ViewSet for viewing simulations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str filename:
        :param str filename__icontains:
        :param str etag:
        :param str expiry_date:
        :param str expiry_date__lte:
        :param str expiry_date__lt:
        :param str expiry_date__gte:
        :param str expiry_date__gt:
        :param str state:
        :param str state__in: Multiple values may be separated by commas.
        :param str type:
        :param str type__in: Multiple values may be separated by commas.
        :param str meta:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse2007
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_list_with_http_info(**kwargs)  # noqa: E501

    def files_list_with_http_info(self, **kwargs):  # noqa: E501
        """files_list  # noqa: E501

        A simple ViewSet for viewing simulations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str filename:
        :param str filename__icontains:
        :param str etag:
        :param str expiry_date:
        :param str expiry_date__lte:
        :param str expiry_date__lt:
        :param str expiry_date__gte:
        :param str expiry_date__gt:
        :param str state:
        :param str state__in: Multiple values may be separated by commas.
        :param str type:
        :param str type__in: Multiple values may be separated by commas.
        :param str meta:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse2007, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'filename',
            'filename__icontains',
            'etag',
            'expiry_date',
            'expiry_date__lte',
            'expiry_date__lt',
            'expiry_date__gte',
            'expiry_date__gt',
            'state',
            'state__in',
            'type',
            'type__in',
            'meta',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filename' in local_var_params and local_var_params['filename'] is not None:  # noqa: E501
            query_params.append(('filename', local_var_params['filename']))  # noqa: E501
        if 'filename__icontains' in local_var_params and local_var_params['filename__icontains'] is not None:  # noqa: E501
            query_params.append(('filename__icontains', local_var_params['filename__icontains']))  # noqa: E501
        if 'etag' in local_var_params and local_var_params['etag'] is not None:  # noqa: E501
            query_params.append(('etag', local_var_params['etag']))  # noqa: E501
        if 'expiry_date' in local_var_params and local_var_params['expiry_date'] is not None:  # noqa: E501
            query_params.append(('expiry_date', local_var_params['expiry_date']))  # noqa: E501
        if 'expiry_date__lte' in local_var_params and local_var_params['expiry_date__lte'] is not None:  # noqa: E501
            query_params.append(('expiry_date__lte', local_var_params['expiry_date__lte']))  # noqa: E501
        if 'expiry_date__lt' in local_var_params and local_var_params['expiry_date__lt'] is not None:  # noqa: E501
            query_params.append(('expiry_date__lt', local_var_params['expiry_date__lt']))  # noqa: E501
        if 'expiry_date__gte' in local_var_params and local_var_params['expiry_date__gte'] is not None:  # noqa: E501
            query_params.append(('expiry_date__gte', local_var_params['expiry_date__gte']))  # noqa: E501
        if 'expiry_date__gt' in local_var_params and local_var_params['expiry_date__gt'] is not None:  # noqa: E501
            query_params.append(('expiry_date__gt', local_var_params['expiry_date__gt']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'state__in' in local_var_params and local_var_params['state__in'] is not None:  # noqa: E501
            query_params.append(('state__in', local_var_params['state__in']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'type__in' in local_var_params and local_var_params['type__in'] is not None:  # noqa: E501
            query_params.append(('type__in', local_var_params['type__in']))  # noqa: E501
        if 'meta' in local_var_params and local_var_params['meta'] is not None:  # noqa: E501
            query_params.append(('meta', local_var_params['meta']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/files/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2007',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_partial_update(self, id, data, **kwargs):  # noqa: E501
        """files_partial_update  # noqa: E501

        A simple ViewSet for viewing simulations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_partial_update(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param File data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_partial_update_with_http_info(id, data, **kwargs)  # noqa: E501

    def files_partial_update_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """files_partial_update  # noqa: E501

        A simple ViewSet for viewing simulations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_partial_update_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param File data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(File, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `files_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `files_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/files/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='File',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_processed(self, id, data, **kwargs):  # noqa: E501
        """Endpoint to which the upload-processor can enrich file objects (and their related objects) with metadata.  # noqa: E501

        For example the geotransform of raster files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_processed(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param FileMeta data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_processed_with_http_info(id, data, **kwargs)  # noqa: E501

    def files_processed_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """Endpoint to which the upload-processor can enrich file objects (and their related objects) with metadata.  # noqa: E501

        For example the geotransform of raster files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_processed_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param FileMeta data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_processed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `files_processed`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `files_processed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/files/{id}/processed/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_read(self, id, **kwargs):  # noqa: E501
        """files_read  # noqa: E501

        A simple ViewSet for viewing simulations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_read(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_read_with_http_info(id, **kwargs)  # noqa: E501

    def files_read_with_http_info(self, id, **kwargs):  # noqa: E501
        """files_read  # noqa: E501

        A simple ViewSet for viewing simulations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_read_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(File, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `files_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/files/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='File',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_update(self, id, data, **kwargs):  # noqa: E501
        """files_update  # noqa: E501

        A simple ViewSet for viewing simulations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_update(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param File data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.files_update_with_http_info(id, data, **kwargs)  # noqa: E501

    def files_update_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """files_update  # noqa: E501

        A simple ViewSet for viewing simulations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_update_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file. (required)
        :param File data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(File, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `files_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `files_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/files/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='File',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def inpy_versions_create(self, data, **kwargs):  # noqa: E501
        """inpy_versions_create  # noqa: E501

        Inpy was the service for preparing user-supplied schematisations into 3Di models (threedimodels) usable by the 3Di calculation core.  Currently, this route is pending deprecation: most newly generated 3Di models will carry an empty inpy_version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.inpy_versions_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param InpyVersion data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InpyVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.inpy_versions_create_with_http_info(data, **kwargs)  # noqa: E501

    def inpy_versions_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """inpy_versions_create  # noqa: E501

        Inpy was the service for preparing user-supplied schematisations into 3Di models (threedimodels) usable by the 3Di calculation core.  Currently, this route is pending deprecation: most newly generated 3Di models will carry an empty inpy_version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.inpy_versions_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param InpyVersion data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InpyVersion, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method inpy_versions_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `inpy_versions_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/inpy-versions/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InpyVersion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def inpy_versions_delete(self, id, **kwargs):  # noqa: E501
        """inpy_versions_delete  # noqa: E501

        Inpy was the service for preparing user-supplied schematisations into 3Di models (threedimodels) usable by the 3Di calculation core.  Currently, this route is pending deprecation: most newly generated 3Di models will carry an empty inpy_version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.inpy_versions_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this inpy version. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.inpy_versions_delete_with_http_info(id, **kwargs)  # noqa: E501

    def inpy_versions_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """inpy_versions_delete  # noqa: E501

        Inpy was the service for preparing user-supplied schematisations into 3Di models (threedimodels) usable by the 3Di calculation core.  Currently, this route is pending deprecation: most newly generated 3Di models will carry an empty inpy_version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.inpy_versions_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this inpy version. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method inpy_versions_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `inpy_versions_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/inpy-versions/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def inpy_versions_list(self, **kwargs):  # noqa: E501
        """inpy_versions_list  # noqa: E501

        Inpy was the service for preparing user-supplied schematisations into 3Di models (threedimodels) usable by the 3Di calculation core.  Currently, this route is pending deprecation: most newly generated 3Di models will carry an empty inpy_version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.inpy_versions_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedi_version:
        :param str threedi_version__iexact:
        :param str threedi_version__contains:
        :param str threedi_version__icontains:
        :param str threedi_version__in: Multiple values may be separated by commas.
        :param str threedi_version__startswith:
        :param str threedi_version__istartswith:
        :param str threedi_version__endswith:
        :param str threedi_version__regex:
        :param str threedicore_version:
        :param str threedicore_version__iexact:
        :param str threedicore_version__contains:
        :param str threedicore_version__icontains:
        :param str threedicore_version__in: Multiple values may be separated by commas.
        :param str threedicore_version__startswith:
        :param str threedicore_version__istartswith:
        :param str threedicore_version__endswith:
        :param str threedicore_version__regex:
        :param str slug:
        :param str slug__iexact:
        :param str slug__contains:
        :param str slug__icontains:
        :param str slug__in: Multiple values may be separated by commas.
        :param str slug__startswith:
        :param str slug__istartswith:
        :param str slug__endswith:
        :param str slug__regex:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse2008
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.inpy_versions_list_with_http_info(**kwargs)  # noqa: E501

    def inpy_versions_list_with_http_info(self, **kwargs):  # noqa: E501
        """inpy_versions_list  # noqa: E501

        Inpy was the service for preparing user-supplied schematisations into 3Di models (threedimodels) usable by the 3Di calculation core.  Currently, this route is pending deprecation: most newly generated 3Di models will carry an empty inpy_version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.inpy_versions_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str threedi_version:
        :param str threedi_version__iexact:
        :param str threedi_version__contains:
        :param str threedi_version__icontains:
        :param str threedi_version__in: Multiple values may be separated by commas.
        :param str threedi_version__startswith:
        :param str threedi_version__istartswith:
        :param str threedi_version__endswith:
        :param str threedi_version__regex:
        :param str threedicore_version:
        :param str threedicore_version__iexact:
        :param str threedicore_version__contains:
        :param str threedicore_version__icontains:
        :param str threedicore_version__in: Multiple values may be separated by commas.
        :param str threedicore_version__startswith:
        :param str threedicore_version__istartswith:
        :param str threedicore_version__endswith:
        :param str threedicore_version__regex:
        :param str slug:
        :param str slug__iexact:
        :param str slug__contains:
        :param str slug__icontains:
        :param str slug__in: Multiple values may be separated by commas.
        :param str slug__startswith:
        :param str slug__istartswith:
        :param str slug__endswith:
        :param str slug__regex:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse2008, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'threedi_version',
            'threedi_version__iexact',
            'threedi_version__contains',
            'threedi_version__icontains',
            'threedi_version__in',
            'threedi_version__startswith',
            'threedi_version__istartswith',
            'threedi_version__endswith',
            'threedi_version__regex',
            'threedicore_version',
            'threedicore_version__iexact',
            'threedicore_version__contains',
            'threedicore_version__icontains',
            'threedicore_version__in',
            'threedicore_version__startswith',
            'threedicore_version__istartswith',
            'threedicore_version__endswith',
            'threedicore_version__regex',
            'slug',
            'slug__iexact',
            'slug__contains',
            'slug__icontains',
            'slug__in',
            'slug__startswith',
            'slug__istartswith',
            'slug__endswith',
            'slug__regex',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method inpy_versions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'threedi_version' in local_var_params and local_var_params['threedi_version'] is not None:  # noqa: E501
            query_params.append(('threedi_version', local_var_params['threedi_version']))  # noqa: E501
        if 'threedi_version__iexact' in local_var_params and local_var_params['threedi_version__iexact'] is not None:  # noqa: E501
            query_params.append(('threedi_version__iexact', local_var_params['threedi_version__iexact']))  # noqa: E501
        if 'threedi_version__contains' in local_var_params and local_var_params['threedi_version__contains'] is not None:  # noqa: E501
            query_params.append(('threedi_version__contains', local_var_params['threedi_version__contains']))  # noqa: E501
        if 'threedi_version__icontains' in local_var_params and local_var_params['threedi_version__icontains'] is not None:  # noqa: E501
            query_params.append(('threedi_version__icontains', local_var_params['threedi_version__icontains']))  # noqa: E501
        if 'threedi_version__in' in local_var_params and local_var_params['threedi_version__in'] is not None:  # noqa: E501
            query_params.append(('threedi_version__in', local_var_params['threedi_version__in']))  # noqa: E501
        if 'threedi_version__startswith' in local_var_params and local_var_params['threedi_version__startswith'] is not None:  # noqa: E501
            query_params.append(('threedi_version__startswith', local_var_params['threedi_version__startswith']))  # noqa: E501
        if 'threedi_version__istartswith' in local_var_params and local_var_params['threedi_version__istartswith'] is not None:  # noqa: E501
            query_params.append(('threedi_version__istartswith', local_var_params['threedi_version__istartswith']))  # noqa: E501
        if 'threedi_version__endswith' in local_var_params and local_var_params['threedi_version__endswith'] is not None:  # noqa: E501
            query_params.append(('threedi_version__endswith', local_var_params['threedi_version__endswith']))  # noqa: E501
        if 'threedi_version__regex' in local_var_params and local_var_params['threedi_version__regex'] is not None:  # noqa: E501
            query_params.append(('threedi_version__regex', local_var_params['threedi_version__regex']))  # noqa: E501
        if 'threedicore_version' in local_var_params and local_var_params['threedicore_version'] is not None:  # noqa: E501
            query_params.append(('threedicore_version', local_var_params['threedicore_version']))  # noqa: E501
        if 'threedicore_version__iexact' in local_var_params and local_var_params['threedicore_version__iexact'] is not None:  # noqa: E501
            query_params.append(('threedicore_version__iexact', local_var_params['threedicore_version__iexact']))  # noqa: E501
        if 'threedicore_version__contains' in local_var_params and local_var_params['threedicore_version__contains'] is not None:  # noqa: E501
            query_params.append(('threedicore_version__contains', local_var_params['threedicore_version__contains']))  # noqa: E501
        if 'threedicore_version__icontains' in local_var_params and local_var_params['threedicore_version__icontains'] is not None:  # noqa: E501
            query_params.append(('threedicore_version__icontains', local_var_params['threedicore_version__icontains']))  # noqa: E501
        if 'threedicore_version__in' in local_var_params and local_var_params['threedicore_version__in'] is not None:  # noqa: E501
            query_params.append(('threedicore_version__in', local_var_params['threedicore_version__in']))  # noqa: E501
        if 'threedicore_version__startswith' in local_var_params and local_var_params['threedicore_version__startswith'] is not None:  # noqa: E501
            query_params.append(('threedicore_version__startswith', local_var_params['threedicore_version__startswith']))  # noqa: E501
        if 'threedicore_version__istartswith' in local_var_params and local_var_params['threedicore_version__istartswith'] is not None:  # noqa: E501
            query_params.append(('threedicore_version__istartswith', local_var_params['threedicore_version__istartswith']))  # noqa: E501
        if 'threedicore_version__endswith' in local_var_params and local_var_params['threedicore_version__endswith'] is not None:  # noqa: E501
            query_params.append(('threedicore_version__endswith', local_var_params['threedicore_version__endswith']))  # noqa: E501
        if 'threedicore_version__regex' in local_var_params and local_var_params['threedicore_version__regex'] is not None:  # noqa: E501
            query_params.append(('threedicore_version__regex', local_var_params['threedicore_version__regex']))  # noqa: E501
        if 'slug' in local_var_params and local_var_params['slug'] is not None:  # noqa: E501
            query_params.append(('slug', local_var_params['slug']))  # noqa: E501
        if 'slug__iexact' in local_var_params and local_var_params['slug__iexact'] is not None:  # noqa: E501
            query_params.append(('slug__iexact', local_var_params['slug__iexact']))  # noqa: E501
        if 'slug__contains' in local_var_params and local_var_params['slug__contains'] is not None:  # noqa: E501
            query_params.append(('slug__contains', local_var_params['slug__contains']))  # noqa: E501
        if 'slug__icontains' in local_var_params and local_var_params['slug__icontains'] is not None:  # noqa: E501
            query_params.append(('slug__icontains', local_var_params['slug__icontains']))  # noqa: E501
        if 'slug__in' in local_var_params and local_var_params['slug__in'] is not None:  # noqa: E501
            query_params.append(('slug__in', local_var_params['slug__in']))  # noqa: E501
        if 'slug__startswith' in local_var_params and local_var_params['slug__startswith'] is not None:  # noqa: E501
            query_params.append(('slug__startswith', local_var_params['slug__startswith']))  # noqa: E501
        if 'slug__istartswith' in local_var_params and local_var_params['slug__istartswith'] is not None:  # noqa: E501
            query_params.append(('slug__istartswith', local_var_params['slug__istartswith']))  # noqa: E501
        if 'slug__endswith' in local_var_params and local_var_params['slug__endswith'] is not None:  # noqa: E501
            query_params.append(('slug__endswith', local_var_params['slug__endswith']))  # noqa: E501
        if 'slug__regex' in local_var_params and local_var_params['slug__regex'] is not None:  # noqa: E501
            query_params.append(('slug__regex', local_var_params['slug__regex']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/inpy-versions/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2008',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def inpy_versions_partial_update(self, id, data, **kwargs):  # noqa: E501
        """inpy_versions_partial_update  # noqa: E501

        Inpy was the service for preparing user-supplied schematisations into 3Di models (threedimodels) usable by the 3Di calculation core.  Currently, this route is pending deprecation: most newly generated 3Di models will carry an empty inpy_version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.inpy_versions_partial_update(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this inpy version. (required)
        :param InpyVersion data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InpyVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.inpy_versions_partial_update_with_http_info(id, data, **kwargs)  # noqa: E501

    def inpy_versions_partial_update_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """inpy_versions_partial_update  # noqa: E501

        Inpy was the service for preparing user-supplied schematisations into 3Di models (threedimodels) usable by the 3Di calculation core.  Currently, this route is pending deprecation: most newly generated 3Di models will carry an empty inpy_version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.inpy_versions_partial_update_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this inpy version. (required)
        :param InpyVersion data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InpyVersion, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method inpy_versions_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `inpy_versions_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `inpy_versions_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/inpy-versions/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InpyVersion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def inpy_versions_read(self, id, **kwargs):  # noqa: E501
        """inpy_versions_read  # noqa: E501

        Inpy was the service for preparing user-supplied schematisations into 3Di models (threedimodels) usable by the 3Di calculation core.  Currently, this route is pending deprecation: most newly generated 3Di models will carry an empty inpy_version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.inpy_versions_read(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this inpy version. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InpyVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.inpy_versions_read_with_http_info(id, **kwargs)  # noqa: E501

    def inpy_versions_read_with_http_info(self, id, **kwargs):  # noqa: E501
        """inpy_versions_read  # noqa: E501

        Inpy was the service for preparing user-supplied schematisations into 3Di models (threedimodels) usable by the 3Di calculation core.  Currently, this route is pending deprecation: most newly generated 3Di models will carry an empty inpy_version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.inpy_versions_read_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this inpy version. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InpyVersion, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method inpy_versions_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `inpy_versions_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/inpy-versions/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InpyVersion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def inpy_versions_update(self, id, data, **kwargs):  # noqa: E501
        """inpy_versions_update  # noqa: E501

        Inpy was the service for preparing user-supplied schematisations into 3Di models (threedimodels) usable by the 3Di calculation core.  Currently, this route is pending deprecation: most newly generated 3Di models will carry an empty inpy_version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.inpy_versions_update(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this inpy version. (required)
        :param InpyVersion data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InpyVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.inpy_versions_update_with_http_info(id, data, **kwargs)  # noqa: E501

    def inpy_versions_update_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """inpy_versions_update  # noqa: E501

        Inpy was the service for preparing user-supplied schematisations into 3Di models (threedimodels) usable by the 3Di calculation core.  Currently, this route is pending deprecation: most newly generated 3Di models will carry an empty inpy_version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.inpy_versions_update_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this inpy version. (required)
        :param InpyVersion data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InpyVersion, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method inpy_versions_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `inpy_versions_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `inpy_versions_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/inpy-versions/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InpyVersion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organisations_list(self, **kwargs):  # noqa: E501
        """Read-only API endpoint for interacting with organisations.  # noqa: E501

        ##Authorization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organisations_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name:
        :param str name__iexact:
        :param str name__contains:
        :param str name__icontains:
        :param str name__in: Multiple values may be separated by commas.
        :param str name__startswith:
        :param str name__istartswith:
        :param str name__endswith:
        :param str name__regex:
        :param str unique_id:
        :param str unique_id__iexact:
        :param str unique_id__contains:
        :param str unique_id__icontains:
        :param str unique_id__in: Multiple values may be separated by commas.
        :param str unique_id__startswith:
        :param str unique_id__istartswith:
        :param str unique_id__endswith:
        :param str unique_id__regex:
        :param str valid_contracts_only:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse2009
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organisations_list_with_http_info(**kwargs)  # noqa: E501

    def organisations_list_with_http_info(self, **kwargs):  # noqa: E501
        """Read-only API endpoint for interacting with organisations.  # noqa: E501

        ##Authorization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organisations_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name:
        :param str name__iexact:
        :param str name__contains:
        :param str name__icontains:
        :param str name__in: Multiple values may be separated by commas.
        :param str name__startswith:
        :param str name__istartswith:
        :param str name__endswith:
        :param str name__regex:
        :param str unique_id:
        :param str unique_id__iexact:
        :param str unique_id__contains:
        :param str unique_id__icontains:
        :param str unique_id__in: Multiple values may be separated by commas.
        :param str unique_id__startswith:
        :param str unique_id__istartswith:
        :param str unique_id__endswith:
        :param str unique_id__regex:
        :param str valid_contracts_only:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse2009, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name',
            'name__iexact',
            'name__contains',
            'name__icontains',
            'name__in',
            'name__startswith',
            'name__istartswith',
            'name__endswith',
            'name__regex',
            'unique_id',
            'unique_id__iexact',
            'unique_id__contains',
            'unique_id__icontains',
            'unique_id__in',
            'unique_id__startswith',
            'unique_id__istartswith',
            'unique_id__endswith',
            'unique_id__regex',
            'valid_contracts_only',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organisations_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name__iexact' in local_var_params and local_var_params['name__iexact'] is not None:  # noqa: E501
            query_params.append(('name__iexact', local_var_params['name__iexact']))  # noqa: E501
        if 'name__contains' in local_var_params and local_var_params['name__contains'] is not None:  # noqa: E501
            query_params.append(('name__contains', local_var_params['name__contains']))  # noqa: E501
        if 'name__icontains' in local_var_params and local_var_params['name__icontains'] is not None:  # noqa: E501
            query_params.append(('name__icontains', local_var_params['name__icontains']))  # noqa: E501
        if 'name__in' in local_var_params and local_var_params['name__in'] is not None:  # noqa: E501
            query_params.append(('name__in', local_var_params['name__in']))  # noqa: E501
        if 'name__startswith' in local_var_params and local_var_params['name__startswith'] is not None:  # noqa: E501
            query_params.append(('name__startswith', local_var_params['name__startswith']))  # noqa: E501
        if 'name__istartswith' in local_var_params and local_var_params['name__istartswith'] is not None:  # noqa: E501
            query_params.append(('name__istartswith', local_var_params['name__istartswith']))  # noqa: E501
        if 'name__endswith' in local_var_params and local_var_params['name__endswith'] is not None:  # noqa: E501
            query_params.append(('name__endswith', local_var_params['name__endswith']))  # noqa: E501
        if 'name__regex' in local_var_params and local_var_params['name__regex'] is not None:  # noqa: E501
            query_params.append(('name__regex', local_var_params['name__regex']))  # noqa: E501
        if 'unique_id' in local_var_params and local_var_params['unique_id'] is not None:  # noqa: E501
            query_params.append(('unique_id', local_var_params['unique_id']))  # noqa: E501
        if 'unique_id__iexact' in local_var_params and local_var_params['unique_id__iexact'] is not None:  # noqa: E501
            query_params.append(('unique_id__iexact', local_var_params['unique_id__iexact']))  # noqa: E501
        if 'unique_id__contains' in local_var_params and local_var_params['unique_id__contains'] is not None:  # noqa: E501
            query_params.append(('unique_id__contains', local_var_params['unique_id__contains']))  # noqa: E501
        if 'unique_id__icontains' in local_var_params and local_var_params['unique_id__icontains'] is not None:  # noqa: E501
            query_params.append(('unique_id__icontains', local_var_params['unique_id__icontains']))  # noqa: E501
        if 'unique_id__in' in local_var_params and local_var_params['unique_id__in'] is not None:  # noqa: E501
            query_params.append(('unique_id__in', local_var_params['unique_id__in']))  # noqa: E501
        if 'unique_id__startswith' in local_var_params and local_var_params['unique_id__startswith'] is not None:  # noqa: E501
            query_params.append(('unique_id__startswith', local_var_params['unique_id__startswith']))  # noqa: E501
        if 'unique_id__istartswith' in local_var_params and local_var_params['unique_id__istartswith'] is not None:  # noqa: E501
            query_params.append(('unique_id__istartswith', local_var_params['unique_id__istartswith']))  # noqa: E501
        if 'unique_id__endswith' in local_var_params and local_var_params['unique_id__endswith'] is not None:  # noqa: E501
            query_params.append(('unique_id__endswith', local_var_params['unique_id__endswith']))  # noqa: E501
        if 'unique_id__regex' in local_var_params and local_var_params['unique_id__regex'] is not None:  # noqa: E501
            query_params.append(('unique_id__regex', local_var_params['unique_id__regex']))  # noqa: E501
        if 'valid_contracts_only' in local_var_params and local_var_params['valid_contracts_only'] is not None:  # noqa: E501
            query_params.append(('valid_contracts_only', local_var_params['valid_contracts_only']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/organisations/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2009',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organisations_permissions(self, unique_id, **kwargs):  # noqa: E501
        """Read-only API endpoint for interacting with organisations.  # noqa: E501

        ##Authorization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organisations_permissions(unique_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str unique_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[OrganisationRole]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organisations_permissions_with_http_info(unique_id, **kwargs)  # noqa: E501

    def organisations_permissions_with_http_info(self, unique_id, **kwargs):  # noqa: E501
        """Read-only API endpoint for interacting with organisations.  # noqa: E501

        ##Authorization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organisations_permissions_with_http_info(unique_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str unique_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[OrganisationRole], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'unique_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organisations_permissions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'unique_id' is set
        if self.api_client.client_side_validation and ('unique_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['unique_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `unique_id` when calling `organisations_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'unique_id' in local_var_params:
            path_params['unique_id'] = local_var_params['unique_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/organisations/{unique_id}/permissions/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganisationRole]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def organisations_read(self, unique_id, **kwargs):  # noqa: E501
        """Read-only API endpoint for interacting with organisations.  # noqa: E501

        ##Authorization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organisations_read(unique_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str unique_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Organisation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.organisations_read_with_http_info(unique_id, **kwargs)  # noqa: E501

    def organisations_read_with_http_info(self, unique_id, **kwargs):  # noqa: E501
        """Read-only API endpoint for interacting with organisations.  # noqa: E501

        ##Authorization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.organisations_read_with_http_info(unique_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str unique_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Organisation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'unique_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method organisations_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'unique_id' is set
        if self.api_client.client_side_validation and ('unique_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['unique_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `unique_id` when calling `organisations_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'unique_id' in local_var_params:
            path_params['unique_id'] = local_var_params['unique_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/organisations/{unique_id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organisation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def permissions_create(self, data, **kwargs):  # noqa: E501
        """create a role for an existing user in an existing organisation  # noqa: E501

        Example payload:      {       \"user\": \"chuck.norris\",  # user name       \"role\": \"follow_simulation\",  # role name       \"organisation\": \"48dac75bef8a42ebbb52e8f89bbdb9f2\"  # unique id     }  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OrganisationRole data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganisationRole
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.permissions_create_with_http_info(data, **kwargs)  # noqa: E501

    def permissions_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """create a role for an existing user in an existing organisation  # noqa: E501

        Example payload:      {       \"user\": \"chuck.norris\",  # user name       \"role\": \"follow_simulation\",  # role name       \"organisation\": \"48dac75bef8a42ebbb52e8f89bbdb9f2\"  # unique id     }  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OrganisationRole data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganisationRole, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permissions_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `permissions_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/permissions/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganisationRole',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def permissions_delete(self, id, **kwargs):  # noqa: E501
        """permissions_delete  # noqa: E501

        Permissions management endpoints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this user organisation role. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.permissions_delete_with_http_info(id, **kwargs)  # noqa: E501

    def permissions_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """permissions_delete  # noqa: E501

        Permissions management endpoints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this user organisation role. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permissions_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `permissions_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/permissions/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def permissions_list(self, **kwargs):  # noqa: E501
        """permissions_list  # noqa: E501

        Permissions management endpoints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user__username:
        :param str user__username__iexact:
        :param str user__username__contains:
        :param str user__username__icontains:
        :param str user__username__in: Multiple values may be separated by commas.
        :param str user__username__startswith:
        :param str user__username__istartswith:
        :param str user__username__endswith:
        :param str user__username__regex:
        :param str role__name:
        :param str role__name__iexact:
        :param str role__name__contains:
        :param str role__name__icontains:
        :param str role__name__in: Multiple values may be separated by commas.
        :param str role__name__startswith:
        :param str role__name__istartswith:
        :param str role__name__endswith:
        :param str role__name__regex:
        :param str organisation__name:
        :param str organisation__name__iexact:
        :param str organisation__name__contains:
        :param str organisation__name__icontains:
        :param str organisation__name__in: Multiple values may be separated by commas.
        :param str organisation__name__startswith:
        :param str organisation__name__istartswith:
        :param str organisation__name__endswith:
        :param str organisation__name__regex:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20010
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.permissions_list_with_http_info(**kwargs)  # noqa: E501

    def permissions_list_with_http_info(self, **kwargs):  # noqa: E501
        """permissions_list  # noqa: E501

        Permissions management endpoints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user__username:
        :param str user__username__iexact:
        :param str user__username__contains:
        :param str user__username__icontains:
        :param str user__username__in: Multiple values may be separated by commas.
        :param str user__username__startswith:
        :param str user__username__istartswith:
        :param str user__username__endswith:
        :param str user__username__regex:
        :param str role__name:
        :param str role__name__iexact:
        :param str role__name__contains:
        :param str role__name__icontains:
        :param str role__name__in: Multiple values may be separated by commas.
        :param str role__name__startswith:
        :param str role__name__istartswith:
        :param str role__name__endswith:
        :param str role__name__regex:
        :param str organisation__name:
        :param str organisation__name__iexact:
        :param str organisation__name__contains:
        :param str organisation__name__icontains:
        :param str organisation__name__in: Multiple values may be separated by commas.
        :param str organisation__name__startswith:
        :param str organisation__name__istartswith:
        :param str organisation__name__endswith:
        :param str organisation__name__regex:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20010, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user__username',
            'user__username__iexact',
            'user__username__contains',
            'user__username__icontains',
            'user__username__in',
            'user__username__startswith',
            'user__username__istartswith',
            'user__username__endswith',
            'user__username__regex',
            'role__name',
            'role__name__iexact',
            'role__name__contains',
            'role__name__icontains',
            'role__name__in',
            'role__name__startswith',
            'role__name__istartswith',
            'role__name__endswith',
            'role__name__regex',
            'organisation__name',
            'organisation__name__iexact',
            'organisation__name__contains',
            'organisation__name__icontains',
            'organisation__name__in',
            'organisation__name__startswith',
            'organisation__name__istartswith',
            'organisation__name__endswith',
            'organisation__name__regex',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permissions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user__username' in local_var_params and local_var_params['user__username'] is not None:  # noqa: E501
            query_params.append(('user__username', local_var_params['user__username']))  # noqa: E501
        if 'user__username__iexact' in local_var_params and local_var_params['user__username__iexact'] is not None:  # noqa: E501
            query_params.append(('user__username__iexact', local_var_params['user__username__iexact']))  # noqa: E501
        if 'user__username__contains' in local_var_params and local_var_params['user__username__contains'] is not None:  # noqa: E501
            query_params.append(('user__username__contains', local_var_params['user__username__contains']))  # noqa: E501
        if 'user__username__icontains' in local_var_params and local_var_params['user__username__icontains'] is not None:  # noqa: E501
            query_params.append(('user__username__icontains', local_var_params['user__username__icontains']))  # noqa: E501
        if 'user__username__in' in local_var_params and local_var_params['user__username__in'] is not None:  # noqa: E501
            query_params.append(('user__username__in', local_var_params['user__username__in']))  # noqa: E501
        if 'user__username__startswith' in local_var_params and local_var_params['user__username__startswith'] is not None:  # noqa: E501
            query_params.append(('user__username__startswith', local_var_params['user__username__startswith']))  # noqa: E501
        if 'user__username__istartswith' in local_var_params and local_var_params['user__username__istartswith'] is not None:  # noqa: E501
            query_params.append(('user__username__istartswith', local_var_params['user__username__istartswith']))  # noqa: E501
        if 'user__username__endswith' in local_var_params and local_var_params['user__username__endswith'] is not None:  # noqa: E501
            query_params.append(('user__username__endswith', local_var_params['user__username__endswith']))  # noqa: E501
        if 'user__username__regex' in local_var_params and local_var_params['user__username__regex'] is not None:  # noqa: E501
            query_params.append(('user__username__regex', local_var_params['user__username__regex']))  # noqa: E501
        if 'role__name' in local_var_params and local_var_params['role__name'] is not None:  # noqa: E501
            query_params.append(('role__name', local_var_params['role__name']))  # noqa: E501
        if 'role__name__iexact' in local_var_params and local_var_params['role__name__iexact'] is not None:  # noqa: E501
            query_params.append(('role__name__iexact', local_var_params['role__name__iexact']))  # noqa: E501
        if 'role__name__contains' in local_var_params and local_var_params['role__name__contains'] is not None:  # noqa: E501
            query_params.append(('role__name__contains', local_var_params['role__name__contains']))  # noqa: E501
        if 'role__name__icontains' in local_var_params and local_var_params['role__name__icontains'] is not None:  # noqa: E501
            query_params.append(('role__name__icontains', local_var_params['role__name__icontains']))  # noqa: E501
        if 'role__name__in' in local_var_params and local_var_params['role__name__in'] is not None:  # noqa: E501
            query_params.append(('role__name__in', local_var_params['role__name__in']))  # noqa: E501
        if 'role__name__startswith' in local_var_params and local_var_params['role__name__startswith'] is not None:  # noqa: E501
            query_params.append(('role__name__startswith', local_var_params['role__name__startswith']))  # noqa: E501
        if 'role__name__istartswith' in local_var_params and local_var_params['role__name__istartswith'] is not None:  # noqa: E501
            query_params.append(('role__name__istartswith', local_var_params['role__name__istartswith']))  # noqa: E501
        if 'role__name__endswith' in local_var_params and local_var_params['role__name__endswith'] is not None:  # noqa: E501
            query_params.append(('role__name__endswith', local_var_params['role__name__endswith']))  # noqa: E501
        if 'role__name__regex' in local_var_params and local_var_params['role__name__regex'] is not None:  # noqa: E501
            query_params.append(('role__name__regex', local_var_params['role__name__regex']))  # noqa: E501
        if 'organisation__name' in local_var_params and local_var_params['organisation__name'] is not None:  # noqa: E501
            query_params.append(('organisation__name', local_var_params['organisation__name']))  # noqa: E501
        if 'organisation__name__iexact' in local_var_params and local_var_params['organisation__name__iexact'] is not None:  # noqa: E501
            query_params.append(('organisation__name__iexact', local_var_params['organisation__name__iexact']))  # noqa: E501
        if 'organisation__name__contains' in local_var_params and local_var_params['organisation__name__contains'] is not None:  # noqa: E501
            query_params.append(('organisation__name__contains', local_var_params['organisation__name__contains']))  # noqa: E501
        if 'organisation__name__icontains' in local_var_params and local_var_params['organisation__name__icontains'] is not None:  # noqa: E501
            query_params.append(('organisation__name__icontains', local_var_params['organisation__name__icontains']))  # noqa: E501
        if 'organisation__name__in' in local_var_params and local_var_params['organisation__name__in'] is not None:  # noqa: E501
            query_params.append(('organisation__name__in', local_var_params['organisation__name__in']))  # noqa: E501
        if 'organisation__name__startswith' in local_var_params and local_var_params['organisation__name__startswith'] is not None:  # noqa: E501
            query_params.append(('organisation__name__startswith', local_var_params['organisation__name__startswith']))  # noqa: E501
        if 'organisation__name__istartswith' in local_var_params and local_var_params['organisation__name__istartswith'] is not None:  # noqa: E501
            query_params.append(('organisation__name__istartswith', local_var_params['organisation__name__istartswith']))  # noqa: E501
        if 'organisation__name__endswith' in local_var_params and local_var_params['organisation__name__endswith'] is not None:  # noqa: E501
            query_params.append(('organisation__name__endswith', local_var_params['organisation__name__endswith']))  # noqa: E501
        if 'organisation__name__regex' in local_var_params and local_var_params['organisation__name__regex'] is not None:  # noqa: E501
            query_params.append(('organisation__name__regex', local_var_params['organisation__name__regex']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/permissions/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20010',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def permissions_read(self, id, **kwargs):  # noqa: E501
        """permissions_read  # noqa: E501

        Permissions management endpoints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_read(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this user organisation role. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrganisationRole
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.permissions_read_with_http_info(id, **kwargs)  # noqa: E501

    def permissions_read_with_http_info(self, id, **kwargs):  # noqa: E501
        """permissions_read  # noqa: E501

        Permissions management endpoints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permissions_read_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this user organisation role. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrganisationRole, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permissions_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `permissions_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/permissions/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganisationRole',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repositories_create(self, data, **kwargs):  # noqa: E501
        """repositories_create  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Repository data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.repositories_create_with_http_info(data, **kwargs)  # noqa: E501

    def repositories_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """repositories_create  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Repository data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Repository, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repositories_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `repositories_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/repositories/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Repository',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repositories_delete(self, id, **kwargs):  # noqa: E501
        """repositories_delete  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this repository. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.repositories_delete_with_http_info(id, **kwargs)  # noqa: E501

    def repositories_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """repositories_delete  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this repository. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repositories_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `repositories_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/repositories/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repositories_list(self, **kwargs):  # noqa: E501
        """repositories_list  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str slug:
        :param str slug__iexact:
        :param str slug__contains:
        :param str slug__icontains:
        :param str slug__in: Multiple values may be separated by commas.
        :param str slug__startswith:
        :param str slug__istartswith:
        :param str slug__endswith:
        :param str slug__regex:
        :param float organisation__id:
        :param float organisation__id__gt:
        :param float organisation__id__gte:
        :param float organisation__id__lt:
        :param float organisation__id__lte:
        :param str organisation__id__isnull:
        :param str organisation__name:
        :param str organisation__name__iexact:
        :param str organisation__name__contains:
        :param str organisation__name__icontains:
        :param str organisation__name__in: Multiple values may be separated by commas.
        :param str organisation__name__startswith:
        :param str organisation__name__istartswith:
        :param str organisation__name__endswith:
        :param str organisation__name__regex:
        :param str organisation__unique_id:
        :param str organisation__unique_id__iexact:
        :param str organisation__unique_id__contains:
        :param str organisation__unique_id__icontains:
        :param str organisation__unique_id__in: Multiple values may be separated by commas.
        :param str organisation__unique_id__startswith:
        :param str organisation__unique_id__istartswith:
        :param str organisation__unique_id__endswith:
        :param str organisation__unique_id__regex:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20011
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.repositories_list_with_http_info(**kwargs)  # noqa: E501

    def repositories_list_with_http_info(self, **kwargs):  # noqa: E501
        """repositories_list  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str slug:
        :param str slug__iexact:
        :param str slug__contains:
        :param str slug__icontains:
        :param str slug__in: Multiple values may be separated by commas.
        :param str slug__startswith:
        :param str slug__istartswith:
        :param str slug__endswith:
        :param str slug__regex:
        :param float organisation__id:
        :param float organisation__id__gt:
        :param float organisation__id__gte:
        :param float organisation__id__lt:
        :param float organisation__id__lte:
        :param str organisation__id__isnull:
        :param str organisation__name:
        :param str organisation__name__iexact:
        :param str organisation__name__contains:
        :param str organisation__name__icontains:
        :param str organisation__name__in: Multiple values may be separated by commas.
        :param str organisation__name__startswith:
        :param str organisation__name__istartswith:
        :param str organisation__name__endswith:
        :param str organisation__name__regex:
        :param str organisation__unique_id:
        :param str organisation__unique_id__iexact:
        :param str organisation__unique_id__contains:
        :param str organisation__unique_id__icontains:
        :param str organisation__unique_id__in: Multiple values may be separated by commas.
        :param str organisation__unique_id__startswith:
        :param str organisation__unique_id__istartswith:
        :param str organisation__unique_id__endswith:
        :param str organisation__unique_id__regex:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20011, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'slug',
            'slug__iexact',
            'slug__contains',
            'slug__icontains',
            'slug__in',
            'slug__startswith',
            'slug__istartswith',
            'slug__endswith',
            'slug__regex',
            'organisation__id',
            'organisation__id__gt',
            'organisation__id__gte',
            'organisation__id__lt',
            'organisation__id__lte',
            'organisation__id__isnull',
            'organisation__name',
            'organisation__name__iexact',
            'organisation__name__contains',
            'organisation__name__icontains',
            'organisation__name__in',
            'organisation__name__startswith',
            'organisation__name__istartswith',
            'organisation__name__endswith',
            'organisation__name__regex',
            'organisation__unique_id',
            'organisation__unique_id__iexact',
            'organisation__unique_id__contains',
            'organisation__unique_id__icontains',
            'organisation__unique_id__in',
            'organisation__unique_id__startswith',
            'organisation__unique_id__istartswith',
            'organisation__unique_id__endswith',
            'organisation__unique_id__regex',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repositories_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'slug' in local_var_params and local_var_params['slug'] is not None:  # noqa: E501
            query_params.append(('slug', local_var_params['slug']))  # noqa: E501
        if 'slug__iexact' in local_var_params and local_var_params['slug__iexact'] is not None:  # noqa: E501
            query_params.append(('slug__iexact', local_var_params['slug__iexact']))  # noqa: E501
        if 'slug__contains' in local_var_params and local_var_params['slug__contains'] is not None:  # noqa: E501
            query_params.append(('slug__contains', local_var_params['slug__contains']))  # noqa: E501
        if 'slug__icontains' in local_var_params and local_var_params['slug__icontains'] is not None:  # noqa: E501
            query_params.append(('slug__icontains', local_var_params['slug__icontains']))  # noqa: E501
        if 'slug__in' in local_var_params and local_var_params['slug__in'] is not None:  # noqa: E501
            query_params.append(('slug__in', local_var_params['slug__in']))  # noqa: E501
        if 'slug__startswith' in local_var_params and local_var_params['slug__startswith'] is not None:  # noqa: E501
            query_params.append(('slug__startswith', local_var_params['slug__startswith']))  # noqa: E501
        if 'slug__istartswith' in local_var_params and local_var_params['slug__istartswith'] is not None:  # noqa: E501
            query_params.append(('slug__istartswith', local_var_params['slug__istartswith']))  # noqa: E501
        if 'slug__endswith' in local_var_params and local_var_params['slug__endswith'] is not None:  # noqa: E501
            query_params.append(('slug__endswith', local_var_params['slug__endswith']))  # noqa: E501
        if 'slug__regex' in local_var_params and local_var_params['slug__regex'] is not None:  # noqa: E501
            query_params.append(('slug__regex', local_var_params['slug__regex']))  # noqa: E501
        if 'organisation__id' in local_var_params and local_var_params['organisation__id'] is not None:  # noqa: E501
            query_params.append(('organisation__id', local_var_params['organisation__id']))  # noqa: E501
        if 'organisation__id__gt' in local_var_params and local_var_params['organisation__id__gt'] is not None:  # noqa: E501
            query_params.append(('organisation__id__gt', local_var_params['organisation__id__gt']))  # noqa: E501
        if 'organisation__id__gte' in local_var_params and local_var_params['organisation__id__gte'] is not None:  # noqa: E501
            query_params.append(('organisation__id__gte', local_var_params['organisation__id__gte']))  # noqa: E501
        if 'organisation__id__lt' in local_var_params and local_var_params['organisation__id__lt'] is not None:  # noqa: E501
            query_params.append(('organisation__id__lt', local_var_params['organisation__id__lt']))  # noqa: E501
        if 'organisation__id__lte' in local_var_params and local_var_params['organisation__id__lte'] is not None:  # noqa: E501
            query_params.append(('organisation__id__lte', local_var_params['organisation__id__lte']))  # noqa: E501
        if 'organisation__id__isnull' in local_var_params and local_var_params['organisation__id__isnull'] is not None:  # noqa: E501
            query_params.append(('organisation__id__isnull', local_var_params['organisation__id__isnull']))  # noqa: E501
        if 'organisation__name' in local_var_params and local_var_params['organisation__name'] is not None:  # noqa: E501
            query_params.append(('organisation__name', local_var_params['organisation__name']))  # noqa: E501
        if 'organisation__name__iexact' in local_var_params and local_var_params['organisation__name__iexact'] is not None:  # noqa: E501
            query_params.append(('organisation__name__iexact', local_var_params['organisation__name__iexact']))  # noqa: E501
        if 'organisation__name__contains' in local_var_params and local_var_params['organisation__name__contains'] is not None:  # noqa: E501
            query_params.append(('organisation__name__contains', local_var_params['organisation__name__contains']))  # noqa: E501
        if 'organisation__name__icontains' in local_var_params and local_var_params['organisation__name__icontains'] is not None:  # noqa: E501
            query_params.append(('organisation__name__icontains', local_var_params['organisation__name__icontains']))  # noqa: E501
        if 'organisation__name__in' in local_var_params and local_var_params['organisation__name__in'] is not None:  # noqa: E501
            query_params.append(('organisation__name__in', local_var_params['organisation__name__in']))  # noqa: E501
        if 'organisation__name__startswith' in local_var_params and local_var_params['organisation__name__startswith'] is not None:  # noqa: E501
            query_params.append(('organisation__name__startswith', local_var_params['organisation__name__startswith']))  # noqa: E501
        if 'organisation__name__istartswith' in local_var_params and local_var_params['organisation__name__istartswith'] is not None:  # noqa: E501
            query_params.append(('organisation__name__istartswith', local_var_params['organisation__name__istartswith']))  # noqa: E501
        if 'organisation__name__endswith' in local_var_params and local_var_params['organisation__name__endswith'] is not None:  # noqa: E501
            query_params.append(('organisation__name__endswith', local_var_params['organisation__name__endswith']))  # noqa: E501
        if 'organisation__name__regex' in local_var_params and local_var_params['organisation__name__regex'] is not None:  # noqa: E501
            query_params.append(('organisation__name__regex', local_var_params['organisation__name__regex']))  # noqa: E501
        if 'organisation__unique_id' in local_var_params and local_var_params['organisation__unique_id'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id', local_var_params['organisation__unique_id']))  # noqa: E501
        if 'organisation__unique_id__iexact' in local_var_params and local_var_params['organisation__unique_id__iexact'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__iexact', local_var_params['organisation__unique_id__iexact']))  # noqa: E501
        if 'organisation__unique_id__contains' in local_var_params and local_var_params['organisation__unique_id__contains'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__contains', local_var_params['organisation__unique_id__contains']))  # noqa: E501
        if 'organisation__unique_id__icontains' in local_var_params and local_var_params['organisation__unique_id__icontains'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__icontains', local_var_params['organisation__unique_id__icontains']))  # noqa: E501
        if 'organisation__unique_id__in' in local_var_params and local_var_params['organisation__unique_id__in'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__in', local_var_params['organisation__unique_id__in']))  # noqa: E501
        if 'organisation__unique_id__startswith' in local_var_params and local_var_params['organisation__unique_id__startswith'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__startswith', local_var_params['organisation__unique_id__startswith']))  # noqa: E501
        if 'organisation__unique_id__istartswith' in local_var_params and local_var_params['organisation__unique_id__istartswith'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__istartswith', local_var_params['organisation__unique_id__istartswith']))  # noqa: E501
        if 'organisation__unique_id__endswith' in local_var_params and local_var_params['organisation__unique_id__endswith'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__endswith', local_var_params['organisation__unique_id__endswith']))  # noqa: E501
        if 'organisation__unique_id__regex' in local_var_params and local_var_params['organisation__unique_id__regex'] is not None:  # noqa: E501
            query_params.append(('organisation__unique_id__regex', local_var_params['organisation__unique_id__regex']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/repositories/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20011',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repositories_partial_update(self, id, data, **kwargs):  # noqa: E501
        """repositories_partial_update  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_partial_update(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this repository. (required)
        :param Repository data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.repositories_partial_update_with_http_info(id, data, **kwargs)  # noqa: E501

    def repositories_partial_update_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """repositories_partial_update  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_partial_update_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this repository. (required)
        :param Repository data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Repository, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repositories_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `repositories_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `repositories_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/repositories/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Repository',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repositories_read(self, id, **kwargs):  # noqa: E501
        """repositories_read  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_read(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this repository. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.repositories_read_with_http_info(id, **kwargs)  # noqa: E501

    def repositories_read_with_http_info(self, id, **kwargs):  # noqa: E501
        """repositories_read  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_read_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this repository. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Repository, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repositories_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `repositories_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/repositories/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Repository',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repositories_revisions(self, id, **kwargs):  # noqa: E501
        """repositories_revisions  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_revisions(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this repository. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Revision]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.repositories_revisions_with_http_info(id, **kwargs)  # noqa: E501

    def repositories_revisions_with_http_info(self, id, **kwargs):  # noqa: E501
        """repositories_revisions  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_revisions_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this repository. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Revision], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repositories_revisions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `repositories_revisions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/repositories/{id}/revisions/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Revision]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repositories_threedimodels(self, id, **kwargs):  # noqa: E501
        """repositories_threedimodels  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_threedimodels(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this repository. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ThreediModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.repositories_threedimodels_with_http_info(id, **kwargs)  # noqa: E501

    def repositories_threedimodels_with_http_info(self, id, **kwargs):  # noqa: E501
        """repositories_threedimodels  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_threedimodels_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this repository. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ThreediModel], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repositories_threedimodels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `repositories_threedimodels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/repositories/{id}/threedimodels/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ThreediModel]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repositories_update(self, id, data, **kwargs):  # noqa: E501
        """repositories_update  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_update(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this repository. (required)
        :param Repository data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.repositories_update_with_http_info(id, data, **kwargs)  # noqa: E501

    def repositories_update_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """repositories_update  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repositories_update_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this repository. (required)
        :param Repository data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Repository, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repositories_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `repositories_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `repositories_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/repositories/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Repository',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revisions_create(self, data, **kwargs):  # noqa: E501
        """revisions_create  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Revision data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Revision
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.revisions_create_with_http_info(data, **kwargs)  # noqa: E501

    def revisions_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """revisions_create  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Revision data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Revision, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revisions_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `revisions_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/revisions/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Revision',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revisions_delete(self, id, **kwargs):  # noqa: E501
        """revisions_delete  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this revision. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.revisions_delete_with_http_info(id, **kwargs)  # noqa: E501

    def revisions_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """revisions_delete  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this revision. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revisions_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `revisions_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/revisions/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revisions_list(self, **kwargs):  # noqa: E501
        """revisions_list  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float number:
        :param float number__gt:
        :param float number__gte:
        :param float number__lt:
        :param float number__lte:
        :param str number__isnull:
        :param str hash:
        :param str hash__iexact:
        :param str hash__contains:
        :param str hash__icontains:
        :param str hash__in: Multiple values may be separated by commas.
        :param str hash__startswith:
        :param str hash__istartswith:
        :param str hash__endswith:
        :param str hash__regex:
        :param float repository__id:
        :param float repository__id__gt:
        :param float repository__id__gte:
        :param float repository__id__lt:
        :param float repository__id__lte:
        :param str repository__id__isnull:
        :param str repository__slug:
        :param str repository__slug__iexact:
        :param str repository__slug__contains:
        :param str repository__slug__icontains:
        :param str repository__slug__in: Multiple values may be separated by commas.
        :param str repository__slug__startswith:
        :param str repository__slug__istartswith:
        :param str repository__slug__endswith:
        :param str repository__slug__regex:
        :param str repository__organisation__name:
        :param str repository__organisation__name__iexact:
        :param str repository__organisation__name__contains:
        :param str repository__organisation__name__icontains:
        :param str repository__organisation__name__in: Multiple values may be separated by commas.
        :param str repository__organisation__name__startswith:
        :param str repository__organisation__name__istartswith:
        :param str repository__organisation__name__endswith:
        :param str repository__organisation__name__regex:
        :param str repository__organisation__unique_id:
        :param str repository__organisation__unique_id__iexact:
        :param str repository__organisation__unique_id__contains:
        :param str repository__organisation__unique_id__icontains:
        :param str repository__organisation__unique_id__in: Multiple values may be separated by commas.
        :param str repository__organisation__unique_id__startswith:
        :param str repository__organisation__unique_id__istartswith:
        :param str repository__organisation__unique_id__endswith:
        :param str repository__organisation__unique_id__regex:
        :param str is_pinned:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20012
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.revisions_list_with_http_info(**kwargs)  # noqa: E501

    def revisions_list_with_http_info(self, **kwargs):  # noqa: E501
        """revisions_list  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float number:
        :param float number__gt:
        :param float number__gte:
        :param float number__lt:
        :param float number__lte:
        :param str number__isnull:
        :param str hash:
        :param str hash__iexact:
        :param str hash__contains:
        :param str hash__icontains:
        :param str hash__in: Multiple values may be separated by commas.
        :param str hash__startswith:
        :param str hash__istartswith:
        :param str hash__endswith:
        :param str hash__regex:
        :param float repository__id:
        :param float repository__id__gt:
        :param float repository__id__gte:
        :param float repository__id__lt:
        :param float repository__id__lte:
        :param str repository__id__isnull:
        :param str repository__slug:
        :param str repository__slug__iexact:
        :param str repository__slug__contains:
        :param str repository__slug__icontains:
        :param str repository__slug__in: Multiple values may be separated by commas.
        :param str repository__slug__startswith:
        :param str repository__slug__istartswith:
        :param str repository__slug__endswith:
        :param str repository__slug__regex:
        :param str repository__organisation__name:
        :param str repository__organisation__name__iexact:
        :param str repository__organisation__name__contains:
        :param str repository__organisation__name__icontains:
        :param str repository__organisation__name__in: Multiple values may be separated by commas.
        :param str repository__organisation__name__startswith:
        :param str repository__organisation__name__istartswith:
        :param str repository__organisation__name__endswith:
        :param str repository__organisation__name__regex:
        :param str repository__organisation__unique_id:
        :param str repository__organisation__unique_id__iexact:
        :param str repository__organisation__unique_id__contains:
        :param str repository__organisation__unique_id__icontains:
        :param str repository__organisation__unique_id__in: Multiple values may be separated by commas.
        :param str repository__organisation__unique_id__startswith:
        :param str repository__organisation__unique_id__istartswith:
        :param str repository__organisation__unique_id__endswith:
        :param str repository__organisation__unique_id__regex:
        :param str is_pinned:
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20012, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'number',
            'number__gt',
            'number__gte',
            'number__lt',
            'number__lte',
            'number__isnull',
            'hash',
            'hash__iexact',
            'hash__contains',
            'hash__icontains',
            'hash__in',
            'hash__startswith',
            'hash__istartswith',
            'hash__endswith',
            'hash__regex',
            'repository__id',
            'repository__id__gt',
            'repository__id__gte',
            'repository__id__lt',
            'repository__id__lte',
            'repository__id__isnull',
            'repository__slug',
            'repository__slug__iexact',
            'repository__slug__contains',
            'repository__slug__icontains',
            'repository__slug__in',
            'repository__slug__startswith',
            'repository__slug__istartswith',
            'repository__slug__endswith',
            'repository__slug__regex',
            'repository__organisation__name',
            'repository__organisation__name__iexact',
            'repository__organisation__name__contains',
            'repository__organisation__name__icontains',
            'repository__organisation__name__in',
            'repository__organisation__name__startswith',
            'repository__organisation__name__istartswith',
            'repository__organisation__name__endswith',
            'repository__organisation__name__regex',
            'repository__organisation__unique_id',
            'repository__organisation__unique_id__iexact',
            'repository__organisation__unique_id__contains',
            'repository__organisation__unique_id__icontains',
            'repository__organisation__unique_id__in',
            'repository__organisation__unique_id__startswith',
            'repository__organisation__unique_id__istartswith',
            'repository__organisation__unique_id__endswith',
            'repository__organisation__unique_id__regex',
            'is_pinned',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revisions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'number' in local_var_params and local_var_params['number'] is not None:  # noqa: E501
            query_params.append(('number', local_var_params['number']))  # noqa: E501
        if 'number__gt' in local_var_params and local_var_params['number__gt'] is not None:  # noqa: E501
            query_params.append(('number__gt', local_var_params['number__gt']))  # noqa: E501
        if 'number__gte' in local_var_params and local_var_params['number__gte'] is not None:  # noqa: E501
            query_params.append(('number__gte', local_var_params['number__gte']))  # noqa: E501
        if 'number__lt' in local_var_params and local_var_params['number__lt'] is not None:  # noqa: E501
            query_params.append(('number__lt', local_var_params['number__lt']))  # noqa: E501
        if 'number__lte' in local_var_params and local_var_params['number__lte'] is not None:  # noqa: E501
            query_params.append(('number__lte', local_var_params['number__lte']))  # noqa: E501
        if 'number__isnull' in local_var_params and local_var_params['number__isnull'] is not None:  # noqa: E501
            query_params.append(('number__isnull', local_var_params['number__isnull']))  # noqa: E501
        if 'hash' in local_var_params and local_var_params['hash'] is not None:  # noqa: E501
            query_params.append(('hash', local_var_params['hash']))  # noqa: E501
        if 'hash__iexact' in local_var_params and local_var_params['hash__iexact'] is not None:  # noqa: E501
            query_params.append(('hash__iexact', local_var_params['hash__iexact']))  # noqa: E501
        if 'hash__contains' in local_var_params and local_var_params['hash__contains'] is not None:  # noqa: E501
            query_params.append(('hash__contains', local_var_params['hash__contains']))  # noqa: E501
        if 'hash__icontains' in local_var_params and local_var_params['hash__icontains'] is not None:  # noqa: E501
            query_params.append(('hash__icontains', local_var_params['hash__icontains']))  # noqa: E501
        if 'hash__in' in local_var_params and local_var_params['hash__in'] is not None:  # noqa: E501
            query_params.append(('hash__in', local_var_params['hash__in']))  # noqa: E501
        if 'hash__startswith' in local_var_params and local_var_params['hash__startswith'] is not None:  # noqa: E501
            query_params.append(('hash__startswith', local_var_params['hash__startswith']))  # noqa: E501
        if 'hash__istartswith' in local_var_params and local_var_params['hash__istartswith'] is not None:  # noqa: E501
            query_params.append(('hash__istartswith', local_var_params['hash__istartswith']))  # noqa: E501
        if 'hash__endswith' in local_var_params and local_var_params['hash__endswith'] is not None:  # noqa: E501
            query_params.append(('hash__endswith', local_var_params['hash__endswith']))  # noqa: E501
        if 'hash__regex' in local_var_params and local_var_params['hash__regex'] is not None:  # noqa: E501
            query_params.append(('hash__regex', local_var_params['hash__regex']))  # noqa: E501
        if 'repository__id' in local_var_params and local_var_params['repository__id'] is not None:  # noqa: E501
            query_params.append(('repository__id', local_var_params['repository__id']))  # noqa: E501
        if 'repository__id__gt' in local_var_params and local_var_params['repository__id__gt'] is not None:  # noqa: E501
            query_params.append(('repository__id__gt', local_var_params['repository__id__gt']))  # noqa: E501
        if 'repository__id__gte' in local_var_params and local_var_params['repository__id__gte'] is not None:  # noqa: E501
            query_params.append(('repository__id__gte', local_var_params['repository__id__gte']))  # noqa: E501
        if 'repository__id__lt' in local_var_params and local_var_params['repository__id__lt'] is not None:  # noqa: E501
            query_params.append(('repository__id__lt', local_var_params['repository__id__lt']))  # noqa: E501
        if 'repository__id__lte' in local_var_params and local_var_params['repository__id__lte'] is not None:  # noqa: E501
            query_params.append(('repository__id__lte', local_var_params['repository__id__lte']))  # noqa: E501
        if 'repository__id__isnull' in local_var_params and local_var_params['repository__id__isnull'] is not None:  # noqa: E501
            query_params.append(('repository__id__isnull', local_var_params['repository__id__isnull']))  # noqa: E501
        if 'repository__slug' in local_var_params and local_var_params['repository__slug'] is not None:  # noqa: E501
            query_params.append(('repository__slug', local_var_params['repository__slug']))  # noqa: E501
        if 'repository__slug__iexact' in local_var_params and local_var_params['repository__slug__iexact'] is not None:  # noqa: E501
            query_params.append(('repository__slug__iexact', local_var_params['repository__slug__iexact']))  # noqa: E501
        if 'repository__slug__contains' in local_var_params and local_var_params['repository__slug__contains'] is not None:  # noqa: E501
            query_params.append(('repository__slug__contains', local_var_params['repository__slug__contains']))  # noqa: E501
        if 'repository__slug__icontains' in local_var_params and local_var_params['repository__slug__icontains'] is not None:  # noqa: E501
            query_params.append(('repository__slug__icontains', local_var_params['repository__slug__icontains']))  # noqa: E501
        if 'repository__slug__in' in local_var_params and local_var_params['repository__slug__in'] is not None:  # noqa: E501
            query_params.append(('repository__slug__in', local_var_params['repository__slug__in']))  # noqa: E501
        if 'repository__slug__startswith' in local_var_params and local_var_params['repository__slug__startswith'] is not None:  # noqa: E501
            query_params.append(('repository__slug__startswith', local_var_params['repository__slug__startswith']))  # noqa: E501
        if 'repository__slug__istartswith' in local_var_params and local_var_params['repository__slug__istartswith'] is not None:  # noqa: E501
            query_params.append(('repository__slug__istartswith', local_var_params['repository__slug__istartswith']))  # noqa: E501
        if 'repository__slug__endswith' in local_var_params and local_var_params['repository__slug__endswith'] is not None:  # noqa: E501
            query_params.append(('repository__slug__endswith', local_var_params['repository__slug__endswith']))  # noqa: E501
        if 'repository__slug__regex' in local_var_params and local_var_params['repository__slug__regex'] is not None:  # noqa: E501
            query_params.append(('repository__slug__regex', local_var_params['repository__slug__regex']))  # noqa: E501
        if 'repository__organisation__name' in local_var_params and local_var_params['repository__organisation__name'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__name', local_var_params['repository__organisation__name']))  # noqa: E501
        if 'repository__organisation__name__iexact' in local_var_params and local_var_params['repository__organisation__name__iexact'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__name__iexact', local_var_params['repository__organisation__name__iexact']))  # noqa: E501
        if 'repository__organisation__name__contains' in local_var_params and local_var_params['repository__organisation__name__contains'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__name__contains', local_var_params['repository__organisation__name__contains']))  # noqa: E501
        if 'repository__organisation__name__icontains' in local_var_params and local_var_params['repository__organisation__name__icontains'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__name__icontains', local_var_params['repository__organisation__name__icontains']))  # noqa: E501
        if 'repository__organisation__name__in' in local_var_params and local_var_params['repository__organisation__name__in'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__name__in', local_var_params['repository__organisation__name__in']))  # noqa: E501
        if 'repository__organisation__name__startswith' in local_var_params and local_var_params['repository__organisation__name__startswith'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__name__startswith', local_var_params['repository__organisation__name__startswith']))  # noqa: E501
        if 'repository__organisation__name__istartswith' in local_var_params and local_var_params['repository__organisation__name__istartswith'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__name__istartswith', local_var_params['repository__organisation__name__istartswith']))  # noqa: E501
        if 'repository__organisation__name__endswith' in local_var_params and local_var_params['repository__organisation__name__endswith'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__name__endswith', local_var_params['repository__organisation__name__endswith']))  # noqa: E501
        if 'repository__organisation__name__regex' in local_var_params and local_var_params['repository__organisation__name__regex'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__name__regex', local_var_params['repository__organisation__name__regex']))  # noqa: E501
        if 'repository__organisation__unique_id' in local_var_params and local_var_params['repository__organisation__unique_id'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__unique_id', local_var_params['repository__organisation__unique_id']))  # noqa: E501
        if 'repository__organisation__unique_id__iexact' in local_var_params and local_var_params['repository__organisation__unique_id__iexact'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__unique_id__iexact', local_var_params['repository__organisation__unique_id__iexact']))  # noqa: E501
        if 'repository__organisation__unique_id__contains' in local_var_params and local_var_params['repository__organisation__unique_id__contains'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__unique_id__contains', local_var_params['repository__organisation__unique_id__contains']))  # noqa: E501
        if 'repository__organisation__unique_id__icontains' in local_var_params and local_var_params['repository__organisation__unique_id__icontains'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__unique_id__icontains', local_var_params['repository__organisation__unique_id__icontains']))  # noqa: E501
        if 'repository__organisation__unique_id__in' in local_var_params and local_var_params['repository__organisation__unique_id__in'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__unique_id__in', local_var_params['repository__organisation__unique_id__in']))  # noqa: E501
        if 'repository__organisation__unique_id__startswith' in local_var_params and local_var_params['repository__organisation__unique_id__startswith'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__unique_id__startswith', local_var_params['repository__organisation__unique_id__startswith']))  # noqa: E501
        if 'repository__organisation__unique_id__istartswith' in local_var_params and local_var_params['repository__organisation__unique_id__istartswith'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__unique_id__istartswith', local_var_params['repository__organisation__unique_id__istartswith']))  # noqa: E501
        if 'repository__organisation__unique_id__endswith' in local_var_params and local_var_params['repository__organisation__unique_id__endswith'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__unique_id__endswith', local_var_params['repository__organisation__unique_id__endswith']))  # noqa: E501
        if 'repository__organisation__unique_id__regex' in local_var_params and local_var_params['repository__organisation__unique_id__regex'] is not None:  # noqa: E501
            query_params.append(('repository__organisation__unique_id__regex', local_var_params['repository__organisation__unique_id__regex']))  # noqa: E501
        if 'is_pinned' in local_var_params and local_var_params['is_pinned'] is not None:  # noqa: E501
            query_params.append(('is_pinned', local_var_params['is_pinned']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/revisions/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20012',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revisions_partial_update(self, id, data, **kwargs):  # noqa: E501
        """revisions_partial_update  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_partial_update(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this revision. (required)
        :param Revision data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Revision
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.revisions_partial_update_with_http_info(id, data, **kwargs)  # noqa: E501

    def revisions_partial_update_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """revisions_partial_update  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_partial_update_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this revision. (required)
        :param Revision data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Revision, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revisions_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `revisions_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `revisions_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/revisions/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Revision',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revisions_read(self, id, **kwargs):  # noqa: E501
        """revisions_read  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_read(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this revision. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Revision
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.revisions_read_with_http_info(id, **kwargs)  # noqa: E501

    def revisions_read_with_http_info(self, id, **kwargs):  # noqa: E501
        """revisions_read  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_read_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this revision. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Revision, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revisions_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `revisions_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/revisions/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Revision',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revisions_threedimodels(self, id, **kwargs):  # noqa: E501
        """revisions_threedimodels  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_threedimodels(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this revision. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ThreediModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.revisions_threedimodels_with_http_info(id, **kwargs)  # noqa: E501

    def revisions_threedimodels_with_http_info(self, id, **kwargs):  # noqa: E501
        """revisions_threedimodels  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_threedimodels_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this revision. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ThreediModel], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revisions_threedimodels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `revisions_threedimodels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/revisions/{id}/threedimodels/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ThreediModel]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revisions_update(self, id, data, **kwargs):  # noqa: E501
        """revisions_update  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_update(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this revision. (required)
        :param Revision data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Revision
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.revisions_update_with_http_info(id, data, **kwargs)  # noqa: E501

    def revisions_update_with_http_info(self, id, data, **kwargs):  # noqa: E501
        """revisions_update  # noqa: E501

        A simple ViewSet for viewing modelmeta  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revisions_update_with_http_info(id, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this revision. (required)
        :param Revision data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Revision, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revisions_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `revisions_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `revisions_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/revisions/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Revision',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def roles_list(self, **kwargs):  # noqa: E501
        """roles_list  # noqa: E501

        Read-only API endpoint for viewing roles  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20013
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles_list_with_http_info(**kwargs)  # noqa: E501

    def roles_list_with_http_info(self, **kwargs):  # noqa: E501
        """roles_list  # noqa: E501

        Read-only API endpoint for viewing roles  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20013, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method roles_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/roles/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20013',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def roles_read(self, id, **kwargs):  # noqa: E501
        """roles_read  # noqa: E501

        Read-only API endpoint for viewing roles  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_read(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this role. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Role
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.roles_read_with_http_info(id, **kwargs)  # noqa: E501

    def roles_read_with_http_info(self, id, **kwargs):  # noqa: E501
        """roles_read  # noqa: E501

        Read-only API endpoint for viewing roles  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.roles_read_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this role. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Role, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method roles_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `roles_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/roles/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Role',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_actions_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Post an action to the simulation to start, pause or end it.  # noqa: E501

        Example usage:  To initialize a simulation (and pause) ``` {\"name\": \"initialize\"} ```  To initialize and directly run a simulation ``` {\"name\": \"start\"} ``` Also use \"start\" to resume a paused simulation.  If you want to pause the simulation automatically after a given duration use the duration parameter ``` {   \"name\": \"start\",   \"duration\": 2500 } ```  To pause a simulation ``` {\"name\": \"pause\"} ``` Please note: The simulation will automatically be shut down after the default timeout of 300 seconds has been reached. You can customize this value by specifying the timeout parameter ``` {   \"name\": \"pause\",   \"timeout\": 999 } ```  To end a simulation ``` {\"name\": \"shutdown\"} ```  To queue a simulation ``` {\"name\": \"queue\"} ``` Queued simulations will be started as soon as a session spot becomes available. If a session spot is directly is available the simulation will also be started immediately. The response body will then contain `{\"name\": \"start\"}` ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_actions_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Action data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Action
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_actions_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_actions_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Post an action to the simulation to start, pause or end it.  # noqa: E501

        Example usage:  To initialize a simulation (and pause) ``` {\"name\": \"initialize\"} ```  To initialize and directly run a simulation ``` {\"name\": \"start\"} ``` Also use \"start\" to resume a paused simulation.  If you want to pause the simulation automatically after a given duration use the duration parameter ``` {   \"name\": \"start\",   \"duration\": 2500 } ```  To pause a simulation ``` {\"name\": \"pause\"} ``` Please note: The simulation will automatically be shut down after the default timeout of 300 seconds has been reached. You can customize this value by specifying the timeout parameter ``` {   \"name\": \"pause\",   \"timeout\": 999 } ```  To end a simulation ``` {\"name\": \"shutdown\"} ```  To queue a simulation ``` {\"name\": \"queue\"} ``` Queued simulations will be started as soon as a session spot becomes available. If a session spot is directly is available the simulation will also be started immediately. The response body will then contain `{\"name\": \"start\"}` ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_actions_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Action data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Action, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_actions_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_actions_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_actions_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/actions/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Action',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_actions_reset_pause_timeout(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Reset the pause timeout with the new specified timeout value  # noqa: E501

        You can only reset the pause timeout when the SimulationStatus.name is 'initialized' and SimulationStatus.paused is True.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_actions_reset_pause_timeout(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Timeout data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Action
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_actions_reset_pause_timeout_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_actions_reset_pause_timeout_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Reset the pause timeout with the new specified timeout value  # noqa: E501

        You can only reset the pause timeout when the SimulationStatus.name is 'initialized' and SimulationStatus.paused is True.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_actions_reset_pause_timeout_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Timeout data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Action, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_actions_reset_pause_timeout" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_actions_reset_pause_timeout`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_actions_reset_pause_timeout`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/actions/reset_pause_timeout/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Action',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create(self, data, **kwargs):  # noqa: E501
        """Create a simulation resource  # noqa: E501

        There are two options to specify the desired duration for the simulation, either by using the ``end_datetime`` **or** the ``duration`` parameter.  ``` {   \"name\":           # give the simulation a name   \"tags\":           # add as many tags as you like: handy to find your simulation back later!   \"threedimodel\":   # The model schema to use for the simulation by                     referring to the id of the threedimodel resource   \"organisation\":   # uuid of the organisation for which the                     simulation is run   \"start_datetime\": # datetime (in ISO 8601 (UTC) format) for the                     simulation start, e.g. \"YYYY-MM-DDThh:mm:ss\"   \"end_datetime\":   # datetime (in ISO 8601 (UTC) format) for the                     simulation end, e.g. \"YYYY-MM-DDThh:mm:ss\"   \"duration\":       # in seconds, can be used instead of end_datetime } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Simulation data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Simulation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_with_http_info(data, **kwargs)  # noqa: E501

    def simulations_create_with_http_info(self, data, **kwargs):  # noqa: E501
        """Create a simulation resource  # noqa: E501

        There are two options to specify the desired duration for the simulation, either by using the ``end_datetime`` **or** the ``duration`` parameter.  ``` {   \"name\":           # give the simulation a name   \"tags\":           # add as many tags as you like: handy to find your simulation back later!   \"threedimodel\":   # The model schema to use for the simulation by                     referring to the id of the threedimodel resource   \"organisation\":   # uuid of the organisation for which the                     simulation is run   \"start_datetime\": # datetime (in ISO 8601 (UTC) format) for the                     simulation start, e.g. \"YYYY-MM-DDThh:mm:ss\"   \"end_datetime\":   # datetime (in ISO 8601 (UTC) format) for the                     simulation end, e.g. \"YYYY-MM-DDThh:mm:ss\"   \"duration\":       # in seconds, can be used instead of end_datetime } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Simulation data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Simulation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Simulation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Save the state of the simulation to file when a given (set of) variable(s) becomes stable  # noqa: E501

        Example ``` {   \"expiry\": \"2020-08-15T13:02:30.317Z\",   \"thresholds\": [     {       \"variable\": \"s1\",       \"value\": 0.005     }   ] } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param StableThresholdSavedState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StableThresholdSavedState
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Save the state of the simulation to file when a given (set of) variable(s) becomes stable  # noqa: E501

        Example ``` {   \"expiry\": \"2020-08-15T13:02:30.317Z\",   \"thresholds\": [     {       \"variable\": \"s1\",       \"value\": 0.005     }   ] } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param StableThresholdSavedState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StableThresholdSavedState, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_stable_threshold_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/stable-threshold/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StableThresholdSavedState',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_delete  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_delete  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_stable_threshold_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/stable-threshold/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_list  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20016
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_list  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20016, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/stable-threshold/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20016',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_partial_update  # noqa: E501

        When the simulation has started this resource can not be patched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param StableThresholdSavedState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_partial_update  # noqa: E501

        When the simulation has started this resource can not be patched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param StableThresholdSavedState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_stable_threshold_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_stable_threshold_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/stable-threshold/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_read  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StableThresholdSavedState
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_read  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StableThresholdSavedState, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_stable_threshold_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/stable-threshold/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StableThresholdSavedState',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_update  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param StableThresholdSavedState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StableThresholdSavedState
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_update  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param StableThresholdSavedState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StableThresholdSavedState, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_stable_threshold_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_stable_threshold_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/stable-threshold/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StableThresholdSavedState',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_stable_threshold_upload(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_upload  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_upload(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_stable_threshold_upload_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_stable_threshold_upload_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_stable_threshold_upload  # noqa: E501

        Stable threshold SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_stable_threshold_upload_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_stable_threshold_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_stable_threshold_upload`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_stable_threshold_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_stable_threshold_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/stable-threshold/{id}/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Save the state at a given time of the simulation to file  # noqa: E501

        ```     {       \"name\":   # custom name for the saved state (optional)       \"tags\":   # add tags to the resource. Either space or comma                 separated (optional)       \"expiry\": # datetime (in ISO 8601 (UTC) format) until the saved                 state file will be kept       \"time\":   # the state at this given time of the simulation will                  be saved to file     } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimedSavedStateUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimedSavedStateUpdate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Save the state at a given time of the simulation to file  # noqa: E501

        ```     {       \"name\":   # custom name for the saved state (optional)       \"tags\":   # add tags to the resource. Either space or comma                 separated (optional)       \"expiry\": # datetime (in ISO 8601 (UTC) format) until the saved                 state file will be kept       \"time\":   # the state at this given time of the simulation will                  be saved to file     } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimedSavedStateUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimedSavedStateUpdate, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_timed_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/timed/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimedSavedStateUpdate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_delete  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_delete  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_timed_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/timed/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_list  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20017
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_list  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20017, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/timed/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20017',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_partial_update  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param TimedSavedStateUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_partial_update  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param TimedSavedStateUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_timed_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_timed_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/timed/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_read  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimedSavedStateUpdate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_read  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimedSavedStateUpdate, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_timed_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/timed/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimedSavedStateUpdate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_update  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param TimedSavedStateUpdate data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimedSavedStateUpdate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_update  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param TimedSavedStateUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimedSavedStateUpdate, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_timed_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_timed_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/timed/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimedSavedStateUpdate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_create_saved_states_timed_upload(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_upload  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_upload(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_create_saved_states_timed_upload_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_create_saved_states_timed_upload_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_create_saved_states_timed_upload  # noqa: E501

        Timed SavedState  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_create_saved_states_timed_upload_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this saved state. (required)
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_create_saved_states_timed_upload" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_create_saved_states_timed_upload`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_create_saved_states_timed_upload`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_create_saved_states_timed_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/create-saved-states/timed/{id}/upload/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_delete(self, id, **kwargs):  # noqa: E501
        """simulations_delete  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this simulation. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_delete_with_http_info(id, **kwargs)  # noqa: E501

    def simulations_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """simulations_delete  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this simulation. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events(self, id, **kwargs):  # noqa: E501
        """simulations_events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this simulation. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Event
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_with_http_info(id, **kwargs)  # noqa: E501

    def simulations_events_with_http_info(self, id, **kwargs):  # noqa: E501
        """simulations_events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this simulation. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Event, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{id}/events/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Event',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_boundaryconditions_file_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Endpoint for uploading a boundary-conditions file.  # noqa: E501

        The format of the filename should be <filename>.<extension>, e.g.  `boundary_conditions_bergermeer.json`  Every leading and trailing spaces will be removed. Other spaces are converted to underscores and anything that is not an alphanumeric, dash, underscore, or dot will be removed as well.  The response provides a put_url which allows you to upload a file containing one or more boundary-conditions.  The uploaded file should be a JSON-file containing an array of boundary-conditions timeseries. Example of the content of such a file: ``` [     {         \"id\": 1,   # sqlite boundary_1d table id         \"type\": \"1D\",  # \"1D\" for 1d boundaries         \"interpolate\": false,         \"values\": [             [0, 0.5],             [500, 0,8],             [1000, 0]         ]     },     {         \"id\": 2,  # sqlite boundary_2d table id         \"type\": \"2D\", # \"2D\" for 2d boundaries         \"interpolate\": false,         \"values\": [             [0, 0,3],             [400, 0.1]         ]     },     {         \"id\": 3,         \"type\": \"2D\",         \"interpolate\": false,         \"values\": [             [0, -2.4],             [1300, 0,3],             [3000, 1.2],             [3600, 0]         ]     } ] ```  The ordering of the boundaries does not matter.  The file is valided to check if all boundary-conditions defined for the threedimodel have timeseries after upload.  Boundary-conditions need to be added before initializing/starting the simulation and cannot be changed once the simulation is initialized.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_boundaryconditions_file_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_boundaryconditions_file_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Endpoint for uploading a boundary-conditions file.  # noqa: E501

        The format of the filename should be <filename>.<extension>, e.g.  `boundary_conditions_bergermeer.json`  Every leading and trailing spaces will be removed. Other spaces are converted to underscores and anything that is not an alphanumeric, dash, underscore, or dot will be removed as well.  The response provides a put_url which allows you to upload a file containing one or more boundary-conditions.  The uploaded file should be a JSON-file containing an array of boundary-conditions timeseries. Example of the content of such a file: ``` [     {         \"id\": 1,   # sqlite boundary_1d table id         \"type\": \"1D\",  # \"1D\" for 1d boundaries         \"interpolate\": false,         \"values\": [             [0, 0.5],             [500, 0,8],             [1000, 0]         ]     },     {         \"id\": 2,  # sqlite boundary_2d table id         \"type\": \"2D\", # \"2D\" for 2d boundaries         \"interpolate\": false,         \"values\": [             [0, 0,3],             [400, 0.1]         ]     },     {         \"id\": 3,         \"type\": \"2D\",         \"interpolate\": false,         \"values\": [             [0, -2.4],             [1300, 0,3],             [3000, 1.2],             [3600, 0]         ]     } ] ```  The ordering of the boundaries does not matter.  The file is valided to check if all boundary-conditions defined for the threedimodel have timeseries after upload.  Boundary-conditions need to be added before initializing/starting the simulation and cannot be changed once the simulation is initialized.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_boundaryconditions_file_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_boundaryconditions_file_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_boundaryconditions_file_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/boundaryconditions/file/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_boundaryconditions_file_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk boundary condition. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_boundaryconditions_file_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_boundaryconditions_file_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk boundary condition. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_boundaryconditions_file_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_boundaryconditions_file_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_boundaryconditions_file_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/boundaryconditions/file/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_boundaryconditions_file_download(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_download  # noqa: E501

        Endpoint for downloading files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_download(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk boundary condition. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_boundaryconditions_file_download_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_boundaryconditions_file_download_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_download  # noqa: E501

        Endpoint for downloading files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_download_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk boundary condition. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_boundaryconditions_file_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_boundaryconditions_file_download`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_boundaryconditions_file_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/boundaryconditions/file/{id}/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_boundaryconditions_file_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20018
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_boundaryconditions_file_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_boundaryconditions_file_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20018, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_boundaryconditions_file_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_boundaryconditions_file_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/boundaryconditions/file/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20018',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_boundaryconditions_file_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_partial_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk boundary condition. (required)
        :param str simulation_pk: (required)
        :param FileBoundaryCondition data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileBoundaryCondition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_boundaryconditions_file_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_boundaryconditions_file_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_partial_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk boundary condition. (required)
        :param str simulation_pk: (required)
        :param FileBoundaryCondition data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileBoundaryCondition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_boundaryconditions_file_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_boundaryconditions_file_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_boundaryconditions_file_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_boundaryconditions_file_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/boundaryconditions/file/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileBoundaryCondition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_boundaryconditions_file_processed(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_processed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_processed(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk boundary condition. (required)
        :param str simulation_pk: (required)
        :param BaseEventState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_boundaryconditions_file_processed_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_boundaryconditions_file_processed_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_processed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_processed_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk boundary condition. (required)
        :param str simulation_pk: (required)
        :param BaseEventState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_boundaryconditions_file_processed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_boundaryconditions_file_processed`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_boundaryconditions_file_processed`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_boundaryconditions_file_processed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/boundaryconditions/file/{id}/processed/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_boundaryconditions_file_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_read  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk boundary condition. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileBoundaryCondition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_boundaryconditions_file_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_boundaryconditions_file_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_read  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk boundary condition. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileBoundaryCondition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_boundaryconditions_file_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_boundaryconditions_file_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_boundaryconditions_file_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/boundaryconditions/file/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileBoundaryCondition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_boundaryconditions_file_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk boundary condition. (required)
        :param str simulation_pk: (required)
        :param FileBoundaryCondition data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileBoundaryCondition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_boundaryconditions_file_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_boundaryconditions_file_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_boundaryconditions_file_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_boundaryconditions_file_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk boundary condition. (required)
        :param str simulation_pk: (required)
        :param FileBoundaryCondition data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileBoundaryCondition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_boundaryconditions_file_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_boundaryconditions_file_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_boundaryconditions_file_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_boundaryconditions_file_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/boundaryconditions/file/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileBoundaryCondition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_breaches_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_breaches_create  # noqa: E501

        Create a breach during a given simulation. The `potential_breach` parameter refers to the id of a potential location associated with the threedimodel. A list of these locations can be retrieved at the uri `/threedimodels/{id}/potentialbreaches/`  The `duration_till_max_depth` parameter describes the time it takes until the deepest point of the breach is reached. [seconds]  `maximum_breach_depth` specifies the maximum depth of the breach relative to the top of the levee [meters]  `initial_width` of the breach [meters]  `discharge_coefficient_positive` and `discharge_coefficient_negative` are dimensionless parameters to deal with behaviour of energy loss around a breach.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Breach data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Breach
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_breaches_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_breaches_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_breaches_create  # noqa: E501

        Create a breach during a given simulation. The `potential_breach` parameter refers to the id of a potential location associated with the threedimodel. A list of these locations can be retrieved at the uri `/threedimodels/{id}/potentialbreaches/`  The `duration_till_max_depth` parameter describes the time it takes until the deepest point of the breach is reached. [seconds]  `maximum_breach_depth` specifies the maximum depth of the breach relative to the top of the levee [meters]  `initial_width` of the breach [meters]  `discharge_coefficient_positive` and `discharge_coefficient_negative` are dimensionless parameters to deal with behaviour of energy loss around a breach.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Breach data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Breach, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_breaches_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_breaches_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_breaches_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/breaches/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Breach',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_breaches_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_breaches_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_breaches_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_breaches_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_breaches_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_breaches_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_breaches_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_breaches_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/breaches/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_breaches_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_breaches_list  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20019
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_breaches_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_breaches_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_breaches_list  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20019, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_breaches_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_breaches_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/breaches/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20019',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_breaches_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_breaches_partial_update  # noqa: E501

        Please note: **Breach resources are not allowed to be patched after the simulation has started**  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param Breach data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_breaches_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_breaches_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_breaches_partial_update  # noqa: E501

        Please note: **Breach resources are not allowed to be patched after the simulation has started**  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param Breach data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_breaches_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_breaches_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_breaches_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_breaches_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/breaches/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_breaches_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_breaches_read  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Breach
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_breaches_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_breaches_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_breaches_read  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Breach, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_breaches_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_breaches_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_breaches_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/breaches/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Breach',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_breaches_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_breaches_update  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param Breach data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Breach
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_breaches_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_breaches_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_breaches_update  # noqa: E501

        A simple ViewSet for viewing Breaches  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_breaches_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this breach. (required)
        :param str simulation_pk: (required)
        :param Breach data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Breach, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_breaches_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_breaches_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_breaches_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_breaches_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/breaches/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Breach',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_create  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_create  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_constant_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/constant/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_constant_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/constant/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_list  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20020
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_list  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20020, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/constant/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20020',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param ConstantLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param ConstantLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_constant_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/constant/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_processed(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_processed  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_processed(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param GridEventState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_processed_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_processed_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_processed  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_processed_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param GridEventState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_processed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_constant_processed`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_processed`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_constant_processed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/constant/{id}/processed/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_read  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_read  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_constant_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/constant/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_constant_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_update  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param ConstantLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_constant_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_constant_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_constant_update  # noqa: E501

        A simple ViewSet for viewing ConstantLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_constant_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param ConstantLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_constant_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_constant_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_constant_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_constant_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/constant/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_file_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Endpoint for uploading a file with one or more laterals.  # noqa: E501

        The format of the filename should be <filename>.<extension>, e.g.  `laterals_bergermeer.json`  Every leading and trailing spaces will be removed. Other spaces are converted to underscores and anything that is not an alphanumeric, dash, underscore, or dot will be removed as well.  The response provides a put_url which allows you to upload a file containing one or more laterals. These laterals should either be a constant- or a timeseries-lateral, or a combination of both. See their respective endpoint for the required fields of these laterals.  The uploaded file should be a JSON-file containing an array of laterals. Example of the content of such a file: ``` [   {     \"offset\": 100,     \"value\": 0.05,     \"duration\": 300,     \"units\": \"m3/s\",     \"connection_node\": 5   },   {     \"offset\": 180,     \"interpolate\": false,     \"values\": [       [0.0, 0.0002],       [900.0, 0.0],       [1200.0, 0.0001],       [1620.0, 0.0]     ],     \"units\": \"m3/s\",     \"connection_node\": 4   },   {     \"offset\": 0,     \"value\": 0.03,     \"duration\": 500,     \"units\": \"m3/s\",     \"point\": {       \"type\": \"Point\",       \"coordinates\": [4.70184629, 52.62586862]   #  longitude, latitude     }   } ] ```  The `offset` of this file-lateral-event will be applied to each individual lateral offset in the uploaded file  If the `periodic` field is set to `daily` the values given are used for every hour of every day in the simulation. Exactly 25 (0-24) timeseries per entry are required like such:       \"values\": [         [0.0, 0.0002],         [3600, 0.01],         .....         <SNIP>         .....         [82800, 0.15]  # 3600.0 * 23         [86400, 0.0]   # 3600.0 * 24       ]  Only laterals with 'values' are allowed in this case.  The **hour** (not minutes or seconds) of the simulation `start_datetime` (UTC) is taken into consideration for the first timeseries value to use. Periodic laterals are intended for dry weather flow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param UploadEventFile data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UploadEventFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_file_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_file_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """Endpoint for uploading a file with one or more laterals.  # noqa: E501

        The format of the filename should be <filename>.<extension>, e.g.  `laterals_bergermeer.json`  Every leading and trailing spaces will be removed. Other spaces are converted to underscores and anything that is not an alphanumeric, dash, underscore, or dot will be removed as well.  The response provides a put_url which allows you to upload a file containing one or more laterals. These laterals should either be a constant- or a timeseries-lateral, or a combination of both. See their respective endpoint for the required fields of these laterals.  The uploaded file should be a JSON-file containing an array of laterals. Example of the content of such a file: ``` [   {     \"offset\": 100,     \"value\": 0.05,     \"duration\": 300,     \"units\": \"m3/s\",     \"connection_node\": 5   },   {     \"offset\": 180,     \"interpolate\": false,     \"values\": [       [0.0, 0.0002],       [900.0, 0.0],       [1200.0, 0.0001],       [1620.0, 0.0]     ],     \"units\": \"m3/s\",     \"connection_node\": 4   },   {     \"offset\": 0,     \"value\": 0.03,     \"duration\": 500,     \"units\": \"m3/s\",     \"point\": {       \"type\": \"Point\",       \"coordinates\": [4.70184629, 52.62586862]   #  longitude, latitude     }   } ] ```  The `offset` of this file-lateral-event will be applied to each individual lateral offset in the uploaded file  If the `periodic` field is set to `daily` the values given are used for every hour of every day in the simulation. Exactly 25 (0-24) timeseries per entry are required like such:       \"values\": [         [0.0, 0.0002],         [3600, 0.01],         .....         <SNIP>         .....         [82800, 0.15]  # 3600.0 * 23         [86400, 0.0]   # 3600.0 * 24       ]  Only laterals with 'values' are allowed in this case.  The **hour** (not minutes or seconds) of the simulation `start_datetime` (UTC) is taken into consideration for the first timeseries value to use. Periodic laterals are intended for dry weather flow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param UploadEventFile data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UploadEventFile, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_file_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_file_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_file_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/file/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UploadEventFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_file_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk lateral. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_file_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_file_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk lateral. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_file_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_file_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_file_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/file/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_file_download(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_download  # noqa: E501

        Endpoint for downloading files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_download(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk lateral. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Download
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_file_download_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_file_download_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_download  # noqa: E501

        Endpoint for downloading files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_download_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk lateral. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Download, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_file_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_file_download`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_file_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/file/{id}/download/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Download',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_file_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20021
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_file_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_file_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20021, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_file_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_file_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/file/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20021',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_file_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk lateral. (required)
        :param str simulation_pk: (required)
        :param FileLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_file_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_file_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk lateral. (required)
        :param str simulation_pk: (required)
        :param FileLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_file_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_file_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_file_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_file_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/file/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_file_processed(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_processed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_processed(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk lateral. (required)
        :param str simulation_pk: (required)
        :param BaseEventState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_file_processed_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_file_processed_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_processed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_processed_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk lateral. (required)
        :param str simulation_pk: (required)
        :param BaseEventState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_file_processed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_file_processed`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_file_processed`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_file_processed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/file/{id}/processed/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_file_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_read  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk lateral. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_file_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_file_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_read  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk lateral. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_file_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_file_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_file_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/file/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_file_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk lateral. (required)
        :param str simulation_pk: (required)
        :param FileLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_file_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_file_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_file_update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_file_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this bulk lateral. (required)
        :param str simulation_pk: (required)
        :param FileLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_file_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_file_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_file_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_file_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/file/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_timeseries_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/timeseries/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_timeseries_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/timeseries/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20022
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20022, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/timeseries/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20022',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_timeseries_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/timeseries/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_processed(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_processed  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_processed(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param GridEventState data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_processed_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_processed_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_processed  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_processed_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param GridEventState data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_processed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_timeseries_processed`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_processed`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_timeseries_processed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/timeseries/{id}/processed/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_timeseries_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/timeseries/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_lateral_timeseries_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLateral data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLateral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_lateral_timeseries_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_lateral_timeseries_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_lateral_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_lateral_timeseries_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lateral. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLateral data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLateral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_lateral_timeseries_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_lateral_timeseries_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_lateral_timeseries_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_lateral_timeseries_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/lateral/timeseries/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLateral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_constant_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_constant_create  # noqa: E501

        A simple ViewSet for viewing ConstantLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_constant_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantLeakage data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLeakage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_constant_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_leakage_constant_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_constant_create  # noqa: E501

        A simple ViewSet for viewing ConstantLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_constant_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantLeakage data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLeakage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_constant_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_constant_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_leakage_constant_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/constant/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLeakage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_constant_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_constant_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_constant_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_leakage_constant_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_constant_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_constant_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_constant_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_constant_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/constant/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_constant_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_constant_list  # noqa: E501

        A simple ViewSet for viewing ConstantLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_constant_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20023
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_constant_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_leakage_constant_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_constant_list  # noqa: E501

        A simple ViewSet for viewing ConstantLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_constant_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20023, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_constant_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_constant_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/constant/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20023',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_constant_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_constant_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param ConstantLeakage data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_constant_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_leakage_constant_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_constant_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param ConstantLeakage data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_constant_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_leakage_constant_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/constant/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_constant_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_constant_read  # noqa: E501

        A simple ViewSet for viewing ConstantLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_constant_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLeakage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_constant_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_leakage_constant_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_constant_read  # noqa: E501

        A simple ViewSet for viewing ConstantLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_constant_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLeakage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_constant_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_constant_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_constant_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/constant/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLeakage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_constant_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_constant_update  # noqa: E501

        A simple ViewSet for viewing ConstantLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_constant_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param ConstantLeakage data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLeakage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_constant_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_leakage_constant_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_constant_update  # noqa: E501

        A simple ViewSet for viewing ConstantLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_constant_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param ConstantLeakage data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLeakage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_constant_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_constant_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_constant_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_leakage_constant_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/constant/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLeakage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_rasters_netcdf_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_rasters_netcdf_create  # noqa: E501

        NetCDF 4 raster leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_rasters_netcdf_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_rasters_netcdf_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_leakage_rasters_netcdf_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_rasters_netcdf_create  # noqa: E501

        NetCDF 4 raster leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_rasters_netcdf_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_rasters_netcdf_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_rasters_netcdf_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_leakage_rasters_netcdf_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/rasters/netcdf/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_rasters_netcdf_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_rasters_netcdf_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_rasters_netcdf_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster leakage. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_rasters_netcdf_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_leakage_rasters_netcdf_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_rasters_netcdf_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_rasters_netcdf_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster leakage. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_rasters_netcdf_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_rasters_netcdf_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_rasters_netcdf_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/rasters/netcdf/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_rasters_netcdf_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_rasters_netcdf_list  # noqa: E501

        NetCDF 4 raster leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_rasters_netcdf_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20024
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_rasters_netcdf_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_leakage_rasters_netcdf_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_rasters_netcdf_list  # noqa: E501

        NetCDF 4 raster leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_rasters_netcdf_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20024, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_rasters_netcdf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_rasters_netcdf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/rasters/netcdf/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20024',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_rasters_netcdf_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_rasters_netcdf_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_rasters_netcdf_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster leakage. (required)
        :param str simulation_pk: (required)
        :param NetCDFRasterLeakage data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_rasters_netcdf_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_leakage_rasters_netcdf_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_rasters_netcdf_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_rasters_netcdf_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster leakage. (required)
        :param str simulation_pk: (required)
        :param NetCDFRasterLeakage data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_rasters_netcdf_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_rasters_netcdf_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_rasters_netcdf_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_leakage_rasters_netcdf_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/rasters/netcdf/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_rasters_netcdf_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_rasters_netcdf_read  # noqa: E501

        NetCDF 4 raster leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_rasters_netcdf_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster leakage. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NetCDFRasterLeakage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_rasters_netcdf_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_leakage_rasters_netcdf_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_rasters_netcdf_read  # noqa: E501

        NetCDF 4 raster leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_rasters_netcdf_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster leakage. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NetCDFRasterLeakage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_rasters_netcdf_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_rasters_netcdf_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_rasters_netcdf_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/rasters/netcdf/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetCDFRasterLeakage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_rasters_netcdf_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_rasters_netcdf_update  # noqa: E501

        NetCDF 4 raster leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_rasters_netcdf_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster leakage. (required)
        :param str simulation_pk: (required)
        :param NetCDFRasterLeakage data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NetCDFRasterLeakage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_rasters_netcdf_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_leakage_rasters_netcdf_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_rasters_netcdf_update  # noqa: E501

        NetCDF 4 raster leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_rasters_netcdf_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file raster leakage. (required)
        :param str simulation_pk: (required)
        :param NetCDFRasterLeakage data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NetCDFRasterLeakage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_rasters_netcdf_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_rasters_netcdf_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_rasters_netcdf_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_leakage_rasters_netcdf_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/rasters/netcdf/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetCDFRasterLeakage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_timeseries_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesLeakage data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLeakage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_timeseries_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_leakage_timeseries_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_create  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesLeakage data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLeakage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_timeseries_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_timeseries_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_leakage_timeseries_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/timeseries/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLeakage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_timeseries_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_timeseries_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_leakage_timeseries_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_timeseries_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_timeseries_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_timeseries_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/timeseries/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_timeseries_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20025
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_timeseries_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_leakage_timeseries_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20025, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_timeseries_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_timeseries_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/timeseries/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20025',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_timeseries_netcdf_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_netcdf_create  # noqa: E501

        NetCDF 4 timeseries leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_netcdf_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Upload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_timeseries_netcdf_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_leakage_timeseries_netcdf_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_netcdf_create  # noqa: E501

        NetCDF 4 timeseries leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_netcdf_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param Upload data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Upload, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_timeseries_netcdf_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_timeseries_netcdf_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_leakage_timeseries_netcdf_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/timeseries/netcdf/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Upload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_timeseries_netcdf_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_netcdf_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_netcdf_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_timeseries_netcdf_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_leakage_timeseries_netcdf_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_netcdf_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_netcdf_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_timeseries_netcdf_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_timeseries_netcdf_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_timeseries_netcdf_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/timeseries/netcdf/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_timeseries_netcdf_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_netcdf_list  # noqa: E501

        NetCDF 4 timeseries leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_netcdf_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20026
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_timeseries_netcdf_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_leakage_timeseries_netcdf_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_netcdf_list  # noqa: E501

        NetCDF 4 timeseries leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_netcdf_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20026, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_timeseries_netcdf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_timeseries_netcdf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/timeseries/netcdf/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20026',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_timeseries_netcdf_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_netcdf_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_netcdf_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param NetCDFTimeseriesLeakage data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_timeseries_netcdf_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_leakage_timeseries_netcdf_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_netcdf_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_netcdf_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param NetCDFTimeseriesLeakage data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_timeseries_netcdf_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_timeseries_netcdf_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_timeseries_netcdf_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_leakage_timeseries_netcdf_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/timeseries/netcdf/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_timeseries_netcdf_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_netcdf_read  # noqa: E501

        NetCDF 4 timeseries leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_netcdf_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NetCDFTimeseriesLeakage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_timeseries_netcdf_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_leakage_timeseries_netcdf_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_netcdf_read  # noqa: E501

        NetCDF 4 timeseries leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_netcdf_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NetCDFTimeseriesLeakage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_timeseries_netcdf_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_timeseries_netcdf_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_timeseries_netcdf_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/timeseries/netcdf/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetCDFTimeseriesLeakage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_timeseries_netcdf_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_netcdf_update  # noqa: E501

        NetCDF 4 timeseries leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_netcdf_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param NetCDFTimeseriesLeakage data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NetCDFTimeseriesLeakage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_timeseries_netcdf_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_leakage_timeseries_netcdf_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_netcdf_update  # noqa: E501

        NetCDF 4 timeseries leakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_netcdf_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this file timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param NetCDFTimeseriesLeakage data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NetCDFTimeseriesLeakage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_timeseries_netcdf_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_timeseries_netcdf_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_timeseries_netcdf_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_leakage_timeseries_netcdf_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/timeseries/netcdf/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetCDFTimeseriesLeakage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_timeseries_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLeakage data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_timeseries_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_leakage_timeseries_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLeakage data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_timeseries_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_leakage_timeseries_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/timeseries/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_timeseries_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLeakage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_timeseries_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_leakage_timeseries_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLeakage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_timeseries_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_timeseries_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_timeseries_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/timeseries/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLeakage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_leakage_timeseries_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLeakage data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLeakage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_leakage_timeseries_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_leakage_timeseries_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_leakage_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesLeakage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_leakage_timeseries_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries leakage. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLeakage data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLeakage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_leakage_timeseries_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_leakage_timeseries_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_leakage_timeseries_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_leakage_timeseries_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/leakage/timeseries/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLeakage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_constant_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_constant_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_constant_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_constant_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_constant_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_constant_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/constant/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_constant_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_constant_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_constant_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_constant_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_constant_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_constant_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/constant/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_constant_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20027
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_constant_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_constant_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20027, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_constant_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_constant_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/constant/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20027',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_constant_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param ConstantRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_constant_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_constant_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param ConstantRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_constant_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_constant_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/constant/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_constant_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_constant_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_constant_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_constant_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_constant_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_constant_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/constant/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_constant_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param ConstantRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_constant_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_constant_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_constant_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_constant_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this timeseries rain. (required)
        :param str simulation_pk: (required)
        :param ConstantRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_constant_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_constant_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_constant_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_constant_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/constant/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_constant_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantLocalRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLocalRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_constant_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_local_constant_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param ConstantLocalRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLocalRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_constant_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_constant_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_local_constant_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/local/constant/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLocalRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_constant_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_constant_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_local_constant_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_constant_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_constant_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_constant_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/local/constant/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_constant_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20028
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_constant_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_local_constant_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20028, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_constant_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_constant_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/local/constant/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20028',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_constant_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param ConstantLocalRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_constant_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_local_constant_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param ConstantLocalRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_constant_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_constant_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_local_constant_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/local/constant/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_constant_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLocalRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_constant_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_local_constant_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLocalRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_constant_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_constant_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_constant_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/local/constant/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLocalRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_constant_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param ConstantLocalRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConstantLocalRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_constant_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_local_constant_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_constant_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_constant_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param ConstantLocalRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConstantLocalRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_constant_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_constant_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_constant_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_local_constant_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/local/constant/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConstantLocalRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_timeseries_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesLocalRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLocalRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_timeseries_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_local_timeseries_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_create  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param TimeseriesLocalRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLocalRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_timeseries_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_timeseries_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_local_timeseries_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/local/timeseries/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLocalRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_timeseries_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_timeseries_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_local_timeseries_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_timeseries_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_timeseries_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_timeseries_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/local/timeseries/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_timeseries_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20029
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_timeseries_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_local_timeseries_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_list  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20029, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_timeseries_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_timeseries_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/local/timeseries/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20029',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_timeseries_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLocalRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_timeseries_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_local_timeseries_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLocalRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_timeseries_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_timeseries_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_local_timeseries_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/local/timeseries/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_timeseries_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLocalRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_timeseries_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_local_timeseries_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_read  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLocalRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_timeseries_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_timeseries_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_timeseries_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/local/timeseries/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLocalRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_local_timeseries_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLocalRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TimeseriesLocalRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_local_timeseries_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_local_timeseries_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_local_timeseries_update  # noqa: E501

        A simple ViewSet for viewing TimeseriesLateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_local_timeseries_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this local rain. (required)
        :param str simulation_pk: (required)
        :param TimeseriesLocalRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TimeseriesLocalRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_local_timeseries_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_local_timeseries_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_local_timeseries_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_local_timeseries_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/local/timeseries/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeseriesLocalRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_lizard_create(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_create  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_create(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param LizardRasterRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardRasterRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_lizard_create_with_http_info(simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_lizard_create_with_http_info(self, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_create  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_create_with_http_info(simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param LizardRasterRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardRasterRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_lizard_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_lizard_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_rasters_lizard_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/rasters/lizard/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardRasterRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_lizard_delete(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_delete(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_lizard_delete_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_lizard_delete_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_delete  # noqa: E501

        destroy resource only if the event has not yet been applied to the associated simulation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_delete_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_lizard_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_rasters_lizard_delete`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_lizard_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/rasters/lizard/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_lizard_list(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_list  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_list(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse20030
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_lizard_list_with_http_info(simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_lizard_list_with_http_info(self, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_list  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_list_with_http_info(simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str simulation_pk: (required)
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse20030, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'simulation_pk',
            'limit',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_lizard_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_lizard_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/rasters/lizard/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20030',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_lizard_partial_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_partial_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param LizardRasterRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_lizard_partial_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_lizard_partial_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_partial_update  # noqa: E501

        when the simulation has started only the duration parameter might be patched  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_partial_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param LizardRasterRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_lizard_partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_rasters_lizard_partial_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_lizard_partial_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_rasters_lizard_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/rasters/lizard/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_lizard_read(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_read  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_read(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardRasterRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_lizard_read_with_http_info(id, simulation_pk, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_lizard_read_with_http_info(self, id, simulation_pk, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_read  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_read_with_http_info(id, simulation_pk, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardRasterRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_lizard_read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_rasters_lizard_read`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_lizard_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'simulation_pk' in local_var_params:
            path_params['simulation_pk'] = local_var_params['simulation_pk']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v3/simulations/{simulation_pk}/events/rain/rasters/lizard/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LizardRasterRain',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def simulations_events_rain_rasters_lizard_update(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_update  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_update(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param LizardRasterRain data: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LizardRasterRain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.simulations_events_rain_rasters_lizard_update_with_http_info(id, simulation_pk, data, **kwargs)  # noqa: E501

    def simulations_events_rain_rasters_lizard_update_with_http_info(self, id, simulation_pk, data, **kwargs):  # noqa: E501
        """simulations_events_rain_rasters_lizard_update  # noqa: E501

        A simple ViewSet for viewing lizardRasterRain  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.simulations_events_rain_rasters_lizard_update_with_http_info(id, simulation_pk, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: A unique integer value identifying this lizard raster rain. (required)
        :param str simulation_pk: (required)
        :param LizardRasterRain data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LizardRasterRain, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'simulation_pk',
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method simulations_events_rain_rasters_lizard_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `simulations_events_rain_rasters_lizard_update`")  # noqa: E501
        # verify the required parameter 'simulation_pk' is set
        if self.api_client.client_side_validation and ('simulation_pk' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulation_pk'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulation_pk` when calling `simulations_events_rain_rasters_lizard_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `simulations_events_rain_rasters_lizard_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
     