"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RustExtension = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const lambda = require("aws-cdk-lib/aws-lambda");
const bundling_1 = require("./bundling");
const cargo_1 = require("./cargo");
/**
 * A Lambda extension written in Rust
 */
class RustExtension extends lambda.LayerVersion {
    constructor(scope, packageName, props) {
        const manifestPath = cargo_1.getCargoManifestPath(props?.manifestPath ?? 'Cargo.toml');
        const bundling = props?.bundling ?? {};
        super(scope, packageName, {
            ...props,
            code: bundling_1.Bundling.bundle({
                ...bundling,
                packageName,
                manifestPath,
                binaryName: props?.binaryName,
                lambdaExtension: true,
            }),
        });
    }
}
exports.RustExtension = RustExtension;
_a = JSII_RTTI_SYMBOL_1;
RustExtension[_a] = { fqn: "cargo-lambda-cdk.RustExtension", version: "0.0.9" };
//# sourceMappingURL=data:application/json;base64,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