/**
 *
 * RenderPipeline
 *
 * Copyright (c) 2014-2016 tobspr <tobias.springer1@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

#pragma once


/*

This are uniformly distributed Poisson Disks.

All disks are sorted depending on their angle and radius, to make sure texture
chaching works as intended.

The program to generate the poisson disks can be found in
toolkit/poisson_disk_generator.

*/


/*

2D Poisson Disks

*/

CONST_ARRAY vec2 poisson_2D_4[4] = vec2[](
    vec2(-0.953543, -0.300415),
    vec2(0.291287, -0.956411),
    vec2(0.957769, 0.282242),
    vec2(-0.277367, 0.960318)
);

CONST_ARRAY vec2 poisson_2D_8[8] = vec2[](
    vec2(-0.994272, -0.104946),
    vec2(-0.375669, -0.92651),
    vec2(0.62611, -0.778924),
    vec2(0.910956, 0.412246),
    vec2(0.972791, -0.226412),
    vec2(0.265636, 0.96113),
    vec2(-0.549897, 0.833746),
    vec2(0.00219648, 0.00555702)
);

CONST_ARRAY vec2 poisson_2D_12[12] = vec2[](
    vec2(-0.759347, -0.650607),
    vec2(-0.276351, -0.00941298),
    vec2(-0.999368, -0.0324209),
    vec2(-0.193248, -0.979636),
    vec2(0.457157, -0.885871),
    vec2(0.968703, -0.246042),
    vec2(0.310191, -0.266896),
    vec2(0.44068, 0.355746),
    vec2(0.448887, 0.885861),
    vec2(0.955905, 0.292457),
    vec2(-0.79166, 0.605247),
    vec2(-0.0714434, 0.980047)
);


CONST_ARRAY vec2 poisson_2D_16[16] = vec2[](
    vec2(-0.680088, -0.731923),
    vec2(-0.957909, -0.247622),
    vec2(0.0948045, -0.992508),
    vec2(-0.316418, -0.93561),
    vec2(0.508091, -0.270309),
    vec2(0.986855, -0.161122),
    vec2(-0.0783372, -0.377044),
    vec2(0.678299, -0.730012),
    vec2(0.264303, 0.150586),
    vec2(0.375585, 0.926198),
    vec2(0.869216, 0.485342),
    vec2(-0.0303609, 0.582547),
    vec2(-0.456659, 0.886469),
    vec2(-0.0502123, 0.998242),
    vec2(-0.522737, 0.0698312),
    vec2(-0.857891, 0.512805)
);

CONST_ARRAY vec2 poisson_2D_32[32] = vec2[](
    vec2(-0.645095, -0.281509),
    vec2(-0.491004, -0.535543),
    vec2(-0.251013, -0.96746),
    vec2(-0.527482, -0.838249),
    vec2(-0.940142, -0.338633),
    vec2(-0.78887, -0.602182),
    vec2(-0.306068, -0.207344),
    vec2(0.0236232, -0.763255),
    vec2(0.326509, -0.930717),
    vec2(0.0188184, -0.427136),
    vec2(0.734814, -0.2611),
    vec2(0.997828, -0.0467772),
    vec2(0.102272, -0.0652116),
    vec2(0.800923, -0.596026),
    vec2(0.532466, -0.718217),
    vec2(0.45988, -0.0147904),
    vec2(0.428033, -0.434308),
    vec2(0.569939, 0.31757),
    vec2(0.847669, 0.530125),
    vec2(0.517769, 0.839368),
    vec2(0.247533, 0.477887),
    vec2(0.952392, 0.24895),
    vec2(-0.49404, 0.843787),
    vec2(0.071269, 0.98377),
    vec2(-0.901791, 0.425404),
    vec2(-0.511218, 0.404082),
    vec2(-0.166727, 0.573622),
    vec2(-0.719383, 0.656148),
    vec2(-0.221952, 0.956912),
    vec2(-0.639361, 0.0178937),
    vec2(-0.192214, 0.149272),
    vec2(-0.999393, 0.0286758)
);

CONST_ARRAY vec2 poisson_2D_64[64] = vec2[](
    vec2(-0.086316, -0.968111),
    vec2(-0.279227, -0.959008),
    vec2(-0.174659, -0.779219),
    vec2(-0.994046, -0.100337),
    vec2(-0.830417, -0.258316),
    vec2(-0.29098, -0.276363),
    vec2(-0.0711791, -0.309748),
    vec2(0.127704, -0.414434),
    vec2(0.255973, -0.712316),
    vec2(-0.472927, -0.394059),
    vec2(0.35572, -0.928901),
    vec2(-0.658504, -0.535877),
    vec2(0.105184, -0.99382),
    vec2(-0.414437, -0.0607066),
    vec2(-0.366554, -0.691781),
    vec2(-0.464703, -0.862405),
    vec2(-0.161989, -0.104327),
    vec2(-0.174757, -0.515362),
    vec2(-0.637325, -0.770203),
    vec2(-0.664806, -0.128825),
    vec2(-0.879395, -0.465052),
    vec2(0.0304411, -0.762748),
    vec2(0.443908, -0.577779),
    vec2(0.188869, -0.0525923),
    vec2(0.988219, -0.136184),
    vec2(0.369901, -0.259416),
    vec2(0.805865, -0.578815),
    vec2(0.628829, -0.776143),
    vec2(0.626141, -0.343504),
    vec2(0.74722, 0.655944),
    vec2(0.234085, 0.806087),
    vec2(0.93415, 0.337947),
    vec2(0.412135, 0.901209),
    vec2(0.676801, 0.206996),
    vec2(0.0943238, 0.661738),
    vec2(0.118536, 0.984615),
    vec2(0.589421, 0.79131),
    vec2(0.731047, 0.429766),
    vec2(0.478587, 0.439142),
    vec2(0.22497, 0.445659),
    vec2(0.374495, 0.660695),
    vec2(0.906059, 0.0973713),
    vec2(0.33495, 0.190513),
    vec2(0.757964, -0.136907),
    vec2(0.54374, -0.0527806),
    vec2(0.908866, -0.36894),
    vec2(-0.0776111, 0.477161),
    vec2(-0.181392, 0.975743),
    vec2(-0.139923, 0.74221),
    vec2(-0.78206, 0.102957),
    vec2(-0.576849, 0.450708),
    vec2(-0.00888789, 0.05214),
    vec2(-0.708787, 0.698047),
    vec2(-0.84552, 0.531998),
    vec2(-0.253359, 0.267802),
    vec2(-0.493709, 0.659425),
    vec2(-0.992843, 0.11576),
    vec2(-0.302095, 0.564714),
    vec2(-0.464918, 0.874781),
    vec2(-0.711149, 0.302547),
    vec2(-0.915964, 0.323287),
    vec2(-0.263747, 0.0616327),
    vec2(-0.519476, 0.175641),
    vec2(0.0307961, 0.26891)
);



/*


3D Poisson Disks


*/

CONST_ARRAY vec3 poisson_3D_16[16] = vec3[](
    vec3(-0.0601252, -0.090253, 0.242585),
    vec3(-0.954277, -0.230389, 0.0491814),
    vec3(-0.440708, -0.751107, 0.48156),
    vec3(0.157285, -0.98681, -0.0113457),
    vec3(-0.463958, -0.603355, -0.645049),
    vec3(0.352804, -0.600314, 0.705076),
    vec3(0.945725, -0.167066, -0.26733),
    vec3(0.378653, -0.457091, -0.789674),
    vec3(0.175363, 0.326807, -0.923022),
    vec3(0.75046, 0.133097, 0.643648),
    vec3(0.533623, 0.832552, 0.0769863),
    vec3(-0.685037, 0.662173, -0.295431),
    vec3(-0.0454946, 0.134477, 0.985295),
    vec3(-0.534475, 0.0997254, -0.826768),
    vec3(-0.307152, 0.748555, 0.585295),
    vec3(-0.709746, 0.0374277, 0.68205)
);

CONST_ARRAY vec3 poisson_3D_32[32] = vec3[](
    vec3(-0.637433, -0.0795689, 0.749829),
    vec3(-0.166216, -0.0315564, -0.983756),
    vec3(-0.528491, -0.143633, 0.195646),
    vec3(-0.249567, -0.825099, 0.498893),
    vec3(-0.558757, -0.434904, -0.667499),
    vec3(-0.858404, -0.473501, -0.145915),
    vec3(-0.135047, -0.296593, -0.335407),
    vec3(0.316311, -0.757367, 0.261108),
    vec3(-0.163747, -0.374054, 0.88854),
    vec3(0.268538, -0.898278, -0.335799),
    vec3(-0.381943, -0.906282, -0.16664),
    vec3(0.837301, -0.420993, 0.347183),
    vec3(0.36155, -0.12942, 0.913665),
    vec3(0.722952, 0.655391, 0.209401),
    vec3(0.374059, 0.504317, -0.764699),
    vec3(0.466859, 0.811274, -0.270417),
    vec3(0.962492, 0.082706, 0.102222),
    vec3(0.726909, 0.197392, 0.592712),
    vec3(0.726963, -0.519139, -0.26076),
    vec3(0.863379, 0.0510047, -0.479442),
    vec3(0.39697, -0.392489, -0.778489),
    vec3(0.395817, 0.28567, -0.152613),
    vec3(0.0115477, 0.0392268, 0.262437),
    vec3(-0.124912, 0.314161, 0.906488),
    vec3(-0.795609, 0.124298, -0.584104),
    vec3(-0.58822, 0.533162, 0.596359),
    vec3(-0.465148, 0.867438, 0.068886),
    vec3(-0.347131, 0.479682, -0.773511),
    vec3(-0.0359631, 0.862508, 0.497219),
    vec3(-0.869958, 0.454845, 0.0919322),
    vec3(-0.100729, 0.895672, -0.400421),
    vec3(-0.312793, 0.316496, -0.184027)
);

CONST_ARRAY vec3 poisson_3D_64[64] = vec3[](
    vec3(-0.15773, -0.0451896, -0.9623),
    vec3(-0.0130272, -0.640955, -0.751804),
    vec3(-0.214195, -0.789982, 0.571629),
    vec3(-0.22401, -0.127885, -0.479033),
    vec3(-0.0381656, -0.400932, 0.389145),
    vec3(-0.958604, -0.255706, 0.0608546),
    vec3(-0.491959, -0.0240958, 0.867465),
    vec3(-0.735088, -0.589627, -0.0952913),
    vec3(-0.361071, -0.387626, -0.841852),
    vec3(-0.454339, -0.716331, -0.490685),
    vec3(-0.464857, -0.00371937, 0.416402),
    vec3(-0.252955, -0.952897, -0.0173203),
    vec3(-0.310376, -0.450015, 0.834997),
    vec3(-0.481379, -0.12181, -0.0713362),
    vec3(0.17995, -0.273669, -0.910183),
    vec3(0.100674, -0.18972, 0.96892),
    vec3(0.229951, -0.770195, -0.427458),
    vec3(-0.534464, -0.703867, 0.273916),
    vec3(-0.779887, -0.341913, 0.505745),
    vec3(-0.793823, -0.290259, -0.406983),
    vec3(0.512152, -0.541214, -0.661702),
    vec3(0.616316, -0.597375, 0.505634),
    vec3(0.798438, -0.464642, -0.225906),
    vec3(0.546185, -0.833083, -0.0299397),
    vec3(0.38638, -0.311687, 0.154036),
    vec3(0.172597, -0.639959, 0.741325),
    vec3(0.124675, -0.818478, 0.257105),
    vec3(-0.172153, -0.492998, -0.0557574),
    vec3(0.318022, -0.24362, -0.38011),
    vec3(0.531653, -0.165474, 0.749569),
    vec3(0.529882, 0.24116, -0.257057),
    vec3(0.466419, 0.215838, 0.25547),
    vec3(0.0712114, 0.0329548, 0.548568),
    vec3(0.723801, -0.0377743, -0.668303),
    vec3(0.814331, 0.205909, 0.504961),
    vec3(0.93028, 0.357367, 0.0674278),
    vec3(0.921439, -0.213509, 0.314967),
    vec3(0.96477, -0.0016533, -0.256952),
    vec3(-0.0662509, 0.986109, -0.0656959),
    vec3(0.185578, 0.617772, -0.181412),
    vec3(0.107275, 0.241256, -0.491317),
    vec3(0.164571, 0.247343, 0.917695),
    vec3(0.0651426, 0.739647, -0.652712),
    vec3(0.456338, 0.504012, 0.706019),
    vec3(0.293143, 0.169755, -0.932919),
    vec3(0.032654, 0.0818838, 0.00303189),
    vec3(0.601786, 0.735747, 0.216412),
    vec3(0.151178, 0.940888, 0.300587),
    vec3(0.702927, 0.659986, -0.246973),
    vec3(0.0395814, 0.691424, 0.686644),
    vec3(0.451051, 0.515958, -0.689563),
    vec3(-0.891535, 0.111488, 0.301105),
    vec3(-0.720135, 0.120472, -0.674127),
    vec3(-0.747936, 0.51219, 0.177613),
    vec3(-0.16722, 0.372523, -0.887329),
    vec3(-0.674427, 0.357484, 0.643218),
    vec3(-0.249121, 0.379101, 0.871001),
    vec3(-0.929231, 0.219506, -0.255281),
    vec3(-0.487606, 0.461665, -0.621111),
    vec3(-0.451381, 0.890955, 0.0284355),
    vec3(-0.724563, 0.612287, -0.273063),
    vec3(-0.228439, 0.555403, 0.34383),
    vec3(-0.328195, 0.828738, -0.447974),
    vec3(-0.417829, 0.32502, -0.232616)
);
