"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartingPosition = exports.EventSourceMapping = exports.SourceAccessConfigurationType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const lambda_generated_1 = require("./lambda.generated");
/**
 * The type of authentication protocol or the VPC components for your event source's SourceAccessConfiguration
 * @see https://docs.aws.amazon.com/lambda/latest/dg/API_SourceAccessConfiguration.html#SSS-Type-SourceAccessConfiguration-Type
 */
class SourceAccessConfigurationType {
    constructor(type) {
        this.type = type;
    }
    /** A custom source access configuration property */
    static of(name) {
        return new SourceAccessConfigurationType(name);
    }
}
exports.SourceAccessConfigurationType = SourceAccessConfigurationType;
_a = JSII_RTTI_SYMBOL_1;
SourceAccessConfigurationType[_a] = { fqn: "@aws-cdk/aws-lambda.SourceAccessConfigurationType", version: "1.150.0" };
/**
 * (MQ) The Secrets Manager secret that stores your broker credentials.
 */
SourceAccessConfigurationType.BASIC_AUTH = new SourceAccessConfigurationType('BASIC_AUTH');
/**
 * The subnets associated with your VPC. Lambda connects to these subnets to fetch data from your Self-Managed Apache Kafka cluster.
 */
SourceAccessConfigurationType.VPC_SUBNET = new SourceAccessConfigurationType('VPC_SUBNET');
/**
 * The VPC security group used to manage access to your Self-Managed Apache Kafka brokers.
 */
SourceAccessConfigurationType.VPC_SECURITY_GROUP = new SourceAccessConfigurationType('VPC_SECURITY_GROUP');
/**
 * The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your Self-Managed Apache Kafka brokers.
 */
SourceAccessConfigurationType.SASL_SCRAM_256_AUTH = new SourceAccessConfigurationType('SASL_SCRAM_256_AUTH');
/**
 * The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your Self-Managed Apache Kafka brokers.
 */
SourceAccessConfigurationType.SASL_SCRAM_512_AUTH = new SourceAccessConfigurationType('SASL_SCRAM_512_AUTH');
/**
 * The Secrets Manager ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM),
 * and private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
 */
SourceAccessConfigurationType.CLIENT_CERTIFICATE_TLS_AUTH = new SourceAccessConfigurationType('CLIENT_CERTIFICATE_TLS_AUTH');
/**
 * Defines a Lambda EventSourceMapping resource.
 *
 * Usually, you won't need to define the mapping yourself. This will usually be done by
 * event sources. For example, to add an SQS event source to a function:
 *
 *    import { SqsEventSource } from '@aws-cdk/aws-lambda-event-sources';
 *    lambda.addEventSource(new SqsEventSource(sqs));
 *
 * The `SqsEventSource` class will automatically create the mapping, and will also
 * modify the Lambda's execution role so it can consume messages from the queue.
 */
class EventSourceMapping extends cdk.Resource {
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_EventSourceMappingProps(props);
        if (props.eventSourceArn == undefined && props.kafkaBootstrapServers == undefined) {
            throw new Error('Either eventSourceArn or kafkaBootstrapServers must be set');
        }
        if (props.eventSourceArn !== undefined && props.kafkaBootstrapServers !== undefined) {
            throw new Error('eventSourceArn and kafkaBootstrapServers are mutually exclusive');
        }
        if (props.kafkaBootstrapServers && (((_c = props.kafkaBootstrapServers) === null || _c === void 0 ? void 0 : _c.length) < 1)) {
            throw new Error('kafkaBootStrapServers must not be empty if set');
        }
        if (props.maxBatchingWindow && props.maxBatchingWindow.toSeconds() > 300) {
            throw new Error(`maxBatchingWindow cannot be over 300 seconds, got ${props.maxBatchingWindow.toSeconds()}`);
        }
        if (props.maxRecordAge && (props.maxRecordAge.toSeconds() < 60 || props.maxRecordAge.toDays({ integral: false }) > 7)) {
            throw new Error('maxRecordAge must be between 60 seconds and 7 days inclusive');
        }
        props.retryAttempts !== undefined && cdk.withResolved(props.retryAttempts, (attempts) => {
            if (attempts < 0 || attempts > 10000) {
                throw new Error(`retryAttempts must be between 0 and 10000 inclusive, got ${attempts}`);
            }
        });
        props.parallelizationFactor !== undefined && cdk.withResolved(props.parallelizationFactor, (factor) => {
            if (factor < 1 || factor > 10) {
                throw new Error(`parallelizationFactor must be between 1 and 10 inclusive, got ${factor}`);
            }
        });
        if (props.tumblingWindow && !cdk.Token.isUnresolved(props.tumblingWindow) && props.tumblingWindow.toSeconds() > 900) {
            throw new Error(`tumblingWindow cannot be over 900 seconds, got ${props.tumblingWindow.toSeconds()}`);
        }
        let destinationConfig;
        if (props.onFailure) {
            destinationConfig = {
                onFailure: props.onFailure.bind(this, props.target),
            };
        }
        let selfManagedEventSource;
        if (props.kafkaBootstrapServers) {
            selfManagedEventSource = { endpoints: { kafkaBootstrapServers: props.kafkaBootstrapServers } };
        }
        const cfnEventSourceMapping = new lambda_generated_1.CfnEventSourceMapping(this, 'Resource', {
            batchSize: props.batchSize,
            bisectBatchOnFunctionError: props.bisectBatchOnError,
            destinationConfig,
            enabled: props.enabled,
            eventSourceArn: props.eventSourceArn,
            functionName: props.target.functionName,
            startingPosition: props.startingPosition,
            functionResponseTypes: props.reportBatchItemFailures ? ['ReportBatchItemFailures'] : undefined,
            maximumBatchingWindowInSeconds: (_d = props.maxBatchingWindow) === null || _d === void 0 ? void 0 : _d.toSeconds(),
            maximumRecordAgeInSeconds: (_e = props.maxRecordAge) === null || _e === void 0 ? void 0 : _e.toSeconds(),
            maximumRetryAttempts: props.retryAttempts,
            parallelizationFactor: props.parallelizationFactor,
            topics: props.kafkaTopic !== undefined ? [props.kafkaTopic] : undefined,
            tumblingWindowInSeconds: (_f = props.tumblingWindow) === null || _f === void 0 ? void 0 : _f.toSeconds(),
            sourceAccessConfigurations: (_g = props.sourceAccessConfigurations) === null || _g === void 0 ? void 0 : _g.map((o) => { return { type: o.type.type, uri: o.uri }; }),
            selfManagedEventSource,
        });
        this.eventSourceMappingId = cfnEventSourceMapping.ref;
    }
    /**
     * Import an event source into this stack from its event source id.
     */
    static fromEventSourceMappingId(scope, id, eventSourceMappingId) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.eventSourceMappingId = eventSourceMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.EventSourceMapping = EventSourceMapping;
_b = JSII_RTTI_SYMBOL_1;
EventSourceMapping[_b] = { fqn: "@aws-cdk/aws-lambda.EventSourceMapping", version: "1.150.0" };
/**
 * The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start
 * reading.
 */
var StartingPosition;
(function (StartingPosition) {
    /**
     * Start reading at the last untrimmed record in the shard in the system,
     * which is the oldest data record in the shard.
     */
    StartingPosition["TRIM_HORIZON"] = "TRIM_HORIZON";
    /**
     * Start reading just after the most recent record in the shard, so that you
     * always read the most recent data in the shard
     */
    StartingPosition["LATEST"] = "LATEST";
})(StartingPosition = exports.StartingPosition || (exports.StartingPosition = {}));
//# sourceMappingURL=data:application/json;base64,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