
<a name="readme-top"></a>

<!-- PROJECT SHIELDS -->
<!--
*** I'm using markdown "reference style" links for readability.
*** Reference links are enclosed in brackets [ ] instead of parentheses ( ).
*** See the bottom of this document for the declaration of the reference variables
*** for contributors-url, forks-url, etc. This is an optional, concise syntax you may use.
*** https://www.markdownguide.org/basic-syntax/#reference-style-links
-->
[![PyPI version](https://badge.fury.io/py/InsiderTrader.svg)](https://badge.fury.io/py/InsiderTrader)
[![Contributors][contributors-shield]][contributors-url]
[![Forks][forks-shield]][forks-url]
[![Stargazers][stars-shield]][stars-url]
[![Issues][issues-shield]][issues-url]
[![MIT License][license-shield]][license-url]
[![LinkedIn][linkedin-shield]][linkedin-url]


<!-- PROJECT LOGO -->
<br />
<div align="center">
  <a href="https://github.com/tuhinmallick/InsiderTrader">
    <img src="docs/images/logo.jpg" alt="Logo" width="80" height="80">
  </a>

<h3 align="center">InsiderTraders</h3>

  <p align="center">
    InsiderTraders is a python package that helps in detecting insider trading activities in the stock market.
    <br />
    <a href="https://github.com/tuhinmallick/InsiderTrader"><strong>Explore the docs »</strong></a>
    <br />
    <br />
    <a href="https://github.com/tuhinmallick/InsiderTrader/blob/main/notebooks/Insider_trading_analysis.ipynb">View Demo</a>
    ·
    <a href="https://github.com/tuhinmallick/InsiderTrader/issues">Report Bug</a>
    ·
    <a href="https://github.com/tuhinmallick/InsiderTrader/issues">Request Feature</a>
  </p>
</div>



<!-- TABLE OF CONTENTS -->
<details>
  <summary>Table of Contents</summary>
  <ol>
    <li>
      <a href="#about-the-project">About The Project</a>
      <ul>
        <li><a href="#built-with">Built With</a></li>
      </ul>
    </li>
    <li>
      <a href="#getting-started">Getting Started</a>
      <ul>
        <li><a href="#prerequisites">Prerequisites</a></li>
        <li><a href="#installation">Installation</a></li>
      </ul>
    </li>
    <li><a href="#usage">Usage</a></li>
    <li><a href="#roadmap">Roadmap</a></li>
    <li><a href="#contributing">Contributing</a></li>
    <li><a href="#license">License</a></li>
    <li><a href="#contact">Contact</a></li>
    <li><a href="#acknowledgments">Acknowledgments</a></li>
  </ol>
</details>



<!-- ABOUT THE PROJECT -->
## About The Project

Insider trading refers to the practice of buying or selling securities by individuals who possess non-public information about a company. This information may include financial results, mergers and acquisitions, or other confidential information that is not yet available to the public. The individuals who engage in insider trading are typically corporate insiders, such as company executives and board members, but it can also include anyone who possesses non-public information.

<p align="right">(<a href="#readme-top">back to top</a>)</p>


<!-- 
### Built With

* [![Next][Next.js]][Next-url]
* [![React][React.js]][React-url]
* [![Vue][Vue.js]][Vue-url]
* [![Angular][Angular.io]][Angular-url]
* [![Svelte][Svelte.dev]][Svelte-url]
* [![Laravel][Laravel.com]][Laravel-url]
* [![Bootstrap][Bootstrap.com]][Bootstrap-url]
* [![JQuery][JQuery.com]][JQuery-url]

<p align="right">(<a href="#readme-top">back to top</a>)</p> -->



<!-- GETTING STARTED -->
## Getting Started

To get a local copy up and running follow these simple example steps.




### Installation

Install [InsiderTrader](https://pypi.org/project/InsiderTrader/0.1.0/) from pypi

```bash
  pip install insider-traders
```
    

### Usage

1. Clone the repo
   ```bash
   git clone https://github.com/tuhinmallick/InsiderTrader.git
   ```
2. Go to the project directory
   ```bash
   cd InsiderTrader
   ```
3. Install environment or dependecies
   ```bash
   conda env create -n ENVNAME --file docs/environment.yml
   ```
   or 
   ```bash
   pip install -r requirements.txt
   ```
4. Import the package in `.py`
   ```bash
   from insider_eda.eda_base import Exploratory_data_analysis
   ```

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- USAGE EXAMPLES -->
## Example

_For more examples, please refer to the [Notebook](https://github.com/tuhinmallick/InsiderTrader/blob/main/notebooks/Insider_trading_analysis.ipynb)_

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- ROADMAP -->
## Roadmap

- [X] Granger casaulty test
- [X] AD Fuller test
- [ ] Make package pip installable
    - [ ] Make readme.rst

See the [open issues](https://github.com/tuhinmallick/InsiderTrader/issues) for a full list of proposed features (and known issues).

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- CONTRIBUTING -->
## Contributing

Contributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**.

If you have a suggestion that would make this better, please fork the repo and create a pull request. You can also simply open an issue with the tag "enhancement".
Don't forget to give the project a star! Thanks again!

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- LICENSE -->
## 🛡 License

[![License](https://img.shields.io/github/license/tuhinmallick/InsiderTrader)](https://github.com/tuhinmallick/InsiderTrader/blob/master/LICENSE)

This project is licensed under the terms of the `MIT` license. See [LICENSE](https://github.com/tuhinmallick/InsiderTrader/blob/master/LICENSE) for more details.

<p align="right">(<a href="#readme-top">back to top</a>)</p>

## Authors

- [@tuhinmallick](https://www.github.com/tuhinmallick)

<!-- CONTACT -->
## Contact

Your Name - [@tuhinmallick](https://twitter.com/tuhinmallick) - tuhin.mllk@gmail.com

Project Link: [https://github.com/tuhinmallick/InsiderTrader](https://github.com/tuhinmallick/InsiderTrader)

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- ACKNOWLEDGMENTS -->
## Acknowledgments

* [ilyaryabov](https://www.kaggle.com/datasets/ilyaryabov/insider-trading-sp500-inside-info)


<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- MARKDOWN LINKS & IMAGES -->
<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->
[contributors-shield]: https://img.shields.io/github/contributors/tuhinmallick/InsiderTrader.svg?style=for-the-badge
[contributors-url]: https://github.com/tuhinmallick/InsiderTrader/graphs/contributors
[forks-shield]: https://img.shields.io/github/forks/tuhinmallick/InsiderTrader.svg?style=for-the-badge
[forks-url]: https://github.com/tuhinmallick/InsiderTrader/network/members
[stars-shield]: https://img.shields.io/github/stars/tuhinmallick/InsiderTrader.svg?style=for-the-badge
[stars-url]: https://github.com/tuhinmallick/InsiderTrader/stargazers
[issues-shield]: https://img.shields.io/github/issues/tuhinmallick/InsiderTrader.svg?style=for-the-badge
[issues-url]: https://github.com/tuhinmallick/InsiderTrader/issues
[license-shield]: https://img.shields.io/github/license/tuhinmallick/InsiderTrader.svg?style=for-the-badge
[license-url]: https://github.com/tuhinmallick/InsiderTrader/blob/master/LICENSE.txt
[linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555
[linkedin-url]: https://linkedin.com/in/tuhinmallick

