import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::CloudFront::CachePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html
 * @external
 */
export interface CfnCachePolicyProps {
    /**
     * `AWS::CloudFront::CachePolicy.CachePolicyConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html#cfn-cloudfront-cachepolicy-cachepolicyconfig
     * @external
     */
    readonly cachePolicyConfig: CfnCachePolicy.CachePolicyConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CloudFront::CachePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html
 * @external
 * @cloudformationResource AWS::CloudFront::CachePolicy
 */
export declare class CfnCachePolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFront::CachePolicy";
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute LastModifiedTime
     */
    readonly attrLastModifiedTime: string;
    /**
     * `AWS::CloudFront::CachePolicy.CachePolicyConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html#cfn-cloudfront-cachepolicy-cachepolicyconfig
     * @external
     */
    cachePolicyConfig: CfnCachePolicy.CachePolicyConfigProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::CloudFront::CachePolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCachePolicyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudFront::CachePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html
 * @external
 * @cloudformationResource AWS::CloudFront::CachePolicy
 */
export declare namespace CfnCachePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html
     * @external
     */
    interface CachePolicyConfigProperty {
        /**
         * `CfnCachePolicy.CachePolicyConfigProperty.Comment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-comment
         * @external
         */
        readonly comment?: string;
        /**
         * `CfnCachePolicy.CachePolicyConfigProperty.DefaultTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-defaultttl
         * @external
         */
        readonly defaultTtl: number;
        /**
         * `CfnCachePolicy.CachePolicyConfigProperty.MaxTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-maxttl
         * @external
         */
        readonly maxTtl: number;
        /**
         * `CfnCachePolicy.CachePolicyConfigProperty.MinTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-minttl
         * @external
         */
        readonly minTtl: number;
        /**
         * `CfnCachePolicy.CachePolicyConfigProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnCachePolicy.CachePolicyConfigProperty.ParametersInCacheKeyAndForwardedToOrigin`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cachepolicyconfig.html#cfn-cloudfront-cachepolicy-cachepolicyconfig-parametersincachekeyandforwardedtoorigin
         * @external
         */
        readonly parametersInCacheKeyAndForwardedToOrigin: CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::CachePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html
 * @external
 * @cloudformationResource AWS::CloudFront::CachePolicy
 */
export declare namespace CfnCachePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cookiesconfig.html
     * @external
     */
    interface CookiesConfigProperty {
        /**
         * `CfnCachePolicy.CookiesConfigProperty.CookieBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cookiesconfig.html#cfn-cloudfront-cachepolicy-cookiesconfig-cookiebehavior
         * @external
         */
        readonly cookieBehavior: string;
        /**
         * `CfnCachePolicy.CookiesConfigProperty.Cookies`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-cookiesconfig.html#cfn-cloudfront-cachepolicy-cookiesconfig-cookies
         * @external
         */
        readonly cookies?: string[];
    }
}
/**
 * A CloudFormation `AWS::CloudFront::CachePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html
 * @external
 * @cloudformationResource AWS::CloudFront::CachePolicy
 */
export declare namespace CfnCachePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-headersconfig.html
     * @external
     */
    interface HeadersConfigProperty {
        /**
         * `CfnCachePolicy.HeadersConfigProperty.HeaderBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-headersconfig.html#cfn-cloudfront-cachepolicy-headersconfig-headerbehavior
         * @external
         */
        readonly headerBehavior: string;
        /**
         * `CfnCachePolicy.HeadersConfigProperty.Headers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-headersconfig.html#cfn-cloudfront-cachepolicy-headersconfig-headers
         * @external
         */
        readonly headers?: string[];
    }
}
/**
 * A CloudFormation `AWS::CloudFront::CachePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html
 * @external
 * @cloudformationResource AWS::CloudFront::CachePolicy
 */
export declare namespace CfnCachePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html
     * @external
     */
    interface ParametersInCacheKeyAndForwardedToOriginProperty {
        /**
         * `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.CookiesConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-cookiesconfig
         * @external
         */
        readonly cookiesConfig: CfnCachePolicy.CookiesConfigProperty | cdk.IResolvable;
        /**
         * `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.EnableAcceptEncodingBrotli`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-enableacceptencodingbrotli
         * @external
         */
        readonly enableAcceptEncodingBrotli?: boolean | cdk.IResolvable;
        /**
         * `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.EnableAcceptEncodingGzip`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-enableacceptencodinggzip
         * @external
         */
        readonly enableAcceptEncodingGzip: boolean | cdk.IResolvable;
        /**
         * `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.HeadersConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-headersconfig
         * @external
         */
        readonly headersConfig: CfnCachePolicy.HeadersConfigProperty | cdk.IResolvable;
        /**
         * `CfnCachePolicy.ParametersInCacheKeyAndForwardedToOriginProperty.QueryStringsConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin.html#cfn-cloudfront-cachepolicy-parametersincachekeyandforwardedtoorigin-querystringsconfig
         * @external
         */
        readonly queryStringsConfig: CfnCachePolicy.QueryStringsConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::CachePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html
 * @external
 * @cloudformationResource AWS::CloudFront::CachePolicy
 */
export declare namespace CfnCachePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-querystringsconfig.html
     * @external
     */
    interface QueryStringsConfigProperty {
        /**
         * `CfnCachePolicy.QueryStringsConfigProperty.QueryStringBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-querystringsconfig.html#cfn-cloudfront-cachepolicy-querystringsconfig-querystringbehavior
         * @external
         */
        readonly queryStringBehavior: string;
        /**
         * `CfnCachePolicy.QueryStringsConfigProperty.QueryStrings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cachepolicy-querystringsconfig.html#cfn-cloudfront-cachepolicy-querystringsconfig-querystrings
         * @external
         */
        readonly queryStrings?: string[];
    }
}
/**
 * Properties for defining a `AWS::CloudFront::CloudFrontOriginAccessIdentity`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cloudfrontoriginaccessidentity.html
 * @external
 */
export interface CfnCloudFrontOriginAccessIdentityProps {
    /**
     * `AWS::CloudFront::CloudFrontOriginAccessIdentity.CloudFrontOriginAccessIdentityConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cloudfrontoriginaccessidentity.html#cfn-cloudfront-cloudfrontoriginaccessidentity-cloudfrontoriginaccessidentityconfig
     * @external
     */
    readonly cloudFrontOriginAccessIdentityConfig: CfnCloudFrontOriginAccessIdentity.CloudFrontOriginAccessIdentityConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CloudFront::CloudFrontOriginAccessIdentity`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cloudfrontoriginaccessidentity.html
 * @external
 * @cloudformationResource AWS::CloudFront::CloudFrontOriginAccessIdentity
 */
export declare class CfnCloudFrontOriginAccessIdentity extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFront::CloudFrontOriginAccessIdentity";
    /**
     * @external
     * @cloudformationAttribute S3CanonicalUserId
     */
    readonly attrS3CanonicalUserId: string;
    /**
     * `AWS::CloudFront::CloudFrontOriginAccessIdentity.CloudFrontOriginAccessIdentityConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cloudfrontoriginaccessidentity.html#cfn-cloudfront-cloudfrontoriginaccessidentity-cloudfrontoriginaccessidentityconfig
     * @external
     */
    cloudFrontOriginAccessIdentityConfig: CfnCloudFrontOriginAccessIdentity.CloudFrontOriginAccessIdentityConfigProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::CloudFront::CloudFrontOriginAccessIdentity`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCloudFrontOriginAccessIdentityProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudFront::CloudFrontOriginAccessIdentity`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cloudfrontoriginaccessidentity.html
 * @external
 * @cloudformationResource AWS::CloudFront::CloudFrontOriginAccessIdentity
 */
export declare namespace CfnCloudFrontOriginAccessIdentity {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cloudfrontoriginaccessidentity-cloudfrontoriginaccessidentityconfig.html
     * @external
     */
    interface CloudFrontOriginAccessIdentityConfigProperty {
        /**
         * `CfnCloudFrontOriginAccessIdentity.CloudFrontOriginAccessIdentityConfigProperty.Comment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-cloudfrontoriginaccessidentity-cloudfrontoriginaccessidentityconfig.html#cfn-cloudfront-cloudfrontoriginaccessidentity-cloudfrontoriginaccessidentityconfig-comment
         * @external
         */
        readonly comment: string;
    }
}
/**
 * Properties for defining a `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 */
export interface CfnDistributionProps {
    /**
     * `AWS::CloudFront::Distribution.DistributionConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig
     * @external
     */
    readonly distributionConfig: CfnDistribution.DistributionConfigProperty | cdk.IResolvable;
    /**
     * `AWS::CloudFront::Distribution.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare class CfnDistribution extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFront::Distribution";
    /**
     * @external
     * @cloudformationAttribute DomainName
     */
    readonly attrDomainName: string;
    /**
     * `AWS::CloudFront::Distribution.DistributionConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig
     * @external
     */
    distributionConfig: CfnDistribution.DistributionConfigProperty | cdk.IResolvable;
    /**
     * `AWS::CloudFront::Distribution.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CloudFront::Distribution`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDistributionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html
     * @external
     */
    interface CacheBehaviorProperty {
        /**
         * `CfnDistribution.CacheBehaviorProperty.AllowedMethods`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-allowedmethods
         * @external
         */
        readonly allowedMethods?: string[];
        /**
         * `CfnDistribution.CacheBehaviorProperty.CachePolicyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-cachepolicyid
         * @external
         */
        readonly cachePolicyId?: string;
        /**
         * `CfnDistribution.CacheBehaviorProperty.CachedMethods`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-cachedmethods
         * @external
         */
        readonly cachedMethods?: string[];
        /**
         * `CfnDistribution.CacheBehaviorProperty.Compress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-compress
         * @external
         */
        readonly compress?: boolean | cdk.IResolvable;
        /**
         * `CfnDistribution.CacheBehaviorProperty.DefaultTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-defaultttl
         * @external
         */
        readonly defaultTtl?: number;
        /**
         * `CfnDistribution.CacheBehaviorProperty.FieldLevelEncryptionId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-fieldlevelencryptionid
         * @external
         */
        readonly fieldLevelEncryptionId?: string;
        /**
         * `CfnDistribution.CacheBehaviorProperty.ForwardedValues`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-forwardedvalues
         * @external
         */
        readonly forwardedValues?: CfnDistribution.ForwardedValuesProperty | cdk.IResolvable;
        /**
         * `CfnDistribution.CacheBehaviorProperty.LambdaFunctionAssociations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-lambdafunctionassociations
         * @external
         */
        readonly lambdaFunctionAssociations?: Array<CfnDistribution.LambdaFunctionAssociationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDistribution.CacheBehaviorProperty.MaxTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-maxttl
         * @external
         */
        readonly maxTtl?: number;
        /**
         * `CfnDistribution.CacheBehaviorProperty.MinTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-minttl
         * @external
         */
        readonly minTtl?: number;
        /**
         * `CfnDistribution.CacheBehaviorProperty.OriginRequestPolicyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-originrequestpolicyid
         * @external
         */
        readonly originRequestPolicyId?: string;
        /**
         * `CfnDistribution.CacheBehaviorProperty.PathPattern`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-pathpattern
         * @external
         */
        readonly pathPattern: string;
        /**
         * `CfnDistribution.CacheBehaviorProperty.RealtimeLogConfigArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-realtimelogconfigarn
         * @external
         */
        readonly realtimeLogConfigArn?: string;
        /**
         * `CfnDistribution.CacheBehaviorProperty.SmoothStreaming`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-smoothstreaming
         * @external
         */
        readonly smoothStreaming?: boolean | cdk.IResolvable;
        /**
         * `CfnDistribution.CacheBehaviorProperty.TargetOriginId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-targetoriginid
         * @external
         */
        readonly targetOriginId: string;
        /**
         * `CfnDistribution.CacheBehaviorProperty.TrustedSigners`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-trustedsigners
         * @external
         */
        readonly trustedSigners?: string[];
        /**
         * `CfnDistribution.CacheBehaviorProperty.ViewerProtocolPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-viewerprotocolpolicy
         * @external
         */
        readonly viewerProtocolPolicy: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cookies.html
     * @external
     */
    interface CookiesProperty {
        /**
         * `CfnDistribution.CookiesProperty.Forward`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cookies.html#cfn-cloudfront-distribution-cookies-forward
         * @external
         */
        readonly forward: string;
        /**
         * `CfnDistribution.CookiesProperty.WhitelistedNames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cookies.html#cfn-cloudfront-distribution-cookies-whitelistednames
         * @external
         */
        readonly whitelistedNames?: string[];
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html
     * @external
     */
    interface CustomErrorResponseProperty {
        /**
         * `CfnDistribution.CustomErrorResponseProperty.ErrorCachingMinTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-errorcachingminttl
         * @external
         */
        readonly errorCachingMinTtl?: number;
        /**
         * `CfnDistribution.CustomErrorResponseProperty.ErrorCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-errorcode
         * @external
         */
        readonly errorCode: number;
        /**
         * `CfnDistribution.CustomErrorResponseProperty.ResponseCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-responsecode
         * @external
         */
        readonly responseCode?: number;
        /**
         * `CfnDistribution.CustomErrorResponseProperty.ResponsePagePath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-responsepagepath
         * @external
         */
        readonly responsePagePath?: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html
     * @external
     */
    interface CustomOriginConfigProperty {
        /**
         * `CfnDistribution.CustomOriginConfigProperty.HTTPPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-httpport
         * @external
         */
        readonly httpPort?: number;
        /**
         * `CfnDistribution.CustomOriginConfigProperty.HTTPSPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-httpsport
         * @external
         */
        readonly httpsPort?: number;
        /**
         * `CfnDistribution.CustomOriginConfigProperty.OriginKeepaliveTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originkeepalivetimeout
         * @external
         */
        readonly originKeepaliveTimeout?: number;
        /**
         * `CfnDistribution.CustomOriginConfigProperty.OriginProtocolPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originprotocolpolicy
         * @external
         */
        readonly originProtocolPolicy: string;
        /**
         * `CfnDistribution.CustomOriginConfigProperty.OriginReadTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originreadtimeout
         * @external
         */
        readonly originReadTimeout?: number;
        /**
         * `CfnDistribution.CustomOriginConfigProperty.OriginSSLProtocols`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originsslprotocols
         * @external
         */
        readonly originSslProtocols?: string[];
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html
     * @external
     */
    interface DefaultCacheBehaviorProperty {
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.AllowedMethods`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-allowedmethods
         * @external
         */
        readonly allowedMethods?: string[];
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.CachePolicyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-cachepolicyid
         * @external
         */
        readonly cachePolicyId?: string;
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.CachedMethods`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-cachedmethods
         * @external
         */
        readonly cachedMethods?: string[];
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.Compress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-compress
         * @external
         */
        readonly compress?: boolean | cdk.IResolvable;
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.DefaultTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-defaultttl
         * @external
         */
        readonly defaultTtl?: number;
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.FieldLevelEncryptionId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-fieldlevelencryptionid
         * @external
         */
        readonly fieldLevelEncryptionId?: string;
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.ForwardedValues`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-forwardedvalues
         * @external
         */
        readonly forwardedValues?: CfnDistribution.ForwardedValuesProperty | cdk.IResolvable;
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.LambdaFunctionAssociations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-lambdafunctionassociations
         * @external
         */
        readonly lambdaFunctionAssociations?: Array<CfnDistribution.LambdaFunctionAssociationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.MaxTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-maxttl
         * @external
         */
        readonly maxTtl?: number;
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.MinTTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-minttl
         * @external
         */
        readonly minTtl?: number;
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.OriginRequestPolicyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-originrequestpolicyid
         * @external
         */
        readonly originRequestPolicyId?: string;
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.RealtimeLogConfigArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-realtimelogconfigarn
         * @external
         */
        readonly realtimeLogConfigArn?: string;
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.SmoothStreaming`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-smoothstreaming
         * @external
         */
        readonly smoothStreaming?: boolean | cdk.IResolvable;
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.TargetOriginId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-targetoriginid
         * @external
         */
        readonly targetOriginId: string;
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.TrustedSigners`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-trustedsigners
         * @external
         */
        readonly trustedSigners?: string[];
        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.ViewerProtocolPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-viewerprotocolpolicy
         * @external
         */
        readonly viewerProtocolPolicy: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html
     * @external
     */
    interface DistributionConfigProperty {
        /**
         * `CfnDistribution.DistributionConfigProperty.Aliases`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-aliases
         * @external
         */
        readonly aliases?: string[];
        /**
         * `CfnDistribution.DistributionConfigProperty.CacheBehaviors`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-cachebehaviors
         * @external
         */
        readonly cacheBehaviors?: Array<CfnDistribution.CacheBehaviorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDistribution.DistributionConfigProperty.Comment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-comment
         * @external
         */
        readonly comment?: string;
        /**
         * `CfnDistribution.DistributionConfigProperty.CustomErrorResponses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-customerrorresponses
         * @external
         */
        readonly customErrorResponses?: Array<CfnDistribution.CustomErrorResponseProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDistribution.DistributionConfigProperty.DefaultCacheBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-defaultcachebehavior
         * @external
         */
        readonly defaultCacheBehavior?: CfnDistribution.DefaultCacheBehaviorProperty | cdk.IResolvable;
        /**
         * `CfnDistribution.DistributionConfigProperty.DefaultRootObject`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-defaultrootobject
         * @external
         */
        readonly defaultRootObject?: string;
        /**
         * `CfnDistribution.DistributionConfigProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnDistribution.DistributionConfigProperty.HttpVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-httpversion
         * @external
         */
        readonly httpVersion?: string;
        /**
         * `CfnDistribution.DistributionConfigProperty.IPV6Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-ipv6enabled
         * @external
         */
        readonly ipv6Enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDistribution.DistributionConfigProperty.Logging`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-logging
         * @external
         */
        readonly logging?: CfnDistribution.LoggingProperty | cdk.IResolvable;
        /**
         * `CfnDistribution.DistributionConfigProperty.OriginGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-origingroups
         * @external
         */
        readonly originGroups?: CfnDistribution.OriginGroupsProperty | cdk.IResolvable;
        /**
         * `CfnDistribution.DistributionConfigProperty.Origins`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-origins
         * @external
         */
        readonly origins?: Array<CfnDistribution.OriginProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDistribution.DistributionConfigProperty.PriceClass`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-priceclass
         * @external
         */
        readonly priceClass?: string;
        /**
         * `CfnDistribution.DistributionConfigProperty.Restrictions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions
         * @external
         */
        readonly restrictions?: CfnDistribution.RestrictionsProperty | cdk.IResolvable;
        /**
         * `CfnDistribution.DistributionConfigProperty.ViewerCertificate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-viewercertificate
         * @external
         */
        readonly viewerCertificate?: CfnDistribution.ViewerCertificateProperty | cdk.IResolvable;
        /**
         * `CfnDistribution.DistributionConfigProperty.WebACLId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-webaclid
         * @external
         */
        readonly webAclId?: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html
     * @external
     */
    interface ForwardedValuesProperty {
        /**
         * `CfnDistribution.ForwardedValuesProperty.Cookies`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-cookies
         * @external
         */
        readonly cookies?: CfnDistribution.CookiesProperty | cdk.IResolvable;
        /**
         * `CfnDistribution.ForwardedValuesProperty.Headers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-headers
         * @external
         */
        readonly headers?: string[];
        /**
         * `CfnDistribution.ForwardedValuesProperty.QueryString`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-querystring
         * @external
         */
        readonly queryString: boolean | cdk.IResolvable;
        /**
         * `CfnDistribution.ForwardedValuesProperty.QueryStringCacheKeys`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-querystringcachekeys
         * @external
         */
        readonly queryStringCacheKeys?: string[];
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-georestriction.html
     * @external
     */
    interface GeoRestrictionProperty {
        /**
         * `CfnDistribution.GeoRestrictionProperty.Locations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-georestriction.html#cfn-cloudfront-distribution-georestriction-locations
         * @external
         */
        readonly locations?: string[];
        /**
         * `CfnDistribution.GeoRestrictionProperty.RestrictionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-georestriction.html#cfn-cloudfront-distribution-georestriction-restrictiontype
         * @external
         */
        readonly restrictionType: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html
     * @external
     */
    interface LambdaFunctionAssociationProperty {
        /**
         * `CfnDistribution.LambdaFunctionAssociationProperty.EventType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html#cfn-cloudfront-distribution-lambdafunctionassociation-eventtype
         * @external
         */
        readonly eventType?: string;
        /**
         * `CfnDistribution.LambdaFunctionAssociationProperty.IncludeBody`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html#cfn-cloudfront-distribution-lambdafunctionassociation-includebody
         * @external
         */
        readonly includeBody?: boolean | cdk.IResolvable;
        /**
         * `CfnDistribution.LambdaFunctionAssociationProperty.LambdaFunctionARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html#cfn-cloudfront-distribution-lambdafunctionassociation-lambdafunctionarn
         * @external
         */
        readonly lambdaFunctionArn?: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html
     * @external
     */
    interface LoggingProperty {
        /**
         * `CfnDistribution.LoggingProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html#cfn-cloudfront-distribution-logging-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnDistribution.LoggingProperty.IncludeCookies`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html#cfn-cloudfront-distribution-logging-includecookies
         * @external
         */
        readonly includeCookies?: boolean | cdk.IResolvable;
        /**
         * `CfnDistribution.LoggingProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html#cfn-cloudfront-distribution-logging-prefix
         * @external
         */
        readonly prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html
     * @external
     */
    interface OriginProperty {
        /**
         * `CfnDistribution.OriginProperty.ConnectionAttempts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-connectionattempts
         * @external
         */
        readonly connectionAttempts?: number;
        /**
         * `CfnDistribution.OriginProperty.ConnectionTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-connectiontimeout
         * @external
         */
        readonly connectionTimeout?: number;
        /**
         * `CfnDistribution.OriginProperty.CustomOriginConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-customoriginconfig
         * @external
         */
        readonly customOriginConfig?: CfnDistribution.CustomOriginConfigProperty | cdk.IResolvable;
        /**
         * `CfnDistribution.OriginProperty.DomainName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-domainname
         * @external
         */
        readonly domainName: string;
        /**
         * `CfnDistribution.OriginProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnDistribution.OriginProperty.OriginCustomHeaders`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-origincustomheaders
         * @external
         */
        readonly originCustomHeaders?: Array<CfnDistribution.OriginCustomHeaderProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDistribution.OriginProperty.OriginPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-originpath
         * @external
         */
        readonly originPath?: string;
        /**
         * `CfnDistribution.OriginProperty.S3OriginConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-s3originconfig
         * @external
         */
        readonly s3OriginConfig?: CfnDistribution.S3OriginConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origincustomheader.html
     * @external
     */
    interface OriginCustomHeaderProperty {
        /**
         * `CfnDistribution.OriginCustomHeaderProperty.HeaderName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origincustomheader.html#cfn-cloudfront-distribution-origincustomheader-headername
         * @external
         */
        readonly headerName: string;
        /**
         * `CfnDistribution.OriginCustomHeaderProperty.HeaderValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origincustomheader.html#cfn-cloudfront-distribution-origincustomheader-headervalue
         * @external
         */
        readonly headerValue: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html
     * @external
     */
    interface OriginGroupProperty {
        /**
         * `CfnDistribution.OriginGroupProperty.FailoverCriteria`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html#cfn-cloudfront-distribution-origingroup-failovercriteria
         * @external
         */
        readonly failoverCriteria: CfnDistribution.OriginGroupFailoverCriteriaProperty | cdk.IResolvable;
        /**
         * `CfnDistribution.OriginGroupProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html#cfn-cloudfront-distribution-origingroup-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnDistribution.OriginGroupProperty.Members`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html#cfn-cloudfront-distribution-origingroup-members
         * @external
         */
        readonly members: CfnDistribution.OriginGroupMembersProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupfailovercriteria.html
     * @external
     */
    interface OriginGroupFailoverCriteriaProperty {
        /**
         * `CfnDistribution.OriginGroupFailoverCriteriaProperty.StatusCodes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupfailovercriteria.html#cfn-cloudfront-distribution-origingroupfailovercriteria-statuscodes
         * @external
         */
        readonly statusCodes: CfnDistribution.StatusCodesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmember.html
     * @external
     */
    interface OriginGroupMemberProperty {
        /**
         * `CfnDistribution.OriginGroupMemberProperty.OriginId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmember.html#cfn-cloudfront-distribution-origingroupmember-originid
         * @external
         */
        readonly originId: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmembers.html
     * @external
     */
    interface OriginGroupMembersProperty {
        /**
         * `CfnDistribution.OriginGroupMembersProperty.Items`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmembers.html#cfn-cloudfront-distribution-origingroupmembers-items
         * @external
         */
        readonly items: Array<CfnDistribution.OriginGroupMemberProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDistribution.OriginGroupMembersProperty.Quantity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmembers.html#cfn-cloudfront-distribution-origingroupmembers-quantity
         * @external
         */
        readonly quantity: number;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroups.html
     * @external
     */
    interface OriginGroupsProperty {
        /**
         * `CfnDistribution.OriginGroupsProperty.Items`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroups.html#cfn-cloudfront-distribution-origingroups-items
         * @external
         */
        readonly items?: Array<CfnDistribution.OriginGroupProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDistribution.OriginGroupsProperty.Quantity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroups.html#cfn-cloudfront-distribution-origingroups-quantity
         * @external
         */
        readonly quantity: number;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-restrictions.html
     * @external
     */
    interface RestrictionsProperty {
        /**
         * `CfnDistribution.RestrictionsProperty.GeoRestriction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-restrictions.html#cfn-cloudfront-distribution-restrictions-georestriction
         * @external
         */
        readonly geoRestriction: CfnDistribution.GeoRestrictionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-s3originconfig.html
     * @external
     */
    interface S3OriginConfigProperty {
        /**
         * `CfnDistribution.S3OriginConfigProperty.OriginAccessIdentity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-s3originconfig.html#cfn-cloudfront-distribution-s3originconfig-originaccessidentity
         * @external
         */
        readonly originAccessIdentity?: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-statuscodes.html
     * @external
     */
    interface StatusCodesProperty {
        /**
         * `CfnDistribution.StatusCodesProperty.Items`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-statuscodes.html#cfn-cloudfront-distribution-statuscodes-items
         * @external
         */
        readonly items: number[] | cdk.IResolvable;
        /**
         * `CfnDistribution.StatusCodesProperty.Quantity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-statuscodes.html#cfn-cloudfront-distribution-statuscodes-quantity
         * @external
         */
        readonly quantity: number;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::Distribution
 */
export declare namespace CfnDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html
     * @external
     */
    interface ViewerCertificateProperty {
        /**
         * `CfnDistribution.ViewerCertificateProperty.AcmCertificateArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-acmcertificatearn
         * @external
         */
        readonly acmCertificateArn?: string;
        /**
         * `CfnDistribution.ViewerCertificateProperty.CloudFrontDefaultCertificate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-cloudfrontdefaultcertificate
         * @external
         */
        readonly cloudFrontDefaultCertificate?: boolean | cdk.IResolvable;
        /**
         * `CfnDistribution.ViewerCertificateProperty.IamCertificateId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-iamcertificateid
         * @external
         */
        readonly iamCertificateId?: string;
        /**
         * `CfnDistribution.ViewerCertificateProperty.MinimumProtocolVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-minimumprotocolversion
         * @external
         */
        readonly minimumProtocolVersion?: string;
        /**
         * `CfnDistribution.ViewerCertificateProperty.SslSupportMethod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-sslsupportmethod
         * @external
         */
        readonly sslSupportMethod?: string;
    }
}
/**
 * Properties for defining a `AWS::CloudFront::OriginRequestPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html
 * @external
 */
export interface CfnOriginRequestPolicyProps {
    /**
     * `AWS::CloudFront::OriginRequestPolicy.OriginRequestPolicyConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig
     * @external
     */
    readonly originRequestPolicyConfig: CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CloudFront::OriginRequestPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html
 * @external
 * @cloudformationResource AWS::CloudFront::OriginRequestPolicy
 */
export declare class CfnOriginRequestPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFront::OriginRequestPolicy";
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute LastModifiedTime
     */
    readonly attrLastModifiedTime: string;
    /**
     * `AWS::CloudFront::OriginRequestPolicy.OriginRequestPolicyConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig
     * @external
     */
    originRequestPolicyConfig: CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::CloudFront::OriginRequestPolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnOriginRequestPolicyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudFront::OriginRequestPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html
 * @external
 * @cloudformationResource AWS::CloudFront::OriginRequestPolicy
 */
export declare namespace CfnOriginRequestPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-cookiesconfig.html
     * @external
     */
    interface CookiesConfigProperty {
        /**
         * `CfnOriginRequestPolicy.CookiesConfigProperty.CookieBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-cookiesconfig.html#cfn-cloudfront-originrequestpolicy-cookiesconfig-cookiebehavior
         * @external
         */
        readonly cookieBehavior: string;
        /**
         * `CfnOriginRequestPolicy.CookiesConfigProperty.Cookies`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-cookiesconfig.html#cfn-cloudfront-originrequestpolicy-cookiesconfig-cookies
         * @external
         */
        readonly cookies?: string[];
    }
}
/**
 * A CloudFormation `AWS::CloudFront::OriginRequestPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html
 * @external
 * @cloudformationResource AWS::CloudFront::OriginRequestPolicy
 */
export declare namespace CfnOriginRequestPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-headersconfig.html
     * @external
     */
    interface HeadersConfigProperty {
        /**
         * `CfnOriginRequestPolicy.HeadersConfigProperty.HeaderBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-headersconfig.html#cfn-cloudfront-originrequestpolicy-headersconfig-headerbehavior
         * @external
         */
        readonly headerBehavior: string;
        /**
         * `CfnOriginRequestPolicy.HeadersConfigProperty.Headers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-headersconfig.html#cfn-cloudfront-originrequestpolicy-headersconfig-headers
         * @external
         */
        readonly headers?: string[];
    }
}
/**
 * A CloudFormation `AWS::CloudFront::OriginRequestPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html
 * @external
 * @cloudformationResource AWS::CloudFront::OriginRequestPolicy
 */
export declare namespace CfnOriginRequestPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html
     * @external
     */
    interface OriginRequestPolicyConfigProperty {
        /**
         * `CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty.Comment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-comment
         * @external
         */
        readonly comment?: string;
        /**
         * `CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty.CookiesConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-cookiesconfig
         * @external
         */
        readonly cookiesConfig: CfnOriginRequestPolicy.CookiesConfigProperty | cdk.IResolvable;
        /**
         * `CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty.HeadersConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-headersconfig
         * @external
         */
        readonly headersConfig: CfnOriginRequestPolicy.HeadersConfigProperty | cdk.IResolvable;
        /**
         * `CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty.QueryStringsConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-originrequestpolicyconfig.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig-querystringsconfig
         * @external
         */
        readonly queryStringsConfig: CfnOriginRequestPolicy.QueryStringsConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::OriginRequestPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html
 * @external
 * @cloudformationResource AWS::CloudFront::OriginRequestPolicy
 */
export declare namespace CfnOriginRequestPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-querystringsconfig.html
     * @external
     */
    interface QueryStringsConfigProperty {
        /**
         * `CfnOriginRequestPolicy.QueryStringsConfigProperty.QueryStringBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-querystringsconfig.html#cfn-cloudfront-originrequestpolicy-querystringsconfig-querystringbehavior
         * @external
         */
        readonly queryStringBehavior: string;
        /**
         * `CfnOriginRequestPolicy.QueryStringsConfigProperty.QueryStrings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originrequestpolicy-querystringsconfig.html#cfn-cloudfront-originrequestpolicy-querystringsconfig-querystrings
         * @external
         */
        readonly queryStrings?: string[];
    }
}
/**
 * Properties for defining a `AWS::CloudFront::RealtimeLogConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-realtimelogconfig.html
 * @external
 */
export interface CfnRealtimeLogConfigProps {
    /**
     * `AWS::CloudFront::RealtimeLogConfig.EndPoints`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-realtimelogconfig.html#cfn-cloudfront-realtimelogconfig-endpoints
     * @external
     */
    readonly endPoints: Array<CfnRealtimeLogConfig.EndPointProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudFront::RealtimeLogConfig.Fields`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-realtimelogconfig.html#cfn-cloudfront-realtimelogconfig-fields
     * @external
     */
    readonly fields: string[];
    /**
     * `AWS::CloudFront::RealtimeLogConfig.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-realtimelogconfig.html#cfn-cloudfront-realtimelogconfig-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::CloudFront::RealtimeLogConfig.SamplingRate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-realtimelogconfig.html#cfn-cloudfront-realtimelogconfig-samplingrate
     * @external
     */
    readonly samplingRate: number;
}
/**
 * A CloudFormation `AWS::CloudFront::RealtimeLogConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-realtimelogconfig.html
 * @external
 * @cloudformationResource AWS::CloudFront::RealtimeLogConfig
 */
export declare class CfnRealtimeLogConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFront::RealtimeLogConfig";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::CloudFront::RealtimeLogConfig.EndPoints`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-realtimelogconfig.html#cfn-cloudfront-realtimelogconfig-endpoints
     * @external
     */
    endPoints: Array<CfnRealtimeLogConfig.EndPointProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudFront::RealtimeLogConfig.Fields`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-realtimelogconfig.html#cfn-cloudfront-realtimelogconfig-fields
     * @external
     */
    fields: string[];
    /**
     * `AWS::CloudFront::RealtimeLogConfig.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-realtimelogconfig.html#cfn-cloudfront-realtimelogconfig-name
     * @external
     */
    name: string;
    /**
     * `AWS::CloudFront::RealtimeLogConfig.SamplingRate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-realtimelogconfig.html#cfn-cloudfront-realtimelogconfig-samplingrate
     * @external
     */
    samplingRate: number;
    /**
     * Create a new `AWS::CloudFront::RealtimeLogConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRealtimeLogConfigProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudFront::RealtimeLogConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-realtimelogconfig.html
 * @external
 * @cloudformationResource AWS::CloudFront::RealtimeLogConfig
 */
export declare namespace CfnRealtimeLogConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-realtimelogconfig-endpoint.html
     * @external
     */
    interface EndPointProperty {
        /**
         * `CfnRealtimeLogConfig.EndPointProperty.KinesisStreamConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-realtimelogconfig-endpoint.html#cfn-cloudfront-realtimelogconfig-endpoint-kinesisstreamconfig
         * @external
         */
        readonly kinesisStreamConfig: CfnRealtimeLogConfig.KinesisStreamConfigProperty | cdk.IResolvable;
        /**
         * `CfnRealtimeLogConfig.EndPointProperty.StreamType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-realtimelogconfig-endpoint.html#cfn-cloudfront-realtimelogconfig-endpoint-streamtype
         * @external
         */
        readonly streamType: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::RealtimeLogConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-realtimelogconfig.html
 * @external
 * @cloudformationResource AWS::CloudFront::RealtimeLogConfig
 */
export declare namespace CfnRealtimeLogConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-realtimelogconfig-kinesisstreamconfig.html
     * @external
     */
    interface KinesisStreamConfigProperty {
        /**
         * `CfnRealtimeLogConfig.KinesisStreamConfigProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-realtimelogconfig-kinesisstreamconfig.html#cfn-cloudfront-realtimelogconfig-kinesisstreamconfig-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnRealtimeLogConfig.KinesisStreamConfigProperty.StreamArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-realtimelogconfig-kinesisstreamconfig.html#cfn-cloudfront-realtimelogconfig-kinesisstreamconfig-streamarn
         * @external
         */
        readonly streamArn: string;
    }
}
/**
 * Properties for defining a `AWS::CloudFront::StreamingDistribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html
 * @external
 */
export interface CfnStreamingDistributionProps {
    /**
     * `AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig
     * @external
     */
    readonly streamingDistributionConfig: CfnStreamingDistribution.StreamingDistributionConfigProperty | cdk.IResolvable;
    /**
     * `AWS::CloudFront::StreamingDistribution.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html#cfn-cloudfront-streamingdistribution-tags
     * @external
     */
    readonly tags: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CloudFront::StreamingDistribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::StreamingDistribution
 */
export declare class CfnStreamingDistribution extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFront::StreamingDistribution";
    /**
     * @external
     * @cloudformationAttribute DomainName
     */
    readonly attrDomainName: string;
    /**
     * `AWS::CloudFront::StreamingDistribution.StreamingDistributionConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig
     * @external
     */
    streamingDistributionConfig: CfnStreamingDistribution.StreamingDistributionConfigProperty | cdk.IResolvable;
    /**
     * `AWS::CloudFront::StreamingDistribution.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html#cfn-cloudfront-streamingdistribution-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CloudFront::StreamingDistribution`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStreamingDistributionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudFront::StreamingDistribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::StreamingDistribution
 */
export declare namespace CfnStreamingDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-logging.html
     * @external
     */
    interface LoggingProperty {
        /**
         * `CfnStreamingDistribution.LoggingProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-logging.html#cfn-cloudfront-streamingdistribution-logging-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnStreamingDistribution.LoggingProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-logging.html#cfn-cloudfront-streamingdistribution-logging-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnStreamingDistribution.LoggingProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-logging.html#cfn-cloudfront-streamingdistribution-logging-prefix
         * @external
         */
        readonly prefix: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::StreamingDistribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::StreamingDistribution
 */
export declare namespace CfnStreamingDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-s3origin.html
     * @external
     */
    interface S3OriginProperty {
        /**
         * `CfnStreamingDistribution.S3OriginProperty.DomainName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-s3origin.html#cfn-cloudfront-streamingdistribution-s3origin-domainname
         * @external
         */
        readonly domainName: string;
        /**
         * `CfnStreamingDistribution.S3OriginProperty.OriginAccessIdentity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-s3origin.html#cfn-cloudfront-streamingdistribution-s3origin-originaccessidentity
         * @external
         */
        readonly originAccessIdentity: string;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::StreamingDistribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::StreamingDistribution
 */
export declare namespace CfnStreamingDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html
     * @external
     */
    interface StreamingDistributionConfigProperty {
        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.Aliases`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-aliases
         * @external
         */
        readonly aliases?: string[];
        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.Comment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-comment
         * @external
         */
        readonly comment: string;
        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.Logging`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-logging
         * @external
         */
        readonly logging?: CfnStreamingDistribution.LoggingProperty | cdk.IResolvable;
        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.PriceClass`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-priceclass
         * @external
         */
        readonly priceClass?: string;
        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.S3Origin`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-s3origin
         * @external
         */
        readonly s3Origin: CfnStreamingDistribution.S3OriginProperty | cdk.IResolvable;
        /**
         * `CfnStreamingDistribution.StreamingDistributionConfigProperty.TrustedSigners`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-streamingdistributionconfig.html#cfn-cloudfront-streamingdistribution-streamingdistributionconfig-trustedsigners
         * @external
         */
        readonly trustedSigners: CfnStreamingDistribution.TrustedSignersProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CloudFront::StreamingDistribution`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-streamingdistribution.html
 * @external
 * @cloudformationResource AWS::CloudFront::StreamingDistribution
 */
export declare namespace CfnStreamingDistribution {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-trustedsigners.html
     * @external
     */
    interface TrustedSignersProperty {
        /**
         * `CfnStreamingDistribution.TrustedSignersProperty.AwsAccountNumbers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-trustedsigners.html#cfn-cloudfront-streamingdistribution-trustedsigners-awsaccountnumbers
         * @external
         */
        readonly awsAccountNumbers?: string[];
        /**
         * `CfnStreamingDistribution.TrustedSignersProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-streamingdistribution-trustedsigners.html#cfn-cloudfront-streamingdistribution-trustedsigners-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
