/**
 * Fields of CloudWatch Events that change references
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codebuild_event_type
 */
export declare class ReferenceEvent {
    /**
     * The type of reference event
     *
     * 'referenceCreated', 'referenceUpdated' or 'referenceDeleted'
     */
    static readonly eventType: string;
    /**
     * Name of the CodeCommit repository
     */
    static readonly repositoryName: string;
    /**
     * Id of the CodeCommit repository
     */
    static readonly repositoryId: string;
    /**
     * Type of reference changed
     *
     * 'branch' or 'tag'
     */
    static readonly referenceType: string;
    /**
     * Name of reference changed (branch or tag name)
     */
    static readonly referenceName: string;
    /**
     * Full reference name
     *
     * For example, 'refs/tags/myTag'
     */
    static readonly referenceFullName: string;
    /**
     * Commit id this reference now points to
     */
    static readonly commitId: string;
    private constructor();
}
