/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0014"}, d2={"Lutils/RuntimeEnvInfo;", "", "()V", "AltErgoExecutable", "", "VampireExecutable", "YicesExecutable", "isAltErgoAvailable", "", "()Z", "isTimeoutCommandAvailable", "isVampireAvailable", "isYicesAvailable", "getTimeoutCommand", "", "timeoutSeconds", "", "(Ljava/lang/Integer;)Ljava/util/List;", "isExecutableInPath", "cmd", "GeneralUtils"})
public final class RuntimeEnvInfo {
    @NotNull
    public static final String YicesExecutable = "yices-smt2";
    private static final boolean isYicesAvailable;
    @NotNull
    public static final String VampireExecutable = "vprover";
    private static final boolean isVampireAvailable;
    @NotNull
    public static final String AltErgoExecutable = "alt-ergo";
    private static final boolean isAltErgoAvailable;
    private static final boolean isTimeoutCommandAvailable;
    public static final RuntimeEnvInfo INSTANCE;

    public final boolean isExecutableInPath(@NotNull String cmd) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(cmd, "cmd");
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor(2L, TimeUnit.SECONDS);
            bl = proc.exitValue() == 0;
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    public final boolean isYicesAvailable() {
        return isYicesAvailable;
    }

    public final boolean isVampireAvailable() {
        return isVampireAvailable;
    }

    public final boolean isAltErgoAvailable() {
        return isAltErgoAvailable;
    }

    public final boolean isTimeoutCommandAvailable() {
        return isTimeoutCommandAvailable;
    }

    @NotNull
    public final List<String> getTimeoutCommand(@Nullable Integer timeoutSeconds) {
        List<String> list2;
        if (isTimeoutCommandAvailable) {
            String[] stringArray = new String[4];
            stringArray[0] = "timeout";
            stringArray[1] = "-k";
            stringArray[2] = "3s";
            Integer n = timeoutSeconds;
            stringArray[3] = String.valueOf((n != null ? n : 600000) + 3);
            list2 = CollectionsKt.listOf(stringArray);
        } else {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private RuntimeEnvInfo() {
    }

    static {
        RuntimeEnvInfo runtimeEnvInfo;
        INSTANCE = runtimeEnvInfo = new RuntimeEnvInfo();
        isYicesAvailable = runtimeEnvInfo.isExecutableInPath("yices-smt2 --version");
        isVampireAvailable = runtimeEnvInfo.isExecutableInPath("vprover --version");
        isAltErgoAvailable = runtimeEnvInfo.isExecutableInPath("alt-ergo --version");
        isTimeoutCommandAvailable = runtimeEnvInfo.isExecutableInPath("timeout --version");
    }
}

