/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import algorithms.UnionFind;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLFunctionType;
import spec.cvlast.CVLInbuiltSimpleTypes;
import spec.cvlast.CVLInbuiltStructTypes;
import spec.cvlast.CVLSimpleType;
import spec.cvlast.CVLType;
import spec.cvlast.CVLTypeConversions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJ\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lspec/cvlast/CVLTypeCheckerSettings;", "", "()V", "allowedImplicitTwoWayTypeConversions", "", "Lkotlin/Pair;", "Lspec/cvlast/CVLSimpleType$Inbuilt;", "allowedImplicitTwoWayTypeConversionsClosure", "Lalgorithms/UnionFind;", "Lspec/cvlast/CVLType;", "isImplicitConversionAllowed", "", "t1", "t2", "isImplicitOneWayConversionAllowed", "Shared"})
public final class CVLTypeCheckerSettings {
    private static final Set<Pair<CVLSimpleType.Inbuilt, CVLSimpleType.Inbuilt>> allowedImplicitTwoWayTypeConversions;
    private static final UnionFind<CVLType> allowedImplicitTwoWayTypeConversionsClosure;
    public static final CVLTypeCheckerSettings INSTANCE;

    private final boolean isImplicitOneWayConversionAllowed(CVLType t1, CVLType t2) {
        CVLType cVLType = t1;
        if (!(cVLType instanceof CVLInbuiltSimpleTypes.CVLInbuiltSimpleTypesConvertible)) {
            cVLType = null;
        }
        CVLInbuiltSimpleTypes.CVLInbuiltSimpleTypesConvertible cVLInbuiltSimpleTypesConvertible = (CVLInbuiltSimpleTypes.CVLInbuiltSimpleTypesConvertible)((Object)cVLType);
        CVLInbuiltSimpleTypes t1AsInbuilt = cVLInbuiltSimpleTypesConvertible != null ? cVLInbuiltSimpleTypesConvertible.toCVLInbuiltSimpleTypes() : null;
        CVLType cVLType2 = t2;
        if (!(cVLType2 instanceof CVLInbuiltSimpleTypes.CVLInbuiltSimpleTypesConvertible)) {
            cVLType2 = null;
        }
        CVLInbuiltSimpleTypes.CVLInbuiltSimpleTypesConvertible cVLInbuiltSimpleTypesConvertible2 = (CVLInbuiltSimpleTypes.CVLInbuiltSimpleTypesConvertible)((Object)cVLType2);
        CVLInbuiltSimpleTypes t2AsInbuilt = cVLInbuiltSimpleTypesConvertible2 != null ? cVLInbuiltSimpleTypesConvertible2.toCVLInbuiltSimpleTypes() : null;
        CVLInbuiltStructTypes t1AsInbuiltStruct = CVLInbuiltStructTypes.Companion.valueFromCvlType(t1);
        CVLInbuiltStructTypes t2AsInbuiltStruct = CVLInbuiltStructTypes.Companion.valueFromCvlType(t2);
        if (t1 instanceof CVLFunctionType && t2AsInbuiltStruct == CVLInbuiltStructTypes.methodType) {
            return false;
        }
        if (Intrinsics.areEqual(t1AsInbuilt, CVLInbuiltSimpleTypes.numberLiteral.INSTANCE) && t2AsInbuilt != null && CVLTypeConversions.INSTANCE.isConvertibleToArithmeticType(t2AsInbuilt.getCvlType())) {
            return true;
        }
        if (Intrinsics.areEqual(t1AsInbuilt, CVLInbuiltSimpleTypes.numberLiteral.INSTANCE) && Intrinsics.areEqual(t2AsInbuilt, CVLInbuiltSimpleTypes.address.INSTANCE)) {
            return true;
        }
        CVLInbuiltSimpleTypes cVLInbuiltSimpleTypes = t1AsInbuilt;
        if ((cVLInbuiltSimpleTypes != null ? cVLInbuiltSimpleTypes.getUintSize() : null) != null) {
            CVLInbuiltSimpleTypes cVLInbuiltSimpleTypes2 = t2AsInbuilt;
            if ((cVLInbuiltSimpleTypes2 != null ? cVLInbuiltSimpleTypes2.getUintSize() : null) != null && Intrinsics.compare(t1AsInbuilt.getUintSize(), t2AsInbuilt.getUintSize()) <= 0) {
                return true;
            }
        }
        CVLInbuiltSimpleTypes cVLInbuiltSimpleTypes3 = t1AsInbuilt;
        if ((cVLInbuiltSimpleTypes3 != null ? cVLInbuiltSimpleTypes3.getUintSize() : null) != null && t1AsInbuilt.getUintSize() <= 160 && Intrinsics.areEqual(t2AsInbuilt, CVLInbuiltSimpleTypes.address.INSTANCE)) {
            return true;
        }
        CVLInbuiltSimpleTypes cVLInbuiltSimpleTypes4 = t1AsInbuilt;
        return ((cVLInbuiltSimpleTypes4 != null ? cVLInbuiltSimpleTypes4.getUintSize() : null) != null || Intrinsics.areEqual(t1AsInbuilt, CVLInbuiltSimpleTypes.int.INSTANCE) || Intrinsics.areEqual(t1AsInbuilt, CVLInbuiltSimpleTypes.Companion.int(256)) || Intrinsics.areEqual(t1AsInbuilt, CVLInbuiltSimpleTypes.numberLiteral.INSTANCE)) && Intrinsics.areEqual(t2AsInbuilt, CVLInbuiltSimpleTypes.mathint.INSTANCE);
    }

    public final boolean isImplicitConversionAllowed(@NotNull CVLType t1, @NotNull CVLType t2) {
        Intrinsics.checkParameterIsNotNull(t1, "t1");
        Intrinsics.checkParameterIsNotNull(t2, "t2");
        return this.isImplicitOneWayConversionAllowed(t1, t2) || allowedImplicitTwoWayTypeConversionsClosure.areEqual(t1, t2);
    }

    private CVLTypeCheckerSettings() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        CVLTypeCheckerSettings cVLTypeCheckerSettings;
        INSTANCE = cVLTypeCheckerSettings = new CVLTypeCheckerSettings();
        allowedImplicitTwoWayTypeConversions = SetsKt.setOf(new Pair<CVLSimpleType.Inbuilt, CVLSimpleType.Inbuilt>(CVLInbuiltSimpleTypes.uint.INSTANCE.getCvlType(), CVLInbuiltSimpleTypes.Companion.uint(256).getCvlType()), new Pair<CVLSimpleType.Inbuilt, CVLSimpleType.Inbuilt>(CVLInbuiltSimpleTypes.int.INSTANCE.getCvlType(), CVLInbuiltSimpleTypes.Companion.int(256).getCvlType()), new Pair<CVLSimpleType.Inbuilt, CVLSimpleType.Inbuilt>(CVLInbuiltSimpleTypes.address.INSTANCE.getCvlType(), CVLInbuiltSimpleTypes.Companion.uint(256).getCvlType()));
        UnionFind<CVLSimpleType.Inbuilt> uf = new UnionFind<CVLSimpleType.Inbuilt>();
        Iterable $this$forEach$iv = allowedImplicitTwoWayTypeConversions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void l;
            Pair $dstr$l$r = (Pair)element$iv;
            boolean bl = false;
            CVLSimpleType.Inbuilt inbuilt = (CVLSimpleType.Inbuilt)$dstr$l$r.component1();
            CVLSimpleType.Inbuilt r = (CVLSimpleType.Inbuilt)$dstr$l$r.component2();
            uf = uf.reportEqual((CVLSimpleType.Inbuilt)l, r);
        }
        allowedImplicitTwoWayTypeConversionsClosure = uf;
    }
}

