/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0014\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lsolver/Z3SolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_Z3_COMMAND", "", "alwaysOnOptions", "", "commandForStdInMode", "customSolverExecutable", "timeoutSeconds", "", "incrementalMode", "", "(Ljava/lang/String;Ljava/lang/Integer;Z)Ljava/util/List;", "getDefaultConfigs", "", "Lsolver/SolverConfig;", "getEqSolverTweakingConfigs", "getLiaSolverTweakingConfigs", "getProcessTimeoutString", "timeoutMillis", "getQueryTimeoutString", "GeneralUtils"})
public final class Z3SolverInfo
extends SolverInfo {
    private static final List<String> alwaysOnOptions;
    private static final String DEFAULT_Z3_COMMAND = "z3";
    public static final Z3SolverInfo INSTANCE;

    @Override
    @NotNull
    public List<String> getProcessTimeoutString(int timeoutMillis) {
        return CollectionsKt.listOf("-T:" + timeoutMillis / 1000);
    }

    @Override
    @NotNull
    public List<String> getQueryTimeoutString(int timeoutMillis) {
        return CollectionsKt.listOf("-t:" + timeoutMillis);
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@Nullable String customSolverExecutable, @Nullable Integer timeoutSeconds, boolean incrementalMode) {
        List<String> list2;
        String[] stringArray = new String[2];
        String string2 = customSolverExecutable;
        if (string2 == null) {
            string2 = DEFAULT_Z3_COMMAND;
        }
        stringArray[0] = string2;
        stringArray[1] = "-in";
        Collection collection = CollectionsKt.listOf(stringArray);
        if (timeoutSeconds != null) {
            list2 = this.getQueryTimeoutString(timeoutSeconds * 1000);
        } else {
            Collection collection2 = collection;
            boolean bl = false;
            List list3 = CollectionsKt.emptyList();
            collection = collection2;
            list2 = list3;
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus(collection, (Iterable)list2), (Iterable)alwaysOnOptions);
    }

    @NotNull
    public final Set<SolverConfig> getDefaultConfigs(int timeoutSeconds, boolean incrementalMode) {
        boolean bl = incrementalMode;
        int n = timeoutSeconds;
        SolverInfo solverInfo = INSTANCE;
        boolean bl2 = false;
        List list2 = CollectionsKt.emptyList();
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 48;
        String string2 = null;
        String string3 = null;
        List list3 = list2;
        boolean bl3 = bl;
        int n3 = n;
        SolverInfo solverInfo2 = solverInfo;
        return SetsKt.plus(SetsKt.plus(SetsKt.setOf(new SolverConfig(solverInfo2, n3, bl3, list3, string3, string2, n2, defaultConstructorMarker)), (Iterable)this.getLiaSolverTweakingConfigs(timeoutSeconds, incrementalMode)), (Iterable)this.getEqSolverTweakingConfigs(timeoutSeconds, incrementalMode));
    }

    @NotNull
    public final Set<SolverConfig> getLiaSolverTweakingConfigs(int timeoutSeconds, boolean incrementalMode) {
        return SetsKt.setOf(new SolverConfig(INSTANCE, timeoutSeconds, incrementalMode, CollectionsKt.listOf("smt.arith.solver=2", "smt.auto_config=false"), null, null, 48, null), new SolverConfig(INSTANCE, timeoutSeconds, incrementalMode, CollectionsKt.listOf("tactic.solve_eqs.max_occs=4", "smt.arith.solver=2", "smt.auto_config=false"), null, null, 48, null));
    }

    @NotNull
    public final Set<SolverConfig> getEqSolverTweakingConfigs(int timeoutSeconds, boolean incrementalMode) {
        return SetsKt.setOf(new SolverConfig(INSTANCE, timeoutSeconds, incrementalMode, CollectionsKt.listOf("tactic.solve_eqs.max_occs=4"), null, null, 48, null), new SolverConfig(INSTANCE, timeoutSeconds, incrementalMode, CollectionsKt.listOf("tactic.solve_eqs.max_occs=4", "tactic.solve_eqs.context_solve=true"), null, null, 48, null));
    }

    private Z3SolverInfo() {
        super("Z3");
    }

    static {
        Z3SolverInfo z3SolverInfo;
        INSTANCE = z3SolverInfo = new Z3SolverInfo();
        alwaysOnOptions = CollectionsKt.listOf("-st");
    }
}

