/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.CVC4SolverInfo;
import solver.SolverInfo;
import solver.YicesSolverInfo;
import solver.Z3SolverInfo;
import utils.RuntimeEnvInfo;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u001c\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u00c6\u0003JM\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\t\u0010#\u001a\u00020\u0005H\u00d6\u0001J\t\u0010$\u001a\u00020\nH\u00d6\u0001R\u0013\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lsolver/SolverConfig;", "", "solverInfo", "Lsolver/SolverInfo;", "timeoutSeconds", "", "incrementalMode", "", "options", "", "", "name", "customSolverCommand", "(Lsolver/SolverInfo;IZLjava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getCustomSolverCommand", "()Ljava/lang/String;", "getIncrementalMode", "()Z", "getName", "getOptions", "()Ljava/util/List;", "getSolverInfo", "()Lsolver/SolverInfo;", "getTimeoutSeconds", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "getCmd", "hashCode", "toString", "Companion", "GeneralUtils"})
public final class SolverConfig {
    @NotNull
    private final SolverInfo solverInfo;
    private final int timeoutSeconds;
    private final boolean incrementalMode;
    @NotNull
    private final List<String> options;
    @NotNull
    private final String name;
    @Nullable
    private final String customSolverCommand;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<String> getCmd() {
        return CollectionsKt.plus((Collection)this.solverInfo.commandForStdInMode(this.customSolverCommand, this.timeoutSeconds, this.incrementalMode), (Iterable)this.options);
    }

    @NotNull
    public final SolverInfo getSolverInfo() {
        return this.solverInfo;
    }

    public final int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public final boolean getIncrementalMode() {
        return this.incrementalMode;
    }

    @NotNull
    public final List<String> getOptions() {
        return this.options;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getCustomSolverCommand() {
        return this.customSolverCommand;
    }

    public SolverConfig(@NotNull SolverInfo solverInfo, int timeoutSeconds, boolean incrementalMode, @NotNull List<String> options, @NotNull String name, @Nullable String customSolverCommand) {
        Intrinsics.checkParameterIsNotNull(solverInfo, "solverInfo");
        Intrinsics.checkParameterIsNotNull(options, "options");
        Intrinsics.checkParameterIsNotNull(name, "name");
        this.solverInfo = solverInfo;
        this.timeoutSeconds = timeoutSeconds;
        this.incrementalMode = incrementalMode;
        this.options = options;
        this.name = name;
        this.customSolverCommand = customSolverCommand;
    }

    public /* synthetic */ SolverConfig(SolverInfo solverInfo, int n, boolean bl, List list2, String string2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            string2 = solverInfo.getName();
        }
        if ((n2 & 0x20) != 0) {
            string3 = null;
        }
        this(solverInfo, n, bl, list2, string2, string3);
    }

    @NotNull
    public final SolverInfo component1() {
        return this.solverInfo;
    }

    public final int component2() {
        return this.timeoutSeconds;
    }

    public final boolean component3() {
        return this.incrementalMode;
    }

    @NotNull
    public final List<String> component4() {
        return this.options;
    }

    @NotNull
    public final String component5() {
        return this.name;
    }

    @Nullable
    public final String component6() {
        return this.customSolverCommand;
    }

    @NotNull
    public final SolverConfig copy(@NotNull SolverInfo solverInfo, int timeoutSeconds, boolean incrementalMode, @NotNull List<String> options, @NotNull String name, @Nullable String customSolverCommand) {
        Intrinsics.checkParameterIsNotNull(solverInfo, "solverInfo");
        Intrinsics.checkParameterIsNotNull(options, "options");
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new SolverConfig(solverInfo, timeoutSeconds, incrementalMode, options, name, customSolverCommand);
    }

    public static /* synthetic */ SolverConfig copy$default(SolverConfig solverConfig, SolverInfo solverInfo, int n, boolean bl, List list2, String string2, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            solverInfo = solverConfig.solverInfo;
        }
        if ((n2 & 2) != 0) {
            n = solverConfig.timeoutSeconds;
        }
        if ((n2 & 4) != 0) {
            bl = solverConfig.incrementalMode;
        }
        if ((n2 & 8) != 0) {
            list2 = solverConfig.options;
        }
        if ((n2 & 0x10) != 0) {
            string2 = solverConfig.name;
        }
        if ((n2 & 0x20) != 0) {
            string3 = solverConfig.customSolverCommand;
        }
        return solverConfig.copy(solverInfo, n, bl, list2, string2, string3);
    }

    @NotNull
    public String toString() {
        return "SolverConfig(solverInfo=" + this.solverInfo + ", timeoutSeconds=" + this.timeoutSeconds + ", incrementalMode=" + this.incrementalMode + ", options=" + this.options + ", name=" + this.name + ", customSolverCommand=" + this.customSolverCommand + ")";
    }

    public int hashCode() {
        SolverInfo solverInfo = this.solverInfo;
        int n = ((solverInfo != null ? solverInfo.hashCode() : 0) * 31 + Integer.hashCode(this.timeoutSeconds)) * 31;
        int n2 = this.incrementalMode ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        List<String> list2 = this.options;
        String string2 = this.name;
        String string3 = this.customSolverCommand;
        return (((n + n2) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SolverConfig)) break block3;
                SolverConfig solverConfig = (SolverConfig)object;
                if (!Intrinsics.areEqual(this.solverInfo, solverConfig.solverInfo) || this.timeoutSeconds != solverConfig.timeoutSeconds || this.incrementalMode != solverConfig.incrementalMode || !Intrinsics.areEqual(this.options, solverConfig.options) || !Intrinsics.areEqual(this.name, solverConfig.name) || !Intrinsics.areEqual(this.customSolverCommand, solverConfig.customSolverCommand)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ.\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0010"}, d2={"Lsolver/SolverConfig$Companion;", "", "()V", "getAllQuantifiedConfigs", "", "Lsolver/SolverConfig;", "timeoutSeconds", "", "incrementalMode", "", "getDefaultSolverConfigsDependingOnSolverChoice", "checkAllSolvers", "solverProgramChoice", "Lsolver/SolverInfo;", "getNonLinearConfigs", "getNonLinearQuantifierFreeConfigs", "GeneralUtils"})
    public static final class Companion {
        @NotNull
        public final Set<SolverConfig> getDefaultSolverConfigsDependingOnSolverChoice(boolean checkAllSolvers, @Nullable SolverInfo solverProgramChoice, int timeoutSeconds, boolean incrementalMode) {
            Set<SolverConfig> set;
            if (checkAllSolvers) {
                set = SetsKt.plus(Z3SolverInfo.INSTANCE.getDefaultConfigs(timeoutSeconds, incrementalMode), (Iterable)CVC4SolverInfo.INSTANCE.getDefaultConfigs(timeoutSeconds, incrementalMode));
            } else {
                SolverInfo solverInfo = solverProgramChoice;
                if (Intrinsics.areEqual(solverInfo, Z3SolverInfo.INSTANCE)) {
                    set = Z3SolverInfo.INSTANCE.getDefaultConfigs(timeoutSeconds, incrementalMode);
                } else if (Intrinsics.areEqual(solverInfo, CVC4SolverInfo.INSTANCE)) {
                    set = CVC4SolverInfo.INSTANCE.getDefaultConfigs(timeoutSeconds, incrementalMode);
                } else if (Intrinsics.areEqual(solverInfo, YicesSolverInfo.INSTANCE)) {
                    set = YicesSolverInfo.INSTANCE.getDefaultConfigs(timeoutSeconds, incrementalMode);
                } else {
                    if (solverInfo == null) {
                        throw (Throwable)new IllegalArgumentException("Solver program choice cannot be null when \"check all solvers\" is false.");
                    }
                    String string2 = "unhandled solver program choice: " + solverProgramChoice;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
            }
            return set;
        }

        @NotNull
        public final Set<SolverConfig> getAllQuantifiedConfigs(int timeoutSeconds, boolean incrementalMode) {
            return CVC4SolverInfo.INSTANCE.getQuantifierConfigs(timeoutSeconds, incrementalMode);
        }

        @NotNull
        public final Set<SolverConfig> getNonLinearQuantifierFreeConfigs(int timeoutSeconds, boolean incrementalMode) {
            Set<SolverConfig> set;
            if (RuntimeEnvInfo.INSTANCE.isYicesAvailable()) {
                set = YicesSolverInfo.INSTANCE.getDefaultConfigs(timeoutSeconds, incrementalMode);
            } else {
                boolean bl = false;
                set = SetsKt.emptySet();
            }
            return set;
        }

        @NotNull
        public final Set<SolverConfig> getNonLinearConfigs(int timeoutSeconds, boolean incrementalMode) {
            return CVC4SolverInfo.INSTANCE.getNonLinearConfigs(timeoutSeconds, incrementalMode);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

