/*
 * Decompiled with CFR 0.152.
 */
package org.walleth.sha3;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.walleth.sha3.SHA3Parameter;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a!\u0010\f\u001a\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000e0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u0012\u0010\u0010\u001a\u00020\b*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0010\u001a\u00020\b*\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0014\u0010\u0014\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0016H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"BIT_64", "Ljava/math/BigInteger;", "convertFrom64ToLittleEndian", "", "uLong", "convertFromLittleEndianTo64", "data", "convertToUInt", "", "doF", "", "uState", "roundB", "state", "", "([[Ljava/math/BigInteger;)V", "calculateSHA3", "parameter", "Lorg/walleth/sha3/SHA3Parameter;", "", "fillWithZero", "fillLength", "", "leftRotate64", "rotate", "leftRotate64Safely", "sha3"})
public final class SHA3Kt {
    private static final BigInteger BIT_64 = new BigInteger("18446744073709551615");

    @NotNull
    public static final byte[] calculateSHA3(@NotNull String $receiver, @NotNull SHA3Parameter parameter) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull((Object)parameter, "parameter");
        String string2 = $receiver;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "(this as java.lang.String).getBytes(charset)");
        return SHA3Kt.calculateSHA3(byArray, parameter);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] calculateSHA3(@NotNull byte[] $receiver, @NotNull SHA3Parameter parameter) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull((Object)parameter, "parameter");
        int[] uState = new int[200];
        int[] uMessage = SHA3Kt.convertToUInt($receiver);
        int blockSize = 0;
        for (int inputOffset = 0; inputOffset < uMessage.length; inputOffset += blockSize) {
            blockSize = Math.min(uMessage.length - inputOffset, parameter.getRateInBytes());
            int n = 0;
            int n2 = blockSize;
            while (n < n2) {
                void i;
                uState[i] = uState[i] ^ uMessage[i + inputOffset];
                ++i;
            }
            if (blockSize != parameter.getRateInBytes()) continue;
            SHA3Kt.doF(uState);
            blockSize = 0;
        }
        uState[blockSize] = uState[blockSize] ^ parameter.getD();
        if ((parameter.getD() & 0x80) != 0 && blockSize == parameter.getRateInBytes() - 1) {
            SHA3Kt.doF(uState);
        }
        uState[parameter.getRateInBytes() - 1] = uState[parameter.getRateInBytes() - 1] ^ 0x80;
        SHA3Kt.doF(uState);
        ByteArrayOutputStream byteResults = new ByteArrayOutputStream();
        int tOutputLen = parameter.getOutputLengthInBytes();
        while (tOutputLen > 0) {
            blockSize = Math.min(tOutputLen, parameter.getRateInBytes());
            int n = 0;
            int n3 = blockSize;
            while (n < n3) {
                void i;
                byteResults.write((byte)uState[i]);
                ++i;
            }
            if ((tOutputLen -= blockSize) <= 0) continue;
            SHA3Kt.doF(uState);
        }
        byte[] byArray = byteResults.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "byteResults.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private static final void doF(int[] uState) {
        int j;
        int i;
        void var3_2;
        int i$iv;
        int size$iv = 5;
        BigInteger[][] result$iv = new BigInteger[size$iv][];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            void var6_6 = i$iv;
            void var20_18 = i$iv;
            BigInteger[][] bigIntegerArrayArray = result$iv;
            int size$iv2 = 5;
            BigInteger[] result$iv2 = new BigInteger[size$iv2];
            int n3 = 0;
            int n4 = result$iv2.length;
            while (n3 < n4) {
                BigInteger bigInteger;
                void i$iv2;
                void var11_13 = i$iv2;
                void var12_14 = i$iv2++;
                BigInteger[] bigIntegerArray = result$iv2;
                bigIntegerArray[var12_14] = bigInteger = BigInteger.ZERO;
            }
            BigInteger[] bigIntegerArray = result$iv2;
            bigIntegerArrayArray[var20_18] = bigIntegerArray;
            ++i$iv;
        }
        BigInteger[][] lState = (BigInteger[][])var3_2;
        size$iv = 0;
        int n5 = 4;
        while (size$iv <= n5) {
            i$iv = 0;
            n2 = 4;
            while (i$iv <= n2) {
                int[] data = new int[8];
                System.arraycopy(uState, 8 * (i + 5 * j), data, 0, data.length);
                lState[i][j] = SHA3Kt.convertFromLittleEndianTo64(data);
                ++j;
            }
            ++i;
        }
        SHA3Kt.roundB(lState);
        Arrays.fill(uState, 0);
        n5 = 4;
        for (i = 0; i <= n5; ++i) {
            n2 = 4;
            for (j = 0; j <= n2; ++j) {
                BigInteger bigInteger = lState[i][j];
                Intrinsics.checkExpressionValueIsNotNull(bigInteger, "lState[i][j]");
                int[] data = SHA3Kt.convertFrom64ToLittleEndian(bigInteger);
                System.arraycopy(data, 0, uState, 8 * (i + 5 * j), data.length);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void roundB(BigInteger[][] state) {
        int lfsrState = 1;
        int n = 0;
        int n2 = 23;
        while (n <= n2) {
            void round;
            int j;
            int i;
            int n3;
            int i2;
            BigInteger[] c = new BigInteger[5];
            BigInteger[] d = new BigInteger[5];
            int n4 = 0;
            int n5 = 4;
            while (n4 <= n5) {
                c[i2] = state[i2][0].xor(state[i2][1]).xor(state[i2][2]).xor(state[i2][3]).xor(state[i2][4]);
                ++i2;
            }
            n5 = 4;
            for (i2 = 0; i2 <= n5; ++i2) {
                BigInteger bigInteger = c[(i2 + 4) % 5];
                if (bigInteger == null) {
                    Intrinsics.throwNpe();
                }
                BigInteger bigInteger2 = c[(i2 + 1) % 5];
                if (bigInteger2 == null) {
                    Intrinsics.throwNpe();
                }
                d[i2] = bigInteger.xor(SHA3Kt.leftRotate64(bigInteger2, 1));
            }
            n5 = 4;
            for (i2 = 0; i2 <= n5; ++i2) {
                int n6 = 0;
                n3 = 4;
                while (n6 <= n3) {
                    void j2;
                    BigInteger[] bigIntegerArray = state[i2];
                    BigInteger bigInteger = state[i2][j2].xor(d[i2]);
                    Intrinsics.checkExpressionValueIsNotNull(bigInteger, "state[i][j].xor(d[i])");
                    bigIntegerArray[j2] = bigInteger;
                    ++j2;
                }
            }
            int x = 1;
            int y = 0;
            BigInteger current = state[x][y];
            n3 = 0;
            int n7 = 23;
            while (n3 <= n7) {
                int tX = x;
                x = y;
                y = (2 * tX + 3 * y) % 5;
                BigInteger shiftValue = current;
                current = state[x][y];
                state[x][y] = SHA3Kt.leftRotate64Safely(shiftValue, (i + 1) * (i + 2) / 2);
                ++i;
            }
            i = 0;
            n7 = 4;
            while (i <= n7) {
                int i3;
                BigInteger[] t2 = new BigInteger[5];
                int shiftValue = 0;
                int n8 = 4;
                while (shiftValue <= n8) {
                    t2[i3] = state[i3][j];
                    ++i3;
                }
                n8 = 4;
                for (i3 = 0; i3 <= n8; ++i3) {
                    BigInteger bigInteger = t2[(i3 + 1) % 5];
                    if (bigInteger == null) {
                        Intrinsics.throwNpe();
                    }
                    BigInteger invertVal = bigInteger.xor(BIT_64);
                    BigInteger[] bigIntegerArray = state[i3];
                    BigInteger bigInteger3 = t2[i3];
                    if (bigInteger3 == null) {
                        Intrinsics.throwNpe();
                    }
                    BigInteger bigInteger4 = bigInteger3.xor(invertVal.and(t2[(i3 + 2) % 5]));
                    Intrinsics.checkExpressionValueIsNotNull(bigInteger4, "t[i]!!.xor(invertVal.and(t[(i + 2) % 5]))");
                    bigIntegerArray[j] = bigInteger4;
                }
                ++j;
            }
            j = 0;
            n7 = 6;
            while (j <= n7) {
                lfsrState = (lfsrState << 1 ^ (lfsrState >> 7) * 113) % 256;
                int bitPosition = (1 << i) - 1;
                if ((lfsrState & 2) != 0) {
                    BigInteger[] bigIntegerArray = state[0];
                    BigInteger bigInteger = state[0][0].xor(BigInteger.ONE.shiftLeft(bitPosition));
                    Intrinsics.checkExpressionValueIsNotNull(bigInteger, "state[0][0].xor(ONE.shiftLeft(bitPosition))");
                    bigIntegerArray[0] = bigInteger;
                }
                ++i;
            }
            ++round;
        }
    }

    @NotNull
    public static final String fillWithZero(@NotNull String $receiver, int fillLength) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver + StringsKt.repeat("0", Math.max(fillLength - $receiver.length(), 0));
    }

    /*
     * WARNING - void declaration
     */
    private static final int[] convertToUInt(byte[] data) {
        void var2_2;
        int size$iv = data.length;
        int[] result$iv = new int[size$iv];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            void it;
            int n3;
            void i$iv;
            void var5_5 = i$iv;
            void var9_7 = i$iv++;
            int[] nArray = result$iv;
            nArray[var9_7] = n3 = data[it] & 0xFF;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BigInteger convertFromLittleEndianTo64(@NotNull int[] data) {
        void var3_5;
        String string2;
        Collection<String> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        BigInteger bigInteger;
        Intrinsics.checkParameterIsNotNull(data, "data");
        int[] nArray = data;
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = bigInteger;
        void var2_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
        int n = ((void)$receiver$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv2;
            void var7_12 = item$iv$iv2 = $receiver$iv$iv[i];
            collection = destination$iv$iv;
            string2 = Integer.toString((int)it, 16);
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)collection;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String item$iv$iv2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            string2 = it.length() == 2 ? it : '0' + (String)it;
            collection.add(string2);
        }
        collection = (List)var3_5;
        bigInteger2(CollectionsKt.joinToString$default(CollectionsKt.reversed((Iterable)collection), "", null, null, 0, null, null, 62, null), 16);
        return bigInteger3;
    }

    /*
     * WARNING - void declaration
     */
    private static final int[] convertFrom64ToLittleEndian(BigInteger uLong) {
        String asHex = uLong.toString(16);
        String asHexPadded = StringsKt.repeat("0", 16 - asHex.length()) + asHex;
        int size$iv = 8;
        int[] result$iv = new int[size$iv];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            int n3;
            void it;
            int n4;
            void i$iv;
            void var7_7 = i$iv;
            void var16_13 = i$iv++;
            int[] nArray = result$iv;
            int it2 = n4 = (7 - it) * 2;
            String string2 = asHexPadded;
            int n5 = it2 + 2;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(it2, n5);
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            nArray[var16_13] = n3 = Integer.parseInt(string4, 16);
        }
        return result$iv;
    }

    private static final BigInteger leftRotate64Safely(@NotNull BigInteger $receiver, int rotate) {
        return SHA3Kt.leftRotate64($receiver, rotate % 64);
    }

    private static final BigInteger leftRotate64(@NotNull BigInteger $receiver, int rotate) {
        BigInteger lp = $receiver.shiftRight(64 - rotate);
        BigInteger rp = $receiver.shiftLeft(rotate);
        BigInteger bigInteger = lp.add(rp).mod(new BigInteger("18446744073709551616"));
        Intrinsics.checkExpressionValueIsNotNull(bigInteger, "lp.add(rp).mod(BigInteger(\"18446744073709551616\"))");
        return bigInteger;
    }
}

