/*
 * Decompiled with CFR 0.152.
 */
package org.nield.kotlinstatistics.range;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.nield.kotlinstatistics.range.InvalidRangeException;
import org.nield.kotlinstatistics.range.Range;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/nield/kotlinstatistics/range/ClosedOpenRange;", "T", "", "Lorg/nield/kotlinstatistics/range/Range;", "startInclusive", "endExclusive", "(Ljava/lang/Comparable;Ljava/lang/Comparable;)V", "getEndExclusive", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "lowerBound", "getLowerBound", "getStartInclusive", "upperBound", "getUpperBound", "contains", "", "value", "(Ljava/lang/Comparable;)Z", "isEmpty", "toString", "", "build"})
public final class ClosedOpenRange<T extends Comparable<? super T>>
implements Range<T> {
    @NotNull
    private final T startInclusive;
    @NotNull
    private final T endExclusive;

    @Override
    @NotNull
    public T getLowerBound() {
        return this.startInclusive;
    }

    @Override
    @NotNull
    public T getUpperBound() {
        return this.endExclusive;
    }

    @Override
    public boolean contains(@NotNull T value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return value.compareTo(this.startInclusive) >= 0 && value.compareTo(this.endExclusive) < 0;
    }

    @Override
    public boolean isEmpty() {
        return Intrinsics.areEqual(this.endExclusive, this.startInclusive);
    }

    @NotNull
    public String toString() {
        return "" + '[' + this.startInclusive + ".." + this.endExclusive + ')';
    }

    @NotNull
    public final T getStartInclusive() {
        return this.startInclusive;
    }

    @NotNull
    public final T getEndExclusive() {
        return this.endExclusive;
    }

    public ClosedOpenRange(@NotNull T startInclusive, @NotNull T endExclusive) {
        Intrinsics.checkParameterIsNotNull(startInclusive, "startInclusive");
        Intrinsics.checkParameterIsNotNull(endExclusive, "endExclusive");
        this.startInclusive = startInclusive;
        this.endExclusive = endExclusive;
        if (this.startInclusive.compareTo(this.endExclusive) > 0) {
            throw (Throwable)new InvalidRangeException("" + '(' + this.startInclusive + ".." + this.endExclusive + "] is an invalid ClosedOpenRange!");
        }
    }
}

