/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicKind;
import kotlinx.serialization.PrimitiveKind;
import kotlinx.serialization.SealedClassSerializer;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.UnionKind;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.internal.UtilKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementsKt;
import kotlinx.serialization.json.JsonInput;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonOutput;
import kotlinx.serialization.json.internal.TreeJsonInputKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a*\u0010\u0004\u001a\u00020\u00012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u001a%\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH\u0000\u00a2\u0006\u0002\u0010\u0010\u001a<\u0010\u0011\u001a\u00020\u0001\"\u0004\b\u0000\u0010\f*\u00020\u00122\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\f0\u00132\u0006\u0010\u0014\u001a\u0002H\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0080\b\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"checkKind", "", "kind", "Lkotlinx/serialization/SerialKind;", "validateIfSealed", "serializer", "Lkotlinx/serialization/KSerializer;", "actualSerializer", "", "classDiscriminator", "", "decodeSerializableValuePolymorphic", "T", "Lkotlinx/serialization/json/JsonInput;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/json/JsonInput;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "encodePolymorphically", "Lkotlinx/serialization/json/JsonOutput;", "Lkotlinx/serialization/SerializationStrategy;", "value", "ifPolymorphic", "Lkotlin/Function0;", "(Lkotlinx/serialization/json/JsonOutput;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "kotlinx-serialization-runtime"})
public final class PolymorphicKt {
    public static final <T> void encodePolymorphically(@NotNull JsonOutput $this$encodePolymorphically, @NotNull SerializationStrategy<? super T> serializer2, T value, @NotNull Function0<Unit> ifPolymorphic) {
        int $i$f$encodePolymorphically = 0;
        Intrinsics.checkParameterIsNotNull($this$encodePolymorphically, "$this$encodePolymorphically");
        Intrinsics.checkParameterIsNotNull(serializer2, "serializer");
        Intrinsics.checkParameterIsNotNull(ifPolymorphic, "ifPolymorphic");
        if (!(serializer2 instanceof AbstractPolymorphicSerializer) || $this$encodePolymorphically.getJson().configuration.getUseArrayPolymorphism$kotlinx_serialization_runtime()) {
            serializer2.serialize($this$encodePolymorphically, value);
            return;
        }
        AbstractPolymorphicSerializer cfr_ignored_0 = (AbstractPolymorphicSerializer)serializer2;
        T t2 = value;
        if (t2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
        }
        KSerializer<T> $this$cast$iv = ((AbstractPolymorphicSerializer)serializer2).findPolymorphicSerializer($this$encodePolymorphically, t2);
        boolean $i$f$cast = false;
        KSerializer<T> kSerializer = $this$cast$iv;
        if (kSerializer == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
        }
        KSerializer<T> actualSerializer = kSerializer;
        PolymorphicKt.validateIfSealed((KSerializer)serializer2, actualSerializer, $this$encodePolymorphically.getJson().configuration.getClassDiscriminator$kotlinx_serialization_runtime());
        SerialKind kind = actualSerializer.getDescriptor().getKind();
        PolymorphicKt.checkKind(kind);
        ifPolymorphic.invoke();
        actualSerializer.serialize($this$encodePolymorphically, value);
    }

    private static final void validateIfSealed(KSerializer<?> serializer2, KSerializer<Object> actualSerializer, String classDiscriminator) {
        if (!(serializer2 instanceof SealedClassSerializer)) {
            return;
        }
        if (UtilKt.cachedSerialNames(actualSerializer.getDescriptor()).contains(classDiscriminator)) {
            String baseName = serializer2.getDescriptor().getSerialName();
            String actualName = actualSerializer.getDescriptor().getSerialName();
            String string2 = "Sealed class '" + actualName + "' cannot be serialized as base class '" + baseName + "' because" + " it has property name that conflicts with JSON class discriminator '" + classDiscriminator + "'. " + "You can either change class discriminator in JsonConfiguration, " + "rename property with @SerialName annotation or fall back to array polymorphism";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    }

    public static final void checkKind(@NotNull SerialKind kind) {
        Intrinsics.checkParameterIsNotNull(kind, "kind");
        if (kind instanceof UnionKind.ENUM_KIND) {
            String string2 = "Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonConfiguration.useArrayPolymorphism' instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (kind instanceof PrimitiveKind) {
            String string3 = "Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonConfiguration.useArrayPolymorphism' instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        if (kind instanceof PolymorphicKind) {
            String string4 = "Actual serializer for polymorphic cannot be polymorphic itself";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
    }

    public static final <T> T decodeSerializableValuePolymorphic(@NotNull JsonInput $this$decodeSerializableValuePolymorphic, @NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkParameterIsNotNull($this$decodeSerializableValuePolymorphic, "$this$decodeSerializableValuePolymorphic");
        Intrinsics.checkParameterIsNotNull(deserializer, "deserializer");
        if (!(deserializer instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic.getJson().configuration.getUseArrayPolymorphism$kotlinx_serialization_runtime()) {
            return deserializer.deserialize($this$decodeSerializableValuePolymorphic);
        }
        JsonElement value$iv = $this$decodeSerializableValuePolymorphic.decodeJson();
        boolean $i$f$cast = false;
        boolean bl = value$iv instanceof JsonObject;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " but found " + Reflection.getOrCreateKotlinClass(value$iv.getClass());
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        JsonObject jsonTree = (JsonObject)value$iv;
        String type = JsonElementsKt.getContent((JsonElement)MapsKt.getValue(jsonTree, $this$decodeSerializableValuePolymorphic.getJson().configuration.getClassDiscriminator$kotlinx_serialization_runtime()));
        Map<String, JsonElement> map2 = jsonTree.getContent();
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlinx.serialization.json.JsonElement>");
        }
        TypeIntrinsics.asMutableMap(map2).remove($this$decodeSerializableValuePolymorphic.getJson().configuration.getClassDiscriminator$kotlinx_serialization_runtime());
        KSerializer $this$cast$iv = ((AbstractPolymorphicSerializer)deserializer).findPolymorphicSerializer($this$decodeSerializableValuePolymorphic, type);
        boolean $i$f$cast2 = false;
        KSerializer kSerializer = $this$cast$iv;
        if (kSerializer == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
        }
        KSerializer actualSerializer = kSerializer;
        return TreeJsonInputKt.readJson($this$decodeSerializableValuePolymorphic.getJson(), jsonTree, actualSerializer);
    }
}

