/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.json.JsonDecodingException;
import kotlinx.serialization.json.JsonEncodingException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0012\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0013"}, d2={"InvalidFloatingPoint", "Lkotlinx/serialization/json/JsonEncodingException;", "value", "", "type", "", "output", "key", "InvalidKeyKindException", "keyDescriptor", "Lkotlinx/serialization/SerialDescriptor;", "JsonDecodingException", "Lkotlinx/serialization/json/JsonDecodingException;", "offset", "", "message", "input", "UnknownKeyException", "minify", "kotlinx-serialization-runtime"})
public final class JsonExceptionsKt {
    @NotNull
    public static final JsonDecodingException JsonDecodingException(int offset, @NotNull String message, @NotNull String input) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(input, "input");
        return new JsonDecodingException(offset, message + ".\n JSON input: " + JsonExceptionsKt.minify(input, offset));
    }

    @NotNull
    public static final JsonEncodingException InvalidFloatingPoint(@NotNull Number value, @NotNull String type, @NotNull String output) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(type, "type");
        Intrinsics.checkParameterIsNotNull(output, "output");
        return new JsonEncodingException("" + '\'' + value + "' is not a valid '" + type + "' as per JSON specification. " + "You can enable 'serializeSpecialFloatingPointValues' property to serialize such values\n" + "Current output: " + JsonExceptionsKt.minify$default(output, 0, 1, null));
    }

    @NotNull
    public static final JsonEncodingException InvalidFloatingPoint(@NotNull Number value, @NotNull String key, @NotNull String type, @NotNull String output) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(type, "type");
        Intrinsics.checkParameterIsNotNull(output, "output");
        return new JsonEncodingException("" + '\'' + value + "' with key '" + key + "' is not a valid " + type + " as per JSON specification. " + "You can enable 'serializeSpecialFloatingPointValues' property to serialize such values.\n" + "Current output: " + JsonExceptionsKt.minify$default(output, 0, 1, null));
    }

    @NotNull
    public static final JsonDecodingException UnknownKeyException(@NotNull String key, @NotNull String input) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(input, "input");
        return new JsonDecodingException(-1, "JSON encountered unknown key: '" + key + "'. You can enable 'JsonConfiguration.ignoreUnknownKeys' property to ignore unknown keys.\n" + " JSON input: " + JsonExceptionsKt.minify$default(input, 0, 1, null));
    }

    @NotNull
    public static final JsonEncodingException InvalidKeyKindException(@NotNull SerialDescriptor keyDescriptor) {
        Intrinsics.checkParameterIsNotNull(keyDescriptor, "keyDescriptor");
        return new JsonEncodingException("Value of type '" + keyDescriptor.getSerialName() + "' can't be used in JSON as a key in the map. " + "It should have either primitive or enum kind, but its kind is '" + keyDescriptor.getKind() + ".'\n" + "You can convert such maps to arrays [key1, value1, key2, value2,...] using 'allowStructuredMapKeys' property in JsonConfiguration");
    }

    private static final String minify(@NotNull String $this$minify, int offset) {
        if ($this$minify.length() < 200) {
            return $this$minify;
        }
        if (offset == -1) {
            int start = $this$minify.length() - 60;
            if (start <= 0) {
                return $this$minify;
            }
            String string2 = $this$minify;
            StringBuilder stringBuilder = new StringBuilder().append(".....");
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(start);
            Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).substring(startIndex)");
            String string5 = string4;
            return stringBuilder.append(string5).toString();
        }
        int start = offset - 30;
        int end = offset + 30;
        String prefix = start <= 0 ? "" : ".....";
        String suffix = end >= $this$minify.length() ? "" : ".....";
        String string6 = $this$minify;
        int n = RangesKt.coerceAtLeast(start, 0);
        int n2 = RangesKt.coerceAtMost(end, $this$minify.length());
        StringBuilder stringBuilder = new StringBuilder().append(prefix);
        boolean bl = false;
        String string7 = string6;
        if (string7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull(string8, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string9 = string8;
        return stringBuilder.append(string9).append(suffix).toString();
    }

    static /* synthetic */ String minify$default(String string2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return JsonExceptionsKt.minify(string2, n);
    }
}

