/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.TimeSourceKt;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.scheduling.CoroutineScheduler$WhenMappings;
import kotlinx.coroutines.scheduling.GlobalQueue;
import kotlinx.coroutines.scheduling.NonBlockingContext;
import kotlinx.coroutines.scheduling.Task;
import kotlinx.coroutines.scheduling.TaskContext;
import kotlinx.coroutines.scheduling.TaskImpl;
import kotlinx.coroutines.scheduling.TaskMode;
import kotlinx.coroutines.scheduling.TasksKt;
import kotlinx.coroutines.scheduling.WorkQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\b\u0000\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0003EFGB)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\r\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0007H\u0082\bJ\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0004H\u0002J!\u0010&\u001a\u00020'2\n\u0010(\u001a\u00060)j\u0002`*2\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J\u0011\u0010\u0014\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0007H\u0082\bJ\t\u0010.\u001a\u00020$H\u0082\bJ\t\u0010/\u001a\u00020\u0004H\u0082\bJ&\u00100\u001a\u00020$2\n\u0010(\u001a\u00060)j\u0002`*2\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u00101\u001a\u00020\u0019J\u0014\u00102\u001a\u00020$2\n\u00103\u001a\u00060)j\u0002`*H\u0016J\t\u00104\u001a\u00020$H\u0082\bJ\t\u00105\u001a\u00020\u0004H\u0082\bJ\u0014\u00106\u001a\u00020\u00042\n\u00107\u001a\u00060 R\u00020\u0000H\u0002J\u000e\u00108\u001a\b\u0018\u00010 R\u00020\u0000H\u0002J\u0014\u00109\u001a\u00020$2\n\u00107\u001a\u00060 R\u00020\u0000H\u0002J$\u0010:\u001a\u00020$2\n\u00107\u001a\u00060 R\u00020\u00002\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u0004H\u0002J\b\u0010=\u001a\u00020$H\u0002J\u0010\u0010>\u001a\u00020$2\u0006\u0010?\u001a\u00020'H\u0002J\u000e\u0010@\u001a\u00020$2\u0006\u0010A\u001a\u00020\u0007J\u0018\u0010B\u001a\u00020\u00042\u0006\u0010?\u001a\u00020'2\u0006\u00101\u001a\u00020\u0019H\u0002J\b\u0010C\u001a\u00020\tH\u0016J\b\u0010D\u001a\u00020\u0019H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\r\u001a\u00020\u00048\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0014\u001a\u00020\u00048\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0018\u00010 R\u00020\u00000\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!\u00a8\u0006H"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "Ljava/util/concurrent/Executor;", "Ljava/io/Closeable;", "corePoolSize", "", "maxPoolSize", "idleWorkerKeepAliveNs", "", "schedulerName", "", "(IIJLjava/lang/String;)V", "_isTerminated", "Lkotlinx/atomicfu/AtomicInt;", "blockingWorkers", "getBlockingWorkers", "()I", "controlState", "Lkotlinx/atomicfu/AtomicLong;", "cpuPermits", "Ljava/util/concurrent/Semaphore;", "createdWorkers", "getCreatedWorkers", "globalQueue", "Lkotlinx/coroutines/scheduling/GlobalQueue;", "isTerminated", "", "()Z", "parkedWorkersStack", "random", "Ljava/util/Random;", "workers", "", "Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "[Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "state", "close", "", "createNewWorker", "createTask", "Lkotlinx/coroutines/scheduling/Task;", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "taskContext", "Lkotlinx/coroutines/scheduling/TaskContext;", "createTask$kotlinx_coroutines_core", "decrementBlockingWorkers", "decrementCreatedWorkers", "dispatch", "fair", "execute", "command", "incrementBlockingWorkers", "incrementCreatedWorkers", "parkedWorkersStackNextIndex", "worker", "parkedWorkersStackPop", "parkedWorkersStackPush", "parkedWorkersStackTopUpdate", "oldIndex", "newIndex", "requestCpuWorker", "runSafely", "task", "shutdown", "timeout", "submitToLocalQueue", "toString", "tryUnpark", "Companion", "Worker", "WorkerState", "kotlinx-coroutines-core"})
public final class CoroutineScheduler
implements Executor,
Closeable {
    private final GlobalQueue globalQueue;
    private final Semaphore cpuPermits;
    private volatile long parkedWorkersStack;
    private static final AtomicLongFieldUpdater parkedWorkersStack$FU;
    private final Worker[] workers;
    volatile long controlState;
    static final AtomicLongFieldUpdater controlState$FU;
    private final Random random;
    private volatile int _isTerminated;
    private static final AtomicIntegerFieldUpdater _isTerminated$FU;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final long idleWorkerKeepAliveNs;
    private final String schedulerName;
    private static final int MAX_SPINS = 1000;
    private static final int MAX_YIELDS = 1500;
    private static final int MAX_PARK_TIME_NS;
    private static final int MIN_PARK_TIME_NS;
    private static final Symbol NOT_IN_STACK;
    private static final int ADDED = -1;
    private static final int ADDED_REQUIRES_HELP = 0;
    private static final int NOT_ADDED = 1;
    private static final int FORBIDDEN = -1;
    private static final int ALLOWED = 0;
    private static final int TERMINATED = 1;
    private static final int BLOCKING_SHIFT = 21;
    private static final long CREATED_MASK = 0x1FFFFFL;
    private static final long BLOCKING_MASK = 4398044413952L;
    public static final int MIN_SUPPORTED_POOL_SIZE = 1;
    public static final int MAX_SUPPORTED_POOL_SIZE = 0x1FFFFE;
    private static final long PARKED_INDEX_MASK = 0x1FFFFFL;
    private static final long PARKED_VERSION_MASK = -2097152L;
    private static final long PARKED_VERSION_INC = 0x200000L;
    public static final Companion Companion;

    private final void parkedWorkersStackTopUpdate(Worker worker, int oldIndex, int newIndex) {
        long updVersion;
        long top;
        int n;
        int updIndex;
        CoroutineScheduler $receiver$iv = this;
        do {
            top = $receiver$iv.parkedWorkersStack;
            int index = (int)(top & 0x1FFFFFL);
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
            if (index == oldIndex) {
                if (newIndex == 0) {
                    n = this.parkedWorkersStackNextIndex(worker);
                    continue;
                }
                n = newIndex;
                continue;
            }
            n = index;
        } while ((updIndex = n) < 0 || !parkedWorkersStack$FU.compareAndSet(this, top, updVersion | (long)updIndex));
    }

    private final void parkedWorkersStackPush(Worker worker) {
        int updIndex;
        long updVersion;
        long top;
        if (worker.getNextParkedWorker() != NOT_IN_STACK) {
            return;
        }
        CoroutineScheduler $receiver$iv = this;
        do {
            boolean bl;
            top = $receiver$iv.parkedWorkersStack;
            int index = (int)(top & 0x1FFFFFL);
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
            updIndex = worker.getIndexInArray();
            boolean bl2 = bl = updIndex != 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            worker.setNextParkedWorker(this.workers[index]);
        } while (!parkedWorkersStack$FU.compareAndSet(this, top, updVersion | (long)updIndex));
    }

    private final Worker parkedWorkersStackPop() {
        long updVersion;
        long top;
        Worker worker;
        int updIndex;
        CoroutineScheduler $receiver$iv = this;
        do {
            int index;
            if (this.workers[index = (int)((top = $receiver$iv.parkedWorkersStack) & 0x1FFFFFL)] == null) {
                return null;
            }
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
        } while ((updIndex = this.parkedWorkersStackNextIndex(worker)) < 0 || !parkedWorkersStack$FU.compareAndSet(this, top, updVersion | (long)updIndex));
        worker.setNextParkedWorker(NOT_IN_STACK);
        return worker;
    }

    private final int parkedWorkersStackNextIndex(Worker worker) {
        Object next = worker.getNextParkedWorker();
        while (next != NOT_IN_STACK) {
            if (next == null) {
                return 0;
            }
            Worker nextWorker = (Worker)next;
            int updIndex = nextWorker.getIndexInArray();
            if (updIndex != 0) {
                return updIndex;
            }
            next = nextWorker.getNextParkedWorker();
        }
        return -1;
    }

    private final int getCreatedWorkers() {
        return (int)(this.controlState & 0x1FFFFFL);
    }

    private final int getBlockingWorkers() {
        return (int)((this.controlState & 0x3FFFFE00000L) >> 21);
    }

    private final int createdWorkers(long state) {
        return (int)(state & 0x1FFFFFL);
    }

    private final int blockingWorkers(long state) {
        return (int)((state & 0x3FFFFE00000L) >> 21);
    }

    private final int incrementCreatedWorkers() {
        CoroutineScheduler coroutineScheduler = this;
        long state$iv = controlState$FU.incrementAndGet(this);
        return (int)(state$iv & 0x1FFFFFL);
    }

    private final int decrementCreatedWorkers() {
        CoroutineScheduler coroutineScheduler = this;
        long state$iv = controlState$FU.getAndDecrement(this);
        return (int)(state$iv & 0x1FFFFFL);
    }

    private final void incrementBlockingWorkers() {
        controlState$FU.addAndGet(this, 0x200000L);
    }

    private final void decrementBlockingWorkers() {
        controlState$FU.addAndGet(this, -2097152L);
    }

    private final boolean isTerminated() {
        return this._isTerminated != 0;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkParameterIsNotNull(command, "command");
        CoroutineScheduler.dispatch$default(this, command, null, false, 6, null);
    }

    @Override
    public void close() {
        this.shutdown(10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void shutdown(long timeout) {
        boolean bl;
        int n;
        if (!_isTerminated$FU.compareAndSet(this, 0, 1)) {
            return;
        }
        Thread thread2 = Thread.currentThread();
        if (!(thread2 instanceof Worker)) {
            thread2 = null;
        }
        Worker currentWorker = (Worker)thread2;
        Worker[] lock$iv22 = this.workers;
        synchronized (lock$iv22) {
            CoroutineScheduler this_$iv = this;
            n = (int)(this_$iv.controlState & 0x1FFFFFL);
        }
        int created = n;
        int lock$iv22 = 1;
        int n2 = created;
        if (lock$iv22 <= n2) {
            while (true) {
                Worker worker;
                void i;
                if (this.workers[i] == null) {
                    Intrinsics.throwNpe();
                }
                if (worker != currentWorker) {
                    while (worker.isAlive()) {
                        LockSupport.unpark(worker);
                        worker.join(timeout);
                    }
                    WorkerState state = worker.getState();
                    int n3 = n = state == WorkerState.TERMINATED ? 1 : 0;
                    if (n == 0) {
                        String string2 = "Expected TERMINATED state, but found " + (Object)((Object)state);
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    worker.getLocalQueue().offloadAllWork$kotlinx_coroutines_core(this.globalQueue);
                }
                if (i == n2) break;
                ++i;
            }
        }
        this.globalQueue.close();
        while (true) {
            Runnable runnable;
            if ((runnable = currentWorker) == null || (runnable = runnable.findTask$kotlinx_coroutines_core()) == null) {
                runnable = (Task)this.globalQueue.removeFirstOrNull();
            }
            if (runnable == null) {
                break;
            }
            Runnable task = runnable;
            this.runSafely((Task)task);
        }
        Worker worker = currentWorker;
        if (worker != null) {
            worker.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.TERMINATED);
        }
        boolean bl2 = bl = this.cpuPermits.availablePermits() == this.corePoolSize;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        this.parkedWorkersStack = 0L;
        this.controlState = 0L;
    }

    public final void dispatch(@NotNull Runnable block, @NotNull TaskContext taskContext, boolean fair) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        Intrinsics.checkParameterIsNotNull(taskContext, "taskContext");
        TimeSourceKt.getTimeSource().trackTask();
        Task task = this.createTask$kotlinx_coroutines_core(block, taskContext);
        switch (this.submitToLocalQueue(task, fair)) {
            case -1: {
                return;
            }
            case 1: {
                if (!this.globalQueue.addLast(task)) {
                    throw (Throwable)new RejectedExecutionException(this.schedulerName + " was terminated");
                }
                this.requestCpuWorker();
                break;
            }
            default: {
                this.requestCpuWorker();
            }
        }
    }

    public static /* synthetic */ void dispatch$default(CoroutineScheduler coroutineScheduler, Runnable runnable, TaskContext taskContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            taskContext = NonBlockingContext.INSTANCE;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        coroutineScheduler.dispatch(runnable, taskContext, bl);
    }

    @NotNull
    public final Task createTask$kotlinx_coroutines_core(@NotNull Runnable block, @NotNull TaskContext taskContext) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        Intrinsics.checkParameterIsNotNull(taskContext, "taskContext");
        long nanoTime = TasksKt.schedulerTimeSource.nanoTime();
        if (block instanceof Task) {
            ((Task)block).submissionTime = nanoTime;
            ((Task)block).taskContext = taskContext;
            return (Task)block;
        }
        return new TaskImpl(block, nanoTime, taskContext);
    }

    private final void requestCpuWorker() {
        if (this.cpuPermits.availablePermits() == 0) {
            this.tryUnpark();
            return;
        }
        if (this.tryUnpark()) {
            return;
        }
        long state = this.controlState;
        CoroutineScheduler this_$iv = this;
        int created = (int)(state & 0x1FFFFFL);
        CoroutineScheduler this_$iv2 = this;
        int blocking = (int)((state & 0x3FFFFE00000L) >> 21);
        int cpuWorkers = created - blocking;
        if (cpuWorkers < this.corePoolSize) {
            int newCpuWorkers = this.createNewWorker();
            if (newCpuWorkers == 1 && this.corePoolSize > 1) {
                this.createNewWorker();
            }
            if (newCpuWorkers > 0) {
                return;
            }
        }
        this.tryUnpark();
    }

    private final boolean tryUnpark() {
        Worker worker;
        boolean wasParking;
        do {
            if (this.parkedWorkersStackPop() == null) {
                return false;
            }
            worker.idleResetBeforeUnpark();
            wasParking = worker.isParking();
            LockSupport.unpark(worker);
        } while (!wasParking || !worker.tryForbidTermination());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final int createNewWorker() {
        Worker[] lock$iv = this.workers;
        synchronized (lock$iv) {
            boolean bl;
            void this_$iv;
            int cpuWorkers;
            block10: {
                int created;
                block9: {
                    block8: {
                        if (!this.isTerminated()) break block8;
                        int n = -1;
                        return n;
                    }
                    long state = this.controlState;
                    CoroutineScheduler this_$iv2 = this;
                    created = (int)(state & 0x1FFFFFL);
                    CoroutineScheduler this_$iv3 = this;
                    int blocking = (int)((state & 0x3FFFFE00000L) >> 21);
                    cpuWorkers = created - blocking;
                    if (cpuWorkers < this.corePoolSize) break block9;
                    int n = 0;
                    return n;
                }
                if (created < this.maxPoolSize && this.cpuPermits.availablePermits() != 0) break block10;
                int n = 0;
                return n;
            }
            CoroutineScheduler this_$iv4 = this;
            int newIndex = (int)(this_$iv4.controlState & 0x1FFFFFL) + 1;
            boolean bl2 = this_$iv4 = newIndex > 0 && this.workers[newIndex] == null;
            if (!this_$iv4) {
                String $i$f$getCreatedWorkers = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException($i$f$getCreatedWorkers.toString());
            }
            Object $i$f$getCreatedWorkers = new Worker(newIndex);
            Worker $receiver = $i$f$getCreatedWorkers;
            $receiver.start();
            Worker worker = $i$f$getCreatedWorkers;
            $i$f$getCreatedWorkers = this;
            int n = newIndex;
            $receiver = this_$iv;
            long state$iv$iv = controlState$FU.incrementAndGet(this_$iv);
            int n2 = (int)(state$iv$iv & 0x1FFFFFL);
            boolean bl3 = bl = n == n2;
            if (!bl) {
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            this.workers[newIndex] = worker;
            int n3 = cpuWorkers + 1;
            return n3;
        }
    }

    private final int submitToLocalQueue(Task task, boolean fair) {
        boolean noOffloadingHappened;
        Thread thread2 = Thread.currentThread();
        if (!(thread2 instanceof Worker)) {
            thread2 = null;
        }
        Worker worker = (Worker)thread2;
        if (worker == null) {
            return 1;
        }
        Worker worker2 = worker;
        if (worker2.getScheduler() != this) {
            return 1;
        }
        if (worker2.getState() == WorkerState.TERMINATED) {
            return 1;
        }
        int result2 = -1;
        if (task.getMode() == TaskMode.NON_BLOCKING) {
            if (worker2.isBlocking()) {
                result2 = 0;
            } else {
                boolean hasPermit = worker2.tryAcquireCpuPermit();
                if (!hasPermit) {
                    return 1;
                }
            }
        }
        boolean bl = noOffloadingHappened = fair ? worker2.getLocalQueue().addLast(task, this.globalQueue) : worker2.getLocalQueue().add(task, this.globalQueue);
        if (noOffloadingHappened) {
            if (worker2.getLocalQueue().getBufferSize$kotlinx_coroutines_core() > TasksKt.QUEUE_SIZE_OFFLOAD_THRESHOLD) {
                return 0;
            }
            return result2;
        }
        return 0;
    }

    @NotNull
    public String toString() {
        int parkedWorkers = 0;
        int blockingWorkers = 0;
        int cpuWorkers = 0;
        int retired = 0;
        int terminated = 0;
        ArrayList queueSizes = new ArrayList();
        block7: for (Worker worker : this.workers) {
            if (worker == null) continue;
            int queueSize = worker.getLocalQueue().size$kotlinx_coroutines_core();
            switch (CoroutineScheduler$WhenMappings.$EnumSwitchMapping$0[worker.getState().ordinal()]) {
                case 1: {
                    ++parkedWorkers;
                    continue block7;
                }
                case 2: {
                    ++blockingWorkers;
                    Collection collection = queueSizes;
                    String string2 = String.valueOf(queueSize) + "b";
                    collection.add(string2);
                    continue block7;
                }
                case 3: {
                    ++cpuWorkers;
                    Collection collection = queueSizes;
                    String string2 = String.valueOf(queueSize) + "c";
                    collection.add(string2);
                    continue block7;
                }
                case 4: {
                    ++retired;
                    if (queueSize <= 0) continue block7;
                    Collection collection = queueSizes;
                    String string2 = String.valueOf(queueSize) + "r";
                    collection.add(string2);
                    continue block7;
                }
                case 5: {
                    ++terminated;
                }
            }
        }
        long state = this.controlState;
        CoroutineScheduler coroutineScheduler = this;
        StringBuilder stringBuilder = new StringBuilder().append(this.schedulerName).append('@').append(DebugKt.getHexAddress(this)).append('[').append("Pool Size {").append("core = ").append(this.corePoolSize).append(", ").append("max = ").append(this.maxPoolSize).append("}, ").append("Worker States {").append("CPU = ").append(cpuWorkers).append(", ").append("blocking = ").append(blockingWorkers).append(", ").append("parked = ").append(parkedWorkers).append(", ").append("retired = ").append(retired).append(", ").append("terminated = ").append(terminated).append("}, ").append("running workers queues = ").append(queueSizes).append(", ").append("global queue size = ").append(this.globalQueue.getSize()).append(", ").append("Control State Workers {").append("created = ");
        int n = (int)(state & 0x1FFFFFL);
        CoroutineScheduler coroutineScheduler2 = this;
        stringBuilder = stringBuilder.append(n).append(", ").append("blocking = ");
        n = (int)((state & 0x3FFFFE00000L) >> 21);
        return stringBuilder.append(n).append('}').append("]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runSafely(Task task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            Thread thread2;
            Thread thread3 = thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull(thread3, "thread");
            thread3.getUncaughtExceptionHandler().uncaughtException(thread2, e);
        }
        finally {
            TimeSourceKt.getTimeSource().unTrackTask();
        }
    }

    public CoroutineScheduler(int corePoolSize, int maxPoolSize, long idleWorkerKeepAliveNs, @NotNull String schedulerName) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(schedulerName, "schedulerName");
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.idleWorkerKeepAliveNs = idleWorkerKeepAliveNs;
        this.schedulerName = schedulerName;
        boolean bl2 = bl = this.corePoolSize >= 1;
        if (!bl) {
            String string2 = "Core pool size " + this.corePoolSize + " should be at least 1";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        boolean bl3 = bl = this.maxPoolSize >= this.corePoolSize;
        if (!bl) {
            String string3 = "Max pool size " + this.maxPoolSize + " should be greater than or equals to core pool size " + this.corePoolSize;
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        boolean bl4 = bl = this.maxPoolSize <= 0x1FFFFE;
        if (!bl) {
            String string4 = "Max pool size " + this.maxPoolSize + " should not exceed maximal supported number of threads 2097150";
            throw (Throwable)new IllegalArgumentException(string4.toString());
        }
        boolean bl5 = bl = this.idleWorkerKeepAliveNs > 0L;
        if (!bl) {
            String string5 = "Idle worker keep alive time " + this.idleWorkerKeepAliveNs + " must be positive";
            throw (Throwable)new IllegalArgumentException(string5.toString());
        }
        this.globalQueue = new GlobalQueue();
        this.cpuPermits = new Semaphore(this.corePoolSize, false);
        this.parkedWorkersStack = 0L;
        this.workers = new Worker[this.maxPoolSize + 1];
        this.controlState = 0L;
        this.random = new Random();
        this._isTerminated = 0;
    }

    public /* synthetic */ CoroutineScheduler(int n, int n2, long l, String string2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            l = TasksKt.IDLE_WORKER_KEEP_ALIVE_NS;
        }
        if ((n3 & 8) != 0) {
            string2 = "DefaultDispatcher";
        }
        this(n, n2, l, string2);
    }

    public static final /* synthetic */ void access$incrementBlockingWorkers(CoroutineScheduler $this) {
        $this.incrementBlockingWorkers();
    }

    public static final /* synthetic */ void access$decrementBlockingWorkers(CoroutineScheduler $this) {
        $this.decrementBlockingWorkers();
    }

    public static final /* synthetic */ int access$decrementCreatedWorkers(CoroutineScheduler $this) {
        return $this.decrementCreatedWorkers();
    }

    public static final /* synthetic */ int access$createdWorkers(CoroutineScheduler $this, long state) {
        return $this.createdWorkers(state);
    }

    static {
        Companion = new Companion(null);
        MAX_PARK_TIME_NS = (int)TimeUnit.SECONDS.toNanos(1L);
        MIN_PARK_TIME_NS = (int)RangesKt.coerceAtMost(RangesKt.coerceAtLeast(TasksKt.WORK_STEALING_TIME_RESOLUTION_NS / (long)4, 10L), (long)MAX_PARK_TIME_NS);
        NOT_IN_STACK = new Symbol("NOT_IN_STACK");
        parkedWorkersStack$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "parkedWorkersStack");
        controlState$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "controlState");
        _isTerminated$FU = AtomicIntegerFieldUpdater.newUpdater(CoroutineScheduler.class, "_isTerminated");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0080\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00101\u001a\u00020\u0010H\u0002J\b\u00102\u001a\u00020\fH\u0002J\b\u00103\u001a\u00020-H\u0002J\b\u00104\u001a\u00020-H\u0002J\u0010\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020\u0010H\u0002J\u000f\u00107\u001a\u0004\u0018\u000108H\u0000\u00a2\u0006\u0002\b9J\n\u0010:\u001a\u0004\u0018\u000108H\u0002J\u0010\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020/H\u0002J\u0006\u0010=\u001a\u00020-J\u0015\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b@J\b\u0010A\u001a\u00020-H\u0016J\u0006\u0010B\u001a\u00020\fJ\u0006\u0010C\u001a\u00020\fJ\u0015\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020$H\u0000\u00a2\u0006\u0002\bFJ\n\u0010G\u001a\u0004\u0018\u000108H\u0002J\b\u0010H\u001a\u00020-H\u0002R$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "Ljava/lang/Thread;", "index", "", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler;I)V", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler;)V", "indexInArray", "getIndexInArray", "()I", "setIndexInArray", "(I)V", "isBlocking", "", "()Z", "isParking", "lastExhaustionTime", "", "lastStealIndex", "localQueue", "Lkotlinx/coroutines/scheduling/WorkQueue;", "getLocalQueue", "()Lkotlinx/coroutines/scheduling/WorkQueue;", "nextParkedWorker", "", "getNextParkedWorker", "()Ljava/lang/Object;", "setNextParkedWorker", "(Ljava/lang/Object;)V", "parkTimeNs", "rngState", "scheduler", "Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "getScheduler", "()Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "spins", "state", "Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "getState", "()Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "setState", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;)V", "terminationDeadline", "terminationState", "Lkotlinx/atomicfu/AtomicInt;", "afterTask", "", "taskMode", "Lkotlinx/coroutines/scheduling/TaskMode;", "beforeTask", "taskSubmissionTime", "blockingQuiescence", "blockingWorkerIdle", "cpuWorkerIdle", "doPark", "nanos", "findTask", "Lkotlinx/coroutines/scheduling/Task;", "findTask$kotlinx_coroutines_core", "findTaskWithCpuPermit", "idleReset", "mode", "idleResetBeforeUnpark", "nextInt", "upperBound", "nextInt$kotlinx_coroutines_core", "run", "tryAcquireCpuPermit", "tryForbidTermination", "tryReleaseCpu", "newState", "tryReleaseCpu$kotlinx_coroutines_core", "trySteal", "tryTerminateWorker", "kotlinx-coroutines-core"})
    public final class Worker
    extends Thread {
        private volatile int indexInArray;
        @NotNull
        private final WorkQueue localQueue;
        @NotNull
        private volatile WorkerState state;
        private volatile int terminationState;
        private static final AtomicIntegerFieldUpdater terminationState$FU = AtomicIntegerFieldUpdater.newUpdater(Worker.class, "terminationState");
        private long terminationDeadline;
        @Nullable
        private volatile Object nextParkedWorker;
        private long lastExhaustionTime;
        private volatile int spins;
        private int parkTimeNs;
        private int rngState;
        private int lastStealIndex;

        public final int getIndexInArray() {
            return this.indexInArray;
        }

        public final void setIndexInArray(int index) {
            this.setName(CoroutineScheduler.this.schedulerName + "-worker-" + (index == 0 ? "TERMINATED" : String.valueOf(index)));
            this.indexInArray = index;
        }

        @NotNull
        public final CoroutineScheduler getScheduler() {
            return CoroutineScheduler.this;
        }

        @NotNull
        public final WorkQueue getLocalQueue() {
            return this.localQueue;
        }

        @NotNull
        public final WorkerState getState() {
            return this.state;
        }

        public final void setState(@NotNull WorkerState workerState) {
            Intrinsics.checkParameterIsNotNull((Object)workerState, "<set-?>");
            this.state = workerState;
        }

        public final boolean isParking() {
            return this.state == WorkerState.PARKING;
        }

        public final boolean isBlocking() {
            return this.state == WorkerState.BLOCKING;
        }

        @Nullable
        public final Object getNextParkedWorker() {
            return this.nextParkedWorker;
        }

        public final void setNextParkedWorker(@Nullable Object object) {
            this.nextParkedWorker = object;
        }

        public final boolean tryForbidTermination() {
            boolean bl;
            int state = this.terminationState;
            switch (state) {
                case 1: {
                    bl = false;
                    break;
                }
                case -1: {
                    bl = false;
                    break;
                }
                case 0: {
                    bl = terminationState$FU.compareAndSet(this, 0, -1);
                    break;
                }
                default: {
                    String string2 = "Invalid terminationState = " + state;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
            }
            return bl;
        }

        public final boolean tryAcquireCpuPermit() {
            boolean bl;
            if (this.state == WorkerState.CPU_ACQUIRED) {
                bl = true;
            } else if (CoroutineScheduler.this.cpuPermits.tryAcquire()) {
                this.state = WorkerState.CPU_ACQUIRED;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean tryReleaseCpu$kotlinx_coroutines_core(@NotNull WorkerState newState) {
            boolean hadCpu;
            Intrinsics.checkParameterIsNotNull((Object)newState, "newState");
            WorkerState previousState = this.state;
            boolean bl = hadCpu = previousState == WorkerState.CPU_ACQUIRED;
            if (hadCpu) {
                CoroutineScheduler.this.cpuPermits.release();
            }
            if (previousState != newState) {
                this.state = newState;
            }
            return hadCpu;
        }

        @Override
        public void run() {
            boolean wasIdle = false;
            while (!CoroutineScheduler.this.isTerminated() && this.state != WorkerState.TERMINATED) {
                Task task = this.findTask$kotlinx_coroutines_core();
                if (task == null) {
                    if (this.state == WorkerState.CPU_ACQUIRED) {
                        this.cpuWorkerIdle();
                    } else {
                        this.blockingWorkerIdle();
                    }
                    wasIdle = true;
                    continue;
                }
                TaskMode taskMode = task.getMode();
                if (wasIdle) {
                    this.idleReset(taskMode);
                    wasIdle = false;
                }
                this.beforeTask(taskMode, task.submissionTime);
                CoroutineScheduler.this.runSafely(task);
                this.afterTask(taskMode);
            }
            this.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.TERMINATED);
        }

        private final void beforeTask(TaskMode taskMode, long taskSubmissionTime) {
            if (taskMode != TaskMode.NON_BLOCKING) {
                CoroutineScheduler this_$iv = CoroutineScheduler.this;
                controlState$FU.addAndGet(this_$iv, 0x200000L);
                if (this.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.BLOCKING)) {
                    CoroutineScheduler.this.requestCpuWorker();
                }
                return;
            }
            if (CoroutineScheduler.this.cpuPermits.availablePermits() == 0) {
                return;
            }
            long now = TasksKt.schedulerTimeSource.nanoTime();
            if (now - taskSubmissionTime >= TasksKt.WORK_STEALING_TIME_RESOLUTION_NS && now - this.lastExhaustionTime >= TasksKt.WORK_STEALING_TIME_RESOLUTION_NS * (long)5) {
                this.lastExhaustionTime = now;
                CoroutineScheduler.this.requestCpuWorker();
            }
        }

        private final void afterTask(TaskMode taskMode) {
            if (taskMode != TaskMode.NON_BLOCKING) {
                CoroutineScheduler this_$iv = CoroutineScheduler.this;
                controlState$FU.addAndGet(this_$iv, -2097152L);
                WorkerState currentState = this.state;
                if (currentState != WorkerState.TERMINATED) {
                    boolean bl;
                    boolean bl2 = bl = currentState == WorkerState.BLOCKING;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Expected BLOCKING state, but has " + (Object)((Object)currentState);
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    this.state = WorkerState.RETIRING;
                }
            }
        }

        public final int nextInt$kotlinx_coroutines_core(int upperBound) {
            this.rngState ^= this.rngState << 13;
            this.rngState ^= this.rngState >> 17;
            this.rngState ^= this.rngState << 5;
            int mask = upperBound - 1;
            if ((mask & upperBound) == 0) {
                return this.rngState & mask;
            }
            return (this.rngState & Integer.MAX_VALUE) % upperBound;
        }

        private final void cpuWorkerIdle() {
            int spins = this.spins;
            if (spins <= 1500) {
                this.spins = spins + 1;
                if (spins >= 1000) {
                    Thread.yield();
                }
            } else {
                if (this.parkTimeNs < MAX_PARK_TIME_NS) {
                    this.parkTimeNs = RangesKt.coerceAtMost(this.parkTimeNs * 3 >>> 1, MAX_PARK_TIME_NS);
                }
                this.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.PARKING);
                this.doPark(this.parkTimeNs);
            }
        }

        private final void blockingWorkerIdle() {
            this.tryReleaseCpu$kotlinx_coroutines_core(WorkerState.PARKING);
            if (!this.blockingQuiescence()) {
                return;
            }
            this.terminationState = 0;
            if (this.terminationDeadline == 0L) {
                this.terminationDeadline = System.nanoTime() + CoroutineScheduler.this.idleWorkerKeepAliveNs;
            }
            this.doPark(CoroutineScheduler.this.idleWorkerKeepAliveNs);
            if (System.nanoTime() - this.terminationDeadline >= 0L) {
                this.terminationDeadline = 0L;
                this.tryTerminateWorker();
            }
        }

        private final void doPark(long nanos) {
            CoroutineScheduler.this.parkedWorkersStackPush(this);
            LockSupport.parkNanos(nanos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void tryTerminateWorker() {
            Worker[] lock$iv = CoroutineScheduler.this.workers;
            synchronized (lock$iv) {
                CoroutineScheduler this_$iv;
                if (CoroutineScheduler.this.isTerminated()) {
                    return;
                }
                if (CoroutineScheduler.this.getCreatedWorkers() <= CoroutineScheduler.this.corePoolSize) {
                    return;
                }
                if (!this.blockingQuiescence()) {
                    return;
                }
                if (!terminationState$FU.compareAndSet(this, 0, 1)) {
                    return;
                }
                int oldIndex = this.indexInArray;
                this.setIndexInArray(0);
                CoroutineScheduler.this.parkedWorkersStackTopUpdate(this, oldIndex, 0);
                CoroutineScheduler coroutineScheduler = this_$iv = CoroutineScheduler.this;
                long state$iv$iv = controlState$FU.getAndDecrement(this_$iv);
                int lastIndex = (int)(state$iv$iv & 0x1FFFFFL);
                if (lastIndex != oldIndex) {
                    Worker lastWorker;
                    Worker worker = CoroutineScheduler.this.workers[lastIndex];
                    if (worker == null) {
                        Intrinsics.throwNpe();
                    }
                    ((CoroutineScheduler)CoroutineScheduler.this).workers[oldIndex] = lastWorker = worker;
                    lastWorker.setIndexInArray(oldIndex);
                    CoroutineScheduler.this.parkedWorkersStackTopUpdate(lastWorker, lastIndex, oldIndex);
                }
                ((CoroutineScheduler)CoroutineScheduler.this).workers[lastIndex] = null;
                Unit unit = Unit.INSTANCE;
            }
            this.state = WorkerState.TERMINATED;
        }

        private final boolean blockingQuiescence() {
            Task task = CoroutineScheduler.this.globalQueue.removeFirstBlockingModeOrNull();
            if (task != null) {
                Task task2;
                Task it = task2 = task;
                this.localQueue.add(it, CoroutineScheduler.this.globalQueue);
                return false;
            }
            return true;
        }

        private final void idleReset(TaskMode mode2) {
            this.terminationDeadline = 0L;
            this.lastStealIndex = 0;
            if (this.state == WorkerState.PARKING) {
                boolean bl;
                boolean bl2 = bl = mode2 == TaskMode.PROBABLY_BLOCKING;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                this.state = WorkerState.BLOCKING;
                this.parkTimeNs = MIN_PARK_TIME_NS;
            }
            this.spins = 0;
        }

        public final void idleResetBeforeUnpark() {
            this.parkTimeNs = MIN_PARK_TIME_NS;
            this.spins = 0;
        }

        @Nullable
        public final Task findTask$kotlinx_coroutines_core() {
            if (this.tryAcquireCpuPermit()) {
                return this.findTaskWithCpuPermit();
            }
            Task task = this.localQueue.poll();
            if (task == null) {
                task = CoroutineScheduler.this.globalQueue.removeFirstBlockingModeOrNull();
            }
            return task;
        }

        private final Task findTaskWithCpuPermit() {
            boolean globalFirst;
            boolean bl = globalFirst = this.nextInt$kotlinx_coroutines_core(2 * CoroutineScheduler.this.corePoolSize) == 0;
            if (globalFirst) {
                Task task = (Task)CoroutineScheduler.this.globalQueue.removeFirstOrNull();
                if (task != null) {
                    Task task2;
                    Task it = task2 = task;
                    return it;
                }
            }
            Task task = this.localQueue.poll();
            if (task != null) {
                Task task3;
                Task it = task3 = task;
                return it;
            }
            if (!globalFirst) {
                Task task4 = (Task)CoroutineScheduler.this.globalQueue.removeFirstOrNull();
                if (task4 != null) {
                    Task task5;
                    Task it = task5 = task4;
                    return it;
                }
            }
            return this.trySteal();
        }

        private final Task trySteal() {
            int created = CoroutineScheduler.this.getCreatedWorkers();
            if (created < 2) {
                return null;
            }
            int stealIndex = this.lastStealIndex;
            if (stealIndex == 0) {
                stealIndex = this.nextInt$kotlinx_coroutines_core(created);
            }
            if (++stealIndex > created) {
                stealIndex = 1;
            }
            this.lastStealIndex = stealIndex;
            Worker worker = CoroutineScheduler.this.workers[stealIndex];
            if (worker != null && worker != this && this.localQueue.trySteal(worker.localQueue, CoroutineScheduler.this.globalQueue)) {
                return this.localQueue.poll();
            }
            return null;
        }

        private Worker() {
            this.setDaemon(true);
            this.localQueue = new WorkQueue();
            this.state = WorkerState.RETIRING;
            this.terminationState = 0;
            this.nextParkedWorker = NOT_IN_STACK;
            this.parkTimeNs = MIN_PARK_TIME_NS;
            this.rngState = CoroutineScheduler.this.random.nextInt();
        }

        public Worker(int index) {
            this();
            this.setIndexInArray(index);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "", "(Ljava/lang/String;I)V", "CPU_ACQUIRED", "BLOCKING", "PARKING", "RETIRING", "TERMINATED", "kotlinx-coroutines-core"})
    public static final class WorkerState
    extends Enum<WorkerState> {
        public static final /* enum */ WorkerState CPU_ACQUIRED;
        public static final /* enum */ WorkerState BLOCKING;
        public static final /* enum */ WorkerState PARKING;
        public static final /* enum */ WorkerState RETIRING;
        public static final /* enum */ WorkerState TERMINATED;
        private static final /* synthetic */ WorkerState[] $VALUES;

        static {
            WorkerState[] workerStateArray = new WorkerState[5];
            WorkerState[] workerStateArray2 = workerStateArray;
            workerStateArray[0] = CPU_ACQUIRED = new WorkerState();
            workerStateArray[1] = BLOCKING = new WorkerState();
            workerStateArray[2] = PARKING = new WorkerState();
            workerStateArray[3] = RETIRING = new WorkerState();
            workerStateArray[4] = TERMINATED = new WorkerState();
            $VALUES = workerStateArray;
        }

        public static WorkerState[] values() {
            return (WorkerState[])$VALUES.clone();
        }

        public static WorkerState valueOf(String string2) {
            return Enum.valueOf(WorkerState.class, string2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0002R\u000e\u0010\u0013\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler$Companion;", "", "()V", "ADDED", "", "ADDED_REQUIRES_HELP", "ALLOWED", "BLOCKING_MASK", "", "BLOCKING_SHIFT", "CREATED_MASK", "FORBIDDEN", "MAX_PARK_TIME_NS", "MAX_PARK_TIME_NS$annotations", "MAX_SPINS", "MAX_SUPPORTED_POOL_SIZE", "MAX_YIELDS", "MIN_PARK_TIME_NS", "MIN_PARK_TIME_NS$annotations", "MIN_SUPPORTED_POOL_SIZE", "NOT_ADDED", "NOT_IN_STACK", "Lkotlinx/coroutines/internal/Symbol;", "PARKED_INDEX_MASK", "PARKED_VERSION_INC", "PARKED_VERSION_MASK", "TERMINATED", "kotlinx-coroutines-core"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void MAX_PARK_TIME_NS$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void MIN_PARK_TIME_NS$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

