/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.DefaultExecutor;
import kotlinx.coroutines.Delay;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.EventLoop;
import kotlinx.coroutines.EventLoopKt;
import kotlinx.coroutines.TimeSourceKt;
import kotlinx.coroutines.internal.LockFreeTaskQueueCore;
import kotlinx.coroutines.internal.ThreadSafeHeap;
import kotlinx.coroutines.internal.ThreadSafeHeapNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0003345B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0004J\u0010\u0010\u0017\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u0018j\u0002`\u0019H\u0016J\u0014\u0010\u001e\u001a\u00020\f2\n\u0010\u001f\u001a\u00060\u0018j\u0002`\u0019H\u0002J\u0019\u0010 \u001a\u00020\u00162\n\u0010\u001f\u001a\u00060\u0018j\u0002`\u0019H\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\fH$J\b\u0010#\u001a\u00020\u0012H\u0016J\u0015\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020\u0016H\u0004J\b\u0010(\u001a\u00020\u0016H\u0004J\u0015\u0010)\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020,2\u0006\u0010%\u001a\u00020\bH\u0002J\u001e\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00122\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001600H\u0016J\u0010\u00101\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\b\u00102\u001a\u00020\u0016H$R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00066"}, d2={"Lkotlinx/coroutines/EventLoopBase;", "Lkotlinx/coroutines/CoroutineDispatcher;", "Lkotlinx/coroutines/Delay;", "Lkotlinx/coroutines/EventLoop;", "()V", "_delayed", "Lkotlinx/atomicfu/AtomicRef;", "Lkotlinx/coroutines/internal/ThreadSafeHeap;", "Lkotlinx/coroutines/EventLoopBase$DelayedTask;", "_queue", "", "isCompleted", "", "()Z", "isDelayedEmpty", "isEmpty", "isQueueEmpty", "nextTime", "", "getNextTime", "()J", "closeQueue", "", "dequeue", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "dispatch", "context", "Lkotlin/coroutines/CoroutineContext;", "block", "enqueueImpl", "task", "execute", "execute$kotlinx_coroutines_core", "isCorrectThread", "processNextEvent", "removeDelayedImpl", "delayedTask", "removeDelayedImpl$kotlinx_coroutines_core", "rescheduleAllDelayed", "resetAll", "schedule", "schedule$kotlinx_coroutines_core", "scheduleImpl", "", "scheduleResumeAfterDelay", "timeMillis", "continuation", "Lkotlinx/coroutines/CancellableContinuation;", "shouldUnpark", "unpark", "DelayedResumeTask", "DelayedRunnableTask", "DelayedTask", "kotlinx-coroutines-core"})
public abstract class EventLoopBase
extends CoroutineDispatcher
implements Delay,
EventLoop {
    private volatile Object _queue = null;
    private static final AtomicReferenceFieldUpdater _queue$FU = AtomicReferenceFieldUpdater.newUpdater(EventLoopBase.class, Object.class, "_queue");
    private volatile Object _delayed = null;
    private static final AtomicReferenceFieldUpdater _delayed$FU = AtomicReferenceFieldUpdater.newUpdater(EventLoopBase.class, Object.class, "_delayed");

    protected abstract boolean isCompleted();

    protected abstract void unpark();

    protected abstract boolean isCorrectThread();

    protected final boolean isEmpty() {
        return this.isQueueEmpty() && this.isDelayedEmpty();
    }

    private final boolean isQueueEmpty() {
        Object queue = this._queue;
        Object object = queue;
        return object == null ? true : (object instanceof LockFreeTaskQueueCore ? ((LockFreeTaskQueueCore)queue).isEmpty() : queue == EventLoopKt.access$getCLOSED_EMPTY$p());
    }

    private final boolean isDelayedEmpty() {
        ThreadSafeHeap delayed = (ThreadSafeHeap)this._delayed;
        return delayed == null || delayed.isEmpty();
    }

    private final long getNextTime() {
        Object queue = this._queue;
        if (queue != null) {
            if (queue instanceof LockFreeTaskQueueCore) {
                if (!((LockFreeTaskQueueCore)queue).isEmpty()) {
                    return 0L;
                }
            } else {
                if (queue == EventLoopKt.access$getCLOSED_EMPTY$p()) {
                    return Long.MAX_VALUE;
                }
                return 0L;
            }
        }
        ThreadSafeHeap threadSafeHeap = (ThreadSafeHeap)this._delayed;
        if (threadSafeHeap == null) {
            return Long.MAX_VALUE;
        }
        ThreadSafeHeap delayed = threadSafeHeap;
        DelayedTask delayedTask = (DelayedTask)delayed.peek();
        if (delayedTask == null) {
            return Long.MAX_VALUE;
        }
        DelayedTask nextDelayedTask = delayedTask;
        return RangesKt.coerceAtLeast(nextDelayedTask.nanoTime - TimeSourceKt.getTimeSource().nanoTime(), 0L);
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(block, "block");
        this.execute$kotlinx_coroutines_core(block);
    }

    @Override
    public void scheduleResumeAfterDelay(long timeMillis, @NotNull CancellableContinuation<? super Unit> continuation2) {
        Intrinsics.checkParameterIsNotNull(continuation2, "continuation");
        this.schedule$kotlinx_coroutines_core(new DelayedResumeTask(timeMillis, continuation2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long processNextEvent() {
        block8: {
            if (!this.isCorrectThread()) {
                return Long.MAX_VALUE;
            }
            ThreadSafeHeap delayed = (ThreadSafeHeap)this._delayed;
            if (delayed != null && !delayed.isEmpty()) {
                long now = TimeSourceKt.getTimeSource().nanoTime();
                while (true) {
                    Object v0;
                    ThreadSafeHeap this_$iv;
                    ThreadSafeHeap lock$iv$iv = this_$iv = delayed;
                    synchronized (lock$iv$iv) {
                        Object t2;
                        block7: {
                            if (this_$iv.firstImpl() != null) break block7;
                            Object var6_5 = null;
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 4, 6] lbl13 : MonitorExitStatement: MONITOREXIT : lock$iv$iv
                            v0 = var6_5;
                        }
                        Object first$iv = t2;
                        DelayedTask it = (DelayedTask)first$iv;
                        Object var10_8 = (it.timeToExecute(now) ? this.enqueueImpl(it) : false) ? this_$iv.removeAtImpl(0) : null;
                        // MONITOREXIT @DISABLED, blocks:[1, 2, 4, 6] lbl20 : MonitorExitStatement: MONITOREXIT : lock$iv$iv
                        v0 = var10_8;
                    }
                    if ((DelayedTask)v0 != null) continue;
                    break;
                }
            }
            Runnable runnable = this.dequeue();
            if (runnable == null) break block8;
            runnable.run();
        }
        return this.getNextTime();
    }

    public final void execute$kotlinx_coroutines_core(@NotNull Runnable task) {
        Intrinsics.checkParameterIsNotNull(task, "task");
        if (this.enqueueImpl(task)) {
            this.unpark();
        } else {
            DefaultExecutor.INSTANCE.execute$kotlinx_coroutines_core(task);
        }
    }

    private final boolean enqueueImpl(Runnable task) {
        EventLoopBase $receiver$iv = this;
        while (true) {
            Object queue = $receiver$iv._queue;
            if (this.isCompleted()) {
                return false;
            }
            Object object = queue;
            if (object == null) {
                if (!_queue$FU.compareAndSet(this, null, task)) continue;
                return true;
            }
            if (object instanceof LockFreeTaskQueueCore) {
                Object object2 = queue;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlinx.coroutines.Queue<kotlinx.coroutines.Runnable /* = java.lang.Runnable */> /* = kotlinx.coroutines.internal.LockFreeTaskQueueCore<kotlinx.coroutines.Runnable /* = java.lang.Runnable */> */");
                }
                switch (((LockFreeTaskQueueCore)object2).addLast(task)) {
                    case 0: {
                        return true;
                    }
                    case 2: {
                        return false;
                    }
                    case 1: {
                        _queue$FU.compareAndSet(this, queue, ((LockFreeTaskQueueCore)queue).next());
                    }
                }
                continue;
            }
            if (queue == EventLoopKt.access$getCLOSED_EMPTY$p()) {
                return false;
            }
            LockFreeTaskQueueCore<Runnable> newQueue = new LockFreeTaskQueueCore<Runnable>(8, true);
            Object object3 = queue;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlinx.coroutines.Runnable /* = java.lang.Runnable */");
            }
            newQueue.addLast((Runnable)object3);
            newQueue.addLast(task);
            if (_queue$FU.compareAndSet(this, queue, newQueue)) break;
        }
        return true;
    }

    private final Runnable dequeue() {
        Object queue;
        EventLoopBase $receiver$iv = this;
        while (true) {
            Object object;
            if ((object = (queue = $receiver$iv._queue)) == null) {
                return null;
            }
            if (object instanceof LockFreeTaskQueueCore) {
                Object object2 = queue;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlinx.coroutines.Queue<kotlinx.coroutines.Runnable /* = java.lang.Runnable */> /* = kotlinx.coroutines.internal.LockFreeTaskQueueCore<kotlinx.coroutines.Runnable /* = java.lang.Runnable */> */");
                }
                Object result2 = ((LockFreeTaskQueueCore)object2).removeFirstOrNull();
                if (result2 != LockFreeTaskQueueCore.REMOVE_FROZEN) {
                    return (Runnable)result2;
                }
                _queue$FU.compareAndSet(this, queue, ((LockFreeTaskQueueCore)queue).next());
                continue;
            }
            if (queue == EventLoopKt.access$getCLOSED_EMPTY$p()) {
                return null;
            }
            if (_queue$FU.compareAndSet(this, queue, null)) break;
        }
        Object object = queue;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.coroutines.Runnable /* = java.lang.Runnable */");
        }
        return (Runnable)object;
    }

    protected final void closeQueue() {
        boolean bl = this.isCompleted();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        EventLoopBase $receiver$iv = this;
        while (true) {
            Object queue;
            Object object;
            if ((object = (queue = $receiver$iv._queue)) == null) {
                if (!_queue$FU.compareAndSet(this, null, EventLoopKt.access$getCLOSED_EMPTY$p())) continue;
                return;
            }
            if (object instanceof LockFreeTaskQueueCore) {
                ((LockFreeTaskQueueCore)queue).close();
                return;
            }
            if (queue == EventLoopKt.access$getCLOSED_EMPTY$p()) {
                return;
            }
            LockFreeTaskQueueCore<Runnable> newQueue = new LockFreeTaskQueueCore<Runnable>(8, true);
            Object object2 = queue;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlinx.coroutines.Runnable /* = java.lang.Runnable */");
            }
            newQueue.addLast((Runnable)object2);
            if (_queue$FU.compareAndSet(this, queue, newQueue)) break;
        }
    }

    public final void schedule$kotlinx_coroutines_core(@NotNull DelayedTask delayedTask) {
        Intrinsics.checkParameterIsNotNull(delayedTask, "delayedTask");
        switch (this.scheduleImpl(delayedTask)) {
            case 0: {
                if (!this.shouldUnpark(delayedTask)) break;
                this.unpark();
                break;
            }
            case 1: {
                DefaultExecutor.INSTANCE.schedule$kotlinx_coroutines_core(delayedTask);
                break;
            }
            case 2: {
                break;
            }
            default: {
                String string2 = "unexpected result";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
    }

    private final boolean shouldUnpark(DelayedTask task) {
        ThreadSafeHeap threadSafeHeap = (ThreadSafeHeap)this._delayed;
        return (threadSafeHeap != null ? (DelayedTask)threadSafeHeap.peek() : null) == task;
    }

    private final int scheduleImpl(DelayedTask delayedTask) {
        if (this.isCompleted()) {
            return 1;
        }
        ThreadSafeHeap threadSafeHeap = (ThreadSafeHeap)this._delayed;
        if (threadSafeHeap == null) {
            EventLoopBase eventLoopBase;
            EventLoopBase $receiver = eventLoopBase = this;
            _delayed$FU.compareAndSet($receiver, null, new ThreadSafeHeap());
            Object object = $receiver._delayed;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            threadSafeHeap = (ThreadSafeHeap)object;
        }
        ThreadSafeHeap delayed = threadSafeHeap;
        return delayedTask.schedule(delayed, this);
    }

    public final void removeDelayedImpl$kotlinx_coroutines_core(@NotNull DelayedTask delayedTask) {
        block0: {
            Intrinsics.checkParameterIsNotNull(delayedTask, "delayedTask");
            ThreadSafeHeap threadSafeHeap = (ThreadSafeHeap)this._delayed;
            if (threadSafeHeap == null) break block0;
            threadSafeHeap.remove((ThreadSafeHeapNode)delayedTask);
        }
    }

    protected final void resetAll() {
        this._queue = null;
        this._delayed = null;
    }

    protected final void rescheduleAllDelayed() {
        Object object;
        while ((object = (ThreadSafeHeap)this._delayed) != null && (object = (DelayedTask)((ThreadSafeHeap)object).removeFirstOrNull()) != null) {
            Object delayedTask = object;
            ((DelayedTask)delayedTask).rescheduleOnShutdown();
        }
    }

    @Override
    @Nullable
    public Object delay(long time, @NotNull Continuation<? super Unit> continuation2) {
        return Delay.DefaultImpls.delay(this, time, continuation2);
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long timeMillis, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        return Delay.DefaultImpls.invokeOnTimeout(this, timeMillis, block);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b \u0018\u00002\u00060\u0001j\u0002`\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\u00020\u00042\u00020\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u001c\u0010\u001e\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00000\f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0007J\b\u0010%\u001a\u00020&H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lkotlinx/coroutines/EventLoopBase$DelayedTask;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "", "Lkotlinx/coroutines/DisposableHandle;", "Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "timeMillis", "", "(J)V", "_heap", "", "value", "Lkotlinx/coroutines/internal/ThreadSafeHeap;", "heap", "getHeap", "()Lkotlinx/coroutines/internal/ThreadSafeHeap;", "setHeap", "(Lkotlinx/coroutines/internal/ThreadSafeHeap;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "nanoTime", "compareTo", "other", "dispose", "", "rescheduleOnShutdown", "schedule", "delayed", "eventLoop", "Lkotlinx/coroutines/EventLoopBase;", "timeToExecute", "", "now", "toString", "", "kotlinx-coroutines-core"})
    public static abstract class DelayedTask
    implements Runnable,
    Comparable<DelayedTask>,
    DisposableHandle,
    ThreadSafeHeapNode {
        private Object _heap;
        private int index = -1;
        @JvmField
        public final long nanoTime;

        @Override
        @Nullable
        public ThreadSafeHeap<?> getHeap() {
            Object object = this._heap;
            if (!(object instanceof ThreadSafeHeap)) {
                object = null;
            }
            return (ThreadSafeHeap)object;
        }

        @Override
        public void setHeap(@Nullable ThreadSafeHeap<?> value) {
            boolean bl;
            boolean bl2 = bl = this._heap != EventLoopKt.access$getDISPOSED_TASK$p();
            if (!bl) {
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            this._heap = value;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void setIndex(int n) {
            this.index = n;
        }

        @Override
        public int compareTo(@NotNull DelayedTask other) {
            Intrinsics.checkParameterIsNotNull(other, "other");
            long dTime = this.nanoTime - other.nanoTime;
            return dTime > 0L ? 1 : (dTime < 0L ? -1 : 0);
        }

        public final boolean timeToExecute(long now) {
            return now - this.nanoTime >= 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final synchronized int schedule(@NotNull ThreadSafeHeap<DelayedTask> delayed, @NotNull EventLoopBase eventLoop) {
            boolean bl;
            void this_$iv;
            Intrinsics.checkParameterIsNotNull(delayed, "delayed");
            Intrinsics.checkParameterIsNotNull(eventLoop, "eventLoop");
            if (this._heap == EventLoopKt.access$getDISPOSED_TASK$p()) {
                return 2;
            }
            ThreadSafeHeap<DelayedTask> threadSafeHeap = delayed;
            ThreadSafeHeapNode node$iv = this;
            void lock$iv$iv = this_$iv;
            synchronized (lock$iv$iv) {
                boolean bl2;
                if (!eventLoop.isCompleted()) {
                    this_$iv.addImpl(node$iv);
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                bl = bl2;
            }
            return bl ? 0 : 1;
        }

        public final void rescheduleOnShutdown() {
            DefaultExecutor.INSTANCE.schedule$kotlinx_coroutines_core(this);
        }

        @Override
        public final synchronized void dispose() {
            Object heap = this._heap;
            if (heap == EventLoopKt.access$getDISPOSED_TASK$p()) {
                return;
            }
            Object object = heap;
            if (!(object instanceof ThreadSafeHeap)) {
                object = null;
            }
            ThreadSafeHeap threadSafeHeap = (ThreadSafeHeap)object;
            if (threadSafeHeap != null) {
                threadSafeHeap.remove((ThreadSafeHeapNode)this);
            }
            this._heap = EventLoopKt.access$getDISPOSED_TASK$p();
        }

        @NotNull
        public String toString() {
            return "Delayed[nanos=" + this.nanoTime + ']';
        }

        public DelayedTask(long timeMillis) {
            this.nanoTime = TimeSourceKt.getTimeSource().nanoTime() + EventLoopKt.delayToNanos(timeMillis);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkotlinx/coroutines/EventLoopBase$DelayedResumeTask;", "Lkotlinx/coroutines/EventLoopBase$DelayedTask;", "timeMillis", "", "cont", "Lkotlinx/coroutines/CancellableContinuation;", "", "(Lkotlinx/coroutines/EventLoopBase;JLkotlinx/coroutines/CancellableContinuation;)V", "run", "kotlinx-coroutines-core"})
    private final class DelayedResumeTask
    extends DelayedTask {
        private final CancellableContinuation<Unit> cont;

        @Override
        public void run() {
            CancellableContinuation<Unit> cancellableContinuation;
            CancellableContinuation<Unit> $receiver = cancellableContinuation = this.cont;
            $receiver.resumeUndispatched(EventLoopBase.this, Unit.INSTANCE);
        }

        public DelayedResumeTask(@NotNull long timeMillis, CancellableContinuation<? super Unit> cont) {
            Intrinsics.checkParameterIsNotNull(cont, "cont");
            super(timeMillis);
            this.cont = cont;
            CancellableContinuationKt.disposeOnCancellation(this.cont, this);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkotlinx/coroutines/EventLoopBase$DelayedRunnableTask;", "Lkotlinx/coroutines/EventLoopBase$DelayedTask;", "time", "", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "(JLjava/lang/Runnable;)V", "run", "", "toString", "", "kotlinx-coroutines-core"})
    public static final class DelayedRunnableTask
    extends DelayedTask {
        private final Runnable block;

        @Override
        public void run() {
            this.block.run();
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString() + this.block.toString();
        }

        public DelayedRunnableTask(long time, @NotNull Runnable block) {
            Intrinsics.checkParameterIsNotNull(block, "block");
            super(time);
            this.block = block;
        }
    }
}

