/*
 * Decompiled with CFR 0.152.
 */
package compiler;

import bridge.ContractInstanceInSDC;
import bridge.Method;
import bridge.SolidityType;
import bridge.StorageLayout;
import compiler.ABI;
import compiler.ABIComponent;
import compiler.AbstractSolcRunner;
import compiler.SolidityFunctionStateMutabilitySerializable;
import compiler.StandardSolcRunner;
import compiler.data.Contract;
import compiler.data.ContractSource;
import compiler.data.Error;
import compiler.data.Input;
import compiler.data.Output;
import compiler.data.SolcSettings;
import compiler.data.SolidityOptimization;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.Either;
import utils.EitherKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u001b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\u0017H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\nH\u0014J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001f0\u001eH$J\b\u0010 \u001a\u00020\u0011H$J(\u0010!\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\u00172\u0006\u0010\"\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R3\u0010\u0016\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lcompiler/AbstractSolcRunner;", "", "address", "Ljava/math/BigInteger;", "optimize", "", "(Ljava/math/BigInteger;Z)V", "getAddress", "()Ljava/math/BigInteger;", "contractInstances", "", "Lbridge/ContractInstanceInSDC;", "getContractInstances", "()Ljava/util/List;", "contractInstances$delegate", "Lkotlin/Lazy;", "errors", "", "getErrors", "errors$delegate", "getOptimize", "()Z", "result", "Lutils/Either;", "getResult", "()Lutils/Either;", "result$delegate", "compileContracts", "getAllowedPaths", "getContractSource", "", "Lcompiler/AbstractSolcRunner$Source;", "getSolcExecutable", "postProcess", "res", "Lcompiler/data/Output;", "Source", "Shared"})
public abstract class AbstractSolcRunner {
    @NotNull
    private final Lazy result$delegate;
    @NotNull
    private final Lazy errors$delegate;
    @NotNull
    private final Lazy contractInstances$delegate;
    @NotNull
    private final BigInteger address;
    private final boolean optimize;

    @NotNull
    public final Either<List<ContractInstanceInSDC>, List<String>> getResult() {
        Lazy lazy = this.result$delegate;
        AbstractSolcRunner abstractSolcRunner = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Either)lazy.getValue();
    }

    @NotNull
    public final List<String> getErrors() {
        Lazy lazy = this.errors$delegate;
        AbstractSolcRunner abstractSolcRunner = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<ContractInstanceInSDC> getContractInstances() {
        Lazy lazy = this.contractInstances$delegate;
        AbstractSolcRunner abstractSolcRunner = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    protected abstract Map<String, Source> getContractSource();

    @NotNull
    protected abstract String getSolcExecutable();

    @NotNull
    protected List<String> getAllowedPaths() {
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final Either<List<ContractInstanceInSDC>, List<String>> compileContracts() {
        void $this$mapTo$iv$iv;
        List<String> allowedPaths = CollectionsKt.toMutableList((Collection)this.getAllowedPaths());
        Map<String, Source> $this$map$iv = this.getContractSource();
        boolean $i$f$map = false;
        Map<String, Source> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_9 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var8_9.entrySet().iterator();
        while (iterator2.hasNext()) {
            ContractSource contractSource;
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Object k = it.getKey();
            Source x = (Source)it.getValue();
            if (x instanceof Source.Literal) {
                contractSource = new ContractSource(((Source.Literal)x).getContractSource(), null, 2, null);
            } else if (x instanceof Source.FromFile) {
                File f = new File(((Source.FromFile)x).getPath());
                if (f.getParentFile() != null) {
                    File file;
                    Object k2 = k;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    File parentFile = file;
                    boolean bl5 = false;
                    String string2 = parentFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull(string2, "parentFile.absolutePath");
                    Boolean bl6 = allowedPaths.add(string2);
                    k = k2;
                }
                contractSource = new ContractSource(null, f, 1, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Pair pair = TuplesKt.to(k, contractSource);
            collection.add(pair);
        }
        Map sources = MapsKt.toMap((List)destination$iv$iv);
        Input solidityInput = new Input(null, sources, new SolcSettings(MapsKt.mapOf(TuplesKt.to("*", MapsKt.mapOf(TuplesKt.to("*", CollectionsKt.listOf("abi", "evm.deployedBytecode.object", "evm.bytecode.object", "evm.methodIdentifiers", "evm.deployedBytecode.sourceMap", "storageLayout"))))), new SolidityOptimization(this.optimize)), 1, null);
        Output output = new StandardSolcRunner(this.getSolcExecutable(), allowedPaths).run(solidityInput);
        if (output == null) {
            List list2;
            boolean bl7 = false;
            List list3 = list2 = CollectionsKt.emptyList();
            return new Either.Left(list3);
        }
        Output res2 = output;
        return this.postProcess(res2);
    }

    /*
     * WARNING - void declaration
     */
    private final Either<List<ContractInstanceInSDC>, List<String>> postProcess(Output res2) {
        void $this$flatMapTo$iv$iv;
        Object destination$iv$iv;
        boolean bl;
        block15: {
            Iterable $this$any$iv = res2.getErrors();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Error it = (Error)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getSeverity(), "error")) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$mapTo$iv$iv;
            Error it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = res2.getErrors();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Error)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it.getSeverity(), "error")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Error)item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl4 = false;
                String string2 = it.getMessage();
                object.add(string2);
            }
            return EitherKt.toRight((List)destination$iv$iv);
        }
        int i = 0;
        Map<String, Map<String, Contract>> $this$flatMap$iv = res2.getContracts();
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void item$iv$iv = $this$flatMapTo$iv$iv;
        boolean bl5 = false;
        Iterator iterator2 = item$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            Map contracts;
            Map.Entry element$iv$iv;
            Map.Entry $dstr$_u24__u24$contracts = element$iv$iv = iterator2.next();
            boolean bl6 = false;
            Map.Entry entry = $dstr$_u24__u24$contracts;
            boolean bl7 = false;
            Map $this$map$iv = contracts = (Map)entry.getValue();
            boolean $i$f$map = false;
            Map map2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var20_30 = $this$mapTo$iv$iv;
            boolean bl8 = false;
            Iterator iterator3 = var20_30.entrySet().iterator();
            while (iterator3.hasNext()) {
                void contractName;
                String string3;
                ABI aBI;
                void $this$mapTo$iv$iv2;
                void $dstr$contractName$contract;
                Map.Entry item$iv$iv2;
                Map.Entry entry2 = item$iv$iv2 = iterator3.next();
                Collection collection = destination$iv$iv3;
                boolean bl9 = false;
                void var27_37 = $dstr$contractName$contract;
                boolean bl10 = false;
                String string4 = (String)var27_37.getKey();
                var27_37 = $dstr$contractName$contract;
                bl10 = false;
                Contract contract = (Contract)var27_37.getValue();
                Iterable $this$map$iv2 = contract.getAbi();
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                    Object object;
                    ABIComponent it;
                    Collection<SolidityType> collection2;
                    Iterable $this$mapTo$iv$iv3;
                    Iterable $this$map$iv3;
                    void it2;
                    aBI = (ABI)item$iv$iv3;
                    Collection collection3 = destination$iv$iv4;
                    boolean bl11 = false;
                    String sig = it2.toCanonicalSig();
                    String string5 = it2.getName();
                    boolean bl12 = it2.getConstant();
                    SolidityFunctionStateMutabilitySerializable solidityFunctionStateMutabilitySerializable = new SolidityFunctionStateMutabilitySerializable(it2.getStateMutability());
                    boolean bl13 = !it2.getPayable();
                    String string6 = contract.getEvm().getMethodIdentifiers().get(sig);
                    if (string6 == null) {
                        string6 = "";
                    }
                    Iterable iterable2 = it2.getInputs();
                    string3 = string6;
                    boolean bl14 = bl13;
                    SolidityFunctionStateMutabilitySerializable solidityFunctionStateMutabilitySerializable2 = solidityFunctionStateMutabilitySerializable;
                    boolean bl15 = bl12;
                    boolean bl16 = false;
                    boolean bl17 = true;
                    String string7 = string5;
                    boolean $i$f$map3 = false;
                    Collection<SolidityType> collection4 = $this$map$iv3;
                    Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                        ABIComponent aBIComponent = (ABIComponent)item$iv$iv4;
                        collection2 = destination$iv$iv5;
                        boolean bl18 = false;
                        object = it.toSolidityType();
                        collection2.add((SolidityType)object);
                    }
                    collection2 = (List)destination$iv$iv5;
                    $this$map$iv3 = it2.getOutputs();
                    $i$f$map3 = false;
                    $this$mapTo$iv$iv3 = $this$map$iv3;
                    destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                    $i$f$mapTo3 = false;
                    for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                        it = (ABIComponent)item$iv$iv4;
                        object = destination$iv$iv5;
                        boolean bl19 = false;
                        SolidityType solidityType = it.toSolidityType();
                        object.add(solidityType);
                    }
                    object = (List)destination$iv$iv5;
                    boolean bl20 = false;
                    Object object2 = object;
                    collection4 = collection2;
                    String string8 = string3;
                    boolean bl21 = bl14;
                    SolidityFunctionStateMutabilitySerializable solidityFunctionStateMutabilitySerializable3 = solidityFunctionStateMutabilitySerializable2;
                    boolean bl22 = bl15;
                    boolean bl23 = bl16;
                    boolean bl24 = bl17;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 512;
                    boolean bl25 = bl20;
                    boolean bl26 = bl24;
                    SolidityFunctionStateMutabilitySerializable solidityFunctionStateMutabilitySerializable4 = solidityFunctionStateMutabilitySerializable3;
                    boolean bl27 = bl22;
                    boolean bl28 = bl23;
                    boolean bl29 = bl21;
                    String string9 = string8;
                    Object object3 = object2;
                    Collection<SolidityType> collection5 = collection4;
                    String string10 = string7;
                    Method method = new Method(string10, (List)collection5, (List)object3, string9, bl29, bl28, bl27, solidityFunctionStateMutabilitySerializable4, bl26, bl25, n, defaultConstructorMarker);
                    collection3.add(method);
                }
                List methods = (List)destination$iv$iv4;
                String string11 = contract.getEvm().getDeployedBytecode().getObject();
                if (string11 == null) {
                    Intrinsics.throwNpe();
                }
                String string12 = contract.getEvm().getBytecode().getObject();
                if (string12 == null) {
                    Intrinsics.throwNpe();
                }
                String string13 = contract.getEvm().getDeployedBytecode().getSourceMap();
                if (string13 == null) {
                    Intrinsics.throwNpe();
                }
                BigInteger bigInteger = this.address;
                int n = i;
                i = n + 1;
                List list2 = methods;
                String string14 = string13;
                String string15 = string12;
                String string16 = string11;
                String string17 = "";
                String string18 = "";
                void var67_90 = contractName;
                boolean bl30 = false;
                BigInteger bigInteger2 = BigInteger.valueOf(n);
                Intrinsics.checkExpressionValueIsNotNull(bigInteger2, "BigInteger.valueOf(this.toLong())");
                BigInteger bigInteger3 = bigInteger2;
                Object object = bigInteger3;
                bl30 = false;
                BigInteger bigInteger4 = bigInteger.add((BigInteger)object);
                Intrinsics.checkExpressionValueIsNotNull(bigInteger4, "this.add(other)");
                bigInteger3 = bigInteger4;
                Object var69_92 = null;
                Map map3 = null;
                Map map4 = null;
                Object var72_95 = null;
                StorageLayout storageLayout = contract.getStorageLayout();
                Object var74_97 = null;
                boolean bl31 = false;
                List list3 = CollectionsKt.emptyList();
                Map map5 = null;
                object = list3;
                iterable = var69_92;
                Map map6 = map3;
                Map map7 = map4;
                Iterator iterator4 = var72_95;
                StorageLayout storageLayout2 = storageLayout;
                aBI = var74_97;
                BigInteger bigInteger5 = bigInteger3;
                List list4 = list2;
                String string19 = string14;
                string3 = string15;
                String string20 = string16;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n2 = 48384;
                Map map8 = map5;
                Object object4 = object;
                Iterable iterable3 = iterable;
                Map map9 = map6;
                Map map10 = map7;
                Iterator iterator5 = iterator4;
                StorageLayout storageLayout3 = storageLayout2;
                ABI aBI2 = aBI;
                String string21 = string19;
                String string22 = string3;
                String string23 = string20;
                List list5 = list4;
                BigInteger bigInteger6 = bigInteger5;
                String string24 = string17;
                String string25 = string18;
                void var108_129 = var67_90;
                ContractInstanceInSDC contractInstanceInSDC = new ContractInstanceInSDC((String)var108_129, string25, string24, bigInteger6, list5, string23, string22, string21, (String)((Object)aBI2), storageLayout3, (Map)((Object)iterator5), map10, map9, (Map)((Object)iterable3), (List)object4, map8, n2, defaultConstructorMarker);
                collection.add(contractInstanceInSDC);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        return EitherKt.toLeft((List)destination$iv$iv2);
    }

    @NotNull
    public final BigInteger getAddress() {
        return this.address;
    }

    public final boolean getOptimize() {
        return this.optimize;
    }

    public AbstractSolcRunner(@NotNull BigInteger address2, boolean optimize) {
        Intrinsics.checkParameterIsNotNull(address2, "address");
        this.address = address2;
        this.optimize = optimize;
        this.result$delegate = LazyKt.lazy((Function0)new Function0<Either<? extends List<? extends ContractInstanceInSDC>, ? extends List<? extends String>>>(this){
            final /* synthetic */ AbstractSolcRunner this$0;

            @NotNull
            public final Either<List<ContractInstanceInSDC>, List<String>> invoke() {
                return AbstractSolcRunner.access$compileContracts(this.this$0);
            }
            {
                this.this$0 = abstractSolcRunner;
                super(0);
            }
        });
        this.errors$delegate = LazyKt.lazy((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ AbstractSolcRunner this$0;

            @NotNull
            public final List<String> invoke() {
                return (List)EitherKt.toValue(this.this$0.getResult(), errors.1.INSTANCE, errors.2.INSTANCE);
            }
            {
                this.this$0 = abstractSolcRunner;
                super(0);
            }
        });
        this.contractInstances$delegate = LazyKt.lazy((Function0)new Function0<List<? extends ContractInstanceInSDC>>(this){
            final /* synthetic */ AbstractSolcRunner this$0;

            @NotNull
            public final List<ContractInstanceInSDC> invoke() {
                return (List)EitherKt.toValue(this.this$0.getResult(), contractInstances.1.INSTANCE, contractInstances.2.INSTANCE);
            }
            {
                this.this$0 = abstractSolcRunner;
                super(0);
            }
        });
    }

    public /* synthetic */ AbstractSolcRunner(BigInteger bigInteger, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(bigInteger, bl);
    }

    public static final /* synthetic */ Either access$compileContracts(AbstractSolcRunner $this) {
        return $this.compileContracts();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcompiler/AbstractSolcRunner$Source;", "", "()V", "FromFile", "Literal", "Lcompiler/AbstractSolcRunner$Source$Literal;", "Lcompiler/AbstractSolcRunner$Source$FromFile;", "Shared"})
    public static abstract class Source {
        private Source() {
        }

        public /* synthetic */ Source(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcompiler/AbstractSolcRunner$Source$Literal;", "Lcompiler/AbstractSolcRunner$Source;", "contractSource", "", "(Ljava/lang/String;)V", "getContractSource", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Shared"})
        public static final class Literal
        extends Source {
            @NotNull
            private final String contractSource;

            @NotNull
            public final String getContractSource() {
                return this.contractSource;
            }

            public Literal(@NotNull String contractSource) {
                Intrinsics.checkParameterIsNotNull(contractSource, "contractSource");
                super(null);
                this.contractSource = contractSource;
            }

            @NotNull
            public final String component1() {
                return this.contractSource;
            }

            @NotNull
            public final Literal copy(@NotNull String contractSource) {
                Intrinsics.checkParameterIsNotNull(contractSource, "contractSource");
                return new Literal(contractSource);
            }

            public static /* synthetic */ Literal copy$default(Literal literal, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = literal.contractSource;
                }
                return literal.copy(string2);
            }

            @NotNull
            public String toString() {
                return "Literal(contractSource=" + this.contractSource + ")";
            }

            public int hashCode() {
                String string2 = this.contractSource;
                return string2 != null ? string2.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Literal)) break block3;
                        Literal literal = (Literal)object;
                        if (!Intrinsics.areEqual(this.contractSource, literal.contractSource)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcompiler/AbstractSolcRunner$Source$FromFile;", "Lcompiler/AbstractSolcRunner$Source;", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Shared"})
        public static final class FromFile
        extends Source {
            @NotNull
            private final String path;

            @NotNull
            public final String getPath() {
                return this.path;
            }

            public FromFile(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull(path, "path");
                super(null);
                this.path = path;
            }

            @NotNull
            public final String component1() {
                return this.path;
            }

            @NotNull
            public final FromFile copy(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull(path, "path");
                return new FromFile(path);
            }

            public static /* synthetic */ FromFile copy$default(FromFile fromFile, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = fromFile.path;
                }
                return fromFile.copy(string2);
            }

            @NotNull
            public String toString() {
                return "FromFile(path=" + this.path + ")";
            }

            public int hashCode() {
                String string2 = this.path;
                return string2 != null ? string2.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof FromFile)) break block3;
                        FromFile fromFile = (FromFile)object;
                        if (!Intrinsics.areEqual(this.path, fromFile.path)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

