/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Exp;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpTag;
import spec.cvlast.TwoStateIndex;

public class VariableExp
extends Exp {
    public String id;
    public Annotation annotation;

    public VariableExp(String _id, Annotation _annotation) {
        this.id = _id;
        this.annotation = _annotation;
    }

    public VariableExp(String _id) {
        this(_id, Annotation.NONE);
    }

    public static VariableExp oldVariable(String _id) {
        return new VariableExp(_id, Annotation.OLD);
    }

    public static VariableExp newVariable(String _id) {
        return new VariableExp(_id, Annotation.NEW);
    }

    public boolean isOldVersion() {
        return this.annotation == Annotation.OLD;
    }

    public boolean isNewVersion() {
        return this.annotation == Annotation.NEW;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VariableExp)) {
            return false;
        }
        VariableExp otherVarExp = (VariableExp)obj;
        if (this == otherVarExp) {
            return true;
        }
        return this.annotation.equals((Object)otherVarExp.annotation) && this.id.equals(otherVarExp.id);
    }

    public int hashCode() {
        int result2 = this.id == null ? 0 : this.id.hashCode();
        result2 = 31 * result2 + (this.annotation == null ? 0 : this.annotation.hashCode());
        return result2;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public CVLExp.VariableExp kotlinize() {
        TwoStateIndex index = TwoStateIndex.NEITHER;
        if (this.isOldVersion()) {
            index = TwoStateIndex.OLD;
        }
        if (this.isNewVersion()) {
            index = TwoStateIndex.NEW;
        }
        return new CVLExp.VariableExp(this.id, CVLExpTag.Companion.getEmptyTag(), index);
    }

    static enum Annotation {
        OLD,
        NEW,
        NONE;

    }
}

