# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['databricks_api']

package_data = \
{'': ['*']}

install_requires = \
['databricks-cli>=0.12.0,<0.13.0']

setup_kwargs = {
    'name': 'databricks-api',
    'version': '0.6.0',
    'description': 'Databricks API client auto-generated from the official databricks-cli package',
    'long_description': 'databricks-api\n==============\n\n|pypi| |pyversions|\n\n.. |pypi| image:: https://img.shields.io/pypi/v/databricks-api.svg\n    :target: https://pypi.python.org/pypi/databricks-api\n\n.. |pyversions| image:: https://img.shields.io/pypi/pyversions/databricks-api.svg\n    :target: https://pypi.python.org/pypi/databricks-api\n\n*[This documentation is auto-generated]*\n\nThis package provides a simplified interface for the Databricks REST API.\nThe interface is autogenerated on instantiation using the underlying client\nlibrary used in the official ``databricks-cli`` python package.\n\nInstall using\n\n.. code-block:: bash\n\n    pip install databricks-api\n    \n\nThe docs here describe the interface for version **0.12.0** of\nthe ``databricks-cli`` package for API version **2.0**.\nAssuming there are no new major or minor versions to the ``databricks-cli`` package\nstructure, this package should continue to work without a required update.\n\nThe ``databricks-api`` package contains a ``DatabricksAPI`` class which provides\ninstance attributes for the ``databricks-cli`` ``ApiClient``, as well as each of\nthe available service instances. The attributes of a ``DatabricksAPI`` instance are:\n\n* DatabricksAPI.client *<databricks_cli.sdk.api_client.ApiClient>*\n* DatabricksAPI.jobs *<databricks_cli.sdk.service.JobsService>*\n* DatabricksAPI.cluster *<databricks_cli.sdk.service.ClusterService>*\n* DatabricksAPI.policy *<databricks_cli.sdk.service.PolicyService>*\n* DatabricksAPI.managed_library *<databricks_cli.sdk.service.ManagedLibraryService>*\n* DatabricksAPI.dbfs *<databricks_cli.sdk.service.DbfsService>*\n* DatabricksAPI.workspace *<databricks_cli.sdk.service.WorkspaceService>*\n* DatabricksAPI.secret *<databricks_cli.sdk.service.SecretService>*\n* DatabricksAPI.groups *<databricks_cli.sdk.service.GroupsService>*\n* DatabricksAPI.token *<databricks_cli.sdk.service.TokenService>*\n* DatabricksAPI.instance_pool *<databricks_cli.sdk.service.InstancePoolService>*\n* DatabricksAPI.delta_pipelines *<databricks_cli.sdk.service.DeltaPipelinesService>*\n\nTo instantiate the client, provide the databricks host and either a token or\nuser and password. Also shown is the full signature of the\nunderlying ``ApiClient.__init__``\n\n.. code-block:: python\n\n    from databricks_api import DatabricksAPI\n\n    # Provide a host and token\n    db = DatabricksAPI(\n        host="example.cloud.databricks.com",\n        token="dpapi123..."\n    )\n\n    # OR a host and user and password\n    db = DatabricksAPI(\n        host="example.cloud.databricks.com",\n        user="me@example.com",\n        password="password"\n    )\n\n    # Full __init__ signature\n    db = DatabricksAPI(\n        user=None,\n        password=None,\n        host=None,\n        token=None,\n        apiVersion=2.0,\n        default_headers={},\n        verify=True,\n        command_name=\'\'\n    )\n\nRefer to the `official documentation <https://docs.databricks.com/api/index.html>`_\non the functionality and required arguments of each method below.\n\nEach of the service instance attributes provides the following public methods:\n\nDatabricksAPI.jobs\n------------------\n\n.. code-block:: python\n\n    DatabricksAPI.jobs.cancel_run(\n        run_id,\n        headers=None,\n    )\n\n    DatabricksAPI.jobs.create_job(\n        name=None,\n        existing_cluster_id=None,\n        new_cluster=None,\n        libraries=None,\n        email_notifications=None,\n        timeout_seconds=None,\n        max_retries=None,\n        min_retry_interval_millis=None,\n        retry_on_timeout=None,\n        schedule=None,\n        notebook_task=None,\n        spark_jar_task=None,\n        spark_python_task=None,\n        spark_submit_task=None,\n        max_concurrent_runs=None,\n        headers=None,\n    )\n\n    DatabricksAPI.jobs.delete_job(\n        job_id,\n        headers=None,\n    )\n\n    DatabricksAPI.jobs.delete_run(\n        run_id=None,\n        headers=None,\n    )\n\n    DatabricksAPI.jobs.export_run(\n        run_id,\n        views_to_export=None,\n        headers=None,\n    )\n\n    DatabricksAPI.jobs.get_job(\n        job_id,\n        headers=None,\n    )\n\n    DatabricksAPI.jobs.get_run(\n        run_id=None,\n        headers=None,\n    )\n\n    DatabricksAPI.jobs.get_run_output(\n        run_id,\n        headers=None,\n    )\n\n    DatabricksAPI.jobs.list_jobs(headers=None)\n\n    DatabricksAPI.jobs.list_runs(\n        job_id=None,\n        active_only=None,\n        completed_only=None,\n        offset=None,\n        limit=None,\n        headers=None,\n    )\n\n    DatabricksAPI.jobs.reset_job(\n        job_id,\n        new_settings,\n        headers=None,\n    )\n\n    DatabricksAPI.jobs.run_now(\n        job_id=None,\n        jar_params=None,\n        notebook_params=None,\n        python_params=None,\n        spark_submit_params=None,\n        headers=None,\n    )\n\n    DatabricksAPI.jobs.submit_run(\n        run_name=None,\n        existing_cluster_id=None,\n        new_cluster=None,\n        libraries=None,\n        notebook_task=None,\n        spark_jar_task=None,\n        spark_python_task=None,\n        spark_submit_task=None,\n        timeout_seconds=None,\n        headers=None,\n    )\n\n\nDatabricksAPI.cluster\n---------------------\n\n.. code-block:: python\n\n    DatabricksAPI.cluster.create_cluster(\n        num_workers=None,\n        autoscale=None,\n        cluster_name=None,\n        spark_version=None,\n        spark_conf=None,\n        aws_attributes=None,\n        node_type_id=None,\n        driver_node_type_id=None,\n        ssh_public_keys=None,\n        custom_tags=None,\n        cluster_log_conf=None,\n        init_scripts=None,\n        spark_env_vars=None,\n        autotermination_minutes=None,\n        enable_elastic_disk=None,\n        cluster_source=None,\n        instance_pool_id=None,\n        headers=None,\n    )\n\n    DatabricksAPI.cluster.delete_cluster(\n        cluster_id,\n        headers=None,\n    )\n\n    DatabricksAPI.cluster.edit_cluster(\n        cluster_id,\n        num_workers=None,\n        autoscale=None,\n        cluster_name=None,\n        spark_version=None,\n        spark_conf=None,\n        aws_attributes=None,\n        node_type_id=None,\n        driver_node_type_id=None,\n        ssh_public_keys=None,\n        custom_tags=None,\n        cluster_log_conf=None,\n        init_scripts=None,\n        spark_env_vars=None,\n        autotermination_minutes=None,\n        enable_elastic_disk=None,\n        cluster_source=None,\n        instance_pool_id=None,\n        headers=None,\n    )\n\n    DatabricksAPI.cluster.get_cluster(\n        cluster_id,\n        headers=None,\n    )\n\n    DatabricksAPI.cluster.get_events(\n        cluster_id,\n        start_time=None,\n        end_time=None,\n        order=None,\n        event_types=None,\n        offset=None,\n        limit=None,\n        headers=None,\n    )\n\n    DatabricksAPI.cluster.list_available_zones(headers=None)\n\n    DatabricksAPI.cluster.list_clusters(headers=None)\n\n    DatabricksAPI.cluster.list_node_types(headers=None)\n\n    DatabricksAPI.cluster.list_spark_versions(headers=None)\n\n    DatabricksAPI.cluster.permanent_delete_cluster(\n        cluster_id,\n        headers=None,\n    )\n\n    DatabricksAPI.cluster.pin_cluster(\n        cluster_id,\n        headers=None,\n    )\n\n    DatabricksAPI.cluster.resize_cluster(\n        cluster_id,\n        num_workers=None,\n        autoscale=None,\n        headers=None,\n    )\n\n    DatabricksAPI.cluster.restart_cluster(\n        cluster_id,\n        headers=None,\n    )\n\n    DatabricksAPI.cluster.start_cluster(\n        cluster_id,\n        headers=None,\n    )\n\n    DatabricksAPI.cluster.unpin_cluster(\n        cluster_id,\n        headers=None,\n    )\n\n\nDatabricksAPI.policy\n--------------------\n\n.. code-block:: python\n\n    DatabricksAPI.policy.create_policy(\n        policy_name,\n        definition,\n        headers=None,\n    )\n\n    DatabricksAPI.policy.delete_policy(\n        policy_id,\n        headers=None,\n    )\n\n    DatabricksAPI.policy.edit_policy(\n        policy_id,\n        policy_name,\n        definition,\n        headers=None,\n    )\n\n    DatabricksAPI.policy.get_policy(\n        policy_id,\n        headers=None,\n    )\n\n    DatabricksAPI.policy.list_policies(headers=None)\n\n\nDatabricksAPI.managed_library\n-----------------------------\n\n.. code-block:: python\n\n    DatabricksAPI.managed_library.all_cluster_statuses(headers=None)\n\n    DatabricksAPI.managed_library.cluster_status(\n        cluster_id,\n        headers=None,\n    )\n\n    DatabricksAPI.managed_library.install_libraries(\n        cluster_id,\n        libraries=None,\n        headers=None,\n    )\n\n    DatabricksAPI.managed_library.uninstall_libraries(\n        cluster_id,\n        libraries=None,\n        headers=None,\n    )\n\n\nDatabricksAPI.dbfs\n------------------\n\n.. code-block:: python\n\n    DatabricksAPI.dbfs.add_block(\n        handle,\n        data,\n        headers=None,\n    )\n\n    DatabricksAPI.dbfs.close(\n        handle,\n        headers=None,\n    )\n\n    DatabricksAPI.dbfs.create(\n        path,\n        overwrite=None,\n        headers=None,\n    )\n\n    DatabricksAPI.dbfs.delete(\n        path,\n        recursive=None,\n        headers=None,\n    )\n\n    DatabricksAPI.dbfs.get_status(\n        path,\n        headers=None,\n    )\n\n    DatabricksAPI.dbfs.list(\n        path,\n        headers=None,\n    )\n\n    DatabricksAPI.dbfs.mkdirs(\n        path,\n        headers=None,\n    )\n\n    DatabricksAPI.dbfs.move(\n        source_path,\n        destination_path,\n        headers=None,\n    )\n\n    DatabricksAPI.dbfs.put(\n        path,\n        contents=None,\n        overwrite=None,\n        headers=None,\n    )\n\n    DatabricksAPI.dbfs.read(\n        path,\n        offset=None,\n        length=None,\n        headers=None,\n    )\n\n\nDatabricksAPI.workspace\n-----------------------\n\n.. code-block:: python\n\n    DatabricksAPI.workspace.delete(\n        path,\n        recursive=None,\n        headers=None,\n    )\n\n    DatabricksAPI.workspace.export_workspace(\n        path,\n        format=None,\n        direct_download=None,\n        headers=None,\n    )\n\n    DatabricksAPI.workspace.get_status(\n        path,\n        headers=None,\n    )\n\n    DatabricksAPI.workspace.import_workspace(\n        path,\n        format=None,\n        language=None,\n        content=None,\n        overwrite=None,\n        headers=None,\n    )\n\n    DatabricksAPI.workspace.list(\n        path,\n        headers=None,\n    )\n\n    DatabricksAPI.workspace.mkdirs(\n        path,\n        headers=None,\n    )\n\n\nDatabricksAPI.secret\n--------------------\n\n.. code-block:: python\n\n    DatabricksAPI.secret.create_scope(\n        scope,\n        initial_manage_principal=None,\n        scope_backend_type=None,\n        headers=None,\n    )\n\n    DatabricksAPI.secret.delete_acl(\n        scope,\n        principal,\n        headers=None,\n    )\n\n    DatabricksAPI.secret.delete_scope(\n        scope,\n        headers=None,\n    )\n\n    DatabricksAPI.secret.delete_secret(\n        scope,\n        key,\n        headers=None,\n    )\n\n    DatabricksAPI.secret.get_acl(\n        scope,\n        principal,\n        headers=None,\n    )\n\n    DatabricksAPI.secret.list_acls(\n        scope,\n        headers=None,\n    )\n\n    DatabricksAPI.secret.list_scopes(headers=None)\n\n    DatabricksAPI.secret.list_secrets(\n        scope,\n        headers=None,\n    )\n\n    DatabricksAPI.secret.put_acl(\n        scope,\n        principal,\n        permission,\n        headers=None,\n    )\n\n    DatabricksAPI.secret.put_secret(\n        scope,\n        key,\n        string_value=None,\n        bytes_value=None,\n        headers=None,\n    )\n\n\nDatabricksAPI.groups\n--------------------\n\n.. code-block:: python\n\n    DatabricksAPI.groups.add_to_group(\n        parent_name,\n        user_name=None,\n        group_name=None,\n        headers=None,\n    )\n\n    DatabricksAPI.groups.create_group(\n        group_name,\n        headers=None,\n    )\n\n    DatabricksAPI.groups.get_group_members(\n        group_name,\n        headers=None,\n    )\n\n    DatabricksAPI.groups.get_groups(headers=None)\n\n    DatabricksAPI.groups.get_groups_for_principal(\n        user_name=None,\n        group_name=None,\n        headers=None,\n    )\n\n    DatabricksAPI.groups.remove_from_group(\n        parent_name,\n        user_name=None,\n        group_name=None,\n        headers=None,\n    )\n\n    DatabricksAPI.groups.remove_group(\n        group_name,\n        headers=None,\n    )\n\n\nDatabricksAPI.token\n-------------------\n\n.. code-block:: python\n\n    DatabricksAPI.token.create_token(\n        lifetime_seconds=None,\n        comment=None,\n        headers=None,\n    )\n\n    DatabricksAPI.token.list_tokens(headers=None)\n\n    DatabricksAPI.token.revoke_token(\n        token_id,\n        headers=None,\n    )\n\n\nDatabricksAPI.instance_pool\n---------------------------\n\n.. code-block:: python\n\n    DatabricksAPI.instance_pool.create_instance_pool(\n        instance_pool_name=None,\n        min_idle_instances=None,\n        max_capacity=None,\n        aws_attributes=None,\n        node_type_id=None,\n        custom_tags=None,\n        idle_instance_autotermination_minutes=None,\n        enable_elastic_disk=None,\n        disk_spec=None,\n        preloaded_spark_versions=None,\n        headers=None,\n    )\n\n    DatabricksAPI.instance_pool.delete_instance_pool(\n        instance_pool_id=None,\n        headers=None,\n    )\n\n    DatabricksAPI.instance_pool.edit_instance_pool(\n        instance_pool_id,\n        instance_pool_name=None,\n        min_idle_instances=None,\n        max_capacity=None,\n        aws_attributes=None,\n        node_type_id=None,\n        custom_tags=None,\n        idle_instance_autotermination_minutes=None,\n        enable_elastic_disk=None,\n        disk_spec=None,\n        preloaded_spark_versions=None,\n        headers=None,\n    )\n\n    DatabricksAPI.instance_pool.get_instance_pool(\n        instance_pool_id=None,\n        headers=None,\n    )\n\n    DatabricksAPI.instance_pool.list_instance_pools(headers=None)\n\n\nDatabricksAPI.delta_pipelines\n-----------------------------\n\n.. code-block:: python\n\n    DatabricksAPI.delta_pipelines.create(\n        id=None,\n        name=None,\n        storage=None,\n        configuration=None,\n        clusters=None,\n        libraries=None,\n        trigger=None,\n        filters=None,\n        allow_duplicate_names=None,\n        headers=None,\n    )\n\n    DatabricksAPI.delta_pipelines.delete(\n        pipeline_id=None,\n        headers=None,\n    )\n\n    DatabricksAPI.delta_pipelines.deploy(\n        pipeline_id=None,\n        id=None,\n        name=None,\n        storage=None,\n        configuration=None,\n        clusters=None,\n        libraries=None,\n        trigger=None,\n        filters=None,\n        allow_duplicate_names=None,\n        headers=None,\n    )\n\n    DatabricksAPI.delta_pipelines.get(\n        pipeline_id=None,\n        headers=None,\n    )\n\n    DatabricksAPI.delta_pipelines.reset(\n        pipeline_id=None,\n        headers=None,\n    )\n\n    DatabricksAPI.delta_pipelines.run(\n        pipeline_id=None,\n        headers=None,\n    )\n\n    DatabricksAPI.delta_pipelines.stop(\n        pipeline_id=None,\n        headers=None,\n    )\n\n\n',
    'author': 'Christopher Flynn',
    'author_email': 'crf204@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/crflynn/databricks-api',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*, !=3.4.*',
}


setup(**setup_kwargs)
