/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.easy.RowData;
import java.io.Serializable;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenMunger
implements Serializable {
    public Step[] _steps;

    public String[] inTypes() {
        return this._steps[0].types();
    }

    public String[] inNames() {
        return this._steps[0].names();
    }

    public String[] outNames() {
        return this._steps[this._steps.length - 1].outNames();
    }

    public RowData fit(RowData row) {
        if (row == null) {
            return null;
        }
        for (Step s2 : this._steps) {
            row = s2.transform(row);
        }
        return row;
    }

    public RowData fillDefault(String[] vals) {
        RowData row = new RowData();
        String[] types = this.inTypes();
        String[] names = this.inNames();
        for (int i2 = 0; i2 < types.length; ++i2) {
            row.put(names[i2], vals == null ? null : GenMunger.valueOf(types[i2], vals[i2]));
        }
        return row;
    }

    private static Double parseNum(String n2) {
        if (n2 == null || n2.equals("") || n2.isEmpty()) {
            return Double.NaN;
        }
        return Double.valueOf(n2);
    }

    private static Object valueOf(String type, String val) {
        val = val.replaceAll("^\"|\"$", "");
        return type.equals("Numeric") ? GenMunger.parseNum(val) : val;
    }

    public static void scaleInPlace(double[] means, double[] mults, double[] in) {
        for (int i2 = 0; i2 < in.length; ++i2) {
            in[i2] = (in[i2] - means[i2]) * mults[i2];
        }
    }

    public static double cos(double r2, HashMap<String, String[]> parameters) {
        return Math.cos(r2);
    }

    public static double sin(double r2, HashMap<String, String[]> parameters) {
        return Math.sin(r2);
    }

    public static double countmatches(String s2, HashMap<String, String[]> parameters) {
        String[] patterns = parameters.get("pattern");
        return GenMunger.countMatches(s2, patterns);
    }

    private static int countMatches(String s2, String[] pattern) {
        int cnt = 0;
        for (String pat : pattern) {
            Pattern p2 = Pattern.compile(pat);
            Matcher m2 = p2.matcher(s2);
            while (m2.find()) {
                ++cnt;
            }
        }
        return cnt;
    }

    public static double add(double d2, HashMap<String, String[]> parameters) {
        String[] leftArg = parameters.get("leftArg");
        String[] riteArg = parameters.get("rightArg");
        if (leftArg == null) {
            return d2 + GenMunger.parseNum(riteArg[0]);
        }
        return GenMunger.parseNum(leftArg[0]) + d2;
    }

    public static double minus(double d2, HashMap<String, String[]> parameters) {
        String[] leftArg = parameters.get("leftArg");
        String[] riteArg = parameters.get("rightArg");
        if (leftArg == null) {
            return d2 - GenMunger.parseNum(riteArg[0]);
        }
        return GenMunger.parseNum(leftArg[0]) - d2;
    }

    public static double multiply(double d2, HashMap<String, String[]> parameters) {
        String[] leftArg = parameters.get("leftArg");
        String[] riteArg = parameters.get("rightArg");
        if (leftArg == null) {
            return d2 * GenMunger.parseNum(riteArg[0]);
        }
        return GenMunger.parseNum(leftArg[0]) * d2;
    }

    public static double divide(double d2, HashMap<String, String[]> parameters) {
        String[] leftArg = parameters.get("leftArg");
        String[] riteArg = parameters.get("rightArg");
        if (leftArg == null) {
            return d2 / GenMunger.parseNum(riteArg[0]);
        }
        return GenMunger.parseNum(leftArg[0]) / d2;
    }

    public static double mod(double d2, HashMap<String, String[]> parameters) {
        String leftArg = parameters.get("leftArg")[0];
        String riteArg = parameters.get("rightArg")[0];
        if (leftArg == null) {
            return d2 % GenMunger.parseNum(riteArg);
        }
        return GenMunger.parseNum(leftArg) % d2;
    }

    public static double pow(double d2, HashMap<String, String[]> parameters) {
        String leftArg = parameters.get("leftArg")[0];
        String riteArg = parameters.get("rightArg")[0];
        if (leftArg == null) {
            return Math.pow(d2, GenMunger.parseNum(riteArg));
        }
        return Math.pow(GenMunger.parseNum(leftArg), d2);
    }

    public static String[] strsplit(String s2, HashMap<String, String[]> parameters) {
        String pattern = parameters.get("split")[0];
        return s2.split(pattern);
    }

    public static double asnumeric(String s2, HashMap<String, String[]> parameters) {
        return GenMunger.parseNum(s2);
    }

    public static String trim(String s2, HashMap<String, String[]> parameters) {
        return s2.trim();
    }

    public static String replaceall(String s2, HashMap<String, String[]> parameters) {
        String pattern = parameters.get("pattern")[0];
        String replacement = parameters.get("replacement")[0];
        boolean ignoreCase = parameters.get("ignore_case")[0].equals("TRUE");
        return ignoreCase ? s2.replaceAll("(?i)" + Pattern.quote(pattern), replacement) : s2.replaceAll(pattern, replacement);
    }

    public static String toupper(String s2, HashMap<String, String[]> parameters) {
        return s2.toUpperCase();
    }

    public static String tolower(String s2, HashMap<String, String[]> parameters) {
        return s2.toLowerCase();
    }

    public static String cut(double d2, HashMap<String, String[]> parameters) {
        String[] breaks = parameters.get("breaks");
        String[] labels = parameters.get("labels");
        boolean lowest = parameters.get("include_lowest")[0].equals("TRUE");
        boolean rite = parameters.get("right")[0].equals("TRUE");
        if (Double.isNaN(d2) || lowest && d2 < GenMunger.parseNum(breaks[0]) || !lowest && d2 <= GenMunger.parseNum(breaks[0]) || rite && d2 > GenMunger.parseNum(breaks[breaks.length - 1]) || !rite && d2 >= GenMunger.parseNum(breaks[breaks.length - 1])) {
            return "";
        }
        for (int i2 = 1; i2 < breaks.length; ++i2) {
            if (!rite) continue;
            if (d2 <= GenMunger.parseNum(breaks[i2])) {
                return labels[i2 - 1];
            }
            if (!(d2 < GenMunger.parseNum(breaks[i2]))) continue;
            return labels[i2 - 1];
        }
        return "";
    }

    public static double nchar(String s2, HashMap<String, String[]> parameters) {
        return s2.length();
    }

    public abstract class Step<T>
    implements Serializable {
        private final String[] _names;
        private final String[] _types;
        private final String[] _outNames;
        protected HashMap<String, String[]> _params;

        public abstract RowData transform(RowData var1);

        public Step(String[] inNames, String[] inTypes, String[] outNames) {
            this._names = inNames;
            this._types = inTypes;
            this._outNames = outNames;
            this._params = new HashMap();
        }

        public String[] outNames() {
            return this._outNames;
        }

        public String[] names() {
            return this._names;
        }

        public String[] types() {
            return this._types;
        }

        public HashMap<String, String[]> params() {
            return this._params;
        }
    }
}

