/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.Descriptors;
import ai.h2o.com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class TypeRegistry {
    private static final Logger logger = Logger.getLogger(TypeRegistry.class.getName());
    private final Map<String, Descriptors.Descriptor> types;

    public static TypeRegistry getEmptyTypeRegistry() {
        return EmptyTypeRegistryHolder.EMPTY;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Descriptors.Descriptor find(String name) {
        return this.types.get(name);
    }

    public final Descriptors.Descriptor getDescriptorForTypeUrl(String typeUrl) throws InvalidProtocolBufferException {
        return this.find(TypeRegistry.getTypeName(typeUrl));
    }

    TypeRegistry(Map<String, Descriptors.Descriptor> types) {
        this.types = types;
    }

    private static String getTypeName(String typeUrl) throws InvalidProtocolBufferException {
        String[] stringArray = typeUrl.split("/");
        if (stringArray.length == 1) {
            throw new InvalidProtocolBufferException("Invalid type url found: " + typeUrl);
        }
        return stringArray[stringArray.length - 1];
    }

    public static final class Builder {
        private final Set<String> files = new HashSet<String>();
        private Map<String, Descriptors.Descriptor> types = new HashMap<String, Descriptors.Descriptor>();

        private Builder() {
        }

        public final Builder add(Descriptors.Descriptor messageType) {
            if (this.types == null) {
                throw new IllegalStateException("A TypeRegistry.Builder can only be used once.");
            }
            this.addFile(messageType.getFile());
            return this;
        }

        public final Builder add(Iterable<Descriptors.Descriptor> messageTypes) {
            if (this.types == null) {
                throw new IllegalStateException("A TypeRegistry.Builder can only be used once.");
            }
            for (Descriptors.Descriptor descriptor : messageTypes) {
                this.addFile(descriptor.getFile());
            }
            return this;
        }

        public final TypeRegistry build() {
            TypeRegistry typeRegistry = new TypeRegistry(this.types);
            this.types = null;
            return typeRegistry;
        }

        private void addFile(Descriptors.FileDescriptor file) {
            if (!this.files.add(file.getFullName())) {
                return;
            }
            for (Descriptors.FileDescriptor genericDescriptor : file.getDependencies()) {
                this.addFile(genericDescriptor);
            }
            for (Descriptors.Descriptor descriptor : file.getMessageTypes()) {
                this.addMessage(descriptor);
            }
        }

        private void addMessage(Descriptors.Descriptor message) {
            for (Descriptors.Descriptor descriptor : message.getNestedTypes()) {
                this.addMessage(descriptor);
            }
            if (this.types.containsKey(message.getFullName())) {
                logger.warning("Type " + message.getFullName() + " is added multiple times.");
                return;
            }
            this.types.put(message.getFullName(), message);
        }
    }

    private static class EmptyTypeRegistryHolder {
        private static final TypeRegistry EMPTY = new TypeRegistry(Collections.emptyMap());

        private EmptyTypeRegistryHolder() {
        }
    }
}

