/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.AbstractProtobufList;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class LongArrayList
extends AbstractProtobufList<Long>
implements Internal.LongList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final LongArrayList EMPTY_LIST = new LongArrayList(new long[0], 0);
    private long[] array;
    private int size;

    public static LongArrayList emptyList() {
        return EMPTY_LIST;
    }

    LongArrayList() {
        this(new long[10], 0);
    }

    private LongArrayList(long[] other, int size) {
        this.array = other;
        this.size = size;
    }

    @Override
    protected final void removeRange(int fromIndex, int toIndex) {
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= toIndex - fromIndex;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LongArrayList)) {
            return super.equals(o2);
        }
        LongArrayList longArrayList = (LongArrayList)o2;
        if (this.size != longArrayList.size) {
            return false;
        }
        long[] lArray = longArrayList.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.array[i2] == lArray[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            n2 = n2 * 31 + Internal.hashLong(this.array[i2]);
        }
        return n2;
    }

    @Override
    public final Internal.LongList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new LongArrayList(Arrays.copyOf(this.array, capacity), this.size);
    }

    @Override
    public final Long get(int index) {
        return this.getLong(index);
    }

    @Override
    public final long getLong(int index) {
        this.ensureIndexInRange(index);
        return this.array[index];
    }

    @Override
    public final int indexOf(Object element) {
        if (!(element instanceof Long)) {
            return -1;
        }
        long l2 = (Long)element;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.array[i2] != l2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Long set(int index, Long element) {
        return this.setLong(index, element);
    }

    @Override
    public final long setLong(int index, long element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        long l2 = this.array[index];
        this.array[index] = element;
        return l2;
    }

    @Override
    public final boolean add(Long element) {
        this.addLong(element);
        return true;
    }

    @Override
    public final void add(int index, Long element) {
        this.addLong(index, element);
    }

    @Override
    public final void addLong(long element) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n2 = this.size * 3 / 2 + 1;
            long[] lArray = new long[n2];
            System.arraycopy(this.array, 0, lArray, 0, this.size);
            this.array = lArray;
        }
        this.array[this.size++] = element;
    }

    private void addLong(int index, long element) {
        this.ensureIsMutable();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        } else {
            int n2 = this.size * 3 / 2 + 1;
            long[] lArray = new long[n2];
            System.arraycopy(this.array, 0, lArray, 0, index);
            System.arraycopy(this.array, index, lArray, index + 1, this.size - index);
            this.array = lArray;
        }
        this.array[index] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof LongArrayList)) {
            return super.addAll(collection);
        }
        LongArrayList longArrayList = (LongArrayList)collection;
        if (longArrayList.size == 0) {
            return false;
        }
        int n2 = Integer.MAX_VALUE - this.size;
        if (n2 < longArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n3 = this.size + longArrayList.size;
        if (n3 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n3);
        }
        System.arraycopy(longArrayList.array, 0, this.array, this.size, longArrayList.size);
        this.size = n3;
        ++this.modCount;
        return true;
    }

    @Override
    public final Long remove(int index) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        long l2 = this.array[index];
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        ++this.modCount;
        return l2;
    }

    private void ensureIndexInRange(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index) {
        return "Index:" + index + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

