/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.AbstractProtobufList;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class BooleanArrayList
extends AbstractProtobufList<Boolean>
implements Internal.BooleanList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final BooleanArrayList EMPTY_LIST = new BooleanArrayList(new boolean[0], 0);
    private boolean[] array;
    private int size;

    public static BooleanArrayList emptyList() {
        return EMPTY_LIST;
    }

    BooleanArrayList() {
        this(new boolean[10], 0);
    }

    private BooleanArrayList(boolean[] other, int size) {
        this.array = other;
        this.size = size;
    }

    @Override
    protected final void removeRange(int fromIndex, int toIndex) {
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= toIndex - fromIndex;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof BooleanArrayList)) {
            return super.equals(o2);
        }
        BooleanArrayList booleanArrayList = (BooleanArrayList)o2;
        if (this.size != booleanArrayList.size) {
            return false;
        }
        boolean[] blArray = booleanArrayList.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.array[i2] == blArray[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            n2 = n2 * 31 + Internal.hashBoolean(this.array[i2]);
        }
        return n2;
    }

    @Override
    public final Internal.BooleanList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new BooleanArrayList(Arrays.copyOf(this.array, capacity), this.size);
    }

    @Override
    public final Boolean get(int index) {
        return this.getBoolean(index);
    }

    @Override
    public final boolean getBoolean(int index) {
        this.ensureIndexInRange(index);
        return this.array[index];
    }

    @Override
    public final int indexOf(Object element) {
        if (!(element instanceof Boolean)) {
            return -1;
        }
        boolean bl = (Boolean)element;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.array[i2] != bl) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Boolean set(int index, Boolean element) {
        return this.setBoolean(index, element);
    }

    @Override
    public final boolean setBoolean(int index, boolean element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        boolean bl = this.array[index];
        this.array[index] = element;
        return bl;
    }

    @Override
    public final boolean add(Boolean element) {
        this.addBoolean(element);
        return true;
    }

    @Override
    public final void add(int index, Boolean element) {
        this.addBoolean(index, element);
    }

    @Override
    public final void addBoolean(boolean element) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n2 = this.size * 3 / 2 + 1;
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.array, 0, blArray, 0, this.size);
            this.array = blArray;
        }
        this.array[this.size++] = element;
    }

    private void addBoolean(int index, boolean element) {
        this.ensureIsMutable();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        } else {
            int n2 = this.size * 3 / 2 + 1;
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.array, 0, blArray, 0, index);
            System.arraycopy(this.array, index, blArray, index + 1, this.size - index);
            this.array = blArray;
        }
        this.array[index] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof BooleanArrayList)) {
            return super.addAll(collection);
        }
        BooleanArrayList booleanArrayList = (BooleanArrayList)collection;
        if (booleanArrayList.size == 0) {
            return false;
        }
        int n2 = Integer.MAX_VALUE - this.size;
        if (n2 < booleanArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n3 = this.size + booleanArrayList.size;
        if (n3 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n3);
        }
        System.arraycopy(booleanArrayList.array, 0, this.array, this.size, booleanArrayList.size);
        this.size = n3;
        ++this.modCount;
        return true;
    }

    @Override
    public final Boolean remove(int index) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        boolean bl = this.array[index];
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        ++this.modCount;
        return bl;
    }

    private void ensureIndexInRange(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index) {
        return "Index:" + index + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

