### AWS Glacier Rsync Like Utility
Rsync like utility to backup files and folders to AWS Glacier.
Utility can compress files and store on glacier. Archive ids will be stored in an sqlite database.

You have to log in to aws with aws cli and create a glacier vault beforehand.

Run params:
```shell
$ grsync --help
usage: __main__.py [-h] [--loglevel {CRITICAL,ERROR,WARNING,INFO,DEBUG,NOTSET}] [--db db] --vault vault --region region [--compress COMPRESS] [--partsize PARTSIZE] [--desc desc] src

Rsync like glacier backup util

positional arguments:
  src                   file or folder to generate archive from

optional arguments:
  -h, --help            show this help message and exit
  --loglevel {CRITICAL,ERROR,WARNING,INFO,DEBUG,NOTSET}
                        log level
  --db db               database file to store sync info
  --vault vault         Glacier vault name
  --region region       Glacier region name
  --compress COMPRESS   Enable compression. Only zstd is supported
  --partsize PARTSIZE   Part size for compression
  --desc desc           A description for the archive that will be stored in Amazon Glacer
```

If compression is enabled, file will be read and compressed on the fly and uploaded to glacier multipart.

Sqlite database scheme:
```sqlite
CREATE TABLE 
    sync_history
(	id integer primary key, 
	path text,		/* full path of the backed up file */
	file_size integer,	/* size of the file */
	mtime float,		/* modification time */
	archive_id text,	/* archive id generated by glacier */
	location text,		/* archive url generated by glacier */
	checksum text,		/* checksum of the archive generaged by glacier*/
	compression text,	/* compression algorithm used. NULL if none */
	timestamp text		/* backup timestamp */
);
```

### Do not lose your database