# Generated by Django 3.1.8 on 2021-04-15 06:46

from django.db import migrations, models
import django.db.models.deletion


def initialize_new_satellite_fields(apps, schema_editor):
    Satellite = apps.get_model('base', 'Satellite')
    DemodData = apps.get_model('base', 'DemodData')
    ExportedFrameset = apps.get_model('base', 'ExportedFrameset')
    LatestTleSet = apps.get_model('base', 'LatestTleSet')
    Telemetry = apps.get_model('base', 'Telemetry')
    Tle = apps.get_model('base', 'Tle')
    TransmitterEntry = apps.get_model('base', 'TransmitterEntry')
    for new_satellite in Satellite.objects.all():
        DemodData.objects.filter(satellite=new_satellite.satellite_entry).update(new_satellite=new_satellite)
        ExportedFrameset.objects.filter(satellite=new_satellite.satellite_entry).update(new_satellite=new_satellite)
        LatestTleSet.objects.filter(satellite=new_satellite.satellite_entry).update(new_satellite=new_satellite)
        Telemetry.objects.filter(satellite=new_satellite.satellite_entry).update(new_satellite=new_satellite)
        Tle.objects.filter(satellite=new_satellite.satellite_entry).update(new_satellite=new_satellite)
        TransmitterEntry.objects.filter(satellite=new_satellite.satellite_entry).update(new_satellite=new_satellite)


def reverse_initialize_new_satellite_fields(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0040_update_and_create_satellite_models'),
    ]

    operations = [
        migrations.AddField(
            model_name='demoddata',
            name='new_satellite',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='base.satellite'),
        ),
        migrations.AddField(
            model_name='exportedframeset',
            name='new_satellite',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='base.satellite'),
        ),
        migrations.AddField(
            model_name='latesttleset',
            name='new_satellite',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to='base.satellite'),
        ),
        migrations.AddField(
            model_name='telemetry',
            name='new_satellite',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='base.satellite'),
        ),
        migrations.AddField(
            model_name='tle',
            name='new_satellite',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='base.satellite'),
        ),
        migrations.AddField(
            model_name='transmitterentry',
            name='new_satellite',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='base.satellite'),
        ),
        migrations.RunPython(initialize_new_satellite_fields, reverse_initialize_new_satellite_fields),
    ]
