/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.rulefit;

import hex.genmodel.algos.rulefit.MojoRule;
import java.io.Serializable;
import java.util.Arrays;

public class MojoRuleEnsemble
implements Serializable {
    MojoRule[][][] _orderedRules;

    public MojoRuleEnsemble(MojoRule[][][] orderedRules) {
        this._orderedRules = orderedRules;
    }

    public double[] transformRow(double[] row, int depth, int ntrees, String[] linearModelNames, String[][] linearModelDomains) {
        double[] transformedRow = new double[depth * ntrees];
        for (int i2 = 0; i2 < depth; ++i2) {
            for (int j2 = 0; j2 < ntrees; ++j2) {
                MojoRule[] filteredOrderedRules = this._orderedRules[i2][j2];
                transformedRow[i2 * ntrees + j2] = MojoRuleEnsemble.decode(MojoRuleEnsemble.transform(row, this._orderedRules[i2][j2]), filteredOrderedRules, linearModelNames, linearModelDomains);
            }
        }
        return transformedRow;
    }

    static double decode(double[] cs, MojoRule[] rules, String[] linearModelNames, String[][] linearModelDomains) {
        int newValue = -1;
        for (int iCol = 0; iCol < cs.length; ++iCol) {
            if (cs[iCol] != 1.0) continue;
            newValue = MojoRuleEnsemble.getValueByVarName(rules[iCol]._varName, linearModelNames, linearModelDomains);
        }
        if (newValue >= 0) {
            return newValue;
        }
        return Double.NaN;
    }

    static int getValueByVarName(String varname, String[] linearModelNames, String[][] linearModelDomains) {
        int i2 = Arrays.asList(linearModelNames).indexOf(varname.substring(0, varname.indexOf(78)));
        return Arrays.asList(linearModelDomains[i2]).indexOf(varname);
    }

    static double[] transform(double[] row, MojoRule[] rules) {
        double[] transformedRow = new double[rules.length];
        byte[] out = new byte[]{1};
        for (int i2 = 0; i2 < rules.length; ++i2) {
            out[0] = 1;
            rules[i2].map(row, out);
            transformedRow[i2] = out[0];
        }
        return transformedRow;
    }
}

