/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.UnsafeUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

final class ByteBufferWriter {
    private static final int MIN_CACHED_BUFFER_SIZE = 1024;
    private static final int MAX_CACHED_BUFFER_SIZE = 16384;
    private static final float BUFFER_REALLOCATION_THRESHOLD = 0.5f;
    private static final ThreadLocal<SoftReference<byte[]>> BUFFER = new ThreadLocal();
    private static final Class<?> FILE_OUTPUT_STREAM_CLASS = ByteBufferWriter.safeGetClass("java.io.FileOutputStream");
    private static final long CHANNEL_FIELD_OFFSET = ByteBufferWriter.getChannelFieldOffset(FILE_OUTPUT_STREAM_CLASS);

    private ByteBufferWriter() {
    }

    static void clearCachedBuffer() {
        BUFFER.set(null);
    }

    static void write(ByteBuffer buffer, OutputStream output) throws IOException {
        int n2 = buffer.position();
        try {
            if (buffer.hasArray()) {
                output.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            } else if (!ByteBufferWriter.writeToChannel(buffer, output)) {
                byte[] byArray = ByteBufferWriter.getOrCreateBuffer(buffer.remaining());
                while (buffer.hasRemaining()) {
                    int n3 = Math.min(buffer.remaining(), byArray.length);
                    buffer.get(byArray, 0, n3);
                    output.write(byArray, 0, n3);
                }
            }
            return;
        }
        finally {
            buffer.position(n2);
        }
    }

    private static byte[] getOrCreateBuffer(int requestedSize) {
        requestedSize = Math.max(requestedSize, 1024);
        byte[] byArray = ByteBufferWriter.getBuffer();
        if (byArray == null || ByteBufferWriter.needToReallocate(requestedSize, byArray.length)) {
            byArray = new byte[requestedSize];
            if (requestedSize <= 16384) {
                ByteBufferWriter.setBuffer(byArray);
            }
        }
        return byArray;
    }

    private static boolean needToReallocate(int requestedSize, int bufferLength) {
        return bufferLength < requestedSize && (float)bufferLength < (float)requestedSize * 0.5f;
    }

    private static byte[] getBuffer() {
        SoftReference<byte[]> softReference = BUFFER.get();
        if (softReference == null) {
            return null;
        }
        return softReference.get();
    }

    private static void setBuffer(byte[] value) {
        BUFFER.set(new SoftReference<byte[]>(value));
    }

    private static boolean writeToChannel(ByteBuffer buffer, OutputStream output) throws IOException {
        if (CHANNEL_FIELD_OFFSET >= 0L && FILE_OUTPUT_STREAM_CLASS.isInstance(output)) {
            WritableByteChannel writableByteChannel = null;
            try {
                writableByteChannel = (WritableByteChannel)UnsafeUtil.getObject(output, CHANNEL_FIELD_OFFSET);
            }
            catch (ClassCastException classCastException) {}
            if (writableByteChannel != null) {
                writableByteChannel.write(buffer);
                return true;
            }
        }
        return false;
    }

    private static Class<?> safeGetClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static long getChannelFieldOffset(Class<?> clazz) {
        try {
            if (clazz != null && UnsafeUtil.hasUnsafeArrayOperations()) {
                Field field = clazz.getDeclaredField("channel");
                return UnsafeUtil.objectFieldOffset(field);
            }
        }
        catch (Throwable throwable) {}
        return -1L;
    }
}

