from setuptools import setup, find_packages

setup(
    name='kelectric',
    version='0.1.24rc5',
    url='https://kelectric.readthedocs.io/',
    project_urls={
        'Documentation': 'https://kelectric.readthedocs.io/',
        'Source': 'https://github.com/jacometoss/kelectrc',
        'Funding': 'https://ko-fi.com/jacometoss',
        'Forum': 'https://k-denveloper.blogspot.com/',
        'Bug Tracker': 'https://github.com/jacometoss/kelectric/issues',
    },    
    license='GPL-3.0',
    author='Marco Polo Jacome Toss',
    author_email='jacometoss@outlook.com',
    description='Module for dimensioning copper electrical conductors, feeder conductor and branch circuits ',
    long_description=''.join(open('README.md', encoding='utf-8').readlines()),
    long_description_content_type='text/markdown',
    keywords=['electrical', 'conductor', 'size', 'kelectric'],
    packages=find_packages(include=["kelectric"]),
    include_package_data=True,
    install_requires=['tabulate','numpy','matplotlib'],
    python_requires='>=3.5',
    classifiers=[
        'License :: OSI Approved :: GNU Affero General Public License v3',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Scientific/Engineering :: Physics',
        'Topic :: Scientific/Engineering :: Mathematics',
        'Topic :: Utilities ',
        'Operating System :: Microsoft :: Windows',
        'Operating System :: POSIX :: Linux',
    ],
)

