# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdkarms.endpoint import endpoint_data

class CreateAlertTemplateRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'ARMS', '2019-08-08', 'CreateAlertTemplate','arms')
		self.set_method('POST')
		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())


	def get_TemplateProvider(self):
		return self.get_query_params().get('TemplateProvider')

	def set_TemplateProvider(self,TemplateProvider):
		self.add_query_param('TemplateProvider',TemplateProvider)

	def get_Annotations(self):
		return self.get_query_params().get('Annotations')

	def set_Annotations(self,Annotations):
		self.add_query_param('Annotations',Annotations)

	def get_Rule(self):
		return self.get_query_params().get('Rule')

	def set_Rule(self,Rule):
		self.add_query_param('Rule',Rule)

	def get_Type(self):
		return self.get_query_params().get('Type')

	def set_Type(self,Type):
		self.add_query_param('Type',Type)

	def get_Message(self):
		return self.get_query_params().get('Message')

	def set_Message(self,Message):
		self.add_query_param('Message',Message)

	def get_ParentId(self):
		return self.get_query_params().get('ParentId')

	def set_ParentId(self,ParentId):
		self.add_query_param('ParentId',ParentId)

	def get_Labels(self):
		return self.get_query_params().get('Labels')

	def set_Labels(self,Labels):
		self.add_query_param('Labels',Labels)

	def get_Name(self):
		return self.get_query_params().get('Name')

	def set_Name(self,Name):
		self.add_query_param('Name',Name)

	def get_MatchExpressions(self):
		return self.get_query_params().get('MatchExpressions')

	def set_MatchExpressions(self,MatchExpressions):
		self.add_query_param('MatchExpressions',MatchExpressions)