import { IEventSourceMapping } from './event-source-mapping';
import { IFunction } from './function-base';
/**
 * A destination configuration.
 *
 * @stability stable
 */
export interface DlqDestinationConfig {
    /**
     * The Amazon Resource Name (ARN) of the destination resource.
     *
     * @stability stable
     */
    readonly destination: string;
}
/**
 * A DLQ for an event source.
 *
 * @stability stable
 */
export interface IEventSourceDlq {
    /**
     * Returns the DLQ destination config of the DLQ.
     *
     * @stability stable
     */
    bind(target: IEventSourceMapping, targetHandler: IFunction): DlqDestinationConfig;
}
