import setuptools

setuptools.setup(
    name='helper',
    version='2.5.0',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Environment :: MacOS X',
        'Environment :: No Input/Output (Daemon)',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Natural Language :: English',
        'Operating System :: MacOS',
        'Operating System :: POSIX',
        'Operating System :: POSIX :: BSD',
        'Operating System :: POSIX :: Linux',
        'Operating System :: Unix',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.2',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy',
        'Topic :: Software Development :: Libraries',
        'Topic :: Software Development :: Libraries :: Python Modules'],
    description='Development library for quickly writing configurable '
                'applications and daemons',
    license=open('LICENSE').read(),
    author='Gavin M. Roy',
    author_email='gavinmroy@gmail.com',
    url='https://helper.readthedocs.io',
    packages=['helper'],
    package_data={'': ['LICENSE', 'README.rst']},
    install_requires=['pyyaml'],
    include_package_data=True,
    extras_require={
        'testing': ['flake8', 'mock']
    },
    zip_safe=True,
    entry_points={
        'distutils.commands': ['run_helper = helper.setupext:RunCommand'],
    })
