# AUTOGENERATED! DO NOT EDIT! File to edit: 07_download.ipynb (unless otherwise specified).

__all__ = ['logger', 'download_img_id', 'download_and_calibrate']

# Cell
import logging

from pyciss import io, opusapi

try:
    from pyciss import pipeline
except ImportError:
    print("pipeline module not imported.")

logger = logging.getLogger(__name__)

# Cell
def download_img_id(img_id):
    "Download one specific `img_id`, e.g. 'N1875229393'."
    logger.debug("Downloading file id %s", img_id)
    opus = opusapi.OPUS()
    opus.query_image_id(img_id)
    basepath = opus.download_results()
    print("Downloaded images into {}".format(basepath))

# Cell
def download_and_calibrate(img_id=None, overwrite=False, recalibrate=False, **kwargs):
    """Download and calibrate one or more image ids, in parallel.

    Parameters
    ----------
    img_id : str or io.PathManager, optional
        If more than one item is in img_id, a parallel process is started
    overwrite: bool, optional
        If the pm.cubepath exists, this switch controls if it is being overwritten.
        Default: False
    """
    if isinstance(img_id, io.PathManager):
        pm = img_id
    else:
        # get a PathManager object that knows where your data is or should be
        logger.debug("Creating Pathmanager object")
        pm = io.PathManager(img_id)

    if not pm.raw_image.exists() or overwrite is True:
        logger.debug("Downloading file %s" % pm.img_id)
        download_img_id(pm.img_id)
        pm = io.PathManager(img_id)  # refresh, to get proper PDS version id.
    else:
        logger.info("Found ")

    if not (pm.cubepath.exists() and pm.undestriped.exists()) or overwrite is True:
        calib = pipeline.Calibrator(img_id, **kwargs)
        calib.standard_calib()
    else:
        print("All files exist. Use overwrite=True to redownload and calibrate.")