/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.util.DatePeriod;
import com.sas.util.NumberUtil;
import com.sas.util.transforms.TransformInputOutputInterface;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

@SASScope(value="ALL")
public class ObjectToStringTransform
implements TransformInputOutputInterface {
    static final long serialVersionUID = -7670709939329023996L;
    protected Locale locale;
    protected DateFormat dateFormatter;
    protected String nullString = "null";
    protected String dotString = ".";
    public static final ObjectToStringTransform defaultInstance = new ObjectToStringTransform();

    public ObjectToStringTransform() {
        this(Locale.getDefault());
    }

    public ObjectToStringTransform(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Object transform(Object input) {
        if (input != null) {
            if (input instanceof Double) {
                return NumberUtil.toString((Double)input, this.locale);
            }
            if (input instanceof Float) {
                return NumberUtil.toString(((Float)input).floatValue(), this.locale);
            }
            if (input instanceof DatePeriod) {
                return ((DatePeriod)input).toDisplayString(this.dateFormatter, this.locale);
            }
            if (input instanceof Date) {
                DateFormat formatter = this.dateFormatter;
                if (formatter == null) {
                    formatter = input instanceof Time ? DateFormat.getTimeInstance(2, this.locale) : (input instanceof java.sql.Date ? DateFormat.getDateInstance(2, this.locale) : DateFormat.getDateTimeInstance(2, 2, this.locale));
                }
                return formatter.format((Date)input);
            }
            if (input instanceof MissingValues) {
                if (MissingValues.Dot.equals(input)) {
                    return this.dotString;
                }
                if (MissingValues._BLANK_.equals(input)) {
                    return " ";
                }
            }
            return input.toString();
        }
        return this.nullString;
    }

    @Override
    public Class getInputClass() {
        return Object.class;
    }

    @Override
    public Class getOutputClass() {
        return String.class;
    }

    public DateFormat getDateFormatter() {
        return this.dateFormatter;
    }

    public String getDotString() {
        return this.dotString;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setDateFormatter(DateFormat dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public void setDotString(String dotString) {
        this.dotString = dotString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    @SASScope
    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

