/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DoubleType;
import com.sas.util.transforms.DataTypeToDisplayStringTransform;
import java.util.Locale;

@SASScope
public class DoubleTypeToDisplayStringTransform
extends DataTypeToDisplayStringTransform {
    protected int minDecimalPlaces;

    public DoubleTypeToDisplayStringTransform(DoubleType dataType, Locale locale, int minDecimalPlaces) {
        super(dataType, locale);
        this.minDecimalPlaces = minDecimalPlaces;
    }

    @Override
    public Object transform(Object input) {
        DoubleType dt = (DoubleType)this.dataType;
        if (input == null) {
            return "";
        }
        try {
            return dt.getDisplayString(dt.coerceValue(input, this.locale), this.locale, this.minDecimalPlaces);
        }
        catch (Exception e) {
            return input;
        }
    }
}

