/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.util.Locale;

@SASScope
public class DataTypeToDisplayStringTransform
implements TransformInterface {
    protected DataTypeInterface dataType;
    protected Locale locale;

    public DataTypeToDisplayStringTransform(DataTypeInterface dataType, Locale locale) {
        this.dataType = dataType;
        this.locale = locale;
    }

    @Override
    public Object transform(Object input) throws TransformException {
        try {
            return this.dataType.getDisplayString(this.dataType.coerceValue(input, this.locale), this.locale);
        }
        catch (IllegalArgumentException ex) {
            TransformException e = new TransformException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            this.locale = locale;
        }
    }
}

