/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.util.transforms.TransformInputOutputInterface;

public class BooleanToCharacterTransform
implements TransformInputOutputInterface {
    static final long serialVersionUID = 256899152294673648L;
    public static final BooleanToCharacterTransform defaultInstance = new BooleanToCharacterTransform();
    public char trueChar;
    public char falseChar;

    public BooleanToCharacterTransform() {
        this('T', 'F');
    }

    public BooleanToCharacterTransform(char trueChar, char falseChar) {
        this.trueChar = trueChar;
        this.falseChar = falseChar;
    }

    @Override
    public Object transform(Object value) {
        Boolean bool = (Boolean)value;
        if (bool.booleanValue()) {
            return new Character(this.trueChar);
        }
        return new Character(this.falseChar);
    }

    @Override
    public Class getInputClass() {
        return Boolean.class;
    }

    @Override
    public Class getOutputClass() {
        return Character.class;
    }
}

