/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.util.RB;
import com.sas.util.RangeSegment;
import java.text.Format;

public class NumericRangeSegment
extends RangeSegment {
    public static final String RB_KEY = "NumericRangeSegment.";
    private double min;
    private double max;

    public NumericRangeSegment() {
        this(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false, true, null);
    }

    public NumericRangeSegment(double min, double max) {
        this(min, max, false, true, null);
    }

    public NumericRangeSegment(double min, double max, Object value) {
        this(min, max, false, true, value);
    }

    public NumericRangeSegment(double min, double max, boolean minExcl, boolean maxExcl, Object value) {
        this.min = min;
        this.max = max;
        this.setValue(value);
        this.setMinExclude(minExcl);
        this.setMaxExclude(maxExcl);
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public int inRange(Object value) {
        if (value != null) {
            if (value instanceof Double) {
                return this.inRange((Double)value);
            }
            throw new RuntimeException(RB.getStringResource(RB_KEY, "invalidInputType.txt"));
        }
        return -2;
    }

    public int inRange(double value) {
        int result = 0;
        if (Double.isNaN(value)) {
            result = -2;
        } else if (value < this.min || this.minExclude && value == this.min) {
            result = -1;
        } else if (value > this.max || this.maxExclude && value == this.max) {
            result = 1;
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.min) + (this.minExclude ? "<" : "") + "-" + (this.maxExclude ? "<" : "") + String.valueOf(this.max);
    }

    public String toString(Format format) {
        return format.format(new Double(this.min)) + (this.minExclude ? "<" : "") + "-" + (this.maxExclude ? "<" : "") + format.format(new Double(this.max));
    }
}

