/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.util.AttributeDescriptor;
import com.sas.util.AttributeGroup;
import com.sas.util.Strings;
import java.util.List;

@SASScope
public abstract class AttributeUtil {
    public static AttributeGroup getAttributeGroup(String label, List attributes, boolean createIfNeeded) {
        AttributeGroup group = null;
        if (attributes != null) {
            for (Object attribute : attributes) {
                if (!(attribute instanceof AttributeGroup) || !Strings.equal(((AttributeGroup)attribute).getLabel(), label, false, false)) continue;
                group = (AttributeGroup)attribute;
                break;
            }
        }
        if (group == null && createIfNeeded) {
            group = new AttributeGroup(label);
            if (attributes != null) {
                attributes.add(group);
            }
        }
        return group;
    }

    public static AttributeDescriptor getAttribute(String name, List attributes) {
        for (Object descriptorOrGroup : attributes) {
            AttributeDescriptor possibleDescriptor;
            if (descriptorOrGroup instanceof AttributeDescriptor) {
                String descName = ((AttributeDescriptor)descriptorOrGroup).getName();
                if (descName == null || !descName.equals(name)) continue;
                return (AttributeDescriptor)descriptorOrGroup;
            }
            if (!(descriptorOrGroup instanceof AttributeGroup) || (possibleDescriptor = AttributeUtil.getAttribute(name, ((AttributeGroup)descriptorOrGroup).getAttributeDescriptors())) == null) continue;
            return possibleDescriptor;
        }
        return null;
    }
}

