/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.FormatDescription;
import com.sas.text.InvalidFormatException;
import com.sas.text.TableEntry;

@SASScope
abstract class SASFormatEntry
extends TableEntry {
    protected String baseFormat = null;
    protected boolean d = false;
    protected boolean x = false;

    protected SASFormatEntry(String format, String className) {
        super(format, className);
        this.setMinWidth(Integer.MAX_VALUE);
        this.setMaxWidth(Integer.MIN_VALUE);
        boolean done = false;
        for (int indx = format.length() - 1; indx >= 0 && !done; --indx) {
            char letter = format.charAt(indx);
            if (Character.isLowerCase(letter) && letter != '$') {
                switch (letter) {
                    case 'd': {
                        this.d = true;
                        --indx;
                        break;
                    }
                    case 'x': {
                        this.x = true;
                        break;
                    }
                }
                continue;
            }
            this.baseFormat = format.substring(0, indx + 1);
            done = true;
        }
        if (this.baseFormat == null) {
            this.baseFormat = String.valueOf(' ');
        }
    }

    @Override
    public int getMinDValue() {
        if (this.isDecimalWidthSupported()) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getMaxDValue() {
        if (this.isDecimalWidthSupported()) {
            return this.maxWidth - 1;
        }
        return -1;
    }

    @Override
    public boolean isDecimalWidthSupported() {
        return this.d;
    }

    public abstract String getPattern(String var1) throws InvalidFormatException;

    public abstract String getPattern(String var1, int var2) throws InvalidFormatException;

    public abstract void addPattern(int var1, int var2, String var3);

    public abstract void addPattern(int var1, int var2, String var3, boolean var4);

    abstract FormatDescription[] getFormatDescription();

    public abstract void addResourceString(String var1);

    public abstract void addResourceString(int var1, int var2, String var3);

    public abstract void addResourceString(String var1, boolean var2);

    public abstract void addResourceString(int var1, int var2, String var3, boolean var4);

    public abstract void setCurrencyPatterns(String var1, boolean var2);

    public abstract void addResourceString(String var1, int var2, String var3, boolean var4);

    public abstract void addResourceString(String var1, String var2, String var3, boolean var4);

    public abstract void addResourceString(int var1, String var2, String var3, boolean var4);

    public abstract void addResourceString(String var1, int var2, String var3);

    public abstract void addResourceString(String var1, String var2, String var3);

    public abstract void addResourceString(int var1, String var2, String var3);

    public abstract void addResourceString(int var1, int var2, int var3, String[] var4);

    public abstract void addDatetimeResourceString(int var1, int var2, String var3, boolean var4);

    public abstract void addDatetimeResourceString(int var1, String var2, String var3);

    public abstract void addDatetimeResourceString(String var1, int var2, String var3, boolean var4);

    public abstract void addDatetimeResourceString(String var1, String var2, String var3, int var4, boolean var5);

    public abstract void addDatetimeResourceString(int var1, int var2, int var3, String[] var4);

    public abstract void addDatetimeResourceString(int var1, int var2, String[] var3);
}

