/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.PublicClonable;
import com.sas.models.RB;
import java.io.Serializable;

public class LongQueue
implements PublicClonable,
Serializable {
    public static final String RB_KEY = "LongQueue.";
    static final long serialVersionUID = -8085230761683380277L;
    private long[] queue;
    private int size;
    private int in;
    private boolean growable;

    public LongQueue(int maxElements) {
        this(maxElements, false);
    }

    public LongQueue(int maxElements, boolean growable) {
        if (maxElements <= 0) {
            throw new IllegalArgumentException("maxElements <= 0");
        }
        this.queue = new long[maxElements];
        this.size = 0;
        this.in = 0;
        this.growable = growable;
    }

    public void queue(long value) {
        if (this.isArrayFull()) {
            if (this.isGrowable()) {
                this.grow();
            } else {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "queueFull.ex.txt"));
            }
        }
        this.queue[this.in] = value;
        this.in = (this.in + 1) % this.queue.length;
        ++this.size;
    }

    public final void push(long value) {
        this.queue(value);
    }

    private void grow() {
        long[] newQueue = new long[1 + this.queue.length * 3 / 2];
        int i = 0;
        while (!this.isEmpty()) {
            newQueue[i++] = this.dequeue();
        }
        this.queue = newQueue;
        this.in = i;
        this.size = i;
    }

    public long dequeue() {
        long result = this.peek();
        --this.size;
        return result;
    }

    public long pop() {
        if (this.isEmpty()) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "queueEmpty.ex.txt"));
        }
        this.in = (this.in + this.queue.length - 1) % this.queue.length;
        --this.size;
        return this.queue[this.in];
    }

    public long peek() {
        if (this.isEmpty()) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "queueEmpty.ex.txt"));
        }
        int out = (this.in + this.queue.length - this.size) % this.queue.length;
        return this.queue[out];
    }

    public void removeAll() {
        this.size = 0;
        this.in = 0;
    }

    public boolean isFull() {
        return !this.isGrowable() && this.isArrayFull();
    }

    private boolean isArrayFull() {
        return this.size == this.queue.length;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void setGrowable(boolean growable) {
        this.growable = growable;
    }

    public boolean isGrowable() {
        return this.growable;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LongQueue clone = (LongQueue)super.clone();
        clone.queue = new long[this.queue.length];
        System.arraycopy(this.queue, 0, clone.queue, 0, this.queue.length);
        return clone;
    }
}

