/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.codepolicy.SASScope;
import com.sas.models.FontInfoInterface;
import com.sas.util.LocalizableString;
import com.sas.util.Util;
import com.sas.util.ValidateArg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;

@SASScope
public class BaseFontInfo
implements FontInfoInterface,
Serializable {
    private static final long serialVersionUID = 3633592827126030212L;
    private Integer fontSize;
    private transient LocalizableString fontFamily = new LocalizableString();
    private Boolean boldSelected;
    private Boolean italicSelected;
    private Boolean underlineSelected;

    public BaseFontInfo() {
    }

    public BaseFontInfo(String fontInfo, Locale locale) {
        this.parseString(fontInfo, locale);
    }

    public BaseFontInfo(String fontName, int fontSize, Locale locale) {
        this.setFontFamily(fontName, locale);
        this.setFontSize(fontSize);
    }

    public BaseFontInfo(String fontName, int fontSize, boolean boldSelected, boolean italicSelected, boolean underlineSelected, Locale locale) {
        this.setFontFamily(fontName, locale);
        this.setFontSize(fontSize);
        this.setBoldSelected(boldSelected);
        this.setItalicSelected(italicSelected);
        this.setUnderlineSelected(underlineSelected);
    }

    public void parseString(String fontInfo, Locale locale) {
        if (fontInfo == null) {
            return;
        }
        String fontInfoTrim = fontInfo.trim();
        String[] parts = fontInfoTrim.split(" :: ");
        if (parts.length < 1) {
            throw new IllegalStateException("Invalid fontInfo: " + fontInfo);
        }
        this.setFontFamily(parts[0], locale);
        if (parts.length > 1) {
            try {
                int fontSz = Integer.parseInt(parts[1]);
                this.setFontSize(fontSz);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Invalid fontInfo: " + fontInfo);
            }
        }
        if (parts.length >= 5) {
            this.setBoldSelected(Boolean.parseBoolean(parts[2]));
            this.setItalicSelected(Boolean.parseBoolean(parts[3]));
            this.setUnderlineSelected(Boolean.parseBoolean(parts[4]));
        }
    }

    public void setFontFamily(LocalizableString fontFamily) {
        ValidateArg.notNull(fontFamily, "fontFamily");
        this.fontFamily = fontFamily;
    }

    public void setFontFamily(String fontFamily, Locale locale) {
        ValidateArg.notNull(fontFamily, "fontFamily");
        ValidateArg.notNull(locale, "locale");
        this.fontFamily.setText(fontFamily, locale);
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setBoldSelected(boolean boldSelected) {
        this.boldSelected = boldSelected;
    }

    public void setItalicSelected(boolean italicSelected) {
        this.italicSelected = italicSelected;
    }

    public void setUnderlineSelected(boolean underlineSelected) {
        this.underlineSelected = underlineSelected;
    }

    @Override
    public String getFontFamily(Locale locale) {
        if (this.fontFamily != null) {
            return this.fontFamily.getText(locale);
        }
        return null;
    }

    @Override
    public LocalizableString getFontFamily() {
        if (this.fontFamily != null) {
            try {
                return (LocalizableString)this.fontFamily.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public int getFontSize() {
        if (this.fontSize != null) {
            return this.fontSize;
        }
        return -1;
    }

    @Override
    public boolean isBold() {
        if (this.boldSelected != null) {
            return this.boldSelected;
        }
        return false;
    }

    @Override
    public boolean isItalic() {
        if (this.italicSelected != null) {
            return this.italicSelected;
        }
        return false;
    }

    @Override
    public boolean isUnderline() {
        if (this.underlineSelected != null) {
            return this.underlineSelected;
        }
        return false;
    }

    public boolean equals(Object otherItem) {
        if (otherItem instanceof BaseFontInfo) {
            BaseFontInfo other = (BaseFontInfo)otherItem;
            if (!Util.equal(this.getFontFamily(), other.getFontFamily())) {
                return false;
            }
            if (!Util.equal(this.fontSize, other.fontSize)) {
                return false;
            }
            if (!Util.equal(this.boldSelected, other.boldSelected)) {
                return false;
            }
            if (!Util.equal(this.italicSelected, other.italicSelected)) {
                return false;
            }
            return Util.equal(this.underlineSelected, other.underlineSelected);
        }
        return false;
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        StringBuffer fontInfo = new StringBuffer();
        if (this.fontFamily != null) {
            fontInfo.append(this.getFontFamily(locale));
        }
        if (this.fontSize != null) {
            fontInfo.append(" :: ");
            fontInfo.append(this.getFontSize());
        }
        if (this.boldSelected != null) {
            fontInfo.append(" :: ");
            fontInfo.append(this.boldSelected);
        }
        if (this.italicSelected != null) {
            fontInfo.append(" :: ");
            fontInfo.append(this.italicSelected);
        }
        if (this.underlineSelected != null) {
            fontInfo.append(" :: ");
            fontInfo.append(this.underlineSelected);
        }
        return fontInfo.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.boldSelected);
        out.writeObject(this.italicSelected);
        out.writeObject(this.underlineSelected);
        out.writeObject(this.fontSize);
        String text = null;
        Locale locale = null;
        List<Locale> list = this.fontFamily.getLocales();
        if (!list.isEmpty()) {
            locale = list.get(0);
            text = this.fontFamily.getText(locale);
        }
        out.writeObject(locale);
        out.writeObject(text);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.fontFamily = new LocalizableString();
        in.defaultReadObject();
        this.boldSelected = (Boolean)in.readObject();
        this.italicSelected = (Boolean)in.readObject();
        this.underlineSelected = (Boolean)in.readObject();
        this.fontSize = (Integer)in.readObject();
        Locale locale = (Locale)in.readObject();
        String text = (String)in.readObject();
        if (null != locale && null != text) {
            this.fontFamily.setText(text, locale);
        }
    }
}

