/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.RB;
import com.sas.models.metadataSource.MetadataSource;
import com.sas.models.metadataSource.MetadataSourceImpl;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class MetadataSourceType
extends BaseDataType {
    private static final String RB_KEY = "MetadataSourceType.";
    public static final MetadataSourceType DEFAULT_INSTANCE = new MetadataSourceType();

    @Override
    public Object coerceValue(Object input, Locale inputLocale) throws IllegalArgumentException {
        Object inputValue = input instanceof List && ((List)input).size() == 1 ? ((List)input).get(0) : input;
        if (inputValue == null) {
            return inputValue;
        }
        if (inputValue instanceof MetadataSource) {
            return inputValue;
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String) {
            return new MetadataSourceImpl((String)inputValue);
        }
        if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
            return this.coerceValue(((String[])inputValue)[0], inputLocale);
        }
        throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "dataSourceValueNotValid.ex.txt"), inputValue));
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        return ((MetadataSource)value).getMetadataSourceURL();
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        return this.coerceValue(input, Locale.US);
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        if (value instanceof MetadataSource) {
            return ((MetadataSource)value).getMetadataSourceURL();
        }
        return null;
    }

    @Override
    public int getSQLType() {
        return 2000;
    }

    @Override
    public int getExpressionUsage() {
        return 1111;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        MetadataSource source = (MetadataSource)value;
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (!"".equals(source.getMetadataSourceURL())) {
            map.put(baseMacroVariableName, source.getMetadataSourceURL());
            map.put(baseMacroVariableName + "_type", source.getMetadataType());
        }
        return map;
    }

    @Override
    public Collection getPossibleMacroVariableExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(2);
        extensions.add("");
        extensions.add("_type");
        return extensions;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object retVal = this.coerceValue(value, inputLocale);
        if (retVal != null && retVal instanceof MetadataSource && retVal == value) {
            MetadataSource dsc;
            try {
                dsc = (MetadataSource)((MetadataSource)retVal).clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return dsc;
        }
        return retVal;
    }
}

