/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@SASScope
public class MonitorRecord
extends LogRecord {
    public static final String KEY_TYPE = "TYPE";
    public static final String KEY_FACTORY_NAME = "FACTORY_NAME";
    public static final String KEY_PUDDLE_INDEX = "PUDDLE_INDEX";
    public static final String KEY_CLUSTER_INDEX = "CLUSTER_INDEX";
    public static final String KEY_SERVER_INDEX = "SERVER_INDEX";
    public static final String KEY_SERVER_NAME = "SERVER_NAME";
    public static final String KEY_PORT = "PORT";
    public static final String KEY_CONNECTIONS = "CONNECTIONS";
    public static final String KEY_IDLE = "IDLE";
    public static final String KEY_ACTIVE = "ACTIVE";
    public static final String KEY_CAUSE = "CAUSE";
    public static final String TYPE_SERVER_STATUS = "server_status";
    public static final String CAUSE_REQUEST = "request";
    public static final String CAUSE_RETURN = "return";
    public static final String CAUSE_GC = "garbage_collection";
    public static final String CAUSE_TIMEOUT = "timeout";
    public static final String CAUSE_MIN_AVAIL = "min_avail";
    public static final String CAUSE_MIN_SIZE = "min_size";
    public static final String CAUSE_SHUTDOWN = "shutdown";
    public static final String CAUSE_DESTROY = "destroy";
    public static final String CAUSE_REFRESH = "refresh";
    public static final String CAUSE_NOPERM = "no_permission";
    public static final String CAUSE_BADOPT = "bad_option";
    private static final long serialVersionUID = 3215877166949527102L;
    private Map contents = new HashMap();

    public MonitorRecord() {
        super(Level.FINEST, null);
        this.setType(TYPE_SERVER_STATUS);
        this.setPuddleIndex(-1);
        this.setIdle(0);
    }

    public void setType(String type) {
        this.contents.put(KEY_TYPE, type);
    }

    public void setFactoryName(String factoryName) {
        this.contents.put(KEY_FACTORY_NAME, factoryName);
    }

    public void setPuddleIndex(int puddleIndex) {
        this.contents.put(KEY_PUDDLE_INDEX, Integer.toString(puddleIndex));
    }

    public void setClusterIndex(int clusterIndex) {
        this.contents.put(KEY_CLUSTER_INDEX, Integer.toString(clusterIndex));
    }

    public void setServerIndex(int serverIndex) {
        this.contents.put(KEY_SERVER_INDEX, Integer.toString(serverIndex));
    }

    public void setServerName(String serverName) {
        this.contents.put(KEY_SERVER_NAME, serverName);
    }

    public void setConnections(int connections) {
        this.contents.put(KEY_CONNECTIONS, Integer.toString(connections));
    }

    public void setIdle(int idle) {
        this.contents.put(KEY_IDLE, Integer.toString(idle));
    }

    public void setActive(int active) {
        this.contents.put(KEY_ACTIVE, Integer.toString(active));
    }

    public void setCause(String cause) {
        this.contents.put(KEY_CAUSE, cause);
    }

    public Map getContents() {
        return this.contents;
    }
}

