/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.ThreadPool;
import com.sas.iom.orb.WorkException;
import com.sas.iom.orb.WorkInterface;
import com.sas.services.connection.ConnectionEnvelope;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryEvent;
import com.sas.services.connection.ConnectionFactoryEventListener;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionImpl;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ConnectionRequest;
import com.sas.services.connection.ConnectionResources;
import com.sas.services.connection.Credential;
import com.sas.services.connection.LoginException;
import com.sas.services.connection.RB;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.TrustedPeerCredential;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.omg.CORBA.NO_IMPLEMENT;

@SASScope
public abstract class ConnectionFactoryKernel
implements ConnectionFactoryAdminInterface {
    protected static final int REACT_CX_CLOSED = 0;
    protected static final int REACT_CX_GC = 1;
    protected static final int REACT_CX_REFRESH = 2;
    protected static final int REACT_CX_NOPERM = 3;
    protected static final int REACT_CX_BADOPT = 4;
    private static long _kernelIDCounter;
    private long _kernelID;
    private long _requestIDCounter;
    private long _connectionIDCounter;
    private ConnectionFactoryRequest _cxfReq;
    private Set _listenerSet = new HashSet();
    private boolean _shutdown;
    private boolean _destroyed;

    protected ConnectionFactoryKernel(ConnectionFactoryRequest cxfReq) {
        this._cxfReq = cxfReq;
        this._kernelID = ConnectionFactoryKernel.assignID();
    }

    @Override
    public synchronized void shutdown() {
        if (this.isShutdown() || this.isDestroyed()) {
            return;
        }
        ConnectionFactoryEvent event = new ConnectionFactoryEvent(0);
        this.shutdownKernel(event);
    }

    @Override
    public final Logger getLogger() {
        ConnectionFactoryManager manager = this.getManager();
        ConnectionFactoryConfiguration cxfConfig = this.getConfig();
        String loggerName = manager.getFactoryLoggerName(cxfConfig);
        Logger logger = Logger.getLogger(loggerName);
        return logger;
    }

    protected ConnectionFactoryRequest getRequest() {
        return this._cxfReq;
    }

    protected ConnectionFactoryManager getManager() {
        ConnectionFactoryManager manager = this._cxfReq.getManager();
        return manager;
    }

    protected ConnectionFactoryConfiguration getConfig() {
        ConnectionFactoryConfiguration cxfConfig = this._cxfReq.getOriginalConfiguration();
        return cxfConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnectionFactoryEventListener(ConnectionFactoryEventListener listener) {
        Set set = this._listenerSet;
        synchronized (set) {
            this._listenerSet.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnectionFactoryEventListener(ConnectionFactoryEventListener listener) {
        Set set = this._listenerSet;
        synchronized (set) {
            this._listenerSet.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastEvent(final ConnectionFactoryEvent event) {
        HashSet listenerSetCopy = null;
        Set set = this._listenerSet;
        synchronized (set) {
            int listenerSetL = this._listenerSet.size();
            if (listenerSetL == 0) {
                return;
            }
            listenerSetCopy = new HashSet(listenerSetL);
            listenerSetCopy.addAll(this._listenerSet);
        }
        if (listenerSetCopy.isEmpty()) {
            return;
        }
        final HashSet listenerSetCopyF = listenerSetCopy;
        WorkInterface r = new WorkInterface(){

            @Override
            public void run() {
                for (ConnectionFactoryEventListener listener : listenerSetCopyF) {
                    ConnectionFactoryKernel.this.invokeListener(listener, event);
                }
            }

            @Override
            public void release() {
            }
        };
        ConnectionFactoryManager manager = this.getManager();
        ConnectionResources cxResources = manager.getConnectionResources();
        ThreadPool pool = cxResources.getThreadPool();
        try {
            pool.executeStandard(r);
        }
        catch (WorkException we) {
            r.run();
        }
    }

    private void invokeListener(ConnectionFactoryEventListener listener, ConnectionFactoryEvent event) {
        block2: {
            try {
                listener.handleConnectionFactoryEvent(event);
            }
            catch (Throwable t) {
                if (!this._cxfReq.isLoggableWARNING()) break block2;
                String msg = "ConnectionFactoryEventListener threw exception handling event";
                this._cxfReq.logWARNING(msg, t);
            }
        }
    }

    protected void shutdownKernel(ConnectionFactoryEvent event) {
        this._shutdown = true;
        ConnectionFactoryManager cxfManager = this.getManager();
        cxfManager.removeKernel(this);
        this.broadcastEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyKernel() {
        this._destroyed = true;
        if (!this._shutdown) {
            ConnectionFactoryManager cxfManager = this.getManager();
            cxfManager.removeKernel(this);
        }
        ConnectionFactoryEvent event = new ConnectionFactoryEvent(1);
        this.broadcastEvent(event);
        Set set = this._listenerSet;
        synchronized (set) {
            this._listenerSet.clear();
        }
        ConnectionFactoryConfiguration cxfConfig = this.getConfig();
        cxfConfig.kernelDestroyed(this);
    }

    protected boolean isShutdown() {
        return this._shutdown;
    }

    protected boolean isDestroyed() {
        return this._destroyed;
    }

    protected void removeUserFromCache(Credential user) {
    }

    protected boolean isSecurityPackageAllowed() {
        return false;
    }

    protected boolean isTrustedPeerAllowed() {
        return false;
    }

    protected String getAuthService() {
        return "Host";
    }

    protected long getKernelID() {
        return this._kernelID;
    }

    protected synchronized long assignRequestID() {
        long requestID = this._requestIDCounter++;
        return requestID;
    }

    protected synchronized long assignConnectionID() {
        long connectionID = this._connectionIDCounter++;
        return connectionID;
    }

    protected final ConnectionInterface getConnection(ConnectionRequest cxReq) throws ConnectionFactoryException {
        Credential cred = cxReq.getCredential();
        if (cred instanceof SecurityPackageCredential) {
            if (!this.isSecurityPackageAllowed()) {
                String msgIndex = "cxf.500.ex.txt";
                String msg = RB.getStringResource(msgIndex);
                throw new LoginException(msg);
            }
        } else if (cred instanceof TrustedPeerCredential && !this.isTrustedPeerAllowed()) {
            String msgIndex = "cxf.501.ex.txt";
            String msg = RB.getStringResource(msgIndex);
            throw new LoginException(msg);
        }
        if (cxReq.isLoggableFINE()) {
            String msg = "connection request: " + cxReq.toString();
            cxReq.logFINE(msg);
        }
        if (cxReq.isTraceable()) {
            String tmsg = "traceback for connection request";
            Throwable tb = new Throwable("This traceback is for information only. It is not an error.");
            cxReq.trace(tmsg, tb);
        }
        ConnectionInterface cx = this.doGetConnection(cxReq);
        if (cxReq.isLoggableFINE() && cx instanceof ConnectionImpl) {
            ConnectionEnvelope cxEnv = ((ConnectionImpl)cx).getHandle();
            String connectionID = cxEnv.getConnectionID();
            String msg = "connection request OK: " + connectionID;
            cxReq.logFINE(msg);
        }
        return cx;
    }

    protected ConnectionInterface doGetConnection(ConnectionRequest cxReq) throws ConnectionFactoryException {
        Credential cred = cxReq.getCredential();
        long waitMilliseconds = cxReq.getWaitMilliseconds();
        ConnectionInterface cx = this.getConnection(cred, waitMilliseconds, null);
        return cx;
    }

    protected ConnectionInterface getConnection(Credential userLogin, long waitMilliseconds, Logger cxLogger) throws ConnectionFactoryException {
        NO_IMPLEMENT no_implement = new NO_IMPLEMENT();
        throw new ConnectionFactoryException(no_implement);
    }

    protected abstract ConnectionFactoryAdminInterface getAdminInterface(Credential var1) throws ConnectionFactoryException;

    protected abstract List getDomains();

    protected abstract void reactivateConnection(ConnectionEnvelope var1, int var2, int var3);

    private static synchronized long assignID() {
        long id = _kernelIDCounter++;
        return id;
    }
}

