/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IDataService;
import com.sas.rio.MVAConnection;
import com.sas.rio.RB;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@SASScope(value="ALL")
public class MVADriver
implements Driver {
    Properties m_driverProperties = null;
    private static final Logger logger = Logger.getLogger(MVADriver.class);
    private static final String className = MVADriver.class.getSimpleName();
    private static final String connectLayout = className + "#connect (driver version is %d.%d)";
    private static final String openErrorLayout = className + "()" + " Invalid Log4J configuration.";
    private static Driver registeredDriver;

    @SASScope
    public MVADriver() throws SQLException {
        try {
            if (MVADriver.isLog4jNotConfigured()) {
                Logger.getLogger((String)"com.sas.rio").setLevel(Level.OFF);
            }
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
            logger.warn((Object)openErrorLayout);
        }
    }

    private static boolean isLog4jNotConfigured() {
        Enumeration appenders = Logger.getRootLogger().getAllAppenders();
        if (appenders.hasMoreElements()) {
            return false;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger c = (Logger)loggers.nextElement();
            if (!c.getAllAppenders().hasMoreElements()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized Connection connect(String url, Properties info) throws SQLException {
        if (url.length() < 17) {
            return null;
        }
        if (!url.regionMatches(0, "jdbc:sasiom://", 0, 14)) {
            return null;
        }
        if (info == null) {
            info = new Properties();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format(connectLayout, this.getMajorVersion(), this.getMinorVersion()));
        }
        MVAConnection conn = new MVAConnection(url, info);
        return conn;
    }

    public synchronized Connection connect(IDataService sasDataService, Properties info) throws SQLException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format(connectLayout, this.getMajorVersion(), this.getMinorVersion()));
        }
        MVAConnection conn = new MVAConnection(sasDataService, info);
        return conn;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url.length() < 17) {
            return false;
        }
        return url.regionMatches(0, "jdbc:sasiom://", 0, 14);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo[] driverPropInfo = new DriverPropertyInfo[17];
        driverPropInfo[0] = new DriverPropertyInfo("userName", "");
        driverPropInfo[0].description = RB.getStringResource("Desc.User_Name.txt");
        driverPropInfo[1] = new DriverPropertyInfo("password", "");
        driverPropInfo[1].description = RB.getStringResource("Desc.Password.txt");
        driverPropInfo[2] = new DriverPropertyInfo("dbms", "SQLVIEW");
        driverPropInfo[2].description = RB.getStringResource("Desc.Dbms.txt");
        driverPropInfo[3] = new DriverPropertyInfo("dbmsOptions", "");
        driverPropInfo[3].description = RB.getStringResource("Desc.Dbms_Options.txt");
        driverPropInfo[4] = new DriverPropertyInfo("remarks", "false");
        driverPropInfo[4].description = RB.getStringResource("Desc.Remarks.txt");
        driverPropInfo[4].choices = new String[]{"true", "false"};
        driverPropInfo[5] = new DriverPropertyInfo("undoPolicyNone", "true");
        driverPropInfo[5].description = RB.getStringResource("Desc.Undo_Policy_None.txt");
        driverPropInfo[5].choices = new String[]{"true", "false"};
        driverPropInfo[6] = new DriverPropertyInfo("librefs", "");
        driverPropInfo[6].description = RB.getStringResource("Desc.Librefs.txt");
        driverPropInfo[7] = new DriverPropertyInfo("encryptionPolicy", "");
        driverPropInfo[7].description = RB.getStringResource("Desc.EncryptionPolicy.txt");
        driverPropInfo[7].choices = new String[]{"none", "optional", "required"};
        driverPropInfo[8] = new DriverPropertyInfo("encryptionContent", "");
        driverPropInfo[8].description = RB.getStringResource("Desc.EncryptionContent.txt");
        driverPropInfo[8].choices = new String[]{"all", "authentication"};
        driverPropInfo[9] = new DriverPropertyInfo("encryptionAlgorithms", "");
        driverPropInfo[9].description = RB.getStringResource("Desc.EncryptionAlgorithms.txt");
        driverPropInfo[10] = new DriverPropertyInfo("applyFormats", "false");
        driverPropInfo[10].description = RB.getStringResource("Desc.Apply_Formats.txt");
        driverPropInfo[10].choices = new String[]{"true", "false"};
        driverPropInfo[11] = new DriverPropertyInfo("sasifyTableNames", "default");
        driverPropInfo[11].description = RB.getStringResource("Desc.SasifyTableNames.txt");
        driverPropInfo[11].choices = new String[]{"default", "v91", "none"};
        driverPropInfo[12] = new DriverPropertyInfo("coerceNumericTypes", "true");
        driverPropInfo[12].description = RB.getStringResource("Desc.CoerceNumericTypes.txt");
        driverPropInfo[12].choices = new String[]{"true", "false"};
        driverPropInfo[13] = new DriverPropertyInfo("user", "");
        driverPropInfo[13].description = RB.getStringResource("Desc.User_Name.txt");
        driverPropInfo[14] = new DriverPropertyInfo("useSspi", "none");
        driverPropInfo[14].description = RB.getStringResource("Desc.UseSSPI.txt");
        driverPropInfo[14].choices = new String[]{"none", "kerberos", "ntlm", "negotiate"};
        driverPropInfo[15] = new DriverPropertyInfo("spn", "");
        driverPropInfo[15].description = RB.getStringResource("Desc.spn.txt");
        driverPropInfo[16] = new DriverPropertyInfo("segmentLength", "256");
        driverPropInfo[16].description = RB.getStringResource("Desc.ChunkSize.txt");
        return driverPropInfo;
    }

    @Override
    public int getMajorVersion() {
        String impVersion = this.getClass().getPackage().getImplementationVersion();
        if (impVersion == null) {
            return 99;
        }
        try {
            StringBuffer majorVersion = new StringBuffer(impVersion.substring(0, impVersion.indexOf(46)));
            majorVersion.delete(majorVersion.length() - 3, majorVersion.length());
            majorVersion.delete(majorVersion.length() - 2, majorVersion.length());
            return Integer.parseInt(majorVersion.toString());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
        catch (StringIndexOutOfBoundsException se) {
            return 0;
        }
    }

    @Override
    public int getMinorVersion() {
        String impVersion = null;
        if (this.getClass().getPackage() != null) {
            impVersion = this.getClass().getPackage().getImplementationVersion();
        }
        if (impVersion == null) {
            return 99;
        }
        try {
            StringBuffer minorVersion = new StringBuffer(impVersion.substring(0, impVersion.indexOf(46)));
            minorVersion.delete(minorVersion.length() - 3, minorVersion.length());
            String minorVersionStr = minorVersion.substring(minorVersion.length() - 2, minorVersion.length());
            return Integer.parseInt(minorVersionStr);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
        catch (StringIndexOutOfBoundsException se) {
            return -1;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static synchronized void deregisterDriver() throws SQLException {
        if (registeredDriver != null) {
            logger.debug((Object)"deregistering driver");
            DriverManager.deregisterDriver(registeredDriver);
            registeredDriver = null;
        }
    }

    static {
        try {
            registeredDriver = (Driver)Class.forName("com.sas.rio.MVADriver").newInstance();
            DriverManager.registerDriver(registeredDriver);
        }
        catch (Exception e) {
        }
        catch (ClassFormatError classFormatError) {
            // empty catch block
        }
    }
}

